/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import org.codehaus.janino.ClassFileIClass;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.DebuggingInformation;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.FilterWarningHandler;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Java;
import org.codehaus.janino.Location;
import org.codehaus.janino.Parser;
import org.codehaus.janino.ResourceFinderIClassLoader;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.WarningHandler;
import org.codehaus.janino.util.Benchmark;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.StringPattern;
import org.codehaus.janino.util.enumerator.EnumeratorFormatException;
import org.codehaus.janino.util.enumerator.EnumeratorSet;
import org.codehaus.janino.util.resource.DirectoryResourceCreator;
import org.codehaus.janino.util.resource.DirectoryResourceFinder;
import org.codehaus.janino.util.resource.FileResource;
import org.codehaus.janino.util.resource.FileResourceCreator;
import org.codehaus.janino.util.resource.JarDirectoriesResourceFinder;
import org.codehaus.janino.util.resource.PathResourceFinder;
import org.codehaus.janino.util.resource.Resource;
import org.codehaus.janino.util.resource.ResourceCreator;
import org.codehaus.janino.util.resource.ResourceFinder;

public class Compiler {
    private static final boolean DEBUG = false;
    private static final String[] USAGE = new String[]{"Usage:", "", "  java " + (class$org$codehaus$janino$Compiler != null ? class$org$codehaus$janino$Compiler : (class$org$codehaus$janino$Compiler = Compiler.class$("org.codehaus.janino.Compiler"))).getName() + " [ <option> ] ... <source-file> ...", "", "Supported <option>s are:", "  -d <output-dir>           Where to save class files", "  -sourcepath <dirlist>     Where to look for other source files", "  -classpath <dirlist>      Where to look for other class files", "  -extdirs <dirlist>        Where to look for other class files", "  -bootclasspath <dirlist>  Where to look for other class files", "  -encoding <encoding>      Encoding of source files, e.g. \"UTF-8\" or \"ISO-8859-1\"", "  -verbose", "  -g                        Generate all debugging info", "  -g:none                   Generate no debugging info", "  -g:{lines,vars,source}    Generate only some debugging info", "  -warn:<pattern-list>      Issue certain warnings; examples:", "    -warn:*                 Enables all warnings", "    -warn:IASF              Only warn against implicit access to static fields", "    -warn:*-IASF            Enables all warnings, except those against implicit", "                            access to static fields", "    -warn:*-IA*+IASF        Enables all warnings, except those against implicit", "                            accesses, but do warn against implicit access to", "                            static fields", "  -rebuild                  Compile all source files, even if the class files", "                            seems up-to-date", "  -help", "", "The default encoding in this environment is \"" + new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding() + "\"."};
    private ResourceFinder classFileFinder;
    public static final ResourceFinder FIND_NEXT_TO_SOURCE_FILE = null;
    private ResourceCreator classFileCreator;
    public static final ResourceCreator CREATE_NEXT_TO_SOURCE_FILE = null;
    private String optionalCharacterEncoding;
    private Benchmark benchmark;
    private EnumeratorSet debuggingInformation;
    private WarningHandler optionalWarningHandler;
    private UnitCompiler.ErrorHandler optionalCompileErrorHandler = null;
    private IClassLoader iClassLoader;
    private final ArrayList parsedCompilationUnits = new ArrayList();
    public static final File NO_DESTINATION_DIRECTORY = null;
    public static final StringPattern[] DEFAULT_WARNING_HANDLE_PATTERNS = StringPattern.PATTERNS_NONE;
    static /* synthetic */ Class class$org$codehaus$janino$Compiler;
    static /* synthetic */ Class class$org$codehaus$janino$DebuggingInformation;

    public Compiler(ResourceFinder resourceFinder, IClassLoader iClassLoader, ResourceFinder resourceFinder2, ResourceCreator resourceCreator, String string, boolean bl, EnumeratorSet enumeratorSet, WarningHandler warningHandler) {
        this.classFileFinder = resourceFinder2;
        this.classFileCreator = resourceCreator;
        this.optionalCharacterEncoding = string;
        this.benchmark = new Benchmark(bl);
        this.debuggingInformation = enumeratorSet;
        this.optionalWarningHandler = warningHandler;
        this.iClassLoader = new CompilerIClassLoader(resourceFinder, iClassLoader);
    }

    public Compiler(File[] fileArray, File[] fileArray2, File[] fileArray3, File[] fileArray4, File file, String string, boolean bl, EnumeratorSet enumeratorSet, StringPattern[] stringPatternArray, boolean bl2) {
        this(new PathResourceFinder(fileArray == null ? fileArray2 : fileArray), Compiler.createJavacLikePathIClassLoader(fileArray4, fileArray3, fileArray2), (ResourceFinder)(bl2 ? ResourceFinder.EMPTY_RESOURCE_FINDER : (file == null ? null : new DirectoryResourceFinder(file))), file == null ? null : new DirectoryResourceCreator(file), string, bl, enumeratorSet, new FilterWarningHandler(stringPatternArray, new SimpleWarningHandler()));
        this.benchmark.report("*** JANINO - an embedded compiler for the Java(TM) programming language");
        this.benchmark.report("*** For more information visit http://janino.codehaus.org");
        this.benchmark.report("Source path", fileArray);
        this.benchmark.report("Class path", fileArray2);
        this.benchmark.report("Ext dirs", fileArray3);
        this.benchmark.report("Boot class path", fileArray4);
        this.benchmark.report("Destination directory", file);
        this.benchmark.report("Character encoding", string);
        this.benchmark.report("Verbose", new Boolean(bl));
        this.benchmark.report("Debugging information", enumeratorSet);
        this.benchmark.report("Warning handle patterns", stringPatternArray);
        this.benchmark.report("Rebuild", new Boolean(bl2));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean compile(File[] fileArray) throws Scanner.ScanException, Parser.ParseException, CompileException, IOException {
        this.benchmark.report("Source files", fileArray);
        Resource[] resourceArray = new Resource[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            resourceArray[n] = new FileResource(fileArray[n]);
            ++n;
        }
        this.compile(resourceArray);
        return true;
    }

    public boolean compile(Resource[] resourceArray) throws Scanner.ScanException, Parser.ParseException, CompileException, IOException {
        UnitCompiler.ErrorHandler errorHandler = this.optionalCompileErrorHandler != null ? this.optionalCompileErrorHandler : new UnitCompiler.ErrorHandler(){
            int compileErrorCount = 0;

            public void handleError(String string, Location location) throws CompileException {
                CompileException compileException = new CompileException(string, location);
                if (++this.compileErrorCount >= 20) {
                    throw compileException;
                }
                System.err.println(compileException.getMessage());
            }
        };
        this.benchmark.beginReporting();
        try {
            this.parsedCompilationUnits.clear();
            int n = 0;
            while (n < resourceArray.length) {
                this.parsedCompilationUnits.add(new UnitCompiler(this.parseCompilationUnit(resourceArray[n].getFileName(), new BufferedInputStream(resourceArray[n].open()), this.optionalCharacterEncoding), this.iClassLoader));
                ++n;
            }
            int n2 = 0;
            while (n2 < this.parsedCompilationUnits.size()) {
                Object var12_9;
                ClassFile[] classFileArray;
                UnitCompiler unitCompiler = (UnitCompiler)this.parsedCompilationUnits.get(n2);
                Java.CompilationUnit compilationUnit = unitCompiler.compilationUnit;
                if (compilationUnit.optionalFileName == null) {
                    throw new RuntimeException();
                }
                File file = new File(compilationUnit.optionalFileName);
                unitCompiler.setCompileErrorHandler(errorHandler);
                unitCompiler.setWarningHandler(this.optionalWarningHandler);
                this.benchmark.beginReporting("Compiling compilation unit \"" + file + "\"");
                try {
                    classFileArray = unitCompiler.compileUnit(this.debuggingInformation);
                }
                finally {
                    var12_9 = null;
                    this.benchmark.endReporting();
                }
                this.benchmark.beginReporting("Storing " + classFileArray.length + " class file(s) resulting from compilation unit \"" + file + "\"");
                try {
                    int n3 = 0;
                    while (n3 < classFileArray.length) {
                        this.storeClassFile(classFileArray[n3], file);
                        ++n3;
                    }
                }
                finally {
                    var12_9 = null;
                    this.benchmark.endReporting();
                }
                ++n2;
            }
        }
        finally {
            Object var4_13 = null;
            this.benchmark.endReporting("Compiled " + this.parsedCompilationUnits.size() + " compilation unit(s)");
        }
        return true;
    }

    private static IClassLoader createJavacLikePathIClassLoader(File[] fileArray, File[] fileArray2, File[] fileArray3) {
        PathResourceFinder pathResourceFinder = new PathResourceFinder(fileArray == null ? PathResourceFinder.parsePath(System.getProperty("sun.boot.class.path")) : fileArray);
        JarDirectoriesResourceFinder jarDirectoriesResourceFinder = new JarDirectoriesResourceFinder(fileArray2 == null ? PathResourceFinder.parsePath(System.getProperty("java.ext.dirs")) : fileArray2);
        PathResourceFinder pathResourceFinder2 = new PathResourceFinder(fileArray3);
        ResourceFinderIClassLoader resourceFinderIClassLoader = new ResourceFinderIClassLoader(pathResourceFinder, null);
        resourceFinderIClassLoader = new ResourceFinderIClassLoader(jarDirectoriesResourceFinder, resourceFinderIClassLoader);
        resourceFinderIClassLoader = new ResourceFinderIClassLoader(pathResourceFinder2, resourceFinderIClassLoader);
        return resourceFinderIClassLoader;
    }

    public static File getClassFile(String string, File file, File file2) {
        if (file2 != null) {
            return new File(file2, ClassFile.getClassFileResourceName(string));
        }
        int n = string.lastIndexOf(46);
        return new File(file.getParentFile(), ClassFile.getClassFileResourceName(string.substring(n + 1)));
    }

    public static void main(String[] stringArray) {
        int n;
        File[] fileArray;
        File file = null;
        File[] fileArray2 = null;
        File[] fileArray3 = new File[]{new File(".")};
        File[] fileArray4 = null;
        File[] fileArray5 = null;
        String string = null;
        boolean bl = false;
        EnumeratorSet enumeratorSet = DebuggingInformation.DEFAULT_DEBUGGING_INFORMATION;
        StringPattern[] stringPatternArray = DEFAULT_WARNING_HANDLE_PATTERNS;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            fileArray = stringArray[n2];
            if (fileArray.charAt(0) != '-') break;
            if (fileArray.equals("-d")) {
                file = new File(stringArray[++n2]);
            } else if (fileArray.equals("-sourcepath")) {
                fileArray2 = PathResourceFinder.parsePath(stringArray[++n2]);
            } else if (fileArray.equals("-classpath")) {
                fileArray3 = PathResourceFinder.parsePath(stringArray[++n2]);
            } else if (fileArray.equals("-extdirs")) {
                fileArray4 = PathResourceFinder.parsePath(stringArray[++n2]);
            } else if (fileArray.equals("-bootclasspath")) {
                fileArray5 = PathResourceFinder.parsePath(stringArray[++n2]);
            } else if (fileArray.equals("-encoding")) {
                string = stringArray[++n2];
            } else if (fileArray.equals("-verbose")) {
                bl = true;
            } else if (fileArray.equals("-g")) {
                enumeratorSet = DebuggingInformation.ALL;
            } else if (fileArray.startsWith("-g:")) {
                try {
                    enumeratorSet = new EnumeratorSet(class$org$codehaus$janino$DebuggingInformation != null ? class$org$codehaus$janino$DebuggingInformation : Compiler.class$("org.codehaus.janino.DebuggingInformation"), fileArray.substring(3));
                }
                catch (EnumeratorFormatException enumeratorFormatException) {
                    System.err.println("Invalid debugging option \"" + (String)fileArray + "\", only \"" + DebuggingInformation.ALL + "\" allowed");
                    System.exit(1);
                }
            } else if (fileArray.startsWith("-warn:")) {
                stringPatternArray = StringPattern.parseCombinedPattern(fileArray.substring(6));
            } else if (fileArray.equals("-rebuild")) {
                bl2 = true;
            } else if (fileArray.equals("-help")) {
                n = 0;
                while (n < USAGE.length) {
                    System.out.println(USAGE[n]);
                    ++n;
                }
                System.exit(1);
            } else {
                System.err.println("Unrecognized command line option \"" + (String)fileArray + "\"; try \"-help\".");
                System.exit(1);
            }
            ++n2;
        }
        if (n2 == stringArray.length) {
            System.err.println("No source files given on command line; try \"-help\".");
            System.exit(1);
        }
        fileArray = new File[stringArray.length - n2];
        n = n2;
        while (n < stringArray.length) {
            fileArray[n - n2] = new File(stringArray[n]);
            ++n;
        }
        Compiler compiler = new Compiler(fileArray2, fileArray3, fileArray4, fileArray5, file, string, bl, enumeratorSet, stringPatternArray, bl2);
        try {
            compiler.compile(fileArray);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Java.CompilationUnit parseCompilationUnit(String string, InputStream inputStream, String string2) throws Scanner.ScanException, Parser.ParseException, IOException {
        Java.CompilationUnit compilationUnit;
        try {
            Scanner scanner = new Scanner(string, inputStream, string2);
            scanner.setWarningHandler(this.optionalWarningHandler);
            Parser parser = new Parser(scanner);
            parser.setWarningHandler(this.optionalWarningHandler);
            this.benchmark.beginReporting("Parsing \"" + string + "\"");
            try {
                compilationUnit = parser.parseCompilationUnit();
                Object var10_7 = null;
                this.benchmark.endReporting();
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                this.benchmark.endReporting();
                throw throwable;
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return compilationUnit;
    }

    public void setCompileErrorHandler(UnitCompiler.ErrorHandler errorHandler) {
        this.optionalCompileErrorHandler = errorHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeClassFile(ClassFile classFile, final File file) throws IOException {
        String string = ClassFile.getClassFileResourceName(classFile.getThisClassName());
        ResourceCreator resourceCreator = this.classFileCreator != null ? this.classFileCreator : new FileResourceCreator(){

            protected File getFile(String string) {
                return new File(file.getParentFile(), string.substring(string.lastIndexOf(47) + 1));
            }
        };
        OutputStream outputStream = resourceCreator.createResource(string);
        try {
            try {
                classFile.store(outputStream);
            }
            catch (IOException iOException) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException2) {}
                outputStream = null;
                if (resourceCreator.deleteResource(string)) throw iOException;
                throw new IOException("Could not delete incompletely written class file \"" + string + "\"");
            }
            Object var7_7 = null;
            if (outputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public static class SimpleWarningHandler
    implements WarningHandler {
        public void handleWarning(String string, String string2, Location location) {
            StringBuffer stringBuffer = new StringBuffer();
            if (location != null) {
                stringBuffer.append(location).append(": ");
            }
            stringBuffer.append("Warning ").append(string).append(": ").append(string2);
            System.err.println(stringBuffer.toString());
        }
    }

    private class CompilerIClassLoader
    extends IClassLoader {
        private final ResourceFinder sourceFinder;

        public CompilerIClassLoader(ResourceFinder resourceFinder, IClassLoader iClassLoader) {
            super(iClassLoader);
            this.sourceFinder = resourceFinder;
            super.postConstruct();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private IClass defineIClassFromClassFileResource(Resource resource) throws ClassNotFoundException {
            Compiler.this.benchmark.beginReporting("Loading class file \"" + resource.getFileName() + "\"");
            try {
                ClassFile classFile;
                block9: {
                    InputStream inputStream = null;
                    try {
                        try {
                            inputStream = resource.open();
                            classFile = new ClassFile(new BufferedInputStream(inputStream));
                        }
                        catch (IOException iOException) {
                            throw new ClassNotFoundException("Opening class file resource \"" + resource + "\"", iOException);
                        }
                        Object var8_5 = null;
                        if (inputStream == null) break block9;
                    }
                    catch (Throwable throwable) {
                        Object var8_6 = null;
                        if (inputStream == null) throw throwable;
                        try {
                            inputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    inputStream.close();
                }
                ClassFileIClass classFileIClass = new ClassFileIClass(classFile, this);
                this.defineIClass(classFileIClass);
                classFileIClass.resolveAllClasses();
                ClassFileIClass classFileIClass2 = classFileIClass;
                Object var4_10 = null;
                Compiler.this.benchmark.endReporting();
                return classFileIClass2;
            }
            catch (Throwable throwable) {
                Object var4_11 = null;
                Compiler.this.benchmark.endReporting();
                throw throwable;
            }
        }

        private IClass defineIClassFromSourceResource(Resource resource, String string) throws ClassNotFoundException {
            UnitCompiler unitCompiler;
            Object object;
            try {
                object = Compiler.this.parseCompilationUnit(resource.getFileName(), new BufferedInputStream(resource.open()), Compiler.this.optionalCharacterEncoding);
                unitCompiler = new UnitCompiler((Java.CompilationUnit)object, Compiler.this.iClassLoader);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException("Parsing compilation unit \"" + resource + "\"", iOException);
            }
            catch (Parser.ParseException parseException) {
                throw new ClassNotFoundException("Parsing compilation unit \"" + resource + "\"", parseException);
            }
            catch (Scanner.ScanException scanException) {
                throw new ClassNotFoundException("Parsing compilation unit \"" + resource + "\"", scanException);
            }
            catch (CompileException compileException) {
                throw new ClassNotFoundException("Parsing compilation unit \"" + resource + "\"", compileException);
            }
            Compiler.this.parsedCompilationUnits.add(unitCompiler);
            object = unitCompiler.findClass(string);
            if (object == null) {
                return null;
            }
            this.defineIClass((IClass)object);
            return object;
        }

        protected IClass findIClass(String string) throws ClassNotFoundException {
            Object object;
            Object object2;
            String string2 = Descriptor.toClassName(string);
            if (string2.startsWith("java.")) {
                return null;
            }
            int n = string2.indexOf(36);
            String string3 = n == -1 ? string2 : string2.substring(0, n);
            int n2 = 0;
            while (n2 < Compiler.this.parsedCompilationUnits.size()) {
                object2 = (UnitCompiler)Compiler.this.parsedCompilationUnits.get(n2);
                object = ((UnitCompiler)object2).findClass(string3);
                if (object != null) {
                    if (!string2.equals(string3) && (object = ((UnitCompiler)object2).findClass(string2)) == null) {
                        return null;
                    }
                    this.defineIClass((IClass)object);
                    return object;
                }
                ++n2;
            }
            object2 = this.sourceFinder.findResource(ClassFile.getSourceResourceName(string2));
            if (object2 == null) {
                return null;
            }
            if (Compiler.this.classFileFinder != null) {
                object = Compiler.this.classFileFinder.findResource(ClassFile.getClassFileResourceName(string2));
            } else {
                if (!(object2 instanceof FileResource)) {
                    return null;
                }
                File file = new File(((FileResource)object2).getFile().getParentFile(), ClassFile.getClassFileResourceName(string2.substring(string2.lastIndexOf(46) + 1)));
                Object object3 = object = file.exists() ? new FileResource(file) : null;
            }
            if (object != null && object2.lastModified() <= object.lastModified()) {
                return this.defineIClassFromClassFileResource((Resource)object);
            }
            return this.defineIClassFromSourceResource((Resource)object2, string2);
        }
    }
}

