# Changelog

## [Unreleased](https://github.com/apache/camel-quarkus/tree/HEAD)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/2.1.0...HEAD)

**Fixed bugs:**

- \[Quarkus 2.2.0\] XChange native itest fails to find `CurrencyNames` resource bundle [\#2983](https://github.com/apache/camel-quarkus/issues/2983)
- \[Quarkus 2.2.0\] Spring RabbitMQ native build fails [\#2980](https://github.com/apache/camel-quarkus/issues/2980)
- \[Quarkus 2.2.0\] `quarkus-google-cloud-services` dependent extensions native image build fails  [\#2979](https://github.com/apache/camel-quarkus/issues/2979)
- \[Quarkus 2.2.0\] Infinispan itests fail in native mode [\#2975](https://github.com/apache/camel-quarkus/issues/2975)
- Camel-Infinispan consumer doesn't work [\#2344](https://github.com/apache/camel-quarkus/issues/2344)

**Closed issues:**

- kamelet: Test the kamelet location option [\#3025](https://github.com/apache/camel-quarkus/issues/3025)
- Salesforce test failure [\#3022](https://github.com/apache/camel-quarkus/issues/3022)
- `property` attribute with `@Consume` does not work [\#3021](https://github.com/apache/camel-quarkus/issues/3021)
- Add test coverage to messaging extesnions [\#3018](https://github.com/apache/camel-quarkus/issues/3018)
- Exception when configuring camel-kafka with environment variables in native mode [\#3017](https://github.com/apache/camel-quarkus/issues/3017)
- `CoreTest.testCamelContextAwareRegistryBeansInitialized` failing after RouteBuilder started implementing CamelContextAware [\#3002](https://github.com/apache/camel-quarkus/issues/3002)
- Reduce console log output from `EipTest.throttle` [\#3001](https://github.com/apache/camel-quarkus/issues/3001)
- creation of extension on windows failed [\#2999](https://github.com/apache/camel-quarkus/issues/2999)
- Upgrade to to GraalVM 21.2 [\#2981](https://github.com/apache/camel-quarkus/issues/2981)
- \[Quarkus 2.2.0\] XmlSecurity itests fail in native mode [\#2977](https://github.com/apache/camel-quarkus/issues/2977)
- Skip querying Jandex for quarkus.camel.native.reflection.include-patterns that have no wildcards [\#2970](https://github.com/apache/camel-quarkus/issues/2970)
- Automatically register for reflection: org.apache.camel.converter.jaxb.mapper.SunJaxb21NamespacePrefixMapper [\#2965](https://github.com/apache/camel-quarkus/issues/2965)
- Multiple gRPC consumers for the same service class does not work [\#2954](https://github.com/apache/camel-quarkus/issues/2954)
- NPE when testing serviceCall EIP [\#2952](https://github.com/apache/camel-quarkus/issues/2952)
- Solr: Investigate, why native tests fail in openjdk 11 \(not in graalvm jdk\) [\#2941](https://github.com/apache/camel-quarkus/issues/2941)
- Provide a common set of JMS tests to test different combinations of JMS extension, client & broker [\#2914](https://github.com/apache/camel-quarkus/issues/2914)
- AWS2 ddb-streams integration tests failures [\#2860](https://github.com/apache/camel-quarkus/issues/2860)
- Make `quarkus.google.cloud.project-id` optional [\#2858](https://github.com/apache/camel-quarkus/issues/2858)
- Cannot convert buffer types in platform-http [\#2838](https://github.com/apache/camel-quarkus/issues/2838)
- Box native integration test failure [\#2830](https://github.com/apache/camel-quarkus/issues/2830)
- Expand ElasticSearch REST test coverage [\#2819](https://github.com/apache/camel-quarkus/issues/2819)
- \[Camel 3.11\] Solr cloud integration tests are failing [\#2814](https://github.com/apache/camel-quarkus/issues/2814)
- Expand AWS DDB tests [\#2776](https://github.com/apache/camel-quarkus/issues/2776)
- Apple M1 cannot build the camel-quarkus project [\#2762](https://github.com/apache/camel-quarkus/issues/2762)
- Add ability to test HL7 extension with multiple HAPI implementations [\#2744](https://github.com/apache/camel-quarkus/issues/2744)
- Quarkus Native: SQS to Mongo fails to compile with NoClassDefFoundError: jnr/unixsocket/UnixSocket [\#2678](https://github.com/apache/camel-quarkus/issues/2678)
- Test EIPs DSL methods [\#2628](https://github.com/apache/camel-quarkus/issues/2628)
- Test sending messages to an SNS FIFO topic [\#2625](https://github.com/apache/camel-quarkus/issues/2625)
- Test creating a subscription of an SQS Queue to an SNS Topic [\#2624](https://github.com/apache/camel-quarkus/issues/2624)
- \[CI\] - Camel Master Branch Build Failure [\#2393](https://github.com/apache/camel-quarkus/issues/2393)
- \[CI\] - Quarkus Master Branch Build Failure [\#2375](https://github.com/apache/camel-quarkus/issues/2375)
- Nightly branch sync issue reporting sometimes does not work [\#2367](https://github.com/apache/camel-quarkus/issues/2367)
- LevelDB:  mapped bytebuffer cleaner update for jdk 9+ needs workaround to work in native mode [\#1908](https://github.com/apache/camel-quarkus/issues/1908)
- \[Serialization\] Jolt: Remove the DeepCopySubstitution when/if graal supports Object serialization [\#1433](https://github.com/apache/camel-quarkus/issues/1433)
- \[camel-master branch\] support ComponentNameResolver [\#892](https://github.com/apache/camel-quarkus/issues/892)
- Language component native support [\#817](https://github.com/apache/camel-quarkus/issues/817)

**Merged pull requests:**

- Fix Splunk container exposed ports configuration [\#3041](https://github.com/apache/camel-quarkus/pull/3041) ([jamesnetherton](https://github.com/jamesnetherton))
- Exclude grpc-netty-shaded in favour of grpc-netty as it is not supported by quarkus-opentelemetry [\#3040](https://github.com/apache/camel-quarkus/pull/3040) ([jamesnetherton](https://github.com/jamesnetherton))
- Remove dummy quarkus.google.cloud.project-id after it was made option… [\#3039](https://github.com/apache/camel-quarkus/pull/3039) ([ppalaga](https://github.com/ppalaga))
- Upgrade Qpid JMS & Quarkiverse Google Cloud Services [\#3038](https://github.com/apache/camel-quarkus/pull/3038) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade Quarkus to 2.2.0.Final [\#3035](https://github.com/apache/camel-quarkus/pull/3035) ([jamesnetherton](https://github.com/jamesnetherton))
- Add ability to test HL7 extension with multiple HAPI implementations [\#3034](https://github.com/apache/camel-quarkus/pull/3034) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#2965 to register SunJaxb21NamespacePrefixMapp for reflection [\#3033](https://github.com/apache/camel-quarkus/pull/3033) ([zhfeng](https://github.com/zhfeng))
- Enable Kubernetes extension native tests on CI [\#3032](https://github.com/apache/camel-quarkus/pull/3032) ([jamesnetherton](https://github.com/jamesnetherton))
- Add additional test coverage to messaging extesnions [\#3031](https://github.com/apache/camel-quarkus/pull/3031) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix failure of SalesforceTest.testGetAccountByQueryHelper [\#3030](https://github.com/apache/camel-quarkus/pull/3030) ([jamesnetherton](https://github.com/jamesnetherton))
- property attribute with @Consume does not work  [\#3029](https://github.com/apache/camel-quarkus/pull/3029) ([ppalaga](https://github.com/ppalaga))
- Test setting the kamelet from an external file provided at runtime \#3025 [\#3026](https://github.com/apache/camel-quarkus/pull/3026) ([aldettinger](https://github.com/aldettinger))
- fix SolrTest failure when using CloundContainer \#2967 [\#3024](https://github.com/apache/camel-quarkus/pull/3024) ([ffang](https://github.com/ffang))
- Test camel-xchange with kraken until binance issues are resolved [\#3020](https://github.com/apache/camel-quarkus/pull/3020) ([jamesnetherton](https://github.com/jamesnetherton))
- CoreTest.testCamelContextAwareRegistryBeansInitialized failing after … [\#3019](https://github.com/apache/camel-quarkus/pull/3019) ([ppalaga](https://github.com/ppalaga))
- Upgrade Quarkus to 2.2.0.CR1 [\#3015](https://github.com/apache/camel-quarkus/pull/3015) ([jamesnetherton](https://github.com/jamesnetherton))
- Ensure ActiveMQ container is fully started before running tests [\#3014](https://github.com/apache/camel-quarkus/pull/3014) ([jamesnetherton](https://github.com/jamesnetherton))
- Reduce console log output from EipTest.throttle [\#3012](https://github.com/apache/camel-quarkus/pull/3012) ([jamesnetherton](https://github.com/jamesnetherton))
- Add dev mode support to camel-quarkus-kotlin [\#3011](https://github.com/apache/camel-quarkus/pull/3011) ([jamesnetherton](https://github.com/jamesnetherton))
- fix extension creation on Windows [\#3008](https://github.com/apache/camel-quarkus/pull/3008) ([dufoli](https://github.com/dufoli))
- Upgrade to cassandra-quarkus 1.1.1 [\#3007](https://github.com/apache/camel-quarkus/pull/3007) ([ppalaga](https://github.com/ppalaga))
- Salesforce: Expand Consumer integration tests : add tests for Streami… [\#3005](https://github.com/apache/camel-quarkus/pull/3005) ([zbendhiba](https://github.com/zbendhiba))
- Avoid deprecated BuildProducer injection [\#3004](https://github.com/apache/camel-quarkus/pull/3004) ([jamesnetherton](https://github.com/jamesnetherton))
- Be more specific about which endpoints are mocked in AdviceWith test [\#3003](https://github.com/apache/camel-quarkus/pull/3003) ([jamesnetherton](https://github.com/jamesnetherton))
- Introduce a common set of extendable messaging tests [\#3000](https://github.com/apache/camel-quarkus/pull/3000) ([jamesnetherton](https://github.com/jamesnetherton))
- Salesforce : Expand producer test coverage [\#2998](https://github.com/apache/camel-quarkus/pull/2998) ([zbendhiba](https://github.com/zbendhiba))
-  Test language\(\) DSL method & Language component native support [\#2996](https://github.com/apache/camel-quarkus/pull/2996) ([ppalaga](https://github.com/ppalaga))
- Upgrade to cq-maven-plugin 0.38.0, keep spaces in simple XML elements [\#2995](https://github.com/apache/camel-quarkus/pull/2995) ([ppalaga](https://github.com/ppalaga))
- Upgrade Camel to 3.11.1 [\#2994](https://github.com/apache/camel-quarkus/pull/2994) ([jamesnetherton](https://github.com/jamesnetherton))
- Improve grouped test modules READMEs [\#2993](https://github.com/apache/camel-quarkus/pull/2993) ([ppalaga](https://github.com/ppalaga))
- xchange: explicitly register the CurrencyNames bundle at build time \#… [\#2992](https://github.com/apache/camel-quarkus/pull/2992) ([aldettinger](https://github.com/aldettinger))
- Expand AWS DDB tests \#2776 [\#2988](https://github.com/apache/camel-quarkus/pull/2988) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Run cq:sync-versions in the CI build to verify properties are in sync [\#2987](https://github.com/apache/camel-quarkus/pull/2987) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade Quarkus to 2.1.1.Final [\#2986](https://github.com/apache/camel-quarkus/pull/2986) ([jamesnetherton](https://github.com/jamesnetherton))
- Use shaded spring support dependencies in Spring RabbitMQ extension [\#2985](https://github.com/apache/camel-quarkus/pull/2985) ([jamesnetherton](https://github.com/jamesnetherton))
- leveldb: remove useless substitutions in favor of graalvm built-in Me… [\#2984](https://github.com/apache/camel-quarkus/pull/2984) ([aldettinger](https://github.com/aldettinger))
- Skip querying Jandex for quarkus.camel.native.reflection.include-patt… [\#2973](https://github.com/apache/camel-quarkus/pull/2973) ([ppalaga](https://github.com/ppalaga))
- jolt: remove the DeepCopySubstitution in favor of Quarkus serializati… [\#2972](https://github.com/apache/camel-quarkus/pull/2972) ([aldettinger](https://github.com/aldettinger))
- Use quarkus-grpc-common instead of quarkus-grpc in the gRPC extension [\#2971](https://github.com/apache/camel-quarkus/pull/2971) ([jamesnetherton](https://github.com/jamesnetherton))
- Introduce a build time optimized FastComponentNameResolver [\#2963](https://github.com/apache/camel-quarkus/pull/2963) ([jamesnetherton](https://github.com/jamesnetherton))
- More EIP DSL method tests [\#2962](https://github.com/apache/camel-quarkus/pull/2962) ([ppalaga](https://github.com/ppalaga))
- Fix foundation core faulttolerance itest package name [\#2961](https://github.com/apache/camel-quarkus/pull/2961) ([aldettinger](https://github.com/aldettinger))
- Test sending messages to an SNS FIFO topic \#2625 [\#2960](https://github.com/apache/camel-quarkus/pull/2960) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Removed static modifier from top level class example [\#2959](https://github.com/apache/camel-quarkus/pull/2959) ([mmuzikar](https://github.com/mmuzikar))
- Improve the Configuration by convention section of the configuration … [\#2958](https://github.com/apache/camel-quarkus/pull/2958) ([ppalaga](https://github.com/ppalaga))
- Polish the wording of the Configuration docs page [\#2956](https://github.com/apache/camel-quarkus/pull/2956) ([ppalaga](https://github.com/ppalaga))
- More EIP tests [\#2953](https://github.com/apache/camel-quarkus/pull/2953) ([ppalaga](https://github.com/ppalaga))
- AWS2 ddb-streams integration tests failures \#2860 [\#2951](https://github.com/apache/camel-quarkus/pull/2951) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Document upgrading Camel Quarkus in Quarkus platform [\#2950](https://github.com/apache/camel-quarkus/pull/2950) ([ppalaga](https://github.com/ppalaga))
- Next is 2.2.0 [\#2949](https://github.com/apache/camel-quarkus/pull/2949) ([zbendhiba](https://github.com/zbendhiba))
- Stress the more preferred way of configuring components via CDI by mo… [\#2947](https://github.com/apache/camel-quarkus/pull/2947) ([ppalaga](https://github.com/ppalaga))
- Expand ElasticSearch REST test coverage [\#2945](https://github.com/apache/camel-quarkus/pull/2945) ([jamesnetherton](https://github.com/jamesnetherton))
- Remove an outdated sentence from the SQL extension docs, which was re… [\#2944](https://github.com/apache/camel-quarkus/pull/2944) ([ppalaga](https://github.com/ppalaga))
- Test Quarkus and Camel ElasticSearch REST client configuration [\#2943](https://github.com/apache/camel-quarkus/pull/2943) ([jamesnetherton](https://github.com/jamesnetherton))
- \[Camel 3.11\] Solr cloud integration tests are failing \#2814 [\#2942](https://github.com/apache/camel-quarkus/pull/2942) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Add native support for transferException [\#2940](https://github.com/apache/camel-quarkus/pull/2940) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade Quarkus Debezium to 1.6.1.Final and Quarkus Google Cloud to 0… [\#2937](https://github.com/apache/camel-quarkus/pull/2937) ([zbendhiba](https://github.com/zbendhiba))
- Upgrade Quarkus Qpid JMS to 0.26.0 [\#2936](https://github.com/apache/camel-quarkus/pull/2936) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade to Quarkus 2.1.0.Final [\#2934](https://github.com/apache/camel-quarkus/pull/2934) ([ppalaga](https://github.com/ppalaga))
- Upgrade to Optaplanner 8.8.0 & fix removeProperty tests [\#2933](https://github.com/apache/camel-quarkus/pull/2933) ([ppalaga](https://github.com/ppalaga))
- Use default timer delay for main-unknown-args itest application [\#2931](https://github.com/apache/camel-quarkus/pull/2931) ([jamesnetherton](https://github.com/jamesnetherton))
- Use static issues to report nightly sync workflow failures [\#2928](https://github.com/apache/camel-quarkus/pull/2928) ([jamesnetherton](https://github.com/jamesnetherton))
- Make the creation of a GitHub release a part of the release process [\#2924](https://github.com/apache/camel-quarkus/pull/2924) ([ppalaga](https://github.com/ppalaga))
- Document the options for configuring the ElasticSearch REST client [\#2923](https://github.com/apache/camel-quarkus/pull/2923) ([jamesnetherton](https://github.com/jamesnetherton))
- Salesforce - Mock existing integration tests [\#2921](https://github.com/apache/camel-quarkus/pull/2921) ([zbendhiba](https://github.com/zbendhiba))
- Remove reflective class registration for ScramSaslClientFactory [\#2920](https://github.com/apache/camel-quarkus/pull/2920) ([jamesnetherton](https://github.com/jamesnetherton))
- Support JMS ObjectMessage [\#2919](https://github.com/apache/camel-quarkus/pull/2919) ([jamesnetherton](https://github.com/jamesnetherton))
- Expand Netty test coverage [\#2918](https://github.com/apache/camel-quarkus/pull/2918) ([jamesnetherton](https://github.com/jamesnetherton))
- add zbendhiba public key [\#2917](https://github.com/apache/camel-quarkus/pull/2917) ([zbendhiba](https://github.com/zbendhiba))
- Remove quarkus.camel.sql.script-files configuration property  [\#2916](https://github.com/apache/camel-quarkus/pull/2916) ([jamesnetherton](https://github.com/jamesnetherton))
- Laveraging quarkus-security [\#2915](https://github.com/apache/camel-quarkus/pull/2915) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Prevent configuration of QuarkusKafkaClientFactory if quarkus-kubernetes-service-binding is not on the classpath [\#2913](https://github.com/apache/camel-quarkus/pull/2913) ([jamesnetherton](https://github.com/jamesnetherton))
- Add information about BOMs and precedence of them [\#2912](https://github.com/apache/camel-quarkus/pull/2912) ([mmuzikar](https://github.com/mmuzikar))
- camel-quarkus-minio: quarkus.minio.url is not mandatory [\#2911](https://github.com/apache/camel-quarkus/pull/2911) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Upgrade Quarkus to 2.1.0.CR1 [\#2910](https://github.com/apache/camel-quarkus/pull/2910) ([jamesnetherton](https://github.com/jamesnetherton))
- fix  js-dsl integration test failure \#2908 [\#2909](https://github.com/apache/camel-quarkus/pull/2909) ([ffang](https://github.com/ffang))
- fix  can't build camel-fhir extension native image \#2906 [\#2907](https://github.com/apache/camel-quarkus/pull/2907) ([ffang](https://github.com/ffang))
- Use of serialization feature of Quakus \(includes Sql and Nitrite\) [\#2904](https://github.com/apache/camel-quarkus/pull/2904) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Warn users that not all combinations of artifacts managed by [\#2899](https://github.com/apache/camel-quarkus/pull/2899) ([ppalaga](https://github.com/ppalaga))
- Add tests for Quarkus traced beans with Camel routes [\#2898](https://github.com/apache/camel-quarkus/pull/2898) ([jamesnetherton](https://github.com/jamesnetherton))
- add info about usage of nimbus-jose-jwt [\#2896](https://github.com/apache/camel-quarkus/pull/2896) ([zbendhiba](https://github.com/zbendhiba))
- Remove extra .Final in plugin version [\#2895](https://github.com/apache/camel-quarkus/pull/2895) ([gastaldi](https://github.com/gastaldi))
- Remove redundant jdk-8-classpath profile [\#2891](https://github.com/apache/camel-quarkus/pull/2891) ([jamesnetherton](https://github.com/jamesnetherton))
- Add a summary page for messaging extensions [\#2890](https://github.com/apache/camel-quarkus/pull/2890) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix read-lock tests [\#2889](https://github.com/apache/camel-quarkus/pull/2889) ([philschaller](https://github.com/philschaller))
- Remove useless docker-java8 profile [\#2887](https://github.com/apache/camel-quarkus/pull/2887) ([aldettinger](https://github.com/aldettinger))
- kudu: remove the useless test harness logic dedicated to Java 8 \#2885 [\#2886](https://github.com/apache/camel-quarkus/pull/2886) ([aldettinger](https://github.com/aldettinger))
- Upgrade Quarkus to 2.0.1.Final [\#2883](https://github.com/apache/camel-quarkus/pull/2883) ([jamesnetherton](https://github.com/jamesnetherton))
- Avoid producing FeatureBuildItem in support extensions [\#2882](https://github.com/apache/camel-quarkus/pull/2882) ([jamesnetherton](https://github.com/jamesnetherton))
- Leverage catalog metadata to discover unremovable types [\#2881](https://github.com/apache/camel-quarkus/pull/2881) ([jamesnetherton](https://github.com/jamesnetherton))
- kafka : impossible to authenticate with oauth2 [\#2879](https://github.com/apache/camel-quarkus/pull/2879) ([zbendhiba](https://github.com/zbendhiba))
- Add test for camel.faulttolerance.\* properties \#2780 [\#2877](https://github.com/apache/camel-quarkus/pull/2877) ([aldettinger](https://github.com/aldettinger))
- Fix \#2869 to combine build sanity checks into a single scirpt [\#2875](https://github.com/apache/camel-quarkus/pull/2875) ([zhfeng](https://github.com/zhfeng))
- Clean up unnecessary use of @Unremovable [\#2871](https://github.com/apache/camel-quarkus/pull/2871) ([jamesnetherton](https://github.com/jamesnetherton))
- Default to JDK 11 source & target compiler options [\#2870](https://github.com/apache/camel-quarkus/pull/2870) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#2763 to ensure jvmSince and nativeSince not newer that current v… [\#2866](https://github.com/apache/camel-quarkus/pull/2866) ([zhfeng](https://github.com/zhfeng))
- Fix usage of incorrect @Produces annotation [\#2865](https://github.com/apache/camel-quarkus/pull/2865) ([jamesnetherton](https://github.com/jamesnetherton))
- Dependency upgrades [\#2863](https://github.com/apache/camel-quarkus/pull/2863) ([ppalaga](https://github.com/ppalaga))
- Class loader issues in AvroRpcTest with Quarkus 2.0.0.Alpha3 \#2651 [\#2859](https://github.com/apache/camel-quarkus/pull/2859) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Add OpenTelemetry extension [\#2854](https://github.com/apache/camel-quarkus/pull/2854) ([jamesnetherton](https://github.com/jamesnetherton))
- Remove Camel 3.11 staging repository [\#2851](https://github.com/apache/camel-quarkus/pull/2851) ([jamesnetherton](https://github.com/jamesnetherton))
- Improve extension descriptions [\#2848](https://github.com/apache/camel-quarkus/pull/2848) ([ppalaga](https://github.com/ppalaga))
- Fix \#2285 upgrade to use the lasest narayana lra-coordinator [\#2847](https://github.com/apache/camel-quarkus/pull/2847) ([zhfeng](https://github.com/zhfeng))
- Add a TypeConverter for platform-http to convert Buffer to ByteBuffer and work around \#2838 [\#2846](https://github.com/apache/camel-quarkus/pull/2846) ([jamesnetherton](https://github.com/jamesnetherton))
- Add a section about mocking remote endpoints to Testing page of user guide [\#2843](https://github.com/apache/camel-quarkus/pull/2843) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix InfinispanTest failed on Mac \#2840 [\#2841](https://github.com/apache/camel-quarkus/pull/2841) ([ffang](https://github.com/ffang))
- Upgrade to Camel 3.11 [\#2839](https://github.com/apache/camel-quarkus/pull/2839) ([ppalaga](https://github.com/ppalaga))
- Use a custom NativeImageStartedNotifier for box native tests to work around \#2830 [\#2837](https://github.com/apache/camel-quarkus/pull/2837) ([jamesnetherton](https://github.com/jamesnetherton))
- Add a section about testing to the Contributor guide [\#2836](https://github.com/apache/camel-quarkus/pull/2836) ([ppalaga](https://github.com/ppalaga))
- Upgrade to Quarkus 2.0.0.Final [\#2835](https://github.com/apache/camel-quarkus/pull/2835) ([ppalaga](https://github.com/ppalaga))
- Deprecate quarkus.camel.sql.script-files configuration property [\#2827](https://github.com/apache/camel-quarkus/pull/2827) ([jamesnetherton](https://github.com/jamesnetherton))
- Update the Command mode docs page [\#2826](https://github.com/apache/camel-quarkus/pull/2826) ([ppalaga](https://github.com/ppalaga))
- Test camel.threadpool.\* set of properties \#2781 [\#2825](https://github.com/apache/camel-quarkus/pull/2825) ([aldettinger](https://github.com/aldettinger))
- Migration guide: mention Quarkus 2.0 migration guide, [\#2824](https://github.com/apache/camel-quarkus/pull/2824) ([ppalaga](https://github.com/ppalaga))
- Manage Groovy dependencies with groovy-bom import [\#2821](https://github.com/apache/camel-quarkus/pull/2821) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade to Quarkiverse Google Cloud Services 0.8.0.CR1 [\#2820](https://github.com/apache/camel-quarkus/pull/2820) ([ppalaga](https://github.com/ppalaga))
- Tested and documented the specification of custom beans in applicatio… [\#2818](https://github.com/apache/camel-quarkus/pull/2818) ([aldettinger](https://github.com/aldettinger))
- Unmanage unnecessary google dependencies  [\#2817](https://github.com/apache/camel-quarkus/pull/2817) ([ppalaga](https://github.com/ppalaga))
- Replace quarkus.camel.native.resources.\* with quarkus.native.resource… [\#2813](https://github.com/apache/camel-quarkus/pull/2813) ([ppalaga](https://github.com/ppalaga))
- Remove camel-quarkus-main  [\#2811](https://github.com/apache/camel-quarkus/pull/2811) ([ppalaga](https://github.com/ppalaga))
- Reduce Splunk minimum free disk space requirement [\#2809](https://github.com/apache/camel-quarkus/pull/2809) ([jamesnetherton](https://github.com/jamesnetherton))
- Remove redundant apt dependency from camel-quarkus-bom [\#2808](https://github.com/apache/camel-quarkus/pull/2808) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade to Cassandra Quarkus 1.1.0-rc2, fix \#2801 [\#2807](https://github.com/apache/camel-quarkus/pull/2807) ([ppalaga](https://github.com/ppalaga))
- Expand HTTP clients test coverage [\#2806](https://github.com/apache/camel-quarkus/pull/2806) ([jamesnetherton](https://github.com/jamesnetherton))
- Website build fixed after commit of kamelet docs [\#2804](https://github.com/apache/camel-quarkus/pull/2804) ([oscerd](https://github.com/oscerd))
- Expand jsonpath test coverage \#2783 [\#2803](https://github.com/apache/camel-quarkus/pull/2803) ([aldettinger](https://github.com/aldettinger))
- fix Issue/2733 : Native support for kamelet.yaml discovery [\#2799](https://github.com/apache/camel-quarkus/pull/2799) ([valdar](https://github.com/valdar))
- Test Quarkus and Camel Infinispan client configuration [\#2798](https://github.com/apache/camel-quarkus/pull/2798) ([jamesnetherton](https://github.com/jamesnetherton))
- Fixup \#2658 Intermittent failures in MongoDbTest.testTailingConsumer\(… [\#2795](https://github.com/apache/camel-quarkus/pull/2795) ([ppalaga](https://github.com/ppalaga))
- Avoid leaking localstack containers when ryuk is disabled [\#2792](https://github.com/apache/camel-quarkus/pull/2792) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix JSON Jackson jacksonConversionPojo test-addressed feedback \#2726 [\#2790](https://github.com/apache/camel-quarkus/pull/2790) ([ffang](https://github.com/ffang))
-  fix hazelcast integration-test failed in native mode\(On Mac\) \#2719 [\#2789](https://github.com/apache/camel-quarkus/pull/2789) ([ffang](https://github.com/ffang))
- Dependency upgrades [\#2788](https://github.com/apache/camel-quarkus/pull/2788) ([ppalaga](https://github.com/ppalaga))
- Deprecated @BuildTimeAvroDataFormat in favor of quarkus-avro build ti… [\#2787](https://github.com/apache/camel-quarkus/pull/2787) ([aldettinger](https://github.com/aldettinger))
- Exclude org.bouncycastle:bcprov-debug-jdk15on from camel-as2 because we [\#2785](https://github.com/apache/camel-quarkus/pull/2785) ([ppalaga](https://github.com/ppalaga))
- Fix typo in JIRA relationship name [\#2784](https://github.com/apache/camel-quarkus/pull/2784) ([mmuzikar](https://github.com/mmuzikar))
- Remove health configuration workaround [\#2779](https://github.com/apache/camel-quarkus/pull/2779) ([jamesnetherton](https://github.com/jamesnetherton))
- Adapt Observability docs page to Quarkus 2.0.0 [\#2775](https://github.com/apache/camel-quarkus/pull/2775) ([jamesnetherton](https://github.com/jamesnetherton))
- Test setting MLLP default charset from system property for native mode [\#2774](https://github.com/apache/camel-quarkus/pull/2774) ([jamesnetherton](https://github.com/jamesnetherton))
- fix Unable to determine the status of the running process in TimerIT … [\#2773](https://github.com/apache/camel-quarkus/pull/2773) ([ffang](https://github.com/ffang))
- Kafka - add Kafka Idempotent repository test [\#2771](https://github.com/apache/camel-quarkus/pull/2771) ([zbendhiba](https://github.com/zbendhiba))
- Retry Solr cloud container 'is started' steps on failure [\#2770](https://github.com/apache/camel-quarkus/pull/2770) ([jamesnetherton](https://github.com/jamesnetherton))
- Avoid port clashes where it may already be reserved via the build-helper-maven-plugin [\#2769](https://github.com/apache/camel-quarkus/pull/2769) ([jamesnetherton](https://github.com/jamesnetherton))
- Use autoOffsetReset earliest to avoid missing messages sent by the Kafka producer [\#2768](https://github.com/apache/camel-quarkus/pull/2768) ([jamesnetherton](https://github.com/jamesnetherton))
- Avoid duplicating code in BaseModel & FastCamelContext [\#2765](https://github.com/apache/camel-quarkus/pull/2765) ([jamesnetherton](https://github.com/jamesnetherton))
- Camel quarkus 2652 [\#2764](https://github.com/apache/camel-quarkus/pull/2764) ([aldettinger](https://github.com/aldettinger))
- Fix Qute component metadata in Camel Quarkus catalog [\#2760](https://github.com/apache/camel-quarkus/pull/2760) ([ppalaga](https://github.com/ppalaga))
- Unregister MongoDb's ChangeStreamDocument from reflection once it is … [\#2759](https://github.com/apache/camel-quarkus/pull/2759) ([ppalaga](https://github.com/ppalaga))
- Upgrade to azure-bom 1.0.3 and fix \#2207 Upgrading to Jackson 2.12.1 … [\#2758](https://github.com/apache/camel-quarkus/pull/2758) ([ppalaga](https://github.com/ppalaga))
- yaml-dsl: enable flow mode deserialization by default [\#2757](https://github.com/apache/camel-quarkus/pull/2757) ([lburgazzoli](https://github.com/lburgazzoli))
- camel-jackson-avro data format native support [\#2754](https://github.com/apache/camel-quarkus/pull/2754) ([jamesnetherton](https://github.com/jamesnetherton))
- Sql aggregator does not work in native mode. [\#2748](https://github.com/apache/camel-quarkus/pull/2748) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Intermittent failures in MongoDbTest-testTailingConsumer and testPersistentTailingConsumer [\#2746](https://github.com/apache/camel-quarkus/pull/2746) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Intermittent failures in Aws2SqsSnsIT  [\#2743](https://github.com/apache/camel-quarkus/pull/2743) ([ppalaga](https://github.com/ppalaga))
- Add integration test for discovering custom ProtobufMapper beans [\#2742](https://github.com/apache/camel-quarkus/pull/2742) ([jamesnetherton](https://github.com/jamesnetherton))
- Unable to determine the status of the running process in LogIT without resteasy [\#2740](https://github.com/apache/camel-quarkus/pull/2740) ([ppalaga](https://github.com/ppalaga))
- Fixed the CryptoIT test \#2673 [\#2738](https://github.com/apache/camel-quarkus/pull/2738) ([aldettinger](https://github.com/aldettinger))
- Improve KafkaClientFactory integration [\#2735](https://github.com/apache/camel-quarkus/pull/2735) ([jamesnetherton](https://github.com/jamesnetherton))
- Disable dev services for Kafka itests [\#2734](https://github.com/apache/camel-quarkus/pull/2734) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix MasterTest health check endpoint path [\#2732](https://github.com/apache/camel-quarkus/pull/2732) ([jamesnetherton](https://github.com/jamesnetherton))
- camel-jackson-protobuf data format native support [\#2728](https://github.com/apache/camel-quarkus/pull/2728) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#2608 to create destination correctly and re-enable the test case [\#2725](https://github.com/apache/camel-quarkus/pull/2725) ([zhfeng](https://github.com/zhfeng))
- Upgrade to Quarkus 2.0.0.CR3 [\#2722](https://github.com/apache/camel-quarkus/pull/2722) ([ppalaga](https://github.com/ppalaga))
- Fixes for Quarkus Platform 2.0.0 [\#2720](https://github.com/apache/camel-quarkus/pull/2720) ([ppalaga](https://github.com/ppalaga))
- Enable test for REST body validation [\#2717](https://github.com/apache/camel-quarkus/pull/2717) ([jamesnetherton](https://github.com/jamesnetherton))
- Add missing use cases into MongoDb test coverage \#2715 [\#2716](https://github.com/apache/camel-quarkus/pull/2716) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Added move and delete tests for FTP extension \#2645 [\#2710](https://github.com/apache/camel-quarkus/pull/2710) ([aldettinger](https://github.com/aldettinger))
- Fix vertx-http SSL integration test [\#2705](https://github.com/apache/camel-quarkus/pull/2705) ([jamesnetherton](https://github.com/jamesnetherton))
- Expanded Saxon test coverage with XPath saxon tests and fixed related… [\#2703](https://github.com/apache/camel-quarkus/pull/2703) ([aldettinger](https://github.com/aldettinger))
- Build with JDK 16 as 15 is EOL [\#2700](https://github.com/apache/camel-quarkus/pull/2700) ([jamesnetherton](https://github.com/jamesnetherton))
- Document usage of dashed query params with platform-http [\#2699](https://github.com/apache/camel-quarkus/pull/2699) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade SmallRye Reactive Messaging Camel to 3.3.2 [\#2698](https://github.com/apache/camel-quarkus/pull/2698) ([jamesnetherton](https://github.com/jamesnetherton))
- fix typo [\#2697](https://github.com/apache/camel-quarkus/pull/2697) ([zbendhiba](https://github.com/zbendhiba))
- Expand Sql test coverage \#2623 [\#2694](https://github.com/apache/camel-quarkus/pull/2694) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Upgrade to Quarkus 2.0.0.CR2 [\#2688](https://github.com/apache/camel-quarkus/pull/2688) ([ppalaga](https://github.com/ppalaga))
- Fix another typo 'EndpointInject' [\#2687](https://github.com/apache/camel-quarkus/pull/2687) ([kdubois](https://github.com/kdubois))
- Fix typo in EndpointInject title [\#2686](https://github.com/apache/camel-quarkus/pull/2686) ([kdubois](https://github.com/kdubois))
- Add tests and documentation for transaction policies [\#2684](https://github.com/apache/camel-quarkus/pull/2684) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix aws2-support dependency on httpclient [\#2683](https://github.com/apache/camel-quarkus/pull/2683) ([aloubyansky](https://github.com/aloubyansky))
- fix camel-quarkus-jacksonxml:JsonView annotations take no effect in n… [\#2682](https://github.com/apache/camel-quarkus/pull/2682) ([ffang](https://github.com/ffang))
- Fix Error when using camel-quarkus-jackson in native mode: java.lang.… [\#2680](https://github.com/apache/camel-quarkus/pull/2680) ([ffang](https://github.com/ffang))
- jackson: add test coverage \#2634 [\#2672](https://github.com/apache/camel-quarkus/pull/2672) ([ffang](https://github.com/ffang))
- upgrade json-smart [\#2669](https://github.com/apache/camel-quarkus/pull/2669) ([zbendhiba](https://github.com/zbendhiba))
- quarkus-jackson is included quarkus-kafka-client since quarkus 2.0.0.… [\#2668](https://github.com/apache/camel-quarkus/pull/2668) ([zbendhiba](https://github.com/zbendhiba))
- Quick fix - Intermittent failures in MongoDbTest.testTailingConsumer [\#2665](https://github.com/apache/camel-quarkus/pull/2665) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Eagerly initialized Random in various extensions [\#2663](https://github.com/apache/camel-quarkus/pull/2663) ([ppalaga](https://github.com/ppalaga))
- Fix \#2604 to add a camel-sql case in jta integration tests [\#2655](https://github.com/apache/camel-quarkus/pull/2655) ([zhfeng](https://github.com/zhfeng))
- Ensure camel-quarkus-integration-wiremock-support is test scope [\#2644](https://github.com/apache/camel-quarkus/pull/2644) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade to Camel 3.10.0 and Quarkus 2.0.0.Alpha3 [\#2643](https://github.com/apache/camel-quarkus/pull/2643) ([ppalaga](https://github.com/ppalaga))
- Expand MongoDb test coverage \#2622 [\#2642](https://github.com/apache/camel-quarkus/pull/2642) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Test EIPs DSL methods \#2628 [\#2641](https://github.com/apache/camel-quarkus/pull/2641) ([ppalaga](https://github.com/ppalaga))
- Use CamelContextCustomizer from camel-api [\#2640](https://github.com/apache/camel-quarkus/pull/2640) ([jamesnetherton](https://github.com/jamesnetherton))
- Use WireMock for GitHub tests [\#2639](https://github.com/apache/camel-quarkus/pull/2639) ([jamesnetherton](https://github.com/jamesnetherton))
- \#2633 jacksonxml: add test coverage [\#2635](https://github.com/apache/camel-quarkus/pull/2635) ([ffang](https://github.com/ffang))
- add quarkus-jackson in the camel-quarkus-kafka extension [\#2629](https://github.com/apache/camel-quarkus/pull/2629) ([zbendhiba](https://github.com/zbendhiba))
- Use concurrency key instead of cancel-workflow-runs action [\#2620](https://github.com/apache/camel-quarkus/pull/2620) ([jamesnetherton](https://github.com/jamesnetherton))
- Add tests for path prefixes and all HTTP methods [\#2619](https://github.com/apache/camel-quarkus/pull/2619) ([jamesnetherton](https://github.com/jamesnetherton))
- Test core languages in isolation [\#2614](https://github.com/apache/camel-quarkus/pull/2614) ([ppalaga](https://github.com/ppalaga))
- Add tests for MicroProfile metrics configuration options [\#2611](https://github.com/apache/camel-quarkus/pull/2611) ([jamesnetherton](https://github.com/jamesnetherton))
- Add test coverage for additional JMS message types [\#2609](https://github.com/apache/camel-quarkus/pull/2609) ([jamesnetherton](https://github.com/jamesnetherton))
- Update first-steps.adoc [\#2603](https://github.com/apache/camel-quarkus/pull/2603) ([yazidaqel](https://github.com/yazidaqel))
- Leverage quarkus-hazelcast-client-bom, upgrade to quarkus-hazelcast-client 1.2.0 [\#2602](https://github.com/apache/camel-quarkus/pull/2602) ([ppalaga](https://github.com/ppalaga))
- Document locale limitations in native mode  [\#2601](https://github.com/apache/camel-quarkus/pull/2601) ([ppalaga](https://github.com/ppalaga))
- Revisit core, main and foundation integration tests \#2362 [\#2597](https://github.com/apache/camel-quarkus/pull/2597) ([ppalaga](https://github.com/ppalaga))
- AWS2 components have to set client.endpointOverride\(\) to work on Loca… [\#2596](https://github.com/apache/camel-quarkus/pull/2596) ([ppalaga](https://github.com/ppalaga))
- REST extension doc link is not processed correctly  [\#2593](https://github.com/apache/camel-quarkus/pull/2593) ([ppalaga](https://github.com/ppalaga))
- Support @Consume  [\#2588](https://github.com/apache/camel-quarkus/pull/2588) ([ppalaga](https://github.com/ppalaga))
- Add DataSource configuration docs to JDBC & SQL extensions [\#2587](https://github.com/apache/camel-quarkus/pull/2587) ([jamesnetherton](https://github.com/jamesnetherton))
- Fixed native issue and completed test/documentation \#1710 [\#2585](https://github.com/apache/camel-quarkus/pull/2585) ([aldettinger](https://github.com/aldettinger))
- Test TypeConverters \#2537 [\#2584](https://github.com/apache/camel-quarkus/pull/2584) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Do not use deprecated BuildStep.applicationArchiveMarkers\(\) [\#2583](https://github.com/apache/camel-quarkus/pull/2583) ([jamesnetherton](https://github.com/jamesnetherton))
- Support @EndpointInject and @Produce  [\#2581](https://github.com/apache/camel-quarkus/pull/2581) ([ppalaga](https://github.com/ppalaga))
- With fix of \#2260 too many @Converters are registered \#2570 [\#2571](https://github.com/apache/camel-quarkus/pull/2571) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Move RestBindingMode XML tests to rest itest module [\#2563](https://github.com/apache/camel-quarkus/pull/2563) ([jamesnetherton](https://github.com/jamesnetherton))
- Add additional SOAP extension test coverage [\#2562](https://github.com/apache/camel-quarkus/pull/2562) ([jamesnetherton](https://github.com/jamesnetherton))
- Custom TypeConverter is not automatically registered \#2260 [\#2560](https://github.com/apache/camel-quarkus/pull/2560) ([JiriOndrusek](https://github.com/JiriOndrusek))
- \[fix\] \#2356 Test file language [\#2559](https://github.com/apache/camel-quarkus/pull/2559) ([KurtStam](https://github.com/KurtStam))
- Explained how to override default build locale in bindy documentation… [\#2557](https://github.com/apache/camel-quarkus/pull/2557) ([aldettinger](https://github.com/aldettinger))
- Update changelog action to v1.4 [\#2556](https://github.com/apache/camel-quarkus/pull/2556) ([jamesnetherton](https://github.com/jamesnetherton))
- Add MLLP test coverage for setting charset [\#2555](https://github.com/apache/camel-quarkus/pull/2555) ([jamesnetherton](https://github.com/jamesnetherton))
- \#2550 fix several native integration-test failure [\#2553](https://github.com/apache/camel-quarkus/pull/2553) ([ffang](https://github.com/ffang))
- Wrap PR template content in comments by default [\#2552](https://github.com/apache/camel-quarkus/pull/2552) ([jamesnetherton](https://github.com/jamesnetherton))
- xpath: Fixed native issue and completed tests/documentation \#2547 [\#2551](https://github.com/apache/camel-quarkus/pull/2551) ([aldettinger](https://github.com/aldettinger))
- Test Batch Consumer, charset, filter, sortby, idempotent of the file component [\#2548](https://github.com/apache/camel-quarkus/pull/2548) ([JiriOndrusek](https://github.com/JiriOndrusek))
- XChange native support [\#2545](https://github.com/apache/camel-quarkus/pull/2545) ([jamesnetherton](https://github.com/jamesnetherton))
- Test bean binding  [\#2544](https://github.com/apache/camel-quarkus/pull/2544) ([ppalaga](https://github.com/ppalaga))
- fix org.apache.camel.quarkus.component.splunk.it.SplunkTest failure i… [\#2543](https://github.com/apache/camel-quarkus/pull/2543) ([ffang](https://github.com/ffang))
- Added tests and docs for the simple language \#2533 [\#2541](https://github.com/apache/camel-quarkus/pull/2541) ([aldettinger](https://github.com/aldettinger))
- Expand HL7 test coverage [\#2538](https://github.com/apache/camel-quarkus/pull/2538) ([jamesnetherton](https://github.com/jamesnetherton))
- Expand REST test coverage [\#2535](https://github.com/apache/camel-quarkus/pull/2535) ([jamesnetherton](https://github.com/jamesnetherton))
- Document the possibility to use CDI beans with camel bean component [\#2531](https://github.com/apache/camel-quarkus/pull/2531) ([ppalaga](https://github.com/ppalaga))
- Test class component, test bean language  [\#2530](https://github.com/apache/camel-quarkus/pull/2530) ([ppalaga](https://github.com/ppalaga))
- fix org.apache.camel.quarkus.component.lra.it.LraTest failed \#2523 [\#2524](https://github.com/apache/camel-quarkus/pull/2524) ([ffang](https://github.com/ffang))
- Fix asciidoctor warnings at camel-website build [\#2517](https://github.com/apache/camel-quarkus/pull/2517) ([tadayosi](https://github.com/tadayosi))
- Fix admonitions in adocs [\#2516](https://github.com/apache/camel-quarkus/pull/2516) ([tadayosi](https://github.com/tadayosi))
- Fixed classpath and no prefix resources that were ignored in dev mode… [\#2515](https://github.com/apache/camel-quarkus/pull/2515) ([aldettinger](https://github.com/aldettinger))
- Qute component improperly classified as other in Camel Quarkus Catalog [\#2510](https://github.com/apache/camel-quarkus/pull/2510) ([ppalaga](https://github.com/ppalaga))
- AtlasMap: Use jandex to discover the types we need to register for re… [\#2509](https://github.com/apache/camel-quarkus/pull/2509) ([zbendhiba](https://github.com/zbendhiba))
- Add test coverage for Kafka with SASL\_SSL [\#2507](https://github.com/apache/camel-quarkus/pull/2507) ([jamesnetherton](https://github.com/jamesnetherton))
- \#2490 fix camel-quarkus-hbase-integration-test [\#2506](https://github.com/apache/camel-quarkus/pull/2506) ([ffang](https://github.com/ffang))
- Google Storage support \#2421 [\#2505](https://github.com/apache/camel-quarkus/pull/2505) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Add integration-tests-support-kafka module [\#2504](https://github.com/apache/camel-quarkus/pull/2504) ([jamesnetherton](https://github.com/jamesnetherton))
- Replace references to camel master branch with main in antora playbooks [\#2501](https://github.com/apache/camel-quarkus/pull/2501) ([jamesnetherton](https://github.com/jamesnetherton))
- Add test coverage for Kafka with SSL [\#2500](https://github.com/apache/camel-quarkus/pull/2500) ([jamesnetherton](https://github.com/jamesnetherton))
- update ci doc [\#2498](https://github.com/apache/camel-quarkus/pull/2498) ([zbendhiba](https://github.com/zbendhiba))
- Add integration tests \#2388 [\#2497](https://github.com/apache/camel-quarkus/pull/2497) ([zbendhiba](https://github.com/zbendhiba))
- bindy: fixed the locale test so that it detects issues on Java 8 too … [\#2496](https://github.com/apache/camel-quarkus/pull/2496) ([aldettinger](https://github.com/aldettinger))
- Fix SlackConfig class for native builds [\#2495](https://github.com/apache/camel-quarkus/pull/2495) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix invalid xref link to configuration.adoc [\#2494](https://github.com/apache/camel-quarkus/pull/2494) ([jamesnetherton](https://github.com/jamesnetherton))
- Simplify testcontainers usage [\#2493](https://github.com/apache/camel-quarkus/pull/2493) ([jamesnetherton](https://github.com/jamesnetherton))
- Reballance CI test categories even more [\#2488](https://github.com/apache/camel-quarkus/pull/2488) ([ppalaga](https://github.com/ppalaga))
- Reballance CI test categories, do not validate docs links in inital-mvn-install CI phase [\#2485](https://github.com/apache/camel-quarkus/pull/2485) ([ppalaga](https://github.com/ppalaga))
- Test skipped in native mode should be executed on default Java version at least  [\#2482](https://github.com/apache/camel-quarkus/pull/2482) ([ppalaga](https://github.com/ppalaga))
- Add Quarkus service binding support to Kafka extension [\#2480](https://github.com/apache/camel-quarkus/pull/2480) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade to Quarkus 1.13.2.Final [\#2478](https://github.com/apache/camel-quarkus/pull/2478) ([ppalaga](https://github.com/ppalaga))
- Run Azure tests grouped on the CI thus saving some time [\#2477](https://github.com/apache/camel-quarkus/pull/2477) ([ppalaga](https://github.com/ppalaga))
- documentation fixes [\#2475](https://github.com/apache/camel-quarkus/pull/2475) ([aldettinger](https://github.com/aldettinger))
- Revisit the documentation \#2136 \#2470 \#2374 [\#2474](https://github.com/apache/camel-quarkus/pull/2474) ([ppalaga](https://github.com/ppalaga))
- Upper case Bootstrap, Fix \#2164 [\#2472](https://github.com/apache/camel-quarkus/pull/2472) ([cunningt](https://github.com/cunningt))
- Docs improvements [\#2469](https://github.com/apache/camel-quarkus/pull/2469) ([ppalaga](https://github.com/ppalaga))
- Improve MongoDB extension documentation of named clients [\#2467](https://github.com/apache/camel-quarkus/pull/2467) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix intermittent failure in native MicroprofileMetricsIT [\#2464](https://github.com/apache/camel-quarkus/pull/2464) ([jamesnetherton](https://github.com/jamesnetherton))
- Added native support for camel-openstack \* components \#1943 [\#2463](https://github.com/apache/camel-quarkus/pull/2463) ([aldettinger](https://github.com/aldettinger))
- Make Quarkus Micrometer optional for Reactor Netty extension [\#2462](https://github.com/apache/camel-quarkus/pull/2462) ([jamesnetherton](https://github.com/jamesnetherton))
- Forward HBase testcontainer's log to stdout to see whether \#2458 is o… [\#2459](https://github.com/apache/camel-quarkus/pull/2459) ([ppalaga](https://github.com/ppalaga))
- Fix \#2441 to remove the unused beanContainer in FhirR5Processor [\#2455](https://github.com/apache/camel-quarkus/pull/2455) ([zhfeng](https://github.com/zhfeng))
- Add code.quarkus.io badges on extension pages  [\#2454](https://github.com/apache/camel-quarkus/pull/2454) ([ppalaga](https://github.com/ppalaga))
- camel-quarkus-dozer Error when running native executable \#2449 [\#2453](https://github.com/apache/camel-quarkus/pull/2453) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Fix xref-validator download failure [\#2446](https://github.com/apache/camel-quarkus/pull/2446) ([ppalaga](https://github.com/ppalaga))
- Show deprecation info in Extensions reference  [\#2444](https://github.com/apache/camel-quarkus/pull/2444) ([ppalaga](https://github.com/ppalaga))
- \[fix\] Enforce correct maven version [\#2443](https://github.com/apache/camel-quarkus/pull/2443) ([llowinge](https://github.com/llowinge))
- Upgrade CassandraQL quarkus extension to 1.0.1 \#2423 [\#2440](https://github.com/apache/camel-quarkus/pull/2440) ([zbendhiba](https://github.com/zbendhiba))
- openstack: added nova server and swift tests \#1943 [\#2438](https://github.com/apache/camel-quarkus/pull/2438) ([aldettinger](https://github.com/aldettinger))
- Azure Storage Data Lake appends newline to the file content  [\#2437](https://github.com/apache/camel-quarkus/pull/2437) ([ppalaga](https://github.com/ppalaga))
- Fix NPE if Qute template can't be found [\#2434](https://github.com/apache/camel-quarkus/pull/2434) ([jamesnetherton](https://github.com/jamesnetherton))
- Make camel-quarkus-xml-io work again after we broke it with camel-qua… [\#2432](https://github.com/apache/camel-quarkus/pull/2432) ([ppalaga](https://github.com/ppalaga))
- Split misc test category into new networking-dataformats category [\#2430](https://github.com/apache/camel-quarkus/pull/2430) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade quarkus-google-cloud-services to 0.5.0 [\#2429](https://github.com/apache/camel-quarkus/pull/2429) ([jamesnetherton](https://github.com/jamesnetherton))
- MLLP Native support [\#2428](https://github.com/apache/camel-quarkus/pull/2428) ([jamesnetherton](https://github.com/jamesnetherton))
- Consume kubernetes-client-bom via Quarkus BoM [\#2427](https://github.com/apache/camel-quarkus/pull/2427) ([ppalaga](https://github.com/ppalaga))
- docs: add xref support for adoc file sourced from javadoc [\#2420](https://github.com/apache/camel-quarkus/pull/2420) ([ppalaga](https://github.com/ppalaga))
- Fix intermittent failure in camel-quarkus-master-integration-test [\#2419](https://github.com/apache/camel-quarkus/pull/2419) ([jamesnetherton](https://github.com/jamesnetherton))
- core: Removed the href in core javadoc as it does not generate a corr… [\#2418](https://github.com/apache/camel-quarkus/pull/2418) ([aldettinger](https://github.com/aldettinger))
- Fix of Spring RabbitMQ integration test failures after spring update [\#2415](https://github.com/apache/camel-quarkus/pull/2415) ([JiriOndrusek](https://github.com/JiriOndrusek))
- bindy: do not embed useless resources \#2413 [\#2414](https://github.com/apache/camel-quarkus/pull/2414) ([aldettinger](https://github.com/aldettinger))
- Document the process for maintaining \(quarkus | camel\)-master branches [\#2412](https://github.com/apache/camel-quarkus/pull/2412) ([jamesnetherton](https://github.com/jamesnetherton))
- bindy: created a test to show the locale issue in native and document… [\#2408](https://github.com/apache/camel-quarkus/pull/2408) ([aldettinger](https://github.com/aldettinger))
- Remove Camel 3.9.0 staging repository [\#2404](https://github.com/apache/camel-quarkus/pull/2404) ([jamesnetherton](https://github.com/jamesnetherton))
- Revert Disable doc xref checks as there is no camel-3.9.x branch yet [\#2394](https://github.com/apache/camel-quarkus/pull/2394) ([jamesnetherton](https://github.com/jamesnetherton))
- Quarkiverse dependency upgrades [\#2390](https://github.com/apache/camel-quarkus/pull/2390) ([ppalaga](https://github.com/ppalaga))
- DigitalOcean native support \#1594 [\#2387](https://github.com/apache/camel-quarkus/pull/2387) ([zbendhiba](https://github.com/zbendhiba))
- Replace hbase-testing-util with docker container \#2295 [\#2379](https://github.com/apache/camel-quarkus/pull/2379) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Upgrade to Camel 3.9.0 [\#2378](https://github.com/apache/camel-quarkus/pull/2378) ([jamesnetherton](https://github.com/jamesnetherton))
- Only invoke completed method on unknown arguments if the failure remedy is FAIL [\#2373](https://github.com/apache/camel-quarkus/pull/2373) ([jamesnetherton](https://github.com/jamesnetherton))
- openstack: added neutron port, subnet and nova flavor tests \#1943 [\#2372](https://github.com/apache/camel-quarkus/pull/2372) ([aldettinger](https://github.com/aldettinger))
- Merge camel-quarkus-main into camel-quarkus-core \#2358 [\#2371](https://github.com/apache/camel-quarkus/pull/2371) ([ppalaga](https://github.com/ppalaga))
- Upgrade to Quarkus 1.13.0.Final [\#2370](https://github.com/apache/camel-quarkus/pull/2370) ([ppalaga](https://github.com/ppalaga))
- Increase MicroProfile health extension test coverage [\#2369](https://github.com/apache/camel-quarkus/pull/2369) ([jamesnetherton](https://github.com/jamesnetherton))
- Use AbstractHealthCheck for custom health checks [\#2364](https://github.com/apache/camel-quarkus/pull/2364) ([jamesnetherton](https://github.com/jamesnetherton))
- openstack: added neutron network tests \#1943 [\#2359](https://github.com/apache/camel-quarkus/pull/2359) ([aldettinger](https://github.com/aldettinger))
- Add test coverage for FTPS [\#2357](https://github.com/apache/camel-quarkus/pull/2357) ([jamesnetherton](https://github.com/jamesnetherton))
- Deprecate camel-quarkus-componentdsl and camel-quarkus-endpointdsl ex… [\#2355](https://github.com/apache/camel-quarkus/pull/2355) ([ppalaga](https://github.com/ppalaga))
- Add a link to a blog post about Camel Quarkus command line applications [\#2352](https://github.com/apache/camel-quarkus/pull/2352) ([ppalaga](https://github.com/ppalaga))
- Fix some deprecation warnings [\#2348](https://github.com/apache/camel-quarkus/pull/2348) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade Kotlin to 1.4.31 [\#2347](https://github.com/apache/camel-quarkus/pull/2347) ([jamesnetherton](https://github.com/jamesnetherton))
- openstack: added keystone tests \#1943 [\#2346](https://github.com/apache/camel-quarkus/pull/2346) ([aldettinger](https://github.com/aldettinger))
- Remove AWS SDK v1 extensions after they have been removed from Camel [\#2345](https://github.com/apache/camel-quarkus/pull/2345) ([ppalaga](https://github.com/ppalaga))
- Upgrade to Quarkus 1.13.0.CR1 [\#2343](https://github.com/apache/camel-quarkus/pull/2343) ([jamesnetherton](https://github.com/jamesnetherton))
- Register classes with Solr Field annotations for reflection [\#2342](https://github.com/apache/camel-quarkus/pull/2342) ([jamesnetherton](https://github.com/jamesnetherton))
- Add configuration option to ignore unknown arguments [\#2338](https://github.com/apache/camel-quarkus/pull/2338) ([jamesnetherton](https://github.com/jamesnetherton))
- Disable OptaplannerTest.solveSync on CI [\#2337](https://github.com/apache/camel-quarkus/pull/2337) ([jamesnetherton](https://github.com/jamesnetherton))
- openstack: added cinder snapshots and glance tests \#1943 [\#2335](https://github.com/apache/camel-quarkus/pull/2335) ([aldettinger](https://github.com/aldettinger))
- Fix wrong format of RouteBuilder [\#2334](https://github.com/apache/camel-quarkus/pull/2334) ([llowinge](https://github.com/llowinge))
- openstack: added cinder volume tests \#1943 [\#2330](https://github.com/apache/camel-quarkus/pull/2330) ([aldettinger](https://github.com/aldettinger))
- Upgrade Quarkus to 1.12.2.Final [\#2329](https://github.com/apache/camel-quarkus/pull/2329) ([jamesnetherton](https://github.com/jamesnetherton))
- Document that AtlasMap user classes may need to be registered for ref… [\#2328](https://github.com/apache/camel-quarkus/pull/2328) ([zbendhiba](https://github.com/zbendhiba))
- couchbase JVM : add integration tests fixes \#2326 [\#2327](https://github.com/apache/camel-quarkus/pull/2327) ([zbendhiba](https://github.com/zbendhiba))
- HL7 Native support [\#2325](https://github.com/apache/camel-quarkus/pull/2325) ([jamesnetherton](https://github.com/jamesnetherton))
- Updated link in testing doc [\#2324](https://github.com/apache/camel-quarkus/pull/2324) ([mmuzikar](https://github.com/mmuzikar))
- Workaround \#2207 in Azure Storage Data Lake test [\#2322](https://github.com/apache/camel-quarkus/pull/2322) ([ppalaga](https://github.com/ppalaga))
- Use camel-servicenow-maven-plugin to generate model classes [\#2321](https://github.com/apache/camel-quarkus/pull/2321) ([jamesnetherton](https://github.com/jamesnetherton))
- Unable to use Salesforce DTOs in native mode [\#2315](https://github.com/apache/camel-quarkus/pull/2315) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade Quarkus to 1.12.1.Final [\#2313](https://github.com/apache/camel-quarkus/pull/2313) ([jamesnetherton](https://github.com/jamesnetherton))
- Adjust references to the runner JAR for the fast-jar format [\#2311](https://github.com/apache/camel-quarkus/pull/2311) ([jamesnetherton](https://github.com/jamesnetherton))
- Paho MQTT 5 support  [\#2310](https://github.com/apache/camel-quarkus/pull/2310) ([ppalaga](https://github.com/ppalaga))
- Stitch and Huawei SMN JVM support [\#2309](https://github.com/apache/camel-quarkus/pull/2309) ([ppalaga](https://github.com/ppalaga))
- Review usage of quarkus.ssl.native in integration tests [\#2307](https://github.com/apache/camel-quarkus/pull/2307) ([jamesnetherton](https://github.com/jamesnetherton))
- Azure Storage Data Lake JVM support \#2289 [\#2305](https://github.com/apache/camel-quarkus/pull/2305) ([ppalaga](https://github.com/ppalaga))
- Move HTTP send-dynamic test to HTTP itest module [\#2303](https://github.com/apache/camel-quarkus/pull/2303) ([jamesnetherton](https://github.com/jamesnetherton))
- bindy: added native support for methods registered with @DataField [\#2298](https://github.com/apache/camel-quarkus/pull/2298) ([aldettinger](https://github.com/aldettinger))
- Use azure-sdk-bom instead of individual azure artifact versions [\#2297](https://github.com/apache/camel-quarkus/pull/2297) ([ppalaga](https://github.com/ppalaga))
- Test AWS 2 SES [\#2288](https://github.com/apache/camel-quarkus/pull/2288) ([ppalaga](https://github.com/ppalaga))
- LRA native support [\#2286](https://github.com/apache/camel-quarkus/pull/2286) ([jamesnetherton](https://github.com/jamesnetherton))
- Test AWS 2 Lambda [\#2283](https://github.com/apache/camel-quarkus/pull/2283) ([ppalaga](https://github.com/ppalaga))
- bindy: fixed reflective classes registration, fixes \#2268 [\#2281](https://github.com/apache/camel-quarkus/pull/2281) ([aldettinger](https://github.com/aldettinger))
- Test AWS 2 CloudWatch [\#2280](https://github.com/apache/camel-quarkus/pull/2280) ([ppalaga](https://github.com/ppalaga))
- Improve the release guide [\#2279](https://github.com/apache/camel-quarkus/pull/2279) ([ppalaga](https://github.com/ppalaga))
- Prefer SyntheticBeanBuildItem to initializing bean producers via volatile fields  [\#2277](https://github.com/apache/camel-quarkus/pull/2277) ([ppalaga](https://github.com/ppalaga))
- Next is 1.8.0 [\#2274](https://github.com/apache/camel-quarkus/pull/2274) ([ppalaga](https://github.com/ppalaga))
- Azure EventHubs test fixup [\#2271](https://github.com/apache/camel-quarkus/pull/2271) ([ppalaga](https://github.com/ppalaga))
- Upgrade Quarkus Qpid JMS to 0.23.0 [\#2270](https://github.com/apache/camel-quarkus/pull/2270) ([jamesnetherton](https://github.com/jamesnetherton))
- Make git tests ignore local configuration [\#2269](https://github.com/apache/camel-quarkus/pull/2269) ([jamesnetherton](https://github.com/jamesnetherton))
- Disable ryuk on CI builds [\#2267](https://github.com/apache/camel-quarkus/pull/2267) ([jamesnetherton](https://github.com/jamesnetherton))
- Deprecate Webocket JSR 356 \#2262 [\#2265](https://github.com/apache/camel-quarkus/pull/2265) ([ppalaga](https://github.com/ppalaga))
- Add basic Netty UDP tests [\#2264](https://github.com/apache/camel-quarkus/pull/2264) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade Quarkus to 1.12.0.Final [\#2263](https://github.com/apache/camel-quarkus/pull/2263) ([jamesnetherton](https://github.com/jamesnetherton))
- JFR JVM only support [\#2259](https://github.com/apache/camel-quarkus/pull/2259) ([jamesnetherton](https://github.com/jamesnetherton))
- Added CBOR data format native support \#1754 [\#2257](https://github.com/apache/camel-quarkus/pull/2257) ([aldettinger](https://github.com/aldettinger))
- Test AWS 2 Firehose [\#2256](https://github.com/apache/camel-quarkus/pull/2256) ([ppalaga](https://github.com/ppalaga))
- Nitrite native support \#1298 [\#2254](https://github.com/apache/camel-quarkus/pull/2254) ([JiriOndrusek](https://github.com/JiriOndrusek))
- AWS 2 Kinesis native support  [\#2252](https://github.com/apache/camel-quarkus/pull/2252) ([ppalaga](https://github.com/ppalaga))
- Remove Camel 3.8.0 staging repository [\#2251](https://github.com/apache/camel-quarkus/pull/2251) ([jamesnetherton](https://github.com/jamesnetherton))
- Enable FOP native integration tests [\#2247](https://github.com/apache/camel-quarkus/pull/2247) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix intermittent failure of SpringRabbitmqTest [\#2246](https://github.com/apache/camel-quarkus/pull/2246) ([jamesnetherton](https://github.com/jamesnetherton))
- await for consumer fixes \#2205 [\#2245](https://github.com/apache/camel-quarkus/pull/2245) ([zbendhiba](https://github.com/zbendhiba))
- Remove outdated extensions README [\#2244](https://github.com/apache/camel-quarkus/pull/2244) ([jamesnetherton](https://github.com/jamesnetherton))
- Test AWS 2 DynamoDB Streams [\#2242](https://github.com/apache/camel-quarkus/pull/2242) ([ppalaga](https://github.com/ppalaga))
- Docs xref checks failure with Camel 3.8.0 [\#2240](https://github.com/apache/camel-quarkus/pull/2240) ([jamesnetherton](https://github.com/jamesnetherton))
- Test AWS 2 DynamoDB properly [\#2238](https://github.com/apache/camel-quarkus/pull/2238) ([ppalaga](https://github.com/ppalaga))
- AtlasMap native support \#1989 [\#2237](https://github.com/apache/camel-quarkus/pull/2237) ([zbendhiba](https://github.com/zbendhiba))
- \[update\] Upgrade testcontainers version [\#2236](https://github.com/apache/camel-quarkus/pull/2236) ([llowinge](https://github.com/llowinge))
- Add Kamelet component extension  [\#2235](https://github.com/apache/camel-quarkus/pull/2235) ([jamesnetherton](https://github.com/jamesnetherton))
- Removing unnecessary exclusions in test for CassandaQL [\#2234](https://github.com/apache/camel-quarkus/pull/2234) ([JiriOndrusek](https://github.com/JiriOndrusek))
- camel-spring-rabbitmq - new component \#2128 [\#2233](https://github.com/apache/camel-quarkus/pull/2233) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Remove redundant Netty reflective class configuration [\#2232](https://github.com/apache/camel-quarkus/pull/2232) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade to Quarkus 1.12.0.CR1 [\#2231](https://github.com/apache/camel-quarkus/pull/2231) ([jamesnetherton](https://github.com/jamesnetherton))
- Allow running AWS 2 tests both grouped and isolated [\#2230](https://github.com/apache/camel-quarkus/pull/2230) ([ppalaga](https://github.com/ppalaga))
- Use Java 15 as 14 is EOL [\#2229](https://github.com/apache/camel-quarkus/pull/2229) ([jamesnetherton](https://github.com/jamesnetherton))
- Ensure integration tests have enough free disk space [\#2228](https://github.com/apache/camel-quarkus/pull/2228) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade to Camel 3.8.0 [\#2227](https://github.com/apache/camel-quarkus/pull/2227) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix camel-master CI branch build [\#2224](https://github.com/apache/camel-quarkus/pull/2224) ([jamesnetherton](https://github.com/jamesnetherton))
- Test AWS 2 SNS properly [\#2222](https://github.com/apache/camel-quarkus/pull/2222) ([ppalaga](https://github.com/ppalaga))
- PubNub native support [\#2218](https://github.com/apache/camel-quarkus/pull/2218) ([jamesnetherton](https://github.com/jamesnetherton))
- Test AWS 2 SQS properly [\#2217](https://github.com/apache/camel-quarkus/pull/2217) ([ppalaga](https://github.com/ppalaga))
- Replaced the JettyTestServer class with MockOaipmhServer based on wir… [\#2214](https://github.com/apache/camel-quarkus/pull/2214) ([aldettinger](https://github.com/aldettinger))
- Azure EventHubs native build fails with Quarkus 1.12  [\#2208](https://github.com/apache/camel-quarkus/pull/2208) ([ppalaga](https://github.com/ppalaga))
- Replace the deprecated VanillaUuidGenerator with DefaultUuidGenerator [\#2203](https://github.com/apache/camel-quarkus/pull/2203) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade SmallRye Reactive Messaging Camel to 2.8.0 [\#2199](https://github.com/apache/camel-quarkus/pull/2199) ([jamesnetherton](https://github.com/jamesnetherton))
- Test AWS 2 S3 properly [\#2198](https://github.com/apache/camel-quarkus/pull/2198) ([ppalaga](https://github.com/ppalaga))
- Syslog native support [\#2197](https://github.com/apache/camel-quarkus/pull/2197) ([jamesnetherton](https://github.com/jamesnetherton))
- Changelog is back [\#2195](https://github.com/apache/camel-quarkus/pull/2195) ([oscerd](https://github.com/oscerd))
- AWS2 EventBridge native support [\#2193](https://github.com/apache/camel-quarkus/pull/2193) ([oscerd](https://github.com/oscerd))
- Added OAI-PMH support [\#2190](https://github.com/apache/camel-quarkus/pull/2190) ([aldettinger](https://github.com/aldettinger))
- XML Security native support [\#2186](https://github.com/apache/camel-quarkus/pull/2186) ([jamesnetherton](https://github.com/jamesnetherton))
- Freemarker native support  [\#2184](https://github.com/apache/camel-quarkus/pull/2184) ([ppalaga](https://github.com/ppalaga))
- Import quarkus-qpid-jms-bom to our BoM instead of importing quarkus-q… [\#2181](https://github.com/apache/camel-quarkus/pull/2181) ([ppalaga](https://github.com/ppalaga))
- Some JVM-only extensions falsely advertized as supporting native [\#2179](https://github.com/apache/camel-quarkus/pull/2179) ([ppalaga](https://github.com/ppalaga))
- Azure Event Hubs support [\#2178](https://github.com/apache/camel-quarkus/pull/2178) ([ppalaga](https://github.com/ppalaga))
- StAX native support [\#2177](https://github.com/apache/camel-quarkus/pull/2177) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade Quarkus to 1.11.1.Final [\#2173](https://github.com/apache/camel-quarkus/pull/2173) ([jamesnetherton](https://github.com/jamesnetherton))
- XML Tokenize language native support [\#2169](https://github.com/apache/camel-quarkus/pull/2169) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#1895 to remove registerNarayanaReflectiveClass [\#2165](https://github.com/apache/camel-quarkus/pull/2165) ([zhfeng](https://github.com/zhfeng))
- Improvement for first-steps docs [\#2162](https://github.com/apache/camel-quarkus/pull/2162) ([tstuber](https://github.com/tstuber))
- IPFS native support [\#2159](https://github.com/apache/camel-quarkus/pull/2159) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade Camel to 3.7.1 [\#2158](https://github.com/apache/camel-quarkus/pull/2158) ([jamesnetherton](https://github.com/jamesnetherton))
- Avoid usage of deprecated capabilities string constants [\#2154](https://github.com/apache/camel-quarkus/pull/2154) ([jamesnetherton](https://github.com/jamesnetherton))
- Improve the release docs [\#2150](https://github.com/apache/camel-quarkus/pull/2150) ([ppalaga](https://github.com/ppalaga))
- Upgrade to cq-maven-plugin 0.27, stop using mvnd.rules altogether [\#2148](https://github.com/apache/camel-quarkus/pull/2148) ([ppalaga](https://github.com/ppalaga))
- add Awaitility + suppress warnings \#2127 [\#2146](https://github.com/apache/camel-quarkus/pull/2146) ([zbendhiba](https://github.com/zbendhiba))
- Azure Storage Queue Service native support [\#2143](https://github.com/apache/camel-quarkus/pull/2143) ([ppalaga](https://github.com/ppalaga))
- Improve the release docs [\#2141](https://github.com/apache/camel-quarkus/pull/2141) ([ppalaga](https://github.com/ppalaga))
- Avoid automatic minio client autowiring \#2134 [\#2140](https://github.com/apache/camel-quarkus/pull/2140) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Azure Storage Blob native support  [\#2139](https://github.com/apache/camel-quarkus/pull/2139) ([ppalaga](https://github.com/ppalaga))
- Upgrade Quarkus Qpid JMS to 0.22.0 [\#2138](https://github.com/apache/camel-quarkus/pull/2138) ([jamesnetherton](https://github.com/jamesnetherton))
- Hazelcast integration tests : switch to testcontainers \#2127 [\#2137](https://github.com/apache/camel-quarkus/pull/2137) ([zbendhiba](https://github.com/zbendhiba))
- Upgrade Quarkus to 1.11.0.Final [\#2133](https://github.com/apache/camel-quarkus/pull/2133) ([jamesnetherton](https://github.com/jamesnetherton))
- Allow running the Azure test against the real Azure API in addition to [\#2132](https://github.com/apache/camel-quarkus/pull/2132) ([ppalaga](https://github.com/ppalaga))
- Add notes on enabling Geolocation APIs for geocoder extension integration tests [\#2130](https://github.com/apache/camel-quarkus/pull/2130) ([jamesnetherton](https://github.com/jamesnetherton))
- add missing QuarkusTestResource [\#2129](https://github.com/apache/camel-quarkus/pull/2129) ([zbendhiba](https://github.com/zbendhiba))
- Add vertx-kafka component support [\#2125](https://github.com/apache/camel-quarkus/pull/2125) ([jamesnetherton](https://github.com/jamesnetherton))
- Remove changelog generation workflow [\#2124](https://github.com/apache/camel-quarkus/pull/2124) ([jamesnetherton](https://github.com/jamesnetherton))
- Debezium MongoDB Connector native support [\#2123](https://github.com/apache/camel-quarkus/pull/2123) ([ppalaga](https://github.com/ppalaga))
- Switch back to AdoptOpenJDK/install-jdk action [\#2121](https://github.com/apache/camel-quarkus/pull/2121) ([jamesnetherton](https://github.com/jamesnetherton))
- Align Kotlin and SmallRye Reactive Messaging Camel with Quarkus [\#2118](https://github.com/apache/camel-quarkus/pull/2118) ([jamesnetherton](https://github.com/jamesnetherton))
- Remove docker.io prefix for images [\#2117](https://github.com/apache/camel-quarkus/pull/2117) ([llowinge](https://github.com/llowinge))
- Minio native support \#2040 [\#2116](https://github.com/apache/camel-quarkus/pull/2116) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Add more integration tests for camel-hazelcast extension \#2094 [\#2115](https://github.com/apache/camel-quarkus/pull/2115) ([zbendhiba](https://github.com/zbendhiba))
- antora/xref-validator failure after a component was removed from Camel [\#2114](https://github.com/apache/camel-quarkus/pull/2114) ([ppalaga](https://github.com/ppalaga))
- Upgrade Quarkus to 1.11.0.CR1 [\#2111](https://github.com/apache/camel-quarkus/pull/2111) ([jamesnetherton](https://github.com/jamesnetherton))
- Temporary workaround for \#2109 antora/xref-validator after a componen… [\#2110](https://github.com/apache/camel-quarkus/pull/2110) ([ppalaga](https://github.com/ppalaga))
- CSimple NPE even if CSimple language is not used  [\#2108](https://github.com/apache/camel-quarkus/pull/2108) ([ppalaga](https://github.com/ppalaga))
- Added Redis Aggregation Repository support in JVM mode only \#2085 [\#2106](https://github.com/apache/camel-quarkus/pull/2106) ([aldettinger](https://github.com/aldettinger))
- Remove hystrix from test-categories.yaml [\#2105](https://github.com/apache/camel-quarkus/pull/2105) ([llowinge](https://github.com/llowinge))
- Temporarily switch to actions/setup-java [\#2104](https://github.com/apache/camel-quarkus/pull/2104) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade SmallRye Reactive Messaging Camel to 2.7.0 [\#2100](https://github.com/apache/camel-quarkus/pull/2100) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix twitter itest in native mode using ConfigProvider insted of Confi… [\#2096](https://github.com/apache/camel-quarkus/pull/2096) ([llowinge](https://github.com/llowinge))
- Hazelcast native support fixes \#1647 [\#2093](https://github.com/apache/camel-quarkus/pull/2093) ([zbendhiba](https://github.com/zbendhiba))
- Removed loadsApplicationClasses = true as it has no more effect [\#2092](https://github.com/apache/camel-quarkus/pull/2092) ([aldettinger](https://github.com/aldettinger))
- Upgrade to Quarkus 1.11.0.Beta1 [\#2089](https://github.com/apache/camel-quarkus/pull/2089) ([ppalaga](https://github.com/ppalaga))
- Added JSONata extension [\#2088](https://github.com/apache/camel-quarkus/pull/2088) ([aldettinger](https://github.com/aldettinger))
- CAMEL-15948: examples.json instead of .adoc files [\#2087](https://github.com/apache/camel-quarkus/pull/2087) ([zregvart](https://github.com/zregvart))
- Last release is 1.5.0 [\#2086](https://github.com/apache/camel-quarkus/pull/2086) ([ppalaga](https://github.com/ppalaga))
- Next is 1.6.0 [\#2076](https://github.com/apache/camel-quarkus/pull/2076) ([ppalaga](https://github.com/ppalaga))
- Documented the Camel Quarkus testing approach \#1981 [\#2075](https://github.com/apache/camel-quarkus/pull/2075) ([aldettinger](https://github.com/aldettinger))
- Require Java 11 [\#2073](https://github.com/apache/camel-quarkus/pull/2073) ([ppalaga](https://github.com/ppalaga))
- Upgrade to Quarkus 1.10.3.Final [\#2062](https://github.com/apache/camel-quarkus/pull/2062) ([ppalaga](https://github.com/ppalaga))
- Polish how we pass -Djavax.net.ssl.trustStore to the Solr test \#2029 [\#2056](https://github.com/apache/camel-quarkus/pull/2056) ([ppalaga](https://github.com/ppalaga))
- Fix persistence of WireMock mappings [\#2054](https://github.com/apache/camel-quarkus/pull/2054) ([jamesnetherton](https://github.com/jamesnetherton))
- Updated the release guide in order to publish sources [\#2053](https://github.com/apache/camel-quarkus/pull/2053) ([aldettinger](https://github.com/aldettinger))
- Use camel-dependencies as parent pom to inherit camel version properties [\#2051](https://github.com/apache/camel-quarkus/pull/2051) ([jamesnetherton](https://github.com/jamesnetherton))
- Micrometer component support [\#2050](https://github.com/apache/camel-quarkus/pull/2050) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade Quarkus to 1.10.2.Final [\#2047](https://github.com/apache/camel-quarkus/pull/2047) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix GeocoderNominationTest postalCode field assertion failure [\#2043](https://github.com/apache/camel-quarkus/pull/2043) ([jamesnetherton](https://github.com/jamesnetherton))
- Fixup 94ef785 Next is 1.5.0-SNAPSHOT [\#2041](https://github.com/apache/camel-quarkus/pull/2041) ([ppalaga](https://github.com/ppalaga))
- Add JVM only extensions for minio [\#2039](https://github.com/apache/camel-quarkus/pull/2039) ([github-actions[bot]](https://github.com/apps/github-actions))
- JSch native support [\#2038](https://github.com/apache/camel-quarkus/pull/2038) ([jamesnetherton](https://github.com/jamesnetherton))
- Add Nitrite tests [\#2035](https://github.com/apache/camel-quarkus/pull/2035) ([ppalaga](https://github.com/ppalaga))
- Upgrade Quarkus to 1.10.1.Final [\#2032](https://github.com/apache/camel-quarkus/pull/2032) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade Quarkus Qpid JMS to 0.21.0 [\#2030](https://github.com/apache/camel-quarkus/pull/2030) ([jamesnetherton](https://github.com/jamesnetherton))
- Test the Freemarker extension properly, although only in JVM mode for [\#2028](https://github.com/apache/camel-quarkus/pull/2028) ([ppalaga](https://github.com/ppalaga))
- Solr native support fixes \#1703 [\#2026](https://github.com/apache/camel-quarkus/pull/2026) ([zbendhiba](https://github.com/zbendhiba))
- Camel Avro RPC component native support \#1941 [\#2025](https://github.com/apache/camel-quarkus/pull/2025) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Fix protobuf itest dependency on deployment [\#2021](https://github.com/apache/camel-quarkus/pull/2021) ([llowinge](https://github.com/llowinge))
- Fix debezium itest pom dependencies to deployments [\#2020](https://github.com/apache/camel-quarkus/pull/2020) ([llowinge](https://github.com/llowinge))
- Leverage Quarkus plugin's generate-code mojo instead of protobuf-maven-plugin to generate protobuf stubs [\#2018](https://github.com/apache/camel-quarkus/pull/2018) ([ppalaga](https://github.com/ppalaga))
- Upgrade Quarkus Qpid JMS to 0.20.0 [\#2017](https://github.com/apache/camel-quarkus/pull/2017) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade Quarkus to 1.10.0.Final [\#2016](https://github.com/apache/camel-quarkus/pull/2016) ([jamesnetherton](https://github.com/jamesnetherton))
- Added key [\#2015](https://github.com/apache/camel-quarkus/pull/2015) ([aldettinger](https://github.com/aldettinger))
- Added JSLT native support \#1740 [\#2010](https://github.com/apache/camel-quarkus/pull/2010) ([aldettinger](https://github.com/aldettinger))
- Fix github itest to use oauth token instead username/password [\#2009](https://github.com/apache/camel-quarkus/pull/2009) ([llowinge](https://github.com/llowinge))
- Kudu: unshade and remove embedded netty and use quarkus-netty instead [\#2008](https://github.com/apache/camel-quarkus/pull/2008) ([ppalaga](https://github.com/ppalaga))
- Upgrade to Quarkus 1.10.0.CR1 [\#2004](https://github.com/apache/camel-quarkus/pull/2004) ([jamesnetherton](https://github.com/jamesnetherton))
- Added MSV native support [\#2000](https://github.com/apache/camel-quarkus/pull/2000) ([aldettinger](https://github.com/aldettinger))
- Configurable Debezium itest timeout [\#1999](https://github.com/apache/camel-quarkus/pull/1999) ([llowinge](https://github.com/llowinge))
- Upgrade Quarkus to 1.9.2.Final [\#1994](https://github.com/apache/camel-quarkus/pull/1994) ([jamesnetherton](https://github.com/jamesnetherton))
- Migrate ServiceNow, Slack, Geocoder & Telegram tests to WireMock [\#1993](https://github.com/apache/camel-quarkus/pull/1993) ([jamesnetherton](https://github.com/jamesnetherton))
- Added nagios native support \#1726 [\#1991](https://github.com/apache/camel-quarkus/pull/1991) ([aldettinger](https://github.com/aldettinger))
- core: allign BaseModel with org.apache.camel.impl.DefaultModel [\#1985](https://github.com/apache/camel-quarkus/pull/1985) ([lburgazzoli](https://github.com/lburgazzoli))
- PostgresSQL Event : add usage of Quarkus AgroalDatasource fixes \#1909 [\#1982](https://github.com/apache/camel-quarkus/pull/1982) ([zbendhiba](https://github.com/zbendhiba))
- Reenable Olingo4 integration test [\#1980](https://github.com/apache/camel-quarkus/pull/1980) ([jamesnetherton](https://github.com/jamesnetherton))
- Configuration option \(not\) to start the runtime \#1969 [\#1977](https://github.com/apache/camel-quarkus/pull/1977) ([ppalaga](https://github.com/ppalaga))
- Add JVM only extensions for aws2-eventbridge [\#1975](https://github.com/apache/camel-quarkus/pull/1975) ([github-actions[bot]](https://github.com/apps/github-actions))
- Automate the process of creating jvm only extensions [\#1974](https://github.com/apache/camel-quarkus/pull/1974) ([jamesnetherton](https://github.com/jamesnetherton))
- Fixup Provide a quick profile \#1607 [\#1968](https://github.com/apache/camel-quarkus/pull/1968) ([ppalaga](https://github.com/ppalaga))
- Zendesk native support [\#1967](https://github.com/apache/camel-quarkus/pull/1967) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade Quarkus to 1.9.1.Final [\#1966](https://github.com/apache/camel-quarkus/pull/1966) ([jamesnetherton](https://github.com/jamesnetherton))
- Twilio native support [\#1964](https://github.com/apache/camel-quarkus/pull/1964) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#819 saga native support [\#1963](https://github.com/apache/camel-quarkus/pull/1963) ([zhfeng](https://github.com/zhfeng))
- Provide a quickly profile [\#1962](https://github.com/apache/camel-quarkus/pull/1962) ([ppalaga](https://github.com/ppalaga))
- Leverage Quarkus JAXP extension where applicable \#1806 [\#1958](https://github.com/apache/camel-quarkus/pull/1958) ([ppalaga](https://github.com/ppalaga))
- Document Spark peculiarities \#1928 [\#1957](https://github.com/apache/camel-quarkus/pull/1957) ([ppalaga](https://github.com/ppalaga))
- Leverage camel-platform-http-vertx in platform-http extension [\#1954](https://github.com/apache/camel-quarkus/pull/1954) ([jamesnetherton](https://github.com/jamesnetherton))
- Replace ${camel.quarkus.project.root} set by directory-maven-plugin w… [\#1953](https://github.com/apache/camel-quarkus/pull/1953) ([ppalaga](https://github.com/ppalaga))
- lumberjack : move client payload sending to test fixes \#1949 [\#1950](https://github.com/apache/camel-quarkus/pull/1950) ([zbendhiba](https://github.com/zbendhiba))
- ActiveMQ Default XPath evaluator could not be loaded [\#1947](https://github.com/apache/camel-quarkus/pull/1947) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix usage of deprecated GitHub actions commands [\#1946](https://github.com/apache/camel-quarkus/pull/1946) ([jamesnetherton](https://github.com/jamesnetherton))
- Camel 3.6.0 upgrade leftovers [\#1940](https://github.com/apache/camel-quarkus/pull/1940) ([jamesnetherton](https://github.com/jamesnetherton))
- Exclude glassfish dependencies from hbase-testing-util [\#1939](https://github.com/apache/camel-quarkus/pull/1939) ([jamesnetherton](https://github.com/jamesnetherton))
- Lumberjack native support fixes \#1732 [\#1938](https://github.com/apache/camel-quarkus/pull/1938) ([zbendhiba](https://github.com/zbendhiba))
- Enable Spring dependent extensions to work with Quarkus Spring [\#1937](https://github.com/apache/camel-quarkus/pull/1937) ([jamesnetherton](https://github.com/jamesnetherton))
- Set retention-days parameter on upload-artifact action [\#1936](https://github.com/apache/camel-quarkus/pull/1936) ([jamesnetherton](https://github.com/jamesnetherton))
- Remove Camel 3.6.0 staging repository [\#1934](https://github.com/apache/camel-quarkus/pull/1934) ([jamesnetherton](https://github.com/jamesnetherton))
- Increase test coverage for Spring dependent extensions [\#1932](https://github.com/apache/camel-quarkus/pull/1932) ([jamesnetherton](https://github.com/jamesnetherton))
- FOP tests fail in Quarkus Platform \#1930 [\#1931](https://github.com/apache/camel-quarkus/pull/1931) ([ppalaga](https://github.com/ppalaga))
- Jenkinsfile build: changed the JDK name following INFRA new approach [\#1929](https://github.com/apache/camel-quarkus/pull/1929) ([oscerd](https://github.com/oscerd))
- Align jackson-dataformat-xml version with Quarkus jackson [\#1925](https://github.com/apache/camel-quarkus/pull/1925) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade Quarkus Qpid JMS to 0.19.0 [\#1924](https://github.com/apache/camel-quarkus/pull/1924) ([jamesnetherton](https://github.com/jamesnetherton))
- Trigger changelog generation on workflow\_dispatch [\#1923](https://github.com/apache/camel-quarkus/pull/1923) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade Quarkus to 1.9.0.Final [\#1921](https://github.com/apache/camel-quarkus/pull/1921) ([jamesnetherton](https://github.com/jamesnetherton))
- Added nsq native support fixes \#1722 [\#1920](https://github.com/apache/camel-quarkus/pull/1920) ([aldettinger](https://github.com/aldettinger))
- pgevent: correct service name [\#1919](https://github.com/apache/camel-quarkus/pull/1919) ([zbendhiba](https://github.com/zbendhiba))
- Spark JVM support [\#1916](https://github.com/apache/camel-quarkus/pull/1916) ([ppalaga](https://github.com/ppalaga))
- Workaround AdviceWithRouteBuilder and MicroprofileMetrics conflict [\#1915](https://github.com/apache/camel-quarkus/pull/1915) ([jamesnetherton](https://github.com/jamesnetherton))
- HBase JVM support [\#1906](https://github.com/apache/camel-quarkus/pull/1906) ([ppalaga](https://github.com/ppalaga))
- PostgresSQL Event native support fixes \#1719 [\#1905](https://github.com/apache/camel-quarkus/pull/1905) ([zbendhiba](https://github.com/zbendhiba))
- Prevent CI workflows running on forks [\#1904](https://github.com/apache/camel-quarkus/pull/1904) ([jamesnetherton](https://github.com/jamesnetherton))
- Document all ways to start a new project [\#1903](https://github.com/apache/camel-quarkus/pull/1903) ([jamesnetherton](https://github.com/jamesnetherton))
- LevelDB native support \#1839 [\#1902](https://github.com/apache/camel-quarkus/pull/1902) ([JiriOndrusek](https://github.com/JiriOndrusek))
- camel-quarkus-jira: Add resteasy-common dependency [\#1899](https://github.com/apache/camel-quarkus/pull/1899) ([mmelko](https://github.com/mmelko))
- File specific issues for TODOs where necessary \#1285 [\#1897](https://github.com/apache/camel-quarkus/pull/1897) ([ppalaga](https://github.com/ppalaga))
- Restrict changelog workflow to only run on apache/camel-quarkus repo [\#1893](https://github.com/apache/camel-quarkus/pull/1893) ([jamesnetherton](https://github.com/jamesnetherton))
- Quarkus 1.9.0 post upgrade fixes [\#1890](https://github.com/apache/camel-quarkus/pull/1890) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade Quarkus to 1.9.0.CR1 [\#1887](https://github.com/apache/camel-quarkus/pull/1887) ([jamesnetherton](https://github.com/jamesnetherton))
- Crypto extension requires reflective access to DigitalSignatureConstants [\#1883](https://github.com/apache/camel-quarkus/pull/1883) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade to Debezium 1.3.0.Final [\#1882](https://github.com/apache/camel-quarkus/pull/1882) ([ppalaga](https://github.com/ppalaga))
- CAMEL-QUARKUS-1720: Added Postgres replication slot native support [\#1880](https://github.com/apache/camel-quarkus/pull/1880) ([aldettinger](https://github.com/aldettinger))
- Crypto \(JCE\) native support [\#1878](https://github.com/apache/camel-quarkus/pull/1878) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix twitter itest so it initially waits when start polling tweets [\#1877](https://github.com/apache/camel-quarkus/pull/1877) ([llowinge](https://github.com/llowinge))
- Add an Examples step to the release guide [\#1875](https://github.com/apache/camel-quarkus/pull/1875) ([ppalaga](https://github.com/ppalaga))
- NoSuchMethodException: org.apache.camel.service.lra.LRASagaRoutes.\<init\>\(\) [\#1873](https://github.com/apache/camel-quarkus/pull/1873) ([ppalaga](https://github.com/ppalaga))
- Headersmap native support [\#1872](https://github.com/apache/camel-quarkus/pull/1872) ([jamesnetherton](https://github.com/jamesnetherton))
- Generate the list of examples from the AsciiDoc pages generated in the [\#1870](https://github.com/apache/camel-quarkus/pull/1870) ([ppalaga](https://github.com/ppalaga))
- Let's see if removing -Dmaven.wagon.http.pool=false solves the Maven … [\#1867](https://github.com/apache/camel-quarkus/pull/1867) ([ppalaga](https://github.com/ppalaga))
- Upgrade SmallRye Reactive Messaging Camel to 2.4.0 [\#1866](https://github.com/apache/camel-quarkus/pull/1866) ([jamesnetherton](https://github.com/jamesnetherton))
- Move examples to a separate git repository [\#1864](https://github.com/apache/camel-quarkus/pull/1864) ([ppalaga](https://github.com/ppalaga))
- Fix platform-http handler exception handling [\#1863](https://github.com/apache/camel-quarkus/pull/1863) ([jamesnetherton](https://github.com/jamesnetherton))
- Turn of Maven connection pooling to avoid connection issues on the CI… [\#1859](https://github.com/apache/camel-quarkus/pull/1859) ([ppalaga](https://github.com/ppalaga))
- Tidy up pom.xml files [\#1858](https://github.com/apache/camel-quarkus/pull/1858) ([ppalaga](https://github.com/ppalaga))
- platform-http: handle requests using a thread from the worker pool [\#1857](https://github.com/apache/camel-quarkus/pull/1857) ([lburgazzoli](https://github.com/lburgazzoli))
- Geocoder native support fixes \#1645 [\#1856](https://github.com/apache/camel-quarkus/pull/1856) ([zbendhiba](https://github.com/zbendhiba))
- Document allowContextMapAll native mode limitations [\#1855](https://github.com/apache/camel-quarkus/pull/1855) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade to cq-maven-plugin 0.20.0, set nativeSince property when prom… [\#1854](https://github.com/apache/camel-quarkus/pull/1854) ([ppalaga](https://github.com/ppalaga))
- Document camel main xml configuration properties [\#1853](https://github.com/apache/camel-quarkus/pull/1853) ([jamesnetherton](https://github.com/jamesnetherton))
- Shiro, Ribbon, JCache JVM support [\#1849](https://github.com/apache/camel-quarkus/pull/1849) ([ppalaga](https://github.com/ppalaga))
- Duplicate license headers in Velocity test templates \#1843 [\#1847](https://github.com/apache/camel-quarkus/pull/1847) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Ensure InputStream is closed after reading rome.properties [\#1842](https://github.com/apache/camel-quarkus/pull/1842) ([jamesnetherton](https://github.com/jamesnetherton))
- AWS XRay, Headersmap, Jasypt, LevelDB, LRA JVM support [\#1841](https://github.com/apache/camel-quarkus/pull/1841) ([ppalaga](https://github.com/ppalaga))
- RSS native support [\#1836](https://github.com/apache/camel-quarkus/pull/1836) ([jamesnetherton](https://github.com/jamesnetherton))
- List of misc. components empty after the recent docs generation chang… [\#1835](https://github.com/apache/camel-quarkus/pull/1835) ([ppalaga](https://github.com/ppalaga))
- Exclude .idea directory from license checks [\#1833](https://github.com/apache/camel-quarkus/pull/1833) ([jamesnetherton](https://github.com/jamesnetherton))
- Use distinct descriptions for the for the various JSON data formats [\#1832](https://github.com/apache/camel-quarkus/pull/1832) ([ppalaga](https://github.com/ppalaga))
- Atom native support [\#1831](https://github.com/apache/camel-quarkus/pull/1831) ([jamesnetherton](https://github.com/jamesnetherton))
- String template native support \#1694 [\#1828](https://github.com/apache/camel-quarkus/pull/1828) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Fix intermittent failure of AHC-WS itest [\#1827](https://github.com/apache/camel-quarkus/pull/1827) ([jamesnetherton](https://github.com/jamesnetherton))
- Remove redundant skip of maven-enforcer-plugin execution [\#1825](https://github.com/apache/camel-quarkus/pull/1825) ([jamesnetherton](https://github.com/jamesnetherton))
- OptaPlanner native support fixes \#1721 [\#1822](https://github.com/apache/camel-quarkus/pull/1822) ([zbendhiba](https://github.com/zbendhiba))
- Configure NativeImageResourceBuildItem for camel route classpath resources [\#1821](https://github.com/apache/camel-quarkus/pull/1821) ([jamesnetherton](https://github.com/jamesnetherton))
- Run verify for the docs module on the CI \#1819 [\#1820](https://github.com/apache/camel-quarkus/pull/1820) ([ppalaga](https://github.com/ppalaga))
- Improve mock backend logging [\#1818](https://github.com/apache/camel-quarkus/pull/1818) ([llowinge](https://github.com/llowinge))
- Camel quarkus disable auto route discovery not working [\#1817](https://github.com/apache/camel-quarkus/pull/1817) ([lburgazzoli](https://github.com/lburgazzoli))
- Use partials instead of pages for the individual Camel bits [\#1814](https://github.com/apache/camel-quarkus/pull/1814) ([ppalaga](https://github.com/ppalaga))
- Added UniVocity data formats native support \#1756 [\#1813](https://github.com/apache/camel-quarkus/pull/1813) ([aldettinger](https://github.com/aldettinger))
- Align guava & google-http-client versions with Quarkus [\#1811](https://github.com/apache/camel-quarkus/pull/1811) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade Quarkus to 1.8.1.Final [\#1809](https://github.com/apache/camel-quarkus/pull/1809) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix launch of camel main applications from IntelliJ [\#1808](https://github.com/apache/camel-quarkus/pull/1808) ([jamesnetherton](https://github.com/jamesnetherton))
- Velocity Support \#837 [\#1804](https://github.com/apache/camel-quarkus/pull/1804) ([JiriOndrusek](https://github.com/JiriOndrusek))
- feat\(ssh\): promoting native extension [\#1802](https://github.com/apache/camel-quarkus/pull/1802) ([squakez](https://github.com/squakez))
- Browse native support [\#1801](https://github.com/apache/camel-quarkus/pull/1801) ([jamesnetherton](https://github.com/jamesnetherton))
- gRPC native support [\#1797](https://github.com/apache/camel-quarkus/pull/1797) ([jamesnetherton](https://github.com/jamesnetherton))
- Remove UpdateDocExtensionsListMojo followup \#1777 [\#1794](https://github.com/apache/camel-quarkus/pull/1794) ([ppalaga](https://github.com/ppalaga))
- FOP native support \#1642 [\#1793](https://github.com/apache/camel-quarkus/pull/1793) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Added jing native support fixes \#1741 [\#1792](https://github.com/apache/camel-quarkus/pull/1792) ([aldettinger](https://github.com/aldettinger))
- Disruptor native support [\#1791](https://github.com/apache/camel-quarkus/pull/1791) ([lburgazzoli](https://github.com/lburgazzoli))
- Update camel-quarkus-last-release property to 1.1.0 [\#1789](https://github.com/apache/camel-quarkus/pull/1789) ([jamesnetherton](https://github.com/jamesnetherton))
- Document update [\#1788](https://github.com/apache/camel-quarkus/pull/1788) ([NiteshKoushik](https://github.com/NiteshKoushik))
- Switch from Gitter to Zulip [\#1787](https://github.com/apache/camel-quarkus/pull/1787) ([lburgazzoli](https://github.com/lburgazzoli))
- Exclude daily branch build bot generated issues from the changelog [\#1786](https://github.com/apache/camel-quarkus/pull/1786) ([jamesnetherton](https://github.com/jamesnetherton))
- Caffeine native support [\#1785](https://github.com/apache/camel-quarkus/pull/1785) ([lburgazzoli](https://github.com/lburgazzoli))
- Added automatic changelog gh action [\#1784](https://github.com/apache/camel-quarkus/pull/1784) ([oscerd](https://github.com/oscerd))
- Fix intermittent failures of SmallRyeReactiveMessagingIT [\#1780](https://github.com/apache/camel-quarkus/pull/1780) ([jamesnetherton](https://github.com/jamesnetherton))
- Wrong jira component version definition in camel-quarkus-bom \#1775 [\#1778](https://github.com/apache/camel-quarkus/pull/1778) ([ppalaga](https://github.com/ppalaga))
- Use asciidoctor-antora-indexer to produce lists of extensions [\#1777](https://github.com/apache/camel-quarkus/pull/1777) ([ppalaga](https://github.com/ppalaga))
- Upgrade to cq-maven-plugin 0.19.0, Make mvn -N cq:format remove empty… [\#1774](https://github.com/apache/camel-quarkus/pull/1774) ([ppalaga](https://github.com/ppalaga))
- Add some pre-release tasks to the release guide [\#1771](https://github.com/apache/camel-quarkus/pull/1771) ([jamesnetherton](https://github.com/jamesnetherton))
- camel-quarkus-main - Uses reflection for setting its name [\#1768](https://github.com/apache/camel-quarkus/pull/1768) ([lburgazzoli](https://github.com/lburgazzoli))
- Document cq:create -Dcq.nativeSupported=false for creating JVM-only e… [\#1767](https://github.com/apache/camel-quarkus/pull/1767) ([ppalaga](https://github.com/ppalaga))
- Quarkus 1.8.0.final [\#1766](https://github.com/apache/camel-quarkus/pull/1766) ([jamesnetherton](https://github.com/jamesnetherton))
- Added ssl authentation to the nats extensions [\#1764](https://github.com/apache/camel-quarkus/pull/1764) ([aldettinger](https://github.com/aldettinger))
- Test for \#1497 xml-io should pass namespace info to NamespaceAware [\#1760](https://github.com/apache/camel-quarkus/pull/1760) ([ppalaga](https://github.com/ppalaga))
- AWS2-Lambda Extension: Adding interceptors and align to the other ext… [\#1758](https://github.com/apache/camel-quarkus/pull/1758) ([oscerd](https://github.com/oscerd))
- JGroups, JGroups raft, HL7 Terser, Syslog, JSonApi, ASN.1 File, Barcode, BeanIO, CBOR, JSon Fastjson, uniVocity, Freemarker JVM support [\#1757](https://github.com/apache/camel-quarkus/pull/1757) ([ppalaga](https://github.com/ppalaga))
- Aws2 sts [\#1745](https://github.com/apache/camel-quarkus/pull/1745) ([oscerd](https://github.com/oscerd))
- Management JVM support [\#1744](https://github.com/apache/camel-quarkus/pull/1744) ([jamesnetherton](https://github.com/jamesnetherton))
- JT400, JSLT, Jing, JCR, JClouds JVM support [\#1743](https://github.com/apache/camel-quarkus/pull/1743) ([ppalaga](https://github.com/ppalaga))
- Enhance Github itest with configurable credentials [\#1738](https://github.com/apache/camel-quarkus/pull/1738) ([llowinge](https://github.com/llowinge))
- MLLP, Milo, Lumberjack, Lucene, LDIF, LDAP, Language JVM support [\#1736](https://github.com/apache/camel-quarkus/pull/1736) ([ppalaga](https://github.com/ppalaga))
- Promote AWS 2 Lambda to native [\#1730](https://github.com/apache/camel-quarkus/pull/1730) ([Jeansen](https://github.com/Jeansen))
- SSH, Nagios, MyBatis, MVEL and MSV JVM support [\#1729](https://github.com/apache/camel-quarkus/pull/1729) ([ppalaga](https://github.com/ppalaga))
- Printer, PostgresSQL Event, PostgresSQL Replication Slot, OptaPlanner and NSQ JVM support [\#1724](https://github.com/apache/camel-quarkus/pull/1724) ([ppalaga](https://github.com/ppalaga))
- Fixed bean parameter bindings using language annotations in native mo… [\#1716](https://github.com/apache/camel-quarkus/pull/1716) ([aldettinger](https://github.com/aldettinger))
- Weather native support fixes \#1631 [\#1715](https://github.com/apache/camel-quarkus/pull/1715) ([zbendhiba](https://github.com/zbendhiba))
- XQuery, Saga, RSS, Robot Framework and QuickFix JVM support [\#1713](https://github.com/apache/camel-quarkus/pull/1713) ([ppalaga](https://github.com/ppalaga))
- Soroush, Solr, SNMP, SMPP, SIP, and Schematron JVM support [\#1708](https://github.com/apache/camel-quarkus/pull/1708) ([ppalaga](https://github.com/ppalaga))
- Upgrade to cq-maven-plugin 0.18.1 [\#1700](https://github.com/apache/camel-quarkus/pull/1700) ([ppalaga](https://github.com/ppalaga))
- String Template, Stomp, StAX, Splunk HEC and Splunk JVM support [\#1699](https://github.com/apache/camel-quarkus/pull/1699) ([ppalaga](https://github.com/ppalaga))
- Dropbox native support [\#1693](https://github.com/apache/camel-quarkus/pull/1693) ([jamesnetherton](https://github.com/jamesnetherton))
- Speedup the initial CI mvn install by adding -T1C [\#1692](https://github.com/apache/camel-quarkus/pull/1692) ([ppalaga](https://github.com/ppalaga))
- Remove camel 3.5.0 staging repositories [\#1690](https://github.com/apache/camel-quarkus/pull/1690) ([jamesnetherton](https://github.com/jamesnetherton))
- Replace mvnd.builder.rules with virtual dependencies [\#1689](https://github.com/apache/camel-quarkus/pull/1689) ([ppalaga](https://github.com/ppalaga))
- Feat\(mongodb\): add support for named client [\#1688](https://github.com/apache/camel-quarkus/pull/1688) ([squakez](https://github.com/squakez))
- Move FastUuidGenerator to Camel [\#1683](https://github.com/apache/camel-quarkus/pull/1683) ([lburgazzoli](https://github.com/lburgazzoli))
- Align dependencies with latest camel & quarkus releases [\#1682](https://github.com/apache/camel-quarkus/pull/1682) ([jamesnetherton](https://github.com/jamesnetherton))
- Add vertx-websocket component extension [\#1681](https://github.com/apache/camel-quarkus/pull/1681) ([jamesnetherton](https://github.com/jamesnetherton))
- Add integration tests for the camel-quarkus-kotlin extension [\#1679](https://github.com/apache/camel-quarkus/pull/1679) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade to Quarkus 1.8.0.CR1 [\#1678](https://github.com/apache/camel-quarkus/pull/1678) ([jamesnetherton](https://github.com/jamesnetherton))
- Remove UnbannedReflectiveBuildItem [\#1677](https://github.com/apache/camel-quarkus/pull/1677) ([jamesnetherton](https://github.com/jamesnetherton))
- Added nats native support fixes \#1578 [\#1674](https://github.com/apache/camel-quarkus/pull/1674) ([aldettinger](https://github.com/aldettinger))
- Add vertx-http component extension [\#1673](https://github.com/apache/camel-quarkus/pull/1673) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix Google gmail itest to wait for deletion of mail [\#1671](https://github.com/apache/camel-quarkus/pull/1671) ([llowinge](https://github.com/llowinge))
- Upgrade to Camel 3.5.0 [\#1670](https://github.com/apache/camel-quarkus/pull/1670) ([ppalaga](https://github.com/ppalaga))
- Add some logging to debug \#1632 [\#1668](https://github.com/apache/camel-quarkus/pull/1668) ([jamesnetherton](https://github.com/jamesnetherton))
- Register missing Camel quartz job classes for reflection [\#1665](https://github.com/apache/camel-quarkus/pull/1665) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix Twitter itest to wait for latest sent message [\#1660](https://github.com/apache/camel-quarkus/pull/1660) ([llowinge](https://github.com/llowinge))
- Hipchat, IEC 60870, Ignite, IOTA and JBPM JVM support [\#1657](https://github.com/apache/camel-quarkus/pull/1657) ([ppalaga](https://github.com/ppalaga))
- Re-ballance test-categories.yaml once again [\#1655](https://github.com/apache/camel-quarkus/pull/1655) ([ppalaga](https://github.com/ppalaga))
- More CI tweaks [\#1651](https://github.com/apache/camel-quarkus/pull/1651) ([ppalaga](https://github.com/ppalaga))
- HDFS, hazelcast, Guava EventBus, Geocoder and Ganglia JVM support [\#1650](https://github.com/apache/camel-quarkus/pull/1650) ([ppalaga](https://github.com/ppalaga))
- FOP, Flink, Facebook, ElSQL and Ehcache JVM support [\#1643](https://github.com/apache/camel-quarkus/pull/1643) ([ppalaga](https://github.com/ppalaga))
- Weather, Velocity, Twilio, Thrift and Stub JVM support [\#1636](https://github.com/apache/camel-quarkus/pull/1636) ([ppalaga](https://github.com/ppalaga))
- XChange, Workday, Wordpress, Weka and Web3j JVM support [\#1629](https://github.com/apache/camel-quarkus/pull/1629) ([ppalaga](https://github.com/ppalaga))
- Upgrade Quarkus to 1.7.1.Final [\#1628](https://github.com/apache/camel-quarkus/pull/1628) ([jamesnetherton](https://github.com/jamesnetherton))
- Add IPFS, IRC & JSch JVM only extensions [\#1627](https://github.com/apache/camel-quarkus/pull/1627) ([jamesnetherton](https://github.com/jamesnetherton))
- CI definition tweaks [\#1624](https://github.com/apache/camel-quarkus/pull/1624) ([ppalaga](https://github.com/ppalaga))
- ZooKeeper, ZooKeeper Master, Zendesk, Yammer, XSLT Saxon, XMPP, XML Security and XJ JVM support [\#1618](https://github.com/apache/camel-quarkus/pull/1618) ([ppalaga](https://github.com/ppalaga))
- Fix JAXB dependency alignment issues [\#1609](https://github.com/apache/camel-quarkus/pull/1609) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#1602 Speed up the CI [\#1606](https://github.com/apache/camel-quarkus/pull/1606) ([ppalaga](https://github.com/ppalaga))
- Send unique messages in Slack itest to avoid false positive tests [\#1604](https://github.com/apache/camel-quarkus/pull/1604) ([llowinge](https://github.com/llowinge))
- Upgrade to cq-maven-plugin 0.17.0, sanitize model.name when using it as [\#1603](https://github.com/apache/camel-quarkus/pull/1603) ([ppalaga](https://github.com/ppalaga))
- Crypto \(JCE\), DigitalOcean, Disruptor, Deep Java Library and Drill JVM support [\#1600](https://github.com/apache/camel-quarkus/pull/1600) ([ppalaga](https://github.com/ppalaga))
- Fix servicenow itest to clean resources [\#1596](https://github.com/apache/camel-quarkus/pull/1596) ([llowinge](https://github.com/llowinge))
- Add DNS, etcd & plusar JVM only extensions [\#1595](https://github.com/apache/camel-quarkus/pull/1595) ([jamesnetherton](https://github.com/jamesnetherton))
-  CM SMS Gateway, CMIS, CoAP, CometD and Corda JVM support [\#1590](https://github.com/apache/camel-quarkus/pull/1590) ([ppalaga](https://github.com/ppalaga))
- Bonita, Beanstalk, Caffeine, ChatScript and Chunk JVM support [\#1585](https://github.com/apache/camel-quarkus/pull/1585) ([ppalaga](https://github.com/ppalaga))
- Improve docs [\#1579](https://github.com/apache/camel-quarkus/pull/1579) ([ppalaga](https://github.com/ppalaga))
- Add Dropbox, jOOQ & NATS JVM support [\#1576](https://github.com/apache/camel-quarkus/pull/1576) ([jamesnetherton](https://github.com/jamesnetherton))
- Clean google drive in google sheets itest [\#1575](https://github.com/apache/camel-quarkus/pull/1575) ([llowinge](https://github.com/llowinge))
- Atomix, AWS 2 Kinesis, AWS 2 Lambda, Azure Storage Blob and Azure Storage Queue JVM support [\#1569](https://github.com/apache/camel-quarkus/pull/1569) ([ppalaga](https://github.com/ppalaga))
- Added flatpack component support \#1541 [\#1568](https://github.com/apache/camel-quarkus/pull/1568) ([aldettinger](https://github.com/aldettinger))
- RabbitMQ native extension [\#1567](https://github.com/apache/camel-quarkus/pull/1567) ([Jeansen](https://github.com/Jeansen))
- Tests for \#1563 contextPath ignored for platform-http with REST DSL [\#1565](https://github.com/apache/camel-quarkus/pull/1565) ([ppalaga](https://github.com/ppalaga))
- Fix itest when Twitter acount have spaces in name [\#1562](https://github.com/apache/camel-quarkus/pull/1562) ([llowinge](https://github.com/llowinge))
- APNS, Asterisk and Atom JVM support [\#1559](https://github.com/apache/camel-quarkus/pull/1559) ([ppalaga](https://github.com/ppalaga))
- Update mvnd rules and split their entries by newlines where merge con… [\#1555](https://github.com/apache/camel-quarkus/pull/1555) ([ppalaga](https://github.com/ppalaga))
- Fix telegram itest component property resolution [\#1554](https://github.com/apache/camel-quarkus/pull/1554) ([llowinge](https://github.com/llowinge))
- Compute the component counts using JavaScript to avoid merge conflicts [\#1552](https://github.com/apache/camel-quarkus/pull/1552) ([ppalaga](https://github.com/ppalaga))
- Document snapshot builds in CI docs [\#1551](https://github.com/apache/camel-quarkus/pull/1551) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#765 Git support [\#1548](https://github.com/apache/camel-quarkus/pull/1548) ([ppalaga](https://github.com/ppalaga))
- Publish SNAPSHOT builds [\#1547](https://github.com/apache/camel-quarkus/pull/1547) ([jamesnetherton](https://github.com/jamesnetherton))
- Use proper extension page URLs in quarkus-extension.yaml [\#1546](https://github.com/apache/camel-quarkus/pull/1546) ([ppalaga](https://github.com/ppalaga))
- update create new extension guide : add update of test-categories.yaml [\#1544](https://github.com/apache/camel-quarkus/pull/1544) ([zbendhiba](https://github.com/zbendhiba))
- Add missing netty dependencies to olingo4 extension [\#1543](https://github.com/apache/camel-quarkus/pull/1543) ([jamesnetherton](https://github.com/jamesnetherton))
- Added support for flatpack dataformat fixes \#796 [\#1542](https://github.com/apache/camel-quarkus/pull/1542) ([aldettinger](https://github.com/aldettinger))
- Switch from restcountries.eu to estcountries.com as the .eu service is not reliable anymore [\#1539](https://github.com/apache/camel-quarkus/pull/1539) ([lburgazzoli](https://github.com/lburgazzoli))
- Fixup c11d8da9 Let the list of extensions page show extensions [\#1537](https://github.com/apache/camel-quarkus/pull/1537) ([ppalaga](https://github.com/ppalaga))
- chore\(build\): configure ci to run on release rbanches [\#1536](https://github.com/apache/camel-quarkus/pull/1536) ([lburgazzoli](https://github.com/lburgazzoli))
- Let the list of extensions page show extensions, move list of supported [\#1534](https://github.com/apache/camel-quarkus/pull/1534) ([ppalaga](https://github.com/ppalaga))
- Avoid purging artifacts for builds that may be in progress [\#1529](https://github.com/apache/camel-quarkus/pull/1529) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgarde to camel v3.4.3 [\#1527](https://github.com/apache/camel-quarkus/pull/1527) ([lburgazzoli](https://github.com/lburgazzoli))
- Fixed the VerifyError in the health example fixes \#1517 [\#1525](https://github.com/apache/camel-quarkus/pull/1525) ([aldettinger](https://github.com/aldettinger))
- 1.0.0 post release cleanup [\#1524](https://github.com/apache/camel-quarkus/pull/1524) ([ppalaga](https://github.com/ppalaga))
- Upgrade Quarkus Qpid JMS to 0.17.0 [\#1521](https://github.com/apache/camel-quarkus/pull/1521) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade to Quarkus 1.7.0.Final [\#1520](https://github.com/apache/camel-quarkus/pull/1520) ([jamesnetherton](https://github.com/jamesnetherton))
- Disable merge commits on pull requests [\#1519](https://github.com/apache/camel-quarkus/pull/1519) ([jamesnetherton](https://github.com/jamesnetherton))
- Simplify component configuration for box and fhir itests [\#1518](https://github.com/apache/camel-quarkus/pull/1518) ([jamesnetherton](https://github.com/jamesnetherton))
- Add missing camel-quarkus-main dependency to braintree & twitter itests [\#1516](https://github.com/apache/camel-quarkus/pull/1516) ([jamesnetherton](https://github.com/jamesnetherton))
- Completed bean itests with an @InjectMock test [\#1515](https://github.com/apache/camel-quarkus/pull/1515) ([aldettinger](https://github.com/aldettinger))
- Add extension for smallrye-reactive-messaging-camel [\#1514](https://github.com/apache/camel-quarkus/pull/1514) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade to Quarkus 1.7.0.CR2 [\#1513](https://github.com/apache/camel-quarkus/pull/1513) ([jamesnetherton](https://github.com/jamesnetherton))
- Add master extension [\#1511](https://github.com/apache/camel-quarkus/pull/1511) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade to Quarkus 1.7.0.CR1 [\#1508](https://github.com/apache/camel-quarkus/pull/1508) ([ppalaga](https://github.com/ppalaga))
- Added grok support \#1466 [\#1504](https://github.com/apache/camel-quarkus/pull/1504) ([aldettinger](https://github.com/aldettinger))
- Fixup \#1244 Improve the docs about the default REST transport provider [\#1503](https://github.com/apache/camel-quarkus/pull/1503) ([ppalaga](https://github.com/ppalaga))
- Remove service exclude for ThreadPoolProfileConfigurationProperties [\#1499](https://github.com/apache/camel-quarkus/pull/1499) ([jamesnetherton](https://github.com/jamesnetherton))
- Correct bind type for OpenTracingTracer bean [\#1498](https://github.com/apache/camel-quarkus/pull/1498) ([jamesnetherton](https://github.com/jamesnetherton))
- Make camel-quarkus-rest depend on camel-quarkus-platform-http [\#1496](https://github.com/apache/camel-quarkus/pull/1496) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade to Camel 3.4.2 [\#1492](https://github.com/apache/camel-quarkus/pull/1492) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade Quarkus to 1.6.1.Final [\#1489](https://github.com/apache/camel-quarkus/pull/1489) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#1286 Pass deprecation info to quarkus-extension.yaml [\#1485](https://github.com/apache/camel-quarkus/pull/1485) ([ppalaga](https://github.com/ppalaga))
- Upgrade to Apache Camel 3.4.1 [\#1484](https://github.com/apache/camel-quarkus/pull/1484) ([lburgazzoli](https://github.com/lburgazzoli))
- Fixup \#1468 Intermittent failure of CamelDevModeTest [\#1483](https://github.com/apache/camel-quarkus/pull/1483) ([ppalaga](https://github.com/ppalaga))
- Fix \#1426 Dependency parity checks are now done by Quarkus extension-descriptor mojo [\#1481](https://github.com/apache/camel-quarkus/pull/1481) ([ppalaga](https://github.com/ppalaga))
- Fixup \#1448 Add delay=-1&repeatCount=1 to the command mode test route… [\#1480](https://github.com/apache/camel-quarkus/pull/1480) ([ppalaga](https://github.com/ppalaga))
- Use java.home system property in TrustStoreResource [\#1479](https://github.com/apache/camel-quarkus/pull/1479) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#1448 Add an integration test for the command mode [\#1477](https://github.com/apache/camel-quarkus/pull/1477) ([ppalaga](https://github.com/ppalaga))
- Fix \#1468 Intermittent failure of CamelDevModeTest [\#1473](https://github.com/apache/camel-quarkus/pull/1473) ([ppalaga](https://github.com/ppalaga))
- Add JPA extension [\#1467](https://github.com/apache/camel-quarkus/pull/1467) ([jamesnetherton](https://github.com/jamesnetherton))
- Reproducer for \#1459 [\#1465](https://github.com/apache/camel-quarkus/pull/1465) ([lburgazzoli](https://github.com/lburgazzoli))
- improve bootstrap and configuration documentation [\#1464](https://github.com/apache/camel-quarkus/pull/1464) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix issues with building from the source release zip [\#1463](https://github.com/apache/camel-quarkus/pull/1463) ([jamesnetherton](https://github.com/jamesnetherton))
- Add example about how to use @Handler with beans registered to the Camel Context [\#1461](https://github.com/apache/camel-quarkus/pull/1461) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1455 Exclude the node directory from src kit [\#1458](https://github.com/apache/camel-quarkus/pull/1458) ([WillemJiang](https://github.com/WillemJiang))
- Fix \#1428 to add the usage.adoc [\#1457](https://github.com/apache/camel-quarkus/pull/1457) ([zhfeng](https://github.com/zhfeng))
- org.apache.camel.quarkus.main.CamelMainApplication should be registered for reflection [\#1454](https://github.com/apache/camel-quarkus/pull/1454) ([lburgazzoli](https://github.com/lburgazzoli))
- Document how to use mock in JVM mode tests \#1449 [\#1452](https://github.com/apache/camel-quarkus/pull/1452) ([JiriOndrusek](https://github.com/JiriOndrusek))

## [2.1.0](https://github.com/apache/camel-quarkus/tree/2.1.0) (2021-07-23)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/2.0.0...2.1.0)

**Fixed bugs:**

- Cannot re-process old Kafka messages because of Quarkus overriding the group.id [\#2901](https://github.com/apache/camel-quarkus/issues/2901)

**Closed issues:**

- can't build camel-fhir extension native image [\#2906](https://github.com/apache/camel-quarkus/issues/2906)
- Revise DefaultExchangeHolder [\#2905](https://github.com/apache/camel-quarkus/issues/2905)
- openapi-java failure when building native-image [\#2892](https://github.com/apache/camel-quarkus/issues/2892)
- camel-quarkus-kafka : Kafka oauth authentication issue with kafka-oauth-client 0.8.x versions [\#2878](https://github.com/apache/camel-quarkus/issues/2878)
- Combine build sanity checks into a single script [\#2869](https://github.com/apache/camel-quarkus/issues/2869)
- string-template:bean Bean Injection:  camel quarkus cannot find resource error [\#2849](https://github.com/apache/camel-quarkus/issues/2849)
- Document the need of @RegisterForReflection in Bean doc [\#2844](https://github.com/apache/camel-quarkus/issues/2844)
- InfinispanTest failed on Mac [\#2840](https://github.com/apache/camel-quarkus/issues/2840)
- add affinity dependency in a mac profile for camel-hazelcast extension [\#2800](https://github.com/apache/camel-quarkus/issues/2800)
- Intermittent failure of testJmsTransaction  [\#2767](https://github.com/apache/camel-quarkus/issues/2767)
- Automatic check to ensure that camel.quarkus.jvmSince and camel.quarkus.nativeSince are not newer than the current SNAPSHOT [\#2763](https://github.com/apache/camel-quarkus/issues/2763)
- \[elastic-search\] Test both camel and quarkus configuration of underlying component quarkus client [\#2714](https://github.com/apache/camel-quarkus/issues/2714)
- Test both camel and quarkus configuration of underlying component quarkus client [\#2712](https://github.com/apache/camel-quarkus/issues/2712)
- Split with AggregationStrategy [\#2690](https://github.com/apache/camel-quarkus/issues/2690)
- No consumers available on endpoint [\#2632](https://github.com/apache/camel-quarkus/issues/2632)
- Autowiring of beans can cause warning and problem "bean was marked as unused and removed during build" [\#2519](https://github.com/apache/camel-quarkus/issues/2519)
- \[Serialization\] transferException URI option does not work in native mode [\#1868](https://github.com/apache/camel-quarkus/issues/1868)
- Turn off bean removal by ArC  [\#1387](https://github.com/apache/camel-quarkus/issues/1387)
- js-dsl integration test failure [\#2908](https://github.com/apache/camel-quarkus/issues/2908)
- kudu: remove the useless test harness logic dedicated to Java 8 [\#2885](https://github.com/apache/camel-quarkus/issues/2885)
- Avoid producing `FeatureBuildItem` in support extensions [\#2873](https://github.com/apache/camel-quarkus/issues/2873)
- Promote tags to GitHub releases [\#2864](https://github.com/apache/camel-quarkus/issues/2864)
- Give some guidance to end users which messaging extensions they should use in which situation [\#2856](https://github.com/apache/camel-quarkus/issues/2856)
- \[Quarkus 2.1\] Remove reflective class registration for `ScramSaslClientFactory` [\#2850](https://github.com/apache/camel-quarkus/issues/2850)
- Remove `quarkus.camel.sql.script-files` configuration property [\#2823](https://github.com/apache/camel-quarkus/issues/2823)
- Leverage catalog metadata to discover unremovable bean types [\#2822](https://github.com/apache/camel-quarkus/issues/2822)
- Update the Command mode docs page [\#2782](https://github.com/apache/camel-quarkus/issues/2782)
- Test camel.faulttolerance.\* set of properties [\#2780](https://github.com/apache/camel-quarkus/issues/2780)
- Refactor registration of serialization once support is present in Quarkus [\#2755](https://github.com/apache/camel-quarkus/issues/2755)
- Add Kamelet example [\#2731](https://github.com/apache/camel-quarkus/issues/2731)
- camel-quarkus-minio: "quarkus.minio.url" is mandatory and must be a valid url [\#2721](https://github.com/apache/camel-quarkus/issues/2721)
- Revisit user guide testing page [\#2679](https://github.com/apache/camel-quarkus/issues/2679)
- Salesforce : Mock existing tests [\#2667](https://github.com/apache/camel-quarkus/issues/2667)
- Class loader issues in AvroRpcTest with Quarkus 2.0.0.Alpha3 [\#2651](https://github.com/apache/camel-quarkus/issues/2651)
- Expand Netty test coverage [\#2636](https://github.com/apache/camel-quarkus/issues/2636)
- Add camel-kamelet extension example [\#2630](https://github.com/apache/camel-quarkus/issues/2630)
- Support JMS ObjectMessage [\#2599](https://github.com/apache/camel-quarkus/issues/2599)
- Document the options for configuring the ElasticSearch REST client [\#2502](https://github.com/apache/camel-quarkus/issues/2502)
- Nitrite - follow up - simplify serialization configuration [\#2255](https://github.com/apache/camel-quarkus/issues/2255)
- OpenTelemetry support [\#2084](https://github.com/apache/camel-quarkus/issues/2084)
- Investigate replacing bouncycastle support extension with Quarkus bouncycastle  [\#2005](https://github.com/apache/camel-quarkus/issues/2005)

## [2.0.0](https://github.com/apache/camel-quarkus/tree/2.0.0) (2021-06-25)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/2.0.0-M2...2.0.0)

**Implemented enhancements:**

- Native support for kamelet.yaml discovery [\#2733](https://github.com/apache/camel-quarkus/issues/2733)

**Fixed bugs:**

- Camel jira throws in native mode java.lang.ClassNotFoundException: org.glassfish.jersey.internal.RuntimeDelegateImpl [\#2650](https://github.com/apache/camel-quarkus/issues/2650)

**Closed issues:**

- onException in xml dsl [\#2842](https://github.com/apache/camel-quarkus/issues/2842)
- Add a section about mocking remote endpoints to Testing page of user guide [\#2834](https://github.com/apache/camel-quarkus/issues/2834)
- Salesforce native integration tests throw CNFE for `java.io.InputStream` [\#2831](https://github.com/apache/camel-quarkus/issues/2831)
- Ability to retrieve traceId for observability in routes [\#2802](https://github.com/apache/camel-quarkus/issues/2802)
- Unable to determine the status of the running process in TimerIT without resteasy [\#2772](https://github.com/apache/camel-quarkus/issues/2772)
- Solr test doesn't work on RHEL 8 [\#2766](https://github.com/apache/camel-quarkus/issues/2766)
- Fix JSON Jackson jacksonConversionPojo test [\#2726](https://github.com/apache/camel-quarkus/issues/2726)
- cassandra-driver-core 3.5.0 managed in Debezium BOM too old for testcontainers 1.15.3 [\#2724](https://github.com/apache/camel-quarkus/issues/2724)
- hazelcast integration-test failed in native mode\(On Mac\) [\#2719](https://github.com/apache/camel-quarkus/issues/2719)
- camel-kamelet-reify native support [\#2617](https://github.com/apache/camel-quarkus/issues/2617)
- Add a section about testing to the Contributor guide [\#2607](https://github.com/apache/camel-quarkus/issues/2607)
- Salesforce fails to start because loginUrl configuration is ignored [\#2499](https://github.com/apache/camel-quarkus/issues/2499)
- Use in an example: autowiring of beans available in the CDI container to CamelContext and components [\#2351](https://github.com/apache/camel-quarkus/issues/2351)
- Let quarkus-google-cloud-services or com.google.cloud:libraries-bom align opencensus, perfmark & Co. [\#2816](https://github.com/apache/camel-quarkus/issues/2816)
- Manage Groovy dependencies with `groovy-bom` import [\#2812](https://github.com/apache/camel-quarkus/issues/2812)
- CNFE MapperResultProducerService when com.datastax.oss:java-driver-mapper-runtime is not in the class path [\#2801](https://github.com/apache/camel-quarkus/issues/2801)
- Expand HTTP extension test coverage [\#2794](https://github.com/apache/camel-quarkus/issues/2794)
- camel-quarkus-http doesn't build native image - Random/SplittableRandom [\#2793](https://github.com/apache/camel-quarkus/issues/2793)
- Expand jsonpath test coverage [\#2783](https://github.com/apache/camel-quarkus/issues/2783)
- Test camel.threadpool.\* set of properties [\#2781](https://github.com/apache/camel-quarkus/issues/2781)
- Test specifying custom beans in application.properties [\#2778](https://github.com/apache/camel-quarkus/issues/2778)
- camel.main.dump-routes = true does not work [\#2761](https://github.com/apache/camel-quarkus/issues/2761)
- Avoid duplicating code in `org.apache.camel.quarkus.core.BaseModel` [\#2752](https://github.com/apache/camel-quarkus/issues/2752)
- kubernetes integration-test failure in native mode [\#2730](https://github.com/apache/camel-quarkus/issues/2730)
- Use EmbeddedActiveMQ in messaging and jta integration tests  [\#2727](https://github.com/apache/camel-quarkus/issues/2727)
- \[infinispan\] Test both camel and quarkus configuration of underlying component quarkus client [\#2713](https://github.com/apache/camel-quarkus/issues/2713)
- Register all @JsonView array elements for reflection [\#2708](https://github.com/apache/camel-quarkus/issues/2708)
- demonstrate how to configure quarkus-jackson extension's own ObjectMapper instance and reuse it in our jackson test [\#2706](https://github.com/apache/camel-quarkus/issues/2706)
- \[Camel 3.11\] Remove vertx-http itest SSL workaround [\#2704](https://github.com/apache/camel-quarkus/issues/2704)
- Expand Saxon test coverage with xpath saxon tests [\#2702](https://github.com/apache/camel-quarkus/issues/2702)
- \[Camel 3.11\] ThreadPoolBulkhead not available in smallrye-fault-tolerance 5.1.0 [\#2696](https://github.com/apache/camel-quarkus/issues/2696)
- Debezium: Unresolved type during parsing: org.eclipse.jetty.util.StringUtil  [\#2695](https://github.com/apache/camel-quarkus/issues/2695)
- Sql aggregator does not work in native mode, solve DefaultExchangeHolder globally. [\#2693](https://github.com/apache/camel-quarkus/issues/2693)
- Unmanage unnecessary google dependencies  [\#2689](https://github.com/apache/camel-quarkus/issues/2689)
- Problem with dashed queryParams [\#2685](https://github.com/apache/camel-quarkus/issues/2685)
- camel-quarkus-jacksonxml:JsonView annotations take no effect in native mode [\#2681](https://github.com/apache/camel-quarkus/issues/2681)
- Intermittent failures in MllpIT  [\#2671](https://github.com/apache/camel-quarkus/issues/2671)
- AWS2 test: org.apache.log4j.Priority required via netty, although netty should not be in the class path at all  [\#2670](https://github.com/apache/camel-quarkus/issues/2670)
- Adapt Observability docs page to Quarkus 2.0.0 [\#2659](https://github.com/apache/camel-quarkus/issues/2659)
- Solr test fails during native compilation after upgrade to Camel 3.10.0 and Quarkus 2.0.0.Alpha3 [\#2657](https://github.com/apache/camel-quarkus/issues/2657)
- vert-x http client failing for HTTPS with Quarkus 2.0.0.Alpha3 [\#2656](https://github.com/apache/camel-quarkus/issues/2656)
- kamelet extension: add test for kamelet discovery mechanism [\#2652](https://github.com/apache/camel-quarkus/issues/2652)
- Test moving and deleting files on an FTP server [\#2645](https://github.com/apache/camel-quarkus/issues/2645)
- jackson: add test coverage [\#2634](https://github.com/apache/camel-quarkus/issues/2634)
- jacksonxml: add test coverage [\#2633](https://github.com/apache/camel-quarkus/issues/2633)
- Kafka - add Kafka Idempotent repository test [\#2626](https://github.com/apache/camel-quarkus/issues/2626)
- Expand Sql test coverage [\#2623](https://github.com/apache/camel-quarkus/issues/2623)
- Reinstate camel integration tests to the Quarkus Platform nightly SNAPSHOT build [\#2621](https://github.com/apache/camel-quarkus/issues/2621)
- \[camel 3.10\] load selected list of kamelets definitions at build time [\#2618](https://github.com/apache/camel-quarkus/issues/2618)
- camel-jackson-protobuf data format native support [\#2615](https://github.com/apache/camel-quarkus/issues/2615)
- camel-jackson-avro data format native support [\#2610](https://github.com/apache/camel-quarkus/issues/2610)
- \[camel 3.10\] Test setting MLLP default charset from system property for native mode [\#2554](https://github.com/apache/camel-quarkus/issues/2554)
- \[Quarkus 2.0\] Consider following the way how Quarkus handles Avro schemas [\#2513](https://github.com/apache/camel-quarkus/issues/2513)
- \[Camel 3.10\] Improve KafkaClientFactory integration [\#2486](https://github.com/apache/camel-quarkus/issues/2486)
- \[Camel 3.10\] jsonpath: Getting rid of json-smart as explicit and transitive dependency [\#2435](https://github.com/apache/camel-quarkus/issues/2435)
- Remove camel-quarkus-main [\#2391](https://github.com/apache/camel-quarkus/issues/2391)
- Test LRA extension with the latest Narayana LRA coordinator [\#2285](https://github.com/apache/camel-quarkus/issues/2285)
- Upgrading to Jackson 2.12.1 via Quarkus BOM 1.12 breaks Azure SDK v12 extensions  [\#2207](https://github.com/apache/camel-quarkus/issues/2207)
- Replace quarkus.camel.native.resources.\* with quarkus.native.resources.\* [\#988](https://github.com/apache/camel-quarkus/issues/988)

## [2.0.0-M2](https://github.com/apache/camel-quarkus/tree/2.0.0-M2) (2021-06-10)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/2.0.0-M1...2.0.0-M2)

**Closed issues:**

- Error when using Camel Kinesis component - java.lang.ClassNotFoundException: org.apache.commons.logging.LogFactory [\#2666](https://github.com/apache/camel-quarkus/issues/2666)
- Native compilation issues on GraalVM 21.1 [\#2653](https://github.com/apache/camel-quarkus/issues/2653)
- CamelKafkaTest fails intermittently on the CI [\#2461](https://github.com/apache/camel-quarkus/issues/2461)
- Quarkus Oracle Jdbc Issue NativeMode [\#2448](https://github.com/apache/camel-quarkus/issues/2448)
- Optaplanner native integration tests fail with Quarkus 1.12 [\#2205](https://github.com/apache/camel-quarkus/issues/2205)
- Mocking ProducerTemplate [\#2067](https://github.com/apache/camel-quarkus/issues/2067)
- Debezium-mongodb - observe issue DBZ-2831, which blocks integration tests. [\#2060](https://github.com/apache/camel-quarkus/issues/2060)
- aws kinesis: De-aggregate producer side aggregated msgs [\#2023](https://github.com/apache/camel-quarkus/issues/2023)
- AWS properties not picked up [\#1871](https://github.com/apache/camel-quarkus/issues/1871)
- Investigate intermittent build failures due to port conflicts [\#1370](https://github.com/apache/camel-quarkus/issues/1370)
- Kafka and Strimzi examples [\#1028](https://github.com/apache/camel-quarkus/issues/1028)
- Ugly re-formatted code [\#444](https://github.com/apache/camel-quarkus/issues/444)
- Do not include the source XSLT files into the application archive [\#438](https://github.com/apache/camel-quarkus/issues/438)
- Consider importing camel-bom in camel-quarkus-bom [\#159](https://github.com/apache/camel-quarkus/issues/159)
- Intermittent failures in Aws2SqsSnsIT [\#2741](https://github.com/apache/camel-quarkus/issues/2741)
- Unable to determine the status of the running process in LogIT without resteasy [\#2737](https://github.com/apache/camel-quarkus/issues/2737)
- Resume release command needs to be performed from target/checkout directory [\#2736](https://github.com/apache/camel-quarkus/issues/2736)
- Kafka SASL tests fail after the upgrade to Quarkus 2.0.0.CR3 [\#2729](https://github.com/apache/camel-quarkus/issues/2729)
- camel-quarkus-example : dev mode issue [\#2723](https://github.com/apache/camel-quarkus/issues/2723)
- Add missing use cases into MongoDb test coverage [\#2715](https://github.com/apache/camel-quarkus/issues/2715)
- \[camel-quarkus-examples\] HealthTest/TimerLogMainTest/ObservabilityTest failure on camel-quarkus-main branch [\#2711](https://github.com/apache/camel-quarkus/issues/2711)
- Fix Qute component metadata in Camel Quarkus catalog [\#2701](https://github.com/apache/camel-quarkus/issues/2701)
- \[Quarkus 2.0.0.CR3\] ClassNotFoundException: com.aayushatharva.brotli4j.decoder.DecoderJNI$Wrapper in Google Storage, PubSub and BigQuery test [\#2692](https://github.com/apache/camel-quarkus/issues/2692)
- Error when using camel-quarkus-jackson in native mode: java.lang.ClassNotFoundException: com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule [\#2677](https://github.com/apache/camel-quarkus/issues/2677)
- GraalVM 21.1 in CryptoIT: Trying to verify a provider that was not registered at build time: BC version 1.68 [\#2673](https://github.com/apache/camel-quarkus/issues/2673)
- camel-quarkus-master-integration-test failing after the upgrade to Camel 3.10.0 and Quarkus 2.0.0.Alpha3 [\#2660](https://github.com/apache/camel-quarkus/issues/2660)
- Intermittent failures in MongoDbTest.testTailingConsumer\(\) and MongoDbTest.testPersistentTailingConsumer\(\) [\#2658](https://github.com/apache/camel-quarkus/issues/2658)
- Unregister MongoDb's ChangeStreamDocument from reflection once it is provided by Quarkus [\#2649](https://github.com/apache/camel-quarkus/issues/2649)
- \[Quarkus 2.0.0.CR1\] Stop managing kotlinx-coroutines-core once we get it managed from Quarkus [\#2646](https://github.com/apache/camel-quarkus/issues/2646)
- Messaging integration test for JMS topics is not working [\#2608](https://github.com/apache/camel-quarkus/issues/2608)
- \[Camel 3.10\] Upgrade to minio 8.2.1 in Camel 3.10 breaks Quarkiverse Minio and MinioClientProducer in our test [\#2503](https://github.com/apache/camel-quarkus/issues/2503)
- \[2.0\] Remove camel-quarkus-xml-io [\#2436](https://github.com/apache/camel-quarkus/issues/2436)
- Remove -H:+InlineBeforeAnalysis from Spring RabbitMQ test once Quarkus has InlineBeforeAnalysisBuildItem [\#2416](https://github.com/apache/camel-quarkus/issues/2416)
- \[2.0\] Remove camel-quarkus-componentdsl and camel-quarkus-endpointdsl extensions [\#2354](https://github.com/apache/camel-quarkus/issues/2354)
- Import Debezium BOM [\#1310](https://github.com/apache/camel-quarkus/issues/1310)

## [2.0.0-M1](https://github.com/apache/camel-quarkus/tree/2.0.0-M1) (2021-05-26)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.8.1...2.0.0-M1)

**Implemented enhancements:**

- Support @EndpointInject and @Produce [\#2539](https://github.com/apache/camel-quarkus/issues/2539)

**Closed issues:**

- package org.apache.camel.builder does not exist when using fast-jar in application.properties [\#2612](https://github.com/apache/camel-quarkus/issues/2612)
- \[Quarkus 2.0.0.Alpha2\] : quarkus-bootstrap-maven-plugin  [\#2568](https://github.com/apache/camel-quarkus/issues/2568)
- Datasonnet language not supported? [\#2546](https://github.com/apache/camel-quarkus/issues/2546)
- org.apache.camel.quarkus.component.splunk.it.SplunkTest failure if system timezone isn't UTC [\#2542](https://github.com/apache/camel-quarkus/issues/2542)
- SetHeader does not create a Map when using \[\] [\#2540](https://github.com/apache/camel-quarkus/issues/2540)
- CDI: programmatic lookup problem detected io.quarkus.arc.impl.ArcContainerImpl getMatchingBeans [\#2532](https://github.com/apache/camel-quarkus/issues/2532)
- org.apache.camel.quarkus.component.lra.it.LraTest failed on non-linux machines [\#2523](https://github.com/apache/camel-quarkus/issues/2523)
- Qute component improperly classified as "other" in Camel Quarkus Catalog [\#2508](https://github.com/apache/camel-quarkus/issues/2508)
- Stop testing JavaScript DSL in native mode [\#2481](https://github.com/apache/camel-quarkus/issues/2481)
- Investigate need of @ApplicationScoped annotation [\#2471](https://github.com/apache/camel-quarkus/issues/2471)
- Add info about Camel IDE plugins to the documentation [\#2470](https://github.com/apache/camel-quarkus/issues/2470)
- Improve MongoDB extension documentation of named clients   [\#2466](https://github.com/apache/camel-quarkus/issues/2466)
- Intermittent failure in native MicroprofileMetricsIT [\#2460](https://github.com/apache/camel-quarkus/issues/2460)
- HBase testcontainer fails with UnknownHostException: \<myhostname\>.localdomain: Name or service not known [\#2458](https://github.com/apache/camel-quarkus/issues/2458)
- \[camel 3.10\] kotlin-dsl Enforcer rules have failed [\#2451](https://github.com/apache/camel-quarkus/issues/2451)
- Issue with Camel FHIR extension when upgrading to 1.13.0.Final [\#2450](https://github.com/apache/camel-quarkus/issues/2450)
- camel-quarkus-dozer Error when running native executable [\#2449](https://github.com/apache/camel-quarkus/issues/2449)
- \[Camel 3.10\] Missing EndpointKey [\#2447](https://github.com/apache/camel-quarkus/issues/2447)
- Unable to add camel-quarkus-microprofile-metrics when using camel-quarkus-azure-eventhubs components [\#2442](https://github.com/apache/camel-quarkus/issues/2442)
- Unable to start Quarkus with Camel FHIR  [\#2441](https://github.com/apache/camel-quarkus/issues/2441)
- Add code.quarkus.io badges on extension pages [\#2433](https://github.com/apache/camel-quarkus/issues/2433)
- camel-quarkus-cassandraql : build failure in camel-master branch [\#2424](https://github.com/apache/camel-quarkus/issues/2424)
- Google Storage support [\#2421](https://github.com/apache/camel-quarkus/issues/2421)
- Tests skipped in native mode should be executed on default Java version at least [\#2389](https://github.com/apache/camel-quarkus/issues/2389)
- Adapt examples to the merger of main into core [\#2377](https://github.com/apache/camel-quarkus/issues/2377)
- Adjust the documentation after the merger of main into core [\#2374](https://github.com/apache/camel-quarkus/issues/2374)
- kafka: better integration with quarkus kafka extension [\#2333](https://github.com/apache/camel-quarkus/issues/2333)
- couchbase JVM : add integration tests [\#2326](https://github.com/apache/camel-quarkus/issues/2326)
- \[camel-master\] Support for new DSLs [\#2301](https://github.com/apache/camel-quarkus/issues/2301)
- Show deprecation info in Extensions reference [\#2266](https://github.com/apache/camel-quarkus/issues/2266)
- Custom TypeConverter is not automatically registered [\#2260](https://github.com/apache/camel-quarkus/issues/2260)
- AtlasMap: Use jandex to discover the types we need to register for reflection [\#2241](https://github.com/apache/camel-quarkus/issues/2241)
- AWS2 components have to set client.endpointOverride\(\) to work on Localstack [\#2216](https://github.com/apache/camel-quarkus/issues/2216)
- Startup log of bootstrap runtime [\#2164](https://github.com/apache/camel-quarkus/issues/2164)
- Use AsciiDoc variable for Quarkus version in the documentation [\#2163](https://github.com/apache/camel-quarkus/issues/2163)
- Document correct BoM usage [\#2136](https://github.com/apache/camel-quarkus/issues/2136)
- Add a filter to discard AnnotationTypeConverterLoader [\#1896](https://github.com/apache/camel-quarkus/issues/1896)
- GraalVM 21.1, KafkaSaslSslIT: ClassNotFoundException: org.apache.kafka.common.security.scram.internals.ScramSaslClient$ScramSaslClientFactory [\#2674](https://github.com/apache/camel-quarkus/issues/2674)
- Eagerly initialized Random in various extensions [\#2664](https://github.com/apache/camel-quarkus/issues/2664)
- Use `CamelContextCustomizer` from camel-api [\#2637](https://github.com/apache/camel-quarkus/issues/2637)
- Complete simple core doc concerning "type:\*\*\*" expressions [\#2631](https://github.com/apache/camel-quarkus/issues/2631)
- Expand MongoDb test coverage [\#2622](https://github.com/apache/camel-quarkus/issues/2622)
- Test data format EIPs [\#2616](https://github.com/apache/camel-quarkus/issues/2616)
- Test core languages in isolation [\#2613](https://github.com/apache/camel-quarkus/issues/2613)
- Add a camel-sql case in jta integration tests [\#2604](https://github.com/apache/camel-quarkus/issues/2604)
- Cancel Stale Workflow Runs job is cancelling workflows on all branches [\#2594](https://github.com/apache/camel-quarkus/issues/2594)
- REST extension doc link is not processed correctly [\#2591](https://github.com/apache/camel-quarkus/issues/2591)
- \[camel 3.10\] NATS native image build failure [\#2589](https://github.com/apache/camel-quarkus/issues/2589)
- Support @Consume [\#2580](https://github.com/apache/camel-quarkus/issues/2580)
- \[Quarkus 2.0.0.Alpha2\]  vert.x failure [\#2577](https://github.com/apache/camel-quarkus/issues/2577)
- \[Quarkus 2.0.0.Alpha2\]  Capabilities error [\#2573](https://github.com/apache/camel-quarkus/issues/2573)
- \[Quarkus 2.0.0.Alpha2\] System.properties not recognized if set in Test Resource [\#2572](https://github.com/apache/camel-quarkus/issues/2572)
- With fix of \#2260 too many @Converters are registered [\#2570](https://github.com/apache/camel-quarkus/issues/2570)
- \[Quarkus 2.0.0.Alpha2\] upgrade to  GrpcService annotation [\#2569](https://github.com/apache/camel-quarkus/issues/2569)
- \[Quarkus 2.0.0.Alpha2\] quarkus.test.profile not considered in TestResource [\#2566](https://github.com/apache/camel-quarkus/issues/2566)
- Expand SOAP extension test coverage [\#2561](https://github.com/apache/camel-quarkus/issues/2561)
- several integration-test failure in native mode [\#2550](https://github.com/apache/camel-quarkus/issues/2550)
- Test XPath [\#2547](https://github.com/apache/camel-quarkus/issues/2547)
- Test TypeConverters [\#2537](https://github.com/apache/camel-quarkus/issues/2537)
- Test simple language [\#2533](https://github.com/apache/camel-quarkus/issues/2533)
- Expand REST test coverage [\#2529](https://github.com/apache/camel-quarkus/issues/2529)
- REST JSON example should use the Camel REST DSL [\#2528](https://github.com/apache/camel-quarkus/issues/2528)
- Document locale limitations in native mode [\#2522](https://github.com/apache/camel-quarkus/issues/2522)
- Adapt MicroProfile Health to Camel 3.10 [\#2521](https://github.com/apache/camel-quarkus/issues/2521)
- Expand HL7 test coverage [\#2520](https://github.com/apache/camel-quarkus/issues/2520)
- Expand MLLP test coverage [\#2518](https://github.com/apache/camel-quarkus/issues/2518)
- quarkus.test.flat-class-path=true required to run Avro tests [\#2514](https://github.com/apache/camel-quarkus/issues/2514)
- Test Batch Consumer, charset, filter and sortby options of the file component [\#2512](https://github.com/apache/camel-quarkus/issues/2512)
- Test bean binding [\#2492](https://github.com/apache/camel-quarkus/issues/2492)
- Document the possibility to use CDI beans with camel bean component [\#2491](https://github.com/apache/camel-quarkus/issues/2491)
- Unable to build mongo-to-slack in native with 1.13 quarkus [\#2489](https://github.com/apache/camel-quarkus/issues/2489)
- Add test coverage for Kafka with SSL [\#2484](https://github.com/apache/camel-quarkus/issues/2484)
- Dev Mode: rests xml resources seems ignored [\#2476](https://github.com/apache/camel-quarkus/issues/2476)
- FixedLengthWithLocaleTest.marshalFixedLengthWithLocaleShouldSucceed fails on Java 8 [\#2445](https://github.com/apache/camel-quarkus/issues/2445)
- Upgrade CassandraQL quarkus extension to 1.0.1 [\#2423](https://github.com/apache/camel-quarkus/issues/2423)
- Kafka with SASL\_SSL does not work in quarkus native mode [\#2409](https://github.com/apache/camel-quarkus/issues/2409)
- \[Camel  3.10\] jsonpath : Missing property in path $\['room'\] [\#2395](https://github.com/apache/camel-quarkus/issues/2395)
- Add integration tests for Digitalocean [\#2388](https://github.com/apache/camel-quarkus/issues/2388)
- Store the association between Camel Quarkus Catalog items and Camel Catalog items [\#2368](https://github.com/apache/camel-quarkus/issues/2368)
- Revisit core, main and foundation integration tests [\#2362](https://github.com/apache/camel-quarkus/issues/2362)
- Test class component, test bean language [\#2361](https://github.com/apache/camel-quarkus/issues/2361)
- Test file language [\#2356](https://github.com/apache/camel-quarkus/issues/2356)
- FileTest fails on the platform [\#2278](https://github.com/apache/camel-quarkus/issues/2278)
- Using Camel's @Produce injection [\#2066](https://github.com/apache/camel-quarkus/issues/2066)
- Openstack native support [\#1943](https://github.com/apache/camel-quarkus/issues/1943)
- Add integration tests for camel-quarkus-kafka + sasl  [\#1783](https://github.com/apache/camel-quarkus/issues/1783)
- XQuery component and language native support [\#1710](https://github.com/apache/camel-quarkus/issues/1710)
- XChange native support [\#769](https://github.com/apache/camel-quarkus/issues/769)

## [1.8.1](https://github.com/apache/camel-quarkus/tree/1.8.1) (2021-04-01)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.8.0...1.8.1)

**Fixed bugs:**

- Spring RabbitMQ integration test fails in native mode with Camel 3.9.0 [\#2340](https://github.com/apache/camel-quarkus/issues/2340)

**Closed issues:**

- \[CI\] - Camel Master Branch Build Failure [\#2392](https://github.com/apache/camel-quarkus/issues/2392)
- Stop CI testing on Java 8 [\#2287](https://github.com/apache/camel-quarkus/issues/2287)
- camel-nats intermittently failing on quarkus-platform [\#2061](https://github.com/apache/camel-quarkus/issues/2061)
- Make camel-quarkus-xml-io work again after we broke it with camel-quarkus-xml-io-dsl in 1.8.0 [\#2431](https://github.com/apache/camel-quarkus/issues/2431)
- Consume kubernetes-client-bom via Quarkus BoM [\#2426](https://github.com/apache/camel-quarkus/issues/2426)
- docs: add xref support for adoc file sourced from javadoc [\#2417](https://github.com/apache/camel-quarkus/issues/2417)
- bindy: do not embed useless resources [\#2413](https://github.com/apache/camel-quarkus/issues/2413)
- NPE if Qute template can't be found [\#2410](https://github.com/apache/camel-quarkus/issues/2410)
- Document the process for maintaining \(quarkus | camel\)-master branches [\#2406](https://github.com/apache/camel-quarkus/issues/2406)
- Upgrade to the latest Quarkiverse Google Cloud Services [\#2405](https://github.com/apache/camel-quarkus/issues/2405)
- Intermittent failure in camel-quarkus-master-integration-test [\#2384](https://github.com/apache/camel-quarkus/issues/2384)
- Add test coverage for health check interval and failure-threshold [\#2366](https://github.com/apache/camel-quarkus/issues/2366)
- Add test coverage for a custom HealthCheckRepository  [\#2365](https://github.com/apache/camel-quarkus/issues/2365)
- Use camel-servicenow-maven-plugin to generate model classes [\#2316](https://github.com/apache/camel-quarkus/issues/2316)
- \[Camel 3.9\] Azure Storage Data Lake appends newline to the file content [\#2302](https://github.com/apache/camel-quarkus/issues/2302)
- MLLP native support [\#1731](https://github.com/apache/camel-quarkus/issues/1731)

## [1.8.0](https://github.com/apache/camel-quarkus/tree/1.8.0) (2021-03-26)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.7.0...1.8.0)

**Fixed bugs:**

- Unable to use Salesforce DTOs in native mode [\#2312](https://github.com/apache/camel-quarkus/issues/2312)

**Closed issues:**

- Direct component example [\#2363](https://github.com/apache/camel-quarkus/issues/2363)
- \[CI\] - Quarkus Master Branch Build Failure [\#2360](https://github.com/apache/camel-quarkus/issues/2360)
- Test autowiring of beans available in the CDI container to CamelContext and components [\#2350](https://github.com/apache/camel-quarkus/issues/2350)
- \[CI\] - Camel Master Branch Build Failure [\#2349](https://github.com/apache/camel-quarkus/issues/2349)
- \[CI\] - Quarkus Master Branch Build Failure [\#2336](https://github.com/apache/camel-quarkus/issues/2336)
- \[CI\] - Camel Master Branch Build Failure [\#2332](https://github.com/apache/camel-quarkus/issues/2332)
- \[CI\] - Quarkus Master Branch Build Failure [\#2331](https://github.com/apache/camel-quarkus/issues/2331)
- quarkus 1.7.0 DocumentBuilderFactoryImpl not found [\#2323](https://github.com/apache/camel-quarkus/issues/2323)
- Camel DSL Azure - Storage Blob Service doesn't work as native build. [\#2318](https://github.com/apache/camel-quarkus/issues/2318)
- \[CI\] - Quarkus Master Branch Build Failure [\#2314](https://github.com/apache/camel-quarkus/issues/2314)
- Azure Storage Data Lake listFileSystem operation causes an infinte loop of requests [\#2304](https://github.com/apache/camel-quarkus/issues/2304)
- CI job integration-tests-alternative-jvm \(15\) failing against a valid PR [\#2300](https://github.com/apache/camel-quarkus/issues/2300)
- \[CI\] - Camel Master Branch Build Failure [\#2284](https://github.com/apache/camel-quarkus/issues/2284)
- plugin update-extension-doc-page fails when running extensions-jvm tests [\#2276](https://github.com/apache/camel-quarkus/issues/2276)
- \[CI\] - Quarkus Master Branch Build Failure [\#2275](https://github.com/apache/camel-quarkus/issues/2275)
- \[CI\] - Camel Master Branch Build Failure [\#2261](https://github.com/apache/camel-quarkus/issues/2261)
- Perform basic testing of aws extension through localstack [\#1071](https://github.com/apache/camel-quarkus/issues/1071)
- LRA native support [\#793](https://github.com/apache/camel-quarkus/issues/793)
- Think about consolidating enforcing rules [\#293](https://github.com/apache/camel-quarkus/issues/293)
- Freemarker native support [\#223](https://github.com/apache/camel-quarkus/issues/223)
- Merge camel-quarkus-main into camel-quarkus-core [\#2358](https://github.com/apache/camel-quarkus/issues/2358)
- Make Solr extension automatically register classes with @Field annotations for reflection [\#2341](https://github.com/apache/camel-quarkus/issues/2341)
- Document that AtlasMap user classes may need to be registered for reflection [\#2319](https://github.com/apache/camel-quarkus/issues/2319)
- Test FTPS [\#2317](https://github.com/apache/camel-quarkus/issues/2317)
- Investigate integration test usage of quarkus.ssl.native [\#2306](https://github.com/apache/camel-quarkus/issues/2306)
- Azure extension native build fails with Quarkus 1.13 [\#2299](https://github.com/apache/camel-quarkus/issues/2299)
- SQL integration tests fail with Quarkus 1.13 - Multiple DataSources found in the registry [\#2296](https://github.com/apache/camel-quarkus/issues/2296)
- Replace hbase-testing-util with docker container [\#2295](https://github.com/apache/camel-quarkus/issues/2295)
- \[camel-master\] Support for YAML DSL [\#2294](https://github.com/apache/camel-quarkus/issues/2294)
- main: add an option to ignore command line arguments [\#2293](https://github.com/apache/camel-quarkus/issues/2293)
- bindy: @DataField\(method=\*\) is not supported [\#2282](https://github.com/apache/camel-quarkus/issues/2282)
- Prefer SyntheticBeanBuildItem to initializing bean producers via volatile fields [\#2273](https://github.com/apache/camel-quarkus/issues/2273)
- Bindy - Do not rely on quarkus-resteasy-jackson to register reflective classes [\#2268](https://github.com/apache/camel-quarkus/issues/2268)
- Remove support for Webocket JSR 356 [\#2262](https://github.com/apache/camel-quarkus/issues/2262)
- Camel Quarkus OptaPlanner does not work as of Quarkus 1.12 in apps generated by code.quarkus.io [\#2253](https://github.com/apache/camel-quarkus/issues/2253)
- Optaplanner : upgrade to 8.x extension [\#2243](https://github.com/apache/camel-quarkus/issues/2243)
- Optimise the camel-quarkus-examples CI build [\#2147](https://github.com/apache/camel-quarkus/issues/2147)
- Paho MQTT 5 support [\#2145](https://github.com/apache/camel-quarkus/issues/2145)
- Move Netty related BuildItems to Quarkus Netty extension [\#2142](https://github.com/apache/camel-quarkus/issues/2142)
- Revisit transaction support [\#1918](https://github.com/apache/camel-quarkus/issues/1918)
- HL7 Terser language native support [\#1747](https://github.com/apache/camel-quarkus/issues/1747)
- Splunk native support [\#1698](https://github.com/apache/camel-quarkus/issues/1698)
- Add tests to example projects [\#1501](https://github.com/apache/camel-quarkus/issues/1501)
- Nitrite native support [\#1298](https://github.com/apache/camel-quarkus/issues/1298)

## [1.7.0](https://github.com/apache/camel-quarkus/tree/1.7.0) (2021-02-19)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.6.0...1.7.0)

**Closed issues:**

- Building native fails for Quarkus 1.11.3.Final [\#2250](https://github.com/apache/camel-quarkus/issues/2250)
- \[CI\] - Quarkus Master Branch Build Failure [\#2249](https://github.com/apache/camel-quarkus/issues/2249)
- \[CI\] - Camel Master Branch Build Failure [\#2248](https://github.com/apache/camel-quarkus/issues/2248)
- \[CI\] - Camel Master Branch Build Failure [\#2239](https://github.com/apache/camel-quarkus/issues/2239)
- \[camel-master\] azure-storage-\* integration tests fail [\#2215](https://github.com/apache/camel-quarkus/issues/2215)
- FHIR tests don't work with all possible options [\#2201](https://github.com/apache/camel-quarkus/issues/2201)
- \[CI\] - Quarkus Master Branch Build Failure [\#2194](https://github.com/apache/camel-quarkus/issues/2194)
- Red [\#2188](https://github.com/apache/camel-quarkus/issues/2188)
- \[CI\] - Quarkus Master Branch Build Failure [\#2183](https://github.com/apache/camel-quarkus/issues/2183)
- \[CI\] - Camel Master Branch Build Failure [\#2182](https://github.com/apache/camel-quarkus/issues/2182)
- \[CI\] - Camel Master Branch Build Failure [\#2175](https://github.com/apache/camel-quarkus/issues/2175)
- \[CI\] - Quarkus Master Branch Build Failure [\#2170](https://github.com/apache/camel-quarkus/issues/2170)
- \[CI\] - Quarkus Master Branch Build Failure [\#2161](https://github.com/apache/camel-quarkus/issues/2161)
- \[CI\] - Camel Master Branch Build Failure [\#2157](https://github.com/apache/camel-quarkus/issues/2157)
- \[CI\] - Quarkus Master Branch Build Failure [\#2153](https://github.com/apache/camel-quarkus/issues/2153)
- \[CI\] - Camel Master Branch Build Failure [\#2144](https://github.com/apache/camel-quarkus/issues/2144)
- Figure out how we could leverage Quarkus Developer Console [\#2007](https://github.com/apache/camel-quarkus/issues/2007)
- XML Tokenize language native support [\#780](https://github.com/apache/camel-quarkus/issues/780)
- Docs xref checks failure with Camel 3.8.0 [\#2226](https://github.com/apache/camel-quarkus/issues/2226)
- \[camel-master\] azure-eventhubs: discovered unresolved type during parsing [\#2213](https://github.com/apache/camel-quarkus/issues/2213)
- \[camel-master\] nats: failure running integration tests [\#2211](https://github.com/apache/camel-quarkus/issues/2211)
- camel-quarkus-git: integration test fail if gpg signing is enabled [\#2210](https://github.com/apache/camel-quarkus/issues/2210)
- camel 3.8 - Removed reflection in 9 components [\#2209](https://github.com/apache/camel-quarkus/issues/2209)
- Azure EventHubs native build fails with Quarkus 1.12 [\#2204](https://github.com/apache/camel-quarkus/issues/2204)
- OAI-PMH: Get rid of the JettyTestServer class for tests [\#2192](https://github.com/apache/camel-quarkus/issues/2192)
- Re-introduce Changelog GH Action [\#2189](https://github.com/apache/camel-quarkus/issues/2189)
- Netty UDP does not work in native mode [\#2187](https://github.com/apache/camel-quarkus/issues/2187)
- \[camel 3.8\] create an extension for the kamelet component [\#2174](https://github.com/apache/camel-quarkus/issues/2174)
- Require Java 11 in examples [\#2152](https://github.com/apache/camel-quarkus/issues/2152)
- Reimplement creation of minio client to avoid minio extension limitations [\#2134](https://github.com/apache/camel-quarkus/issues/2134)
- camel-spring-rabbitmq - new component [\#2128](https://github.com/apache/camel-quarkus/issues/2128)
- Hazelcast integration tests : random failing tests on CI  [\#2127](https://github.com/apache/camel-quarkus/issues/2127)
- Align Kubernetes client version with Quarkus [\#2126](https://github.com/apache/camel-quarkus/issues/2126)
- FOP integration tests fail in native mode with GraalVM 20.3.0 [\#2113](https://github.com/apache/camel-quarkus/issues/2113)
- ReplicatedMap : The Hazelcast consumer is not notified on its listener [\#2095](https://github.com/apache/camel-quarkus/issues/2095)
- OAI-PMH support [\#2081](https://github.com/apache/camel-quarkus/issues/2081)
- Azure Event Hubs support [\#2079](https://github.com/apache/camel-quarkus/issues/2079)
- AtlasMap native support [\#1989](https://github.com/apache/camel-quarkus/issues/1989)
- AWS2 EventBridge native support [\#1976](https://github.com/apache/camel-quarkus/issues/1976)
- PubNub native support [\#1944](https://github.com/apache/camel-quarkus/issues/1944)
- Remove JtaProcessor.registerNarayanaReflectiveClass when quarkusio/quarkus\#10180 gets fixed [\#1895](https://github.com/apache/camel-quarkus/issues/1895)
- CBOR data format native support [\#1754](https://github.com/apache/camel-quarkus/issues/1754)
- StAX native support [\#1696](https://github.com/apache/camel-quarkus/issues/1696)
- XML Security native support [\#1617](https://github.com/apache/camel-quarkus/issues/1617)
- Azure Storage Queue Service native support [\#1574](https://github.com/apache/camel-quarkus/issues/1574)
- AWS 2 Kinesis native support [\#1571](https://github.com/apache/camel-quarkus/issues/1571)
- CassandraQL native support [\#1355](https://github.com/apache/camel-quarkus/issues/1355)
- IPFS native support [\#770](https://github.com/apache/camel-quarkus/issues/770)
- Syslog data format native support [\#595](https://github.com/apache/camel-quarkus/issues/595)

## [1.6.0](https://github.com/apache/camel-quarkus/tree/1.6.0) (2021-01-15)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.5.0...1.6.0)

**Closed issues:**

- Document the correct usage of BoMs [\#2135](https://github.com/apache/camel-quarkus/issues/2135)
- camel-quarkus-csimple package not exists but presented in documentation [\#2131](https://github.com/apache/camel-quarkus/issues/2131)
- Could not find artifact com.google.protobuf:protoc:exe:osx-x86\_64:3.13.0 in nexus [\#2097](https://github.com/apache/camel-quarkus/issues/2097)
- \[CI\] - Camel Master Branch Build Failure [\#2077](https://github.com/apache/camel-quarkus/issues/2077)
- \[CI\] - Quarkus Master Branch Build Failure [\#2065](https://github.com/apache/camel-quarkus/issues/2065)
- Release: Update Apache Committee Report Helper for camel-quarkus-1.6.0 released on 2021-01-18 [\#2149](https://github.com/apache/camel-quarkus/issues/2149)
- Minio: Observe issue in quarkiverse-minio [\#2120](https://github.com/apache/camel-quarkus/issues/2120)
- Remove changelog gh action [\#2119](https://github.com/apache/camel-quarkus/issues/2119)
- Geocoder tests with external service are not working [\#2112](https://github.com/apache/camel-quarkus/issues/2112)
- antora/xref-validator failure after a component was removed from Camel [\#2109](https://github.com/apache/camel-quarkus/issues/2109)
- CSimple NPE even if CSimple language is not used [\#2098](https://github.com/apache/camel-quarkus/issues/2098)
- Add more integration tests for camel-hazelcast  extension [\#2094](https://github.com/apache/camel-quarkus/issues/2094)
- Skipped tests on CI \(eg. hystrix\) [\#2091](https://github.com/apache/camel-quarkus/issues/2091)
- Twitter itest doesn't work in native mode [\#2090](https://github.com/apache/camel-quarkus/issues/2090)
- Redis support [\#2085](https://github.com/apache/camel-quarkus/issues/2085)
- Vert.x Kafka support [\#2082](https://github.com/apache/camel-quarkus/issues/2082)
- JSONata support [\#2080](https://github.com/apache/camel-quarkus/issues/2080)
- Create ASF distribution [\#2045](https://github.com/apache/camel-quarkus/issues/2045)
- Minio native support [\#2040](https://github.com/apache/camel-quarkus/issues/2040)
- BigQuery native support [\#2014](https://github.com/apache/camel-quarkus/issues/2014)
- camel-quarkus-kafka: Reconnection issues when working with schema registry [\#1960](https://github.com/apache/camel-quarkus/issues/1960)
- Hazelcast native support [\#1647](https://github.com/apache/camel-quarkus/issues/1647)
- Azure Storage Blob native support [\#1573](https://github.com/apache/camel-quarkus/issues/1573)
- Require Java 11 [\#1299](https://github.com/apache/camel-quarkus/issues/1299)
- Debezium MongoDB Connector native support [\#1190](https://github.com/apache/camel-quarkus/issues/1190)

## [1.5.0](https://github.com/apache/camel-quarkus/tree/1.5.0) (2020-12-14)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.4.0...1.5.0)

**Closed issues:**

- \[CI\] - Camel Master Branch Build Failure [\#2071](https://github.com/apache/camel-quarkus/issues/2071)
- Camel import not working [\#2068](https://github.com/apache/camel-quarkus/issues/2068)
- \[CI\] - Camel Master Branch Build Failure [\#2064](https://github.com/apache/camel-quarkus/issues/2064)
- \[CI\] - Camel Master Branch Build Failure [\#2059](https://github.com/apache/camel-quarkus/issues/2059)
- \[CI\] - Quarkus Master Branch Build Failure [\#2058](https://github.com/apache/camel-quarkus/issues/2058)
- \[CI\] - Quarkus Master Branch Build Failure [\#2049](https://github.com/apache/camel-quarkus/issues/2049)
- \[CI\] - Camel Master Branch Build Failure [\#2046](https://github.com/apache/camel-quarkus/issues/2046)
- \[CI\] - Quarkus Master Branch Build Failure [\#2044](https://github.com/apache/camel-quarkus/issues/2044)
- \[CI\] - Camel Master Branch Build Failure [\#2037](https://github.com/apache/camel-quarkus/issues/2037)
- \[CI\] - Quarkus Master Branch Build Failure [\#2031](https://github.com/apache/camel-quarkus/issues/2031)
- \[CI\] - Camel Master Branch Build Failure [\#2019](https://github.com/apache/camel-quarkus/issues/2019)
- \[CI\] - Quarkus Master Branch Build Failure [\#2013](https://github.com/apache/camel-quarkus/issues/2013)
- FastHeadersMapFactory ClassNotFoundException since 1.0.0-M6 [\#1086](https://github.com/apache/camel-quarkus/issues/1086)
- JSch native support [\#797](https://github.com/apache/camel-quarkus/issues/797)
- Protobuf dataformat native support [\#789](https://github.com/apache/camel-quarkus/issues/789)
- \[Camel 3.7\] Test with camel.main.lightweight=true [\#2063](https://github.com/apache/camel-quarkus/issues/2063)
- CSimple language support [\#2036](https://github.com/apache/camel-quarkus/issues/2036)
- Micrometer component support [\#2034](https://github.com/apache/camel-quarkus/issues/2034)
- Polish how we pass -Djavax.net.ssl.trustStore to the Solr test [\#2029](https://github.com/apache/camel-quarkus/issues/2029)
- timer-log-main example: The example is not working in dev mode [\#2024](https://github.com/apache/camel-quarkus/issues/2024)
- \[CI\] - Camel Master Branch Build Failure [\#2022](https://github.com/apache/camel-quarkus/issues/2022)
- \[Camel 3.7\] Camel main autowire properties by type has been removed  [\#2002](https://github.com/apache/camel-quarkus/issues/2002)
- Antora xref check fails on camel-master branch [\#1996](https://github.com/apache/camel-quarkus/issues/1996)
- \[Camel 3.7\] Investigate reason of the explicit registration of some resources in CamelProcessor [\#1995](https://github.com/apache/camel-quarkus/issues/1995)
- Make UpdateExtensionDocPageMojo generate cross reference URLs [\#1986](https://github.com/apache/camel-quarkus/issues/1986)
- NATS integration test failure - Unable to connect to NATS servers [\#1978](https://github.com/apache/camel-quarkus/issues/1978)
- \[Camel 3.7\] JSON-B data format support [\#1973](https://github.com/apache/camel-quarkus/issues/1973)
- Olingo integration test is throwing SSLPeerUnverifiedException [\#1972](https://github.com/apache/camel-quarkus/issues/1972)
- LevelDB extension does not compile with Camel 3.7.0-SNAPSHOT [\#1948](https://github.com/apache/camel-quarkus/issues/1948)
- Camel Avro RPC component native support [\#1941](https://github.com/apache/camel-quarkus/issues/1941)
- Remove Camel AS2 configuration class reflection registration [\#1874](https://github.com/apache/camel-quarkus/issues/1874)
- OptaPlanner native support [\#1721](https://github.com/apache/camel-quarkus/issues/1721)
- Solr native support [\#1703](https://github.com/apache/camel-quarkus/issues/1703)
- Google pubsub extension native support [\#1041](https://github.com/apache/camel-quarkus/issues/1041)

## [1.4.0](https://github.com/apache/camel-quarkus/tree/1.4.0) (2020-11-19)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.3.0...1.4.0)

**Fixed bugs:**

- AdviceWithRouteBuilder replaceFromWith and microprofile-metrics conflict [\#1894](https://github.com/apache/camel-quarkus/issues/1894)
- Main extension cannot load rest XML definitions [\#1852](https://github.com/apache/camel-quarkus/issues/1852)
- quarkus-spring-web breaks startup of camel-quarkus-activemq [\#1759](https://github.com/apache/camel-quarkus/issues/1759)

**Closed issues:**

- \[CI\] - Camel Master Branch Build Failure [\#2012](https://github.com/apache/camel-quarkus/issues/2012)
- \[CI\] - Quarkus Master Branch Build Failure [\#2006](https://github.com/apache/camel-quarkus/issues/2006)
- \[CI\] - Camel Master Branch Build Failure [\#2003](https://github.com/apache/camel-quarkus/issues/2003)
- \[CI\] - Quarkus Master Branch Build Failure [\#1998](https://github.com/apache/camel-quarkus/issues/1998)
- \[CI\] - Camel Master Branch Build Failure [\#1997](https://github.com/apache/camel-quarkus/issues/1997)
- \[CI\] - Quarkus Master Branch Build Failure [\#1987](https://github.com/apache/camel-quarkus/issues/1987)
- Data Format : Unable marshal LinkedHashMap to Protobuf [\#1983](https://github.com/apache/camel-quarkus/issues/1983)
- \[CI\] - Quarkus Master Branch Build Failure [\#1971](https://github.com/apache/camel-quarkus/issues/1971)
- \[CI\] - Camel Master Branch Build Failure [\#1970](https://github.com/apache/camel-quarkus/issues/1970)
- \[CI\] - Quarkus Master Branch Build Failure [\#1959](https://github.com/apache/camel-quarkus/issues/1959)
- \[CI\] - Camel Master Branch Build Failure [\#1945](https://github.com/apache/camel-quarkus/issues/1945)
- How to add startHistoryId queryParameter to google-mail:history/list \(camel-quarkus-google-mail\) [\#1927](https://github.com/apache/camel-quarkus/issues/1927)
- \[CI\] - Quarkus Master Branch Build Failure [\#1922](https://github.com/apache/camel-quarkus/issues/1922)
- \[CI\] - Camel Master Branch Build Failure [\#1912](https://github.com/apache/camel-quarkus/issues/1912)
- SnappyCompression fails while building native image [\#1910](https://github.com/apache/camel-quarkus/issues/1910)
- Log with KafkaProducer does not work [\#1862](https://github.com/apache/camel-quarkus/issues/1862)
- Hipchat native support [\#1652](https://github.com/apache/camel-quarkus/issues/1652)
- Need an archetype for Camel Quarkus [\#1173](https://github.com/apache/camel-quarkus/issues/1173)
- PDF integration tests failing with Camel 3.7.0-SNAPSHOT [\#1979](https://github.com/apache/camel-quarkus/issues/1979)
- Configuration option \(not\) to start the runtime [\#1969](https://github.com/apache/camel-quarkus/issues/1969)
- json-validator native build fails with Camel 3.7.0-SNAPSHOT [\#1961](https://github.com/apache/camel-quarkus/issues/1961)
- lumberjack : move client payload sending to test [\#1949](https://github.com/apache/camel-quarkus/issues/1949)
- ActiveMQ Default XPath evaluator could not be loaded [\#1933](https://github.com/apache/camel-quarkus/issues/1933)
- FOP tests fail in Quarkus Platform [\#1930](https://github.com/apache/camel-quarkus/issues/1930)
- Document Spark peculiarities [\#1928](https://github.com/apache/camel-quarkus/issues/1928)
- Unreleased Resource: Streams [\#1913](https://github.com/apache/camel-quarkus/issues/1913)
- PostgresSQL Event : add usage of Quarkus AgroalDatasource  [\#1909](https://github.com/apache/camel-quarkus/issues/1909)
- \[Camel Quarkus 1.2\] Remove quarkus.camel.native.resources.include-patterns = routes/\*.xml in examples [\#1901](https://github.com/apache/camel-quarkus/issues/1901)
- Crypto extension requires reflective access to DigitalSignatureConstants [\#1881](https://github.com/apache/camel-quarkus/issues/1881)
- Fix usage of deprecated GitHub actions commands [\#1876](https://github.com/apache/camel-quarkus/issues/1876)
- \[Quarkus 1.9\] leverage Quarkus JAXP extension where applicable [\#1806](https://github.com/apache/camel-quarkus/issues/1806)
- JSLT native support [\#1740](https://github.com/apache/camel-quarkus/issues/1740)
- Lumberjack native support [\#1732](https://github.com/apache/camel-quarkus/issues/1732)
- MSV native support [\#1728](https://github.com/apache/camel-quarkus/issues/1728)
- Nagios native support [\#1726](https://github.com/apache/camel-quarkus/issues/1726)
- Revert PR \#1667 once kudu-client stops shading Netty [\#1669](https://github.com/apache/camel-quarkus/issues/1669)
- Twilio native support [\#1633](https://github.com/apache/camel-quarkus/issues/1633)
- Zendesk native support [\#1613](https://github.com/apache/camel-quarkus/issues/1613)
- Provide a quick profile [\#1607](https://github.com/apache/camel-quarkus/issues/1607)
- Automate the process of creating jvm only extensions  [\#1561](https://github.com/apache/camel-quarkus/issues/1561)
- Leverage camel-platform-http-vertx in platform-http extension [\#1144](https://github.com/apache/camel-quarkus/issues/1144)
- Saga native support [\#819](https://github.com/apache/camel-quarkus/issues/819)

## [1.3.0](https://github.com/apache/camel-quarkus/tree/1.3.0) (2020-10-16)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.2.0...1.3.0)

**Closed issues:**

- HBase integration tests fail with Camel 3.6.0 [\#1914](https://github.com/apache/camel-quarkus/issues/1914)
- Test Geocoder with Google maps mock API if GOOGLE\_GEOCODER\_API\_KEY is not provided [\#1860](https://github.com/apache/camel-quarkus/issues/1860)
- Shiro native support [\#1844](https://github.com/apache/camel-quarkus/issues/1844)
- \[Camel 3.6\] Remove workaround for CAMEL-15518 [\#1769](https://github.com/apache/camel-quarkus/issues/1769)
- \[Camel 3.6?\] Remove createEndpoint method override in QuarkusVertxWebsocketComponent [\#1737](https://github.com/apache/camel-quarkus/issues/1737)
- \[Camel 3.6?\] Improve the camel-bean extension by not using an alias for BeanAnnotationExpressionFactory [\#1725](https://github.com/apache/camel-quarkus/issues/1725)
- \[Camel 3.6\] Remove QuarkusVertxHttpBinding [\#1675](https://github.com/apache/camel-quarkus/issues/1675)

## [1.2.0](https://github.com/apache/camel-quarkus/tree/1.2.0) (2020-10-15)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.1.0...1.2.0)

**Implemented enhancements:**

- Suggestion: Add column for native supported version in camel quarkus extensions list [\#1781](https://github.com/apache/camel-quarkus/issues/1781)

**Fixed bugs:**

- pgevent : config issue [\#1917](https://github.com/apache/camel-quarkus/issues/1917)
- The stream has no active subscriptions when using camel-quarkus-smallrye-reactive-messaging [\#1851](https://github.com/apache/camel-quarkus/issues/1851)
- NoSuchMethodException: org.apache.camel.service.lra.LRASagaRoutes.\<init\>\(\) [\#1840](https://github.com/apache/camel-quarkus/issues/1840)
- Intermittent failure of AhcWsProducerConsumer [\#1815](https://github.com/apache/camel-quarkus/issues/1815)
- 1.1.0 Main fails to start in IntelliJ [\#1800](https://github.com/apache/camel-quarkus/issues/1800)
- Camel-Quarkus Kafka: Failed to configure SaslClientAuthenticator [\#1687](https://github.com/apache/camel-quarkus/issues/1687)

**Closed issues:**

- \[CI\] - Camel Master Branch Build Failure [\#1900](https://github.com/apache/camel-quarkus/issues/1900)
- IllegalArgumentException thrown on itest application startup  [\#1891](https://github.com/apache/camel-quarkus/issues/1891)
- \[CI\] - Quarkus Master Branch Build Failure [\#1886](https://github.com/apache/camel-quarkus/issues/1886)
- \[CI\] - Quarkus Master Branch Build Failure [\#1865](https://github.com/apache/camel-quarkus/issues/1865)
- \[CI\] - Quarkus Master Branch Build Failure [\#1850](https://github.com/apache/camel-quarkus/issues/1850)
- \[CI\] - Quarkus Master Branch Build Failure [\#1830](https://github.com/apache/camel-quarkus/issues/1830)
- \[CI\] - Camel Master Branch Build Failure [\#1826](https://github.com/apache/camel-quarkus/issues/1826)
- \[CI\] - Quarkus Master Branch Build Failure [\#1810](https://github.com/apache/camel-quarkus/issues/1810)
- \[CI\] - Camel Master Branch Build Failure [\#1805](https://github.com/apache/camel-quarkus/issues/1805)
- NATS tests do not work on the platform [\#1803](https://github.com/apache/camel-quarkus/issues/1803)
- \[CI\] - Camel Master Branch Build Failure [\#1798](https://github.com/apache/camel-quarkus/issues/1798)
- \[CI\] - Camel Master Branch Build Failure [\#1779](https://github.com/apache/camel-quarkus/issues/1779)
- \[CI\] - Quarkus Master Branch Build Failure [\#1773](https://github.com/apache/camel-quarkus/issues/1773)
- Add more examples [\#310](https://github.com/apache/camel-quarkus/issues/310)
- Add Camel-Aws-SSM extension [\#108](https://github.com/apache/camel-quarkus/issues/108)
- \[QUARKUS 1.9\] Remove the driver registration workaround from Postgres Replication Slot extension [\#1885](https://github.com/apache/camel-quarkus/issues/1885)
- Duplicate license headers in Velocity test templates [\#1843](https://github.com/apache/camel-quarkus/issues/1843)
- LevelDB native support [\#1839](https://github.com/apache/camel-quarkus/issues/1839)
- Headersmap native support [\#1838](https://github.com/apache/camel-quarkus/issues/1838)
- List of misc. components empty after the recent docs generation changes [\#1834](https://github.com/apache/camel-quarkus/issues/1834)
- Document all ways to start a new project [\#1824](https://github.com/apache/camel-quarkus/issues/1824)
- A user guide page informing about various ways to define routes [\#1823](https://github.com/apache/camel-quarkus/issues/1823)
- Run verify for the docs module on the CI [\#1819](https://github.com/apache/camel-quarkus/issues/1819)
- Camel quarkus disable auto route discovery not working [\#1816](https://github.com/apache/camel-quarkus/issues/1816)
- Configure NativeImageResourceBuildItem for camel route classpath resources [\#1812](https://github.com/apache/camel-quarkus/issues/1812)
- allowContextMapAll requires template engines to have reflective access to camel core classess  [\#1807](https://github.com/apache/camel-quarkus/issues/1807)
- Find a proper place for registering SAXMessages native resource bundle  [\#1796](https://github.com/apache/camel-quarkus/issues/1796)
- Generate partials instead of pages for the individual Camel bits [\#1795](https://github.com/apache/camel-quarkus/issues/1795)
- \[Quarkus 1.9\] Caffeine: remove CacheLoader processor  [\#1790](https://github.com/apache/camel-quarkus/issues/1790)
- Wrong jira component version definition in camel-quarkus-bom 1.0.1 file [\#1775](https://github.com/apache/camel-quarkus/issues/1775)
- Adding Changelog generated automatically through gh action [\#1772](https://github.com/apache/camel-quarkus/issues/1772)
- Component counts not shown on the website [\#1770](https://github.com/apache/camel-quarkus/issues/1770)
- \[Quarkus 1.9\] Move httpmine from our BOM to Quarkus BOM [\#1763](https://github.com/apache/camel-quarkus/issues/1763)
- uniVocity data formats native support [\#1756](https://github.com/apache/camel-quarkus/issues/1756)
- Jing native support [\#1741](https://github.com/apache/camel-quarkus/issues/1741)
- NSQ native support [\#1722](https://github.com/apache/camel-quarkus/issues/1722)
- PostgresSQL Replication Slot native support [\#1720](https://github.com/apache/camel-quarkus/issues/1720)
- PostgresSQL Event native support [\#1719](https://github.com/apache/camel-quarkus/issues/1719)
- Be able to determine that the test was run against external service or not [\#1717](https://github.com/apache/camel-quarkus/issues/1717)
- RSS component native support [\#1711](https://github.com/apache/camel-quarkus/issues/1711)
- Stop managing httpclient-cache as it is managed by Quarkus [\#1704](https://github.com/apache/camel-quarkus/issues/1704)
- String template native support [\#1694](https://github.com/apache/camel-quarkus/issues/1694)
- Move examples to a separate git repository [\#1691](https://github.com/apache/camel-quarkus/issues/1691)
- Make mvn -N cq:format remove empty application.properties files [\#1676](https://github.com/apache/camel-quarkus/issues/1676)
- Document cq:create -Dcq.nativeSupported=false for creating JVM-only extensions [\#1662](https://github.com/apache/camel-quarkus/issues/1662)
- camel-quarkus-activemq extension broker url configuration [\#1661](https://github.com/apache/camel-quarkus/issues/1661)
- Geocoder native support [\#1645](https://github.com/apache/camel-quarkus/issues/1645)
- FOP native support [\#1642](https://github.com/apache/camel-quarkus/issues/1642)
- SmallRyeReactiveMessagingIT fails intermittently [\#1632](https://github.com/apache/camel-quarkus/issues/1632)
- MongoClientName annotation class not available when using camel-quarkus-mongodb extension [\#1608](https://github.com/apache/camel-quarkus/issues/1608)
- Disruptor native support [\#1597](https://github.com/apache/camel-quarkus/issues/1597)
- Crypto \(JCE\) native support [\#1593](https://github.com/apache/camel-quarkus/issues/1593)
- Atom native support [\#1560](https://github.com/apache/camel-quarkus/issues/1560)
- Use asciidoctor-antora-indexer to produce lists of extensions and components on the reference pages [\#1557](https://github.com/apache/camel-quarkus/issues/1557)
- Add styles for Quarkus config options fixed at build time [\#1410](https://github.com/apache/camel-quarkus/issues/1410)
- File specific issues for TODOs where necessary [\#1285](https://github.com/apache/camel-quarkus/issues/1285)
- Velocity Support [\#837](https://github.com/apache/camel-quarkus/issues/837)
- Browse native support [\#816](https://github.com/apache/camel-quarkus/issues/816)
- SSH support [\#798](https://github.com/apache/camel-quarkus/issues/798)
- Caffeine native support [\#794](https://github.com/apache/camel-quarkus/issues/794)
- gRPC native support [\#762](https://github.com/apache/camel-quarkus/issues/762)

## [1.1.0](https://github.com/apache/camel-quarkus/tree/1.1.0) (2020-09-09)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.0.1...1.1.0)

**Fixed bugs:**

- KuduIT fails with Camel 3.5.0 [\#1664](https://github.com/apache/camel-quarkus/issues/1664)
- Unable to use quartz as scheduler for ScheduledPollConsumer in native mode [\#1663](https://github.com/apache/camel-quarkus/issues/1663)
- \[Camel 3.5\] OpenTracing integration test fails with Camel 3.5.0-SNAPSHOT [\#1493](https://github.com/apache/camel-quarkus/issues/1493)

**Closed issues:**

- \[CI\] - Camel Master Branch Build Failure [\#1532](https://github.com/apache/camel-quarkus/issues/1532)
- camel-quarkus-main - Uses reflection for setting its name [\#1765](https://github.com/apache/camel-quarkus/issues/1765)
- Add TLS based authentication support to the nats extension [\#1761](https://github.com/apache/camel-quarkus/issues/1761)
- @Simple annotated bean parameter binding not working in native mode [\#1685](https://github.com/apache/camel-quarkus/issues/1685)
- Create an AWS2-STS extension [\#1680](https://github.com/apache/camel-quarkus/issues/1680)
- Weather native support [\#1631](https://github.com/apache/camel-quarkus/issues/1631)
- ClassNotFoundException thrown when using onException in native mode [\#1605](https://github.com/apache/camel-quarkus/issues/1605)
- Speed up the CI [\#1602](https://github.com/apache/camel-quarkus/issues/1602)
- jakarta.xml.bind:jakarta.xml.bind-api version alignment issues [\#1601](https://github.com/apache/camel-quarkus/issues/1601)
- NATS native support [\#1578](https://github.com/apache/camel-quarkus/issues/1578)
- Dropbox native support [\#1577](https://github.com/apache/camel-quarkus/issues/1577)
- AWS 2 Lambda native support [\#1572](https://github.com/apache/camel-quarkus/issues/1572)
- make camel-management a camel-quarkus extension.  [\#1564](https://github.com/apache/camel-quarkus/issues/1564)
- \[Camel 3.5?\] contextPath ignored for platform-http with REST DSL [\#1563](https://github.com/apache/camel-quarkus/issues/1563)
- Cron component not initialized when used with Endpoint DSL \(since Quarkus 1.7.0.Final\) [\#1553](https://github.com/apache/camel-quarkus/issues/1553)
- Telegram test doesn't work [\#1550](https://github.com/apache/camel-quarkus/issues/1550)
- Flatpack component support [\#1541](https://github.com/apache/camel-quarkus/issues/1541)
- http related tests rely on external service that may sometimes be down [\#1538](https://github.com/apache/camel-quarkus/issues/1538)
- Add ArangoDB component extension [\#1533](https://github.com/apache/camel-quarkus/issues/1533)
- RabbitMQ native support [\#1531](https://github.com/apache/camel-quarkus/issues/1531)
- Add entry in Quarkus MAINTAINERS.adoc [\#1523](https://github.com/apache/camel-quarkus/issues/1523)
- health example throws VerifyError as class MonkeyHealthCheck\_ClientProxy overrides final method AbstractHealthCheck.addMetaData [\#1517](https://github.com/apache/camel-quarkus/issues/1517)
- Add core extension to the list of extensions documentation [\#1510](https://github.com/apache/camel-quarkus/issues/1510)
- UpdateExtensionDocPageMojo generates wrong link for Camel threadpoolfactory-vertx component [\#1506](https://github.com/apache/camel-quarkus/issues/1506)
- \[Camel 3.5/3.4.3\] xml-io should pass namespace info to NamespaceAware elements [\#1497](https://github.com/apache/camel-quarkus/issues/1497)
- Create a vert.x http client extension [\#1491](https://github.com/apache/camel-quarkus/issues/1491)
- org.apache.camel.NoTypeConversionAvailableException: No type converter available to convert from type: java.util.HashMap to the required type: java.nio.ByteBuffer with value {name=e} [\#1475](https://github.com/apache/camel-quarkus/issues/1475)
- Add Camel AS2 Modules as Quarkus Extension [\#1471](https://github.com/apache/camel-quarkus/issues/1471)
- \[Camel 3.5\] Move FastUuidGenerator to Camel [\#1470](https://github.com/apache/camel-quarkus/issues/1470)
- Add support for smallrye-reactive-messaging-camel [\#1469](https://github.com/apache/camel-quarkus/issues/1469)
- Extension for camel-threadpoolfactory-vertx [\#1430](https://github.com/apache/camel-quarkus/issues/1430)
- \[Camel 3.5\] Configuring api context path with property camel.context.rest-configuration.api-context-path does not work [\#1303](https://github.com/apache/camel-quarkus/issues/1303)
- \[Camel 3.5\] Create a vert.x websocket extension [\#1301](https://github.com/apache/camel-quarkus/issues/1301)
- Investigate removing reflective class configuration for components that extend AbstractApiComponent [\#1108](https://github.com/apache/camel-quarkus/issues/1108)
- Flatpack dataformat support [\#796](https://github.com/apache/camel-quarkus/issues/796)
- Create extension for camel-master component [\#711](https://github.com/apache/camel-quarkus/issues/711)
- Remove UnbannedReflectiveBuildItem + policy extension ? [\#699](https://github.com/apache/camel-quarkus/issues/699)

## [1.0.1](https://github.com/apache/camel-quarkus/tree/1.0.1) (2020-08-26)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.0.0...1.0.1)

**Closed issues:**

- IPFS native support [\#1623](https://github.com/apache/camel-quarkus/issues/1623)
- Browse component native support [\#1582](https://github.com/apache/camel-quarkus/issues/1582)
- \[CI\] - Quarkus Master Branch Build Failure [\#1566](https://github.com/apache/camel-quarkus/issues/1566)
- \[CI\] - Quarkus Master Branch Build Failure [\#1530](https://github.com/apache/camel-quarkus/issues/1530)
- \[CI\] - Quarkus Master Branch Build Failure [\#1522](https://github.com/apache/camel-quarkus/issues/1522)
- Add support for Azure SDK12 components [\#1494](https://github.com/apache/camel-quarkus/issues/1494)
- Git support [\#765](https://github.com/apache/camel-quarkus/issues/765)
- Provide aggregated tests for quarkus-platform [\#413](https://github.com/apache/camel-quarkus/issues/413)

## [1.0.0](https://github.com/apache/camel-quarkus/tree/1.0.0) (2020-08-10)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.0.0-CR3...1.0.0)

**Implemented enhancements:**

- Don't bind auto-discovered beans to the registry if they are produced by the user [\#1406](https://github.com/apache/camel-quarkus/issues/1406)
- Create a Camel Json Jackson extension [\#306](https://github.com/apache/camel-quarkus/issues/306)
- Auto configuration of metrics management strategies [\#195](https://github.com/apache/camel-quarkus/issues/195)
- Initialization ordering [\#147](https://github.com/apache/camel-quarkus/issues/147)
- Create a Camel Kafka extension [\#142](https://github.com/apache/camel-quarkus/issues/142)
- Expose health in quarkus  [\#141](https://github.com/apache/camel-quarkus/issues/141)
- Expose metrics in quarkus [\#128](https://github.com/apache/camel-quarkus/issues/128)

**Fixed bugs:**

- Support path parameters in platform-http [\#382](https://github.com/apache/camel-quarkus/issues/382)
- The synthetic test poms are missing signatures [\#207](https://github.com/apache/camel-quarkus/issues/207)

**Closed issues:**

- \[CI\] - Quarkus Master Branch Build Failure [\#1509](https://github.com/apache/camel-quarkus/issues/1509)
- @BindToRegistry not working with @ApplicationScoped route builders [\#1505](https://github.com/apache/camel-quarkus/issues/1505)
- \[CI\] - Quarkus Master Branch Build Failure [\#1502](https://github.com/apache/camel-quarkus/issues/1502)
- \[CI\] - Quarkus Master Branch Build Failure [\#1487](https://github.com/apache/camel-quarkus/issues/1487)
- \[CI\] - Quarkus Master Branch Build Failure [\#1482](https://github.com/apache/camel-quarkus/issues/1482)
- Add camel-master extension [\#1476](https://github.com/apache/camel-quarkus/issues/1476)
- Running a Camel-main batch application [\#1474](https://github.com/apache/camel-quarkus/issues/1474)
- \[CI\] - Quarkus Master Branch Build Failure [\#1472](https://github.com/apache/camel-quarkus/issues/1472)
- \[CI\] - Camel Master Branch Build Failure [\#1456](https://github.com/apache/camel-quarkus/issues/1456)
- \[CI\] - Quarkus Master Branch Build Failure [\#1451](https://github.com/apache/camel-quarkus/issues/1451)
- Quarkus And XML Routes [\#1436](https://github.com/apache/camel-quarkus/issues/1436)
- \[Quarkus 1.6.1.Final\] platform-http: dev mode breaking with log "Request has already been read" [\#1373](https://github.com/apache/camel-quarkus/issues/1373)
- Kafka Component Writing Messages with ProducerTemplate [\#743](https://github.com/apache/camel-quarkus/issues/743)
- vertx-websocket extension [\#1507](https://github.com/apache/camel-quarkus/issues/1507)
- Health example fails to start [\#1500](https://github.com/apache/camel-quarkus/issues/1500)
- Debezium test fails on branch camel-master [\#1490](https://github.com/apache/camel-quarkus/issues/1490)
- Intermittent failure of CamelDevModeTest [\#1468](https://github.com/apache/camel-quarkus/issues/1468)
- Add Grok Extension [\#1466](https://github.com/apache/camel-quarkus/issues/1466)
- Unable to build from source release zip [\#1460](https://github.com/apache/camel-quarkus/issues/1460)
- @Handler on Bean does not resolve method [\#1459](https://github.com/apache/camel-quarkus/issues/1459)
- src kit need to exclude the node installation  [\#1455](https://github.com/apache/camel-quarkus/issues/1455)
- org.apache.camel.quarkus.main.CamelMainApplication should be registered for reflection [\#1453](https://github.com/apache/camel-quarkus/issues/1453)
- Document how to use mock in JVM mode tests [\#1449](https://github.com/apache/camel-quarkus/issues/1449)
- Add an integration test for the command mode [\#1448](https://github.com/apache/camel-quarkus/issues/1448)
- Document JTA extension usage [\#1428](https://github.com/apache/camel-quarkus/issues/1428)
- \[Quarkus 1.6.0\] Remove our dependency parity check once quarkusio/quarkus\#10279 is fixed [\#1426](https://github.com/apache/camel-quarkus/issues/1426)
- Upgrade to Debezium 1.2.0.Final [\#1418](https://github.com/apache/camel-quarkus/issues/1418)
- The CI should fail if there are uncommitted changes after the build [\#1415](https://github.com/apache/camel-quarkus/issues/1415)
- \[Quarkus 1.7\] quarkus-extension-processor race conditions when modules are built in parallel [\#1403](https://github.com/apache/camel-quarkus/issues/1403)
- Asterisk not escaped in Quarkus config docs [\#1402](https://github.com/apache/camel-quarkus/issues/1402)
- Remove service exclude for ThreadPoolProfileConfigurationProperties [\#1380](https://github.com/apache/camel-quarkus/issues/1380)
- OpenAPI Java extension cannot handle non-default API context path   [\#1309](https://github.com/apache/camel-quarkus/issues/1309)
- Pass deprecation info to quarkus-extension.yaml [\#1286](https://github.com/apache/camel-quarkus/issues/1286)
- Make camel-quarkus-rest depend on camel-quarkus-platform-http [\#1244](https://github.com/apache/camel-quarkus/issues/1244)
- Add extension support for camel-jpa [\#889](https://github.com/apache/camel-quarkus/issues/889)
- Unable to GET an https URL with netty-http client [\#695](https://github.com/apache/camel-quarkus/issues/695)
- Fhir test are not working in native mode [\#473](https://github.com/apache/camel-quarkus/issues/473)
- Fix camel-quarkus-pdf native tests [\#472](https://github.com/apache/camel-quarkus/issues/472)
- Add an option to filter auto-discovered routes [\#396](https://github.com/apache/camel-quarkus/issues/396)
- Remove MicroProfile Metrics extension workarounds [\#319](https://github.com/apache/camel-quarkus/issues/319)
- Improve dev mode [\#314](https://github.com/apache/camel-quarkus/issues/314)
- Use Camel's async processor in platform-http [\#299](https://github.com/apache/camel-quarkus/issues/299)
- Add OpenTracing extension [\#276](https://github.com/apache/camel-quarkus/issues/276)
- Ensure the PlatformHttpComponent is registered before the routes are started [\#218](https://github.com/apache/camel-quarkus/issues/218)
- \[platform http\] support for rest dsl [\#217](https://github.com/apache/camel-quarkus/issues/217)
- Make xml and jaxb disabled by default and opt-in when depending on camel [\#188](https://github.com/apache/camel-quarkus/issues/188)
- Leverage platform http service [\#184](https://github.com/apache/camel-quarkus/issues/184)
- Generate documentation to be included in quarkus [\#183](https://github.com/apache/camel-quarkus/issues/183)
- @ConfigProperty and @Inject do not work in RouteBuilders [\#136](https://github.com/apache/camel-quarkus/issues/136)
- Add support for quarkus provided event loop [\#131](https://github.com/apache/camel-quarkus/issues/131)
- Include quarkus info in camel-catalog [\#75](https://github.com/apache/camel-quarkus/issues/75)
- quarkus-camel - Use MainSupport as base for running Camel [\#9](https://github.com/apache/camel-quarkus/issues/9)

**Merged pull requests:**

- Fix README link [\#161](https://github.com/apache/camel-quarkus/pull/161) ([fviolette](https://github.com/fviolette))

## [1.0.0-CR3](https://github.com/apache/camel-quarkus/tree/1.0.0-CR3) (2020-07-03)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.0.0-CR2...1.0.0-CR3)

**Implemented enhancements:**

- Observe Camel's Management events [\#1398](https://github.com/apache/camel-quarkus/issues/1398)
- Observe Camel's events [\#1353](https://github.com/apache/camel-quarkus/issues/1353)

**Fixed bugs:**

- CamelBeanPostProcessor is invoked after routes are already configured [\#1368](https://github.com/apache/camel-quarkus/issues/1368)
- \[Quarkus 1.6\]\[iCal\] TimeZone-less DTSTART and DTEND changed to GMT in native mode [\#838](https://github.com/apache/camel-quarkus/issues/838)

**Closed issues:**

- Question regarding AWS Credentials without XML beans [\#1431](https://github.com/apache/camel-quarkus/issues/1431)
- \[CI\] - Quarkus Master Branch Build Failure [\#1427](https://github.com/apache/camel-quarkus/issues/1427)
- \[CI\] - Quarkus Master Branch Build Failure [\#1417](https://github.com/apache/camel-quarkus/issues/1417)
- \[CI\] - Quarkus Master Branch Build Failure [\#1381](https://github.com/apache/camel-quarkus/issues/1381)
- \[CI\] - Quarkus Master Branch Build Failure [\#1345](https://github.com/apache/camel-quarkus/issues/1345)
- Commit cannot be completed since the group has already rebalanced and assigned the partitions to another member [\#1328](https://github.com/apache/camel-quarkus/issues/1328)
- \[CI\] - Quarkus Master Branch Build Failure [\#1297](https://github.com/apache/camel-quarkus/issues/1297)
- \[CI\] - Camel Master Branch Build Failure [\#1284](https://github.com/apache/camel-quarkus/issues/1284)
- \[CI\] - Quarkus Master Branch Build Failure [\#1283](https://github.com/apache/camel-quarkus/issues/1283)
- \[CI\] - Quarkus Master Branch Build Failure [\#1271](https://github.com/apache/camel-quarkus/issues/1271)
- camel-quarkus-avro: Remove ObjectSubstitution when/if quarkus serialization has been fixed [\#1247](https://github.com/apache/camel-quarkus/issues/1247)
- Tests fail on integration-tests/platform-http for 1.0.0-M5 [\#906](https://github.com/apache/camel-quarkus/issues/906)
- camel-quarkus - Optimize to not allow adding new routes [\#726](https://github.com/apache/camel-quarkus/issues/726)
- JAX-RS endpoint accessible before Camel context is started [\#1439](https://github.com/apache/camel-quarkus/issues/1439)
- Jolt support [\#1421](https://github.com/apache/camel-quarkus/issues/1421)
- Observe Camel's Lifecycle events [\#1399](https://github.com/apache/camel-quarkus/issues/1399)
- Package Maven Plugin: Goal prefix is specified as: 'camel-quarkus'. Maven currently expects it to be 'camel-quarkus-package'. [\#1395](https://github.com/apache/camel-quarkus/issues/1395)
- The quarkus-bootstrap-maven-plugin is listed twice on all the runtime extensions POMs [\#1390](https://github.com/apache/camel-quarkus/issues/1390)
- AWS2-Athena extension [\#1388](https://github.com/apache/camel-quarkus/issues/1388)
- Create a camel-componentdsl extension [\#1376](https://github.com/apache/camel-quarkus/issues/1376)
- Json Validator Support [\#1367](https://github.com/apache/camel-quarkus/issues/1367)
- \[suggestion\] log message for FileNotFound exception not clear enough [\#1365](https://github.com/apache/camel-quarkus/issues/1365)
- Add an AWS2-SES native extension [\#1363](https://github.com/apache/camel-quarkus/issues/1363)
- Add an AWS2-MSK native extension [\#1360](https://github.com/apache/camel-quarkus/issues/1360)
- Add an AWS2-MQ native extension [\#1359](https://github.com/apache/camel-quarkus/issues/1359)
- Add an AWS2-KMS native extension [\#1358](https://github.com/apache/camel-quarkus/issues/1358)
- Add an AWS2-IAM native extension [\#1357](https://github.com/apache/camel-quarkus/issues/1357)
- Add an AWS2-DDB native extension [\#1356](https://github.com/apache/camel-quarkus/issues/1356)
- List all the configuration properties onthe website [\#1350](https://github.com/apache/camel-quarkus/issues/1350)
- Replace joschi/setup-jdk with AdoptOpenJDK/install-jdk [\#1349](https://github.com/apache/camel-quarkus/issues/1349)
- Create vertx component extension [\#1322](https://github.com/apache/camel-quarkus/issues/1322)
- NoClassDefFoundError for HttpServletRequest in native tests for olingo4 [\#1319](https://github.com/apache/camel-quarkus/issues/1319)
- Make Kudu native test runnable on Quarkus Platform on Java 8 and 11 [\#1314](https://github.com/apache/camel-quarkus/issues/1314)
- \[Quarkus 1.6\] Unresolved method AutoscalingAPIGroupDSL.v1\(\) error in Kubernetes native image generation [\#1313](https://github.com/apache/camel-quarkus/issues/1313)
- Debezium unit tests failing with Quarkus master [\#1312](https://github.com/apache/camel-quarkus/issues/1312)
- Add an AWS2-Translate native extension [\#1308](https://github.com/apache/camel-quarkus/issues/1308)
- Document SSL auto-enabled by extensions [\#1300](https://github.com/apache/camel-quarkus/issues/1300)
- Platform HTTP does not automatically set content-length or chunked [\#1288](https://github.com/apache/camel-quarkus/issues/1288)
- Add rest and restapi to the list of discoverable factories [\#1287](https://github.com/apache/camel-quarkus/issues/1287)
- Create extension for camel-openapi-java [\#1281](https://github.com/apache/camel-quarkus/issues/1281)
- Add enforce rule to avoid extension depending on camel-quarkus-xml-io or camel-quarkus-xml-jaxb directly  [\#1277](https://github.com/apache/camel-quarkus/issues/1277)
- \[Quarkus 1.6\] quarkus:dev can't reload when updating timer-log example [\#1274](https://github.com/apache/camel-quarkus/issues/1274)
- \[Quarkus 1.6\] Unsupported type MethodAccessorGenerator on Consul [\#1273](https://github.com/apache/camel-quarkus/issues/1273)
- Azure native test failure [\#1269](https://github.com/apache/camel-quarkus/issues/1269)
- camel-jta support [\#1263](https://github.com/apache/camel-quarkus/issues/1263)
- Remove NettyHttpComponent producer method from RestOpenapiResource [\#1237](https://github.com/apache/camel-quarkus/issues/1237)
- Remove mongodb from BOM after upgrade to Quarkus 1.5.x [\#1225](https://github.com/apache/camel-quarkus/issues/1225)
- Example can't be run from the project itself [\#1223](https://github.com/apache/camel-quarkus/issues/1223)
- Revert workaround for @EnabledIf after upgrade to Quarkus 1.5.x [\#1222](https://github.com/apache/camel-quarkus/issues/1222)
- transacted\(\) support in camel-quarkus [\#1197](https://github.com/apache/camel-quarkus/issues/1197)
- Debezium SQL Server Connector native support [\#1193](https://github.com/apache/camel-quarkus/issues/1193)
- Unresolved type Base64 in camel-jira native test [\#1166](https://github.com/apache/camel-quarkus/issues/1166)
- Add an AWS2-EKS native extension [\#1142](https://github.com/apache/camel-quarkus/issues/1142)
- Add an AWS2-ECS native extension [\#1141](https://github.com/apache/camel-quarkus/issues/1141)
- Add an AWS2-EC2 native extensions [\#1140](https://github.com/apache/camel-quarkus/issues/1140)
- Revisit camel-quarkus bootstrap [\#1128](https://github.com/apache/camel-quarkus/issues/1128)
- Jira test fails in native mode on Quarkus Platform [\#1090](https://github.com/apache/camel-quarkus/issues/1090)
- Remove the need for registering RestBindingJaxbDataFormatFactory service  [\#1066](https://github.com/apache/camel-quarkus/issues/1066)
- Remove enforcing camel keyword in metadata [\#1058](https://github.com/apache/camel-quarkus/issues/1058)
- Support Quarkus command mode [\#1037](https://github.com/apache/camel-quarkus/issues/1037)
- Couchdb native support for Consumer Mode [\#1022](https://github.com/apache/camel-quarkus/issues/1022)
- camel-quarkus-aws-sns failing to compile image-native [\#870](https://github.com/apache/camel-quarkus/issues/870)
- NullPointerException when starting with quarkus:dev goal [\#828](https://github.com/apache/camel-quarkus/issues/828)
- Tika support [\#799](https://github.com/apache/camel-quarkus/issues/799)
- Test the Jira extension using Testcontainer and the Jira image [\#752](https://github.com/apache/camel-quarkus/issues/752)
- Add documentation about configuration options [\#536](https://github.com/apache/camel-quarkus/issues/536)
- Feature: Add camel-mock [\#531](https://github.com/apache/camel-quarkus/issues/531)
- Improve extension summary so they have more details in the code.quarkus.io [\#465](https://github.com/apache/camel-quarkus/issues/465)

**Merged pull requests:**

- Upgrade Quarkus Qpid JMS to 0.16.0 [\#1450](https://github.com/apache/camel-quarkus/pull/1450) ([jamesnetherton](https://github.com/jamesnetherton))
- Feature: Add camel-mock \#531 [\#1447](https://github.com/apache/camel-quarkus/pull/1447) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Upgrade to Quarkus 1.6.0.Final [\#1446](https://github.com/apache/camel-quarkus/pull/1446) ([ppalaga](https://github.com/ppalaga))
- Make sure that Quarkus orders booting our runtime before starting to serve HTTP endpoints. [\#1445](https://github.com/apache/camel-quarkus/pull/1445) ([ppalaga](https://github.com/ppalaga))
- Split main startup logic [\#1444](https://github.com/apache/camel-quarkus/pull/1444) ([lburgazzoli](https://github.com/lburgazzoli))
- Improve the bootstrap docs [\#1442](https://github.com/apache/camel-quarkus/pull/1442) ([ppalaga](https://github.com/ppalaga))
- Re-enable TimerDevModeTest.logMessageEdit\(\) after the upgrade to Quar… [\#1440](https://github.com/apache/camel-quarkus/pull/1440) ([ppalaga](https://github.com/ppalaga))
- Upgrade cq-maven-plugin to 0.11.0 [\#1438](https://github.com/apache/camel-quarkus/pull/1438) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#1415 The CI should fail if there are uncommitted changes after t… [\#1435](https://github.com/apache/camel-quarkus/pull/1435) ([ppalaga](https://github.com/ppalaga))
- Add skip option to UpdateExtensionDocPageMojo to be able to workaroun… [\#1434](https://github.com/apache/camel-quarkus/pull/1434) ([ppalaga](https://github.com/ppalaga))
- Added Jolt support \#1421 [\#1432](https://github.com/apache/camel-quarkus/pull/1432) ([aldettinger](https://github.com/aldettinger))
- Fix \#1313 Upgrade to Kubernetes Client 4.10.2 to align with Quarkus [\#1425](https://github.com/apache/camel-quarkus/pull/1425) ([ppalaga](https://github.com/ppalaga))
- Enable Debezium tests after the upgrade to Quarkus 1.6.0.CR1 [\#1424](https://github.com/apache/camel-quarkus/pull/1424) ([ppalaga](https://github.com/ppalaga))
- Upgrade to Quarkus 1.6.0.CR1 [\#1423](https://github.com/apache/camel-quarkus/pull/1423) ([ppalaga](https://github.com/ppalaga))
- Ensure Quarkus Vertx instance is set on the camel component when not using camel-quarkus-main [\#1422](https://github.com/apache/camel-quarkus/pull/1422) ([jamesnetherton](https://github.com/jamesnetherton))
- Ensure CamelContextAware beans have CamelContext set when bound to the registry [\#1420](https://github.com/apache/camel-quarkus/pull/1420) ([jamesnetherton](https://github.com/jamesnetherton))
- Rename camel-quarkus-package-maven-plugin to camel-quarkus-maven-plugin [\#1416](https://github.com/apache/camel-quarkus/pull/1416) ([lburgazzoli](https://github.com/lburgazzoli))
- CAMEL-15216 : Omit the warning of level index [\#1414](https://github.com/apache/camel-quarkus/pull/1414) ([AemieJ](https://github.com/AemieJ))
- Added an AWS2-Athena native extension [\#1412](https://github.com/apache/camel-quarkus/pull/1412) ([oscerd](https://github.com/oscerd))
- Fix \#1263 - Add the camel-jta extension [\#1411](https://github.com/apache/camel-quarkus/pull/1411) ([zhfeng](https://github.com/zhfeng))
- Update dependencies [\#1409](https://github.com/apache/camel-quarkus/pull/1409) ([lburgazzoli](https://github.com/lburgazzoli))
- Added Json Validator support \#1367 [\#1408](https://github.com/apache/camel-quarkus/pull/1408) ([aldettinger](https://github.com/aldettinger))
- Create a camel-componentdsl extension [\#1407](https://github.com/apache/camel-quarkus/pull/1407) ([lburgazzoli](https://github.com/lburgazzoli))
- Observe Camel's events [\#1405](https://github.com/apache/camel-quarkus/pull/1405) ([lburgazzoli](https://github.com/lburgazzoli))
- Observe Camel's Lifecycle events [\#1404](https://github.com/apache/camel-quarkus/pull/1404) ([lburgazzoli](https://github.com/lburgazzoli))
- Aws2 ses [\#1401](https://github.com/apache/camel-quarkus/pull/1401) ([oscerd](https://github.com/oscerd))
- Observe Camel's Management events [\#1400](https://github.com/apache/camel-quarkus/pull/1400) ([lburgazzoli](https://github.com/lburgazzoli))
- Cleanup [\#1397](https://github.com/apache/camel-quarkus/pull/1397) ([lburgazzoli](https://github.com/lburgazzoli))
- The quarkus-bootstrap-maven-plugin is listed twice on all the runtime extensions POMs [\#1396](https://github.com/apache/camel-quarkus/pull/1396) ([lburgazzoli](https://github.com/lburgazzoli))
- component injection: produce a CamelRuntimeTaskBuildItem for synchronization purpose [\#1394](https://github.com/apache/camel-quarkus/pull/1394) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix potential NPE [\#1393](https://github.com/apache/camel-quarkus/pull/1393) ([lburgazzoli](https://github.com/lburgazzoli))
- Replace joschi/setup-jdk with AdoptOpenJDK/install-jdk [\#1392](https://github.com/apache/camel-quarkus/pull/1392) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1350 List Quarkus configuration options on extension pages [\#1389](https://github.com/apache/camel-quarkus/pull/1389) ([ppalaga](https://github.com/ppalaga))
- Post Camel 3.4.0 upgrade cleanups [\#1386](https://github.com/apache/camel-quarkus/pull/1386) ([jamesnetherton](https://github.com/jamesnetherton))
- AWS2-MSK [\#1385](https://github.com/apache/camel-quarkus/pull/1385) ([oscerd](https://github.com/oscerd))
- Upgrade to Quarkus 1.5.2.Final [\#1382](https://github.com/apache/camel-quarkus/pull/1382) ([jamesnetherton](https://github.com/jamesnetherton))
- Log message for FileNotFound exception not clear enough \#1365 [\#1379](https://github.com/apache/camel-quarkus/pull/1379) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Fix \#1300 Document SSL auto-enabled by extensions [\#1378](https://github.com/apache/camel-quarkus/pull/1378) ([ppalaga](https://github.com/ppalaga))
- Adding a dependency to make example work  [\#1377](https://github.com/apache/camel-quarkus/pull/1377) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Upgrade to Camel 3.4.0 [\#1375](https://github.com/apache/camel-quarkus/pull/1375) ([jamesnetherton](https://github.com/jamesnetherton))
- Aws2 mq [\#1374](https://github.com/apache/camel-quarkus/pull/1374) ([oscerd](https://github.com/oscerd))
- Type safe component injection [\#1372](https://github.com/apache/camel-quarkus/pull/1372) ([lburgazzoli](https://github.com/lburgazzoli))
- AWS2-KMS [\#1369](https://github.com/apache/camel-quarkus/pull/1369) ([oscerd](https://github.com/oscerd))
- Fix \#838 TimeZone-less DTSTART and DTEND not changed to GMT [\#1366](https://github.com/apache/camel-quarkus/pull/1366) ([ppalaga](https://github.com/ppalaga))
- Aws2 iam [\#1364](https://github.com/apache/camel-quarkus/pull/1364) ([oscerd](https://github.com/oscerd))
- AWS2-ECS: Fixed the deployment module [\#1362](https://github.com/apache/camel-quarkus/pull/1362) ([oscerd](https://github.com/oscerd))
- AWS2 DDB [\#1361](https://github.com/apache/camel-quarkus/pull/1361) ([oscerd](https://github.com/oscerd))
- Aws2 eks [\#1354](https://github.com/apache/camel-quarkus/pull/1354) ([oscerd](https://github.com/oscerd))
- Unable to GET an https URL with netty-http client \#695 [\#1352](https://github.com/apache/camel-quarkus/pull/1352) ([JiriOndrusek](https://github.com/JiriOndrusek))
- debezium-embedded dependencies \#1340 [\#1351](https://github.com/apache/camel-quarkus/pull/1351) ([JiriOndrusek](https://github.com/JiriOndrusek))
- chore\(doc\): rephrase CamelServiceDestination javadocs. [\#1348](https://github.com/apache/camel-quarkus/pull/1348) ([lburgazzoli](https://github.com/lburgazzoli))
- debezium: exclude org.apache.kafka:kafka-log4j-appender from debezium-embedded transitive dependencies [\#1347](https://github.com/apache/camel-quarkus/pull/1347) ([lburgazzoli](https://github.com/lburgazzoli))
- integration-tests: make influxdb tests more idiomatic [\#1346](https://github.com/apache/camel-quarkus/pull/1346) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade to Quarkus 1.5.1.Final [\#1343](https://github.com/apache/camel-quarkus/pull/1343) ([ppalaga](https://github.com/ppalaga))
- Make the local Antora build produce .htaccess file with redirects based [\#1342](https://github.com/apache/camel-quarkus/pull/1342) ([ppalaga](https://github.com/ppalaga))
- Add notes related to quarkus extension configuration for amqp, kubernetes & mongo-gridfs docs [\#1341](https://github.com/apache/camel-quarkus/pull/1341) ([jamesnetherton](https://github.com/jamesnetherton))
- The next is 1.0.0-CR3 [\#1339](https://github.com/apache/camel-quarkus/pull/1339) ([ppalaga](https://github.com/ppalaga))
- Cleanup [\#1337](https://github.com/apache/camel-quarkus/pull/1337) ([lburgazzoli](https://github.com/lburgazzoli))
- Add vertx component extension [\#1336](https://github.com/apache/camel-quarkus/pull/1336) ([jamesnetherton](https://github.com/jamesnetherton))
- Declare org.graalvm.nativeimage:svm as provided [\#1335](https://github.com/apache/camel-quarkus/pull/1335) ([lburgazzoli](https://github.com/lburgazzoli))
- Revert "Fixed how to build link in create new extension guide" [\#1334](https://github.com/apache/camel-quarkus/pull/1334) ([oscerd](https://github.com/oscerd))
- Revert link [\#1333](https://github.com/apache/camel-quarkus/pull/1333) ([oscerd](https://github.com/oscerd))
- Link fix [\#1332](https://github.com/apache/camel-quarkus/pull/1332) ([oscerd](https://github.com/oscerd))
- Fix \#1066 Remove the need for registering RestBindingJaxbDataFormatFa… [\#1331](https://github.com/apache/camel-quarkus/pull/1331) ([ppalaga](https://github.com/ppalaga))
- Fixed contributor guide index.adoc links [\#1330](https://github.com/apache/camel-quarkus/pull/1330) ([oscerd](https://github.com/oscerd))
- AWS2-ECS native extension [\#1329](https://github.com/apache/camel-quarkus/pull/1329) ([oscerd](https://github.com/oscerd))
- Fixing the contributing guide links in README.adoc [\#1327](https://github.com/apache/camel-quarkus/pull/1327) ([oscerd](https://github.com/oscerd))
- Avoid duplicate feature registration of camel-support-debezium [\#1326](https://github.com/apache/camel-quarkus/pull/1326) ([jamesnetherton](https://github.com/jamesnetherton))
- Debezium tests fail on Quarkus Platform in native mode \#1311 [\#1325](https://github.com/apache/camel-quarkus/pull/1325) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Add servlet-api to classpath to help pointsto analysis \#1319 [\#1324](https://github.com/apache/camel-quarkus/pull/1324) ([galderz](https://github.com/galderz))
- Added couchdb consumer support in native mode \#1022 [\#1323](https://github.com/apache/camel-quarkus/pull/1323) ([aldettinger](https://github.com/aldettinger))
- Fix \#1314 Make Kudu native test runnable on Quarkus Platform on Java … [\#1318](https://github.com/apache/camel-quarkus/pull/1318) ([ppalaga](https://github.com/ppalaga))
- Aws2 translate [\#1317](https://github.com/apache/camel-quarkus/pull/1317) ([oscerd](https://github.com/oscerd))
- Leverage cq:promote when porting extensions from JVM to native [\#1316](https://github.com/apache/camel-quarkus/pull/1316) ([ppalaga](https://github.com/ppalaga))
- Fixed link in Debezium-sqlserver extension [\#1315](https://github.com/apache/camel-quarkus/pull/1315) ([oscerd](https://github.com/oscerd))
- chore\(pgp\): update pgp key for Nicola Ferraro [\#1307](https://github.com/apache/camel-quarkus/pull/1307) ([nicolaferraro](https://github.com/nicolaferraro))
- Add AWS2-EC2 native extension [\#1306](https://github.com/apache/camel-quarkus/pull/1306) ([oscerd](https://github.com/oscerd))
- Revert \#1299 require Java 11 [\#1305](https://github.com/apache/camel-quarkus/pull/1305) ([ppalaga](https://github.com/ppalaga))
- Fixup \#1193 Debezium SQL Server Connector native support [\#1304](https://github.com/apache/camel-quarkus/pull/1304) ([ppalaga](https://github.com/ppalaga))
- Minor fixes [\#1302](https://github.com/apache/camel-quarkus/pull/1302) ([ppalaga](https://github.com/ppalaga))
- 1.0.0-CR2 post release polishing [\#1296](https://github.com/apache/camel-quarkus/pull/1296) ([ppalaga](https://github.com/ppalaga))
- Remove superflous metrics dependencies from OpenTracing extension [\#1295](https://github.com/apache/camel-quarkus/pull/1295) ([jamesnetherton](https://github.com/jamesnetherton))
- Enable SSL for Azure extension \#1269 [\#1294](https://github.com/apache/camel-quarkus/pull/1294) ([galderz](https://github.com/galderz))
- Create extension for camel-openapi-java [\#1293](https://github.com/apache/camel-quarkus/pull/1293) ([lburgazzoli](https://github.com/lburgazzoli))
- Drop the Jaxb based XMLRoutesDefinitionLoader [\#1292](https://github.com/apache/camel-quarkus/pull/1292) ([lburgazzoli](https://github.com/lburgazzoli))
- Add rest and restapi to the list of discoverable factories [\#1290](https://github.com/apache/camel-quarkus/pull/1290) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1288: automatically set content-length or chunked on platform-ht… [\#1289](https://github.com/apache/camel-quarkus/pull/1289) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(deps\): update testcontainers to v1.14.3 [\#1279](https://github.com/apache/camel-quarkus/pull/1279) ([lburgazzoli](https://github.com/lburgazzoli))
- Debezium SQL Server Connector native support \#1193 [\#1278](https://github.com/apache/camel-quarkus/pull/1278) ([JiriOndrusek](https://github.com/JiriOndrusek))
- extension dependencies issue [\#1276](https://github.com/apache/camel-quarkus/pull/1276) ([lburgazzoli](https://github.com/lburgazzoli))
- Stub Jira endpoints for integration testing [\#1270](https://github.com/apache/camel-quarkus/pull/1270) ([jamesnetherton](https://github.com/jamesnetherton))
- Tika support [\#998](https://github.com/apache/camel-quarkus/pull/998) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Revisit camel-quarkus bootstrap [\#1344](https://github.com/apache/camel-quarkus/pull/1344) ([lburgazzoli](https://github.com/lburgazzoli))

## [1.0.0-CR2](https://github.com/apache/camel-quarkus/tree/1.0.0-CR2) (2020-05-29)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.0.0-CR1...1.0.0-CR2)

**Closed issues:**

- Revisit factory finder set-up [\#1112](https://github.com/apache/camel-quarkus/issues/1112)
- extension dependencies issue [\#1275](https://github.com/apache/camel-quarkus/issues/1275)
- Document how extension pages are generated [\#1255](https://github.com/apache/camel-quarkus/issues/1255)
- Document how quarkus-extemsion.yaml is generated [\#1243](https://github.com/apache/camel-quarkus/issues/1243)
- Per-extension documentation pages [\#1232](https://github.com/apache/camel-quarkus/issues/1232)
- Cute Extension - Add options for allowing template via header/context map [\#1212](https://github.com/apache/camel-quarkus/issues/1212)
- Use influxdb 2.18 as in Camel 3.3.0 [\#1208](https://github.com/apache/camel-quarkus/issues/1208)
- Debezium MySQL Connector native support [\#1192](https://github.com/apache/camel-quarkus/issues/1192)
- Debezium PostgresSQL Connector native support [\#1191](https://github.com/apache/camel-quarkus/issues/1191)
- ASM Unsupported api 524288 after the upgrade to Gizmo 1.0.3 [\#1182](https://github.com/apache/camel-quarkus/issues/1182)
- Avro dataformat native support [\#1180](https://github.com/apache/camel-quarkus/issues/1180)
- Add simple timer dev mode test [\#1177](https://github.com/apache/camel-quarkus/issues/1177)
- Dev mode does not work using platform 1.4.1 [\#1171](https://github.com/apache/camel-quarkus/issues/1171)
- ClassNotFoundException JAXBContext in camel-core-impl [\#1161](https://github.com/apache/camel-quarkus/issues/1161)
- Drop Kudu container-based itests infra for JDK 8 [\#1157](https://github.com/apache/camel-quarkus/issues/1157)
- javadoc plugin re-run in release:perform [\#1156](https://github.com/apache/camel-quarkus/issues/1156)
- Disable tests \(unit and integration\) while doing a release [\#1155](https://github.com/apache/camel-quarkus/issues/1155)
- Generating JavaDoc is slown on Java 11 [\#1154](https://github.com/apache/camel-quarkus/issues/1154)
- Import camel-quarkus-bom-test into camel-quarkus-build-parent-it [\#1153](https://github.com/apache/camel-quarkus/issues/1153)
- Add JDK 11 support to the Kudu container based itests infrastructure [\#1132](https://github.com/apache/camel-quarkus/issues/1132)
- mongo-gridfs should reuse the Quarkus Mongo extension [\#932](https://github.com/apache/camel-quarkus/issues/932)

## [1.0.0-CR1](https://github.com/apache/camel-quarkus/tree/1.0.0-CR1) (2020-05-27)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.0.0-M7...1.0.0-CR1)

**Closed issues:**

- Unregister unnecessary Camel configuration classes from reflection [\#1266](https://github.com/apache/camel-quarkus/issues/1266)
- \[CI\] - Camel Master Branch Build Failure [\#1261](https://github.com/apache/camel-quarkus/issues/1261)
- \[CI\] - Quarkus Master Branch Build Failure [\#1251](https://github.com/apache/camel-quarkus/issues/1251)
- REST OpenApi native support [\#1235](https://github.com/apache/camel-quarkus/issues/1235)
- Add support for MicroProfile Fault Tolerance [\#1234](https://github.com/apache/camel-quarkus/issues/1234)
- \[CI\] - Quarkus Master Branch Build Failure [\#1218](https://github.com/apache/camel-quarkus/issues/1218)
- \[CI\] - Quarkus Master Branch Build Failure [\#1210](https://github.com/apache/camel-quarkus/issues/1210)
- Kudu IT failing [\#1206](https://github.com/apache/camel-quarkus/issues/1206)
- \[CI\] - Camel Master Branch Build Failure [\#1205](https://github.com/apache/camel-quarkus/issues/1205)
- NullPointerException with telegram webhook [\#1200](https://github.com/apache/camel-quarkus/issues/1200)
- ClassNotFoundException: CamelCronService [\#1195](https://github.com/apache/camel-quarkus/issues/1195)
- \[CI\] - Quarkus Master Branch Build Failure [\#1179](https://github.com/apache/camel-quarkus/issues/1179)
- \[CI\] - Camel Master Branch Build Failure [\#1174](https://github.com/apache/camel-quarkus/issues/1174)
- Remove Elasticsearch Rest doc title fix when upgrading to Camel 3.3.0 [\#1167](https://github.com/apache/camel-quarkus/issues/1167)
- ActiveMQ XalanXPathEvaluator CNFE warning [\#1160](https://github.com/apache/camel-quarkus/issues/1160)
- \[CI\] - Quarkus Master Branch Build Failure [\#1148](https://github.com/apache/camel-quarkus/issues/1148)
- MethodAccessorGenerator reachable error in camel-activemq tests with jdk11u-dev [\#1145](https://github.com/apache/camel-quarkus/issues/1145)
- Remove register for reflection in file/ftp when upgrading to Camel 3.3 [\#1113](https://github.com/apache/camel-quarkus/issues/1113)
- Test Azure extension with Azurite [\#1072](https://github.com/apache/camel-quarkus/issues/1072)
- Improve the quality of quarkus-extension.yaml files [\#1006](https://github.com/apache/camel-quarkus/issues/1006)
- Elasticsearch Rest native mode [\#896](https://github.com/apache/camel-quarkus/issues/896)
- Cannot build examples/timer-log in native mode [\#756](https://github.com/apache/camel-quarkus/issues/756)

**Merged pull requests:**

- Add Peter Palaga's PGP key [\#1268](https://github.com/apache/camel-quarkus/pull/1268) ([ppalaga](https://github.com/ppalaga))
- Upgrade Quarkus to 1.5.0.Final [\#1267](https://github.com/apache/camel-quarkus/pull/1267) ([jamesnetherton](https://github.com/jamesnetherton))
- Remove camel-rest workaround as the fic for the issue is included in Apache Camel 3.3.0 [\#1265](https://github.com/apache/camel-quarkus/pull/1265) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1208 Use influxdb 2.18 as in Camel 3.3.0 [\#1264](https://github.com/apache/camel-quarkus/pull/1264) ([ppalaga](https://github.com/ppalaga))
- Status badges on extension pages [\#1260](https://github.com/apache/camel-quarkus/pull/1260) ([ppalaga](https://github.com/ppalaga))
- Split doc pages to user-guide and contributor-guide directories and s… [\#1259](https://github.com/apache/camel-quarkus/pull/1259) ([ppalaga](https://github.com/ppalaga))
- Debezium MySQL Connector native support \#1192 [\#1258](https://github.com/apache/camel-quarkus/pull/1258) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Fix \#1255 Document how extension pages are generated [\#1257](https://github.com/apache/camel-quarkus/pull/1257) ([ppalaga](https://github.com/ppalaga))
- Document how quarkus-extemsion.yaml is generated [\#1256](https://github.com/apache/camel-quarkus/pull/1256) ([ppalaga](https://github.com/ppalaga))
- \#1232 Extension pages [\#1254](https://github.com/apache/camel-quarkus/pull/1254) ([ppalaga](https://github.com/ppalaga))
- Upgrade to Quarkus 1.5.0.CR1 [\#1253](https://github.com/apache/camel-quarkus/pull/1253) ([ppalaga](https://github.com/ppalaga))
- Automatically cancel redundant workflow runs [\#1252](https://github.com/apache/camel-quarkus/pull/1252) ([jamesnetherton](https://github.com/jamesnetherton))
- Enable update-extension-doc-page mojo in newly scaffolded extensions [\#1250](https://github.com/apache/camel-quarkus/pull/1250) ([ppalaga](https://github.com/ppalaga))
- Fix \#1232 Per-extension documentation pages [\#1249](https://github.com/apache/camel-quarkus/pull/1249) ([ppalaga](https://github.com/ppalaga))
- Add support for MicroProfile Fault Tolerance [\#1248](https://github.com/apache/camel-quarkus/pull/1248) ([jamesnetherton](https://github.com/jamesnetherton))
- Added native support for avro dataformat \#1180 [\#1246](https://github.com/apache/camel-quarkus/pull/1246) ([aldettinger](https://github.com/aldettinger))
- Add MongoDB GridFS native support [\#1242](https://github.com/apache/camel-quarkus/pull/1242) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#1212 - Add the allowTemplateFromHeader option in the qute component [\#1241](https://github.com/apache/camel-quarkus/pull/1241) ([zhfeng](https://github.com/zhfeng))
- Reduce the number of Qute component dependencies [\#1240](https://github.com/apache/camel-quarkus/pull/1240) ([ppalaga](https://github.com/ppalaga))
- Remove duplicate kubernetes-client.version property [\#1238](https://github.com/apache/camel-quarkus/pull/1238) ([ppalaga](https://github.com/ppalaga))
- Add REST OpenApi native support [\#1236](https://github.com/apache/camel-quarkus/pull/1236) ([jamesnetherton](https://github.com/jamesnetherton))
- Bump Testcontainers to version 1.14.2 [\#1231](https://github.com/apache/camel-quarkus/pull/1231) ([oscerd](https://github.com/oscerd))
- Improve Quarkus metadata [\#1230](https://github.com/apache/camel-quarkus/pull/1230) ([ppalaga](https://github.com/ppalaga))
- Remove Elasticsearch Rest doc title fix [\#1229](https://github.com/apache/camel-quarkus/pull/1229) ([jamesnetherton](https://github.com/jamesnetherton))
- Test Azure extension with Azurite [\#1228](https://github.com/apache/camel-quarkus/pull/1228) ([jamesnetherton](https://github.com/jamesnetherton))
- Run the CI on Java 14 instead of Java 12 [\#1227](https://github.com/apache/camel-quarkus/pull/1227) ([ppalaga](https://github.com/ppalaga))
- Camel 3.3.0 upgrade follow ups [\#1226](https://github.com/apache/camel-quarkus/pull/1226) ([ppalaga](https://github.com/ppalaga))
- Upgrade to Camel 3.3.0 [\#1224](https://github.com/apache/camel-quarkus/pull/1224) ([ppalaga](https://github.com/ppalaga))
- Workaround for quarkusio/quarkus/issues/9273 [\#1221](https://github.com/apache/camel-quarkus/pull/1221) ([gnodet](https://github.com/gnodet))
- Follow the existing naming convention in SAP NetWeaver test artifactId [\#1220](https://github.com/apache/camel-quarkus/pull/1220) ([ppalaga](https://github.com/ppalaga))
- Remove 'core' prefix for main related integration tests modules [\#1217](https://github.com/apache/camel-quarkus/pull/1217) ([lburgazzoli](https://github.com/lburgazzoli))
- Introduce RuntimeCamelContextCustomizerBuildItem to allow to customize the camel context before it is started [\#1216](https://github.com/apache/camel-quarkus/pull/1216) ([lburgazzoli](https://github.com/lburgazzoli))
- Debezium PostgresSQL Connector native support \#1191 [\#1215](https://github.com/apache/camel-quarkus/pull/1215) ([JiriOndrusek](https://github.com/JiriOndrusek))
- Rename test support extension to a more meaningful name [\#1214](https://github.com/apache/camel-quarkus/pull/1214) ([lburgazzoli](https://github.com/lburgazzoli))
- Do not use version literals in BOMs [\#1213](https://github.com/apache/camel-quarkus/pull/1213) ([ppalaga](https://github.com/ppalaga))
- Refactor core module layout [\#1211](https://github.com/apache/camel-quarkus/pull/1211) ([lburgazzoli](https://github.com/lburgazzoli))
- Move integration-tests support modules out of integration-tests folder [\#1207](https://github.com/apache/camel-quarkus/pull/1207) ([lburgazzoli](https://github.com/lburgazzoli))
- Idiomatic Mustache test [\#1204](https://github.com/apache/camel-quarkus/pull/1204) ([ppalaga](https://github.com/ppalaga))
- Do not skip tests in native jobs using -DskipTest it skips also [\#1203](https://github.com/apache/camel-quarkus/pull/1203) ([ppalaga](https://github.com/ppalaga))
- fix caffeine-lrucache modules name [\#1202](https://github.com/apache/camel-quarkus/pull/1202) ([lburgazzoli](https://github.com/lburgazzoli))
- ftp: remove redundant build items [\#1201](https://github.com/apache/camel-quarkus/pull/1201) ([lburgazzoli](https://github.com/lburgazzoli))
- Ensure consistent itest name tag [\#1199](https://github.com/apache/camel-quarkus/pull/1199) ([jamesnetherton](https://github.com/jamesnetherton))
- Use artifact uploads/downloads instead of cache to pass Maven repo to… [\#1198](https://github.com/apache/camel-quarkus/pull/1198) ([ppalaga](https://github.com/ppalaga))
- Fix ClassNotFoundException when using quartz extension [\#1196](https://github.com/apache/camel-quarkus/pull/1196) ([jamesnetherton](https://github.com/jamesnetherton))
- Import software.amazon.awssdk:bom instead of managing the items indiv… [\#1194](https://github.com/apache/camel-quarkus/pull/1194) ([ppalaga](https://github.com/ppalaga))
- AWS2-Commons extensions: Added back SSL Native support [\#1189](https://github.com/apache/camel-quarkus/pull/1189) ([oscerd](https://github.com/oscerd))
- Add branch commit to the intergration build failure report [\#1187](https://github.com/apache/camel-quarkus/pull/1187) ([ppalaga](https://github.com/ppalaga))
- AWS2 Extensions cleanup [\#1186](https://github.com/apache/camel-quarkus/pull/1186) ([oscerd](https://github.com/oscerd))
- Add jaxb as dependency and allow skipping formatting [\#1185](https://github.com/apache/camel-quarkus/pull/1185) ([galderz](https://github.com/galderz))
- Build Quarkus master faster with -Denforcer.skip -Dquarkus.build.skip… [\#1184](https://github.com/apache/camel-quarkus/pull/1184) ([ppalaga](https://github.com/ppalaga))
- Fix \#1182 ASM Unsupported api 524288 after the upgrade to Gizmo 1.0.3 [\#1183](https://github.com/apache/camel-quarkus/pull/1183) ([ppalaga](https://github.com/ppalaga))
- Upgrade Quarkus to 1.4.2.Final [\#1181](https://github.com/apache/camel-quarkus/pull/1181) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#1177 Add simple timer dev mode test [\#1178](https://github.com/apache/camel-quarkus/pull/1178) ([ppalaga](https://github.com/ppalaga))
- Fixed the jvm8 CI build \#1157 [\#1176](https://github.com/apache/camel-quarkus/pull/1176) ([aldettinger](https://github.com/aldettinger))
- Code cleanup [\#1175](https://github.com/apache/camel-quarkus/pull/1175) ([lburgazzoli](https://github.com/lburgazzoli))
- Bump Jandex to version 1.0.8 [\#1172](https://github.com/apache/camel-quarkus/pull/1172) ([oscerd](https://github.com/oscerd))
- Bump Camel-Quarkus last release to 1.0.0-M7 [\#1170](https://github.com/apache/camel-quarkus/pull/1170) ([oscerd](https://github.com/oscerd))
- Replace hard coded native test categories with dynamic lookup [\#1169](https://github.com/apache/camel-quarkus/pull/1169) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#1153 Import camel-quarkus-bom-test into camel-quarkus-build-pare… [\#1168](https://github.com/apache/camel-quarkus/pull/1168) ([ppalaga](https://github.com/ppalaga))
- Upgrade Quarkus Qpid JMS to 0.14.1 [\#1165](https://github.com/apache/camel-quarkus/pull/1165) ([jamesnetherton](https://github.com/jamesnetherton))
- Add native support for Elasticsearch REST [\#1164](https://github.com/apache/camel-quarkus/pull/1164) ([jamesnetherton](https://github.com/jamesnetherton))
- Release process improvements [\#1162](https://github.com/apache/camel-quarkus/pull/1162) ([ppalaga](https://github.com/ppalaga))
- deps: update kotlin to v1.3.72 [\#1159](https://github.com/apache/camel-quarkus/pull/1159) ([lburgazzoli](https://github.com/lburgazzoli))
- Improve master -\> camel-master sync workflow [\#1158](https://github.com/apache/camel-quarkus/pull/1158) ([jamesnetherton](https://github.com/jamesnetherton))
- build: create build-parent-it pom to collect common integration tests set-up [\#1151](https://github.com/apache/camel-quarkus/pull/1151) ([lburgazzoli](https://github.com/lburgazzoli))
- Automatic sync branch master to camel-master [\#1150](https://github.com/apache/camel-quarkus/pull/1150) ([github-actions[bot]](https://github.com/apps/github-actions))
- Upgrade Activemq to version 5.11.12 [\#1149](https://github.com/apache/camel-quarkus/pull/1149) ([oscerd](https://github.com/oscerd))
- Update quarkus to v1.4.1.Final [\#1147](https://github.com/apache/camel-quarkus/pull/1147) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade Quarkus Qpid JMS to 0.14.0 [\#1143](https://github.com/apache/camel-quarkus/pull/1143) ([jamesnetherton](https://github.com/jamesnetherton))
- Exclude docs module from quarkus-master sync build [\#1139](https://github.com/apache/camel-quarkus/pull/1139) ([jamesnetherton](https://github.com/jamesnetherton))
- Bump Github-api to version 1.111 [\#1138](https://github.com/apache/camel-quarkus/pull/1138) ([oscerd](https://github.com/oscerd))
- Bump Testcontainers to version 1.14.1 [\#1137](https://github.com/apache/camel-quarkus/pull/1137) ([oscerd](https://github.com/oscerd))
- Update quarkus to v1.4.0.Final [\#1135](https://github.com/apache/camel-quarkus/pull/1135) ([lburgazzoli](https://github.com/lburgazzoli))
- Added an AWS2-CW native extension [\#1134](https://github.com/apache/camel-quarkus/pull/1134) ([oscerd](https://github.com/oscerd))
- Added release guide to the documentation [\#1131](https://github.com/apache/camel-quarkus/pull/1131) ([oscerd](https://github.com/oscerd))
- Add a doc page to describe the CI setup [\#1130](https://github.com/apache/camel-quarkus/pull/1130) ([jamesnetherton](https://github.com/jamesnetherton))
- Fixed wrong repository to point for releasing [\#1129](https://github.com/apache/camel-quarkus/pull/1129) ([oscerd](https://github.com/oscerd))
- Improve master -\> quarkus-master branch scheduled synchronization workflow [\#1127](https://github.com/apache/camel-quarkus/pull/1127) ([jamesnetherton](https://github.com/jamesnetherton))
- Fixes CAMEL-14945: move attribute to component descriptor... [\#1125](https://github.com/apache/camel-quarkus/pull/1125) ([djencks](https://github.com/djencks))
- Automatic sync branch master to quarkus-master [\#1124](https://github.com/apache/camel-quarkus/pull/1124) ([github-actions[bot]](https://github.com/apps/github-actions))
- Fix Kudu native build on JDK 11 [\#1122](https://github.com/apache/camel-quarkus/pull/1122) ([jamesnetherton](https://github.com/jamesnetherton))
- Trigger project build on push [\#1119](https://github.com/apache/camel-quarkus/pull/1119) ([jamesnetherton](https://github.com/jamesnetherton))
- Automatic sync branch master to quarkus-master [\#1118](https://github.com/apache/camel-quarkus/pull/1118) ([github-actions[bot]](https://github.com/apps/github-actions))
- Dynamic endpoint cannot be resolved properly \(toD\) [\#1117](https://github.com/apache/camel-quarkus/pull/1117) ([lburgazzoli](https://github.com/lburgazzoli))
- Paho extension native support for Websocket Connections [\#1114](https://github.com/apache/camel-quarkus/pull/1114) ([lburgazzoli](https://github.com/lburgazzoli))
- Automatic sync branch master to quarkus-master [\#1111](https://github.com/apache/camel-quarkus/pull/1111) ([github-actions[bot]](https://github.com/apps/github-actions))
- Add integration test for \#1105 [\#1110](https://github.com/apache/camel-quarkus/pull/1110) ([philschaller](https://github.com/philschaller))
- Remove unneccessary reflective class registration for camel configuration [\#1107](https://github.com/apache/camel-quarkus/pull/1107) ([jamesnetherton](https://github.com/jamesnetherton))
- Automatic sync branch master to camel-master [\#1106](https://github.com/apache/camel-quarkus/pull/1106) ([github-actions[bot]](https://github.com/apps/github-actions))
- Automatic sync branch master to quarkus-master [\#1104](https://github.com/apache/camel-quarkus/pull/1104) ([github-actions[bot]](https://github.com/apps/github-actions))
- Simplify the Catalog related code after the upgrade to Camel 3.2.0 [\#1103](https://github.com/apache/camel-quarkus/pull/1103) ([ppalaga](https://github.com/ppalaga))
- Automatic sync branch master to quarkus-master [\#1102](https://github.com/apache/camel-quarkus/pull/1102) ([github-actions[bot]](https://github.com/apps/github-actions))
- Added an AWS2 SNS extension [\#1100](https://github.com/apache/camel-quarkus/pull/1100) ([oscerd](https://github.com/oscerd))
- Docs navigation improvements, docs wording [\#1098](https://github.com/apache/camel-quarkus/pull/1098) ([ppalaga](https://github.com/ppalaga))
- Fixed Typo in the antora.yml file [\#1096](https://github.com/apache/camel-quarkus/pull/1096) ([oscerd](https://github.com/oscerd))
- Kubernetes extension native support [\#1095](https://github.com/apache/camel-quarkus/pull/1095) ([jamesnetherton](https://github.com/jamesnetherton))
- Automatic sync branch master to quarkus-master [\#1094](https://github.com/apache/camel-quarkus/pull/1094) ([github-actions[bot]](https://github.com/apps/github-actions))
- Introducing an AWS2 support extension [\#1093](https://github.com/apache/camel-quarkus/pull/1093) ([oscerd](https://github.com/oscerd))
- Fix AMQP tests hanging in CI environment [\#1091](https://github.com/apache/camel-quarkus/pull/1091) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade Quarkus to 1.4.0.CR1 [\#1089](https://github.com/apache/camel-quarkus/pull/1089) ([jamesnetherton](https://github.com/jamesnetherton))
- Automatic sync branch master to quarkus-master [\#1087](https://github.com/apache/camel-quarkus/pull/1087) ([github-actions[bot]](https://github.com/apps/github-actions))
- AWS2 S3 native extension [\#1085](https://github.com/apache/camel-quarkus/pull/1085) ([oscerd](https://github.com/oscerd))
- Upgrade Jackson to version 2.10.3 to align with Camel version used [\#1082](https://github.com/apache/camel-quarkus/pull/1082) ([oscerd](https://github.com/oscerd))
- Upgrade to Testcontainers 1.14.0 [\#1081](https://github.com/apache/camel-quarkus/pull/1081) ([oscerd](https://github.com/oscerd))
- Automatic sync branch master to quarkus-master [\#1080](https://github.com/apache/camel-quarkus/pull/1080) ([github-actions[bot]](https://github.com/apps/github-actions))
- http-log example [\#1079](https://github.com/apache/camel-quarkus/pull/1079) ([davsclaus](https://github.com/davsclaus))
- Fix \#984 introduce the CamelContextCustomizerBuildItem [\#1076](https://github.com/apache/camel-quarkus/pull/1076) ([zhfeng](https://github.com/zhfeng))
- Automatic sync branch master to camel-master [\#1074](https://github.com/apache/camel-quarkus/pull/1074) ([github-actions[bot]](https://github.com/apps/github-actions))
- Bump to Camel Quarkus 1.0.0-M6 [\#1073](https://github.com/apache/camel-quarkus/pull/1073) ([oscerd](https://github.com/oscerd))
- Add a native extension for AWS2-SQS [\#1070](https://github.com/apache/camel-quarkus/pull/1070) ([oscerd](https://github.com/oscerd))
- Sidebar menu tidy up names-14567 [\#1068](https://github.com/apache/camel-quarkus/pull/1068) ([rimshach](https://github.com/rimshach))
- Post 3.2 cleanup [\#1067](https://github.com/apache/camel-quarkus/pull/1067) ([lburgazzoli](https://github.com/lburgazzoli))
- Move spring's kotlin processors and substitutions to a dedicated file [\#1065](https://github.com/apache/camel-quarkus/pull/1065) ([lburgazzoli](https://github.com/lburgazzoli))
- Post Camel 3.2.0 upgrade fixes [\#1063](https://github.com/apache/camel-quarkus/pull/1063) ([jamesnetherton](https://github.com/jamesnetherton))
- Automatic sync branch master to quarkus-master [\#1062](https://github.com/apache/camel-quarkus/pull/1062) ([github-actions[bot]](https://github.com/apps/github-actions))
- Use test resources instead of system properties for easy testing within the quarkus platform [\#1060](https://github.com/apache/camel-quarkus/pull/1060) ([lburgazzoli](https://github.com/lburgazzoli))
- CI build improvements [\#1059](https://github.com/apache/camel-quarkus/pull/1059) ([jamesnetherton](https://github.com/jamesnetherton))
- Bump Quarkus to version 1.3.2.Final [\#1056](https://github.com/apache/camel-quarkus/pull/1056) ([oscerd](https://github.com/oscerd))
- Moved the guide to promote a JVM Only extension to native to a dedica… [\#1052](https://github.com/apache/camel-quarkus/pull/1052) ([aldettinger](https://github.com/aldettinger))
- Completed the contributor guide with a section to promote JVM Only ex… [\#1051](https://github.com/apache/camel-quarkus/pull/1051) ([aldettinger](https://github.com/aldettinger))
- InfluxDB native support \#1036 [\#1050](https://github.com/apache/camel-quarkus/pull/1050) ([JiriOndrusek](https://github.com/JiriOndrusek))
- CI build improvements [\#1049](https://github.com/apache/camel-quarkus/pull/1049) ([jamesnetherton](https://github.com/jamesnetherton))
- Webhook component support [\#1048](https://github.com/apache/camel-quarkus/pull/1048) ([jamesnetherton](https://github.com/jamesnetherton))
- Servlet tests \#853 \#854 [\#1046](https://github.com/apache/camel-quarkus/pull/1046) ([ppalaga](https://github.com/ppalaga))
- Update groovy to v3.0.2 [\#1045](https://github.com/apache/camel-quarkus/pull/1045) ([lburgazzoli](https://github.com/lburgazzoli))
- BeanInfo::getImplClazz can be null for primitives or arrays [\#1043](https://github.com/apache/camel-quarkus/pull/1043) ([lburgazzoli](https://github.com/lburgazzoli))
- TrustStoreResource does not work on Java 11 [\#1042](https://github.com/apache/camel-quarkus/pull/1042) ([lburgazzoli](https://github.com/lburgazzoli))
- SAP NetWeaver native support [\#1038](https://github.com/apache/camel-quarkus/pull/1038) ([jamesnetherton](https://github.com/jamesnetherton))
- Automatic sync branch master to quarkus-master [\#1033](https://github.com/apache/camel-quarkus/pull/1033) ([github-actions[bot]](https://github.com/apps/github-actions))
- Fix intermittent failure of messaging tests [\#1031](https://github.com/apache/camel-quarkus/pull/1031) ([jamesnetherton](https://github.com/jamesnetherton))
- AWS-SWF: Make the extension native [\#1030](https://github.com/apache/camel-quarkus/pull/1030) ([oscerd](https://github.com/oscerd))
- Revisit \#1017 Be even less intrusive when registering our Transformer… [\#1027](https://github.com/apache/camel-quarkus/pull/1027) ([ppalaga](https://github.com/ppalaga))
- chore\(xslt\): cleanup and small fix [\#1026](https://github.com/apache/camel-quarkus/pull/1026) ([lburgazzoli](https://github.com/lburgazzoli))
- Temporarilly disable JmsTest until \#1023 is fixed [\#1025](https://github.com/apache/camel-quarkus/pull/1025) ([jamesnetherton](https://github.com/jamesnetherton))
- Added native support for Couchdb extension in producer mode \#989 [\#1024](https://github.com/apache/camel-quarkus/pull/1024) ([aldettinger](https://github.com/aldettinger))
- Camel-AWS-SDB: Make the extension Native [\#1020](https://github.com/apache/camel-quarkus/pull/1020) ([oscerd](https://github.com/oscerd))
- chore: small cleanup [\#1019](https://github.com/apache/camel-quarkus/pull/1019) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1017 Do not hardcode the TransformerFactory implementation irrev… [\#1018](https://github.com/apache/camel-quarkus/pull/1018) ([ppalaga](https://github.com/ppalaga))
- Use testcontainer to test camel infinispan extension to reduce test dependencies on infinispan [\#1014](https://github.com/apache/camel-quarkus/pull/1014) ([lburgazzoli](https://github.com/lburgazzoli))
- Workaround for the platform http not be able to handle matchOnUriPrefix [\#1012](https://github.com/apache/camel-quarkus/pull/1012) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix native images issues on Java 11 [\#1011](https://github.com/apache/camel-quarkus/pull/1011) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#706 Improve RuntimeCatalogConfig docs [\#1009](https://github.com/apache/camel-quarkus/pull/1009) ([ppalaga](https://github.com/ppalaga))
- Fix \#963 Build processor class template may create redundant LOG field [\#1008](https://github.com/apache/camel-quarkus/pull/1008) ([ppalaga](https://github.com/ppalaga))
- Upgrade Quarkus Qpid JMS to 0.13.1 [\#1007](https://github.com/apache/camel-quarkus/pull/1007) ([jamesnetherton](https://github.com/jamesnetherton))
- Make consul depend on core-cloud \#1003 [\#1004](https://github.com/apache/camel-quarkus/pull/1004) ([galderz](https://github.com/galderz))
- New source assembly descriptor and root pom rename [\#1002](https://github.com/apache/camel-quarkus/pull/1002) ([ppalaga](https://github.com/ppalaga))
- Add jaxb dependency \#996 [\#997](https://github.com/apache/camel-quarkus/pull/997) ([galderz](https://github.com/galderz))
- Automatic sync branch master to quarkus-master [\#993](https://github.com/apache/camel-quarkus/pull/993) ([github-actions[bot]](https://github.com/apps/github-actions))
- Update Quarkus to v1.3.1.Final [\#992](https://github.com/apache/camel-quarkus/pull/992) ([lburgazzoli](https://github.com/lburgazzoli))
- Make a tabular list of examples for the examples page [\#991](https://github.com/apache/camel-quarkus/pull/991) ([AemieJ](https://github.com/AemieJ))
- \[CAMEL-13704\] - Added PR template file with instructions on what to include [\#990](https://github.com/apache/camel-quarkus/pull/990) ([Xxyumi-hub](https://github.com/Xxyumi-hub))
- Fix \#253 Build time property to register classes for reflection [\#987](https://github.com/apache/camel-quarkus/pull/987) ([ppalaga](https://github.com/ppalaga))
- Update Quarkus extension description for zip-deflater and lzf [\#986](https://github.com/apache/camel-quarkus/pull/986) ([rsvoboda](https://github.com/rsvoboda))
- Move quarkus.camel.resources.\* config options to quarkus.camel.native… [\#983](https://github.com/apache/camel-quarkus/pull/983) ([ppalaga](https://github.com/ppalaga))
- Add GitHub extension [\#982](https://github.com/apache/camel-quarkus/pull/982) ([jamesnetherton](https://github.com/jamesnetherton))
- Separate some misc extensions into their own categories [\#981](https://github.com/apache/camel-quarkus/pull/981) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix asciidoc syntax errors in native-mode.adoc [\#980](https://github.com/apache/camel-quarkus/pull/980) ([djencks](https://github.com/djencks))
- Fix asciidoc syntax error [\#979](https://github.com/apache/camel-quarkus/pull/979) ([djencks](https://github.com/djencks))
- Add Google Pubsub extension \(JVM only\) [\#978](https://github.com/apache/camel-quarkus/pull/978) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#976 REST OpenApi support \(JVM only\) [\#977](https://github.com/apache/camel-quarkus/pull/977) ([ppalaga](https://github.com/ppalaga))
- Speedup the Validate PR Style GH workflow by invoking only mvn validate [\#975](https://github.com/apache/camel-quarkus/pull/975) ([ppalaga](https://github.com/ppalaga))
- Protobuf and gRPC [\#974](https://github.com/apache/camel-quarkus/pull/974) ([ppalaga](https://github.com/ppalaga))
- Clean up poms: introduce test BOM, manage only where necessary [\#973](https://github.com/apache/camel-quarkus/pull/973) ([ppalaga](https://github.com/ppalaga))
- Documented the use of quarkus.camel.resources.\*-patterns \#961 [\#971](https://github.com/apache/camel-quarkus/pull/971) ([aldettinger](https://github.com/aldettinger))
- Update to add the camel-servicenow extension [\#970](https://github.com/apache/camel-quarkus/pull/970) ([zhfeng](https://github.com/zhfeng))
- Add Avro JVM Extension [\#969](https://github.com/apache/camel-quarkus/pull/969) ([mmelko](https://github.com/mmelko))
- Add AMQP extension [\#968](https://github.com/apache/camel-quarkus/pull/968) ([jamesnetherton](https://github.com/jamesnetherton))
- Remove redundant native profile from kubernetes extension [\#967](https://github.com/apache/camel-quarkus/pull/967) ([jamesnetherton](https://github.com/jamesnetherton))
- Add Kubernetes extension \(JVM only\) [\#966](https://github.com/apache/camel-quarkus/pull/966) ([jamesnetherton](https://github.com/jamesnetherton))
- AWS SWF and SDB [\#962](https://github.com/apache/camel-quarkus/pull/962) ([ppalaga](https://github.com/ppalaga))
- Added options to select resources for inclusion in native executable \#868 [\#960](https://github.com/apache/camel-quarkus/pull/960) ([aldettinger](https://github.com/aldettinger))
- Fix \#936 Warn if JVM only extensions are used in native mode [\#957](https://github.com/apache/camel-quarkus/pull/957) ([ppalaga](https://github.com/ppalaga))
- AWS 2 [\#955](https://github.com/apache/camel-quarkus/pull/955) ([ppalaga](https://github.com/ppalaga))
- Add Google BigQuery extension [\#954](https://github.com/apache/camel-quarkus/pull/954) ([jamesnetherton](https://github.com/jamesnetherton))
- Automatic sync branch master to quarkus-master [\#940](https://github.com/apache/camel-quarkus/pull/940) ([github-actions[bot]](https://github.com/apps/github-actions))
- SAP NetWeaver, Groovy and OGNL [\#938](https://github.com/apache/camel-quarkus/pull/938) ([ppalaga](https://github.com/ppalaga))
- Add quartz & cron extensions [\#935](https://github.com/apache/camel-quarkus/pull/935) ([jamesnetherton](https://github.com/jamesnetherton))
- PubNub and RabbitMQ [\#933](https://github.com/apache/camel-quarkus/pull/933) ([ppalaga](https://github.com/ppalaga))
- OpenStack support \(JVM only\) [\#930](https://github.com/apache/camel-quarkus/pull/930) ([jamesnetherton](https://github.com/jamesnetherton))
- InfluxDB, Kudu, MongoDB GridFS and Nitrite [\#929](https://github.com/apache/camel-quarkus/pull/929) ([ppalaga](https://github.com/ppalaga))
- Updated Maven version in Prerequisites section [\#923](https://github.com/apache/camel-quarkus/pull/923) ([djcoleman](https://github.com/djcoleman))
- Use Awaitility to poll for Google calendar deletion [\#921](https://github.com/apache/camel-quarkus/pull/921) ([jamesnetherton](https://github.com/jamesnetherton))
- Debezium connectors [\#920](https://github.com/apache/camel-quarkus/pull/920) ([ppalaga](https://github.com/ppalaga))
- Add Google Sheets extension [\#919](https://github.com/apache/camel-quarkus/pull/919) ([jamesnetherton](https://github.com/jamesnetherton))
- Add Google Calendar extension [\#914](https://github.com/apache/camel-quarkus/pull/914) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(deprecation\): replace usage fo deprecated io.quarkus.vertx.web.deployment.BodyHandlerBuildItem [\#913](https://github.com/apache/camel-quarkus/pull/913) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(it\): small telegram tests cleanup [\#912](https://github.com/apache/camel-quarkus/pull/912) ([lburgazzoli](https://github.com/lburgazzoli))
- Cassandra, CouchDB and Couchbase [\#911](https://github.com/apache/camel-quarkus/pull/911) ([ppalaga](https://github.com/ppalaga))
- Add Google Drive extension [\#907](https://github.com/apache/camel-quarkus/pull/907) ([jamesnetherton](https://github.com/jamesnetherton))
- Add Google Mail extension [\#905](https://github.com/apache/camel-quarkus/pull/905) ([jamesnetherton](https://github.com/jamesnetherton))
- POM enhancements [\#903](https://github.com/apache/camel-quarkus/pull/903) ([ppalaga](https://github.com/ppalaga))
- Fix \#901 GraphQLResource should read from the classpath instead from … [\#902](https://github.com/apache/camel-quarkus/pull/902) ([ppalaga](https://github.com/ppalaga))
- Bump to Camel-Quarkus 1.0.0-M5 [\#900](https://github.com/apache/camel-quarkus/pull/900) ([oscerd](https://github.com/oscerd))
- Fix \#897 List the JVM-only extensions in the docs [\#898](https://github.com/apache/camel-quarkus/pull/898) ([ppalaga](https://github.com/ppalaga))
- The first JVM-only extension [\#895](https://github.com/apache/camel-quarkus/pull/895) ([ppalaga](https://github.com/ppalaga))
- telegram extension cannot construct IncomingMessageEntity for commands [\#893](https://github.com/apache/camel-quarkus/pull/893) ([lburgazzoli](https://github.com/lburgazzoli))
- Automatic sync branch master to quarkus-master [\#890](https://github.com/apache/camel-quarkus/pull/890) ([github-actions[bot]](https://github.com/apps/github-actions))
- camel-quarkus-core: make caffeine cache optional [\#887](https://github.com/apache/camel-quarkus/pull/887) ([lburgazzoli](https://github.com/lburgazzoli))
- Add soap dataformat quarkus extension [\#883](https://github.com/apache/camel-quarkus/pull/883) ([mmelko](https://github.com/mmelko))
- Update to introduce the quarkus qute extension [\#878](https://github.com/apache/camel-quarkus/pull/878) ([zhfeng](https://github.com/zhfeng))

## [1.0.0-M7](https://github.com/apache/camel-quarkus/tree/1.0.0-M7) (2020-04-27)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.0.0-M6...1.0.0-M7)

**Fixed bugs:**

- Property binding requires reflective access to configuration classes [\#843](https://github.com/apache/camel-quarkus/issues/843)
- Gson integration test fails with Camel 3.1.0  [\#776](https://github.com/apache/camel-quarkus/issues/776)

**Closed issues:**

- \[CI\] - Quarkus Master Branch Build Failure [\#1136](https://github.com/apache/camel-quarkus/issues/1136)
- Added AWS2-CW native extension [\#1133](https://github.com/apache/camel-quarkus/issues/1133)
- Quarkus Master - Classes that should be initialized at run time got initialized during image building  [\#1126](https://github.com/apache/camel-quarkus/issues/1126)
- Kudu native build fails [\#1121](https://github.com/apache/camel-quarkus/issues/1121)
- Dynamic endpoint cannot be resolved properly \(toD\) [\#1116](https://github.com/apache/camel-quarkus/issues/1116)
- ActiveMQ test failing with Quarkus master [\#1115](https://github.com/apache/camel-quarkus/issues/1115)
- Paho extension native support for Websocket Connections [\#1109](https://github.com/apache/camel-quarkus/issues/1109)
- Read lock options for files are ignored [\#1105](https://github.com/apache/camel-quarkus/issues/1105)
- AWS2-SNS native extension [\#1099](https://github.com/apache/camel-quarkus/issues/1099)
- Kudu extension native support [\#1097](https://github.com/apache/camel-quarkus/issues/1097)
- Create a support extension for AWS2 [\#1092](https://github.com/apache/camel-quarkus/issues/1092)
- AWS2-S3 native extension [\#1084](https://github.com/apache/camel-quarkus/issues/1084)
- AWS2-SQS native followups [\#1083](https://github.com/apache/camel-quarkus/issues/1083)
- Camel JMX is logged as enabled for native compiled example [\#1078](https://github.com/apache/camel-quarkus/issues/1078)
- Is quarkus.ssl.native=true still needed [\#1077](https://github.com/apache/camel-quarkus/issues/1077)
- Move extension aws2-sqs to native extensions [\#1069](https://github.com/apache/camel-quarkus/issues/1069)
- Reinstate MongoDB extensions [\#1064](https://github.com/apache/camel-quarkus/issues/1064)
- Revert dependency patch after Camel 3.2 upgrade [\#1040](https://github.com/apache/camel-quarkus/issues/1040)
- Kubernetes extension native support [\#1039](https://github.com/apache/camel-quarkus/issues/1039)
- InfluxDB native support [\#1036](https://github.com/apache/camel-quarkus/issues/1036)
- Remove platform-http workaround when upgrading camel to 3.2.0 [\#1013](https://github.com/apache/camel-quarkus/issues/1013)
- Camel-Avro: In 3.2.0 it will be splitted in camel-avro and camel-avro-rpc [\#995](https://github.com/apache/camel-quarkus/issues/995)
- Introduce the CamelContextCustomizerBuildItem to do further customization of the camel context [\#984](https://github.com/apache/camel-quarkus/issues/984)
- Platform HTTP consumer does not support matchOnUriPrefix [\#880](https://github.com/apache/camel-quarkus/issues/880)

## [1.0.0-M6](https://github.com/apache/camel-quarkus/tree/1.0.0-M6) (2020-04-09)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.0.0-M5...1.0.0-M6)

**Implemented enhancements:**

- Don't publish integration tests during a Maven release [\#842](https://github.com/apache/camel-quarkus/issues/842)
- Create a Camel Kubernetes extension [\#303](https://github.com/apache/camel-quarkus/issues/303)
- Create a Camel AMQP extension [\#143](https://github.com/apache/camel-quarkus/issues/143)

**Fixed bugs:**

- Olingo4 native mode integration test failure [\#1061](https://github.com/apache/camel-quarkus/issues/1061)
- XML integration tests fail in native mode on JDK 11 [\#1000](https://github.com/apache/camel-quarkus/issues/1000)
- RestBindingReifier.setupJaxb fails in native mode with JDK 11 [\#999](https://github.com/apache/camel-quarkus/issues/999)
- CustomDefaultServletClassTest Failed to index: org.apache.camel.quarkus.component.servlet.test.CustomServlet [\#854](https://github.com/apache/camel-quarkus/issues/854)
- NoDefaultServletTest cannot find property quarkus.camel.servlet.url-patterns [\#853](https://github.com/apache/camel-quarkus/issues/853)
- TrustStoreResource does not work on Java 11 [\#852](https://github.com/apache/camel-quarkus/issues/852)

**Closed issues:**

- Upgrade Quarkus to version 1.3.2.Final [\#1054](https://github.com/apache/camel-quarkus/issues/1054)
- NPE in ContainerBeansBuildItem [\#1044](https://github.com/apache/camel-quarkus/issues/1044)
- Vertx throws exception IllegalStateException: Request has already been read [\#1032](https://github.com/apache/camel-quarkus/issues/1032)
- Camel-AWS-SWF: Support native [\#1029](https://github.com/apache/camel-quarkus/issues/1029)
- Intermittent failure of messaging tests [\#1023](https://github.com/apache/camel-quarkus/issues/1023)
- Create a doc page to list necessary steps to promote a jvm-only extension to native [\#1021](https://github.com/apache/camel-quarkus/issues/1021)
- Do not hardcode the TransformerFactory implementation irreversibly [\#1017](https://github.com/apache/camel-quarkus/issues/1017)
- Camel-AWS-SDB: Support native [\#1016](https://github.com/apache/camel-quarkus/issues/1016)
- camle-tagsoup extension tests  fails in native mode on Jdk 11 [\#1010](https://github.com/apache/camel-quarkus/issues/1010)
- PropertyBindingException slidingwindowsize [\#1005](https://github.com/apache/camel-quarkus/issues/1005)
- ClassNotFoundException Caffeine SSLMS [\#1003](https://github.com/apache/camel-quarkus/issues/1003)
- Rename the top module from camel-quarkus-parent to camel-quarkus [\#1001](https://github.com/apache/camel-quarkus/issues/1001)
- Unresolved type JAXBContext [\#996](https://github.com/apache/camel-quarkus/issues/996)
- Couchdb native support for Producer Mode [\#989](https://github.com/apache/camel-quarkus/issues/989)
- REST OpenApi support \(JVM only\) [\#976](https://github.com/apache/camel-quarkus/issues/976)
- gRPC support \(JVM only\) [\#965](https://github.com/apache/camel-quarkus/issues/965)
- Protobuf dataformat support \(JVM only\) [\#964](https://github.com/apache/camel-quarkus/issues/964)
- Build processor class template may create redundant LOG field  [\#963](https://github.com/apache/camel-quarkus/issues/963)
- Document the use of quarkus.camel.resources.\*-patterns [\#961](https://github.com/apache/camel-quarkus/issues/961)
- AWS SimpleDB support \(JVM only\) [\#959](https://github.com/apache/camel-quarkus/issues/959)
- AWS Simple Workflow support \(JVM only\) [\#958](https://github.com/apache/camel-quarkus/issues/958)
- SAP NetWeaver native support [\#956](https://github.com/apache/camel-quarkus/issues/956)
- AWS 2 Translate support \(JVM only\) [\#953](https://github.com/apache/camel-quarkus/issues/953)
- AWS 2 Simple Queue Service support \(JVM only\) [\#952](https://github.com/apache/camel-quarkus/issues/952)
- AWS 2 Simple Notification System support \(JVM only\) [\#951](https://github.com/apache/camel-quarkus/issues/951)
- AWS 2 Simple Email Service support \(JVM only\) [\#950](https://github.com/apache/camel-quarkus/issues/950)
- AWS 2 MSK support \(JVM only\) [\#949](https://github.com/apache/camel-quarkus/issues/949)
- AWS 2 MQ support \(JVM only\) [\#948](https://github.com/apache/camel-quarkus/issues/948)
- AWS 2 KMS support \(JVM only\) [\#947](https://github.com/apache/camel-quarkus/issues/947)
- AWS 2 IAM support \(JVM only\) [\#946](https://github.com/apache/camel-quarkus/issues/946)
- AWS 2 EKS support \(JVM only\) [\#945](https://github.com/apache/camel-quarkus/issues/945)
- AWS 2 ECS support \(JVM only\) [\#944](https://github.com/apache/camel-quarkus/issues/944)
- AWS 2 EC2 support \(JVM only\) [\#943](https://github.com/apache/camel-quarkus/issues/943)
- AWS 2 DynamoDB support \(JVM only\) [\#942](https://github.com/apache/camel-quarkus/issues/942)
- AWS 2 CloudWatch support \(JVM only\) [\#941](https://github.com/apache/camel-quarkus/issues/941)
- SAP NetWeaver support \(JVM only\) [\#937](https://github.com/apache/camel-quarkus/issues/937)
- Warn if JVM only extensions are used in native mode [\#936](https://github.com/apache/camel-quarkus/issues/936)
- PubNub support [\#931](https://github.com/apache/camel-quarkus/issues/931)
- Nitrite support [\#928](https://github.com/apache/camel-quarkus/issues/928)
- MongoDB GridFS support [\#927](https://github.com/apache/camel-quarkus/issues/927)
- Kudu support [\#926](https://github.com/apache/camel-quarkus/issues/926)
- InfluxDB support [\#925](https://github.com/apache/camel-quarkus/issues/925)
- Openstack support [\#922](https://github.com/apache/camel-quarkus/issues/922)
- Debezium SQL Server Connector support [\#918](https://github.com/apache/camel-quarkus/issues/918)
- Debezium MySQL Connector support [\#917](https://github.com/apache/camel-quarkus/issues/917)
- Debezium PostgresSQL Connector support [\#916](https://github.com/apache/camel-quarkus/issues/916)
- Debezium MongoDB Connector support [\#915](https://github.com/apache/camel-quarkus/issues/915)
- CouchDB support [\#910](https://github.com/apache/camel-quarkus/issues/910)
- Couchbase support \(JVM only\) [\#909](https://github.com/apache/camel-quarkus/issues/909)
- Cassandra CQL support [\#908](https://github.com/apache/camel-quarkus/issues/908)
- GraphQLResource should read from the classpath instead from the filesystem [\#901](https://github.com/apache/camel-quarkus/issues/901)
- camel-quarkus-elasticsearch-rest build fails with "Dependency convergence error" [\#899](https://github.com/apache/camel-quarkus/issues/899)
- List the JVM-only extensions in the docs [\#897](https://github.com/apache/camel-quarkus/issues/897)
- Elastichsearch Rest support [\#894](https://github.com/apache/camel-quarkus/issues/894)
- telegram extension cannot construct IncomingMessageEntity for commands [\#888](https://github.com/apache/camel-quarkus/issues/888)
- camel-quarkus-core: make caffeine cache optional [\#886](https://github.com/apache/camel-quarkus/issues/886)
- Add templates config option to the Mustache extension [\#868](https://github.com/apache/camel-quarkus/issues/868)
- Duplicate LICENSE\(.txt\) and NOTICE\(.txt\) files in the source distribution [\#844](https://github.com/apache/camel-quarkus/issues/844)
- Qute support [\#825](https://github.com/apache/camel-quarkus/issues/825)
- Quartz support [\#823](https://github.com/apache/camel-quarkus/issues/823)
- Cron support [\#822](https://github.com/apache/camel-quarkus/issues/822)
- Webhook component support [\#820](https://github.com/apache/camel-quarkus/issues/820)
- Openshift support [\#812](https://github.com/apache/camel-quarkus/issues/812)
- GitHub support [\#811](https://github.com/apache/camel-quarkus/issues/811)
- Google Sheets support [\#809](https://github.com/apache/camel-quarkus/issues/809)
- Google Pubsub support [\#808](https://github.com/apache/camel-quarkus/issues/808)
- Google Mail support [\#807](https://github.com/apache/camel-quarkus/issues/807)
- Google Drive support [\#806](https://github.com/apache/camel-quarkus/issues/806)
- Google Calendar support [\#805](https://github.com/apache/camel-quarkus/issues/805)
- Google BigQuery support [\#804](https://github.com/apache/camel-quarkus/issues/804)
- Avro support [\#782](https://github.com/apache/camel-quarkus/issues/782)
- Groovy language support [\#781](https://github.com/apache/camel-quarkus/issues/781)
- ServiceNow support [\#766](https://github.com/apache/camel-quarkus/issues/766)
- SOAP dataformat support [\#763](https://github.com/apache/camel-quarkus/issues/763)
- Upgarde Quarkus to v1.3.0.Final [\#760](https://github.com/apache/camel-quarkus/issues/760)
- Improve RuntimeCatalogConfig docs [\#706](https://github.com/apache/camel-quarkus/issues/706)
- Do not expose mutable collections from FHIR BuildItems [\#690](https://github.com/apache/camel-quarkus/issues/690)
- RabbitMQ support [\#675](https://github.com/apache/camel-quarkus/issues/675)
- Camel routes with xslt doesn't work in dev mode [\#671](https://github.com/apache/camel-quarkus/issues/671)
- Utility to generate/scaffold an extension for a camel component [\#616](https://github.com/apache/camel-quarkus/issues/616)
- OGNL language support [\#410](https://github.com/apache/camel-quarkus/issues/410)

## [1.0.0-M5](https://github.com/apache/camel-quarkus/tree/1.0.0-M5) (2020-03-13)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.0.0-M4...1.0.0-M5)

**Fixed bugs:**

- Quarkus fails to start with uri: platform-http://hello [\#879](https://github.com/apache/camel-quarkus/issues/879)
- @BindToRegistry fields need to be explicitly registered for reflection in order to work in native mode [\#867](https://github.com/apache/camel-quarkus/issues/867)
- Camel MongoDB extension does not register camelMongoClient bean [\#747](https://github.com/apache/camel-quarkus/issues/747)

**Closed issues:**

- FastCamelContext to implement ModelCamelContext [\#877](https://github.com/apache/camel-quarkus/issues/877)
- kafka itests fails [\#875](https://github.com/apache/camel-quarkus/issues/875)
- Re-org the source tree [\#865](https://github.com/apache/camel-quarkus/issues/865)
- Support for camel-xml-io [\#847](https://github.com/apache/camel-quarkus/issues/847)
- Optimize PR build GitHub action [\#836](https://github.com/apache/camel-quarkus/issues/836)
- Ref component support [\#818](https://github.com/apache/camel-quarkus/issues/818)
- Mustache support [\#803](https://github.com/apache/camel-quarkus/issues/803)
- GraphQL support [\#801](https://github.com/apache/camel-quarkus/issues/801)
- File Watch support [\#795](https://github.com/apache/camel-quarkus/issues/795)
- JSon XStream dataformat support [\#787](https://github.com/apache/camel-quarkus/issues/787)
- JAXB dataformat support [\#786](https://github.com/apache/camel-quarkus/issues/786)
- JacksonXML support [\#785](https://github.com/apache/camel-quarkus/issues/785)
- iCal support [\#784](https://github.com/apache/camel-quarkus/issues/784)
- GZip Deflater support [\#783](https://github.com/apache/camel-quarkus/issues/783)
- Add support for camel-johnzon extension [\#775](https://github.com/apache/camel-quarkus/issues/775)
- Upgarde Camel to v3.1.0 [\#759](https://github.com/apache/camel-quarkus/issues/759)
- Automate tests against camel and quarkus master [\#652](https://github.com/apache/camel-quarkus/issues/652)
- MongoDB itest fails on Camel 3.1.0-SNAPSHOT [\#649](https://github.com/apache/camel-quarkus/issues/649)
- java.lang.NoClassDefFoundError with JDK 11+ [\#642](https://github.com/apache/camel-quarkus/issues/642)
- Add support for camel-activemq [\#424](https://github.com/apache/camel-quarkus/issues/424)

**Merged pull requests:**

- Upgrade Quarkus to 1.3.0.Final [\#884](https://github.com/apache/camel-quarkus/pull/884) ([jamesnetherton](https://github.com/jamesnetherton))
- Remove default or redundant config of the failsafe plugin [\#882](https://github.com/apache/camel-quarkus/pull/882) ([ppalaga](https://github.com/ppalaga))
- FastCamelContext to implement ModelCamelContext [\#881](https://github.com/apache/camel-quarkus/pull/881) ([lburgazzoli](https://github.com/lburgazzoli))
- Fixed kafka itests as @Inject is not supported in native tests [\#876](https://github.com/apache/camel-quarkus/pull/876) ([aldettinger](https://github.com/aldettinger))
- Ref component support [\#874](https://github.com/apache/camel-quarkus/pull/874) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(doc\): fix contributor guide example [\#873](https://github.com/apache/camel-quarkus/pull/873) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(build\): update maven to v3.6.3 [\#871](https://github.com/apache/camel-quarkus/pull/871) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#865 Re-org the source tree [\#869](https://github.com/apache/camel-quarkus/pull/869) ([ppalaga](https://github.com/ppalaga))
- Add GraphQL extension [\#864](https://github.com/apache/camel-quarkus/pull/864) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#795 File Watch support [\#863](https://github.com/apache/camel-quarkus/pull/863) ([ppalaga](https://github.com/ppalaga))
- Upgrade Quarkus to 1.3.0.CR2 [\#862](https://github.com/apache/camel-quarkus/pull/862) ([jamesnetherton](https://github.com/jamesnetherton))
- Optimize PR build GitHub action [\#861](https://github.com/apache/camel-quarkus/pull/861) ([jamesnetherton](https://github.com/jamesnetherton))
- Add ActiveMQ extension [\#860](https://github.com/apache/camel-quarkus/pull/860) ([jamesnetherton](https://github.com/jamesnetherton))
- Automatic sync branch master to quarkus-master [\#859](https://github.com/apache/camel-quarkus/pull/859) ([github-actions[bot]](https://github.com/apps/github-actions))
- Fix \#787 JSon XStream dataformat support [\#857](https://github.com/apache/camel-quarkus/pull/857) ([ppalaga](https://github.com/ppalaga))
- Bump to Quarkus 1.0.0-M4 [\#856](https://github.com/apache/camel-quarkus/pull/856) ([oscerd](https://github.com/oscerd))
- Post Quarkus 1.3.0.CR1 upgrade tidy ups [\#855](https://github.com/apache/camel-quarkus/pull/855) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade to Quarkus 1.3.0.CR1 [\#851](https://github.com/apache/camel-quarkus/pull/851) ([jamesnetherton](https://github.com/jamesnetherton))
- add camel-jaxb into extensions [\#850](https://github.com/apache/camel-quarkus/pull/850) ([mmelko](https://github.com/mmelko))
- Support for camel-xml-io [\#849](https://github.com/apache/camel-quarkus/pull/849) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#785 JacksonXML support [\#848](https://github.com/apache/camel-quarkus/pull/848) ([ppalaga](https://github.com/ppalaga))
- Fix since versions on various places [\#845](https://github.com/apache/camel-quarkus/pull/845) ([ppalaga](https://github.com/ppalaga))
- Add JMS extension [\#841](https://github.com/apache/camel-quarkus/pull/841) ([jamesnetherton](https://github.com/jamesnetherton))
- Added Johnzon extension \#775 [\#840](https://github.com/apache/camel-quarkus/pull/840) ([aldettinger](https://github.com/aldettinger))
- Fix \#784 iCal support [\#839](https://github.com/apache/camel-quarkus/pull/839) ([ppalaga](https://github.com/ppalaga))
- Remove MongoDB dependency overrides [\#834](https://github.com/apache/camel-quarkus/pull/834) ([jamesnetherton](https://github.com/jamesnetherton))
- Add websocket-jsr356 extension [\#833](https://github.com/apache/camel-quarkus/pull/833) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#831 Move Groovy executions under the enforce profile [\#832](https://github.com/apache/camel-quarkus/pull/832) ([ppalaga](https://github.com/ppalaga))
- Automatic sync branch master to camel-master [\#830](https://github.com/apache/camel-quarkus/pull/830) ([github-actions[bot]](https://github.com/apps/github-actions))
- Automatic sync branch master to quarkus-master [\#829](https://github.com/apache/camel-quarkus/pull/829) ([github-actions[bot]](https://github.com/apps/github-actions))
- \#791 \#783 \#788 Compression dataformats [\#827](https://github.com/apache/camel-quarkus/pull/827) ([ppalaga](https://github.com/ppalaga))
- Add Braintree extension [\#826](https://github.com/apache/camel-quarkus/pull/826) ([jamesnetherton](https://github.com/jamesnetherton))
- Add xpath language extension [\#779](https://github.com/apache/camel-quarkus/pull/779) ([jamesnetherton](https://github.com/jamesnetherton))
- Ensure that the GitHub Actions run each itest [\#778](https://github.com/apache/camel-quarkus/pull/778) ([ppalaga](https://github.com/ppalaga))
- Fix \#498 Improve the XSLT test coverage [\#777](https://github.com/apache/camel-quarkus/pull/777) ([ppalaga](https://github.com/ppalaga))
- Add Azure extension [\#774](https://github.com/apache/camel-quarkus/pull/774) ([jamesnetherton](https://github.com/jamesnetherton))
- Add telegram extension to CI build [\#773](https://github.com/apache/camel-quarkus/pull/773) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade to camel 3.1.0 [\#768](https://github.com/apache/camel-quarkus/pull/768) ([jamesnetherton](https://github.com/jamesnetherton))
- Jira integration test fails in native mode [\#758](https://github.com/apache/camel-quarkus/pull/758) ([jamesnetherton](https://github.com/jamesnetherton))
- Remove redundant mvnd.builder.rules from the top level pom.xml [\#755](https://github.com/apache/camel-quarkus/pull/755) ([ppalaga](https://github.com/ppalaga))
- Fix \#960 Do not expose mutable collections from FHIR BuildItems [\#754](https://github.com/apache/camel-quarkus/pull/754) ([ppalaga](https://github.com/ppalaga))
- Remove redundant quarkus.ssl.native=true from box application.properties [\#751](https://github.com/apache/camel-quarkus/pull/751) ([ppalaga](https://github.com/ppalaga))
- FhirDataformatTest failure -TransformerFactoryImpl not found [\#750](https://github.com/apache/camel-quarkus/pull/750) ([jamesnetherton](https://github.com/jamesnetherton))
- Minor cleanup and a mvnd.builder.rule update [\#749](https://github.com/apache/camel-quarkus/pull/749) ([ppalaga](https://github.com/ppalaga))
- Automatic sync branch master to quarkus-master [\#745](https://github.com/apache/camel-quarkus/pull/745) ([github-actions[bot]](https://github.com/apps/github-actions))
- Automatic sync branch master to camel-master [\#744](https://github.com/apache/camel-quarkus/pull/744) ([github-actions[bot]](https://github.com/apps/github-actions))
- Add LoginToken to Salesforce reflective class list [\#742](https://github.com/apache/camel-quarkus/pull/742) ([jamesnetherton](https://github.com/jamesnetherton))
- Created a camel gson extension \#681 [\#738](https://github.com/apache/camel-quarkus/pull/738) ([aldettinger](https://github.com/aldettinger))
- chore\(test\): add test for bean\(class, method\) [\#737](https://github.com/apache/camel-quarkus/pull/737) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix XSLT extension NoSuchMethodError: TransformerFactory.newInstance\(String,ClassLoader\) [\#736](https://github.com/apache/camel-quarkus/pull/736) ([jamesnetherton](https://github.com/jamesnetherton))
- build: Do resource hungry native builds in parallel [\#735](https://github.com/apache/camel-quarkus/pull/735) ([jamesnetherton](https://github.com/jamesnetherton))
- CAMEL-QUARKUS-729: Centralized JSON dataformats related itests in dat… [\#734](https://github.com/apache/camel-quarkus/pull/734) ([aldettinger](https://github.com/aldettinger))
- Speed up build for misc extensions   [\#733](https://github.com/apache/camel-quarkus/pull/733) ([jamesnetherton](https://github.com/jamesnetherton))
- Removed useless Jenkinsfile\(s\) [\#732](https://github.com/apache/camel-quarkus/pull/732) ([oscerd](https://github.com/oscerd))
- Cleanup tests [\#731](https://github.com/apache/camel-quarkus/pull/731) ([lburgazzoli](https://github.com/lburgazzoli))
- Update kotlin to v1.3.61 [\#730](https://github.com/apache/camel-quarkus/pull/730) ([lburgazzoli](https://github.com/lburgazzoli))
- Improve Jira extension [\#728](https://github.com/apache/camel-quarkus/pull/728) ([jamesnetherton](https://github.com/jamesnetherton))
- Update quarkus to v1.3.0.Alpha2 [\#727](https://github.com/apache/camel-quarkus/pull/727) ([lburgazzoli](https://github.com/lburgazzoli))
- Automatic sync branch master to quarkus-master [\#724](https://github.com/apache/camel-quarkus/pull/724) ([github-actions[bot]](https://github.com/apps/github-actions))
- Resolves \#162 adds camel-box support [\#722](https://github.com/apache/camel-quarkus/pull/722) ([johnpoth](https://github.com/johnpoth))
- Fix \#598 Use quarkus.package.type=native instead of the native-image mojo [\#720](https://github.com/apache/camel-quarkus/pull/720) ([ppalaga](https://github.com/ppalaga))
- Fix \#713 Revisit the Quarkus native image mojo options generated by create-extension [\#719](https://github.com/apache/camel-quarkus/pull/719) ([ppalaga](https://github.com/ppalaga))
- Schedule sync of quarkus-master branch [\#718](https://github.com/apache/camel-quarkus/pull/718) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#716 Move the Atlassian Maven repository to the Jira runtime module [\#717](https://github.com/apache/camel-quarkus/pull/717) ([ppalaga](https://github.com/ppalaga))
- camel-jira extension:more polish up [\#714](https://github.com/apache/camel-quarkus/pull/714) ([ffang](https://github.com/ffang))
- create camel-jira extension \#710 [\#712](https://github.com/apache/camel-quarkus/pull/712) ([ffang](https://github.com/ffang))
- \#688 \#694 Minor create-extension mojo fixes [\#709](https://github.com/apache/camel-quarkus/pull/709) ([ppalaga](https://github.com/ppalaga))
- \#670 fix PDF itests in native mode [\#707](https://github.com/apache/camel-quarkus/pull/707) ([ffang](https://github.com/ffang))
- Update mvnd.builder.rules [\#705](https://github.com/apache/camel-quarkus/pull/705) ([ppalaga](https://github.com/ppalaga))
- Ensure that catalog files are added to the native image [\#704](https://github.com/apache/camel-quarkus/pull/704) ([lburgazzoli](https://github.com/lburgazzoli))
- Use camel-quarkus-support-httpclient in slack extension [\#703](https://github.com/apache/camel-quarkus/pull/703) ([jamesnetherton](https://github.com/jamesnetherton))
- Add olingo4 itest to project list [\#702](https://github.com/apache/camel-quarkus/pull/702) ([jamesnetherton](https://github.com/jamesnetherton))
- Remove enableJni from integration tests as JNI si always enabled on GraalVM 19.3.1 [\#701](https://github.com/apache/camel-quarkus/pull/701) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#696 Test HTTPS with the HTTP clients [\#697](https://github.com/apache/camel-quarkus/pull/697) ([ppalaga](https://github.com/ppalaga))
- Add olingo4 extension [\#693](https://github.com/apache/camel-quarkus/pull/693) ([jamesnetherton](https://github.com/jamesnetherton))
- Cleanup: Declare quarkus-development-mode-spi as a nonExtensionArtifact [\#691](https://github.com/apache/camel-quarkus/pull/691) ([ppalaga](https://github.com/ppalaga))
- Automatic sync branch master to camel-master [\#689](https://github.com/apache/camel-quarkus/pull/689) ([github-actions[bot]](https://github.com/apps/github-actions))
- Snapshots and Actions [\#687](https://github.com/apache/camel-quarkus/pull/687) ([lburgazzoli](https://github.com/lburgazzoli))
-  Upgrade to quarkus 1.3.0.Alpha1 [\#685](https://github.com/apache/camel-quarkus/pull/685) ([lburgazzoli](https://github.com/lburgazzoli))
- Add stream extension [\#682](https://github.com/apache/camel-quarkus/pull/682) ([jamesnetherton](https://github.com/jamesnetherton))
- Create enforce profile that disables dependency checks [\#679](https://github.com/apache/camel-quarkus/pull/679) ([johnpoth](https://github.com/johnpoth))
- camel-fhir record FHIR context instead of creating it at runtime. Onl… [\#678](https://github.com/apache/camel-quarkus/pull/678) ([johnpoth](https://github.com/johnpoth))
- Add GitHub action for automatic testing of camel-master branch [\#677](https://github.com/apache/camel-quarkus/pull/677) ([jamesnetherton](https://github.com/jamesnetherton))
- fix\(rest-json/pom.xml\): use quarkus-based dependency [\#674](https://github.com/apache/camel-quarkus/pull/674) ([hanzo2001](https://github.com/hanzo2001))
- Cleanup [\#667](https://github.com/apache/camel-quarkus/pull/667) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix the \<firstVersion\> of extensions that were released for the first… [\#665](https://github.com/apache/camel-quarkus/pull/665) ([ppalaga](https://github.com/ppalaga))
- Bump To Quarkus 1.0.0-M3 [\#664](https://github.com/apache/camel-quarkus/pull/664) ([oscerd](https://github.com/oscerd))
- Add integration test for Jackson unmarshalling with different POJOs [\#663](https://github.com/apache/camel-quarkus/pull/663) ([philschaller](https://github.com/philschaller))
- Upgrade TestContainers to version 1.12.5 [\#662](https://github.com/apache/camel-quarkus/pull/662) ([oscerd](https://github.com/oscerd))

## [1.0.0-M4](https://github.com/apache/camel-quarkus/tree/1.0.0-M4) (2020-03-03)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.0.0-M3...1.0.0-M4)

**Fixed bugs:**

- Jira integration test fails in native mode [\#757](https://github.com/apache/camel-quarkus/issues/757)
- FhirDataformatTest failure -TransformerFactoryImpl not found [\#748](https://github.com/apache/camel-quarkus/issues/748)
- Salesforce extension does not work in native mode [\#740](https://github.com/apache/camel-quarkus/issues/740)
- NoSuchMethodError: TransformerFactory.newInstance\(String,ClassLoader\) in dev mode [\#721](https://github.com/apache/camel-quarkus/issues/721)
- PDF itest fails in native mode when building the font cache [\#670](https://github.com/apache/camel-quarkus/issues/670)
- Unmarshalling with Jackson in multiple routes with different classes [\#637](https://github.com/apache/camel-quarkus/issues/637)

**Closed issues:**

- Move Groovy executions under the enforce profile [\#831](https://github.com/apache/camel-quarkus/issues/831)
- Braintree support [\#810](https://github.com/apache/camel-quarkus/issues/810)
- Zip Deflate Compression dataformat support [\#791](https://github.com/apache/camel-quarkus/issues/791)
- LZF Deflate Compression dataformat support [\#788](https://github.com/apache/camel-quarkus/issues/788)
- Add support for camel-jms [\#767](https://github.com/apache/camel-quarkus/issues/767)
- Create Azure component extension [\#761](https://github.com/apache/camel-quarkus/issues/761)
- Camel-Jira extension: Enforcer rules are failing on the module [\#753](https://github.com/apache/camel-quarkus/issues/753)
- Create a XPath language extension [\#739](https://github.com/apache/camel-quarkus/issues/739)
- Create dataformats-json itests from jackson itests [\#729](https://github.com/apache/camel-quarkus/issues/729)
- Move the Atlassian Maven repository to the Jira runtime module. [\#716](https://github.com/apache/camel-quarkus/issues/716)
- improve camel-jira integration test [\#715](https://github.com/apache/camel-quarkus/issues/715)
- Revisit the Quarkus native image mojo options generated by create-extension [\#713](https://github.com/apache/camel-quarkus/issues/713)
- create camel-jira extension [\#710](https://github.com/apache/camel-quarkus/issues/710)
- Restore the testing of the font option when switching to camel 3.1.0 [\#708](https://github.com/apache/camel-quarkus/issues/708)
- Test HTTPS with the HTTP clients [\#696](https://github.com/apache/camel-quarkus/issues/696)
- quarkus-maven-plugin generate application.properties file for IT tests [\#694](https://github.com/apache/camel-quarkus/issues/694)
- Create a camel olingo4 extension [\#692](https://github.com/apache/camel-quarkus/issues/692)
- Create extension mojo not working after Quarkus 1.3.0.Alpha1 upgrade [\#688](https://github.com/apache/camel-quarkus/issues/688)
- Ensure that catalog files are added to the native image [\#686](https://github.com/apache/camel-quarkus/issues/686)
- Upgrade to quarkus 1.3.0.Alpha1 [\#684](https://github.com/apache/camel-quarkus/issues/684)
- Timer not fired in native mode [\#683](https://github.com/apache/camel-quarkus/issues/683)
- Create a camel gson extension [\#681](https://github.com/apache/camel-quarkus/issues/681)
- Create a camel stream extension [\#680](https://github.com/apache/camel-quarkus/issues/680)
- Incredible use of RAM even on small example/rest-json [\#673](https://github.com/apache/camel-quarkus/issues/673)
- Create a camel-bindy extension [\#653](https://github.com/apache/camel-quarkus/issues/653)
- Add JniBuildItem to extensions that need JNI [\#627](https://github.com/apache/camel-quarkus/issues/627)
- Create a camel-websocket-jsr356 extension [\#613](https://github.com/apache/camel-quarkus/issues/613)
- Use quarkus.package.type=native instead of the native-image mojo [\#598](https://github.com/apache/camel-quarkus/issues/598)
- Improve the XSLT test coverage [\#498](https://github.com/apache/camel-quarkus/issues/498)
- Native SSL support does not work on ASF Jenkins CI  [\#468](https://github.com/apache/camel-quarkus/issues/468)
- support camel-box [\#162](https://github.com/apache/camel-quarkus/issues/162)

## [1.0.0-M3](https://github.com/apache/camel-quarkus/tree/1.0.0-M3) (2020-01-24)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.0.0-M2...1.0.0-M3)

**Implemented enhancements:**

- Create a Camel ReactiveStreams extension [\#304](https://github.com/apache/camel-quarkus/issues/304)
- Create a Camel Telegram extension [\#74](https://github.com/apache/camel-quarkus/issues/74)

**Fixed bugs:**

- camel-pdf: build failure in jvm mode with Apache Camel 3.0.1 [\#631](https://github.com/apache/camel-quarkus/issues/631)

**Closed issues:**

- The MicroProfile test fails against Camel 3.1.0-SNAPSHOT [\#650](https://github.com/apache/camel-quarkus/issues/650)
- Lower the level of "Could not find a non-optional class for key ..." message [\#640](https://github.com/apache/camel-quarkus/issues/640)
- Dependency parity check [\#635](https://github.com/apache/camel-quarkus/issues/635)
- Upgrade to Apache Camel 3.0.1 [\#628](https://github.com/apache/camel-quarkus/issues/628)
- Add Camel-AWS-Kinesis extension [\#624](https://github.com/apache/camel-quarkus/issues/624)
- Encourage users to ask for missing extensions and to help implementing them [\#622](https://github.com/apache/camel-quarkus/issues/622)
- Introduce CamelServiceInfo transformers [\#620](https://github.com/apache/camel-quarkus/issues/620)
- Create a camel-ahc-ws extension  [\#619](https://github.com/apache/camel-quarkus/issues/619)
- Registerable and discoverable Camel services [\#617](https://github.com/apache/camel-quarkus/issues/617)
- Extension for endpoint DSL [\#612](https://github.com/apache/camel-quarkus/issues/612)
- Improve the camel-jsonpath extension by not using an alias for DefaultAnnotationExpressionFactory [\#611](https://github.com/apache/camel-quarkus/issues/611)
- Fix the defineClass exception in camel-quarkus-jsonpath while running in native mode [\#610](https://github.com/apache/camel-quarkus/issues/610)
- Upgrade to Quarkus 1.1.1.Final [\#606](https://github.com/apache/camel-quarkus/issues/606)
- Remove PlatformHttpSpanDecorator from OpenTracing extension [\#605](https://github.com/apache/camel-quarkus/issues/605)
- ahc dependencies [\#601](https://github.com/apache/camel-quarkus/issues/601)
- Consolidate http based component integration tests [\#600](https://github.com/apache/camel-quarkus/issues/600)
- Document the need to set quarkus.native.add-all-charsets = true in HTTP extensions [\#599](https://github.com/apache/camel-quarkus/issues/599)
- Create a camel-http extension [\#596](https://github.com/apache/camel-quarkus/issues/596)
- Different versions for Jetty and Jetty-Maven-plugin [\#578](https://github.com/apache/camel-quarkus/issues/578)
- Contribute A New Example Project. [\#574](https://github.com/apache/camel-quarkus/issues/574)
- AWS support: Leverage Quarkus-jackson instead of using Jackson stuff in each extension [\#572](https://github.com/apache/camel-quarkus/issues/572)
- Untrack Artemis test instance data [\#568](https://github.com/apache/camel-quarkus/issues/568)
- Create an AWS common extension [\#566](https://github.com/apache/camel-quarkus/issues/566)
- Create AWS Lambda extension [\#563](https://github.com/apache/camel-quarkus/issues/563)
- Create AWS EC2 Extension [\#562](https://github.com/apache/camel-quarkus/issues/562)
- Create AWS Translate extension [\#561](https://github.com/apache/camel-quarkus/issues/561)
- AHC extension [\#560](https://github.com/apache/camel-quarkus/issues/560)
- Randomize http test port [\#553](https://github.com/apache/camel-quarkus/issues/553)
- Add camel-endpointdsl extension [\#551](https://github.com/apache/camel-quarkus/issues/551)
- \[MongoDB extension\] Refactor with camel 3.1.x new connection bean [\#544](https://github.com/apache/camel-quarkus/issues/544)
- Unmarshal json in spring xml [\#543](https://github.com/apache/camel-quarkus/issues/543)
- \[graalvm-19.3.0\] camel-quarkus-salesforce fails to compile in native mode [\#541](https://github.com/apache/camel-quarkus/issues/541)
- \[graalvm-19.3.0\] camel-quarkus-bean fails to compile in native mode [\#540](https://github.com/apache/camel-quarkus/issues/540)
- Dozer extension should use JaxbFileRootBuildItem [\#539](https://github.com/apache/camel-quarkus/issues/539)
- Add support/spring artifact for common substrate support [\#538](https://github.com/apache/camel-quarkus/issues/538)
- camel-json-path extension [\#426](https://github.com/apache/camel-quarkus/issues/426)
- Re-enable the FHIR tests once the FHIR testing service is back again [\#352](https://github.com/apache/camel-quarkus/issues/352)
- Dev mode does not work on Java 12 [\#289](https://github.com/apache/camel-quarkus/issues/289)
- Error building with caffeine on GraalVM 19.1.1 \(quarkus snapshot\) [\#80](https://github.com/apache/camel-quarkus/issues/80)

**Merged pull requests:**

- Set firstVersion to 1.0.0 to match the reality [\#661](https://github.com/apache/camel-quarkus/pull/661) ([ppalaga](https://github.com/ppalaga))
- The MicroProfile test fails if message history is turned off [\#660](https://github.com/apache/camel-quarkus/pull/660) ([lburgazzoli](https://github.com/lburgazzoli))
- Create a Camel ReactiveStreams extension \(initial implementation\) [\#659](https://github.com/apache/camel-quarkus/pull/659) ([lburgazzoli](https://github.com/lburgazzoli))
- Update Quarkus to v1.2.0.Final [\#658](https://github.com/apache/camel-quarkus/pull/658) ([lburgazzoli](https://github.com/lburgazzoli))
- factory-finder: move reactive-executor filter to core processor as the related service is always programmatically configured [\#657](https://github.com/apache/camel-quarkus/pull/657) ([lburgazzoli](https://github.com/lburgazzoli))
- Context and FactoryFinder improvements [\#656](https://github.com/apache/camel-quarkus/pull/656) ([lburgazzoli](https://github.com/lburgazzoli))
- fhir: reduce uri options by leveraging component configuration [\#655](https://github.com/apache/camel-quarkus/pull/655) ([lburgazzoli](https://github.com/lburgazzoli))
- Add tests and improvements for FastFactoryFinder [\#648](https://github.com/apache/camel-quarkus/pull/648) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#518 Rely on configurers for Configuration classes instead of using [\#647](https://github.com/apache/camel-quarkus/pull/647) ([ppalaga](https://github.com/ppalaga))
- chore: move dependencies exlusions to runtime bom [\#646](https://github.com/apache/camel-quarkus/pull/646) ([lburgazzoli](https://github.com/lburgazzoli))
- Removed the now useless alias for DefaultAnnotationExpressionFactory … [\#645](https://github.com/apache/camel-quarkus/pull/645) ([aldettinger](https://github.com/aldettinger))
- Fix \#599 Document the need to set quarkus.native.add-all-charsets = true in HTTP extensions [\#644](https://github.com/apache/camel-quarkus/pull/644) ([ppalaga](https://github.com/ppalaga))
- Remove PlatformHttpSpanDecorator from OpenTracing extension [\#643](https://github.com/apache/camel-quarkus/pull/643) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#640 Lower the level of "Could not find a non-optional class for … [\#641](https://github.com/apache/camel-quarkus/pull/641) ([ppalaga](https://github.com/ppalaga))
- Removed the Apache repositories since now the situation should be ok … [\#639](https://github.com/apache/camel-quarkus/pull/639) ([oscerd](https://github.com/oscerd))
- Fix \#635 Dependency parity check [\#638](https://github.com/apache/camel-quarkus/pull/638) ([ppalaga](https://github.com/ppalaga))
- Determine the Camel version at build time [\#636](https://github.com/apache/camel-quarkus/pull/636) ([ppalaga](https://github.com/ppalaga))
- Run native tests with GitHub Actions [\#634](https://github.com/apache/camel-quarkus/pull/634) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#622 Encourage users to ask for missing extensions and to help im… [\#633](https://github.com/apache/camel-quarkus/pull/633) ([ppalaga](https://github.com/ppalaga))
- Add impsort-maven-plugin [\#632](https://github.com/apache/camel-quarkus/pull/632) ([ppalaga](https://github.com/ppalaga))
- Update to Apache Camel 3.0.1 [\#630](https://github.com/apache/camel-quarkus/pull/630) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: fix sjm2 extension metadata [\#629](https://github.com/apache/camel-quarkus/pull/629) ([lburgazzoli](https://github.com/lburgazzoli))
- Added an AWS Kinesis extension [\#626](https://github.com/apache/camel-quarkus/pull/626) ([oscerd](https://github.com/oscerd))
- Add ahc-ws extension [\#625](https://github.com/apache/camel-quarkus/pull/625) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#620 Introduce CamelServiceInfo transformers [\#621](https://github.com/apache/camel-quarkus/pull/621) ([ppalaga](https://github.com/ppalaga))
- Fix \#617 Registerable and discoverable Camel services [\#618](https://github.com/apache/camel-quarkus/pull/618) ([ppalaga](https://github.com/ppalaga))
- Initial camel-consul support [\#615](https://github.com/apache/camel-quarkus/pull/615) ([lburgazzoli](https://github.com/lburgazzoli))
- Added an AWS Translate extension [\#614](https://github.com/apache/camel-quarkus/pull/614) ([oscerd](https://github.com/oscerd))
- Created a camel-jsonpath extension \#426 [\#609](https://github.com/apache/camel-quarkus/pull/609) ([aldettinger](https://github.com/aldettinger))
- Add spring common extension [\#608](https://github.com/apache/camel-quarkus/pull/608) ([jamesnetherton](https://github.com/jamesnetherton))
- Bump Quarkus to version 1.1.1.Final [\#607](https://github.com/apache/camel-quarkus/pull/607) ([oscerd](https://github.com/oscerd))
- ahc dependencies [\#604](https://github.com/apache/camel-quarkus/pull/604) ([lburgazzoli](https://github.com/lburgazzoli))
- WIP - Prepare for Quarkus 1.2 [\#603](https://github.com/apache/camel-quarkus/pull/603) ([gsmet](https://github.com/gsmet))
- Consolidate http based component integration tests [\#602](https://github.com/apache/camel-quarkus/pull/602) ([lburgazzoli](https://github.com/lburgazzoli))
- Create a camel-http extension [\#597](https://github.com/apache/camel-quarkus/pull/597) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: remove jetty-maven-plugin.version as jetty-maven-plugin is not more used [\#594](https://github.com/apache/camel-quarkus/pull/594) ([lburgazzoli](https://github.com/lburgazzoli))
- build: formatter-maven-plugin should validate code format when check-format profile is active [\#593](https://github.com/apache/camel-quarkus/pull/593) ([lburgazzoli](https://github.com/lburgazzoli))
- build: add Java 12 to PR build action [\#592](https://github.com/apache/camel-quarkus/pull/592) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove @Nullable leftovers [\#591](https://github.com/apache/camel-quarkus/pull/591) ([lburgazzoli](https://github.com/lburgazzoli))
- Format method param JavaDoc in columns [\#590](https://github.com/apache/camel-quarkus/pull/590) ([ppalaga](https://github.com/ppalaga))
- Improve dev mode test and \*BeanBuldItem [\#589](https://github.com/apache/camel-quarkus/pull/589) ([lburgazzoli](https://github.com/lburgazzoli))
- Some cleanup and improvements [\#588](https://github.com/apache/camel-quarkus/pull/588) ([lburgazzoli](https://github.com/lburgazzoli))
- Move MicroProfile metrics camel context configuration to static init [\#587](https://github.com/apache/camel-quarkus/pull/587) ([jamesnetherton](https://github.com/jamesnetherton))
- Camel-AWS extensions: Cleanup [\#586](https://github.com/apache/camel-quarkus/pull/586) ([oscerd](https://github.com/oscerd))
- chore: include test xml routes in native image [\#585](https://github.com/apache/camel-quarkus/pull/585) ([lburgazzoli](https://github.com/lburgazzoli))
- Added AWS-Lambda extension [\#584](https://github.com/apache/camel-quarkus/pull/584) ([oscerd](https://github.com/oscerd))
- Add basic tests for dev mode [\#583](https://github.com/apache/camel-quarkus/pull/583) ([lburgazzoli](https://github.com/lburgazzoli))
- Throw NoSuchLanguageException if a language cannot be found [\#582](https://github.com/apache/camel-quarkus/pull/582) ([lburgazzoli](https://github.com/lburgazzoli))
- Add tests for \#543 [\#581](https://github.com/apache/camel-quarkus/pull/581) ([lburgazzoli](https://github.com/lburgazzoli))
- Dozer extension should use JaxbFileRootBuildItem [\#580](https://github.com/apache/camel-quarkus/pull/580) ([jamesnetherton](https://github.com/jamesnetherton))
- Cleanup [\#577](https://github.com/apache/camel-quarkus/pull/577) ([oscerd](https://github.com/oscerd))
- Don't search license in csv file [\#576](https://github.com/apache/camel-quarkus/pull/576) ([oscerd](https://github.com/oscerd))
- CSV File Splitter To Log [\#575](https://github.com/apache/camel-quarkus/pull/575) ([Namphibian](https://github.com/Namphibian))
- AWS support: Leverage Quarkus-jackson instead of using Jackson stuff … [\#573](https://github.com/apache/camel-quarkus/pull/573) ([oscerd](https://github.com/oscerd))
- Remove mp-config workaround [\#571](https://github.com/apache/camel-quarkus/pull/571) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#560 AHC extension [\#570](https://github.com/apache/camel-quarkus/pull/570) ([ppalaga](https://github.com/ppalaga))
- Fix \#568 Untrack Artemis test instance data [\#569](https://github.com/apache/camel-quarkus/pull/569) ([ppalaga](https://github.com/ppalaga))
- Create an AWS commons extension [\#567](https://github.com/apache/camel-quarkus/pull/567) ([oscerd](https://github.com/oscerd))
- AWS-EC2 Extension [\#565](https://github.com/apache/camel-quarkus/pull/565) ([oscerd](https://github.com/oscerd))
- Fix first version of Camel-SQL extension [\#559](https://github.com/apache/camel-quarkus/pull/559) ([oscerd](https://github.com/oscerd))
- Update docs to version 1.0.0-M2 [\#558](https://github.com/apache/camel-quarkus/pull/558) ([oscerd](https://github.com/oscerd))
- A JUnit dependency is required to run our integration tests outside of [\#557](https://github.com/apache/camel-quarkus/pull/557) ([ppalaga](https://github.com/ppalaga))
- Restored the native profile for camel-quarkus-pdf integration tests [\#556](https://github.com/apache/camel-quarkus/pull/556) ([aldettinger](https://github.com/aldettinger))
- Randomize http test port [\#555](https://github.com/apache/camel-quarkus/pull/555) ([lburgazzoli](https://github.com/lburgazzoli))
- Modular RoutesCollector [\#554](https://github.com/apache/camel-quarkus/pull/554) ([lburgazzoli](https://github.com/lburgazzoli))
- Add camel-endpointdsl extension [\#552](https://github.com/apache/camel-quarkus/pull/552) ([lburgazzoli](https://github.com/lburgazzoli))
- Enable local native sftp tests [\#547](https://github.com/apache/camel-quarkus/pull/547) ([lburgazzoli](https://github.com/lburgazzoli))

## [1.0.0-M2](https://github.com/apache/camel-quarkus/tree/1.0.0-M2) (2019-12-17)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/1.0.0-M1...1.0.0-M2)

**Closed issues:**

- Manjaro: Dependency Problem with Platform-HTTP [\#532](https://github.com/apache/camel-quarkus/issues/532)
- Re-introduce RoutesBuilderBuildItem [\#526](https://github.com/apache/camel-quarkus/issues/526)
- XSLT documentation is misleading [\#520](https://github.com/apache/camel-quarkus/issues/520)
- Rely on configurers for Configuration classes instead of using reflection [\#518](https://github.com/apache/camel-quarkus/issues/518)
- Create AWS-IAM Extension [\#514](https://github.com/apache/camel-quarkus/issues/514)
- Do not use hard coded ports in integration-tests [\#508](https://github.com/apache/camel-quarkus/issues/508)
- camel-sql extension [\#505](https://github.com/apache/camel-quarkus/issues/505)

**Merged pull requests:**

- Quarkus 1.1 upgrade [\#550](https://github.com/apache/camel-quarkus/pull/550) ([gsmet](https://github.com/gsmet))
- Add initial support for kotlin [\#549](https://github.com/apache/camel-quarkus/pull/549) ([lburgazzoli](https://github.com/lburgazzoli))
- Ensure custom services such as deataformats, languages and component are not removed from container [\#548](https://github.com/apache/camel-quarkus/pull/548) ([lburgazzoli](https://github.com/lburgazzoli))
- Ensure RoutesBuilder instances created by a CDI Producder are  not removed [\#546](https://github.com/apache/camel-quarkus/pull/546) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix commons-logging setup [\#545](https://github.com/apache/camel-quarkus/pull/545) ([lburgazzoli](https://github.com/lburgazzoli))
- examples: add timer-log kotlin example [\#542](https://github.com/apache/camel-quarkus/pull/542) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: Clarify supported URI schemes in SQL script-files config property [\#535](https://github.com/apache/camel-quarkus/pull/535) ([jamesnetherton](https://github.com/jamesnetherton))
- Add SQL component extension [\#533](https://github.com/apache/camel-quarkus/pull/533) ([jamesnetherton](https://github.com/jamesnetherton))
- chore: Remove redundant banned dependency [\#530](https://github.com/apache/camel-quarkus/pull/530) ([jamesnetherton](https://github.com/jamesnetherton))
- Replace \<firstVersion\> 0.5.0 with 1.0.0-M1 [\#529](https://github.com/apache/camel-quarkus/pull/529) ([ppalaga](https://github.com/ppalaga))
- Re-introduce RoutesBuilderBuildItem [\#528](https://github.com/apache/camel-quarkus/pull/528) ([lburgazzoli](https://github.com/lburgazzoli))
- 1.0.0-M1 [\#527](https://github.com/apache/camel-quarkus/pull/527) ([oscerd](https://github.com/oscerd))
- Add a workaround for Camel's DI \(see CAMEL-14271\) [\#525](https://github.com/apache/camel-quarkus/pull/525) ([lburgazzoli](https://github.com/lburgazzoli))
- refactor FHIR integration tests [\#524](https://github.com/apache/camel-quarkus/pull/524) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#520 XSLT documentation is misleading [\#523](https://github.com/apache/camel-quarkus/pull/523) ([ppalaga](https://github.com/ppalaga))
- Do not check licenses in integration-tests/sjms/data [\#522](https://github.com/apache/camel-quarkus/pull/522) ([ppalaga](https://github.com/ppalaga))
- chore: cleanup poms [\#519](https://github.com/apache/camel-quarkus/pull/519) ([lburgazzoli](https://github.com/lburgazzoli))
- introduce testcontainers [\#517](https://github.com/apache/camel-quarkus/pull/517) ([lburgazzoli](https://github.com/lburgazzoli))
- Create AWS-IAM Extension [\#515](https://github.com/apache/camel-quarkus/pull/515) ([oscerd](https://github.com/oscerd))
- ftp: implement ftp/sft server test support with QuarkusTestResourceLifecycleManager [\#512](https://github.com/apache/camel-quarkus/pull/512) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: Fix pom sorting script execution [\#510](https://github.com/apache/camel-quarkus/pull/510) ([jamesnetherton](https://github.com/jamesnetherton))
- Do not use hard coded ports in integration-tests [\#509](https://github.com/apache/camel-quarkus/pull/509) ([lburgazzoli](https://github.com/lburgazzoli))
- Automatically register dozer mapping classes for reflection [\#507](https://github.com/apache/camel-quarkus/pull/507) ([jamesnetherton](https://github.com/jamesnetherton))

## [1.0.0-M1](https://github.com/apache/camel-quarkus/tree/1.0.0-M1) (2019-12-04)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/0.4.0...1.0.0-M1)

**Implemented enhancements:**

- Cerate a Camel MongoDB extension [\#302](https://github.com/apache/camel-quarkus/issues/302)
- Add Camel-AWS-ECS extension [\#17](https://github.com/apache/camel-quarkus/issues/17)
- Add Camel-AWS-KMS extension [\#16](https://github.com/apache/camel-quarkus/issues/16)

**Fixed bugs:**

- xslt extension not working on java 11 [\#427](https://github.com/apache/camel-quarkus/issues/427)

**Closed issues:**

- seda extension [\#500](https://github.com/apache/camel-quarkus/issues/500)
- Filter out beans from CDI from build time discovery [\#499](https://github.com/apache/camel-quarkus/issues/499)
- Group catalog re-generation and formatting mojos under a single profile [\#494](https://github.com/apache/camel-quarkus/issues/494)
- Add support for tidymarkup and tagsoup [\#490](https://github.com/apache/camel-quarkus/issues/490)
- The validator test should use a classpath URI for the XSD [\#484](https://github.com/apache/camel-quarkus/issues/484)
- Flatten the integration-tests hierarchy and remove camel-quarkus-test-list.xml from git [\#483](https://github.com/apache/camel-quarkus/issues/483)
- Native compile fails in some aggregation strategy which I am not using [\#477](https://github.com/apache/camel-quarkus/issues/477)
- List itests in an XML file for the Quarkus platform [\#476](https://github.com/apache/camel-quarkus/issues/476)
- Support dependency injection of FluentProducerTemplate/FluentConsumerTemplate  [\#474](https://github.com/apache/camel-quarkus/issues/474)
- Upgrade to quarkus 1.0.0.Final [\#470](https://github.com/apache/camel-quarkus/issues/470)
- Upgrade to camel  3.0.0 [\#469](https://github.com/apache/camel-quarkus/issues/469)
- Problem: Classes that should be initialized at run time got initialized during image building [\#467](https://github.com/apache/camel-quarkus/issues/467)
- Create a Camel FTP extension [\#463](https://github.com/apache/camel-quarkus/issues/463)
- Support only classpath: XSLT URIs [\#455](https://github.com/apache/camel-quarkus/issues/455)
- camel-quarkus-netty-http failing to boot [\#454](https://github.com/apache/camel-quarkus/issues/454)
- Move the platform-http component to Camel [\#453](https://github.com/apache/camel-quarkus/issues/453)
- Avoid subclassing the upstream XsltComponent [\#441](https://github.com/apache/camel-quarkus/issues/441)
- Get the basedir reliably [\#439](https://github.com/apache/camel-quarkus/issues/439)
- Create a Camel Dozer extension [\#435](https://github.com/apache/camel-quarkus/issues/435)
- Consolidate microprofile integration tests [\#433](https://github.com/apache/camel-quarkus/issues/433)
- camel-hystrix extension [\#429](https://github.com/apache/camel-quarkus/issues/429)
- XSLT extension does not work with file: URIs [\#428](https://github.com/apache/camel-quarkus/issues/428)
- Use @Inject in the timer-log-cdi example [\#416](https://github.com/apache/camel-quarkus/issues/416)
- Document that beans managed by Arc are not instantiated from a static initializer [\#415](https://github.com/apache/camel-quarkus/issues/415)
- Using custom camel componet into quarkus-camel [\#379](https://github.com/apache/camel-quarkus/issues/379)

**Merged pull requests:**

- feat: base64 extension [\#506](https://github.com/apache/camel-quarkus/pull/506) ([davsclaus](https://github.com/davsclaus))
- Improve bean discovery filtering [\#504](https://github.com/apache/camel-quarkus/pull/504) ([lburgazzoli](https://github.com/lburgazzoli))
- Improve registration of DozerTypeConverter [\#503](https://github.com/apache/camel-quarkus/pull/503) ([jamesnetherton](https://github.com/jamesnetherton))
- feat: seda extension. [\#502](https://github.com/apache/camel-quarkus/pull/502) ([davsclaus](https://github.com/davsclaus))
- Filter out beans from CDI from build time discovery [\#501](https://github.com/apache/camel-quarkus/pull/501) ([lburgazzoli](https://github.com/lburgazzoli))
- fix dependencies management in package-maven-plugin [\#497](https://github.com/apache/camel-quarkus/pull/497) ([lburgazzoli](https://github.com/lburgazzoli))
- mp-config: enable testing profiles in native mode [\#496](https://github.com/apache/camel-quarkus/pull/496) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#494 Group catalog re-generation and formatting mojos under a sin… [\#495](https://github.com/apache/camel-quarkus/pull/495) ([ppalaga](https://github.com/ppalaga))
- Issue 490: Add tagsoup support [\#493](https://github.com/apache/camel-quarkus/pull/493) ([jsight](https://github.com/jsight))
- Scripts to sort pom.xml files [\#492](https://github.com/apache/camel-quarkus/pull/492) ([ppalaga](https://github.com/ppalaga))
- Document and test referring to beans by name [\#491](https://github.com/apache/camel-quarkus/pull/491) ([ppalaga](https://github.com/ppalaga))
- Fix \#483 Flatten the integration-tests hierarchy and remove camel-qua… [\#489](https://github.com/apache/camel-quarkus/pull/489) ([ppalaga](https://github.com/ppalaga))
- Update to quarkus-1.0.1.Final [\#487](https://github.com/apache/camel-quarkus/pull/487) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#484 The validator test should use a classpath URI for the XSD [\#486](https://github.com/apache/camel-quarkus/pull/486) ([ppalaga](https://github.com/ppalaga))
- Add camel-sjms2 extension [\#485](https://github.com/apache/camel-quarkus/pull/485) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#476 List itests in an XML file for the Quarkus platform [\#482](https://github.com/apache/camel-quarkus/pull/482) ([ppalaga](https://github.com/ppalaga))
- Add workaroud for MP Config profile awarness [\#481](https://github.com/apache/camel-quarkus/pull/481) ([lburgazzoli](https://github.com/lburgazzoli))
- Add MongoDB extension [\#480](https://github.com/apache/camel-quarkus/pull/480) ([jamesnetherton](https://github.com/jamesnetherton))
- Simplify the Tooling hierarchy [\#479](https://github.com/apache/camel-quarkus/pull/479) ([ppalaga](https://github.com/ppalaga))
- Fixes native test and add support for FHIR R5 specification [\#478](https://github.com/apache/camel-quarkus/pull/478) ([johnpoth](https://github.com/johnpoth))
- Support dependency injection of FluentProducerTemplate/FluentConsumerTemplate [\#475](https://github.com/apache/camel-quarkus/pull/475) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade to camel 3.0.0 and quarkus 1.0.0.Final [\#471](https://github.com/apache/camel-quarkus/pull/471) ([lburgazzoli](https://github.com/lburgazzoli))
- Add FTP extension [\#464](https://github.com/apache/camel-quarkus/pull/464) ([jamesnetherton](https://github.com/jamesnetherton))
- Add spring-di example [\#462](https://github.com/apache/camel-quarkus/pull/462) ([lburgazzoli](https://github.com/lburgazzoli))
- Startup a FHIR server when running the FHIR integration tests [\#461](https://github.com/apache/camel-quarkus/pull/461) ([johnpoth](https://github.com/johnpoth))
- Fix \#453 Move the platform-http component to Camel [\#459](https://github.com/apache/camel-quarkus/pull/459) ([ppalaga](https://github.com/ppalaga))
- Add support extension for commons-logging [\#458](https://github.com/apache/camel-quarkus/pull/458) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#455 Support only classpath: XSLT URIs [\#456](https://github.com/apache/camel-quarkus/pull/456) ([ppalaga](https://github.com/ppalaga))
- \#416, \#415 [\#452](https://github.com/apache/camel-quarkus/pull/452) ([ppalaga](https://github.com/ppalaga))
- Update to Quarkus 1.0.0-CR2 and regen [\#450](https://github.com/apache/camel-quarkus/pull/450) ([lburgazzoli](https://github.com/lburgazzoli))
- Add Hystirx component extension [\#449](https://github.com/apache/camel-quarkus/pull/449) ([jamesnetherton](https://github.com/jamesnetherton))
- Fixed FhirProcessor imports [\#448](https://github.com/apache/camel-quarkus/pull/448) ([oscerd](https://github.com/oscerd))
- Add Camel-AWS-ECS extension [\#447](https://github.com/apache/camel-quarkus/pull/447) ([oscerd](https://github.com/oscerd))
- Remove workaround for https://github.com/quarkusio/quarkus/issues/4564 as it seems to be fixed [\#445](https://github.com/apache/camel-quarkus/pull/445) ([lburgazzoli](https://github.com/lburgazzoli))
- Add Camel-AWS-KMS extension [\#443](https://github.com/apache/camel-quarkus/pull/443) ([oscerd](https://github.com/oscerd))
- Add Dozer component extension [\#442](https://github.com/apache/camel-quarkus/pull/442) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#428 XSLT extension does not work with file: URIs [\#440](https://github.com/apache/camel-quarkus/pull/440) ([ppalaga](https://github.com/ppalaga))
- xslt extension not working on java 11 [\#437](https://github.com/apache/camel-quarkus/pull/437) ([lburgazzoli](https://github.com/lburgazzoli))
- Update latest version released to 0.4.0 [\#436](https://github.com/apache/camel-quarkus/pull/436) ([oscerd](https://github.com/oscerd))
- Consolidate microprofile integration tests [\#434](https://github.com/apache/camel-quarkus/pull/434) ([lburgazzoli](https://github.com/lburgazzoli))
- Create a Camel Kafka extension [\#432](https://github.com/apache/camel-quarkus/pull/432) ([lburgazzoli](https://github.com/lburgazzoli))
- Improve bean validator extension [\#431](https://github.com/apache/camel-quarkus/pull/431) ([lburgazzoli](https://github.com/lburgazzoli))
- Initial JMS support [\#430](https://github.com/apache/camel-quarkus/pull/430) ([lburgazzoli](https://github.com/lburgazzoli))
- Fixes \#411 bean-validator extension [\#412](https://github.com/apache/camel-quarkus/pull/412) ([davsclaus](https://github.com/davsclaus))

## [0.4.0](https://github.com/apache/camel-quarkus/tree/0.4.0) (2019-11-15)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/0.3.1...0.4.0)

**Implemented enhancements:**

- Create a Camel File extension [\#398](https://github.com/apache/camel-quarkus/issues/398)
- Create a Camel SnakeYAML extension [\#338](https://github.com/apache/camel-quarkus/issues/338)

**Fixed bugs:**

- xslt extension not building in native mode [\#419](https://github.com/apache/camel-quarkus/issues/419)

**Closed issues:**

- Create a Camel exec extension [\#417](https://github.com/apache/camel-quarkus/issues/417)
- bean-validator extension [\#411](https://github.com/apache/camel-quarkus/issues/411)
- dataformat extension [\#408](https://github.com/apache/camel-quarkus/issues/408)
- xslt extension [\#406](https://github.com/apache/camel-quarkus/issues/406)
- Add scheduler extension [\#403](https://github.com/apache/camel-quarkus/issues/403)
- camel-validator component [\#391](https://github.com/apache/camel-quarkus/issues/391)
- \[code formatter\] multi line TODOs are not supported [\#389](https://github.com/apache/camel-quarkus/issues/389)
- @Inject CamelContext on RouteBuilder seems not working [\#386](https://github.com/apache/camel-quarkus/issues/386)
- ControlBus extension [\#385](https://github.com/apache/camel-quarkus/issues/385)
- camel-quarkus-microprofile-metrics - Does not work [\#384](https://github.com/apache/camel-quarkus/issues/384)
- Avoid usage of the remote-resource-plugin and prefer local LICENSE / NOTICE files [\#376](https://github.com/apache/camel-quarkus/issues/376)
- Upgrade to Quarkus 0.28.1 [\#372](https://github.com/apache/camel-quarkus/issues/372)
- Add description to extension matedata [\#360](https://github.com/apache/camel-quarkus/issues/360)
- Make netty-http dependent on netty and remove the duplications [\#357](https://github.com/apache/camel-quarkus/issues/357)
- Issues in the List of extensions  [\#356](https://github.com/apache/camel-quarkus/issues/356)
- Update contributor guide: s/json/yaml/, extension adoc page [\#354](https://github.com/apache/camel-quarkus/issues/354)
- Add category to extension descriptors [\#347](https://github.com/apache/camel-quarkus/issues/347)
- Experiment with the code formatter plugin https://code.revelc.net/formatter-maven-plugin/ [\#337](https://github.com/apache/camel-quarkus/issues/337)
- Make the maven plugin depend on the camel package-maven-plugin [\#336](https://github.com/apache/camel-quarkus/issues/336)
- Create a Camel Netty TCP extension [\#248](https://github.com/apache/camel-quarkus/issues/248)
- Be listed in code.quarkus.io [\#190](https://github.com/apache/camel-quarkus/issues/190)

**Merged pull requests:**

- Fix \#356 Issues in the List of extensions [\#425](https://github.com/apache/camel-quarkus/pull/425) ([ppalaga](https://github.com/ppalaga))
- build\(actions\): enable build in jvm mode for all the supported java versions [\#423](https://github.com/apache/camel-quarkus/pull/423) ([lburgazzoli](https://github.com/lburgazzoli))
- xslt extension not building in native mode [\#422](https://github.com/apache/camel-quarkus/pull/422) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: Remove unused itest dependencies [\#421](https://github.com/apache/camel-quarkus/pull/421) ([jamesnetherton](https://github.com/jamesnetherton))
- Add exec component extension [\#420](https://github.com/apache/camel-quarkus/pull/420) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#382 Support path parameters in platform-http [\#418](https://github.com/apache/camel-quarkus/pull/418) ([ppalaga](https://github.com/ppalaga))
- chore: add timer-log-cdi example [\#414](https://github.com/apache/camel-quarkus/pull/414) ([lburgazzoli](https://github.com/lburgazzoli))
- Dataformat [\#409](https://github.com/apache/camel-quarkus/pull/409) ([davsclaus](https://github.com/davsclaus))
- Xslt [\#407](https://github.com/apache/camel-quarkus/pull/407) ([davsclaus](https://github.com/davsclaus))
- core: avoid referencing application classes in bean build items and loading them in core build processors [\#405](https://github.com/apache/camel-quarkus/pull/405) ([lburgazzoli](https://github.com/lburgazzoli))
- Scheduler [\#404](https://github.com/apache/camel-quarkus/pull/404) ([davsclaus](https://github.com/davsclaus))
- Fix \#136 and \#396 [\#402](https://github.com/apache/camel-quarkus/pull/402) ([ppalaga](https://github.com/ppalaga))
- chore: Fix deprecation warning on netty tests and simplify it a bit [\#401](https://github.com/apache/camel-quarkus/pull/401) ([lburgazzoli](https://github.com/lburgazzoli))
- Add file component extension [\#399](https://github.com/apache/camel-quarkus/pull/399) ([jamesnetherton](https://github.com/jamesnetherton))
- Cleanup and CamelConfig improvements [\#397](https://github.com/apache/camel-quarkus/pull/397) ([lburgazzoli](https://github.com/lburgazzoli))
- Cleanup Netty extension [\#395](https://github.com/apache/camel-quarkus/pull/395) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix license headers [\#394](https://github.com/apache/camel-quarkus/pull/394) ([ppalaga](https://github.com/ppalaga))
- added Camel validation extension [\#393](https://github.com/apache/camel-quarkus/pull/393) ([ploef](https://github.com/ploef))
- Perform TypeConverterLoader discovery using jandex instead of camel's class path scanner [\#392](https://github.com/apache/camel-quarkus/pull/392) ([lburgazzoli](https://github.com/lburgazzoli))
- Add SnakeYAML extension [\#390](https://github.com/apache/camel-quarkus/pull/390) ([jamesnetherton](https://github.com/jamesnetherton))
- feat: controlbus extension. [\#388](https://github.com/apache/camel-quarkus/pull/388) ([davsclaus](https://github.com/davsclaus))
- Recommend mvn license:format -Plicense in the docs [\#387](https://github.com/apache/camel-quarkus/pull/387) ([ppalaga](https://github.com/ppalaga))
- Update to Quarkus 1.0.0.CR1 [\#381](https://github.com/apache/camel-quarkus/pull/381) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: remove checkstyle leftovers [\#380](https://github.com/apache/camel-quarkus/pull/380) ([lburgazzoli](https://github.com/lburgazzoli))
- Update to quarkus 0.28.1 [\#378](https://github.com/apache/camel-quarkus/pull/378) ([lburgazzoli](https://github.com/lburgazzoli))
- Use local legal files, fixes \#376 [\#377](https://github.com/apache/camel-quarkus/pull/377) ([gnodet](https://github.com/gnodet))
- Reuse camel package maven plugin to avoid duplicating code, fixes \#336 [\#375](https://github.com/apache/camel-quarkus/pull/375) ([gnodet](https://github.com/gnodet))
- chore\(deps\): remove jetty-client from suport/common [\#374](https://github.com/apache/camel-quarkus/pull/374) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade to quarkus 0.28.0 [\#373](https://github.com/apache/camel-quarkus/pull/373) ([gnodet](https://github.com/gnodet))
- Issue 337 [\#371](https://github.com/apache/camel-quarkus/pull/371) ([gnodet](https://github.com/gnodet))
- Improve the Github workflows: use -ntp, check licenses, better step a… [\#370](https://github.com/apache/camel-quarkus/pull/370) ([ppalaga](https://github.com/ppalaga))
- Use capabilities instead of feature names [\#369](https://github.com/apache/camel-quarkus/pull/369) ([lburgazzoli](https://github.com/lburgazzoli))
- Add description to extension matedata [\#367](https://github.com/apache/camel-quarkus/pull/367) ([lburgazzoli](https://github.com/lburgazzoli))
- Set camel-quarkus-last-release: 0.3.1 in site.yml [\#366](https://github.com/apache/camel-quarkus/pull/366) ([ppalaga](https://github.com/ppalaga))
- Fix \#357 Make netty-http dependent on netty and remove the duplications [\#365](https://github.com/apache/camel-quarkus/pull/365) ([ppalaga](https://github.com/ppalaga))
- Make -Pnative equivalent with -Dnative, prefer -Pnative in the docs [\#363](https://github.com/apache/camel-quarkus/pull/363) ([ppalaga](https://github.com/ppalaga))
- chore: fix cs [\#362](https://github.com/apache/camel-quarkus/pull/362) ([lburgazzoli](https://github.com/lburgazzoli))
- Use uppercase FHIR where appropriate [\#359](https://github.com/apache/camel-quarkus/pull/359) ([ppalaga](https://github.com/ppalaga))
- Publish discovered RoutesBuilders via CamelBeanBuildItem [\#358](https://github.com/apache/camel-quarkus/pull/358) ([ppalaga](https://github.com/ppalaga))
- Fix \#354 Update contributor guide: s/json/yaml/, extension adoc page [\#355](https://github.com/apache/camel-quarkus/pull/355) ([ppalaga](https://github.com/ppalaga))
- Camel quarkus netty [\#353](https://github.com/apache/camel-quarkus/pull/353) ([dhartford](https://github.com/dhartford))

## [0.3.1](https://github.com/apache/camel-quarkus/tree/0.3.1) (2019-10-30)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/0.3.0...0.3.1)

**Closed issues:**

- Update to quarkus 0.27.0 when available [\#346](https://github.com/apache/camel-quarkus/issues/346)
- platform-http should return 415 for an unaccepted content type [\#326](https://github.com/apache/camel-quarkus/issues/326)
- TarfileTest can fail on exotic platforms [\#270](https://github.com/apache/camel-quarkus/issues/270)
- platform-http component should return 204 for success and no body [\#220](https://github.com/apache/camel-quarkus/issues/220)

**Merged pull requests:**

- Improve service filter and related methods [\#351](https://github.com/apache/camel-quarkus/pull/351) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade to quarkus 0.27.0 [\#350](https://github.com/apache/camel-quarkus/pull/350) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#270 TarfileTest can fail on exotic platforms [\#349](https://github.com/apache/camel-quarkus/pull/349) ([ppalaga](https://github.com/ppalaga))
- Fix \#220 platform-http component should return 204 for success and no… [\#348](https://github.com/apache/camel-quarkus/pull/348) ([ppalaga](https://github.com/ppalaga))
- Set camel-quarkus-last-release: 0.3.0 in site.yml [\#345](https://github.com/apache/camel-quarkus/pull/345) ([ppalaga](https://github.com/ppalaga))
- Improve the contributor guide, esp. the create-extension examples [\#343](https://github.com/apache/camel-quarkus/pull/343) ([ppalaga](https://github.com/ppalaga))
- Created a camel-pdf component extension fixes \#341 [\#342](https://github.com/apache/camel-quarkus/pull/342) ([aldettinger](https://github.com/aldettinger))
- Improve camel service discovery and filtering [\#340](https://github.com/apache/camel-quarkus/pull/340) ([lburgazzoli](https://github.com/lburgazzoli))
- main: impove events and build phase [\#339](https://github.com/apache/camel-quarkus/pull/339) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#326 platform-http should return 415 for an unaccepted content type [\#335](https://github.com/apache/camel-quarkus/pull/335) ([ppalaga](https://github.com/ppalaga))

## [0.3.0](https://github.com/apache/camel-quarkus/tree/0.3.0) (2019-10-25)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/0.2.0...0.3.0)

**Implemented enhancements:**

- Create a Camel VM extension [\#318](https://github.com/apache/camel-quarkus/issues/318)
- Create a Camel Slack extension [\#305](https://github.com/apache/camel-quarkus/issues/305)

**Fixed bugs:**

- Paho integration tests fail in native mode [\#273](https://github.com/apache/camel-quarkus/issues/273)

**Closed issues:**

- Create a Camel pdf component extension [\#341](https://github.com/apache/camel-quarkus/issues/341)
- Do not use docker to run native tests [\#332](https://github.com/apache/camel-quarkus/issues/332)
- Document the platform-http extension [\#324](https://github.com/apache/camel-quarkus/issues/324)
- Make camel-attachments an optional dependency of platform-http [\#322](https://github.com/apache/camel-quarkus/issues/322)
- Upgarde to camel 3.0.0-RC3 [\#316](https://github.com/apache/camel-quarkus/issues/316)
- Upgrade to quarkus 0.26.0 [\#315](https://github.com/apache/camel-quarkus/issues/315)
- examples/rest-json - Needs trailing slash for urls to work [\#309](https://github.com/apache/camel-quarkus/issues/309)
- Support multipart/form-data in platform-http extension [\#308](https://github.com/apache/camel-quarkus/issues/308)
- Add observability example [\#297](https://github.com/apache/camel-quarkus/issues/297)
- Add a support/xml artifact for common substrate support [\#294](https://github.com/apache/camel-quarkus/issues/294)
- Rename xml-common extension to core-xml [\#292](https://github.com/apache/camel-quarkus/issues/292)
- Bind discovered routes to registry to leverage RoutesCollector [\#290](https://github.com/apache/camel-quarkus/issues/290)
- master failing  [\#288](https://github.com/apache/camel-quarkus/issues/288)
- Un-negate the names [\#285](https://github.com/apache/camel-quarkus/issues/285)
- Missing versions/dependancies in rest json example [\#281](https://github.com/apache/camel-quarkus/issues/281)
- Add minimal extension metadata [\#278](https://github.com/apache/camel-quarkus/issues/278)
- camel-quarkus-integration-test-core -Dnative outofmemory or 137 error [\#275](https://github.com/apache/camel-quarkus/issues/275)
- Add tarfile extension [\#265](https://github.com/apache/camel-quarkus/issues/265)
- About component REST compatibility issues [\#264](https://github.com/apache/camel-quarkus/issues/264)
- integration-tests/servlet doesn't work in development mode [\#263](https://github.com/apache/camel-quarkus/issues/263)
- Use bomEntryVersion of CreateExtensionMojo to avoid ${project.version} usage in BOMs [\#262](https://github.com/apache/camel-quarkus/issues/262)
- camel-quarkus parent pom when already have a parent pom [\#260](https://github.com/apache/camel-quarkus/issues/260)
- The User guide should refer to the rest-json example rather than the servlet itest [\#259](https://github.com/apache/camel-quarkus/issues/259)
- Shell scripts in the user guide documentation are not compatible with Mac OS X [\#257](https://github.com/apache/camel-quarkus/issues/257)
- \[servlet-extension\] Unrecognized configuration key "quarkus.camel.servlet.url-patterns" provided [\#251](https://github.com/apache/camel-quarkus/issues/251)
- CamelContext.getVersion\(\) always returns an empty string [\#247](https://github.com/apache/camel-quarkus/issues/247)
- Update doc with better extension list [\#245](https://github.com/apache/camel-quarkus/issues/245)
- Auto configure MicroProfile metrics Camel context event notifier [\#240](https://github.com/apache/camel-quarkus/issues/240)
- ActiveMQTestResource should not eat the exception [\#234](https://github.com/apache/camel-quarkus/issues/234)
- Help with the creation of the Component Camel-Quarkus-JMS [\#233](https://github.com/apache/camel-quarkus/issues/233)
- Add a daily job that test master agains quarkus snapshots [\#232](https://github.com/apache/camel-quarkus/issues/232)
- Upgrade to Quarkus 0.23.0 [\#209](https://github.com/apache/camel-quarkus/issues/209)
- Release 0.2.0 [\#203](https://github.com/apache/camel-quarkus/issues/203)
- Remove scaffold-integration-test.groovy [\#173](https://github.com/apache/camel-quarkus/issues/173)
- netty4-http producer fails with RejectedExecutionException [\#132](https://github.com/apache/camel-quarkus/issues/132)
- Decide how to maintain examples [\#118](https://github.com/apache/camel-quarkus/issues/118)
- camel application property routesUri is not overridden at runtime [\#54](https://github.com/apache/camel-quarkus/issues/54)

**Merged pull requests:**

- Polish examples and use -P native for all of them for native build. [\#334](https://github.com/apache/camel-quarkus/pull/334) ([davsclaus](https://github.com/davsclaus))
- Do not use docker to run native tests, fixes \#332 [\#333](https://github.com/apache/camel-quarkus/pull/333) ([gnodet](https://github.com/gnodet))
- Add Slack extension [\#331](https://github.com/apache/camel-quarkus/pull/331) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(build\): add doclint-java8-disable profile borrowed from Apache Camel [\#329](https://github.com/apache/camel-quarkus/pull/329) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(build\): set groovy-maven-plugin version [\#328](https://github.com/apache/camel-quarkus/pull/328) ([lburgazzoli](https://github.com/lburgazzoli))
- Improve dev mode [\#327](https://github.com/apache/camel-quarkus/pull/327) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgarde quarkus to v0.26.1 [\#325](https://github.com/apache/camel-quarkus/pull/325) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#322 Make camel-attachments an optional dependency of platform-http [\#323](https://github.com/apache/camel-quarkus/pull/323) ([ppalaga](https://github.com/ppalaga))
- Fix \#308 Support multipart/form-data in platform-http extension [\#321](https://github.com/apache/camel-quarkus/pull/321) ([ppalaga](https://github.com/ppalaga))
- Add jackson and vm extensions, fixes \#306 and \#318 [\#320](https://github.com/apache/camel-quarkus/pull/320) ([gnodet](https://github.com/gnodet))
- Upgrade Camel & Quarkus to latest releases [\#317](https://github.com/apache/camel-quarkus/pull/317) ([jamesnetherton](https://github.com/jamesnetherton))
- Fixup \#262 Use bomEntryVersion of CreateExtensionMojo [\#313](https://github.com/apache/camel-quarkus/pull/313) ([ppalaga](https://github.com/ppalaga))
- Timer example [\#312](https://github.com/apache/camel-quarkus/pull/312) ([davsclaus](https://github.com/davsclaus))
- Add observability example [\#311](https://github.com/apache/camel-quarkus/pull/311) ([jamesnetherton](https://github.com/jamesnetherton))
- chore: rename SubstrateProcessor [\#307](https://github.com/apache/camel-quarkus/pull/307) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: add tests for quarkusio/quarkus\#4408 [\#301](https://github.com/apache/camel-quarkus/pull/301) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#285 Un-negate the config options names [\#300](https://github.com/apache/camel-quarkus/pull/300) ([ppalaga](https://github.com/ppalaga))
- Improve XML support [\#298](https://github.com/apache/camel-quarkus/pull/298) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix version in integration-test-pom.xml [\#296](https://github.com/apache/camel-quarkus/pull/296) ([johnpoth](https://github.com/johnpoth))
- Enable PlatformHttpTest.invalidMethod\(\) [\#295](https://github.com/apache/camel-quarkus/pull/295) ([ppalaga](https://github.com/ppalaga))
- master failing [\#291](https://github.com/apache/camel-quarkus/pull/291) ([lburgazzoli](https://github.com/lburgazzoli))
- Activate bomEntryVersion now that we are on Quarkus 0.25 [\#287](https://github.com/apache/camel-quarkus/pull/287) ([ppalaga](https://github.com/ppalaga))
- Add FHIR extension [\#286](https://github.com/apache/camel-quarkus/pull/286) ([johnpoth](https://github.com/johnpoth))
- Followup \#278 Assert that quarkus-extension.json exists for each exte… [\#284](https://github.com/apache/camel-quarkus/pull/284) ([ppalaga](https://github.com/ppalaga))
- Document health, metrics & OpenTracing extensions [\#283](https://github.com/apache/camel-quarkus/pull/283) ([jamesnetherton](https://github.com/jamesnetherton))
- Add minimal extension metadata [\#282](https://github.com/apache/camel-quarkus/pull/282) ([lburgazzoli](https://github.com/lburgazzoli))
- Update to quarkus 0.25.0 [\#280](https://github.com/apache/camel-quarkus/pull/280) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: Add OpenTracing extension [\#279](https://github.com/apache/camel-quarkus/pull/279) ([jamesnetherton](https://github.com/jamesnetherton))
- fix\(build\): Handle loading routes from XML with latest camel SNAPSHOT [\#277](https://github.com/apache/camel-quarkus/pull/277) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Paho integration tests fail in native mode [\#274](https://github.com/apache/camel-quarkus/pull/274) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: CamelContext.getVersion\(\) always returns an empty string [\#272](https://github.com/apache/camel-quarkus/pull/272) ([jamesnetherton](https://github.com/jamesnetherton))
- Add MicroProfile Health extension [\#271](https://github.com/apache/camel-quarkus/pull/271) ([jamesnetherton](https://github.com/jamesnetherton))
- Polish2 [\#269](https://github.com/apache/camel-quarkus/pull/269) ([davsclaus](https://github.com/davsclaus))
- Fixes \#265 - Add tarfile extension [\#266](https://github.com/apache/camel-quarkus/pull/266) ([davsclaus](https://github.com/davsclaus))
- Fix \#259 The User guide should refer to the rest-json example [\#261](https://github.com/apache/camel-quarkus/pull/261) ([ppalaga](https://github.com/ppalaga))
- Fix \#217 Support rest dsl in platform-http component [\#256](https://github.com/apache/camel-quarkus/pull/256) ([ppalaga](https://github.com/ppalaga))
- Remove the script for generating synthetic test-jars [\#255](https://github.com/apache/camel-quarkus/pull/255) ([ppalaga](https://github.com/ppalaga))
- Fix \#251 Unrecognized configuration key [\#254](https://github.com/apache/camel-quarkus/pull/254) ([ppalaga](https://github.com/ppalaga))
- camel application property routesUri is not overridden at runtime [\#252](https://github.com/apache/camel-quarkus/pull/252) ([lburgazzoli](https://github.com/lburgazzoli))
- \#245 update the extensions list in the website docs also [\#250](https://github.com/apache/camel-quarkus/pull/250) ([davsclaus](https://github.com/davsclaus))
- Make xml and jaxb disabled by default and opt-in when depending on ca… [\#249](https://github.com/apache/camel-quarkus/pull/249) ([gnodet](https://github.com/gnodet))
- chore: add some doc about camel-main build steps [\#246](https://github.com/apache/camel-quarkus/pull/246) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: remove workaround for runtime registry as issue has been fixed upstream [\#244](https://github.com/apache/camel-quarkus/pull/244) ([lburgazzoli](https://github.com/lburgazzoli))
- Generate extension list readme file via tooling like we do at Apache Camel [\#243](https://github.com/apache/camel-quarkus/pull/243) ([davsclaus](https://github.com/davsclaus))
- quarkus-camel-catalog [\#242](https://github.com/apache/camel-quarkus/pull/242) ([davsclaus](https://github.com/davsclaus))
- Auto configure MicroProfile metrics Camel context event notifier [\#241](https://github.com/apache/camel-quarkus/pull/241) ([jamesnetherton](https://github.com/jamesnetherton))
- Added License header on the html file [\#239](https://github.com/apache/camel-quarkus/pull/239) ([WillemJiang](https://github.com/WillemJiang))
- port rest-json quickstart to camel-quarkus [\#238](https://github.com/apache/camel-quarkus/pull/238) ([lburgazzoli](https://github.com/lburgazzoli))
- Improve the beans and registry BuildItems' JavaDoc [\#237](https://github.com/apache/camel-quarkus/pull/237) ([ppalaga](https://github.com/ppalaga))
- Add workarounds for https://github.com/quarkusio/quarkus/issues/4407 [\#236](https://github.com/apache/camel-quarkus/pull/236) ([lburgazzoli](https://github.com/lburgazzoli))
- \#234 Added log when starting or stoping ActiveMQ Broker failed [\#235](https://github.com/apache/camel-quarkus/pull/235) ([WillemJiang](https://github.com/WillemJiang))
- Add support for quarkus provided event loop [\#231](https://github.com/apache/camel-quarkus/pull/231) ([lburgazzoli](https://github.com/lburgazzoli))
- Ensure the PlatformHttpComponent is registered before the routes are started [\#230](https://github.com/apache/camel-quarkus/pull/230) ([lburgazzoli](https://github.com/lburgazzoli))
- Do not use deprecated methods [\#229](https://github.com/apache/camel-quarkus/pull/229) ([lburgazzoli](https://github.com/lburgazzoli))
- Cleanup [\#228](https://github.com/apache/camel-quarkus/pull/228) ([lburgazzoli](https://github.com/lburgazzoli))
- Use MainSupport as base for running Camel [\#226](https://github.com/apache/camel-quarkus/pull/226) ([lburgazzoli](https://github.com/lburgazzoli))
- Rename substitutions class names [\#225](https://github.com/apache/camel-quarkus/pull/225) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: rename CamelRegistryBuildItem to a more meaningful CamelBeanBuildItem [\#222](https://github.com/apache/camel-quarkus/pull/222) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(deps\): upgrade quarkus to v0.23.2 [\#221](https://github.com/apache/camel-quarkus/pull/221) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: fix mail cs [\#219](https://github.com/apache/camel-quarkus/pull/219) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove scaffold-integration-test.groovy [\#216](https://github.com/apache/camel-quarkus/pull/216) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(build\): move depdendencies enforcer script to build/scripts [\#215](https://github.com/apache/camel-quarkus/pull/215) ([lburgazzoli](https://github.com/lburgazzoli))
- Submodule for support extensions [\#214](https://github.com/apache/camel-quarkus/pull/214) ([lburgazzoli](https://github.com/lburgazzoli))
- cleanup aws and paho extensions [\#212](https://github.com/apache/camel-quarkus/pull/212) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgarde to quarkus v0.23.1 [\#211](https://github.com/apache/camel-quarkus/pull/211) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade the docs to camel-quarkus-last-release: 0.2.0 [\#210](https://github.com/apache/camel-quarkus/pull/210) ([ppalaga](https://github.com/ppalaga))
- Auto configuration of metrics management strategies [\#205](https://github.com/apache/camel-quarkus/pull/205) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#184 Leverage platform http service [\#201](https://github.com/apache/camel-quarkus/pull/201) ([ppalaga](https://github.com/ppalaga))
- Fix \#133 Test netty4-http as a producer [\#134](https://github.com/apache/camel-quarkus/pull/134) ([ppalaga](https://github.com/ppalaga))

## [0.2.0](https://github.com/apache/camel-quarkus/tree/0.2.0) (2019-09-23)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/0.1.0...0.2.0)

**Implemented enhancements:**

- Create a Camel MQTT extension [\#171](https://github.com/apache/camel-quarkus/issues/171)

**Closed issues:**

- Master broken [\#185](https://github.com/apache/camel-quarkus/issues/185)
- Move the routesUri to the runtime config [\#182](https://github.com/apache/camel-quarkus/issues/182)
- Generate a jar with a non-test pom for each integration test [\#179](https://github.com/apache/camel-quarkus/issues/179)
- Remove support for defer-init-phase [\#172](https://github.com/apache/camel-quarkus/issues/172)
- Trigger the rebuild of Camel website on docs/\*\*/\* change [\#168](https://github.com/apache/camel-quarkus/issues/168)
- support for camel-timer [\#163](https://github.com/apache/camel-quarkus/issues/163)
- Salesforce integration test takes 30+ mins [\#149](https://github.com/apache/camel-quarkus/issues/149)
- Upgrade to Apache Camel RC1 [\#139](https://github.com/apache/camel-quarkus/issues/139)
- Test netty4-http as a producer [\#133](https://github.com/apache/camel-quarkus/issues/133)
- Properies evaluation broken after the introduction of PropertyBindingSupport [\#129](https://github.com/apache/camel-quarkus/issues/129)
- Deployment BOM [\#124](https://github.com/apache/camel-quarkus/issues/124)
- Publish snaphosts [\#123](https://github.com/apache/camel-quarkus/issues/123)
- rename xml extension to xml-common [\#116](https://github.com/apache/camel-quarkus/issues/116)
- Move create-extension-templates to i.e. tooling [\#114](https://github.com/apache/camel-quarkus/issues/114)
- Document the release process [\#113](https://github.com/apache/camel-quarkus/issues/113)
- Make camel-quarkus-bom usable as a parent for user applications [\#112](https://github.com/apache/camel-quarkus/issues/112)
- Release v0.1.0 [\#109](https://github.com/apache/camel-quarkus/issues/109)
- Servlet extension should set the default RestConfiguration [\#107](https://github.com/apache/camel-quarkus/issues/107)
- Make CamelRuntime smart to decide deferInitPhase [\#96](https://github.com/apache/camel-quarkus/issues/96)
- Env variable substitution doesn't work [\#82](https://github.com/apache/camel-quarkus/issues/82)
- Bean extension fails in native mode due to using dynamic proxies [\#70](https://github.com/apache/camel-quarkus/issues/70)
- FastCamelContext.clearModel\(\) causes NPEs at runtime [\#69](https://github.com/apache/camel-quarkus/issues/69)
- Enforce dependency rules [\#58](https://github.com/apache/camel-quarkus/issues/58)
- Re-introduce test scope in integration test projects [\#41](https://github.com/apache/camel-quarkus/issues/41)
- Website [\#38](https://github.com/apache/camel-quarkus/issues/38)
- quarkus-camel - Migrate option prefixes [\#8](https://github.com/apache/camel-quarkus/issues/8)
- Upgrade to Camel SNAPSHOT [\#7](https://github.com/apache/camel-quarkus/issues/7)

**Merged pull requests:**

- Disable deployment of synthetic test poms for now see \#207 [\#208](https://github.com/apache/camel-quarkus/pull/208) ([ppalaga](https://github.com/ppalaga))
- Improve the maven deployment of the synthetic test jars [\#206](https://github.com/apache/camel-quarkus/pull/206) ([ppalaga](https://github.com/ppalaga))
- Set the missing deploy plugin properties for the reusable-test-jar ex… [\#204](https://github.com/apache/camel-quarkus/pull/204) ([ppalaga](https://github.com/ppalaga))
- Upgrade to Quarkus 0.22.0 [\#202](https://github.com/apache/camel-quarkus/pull/202) ([ppalaga](https://github.com/ppalaga))
- improve the paho integration test [\#200](https://github.com/apache/camel-quarkus/pull/200) ([zhfeng](https://github.com/zhfeng))
- Add the camel-paho extension to support the MQTT [\#197](https://github.com/apache/camel-quarkus/pull/197) ([zhfeng](https://github.com/zhfeng))
- chore\(deps\): update quarkus to v0.21.2 [\#196](https://github.com/apache/camel-quarkus/pull/196) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(it\): add noDeps to quarkus-maven-plugin to make hot-reload working in multi-module projects [\#194](https://github.com/apache/camel-quarkus/pull/194) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(reflection\): add CamelContext and StreamCachingStrategy to the list of reflective classes [\#193](https://github.com/apache/camel-quarkus/pull/193) ([lburgazzoli](https://github.com/lburgazzoli))
- don't start camel context before the container is fully started [\#192](https://github.com/apache/camel-quarkus/pull/192) ([lburgazzoli](https://github.com/lburgazzoli))
- Issue 69 [\#187](https://github.com/apache/camel-quarkus/pull/187) ([gnodet](https://github.com/gnodet))
- Fix \#179 Generate a jar with a non-test pom for each integration test [\#181](https://github.com/apache/camel-quarkus/pull/181) ([ppalaga](https://github.com/ppalaga))
- Make code generators checkstyle compliant [\#177](https://github.com/apache/camel-quarkus/pull/177) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade to Maven 3.6.2 [\#176](https://github.com/apache/camel-quarkus/pull/176) ([ppalaga](https://github.com/ppalaga))
- Fix checkstyle violations [\#175](https://github.com/apache/camel-quarkus/pull/175) ([jamesnetherton](https://github.com/jamesnetherton))
- Expose metrics in quarkus [\#174](https://github.com/apache/camel-quarkus/pull/174) ([jamesnetherton](https://github.com/jamesnetherton))
- Upgrade to Apache Camel RC1 [\#170](https://github.com/apache/camel-quarkus/pull/170) ([lburgazzoli](https://github.com/lburgazzoli))
- Add website build trigger [\#169](https://github.com/apache/camel-quarkus/pull/169) ([zregvart](https://github.com/zregvart))
- CSV Extension [\#167](https://github.com/apache/camel-quarkus/pull/167) ([ppalaga](https://github.com/ppalaga))
- Fixes \#123 adding a deploy profile [\#166](https://github.com/apache/camel-quarkus/pull/166) ([oscerd](https://github.com/oscerd))
- camel-zipfile quarkus extension [\#165](https://github.com/apache/camel-quarkus/pull/165) ([davsclaus](https://github.com/davsclaus))
- Support for camel-mail [\#164](https://github.com/apache/camel-quarkus/pull/164) ([gnodet](https://github.com/gnodet))
- Groovy script to scaffold an integration test when creating a new [\#160](https://github.com/apache/camel-quarkus/pull/160) ([ppalaga](https://github.com/ppalaga))
- Fix \#70 Bean extension does not fail in native mode due to dynamic pr… [\#158](https://github.com/apache/camel-quarkus/pull/158) ([ppalaga](https://github.com/ppalaga))
- Fixup \#124 Deployments POM [\#157](https://github.com/apache/camel-quarkus/pull/157) ([ppalaga](https://github.com/ppalaga))
- Fix \#58 Enforce dependency rules [\#156](https://github.com/apache/camel-quarkus/pull/156) ([ppalaga](https://github.com/ppalaga))
- Update the link to the new site of Camel [\#155](https://github.com/apache/camel-quarkus/pull/155) ([oscerd](https://github.com/oscerd))
- Remove unecessary conditional discovery [\#154](https://github.com/apache/camel-quarkus/pull/154) ([lburgazzoli](https://github.com/lburgazzoli))
- Adapt the Contributor guide to the new layout of POMs and new native … [\#153](https://github.com/apache/camel-quarkus/pull/153) ([ppalaga](https://github.com/ppalaga))
- Modularize recorder and processors [\#152](https://github.com/apache/camel-quarkus/pull/152) ([lburgazzoli](https://github.com/lburgazzoli))
- Set disableReports=true in quarkus-maven-plugin config to speed up th… [\#151](https://github.com/apache/camel-quarkus/pull/151) ([ppalaga](https://github.com/ppalaga))
- Fix \#41 Re-introduce test scope in integration test projects [\#150](https://github.com/apache/camel-quarkus/pull/150) ([ppalaga](https://github.com/ppalaga))
- Basic impl for \#147 [\#148](https://github.com/apache/camel-quarkus/pull/148) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(test\): add test to validate camel registry hooks in ArC [\#146](https://github.com/apache/camel-quarkus/pull/146) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#124 Deployment BOM [\#145](https://github.com/apache/camel-quarkus/pull/145) ([ppalaga](https://github.com/ppalaga))
- chore\(extension\): add extension for camel-http-common [\#144](https://github.com/apache/camel-quarkus/pull/144) ([lburgazzoli](https://github.com/lburgazzoli))
- Add tests to the twitter itest project [\#138](https://github.com/apache/camel-quarkus/pull/138) ([ppalaga](https://github.com/ppalaga))
- Upgrade to Quarkus 0.21.1 [\#137](https://github.com/apache/camel-quarkus/pull/137) ([ppalaga](https://github.com/ppalaga))
- Upgrade to Quarkus 0.21.0 [\#135](https://github.com/apache/camel-quarkus/pull/135) ([ppalaga](https://github.com/ppalaga))
- Fix \#129 Properies evaluation broken after the introduction of Proper… [\#130](https://github.com/apache/camel-quarkus/pull/130) ([ppalaga](https://github.com/ppalaga))
- Order the dependencies managed in the BOM [\#127](https://github.com/apache/camel-quarkus/pull/127) ([ppalaga](https://github.com/ppalaga))
- Fix \#114 Move create-extension-templates to i.e. tooling [\#126](https://github.com/apache/camel-quarkus/pull/126) ([ppalaga](https://github.com/ppalaga))
- Fix \#113 Document the release process [\#125](https://github.com/apache/camel-quarkus/pull/125) ([ppalaga](https://github.com/ppalaga))
- User guide [\#122](https://github.com/apache/camel-quarkus/pull/122) ([ppalaga](https://github.com/ppalaga))
- create extension for camel's core cloud impl [\#121](https://github.com/apache/camel-quarkus/pull/121) ([lburgazzoli](https://github.com/lburgazzoli))
- Override DefaultStreamCachingStrategy::resolveSpoolDirectory to avoid NPE [\#120](https://github.com/apache/camel-quarkus/pull/120) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: replace custom properties binding implementation with PropertyBindingSupport from camel support [\#119](https://github.com/apache/camel-quarkus/pull/119) ([lburgazzoli](https://github.com/lburgazzoli))
- rename xml extension to xml-common [\#117](https://github.com/apache/camel-quarkus/pull/117) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#112 Make camel-quarkus-bom usable as a parent for user applications [\#115](https://github.com/apache/camel-quarkus/pull/115) ([ppalaga](https://github.com/ppalaga))

## [0.1.0](https://github.com/apache/camel-quarkus/tree/0.1.0) (2019-08-07)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/0.0.2...0.1.0)

**Implemented enhancements:**

- Consider porting the Twitter Camel support [\#57](https://github.com/apache/camel-quarkus/issues/57)

**Closed issues:**

- Figure out whether the Reifier substitutions can be added conditionally [\#98](https://github.com/apache/camel-quarkus/issues/98)
- AWS Extensions integration test are not built as native [\#81](https://github.com/apache/camel-quarkus/issues/81)
- Documentation [\#37](https://github.com/apache/camel-quarkus/issues/37)
- Release first version of camel-quarkus [\#36](https://github.com/apache/camel-quarkus/issues/36)
- "Multiple consumers for the same endpoint" after renaming packages in extensions/servlet/deployment/src/test/java [\#24](https://github.com/apache/camel-quarkus/issues/24)

**Merged pull requests:**

- Figure out whether the Reifier substitutions can be added conditionally [\#110](https://github.com/apache/camel-quarkus/pull/110) ([lburgazzoli](https://github.com/lburgazzoli))
- Use source block instead of code [\#106](https://github.com/apache/camel-quarkus/pull/106) ([zregvart](https://github.com/zregvart))
- Fix \#37 Setup the documentation [\#105](https://github.com/apache/camel-quarkus/pull/105) ([ppalaga](https://github.com/ppalaga))
- Remove the TravisCI badge from the README [\#104](https://github.com/apache/camel-quarkus/pull/104) ([ppalaga](https://github.com/ppalaga))
- Rename the rest of java packages in itests [\#103](https://github.com/apache/camel-quarkus/pull/103) ([ppalaga](https://github.com/ppalaga))
- Add configuration for quarkus:create-extension mojo [\#102](https://github.com/apache/camel-quarkus/pull/102) ([ppalaga](https://github.com/ppalaga))
- chore\(cleanup\): remove ide-config [\#101](https://github.com/apache/camel-quarkus/pull/101) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade quarkus to v0.20.0  plsu some cleanup [\#100](https://github.com/apache/camel-quarkus/pull/100) ([lburgazzoli](https://github.com/lburgazzoli))
- Add twitter extension [\#99](https://github.com/apache/camel-quarkus/pull/99) ([jamesnetherton](https://github.com/jamesnetherton))
- Omit the artifactId in release tags [\#95](https://github.com/apache/camel-quarkus/pull/95) ([ppalaga](https://github.com/ppalaga))
- Fix typo s/AWs\_REGION/AWS\_REGION/ [\#94](https://github.com/apache/camel-quarkus/pull/94) ([ppalaga](https://github.com/ppalaga))
- Move test packages to org.apache.camel [\#77](https://github.com/apache/camel-quarkus/pull/77) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade to Camel 3.0.0-M4 [\#72](https://github.com/apache/camel-quarkus/pull/72) ([ppalaga](https://github.com/ppalaga))

## [0.0.2](https://github.com/apache/camel-quarkus/tree/0.0.2) (2019-07-29)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/camel-quarkus-parent-0.0.1...0.0.2)

## [camel-quarkus-parent-0.0.1](https://github.com/apache/camel-quarkus/tree/camel-quarkus-parent-0.0.1) (2019-07-25)

[Full Changelog](https://github.com/apache/camel-quarkus/compare/0e8177815305790d7e79004a9e9f81a48d2b7c41...camel-quarkus-parent-0.0.1)

**Closed issues:**

- Upgrade quarkus to v0.19.0 [\#60](https://github.com/apache/camel-quarkus/issues/60)
- Review extensions' dependencies chains [\#56](https://github.com/apache/camel-quarkus/issues/56)
- Use caffein as LRUCache in native mode [\#45](https://github.com/apache/camel-quarkus/issues/45)
- Infinispan substrate test are disbaled [\#44](https://github.com/apache/camel-quarkus/issues/44)
- Use RestAssured in JDBC test [\#42](https://github.com/apache/camel-quarkus/issues/42)
- Move Bean test out of Core integration test [\#39](https://github.com/apache/camel-quarkus/issues/39)
- Move XStream processor from salesforce to a dedicated extension [\#34](https://github.com/apache/camel-quarkus/issues/34)
- Move jetty processor from salesforce to a dedicated extension [\#33](https://github.com/apache/camel-quarkus/issues/33)
- Move netty integration-tests out of core [\#32](https://github.com/apache/camel-quarkus/issues/32)
- Move infinispan integration-tests out of core [\#31](https://github.com/apache/camel-quarkus/issues/31)
- Use docker-build in travis [\#29](https://github.com/apache/camel-quarkus/issues/29)
- Rename integration test artifacts [\#25](https://github.com/apache/camel-quarkus/issues/25)
- Avoid 3rd party maven repositories if possible [\#20](https://github.com/apache/camel-quarkus/issues/20)
- Configure license format [\#19](https://github.com/apache/camel-quarkus/issues/19)
- Add Camel-AWS-EKS extension [\#18](https://github.com/apache/camel-quarkus/issues/18)
- Configure checkstyle [\#14](https://github.com/apache/camel-quarkus/issues/14)
- Test the native mode on TravisCI [\#11](https://github.com/apache/camel-quarkus/issues/11)
- Produce test-jars of the integration tests [\#10](https://github.com/apache/camel-quarkus/issues/10)
- Initial source code - Package names [\#6](https://github.com/apache/camel-quarkus/issues/6)
- Initial source code - Maven GAV [\#5](https://github.com/apache/camel-quarkus/issues/5)
- Initial source code - Add license headers [\#4](https://github.com/apache/camel-quarkus/issues/4)

**Merged pull requests:**

- Added failIfNoTest option in surefire configuration [\#93](https://github.com/apache/camel-quarkus/pull/93) ([oscerd](https://github.com/oscerd))
- chore\(build\): move release profile to camel-quarkus-parent [\#92](https://github.com/apache/camel-quarkus/pull/92) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove unused imports from CamelRoute in netty4-http integration test [\#91](https://github.com/apache/camel-quarkus/pull/91) ([ppalaga](https://github.com/ppalaga))
- chore\(it\): cleanup it poms [\#90](https://github.com/apache/camel-quarkus/pull/90) ([lburgazzoli](https://github.com/lburgazzoli))
- AWS Extension configuration classes need to be registered for reflection [\#89](https://github.com/apache/camel-quarkus/pull/89) ([oscerd](https://github.com/oscerd))
- Changed the integration test module name and folder name for AWS [\#88](https://github.com/apache/camel-quarkus/pull/88) ([oscerd](https://github.com/oscerd))
- chore\(test\): add camel core cdi test [\#87](https://github.com/apache/camel-quarkus/pull/87) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix typo s/nett4/netty4/ [\#86](https://github.com/apache/camel-quarkus/pull/86) ([ppalaga](https://github.com/ppalaga))
- Add a single integration test module for the AWS extensions [\#85](https://github.com/apache/camel-quarkus/pull/85) ([oscerd](https://github.com/oscerd))
- chore\(it\): cleanup application.properties and poms [\#84](https://github.com/apache/camel-quarkus/pull/84) ([lburgazzoli](https://github.com/lburgazzoli))
- Fixes \#18 Add a Camel AWS-EKS Extension [\#83](https://github.com/apache/camel-quarkus/pull/83) ([oscerd](https://github.com/oscerd))
- Move netty integration-tests out of core [\#79](https://github.com/apache/camel-quarkus/pull/79) ([lburgazzoli](https://github.com/lburgazzoli))
- Dedicated extension for jetty and xstream [\#78](https://github.com/apache/camel-quarkus/pull/78) ([lburgazzoli](https://github.com/lburgazzoli))
- Prepare for Camel 3.0.0-M3/4 [\#67](https://github.com/apache/camel-quarkus/pull/67) ([ppalaga](https://github.com/ppalaga))
- Upgrade quarkus to v0.19.1 [\#66](https://github.com/apache/camel-quarkus/pull/66) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade quarkus to v0.19.0 [\#64](https://github.com/apache/camel-quarkus/pull/64) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(build\): cleanup build set-up [\#61](https://github.com/apache/camel-quarkus/pull/61) ([lburgazzoli](https://github.com/lburgazzoli))
- Review extensions' dependencies chains [\#59](https://github.com/apache/camel-quarkus/pull/59) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#31 Move infinispan integration-tests out of core [\#55](https://github.com/apache/camel-quarkus/pull/55) ([ppalaga](https://github.com/ppalaga))
- chore\(build\): remove travis build [\#53](https://github.com/apache/camel-quarkus/pull/53) ([lburgazzoli](https://github.com/lburgazzoli))
- Removed Jenkinsfile not used [\#52](https://github.com/apache/camel-quarkus/pull/52) ([oscerd](https://github.com/oscerd))
- Do not use io.quarkus...FeatureBuildItem feature constants [\#50](https://github.com/apache/camel-quarkus/pull/50) ([ppalaga](https://github.com/ppalaga))
- chore\(build\): add Jenkinsfile [\#49](https://github.com/apache/camel-quarkus/pull/49) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(arc\): add ConsumerTemplate and ProducerTemplate producers [\#48](https://github.com/apache/camel-quarkus/pull/48) ([lburgazzoli](https://github.com/lburgazzoli))
- Use RestAssured in JDBC test [\#47](https://github.com/apache/camel-quarkus/pull/47) ([lburgazzoli](https://github.com/lburgazzoli))
- Caffeine [\#46](https://github.com/apache/camel-quarkus/pull/46) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: ignore ObjectStore folder [\#43](https://github.com/apache/camel-quarkus/pull/43) ([lburgazzoli](https://github.com/lburgazzoli))
- Manage camel-servlet and camel-aws-sns in the BOM [\#40](https://github.com/apache/camel-quarkus/pull/40) ([ppalaga](https://github.com/ppalaga))
- Fix \#10 Produce test-jars of the integration tests [\#35](https://github.com/apache/camel-quarkus/pull/35) ([ppalaga](https://github.com/ppalaga))
- Use docker-build in travis [\#30](https://github.com/apache/camel-quarkus/pull/30) ([lburgazzoli](https://github.com/lburgazzoli))
- Avoid 3rd party maven repositories if possible [\#28](https://github.com/apache/camel-quarkus/pull/28) ([lburgazzoli](https://github.com/lburgazzoli))
- Add badges and How to build section to the README [\#27](https://github.com/apache/camel-quarkus/pull/27) ([ppalaga](https://github.com/ppalaga))
- Fix \#25 Use the same naming scheme for artifactIds and module names [\#26](https://github.com/apache/camel-quarkus/pull/26) ([ppalaga](https://github.com/ppalaga))
- Fix \#6 Rename packages from io.quarkus.camel to org.apache.camel.quarkus [\#23](https://github.com/apache/camel-quarkus/pull/23) ([ppalaga](https://github.com/ppalaga))
- Initial import cleanup [\#22](https://github.com/apache/camel-quarkus/pull/22) ([lburgazzoli](https://github.com/lburgazzoli))
- Use vanilla Maven Compiler Plugin version \(from maven central\) [\#21](https://github.com/apache/camel-quarkus/pull/21) ([davsclaus](https://github.com/davsclaus))
- chore\(build\): use project.version [\#15](https://github.com/apache/camel-quarkus/pull/15) ([lburgazzoli](https://github.com/lburgazzoli))
- Add keys [\#13](https://github.com/apache/camel-quarkus/pull/13) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#11 Test the native mode on TravisCI [\#12](https://github.com/apache/camel-quarkus/pull/12) ([ppalaga](https://github.com/ppalaga))
- Migrate Camel extensions from Quarkus [\#3](https://github.com/apache/camel-quarkus/pull/3) ([ppalaga](https://github.com/ppalaga))
- Add Maven wrapper and .travis.yml [\#2](https://github.com/apache/camel-quarkus/pull/2) ([ppalaga](https://github.com/ppalaga))
- Add Parent POM [\#1](https://github.com/apache/camel-quarkus/pull/1) ([ppalaga](https://github.com/ppalaga))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
