/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.solr.it;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import io.quarkus.runtime.StartupEvent;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
@Path("/solr/cloud")
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
public class SolrCloudResource extends SolrCommonResource {

    @ConfigProperty(name = "solr.cloud.component.url", defaultValue = "localhost:8981/solr?zkHost=localhost:1281&collection=collection1&username=solr&password=SolrRocks")
    String solrComponentUrl;

    @ConfigProperty(name = "solr.cloud.url", defaultValue = "localhost:8981/solr/collection1")
    String solrUrl;

    public void init(@Observes StartupEvent startupEvent) {
        solrComponentURI = String.format("solrCloud://%s", solrComponentUrl);
        solrClient = new HttpSolrClient.Builder(String.format("http://%s", solrUrl)).build();
    }
}
