/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.streams;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.WriteTimeoutException;

public class ChannelOutputStream
extends OutputStream {
    protected final StreamSinkChannel channel;
    protected volatile boolean closed;
    protected volatile long timeout;

    public ChannelOutputStream(StreamSinkChannel channel) {
        this.channel = channel;
    }

    public ChannelOutputStream(StreamSinkChannel channel, long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        this.channel = channel;
        long calcTimeout = unit.toMillis(timeout);
        this.timeout = timeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    private static IOException closed() {
        return new IOException("The output stream is closed");
    }

    public long getWriteTimeout(TimeUnit unit) {
        return unit.convert(this.timeout, TimeUnit.MILLISECONDS);
    }

    public void setWriteTimeout(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        long calcTimeout = unit.toMillis(timeout);
        this.timeout = timeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw ChannelOutputStream.closed();
        }
        ByteBuffer buffer = ByteBuffer.wrap(new byte[]{(byte)b});
        long timeout = this.timeout;
        if (timeout == 0L) {
            while (this.channel.write(buffer) == 0) {
                this.channel.awaitWritable();
                if (!this.closed) continue;
                throw ChannelOutputStream.closed();
            }
        } else {
            long now = System.currentTimeMillis();
            long deadline = now + timeout;
            while (this.channel.write(buffer) == 0) {
                if (now >= deadline) {
                    throw new WriteTimeoutException("Write timed out");
                }
                this.channel.awaitWritable(deadline - now, TimeUnit.MILLISECONDS);
                if (this.closed) {
                    throw ChannelOutputStream.closed();
                }
                now = System.currentTimeMillis();
            }
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw ChannelOutputStream.closed();
        }
        ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
        long timeout = this.timeout;
        if (timeout == 0L) {
            while (buffer.hasRemaining()) {
                while (this.channel.write(buffer) == 0) {
                    try {
                        this.channel.awaitWritable();
                    }
                    catch (InterruptedIOException e) {
                        e.bytesTransferred = buffer.position();
                        throw e;
                    }
                    if (!this.closed) continue;
                    throw ChannelOutputStream.closed();
                }
            }
        } else {
            long now = System.currentTimeMillis();
            long deadline = now + timeout;
            while (buffer.hasRemaining()) {
                while (this.channel.write(buffer) == 0) {
                    try {
                        if (now >= deadline) {
                            throw new WriteTimeoutException("Write timed out");
                        }
                        this.channel.awaitWritable(deadline - now, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedIOException e) {
                        e.bytesTransferred = buffer.position();
                        throw e;
                    }
                    if (!this.closed) continue;
                    throw ChannelOutputStream.closed();
                }
            }
        }
    }

    @Override
    public void flush() throws IOException {
        Channels.flushBlocking(this.channel);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        Channels.shutdownWritesBlocking(this.channel);
    }
}

