package apis

import (
	corev1 "k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/types"
)

// Patch describes a patch to be enforced at runtime
// +k8s:openapi-gen=true
type Patch struct {
	//ID represents a unique Identifier for this patch
	// +kubebuilder:validation:Required
	ID string `json:"id"`
	// SourceObject refs is an arrays of refereces to source objects that will be used as input for the template processing
	// +kubebuilder:validation:Optional
	// +listType=atomic
	SourceObjectRefs []corev1.ObjectReference `json:"sourceObjectRefs,omitempty"`

	// TargetObjectRef is a reference to the object to which the pacth should be applied.
	// +kubebuilder:validation:Required
	TargetObjectRef corev1.ObjectReference `json:"targetObjectRef"`

	// PatchType is the type of patch to be applied, one of "application/json-patch+json"'"application/merge-patch+json","application/strategic-merge-patch+json","application/apply-patch+yaml"
	// +kubebuilder:validation:Optional
	// +kubebuilder:validation:Enum="application/json-patch+json";"application/merge-patch+json";"application/strategic-merge-patch+json";"application/apply-patch+yaml"
	// default:="application/strategic-merge-patch+json"
	PatchType types.PatchType `json:"patchType,omitempty"`

	// PatchTemplate is a go template that will be resolved using the SourceObjectRefs as parameters. The result must be a valid patch based on the pacth type and the target object.
	// +kubebuilder:validation:Required
	PatchTemplate string `json:"patchTemplate"`
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Patch) DeepCopyInto(out *Patch) {
	*out = *in
	if in.SourceObjectRefs != nil {
		in, out := &in.SourceObjectRefs, &out.SourceObjectRefs
		*out = make([]corev1.ObjectReference, len(*in))
		copy(*out, *in)
	}
	out.TargetObjectRef = in.TargetObjectRef
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Patch.
func (in *Patch) DeepCopy() *Patch {
	if in == nil {
		return nil
	}
	out := new(Patch)
	in.DeepCopyInto(out)
	return out
}
