package apis

import metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"

// +patchMergeKey=type
// +patchStrategy=merge
// +listType=map
// +listMapKey=type
type Conditions []metav1.Condition

// EnforcingReconcileStatus represents the status of the last reconcile cycle. It's used to communicate success or failure and the error message
type EnforcingReconcileStatus struct {

	// ReconcileStatus this is the general status of the main reconciler
	// +kubebuilder:validation:Optional
	// +patchMergeKey=type
	// +patchStrategy=merge
	// +listType=map
	// +listMapKey=type
	Conditions []metav1.Condition `json:"conditions,omitempty" patchStrategy:"merge" patchMergeKey:"type"`

	//LockedResourceStatuses contains the reconcile status for each of the managed resources
	// +kubebuilder:validation:Optional
	LockedResourceStatuses map[string]Conditions `json:"lockedResourceStatuses,omitempty"`

	//LockedResourceStatuses contains the reconcile status for each of the managed resources
	// +kubebuilder:validation:Optional
	LockedPatchStatuses map[string]Conditions `json:"lockedPatchStatuses,omitempty"`
}

// EnforcingReconcileStatusAware represent a CRD type that has been enabled with ReconcileStatus, it can then benefit of a series of utility methods.
type EnforcingReconcileStatusAware interface {
	GetEnforcingReconcileStatus() EnforcingReconcileStatus
	SetEnforcingReconcileStatus(enforcingReconcileStatus EnforcingReconcileStatus)
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EnforcingReconcileStatus) DeepCopyInto(out *EnforcingReconcileStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]metav1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.LockedResourceStatuses != nil {
		in, out := &in.LockedResourceStatuses, &out.LockedResourceStatuses
		*out = make(map[string]Conditions, len(*in))
		for key, val := range *in {
			var outVal []metav1.Condition
			if val == nil {
				(*out)[key] = nil
			} else {
				in, out := &val, &outVal
				*out = make([]metav1.Condition, len(*in))
				for i := range *in {
					(*in)[i].DeepCopyInto(&(*out)[i])
				}
			}
			(*out)[key] = outVal
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EnforcingReconcileStatus.
func (in *EnforcingReconcileStatus) DeepCopy() *EnforcingReconcileStatus {
	if in == nil {
		return nil
	}
	out := new(EnforcingReconcileStatus)
	in.DeepCopyInto(out)
	return out
}
