/*
Copyright 2019 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    https://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package main

import (
	"flag"
	"fmt"
	"log"
	"net/http"
	"os"

	"github.com/knative/serving/test"
)

var wd string

func handler(w http.ResponseWriter, r *http.Request) {
	fmt.Fprintln(w, wd)
}

func main() {
	flag.Parse()
	wd, _ = os.Getwd()
	log.Printf("WorkingDir app started in %q.", wd)

	test.ListenAndServeGracefully(":8080", handler)
}
