// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/adapter/model/v1beta1/infrastructure_backend.proto

// This package defines the service and types used by adapter code to serve requests from Mixer.
// This package also defines the types that are used to create Mixer templates.

package v1beta1

import (
	context "context"
	fmt "fmt"
	rpc "github.com/gogo/googleapis/google/rpc"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	types "github.com/gogo/protobuf/types"
	grpc "google.golang.org/grpc"
	io "io"
	math "math"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Request message for `CreateSession` method.
type CreateSessionRequest struct {
	// Adapter specific configuration.
	AdapterConfig *types.Any `protobuf:"bytes,1,opt,name=adapter_config,json=adapterConfig,proto3" json:"adapter_config,omitempty"`
	// Map of instance names to their template-specific inferred type.
	InferredTypes map[string]*types.Any `protobuf:"bytes,2,rep,name=inferred_types,json=inferredTypes,proto3" json:"inferred_types,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *CreateSessionRequest) Reset()      { *m = CreateSessionRequest{} }
func (*CreateSessionRequest) ProtoMessage() {}
func (*CreateSessionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b62a0b3a6ebb4b55, []int{0}
}
func (m *CreateSessionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CreateSessionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CreateSessionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CreateSessionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSessionRequest.Merge(m, src)
}
func (m *CreateSessionRequest) XXX_Size() int {
	return m.Size()
}
func (m *CreateSessionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSessionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSessionRequest proto.InternalMessageInfo

func (m *CreateSessionRequest) GetAdapterConfig() *types.Any {
	if m != nil {
		return m.AdapterConfig
	}
	return nil
}

func (m *CreateSessionRequest) GetInferredTypes() map[string]*types.Any {
	if m != nil {
		return m.InferredTypes
	}
	return nil
}

// Response message for `CreateSession` method.
type CreateSessionResponse struct {
	// Id of the created session.
	SessionId string `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	// The success/failure status of create session call.
	Status *rpc.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
}

func (m *CreateSessionResponse) Reset()      { *m = CreateSessionResponse{} }
func (*CreateSessionResponse) ProtoMessage() {}
func (*CreateSessionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b62a0b3a6ebb4b55, []int{1}
}
func (m *CreateSessionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CreateSessionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CreateSessionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CreateSessionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSessionResponse.Merge(m, src)
}
func (m *CreateSessionResponse) XXX_Size() int {
	return m.Size()
}
func (m *CreateSessionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSessionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSessionResponse proto.InternalMessageInfo

func (m *CreateSessionResponse) GetSessionId() string {
	if m != nil {
		return m.SessionId
	}
	return ""
}

func (m *CreateSessionResponse) GetStatus() *rpc.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

// Request message for `Validate` method.
type ValidateRequest struct {
	// Adapter specific configuration.
	AdapterConfig *types.Any `protobuf:"bytes,1,opt,name=adapter_config,json=adapterConfig,proto3" json:"adapter_config,omitempty"`
	// Map of instance names to their template-specific inferred type.
	InferredTypes map[string]*types.Any `protobuf:"bytes,2,rep,name=inferred_types,json=inferredTypes,proto3" json:"inferred_types,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *ValidateRequest) Reset()      { *m = ValidateRequest{} }
func (*ValidateRequest) ProtoMessage() {}
func (*ValidateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b62a0b3a6ebb4b55, []int{2}
}
func (m *ValidateRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ValidateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ValidateRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ValidateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValidateRequest.Merge(m, src)
}
func (m *ValidateRequest) XXX_Size() int {
	return m.Size()
}
func (m *ValidateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ValidateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ValidateRequest proto.InternalMessageInfo

func (m *ValidateRequest) GetAdapterConfig() *types.Any {
	if m != nil {
		return m.AdapterConfig
	}
	return nil
}

func (m *ValidateRequest) GetInferredTypes() map[string]*types.Any {
	if m != nil {
		return m.InferredTypes
	}
	return nil
}

// Response message for `Validate` method.
type ValidateResponse struct {
	// The success/failure status of validation call.
	Status *rpc.Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
}

func (m *ValidateResponse) Reset()      { *m = ValidateResponse{} }
func (*ValidateResponse) ProtoMessage() {}
func (*ValidateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b62a0b3a6ebb4b55, []int{3}
}
func (m *ValidateResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ValidateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ValidateResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ValidateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValidateResponse.Merge(m, src)
}
func (m *ValidateResponse) XXX_Size() int {
	return m.Size()
}
func (m *ValidateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ValidateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ValidateResponse proto.InternalMessageInfo

func (m *ValidateResponse) GetStatus() *rpc.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

// Request message for `CloseSession` method.
type CloseSessionRequest struct {
	// Id of the session to be closed.
	SessionId string `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
}

func (m *CloseSessionRequest) Reset()      { *m = CloseSessionRequest{} }
func (*CloseSessionRequest) ProtoMessage() {}
func (*CloseSessionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b62a0b3a6ebb4b55, []int{4}
}
func (m *CloseSessionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CloseSessionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CloseSessionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CloseSessionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloseSessionRequest.Merge(m, src)
}
func (m *CloseSessionRequest) XXX_Size() int {
	return m.Size()
}
func (m *CloseSessionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CloseSessionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CloseSessionRequest proto.InternalMessageInfo

func (m *CloseSessionRequest) GetSessionId() string {
	if m != nil {
		return m.SessionId
	}
	return ""
}

// Response message for `CloseSession` method.
type CloseSessionResponse struct {
	// The success/failure status of close session call.
	Status *rpc.Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
}

func (m *CloseSessionResponse) Reset()      { *m = CloseSessionResponse{} }
func (*CloseSessionResponse) ProtoMessage() {}
func (*CloseSessionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b62a0b3a6ebb4b55, []int{5}
}
func (m *CloseSessionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CloseSessionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CloseSessionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CloseSessionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloseSessionResponse.Merge(m, src)
}
func (m *CloseSessionResponse) XXX_Size() int {
	return m.Size()
}
func (m *CloseSessionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CloseSessionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CloseSessionResponse proto.InternalMessageInfo

func (m *CloseSessionResponse) GetStatus() *rpc.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateSessionRequest)(nil), "istio.mixer.adapter.model.v1beta1.CreateSessionRequest")
	proto.RegisterMapType((map[string]*types.Any)(nil), "istio.mixer.adapter.model.v1beta1.CreateSessionRequest.InferredTypesEntry")
	proto.RegisterType((*CreateSessionResponse)(nil), "istio.mixer.adapter.model.v1beta1.CreateSessionResponse")
	proto.RegisterType((*ValidateRequest)(nil), "istio.mixer.adapter.model.v1beta1.ValidateRequest")
	proto.RegisterMapType((map[string]*types.Any)(nil), "istio.mixer.adapter.model.v1beta1.ValidateRequest.InferredTypesEntry")
	proto.RegisterType((*ValidateResponse)(nil), "istio.mixer.adapter.model.v1beta1.ValidateResponse")
	proto.RegisterType((*CloseSessionRequest)(nil), "istio.mixer.adapter.model.v1beta1.CloseSessionRequest")
	proto.RegisterType((*CloseSessionResponse)(nil), "istio.mixer.adapter.model.v1beta1.CloseSessionResponse")
}

func init() {
	proto.RegisterFile("mixer/adapter/model/v1beta1/infrastructure_backend.proto", fileDescriptor_b62a0b3a6ebb4b55)
}

var fileDescriptor_b62a0b3a6ebb4b55 = []byte{
	// 530 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x54, 0x41, 0x6f, 0xd3, 0x4c,
	0x10, 0xf5, 0x26, 0xfa, 0xaa, 0xaf, 0x5b, 0x52, 0xaa, 0x25, 0x15, 0xc1, 0x12, 0xab, 0x92, 0x53,
	0xd4, 0xc3, 0x5a, 0x4d, 0x11, 0x8d, 0x40, 0x42, 0x22, 0x51, 0x0f, 0xe1, 0xe8, 0xa2, 0x1e, 0xb8,
	0x44, 0x6b, 0x7b, 0x13, 0xad, 0xea, 0x7a, 0xdd, 0xdd, 0x75, 0x85, 0x4f, 0x54, 0xfc, 0x02, 0x84,
	0x38, 0x73, 0xe6, 0xa7, 0x70, 0xcc, 0xb1, 0x47, 0xe2, 0x5c, 0x38, 0xf6, 0x27, 0xa0, 0xda, 0x1b,
	0xb5, 0x49, 0x21, 0xad, 0x11, 0x12, 0x37, 0x6b, 0x67, 0xde, 0xbc, 0x37, 0x6f, 0x66, 0x0c, 0x3b,
	0xc7, 0xfc, 0x1d, 0x93, 0x0e, 0x0d, 0x68, 0xac, 0x99, 0x74, 0x8e, 0x45, 0xc0, 0x42, 0xe7, 0x74,
	0xc7, 0x63, 0x9a, 0xee, 0x38, 0x3c, 0x1a, 0x4a, 0xaa, 0xb4, 0x4c, 0x7c, 0x9d, 0x48, 0x36, 0xf0,
	0xa8, 0x7f, 0xc4, 0xa2, 0x80, 0xc4, 0x52, 0x68, 0x81, 0x9e, 0x70, 0xa5, 0xb9, 0x20, 0x39, 0x9e,
	0x18, 0x3c, 0xc9, 0xf1, 0xc4, 0xe0, 0xed, 0x47, 0x23, 0x21, 0x46, 0x21, 0x73, 0x72, 0x80, 0x97,
	0x0c, 0x1d, 0x1a, 0xa5, 0x05, 0xda, 0x7e, 0x68, 0x42, 0x32, 0xf6, 0x1d, 0xa5, 0xa9, 0x4e, 0x54,
	0x11, 0x68, 0x7e, 0xa9, 0xc0, 0x7a, 0x4f, 0x32, 0xaa, 0xd9, 0x01, 0x53, 0x8a, 0x8b, 0xc8, 0x65,
	0x27, 0x09, 0x53, 0x1a, 0xbd, 0x80, 0xeb, 0x86, 0x65, 0xe0, 0x8b, 0x68, 0xc8, 0x47, 0x0d, 0xb0,
	0x05, 0x5a, 0x6b, 0xed, 0x3a, 0x29, 0x4a, 0x91, 0x19, 0x0b, 0x79, 0x15, 0xa5, 0x6e, 0xcd, 0xe4,
	0xf6, 0xf2, 0x54, 0x74, 0x02, 0xd7, 0x79, 0x34, 0x64, 0x52, 0xb2, 0x60, 0xa0, 0xd3, 0x98, 0xa9,
	0x46, 0x65, 0xab, 0xda, 0x5a, 0x6b, 0xbf, 0x26, 0xb7, 0x76, 0x41, 0x7e, 0xa5, 0x86, 0xf4, 0x4d,
	0xb5, 0x37, 0x97, 0xc5, 0xf6, 0x23, 0x2d, 0x53, 0xb7, 0xc6, 0xaf, 0xbf, 0xd9, 0x87, 0x10, 0xdd,
	0x4c, 0x42, 0x1b, 0xb0, 0x7a, 0xc4, 0xd2, 0x5c, 0xfa, 0xaa, 0x7b, 0xf9, 0x89, 0xb6, 0xe1, 0x7f,
	0xa7, 0x34, 0x4c, 0x58, 0xa3, 0xb2, 0xa4, 0x9d, 0x22, 0xe5, 0x79, 0xa5, 0x03, 0x9a, 0x1e, 0xdc,
	0x5c, 0x50, 0xa4, 0x62, 0x11, 0x29, 0x86, 0x1e, 0x43, 0xa8, 0x8a, 0xa7, 0x01, 0x0f, 0x0c, 0xc3,
	0xaa, 0x79, 0xe9, 0x07, 0x68, 0x1b, 0xae, 0x14, 0x46, 0x1b, 0x22, 0x34, 0x23, 0x92, 0xb1, 0x4f,
	0x0e, 0xf2, 0x88, 0x6b, 0x32, 0x9a, 0x9f, 0x2b, 0xf0, 0xfe, 0x21, 0x0d, 0x79, 0x40, 0x35, 0xfb,
	0x2b, 0xfe, 0x87, 0xbf, 0xf1, 0x7f, 0xff, 0x0e, 0xfe, 0x2f, 0x08, 0xf9, 0x87, 0xd6, 0xbf, 0x84,
	0x1b, 0x57, 0x62, 0x8c, 0xeb, 0x57, 0xb6, 0x82, 0x5b, 0x6d, 0x7d, 0x0a, 0x1f, 0xf4, 0x42, 0xa1,
	0x16, 0x37, 0x7b, 0xf9, 0xe0, 0x9a, 0x5d, 0x58, 0x9f, 0x47, 0x95, 0x67, 0x6e, 0x7f, 0xaa, 0xc2,
	0xcd, 0xfe, 0xdc, 0x35, 0x77, 0x8b, 0x63, 0x46, 0x0a, 0xfe, 0x3f, 0xeb, 0x09, 0xb5, 0xcb, 0x4f,
	0xc3, 0xde, 0x2d, 0x85, 0x31, 0xd2, 0x3f, 0x00, 0x58, 0x9b, 0x5b, 0x62, 0xb4, 0xf7, 0x87, 0x87,
	0x68, 0x77, 0xca, 0x03, 0x8d, 0x88, 0xf7, 0xf0, 0xde, 0x75, 0x5f, 0xd1, 0xb3, 0xbb, 0x54, 0xba,
	0x39, 0x3e, 0x7b, 0xaf, 0x34, 0xae, 0x10, 0xd0, 0xa5, 0xe3, 0x09, 0xb6, 0xce, 0x27, 0xd8, 0xba,
	0x98, 0x60, 0x70, 0x96, 0x61, 0xf0, 0x35, 0xc3, 0xe0, 0x5b, 0x86, 0xc1, 0x38, 0xc3, 0xe0, 0x7b,
	0x86, 0xc1, 0x8f, 0x0c, 0x5b, 0x17, 0x19, 0x06, 0x1f, 0xa7, 0xd8, 0x1a, 0x4f, 0xb1, 0x75, 0x3e,
	0xc5, 0xd6, 0xdb, 0x56, 0xc1, 0xc6, 0x85, 0x43, 0x63, 0xee, 0x2c, 0xf9, 0x7d, 0x9f, 0x01, 0xe0,
	0xad, 0xe4, 0xab, 0xbc, 0xfb, 0x33, 0x00, 0x00, 0xff, 0xff, 0x35, 0xb4, 0xbe, 0x68, 0xe7, 0x05,
	0x00, 0x00,
}

func (this *CreateSessionRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CreateSessionRequest)
	if !ok {
		that2, ok := that.(CreateSessionRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.AdapterConfig.Equal(that1.AdapterConfig) {
		return false
	}
	if len(this.InferredTypes) != len(that1.InferredTypes) {
		return false
	}
	for i := range this.InferredTypes {
		if !this.InferredTypes[i].Equal(that1.InferredTypes[i]) {
			return false
		}
	}
	return true
}
func (this *CreateSessionResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CreateSessionResponse)
	if !ok {
		that2, ok := that.(CreateSessionResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.SessionId != that1.SessionId {
		return false
	}
	if !this.Status.Equal(that1.Status) {
		return false
	}
	return true
}
func (this *ValidateRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ValidateRequest)
	if !ok {
		that2, ok := that.(ValidateRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.AdapterConfig.Equal(that1.AdapterConfig) {
		return false
	}
	if len(this.InferredTypes) != len(that1.InferredTypes) {
		return false
	}
	for i := range this.InferredTypes {
		if !this.InferredTypes[i].Equal(that1.InferredTypes[i]) {
			return false
		}
	}
	return true
}
func (this *ValidateResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ValidateResponse)
	if !ok {
		that2, ok := that.(ValidateResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Status.Equal(that1.Status) {
		return false
	}
	return true
}
func (this *CloseSessionRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CloseSessionRequest)
	if !ok {
		that2, ok := that.(CloseSessionRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.SessionId != that1.SessionId {
		return false
	}
	return true
}
func (this *CloseSessionResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CloseSessionResponse)
	if !ok {
		that2, ok := that.(CloseSessionResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Status.Equal(that1.Status) {
		return false
	}
	return true
}
func (this *CreateSessionRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&v1beta1.CreateSessionRequest{")
	if this.AdapterConfig != nil {
		s = append(s, "AdapterConfig: "+fmt.Sprintf("%#v", this.AdapterConfig)+",\n")
	}
	keysForInferredTypes := make([]string, 0, len(this.InferredTypes))
	for k, _ := range this.InferredTypes {
		keysForInferredTypes = append(keysForInferredTypes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForInferredTypes)
	mapStringForInferredTypes := "map[string]*types.Any{"
	for _, k := range keysForInferredTypes {
		mapStringForInferredTypes += fmt.Sprintf("%#v: %#v,", k, this.InferredTypes[k])
	}
	mapStringForInferredTypes += "}"
	if this.InferredTypes != nil {
		s = append(s, "InferredTypes: "+mapStringForInferredTypes+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CreateSessionResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&v1beta1.CreateSessionResponse{")
	s = append(s, "SessionId: "+fmt.Sprintf("%#v", this.SessionId)+",\n")
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ValidateRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&v1beta1.ValidateRequest{")
	if this.AdapterConfig != nil {
		s = append(s, "AdapterConfig: "+fmt.Sprintf("%#v", this.AdapterConfig)+",\n")
	}
	keysForInferredTypes := make([]string, 0, len(this.InferredTypes))
	for k, _ := range this.InferredTypes {
		keysForInferredTypes = append(keysForInferredTypes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForInferredTypes)
	mapStringForInferredTypes := "map[string]*types.Any{"
	for _, k := range keysForInferredTypes {
		mapStringForInferredTypes += fmt.Sprintf("%#v: %#v,", k, this.InferredTypes[k])
	}
	mapStringForInferredTypes += "}"
	if this.InferredTypes != nil {
		s = append(s, "InferredTypes: "+mapStringForInferredTypes+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ValidateResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&v1beta1.ValidateResponse{")
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CloseSessionRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&v1beta1.CloseSessionRequest{")
	s = append(s, "SessionId: "+fmt.Sprintf("%#v", this.SessionId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CloseSessionResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&v1beta1.CloseSessionResponse{")
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringInfrastructureBackend(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// InfrastructureBackendClient is the client API for InfrastructureBackend service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type InfrastructureBackendClient interface {
	// Validates the handler configuration along with the template-specific instances that would be routed to that
	// handler. The `CreateSession` for a specific handler configuration is invoked only if its associated `Validate`
	// call has returned success.
	Validate(ctx context.Context, in *ValidateRequest, opts ...grpc.CallOption) (*ValidateResponse, error)
	// Creates a session for a given handler configuration and the template-specific instances that would be routed to
	// that handler. For every handler configuration, Mixer creates a separate session by invoking `CreateSession`
	// on the backend.
	//
	// `CreateSessionRequest` contains the adapter specific handler configuration and the inferred type information about
	// the instances the handler would receive during request processing.
	//
	// `CreateSession` must return a `session_id` which Mixer uses to invoke template-specific Handle functions during
	// request processing. The `session_id` provides the Handle functions a way to retrieve the necessary configuration
	// associated with the session. Upon Mixer configuration change, Mixer will re-invoke `CreateSession` for all
	// handler configurations whose existing sessions are invalidated or didn't existed.
	//
	// Backend is allowed to return the same session id if given the same configuration block.
	// This would happen when multiple instances of Mixer in a deployment all create sessions with the same configuration.
	// Note that given individual instances of Mixer can call `CloseSession`, reusing `session_id` by the backend
	// assumes that the backend is doing reference counting.
	//
	// If the backend couldn't create a session for a specific handler configuration and
	// returns non S_OK status, Mixer will not make request-time Handle calls associated with that handler configuration.
	CreateSession(ctx context.Context, in *CreateSessionRequest, opts ...grpc.CallOption) (*CreateSessionResponse, error)
	// Closes the session associated with the `session_id`. Mixer closes a session when its associated handler
	// configuration or the instance configuration changes. Backend is supposed to cleanup all the resources associated
	// with the session_id referenced by CloseSessionRequest.
	CloseSession(ctx context.Context, in *CloseSessionRequest, opts ...grpc.CallOption) (*CloseSessionResponse, error)
}

type infrastructureBackendClient struct {
	cc *grpc.ClientConn
}

func NewInfrastructureBackendClient(cc *grpc.ClientConn) InfrastructureBackendClient {
	return &infrastructureBackendClient{cc}
}

func (c *infrastructureBackendClient) Validate(ctx context.Context, in *ValidateRequest, opts ...grpc.CallOption) (*ValidateResponse, error) {
	out := new(ValidateResponse)
	err := c.cc.Invoke(ctx, "/istio.mixer.adapter.model.v1beta1.InfrastructureBackend/Validate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *infrastructureBackendClient) CreateSession(ctx context.Context, in *CreateSessionRequest, opts ...grpc.CallOption) (*CreateSessionResponse, error) {
	out := new(CreateSessionResponse)
	err := c.cc.Invoke(ctx, "/istio.mixer.adapter.model.v1beta1.InfrastructureBackend/CreateSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *infrastructureBackendClient) CloseSession(ctx context.Context, in *CloseSessionRequest, opts ...grpc.CallOption) (*CloseSessionResponse, error) {
	out := new(CloseSessionResponse)
	err := c.cc.Invoke(ctx, "/istio.mixer.adapter.model.v1beta1.InfrastructureBackend/CloseSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InfrastructureBackendServer is the server API for InfrastructureBackend service.
type InfrastructureBackendServer interface {
	// Validates the handler configuration along with the template-specific instances that would be routed to that
	// handler. The `CreateSession` for a specific handler configuration is invoked only if its associated `Validate`
	// call has returned success.
	Validate(context.Context, *ValidateRequest) (*ValidateResponse, error)
	// Creates a session for a given handler configuration and the template-specific instances that would be routed to
	// that handler. For every handler configuration, Mixer creates a separate session by invoking `CreateSession`
	// on the backend.
	//
	// `CreateSessionRequest` contains the adapter specific handler configuration and the inferred type information about
	// the instances the handler would receive during request processing.
	//
	// `CreateSession` must return a `session_id` which Mixer uses to invoke template-specific Handle functions during
	// request processing. The `session_id` provides the Handle functions a way to retrieve the necessary configuration
	// associated with the session. Upon Mixer configuration change, Mixer will re-invoke `CreateSession` for all
	// handler configurations whose existing sessions are invalidated or didn't existed.
	//
	// Backend is allowed to return the same session id if given the same configuration block.
	// This would happen when multiple instances of Mixer in a deployment all create sessions with the same configuration.
	// Note that given individual instances of Mixer can call `CloseSession`, reusing `session_id` by the backend
	// assumes that the backend is doing reference counting.
	//
	// If the backend couldn't create a session for a specific handler configuration and
	// returns non S_OK status, Mixer will not make request-time Handle calls associated with that handler configuration.
	CreateSession(context.Context, *CreateSessionRequest) (*CreateSessionResponse, error)
	// Closes the session associated with the `session_id`. Mixer closes a session when its associated handler
	// configuration or the instance configuration changes. Backend is supposed to cleanup all the resources associated
	// with the session_id referenced by CloseSessionRequest.
	CloseSession(context.Context, *CloseSessionRequest) (*CloseSessionResponse, error)
}

func RegisterInfrastructureBackendServer(s *grpc.Server, srv InfrastructureBackendServer) {
	s.RegisterService(&_InfrastructureBackend_serviceDesc, srv)
}

func _InfrastructureBackend_Validate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InfrastructureBackendServer).Validate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/istio.mixer.adapter.model.v1beta1.InfrastructureBackend/Validate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InfrastructureBackendServer).Validate(ctx, req.(*ValidateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InfrastructureBackend_CreateSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InfrastructureBackendServer).CreateSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/istio.mixer.adapter.model.v1beta1.InfrastructureBackend/CreateSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InfrastructureBackendServer).CreateSession(ctx, req.(*CreateSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InfrastructureBackend_CloseSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloseSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InfrastructureBackendServer).CloseSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/istio.mixer.adapter.model.v1beta1.InfrastructureBackend/CloseSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InfrastructureBackendServer).CloseSession(ctx, req.(*CloseSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _InfrastructureBackend_serviceDesc = grpc.ServiceDesc{
	ServiceName: "istio.mixer.adapter.model.v1beta1.InfrastructureBackend",
	HandlerType: (*InfrastructureBackendServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Validate",
			Handler:    _InfrastructureBackend_Validate_Handler,
		},
		{
			MethodName: "CreateSession",
			Handler:    _InfrastructureBackend_CreateSession_Handler,
		},
		{
			MethodName: "CloseSession",
			Handler:    _InfrastructureBackend_CloseSession_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "mixer/adapter/model/v1beta1/infrastructure_backend.proto",
}

func (m *CreateSessionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CreateSessionRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.AdapterConfig != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintInfrastructureBackend(dAtA, i, uint64(m.AdapterConfig.Size()))
		n1, err := m.AdapterConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.InferredTypes) > 0 {
		for k, _ := range m.InferredTypes {
			dAtA[i] = 0x12
			i++
			v := m.InferredTypes[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovInfrastructureBackend(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovInfrastructureBackend(uint64(len(k))) + msgSize
			i = encodeVarintInfrastructureBackend(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintInfrastructureBackend(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintInfrastructureBackend(dAtA, i, uint64(v.Size()))
				n2, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n2
			}
		}
	}
	return i, nil
}

func (m *CreateSessionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CreateSessionResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SessionId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintInfrastructureBackend(dAtA, i, uint64(len(m.SessionId)))
		i += copy(dAtA[i:], m.SessionId)
	}
	if m.Status != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintInfrastructureBackend(dAtA, i, uint64(m.Status.Size()))
		n3, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}

func (m *ValidateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValidateRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.AdapterConfig != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintInfrastructureBackend(dAtA, i, uint64(m.AdapterConfig.Size()))
		n4, err := m.AdapterConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if len(m.InferredTypes) > 0 {
		for k, _ := range m.InferredTypes {
			dAtA[i] = 0x12
			i++
			v := m.InferredTypes[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovInfrastructureBackend(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovInfrastructureBackend(uint64(len(k))) + msgSize
			i = encodeVarintInfrastructureBackend(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintInfrastructureBackend(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintInfrastructureBackend(dAtA, i, uint64(v.Size()))
				n5, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n5
			}
		}
	}
	return i, nil
}

func (m *ValidateResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValidateResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Status != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintInfrastructureBackend(dAtA, i, uint64(m.Status.Size()))
		n6, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}

func (m *CloseSessionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CloseSessionRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SessionId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintInfrastructureBackend(dAtA, i, uint64(len(m.SessionId)))
		i += copy(dAtA[i:], m.SessionId)
	}
	return i, nil
}

func (m *CloseSessionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CloseSessionResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Status != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintInfrastructureBackend(dAtA, i, uint64(m.Status.Size()))
		n7, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}

func encodeVarintInfrastructureBackend(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *CreateSessionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AdapterConfig != nil {
		l = m.AdapterConfig.Size()
		n += 1 + l + sovInfrastructureBackend(uint64(l))
	}
	if len(m.InferredTypes) > 0 {
		for k, v := range m.InferredTypes {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovInfrastructureBackend(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovInfrastructureBackend(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovInfrastructureBackend(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *CreateSessionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SessionId)
	if l > 0 {
		n += 1 + l + sovInfrastructureBackend(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovInfrastructureBackend(uint64(l))
	}
	return n
}

func (m *ValidateRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AdapterConfig != nil {
		l = m.AdapterConfig.Size()
		n += 1 + l + sovInfrastructureBackend(uint64(l))
	}
	if len(m.InferredTypes) > 0 {
		for k, v := range m.InferredTypes {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovInfrastructureBackend(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovInfrastructureBackend(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovInfrastructureBackend(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *ValidateResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovInfrastructureBackend(uint64(l))
	}
	return n
}

func (m *CloseSessionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SessionId)
	if l > 0 {
		n += 1 + l + sovInfrastructureBackend(uint64(l))
	}
	return n
}

func (m *CloseSessionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovInfrastructureBackend(uint64(l))
	}
	return n
}

func sovInfrastructureBackend(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozInfrastructureBackend(x uint64) (n int) {
	return sovInfrastructureBackend(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *CreateSessionRequest) String() string {
	if this == nil {
		return "nil"
	}
	keysForInferredTypes := make([]string, 0, len(this.InferredTypes))
	for k, _ := range this.InferredTypes {
		keysForInferredTypes = append(keysForInferredTypes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForInferredTypes)
	mapStringForInferredTypes := "map[string]*types.Any{"
	for _, k := range keysForInferredTypes {
		mapStringForInferredTypes += fmt.Sprintf("%v: %v,", k, this.InferredTypes[k])
	}
	mapStringForInferredTypes += "}"
	s := strings.Join([]string{`&CreateSessionRequest{`,
		`AdapterConfig:` + strings.Replace(fmt.Sprintf("%v", this.AdapterConfig), "Any", "types.Any", 1) + `,`,
		`InferredTypes:` + mapStringForInferredTypes + `,`,
		`}`,
	}, "")
	return s
}
func (this *CreateSessionResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CreateSessionResponse{`,
		`SessionId:` + fmt.Sprintf("%v", this.SessionId) + `,`,
		`Status:` + strings.Replace(fmt.Sprintf("%v", this.Status), "Status", "rpc.Status", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ValidateRequest) String() string {
	if this == nil {
		return "nil"
	}
	keysForInferredTypes := make([]string, 0, len(this.InferredTypes))
	for k, _ := range this.InferredTypes {
		keysForInferredTypes = append(keysForInferredTypes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForInferredTypes)
	mapStringForInferredTypes := "map[string]*types.Any{"
	for _, k := range keysForInferredTypes {
		mapStringForInferredTypes += fmt.Sprintf("%v: %v,", k, this.InferredTypes[k])
	}
	mapStringForInferredTypes += "}"
	s := strings.Join([]string{`&ValidateRequest{`,
		`AdapterConfig:` + strings.Replace(fmt.Sprintf("%v", this.AdapterConfig), "Any", "types.Any", 1) + `,`,
		`InferredTypes:` + mapStringForInferredTypes + `,`,
		`}`,
	}, "")
	return s
}
func (this *ValidateResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ValidateResponse{`,
		`Status:` + strings.Replace(fmt.Sprintf("%v", this.Status), "Status", "rpc.Status", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CloseSessionRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CloseSessionRequest{`,
		`SessionId:` + fmt.Sprintf("%v", this.SessionId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CloseSessionResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CloseSessionResponse{`,
		`Status:` + strings.Replace(fmt.Sprintf("%v", this.Status), "Status", "rpc.Status", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringInfrastructureBackend(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *CreateSessionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowInfrastructureBackend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateSessionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateSessionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdapterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowInfrastructureBackend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdapterConfig == nil {
				m.AdapterConfig = &types.Any{}
			}
			if err := m.AdapterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InferredTypes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowInfrastructureBackend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InferredTypes == nil {
				m.InferredTypes = make(map[string]*types.Any)
			}
			var mapkey string
			var mapvalue *types.Any
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowInfrastructureBackend
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowInfrastructureBackend
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthInfrastructureBackend
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthInfrastructureBackend
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowInfrastructureBackend
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthInfrastructureBackend
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthInfrastructureBackend
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &types.Any{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipInfrastructureBackend(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthInfrastructureBackend
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.InferredTypes[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipInfrastructureBackend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreateSessionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowInfrastructureBackend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateSessionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateSessionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowInfrastructureBackend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowInfrastructureBackend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &rpc.Status{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipInfrastructureBackend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValidateRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowInfrastructureBackend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValidateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValidateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdapterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowInfrastructureBackend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdapterConfig == nil {
				m.AdapterConfig = &types.Any{}
			}
			if err := m.AdapterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InferredTypes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowInfrastructureBackend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InferredTypes == nil {
				m.InferredTypes = make(map[string]*types.Any)
			}
			var mapkey string
			var mapvalue *types.Any
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowInfrastructureBackend
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowInfrastructureBackend
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthInfrastructureBackend
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthInfrastructureBackend
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowInfrastructureBackend
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthInfrastructureBackend
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthInfrastructureBackend
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &types.Any{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipInfrastructureBackend(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthInfrastructureBackend
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.InferredTypes[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipInfrastructureBackend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValidateResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowInfrastructureBackend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValidateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValidateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowInfrastructureBackend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &rpc.Status{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipInfrastructureBackend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CloseSessionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowInfrastructureBackend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CloseSessionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CloseSessionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowInfrastructureBackend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipInfrastructureBackend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CloseSessionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowInfrastructureBackend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CloseSessionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CloseSessionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowInfrastructureBackend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &rpc.Status{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipInfrastructureBackend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthInfrastructureBackend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipInfrastructureBackend(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowInfrastructureBackend
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowInfrastructureBackend
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowInfrastructureBackend
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthInfrastructureBackend
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthInfrastructureBackend
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowInfrastructureBackend
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipInfrastructureBackend(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthInfrastructureBackend
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthInfrastructureBackend = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowInfrastructureBackend   = fmt.Errorf("proto: integer overflow")
)
