/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha1 "knative.dev/eventing-kafka/pkg/apis/sources/v1alpha1"
)

// FakeKafkaSources implements KafkaSourceInterface
type FakeKafkaSources struct {
	Fake *FakeSourcesV1alpha1
	ns   string
}

var kafkasourcesResource = schema.GroupVersionResource{Group: "sources.knative.dev", Version: "v1alpha1", Resource: "kafkasources"}

var kafkasourcesKind = schema.GroupVersionKind{Group: "sources.knative.dev", Version: "v1alpha1", Kind: "KafkaSource"}

// Get takes name of the kafkaSource, and returns the corresponding kafkaSource object, and an error if there is any.
func (c *FakeKafkaSources) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.KafkaSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(kafkasourcesResource, c.ns, name), &v1alpha1.KafkaSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.KafkaSource), err
}

// List takes label and field selectors, and returns the list of KafkaSources that match those selectors.
func (c *FakeKafkaSources) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.KafkaSourceList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(kafkasourcesResource, kafkasourcesKind, c.ns, opts), &v1alpha1.KafkaSourceList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.KafkaSourceList{ListMeta: obj.(*v1alpha1.KafkaSourceList).ListMeta}
	for _, item := range obj.(*v1alpha1.KafkaSourceList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested kafkaSources.
func (c *FakeKafkaSources) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(kafkasourcesResource, c.ns, opts))

}

// Create takes the representation of a kafkaSource and creates it.  Returns the server's representation of the kafkaSource, and an error, if there is any.
func (c *FakeKafkaSources) Create(ctx context.Context, kafkaSource *v1alpha1.KafkaSource, opts v1.CreateOptions) (result *v1alpha1.KafkaSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(kafkasourcesResource, c.ns, kafkaSource), &v1alpha1.KafkaSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.KafkaSource), err
}

// Update takes the representation of a kafkaSource and updates it. Returns the server's representation of the kafkaSource, and an error, if there is any.
func (c *FakeKafkaSources) Update(ctx context.Context, kafkaSource *v1alpha1.KafkaSource, opts v1.UpdateOptions) (result *v1alpha1.KafkaSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(kafkasourcesResource, c.ns, kafkaSource), &v1alpha1.KafkaSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.KafkaSource), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeKafkaSources) UpdateStatus(ctx context.Context, kafkaSource *v1alpha1.KafkaSource, opts v1.UpdateOptions) (*v1alpha1.KafkaSource, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(kafkasourcesResource, "status", c.ns, kafkaSource), &v1alpha1.KafkaSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.KafkaSource), err
}

// Delete takes name of the kafkaSource and deletes it. Returns an error if one occurs.
func (c *FakeKafkaSources) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(kafkasourcesResource, c.ns, name), &v1alpha1.KafkaSource{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeKafkaSources) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(kafkasourcesResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.KafkaSourceList{})
	return err
}

// Patch applies the patch and returns the patched kafkaSource.
func (c *FakeKafkaSources) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.KafkaSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(kafkasourcesResource, c.ns, name, pt, data, subresources...), &v1alpha1.KafkaSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.KafkaSource), err
}
