# Test serverless-operator with secure traffic

To test service mesh operator and setup secure traffic, run `make install-full-mesh`

```
make install-full-mesh
```

This command deploys resources in [mesh_resources directory](../hack/lib/mesh_resources/).

```
$ oc get -f hack/lib/mesh_resources/
NAME                        STATUS   AGE
namespace/knative-serving   Active   135m

NAME                                                  AGE
gateway.networking.istio.io/knative-ingress-gateway   135m
gateway.networking.istio.io/knative-local-gateway     135m

NAME                            TYPE        CLUSTER-IP      EXTERNAL-IP   PORT(S)   AGE
service/knative-local-gateway   ClusterIP   172.30.73.137   <none>        80/TCP    135m

NAME                                           AGE
peerauthentication.security.istio.io/default   137m

NAME                                       READY   STATUS            PROFILES      VERSION   AGE
servicemeshcontrolplane.maistra.io/basic   9/9     ComponentsReady   ["default"]   2.0.4     137m

NAME                                       READY   STATUS           AGE
servicemeshmemberroll.maistra.io/default   2/4     ReconcileError   135m

NAME                                                    PACKAGE               SOURCE             CHANNEL
subscription.operators.coreos.com/jaeger-product        jaeger-product        redhat-operators   stable
subscription.operators.coreos.com/kiali-ossm            kiali-ossm            redhat-operators   stable
subscription.operators.coreos.com/servicemeshoperator   servicemeshoperator   redhat-operators   stable
```

In addition to that, the secret `wildcard-certs` in istio-system is generated by script.

```
$ oc get secret -n istio-system wildcard-certs
NAME             TYPE                DATA   AGE
wildcard-certs   kubernetes.io/tls   2      133m
```

Once all resources are deployed you can test secure traffic.

First, make sure that your namespace is in `ServiceMeshMemberRoll`.

```
apiVersion: maistra.io/v1
kind: ServiceMeshMemberRoll
metadata:
  name: default
  namespace: istio-system
spec:
  members:
    - knative-serving
    - serving-tests
    - serving-tests-alt
    - $NAMESPACE_YOU_WANT_TO_ADD
    # Add namespace you want to include mesh. `serving-tests` and `serving-tests-alt` are added by default for e2e test. You can drop them if you like.
```

Then, create or update KnativeServing with the following options.

```shell
cat <<EOF | oc apply -f -
apiVersion: operator.knative.dev/v1alpha1
kind: KnativeServing
metadata:
  name: knative-serving
  namespace: knative-serving
spec:
  ingress:
    istio:
      enabled: true
  deployments:
  - name: activator
    annotations:
      "sidecar.istio.io/inject": "true"
      "sidecar.istio.io/rewriteAppHTTPProbers": "true"
  - name: autoscaler
    annotations:
      "sidecar.istio.io/inject": "true"
      "sidecar.istio.io/rewriteAppHTTPProbers": "true"
EOF
```

Then, create KnativeuService with `sidecar.istio.io/inject: "true"`, `sidecar.istio.io/rewriteAppHTTPProbers: "true"` and `serving.knative.openshift.io/enablePassthrough: "true"` annotations in your namespace,
which is one of the namespaces in the `ServiceMeshMemberRoll`.

```sh
cat <<EOF | oc apply -f -
apiVersion: serving.knative.dev/v1
kind: Service
metadata:
  name: hello-example
  namespace: $NAMESPACE_YOU_WANT_TO_ADD
  annotations:
    serving.knative.openshift.io/enablePassthrough: "true"
spec:
  template:
    metadata:
      name: hello-example-1
      annotations:
        sidecar.istio.io/inject: "true"
        sidecar.istio.io/rewriteAppHTTPProbers: "true"
    spec:
      containers:
      - image: gcr.io/knative-samples/helloworld-go
        name: user-container
EOF
```

And now, we can hit it with the certificate in /tmp/certs-XXX:

```
$ curl --cacert /tmp/certs-ftk/root.crt https://${YOUR_KSVC_URL}
Hello World!
```

To uninstall service mesh operator, run `make uninstall-mesh`.

```
make uninstall-full-mesh
```
