// Copyright 2021 The OpenZipkin Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package model

import (
	"encoding/json"
	"testing"
)

func TestAnnotationNegativeTimestamp(t *testing.T) {
	var (
		span SpanModel
		b1   = []byte(`{"annotations":[{"timestamp":-1}]}`)
		b2   = []byte(`{"annotations":[{"timestamp":0}]}`)
	)

	if err := json.Unmarshal(b1, &span); err == nil {
		t.Errorf("Unmarshal should have failed with error, have: %+v", span)
	}

	if err := json.Unmarshal(b2, &span); err == nil {
		t.Errorf("Unmarshal should have failed with error, have: %+v", span)
	}
}
