package reservations

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/reservations/mgmt/2017-11-01/reservations"

// AppliedScopeType enumerates the values for applied scope type.
type AppliedScopeType string

const (
	// Shared ...
	Shared AppliedScopeType = "Shared"
	// Single ...
	Single AppliedScopeType = "Single"
)

// PossibleAppliedScopeTypeValues returns an array of possible values for the AppliedScopeType const type.
func PossibleAppliedScopeTypeValues() []AppliedScopeType {
	return []AppliedScopeType{Shared, Single}
}

// AppliedScopeType1 enumerates the values for applied scope type 1.
type AppliedScopeType1 string

const (
	// AppliedScopeType1Shared ...
	AppliedScopeType1Shared AppliedScopeType1 = "Shared"
	// AppliedScopeType1Single ...
	AppliedScopeType1Single AppliedScopeType1 = "Single"
)

// PossibleAppliedScopeType1Values returns an array of possible values for the AppliedScopeType1 const type.
func PossibleAppliedScopeType1Values() []AppliedScopeType1 {
	return []AppliedScopeType1{AppliedScopeType1Shared, AppliedScopeType1Single}
}

// Code enumerates the values for code.
type Code string

const (
	// ActivateQuoteFailed ...
	ActivateQuoteFailed Code = "ActivateQuoteFailed"
	// AppliedScopesNotAssociatedWithCommerceAccount ...
	AppliedScopesNotAssociatedWithCommerceAccount Code = "AppliedScopesNotAssociatedWithCommerceAccount"
	// AppliedScopesSameAsExisting ...
	AppliedScopesSameAsExisting Code = "AppliedScopesSameAsExisting"
	// AuthorizationFailed ...
	AuthorizationFailed Code = "AuthorizationFailed"
	// BadRequest ...
	BadRequest Code = "BadRequest"
	// BillingCustomerInputError ...
	BillingCustomerInputError Code = "BillingCustomerInputError"
	// BillingError ...
	BillingError Code = "BillingError"
	// BillingPaymentInstrumentHardError ...
	BillingPaymentInstrumentHardError Code = "BillingPaymentInstrumentHardError"
	// BillingPaymentInstrumentSoftError ...
	BillingPaymentInstrumentSoftError Code = "BillingPaymentInstrumentSoftError"
	// BillingScopeIDCannotBeChanged ...
	BillingScopeIDCannotBeChanged Code = "BillingScopeIdCannotBeChanged"
	// BillingTransientError ...
	BillingTransientError Code = "BillingTransientError"
	// CalculatePriceFailed ...
	CalculatePriceFailed Code = "CalculatePriceFailed"
	// CapacityUpdateScopesFailed ...
	CapacityUpdateScopesFailed Code = "CapacityUpdateScopesFailed"
	// ClientCertificateThumbprintNotSet ...
	ClientCertificateThumbprintNotSet Code = "ClientCertificateThumbprintNotSet"
	// CreateQuoteFailed ...
	CreateQuoteFailed Code = "CreateQuoteFailed"
	// Forbidden ...
	Forbidden Code = "Forbidden"
	// FulfillmentConfigurationError ...
	FulfillmentConfigurationError Code = "FulfillmentConfigurationError"
	// FulfillmentError ...
	FulfillmentError Code = "FulfillmentError"
	// FulfillmentOutOfStockError ...
	FulfillmentOutOfStockError Code = "FulfillmentOutOfStockError"
	// FulfillmentTransientError ...
	FulfillmentTransientError Code = "FulfillmentTransientError"
	// HTTPMethodNotSupported ...
	HTTPMethodNotSupported Code = "HttpMethodNotSupported"
	// InternalServerError ...
	InternalServerError Code = "InternalServerError"
	// InvalidAccessToken ...
	InvalidAccessToken Code = "InvalidAccessToken"
	// InvalidFulfillmentRequestParameters ...
	InvalidFulfillmentRequestParameters Code = "InvalidFulfillmentRequestParameters"
	// InvalidHealthCheckType ...
	InvalidHealthCheckType Code = "InvalidHealthCheckType"
	// InvalidLocationID ...
	InvalidLocationID Code = "InvalidLocationId"
	// InvalidRefundQuantity ...
	InvalidRefundQuantity Code = "InvalidRefundQuantity"
	// InvalidRequestContent ...
	InvalidRequestContent Code = "InvalidRequestContent"
	// InvalidRequestURI ...
	InvalidRequestURI Code = "InvalidRequestUri"
	// InvalidReservationID ...
	InvalidReservationID Code = "InvalidReservationId"
	// InvalidReservationOrderID ...
	InvalidReservationOrderID Code = "InvalidReservationOrderId"
	// InvalidSingleAppliedScopesCount ...
	InvalidSingleAppliedScopesCount Code = "InvalidSingleAppliedScopesCount"
	// InvalidSubscriptionID ...
	InvalidSubscriptionID Code = "InvalidSubscriptionId"
	// InvalidTenantID ...
	InvalidTenantID Code = "InvalidTenantId"
	// MissingAppliedScopesForSingle ...
	MissingAppliedScopesForSingle Code = "MissingAppliedScopesForSingle"
	// MissingTenantID ...
	MissingTenantID Code = "MissingTenantId"
	// NonsupportedAccountID ...
	NonsupportedAccountID Code = "NonsupportedAccountId"
	// NotSpecified ...
	NotSpecified Code = "NotSpecified"
	// NotSupportedCountry ...
	NotSupportedCountry Code = "NotSupportedCountry"
	// NoValidReservationsToReRate ...
	NoValidReservationsToReRate Code = "NoValidReservationsToReRate"
	// OperationCannotBePerformedInCurrentState ...
	OperationCannotBePerformedInCurrentState Code = "OperationCannotBePerformedInCurrentState"
	// OperationFailed ...
	OperationFailed Code = "OperationFailed"
	// PaymentInstrumentNotFound ...
	PaymentInstrumentNotFound Code = "PaymentInstrumentNotFound"
	// PurchaseError ...
	PurchaseError Code = "PurchaseError"
	// ReRateOnlyAllowedForEA ...
	ReRateOnlyAllowedForEA Code = "ReRateOnlyAllowedForEA"
	// ReservationIDNotInReservationOrder ...
	ReservationIDNotInReservationOrder Code = "ReservationIdNotInReservationOrder"
	// ReservationOrderCreationFailed ...
	ReservationOrderCreationFailed Code = "ReservationOrderCreationFailed"
	// ReservationOrderIDAlreadyExists ...
	ReservationOrderIDAlreadyExists Code = "ReservationOrderIdAlreadyExists"
	// ReservationOrderNotEnabled ...
	ReservationOrderNotEnabled Code = "ReservationOrderNotEnabled"
	// ReservationOrderNotFound ...
	ReservationOrderNotFound Code = "ReservationOrderNotFound"
	// RiskCheckFailed ...
	RiskCheckFailed Code = "RiskCheckFailed"
	// RoleAssignmentCreationFailed ...
	RoleAssignmentCreationFailed Code = "RoleAssignmentCreationFailed"
	// ServerTimeout ...
	ServerTimeout Code = "ServerTimeout"
	// UnauthenticatedRequestsThrottled ...
	UnauthenticatedRequestsThrottled Code = "UnauthenticatedRequestsThrottled"
	// UnsupportedReservationTerm ...
	UnsupportedReservationTerm Code = "UnsupportedReservationTerm"
)

// PossibleCodeValues returns an array of possible values for the Code const type.
func PossibleCodeValues() []Code {
	return []Code{ActivateQuoteFailed, AppliedScopesNotAssociatedWithCommerceAccount, AppliedScopesSameAsExisting, AuthorizationFailed, BadRequest, BillingCustomerInputError, BillingError, BillingPaymentInstrumentHardError, BillingPaymentInstrumentSoftError, BillingScopeIDCannotBeChanged, BillingTransientError, CalculatePriceFailed, CapacityUpdateScopesFailed, ClientCertificateThumbprintNotSet, CreateQuoteFailed, Forbidden, FulfillmentConfigurationError, FulfillmentError, FulfillmentOutOfStockError, FulfillmentTransientError, HTTPMethodNotSupported, InternalServerError, InvalidAccessToken, InvalidFulfillmentRequestParameters, InvalidHealthCheckType, InvalidLocationID, InvalidRefundQuantity, InvalidRequestContent, InvalidRequestURI, InvalidReservationID, InvalidReservationOrderID, InvalidSingleAppliedScopesCount, InvalidSubscriptionID, InvalidTenantID, MissingAppliedScopesForSingle, MissingTenantID, NonsupportedAccountID, NotSpecified, NotSupportedCountry, NoValidReservationsToReRate, OperationCannotBePerformedInCurrentState, OperationFailed, PaymentInstrumentNotFound, PurchaseError, ReRateOnlyAllowedForEA, ReservationIDNotInReservationOrder, ReservationOrderCreationFailed, ReservationOrderIDAlreadyExists, ReservationOrderNotEnabled, ReservationOrderNotFound, RiskCheckFailed, RoleAssignmentCreationFailed, ServerTimeout, UnauthenticatedRequestsThrottled, UnsupportedReservationTerm}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// MicrosoftCompute ...
	MicrosoftCompute Kind = "Microsoft.Compute"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{MicrosoftCompute}
}

// Location enumerates the values for location.
type Location string

const (
	// Australiaeast ...
	Australiaeast Location = "australiaeast"
	// Australiasoutheast ...
	Australiasoutheast Location = "australiasoutheast"
	// Brazilsouth ...
	Brazilsouth Location = "brazilsouth"
	// Canadacentral ...
	Canadacentral Location = "canadacentral"
	// Canadaeast ...
	Canadaeast Location = "canadaeast"
	// Centralindia ...
	Centralindia Location = "centralindia"
	// Centralus ...
	Centralus Location = "centralus"
	// Eastasia ...
	Eastasia Location = "eastasia"
	// Eastus ...
	Eastus Location = "eastus"
	// Eastus2 ...
	Eastus2 Location = "eastus2"
	// Japaneast ...
	Japaneast Location = "japaneast"
	// Japanwest ...
	Japanwest Location = "japanwest"
	// Northcentralus ...
	Northcentralus Location = "northcentralus"
	// Northeurope ...
	Northeurope Location = "northeurope"
	// Southcentralus ...
	Southcentralus Location = "southcentralus"
	// Southeastasia ...
	Southeastasia Location = "southeastasia"
	// Southindia ...
	Southindia Location = "southindia"
	// Uksouth ...
	Uksouth Location = "uksouth"
	// Ukwest ...
	Ukwest Location = "ukwest"
	// Westcentralus ...
	Westcentralus Location = "westcentralus"
	// Westeurope ...
	Westeurope Location = "westeurope"
	// Westindia ...
	Westindia Location = "westindia"
	// Westus ...
	Westus Location = "westus"
	// Westus2 ...
	Westus2 Location = "westus2"
)

// PossibleLocationValues returns an array of possible values for the Location const type.
func PossibleLocationValues() []Location {
	return []Location{Australiaeast, Australiasoutheast, Brazilsouth, Canadacentral, Canadaeast, Centralindia, Centralus, Eastasia, Eastus, Eastus2, Japaneast, Japanwest, Northcentralus, Northeurope, Southcentralus, Southeastasia, Southindia, Uksouth, Ukwest, Westcentralus, Westeurope, Westindia, Westus, Westus2}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// BillingFailed ...
	BillingFailed ProvisioningState = "BillingFailed"
	// Cancelled ...
	Cancelled ProvisioningState = "Cancelled"
	// ConfirmedBilling ...
	ConfirmedBilling ProvisioningState = "ConfirmedBilling"
	// ConfirmedResourceHold ...
	ConfirmedResourceHold ProvisioningState = "ConfirmedResourceHold"
	// Created ...
	Created ProvisioningState = "Created"
	// Creating ...
	Creating ProvisioningState = "Creating"
	// Expired ...
	Expired ProvisioningState = "Expired"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Merged ...
	Merged ProvisioningState = "Merged"
	// PendingBilling ...
	PendingBilling ProvisioningState = "PendingBilling"
	// PendingResourceHold ...
	PendingResourceHold ProvisioningState = "PendingResourceHold"
	// Split ...
	Split ProvisioningState = "Split"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{BillingFailed, Cancelled, ConfirmedBilling, ConfirmedResourceHold, Created, Creating, Expired, Failed, Merged, PendingBilling, PendingResourceHold, Split, Succeeded}
}

// ProvisioningState1 enumerates the values for provisioning state 1.
type ProvisioningState1 string

const (
	// ProvisioningState1BillingFailed ...
	ProvisioningState1BillingFailed ProvisioningState1 = "BillingFailed"
	// ProvisioningState1Cancelled ...
	ProvisioningState1Cancelled ProvisioningState1 = "Cancelled"
	// ProvisioningState1ConfirmedBilling ...
	ProvisioningState1ConfirmedBilling ProvisioningState1 = "ConfirmedBilling"
	// ProvisioningState1ConfirmedResourceHold ...
	ProvisioningState1ConfirmedResourceHold ProvisioningState1 = "ConfirmedResourceHold"
	// ProvisioningState1Created ...
	ProvisioningState1Created ProvisioningState1 = "Created"
	// ProvisioningState1Creating ...
	ProvisioningState1Creating ProvisioningState1 = "Creating"
	// ProvisioningState1Expired ...
	ProvisioningState1Expired ProvisioningState1 = "Expired"
	// ProvisioningState1Failed ...
	ProvisioningState1Failed ProvisioningState1 = "Failed"
	// ProvisioningState1Merged ...
	ProvisioningState1Merged ProvisioningState1 = "Merged"
	// ProvisioningState1PendingBilling ...
	ProvisioningState1PendingBilling ProvisioningState1 = "PendingBilling"
	// ProvisioningState1PendingResourceHold ...
	ProvisioningState1PendingResourceHold ProvisioningState1 = "PendingResourceHold"
	// ProvisioningState1Split ...
	ProvisioningState1Split ProvisioningState1 = "Split"
	// ProvisioningState1Succeeded ...
	ProvisioningState1Succeeded ProvisioningState1 = "Succeeded"
)

// PossibleProvisioningState1Values returns an array of possible values for the ProvisioningState1 const type.
func PossibleProvisioningState1Values() []ProvisioningState1 {
	return []ProvisioningState1{ProvisioningState1BillingFailed, ProvisioningState1Cancelled, ProvisioningState1ConfirmedBilling, ProvisioningState1ConfirmedResourceHold, ProvisioningState1Created, ProvisioningState1Creating, ProvisioningState1Expired, ProvisioningState1Failed, ProvisioningState1Merged, ProvisioningState1PendingBilling, ProvisioningState1PendingResourceHold, ProvisioningState1Split, ProvisioningState1Succeeded}
}

// StatusCode enumerates the values for status code.
type StatusCode string

const (
	// StatusCodeActive ...
	StatusCodeActive StatusCode = "Active"
	// StatusCodeExpired ...
	StatusCodeExpired StatusCode = "Expired"
	// StatusCodeMerged ...
	StatusCodeMerged StatusCode = "Merged"
	// StatusCodeNone ...
	StatusCodeNone StatusCode = "None"
	// StatusCodePaymentInstrumentError ...
	StatusCodePaymentInstrumentError StatusCode = "PaymentInstrumentError"
	// StatusCodePending ...
	StatusCodePending StatusCode = "Pending"
	// StatusCodePurchaseError ...
	StatusCodePurchaseError StatusCode = "PurchaseError"
	// StatusCodeSplit ...
	StatusCodeSplit StatusCode = "Split"
	// StatusCodeSucceeded ...
	StatusCodeSucceeded StatusCode = "Succeeded"
)

// PossibleStatusCodeValues returns an array of possible values for the StatusCode const type.
func PossibleStatusCodeValues() []StatusCode {
	return []StatusCode{StatusCodeActive, StatusCodeExpired, StatusCodeMerged, StatusCodeNone, StatusCodePaymentInstrumentError, StatusCodePending, StatusCodePurchaseError, StatusCodeSplit, StatusCodeSucceeded}
}

// Term enumerates the values for term.
type Term string

const (
	// P1Y ...
	P1Y Term = "P1Y"
	// P3Y ...
	P3Y Term = "P3Y"
)

// PossibleTermValues returns an array of possible values for the Term const type.
func PossibleTermValues() []Term {
	return []Term{P1Y, P3Y}
}

// AppliedReservationList ...
type AppliedReservationList struct {
	Value *[]string `json:"value,omitempty"`
	// NextLink - Url to get the next page of reservations
	NextLink *string `json:"nextLink,omitempty"`
}

// AppliedReservations ...
type AppliedReservations struct {
	autorest.Response `json:"-"`
	// ID - Identifier of the applied reservations
	ID *string `json:"id,omitempty"`
	// Name - Name of resource
	Name *string `json:"name,omitempty"`
	// Type - Type of resource. "Microsoft.Capacity/AppliedReservations"
	Type                           *string `json:"type,omitempty"`
	*AppliedReservationsProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AppliedReservations.
func (ar AppliedReservations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.ID != nil {
		objectMap["id"] = ar.ID
	}
	if ar.Name != nil {
		objectMap["name"] = ar.Name
	}
	if ar.Type != nil {
		objectMap["type"] = ar.Type
	}
	if ar.AppliedReservationsProperties != nil {
		objectMap["properties"] = ar.AppliedReservationsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppliedReservations struct.
func (ar *AppliedReservations) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var appliedReservationsProperties AppliedReservationsProperties
				err = json.Unmarshal(*v, &appliedReservationsProperties)
				if err != nil {
					return err
				}
				ar.AppliedReservationsProperties = &appliedReservationsProperties
			}
		}
	}

	return nil
}

// AppliedReservationsProperties ...
type AppliedReservationsProperties struct {
	ReservationOrderIds *AppliedReservationList `json:"reservationOrderIds,omitempty"`
}

// Catalog ...
type Catalog struct {
	// ResourceType - The type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`
	// Name - The name of SKU
	Name *string `json:"name,omitempty"`
	// Tier - The tier of this SKU
	Tier *string `json:"tier,omitempty"`
	// Size - The size of this SKU
	Size *string `json:"size,omitempty"`
	// Terms - Available reservation terms for this resource
	Terms        *[]string         `json:"terms,omitempty"`
	Locations    *[]string         `json:"locations,omitempty"`
	Capabilities *[]SkuCapability  `json:"capabilities,omitempty"`
	Restrictions *[]SkuRestriction `json:"restrictions,omitempty"`
}

// Error ...
type Error struct {
	Error *ExtendedErrorInfo `json:"error,omitempty"`
}

// ExtendedErrorInfo ...
type ExtendedErrorInfo struct {
	// Code - Possible values include: 'NotSpecified', 'InternalServerError', 'ServerTimeout', 'AuthorizationFailed', 'BadRequest', 'ClientCertificateThumbprintNotSet', 'InvalidRequestContent', 'OperationFailed', 'HTTPMethodNotSupported', 'InvalidRequestURI', 'MissingTenantID', 'InvalidTenantID', 'InvalidReservationOrderID', 'InvalidReservationID', 'ReservationIDNotInReservationOrder', 'ReservationOrderNotFound', 'InvalidSubscriptionID', 'InvalidAccessToken', 'InvalidLocationID', 'UnauthenticatedRequestsThrottled', 'InvalidHealthCheckType', 'Forbidden', 'BillingScopeIDCannotBeChanged', 'AppliedScopesNotAssociatedWithCommerceAccount', 'AppliedScopesSameAsExisting', 'RoleAssignmentCreationFailed', 'ReservationOrderCreationFailed', 'ReservationOrderNotEnabled', 'CapacityUpdateScopesFailed', 'UnsupportedReservationTerm', 'ReservationOrderIDAlreadyExists', 'RiskCheckFailed', 'CreateQuoteFailed', 'ActivateQuoteFailed', 'NonsupportedAccountID', 'PaymentInstrumentNotFound', 'MissingAppliedScopesForSingle', 'NoValidReservationsToReRate', 'ReRateOnlyAllowedForEA', 'OperationCannotBePerformedInCurrentState', 'InvalidSingleAppliedScopesCount', 'InvalidFulfillmentRequestParameters', 'NotSupportedCountry', 'InvalidRefundQuantity', 'PurchaseError', 'BillingCustomerInputError', 'BillingPaymentInstrumentSoftError', 'BillingPaymentInstrumentHardError', 'BillingTransientError', 'BillingError', 'FulfillmentConfigurationError', 'FulfillmentOutOfStockError', 'FulfillmentTransientError', 'FulfillmentError', 'CalculatePriceFailed'
	Code    Code    `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// ExtendedStatusInfo ...
type ExtendedStatusInfo struct {
	// StatusCode - Possible values include: 'StatusCodeNone', 'StatusCodePending', 'StatusCodeActive', 'StatusCodePurchaseError', 'StatusCodePaymentInstrumentError', 'StatusCodeSplit', 'StatusCodeMerged', 'StatusCodeExpired', 'StatusCodeSucceeded'
	StatusCode StatusCode `json:"statusCode,omitempty"`
	// Message - The message giving detailed information about the status code.
	Message *string `json:"message,omitempty"`
}

// List ...
type List struct {
	autorest.Response `json:"-"`
	Value             *[]Response `json:"value,omitempty"`
	// NextLink - Url to get the next page of reservations.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListCatalog ...
type ListCatalog struct {
	autorest.Response `json:"-"`
	Value             *[]Catalog `json:"value,omitempty"`
}

// ListIterator provides access to a complete listing of Response values.
type ListIterator struct {
	i    int
	page ListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListIterator) Response() List {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListIterator) Value() Response {
	if !iter.page.NotDone() {
		return Response{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListIterator type.
func NewListIterator(page ListPage) ListIterator {
	return ListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (l List) IsEmpty() bool {
	return l.Value == nil || len(*l.Value) == 0
}

// listPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (l List) listPreparer(ctx context.Context) (*http.Request, error) {
	if l.NextLink == nil || len(to.String(l.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(l.NextLink)))
}

// ListPage contains a page of Response values.
type ListPage struct {
	fn func(context.Context, List) (List, error)
	l  List
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.l)
	if err != nil {
		return err
	}
	page.l = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListPage) NotDone() bool {
	return !page.l.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListPage) Response() List {
	return page.l
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListPage) Values() []Response {
	if page.l.IsEmpty() {
		return nil
	}
	return *page.l.Value
}

// Creates a new instance of the ListPage type.
func NewListPage(getNextPage func(context.Context, List) (List, error)) ListPage {
	return ListPage{fn: getNextPage}
}

// ListResponse ...
type ListResponse struct {
	autorest.Response `json:"-"`
	Value             *[]Response `json:"value,omitempty"`
}

// MergeProperties ...
type MergeProperties struct {
	// Sources - Format of the resource id should be /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	Sources *[]string `json:"sources,omitempty"`
}

// MergePropertiesType ...
type MergePropertiesType struct {
	// MergeDestination - Reservation Resource Id Created due to the merge. Format of the resource Id is /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	MergeDestination *string `json:"mergeDestination,omitempty"`
	// MergeSources - Resource Ids of the Source Reservation's merged to form this Reservation. Format of the resource Id is /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	MergeSources *[]string `json:"mergeSources,omitempty"`
}

// MergeRequest ...
type MergeRequest struct {
	*MergeProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MergeRequest.
func (mr MergeRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mr.MergeProperties != nil {
		objectMap["properties"] = mr.MergeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MergeRequest struct.
func (mr *MergeRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mergeProperties MergeProperties
				err = json.Unmarshal(*v, &mergeProperties)
				if err != nil {
					return err
				}
				mr.MergeProperties = &mergeProperties
			}
		}
	}

	return nil
}

// OperationDisplay ...
type OperationDisplay struct {
	Provider    *string `json:"provider,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Description *string `json:"description,omitempty"`
}

// OperationList ...
type OperationList struct {
	autorest.Response `json:"-"`
	Value             *[]OperationResponse `json:"value,omitempty"`
	// NextLink - Url to get the next page of items.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListIterator provides access to a complete listing of OperationResponse values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() OperationResponse {
	if !iter.page.NotDone() {
		return OperationResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if ol.NextLink == nil || len(to.String(ol.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of OperationResponse values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ol)
	if err != nil {
		return err
	}
	page.ol = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []OperationResponse {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{fn: getNextPage}
}

// OperationResponse ...
type OperationResponse struct {
	Name    *string           `json:"name,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
	Origin  *string           `json:"origin,omitempty"`
}

// OrderList ...
type OrderList struct {
	autorest.Response `json:"-"`
	Value             *[]OrderResponse `json:"value,omitempty"`
	// NextLink - Url to get the next page of reservationOrders.
	NextLink *string `json:"nextLink,omitempty"`
}

// OrderListIterator provides access to a complete listing of OrderResponse values.
type OrderListIterator struct {
	i    int
	page OrderListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OrderListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OrderListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OrderListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OrderListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OrderListIterator) Response() OrderList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OrderListIterator) Value() OrderResponse {
	if !iter.page.NotDone() {
		return OrderResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OrderListIterator type.
func NewOrderListIterator(page OrderListPage) OrderListIterator {
	return OrderListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OrderList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// orderListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OrderList) orderListPreparer(ctx context.Context) (*http.Request, error) {
	if ol.NextLink == nil || len(to.String(ol.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OrderListPage contains a page of OrderResponse values.
type OrderListPage struct {
	fn func(context.Context, OrderList) (OrderList, error)
	ol OrderList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OrderListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OrderListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ol)
	if err != nil {
		return err
	}
	page.ol = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OrderListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OrderListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OrderListPage) Response() OrderList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OrderListPage) Values() []OrderResponse {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OrderListPage type.
func NewOrderListPage(getNextPage func(context.Context, OrderList) (OrderList, error)) OrderListPage {
	return OrderListPage{fn: getNextPage}
}

// OrderProperties ...
type OrderProperties struct {
	// DisplayName - Friendly name for user to easily identified the reservation.
	DisplayName *string `json:"displayName,omitempty"`
	// RequestDateTime - This is the DateTime when the reservation was initially requested for purchase.
	RequestDateTime *date.Time `json:"requestDateTime,omitempty"`
	// CreatedDateTime - This is the DateTime when the reservation was created.
	CreatedDateTime *date.Time `json:"createdDateTime,omitempty"`
	// ExpiryDate - This is the date when the Reservation will expire.
	ExpiryDate *date.Date `json:"expiryDate,omitempty"`
	// OriginalQuantity - Total Quantity of the SKUs purchased in the Reservation.
	OriginalQuantity *int32 `json:"originalQuantity,omitempty"`
	// Term - Possible values include: 'P1Y', 'P3Y'
	Term Term `json:"term,omitempty"`
	// ProvisioningState - Possible values include: 'ProvisioningState1Creating', 'ProvisioningState1PendingResourceHold', 'ProvisioningState1ConfirmedResourceHold', 'ProvisioningState1PendingBilling', 'ProvisioningState1ConfirmedBilling', 'ProvisioningState1Created', 'ProvisioningState1Succeeded', 'ProvisioningState1Cancelled', 'ProvisioningState1Expired', 'ProvisioningState1BillingFailed', 'ProvisioningState1Failed', 'ProvisioningState1Split', 'ProvisioningState1Merged'
	ProvisioningState    ProvisioningState1 `json:"provisioningState,omitempty"`
	ReservationsProperty *[]Response        `json:"reservations,omitempty"`
}

// OrderResponse ...
type OrderResponse struct {
	autorest.Response `json:"-"`
	Etag              *int32 `json:"etag,omitempty"`
	// ID - Identifier of the reservation
	ID *string `json:"id,omitempty"`
	// Name - Name of the reservation
	Name             *string `json:"name,omitempty"`
	*OrderProperties `json:"properties,omitempty"`
	// Type - Type of resource. "Microsoft.Capacity/reservations"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for OrderResponse.
func (or OrderResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if or.Etag != nil {
		objectMap["etag"] = or.Etag
	}
	if or.ID != nil {
		objectMap["id"] = or.ID
	}
	if or.Name != nil {
		objectMap["name"] = or.Name
	}
	if or.OrderProperties != nil {
		objectMap["properties"] = or.OrderProperties
	}
	if or.Type != nil {
		objectMap["type"] = or.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OrderResponse struct.
func (or *OrderResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag int32
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				or.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				or.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				or.Name = &name
			}
		case "properties":
			if v != nil {
				var orderProperties OrderProperties
				err = json.Unmarshal(*v, &orderProperties)
				if err != nil {
					return err
				}
				or.OrderProperties = &orderProperties
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				or.Type = &typeVar
			}
		}
	}

	return nil
}

// Patch ...
type Patch struct {
	*PatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Patch.
func (p Patch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PatchProperties != nil {
		objectMap["properties"] = p.PatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Patch struct.
func (p *Patch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var patchProperties PatchProperties
				err = json.Unmarshal(*v, &patchProperties)
				if err != nil {
					return err
				}
				p.PatchProperties = &patchProperties
			}
		}
	}

	return nil
}

// PatchProperties ...
type PatchProperties struct {
	// AppliedScopeType - Possible values include: 'AppliedScopeType1Single', 'AppliedScopeType1Shared'
	AppliedScopeType AppliedScopeType1 `json:"appliedScopeType,omitempty"`
	AppliedScopes    *[]string         `json:"appliedScopes,omitempty"`
}

// Properties ...
type Properties struct {
	// DisplayName - Friendly name for user to easily identify the reservation
	DisplayName   *string   `json:"displayName,omitempty"`
	AppliedScopes *[]string `json:"appliedScopes,omitempty"`
	// AppliedScopeType - Possible values include: 'Single', 'Shared'
	AppliedScopeType AppliedScopeType `json:"appliedScopeType,omitempty"`
	// Quantity - Quantity of the SKUs that are part of the Reservation.
	Quantity *int32 `json:"quantity,omitempty"`
	// ProvisioningState - Possible values include: 'Creating', 'PendingResourceHold', 'ConfirmedResourceHold', 'PendingBilling', 'ConfirmedBilling', 'Created', 'Succeeded', 'Cancelled', 'Expired', 'BillingFailed', 'Failed', 'Split', 'Merged'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// EffectiveDateTime - DateTime of the Reservation starting when this version is effective from.
	EffectiveDateTime *date.Time `json:"effectiveDateTime,omitempty"`
	// LastUpdatedDateTime - DateTime of the last time the Reservation was updated.
	LastUpdatedDateTime *date.Time `json:"lastUpdatedDateTime,omitempty"`
	// ExpiryDate - This is the date when the Reservation will expire.
	ExpiryDate         *date.Date           `json:"expiryDate,omitempty"`
	ExtendedStatusInfo *ExtendedStatusInfo  `json:"extendedStatusInfo,omitempty"`
	SplitProperties    *SplitPropertiesType `json:"splitProperties,omitempty"`
	MergeProperties    *MergePropertiesType `json:"mergeProperties,omitempty"`
}

// ReservationMergeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReservationMergeFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReservationMergeFuture) Result(client Client) (lr ListResponse, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.ReservationMergeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("reservations.ReservationMergeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if lr.Response.Response, err = future.GetResult(sender); err == nil && lr.Response.Response.StatusCode != http.StatusNoContent {
		lr, err = client.MergeResponder(lr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "reservations.ReservationMergeFuture", "Result", lr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReservationUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReservationUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReservationUpdateFuture) Result(client Client) (r Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.ReservationUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("reservations.ReservationUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.UpdateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "reservations.ReservationUpdateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Response ...
type Response struct {
	autorest.Response `json:"-"`
	// Location - Possible values include: 'Westus', 'Eastus', 'Eastus2', 'Northcentralus', 'Westus2', 'Southcentralus', 'Centralus', 'Westeurope', 'Northeurope', 'Eastasia', 'Southeastasia', 'Japaneast', 'Japanwest', 'Brazilsouth', 'Australiaeast', 'Australiasoutheast', 'Southindia', 'Westindia', 'Centralindia', 'Canadacentral', 'Canadaeast', 'Uksouth', 'Westcentralus', 'Ukwest'
	Location Location `json:"location,omitempty"`
	Etag     *int32   `json:"etag,omitempty"`
	// ID - Identifier of the reservation
	ID *string `json:"id,omitempty"`
	// Name - Name of the reservation
	Name *string `json:"name,omitempty"`
	// Kind - Resource Provider type to be reserved. Possible values include: 'MicrosoftCompute'
	Kind       Kind        `json:"kind,omitempty"`
	Sku        *SkuName    `json:"sku,omitempty"`
	Properties *Properties `json:"properties,omitempty"`
	// Type - Type of resource. "Microsoft.Capacity/reservationOrders/reservations"
	Type *string `json:"type,omitempty"`
}

// SkuCapability ...
type SkuCapability struct {
	// Name - An invariant to describe the feature.
	Name *string `json:"name,omitempty"`
	// Value - An invariant if the feature is measured by quantity.
	Value *string `json:"value,omitempty"`
}

// SkuName ...
type SkuName struct {
	Name *string `json:"name,omitempty"`
}

// SkuRestriction ...
type SkuRestriction struct {
	// Type - The type of restrictions.
	Type *string `json:"type,omitempty"`
	// Values - The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted.
	Values *[]string `json:"values,omitempty"`
	// ReasonCode - The reason for restriction.
	ReasonCode *string `json:"reasonCode,omitempty"`
}

// SplitFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type SplitFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SplitFuture) Result(client Client) (lr ListResponse, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.SplitFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("reservations.SplitFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if lr.Response.Response, err = future.GetResult(sender); err == nil && lr.Response.Response.StatusCode != http.StatusNoContent {
		lr, err = client.SplitResponder(lr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "reservations.SplitFuture", "Result", lr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SplitProperties ...
type SplitProperties struct {
	// Quantities - List of the quantities in the new reservations to create.
	Quantities *[]int32 `json:"quantities,omitempty"`
	// ReservationID - Resource id of the reservation to be split. Format of the resource id should be /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	ReservationID *string `json:"reservationId,omitempty"`
}

// SplitPropertiesType ...
type SplitPropertiesType struct {
	// SplitDestinations - List of destination Resource Id that are created due to split. Format of the resource Id is /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	SplitDestinations *[]string `json:"splitDestinations,omitempty"`
	// SplitSource - Resource Id of the Reservation from which this is split. Format of the resource Id is /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	SplitSource *string `json:"splitSource,omitempty"`
}

// SplitRequest ...
type SplitRequest struct {
	*SplitProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SplitRequest.
func (sr SplitRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.SplitProperties != nil {
		objectMap["properties"] = sr.SplitProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SplitRequest struct.
func (sr *SplitRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var splitProperties SplitProperties
				err = json.Unmarshal(*v, &splitProperties)
				if err != nil {
					return err
				}
				sr.SplitProperties = &splitProperties
			}
		}
	}

	return nil
}
