package workloadmonitor

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/workloadmonitor/mgmt/2018-08-31-preview/workloadmonitor"

// AlertGeneration enumerates the values for alert generation.
type AlertGeneration string

const (
	// Disabled ...
	Disabled AlertGeneration = "Disabled"
	// Enabled ...
	Enabled AlertGeneration = "Enabled"
)

// PossibleAlertGenerationValues returns an array of possible values for the AlertGeneration const type.
func PossibleAlertGenerationValues() []AlertGeneration {
	return []AlertGeneration{Disabled, Enabled}
}

// HealthState enumerates the values for health state.
type HealthState string

const (
	// Error ...
	Error HealthState = "Error"
	// Success ...
	Success HealthState = "Success"
	// Uninitialized ...
	Uninitialized HealthState = "Uninitialized"
	// Unknown ...
	Unknown HealthState = "Unknown"
	// Warning ...
	Warning HealthState = "Warning"
)

// PossibleHealthStateValues returns an array of possible values for the HealthState const type.
func PossibleHealthStateValues() []HealthState {
	return []HealthState{Error, Success, Uninitialized, Unknown, Warning}
}

// HealthStateCategory enumerates the values for health state category.
type HealthStateCategory string

const (
	// CustomGroup ...
	CustomGroup HealthStateCategory = "CustomGroup"
	// Identity ...
	Identity HealthStateCategory = "Identity"
)

// PossibleHealthStateCategoryValues returns an array of possible values for the HealthStateCategory const type.
func PossibleHealthStateCategoryValues() []HealthStateCategory {
	return []HealthStateCategory{CustomGroup, Identity}
}

// MonitorCategory enumerates the values for monitor category.
type MonitorCategory string

const (
	// AvailabilityHealth ...
	AvailabilityHealth MonitorCategory = "AvailabilityHealth"
	// Configuration ...
	Configuration MonitorCategory = "Configuration"
	// EntityHealth ...
	EntityHealth MonitorCategory = "EntityHealth"
	// PerformanceHealth ...
	PerformanceHealth MonitorCategory = "PerformanceHealth"
	// Security ...
	Security MonitorCategory = "Security"
)

// PossibleMonitorCategoryValues returns an array of possible values for the MonitorCategory const type.
func PossibleMonitorCategoryValues() []MonitorCategory {
	return []MonitorCategory{AvailabilityHealth, Configuration, EntityHealth, PerformanceHealth, Security}
}

// MonitorState enumerates the values for monitor state.
type MonitorState string

const (
	// MonitorStateDisabled ...
	MonitorStateDisabled MonitorState = "Disabled"
	// MonitorStateEnabled ...
	MonitorStateEnabled MonitorState = "Enabled"
)

// PossibleMonitorStateValues returns an array of possible values for the MonitorState const type.
func PossibleMonitorStateValues() []MonitorState {
	return []MonitorState{MonitorStateDisabled, MonitorStateEnabled}
}

// MonitorType enumerates the values for monitor type.
type MonitorType string

const (
	// Aggregate ...
	Aggregate MonitorType = "Aggregate"
	// Dependency ...
	Dependency MonitorType = "Dependency"
	// Unit ...
	Unit MonitorType = "Unit"
)

// PossibleMonitorTypeValues returns an array of possible values for the MonitorType const type.
func PossibleMonitorTypeValues() []MonitorType {
	return []MonitorType{Aggregate, Dependency, Unit}
}

// Operator enumerates the values for operator.
type Operator string

const (
	// Equals ...
	Equals Operator = "Equals"
	// GreaterThan ...
	GreaterThan Operator = "GreaterThan"
	// GreaterThanOrEqual ...
	GreaterThanOrEqual Operator = "GreaterThanOrEqual"
	// LessThan ...
	LessThan Operator = "LessThan"
	// LessThanOrEqual ...
	LessThanOrEqual Operator = "LessThanOrEqual"
	// NotEquals ...
	NotEquals Operator = "NotEquals"
)

// PossibleOperatorValues returns an array of possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{Equals, GreaterThan, GreaterThanOrEqual, LessThan, LessThanOrEqual, NotEquals}
}

// WorkloadType enumerates the values for workload type.
type WorkloadType string

const (
	// Apache ...
	Apache WorkloadType = "Apache"
	// BaseOS ...
	BaseOS WorkloadType = "BaseOS"
	// IIS ...
	IIS WorkloadType = "IIS"
	// SQL ...
	SQL WorkloadType = "SQL"
)

// PossibleWorkloadTypeValues returns an array of possible values for the WorkloadType const type.
func PossibleWorkloadTypeValues() []WorkloadType {
	return []WorkloadType{Apache, BaseOS, IIS, SQL}
}

// AzureEntityResource the resource model definition for a Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// Component model for component.
type Component struct {
	autorest.Response `json:"-"`
	// Etag - For optimistic concurrency control.
	Etag *string `json:"etag,omitempty"`
	// ComponentProperties - Properties of the component.
	*ComponentProperties `json:"properties,omitempty"`
	// ID - Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Component.
func (c Component) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Etag != nil {
		objectMap["etag"] = c.Etag
	}
	if c.ComponentProperties != nil {
		objectMap["properties"] = c.ComponentProperties
	}
	if c.ID != nil {
		objectMap["id"] = c.ID
	}
	if c.Name != nil {
		objectMap["name"] = c.Name
	}
	if c.Type != nil {
		objectMap["type"] = c.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Component struct.
func (c *Component) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				c.Etag = &etag
			}
		case "properties":
			if v != nil {
				var componentProperties ComponentProperties
				err = json.Unmarshal(*v, &componentProperties)
				if err != nil {
					return err
				}
				c.ComponentProperties = &componentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ComponentProperties model for properties of a component.
type ComponentProperties struct {
	// WorkspaceID - ID of the workspace.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// SolutionID - ID of the OMS solution this component belong to.
	SolutionID *string `json:"solutionId,omitempty"`
	// WorkloadType - Type of the workload. Possible values include: 'BaseOS', 'SQL', 'IIS', 'Apache'
	WorkloadType WorkloadType `json:"workloadType,omitempty"`
	// ComponentName - Name of the component.
	ComponentName *string `json:"componentName,omitempty"`
	// ComponentTypeID - ID of the component type.
	ComponentTypeID *string `json:"componentTypeId,omitempty"`
	// ComponentTypeName - Name of the component type. Qualifies the type of component such as whether it is a SQL database, logical disk, website, etc.
	ComponentTypeName *string `json:"componentTypeName,omitempty"`
	// ComponentTypeGroupCategory - Component type group category. Classification of component type groups into a logical category. e.g. Network, Disk, Memory, CPU.
	ComponentTypeGroupCategory *string `json:"componentTypeGroupCategory,omitempty"`
	// HealthState - Health state of the component. Possible values include: 'Error', 'Warning', 'Success', 'Unknown', 'Uninitialized'
	HealthState HealthState `json:"healthState,omitempty"`
	// HealthStateCategory - Category of component's health state. Possible values include: 'Identity', 'CustomGroup'
	HealthStateCategory HealthStateCategory `json:"healthStateCategory,omitempty"`
	// HealthStateChangesStartTime - Start time for health state changes.
	HealthStateChangesStartTime *date.Time `json:"healthStateChangesStartTime,omitempty"`
	// HealthStateChangesEndTime - End time for health state changes.
	HealthStateChangesEndTime *date.Time `json:"healthStateChangesEndTime,omitempty"`
	// LastHealthStateChangeTime - Time of last health state change.
	LastHealthStateChangeTime *date.Time `json:"lastHealthStateChangeTime,omitempty"`
	// VMID - ID of the VM this component belongs to.
	VMID *string `json:"vmId,omitempty"`
	// VMName - Name of the VM this component belongs to.
	VMName *string `json:"vmName,omitempty"`
	// VMTags - Tags on the VM this component belongs to.
	VMTags map[string]*string `json:"vmTags"`
	// AggregateProperties - Properties requested in aggregation queries.
	AggregateProperties map[string]*string `json:"aggregateProperties"`
	// Children - component children.
	Children *[]Component `json:"children,omitempty"`
}

// MarshalJSON is the custom marshaler for ComponentProperties.
func (cp ComponentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.WorkspaceID != nil {
		objectMap["workspaceId"] = cp.WorkspaceID
	}
	if cp.SolutionID != nil {
		objectMap["solutionId"] = cp.SolutionID
	}
	if cp.WorkloadType != "" {
		objectMap["workloadType"] = cp.WorkloadType
	}
	if cp.ComponentName != nil {
		objectMap["componentName"] = cp.ComponentName
	}
	if cp.ComponentTypeID != nil {
		objectMap["componentTypeId"] = cp.ComponentTypeID
	}
	if cp.ComponentTypeName != nil {
		objectMap["componentTypeName"] = cp.ComponentTypeName
	}
	if cp.ComponentTypeGroupCategory != nil {
		objectMap["componentTypeGroupCategory"] = cp.ComponentTypeGroupCategory
	}
	if cp.HealthState != "" {
		objectMap["healthState"] = cp.HealthState
	}
	if cp.HealthStateCategory != "" {
		objectMap["healthStateCategory"] = cp.HealthStateCategory
	}
	if cp.HealthStateChangesStartTime != nil {
		objectMap["healthStateChangesStartTime"] = cp.HealthStateChangesStartTime
	}
	if cp.HealthStateChangesEndTime != nil {
		objectMap["healthStateChangesEndTime"] = cp.HealthStateChangesEndTime
	}
	if cp.LastHealthStateChangeTime != nil {
		objectMap["lastHealthStateChangeTime"] = cp.LastHealthStateChangeTime
	}
	if cp.VMID != nil {
		objectMap["vmId"] = cp.VMID
	}
	if cp.VMName != nil {
		objectMap["vmName"] = cp.VMName
	}
	if cp.VMTags != nil {
		objectMap["vmTags"] = cp.VMTags
	}
	if cp.AggregateProperties != nil {
		objectMap["aggregateProperties"] = cp.AggregateProperties
	}
	if cp.Children != nil {
		objectMap["children"] = cp.Children
	}
	return json.Marshal(objectMap)
}

// ComponentsCollection model for collection of components.
type ComponentsCollection struct {
	autorest.Response `json:"-"`
	// NextLink - URL to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Collection of components.
	Value *[]Component `json:"value,omitempty"`
}

// ComponentsCollectionIterator provides access to a complete listing of Component values.
type ComponentsCollectionIterator struct {
	i    int
	page ComponentsCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ComponentsCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComponentsCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ComponentsCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ComponentsCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ComponentsCollectionIterator) Response() ComponentsCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ComponentsCollectionIterator) Value() Component {
	if !iter.page.NotDone() {
		return Component{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ComponentsCollectionIterator type.
func NewComponentsCollectionIterator(page ComponentsCollectionPage) ComponentsCollectionIterator {
	return ComponentsCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cc ComponentsCollection) IsEmpty() bool {
	return cc.Value == nil || len(*cc.Value) == 0
}

// componentsCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cc ComponentsCollection) componentsCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if cc.NextLink == nil || len(to.String(cc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cc.NextLink)))
}

// ComponentsCollectionPage contains a page of Component values.
type ComponentsCollectionPage struct {
	fn func(context.Context, ComponentsCollection) (ComponentsCollection, error)
	cc ComponentsCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ComponentsCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComponentsCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cc)
	if err != nil {
		return err
	}
	page.cc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ComponentsCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ComponentsCollectionPage) NotDone() bool {
	return !page.cc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ComponentsCollectionPage) Response() ComponentsCollection {
	return page.cc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ComponentsCollectionPage) Values() []Component {
	if page.cc.IsEmpty() {
		return nil
	}
	return *page.cc.Value
}

// Creates a new instance of the ComponentsCollectionPage type.
func NewComponentsCollectionPage(getNextPage func(context.Context, ComponentsCollection) (ComponentsCollection, error)) ComponentsCollectionPage {
	return ComponentsCollectionPage{fn: getNextPage}
}

// ErrorFieldContract error field contract.
type ErrorFieldContract struct {
	// Code - Property level error code.
	Code *string `json:"code,omitempty"`
	// Message - Human-readable representation of property-level error.
	Message *string `json:"message,omitempty"`
	// Target - Property name.
	Target *string `json:"target,omitempty"`
}

// ErrorResponse error body contract.
type ErrorResponse struct {
	// Code - Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response.
	Code *string `json:"code,omitempty"`
	// Message - Human-readable representation of the error.
	Message *string `json:"message,omitempty"`
	// Details - The list of invalid fields send in request, in case of validation error.
	Details *[]ErrorFieldContract `json:"details,omitempty"`
}

// HealthStateChange model for health state change
type HealthStateChange struct {
	// HealthState - Health state of monitor instance. Possible values include: 'Error', 'Warning', 'Success', 'Unknown', 'Uninitialized'
	HealthState HealthState `json:"healthState,omitempty"`
	// HealthStateChangeTime - Time at which this Health state was reached.
	HealthStateChangeTime *date.Time `json:"healthStateChangeTime,omitempty"`
}

// Monitor model for Monitor
type Monitor struct {
	autorest.Response `json:"-"`
	// Etag - For optimistic concurrency control.
	Etag *string `json:"etag,omitempty"`
	// MonitorProperties - Properties of monitor instance
	*MonitorProperties `json:"properties,omitempty"`
	// ID - Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Monitor.
func (mVar Monitor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.Etag != nil {
		objectMap["etag"] = mVar.Etag
	}
	if mVar.MonitorProperties != nil {
		objectMap["properties"] = mVar.MonitorProperties
	}
	if mVar.ID != nil {
		objectMap["id"] = mVar.ID
	}
	if mVar.Name != nil {
		objectMap["name"] = mVar.Name
	}
	if mVar.Type != nil {
		objectMap["type"] = mVar.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Monitor struct.
func (mVar *Monitor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mVar.Etag = &etag
			}
		case "properties":
			if v != nil {
				var monitorProperties MonitorProperties
				err = json.Unmarshal(*v, &monitorProperties)
				if err != nil {
					return err
				}
				mVar.MonitorProperties = &monitorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		}
	}

	return nil
}

// MonitorCriteria criteria for monitor configuration
type MonitorCriteria struct {
	// HealthState - Target health state of the criteria. Possible values include: 'Error', 'Warning', 'Success', 'Unknown', 'Uninitialized'
	HealthState HealthState `json:"healthState,omitempty"`
	// Threshold - Treshold value for this criteria
	Threshold *float64 `json:"threshold,omitempty"`
	// ComparisonOperator - Comparison enum on theshold of this criteria. Possible values include: 'Equals', 'GreaterThan', 'GreaterThanOrEqual', 'LessThan', 'LessThanOrEqual', 'NotEquals'
	ComparisonOperator Operator `json:"comparisonOperator,omitempty"`
}

// MonitorInstance model for monitor instance.
type MonitorInstance struct {
	autorest.Response `json:"-"`
	// Etag - For optimistic concurrency control.
	Etag *string `json:"etag,omitempty"`
	// MonitorInstanceProperties - Properties of the monitor instance.
	*MonitorInstanceProperties `json:"properties,omitempty"`
	// ID - Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MonitorInstance.
func (mi MonitorInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mi.Etag != nil {
		objectMap["etag"] = mi.Etag
	}
	if mi.MonitorInstanceProperties != nil {
		objectMap["properties"] = mi.MonitorInstanceProperties
	}
	if mi.ID != nil {
		objectMap["id"] = mi.ID
	}
	if mi.Name != nil {
		objectMap["name"] = mi.Name
	}
	if mi.Type != nil {
		objectMap["type"] = mi.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MonitorInstance struct.
func (mi *MonitorInstance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mi.Etag = &etag
			}
		case "properties":
			if v != nil {
				var monitorInstanceProperties MonitorInstanceProperties
				err = json.Unmarshal(*v, &monitorInstanceProperties)
				if err != nil {
					return err
				}
				mi.MonitorInstanceProperties = &monitorInstanceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mi.Type = &typeVar
			}
		}
	}

	return nil
}

// MonitorInstanceProperties model for properties of a monitor instance.
type MonitorInstanceProperties struct {
	// WorkspaceID - ID of the workspace.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// SolutionID - ID of the OMS solution this health instance belong to.
	SolutionID *string `json:"solutionId,omitempty"`
	// WorkloadType - Type of the workload. Possible values include: 'BaseOS', 'SQL', 'IIS', 'Apache'
	WorkloadType WorkloadType `json:"workloadType,omitempty"`
	// ComponentID - ID of the component.
	ComponentID *string `json:"componentId,omitempty"`
	// ComponentName - Name of the component.
	ComponentName *string `json:"componentName,omitempty"`
	// ComponentTypeID - ID of the component type.
	ComponentTypeID *string `json:"componentTypeId,omitempty"`
	// ComponentTypeName - Name of the component type. Qualifies the type of component such as whether it is a SQL database, logical disk, website, etc.
	ComponentTypeName *string `json:"componentTypeName,omitempty"`
	// MonitorID - ID of the monitor instance.
	MonitorID *string `json:"monitorId,omitempty"`
	// MonitorName - Name of the monitor.
	MonitorName *string `json:"monitorName,omitempty"`
	// MonitorType - Type of the monitor. The qualifier for the health criteria depending on the functionality it performs such as Unit, Aggregate, Dependency. Possible values include: 'Aggregate', 'Dependency', 'Unit'
	MonitorType MonitorType `json:"monitorType,omitempty"`
	// MonitorCategory - Monitor type category. Indicates the attribute of the component that the health criteria monitors such as Performance, Availability, etc. Possible values include: 'AvailabilityHealth', 'Configuration', 'EntityHealth', 'PerformanceHealth', 'Security'
	MonitorCategory MonitorCategory `json:"monitorCategory,omitempty"`
	// HealthState - Health state of monitor instance. Possible values include: 'Error', 'Warning', 'Success', 'Unknown', 'Uninitialized'
	HealthState HealthState `json:"healthState,omitempty"`
	// HealthStateCategory - Category of monitor instance's health state. Possible values include: 'Identity', 'CustomGroup'
	HealthStateCategory HealthStateCategory `json:"healthStateCategory,omitempty"`
	// HealthStateChanges - Health state changes.
	HealthStateChanges *[]HealthStateChange `json:"healthStateChanges,omitempty"`
	// HealthStateChangesStartTime - Start time for health state changes.
	HealthStateChangesStartTime *date.Time `json:"healthStateChangesStartTime,omitempty"`
	// HealthStateChangesEndTime - End time for health state changes.
	HealthStateChangesEndTime *date.Time `json:"healthStateChangesEndTime,omitempty"`
	// LastHealthStateChangeTime - Time of last health state change.
	LastHealthStateChangeTime *date.Time `json:"lastHealthStateChangeTime,omitempty"`
	// AlertGeneration - Generates alert or not. Possible values include: 'Enabled', 'Disabled'
	AlertGeneration AlertGeneration `json:"alertGeneration,omitempty"`
	// AggregateProperties - Properties requested in aggregation queries.
	AggregateProperties map[string]*string `json:"aggregateProperties"`
	// Children - Health instance children.
	Children *[]MonitorInstance `json:"children,omitempty"`
}

// MarshalJSON is the custom marshaler for MonitorInstanceProperties.
func (mip MonitorInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mip.WorkspaceID != nil {
		objectMap["workspaceId"] = mip.WorkspaceID
	}
	if mip.SolutionID != nil {
		objectMap["solutionId"] = mip.SolutionID
	}
	if mip.WorkloadType != "" {
		objectMap["workloadType"] = mip.WorkloadType
	}
	if mip.ComponentID != nil {
		objectMap["componentId"] = mip.ComponentID
	}
	if mip.ComponentName != nil {
		objectMap["componentName"] = mip.ComponentName
	}
	if mip.ComponentTypeID != nil {
		objectMap["componentTypeId"] = mip.ComponentTypeID
	}
	if mip.ComponentTypeName != nil {
		objectMap["componentTypeName"] = mip.ComponentTypeName
	}
	if mip.MonitorID != nil {
		objectMap["monitorId"] = mip.MonitorID
	}
	if mip.MonitorName != nil {
		objectMap["monitorName"] = mip.MonitorName
	}
	if mip.MonitorType != "" {
		objectMap["monitorType"] = mip.MonitorType
	}
	if mip.MonitorCategory != "" {
		objectMap["monitorCategory"] = mip.MonitorCategory
	}
	if mip.HealthState != "" {
		objectMap["healthState"] = mip.HealthState
	}
	if mip.HealthStateCategory != "" {
		objectMap["healthStateCategory"] = mip.HealthStateCategory
	}
	if mip.HealthStateChanges != nil {
		objectMap["healthStateChanges"] = mip.HealthStateChanges
	}
	if mip.HealthStateChangesStartTime != nil {
		objectMap["healthStateChangesStartTime"] = mip.HealthStateChangesStartTime
	}
	if mip.HealthStateChangesEndTime != nil {
		objectMap["healthStateChangesEndTime"] = mip.HealthStateChangesEndTime
	}
	if mip.LastHealthStateChangeTime != nil {
		objectMap["lastHealthStateChangeTime"] = mip.LastHealthStateChangeTime
	}
	if mip.AlertGeneration != "" {
		objectMap["alertGeneration"] = mip.AlertGeneration
	}
	if mip.AggregateProperties != nil {
		objectMap["aggregateProperties"] = mip.AggregateProperties
	}
	if mip.Children != nil {
		objectMap["children"] = mip.Children
	}
	return json.Marshal(objectMap)
}

// MonitorInstancesCollection model for collection of health instances.
type MonitorInstancesCollection struct {
	autorest.Response `json:"-"`
	// NextLink - URL to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Collection of health instances.
	Value *[]MonitorInstance `json:"value,omitempty"`
}

// MonitorInstancesCollectionIterator provides access to a complete listing of MonitorInstance values.
type MonitorInstancesCollectionIterator struct {
	i    int
	page MonitorInstancesCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MonitorInstancesCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitorInstancesCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MonitorInstancesCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MonitorInstancesCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MonitorInstancesCollectionIterator) Response() MonitorInstancesCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MonitorInstancesCollectionIterator) Value() MonitorInstance {
	if !iter.page.NotDone() {
		return MonitorInstance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MonitorInstancesCollectionIterator type.
func NewMonitorInstancesCollectionIterator(page MonitorInstancesCollectionPage) MonitorInstancesCollectionIterator {
	return MonitorInstancesCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mic MonitorInstancesCollection) IsEmpty() bool {
	return mic.Value == nil || len(*mic.Value) == 0
}

// monitorInstancesCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mic MonitorInstancesCollection) monitorInstancesCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if mic.NextLink == nil || len(to.String(mic.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mic.NextLink)))
}

// MonitorInstancesCollectionPage contains a page of MonitorInstance values.
type MonitorInstancesCollectionPage struct {
	fn  func(context.Context, MonitorInstancesCollection) (MonitorInstancesCollection, error)
	mic MonitorInstancesCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MonitorInstancesCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitorInstancesCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.mic)
	if err != nil {
		return err
	}
	page.mic = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MonitorInstancesCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MonitorInstancesCollectionPage) NotDone() bool {
	return !page.mic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MonitorInstancesCollectionPage) Response() MonitorInstancesCollection {
	return page.mic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MonitorInstancesCollectionPage) Values() []MonitorInstance {
	if page.mic.IsEmpty() {
		return nil
	}
	return *page.mic.Value
}

// Creates a new instance of the MonitorInstancesCollectionPage type.
func NewMonitorInstancesCollectionPage(getNextPage func(context.Context, MonitorInstancesCollection) (MonitorInstancesCollection, error)) MonitorInstancesCollectionPage {
	return MonitorInstancesCollectionPage{fn: getNextPage}
}

// MonitorProperties model for properties of a Monitor.
type MonitorProperties struct {
	// Description - Description of the monitor
	Description *string `json:"description,omitempty"`
	// MonitorID - ID of the monitor
	MonitorID *string `json:"monitorId,omitempty"`
	// MonitorName - Name of the monitor
	MonitorName *string `json:"monitorName,omitempty"`
	// MonitorDisplayName - User friendly display name of the monitor
	MonitorDisplayName *string `json:"monitorDisplayName,omitempty"`
	// ParentMonitorName - Name of the parent monitor
	ParentMonitorName *string `json:"parentMonitorName,omitempty"`
	// ParentMonitorDisplayName - User friendly display name of the parent monitor
	ParentMonitorDisplayName *string `json:"parentMonitorDisplayName,omitempty"`
	// MonitorType - Type of the monitor. Possible values include: 'Aggregate', 'Dependency', 'Unit'
	MonitorType MonitorType `json:"monitorType,omitempty"`
	// MonitorCategory - Category of the monitor. Possible values include: 'AvailabilityHealth', 'Configuration', 'EntityHealth', 'PerformanceHealth', 'Security'
	MonitorCategory MonitorCategory `json:"monitorCategory,omitempty"`
	// ComponentTypeID - Component Type Id of monitor
	ComponentTypeID *string `json:"componentTypeId,omitempty"`
	// ComponentTypeName - Component Type Name of monitor
	ComponentTypeName *string `json:"componentTypeName,omitempty"`
	// ComponentTypeDisplayName - Component Type Display Name of the monitor
	ComponentTypeDisplayName *string `json:"componentTypeDisplayName,omitempty"`
	// MonitorState - Is the monitor state enabled or disabled. Possible values include: 'MonitorStateEnabled', 'MonitorStateDisabled'
	MonitorState MonitorState `json:"monitorState,omitempty"`
	// Criteria - Collection of MonitorCriteria. For PATCH calls, instead of partial list, complete list of expected criteria should be passed for proper updation.
	Criteria *[]MonitorCriteria `json:"criteria,omitempty"`
	// AlertGeneration - Generates alerts or not. Possible values include: 'Enabled', 'Disabled'
	AlertGeneration AlertGeneration `json:"alertGeneration,omitempty"`
	// Frequency - Frequency at which monitor condition is evaluated
	Frequency *int32 `json:"frequency,omitempty"`
	// LookbackDuration - The duration in minutes in the past during which the monitor is evaluated
	LookbackDuration *int32 `json:"lookbackDuration,omitempty"`
	// DocumentationURL - URL pointing to the documentation of the monitor
	DocumentationURL *string `json:"documentationURL,omitempty"`
	// SignalName - Name of the signal on which this monitor is configured.
	SignalName *string `json:"signalName,omitempty"`
	// SignalType - Type of the signal on which this monitor is configured.
	SignalType *string `json:"signalType,omitempty"`
}

// MonitorsCollection model for collection of Monitor.
type MonitorsCollection struct {
	autorest.Response `json:"-"`
	// NextLink - URL for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Collection of Monitor.
	Value *[]Monitor `json:"value,omitempty"`
}

// MonitorsCollectionIterator provides access to a complete listing of Monitor values.
type MonitorsCollectionIterator struct {
	i    int
	page MonitorsCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MonitorsCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitorsCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MonitorsCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MonitorsCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MonitorsCollectionIterator) Response() MonitorsCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MonitorsCollectionIterator) Value() Monitor {
	if !iter.page.NotDone() {
		return Monitor{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MonitorsCollectionIterator type.
func NewMonitorsCollectionIterator(page MonitorsCollectionPage) MonitorsCollectionIterator {
	return MonitorsCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mc MonitorsCollection) IsEmpty() bool {
	return mc.Value == nil || len(*mc.Value) == 0
}

// monitorsCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mc MonitorsCollection) monitorsCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if mc.NextLink == nil || len(to.String(mc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mc.NextLink)))
}

// MonitorsCollectionPage contains a page of Monitor values.
type MonitorsCollectionPage struct {
	fn func(context.Context, MonitorsCollection) (MonitorsCollection, error)
	mc MonitorsCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MonitorsCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitorsCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.mc)
	if err != nil {
		return err
	}
	page.mc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MonitorsCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MonitorsCollectionPage) NotDone() bool {
	return !page.mc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MonitorsCollectionPage) Response() MonitorsCollection {
	return page.mc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MonitorsCollectionPage) Values() []Monitor {
	if page.mc.IsEmpty() {
		return nil
	}
	return *page.mc.Value
}

// Creates a new instance of the MonitorsCollectionPage type.
func NewMonitorsCollectionPage(getNextPage func(context.Context, MonitorsCollection) (MonitorsCollection, error)) MonitorsCollectionPage {
	return MonitorsCollectionPage{fn: getNextPage}
}

// NotificationSetting model for component.
type NotificationSetting struct {
	// Etag - For optimistic concurrency control.
	Etag *string `json:"etag,omitempty"`
	// NotificationSettingProperties - Properties of the component.
	*NotificationSettingProperties `json:"properties,omitempty"`
	// ID - Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for NotificationSetting.
func (ns NotificationSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ns.Etag != nil {
		objectMap["etag"] = ns.Etag
	}
	if ns.NotificationSettingProperties != nil {
		objectMap["properties"] = ns.NotificationSettingProperties
	}
	if ns.ID != nil {
		objectMap["id"] = ns.ID
	}
	if ns.Name != nil {
		objectMap["name"] = ns.Name
	}
	if ns.Type != nil {
		objectMap["type"] = ns.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NotificationSetting struct.
func (ns *NotificationSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ns.Etag = &etag
			}
		case "properties":
			if v != nil {
				var notificationSettingProperties NotificationSettingProperties
				err = json.Unmarshal(*v, &notificationSettingProperties)
				if err != nil {
					return err
				}
				ns.NotificationSettingProperties = &notificationSettingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ns.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ns.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ns.Type = &typeVar
			}
		}
	}

	return nil
}

// NotificationSettingProperties model for properties of a NotificationSetting.
type NotificationSettingProperties struct {
	// ActionGroups - List of action group resource ids to be notified
	ActionGroups *[]string `json:"actionGroups,omitempty"`
}

// NotificationSettingsCollection model for collection of notificationSettings.
type NotificationSettingsCollection struct {
	autorest.Response `json:"-"`
	// NextLink - URL to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Collection of components.
	Value *[]NotificationSetting `json:"value,omitempty"`
}

// NotificationSettingsCollectionIterator provides access to a complete listing of NotificationSetting
// values.
type NotificationSettingsCollectionIterator struct {
	i    int
	page NotificationSettingsCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NotificationSettingsCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NotificationSettingsCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NotificationSettingsCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NotificationSettingsCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NotificationSettingsCollectionIterator) Response() NotificationSettingsCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NotificationSettingsCollectionIterator) Value() NotificationSetting {
	if !iter.page.NotDone() {
		return NotificationSetting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NotificationSettingsCollectionIterator type.
func NewNotificationSettingsCollectionIterator(page NotificationSettingsCollectionPage) NotificationSettingsCollectionIterator {
	return NotificationSettingsCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nsc NotificationSettingsCollection) IsEmpty() bool {
	return nsc.Value == nil || len(*nsc.Value) == 0
}

// notificationSettingsCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nsc NotificationSettingsCollection) notificationSettingsCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if nsc.NextLink == nil || len(to.String(nsc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nsc.NextLink)))
}

// NotificationSettingsCollectionPage contains a page of NotificationSetting values.
type NotificationSettingsCollectionPage struct {
	fn  func(context.Context, NotificationSettingsCollection) (NotificationSettingsCollection, error)
	nsc NotificationSettingsCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NotificationSettingsCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NotificationSettingsCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.nsc)
	if err != nil {
		return err
	}
	page.nsc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NotificationSettingsCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NotificationSettingsCollectionPage) NotDone() bool {
	return !page.nsc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NotificationSettingsCollectionPage) Response() NotificationSettingsCollection {
	return page.nsc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NotificationSettingsCollectionPage) Values() []NotificationSetting {
	if page.nsc.IsEmpty() {
		return nil
	}
	return *page.nsc.Value
}

// Creates a new instance of the NotificationSettingsCollectionPage type.
func NewNotificationSettingsCollectionPage(getNextPage func(context.Context, NotificationSettingsCollection) (NotificationSettingsCollection, error)) NotificationSettingsCollectionPage {
	return NotificationSettingsCollectionPage{fn: getNextPage}
}

// Operation operation supported by the resource provider.
type Operation struct {
	// Display - The properties of the resource operation.
	Display *OperationProperties `json:"display,omitempty"`
	// Name - The name of the resource operation.
	Name *string `json:"name,omitempty"`
	// Origin - The origin of the operation.
	Origin *string `json:"origin,omitempty"`
}

// OperationListResult container for a list of operations supported by the resource provider.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// NextLink - URL to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - List of operations.
	Value *[]Operation `json:"value,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// OperationProperties properties of an operation supported by the resource provider.
type OperationProperties struct {
	// Description - The description of the resource provider.
	Description *string `json:"description,omitempty"`
	// Operation - This operation name.
	Operation *string `json:"operation,omitempty"`
	// Provider - The provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource name.
	Resource *string `json:"resource,omitempty"`
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags
type ProxyResource struct {
	// ID - Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// Resource ...
type Resource struct {
	// ID - Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.ID != nil {
		objectMap["id"] = tr.ID
	}
	if tr.Name != nil {
		objectMap["name"] = tr.Name
	}
	if tr.Type != nil {
		objectMap["type"] = tr.Type
	}
	return json.Marshal(objectMap)
}
