// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateRuleInput struct {
	_ struct{} `type:"structure"`

	// The rule description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector ID for the rule's parent detector.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The rule expression.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" min:"1" type:"string" required:"true"`

	// The language of the rule.
	//
	// Language is a required field
	Language Language `locationName:"language" type:"string" required:"true" enum:"true"`

	// The outcome or outcomes returned when the rule expression matches.
	//
	// Outcomes is a required field
	Outcomes []string `locationName:"outcomes" min:"1" type:"list" required:"true"`

	// The rule ID.
	//
	// RuleId is a required field
	RuleId *string `locationName:"ruleId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateRuleInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorId", 1))
	}

	if s.Expression == nil {
		invalidParams.Add(aws.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Expression", 1))
	}
	if len(s.Language) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Language"))
	}

	if s.Outcomes == nil {
		invalidParams.Add(aws.NewErrParamRequired("Outcomes"))
	}
	if s.Outcomes != nil && len(s.Outcomes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Outcomes", 1))
	}

	if s.RuleId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateRuleOutput struct {
	_ struct{} `type:"structure"`

	// The created rule.
	Rule *Rule `locationName:"rule" type:"structure"`
}

// String returns the string representation
func (s CreateRuleOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateRule = "CreateRule"

// CreateRuleRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Creates a rule for use with the specified detector.
//
//    // Example sending a request using CreateRuleRequest.
//    req := client.CreateRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateRule
func (c *Client) CreateRuleRequest(input *CreateRuleInput) CreateRuleRequest {
	op := &aws.Operation{
		Name:       opCreateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRuleInput{}
	}

	req := c.newRequest(op, input, &CreateRuleOutput{})
	return CreateRuleRequest{Request: req, Input: input, Copy: c.CreateRuleRequest}
}

// CreateRuleRequest is the request type for the
// CreateRule API operation.
type CreateRuleRequest struct {
	*aws.Request
	Input *CreateRuleInput
	Copy  func(*CreateRuleInput) CreateRuleRequest
}

// Send marshals and sends the CreateRule API request.
func (r CreateRuleRequest) Send(ctx context.Context) (*CreateRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateRuleResponse{
		CreateRuleOutput: r.Request.Data.(*CreateRuleOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateRuleResponse is the response type for the
// CreateRule API operation.
type CreateRuleResponse struct {
	*CreateRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateRule request.
func (r *CreateRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
