// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeletePendingAggregationRequestInput struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the account requesting to aggregate data.
	//
	// RequesterAccountId is a required field
	RequesterAccountId *string `type:"string" required:"true"`

	// The region requesting to aggregate data.
	//
	// RequesterAwsRegion is a required field
	RequesterAwsRegion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePendingAggregationRequestInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePendingAggregationRequestInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePendingAggregationRequestInput"}

	if s.RequesterAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RequesterAccountId"))
	}

	if s.RequesterAwsRegion == nil {
		invalidParams.Add(aws.NewErrParamRequired("RequesterAwsRegion"))
	}
	if s.RequesterAwsRegion != nil && len(*s.RequesterAwsRegion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RequesterAwsRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeletePendingAggregationRequestOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePendingAggregationRequestOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeletePendingAggregationRequest = "DeletePendingAggregationRequest"

// DeletePendingAggregationRequestRequest returns a request value for making API operation for
// AWS Config.
//
// Deletes pending authorization requests for a specified aggregator account
// in a specified region.
//
//    // Example sending a request using DeletePendingAggregationRequestRequest.
//    req := client.DeletePendingAggregationRequestRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeletePendingAggregationRequest
func (c *Client) DeletePendingAggregationRequestRequest(input *DeletePendingAggregationRequestInput) DeletePendingAggregationRequestRequest {
	op := &aws.Operation{
		Name:       opDeletePendingAggregationRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePendingAggregationRequestInput{}
	}

	req := c.newRequest(op, input, &DeletePendingAggregationRequestOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeletePendingAggregationRequestRequest{Request: req, Input: input, Copy: c.DeletePendingAggregationRequestRequest}
}

// DeletePendingAggregationRequestRequest is the request type for the
// DeletePendingAggregationRequest API operation.
type DeletePendingAggregationRequestRequest struct {
	*aws.Request
	Input *DeletePendingAggregationRequestInput
	Copy  func(*DeletePendingAggregationRequestInput) DeletePendingAggregationRequestRequest
}

// Send marshals and sends the DeletePendingAggregationRequest API request.
func (r DeletePendingAggregationRequestRequest) Send(ctx context.Context) (*DeletePendingAggregationRequestResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePendingAggregationRequestResponse{
		DeletePendingAggregationRequestOutput: r.Request.Data.(*DeletePendingAggregationRequestOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePendingAggregationRequestResponse is the response type for the
// DeletePendingAggregationRequest API operation.
type DeletePendingAggregationRequestResponse struct {
	*DeletePendingAggregationRequestOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePendingAggregationRequest request.
func (r *DeletePendingAggregationRequestResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
