// Code generated by "libovsdb.modelgen"
// DO NOT EDIT.

package nbdb

import "github.com/ovn-org/libovsdb/model"

type (
	ACLAction    = string
	ACLDirection = string
	ACLSeverity  = string
)

var (
	ACLActionAllow          ACLAction    = "allow"
	ACLActionAllowRelated   ACLAction    = "allow-related"
	ACLActionAllowStateless ACLAction    = "allow-stateless"
	ACLActionDrop           ACLAction    = "drop"
	ACLActionReject         ACLAction    = "reject"
	ACLDirectionFromLport   ACLDirection = "from-lport"
	ACLDirectionToLport     ACLDirection = "to-lport"
	ACLSeverityAlert        ACLSeverity  = "alert"
	ACLSeverityWarning      ACLSeverity  = "warning"
	ACLSeverityNotice       ACLSeverity  = "notice"
	ACLSeverityInfo         ACLSeverity  = "info"
	ACLSeverityDebug        ACLSeverity  = "debug"
)

// ACL defines an object in ACL table
type ACL struct {
	UUID        string            `ovsdb:"_uuid"`
	Action      ACLAction         `ovsdb:"action"`
	Direction   ACLDirection      `ovsdb:"direction"`
	ExternalIDs map[string]string `ovsdb:"external_ids"`
	Label       int               `ovsdb:"label"`
	Log         bool              `ovsdb:"log"`
	Match       string            `ovsdb:"match"`
	Meter       *string           `ovsdb:"meter"`
	Name        *string           `ovsdb:"name"`
	Options     map[string]string `ovsdb:"options"`
	Priority    int               `ovsdb:"priority"`
	Severity    *ACLSeverity      `ovsdb:"severity"`
}

func copyACLExternalIDs(a map[string]string) map[string]string {
	if a == nil {
		return nil
	}
	b := make(map[string]string, len(a))
	for k, v := range a {
		b[k] = v
	}
	return b
}

func equalACLExternalIDs(a, b map[string]string) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if len(a) != len(b) {
		return false
	}
	for k, v := range a {
		if w, ok := b[k]; !ok || v != w {
			return false
		}
	}
	return true
}

func copyACLMeter(a *string) *string {
	if a == nil {
		return nil
	}
	b := *a
	return &b
}

func equalACLMeter(a, b *string) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if a == b {
		return true
	}
	return *a == *b
}

func copyACLName(a *string) *string {
	if a == nil {
		return nil
	}
	b := *a
	return &b
}

func equalACLName(a, b *string) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if a == b {
		return true
	}
	return *a == *b
}

func copyACLOptions(a map[string]string) map[string]string {
	if a == nil {
		return nil
	}
	b := make(map[string]string, len(a))
	for k, v := range a {
		b[k] = v
	}
	return b
}

func equalACLOptions(a, b map[string]string) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if len(a) != len(b) {
		return false
	}
	for k, v := range a {
		if w, ok := b[k]; !ok || v != w {
			return false
		}
	}
	return true
}

func copyACLSeverity(a *ACLSeverity) *ACLSeverity {
	if a == nil {
		return nil
	}
	b := *a
	return &b
}

func equalACLSeverity(a, b *ACLSeverity) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if a == b {
		return true
	}
	return *a == *b
}

func (a *ACL) DeepCopyInto(b *ACL) {
	*b = *a
	b.ExternalIDs = copyACLExternalIDs(a.ExternalIDs)
	b.Meter = copyACLMeter(a.Meter)
	b.Name = copyACLName(a.Name)
	b.Options = copyACLOptions(a.Options)
	b.Severity = copyACLSeverity(a.Severity)
}

func (a *ACL) DeepCopy() *ACL {
	b := new(ACL)
	a.DeepCopyInto(b)
	return b
}

func (a *ACL) CloneModelInto(b model.Model) {
	c := b.(*ACL)
	a.DeepCopyInto(c)
}

func (a *ACL) CloneModel() model.Model {
	return a.DeepCopy()
}

func (a *ACL) Equals(b *ACL) bool {
	return a.UUID == b.UUID &&
		a.Action == b.Action &&
		a.Direction == b.Direction &&
		equalACLExternalIDs(a.ExternalIDs, b.ExternalIDs) &&
		a.Label == b.Label &&
		a.Log == b.Log &&
		a.Match == b.Match &&
		equalACLMeter(a.Meter, b.Meter) &&
		equalACLName(a.Name, b.Name) &&
		equalACLOptions(a.Options, b.Options) &&
		a.Priority == b.Priority &&
		equalACLSeverity(a.Severity, b.Severity)
}

func (a *ACL) EqualsModel(b model.Model) bool {
	c := b.(*ACL)
	return a.Equals(c)
}

var _ model.CloneableModel = &ACL{}
var _ model.ComparableModel = &ACL{}
