package dtlapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/devtestlabs/mgmt/2016-05-15/dtl"
	"github.com/Azure/go-autorest/autorest"
)

// ProviderOperationsClientAPI contains the set of methods on the ProviderOperationsClient type.
type ProviderOperationsClientAPI interface {
	List(ctx context.Context) (result dtl.ProviderOperationResultPage, err error)
	ListComplete(ctx context.Context) (result dtl.ProviderOperationResultIterator, err error)
}

var _ ProviderOperationsClientAPI = (*dtl.ProviderOperationsClient)(nil)

// LabsClientAPI contains the set of methods on the LabsClient type.
type LabsClientAPI interface {
	ClaimAnyVM(ctx context.Context, resourceGroupName string, name string) (result dtl.LabsClaimAnyVMFuture, err error)
	CreateEnvironment(ctx context.Context, resourceGroupName string, name string, labVirtualMachineCreationParameter dtl.LabVirtualMachineCreationParameter) (result dtl.LabsCreateEnvironmentFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, lab dtl.Lab) (result dtl.LabsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, name string) (result dtl.LabsDeleteFuture, err error)
	ExportResourceUsage(ctx context.Context, resourceGroupName string, name string, exportResourceUsageParameters dtl.ExportResourceUsageParameters) (result dtl.LabsExportResourceUsageFuture, err error)
	GenerateUploadURI(ctx context.Context, resourceGroupName string, name string, generateUploadURIParameter dtl.GenerateUploadURIParameter) (result dtl.GenerateUploadURIResponse, err error)
	Get(ctx context.Context, resourceGroupName string, name string, expand string) (result dtl.Lab, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationLabPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationLabIterator, err error)
	ListBySubscription(ctx context.Context, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationLabPage, err error)
	ListBySubscriptionComplete(ctx context.Context, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationLabIterator, err error)
	ListVhds(ctx context.Context, resourceGroupName string, name string) (result dtl.ResponseWithContinuationLabVhdPage, err error)
	ListVhdsComplete(ctx context.Context, resourceGroupName string, name string) (result dtl.ResponseWithContinuationLabVhdIterator, err error)
	Update(ctx context.Context, resourceGroupName string, name string, lab dtl.LabFragment) (result dtl.Lab, err error)
}

var _ LabsClientAPI = (*dtl.LabsClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	Get(ctx context.Context, locationName string, name string) (result dtl.OperationResult, err error)
}

var _ OperationsClientAPI = (*dtl.OperationsClient)(nil)

// GlobalSchedulesClientAPI contains the set of methods on the GlobalSchedulesClient type.
type GlobalSchedulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, schedule dtl.Schedule) (result dtl.Schedule, err error)
	Delete(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	Execute(ctx context.Context, resourceGroupName string, name string) (result dtl.GlobalSchedulesExecuteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, name string, expand string) (result dtl.Schedule, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationSchedulePage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationScheduleIterator, err error)
	ListBySubscription(ctx context.Context, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationSchedulePage, err error)
	ListBySubscriptionComplete(ctx context.Context, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationScheduleIterator, err error)
	Retarget(ctx context.Context, resourceGroupName string, name string, retargetScheduleProperties dtl.RetargetScheduleProperties) (result dtl.GlobalSchedulesRetargetFuture, err error)
	Update(ctx context.Context, resourceGroupName string, name string, schedule dtl.ScheduleFragment) (result dtl.Schedule, err error)
}

var _ GlobalSchedulesClientAPI = (*dtl.GlobalSchedulesClient)(nil)

// ArtifactSourcesClientAPI contains the set of methods on the ArtifactSourcesClient type.
type ArtifactSourcesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, labName string, name string, artifactSource dtl.ArtifactSource) (result dtl.ArtifactSource, err error)
	Delete(ctx context.Context, resourceGroupName string, labName string, name string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, labName string, name string, expand string) (result dtl.ArtifactSource, err error)
	List(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationArtifactSourcePage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationArtifactSourceIterator, err error)
	Update(ctx context.Context, resourceGroupName string, labName string, name string, artifactSource dtl.ArtifactSourceFragment) (result dtl.ArtifactSource, err error)
}

var _ ArtifactSourcesClientAPI = (*dtl.ArtifactSourcesClient)(nil)

// ArmTemplatesClientAPI contains the set of methods on the ArmTemplatesClient type.
type ArmTemplatesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, labName string, artifactSourceName string, name string, expand string) (result dtl.ArmTemplate, err error)
	List(ctx context.Context, resourceGroupName string, labName string, artifactSourceName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationArmTemplatePage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, labName string, artifactSourceName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationArmTemplateIterator, err error)
}

var _ ArmTemplatesClientAPI = (*dtl.ArmTemplatesClient)(nil)

// ArtifactsClientAPI contains the set of methods on the ArtifactsClient type.
type ArtifactsClientAPI interface {
	GenerateArmTemplate(ctx context.Context, resourceGroupName string, labName string, artifactSourceName string, name string, generateArmTemplateRequest dtl.GenerateArmTemplateRequest) (result dtl.ArmTemplateInfo, err error)
	Get(ctx context.Context, resourceGroupName string, labName string, artifactSourceName string, name string, expand string) (result dtl.Artifact, err error)
	List(ctx context.Context, resourceGroupName string, labName string, artifactSourceName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationArtifactPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, labName string, artifactSourceName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationArtifactIterator, err error)
}

var _ ArtifactsClientAPI = (*dtl.ArtifactsClient)(nil)

// CostsClientAPI contains the set of methods on the CostsClient type.
type CostsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, labName string, name string, labCost dtl.LabCost) (result dtl.LabCost, err error)
	Get(ctx context.Context, resourceGroupName string, labName string, name string, expand string) (result dtl.LabCost, err error)
}

var _ CostsClientAPI = (*dtl.CostsClient)(nil)

// CustomImagesClientAPI contains the set of methods on the CustomImagesClient type.
type CustomImagesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, labName string, name string, customImage dtl.CustomImage) (result dtl.CustomImagesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, labName string, name string) (result dtl.CustomImagesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, labName string, name string, expand string) (result dtl.CustomImage, err error)
	List(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationCustomImagePage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationCustomImageIterator, err error)
}

var _ CustomImagesClientAPI = (*dtl.CustomImagesClient)(nil)

// FormulasClientAPI contains the set of methods on the FormulasClient type.
type FormulasClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, labName string, name string, formula dtl.Formula) (result dtl.FormulasCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, labName string, name string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, labName string, name string, expand string) (result dtl.Formula, err error)
	List(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationFormulaPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationFormulaIterator, err error)
}

var _ FormulasClientAPI = (*dtl.FormulasClient)(nil)

// GalleryImagesClientAPI contains the set of methods on the GalleryImagesClient type.
type GalleryImagesClientAPI interface {
	List(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationGalleryImagePage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationGalleryImageIterator, err error)
}

var _ GalleryImagesClientAPI = (*dtl.GalleryImagesClient)(nil)

// NotificationChannelsClientAPI contains the set of methods on the NotificationChannelsClient type.
type NotificationChannelsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, labName string, name string, notificationChannel dtl.NotificationChannel) (result dtl.NotificationChannel, err error)
	Delete(ctx context.Context, resourceGroupName string, labName string, name string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, labName string, name string, expand string) (result dtl.NotificationChannel, err error)
	List(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationNotificationChannelPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationNotificationChannelIterator, err error)
	Notify(ctx context.Context, resourceGroupName string, labName string, name string, notifyParameters dtl.NotifyParameters) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, labName string, name string, notificationChannel dtl.NotificationChannelFragment) (result dtl.NotificationChannel, err error)
}

var _ NotificationChannelsClientAPI = (*dtl.NotificationChannelsClient)(nil)

// PolicySetsClientAPI contains the set of methods on the PolicySetsClient type.
type PolicySetsClientAPI interface {
	EvaluatePolicies(ctx context.Context, resourceGroupName string, labName string, name string, evaluatePoliciesRequest dtl.EvaluatePoliciesRequest) (result dtl.EvaluatePoliciesResponse, err error)
}

var _ PolicySetsClientAPI = (*dtl.PolicySetsClient)(nil)

// PoliciesClientAPI contains the set of methods on the PoliciesClient type.
type PoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, labName string, policySetName string, name string, policy dtl.Policy) (result dtl.Policy, err error)
	Delete(ctx context.Context, resourceGroupName string, labName string, policySetName string, name string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, labName string, policySetName string, name string, expand string) (result dtl.Policy, err error)
	List(ctx context.Context, resourceGroupName string, labName string, policySetName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationPolicyPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, labName string, policySetName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationPolicyIterator, err error)
	Update(ctx context.Context, resourceGroupName string, labName string, policySetName string, name string, policy dtl.PolicyFragment) (result dtl.Policy, err error)
}

var _ PoliciesClientAPI = (*dtl.PoliciesClient)(nil)

// SchedulesClientAPI contains the set of methods on the SchedulesClient type.
type SchedulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, labName string, name string, schedule dtl.Schedule) (result dtl.Schedule, err error)
	Delete(ctx context.Context, resourceGroupName string, labName string, name string) (result autorest.Response, err error)
	Execute(ctx context.Context, resourceGroupName string, labName string, name string) (result dtl.SchedulesExecuteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, labName string, name string, expand string) (result dtl.Schedule, err error)
	List(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationSchedulePage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationScheduleIterator, err error)
	ListApplicable(ctx context.Context, resourceGroupName string, labName string, name string) (result dtl.ResponseWithContinuationSchedulePage, err error)
	ListApplicableComplete(ctx context.Context, resourceGroupName string, labName string, name string) (result dtl.ResponseWithContinuationScheduleIterator, err error)
	Update(ctx context.Context, resourceGroupName string, labName string, name string, schedule dtl.ScheduleFragment) (result dtl.Schedule, err error)
}

var _ SchedulesClientAPI = (*dtl.SchedulesClient)(nil)

// ServiceRunnersClientAPI contains the set of methods on the ServiceRunnersClient type.
type ServiceRunnersClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, labName string, name string, serviceRunner dtl.ServiceRunner) (result dtl.ServiceRunner, err error)
	Delete(ctx context.Context, resourceGroupName string, labName string, name string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, labName string, name string) (result dtl.ServiceRunner, err error)
	List(ctx context.Context, resourceGroupName string, labName string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationServiceRunnerPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, labName string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationServiceRunnerIterator, err error)
}

var _ ServiceRunnersClientAPI = (*dtl.ServiceRunnersClient)(nil)

// UsersClientAPI contains the set of methods on the UsersClient type.
type UsersClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, labName string, name string, userParameter dtl.User) (result dtl.User, err error)
	Delete(ctx context.Context, resourceGroupName string, labName string, name string) (result dtl.UsersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, labName string, name string, expand string) (result dtl.User, err error)
	List(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationUserPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationUserIterator, err error)
	Update(ctx context.Context, resourceGroupName string, labName string, name string, userParameter dtl.UserFragment) (result dtl.User, err error)
}

var _ UsersClientAPI = (*dtl.UsersClient)(nil)

// DisksClientAPI contains the set of methods on the DisksClient type.
type DisksClientAPI interface {
	Attach(ctx context.Context, resourceGroupName string, labName string, userName string, name string, attachDiskProperties dtl.AttachDiskProperties) (result dtl.DisksAttachFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, labName string, userName string, name string, disk dtl.Disk) (result dtl.DisksCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, labName string, userName string, name string) (result dtl.DisksDeleteFuture, err error)
	Detach(ctx context.Context, resourceGroupName string, labName string, userName string, name string, detachDiskProperties dtl.DetachDiskProperties) (result dtl.DisksDetachFuture, err error)
	Get(ctx context.Context, resourceGroupName string, labName string, userName string, name string, expand string) (result dtl.Disk, err error)
	List(ctx context.Context, resourceGroupName string, labName string, userName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationDiskPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, labName string, userName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationDiskIterator, err error)
}

var _ DisksClientAPI = (*dtl.DisksClient)(nil)

// EnvironmentsClientAPI contains the set of methods on the EnvironmentsClient type.
type EnvironmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, labName string, userName string, name string, dtlEnvironment dtl.Environment) (result dtl.EnvironmentsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, labName string, userName string, name string) (result dtl.EnvironmentsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, labName string, userName string, name string, expand string) (result dtl.Environment, err error)
	List(ctx context.Context, resourceGroupName string, labName string, userName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationDtlEnvironmentPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, labName string, userName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationDtlEnvironmentIterator, err error)
}

var _ EnvironmentsClientAPI = (*dtl.EnvironmentsClient)(nil)

// SecretsClientAPI contains the set of methods on the SecretsClient type.
type SecretsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, labName string, userName string, name string, secret dtl.Secret) (result dtl.Secret, err error)
	Delete(ctx context.Context, resourceGroupName string, labName string, userName string, name string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, labName string, userName string, name string, expand string) (result dtl.Secret, err error)
	List(ctx context.Context, resourceGroupName string, labName string, userName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationSecretPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, labName string, userName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationSecretIterator, err error)
}

var _ SecretsClientAPI = (*dtl.SecretsClient)(nil)

// VirtualMachinesClientAPI contains the set of methods on the VirtualMachinesClient type.
type VirtualMachinesClientAPI interface {
	AddDataDisk(ctx context.Context, resourceGroupName string, labName string, name string, dataDiskProperties dtl.DataDiskProperties) (result dtl.VirtualMachinesAddDataDiskFuture, err error)
	ApplyArtifacts(ctx context.Context, resourceGroupName string, labName string, name string, applyArtifactsRequest dtl.ApplyArtifactsRequest) (result dtl.VirtualMachinesApplyArtifactsFuture, err error)
	Claim(ctx context.Context, resourceGroupName string, labName string, name string) (result dtl.VirtualMachinesClaimFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, labName string, name string, labVirtualMachine dtl.LabVirtualMachine) (result dtl.VirtualMachinesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, labName string, name string) (result dtl.VirtualMachinesDeleteFuture, err error)
	DetachDataDisk(ctx context.Context, resourceGroupName string, labName string, name string, detachDataDiskProperties dtl.DetachDataDiskProperties) (result dtl.VirtualMachinesDetachDataDiskFuture, err error)
	Get(ctx context.Context, resourceGroupName string, labName string, name string, expand string) (result dtl.LabVirtualMachine, err error)
	List(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationLabVirtualMachinePage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationLabVirtualMachineIterator, err error)
	ListApplicableSchedules(ctx context.Context, resourceGroupName string, labName string, name string) (result dtl.ApplicableSchedule, err error)
	Start(ctx context.Context, resourceGroupName string, labName string, name string) (result dtl.VirtualMachinesStartFuture, err error)
	Stop(ctx context.Context, resourceGroupName string, labName string, name string) (result dtl.VirtualMachinesStopFuture, err error)
	Update(ctx context.Context, resourceGroupName string, labName string, name string, labVirtualMachine dtl.LabVirtualMachineFragment) (result dtl.LabVirtualMachine, err error)
}

var _ VirtualMachinesClientAPI = (*dtl.VirtualMachinesClient)(nil)

// VirtualMachineSchedulesClientAPI contains the set of methods on the VirtualMachineSchedulesClient type.
type VirtualMachineSchedulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string, name string, schedule dtl.Schedule) (result dtl.Schedule, err error)
	Delete(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string, name string) (result autorest.Response, err error)
	Execute(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string, name string) (result dtl.VirtualMachineSchedulesExecuteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string, name string, expand string) (result dtl.Schedule, err error)
	List(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationSchedulePage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationScheduleIterator, err error)
	Update(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string, name string, schedule dtl.ScheduleFragment) (result dtl.Schedule, err error)
}

var _ VirtualMachineSchedulesClientAPI = (*dtl.VirtualMachineSchedulesClient)(nil)

// VirtualNetworksClientAPI contains the set of methods on the VirtualNetworksClient type.
type VirtualNetworksClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, labName string, name string, virtualNetwork dtl.VirtualNetwork) (result dtl.VirtualNetworksCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, labName string, name string) (result dtl.VirtualNetworksDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, labName string, name string, expand string) (result dtl.VirtualNetwork, err error)
	List(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationVirtualNetworkPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, labName string, expand string, filter string, top *int32, orderby string) (result dtl.ResponseWithContinuationVirtualNetworkIterator, err error)
	Update(ctx context.Context, resourceGroupName string, labName string, name string, virtualNetwork dtl.VirtualNetworkFragment) (result dtl.VirtualNetwork, err error)
}

var _ VirtualNetworksClientAPI = (*dtl.VirtualNetworksClient)(nil)
