// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package artifacts

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/synapse/2019-06-01-preview/artifacts"
)

type AuthenticationType = original.AuthenticationType

const (
	AuthenticationTypeAnonymous                      AuthenticationType = original.AuthenticationTypeAnonymous
	AuthenticationTypeBasic                          AuthenticationType = original.AuthenticationTypeBasic
	AuthenticationTypeClientCertificate              AuthenticationType = original.AuthenticationTypeClientCertificate
	AuthenticationTypeWebLinkedServiceTypeProperties AuthenticationType = original.AuthenticationTypeWebLinkedServiceTypeProperties
)

type AuthorizationType = original.AuthorizationType

const (
	AuthorizationTypeKey                          AuthorizationType = original.AuthorizationTypeKey
	AuthorizationTypeLinkedIntegrationRuntimeType AuthorizationType = original.AuthorizationTypeLinkedIntegrationRuntimeType
	AuthorizationTypeRBAC                         AuthorizationType = original.AuthorizationTypeRBAC
)

type AvroCompressionCodec = original.AvroCompressionCodec

const (
	Bzip2   AvroCompressionCodec = original.Bzip2
	Deflate AvroCompressionCodec = original.Deflate
	None    AvroCompressionCodec = original.None
	Snappy  AvroCompressionCodec = original.Snappy
	Xz      AvroCompressionCodec = original.Xz
)

type AzureFunctionActivityMethod = original.AzureFunctionActivityMethod

const (
	DELETE  AzureFunctionActivityMethod = original.DELETE
	GET     AzureFunctionActivityMethod = original.GET
	HEAD    AzureFunctionActivityMethod = original.HEAD
	OPTIONS AzureFunctionActivityMethod = original.OPTIONS
	POST    AzureFunctionActivityMethod = original.POST
	PUT     AzureFunctionActivityMethod = original.PUT
	TRACE   AzureFunctionActivityMethod = original.TRACE
)

type AzureSearchIndexWriteBehaviorType = original.AzureSearchIndexWriteBehaviorType

const (
	Merge  AzureSearchIndexWriteBehaviorType = original.Merge
	Upload AzureSearchIndexWriteBehaviorType = original.Upload
)

type BlobEventTypes = original.BlobEventTypes

const (
	MicrosoftStorageBlobCreated BlobEventTypes = original.MicrosoftStorageBlobCreated
	MicrosoftStorageBlobDeleted BlobEventTypes = original.MicrosoftStorageBlobDeleted
)

type CassandraSourceReadConsistencyLevels = original.CassandraSourceReadConsistencyLevels

const (
	ALL         CassandraSourceReadConsistencyLevels = original.ALL
	EACHQUORUM  CassandraSourceReadConsistencyLevels = original.EACHQUORUM
	LOCALONE    CassandraSourceReadConsistencyLevels = original.LOCALONE
	LOCALQUORUM CassandraSourceReadConsistencyLevels = original.LOCALQUORUM
	LOCALSERIAL CassandraSourceReadConsistencyLevels = original.LOCALSERIAL
	ONE         CassandraSourceReadConsistencyLevels = original.ONE
	QUORUM      CassandraSourceReadConsistencyLevels = original.QUORUM
	SERIAL      CassandraSourceReadConsistencyLevels = original.SERIAL
	THREE       CassandraSourceReadConsistencyLevels = original.THREE
	TWO         CassandraSourceReadConsistencyLevels = original.TWO
)

type CellOutputType = original.CellOutputType

const (
	DisplayData   CellOutputType = original.DisplayData
	Error         CellOutputType = original.Error
	ExecuteResult CellOutputType = original.ExecuteResult
	Stream        CellOutputType = original.Stream
)

type CopyBehaviorType = original.CopyBehaviorType

const (
	FlattenHierarchy  CopyBehaviorType = original.FlattenHierarchy
	MergeFiles        CopyBehaviorType = original.MergeFiles
	PreserveHierarchy CopyBehaviorType = original.PreserveHierarchy
)

type DataFlowComputeType = original.DataFlowComputeType

const (
	ComputeOptimized DataFlowComputeType = original.ComputeOptimized
	General          DataFlowComputeType = original.General
	MemoryOptimized  DataFlowComputeType = original.MemoryOptimized
)

type DatasetCompressionLevel = original.DatasetCompressionLevel

const (
	Fastest DatasetCompressionLevel = original.Fastest
	Optimal DatasetCompressionLevel = original.Optimal
)

type DayOfWeek = original.DayOfWeek

const (
	Friday    DayOfWeek = original.Friday
	Monday    DayOfWeek = original.Monday
	Saturday  DayOfWeek = original.Saturday
	Sunday    DayOfWeek = original.Sunday
	Thursday  DayOfWeek = original.Thursday
	Tuesday   DayOfWeek = original.Tuesday
	Wednesday DayOfWeek = original.Wednesday
)

type Db2AuthenticationType = original.Db2AuthenticationType

const (
	Basic Db2AuthenticationType = original.Basic
)

type DelimitedTextCompressionCodec = original.DelimitedTextCompressionCodec

const (
	DelimitedTextCompressionCodecBzip2      DelimitedTextCompressionCodec = original.DelimitedTextCompressionCodecBzip2
	DelimitedTextCompressionCodecDeflate    DelimitedTextCompressionCodec = original.DelimitedTextCompressionCodecDeflate
	DelimitedTextCompressionCodecGzip       DelimitedTextCompressionCodec = original.DelimitedTextCompressionCodecGzip
	DelimitedTextCompressionCodecLz4        DelimitedTextCompressionCodec = original.DelimitedTextCompressionCodecLz4
	DelimitedTextCompressionCodecSnappy     DelimitedTextCompressionCodec = original.DelimitedTextCompressionCodecSnappy
	DelimitedTextCompressionCodecZipDeflate DelimitedTextCompressionCodec = original.DelimitedTextCompressionCodecZipDeflate
)

type DependencyCondition = original.DependencyCondition

const (
	Completed DependencyCondition = original.Completed
	Failed    DependencyCondition = original.Failed
	Skipped   DependencyCondition = original.Skipped
	Succeeded DependencyCondition = original.Succeeded
)

type DynamicsAuthenticationType = original.DynamicsAuthenticationType

const (
	AADServicePrincipal DynamicsAuthenticationType = original.AADServicePrincipal
	Ifd                 DynamicsAuthenticationType = original.Ifd
	Office365           DynamicsAuthenticationType = original.Office365
)

type DynamicsDeploymentType = original.DynamicsDeploymentType

const (
	Online            DynamicsDeploymentType = original.Online
	OnPremisesWithIfd DynamicsDeploymentType = original.OnPremisesWithIfd
)

type DynamicsServicePrincipalCredentialType = original.DynamicsServicePrincipalCredentialType

const (
	ServicePrincipalCert DynamicsServicePrincipalCredentialType = original.ServicePrincipalCert
	ServicePrincipalKey  DynamicsServicePrincipalCredentialType = original.ServicePrincipalKey
)

type EventSubscriptionStatus = original.EventSubscriptionStatus

const (
	Deprovisioning EventSubscriptionStatus = original.Deprovisioning
	Disabled       EventSubscriptionStatus = original.Disabled
	Enabled        EventSubscriptionStatus = original.Enabled
	Provisioning   EventSubscriptionStatus = original.Provisioning
	Unknown        EventSubscriptionStatus = original.Unknown
)

type FtpAuthenticationType = original.FtpAuthenticationType

const (
	FtpAuthenticationTypeAnonymous FtpAuthenticationType = original.FtpAuthenticationTypeAnonymous
	FtpAuthenticationTypeBasic     FtpAuthenticationType = original.FtpAuthenticationTypeBasic
)

type GoogleAdWordsAuthenticationType = original.GoogleAdWordsAuthenticationType

const (
	ServiceAuthentication GoogleAdWordsAuthenticationType = original.ServiceAuthentication
	UserAuthentication    GoogleAdWordsAuthenticationType = original.UserAuthentication
)

type GoogleBigQueryAuthenticationType = original.GoogleBigQueryAuthenticationType

const (
	GoogleBigQueryAuthenticationTypeServiceAuthentication GoogleBigQueryAuthenticationType = original.GoogleBigQueryAuthenticationTypeServiceAuthentication
	GoogleBigQueryAuthenticationTypeUserAuthentication    GoogleBigQueryAuthenticationType = original.GoogleBigQueryAuthenticationTypeUserAuthentication
)

type HBaseAuthenticationType = original.HBaseAuthenticationType

const (
	HBaseAuthenticationTypeAnonymous HBaseAuthenticationType = original.HBaseAuthenticationTypeAnonymous
	HBaseAuthenticationTypeBasic     HBaseAuthenticationType = original.HBaseAuthenticationTypeBasic
)

type HDInsightActivityDebugInfoOption = original.HDInsightActivityDebugInfoOption

const (
	HDInsightActivityDebugInfoOptionAlways  HDInsightActivityDebugInfoOption = original.HDInsightActivityDebugInfoOptionAlways
	HDInsightActivityDebugInfoOptionFailure HDInsightActivityDebugInfoOption = original.HDInsightActivityDebugInfoOptionFailure
	HDInsightActivityDebugInfoOptionNone    HDInsightActivityDebugInfoOption = original.HDInsightActivityDebugInfoOptionNone
)

type HTTPAuthenticationType = original.HTTPAuthenticationType

const (
	HTTPAuthenticationTypeAnonymous         HTTPAuthenticationType = original.HTTPAuthenticationTypeAnonymous
	HTTPAuthenticationTypeBasic             HTTPAuthenticationType = original.HTTPAuthenticationTypeBasic
	HTTPAuthenticationTypeClientCertificate HTTPAuthenticationType = original.HTTPAuthenticationTypeClientCertificate
	HTTPAuthenticationTypeDigest            HTTPAuthenticationType = original.HTTPAuthenticationTypeDigest
	HTTPAuthenticationTypeWindows           HTTPAuthenticationType = original.HTTPAuthenticationTypeWindows
)

type HdiNodeTypes = original.HdiNodeTypes

const (
	Headnode   HdiNodeTypes = original.Headnode
	Workernode HdiNodeTypes = original.Workernode
	Zookeeper  HdiNodeTypes = original.Zookeeper
)

type HiveAuthenticationType = original.HiveAuthenticationType

const (
	Anonymous                    HiveAuthenticationType = original.Anonymous
	Username                     HiveAuthenticationType = original.Username
	UsernameAndPassword          HiveAuthenticationType = original.UsernameAndPassword
	WindowsAzureHDInsightService HiveAuthenticationType = original.WindowsAzureHDInsightService
)

type HiveServerType = original.HiveServerType

const (
	HiveServer1      HiveServerType = original.HiveServer1
	HiveServer2      HiveServerType = original.HiveServer2
	HiveThriftServer HiveServerType = original.HiveThriftServer
)

type HiveThriftTransportProtocol = original.HiveThriftTransportProtocol

const (
	Binary HiveThriftTransportProtocol = original.Binary
	HTTP   HiveThriftTransportProtocol = original.HTTP
	SASL   HiveThriftTransportProtocol = original.SASL
)

type ImpalaAuthenticationType = original.ImpalaAuthenticationType

const (
	ImpalaAuthenticationTypeAnonymous           ImpalaAuthenticationType = original.ImpalaAuthenticationTypeAnonymous
	ImpalaAuthenticationTypeSASLUsername        ImpalaAuthenticationType = original.ImpalaAuthenticationTypeSASLUsername
	ImpalaAuthenticationTypeUsernameAndPassword ImpalaAuthenticationType = original.ImpalaAuthenticationTypeUsernameAndPassword
)

type IntegrationRuntimeEdition = original.IntegrationRuntimeEdition

const (
	Enterprise IntegrationRuntimeEdition = original.Enterprise
	Standard   IntegrationRuntimeEdition = original.Standard
)

type IntegrationRuntimeEntityReferenceType = original.IntegrationRuntimeEntityReferenceType

const (
	IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference IntegrationRuntimeEntityReferenceType = original.IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference
	IntegrationRuntimeEntityReferenceTypeLinkedServiceReference      IntegrationRuntimeEntityReferenceType = original.IntegrationRuntimeEntityReferenceTypeLinkedServiceReference
)

type IntegrationRuntimeLicenseType = original.IntegrationRuntimeLicenseType

const (
	BasePrice       IntegrationRuntimeLicenseType = original.BasePrice
	LicenseIncluded IntegrationRuntimeLicenseType = original.LicenseIncluded
)

type IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTier

const (
	IntegrationRuntimeSsisCatalogPricingTierBasic     IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTierBasic
	IntegrationRuntimeSsisCatalogPricingTierPremium   IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTierPremium
	IntegrationRuntimeSsisCatalogPricingTierPremiumRS IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTierPremiumRS
	IntegrationRuntimeSsisCatalogPricingTierStandard  IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTierStandard
)

type IntegrationRuntimeState = original.IntegrationRuntimeState

const (
	IntegrationRuntimeStateAccessDenied     IntegrationRuntimeState = original.IntegrationRuntimeStateAccessDenied
	IntegrationRuntimeStateInitial          IntegrationRuntimeState = original.IntegrationRuntimeStateInitial
	IntegrationRuntimeStateLimited          IntegrationRuntimeState = original.IntegrationRuntimeStateLimited
	IntegrationRuntimeStateNeedRegistration IntegrationRuntimeState = original.IntegrationRuntimeStateNeedRegistration
	IntegrationRuntimeStateOffline          IntegrationRuntimeState = original.IntegrationRuntimeStateOffline
	IntegrationRuntimeStateOnline           IntegrationRuntimeState = original.IntegrationRuntimeStateOnline
	IntegrationRuntimeStateStarted          IntegrationRuntimeState = original.IntegrationRuntimeStateStarted
	IntegrationRuntimeStateStarting         IntegrationRuntimeState = original.IntegrationRuntimeStateStarting
	IntegrationRuntimeStateStopped          IntegrationRuntimeState = original.IntegrationRuntimeStateStopped
	IntegrationRuntimeStateStopping         IntegrationRuntimeState = original.IntegrationRuntimeStateStopping
)

type IntegrationRuntimeType = original.IntegrationRuntimeType

const (
	Managed    IntegrationRuntimeType = original.Managed
	SelfHosted IntegrationRuntimeType = original.SelfHosted
)

type JSONFormatFilePattern = original.JSONFormatFilePattern

const (
	ArrayOfObjects JSONFormatFilePattern = original.ArrayOfObjects
	SetOfObjects   JSONFormatFilePattern = original.SetOfObjects
)

type JSONWriteFilePattern = original.JSONWriteFilePattern

const (
	JSONWriteFilePatternArrayOfObjects JSONWriteFilePattern = original.JSONWriteFilePatternArrayOfObjects
	JSONWriteFilePatternSetOfObjects   JSONWriteFilePattern = original.JSONWriteFilePatternSetOfObjects
)

type MongoDbAuthenticationType = original.MongoDbAuthenticationType

const (
	MongoDbAuthenticationTypeAnonymous MongoDbAuthenticationType = original.MongoDbAuthenticationTypeAnonymous
	MongoDbAuthenticationTypeBasic     MongoDbAuthenticationType = original.MongoDbAuthenticationTypeBasic
)

type NetezzaPartitionOption = original.NetezzaPartitionOption

const (
	NetezzaPartitionOptionDataSlice    NetezzaPartitionOption = original.NetezzaPartitionOptionDataSlice
	NetezzaPartitionOptionDynamicRange NetezzaPartitionOption = original.NetezzaPartitionOptionDynamicRange
	NetezzaPartitionOptionNone         NetezzaPartitionOption = original.NetezzaPartitionOptionNone
)

type NodeSize = original.NodeSize

const (
	NodeSizeLarge    NodeSize = original.NodeSizeLarge
	NodeSizeMedium   NodeSize = original.NodeSizeMedium
	NodeSizeNone     NodeSize = original.NodeSizeNone
	NodeSizeSmall    NodeSize = original.NodeSizeSmall
	NodeSizeXLarge   NodeSize = original.NodeSizeXLarge
	NodeSizeXXLarge  NodeSize = original.NodeSizeXXLarge
	NodeSizeXXXLarge NodeSize = original.NodeSizeXXXLarge
)

type NodeSizeFamily = original.NodeSizeFamily

const (
	NodeSizeFamilyMemoryOptimized NodeSizeFamily = original.NodeSizeFamilyMemoryOptimized
	NodeSizeFamilyNone            NodeSizeFamily = original.NodeSizeFamilyNone
)

type ODataAadServicePrincipalCredentialType = original.ODataAadServicePrincipalCredentialType

const (
	ODataAadServicePrincipalCredentialTypeServicePrincipalCert ODataAadServicePrincipalCredentialType = original.ODataAadServicePrincipalCredentialTypeServicePrincipalCert
	ODataAadServicePrincipalCredentialTypeServicePrincipalKey  ODataAadServicePrincipalCredentialType = original.ODataAadServicePrincipalCredentialTypeServicePrincipalKey
)

type ODataAuthenticationType = original.ODataAuthenticationType

const (
	ODataAuthenticationTypeAadServicePrincipal    ODataAuthenticationType = original.ODataAuthenticationTypeAadServicePrincipal
	ODataAuthenticationTypeAnonymous              ODataAuthenticationType = original.ODataAuthenticationTypeAnonymous
	ODataAuthenticationTypeBasic                  ODataAuthenticationType = original.ODataAuthenticationTypeBasic
	ODataAuthenticationTypeManagedServiceIdentity ODataAuthenticationType = original.ODataAuthenticationTypeManagedServiceIdentity
	ODataAuthenticationTypeWindows                ODataAuthenticationType = original.ODataAuthenticationTypeWindows
)

type OraclePartitionOption = original.OraclePartitionOption

const (
	OraclePartitionOptionDynamicRange              OraclePartitionOption = original.OraclePartitionOptionDynamicRange
	OraclePartitionOptionNone                      OraclePartitionOption = original.OraclePartitionOptionNone
	OraclePartitionOptionPhysicalPartitionsOfTable OraclePartitionOption = original.OraclePartitionOptionPhysicalPartitionsOfTable
)

type OrcCompressionCodec = original.OrcCompressionCodec

const (
	OrcCompressionCodecNone   OrcCompressionCodec = original.OrcCompressionCodecNone
	OrcCompressionCodecSnappy OrcCompressionCodec = original.OrcCompressionCodecSnappy
	OrcCompressionCodecZlib   OrcCompressionCodec = original.OrcCompressionCodecZlib
)

type ParameterType = original.ParameterType

const (
	ParameterTypeArray        ParameterType = original.ParameterTypeArray
	ParameterTypeBool         ParameterType = original.ParameterTypeBool
	ParameterTypeFloat        ParameterType = original.ParameterTypeFloat
	ParameterTypeInt          ParameterType = original.ParameterTypeInt
	ParameterTypeObject       ParameterType = original.ParameterTypeObject
	ParameterTypeSecureString ParameterType = original.ParameterTypeSecureString
	ParameterTypeString       ParameterType = original.ParameterTypeString
)

type ParquetCompressionCodec = original.ParquetCompressionCodec

const (
	ParquetCompressionCodecGzip   ParquetCompressionCodec = original.ParquetCompressionCodecGzip
	ParquetCompressionCodecLzo    ParquetCompressionCodec = original.ParquetCompressionCodecLzo
	ParquetCompressionCodecNone   ParquetCompressionCodec = original.ParquetCompressionCodecNone
	ParquetCompressionCodecSnappy ParquetCompressionCodec = original.ParquetCompressionCodecSnappy
)

type PhoenixAuthenticationType = original.PhoenixAuthenticationType

const (
	PhoenixAuthenticationTypeAnonymous                    PhoenixAuthenticationType = original.PhoenixAuthenticationTypeAnonymous
	PhoenixAuthenticationTypeUsernameAndPassword          PhoenixAuthenticationType = original.PhoenixAuthenticationTypeUsernameAndPassword
	PhoenixAuthenticationTypeWindowsAzureHDInsightService PhoenixAuthenticationType = original.PhoenixAuthenticationTypeWindowsAzureHDInsightService
)

type PluginCurrentState = original.PluginCurrentState

const (
	Cleanup             PluginCurrentState = original.Cleanup
	Ended               PluginCurrentState = original.Ended
	Monitoring          PluginCurrentState = original.Monitoring
	Preparation         PluginCurrentState = original.Preparation
	Queued              PluginCurrentState = original.Queued
	ResourceAcquisition PluginCurrentState = original.ResourceAcquisition
	Submission          PluginCurrentState = original.Submission
)

type PolybaseSettingsRejectType = original.PolybaseSettingsRejectType

const (
	Percentage PolybaseSettingsRejectType = original.Percentage
	Value      PolybaseSettingsRejectType = original.Value
)

type PrestoAuthenticationType = original.PrestoAuthenticationType

const (
	PrestoAuthenticationTypeAnonymous PrestoAuthenticationType = original.PrestoAuthenticationTypeAnonymous
	PrestoAuthenticationTypeLDAP      PrestoAuthenticationType = original.PrestoAuthenticationTypeLDAP
)

type RecurrenceFrequency = original.RecurrenceFrequency

const (
	Day          RecurrenceFrequency = original.Day
	Hour         RecurrenceFrequency = original.Hour
	Minute       RecurrenceFrequency = original.Minute
	Month        RecurrenceFrequency = original.Month
	NotSpecified RecurrenceFrequency = original.NotSpecified
	Week         RecurrenceFrequency = original.Week
	Year         RecurrenceFrequency = original.Year
)

type ResourceIdentityType = original.ResourceIdentityType

const (
	ResourceIdentityTypeNone           ResourceIdentityType = original.ResourceIdentityTypeNone
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = original.ResourceIdentityTypeSystemAssigned
)

type RestServiceAuthenticationType = original.RestServiceAuthenticationType

const (
	RestServiceAuthenticationTypeAadServicePrincipal    RestServiceAuthenticationType = original.RestServiceAuthenticationTypeAadServicePrincipal
	RestServiceAuthenticationTypeAnonymous              RestServiceAuthenticationType = original.RestServiceAuthenticationTypeAnonymous
	RestServiceAuthenticationTypeBasic                  RestServiceAuthenticationType = original.RestServiceAuthenticationTypeBasic
	RestServiceAuthenticationTypeManagedServiceIdentity RestServiceAuthenticationType = original.RestServiceAuthenticationTypeManagedServiceIdentity
)

type RunQueryFilterOperand = original.RunQueryFilterOperand

const (
	ActivityName        RunQueryFilterOperand = original.ActivityName
	ActivityRunEnd      RunQueryFilterOperand = original.ActivityRunEnd
	ActivityRunStart    RunQueryFilterOperand = original.ActivityRunStart
	ActivityType        RunQueryFilterOperand = original.ActivityType
	LatestOnly          RunQueryFilterOperand = original.LatestOnly
	PipelineName        RunQueryFilterOperand = original.PipelineName
	RunEnd              RunQueryFilterOperand = original.RunEnd
	RunGroupID          RunQueryFilterOperand = original.RunGroupID
	RunStart            RunQueryFilterOperand = original.RunStart
	Status              RunQueryFilterOperand = original.Status
	TriggerName         RunQueryFilterOperand = original.TriggerName
	TriggerRunTimestamp RunQueryFilterOperand = original.TriggerRunTimestamp
)

type RunQueryFilterOperator = original.RunQueryFilterOperator

const (
	Equals    RunQueryFilterOperator = original.Equals
	In        RunQueryFilterOperator = original.In
	NotEquals RunQueryFilterOperator = original.NotEquals
	NotIn     RunQueryFilterOperator = original.NotIn
)

type RunQueryOrder = original.RunQueryOrder

const (
	ASC  RunQueryOrder = original.ASC
	DESC RunQueryOrder = original.DESC
)

type RunQueryOrderByField = original.RunQueryOrderByField

const (
	RunQueryOrderByFieldActivityName        RunQueryOrderByField = original.RunQueryOrderByFieldActivityName
	RunQueryOrderByFieldActivityRunEnd      RunQueryOrderByField = original.RunQueryOrderByFieldActivityRunEnd
	RunQueryOrderByFieldActivityRunStart    RunQueryOrderByField = original.RunQueryOrderByFieldActivityRunStart
	RunQueryOrderByFieldPipelineName        RunQueryOrderByField = original.RunQueryOrderByFieldPipelineName
	RunQueryOrderByFieldRunEnd              RunQueryOrderByField = original.RunQueryOrderByFieldRunEnd
	RunQueryOrderByFieldRunStart            RunQueryOrderByField = original.RunQueryOrderByFieldRunStart
	RunQueryOrderByFieldStatus              RunQueryOrderByField = original.RunQueryOrderByFieldStatus
	RunQueryOrderByFieldTriggerName         RunQueryOrderByField = original.RunQueryOrderByFieldTriggerName
	RunQueryOrderByFieldTriggerRunTimestamp RunQueryOrderByField = original.RunQueryOrderByFieldTriggerRunTimestamp
)

type SQLConnectionType = original.SQLConnectionType

const (
	SQLConnectionTypeSQLOnDemand SQLConnectionType = original.SQLConnectionTypeSQLOnDemand
	SQLConnectionTypeSQLPool     SQLConnectionType = original.SQLConnectionTypeSQLPool
)

type SQLScriptType = original.SQLScriptType

const (
	SQLQuery SQLScriptType = original.SQLQuery
)

type SalesforceSinkWriteBehavior = original.SalesforceSinkWriteBehavior

const (
	Insert SalesforceSinkWriteBehavior = original.Insert
	Upsert SalesforceSinkWriteBehavior = original.Upsert
)

type SalesforceSourceReadBehavior = original.SalesforceSourceReadBehavior

const (
	Query    SalesforceSourceReadBehavior = original.Query
	QueryAll SalesforceSourceReadBehavior = original.QueryAll
)

type SapCloudForCustomerSinkWriteBehavior = original.SapCloudForCustomerSinkWriteBehavior

const (
	SapCloudForCustomerSinkWriteBehaviorInsert SapCloudForCustomerSinkWriteBehavior = original.SapCloudForCustomerSinkWriteBehaviorInsert
	SapCloudForCustomerSinkWriteBehaviorUpdate SapCloudForCustomerSinkWriteBehavior = original.SapCloudForCustomerSinkWriteBehaviorUpdate
)

type SapHanaAuthenticationType = original.SapHanaAuthenticationType

const (
	SapHanaAuthenticationTypeBasic   SapHanaAuthenticationType = original.SapHanaAuthenticationTypeBasic
	SapHanaAuthenticationTypeWindows SapHanaAuthenticationType = original.SapHanaAuthenticationTypeWindows
)

type SapHanaPartitionOption = original.SapHanaPartitionOption

const (
	SapHanaPartitionOptionNone                      SapHanaPartitionOption = original.SapHanaPartitionOptionNone
	SapHanaPartitionOptionPhysicalPartitionsOfTable SapHanaPartitionOption = original.SapHanaPartitionOptionPhysicalPartitionsOfTable
	SapHanaPartitionOptionSapHanaDynamicRange       SapHanaPartitionOption = original.SapHanaPartitionOptionSapHanaDynamicRange
)

type SapTablePartitionOption = original.SapTablePartitionOption

const (
	SapTablePartitionOptionNone                     SapTablePartitionOption = original.SapTablePartitionOptionNone
	SapTablePartitionOptionPartitionOnCalendarDate  SapTablePartitionOption = original.SapTablePartitionOptionPartitionOnCalendarDate
	SapTablePartitionOptionPartitionOnCalendarMonth SapTablePartitionOption = original.SapTablePartitionOptionPartitionOnCalendarMonth
	SapTablePartitionOptionPartitionOnCalendarYear  SapTablePartitionOption = original.SapTablePartitionOptionPartitionOnCalendarYear
	SapTablePartitionOptionPartitionOnInt           SapTablePartitionOption = original.SapTablePartitionOptionPartitionOnInt
	SapTablePartitionOptionPartitionOnTime          SapTablePartitionOption = original.SapTablePartitionOptionPartitionOnTime
)

type SchedulerCurrentState = original.SchedulerCurrentState

const (
	SchedulerCurrentStateEnded     SchedulerCurrentState = original.SchedulerCurrentStateEnded
	SchedulerCurrentStateQueued    SchedulerCurrentState = original.SchedulerCurrentStateQueued
	SchedulerCurrentStateScheduled SchedulerCurrentState = original.SchedulerCurrentStateScheduled
)

type ServiceNowAuthenticationType = original.ServiceNowAuthenticationType

const (
	ServiceNowAuthenticationTypeBasic  ServiceNowAuthenticationType = original.ServiceNowAuthenticationTypeBasic
	ServiceNowAuthenticationTypeOAuth2 ServiceNowAuthenticationType = original.ServiceNowAuthenticationTypeOAuth2
)

type SftpAuthenticationType = original.SftpAuthenticationType

const (
	SftpAuthenticationTypeBasic        SftpAuthenticationType = original.SftpAuthenticationTypeBasic
	SftpAuthenticationTypeSSHPublicKey SftpAuthenticationType = original.SftpAuthenticationTypeSSHPublicKey
)

type SparkAuthenticationType = original.SparkAuthenticationType

const (
	SparkAuthenticationTypeAnonymous                    SparkAuthenticationType = original.SparkAuthenticationTypeAnonymous
	SparkAuthenticationTypeUsername                     SparkAuthenticationType = original.SparkAuthenticationTypeUsername
	SparkAuthenticationTypeUsernameAndPassword          SparkAuthenticationType = original.SparkAuthenticationTypeUsernameAndPassword
	SparkAuthenticationTypeWindowsAzureHDInsightService SparkAuthenticationType = original.SparkAuthenticationTypeWindowsAzureHDInsightService
)

type SparkBatchJobResultType = original.SparkBatchJobResultType

const (
	SparkBatchJobResultTypeCancelled SparkBatchJobResultType = original.SparkBatchJobResultTypeCancelled
	SparkBatchJobResultTypeFailed    SparkBatchJobResultType = original.SparkBatchJobResultTypeFailed
	SparkBatchJobResultTypeSucceeded SparkBatchJobResultType = original.SparkBatchJobResultTypeSucceeded
	SparkBatchJobResultTypeUncertain SparkBatchJobResultType = original.SparkBatchJobResultTypeUncertain
)

type SparkErrorSource = original.SparkErrorSource

const (
	SparkErrorSourceDependency SparkErrorSource = original.SparkErrorSourceDependency
	SparkErrorSourceSystem     SparkErrorSource = original.SparkErrorSourceSystem
	SparkErrorSourceUnknown    SparkErrorSource = original.SparkErrorSourceUnknown
	SparkErrorSourceUser       SparkErrorSource = original.SparkErrorSourceUser
)

type SparkJobType = original.SparkJobType

const (
	SparkBatch   SparkJobType = original.SparkBatch
	SparkSession SparkJobType = original.SparkSession
)

type SparkServerType = original.SparkServerType

const (
	SharkServer       SparkServerType = original.SharkServer
	SharkServer2      SparkServerType = original.SharkServer2
	SparkThriftServer SparkServerType = original.SparkThriftServer
)

type SparkThriftTransportProtocol = original.SparkThriftTransportProtocol

const (
	SparkThriftTransportProtocolBinary SparkThriftTransportProtocol = original.SparkThriftTransportProtocolBinary
	SparkThriftTransportProtocolHTTP   SparkThriftTransportProtocol = original.SparkThriftTransportProtocolHTTP
	SparkThriftTransportProtocolSASL   SparkThriftTransportProtocol = original.SparkThriftTransportProtocolSASL
)

type SsisPackageLocationType = original.SsisPackageLocationType

const (
	File          SsisPackageLocationType = original.File
	InlinePackage SsisPackageLocationType = original.InlinePackage
	SSISDB        SsisPackageLocationType = original.SSISDB
)

type StoredProcedureParameterType = original.StoredProcedureParameterType

const (
	Boolean StoredProcedureParameterType = original.Boolean
	Date    StoredProcedureParameterType = original.Date
	Decimal StoredProcedureParameterType = original.Decimal
	GUID    StoredProcedureParameterType = original.GUID
	Int     StoredProcedureParameterType = original.Int
	Int64   StoredProcedureParameterType = original.Int64
	String  StoredProcedureParameterType = original.String
)

type SybaseAuthenticationType = original.SybaseAuthenticationType

const (
	SybaseAuthenticationTypeBasic   SybaseAuthenticationType = original.SybaseAuthenticationTypeBasic
	SybaseAuthenticationTypeWindows SybaseAuthenticationType = original.SybaseAuthenticationTypeWindows
)

type TeradataAuthenticationType = original.TeradataAuthenticationType

const (
	TeradataAuthenticationTypeBasic   TeradataAuthenticationType = original.TeradataAuthenticationTypeBasic
	TeradataAuthenticationTypeWindows TeradataAuthenticationType = original.TeradataAuthenticationTypeWindows
)

type TeradataPartitionOption = original.TeradataPartitionOption

const (
	TeradataPartitionOptionDynamicRange TeradataPartitionOption = original.TeradataPartitionOptionDynamicRange
	TeradataPartitionOptionHash         TeradataPartitionOption = original.TeradataPartitionOptionHash
	TeradataPartitionOptionNone         TeradataPartitionOption = original.TeradataPartitionOptionNone
)

type TriggerRunStatus = original.TriggerRunStatus

const (
	TriggerRunStatusFailed     TriggerRunStatus = original.TriggerRunStatusFailed
	TriggerRunStatusInprogress TriggerRunStatus = original.TriggerRunStatusInprogress
	TriggerRunStatusSucceeded  TriggerRunStatus = original.TriggerRunStatusSucceeded
)

type TriggerRuntimeState = original.TriggerRuntimeState

const (
	TriggerRuntimeStateDisabled TriggerRuntimeState = original.TriggerRuntimeStateDisabled
	TriggerRuntimeStateStarted  TriggerRuntimeState = original.TriggerRuntimeStateStarted
	TriggerRuntimeStateStopped  TriggerRuntimeState = original.TriggerRuntimeStateStopped
)

type TumblingWindowFrequency = original.TumblingWindowFrequency

const (
	TumblingWindowFrequencyHour   TumblingWindowFrequency = original.TumblingWindowFrequencyHour
	TumblingWindowFrequencyMinute TumblingWindowFrequency = original.TumblingWindowFrequencyMinute
)

type Type = original.Type

const (
	TypeAzureKeyVaultSecret Type = original.TypeAzureKeyVaultSecret
	TypeSecretBase          Type = original.TypeSecretBase
	TypeSecureString        Type = original.TypeSecureString
)

type TypeBasicActivity = original.TypeBasicActivity

const (
	TypeActivity                 TypeBasicActivity = original.TypeActivity
	TypeAppendVariable           TypeBasicActivity = original.TypeAppendVariable
	TypeAzureDataExplorerCommand TypeBasicActivity = original.TypeAzureDataExplorerCommand
	TypeAzureFunctionActivity    TypeBasicActivity = original.TypeAzureFunctionActivity
	TypeAzureMLBatchExecution    TypeBasicActivity = original.TypeAzureMLBatchExecution
	TypeAzureMLExecutePipeline   TypeBasicActivity = original.TypeAzureMLExecutePipeline
	TypeAzureMLUpdateResource    TypeBasicActivity = original.TypeAzureMLUpdateResource
	TypeContainer                TypeBasicActivity = original.TypeContainer
	TypeCopy                     TypeBasicActivity = original.TypeCopy
	TypeCustom                   TypeBasicActivity = original.TypeCustom
	TypeDatabricksNotebook       TypeBasicActivity = original.TypeDatabricksNotebook
	TypeDatabricksSparkJar       TypeBasicActivity = original.TypeDatabricksSparkJar
	TypeDatabricksSparkPython    TypeBasicActivity = original.TypeDatabricksSparkPython
	TypeDataLakeAnalyticsUSQL    TypeBasicActivity = original.TypeDataLakeAnalyticsUSQL
	TypeDelete                   TypeBasicActivity = original.TypeDelete
	TypeExecuteDataFlow          TypeBasicActivity = original.TypeExecuteDataFlow
	TypeExecutePipeline          TypeBasicActivity = original.TypeExecutePipeline
	TypeExecuteSSISPackage       TypeBasicActivity = original.TypeExecuteSSISPackage
	TypeExecution                TypeBasicActivity = original.TypeExecution
	TypeFilter                   TypeBasicActivity = original.TypeFilter
	TypeForEach                  TypeBasicActivity = original.TypeForEach
	TypeGetMetadata              TypeBasicActivity = original.TypeGetMetadata
	TypeHDInsightHive            TypeBasicActivity = original.TypeHDInsightHive
	TypeHDInsightMapReduce       TypeBasicActivity = original.TypeHDInsightMapReduce
	TypeHDInsightPig             TypeBasicActivity = original.TypeHDInsightPig
	TypeHDInsightSpark           TypeBasicActivity = original.TypeHDInsightSpark
	TypeHDInsightStreaming       TypeBasicActivity = original.TypeHDInsightStreaming
	TypeIfCondition              TypeBasicActivity = original.TypeIfCondition
	TypeLookup                   TypeBasicActivity = original.TypeLookup
	TypeSetVariable              TypeBasicActivity = original.TypeSetVariable
	TypeSparkJob                 TypeBasicActivity = original.TypeSparkJob
	TypeSQLPoolStoredProcedure   TypeBasicActivity = original.TypeSQLPoolStoredProcedure
	TypeSQLServerStoredProcedure TypeBasicActivity = original.TypeSQLServerStoredProcedure
	TypeSwitch                   TypeBasicActivity = original.TypeSwitch
	TypeSynapseNotebook          TypeBasicActivity = original.TypeSynapseNotebook
	TypeUntil                    TypeBasicActivity = original.TypeUntil
	TypeValidation               TypeBasicActivity = original.TypeValidation
	TypeWait                     TypeBasicActivity = original.TypeWait
	TypeWebActivity              TypeBasicActivity = original.TypeWebActivity
	TypeWebHook                  TypeBasicActivity = original.TypeWebHook
)

type TypeBasicCopySink = original.TypeBasicCopySink

const (
	TypeAvroSink                     TypeBasicCopySink = original.TypeAvroSink
	TypeAzureBlobFSSink              TypeBasicCopySink = original.TypeAzureBlobFSSink
	TypeAzureDataExplorerSink        TypeBasicCopySink = original.TypeAzureDataExplorerSink
	TypeAzureDataLakeStoreSink       TypeBasicCopySink = original.TypeAzureDataLakeStoreSink
	TypeAzureMySQLSink               TypeBasicCopySink = original.TypeAzureMySQLSink
	TypeAzurePostgreSQLSink          TypeBasicCopySink = original.TypeAzurePostgreSQLSink
	TypeAzureQueueSink               TypeBasicCopySink = original.TypeAzureQueueSink
	TypeAzureSearchIndexSink         TypeBasicCopySink = original.TypeAzureSearchIndexSink
	TypeAzureSQLSink                 TypeBasicCopySink = original.TypeAzureSQLSink
	TypeAzureTableSink               TypeBasicCopySink = original.TypeAzureTableSink
	TypeBinarySink                   TypeBasicCopySink = original.TypeBinarySink
	TypeBlobSink                     TypeBasicCopySink = original.TypeBlobSink
	TypeCommonDataServiceForAppsSink TypeBasicCopySink = original.TypeCommonDataServiceForAppsSink
	TypeCopySink                     TypeBasicCopySink = original.TypeCopySink
	TypeCosmosDbMongoDbAPISink       TypeBasicCopySink = original.TypeCosmosDbMongoDbAPISink
	TypeCosmosDbSQLAPISink           TypeBasicCopySink = original.TypeCosmosDbSQLAPISink
	TypeDelimitedTextSink            TypeBasicCopySink = original.TypeDelimitedTextSink
	TypeDocumentDbCollectionSink     TypeBasicCopySink = original.TypeDocumentDbCollectionSink
	TypeDynamicsCrmSink              TypeBasicCopySink = original.TypeDynamicsCrmSink
	TypeDynamicsSink                 TypeBasicCopySink = original.TypeDynamicsSink
	TypeFileSystemSink               TypeBasicCopySink = original.TypeFileSystemSink
	TypeInformixSink                 TypeBasicCopySink = original.TypeInformixSink
	TypeJSONSink                     TypeBasicCopySink = original.TypeJSONSink
	TypeMicrosoftAccessSink          TypeBasicCopySink = original.TypeMicrosoftAccessSink
	TypeOdbcSink                     TypeBasicCopySink = original.TypeOdbcSink
	TypeOracleSink                   TypeBasicCopySink = original.TypeOracleSink
	TypeOrcSink                      TypeBasicCopySink = original.TypeOrcSink
	TypeParquetSink                  TypeBasicCopySink = original.TypeParquetSink
	TypeSalesforceServiceCloudSink   TypeBasicCopySink = original.TypeSalesforceServiceCloudSink
	TypeSalesforceSink               TypeBasicCopySink = original.TypeSalesforceSink
	TypeSapCloudForCustomerSink      TypeBasicCopySink = original.TypeSapCloudForCustomerSink
	TypeSQLDWSink                    TypeBasicCopySink = original.TypeSQLDWSink
	TypeSQLMISink                    TypeBasicCopySink = original.TypeSQLMISink
	TypeSQLServerSink                TypeBasicCopySink = original.TypeSQLServerSink
	TypeSQLSink                      TypeBasicCopySink = original.TypeSQLSink
)

type TypeBasicCopySource = original.TypeBasicCopySource

const (
	TypeAmazonMWSSource                TypeBasicCopySource = original.TypeAmazonMWSSource
	TypeAmazonRedshiftSource           TypeBasicCopySource = original.TypeAmazonRedshiftSource
	TypeAvroSource                     TypeBasicCopySource = original.TypeAvroSource
	TypeAzureBlobFSSource              TypeBasicCopySource = original.TypeAzureBlobFSSource
	TypeAzureDataExplorerSource        TypeBasicCopySource = original.TypeAzureDataExplorerSource
	TypeAzureDataLakeStoreSource       TypeBasicCopySource = original.TypeAzureDataLakeStoreSource
	TypeAzureMariaDBSource             TypeBasicCopySource = original.TypeAzureMariaDBSource
	TypeAzureMySQLSource               TypeBasicCopySource = original.TypeAzureMySQLSource
	TypeAzurePostgreSQLSource          TypeBasicCopySource = original.TypeAzurePostgreSQLSource
	TypeAzureSQLSource                 TypeBasicCopySource = original.TypeAzureSQLSource
	TypeAzureTableSource               TypeBasicCopySource = original.TypeAzureTableSource
	TypeBinarySource                   TypeBasicCopySource = original.TypeBinarySource
	TypeBlobSource                     TypeBasicCopySource = original.TypeBlobSource
	TypeCassandraSource                TypeBasicCopySource = original.TypeCassandraSource
	TypeCommonDataServiceForAppsSource TypeBasicCopySource = original.TypeCommonDataServiceForAppsSource
	TypeConcurSource                   TypeBasicCopySource = original.TypeConcurSource
	TypeCopySource                     TypeBasicCopySource = original.TypeCopySource
	TypeCosmosDbMongoDbAPISource       TypeBasicCopySource = original.TypeCosmosDbMongoDbAPISource
	TypeCosmosDbSQLAPISource           TypeBasicCopySource = original.TypeCosmosDbSQLAPISource
	TypeCouchbaseSource                TypeBasicCopySource = original.TypeCouchbaseSource
	TypeDb2Source                      TypeBasicCopySource = original.TypeDb2Source
	TypeDelimitedTextSource            TypeBasicCopySource = original.TypeDelimitedTextSource
	TypeDocumentDbCollectionSource     TypeBasicCopySource = original.TypeDocumentDbCollectionSource
	TypeDrillSource                    TypeBasicCopySource = original.TypeDrillSource
	TypeDynamicsAXSource               TypeBasicCopySource = original.TypeDynamicsAXSource
	TypeDynamicsCrmSource              TypeBasicCopySource = original.TypeDynamicsCrmSource
	TypeDynamicsSource                 TypeBasicCopySource = original.TypeDynamicsSource
	TypeEloquaSource                   TypeBasicCopySource = original.TypeEloquaSource
	TypeFileSystemSource               TypeBasicCopySource = original.TypeFileSystemSource
	TypeGoogleAdWordsSource            TypeBasicCopySource = original.TypeGoogleAdWordsSource
	TypeGoogleBigQuerySource           TypeBasicCopySource = original.TypeGoogleBigQuerySource
	TypeGreenplumSource                TypeBasicCopySource = original.TypeGreenplumSource
	TypeHBaseSource                    TypeBasicCopySource = original.TypeHBaseSource
	TypeHdfsSource                     TypeBasicCopySource = original.TypeHdfsSource
	TypeHiveSource                     TypeBasicCopySource = original.TypeHiveSource
	TypeHTTPSource                     TypeBasicCopySource = original.TypeHTTPSource
	TypeHubspotSource                  TypeBasicCopySource = original.TypeHubspotSource
	TypeImpalaSource                   TypeBasicCopySource = original.TypeImpalaSource
	TypeInformixSource                 TypeBasicCopySource = original.TypeInformixSource
	TypeJiraSource                     TypeBasicCopySource = original.TypeJiraSource
	TypeJSONSource                     TypeBasicCopySource = original.TypeJSONSource
	TypeMagentoSource                  TypeBasicCopySource = original.TypeMagentoSource
	TypeMariaDBSource                  TypeBasicCopySource = original.TypeMariaDBSource
	TypeMarketoSource                  TypeBasicCopySource = original.TypeMarketoSource
	TypeMicrosoftAccessSource          TypeBasicCopySource = original.TypeMicrosoftAccessSource
	TypeMongoDbSource                  TypeBasicCopySource = original.TypeMongoDbSource
	TypeMongoDbV2Source                TypeBasicCopySource = original.TypeMongoDbV2Source
	TypeMySQLSource                    TypeBasicCopySource = original.TypeMySQLSource
	TypeNetezzaSource                  TypeBasicCopySource = original.TypeNetezzaSource
	TypeODataSource                    TypeBasicCopySource = original.TypeODataSource
	TypeOdbcSource                     TypeBasicCopySource = original.TypeOdbcSource
	TypeOffice365Source                TypeBasicCopySource = original.TypeOffice365Source
	TypeOracleServiceCloudSource       TypeBasicCopySource = original.TypeOracleServiceCloudSource
	TypeOracleSource                   TypeBasicCopySource = original.TypeOracleSource
	TypeOrcSource                      TypeBasicCopySource = original.TypeOrcSource
	TypeParquetSource                  TypeBasicCopySource = original.TypeParquetSource
	TypePaypalSource                   TypeBasicCopySource = original.TypePaypalSource
	TypePhoenixSource                  TypeBasicCopySource = original.TypePhoenixSource
	TypePostgreSQLSource               TypeBasicCopySource = original.TypePostgreSQLSource
	TypePrestoSource                   TypeBasicCopySource = original.TypePrestoSource
	TypeQuickBooksSource               TypeBasicCopySource = original.TypeQuickBooksSource
	TypeRelationalSource               TypeBasicCopySource = original.TypeRelationalSource
	TypeResponsysSource                TypeBasicCopySource = original.TypeResponsysSource
	TypeRestSource                     TypeBasicCopySource = original.TypeRestSource
	TypeSalesforceMarketingCloudSource TypeBasicCopySource = original.TypeSalesforceMarketingCloudSource
	TypeSalesforceServiceCloudSource   TypeBasicCopySource = original.TypeSalesforceServiceCloudSource
	TypeSalesforceSource               TypeBasicCopySource = original.TypeSalesforceSource
	TypeSapBwSource                    TypeBasicCopySource = original.TypeSapBwSource
	TypeSapCloudForCustomerSource      TypeBasicCopySource = original.TypeSapCloudForCustomerSource
	TypeSapEccSource                   TypeBasicCopySource = original.TypeSapEccSource
	TypeSapHanaSource                  TypeBasicCopySource = original.TypeSapHanaSource
	TypeSapOpenHubSource               TypeBasicCopySource = original.TypeSapOpenHubSource
	TypeSapTableSource                 TypeBasicCopySource = original.TypeSapTableSource
	TypeServiceNowSource               TypeBasicCopySource = original.TypeServiceNowSource
	TypeShopifySource                  TypeBasicCopySource = original.TypeShopifySource
	TypeSparkSource                    TypeBasicCopySource = original.TypeSparkSource
	TypeSQLDWSource                    TypeBasicCopySource = original.TypeSQLDWSource
	TypeSQLMISource                    TypeBasicCopySource = original.TypeSQLMISource
	TypeSQLServerSource                TypeBasicCopySource = original.TypeSQLServerSource
	TypeSQLSource                      TypeBasicCopySource = original.TypeSQLSource
	TypeSquareSource                   TypeBasicCopySource = original.TypeSquareSource
	TypeSybaseSource                   TypeBasicCopySource = original.TypeSybaseSource
	TypeTabularSource                  TypeBasicCopySource = original.TypeTabularSource
	TypeTeradataSource                 TypeBasicCopySource = original.TypeTeradataSource
	TypeVerticaSource                  TypeBasicCopySource = original.TypeVerticaSource
	TypeWebSource                      TypeBasicCopySource = original.TypeWebSource
	TypeXeroSource                     TypeBasicCopySource = original.TypeXeroSource
	TypeZohoSource                     TypeBasicCopySource = original.TypeZohoSource
)

type TypeBasicCopyTranslator = original.TypeBasicCopyTranslator

const (
	TypeCopyTranslator    TypeBasicCopyTranslator = original.TypeCopyTranslator
	TypeTabularTranslator TypeBasicCopyTranslator = original.TypeTabularTranslator
)

type TypeBasicCustomSetupBase = original.TypeBasicCustomSetupBase

const (
	TypeCmdkeySetup              TypeBasicCustomSetupBase = original.TypeCmdkeySetup
	TypeComponentSetup           TypeBasicCustomSetupBase = original.TypeComponentSetup
	TypeCustomSetupBase          TypeBasicCustomSetupBase = original.TypeCustomSetupBase
	TypeEnvironmentVariableSetup TypeBasicCustomSetupBase = original.TypeEnvironmentVariableSetup
)

type TypeBasicDataFlow = original.TypeBasicDataFlow

const (
	TypeDataFlow        TypeBasicDataFlow = original.TypeDataFlow
	TypeMappingDataFlow TypeBasicDataFlow = original.TypeMappingDataFlow
)

type TypeBasicDataset = original.TypeBasicDataset

const (
	TypeAmazonMWSObject                TypeBasicDataset = original.TypeAmazonMWSObject
	TypeAmazonRedshiftTable            TypeBasicDataset = original.TypeAmazonRedshiftTable
	TypeAvro                           TypeBasicDataset = original.TypeAvro
	TypeAzureDataExplorerTable         TypeBasicDataset = original.TypeAzureDataExplorerTable
	TypeAzureMariaDBTable              TypeBasicDataset = original.TypeAzureMariaDBTable
	TypeAzureMySQLTable                TypeBasicDataset = original.TypeAzureMySQLTable
	TypeAzurePostgreSQLTable           TypeBasicDataset = original.TypeAzurePostgreSQLTable
	TypeAzureSearchIndex               TypeBasicDataset = original.TypeAzureSearchIndex
	TypeAzureSQLDWTable                TypeBasicDataset = original.TypeAzureSQLDWTable
	TypeAzureSQLMITable                TypeBasicDataset = original.TypeAzureSQLMITable
	TypeAzureSQLTable                  TypeBasicDataset = original.TypeAzureSQLTable
	TypeAzureTable                     TypeBasicDataset = original.TypeAzureTable
	TypeBinary                         TypeBasicDataset = original.TypeBinary
	TypeCassandraTable                 TypeBasicDataset = original.TypeCassandraTable
	TypeCommonDataServiceForAppsEntity TypeBasicDataset = original.TypeCommonDataServiceForAppsEntity
	TypeConcurObject                   TypeBasicDataset = original.TypeConcurObject
	TypeCosmosDbMongoDbAPICollection   TypeBasicDataset = original.TypeCosmosDbMongoDbAPICollection
	TypeCosmosDbSQLAPICollection       TypeBasicDataset = original.TypeCosmosDbSQLAPICollection
	TypeCouchbaseTable                 TypeBasicDataset = original.TypeCouchbaseTable
	TypeCustomDataset                  TypeBasicDataset = original.TypeCustomDataset
	TypeDataset                        TypeBasicDataset = original.TypeDataset
	TypeDb2Table                       TypeBasicDataset = original.TypeDb2Table
	TypeDelimitedText                  TypeBasicDataset = original.TypeDelimitedText
	TypeDocumentDbCollection           TypeBasicDataset = original.TypeDocumentDbCollection
	TypeDrillTable                     TypeBasicDataset = original.TypeDrillTable
	TypeDynamicsAXResource             TypeBasicDataset = original.TypeDynamicsAXResource
	TypeDynamicsCrmEntity              TypeBasicDataset = original.TypeDynamicsCrmEntity
	TypeDynamicsEntity                 TypeBasicDataset = original.TypeDynamicsEntity
	TypeEloquaObject                   TypeBasicDataset = original.TypeEloquaObject
	TypeGoogleAdWordsObject            TypeBasicDataset = original.TypeGoogleAdWordsObject
	TypeGoogleBigQueryObject           TypeBasicDataset = original.TypeGoogleBigQueryObject
	TypeGreenplumTable                 TypeBasicDataset = original.TypeGreenplumTable
	TypeHBaseObject                    TypeBasicDataset = original.TypeHBaseObject
	TypeHiveObject                     TypeBasicDataset = original.TypeHiveObject
	TypeHubspotObject                  TypeBasicDataset = original.TypeHubspotObject
	TypeImpalaObject                   TypeBasicDataset = original.TypeImpalaObject
	TypeInformixTable                  TypeBasicDataset = original.TypeInformixTable
	TypeJiraObject                     TypeBasicDataset = original.TypeJiraObject
	TypeJSON                           TypeBasicDataset = original.TypeJSON
	TypeMagentoObject                  TypeBasicDataset = original.TypeMagentoObject
	TypeMariaDBTable                   TypeBasicDataset = original.TypeMariaDBTable
	TypeMarketoObject                  TypeBasicDataset = original.TypeMarketoObject
	TypeMicrosoftAccessTable           TypeBasicDataset = original.TypeMicrosoftAccessTable
	TypeMongoDbCollection              TypeBasicDataset = original.TypeMongoDbCollection
	TypeMongoDbV2Collection            TypeBasicDataset = original.TypeMongoDbV2Collection
	TypeMySQLTable                     TypeBasicDataset = original.TypeMySQLTable
	TypeNetezzaTable                   TypeBasicDataset = original.TypeNetezzaTable
	TypeODataResource                  TypeBasicDataset = original.TypeODataResource
	TypeOdbcTable                      TypeBasicDataset = original.TypeOdbcTable
	TypeOffice365Table                 TypeBasicDataset = original.TypeOffice365Table
	TypeOracleServiceCloudObject       TypeBasicDataset = original.TypeOracleServiceCloudObject
	TypeOracleTable                    TypeBasicDataset = original.TypeOracleTable
	TypeOrc                            TypeBasicDataset = original.TypeOrc
	TypeParquet                        TypeBasicDataset = original.TypeParquet
	TypePaypalObject                   TypeBasicDataset = original.TypePaypalObject
	TypePhoenixObject                  TypeBasicDataset = original.TypePhoenixObject
	TypePostgreSQLTable                TypeBasicDataset = original.TypePostgreSQLTable
	TypePrestoObject                   TypeBasicDataset = original.TypePrestoObject
	TypeQuickBooksObject               TypeBasicDataset = original.TypeQuickBooksObject
	TypeRelationalTable                TypeBasicDataset = original.TypeRelationalTable
	TypeResponsysObject                TypeBasicDataset = original.TypeResponsysObject
	TypeRestResource                   TypeBasicDataset = original.TypeRestResource
	TypeSalesforceMarketingCloudObject TypeBasicDataset = original.TypeSalesforceMarketingCloudObject
	TypeSalesforceObject               TypeBasicDataset = original.TypeSalesforceObject
	TypeSalesforceServiceCloudObject   TypeBasicDataset = original.TypeSalesforceServiceCloudObject
	TypeSapBwCube                      TypeBasicDataset = original.TypeSapBwCube
	TypeSapCloudForCustomerResource    TypeBasicDataset = original.TypeSapCloudForCustomerResource
	TypeSapEccResource                 TypeBasicDataset = original.TypeSapEccResource
	TypeSapHanaTable                   TypeBasicDataset = original.TypeSapHanaTable
	TypeSapOpenHubTable                TypeBasicDataset = original.TypeSapOpenHubTable
	TypeSapTableResource               TypeBasicDataset = original.TypeSapTableResource
	TypeServiceNowObject               TypeBasicDataset = original.TypeServiceNowObject
	TypeShopifyObject                  TypeBasicDataset = original.TypeShopifyObject
	TypeSparkObject                    TypeBasicDataset = original.TypeSparkObject
	TypeSQLServerTable                 TypeBasicDataset = original.TypeSQLServerTable
	TypeSquareObject                   TypeBasicDataset = original.TypeSquareObject
	TypeSybaseTable                    TypeBasicDataset = original.TypeSybaseTable
	TypeTeradataTable                  TypeBasicDataset = original.TypeTeradataTable
	TypeVerticaTable                   TypeBasicDataset = original.TypeVerticaTable
	TypeWebTable                       TypeBasicDataset = original.TypeWebTable
	TypeXeroObject                     TypeBasicDataset = original.TypeXeroObject
	TypeZohoObject                     TypeBasicDataset = original.TypeZohoObject
)

type TypeBasicDatasetCompression = original.TypeBasicDatasetCompression

const (
	TypeBZip2              TypeBasicDatasetCompression = original.TypeBZip2
	TypeDatasetCompression TypeBasicDatasetCompression = original.TypeDatasetCompression
	TypeDeflate            TypeBasicDatasetCompression = original.TypeDeflate
	TypeGZip               TypeBasicDatasetCompression = original.TypeGZip
	TypeZipDeflate         TypeBasicDatasetCompression = original.TypeZipDeflate
)

type TypeBasicDatasetLocation = original.TypeBasicDatasetLocation

const (
	TypeAmazonS3Location           TypeBasicDatasetLocation = original.TypeAmazonS3Location
	TypeAzureBlobFSLocation        TypeBasicDatasetLocation = original.TypeAzureBlobFSLocation
	TypeAzureBlobStorageLocation   TypeBasicDatasetLocation = original.TypeAzureBlobStorageLocation
	TypeAzureDataLakeStoreLocation TypeBasicDatasetLocation = original.TypeAzureDataLakeStoreLocation
	TypeAzureFileStorageLocation   TypeBasicDatasetLocation = original.TypeAzureFileStorageLocation
	TypeDatasetLocation            TypeBasicDatasetLocation = original.TypeDatasetLocation
	TypeFileServerLocation         TypeBasicDatasetLocation = original.TypeFileServerLocation
	TypeFtpServerLocation          TypeBasicDatasetLocation = original.TypeFtpServerLocation
	TypeGoogleCloudStorageLocation TypeBasicDatasetLocation = original.TypeGoogleCloudStorageLocation
	TypeHdfsLocation               TypeBasicDatasetLocation = original.TypeHdfsLocation
	TypeHTTPServerLocation         TypeBasicDatasetLocation = original.TypeHTTPServerLocation
	TypeSftpLocation               TypeBasicDatasetLocation = original.TypeSftpLocation
)

type TypeBasicDatasetStorageFormat = original.TypeBasicDatasetStorageFormat

const (
	TypeAvroFormat           TypeBasicDatasetStorageFormat = original.TypeAvroFormat
	TypeDatasetStorageFormat TypeBasicDatasetStorageFormat = original.TypeDatasetStorageFormat
	TypeJSONFormat           TypeBasicDatasetStorageFormat = original.TypeJSONFormat
	TypeOrcFormat            TypeBasicDatasetStorageFormat = original.TypeOrcFormat
	TypeParquetFormat        TypeBasicDatasetStorageFormat = original.TypeParquetFormat
	TypeTextFormat           TypeBasicDatasetStorageFormat = original.TypeTextFormat
)

type TypeBasicDependencyReference = original.TypeBasicDependencyReference

const (
	TypeDependencyReference                          TypeBasicDependencyReference = original.TypeDependencyReference
	TypeSelfDependencyTumblingWindowTriggerReference TypeBasicDependencyReference = original.TypeSelfDependencyTumblingWindowTriggerReference
	TypeTriggerDependencyReference                   TypeBasicDependencyReference = original.TypeTriggerDependencyReference
	TypeTumblingWindowTriggerDependencyReference     TypeBasicDependencyReference = original.TypeTumblingWindowTriggerDependencyReference
)

type TypeBasicFormatReadSettings = original.TypeBasicFormatReadSettings

const (
	TypeDelimitedTextReadSettings TypeBasicFormatReadSettings = original.TypeDelimitedTextReadSettings
	TypeFormatReadSettings        TypeBasicFormatReadSettings = original.TypeFormatReadSettings
)

type TypeBasicFormatWriteSettings = original.TypeBasicFormatWriteSettings

const (
	TypeAvroWriteSettings          TypeBasicFormatWriteSettings = original.TypeAvroWriteSettings
	TypeDelimitedTextWriteSettings TypeBasicFormatWriteSettings = original.TypeDelimitedTextWriteSettings
	TypeFormatWriteSettings        TypeBasicFormatWriteSettings = original.TypeFormatWriteSettings
	TypeJSONWriteSettings          TypeBasicFormatWriteSettings = original.TypeJSONWriteSettings
)

type TypeBasicIntegrationRuntime = original.TypeBasicIntegrationRuntime

const (
	TypeIntegrationRuntime TypeBasicIntegrationRuntime = original.TypeIntegrationRuntime
	TypeManaged            TypeBasicIntegrationRuntime = original.TypeManaged
	TypeSelfHosted         TypeBasicIntegrationRuntime = original.TypeSelfHosted
)

type TypeBasicLinkedService = original.TypeBasicLinkedService

const (
	TypeAmazonMWS                TypeBasicLinkedService = original.TypeAmazonMWS
	TypeAmazonRedshift           TypeBasicLinkedService = original.TypeAmazonRedshift
	TypeAmazonS3                 TypeBasicLinkedService = original.TypeAmazonS3
	TypeAzureBatch               TypeBasicLinkedService = original.TypeAzureBatch
	TypeAzureBlobFS              TypeBasicLinkedService = original.TypeAzureBlobFS
	TypeAzureBlobStorage         TypeBasicLinkedService = original.TypeAzureBlobStorage
	TypeAzureDatabricks          TypeBasicLinkedService = original.TypeAzureDatabricks
	TypeAzureDataExplorer        TypeBasicLinkedService = original.TypeAzureDataExplorer
	TypeAzureDataLakeAnalytics   TypeBasicLinkedService = original.TypeAzureDataLakeAnalytics
	TypeAzureDataLakeStore       TypeBasicLinkedService = original.TypeAzureDataLakeStore
	TypeAzureFileStorage         TypeBasicLinkedService = original.TypeAzureFileStorage
	TypeAzureFunction            TypeBasicLinkedService = original.TypeAzureFunction
	TypeAzureKeyVault            TypeBasicLinkedService = original.TypeAzureKeyVault
	TypeAzureMariaDB             TypeBasicLinkedService = original.TypeAzureMariaDB
	TypeAzureML                  TypeBasicLinkedService = original.TypeAzureML
	TypeAzureMLService           TypeBasicLinkedService = original.TypeAzureMLService
	TypeAzureMySQL               TypeBasicLinkedService = original.TypeAzureMySQL
	TypeAzurePostgreSQL          TypeBasicLinkedService = original.TypeAzurePostgreSQL
	TypeAzureSearch              TypeBasicLinkedService = original.TypeAzureSearch
	TypeAzureSQLDatabase         TypeBasicLinkedService = original.TypeAzureSQLDatabase
	TypeAzureSQLDW               TypeBasicLinkedService = original.TypeAzureSQLDW
	TypeAzureSQLMI               TypeBasicLinkedService = original.TypeAzureSQLMI
	TypeAzureStorage             TypeBasicLinkedService = original.TypeAzureStorage
	TypeAzureTableStorage        TypeBasicLinkedService = original.TypeAzureTableStorage
	TypeCassandra                TypeBasicLinkedService = original.TypeCassandra
	TypeCommonDataServiceForApps TypeBasicLinkedService = original.TypeCommonDataServiceForApps
	TypeConcur                   TypeBasicLinkedService = original.TypeConcur
	TypeCosmosDb                 TypeBasicLinkedService = original.TypeCosmosDb
	TypeCosmosDbMongoDbAPI       TypeBasicLinkedService = original.TypeCosmosDbMongoDbAPI
	TypeCouchbase                TypeBasicLinkedService = original.TypeCouchbase
	TypeCustomDataSource         TypeBasicLinkedService = original.TypeCustomDataSource
	TypeDb2                      TypeBasicLinkedService = original.TypeDb2
	TypeDrill                    TypeBasicLinkedService = original.TypeDrill
	TypeDynamics                 TypeBasicLinkedService = original.TypeDynamics
	TypeDynamicsAX               TypeBasicLinkedService = original.TypeDynamicsAX
	TypeDynamicsCrm              TypeBasicLinkedService = original.TypeDynamicsCrm
	TypeEloqua                   TypeBasicLinkedService = original.TypeEloqua
	TypeFileServer               TypeBasicLinkedService = original.TypeFileServer
	TypeFtpServer                TypeBasicLinkedService = original.TypeFtpServer
	TypeGoogleAdWords            TypeBasicLinkedService = original.TypeGoogleAdWords
	TypeGoogleBigQuery           TypeBasicLinkedService = original.TypeGoogleBigQuery
	TypeGoogleCloudStorage       TypeBasicLinkedService = original.TypeGoogleCloudStorage
	TypeGreenplum                TypeBasicLinkedService = original.TypeGreenplum
	TypeHBase                    TypeBasicLinkedService = original.TypeHBase
	TypeHdfs                     TypeBasicLinkedService = original.TypeHdfs
	TypeHDInsight                TypeBasicLinkedService = original.TypeHDInsight
	TypeHDInsightOnDemand        TypeBasicLinkedService = original.TypeHDInsightOnDemand
	TypeHive                     TypeBasicLinkedService = original.TypeHive
	TypeHTTPServer               TypeBasicLinkedService = original.TypeHTTPServer
	TypeHubspot                  TypeBasicLinkedService = original.TypeHubspot
	TypeImpala                   TypeBasicLinkedService = original.TypeImpala
	TypeInformix                 TypeBasicLinkedService = original.TypeInformix
	TypeJira                     TypeBasicLinkedService = original.TypeJira
	TypeLinkedService            TypeBasicLinkedService = original.TypeLinkedService
	TypeMagento                  TypeBasicLinkedService = original.TypeMagento
	TypeMariaDB                  TypeBasicLinkedService = original.TypeMariaDB
	TypeMarketo                  TypeBasicLinkedService = original.TypeMarketo
	TypeMicrosoftAccess          TypeBasicLinkedService = original.TypeMicrosoftAccess
	TypeMongoDb                  TypeBasicLinkedService = original.TypeMongoDb
	TypeMongoDbV2                TypeBasicLinkedService = original.TypeMongoDbV2
	TypeMySQL                    TypeBasicLinkedService = original.TypeMySQL
	TypeNetezza                  TypeBasicLinkedService = original.TypeNetezza
	TypeOData                    TypeBasicLinkedService = original.TypeOData
	TypeOdbc                     TypeBasicLinkedService = original.TypeOdbc
	TypeOffice365                TypeBasicLinkedService = original.TypeOffice365
	TypeOracle                   TypeBasicLinkedService = original.TypeOracle
	TypeOracleServiceCloud       TypeBasicLinkedService = original.TypeOracleServiceCloud
	TypePaypal                   TypeBasicLinkedService = original.TypePaypal
	TypePhoenix                  TypeBasicLinkedService = original.TypePhoenix
	TypePostgreSQL               TypeBasicLinkedService = original.TypePostgreSQL
	TypePresto                   TypeBasicLinkedService = original.TypePresto
	TypeQuickBooks               TypeBasicLinkedService = original.TypeQuickBooks
	TypeResponsys                TypeBasicLinkedService = original.TypeResponsys
	TypeRestService              TypeBasicLinkedService = original.TypeRestService
	TypeSalesforce               TypeBasicLinkedService = original.TypeSalesforce
	TypeSalesforceMarketingCloud TypeBasicLinkedService = original.TypeSalesforceMarketingCloud
	TypeSalesforceServiceCloud   TypeBasicLinkedService = original.TypeSalesforceServiceCloud
	TypeSapBW                    TypeBasicLinkedService = original.TypeSapBW
	TypeSapCloudForCustomer      TypeBasicLinkedService = original.TypeSapCloudForCustomer
	TypeSapEcc                   TypeBasicLinkedService = original.TypeSapEcc
	TypeSapHana                  TypeBasicLinkedService = original.TypeSapHana
	TypeSapOpenHub               TypeBasicLinkedService = original.TypeSapOpenHub
	TypeSapTable                 TypeBasicLinkedService = original.TypeSapTable
	TypeServiceNow               TypeBasicLinkedService = original.TypeServiceNow
	TypeSftp                     TypeBasicLinkedService = original.TypeSftp
	TypeShopify                  TypeBasicLinkedService = original.TypeShopify
	TypeSpark                    TypeBasicLinkedService = original.TypeSpark
	TypeSQLServer                TypeBasicLinkedService = original.TypeSQLServer
	TypeSquare                   TypeBasicLinkedService = original.TypeSquare
	TypeSybase                   TypeBasicLinkedService = original.TypeSybase
	TypeTeradata                 TypeBasicLinkedService = original.TypeTeradata
	TypeVertica                  TypeBasicLinkedService = original.TypeVertica
	TypeWeb                      TypeBasicLinkedService = original.TypeWeb
	TypeXero                     TypeBasicLinkedService = original.TypeXero
	TypeZoho                     TypeBasicLinkedService = original.TypeZoho
)

type TypeBasicStoreReadSettings = original.TypeBasicStoreReadSettings

const (
	TypeAmazonS3ReadSettings           TypeBasicStoreReadSettings = original.TypeAmazonS3ReadSettings
	TypeAzureBlobFSReadSettings        TypeBasicStoreReadSettings = original.TypeAzureBlobFSReadSettings
	TypeAzureBlobStorageReadSettings   TypeBasicStoreReadSettings = original.TypeAzureBlobStorageReadSettings
	TypeAzureDataLakeStoreReadSettings TypeBasicStoreReadSettings = original.TypeAzureDataLakeStoreReadSettings
	TypeAzureFileStorageReadSettings   TypeBasicStoreReadSettings = original.TypeAzureFileStorageReadSettings
	TypeFileServerReadSettings         TypeBasicStoreReadSettings = original.TypeFileServerReadSettings
	TypeFtpReadSettings                TypeBasicStoreReadSettings = original.TypeFtpReadSettings
	TypeGoogleCloudStorageReadSettings TypeBasicStoreReadSettings = original.TypeGoogleCloudStorageReadSettings
	TypeHdfsReadSettings               TypeBasicStoreReadSettings = original.TypeHdfsReadSettings
	TypeHTTPReadSettings               TypeBasicStoreReadSettings = original.TypeHTTPReadSettings
	TypeSftpReadSettings               TypeBasicStoreReadSettings = original.TypeSftpReadSettings
	TypeStoreReadSettings              TypeBasicStoreReadSettings = original.TypeStoreReadSettings
)

type TypeBasicStoreWriteSettings = original.TypeBasicStoreWriteSettings

const (
	TypeAzureBlobFSWriteSettings        TypeBasicStoreWriteSettings = original.TypeAzureBlobFSWriteSettings
	TypeAzureBlobStorageWriteSettings   TypeBasicStoreWriteSettings = original.TypeAzureBlobStorageWriteSettings
	TypeAzureDataLakeStoreWriteSettings TypeBasicStoreWriteSettings = original.TypeAzureDataLakeStoreWriteSettings
	TypeFileServerWriteSettings         TypeBasicStoreWriteSettings = original.TypeFileServerWriteSettings
	TypeSftpWriteSettings               TypeBasicStoreWriteSettings = original.TypeSftpWriteSettings
	TypeStoreWriteSettings              TypeBasicStoreWriteSettings = original.TypeStoreWriteSettings
)

type TypeBasicTrigger = original.TypeBasicTrigger

const (
	TypeBlobEventsTrigger          TypeBasicTrigger = original.TypeBlobEventsTrigger
	TypeBlobTrigger                TypeBasicTrigger = original.TypeBlobTrigger
	TypeChainingTrigger            TypeBasicTrigger = original.TypeChainingTrigger
	TypeMultiplePipelineTrigger    TypeBasicTrigger = original.TypeMultiplePipelineTrigger
	TypeRerunTumblingWindowTrigger TypeBasicTrigger = original.TypeRerunTumblingWindowTrigger
	TypeScheduleTrigger            TypeBasicTrigger = original.TypeScheduleTrigger
	TypeTrigger                    TypeBasicTrigger = original.TypeTrigger
	TypeTumblingWindowTrigger      TypeBasicTrigger = original.TypeTumblingWindowTrigger
)

type VariableType = original.VariableType

const (
	VariableTypeArray   VariableType = original.VariableTypeArray
	VariableTypeBool    VariableType = original.VariableTypeBool
	VariableTypeBoolean VariableType = original.VariableTypeBoolean
	VariableTypeString  VariableType = original.VariableTypeString
)

type WebActivityMethod = original.WebActivityMethod

const (
	WebActivityMethodDELETE WebActivityMethod = original.WebActivityMethodDELETE
	WebActivityMethodGET    WebActivityMethod = original.WebActivityMethodGET
	WebActivityMethodPOST   WebActivityMethod = original.WebActivityMethodPOST
	WebActivityMethodPUT    WebActivityMethod = original.WebActivityMethodPUT
)

type WebHookActivityMethod = original.WebHookActivityMethod

const (
	WebHookActivityMethodPOST WebHookActivityMethod = original.WebHookActivityMethodPOST
)

type Activity = original.Activity
type ActivityDependency = original.ActivityDependency
type ActivityPolicy = original.ActivityPolicy
type ActivityRun = original.ActivityRun
type ActivityRunsQueryResponse = original.ActivityRunsQueryResponse
type AddDataFlowToDebugSessionResponse = original.AddDataFlowToDebugSessionResponse
type AmazonMWSLinkedService = original.AmazonMWSLinkedService
type AmazonMWSLinkedServiceTypeProperties = original.AmazonMWSLinkedServiceTypeProperties
type AmazonMWSObjectDataset = original.AmazonMWSObjectDataset
type AmazonMWSSource = original.AmazonMWSSource
type AmazonRedshiftLinkedService = original.AmazonRedshiftLinkedService
type AmazonRedshiftLinkedServiceTypeProperties = original.AmazonRedshiftLinkedServiceTypeProperties
type AmazonRedshiftSource = original.AmazonRedshiftSource
type AmazonRedshiftTableDataset = original.AmazonRedshiftTableDataset
type AmazonRedshiftTableDatasetTypeProperties = original.AmazonRedshiftTableDatasetTypeProperties
type AmazonS3LinkedService = original.AmazonS3LinkedService
type AmazonS3LinkedServiceTypeProperties = original.AmazonS3LinkedServiceTypeProperties
type AmazonS3Location = original.AmazonS3Location
type AmazonS3ReadSettings = original.AmazonS3ReadSettings
type AppendVariableActivity = original.AppendVariableActivity
type AppendVariableActivityTypeProperties = original.AppendVariableActivityTypeProperties
type AutoPauseProperties = original.AutoPauseProperties
type AutoScaleProperties = original.AutoScaleProperties
type AvroDataset = original.AvroDataset
type AvroDatasetTypeProperties = original.AvroDatasetTypeProperties
type AvroFormat = original.AvroFormat
type AvroSink = original.AvroSink
type AvroSource = original.AvroSource
type AvroWriteSettings = original.AvroWriteSettings
type AzureBatchLinkedService = original.AzureBatchLinkedService
type AzureBatchLinkedServiceTypeProperties = original.AzureBatchLinkedServiceTypeProperties
type AzureBlobFSLinkedService = original.AzureBlobFSLinkedService
type AzureBlobFSLinkedServiceTypeProperties = original.AzureBlobFSLinkedServiceTypeProperties
type AzureBlobFSLocation = original.AzureBlobFSLocation
type AzureBlobFSReadSettings = original.AzureBlobFSReadSettings
type AzureBlobFSSink = original.AzureBlobFSSink
type AzureBlobFSSource = original.AzureBlobFSSource
type AzureBlobFSWriteSettings = original.AzureBlobFSWriteSettings
type AzureBlobStorageLinkedService = original.AzureBlobStorageLinkedService
type AzureBlobStorageLinkedServiceTypeProperties = original.AzureBlobStorageLinkedServiceTypeProperties
type AzureBlobStorageLocation = original.AzureBlobStorageLocation
type AzureBlobStorageReadSettings = original.AzureBlobStorageReadSettings
type AzureBlobStorageWriteSettings = original.AzureBlobStorageWriteSettings
type AzureDataExplorerCommandActivity = original.AzureDataExplorerCommandActivity
type AzureDataExplorerCommandActivityTypeProperties = original.AzureDataExplorerCommandActivityTypeProperties
type AzureDataExplorerDatasetTypeProperties = original.AzureDataExplorerDatasetTypeProperties
type AzureDataExplorerLinkedService = original.AzureDataExplorerLinkedService
type AzureDataExplorerLinkedServiceTypeProperties = original.AzureDataExplorerLinkedServiceTypeProperties
type AzureDataExplorerSink = original.AzureDataExplorerSink
type AzureDataExplorerSource = original.AzureDataExplorerSource
type AzureDataExplorerTableDataset = original.AzureDataExplorerTableDataset
type AzureDataLakeAnalyticsLinkedService = original.AzureDataLakeAnalyticsLinkedService
type AzureDataLakeAnalyticsLinkedServiceTypeProperties = original.AzureDataLakeAnalyticsLinkedServiceTypeProperties
type AzureDataLakeStoreLinkedService = original.AzureDataLakeStoreLinkedService
type AzureDataLakeStoreLinkedServiceTypeProperties = original.AzureDataLakeStoreLinkedServiceTypeProperties
type AzureDataLakeStoreLocation = original.AzureDataLakeStoreLocation
type AzureDataLakeStoreReadSettings = original.AzureDataLakeStoreReadSettings
type AzureDataLakeStoreSink = original.AzureDataLakeStoreSink
type AzureDataLakeStoreSource = original.AzureDataLakeStoreSource
type AzureDataLakeStoreWriteSettings = original.AzureDataLakeStoreWriteSettings
type AzureDatabricksLinkedService = original.AzureDatabricksLinkedService
type AzureDatabricksLinkedServiceTypeProperties = original.AzureDatabricksLinkedServiceTypeProperties
type AzureEntityResource = original.AzureEntityResource
type AzureFileStorageLinkedService = original.AzureFileStorageLinkedService
type AzureFileStorageLinkedServiceTypeProperties = original.AzureFileStorageLinkedServiceTypeProperties
type AzureFileStorageLocation = original.AzureFileStorageLocation
type AzureFileStorageReadSettings = original.AzureFileStorageReadSettings
type AzureFunctionActivity = original.AzureFunctionActivity
type AzureFunctionActivityTypeProperties = original.AzureFunctionActivityTypeProperties
type AzureFunctionLinkedService = original.AzureFunctionLinkedService
type AzureFunctionLinkedServiceTypeProperties = original.AzureFunctionLinkedServiceTypeProperties
type AzureKeyVaultLinkedService = original.AzureKeyVaultLinkedService
type AzureKeyVaultLinkedServiceTypeProperties = original.AzureKeyVaultLinkedServiceTypeProperties
type AzureKeyVaultSecretReference = original.AzureKeyVaultSecretReference
type AzureMLBatchExecutionActivity = original.AzureMLBatchExecutionActivity
type AzureMLBatchExecutionActivityTypeProperties = original.AzureMLBatchExecutionActivityTypeProperties
type AzureMLExecutePipelineActivity = original.AzureMLExecutePipelineActivity
type AzureMLExecutePipelineActivityTypeProperties = original.AzureMLExecutePipelineActivityTypeProperties
type AzureMLLinkedService = original.AzureMLLinkedService
type AzureMLLinkedServiceTypeProperties = original.AzureMLLinkedServiceTypeProperties
type AzureMLServiceLinkedService = original.AzureMLServiceLinkedService
type AzureMLServiceLinkedServiceTypeProperties = original.AzureMLServiceLinkedServiceTypeProperties
type AzureMLUpdateResourceActivity = original.AzureMLUpdateResourceActivity
type AzureMLUpdateResourceActivityTypeProperties = original.AzureMLUpdateResourceActivityTypeProperties
type AzureMLWebServiceFile = original.AzureMLWebServiceFile
type AzureMariaDBLinkedService = original.AzureMariaDBLinkedService
type AzureMariaDBLinkedServiceTypeProperties = original.AzureMariaDBLinkedServiceTypeProperties
type AzureMariaDBSource = original.AzureMariaDBSource
type AzureMariaDBTableDataset = original.AzureMariaDBTableDataset
type AzureMySQLLinkedService = original.AzureMySQLLinkedService
type AzureMySQLLinkedServiceTypeProperties = original.AzureMySQLLinkedServiceTypeProperties
type AzureMySQLSink = original.AzureMySQLSink
type AzureMySQLSource = original.AzureMySQLSource
type AzureMySQLTableDataset = original.AzureMySQLTableDataset
type AzureMySQLTableDatasetTypeProperties = original.AzureMySQLTableDatasetTypeProperties
type AzurePostgreSQLLinkedService = original.AzurePostgreSQLLinkedService
type AzurePostgreSQLLinkedServiceTypeProperties = original.AzurePostgreSQLLinkedServiceTypeProperties
type AzurePostgreSQLSink = original.AzurePostgreSQLSink
type AzurePostgreSQLSource = original.AzurePostgreSQLSource
type AzurePostgreSQLTableDataset = original.AzurePostgreSQLTableDataset
type AzurePostgreSQLTableDatasetTypeProperties = original.AzurePostgreSQLTableDatasetTypeProperties
type AzureQueueSink = original.AzureQueueSink
type AzureSQLDWLinkedService = original.AzureSQLDWLinkedService
type AzureSQLDWLinkedServiceTypeProperties = original.AzureSQLDWLinkedServiceTypeProperties
type AzureSQLDWTableDataset = original.AzureSQLDWTableDataset
type AzureSQLDWTableDatasetTypeProperties = original.AzureSQLDWTableDatasetTypeProperties
type AzureSQLDatabaseLinkedService = original.AzureSQLDatabaseLinkedService
type AzureSQLDatabaseLinkedServiceTypeProperties = original.AzureSQLDatabaseLinkedServiceTypeProperties
type AzureSQLMILinkedService = original.AzureSQLMILinkedService
type AzureSQLMILinkedServiceTypeProperties = original.AzureSQLMILinkedServiceTypeProperties
type AzureSQLMITableDataset = original.AzureSQLMITableDataset
type AzureSQLMITableDatasetTypeProperties = original.AzureSQLMITableDatasetTypeProperties
type AzureSQLSink = original.AzureSQLSink
type AzureSQLSource = original.AzureSQLSource
type AzureSQLTableDataset = original.AzureSQLTableDataset
type AzureSQLTableDatasetTypeProperties = original.AzureSQLTableDatasetTypeProperties
type AzureSearchIndexDataset = original.AzureSearchIndexDataset
type AzureSearchIndexDatasetTypeProperties = original.AzureSearchIndexDatasetTypeProperties
type AzureSearchIndexSink = original.AzureSearchIndexSink
type AzureSearchLinkedService = original.AzureSearchLinkedService
type AzureSearchLinkedServiceTypeProperties = original.AzureSearchLinkedServiceTypeProperties
type AzureStorageLinkedService = original.AzureStorageLinkedService
type AzureStorageLinkedServiceTypeProperties = original.AzureStorageLinkedServiceTypeProperties
type AzureTableDataset = original.AzureTableDataset
type AzureTableDatasetTypeProperties = original.AzureTableDatasetTypeProperties
type AzureTableSink = original.AzureTableSink
type AzureTableSource = original.AzureTableSource
type AzureTableStorageLinkedService = original.AzureTableStorageLinkedService
type BaseClient = original.BaseClient
type BasicActivity = original.BasicActivity
type BasicControlActivity = original.BasicControlActivity
type BasicCopySink = original.BasicCopySink
type BasicCopySource = original.BasicCopySource
type BasicCopyTranslator = original.BasicCopyTranslator
type BasicCustomSetupBase = original.BasicCustomSetupBase
type BasicDataFlow = original.BasicDataFlow
type BasicDataset = original.BasicDataset
type BasicDatasetCompression = original.BasicDatasetCompression
type BasicDatasetLocation = original.BasicDatasetLocation
type BasicDatasetStorageFormat = original.BasicDatasetStorageFormat
type BasicDependencyReference = original.BasicDependencyReference
type BasicExecutionActivity = original.BasicExecutionActivity
type BasicFormatReadSettings = original.BasicFormatReadSettings
type BasicFormatWriteSettings = original.BasicFormatWriteSettings
type BasicIntegrationRuntime = original.BasicIntegrationRuntime
type BasicLinkedIntegrationRuntimeType = original.BasicLinkedIntegrationRuntimeType
type BasicLinkedService = original.BasicLinkedService
type BasicMultiplePipelineTrigger = original.BasicMultiplePipelineTrigger
type BasicSecretBase = original.BasicSecretBase
type BasicStoreReadSettings = original.BasicStoreReadSettings
type BasicStoreWriteSettings = original.BasicStoreWriteSettings
type BasicTabularSource = original.BasicTabularSource
type BasicTrigger = original.BasicTrigger
type BasicTriggerDependencyReference = original.BasicTriggerDependencyReference
type BasicWebLinkedServiceTypeProperties = original.BasicWebLinkedServiceTypeProperties
type BigDataPoolReference = original.BigDataPoolReference
type BigDataPoolResourceInfo = original.BigDataPoolResourceInfo
type BigDataPoolResourceInfoListResult = original.BigDataPoolResourceInfoListResult
type BigDataPoolResourceProperties = original.BigDataPoolResourceProperties
type BigDataPoolsClient = original.BigDataPoolsClient
type BinaryDataset = original.BinaryDataset
type BinaryDatasetTypeProperties = original.BinaryDatasetTypeProperties
type BinarySink = original.BinarySink
type BinarySource = original.BinarySource
type BlobEventsTrigger = original.BlobEventsTrigger
type BlobEventsTriggerTypeProperties = original.BlobEventsTriggerTypeProperties
type BlobSink = original.BlobSink
type BlobSource = original.BlobSource
type BlobTrigger = original.BlobTrigger
type BlobTriggerTypeProperties = original.BlobTriggerTypeProperties
type CassandraLinkedService = original.CassandraLinkedService
type CassandraLinkedServiceTypeProperties = original.CassandraLinkedServiceTypeProperties
type CassandraSource = original.CassandraSource
type CassandraTableDataset = original.CassandraTableDataset
type CassandraTableDatasetTypeProperties = original.CassandraTableDatasetTypeProperties
type ChainingTrigger = original.ChainingTrigger
type ChainingTriggerTypeProperties = original.ChainingTriggerTypeProperties
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type CmdkeySetup = original.CmdkeySetup
type CmdkeySetupTypeProperties = original.CmdkeySetupTypeProperties
type CommonDataServiceForAppsEntityDataset = original.CommonDataServiceForAppsEntityDataset
type CommonDataServiceForAppsEntityDatasetTypeProperties = original.CommonDataServiceForAppsEntityDatasetTypeProperties
type CommonDataServiceForAppsLinkedService = original.CommonDataServiceForAppsLinkedService
type CommonDataServiceForAppsLinkedServiceTypeProperties = original.CommonDataServiceForAppsLinkedServiceTypeProperties
type CommonDataServiceForAppsSink = original.CommonDataServiceForAppsSink
type CommonDataServiceForAppsSource = original.CommonDataServiceForAppsSource
type ComponentSetup = original.ComponentSetup
type ConcurLinkedService = original.ConcurLinkedService
type ConcurLinkedServiceTypeProperties = original.ConcurLinkedServiceTypeProperties
type ConcurObjectDataset = original.ConcurObjectDataset
type ConcurSource = original.ConcurSource
type ControlActivity = original.ControlActivity
type CopyActivity = original.CopyActivity
type CopyActivityTypeProperties = original.CopyActivityTypeProperties
type CopySink = original.CopySink
type CopySource = original.CopySource
type CopyTranslator = original.CopyTranslator
type CosmosDbLinkedService = original.CosmosDbLinkedService
type CosmosDbLinkedServiceTypeProperties = original.CosmosDbLinkedServiceTypeProperties
type CosmosDbMongoDbAPICollectionDataset = original.CosmosDbMongoDbAPICollectionDataset
type CosmosDbMongoDbAPICollectionDatasetTypeProperties = original.CosmosDbMongoDbAPICollectionDatasetTypeProperties
type CosmosDbMongoDbAPILinkedService = original.CosmosDbMongoDbAPILinkedService
type CosmosDbMongoDbAPILinkedServiceTypeProperties = original.CosmosDbMongoDbAPILinkedServiceTypeProperties
type CosmosDbMongoDbAPISink = original.CosmosDbMongoDbAPISink
type CosmosDbMongoDbAPISource = original.CosmosDbMongoDbAPISource
type CosmosDbSQLAPICollectionDataset = original.CosmosDbSQLAPICollectionDataset
type CosmosDbSQLAPICollectionDatasetTypeProperties = original.CosmosDbSQLAPICollectionDatasetTypeProperties
type CosmosDbSQLAPISink = original.CosmosDbSQLAPISink
type CosmosDbSQLAPISource = original.CosmosDbSQLAPISource
type CouchbaseLinkedService = original.CouchbaseLinkedService
type CouchbaseLinkedServiceTypeProperties = original.CouchbaseLinkedServiceTypeProperties
type CouchbaseSource = original.CouchbaseSource
type CouchbaseTableDataset = original.CouchbaseTableDataset
type CreateDataFlowDebugSessionRequest = original.CreateDataFlowDebugSessionRequest
type CreateDataFlowDebugSessionResponse = original.CreateDataFlowDebugSessionResponse
type CreateRunResponse = original.CreateRunResponse
type CustomActivity = original.CustomActivity
type CustomActivityReferenceObject = original.CustomActivityReferenceObject
type CustomActivityTypeProperties = original.CustomActivityTypeProperties
type CustomDataSourceLinkedService = original.CustomDataSourceLinkedService
type CustomDataset = original.CustomDataset
type CustomSetupBase = original.CustomSetupBase
type CustomerManagedKeyDetails = original.CustomerManagedKeyDetails
type DWCopyCommandDefaultValue = original.DWCopyCommandDefaultValue
type DWCopyCommandSettings = original.DWCopyCommandSettings
type DataFlow = original.DataFlow
type DataFlowClient = original.DataFlowClient
type DataFlowCreateOrUpdateDataFlowFuture = original.DataFlowCreateOrUpdateDataFlowFuture
type DataFlowDebugCommandRequest = original.DataFlowDebugCommandRequest
type DataFlowDebugCommandResponse = original.DataFlowDebugCommandResponse
type DataFlowDebugPackage = original.DataFlowDebugPackage
type DataFlowDebugPackageDebugSettings = original.DataFlowDebugPackageDebugSettings
type DataFlowDebugPreviewDataRequest = original.DataFlowDebugPreviewDataRequest
type DataFlowDebugQueryResponse = original.DataFlowDebugQueryResponse
type DataFlowDebugResource = original.DataFlowDebugResource
type DataFlowDebugResultResponse = original.DataFlowDebugResultResponse
type DataFlowDebugSessionClient = original.DataFlowDebugSessionClient
type DataFlowDebugSessionCreateDataFlowDebugSessionFuture = original.DataFlowDebugSessionCreateDataFlowDebugSessionFuture
type DataFlowDebugSessionExecuteCommandFuture = original.DataFlowDebugSessionExecuteCommandFuture
type DataFlowDebugSessionInfo = original.DataFlowDebugSessionInfo
type DataFlowDebugStatisticsRequest = original.DataFlowDebugStatisticsRequest
type DataFlowDeleteDataFlowFuture = original.DataFlowDeleteDataFlowFuture
type DataFlowFolder = original.DataFlowFolder
type DataFlowListResponse = original.DataFlowListResponse
type DataFlowListResponseIterator = original.DataFlowListResponseIterator
type DataFlowListResponsePage = original.DataFlowListResponsePage
type DataFlowReference = original.DataFlowReference
type DataFlowRenameDataFlowFuture = original.DataFlowRenameDataFlowFuture
type DataFlowResource = original.DataFlowResource
type DataFlowSink = original.DataFlowSink
type DataFlowSource = original.DataFlowSource
type DataFlowSourceSetting = original.DataFlowSourceSetting
type DataFlowStagingInfo = original.DataFlowStagingInfo
type DataLakeAnalyticsUSQLActivity = original.DataLakeAnalyticsUSQLActivity
type DataLakeAnalyticsUSQLActivityTypeProperties = original.DataLakeAnalyticsUSQLActivityTypeProperties
type DataLakeStorageAccountDetails = original.DataLakeStorageAccountDetails
type DatabricksNotebookActivity = original.DatabricksNotebookActivity
type DatabricksNotebookActivityTypeProperties = original.DatabricksNotebookActivityTypeProperties
type DatabricksSparkJarActivity = original.DatabricksSparkJarActivity
type DatabricksSparkJarActivityTypeProperties = original.DatabricksSparkJarActivityTypeProperties
type DatabricksSparkPythonActivity = original.DatabricksSparkPythonActivity
type DatabricksSparkPythonActivityTypeProperties = original.DatabricksSparkPythonActivityTypeProperties
type Dataset = original.Dataset
type DatasetBZip2Compression = original.DatasetBZip2Compression
type DatasetClient = original.DatasetClient
type DatasetCompression = original.DatasetCompression
type DatasetCreateOrUpdateDatasetFuture = original.DatasetCreateOrUpdateDatasetFuture
type DatasetDataElement = original.DatasetDataElement
type DatasetDebugResource = original.DatasetDebugResource
type DatasetDeflateCompression = original.DatasetDeflateCompression
type DatasetDeleteDatasetFuture = original.DatasetDeleteDatasetFuture
type DatasetFolder = original.DatasetFolder
type DatasetGZipCompression = original.DatasetGZipCompression
type DatasetListResponse = original.DatasetListResponse
type DatasetListResponseIterator = original.DatasetListResponseIterator
type DatasetListResponsePage = original.DatasetListResponsePage
type DatasetLocation = original.DatasetLocation
type DatasetReference = original.DatasetReference
type DatasetRenameDatasetFuture = original.DatasetRenameDatasetFuture
type DatasetResource = original.DatasetResource
type DatasetSchemaDataElement = original.DatasetSchemaDataElement
type DatasetStorageFormat = original.DatasetStorageFormat
type DatasetZipDeflateCompression = original.DatasetZipDeflateCompression
type Db2LinkedService = original.Db2LinkedService
type Db2LinkedServiceTypeProperties = original.Db2LinkedServiceTypeProperties
type Db2Source = original.Db2Source
type Db2TableDataset = original.Db2TableDataset
type Db2TableDatasetTypeProperties = original.Db2TableDatasetTypeProperties
type DeleteActivity = original.DeleteActivity
type DeleteActivityTypeProperties = original.DeleteActivityTypeProperties
type DeleteDataFlowDebugSessionRequest = original.DeleteDataFlowDebugSessionRequest
type DelimitedTextDataset = original.DelimitedTextDataset
type DelimitedTextDatasetTypeProperties = original.DelimitedTextDatasetTypeProperties
type DelimitedTextReadSettings = original.DelimitedTextReadSettings
type DelimitedTextSink = original.DelimitedTextSink
type DelimitedTextSource = original.DelimitedTextSource
type DelimitedTextWriteSettings = original.DelimitedTextWriteSettings
type DependencyReference = original.DependencyReference
type DistcpSettings = original.DistcpSettings
type DocumentDbCollectionDataset = original.DocumentDbCollectionDataset
type DocumentDbCollectionDatasetTypeProperties = original.DocumentDbCollectionDatasetTypeProperties
type DocumentDbCollectionSink = original.DocumentDbCollectionSink
type DocumentDbCollectionSource = original.DocumentDbCollectionSource
type DrillDatasetTypeProperties = original.DrillDatasetTypeProperties
type DrillLinkedService = original.DrillLinkedService
type DrillLinkedServiceTypeProperties = original.DrillLinkedServiceTypeProperties
type DrillSource = original.DrillSource
type DrillTableDataset = original.DrillTableDataset
type DynamicsAXLinkedService = original.DynamicsAXLinkedService
type DynamicsAXLinkedServiceTypeProperties = original.DynamicsAXLinkedServiceTypeProperties
type DynamicsAXResourceDataset = original.DynamicsAXResourceDataset
type DynamicsAXResourceDatasetTypeProperties = original.DynamicsAXResourceDatasetTypeProperties
type DynamicsAXSource = original.DynamicsAXSource
type DynamicsCrmEntityDataset = original.DynamicsCrmEntityDataset
type DynamicsCrmEntityDatasetTypeProperties = original.DynamicsCrmEntityDatasetTypeProperties
type DynamicsCrmLinkedService = original.DynamicsCrmLinkedService
type DynamicsCrmLinkedServiceTypeProperties = original.DynamicsCrmLinkedServiceTypeProperties
type DynamicsCrmSink = original.DynamicsCrmSink
type DynamicsCrmSource = original.DynamicsCrmSource
type DynamicsEntityDataset = original.DynamicsEntityDataset
type DynamicsEntityDatasetTypeProperties = original.DynamicsEntityDatasetTypeProperties
type DynamicsLinkedService = original.DynamicsLinkedService
type DynamicsLinkedServiceTypeProperties = original.DynamicsLinkedServiceTypeProperties
type DynamicsSink = original.DynamicsSink
type DynamicsSource = original.DynamicsSource
type EloquaLinkedService = original.EloquaLinkedService
type EloquaLinkedServiceTypeProperties = original.EloquaLinkedServiceTypeProperties
type EloquaObjectDataset = original.EloquaObjectDataset
type EloquaSource = original.EloquaSource
type EncryptionDetails = original.EncryptionDetails
type EntityReference = original.EntityReference
type EnvironmentVariableSetup = original.EnvironmentVariableSetup
type EnvironmentVariableSetupTypeProperties = original.EnvironmentVariableSetupTypeProperties
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorContract = original.ErrorContract
type ErrorResponse = original.ErrorResponse
type EvaluateDataFlowExpressionRequest = original.EvaluateDataFlowExpressionRequest
type ExecuteDataFlowActivity = original.ExecuteDataFlowActivity
type ExecuteDataFlowActivityTypeProperties = original.ExecuteDataFlowActivityTypeProperties
type ExecuteDataFlowActivityTypePropertiesCompute = original.ExecuteDataFlowActivityTypePropertiesCompute
type ExecutePipelineActivity = original.ExecutePipelineActivity
type ExecutePipelineActivityTypeProperties = original.ExecutePipelineActivityTypeProperties
type ExecuteSSISPackageActivity = original.ExecuteSSISPackageActivity
type ExecuteSSISPackageActivityTypeProperties = original.ExecuteSSISPackageActivityTypeProperties
type ExecutionActivity = original.ExecutionActivity
type ExposureControlRequest = original.ExposureControlRequest
type ExposureControlResponse = original.ExposureControlResponse
type Expression = original.Expression
type FileServerLinkedService = original.FileServerLinkedService
type FileServerLinkedServiceTypeProperties = original.FileServerLinkedServiceTypeProperties
type FileServerLocation = original.FileServerLocation
type FileServerReadSettings = original.FileServerReadSettings
type FileServerWriteSettings = original.FileServerWriteSettings
type FileSystemSink = original.FileSystemSink
type FileSystemSource = original.FileSystemSource
type FilterActivity = original.FilterActivity
type FilterActivityTypeProperties = original.FilterActivityTypeProperties
type ForEachActivity = original.ForEachActivity
type ForEachActivityTypeProperties = original.ForEachActivityTypeProperties
type FormatReadSettings = original.FormatReadSettings
type FormatWriteSettings = original.FormatWriteSettings
type FtpReadSettings = original.FtpReadSettings
type FtpServerLinkedService = original.FtpServerLinkedService
type FtpServerLinkedServiceTypeProperties = original.FtpServerLinkedServiceTypeProperties
type FtpServerLocation = original.FtpServerLocation
type GenericDatasetTypeProperties = original.GenericDatasetTypeProperties
type GetMetadataActivity = original.GetMetadataActivity
type GetMetadataActivityTypeProperties = original.GetMetadataActivityTypeProperties
type GetSsisObjectMetadataRequest = original.GetSsisObjectMetadataRequest
type GitHubAccessTokenRequest = original.GitHubAccessTokenRequest
type GitHubAccessTokenResponse = original.GitHubAccessTokenResponse
type GoogleAdWordsLinkedService = original.GoogleAdWordsLinkedService
type GoogleAdWordsLinkedServiceTypeProperties = original.GoogleAdWordsLinkedServiceTypeProperties
type GoogleAdWordsObjectDataset = original.GoogleAdWordsObjectDataset
type GoogleAdWordsSource = original.GoogleAdWordsSource
type GoogleBigQueryDatasetTypeProperties = original.GoogleBigQueryDatasetTypeProperties
type GoogleBigQueryLinkedService = original.GoogleBigQueryLinkedService
type GoogleBigQueryLinkedServiceTypeProperties = original.GoogleBigQueryLinkedServiceTypeProperties
type GoogleBigQueryObjectDataset = original.GoogleBigQueryObjectDataset
type GoogleBigQuerySource = original.GoogleBigQuerySource
type GoogleCloudStorageLinkedService = original.GoogleCloudStorageLinkedService
type GoogleCloudStorageLinkedServiceTypeProperties = original.GoogleCloudStorageLinkedServiceTypeProperties
type GoogleCloudStorageLocation = original.GoogleCloudStorageLocation
type GoogleCloudStorageReadSettings = original.GoogleCloudStorageReadSettings
type GreenplumDatasetTypeProperties = original.GreenplumDatasetTypeProperties
type GreenplumLinkedService = original.GreenplumLinkedService
type GreenplumLinkedServiceTypeProperties = original.GreenplumLinkedServiceTypeProperties
type GreenplumSource = original.GreenplumSource
type GreenplumTableDataset = original.GreenplumTableDataset
type HBaseLinkedService = original.HBaseLinkedService
type HBaseLinkedServiceTypeProperties = original.HBaseLinkedServiceTypeProperties
type HBaseObjectDataset = original.HBaseObjectDataset
type HBaseSource = original.HBaseSource
type HDInsightHiveActivity = original.HDInsightHiveActivity
type HDInsightHiveActivityTypeProperties = original.HDInsightHiveActivityTypeProperties
type HDInsightLinkedService = original.HDInsightLinkedService
type HDInsightLinkedServiceTypeProperties = original.HDInsightLinkedServiceTypeProperties
type HDInsightMapReduceActivity = original.HDInsightMapReduceActivity
type HDInsightMapReduceActivityTypeProperties = original.HDInsightMapReduceActivityTypeProperties
type HDInsightOnDemandLinkedService = original.HDInsightOnDemandLinkedService
type HDInsightOnDemandLinkedServiceTypeProperties = original.HDInsightOnDemandLinkedServiceTypeProperties
type HDInsightPigActivity = original.HDInsightPigActivity
type HDInsightPigActivityTypeProperties = original.HDInsightPigActivityTypeProperties
type HDInsightSparkActivity = original.HDInsightSparkActivity
type HDInsightSparkActivityTypeProperties = original.HDInsightSparkActivityTypeProperties
type HDInsightStreamingActivity = original.HDInsightStreamingActivity
type HDInsightStreamingActivityTypeProperties = original.HDInsightStreamingActivityTypeProperties
type HTTPLinkedService = original.HTTPLinkedService
type HTTPLinkedServiceTypeProperties = original.HTTPLinkedServiceTypeProperties
type HTTPReadSettings = original.HTTPReadSettings
type HTTPServerLocation = original.HTTPServerLocation
type HTTPSource = original.HTTPSource
type HdfsLinkedService = original.HdfsLinkedService
type HdfsLinkedServiceTypeProperties = original.HdfsLinkedServiceTypeProperties
type HdfsLocation = original.HdfsLocation
type HdfsReadSettings = original.HdfsReadSettings
type HdfsSource = original.HdfsSource
type HiveDatasetTypeProperties = original.HiveDatasetTypeProperties
type HiveLinkedService = original.HiveLinkedService
type HiveLinkedServiceTypeProperties = original.HiveLinkedServiceTypeProperties
type HiveObjectDataset = original.HiveObjectDataset
type HiveSource = original.HiveSource
type HubspotLinkedService = original.HubspotLinkedService
type HubspotLinkedServiceTypeProperties = original.HubspotLinkedServiceTypeProperties
type HubspotObjectDataset = original.HubspotObjectDataset
type HubspotSource = original.HubspotSource
type IfConditionActivity = original.IfConditionActivity
type IfConditionActivityTypeProperties = original.IfConditionActivityTypeProperties
type ImpalaDatasetTypeProperties = original.ImpalaDatasetTypeProperties
type ImpalaLinkedService = original.ImpalaLinkedService
type ImpalaLinkedServiceTypeProperties = original.ImpalaLinkedServiceTypeProperties
type ImpalaObjectDataset = original.ImpalaObjectDataset
type ImpalaSource = original.ImpalaSource
type InformixLinkedService = original.InformixLinkedService
type InformixLinkedServiceTypeProperties = original.InformixLinkedServiceTypeProperties
type InformixSink = original.InformixSink
type InformixSource = original.InformixSource
type InformixTableDataset = original.InformixTableDataset
type InformixTableDatasetTypeProperties = original.InformixTableDatasetTypeProperties
type IntegrationRuntime = original.IntegrationRuntime
type IntegrationRuntimeComputeProperties = original.IntegrationRuntimeComputeProperties
type IntegrationRuntimeCustomSetupScriptProperties = original.IntegrationRuntimeCustomSetupScriptProperties
type IntegrationRuntimeDataFlowProperties = original.IntegrationRuntimeDataFlowProperties
type IntegrationRuntimeDataProxyProperties = original.IntegrationRuntimeDataProxyProperties
type IntegrationRuntimeListResponse = original.IntegrationRuntimeListResponse
type IntegrationRuntimeReference = original.IntegrationRuntimeReference
type IntegrationRuntimeResource = original.IntegrationRuntimeResource
type IntegrationRuntimeSsisCatalogInfo = original.IntegrationRuntimeSsisCatalogInfo
type IntegrationRuntimeSsisProperties = original.IntegrationRuntimeSsisProperties
type IntegrationRuntimeVNetProperties = original.IntegrationRuntimeVNetProperties
type IntegrationRuntimesClient = original.IntegrationRuntimesClient
type JSONDataset = original.JSONDataset
type JSONDatasetTypeProperties = original.JSONDatasetTypeProperties
type JSONFormat = original.JSONFormat
type JSONSink = original.JSONSink
type JSONSource = original.JSONSource
type JSONWriteSettings = original.JSONWriteSettings
type JiraLinkedService = original.JiraLinkedService
type JiraLinkedServiceTypeProperties = original.JiraLinkedServiceTypeProperties
type JiraObjectDataset = original.JiraObjectDataset
type JiraSource = original.JiraSource
type LibraryRequirements = original.LibraryRequirements
type LicensedComponentSetupTypeProperties = original.LicensedComponentSetupTypeProperties
type LinkedIntegrationRuntimeKeyAuthorization = original.LinkedIntegrationRuntimeKeyAuthorization
type LinkedIntegrationRuntimeRbacAuthorization = original.LinkedIntegrationRuntimeRbacAuthorization
type LinkedIntegrationRuntimeType = original.LinkedIntegrationRuntimeType
type LinkedService = original.LinkedService
type LinkedServiceClient = original.LinkedServiceClient
type LinkedServiceCreateOrUpdateLinkedServiceFuture = original.LinkedServiceCreateOrUpdateLinkedServiceFuture
type LinkedServiceDebugResource = original.LinkedServiceDebugResource
type LinkedServiceDeleteLinkedServiceFuture = original.LinkedServiceDeleteLinkedServiceFuture
type LinkedServiceListResponse = original.LinkedServiceListResponse
type LinkedServiceListResponseIterator = original.LinkedServiceListResponseIterator
type LinkedServiceListResponsePage = original.LinkedServiceListResponsePage
type LinkedServiceReference = original.LinkedServiceReference
type LinkedServiceRenameLinkedServiceFuture = original.LinkedServiceRenameLinkedServiceFuture
type LinkedServiceResource = original.LinkedServiceResource
type LogStorageSettings = original.LogStorageSettings
type LookupActivity = original.LookupActivity
type LookupActivityTypeProperties = original.LookupActivityTypeProperties
type MagentoLinkedService = original.MagentoLinkedService
type MagentoLinkedServiceTypeProperties = original.MagentoLinkedServiceTypeProperties
type MagentoObjectDataset = original.MagentoObjectDataset
type MagentoSource = original.MagentoSource
type ManagedIdentity = original.ManagedIdentity
type ManagedIntegrationRuntime = original.ManagedIntegrationRuntime
type ManagedIntegrationRuntimeTypeProperties = original.ManagedIntegrationRuntimeTypeProperties
type ManagedVirtualNetworkSettings = original.ManagedVirtualNetworkSettings
type MappingDataFlow = original.MappingDataFlow
type MappingDataFlowTypeProperties = original.MappingDataFlowTypeProperties
type MariaDBLinkedService = original.MariaDBLinkedService
type MariaDBLinkedServiceTypeProperties = original.MariaDBLinkedServiceTypeProperties
type MariaDBSource = original.MariaDBSource
type MariaDBTableDataset = original.MariaDBTableDataset
type MarketoLinkedService = original.MarketoLinkedService
type MarketoLinkedServiceTypeProperties = original.MarketoLinkedServiceTypeProperties
type MarketoObjectDataset = original.MarketoObjectDataset
type MarketoSource = original.MarketoSource
type MicrosoftAccessLinkedService = original.MicrosoftAccessLinkedService
type MicrosoftAccessLinkedServiceTypeProperties = original.MicrosoftAccessLinkedServiceTypeProperties
type MicrosoftAccessSink = original.MicrosoftAccessSink
type MicrosoftAccessSource = original.MicrosoftAccessSource
type MicrosoftAccessTableDataset = original.MicrosoftAccessTableDataset
type MicrosoftAccessTableDatasetTypeProperties = original.MicrosoftAccessTableDatasetTypeProperties
type MongoDbCollectionDataset = original.MongoDbCollectionDataset
type MongoDbCollectionDatasetTypeProperties = original.MongoDbCollectionDatasetTypeProperties
type MongoDbCursorMethodsProperties = original.MongoDbCursorMethodsProperties
type MongoDbLinkedService = original.MongoDbLinkedService
type MongoDbLinkedServiceTypeProperties = original.MongoDbLinkedServiceTypeProperties
type MongoDbSource = original.MongoDbSource
type MongoDbV2CollectionDataset = original.MongoDbV2CollectionDataset
type MongoDbV2CollectionDatasetTypeProperties = original.MongoDbV2CollectionDatasetTypeProperties
type MongoDbV2LinkedService = original.MongoDbV2LinkedService
type MongoDbV2LinkedServiceTypeProperties = original.MongoDbV2LinkedServiceTypeProperties
type MongoDbV2Source = original.MongoDbV2Source
type MultiplePipelineTrigger = original.MultiplePipelineTrigger
type MySQLLinkedService = original.MySQLLinkedService
type MySQLLinkedServiceTypeProperties = original.MySQLLinkedServiceTypeProperties
type MySQLSource = original.MySQLSource
type MySQLTableDataset = original.MySQLTableDataset
type MySQLTableDatasetTypeProperties = original.MySQLTableDatasetTypeProperties
type NetezzaLinkedService = original.NetezzaLinkedService
type NetezzaLinkedServiceTypeProperties = original.NetezzaLinkedServiceTypeProperties
type NetezzaPartitionSettings = original.NetezzaPartitionSettings
type NetezzaSource = original.NetezzaSource
type NetezzaTableDataset = original.NetezzaTableDataset
type NetezzaTableDatasetTypeProperties = original.NetezzaTableDatasetTypeProperties
type Notebook = original.Notebook
type NotebookCell = original.NotebookCell
type NotebookCellOutputItem = original.NotebookCellOutputItem
type NotebookClient = original.NotebookClient
type NotebookCreateOrUpdateNotebookFuture = original.NotebookCreateOrUpdateNotebookFuture
type NotebookDeleteNotebookFuture = original.NotebookDeleteNotebookFuture
type NotebookKernelSpec = original.NotebookKernelSpec
type NotebookLanguageInfo = original.NotebookLanguageInfo
type NotebookListResponse = original.NotebookListResponse
type NotebookListResponseIterator = original.NotebookListResponseIterator
type NotebookListResponsePage = original.NotebookListResponsePage
type NotebookMetadata = original.NotebookMetadata
type NotebookRenameNotebookFuture = original.NotebookRenameNotebookFuture
type NotebookResource = original.NotebookResource
type NotebookSessionProperties = original.NotebookSessionProperties
type ODataLinkedService = original.ODataLinkedService
type ODataLinkedServiceTypeProperties = original.ODataLinkedServiceTypeProperties
type ODataResourceDataset = original.ODataResourceDataset
type ODataResourceDatasetTypeProperties = original.ODataResourceDatasetTypeProperties
type ODataSource = original.ODataSource
type OdbcLinkedService = original.OdbcLinkedService
type OdbcLinkedServiceTypeProperties = original.OdbcLinkedServiceTypeProperties
type OdbcSink = original.OdbcSink
type OdbcSource = original.OdbcSource
type OdbcTableDataset = original.OdbcTableDataset
type OdbcTableDatasetTypeProperties = original.OdbcTableDatasetTypeProperties
type Office365Dataset = original.Office365Dataset
type Office365DatasetTypeProperties = original.Office365DatasetTypeProperties
type Office365LinkedService = original.Office365LinkedService
type Office365LinkedServiceTypeProperties = original.Office365LinkedServiceTypeProperties
type Office365Source = original.Office365Source
type OracleLinkedService = original.OracleLinkedService
type OracleLinkedServiceTypeProperties = original.OracleLinkedServiceTypeProperties
type OraclePartitionSettings = original.OraclePartitionSettings
type OracleServiceCloudLinkedService = original.OracleServiceCloudLinkedService
type OracleServiceCloudLinkedServiceTypeProperties = original.OracleServiceCloudLinkedServiceTypeProperties
type OracleServiceCloudObjectDataset = original.OracleServiceCloudObjectDataset
type OracleServiceCloudSource = original.OracleServiceCloudSource
type OracleSink = original.OracleSink
type OracleSource = original.OracleSource
type OracleTableDataset = original.OracleTableDataset
type OracleTableDatasetTypeProperties = original.OracleTableDatasetTypeProperties
type OrcDataset = original.OrcDataset
type OrcDatasetTypeProperties = original.OrcDatasetTypeProperties
type OrcFormat = original.OrcFormat
type OrcSink = original.OrcSink
type OrcSource = original.OrcSource
type ParameterSpecification = original.ParameterSpecification
type ParquetDataset = original.ParquetDataset
type ParquetDatasetTypeProperties = original.ParquetDatasetTypeProperties
type ParquetFormat = original.ParquetFormat
type ParquetSink = original.ParquetSink
type ParquetSource = original.ParquetSource
type PaypalLinkedService = original.PaypalLinkedService
type PaypalLinkedServiceTypeProperties = original.PaypalLinkedServiceTypeProperties
type PaypalObjectDataset = original.PaypalObjectDataset
type PaypalSource = original.PaypalSource
type PhoenixDatasetTypeProperties = original.PhoenixDatasetTypeProperties
type PhoenixLinkedService = original.PhoenixLinkedService
type PhoenixLinkedServiceTypeProperties = original.PhoenixLinkedServiceTypeProperties
type PhoenixObjectDataset = original.PhoenixObjectDataset
type PhoenixSource = original.PhoenixSource
type Pipeline = original.Pipeline
type PipelineClient = original.PipelineClient
type PipelineCreateOrUpdatePipelineFuture = original.PipelineCreateOrUpdatePipelineFuture
type PipelineDeletePipelineFuture = original.PipelineDeletePipelineFuture
type PipelineFolder = original.PipelineFolder
type PipelineListResponse = original.PipelineListResponse
type PipelineListResponseIterator = original.PipelineListResponseIterator
type PipelineListResponsePage = original.PipelineListResponsePage
type PipelineReference = original.PipelineReference
type PipelineRenamePipelineFuture = original.PipelineRenamePipelineFuture
type PipelineResource = original.PipelineResource
type PipelineRun = original.PipelineRun
type PipelineRunClient = original.PipelineRunClient
type PipelineRunInvokedBy = original.PipelineRunInvokedBy
type PipelineRunsQueryResponse = original.PipelineRunsQueryResponse
type PolybaseSettings = original.PolybaseSettings
type PostgreSQLLinkedService = original.PostgreSQLLinkedService
type PostgreSQLLinkedServiceTypeProperties = original.PostgreSQLLinkedServiceTypeProperties
type PostgreSQLSource = original.PostgreSQLSource
type PostgreSQLTableDataset = original.PostgreSQLTableDataset
type PostgreSQLTableDatasetTypeProperties = original.PostgreSQLTableDatasetTypeProperties
type PrestoDatasetTypeProperties = original.PrestoDatasetTypeProperties
type PrestoLinkedService = original.PrestoLinkedService
type PrestoLinkedServiceTypeProperties = original.PrestoLinkedServiceTypeProperties
type PrestoObjectDataset = original.PrestoObjectDataset
type PrestoSource = original.PrestoSource
type PrivateEndpoint = original.PrivateEndpoint
type PrivateEndpointConnection = original.PrivateEndpointConnection
type PrivateEndpointConnectionProperties = original.PrivateEndpointConnectionProperties
type PrivateLinkServiceConnectionState = original.PrivateLinkServiceConnectionState
type ProxyResource = original.ProxyResource
type PurviewConfiguration = original.PurviewConfiguration
type QueryDataFlowDebugSessionsResponse = original.QueryDataFlowDebugSessionsResponse
type QueryDataFlowDebugSessionsResponseIterator = original.QueryDataFlowDebugSessionsResponseIterator
type QueryDataFlowDebugSessionsResponsePage = original.QueryDataFlowDebugSessionsResponsePage
type QuickBooksLinkedService = original.QuickBooksLinkedService
type QuickBooksLinkedServiceTypeProperties = original.QuickBooksLinkedServiceTypeProperties
type QuickBooksObjectDataset = original.QuickBooksObjectDataset
type QuickBooksSource = original.QuickBooksSource
type RecurrenceSchedule = original.RecurrenceSchedule
type RecurrenceScheduleOccurrence = original.RecurrenceScheduleOccurrence
type RedirectIncompatibleRowSettings = original.RedirectIncompatibleRowSettings
type RedshiftUnloadSettings = original.RedshiftUnloadSettings
type RelationalSource = original.RelationalSource
type RelationalTableDataset = original.RelationalTableDataset
type RelationalTableDatasetTypeProperties = original.RelationalTableDatasetTypeProperties
type RenameRequest = original.RenameRequest
type RerunTriggerListResponse = original.RerunTriggerListResponse
type RerunTriggerResource = original.RerunTriggerResource
type RerunTumblingWindowTrigger = original.RerunTumblingWindowTrigger
type RerunTumblingWindowTriggerActionParameters = original.RerunTumblingWindowTriggerActionParameters
type RerunTumblingWindowTriggerTypeProperties = original.RerunTumblingWindowTriggerTypeProperties
type Resource = original.Resource
type ResponsysLinkedService = original.ResponsysLinkedService
type ResponsysLinkedServiceTypeProperties = original.ResponsysLinkedServiceTypeProperties
type ResponsysObjectDataset = original.ResponsysObjectDataset
type ResponsysSource = original.ResponsysSource
type RestResourceDataset = original.RestResourceDataset
type RestResourceDatasetTypeProperties = original.RestResourceDatasetTypeProperties
type RestServiceLinkedService = original.RestServiceLinkedService
type RestServiceLinkedServiceTypeProperties = original.RestServiceLinkedServiceTypeProperties
type RestSource = original.RestSource
type RetryPolicy = original.RetryPolicy
type RunFilterParameters = original.RunFilterParameters
type RunQueryFilter = original.RunQueryFilter
type RunQueryOrderBy = original.RunQueryOrderBy
type SQLConnection = original.SQLConnection
type SQLDWSink = original.SQLDWSink
type SQLDWSource = original.SQLDWSource
type SQLMISink = original.SQLMISink
type SQLMISource = original.SQLMISource
type SQLPool = original.SQLPool
type SQLPoolInfoListResult = original.SQLPoolInfoListResult
type SQLPoolReference = original.SQLPoolReference
type SQLPoolResourceProperties = original.SQLPoolResourceProperties
type SQLPoolStoredProcedureActivity = original.SQLPoolStoredProcedureActivity
type SQLPoolStoredProcedureActivityTypeProperties = original.SQLPoolStoredProcedureActivityTypeProperties
type SQLPoolsClient = original.SQLPoolsClient
type SQLScript = original.SQLScript
type SQLScriptClient = original.SQLScriptClient
type SQLScriptContent = original.SQLScriptContent
type SQLScriptMetadata = original.SQLScriptMetadata
type SQLScriptRenameSQLScriptFuture = original.SQLScriptRenameSQLScriptFuture
type SQLScriptResource = original.SQLScriptResource
type SQLScriptsListResponse = original.SQLScriptsListResponse
type SQLScriptsListResponseIterator = original.SQLScriptsListResponseIterator
type SQLScriptsListResponsePage = original.SQLScriptsListResponsePage
type SQLServerLinkedService = original.SQLServerLinkedService
type SQLServerLinkedServiceTypeProperties = original.SQLServerLinkedServiceTypeProperties
type SQLServerSink = original.SQLServerSink
type SQLServerSource = original.SQLServerSource
type SQLServerStoredProcedureActivity = original.SQLServerStoredProcedureActivity
type SQLServerStoredProcedureActivityTypeProperties = original.SQLServerStoredProcedureActivityTypeProperties
type SQLServerTableDataset = original.SQLServerTableDataset
type SQLServerTableDatasetTypeProperties = original.SQLServerTableDatasetTypeProperties
type SQLSink = original.SQLSink
type SQLSource = original.SQLSource
type SSISAccessCredential = original.SSISAccessCredential
type SSISChildPackage = original.SSISChildPackage
type SSISExecutionCredential = original.SSISExecutionCredential
type SSISExecutionParameter = original.SSISExecutionParameter
type SSISLogLocation = original.SSISLogLocation
type SSISLogLocationTypeProperties = original.SSISLogLocationTypeProperties
type SSISPackageLocation = original.SSISPackageLocation
type SSISPackageLocationTypeProperties = original.SSISPackageLocationTypeProperties
type SSISPropertyOverride = original.SSISPropertyOverride
type SalesforceLinkedService = original.SalesforceLinkedService
type SalesforceLinkedServiceTypeProperties = original.SalesforceLinkedServiceTypeProperties
type SalesforceMarketingCloudLinkedService = original.SalesforceMarketingCloudLinkedService
type SalesforceMarketingCloudLinkedServiceTypeProperties = original.SalesforceMarketingCloudLinkedServiceTypeProperties
type SalesforceMarketingCloudObjectDataset = original.SalesforceMarketingCloudObjectDataset
type SalesforceMarketingCloudSource = original.SalesforceMarketingCloudSource
type SalesforceObjectDataset = original.SalesforceObjectDataset
type SalesforceObjectDatasetTypeProperties = original.SalesforceObjectDatasetTypeProperties
type SalesforceServiceCloudLinkedService = original.SalesforceServiceCloudLinkedService
type SalesforceServiceCloudLinkedServiceTypeProperties = original.SalesforceServiceCloudLinkedServiceTypeProperties
type SalesforceServiceCloudObjectDataset = original.SalesforceServiceCloudObjectDataset
type SalesforceServiceCloudObjectDatasetTypeProperties = original.SalesforceServiceCloudObjectDatasetTypeProperties
type SalesforceServiceCloudSink = original.SalesforceServiceCloudSink
type SalesforceServiceCloudSource = original.SalesforceServiceCloudSource
type SalesforceSink = original.SalesforceSink
type SalesforceSource = original.SalesforceSource
type SapBWLinkedService = original.SapBWLinkedService
type SapBWLinkedServiceTypeProperties = original.SapBWLinkedServiceTypeProperties
type SapBwCubeDataset = original.SapBwCubeDataset
type SapBwSource = original.SapBwSource
type SapCloudForCustomerLinkedService = original.SapCloudForCustomerLinkedService
type SapCloudForCustomerLinkedServiceTypeProperties = original.SapCloudForCustomerLinkedServiceTypeProperties
type SapCloudForCustomerResourceDataset = original.SapCloudForCustomerResourceDataset
type SapCloudForCustomerResourceDatasetTypeProperties = original.SapCloudForCustomerResourceDatasetTypeProperties
type SapCloudForCustomerSink = original.SapCloudForCustomerSink
type SapCloudForCustomerSource = original.SapCloudForCustomerSource
type SapEccLinkedService = original.SapEccLinkedService
type SapEccLinkedServiceTypeProperties = original.SapEccLinkedServiceTypeProperties
type SapEccResourceDataset = original.SapEccResourceDataset
type SapEccResourceDatasetTypeProperties = original.SapEccResourceDatasetTypeProperties
type SapEccSource = original.SapEccSource
type SapHanaLinkedService = original.SapHanaLinkedService
type SapHanaLinkedServiceProperties = original.SapHanaLinkedServiceProperties
type SapHanaPartitionSettings = original.SapHanaPartitionSettings
type SapHanaSource = original.SapHanaSource
type SapHanaTableDataset = original.SapHanaTableDataset
type SapHanaTableDatasetTypeProperties = original.SapHanaTableDatasetTypeProperties
type SapOpenHubLinkedService = original.SapOpenHubLinkedService
type SapOpenHubLinkedServiceTypeProperties = original.SapOpenHubLinkedServiceTypeProperties
type SapOpenHubSource = original.SapOpenHubSource
type SapOpenHubTableDataset = original.SapOpenHubTableDataset
type SapOpenHubTableDatasetTypeProperties = original.SapOpenHubTableDatasetTypeProperties
type SapTableLinkedService = original.SapTableLinkedService
type SapTableLinkedServiceTypeProperties = original.SapTableLinkedServiceTypeProperties
type SapTablePartitionSettings = original.SapTablePartitionSettings
type SapTableResourceDataset = original.SapTableResourceDataset
type SapTableResourceDatasetTypeProperties = original.SapTableResourceDatasetTypeProperties
type SapTableSource = original.SapTableSource
type ScheduleTrigger = original.ScheduleTrigger
type ScheduleTriggerRecurrence = original.ScheduleTriggerRecurrence
type ScheduleTriggerTypeProperties = original.ScheduleTriggerTypeProperties
type ScriptAction = original.ScriptAction
type SecretBase = original.SecretBase
type SecureString = original.SecureString
type SelfDependencyTumblingWindowTriggerReference = original.SelfDependencyTumblingWindowTriggerReference
type SelfHostedIntegrationRuntime = original.SelfHostedIntegrationRuntime
type SelfHostedIntegrationRuntimeTypeProperties = original.SelfHostedIntegrationRuntimeTypeProperties
type ServiceNowLinkedService = original.ServiceNowLinkedService
type ServiceNowLinkedServiceTypeProperties = original.ServiceNowLinkedServiceTypeProperties
type ServiceNowObjectDataset = original.ServiceNowObjectDataset
type ServiceNowSource = original.ServiceNowSource
type SetVariableActivity = original.SetVariableActivity
type SetVariableActivityTypeProperties = original.SetVariableActivityTypeProperties
type SftpLocation = original.SftpLocation
type SftpReadSettings = original.SftpReadSettings
type SftpServerLinkedService = original.SftpServerLinkedService
type SftpServerLinkedServiceTypeProperties = original.SftpServerLinkedServiceTypeProperties
type SftpWriteSettings = original.SftpWriteSettings
type ShopifyLinkedService = original.ShopifyLinkedService
type ShopifyLinkedServiceTypeProperties = original.ShopifyLinkedServiceTypeProperties
type ShopifyObjectDataset = original.ShopifyObjectDataset
type ShopifySource = original.ShopifySource
type Sku = original.Sku
type SparkBatchJob = original.SparkBatchJob
type SparkBatchJobState = original.SparkBatchJobState
type SparkDatasetTypeProperties = original.SparkDatasetTypeProperties
type SparkJobDefinition = original.SparkJobDefinition
type SparkJobDefinitionClient = original.SparkJobDefinitionClient
type SparkJobDefinitionDebugSparkJobDefinitionFuture = original.SparkJobDefinitionDebugSparkJobDefinitionFuture
type SparkJobDefinitionExecuteSparkJobDefinitionFuture = original.SparkJobDefinitionExecuteSparkJobDefinitionFuture
type SparkJobDefinitionRenameSparkJobDefinitionFuture = original.SparkJobDefinitionRenameSparkJobDefinitionFuture
type SparkJobDefinitionResource = original.SparkJobDefinitionResource
type SparkJobDefinitionsListResponse = original.SparkJobDefinitionsListResponse
type SparkJobDefinitionsListResponseIterator = original.SparkJobDefinitionsListResponseIterator
type SparkJobDefinitionsListResponsePage = original.SparkJobDefinitionsListResponsePage
type SparkJobProperties = original.SparkJobProperties
type SparkLinkedService = original.SparkLinkedService
type SparkLinkedServiceTypeProperties = original.SparkLinkedServiceTypeProperties
type SparkObjectDataset = original.SparkObjectDataset
type SparkRequest = original.SparkRequest
type SparkScheduler = original.SparkScheduler
type SparkServiceError = original.SparkServiceError
type SparkServicePlugin = original.SparkServicePlugin
type SparkSource = original.SparkSource
type SquareLinkedService = original.SquareLinkedService
type SquareLinkedServiceTypeProperties = original.SquareLinkedServiceTypeProperties
type SquareObjectDataset = original.SquareObjectDataset
type SquareSource = original.SquareSource
type SsisObjectMetadataStatusResponse = original.SsisObjectMetadataStatusResponse
type StagingSettings = original.StagingSettings
type StartDataFlowDebugSessionRequest = original.StartDataFlowDebugSessionRequest
type StartDataFlowDebugSessionResponse = original.StartDataFlowDebugSessionResponse
type StoreReadSettings = original.StoreReadSettings
type StoreWriteSettings = original.StoreWriteSettings
type StoredProcedureParameter = original.StoredProcedureParameter
type SubResource = original.SubResource
type SubResourceDebugResource = original.SubResourceDebugResource
type SwitchActivity = original.SwitchActivity
type SwitchActivityTypeProperties = original.SwitchActivityTypeProperties
type SwitchCase = original.SwitchCase
type SybaseLinkedService = original.SybaseLinkedService
type SybaseLinkedServiceTypeProperties = original.SybaseLinkedServiceTypeProperties
type SybaseSource = original.SybaseSource
type SybaseTableDataset = original.SybaseTableDataset
type SybaseTableDatasetTypeProperties = original.SybaseTableDatasetTypeProperties
type SynapseNotebookActivity = original.SynapseNotebookActivity
type SynapseNotebookActivityTypeProperties = original.SynapseNotebookActivityTypeProperties
type SynapseNotebookReference = original.SynapseNotebookReference
type SynapseSparkJobActivityTypeProperties = original.SynapseSparkJobActivityTypeProperties
type SynapseSparkJobDefinitionActivity = original.SynapseSparkJobDefinitionActivity
type SynapseSparkJobReference = original.SynapseSparkJobReference
type TabularSource = original.TabularSource
type TabularTranslator = original.TabularTranslator
type TeradataLinkedService = original.TeradataLinkedService
type TeradataLinkedServiceTypeProperties = original.TeradataLinkedServiceTypeProperties
type TeradataPartitionSettings = original.TeradataPartitionSettings
type TeradataSource = original.TeradataSource
type TeradataTableDataset = original.TeradataTableDataset
type TeradataTableDatasetTypeProperties = original.TeradataTableDatasetTypeProperties
type TextFormat = original.TextFormat
type TrackedResource = original.TrackedResource
type Transformation = original.Transformation
type Trigger = original.Trigger
type TriggerClient = original.TriggerClient
type TriggerCreateOrUpdateTriggerFuture = original.TriggerCreateOrUpdateTriggerFuture
type TriggerDeleteTriggerFuture = original.TriggerDeleteTriggerFuture
type TriggerDependencyProvisioningStatus = original.TriggerDependencyProvisioningStatus
type TriggerDependencyReference = original.TriggerDependencyReference
type TriggerListResponse = original.TriggerListResponse
type TriggerListResponseIterator = original.TriggerListResponseIterator
type TriggerListResponsePage = original.TriggerListResponsePage
type TriggerPipelineReference = original.TriggerPipelineReference
type TriggerReference = original.TriggerReference
type TriggerResource = original.TriggerResource
type TriggerRun = original.TriggerRun
type TriggerRunClient = original.TriggerRunClient
type TriggerRunsQueryResponse = original.TriggerRunsQueryResponse
type TriggerStartTriggerFuture = original.TriggerStartTriggerFuture
type TriggerStopTriggerFuture = original.TriggerStopTriggerFuture
type TriggerSubscribeTriggerToEventsFuture = original.TriggerSubscribeTriggerToEventsFuture
type TriggerSubscriptionOperationStatus = original.TriggerSubscriptionOperationStatus
type TriggerUnsubscribeTriggerFromEventsFuture = original.TriggerUnsubscribeTriggerFromEventsFuture
type TumblingWindowTrigger = original.TumblingWindowTrigger
type TumblingWindowTriggerDependencyReference = original.TumblingWindowTriggerDependencyReference
type TumblingWindowTriggerTypeProperties = original.TumblingWindowTriggerTypeProperties
type UntilActivity = original.UntilActivity
type UntilActivityTypeProperties = original.UntilActivityTypeProperties
type UserProperty = original.UserProperty
type ValidationActivity = original.ValidationActivity
type ValidationActivityTypeProperties = original.ValidationActivityTypeProperties
type VariableSpecification = original.VariableSpecification
type VerticaDatasetTypeProperties = original.VerticaDatasetTypeProperties
type VerticaLinkedService = original.VerticaLinkedService
type VerticaLinkedServiceTypeProperties = original.VerticaLinkedServiceTypeProperties
type VerticaSource = original.VerticaSource
type VerticaTableDataset = original.VerticaTableDataset
type VirtualNetworkProfile = original.VirtualNetworkProfile
type WaitActivity = original.WaitActivity
type WaitActivityTypeProperties = original.WaitActivityTypeProperties
type WebActivity = original.WebActivity
type WebActivityAuthentication = original.WebActivityAuthentication
type WebActivityTypeProperties = original.WebActivityTypeProperties
type WebAnonymousAuthentication = original.WebAnonymousAuthentication
type WebBasicAuthentication = original.WebBasicAuthentication
type WebClientCertificateAuthentication = original.WebClientCertificateAuthentication
type WebHookActivity = original.WebHookActivity
type WebHookActivityTypeProperties = original.WebHookActivityTypeProperties
type WebLinkedService = original.WebLinkedService
type WebLinkedServiceTypeProperties = original.WebLinkedServiceTypeProperties
type WebSource = original.WebSource
type WebTableDataset = original.WebTableDataset
type WebTableDatasetTypeProperties = original.WebTableDatasetTypeProperties
type Workspace = original.Workspace
type WorkspaceClient = original.WorkspaceClient
type WorkspaceGitRepoManagementClient = original.WorkspaceGitRepoManagementClient
type WorkspaceIdentity = original.WorkspaceIdentity
type WorkspaceKeyDetails = original.WorkspaceKeyDetails
type WorkspaceProperties = original.WorkspaceProperties
type WorkspaceRepositoryConfiguration = original.WorkspaceRepositoryConfiguration
type WorkspaceUpdateParameters = original.WorkspaceUpdateParameters
type XeroLinkedService = original.XeroLinkedService
type XeroLinkedServiceTypeProperties = original.XeroLinkedServiceTypeProperties
type XeroObjectDataset = original.XeroObjectDataset
type XeroSource = original.XeroSource
type ZohoLinkedService = original.ZohoLinkedService
type ZohoLinkedServiceTypeProperties = original.ZohoLinkedServiceTypeProperties
type ZohoObjectDataset = original.ZohoObjectDataset
type ZohoSource = original.ZohoSource

func New(endpoint string) BaseClient {
	return original.New(endpoint)
}
func NewBigDataPoolsClient(endpoint string) BigDataPoolsClient {
	return original.NewBigDataPoolsClient(endpoint)
}
func NewDataFlowClient(endpoint string) DataFlowClient {
	return original.NewDataFlowClient(endpoint)
}
func NewDataFlowDebugSessionClient(endpoint string) DataFlowDebugSessionClient {
	return original.NewDataFlowDebugSessionClient(endpoint)
}
func NewDataFlowListResponseIterator(page DataFlowListResponsePage) DataFlowListResponseIterator {
	return original.NewDataFlowListResponseIterator(page)
}
func NewDataFlowListResponsePage(cur DataFlowListResponse, getNextPage func(context.Context, DataFlowListResponse) (DataFlowListResponse, error)) DataFlowListResponsePage {
	return original.NewDataFlowListResponsePage(cur, getNextPage)
}
func NewDatasetClient(endpoint string) DatasetClient {
	return original.NewDatasetClient(endpoint)
}
func NewDatasetListResponseIterator(page DatasetListResponsePage) DatasetListResponseIterator {
	return original.NewDatasetListResponseIterator(page)
}
func NewDatasetListResponsePage(cur DatasetListResponse, getNextPage func(context.Context, DatasetListResponse) (DatasetListResponse, error)) DatasetListResponsePage {
	return original.NewDatasetListResponsePage(cur, getNextPage)
}
func NewIntegrationRuntimesClient(endpoint string) IntegrationRuntimesClient {
	return original.NewIntegrationRuntimesClient(endpoint)
}
func NewLinkedServiceClient(endpoint string) LinkedServiceClient {
	return original.NewLinkedServiceClient(endpoint)
}
func NewLinkedServiceListResponseIterator(page LinkedServiceListResponsePage) LinkedServiceListResponseIterator {
	return original.NewLinkedServiceListResponseIterator(page)
}
func NewLinkedServiceListResponsePage(cur LinkedServiceListResponse, getNextPage func(context.Context, LinkedServiceListResponse) (LinkedServiceListResponse, error)) LinkedServiceListResponsePage {
	return original.NewLinkedServiceListResponsePage(cur, getNextPage)
}
func NewNotebookClient(endpoint string) NotebookClient {
	return original.NewNotebookClient(endpoint)
}
func NewNotebookListResponseIterator(page NotebookListResponsePage) NotebookListResponseIterator {
	return original.NewNotebookListResponseIterator(page)
}
func NewNotebookListResponsePage(cur NotebookListResponse, getNextPage func(context.Context, NotebookListResponse) (NotebookListResponse, error)) NotebookListResponsePage {
	return original.NewNotebookListResponsePage(cur, getNextPage)
}
func NewPipelineClient(endpoint string) PipelineClient {
	return original.NewPipelineClient(endpoint)
}
func NewPipelineListResponseIterator(page PipelineListResponsePage) PipelineListResponseIterator {
	return original.NewPipelineListResponseIterator(page)
}
func NewPipelineListResponsePage(cur PipelineListResponse, getNextPage func(context.Context, PipelineListResponse) (PipelineListResponse, error)) PipelineListResponsePage {
	return original.NewPipelineListResponsePage(cur, getNextPage)
}
func NewPipelineRunClient(endpoint string) PipelineRunClient {
	return original.NewPipelineRunClient(endpoint)
}
func NewQueryDataFlowDebugSessionsResponseIterator(page QueryDataFlowDebugSessionsResponsePage) QueryDataFlowDebugSessionsResponseIterator {
	return original.NewQueryDataFlowDebugSessionsResponseIterator(page)
}
func NewQueryDataFlowDebugSessionsResponsePage(cur QueryDataFlowDebugSessionsResponse, getNextPage func(context.Context, QueryDataFlowDebugSessionsResponse) (QueryDataFlowDebugSessionsResponse, error)) QueryDataFlowDebugSessionsResponsePage {
	return original.NewQueryDataFlowDebugSessionsResponsePage(cur, getNextPage)
}
func NewSQLPoolsClient(endpoint string) SQLPoolsClient {
	return original.NewSQLPoolsClient(endpoint)
}
func NewSQLScriptClient(endpoint string) SQLScriptClient {
	return original.NewSQLScriptClient(endpoint)
}
func NewSQLScriptsListResponseIterator(page SQLScriptsListResponsePage) SQLScriptsListResponseIterator {
	return original.NewSQLScriptsListResponseIterator(page)
}
func NewSQLScriptsListResponsePage(cur SQLScriptsListResponse, getNextPage func(context.Context, SQLScriptsListResponse) (SQLScriptsListResponse, error)) SQLScriptsListResponsePage {
	return original.NewSQLScriptsListResponsePage(cur, getNextPage)
}
func NewSparkJobDefinitionClient(endpoint string) SparkJobDefinitionClient {
	return original.NewSparkJobDefinitionClient(endpoint)
}
func NewSparkJobDefinitionsListResponseIterator(page SparkJobDefinitionsListResponsePage) SparkJobDefinitionsListResponseIterator {
	return original.NewSparkJobDefinitionsListResponseIterator(page)
}
func NewSparkJobDefinitionsListResponsePage(cur SparkJobDefinitionsListResponse, getNextPage func(context.Context, SparkJobDefinitionsListResponse) (SparkJobDefinitionsListResponse, error)) SparkJobDefinitionsListResponsePage {
	return original.NewSparkJobDefinitionsListResponsePage(cur, getNextPage)
}
func NewTriggerClient(endpoint string) TriggerClient {
	return original.NewTriggerClient(endpoint)
}
func NewTriggerListResponseIterator(page TriggerListResponsePage) TriggerListResponseIterator {
	return original.NewTriggerListResponseIterator(page)
}
func NewTriggerListResponsePage(cur TriggerListResponse, getNextPage func(context.Context, TriggerListResponse) (TriggerListResponse, error)) TriggerListResponsePage {
	return original.NewTriggerListResponsePage(cur, getNextPage)
}
func NewTriggerRunClient(endpoint string) TriggerRunClient {
	return original.NewTriggerRunClient(endpoint)
}
func NewWithoutDefaults(endpoint string) BaseClient {
	return original.NewWithoutDefaults(endpoint)
}
func NewWorkspaceClient(endpoint string) WorkspaceClient {
	return original.NewWorkspaceClient(endpoint)
}
func NewWorkspaceGitRepoManagementClient(endpoint string) WorkspaceGitRepoManagementClient {
	return original.NewWorkspaceGitRepoManagementClient(endpoint)
}
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return original.PossibleAuthenticationTypeValues()
}
func PossibleAuthorizationTypeValues() []AuthorizationType {
	return original.PossibleAuthorizationTypeValues()
}
func PossibleAvroCompressionCodecValues() []AvroCompressionCodec {
	return original.PossibleAvroCompressionCodecValues()
}
func PossibleAzureFunctionActivityMethodValues() []AzureFunctionActivityMethod {
	return original.PossibleAzureFunctionActivityMethodValues()
}
func PossibleAzureSearchIndexWriteBehaviorTypeValues() []AzureSearchIndexWriteBehaviorType {
	return original.PossibleAzureSearchIndexWriteBehaviorTypeValues()
}
func PossibleBlobEventTypesValues() []BlobEventTypes {
	return original.PossibleBlobEventTypesValues()
}
func PossibleCassandraSourceReadConsistencyLevelsValues() []CassandraSourceReadConsistencyLevels {
	return original.PossibleCassandraSourceReadConsistencyLevelsValues()
}
func PossibleCellOutputTypeValues() []CellOutputType {
	return original.PossibleCellOutputTypeValues()
}
func PossibleCopyBehaviorTypeValues() []CopyBehaviorType {
	return original.PossibleCopyBehaviorTypeValues()
}
func PossibleDataFlowComputeTypeValues() []DataFlowComputeType {
	return original.PossibleDataFlowComputeTypeValues()
}
func PossibleDatasetCompressionLevelValues() []DatasetCompressionLevel {
	return original.PossibleDatasetCompressionLevelValues()
}
func PossibleDayOfWeekValues() []DayOfWeek {
	return original.PossibleDayOfWeekValues()
}
func PossibleDb2AuthenticationTypeValues() []Db2AuthenticationType {
	return original.PossibleDb2AuthenticationTypeValues()
}
func PossibleDelimitedTextCompressionCodecValues() []DelimitedTextCompressionCodec {
	return original.PossibleDelimitedTextCompressionCodecValues()
}
func PossibleDependencyConditionValues() []DependencyCondition {
	return original.PossibleDependencyConditionValues()
}
func PossibleDynamicsAuthenticationTypeValues() []DynamicsAuthenticationType {
	return original.PossibleDynamicsAuthenticationTypeValues()
}
func PossibleDynamicsDeploymentTypeValues() []DynamicsDeploymentType {
	return original.PossibleDynamicsDeploymentTypeValues()
}
func PossibleDynamicsServicePrincipalCredentialTypeValues() []DynamicsServicePrincipalCredentialType {
	return original.PossibleDynamicsServicePrincipalCredentialTypeValues()
}
func PossibleEventSubscriptionStatusValues() []EventSubscriptionStatus {
	return original.PossibleEventSubscriptionStatusValues()
}
func PossibleFtpAuthenticationTypeValues() []FtpAuthenticationType {
	return original.PossibleFtpAuthenticationTypeValues()
}
func PossibleGoogleAdWordsAuthenticationTypeValues() []GoogleAdWordsAuthenticationType {
	return original.PossibleGoogleAdWordsAuthenticationTypeValues()
}
func PossibleGoogleBigQueryAuthenticationTypeValues() []GoogleBigQueryAuthenticationType {
	return original.PossibleGoogleBigQueryAuthenticationTypeValues()
}
func PossibleHBaseAuthenticationTypeValues() []HBaseAuthenticationType {
	return original.PossibleHBaseAuthenticationTypeValues()
}
func PossibleHDInsightActivityDebugInfoOptionValues() []HDInsightActivityDebugInfoOption {
	return original.PossibleHDInsightActivityDebugInfoOptionValues()
}
func PossibleHTTPAuthenticationTypeValues() []HTTPAuthenticationType {
	return original.PossibleHTTPAuthenticationTypeValues()
}
func PossibleHdiNodeTypesValues() []HdiNodeTypes {
	return original.PossibleHdiNodeTypesValues()
}
func PossibleHiveAuthenticationTypeValues() []HiveAuthenticationType {
	return original.PossibleHiveAuthenticationTypeValues()
}
func PossibleHiveServerTypeValues() []HiveServerType {
	return original.PossibleHiveServerTypeValues()
}
func PossibleHiveThriftTransportProtocolValues() []HiveThriftTransportProtocol {
	return original.PossibleHiveThriftTransportProtocolValues()
}
func PossibleImpalaAuthenticationTypeValues() []ImpalaAuthenticationType {
	return original.PossibleImpalaAuthenticationTypeValues()
}
func PossibleIntegrationRuntimeEditionValues() []IntegrationRuntimeEdition {
	return original.PossibleIntegrationRuntimeEditionValues()
}
func PossibleIntegrationRuntimeEntityReferenceTypeValues() []IntegrationRuntimeEntityReferenceType {
	return original.PossibleIntegrationRuntimeEntityReferenceTypeValues()
}
func PossibleIntegrationRuntimeLicenseTypeValues() []IntegrationRuntimeLicenseType {
	return original.PossibleIntegrationRuntimeLicenseTypeValues()
}
func PossibleIntegrationRuntimeSsisCatalogPricingTierValues() []IntegrationRuntimeSsisCatalogPricingTier {
	return original.PossibleIntegrationRuntimeSsisCatalogPricingTierValues()
}
func PossibleIntegrationRuntimeStateValues() []IntegrationRuntimeState {
	return original.PossibleIntegrationRuntimeStateValues()
}
func PossibleIntegrationRuntimeTypeValues() []IntegrationRuntimeType {
	return original.PossibleIntegrationRuntimeTypeValues()
}
func PossibleJSONFormatFilePatternValues() []JSONFormatFilePattern {
	return original.PossibleJSONFormatFilePatternValues()
}
func PossibleJSONWriteFilePatternValues() []JSONWriteFilePattern {
	return original.PossibleJSONWriteFilePatternValues()
}
func PossibleMongoDbAuthenticationTypeValues() []MongoDbAuthenticationType {
	return original.PossibleMongoDbAuthenticationTypeValues()
}
func PossibleNetezzaPartitionOptionValues() []NetezzaPartitionOption {
	return original.PossibleNetezzaPartitionOptionValues()
}
func PossibleNodeSizeFamilyValues() []NodeSizeFamily {
	return original.PossibleNodeSizeFamilyValues()
}
func PossibleNodeSizeValues() []NodeSize {
	return original.PossibleNodeSizeValues()
}
func PossibleODataAadServicePrincipalCredentialTypeValues() []ODataAadServicePrincipalCredentialType {
	return original.PossibleODataAadServicePrincipalCredentialTypeValues()
}
func PossibleODataAuthenticationTypeValues() []ODataAuthenticationType {
	return original.PossibleODataAuthenticationTypeValues()
}
func PossibleOraclePartitionOptionValues() []OraclePartitionOption {
	return original.PossibleOraclePartitionOptionValues()
}
func PossibleOrcCompressionCodecValues() []OrcCompressionCodec {
	return original.PossibleOrcCompressionCodecValues()
}
func PossibleParameterTypeValues() []ParameterType {
	return original.PossibleParameterTypeValues()
}
func PossibleParquetCompressionCodecValues() []ParquetCompressionCodec {
	return original.PossibleParquetCompressionCodecValues()
}
func PossiblePhoenixAuthenticationTypeValues() []PhoenixAuthenticationType {
	return original.PossiblePhoenixAuthenticationTypeValues()
}
func PossiblePluginCurrentStateValues() []PluginCurrentState {
	return original.PossiblePluginCurrentStateValues()
}
func PossiblePolybaseSettingsRejectTypeValues() []PolybaseSettingsRejectType {
	return original.PossiblePolybaseSettingsRejectTypeValues()
}
func PossiblePrestoAuthenticationTypeValues() []PrestoAuthenticationType {
	return original.PossiblePrestoAuthenticationTypeValues()
}
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return original.PossibleRecurrenceFrequencyValues()
}
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return original.PossibleResourceIdentityTypeValues()
}
func PossibleRestServiceAuthenticationTypeValues() []RestServiceAuthenticationType {
	return original.PossibleRestServiceAuthenticationTypeValues()
}
func PossibleRunQueryFilterOperandValues() []RunQueryFilterOperand {
	return original.PossibleRunQueryFilterOperandValues()
}
func PossibleRunQueryFilterOperatorValues() []RunQueryFilterOperator {
	return original.PossibleRunQueryFilterOperatorValues()
}
func PossibleRunQueryOrderByFieldValues() []RunQueryOrderByField {
	return original.PossibleRunQueryOrderByFieldValues()
}
func PossibleRunQueryOrderValues() []RunQueryOrder {
	return original.PossibleRunQueryOrderValues()
}
func PossibleSQLConnectionTypeValues() []SQLConnectionType {
	return original.PossibleSQLConnectionTypeValues()
}
func PossibleSQLScriptTypeValues() []SQLScriptType {
	return original.PossibleSQLScriptTypeValues()
}
func PossibleSalesforceSinkWriteBehaviorValues() []SalesforceSinkWriteBehavior {
	return original.PossibleSalesforceSinkWriteBehaviorValues()
}
func PossibleSalesforceSourceReadBehaviorValues() []SalesforceSourceReadBehavior {
	return original.PossibleSalesforceSourceReadBehaviorValues()
}
func PossibleSapCloudForCustomerSinkWriteBehaviorValues() []SapCloudForCustomerSinkWriteBehavior {
	return original.PossibleSapCloudForCustomerSinkWriteBehaviorValues()
}
func PossibleSapHanaAuthenticationTypeValues() []SapHanaAuthenticationType {
	return original.PossibleSapHanaAuthenticationTypeValues()
}
func PossibleSapHanaPartitionOptionValues() []SapHanaPartitionOption {
	return original.PossibleSapHanaPartitionOptionValues()
}
func PossibleSapTablePartitionOptionValues() []SapTablePartitionOption {
	return original.PossibleSapTablePartitionOptionValues()
}
func PossibleSchedulerCurrentStateValues() []SchedulerCurrentState {
	return original.PossibleSchedulerCurrentStateValues()
}
func PossibleServiceNowAuthenticationTypeValues() []ServiceNowAuthenticationType {
	return original.PossibleServiceNowAuthenticationTypeValues()
}
func PossibleSftpAuthenticationTypeValues() []SftpAuthenticationType {
	return original.PossibleSftpAuthenticationTypeValues()
}
func PossibleSparkAuthenticationTypeValues() []SparkAuthenticationType {
	return original.PossibleSparkAuthenticationTypeValues()
}
func PossibleSparkBatchJobResultTypeValues() []SparkBatchJobResultType {
	return original.PossibleSparkBatchJobResultTypeValues()
}
func PossibleSparkErrorSourceValues() []SparkErrorSource {
	return original.PossibleSparkErrorSourceValues()
}
func PossibleSparkJobTypeValues() []SparkJobType {
	return original.PossibleSparkJobTypeValues()
}
func PossibleSparkServerTypeValues() []SparkServerType {
	return original.PossibleSparkServerTypeValues()
}
func PossibleSparkThriftTransportProtocolValues() []SparkThriftTransportProtocol {
	return original.PossibleSparkThriftTransportProtocolValues()
}
func PossibleSsisPackageLocationTypeValues() []SsisPackageLocationType {
	return original.PossibleSsisPackageLocationTypeValues()
}
func PossibleStoredProcedureParameterTypeValues() []StoredProcedureParameterType {
	return original.PossibleStoredProcedureParameterTypeValues()
}
func PossibleSybaseAuthenticationTypeValues() []SybaseAuthenticationType {
	return original.PossibleSybaseAuthenticationTypeValues()
}
func PossibleTeradataAuthenticationTypeValues() []TeradataAuthenticationType {
	return original.PossibleTeradataAuthenticationTypeValues()
}
func PossibleTeradataPartitionOptionValues() []TeradataPartitionOption {
	return original.PossibleTeradataPartitionOptionValues()
}
func PossibleTriggerRunStatusValues() []TriggerRunStatus {
	return original.PossibleTriggerRunStatusValues()
}
func PossibleTriggerRuntimeStateValues() []TriggerRuntimeState {
	return original.PossibleTriggerRuntimeStateValues()
}
func PossibleTumblingWindowFrequencyValues() []TumblingWindowFrequency {
	return original.PossibleTumblingWindowFrequencyValues()
}
func PossibleTypeBasicActivityValues() []TypeBasicActivity {
	return original.PossibleTypeBasicActivityValues()
}
func PossibleTypeBasicCopySinkValues() []TypeBasicCopySink {
	return original.PossibleTypeBasicCopySinkValues()
}
func PossibleTypeBasicCopySourceValues() []TypeBasicCopySource {
	return original.PossibleTypeBasicCopySourceValues()
}
func PossibleTypeBasicCopyTranslatorValues() []TypeBasicCopyTranslator {
	return original.PossibleTypeBasicCopyTranslatorValues()
}
func PossibleTypeBasicCustomSetupBaseValues() []TypeBasicCustomSetupBase {
	return original.PossibleTypeBasicCustomSetupBaseValues()
}
func PossibleTypeBasicDataFlowValues() []TypeBasicDataFlow {
	return original.PossibleTypeBasicDataFlowValues()
}
func PossibleTypeBasicDatasetCompressionValues() []TypeBasicDatasetCompression {
	return original.PossibleTypeBasicDatasetCompressionValues()
}
func PossibleTypeBasicDatasetLocationValues() []TypeBasicDatasetLocation {
	return original.PossibleTypeBasicDatasetLocationValues()
}
func PossibleTypeBasicDatasetStorageFormatValues() []TypeBasicDatasetStorageFormat {
	return original.PossibleTypeBasicDatasetStorageFormatValues()
}
func PossibleTypeBasicDatasetValues() []TypeBasicDataset {
	return original.PossibleTypeBasicDatasetValues()
}
func PossibleTypeBasicDependencyReferenceValues() []TypeBasicDependencyReference {
	return original.PossibleTypeBasicDependencyReferenceValues()
}
func PossibleTypeBasicFormatReadSettingsValues() []TypeBasicFormatReadSettings {
	return original.PossibleTypeBasicFormatReadSettingsValues()
}
func PossibleTypeBasicFormatWriteSettingsValues() []TypeBasicFormatWriteSettings {
	return original.PossibleTypeBasicFormatWriteSettingsValues()
}
func PossibleTypeBasicIntegrationRuntimeValues() []TypeBasicIntegrationRuntime {
	return original.PossibleTypeBasicIntegrationRuntimeValues()
}
func PossibleTypeBasicLinkedServiceValues() []TypeBasicLinkedService {
	return original.PossibleTypeBasicLinkedServiceValues()
}
func PossibleTypeBasicStoreReadSettingsValues() []TypeBasicStoreReadSettings {
	return original.PossibleTypeBasicStoreReadSettingsValues()
}
func PossibleTypeBasicStoreWriteSettingsValues() []TypeBasicStoreWriteSettings {
	return original.PossibleTypeBasicStoreWriteSettingsValues()
}
func PossibleTypeBasicTriggerValues() []TypeBasicTrigger {
	return original.PossibleTypeBasicTriggerValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func PossibleVariableTypeValues() []VariableType {
	return original.PossibleVariableTypeValues()
}
func PossibleWebActivityMethodValues() []WebActivityMethod {
	return original.PossibleWebActivityMethodValues()
}
func PossibleWebHookActivityMethodValues() []WebHookActivityMethod {
	return original.PossibleWebHookActivityMethodValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
