// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartMLEvaluationTaskRunInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the machine learning transform.
	//
	// TransformId is a required field
	TransformId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartMLEvaluationTaskRunInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMLEvaluationTaskRunInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartMLEvaluationTaskRunInput"}

	if s.TransformId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformId"))
	}
	if s.TransformId != nil && len(*s.TransformId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TransformId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartMLEvaluationTaskRunOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier associated with this run.
	TaskRunId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartMLEvaluationTaskRunOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartMLEvaluationTaskRun = "StartMLEvaluationTaskRun"

// StartMLEvaluationTaskRunRequest returns a request value for making API operation for
// AWS Glue.
//
// Starts a task to estimate the quality of the transform.
//
// When you provide label sets as examples of truth, AWS Glue machine learning
// uses some of those examples to learn from them. The rest of the labels are
// used as a test to estimate quality.
//
// Returns a unique identifier for the run. You can call GetMLTaskRun to get
// more information about the stats of the EvaluationTaskRun.
//
//    // Example sending a request using StartMLEvaluationTaskRunRequest.
//    req := client.StartMLEvaluationTaskRunRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartMLEvaluationTaskRun
func (c *Client) StartMLEvaluationTaskRunRequest(input *StartMLEvaluationTaskRunInput) StartMLEvaluationTaskRunRequest {
	op := &aws.Operation{
		Name:       opStartMLEvaluationTaskRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMLEvaluationTaskRunInput{}
	}

	req := c.newRequest(op, input, &StartMLEvaluationTaskRunOutput{})
	return StartMLEvaluationTaskRunRequest{Request: req, Input: input, Copy: c.StartMLEvaluationTaskRunRequest}
}

// StartMLEvaluationTaskRunRequest is the request type for the
// StartMLEvaluationTaskRun API operation.
type StartMLEvaluationTaskRunRequest struct {
	*aws.Request
	Input *StartMLEvaluationTaskRunInput
	Copy  func(*StartMLEvaluationTaskRunInput) StartMLEvaluationTaskRunRequest
}

// Send marshals and sends the StartMLEvaluationTaskRun API request.
func (r StartMLEvaluationTaskRunRequest) Send(ctx context.Context) (*StartMLEvaluationTaskRunResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartMLEvaluationTaskRunResponse{
		StartMLEvaluationTaskRunOutput: r.Request.Data.(*StartMLEvaluationTaskRunOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartMLEvaluationTaskRunResponse is the response type for the
// StartMLEvaluationTaskRun API operation.
type StartMLEvaluationTaskRunResponse struct {
	*StartMLEvaluationTaskRunOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartMLEvaluationTaskRun request.
func (r *StartMLEvaluationTaskRunResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
