// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package globalaccelerator

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeEndpointGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint group to describe.
	//
	// EndpointGroupArn is a required field
	EndpointGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeEndpointGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeEndpointGroupInput"}

	if s.EndpointGroupArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndpointGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeEndpointGroupOutput struct {
	_ struct{} `type:"structure"`

	// The description of an endpoint group.
	EndpointGroup *EndpointGroup `type:"structure"`
}

// String returns the string representation
func (s DescribeEndpointGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeEndpointGroup = "DescribeEndpointGroup"

// DescribeEndpointGroupRequest returns a request value for making API operation for
// AWS Global Accelerator.
//
// Describe an endpoint group.
//
//    // Example sending a request using DescribeEndpointGroupRequest.
//    req := client.DescribeEndpointGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeEndpointGroup
func (c *Client) DescribeEndpointGroupRequest(input *DescribeEndpointGroupInput) DescribeEndpointGroupRequest {
	op := &aws.Operation{
		Name:       opDescribeEndpointGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointGroupInput{}
	}

	req := c.newRequest(op, input, &DescribeEndpointGroupOutput{})
	return DescribeEndpointGroupRequest{Request: req, Input: input, Copy: c.DescribeEndpointGroupRequest}
}

// DescribeEndpointGroupRequest is the request type for the
// DescribeEndpointGroup API operation.
type DescribeEndpointGroupRequest struct {
	*aws.Request
	Input *DescribeEndpointGroupInput
	Copy  func(*DescribeEndpointGroupInput) DescribeEndpointGroupRequest
}

// Send marshals and sends the DescribeEndpointGroup API request.
func (r DescribeEndpointGroupRequest) Send(ctx context.Context) (*DescribeEndpointGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeEndpointGroupResponse{
		DescribeEndpointGroupOutput: r.Request.Data.(*DescribeEndpointGroupOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeEndpointGroupResponse is the response type for the
// DescribeEndpointGroup API operation.
type DescribeEndpointGroupResponse struct {
	*DescribeEndpointGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeEndpointGroup request.
func (r *DescribeEndpointGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
