// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchlogs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeSubscriptionFiltersInput struct {
	_ struct{} `type:"structure"`

	// The prefix to match. If you don't specify a value, no prefix filter is applied.
	FilterNamePrefix *string `locationName:"filterNamePrefix" min:"1" type:"string"`

	// The maximum number of items returned. If you don't specify a value, the default
	// is up to 50 items.
	Limit *int64 `locationName:"limit" min:"1" type:"integer"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeSubscriptionFiltersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSubscriptionFiltersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeSubscriptionFiltersInput"}
	if s.FilterNamePrefix != nil && len(*s.FilterNamePrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FilterNamePrefix", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeSubscriptionFiltersOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of items to return. The token expires after 24
	// hours.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The subscription filters.
	SubscriptionFilters []SubscriptionFilter `locationName:"subscriptionFilters" type:"list"`
}

// String returns the string representation
func (s DescribeSubscriptionFiltersOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeSubscriptionFilters = "DescribeSubscriptionFilters"

// DescribeSubscriptionFiltersRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Lists the subscription filters for the specified log group. You can list
// all the subscription filters or filter the results by prefix. The results
// are ASCII-sorted by filter name.
//
//    // Example sending a request using DescribeSubscriptionFiltersRequest.
//    req := client.DescribeSubscriptionFiltersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeSubscriptionFilters
func (c *Client) DescribeSubscriptionFiltersRequest(input *DescribeSubscriptionFiltersInput) DescribeSubscriptionFiltersRequest {
	op := &aws.Operation{
		Name:       opDescribeSubscriptionFilters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSubscriptionFiltersInput{}
	}

	req := c.newRequest(op, input, &DescribeSubscriptionFiltersOutput{})
	return DescribeSubscriptionFiltersRequest{Request: req, Input: input, Copy: c.DescribeSubscriptionFiltersRequest}
}

// DescribeSubscriptionFiltersRequest is the request type for the
// DescribeSubscriptionFilters API operation.
type DescribeSubscriptionFiltersRequest struct {
	*aws.Request
	Input *DescribeSubscriptionFiltersInput
	Copy  func(*DescribeSubscriptionFiltersInput) DescribeSubscriptionFiltersRequest
}

// Send marshals and sends the DescribeSubscriptionFilters API request.
func (r DescribeSubscriptionFiltersRequest) Send(ctx context.Context) (*DescribeSubscriptionFiltersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeSubscriptionFiltersResponse{
		DescribeSubscriptionFiltersOutput: r.Request.Data.(*DescribeSubscriptionFiltersOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeSubscriptionFiltersRequestPaginator returns a paginator for DescribeSubscriptionFilters.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeSubscriptionFiltersRequest(input)
//   p := cloudwatchlogs.NewDescribeSubscriptionFiltersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeSubscriptionFiltersPaginator(req DescribeSubscriptionFiltersRequest) DescribeSubscriptionFiltersPaginator {
	return DescribeSubscriptionFiltersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeSubscriptionFiltersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeSubscriptionFiltersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeSubscriptionFiltersPaginator struct {
	aws.Pager
}

func (p *DescribeSubscriptionFiltersPaginator) CurrentPage() *DescribeSubscriptionFiltersOutput {
	return p.Pager.CurrentPage().(*DescribeSubscriptionFiltersOutput)
}

// DescribeSubscriptionFiltersResponse is the response type for the
// DescribeSubscriptionFilters API operation.
type DescribeSubscriptionFiltersResponse struct {
	*DescribeSubscriptionFiltersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeSubscriptionFilters request.
func (r *DescribeSubscriptionFiltersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
