// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/build/v1/publish_build_event.proto

package build

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf4 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf5 "github.com/golang/protobuf/ptypes/empty"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// The service level of the build request. Backends only uses this value when
// the BuildEnqueued event is published to determine what level of service
// this build should receive.
type PublishLifecycleEventRequest_ServiceLevel int32

const (
	// Non-interactive builds can tolerate longer event latencies. This is the
	// default ServiceLevel if callers do not specify one.
	PublishLifecycleEventRequest_NONINTERACTIVE PublishLifecycleEventRequest_ServiceLevel = 0
	// The events of an interactive build should be delivered with low latency.
	PublishLifecycleEventRequest_INTERACTIVE PublishLifecycleEventRequest_ServiceLevel = 1
)

var PublishLifecycleEventRequest_ServiceLevel_name = map[int32]string{
	0: "NONINTERACTIVE",
	1: "INTERACTIVE",
}
var PublishLifecycleEventRequest_ServiceLevel_value = map[string]int32{
	"NONINTERACTIVE": 0,
	"INTERACTIVE":    1,
}

func (x PublishLifecycleEventRequest_ServiceLevel) String() string {
	return proto.EnumName(PublishLifecycleEventRequest_ServiceLevel_name, int32(x))
}
func (PublishLifecycleEventRequest_ServiceLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor2, []int{0, 0}
}

// Publishes 'lifecycle events' that update the high-level state of a build:
// - BuildEnqueued: When a build is scheduled.
// - InvocationAttemptStarted: When work for a build starts; there can be
//     multiple invocations for a build (e.g. retries).
// - InvocationAttemptCompleted: When work for a build finishes.
// - BuildFinished: When a build is finished.
type PublishLifecycleEventRequest struct {
	// The interactivity of this build.
	ServiceLevel PublishLifecycleEventRequest_ServiceLevel `protobuf:"varint,1,opt,name=service_level,json=serviceLevel,enum=google.devtools.build.v1.PublishLifecycleEventRequest_ServiceLevel" json:"service_level,omitempty"`
	// The lifecycle build event. If this is a build tool event, the RPC will fail
	// with INVALID_REQUEST.
	BuildEvent *OrderedBuildEvent `protobuf:"bytes,2,opt,name=build_event,json=buildEvent" json:"build_event,omitempty"`
	// If the next event for this build or invocation (depending on the event
	// type) hasn't been published after this duration from when {build_event}
	// is written to BES, consider this stream expired. If this field is not set,
	// BES backend will use its own default value.
	StreamTimeout *google_protobuf4.Duration `protobuf:"bytes,3,opt,name=stream_timeout,json=streamTimeout" json:"stream_timeout,omitempty"`
	// Additional information about a build request. These are define by the event
	// publishers, and the Build Event Service does not validate or interpret
	// them. They are used while notifying internal systems of new builds and
	// invocations if the OrderedBuildEvent.event type is
	// BuildEnqueued/InvocationAttemptStarted.
	NotificationKeywords []string `protobuf:"bytes,4,rep,name=notification_keywords,json=notificationKeywords" json:"notification_keywords,omitempty"`
	// This field identifies which project (if any) the build is associated with.
	ProjectId string `protobuf:"bytes,6,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
}

func (m *PublishLifecycleEventRequest) Reset()                    { *m = PublishLifecycleEventRequest{} }
func (m *PublishLifecycleEventRequest) String() string            { return proto.CompactTextString(m) }
func (*PublishLifecycleEventRequest) ProtoMessage()               {}
func (*PublishLifecycleEventRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{0} }

func (m *PublishLifecycleEventRequest) GetServiceLevel() PublishLifecycleEventRequest_ServiceLevel {
	if m != nil {
		return m.ServiceLevel
	}
	return PublishLifecycleEventRequest_NONINTERACTIVE
}

func (m *PublishLifecycleEventRequest) GetBuildEvent() *OrderedBuildEvent {
	if m != nil {
		return m.BuildEvent
	}
	return nil
}

func (m *PublishLifecycleEventRequest) GetStreamTimeout() *google_protobuf4.Duration {
	if m != nil {
		return m.StreamTimeout
	}
	return nil
}

func (m *PublishLifecycleEventRequest) GetNotificationKeywords() []string {
	if m != nil {
		return m.NotificationKeywords
	}
	return nil
}

func (m *PublishLifecycleEventRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// States which event has been committed. Any failure to commit will cause
// RPC errors, hence not recorded by this proto.
type PublishBuildToolEventStreamResponse struct {
	// The stream that contains this event.
	StreamId *StreamId `protobuf:"bytes,1,opt,name=stream_id,json=streamId" json:"stream_id,omitempty"`
	// The sequence number of this event that has been committed.
	SequenceNumber int64 `protobuf:"varint,2,opt,name=sequence_number,json=sequenceNumber" json:"sequence_number,omitempty"`
}

func (m *PublishBuildToolEventStreamResponse) Reset()         { *m = PublishBuildToolEventStreamResponse{} }
func (m *PublishBuildToolEventStreamResponse) String() string { return proto.CompactTextString(m) }
func (*PublishBuildToolEventStreamResponse) ProtoMessage()    {}
func (*PublishBuildToolEventStreamResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{1}
}

func (m *PublishBuildToolEventStreamResponse) GetStreamId() *StreamId {
	if m != nil {
		return m.StreamId
	}
	return nil
}

func (m *PublishBuildToolEventStreamResponse) GetSequenceNumber() int64 {
	if m != nil {
		return m.SequenceNumber
	}
	return 0
}

// Build event with contextual information about the stream it belongs to and
// its position in that stream.
type OrderedBuildEvent struct {
	// Which build event stream this event belongs to.
	StreamId *StreamId `protobuf:"bytes,1,opt,name=stream_id,json=streamId" json:"stream_id,omitempty"`
	// The position of this event in the stream. The sequence numbers for a build
	// event stream should be a sequence of consecutive natural numbers starting
	// from one. (1, 2, 3, ...)
	SequenceNumber int64 `protobuf:"varint,2,opt,name=sequence_number,json=sequenceNumber" json:"sequence_number,omitempty"`
	// The actual event.
	Event *BuildEvent `protobuf:"bytes,3,opt,name=event" json:"event,omitempty"`
}

func (m *OrderedBuildEvent) Reset()                    { *m = OrderedBuildEvent{} }
func (m *OrderedBuildEvent) String() string            { return proto.CompactTextString(m) }
func (*OrderedBuildEvent) ProtoMessage()               {}
func (*OrderedBuildEvent) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{2} }

func (m *OrderedBuildEvent) GetStreamId() *StreamId {
	if m != nil {
		return m.StreamId
	}
	return nil
}

func (m *OrderedBuildEvent) GetSequenceNumber() int64 {
	if m != nil {
		return m.SequenceNumber
	}
	return 0
}

func (m *OrderedBuildEvent) GetEvent() *BuildEvent {
	if m != nil {
		return m.Event
	}
	return nil
}

type PublishBuildToolEventStreamRequest struct {
	// Which build event stream this event belongs to.
	StreamId *StreamId `protobuf:"bytes,1,opt,name=stream_id,json=streamId" json:"stream_id,omitempty"`
	// The position of this event in the stream. The sequence numbers for a build
	// event stream should be a sequence of consecutive natural numbers starting
	// from one. (1, 2, 3, ...)
	SequenceNumber int64 `protobuf:"varint,2,opt,name=sequence_number,json=sequenceNumber" json:"sequence_number,omitempty"`
	// The actual event.
	Event *BuildEvent `protobuf:"bytes,3,opt,name=event" json:"event,omitempty"`
	// The build event with position info.
	// New publishing clients should use this field rather than the 3 above.
	OrderedBuildEvent *OrderedBuildEvent `protobuf:"bytes,4,opt,name=ordered_build_event,json=orderedBuildEvent" json:"ordered_build_event,omitempty"`
	// The keywords to be attached to the notification which notifies the start
	// of a new build event stream. BES only reads this field when sequence_number
	// or ordered_build_event.sequence_number is 1 in this message. If this field
	// is empty, BES will not publish notification messages for this stream.
	NotificationKeywords []string `protobuf:"bytes,5,rep,name=notification_keywords,json=notificationKeywords" json:"notification_keywords,omitempty"`
}

func (m *PublishBuildToolEventStreamRequest) Reset()         { *m = PublishBuildToolEventStreamRequest{} }
func (m *PublishBuildToolEventStreamRequest) String() string { return proto.CompactTextString(m) }
func (*PublishBuildToolEventStreamRequest) ProtoMessage()    {}
func (*PublishBuildToolEventStreamRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{3}
}

func (m *PublishBuildToolEventStreamRequest) GetStreamId() *StreamId {
	if m != nil {
		return m.StreamId
	}
	return nil
}

func (m *PublishBuildToolEventStreamRequest) GetSequenceNumber() int64 {
	if m != nil {
		return m.SequenceNumber
	}
	return 0
}

func (m *PublishBuildToolEventStreamRequest) GetEvent() *BuildEvent {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *PublishBuildToolEventStreamRequest) GetOrderedBuildEvent() *OrderedBuildEvent {
	if m != nil {
		return m.OrderedBuildEvent
	}
	return nil
}

func (m *PublishBuildToolEventStreamRequest) GetNotificationKeywords() []string {
	if m != nil {
		return m.NotificationKeywords
	}
	return nil
}

func init() {
	proto.RegisterType((*PublishLifecycleEventRequest)(nil), "google.devtools.build.v1.PublishLifecycleEventRequest")
	proto.RegisterType((*PublishBuildToolEventStreamResponse)(nil), "google.devtools.build.v1.PublishBuildToolEventStreamResponse")
	proto.RegisterType((*OrderedBuildEvent)(nil), "google.devtools.build.v1.OrderedBuildEvent")
	proto.RegisterType((*PublishBuildToolEventStreamRequest)(nil), "google.devtools.build.v1.PublishBuildToolEventStreamRequest")
	proto.RegisterEnum("google.devtools.build.v1.PublishLifecycleEventRequest_ServiceLevel", PublishLifecycleEventRequest_ServiceLevel_name, PublishLifecycleEventRequest_ServiceLevel_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for PublishBuildEvent service

type PublishBuildEventClient interface {
	// Publish a build event stating the new state of a build (typically from the
	// build queue). If the event is a BuildEnqueued event, also register the new
	// build request ID and its build type to BES.
	//
	// The backend will persist the event and deliver it to registered frontend
	// jobs immediately without batching.
	//
	// The commit status of the request is reported by the RPC's util_status()
	// function. The error code is the canoncial error code defined in
	// //util/task/codes.proto.
	PublishLifecycleEvent(ctx context.Context, in *PublishLifecycleEventRequest, opts ...grpc.CallOption) (*google_protobuf5.Empty, error)
	// Publish build tool events belonging to the same stream to a backend job
	// using bidirectional streaming.
	PublishBuildToolEventStream(ctx context.Context, opts ...grpc.CallOption) (PublishBuildEvent_PublishBuildToolEventStreamClient, error)
}

type publishBuildEventClient struct {
	cc *grpc.ClientConn
}

func NewPublishBuildEventClient(cc *grpc.ClientConn) PublishBuildEventClient {
	return &publishBuildEventClient{cc}
}

func (c *publishBuildEventClient) PublishLifecycleEvent(ctx context.Context, in *PublishLifecycleEventRequest, opts ...grpc.CallOption) (*google_protobuf5.Empty, error) {
	out := new(google_protobuf5.Empty)
	err := grpc.Invoke(ctx, "/google.devtools.build.v1.PublishBuildEvent/PublishLifecycleEvent", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publishBuildEventClient) PublishBuildToolEventStream(ctx context.Context, opts ...grpc.CallOption) (PublishBuildEvent_PublishBuildToolEventStreamClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_PublishBuildEvent_serviceDesc.Streams[0], c.cc, "/google.devtools.build.v1.PublishBuildEvent/PublishBuildToolEventStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &publishBuildEventPublishBuildToolEventStreamClient{stream}
	return x, nil
}

type PublishBuildEvent_PublishBuildToolEventStreamClient interface {
	Send(*OrderedBuildEvent) error
	Recv() (*PublishBuildToolEventStreamResponse, error)
	grpc.ClientStream
}

type publishBuildEventPublishBuildToolEventStreamClient struct {
	grpc.ClientStream
}

func (x *publishBuildEventPublishBuildToolEventStreamClient) Send(m *OrderedBuildEvent) error {
	return x.ClientStream.SendMsg(m)
}

func (x *publishBuildEventPublishBuildToolEventStreamClient) Recv() (*PublishBuildToolEventStreamResponse, error) {
	m := new(PublishBuildToolEventStreamResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for PublishBuildEvent service

type PublishBuildEventServer interface {
	// Publish a build event stating the new state of a build (typically from the
	// build queue). If the event is a BuildEnqueued event, also register the new
	// build request ID and its build type to BES.
	//
	// The backend will persist the event and deliver it to registered frontend
	// jobs immediately without batching.
	//
	// The commit status of the request is reported by the RPC's util_status()
	// function. The error code is the canoncial error code defined in
	// //util/task/codes.proto.
	PublishLifecycleEvent(context.Context, *PublishLifecycleEventRequest) (*google_protobuf5.Empty, error)
	// Publish build tool events belonging to the same stream to a backend job
	// using bidirectional streaming.
	PublishBuildToolEventStream(PublishBuildEvent_PublishBuildToolEventStreamServer) error
}

func RegisterPublishBuildEventServer(s *grpc.Server, srv PublishBuildEventServer) {
	s.RegisterService(&_PublishBuildEvent_serviceDesc, srv)
}

func _PublishBuildEvent_PublishLifecycleEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PublishLifecycleEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublishBuildEventServer).PublishLifecycleEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.build.v1.PublishBuildEvent/PublishLifecycleEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublishBuildEventServer).PublishLifecycleEvent(ctx, req.(*PublishLifecycleEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PublishBuildEvent_PublishBuildToolEventStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(PublishBuildEventServer).PublishBuildToolEventStream(&publishBuildEventPublishBuildToolEventStreamServer{stream})
}

type PublishBuildEvent_PublishBuildToolEventStreamServer interface {
	Send(*PublishBuildToolEventStreamResponse) error
	Recv() (*OrderedBuildEvent, error)
	grpc.ServerStream
}

type publishBuildEventPublishBuildToolEventStreamServer struct {
	grpc.ServerStream
}

func (x *publishBuildEventPublishBuildToolEventStreamServer) Send(m *PublishBuildToolEventStreamResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *publishBuildEventPublishBuildToolEventStreamServer) Recv() (*OrderedBuildEvent, error) {
	m := new(OrderedBuildEvent)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _PublishBuildEvent_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.build.v1.PublishBuildEvent",
	HandlerType: (*PublishBuildEventServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "PublishLifecycleEvent",
			Handler:    _PublishBuildEvent_PublishLifecycleEvent_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "PublishBuildToolEventStream",
			Handler:       _PublishBuildEvent_PublishBuildToolEventStream_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/devtools/build/v1/publish_build_event.proto",
}

func init() { proto.RegisterFile("google/devtools/build/v1/publish_build_event.proto", fileDescriptor2) }

var fileDescriptor2 = []byte{
	// 666 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x55, 0xcf, 0x6e, 0xd3, 0x4e,
	0x10, 0xfe, 0x6d, 0xd2, 0x56, 0xbf, 0x6c, 0xda, 0x94, 0x2e, 0x14, 0x4c, 0xda, 0xa2, 0xc8, 0x20,
	0x88, 0xa8, 0x64, 0xd3, 0x54, 0xe2, 0x50, 0x54, 0xfe, 0xa4, 0xe4, 0x10, 0x51, 0xa5, 0x95, 0x1b,
	0x71, 0x80, 0x83, 0xe5, 0xd8, 0xd3, 0x74, 0xa9, 0xe3, 0x35, 0xde, 0xb5, 0x51, 0xaf, 0xbc, 0x40,
	0x0f, 0x3c, 0x01, 0x77, 0x5e, 0x80, 0xe7, 0x80, 0x47, 0xe0, 0xc0, 0x23, 0x70, 0x44, 0xde, 0x75,
	0x90, 0x69, 0x70, 0x50, 0x73, 0xe0, 0xe6, 0xdd, 0x99, 0xf9, 0x66, 0xbe, 0x6f, 0x76, 0xc6, 0xb8,
	0x35, 0x64, 0x6c, 0xe8, 0x83, 0xe9, 0x41, 0x22, 0x18, 0xf3, 0xb9, 0x39, 0x88, 0xa9, 0xef, 0x99,
	0xc9, 0x96, 0x19, 0xc6, 0x03, 0x9f, 0xf2, 0x13, 0x5b, 0x5e, 0xd8, 0x90, 0x40, 0x20, 0x8c, 0x30,
	0x62, 0x82, 0x11, 0x4d, 0xc5, 0x18, 0xe3, 0x18, 0x43, 0xba, 0x18, 0xc9, 0x56, 0x7d, 0x3d, 0x43,
	0x73, 0x42, 0x6a, 0x3a, 0x41, 0xc0, 0x84, 0x23, 0x28, 0x0b, 0xb8, 0x8a, 0xab, 0x6f, 0x16, 0xe6,
	0xca, 0xe5, 0x18, 0x3b, 0xdf, 0xca, 0x9c, 0xe5, 0x69, 0x10, 0x1f, 0x9b, 0x5e, 0x1c, 0x49, 0xb4,
	0xcc, 0xbe, 0x76, 0xd1, 0x0e, 0xa3, 0x50, 0x9c, 0x29, 0xa3, 0xfe, 0xb1, 0x8c, 0xd7, 0x0f, 0x55,
	0xfd, 0xfb, 0xf4, 0x18, 0xdc, 0x33, 0xd7, 0x87, 0x4e, 0x8a, 0x6e, 0xc1, 0xdb, 0x18, 0xb8, 0x20,
	0x27, 0x78, 0x89, 0x43, 0x94, 0x50, 0x17, 0x6c, 0x1f, 0x12, 0xf0, 0x35, 0xd4, 0x40, 0xcd, 0x5a,
	0x6b, 0xcf, 0x28, 0xa2, 0x66, 0x4c, 0x83, 0x33, 0x8e, 0x14, 0xd6, 0x7e, 0x0a, 0x65, 0x2d, 0xf2,
	0xdc, 0x89, 0xec, 0xe3, 0x6a, 0x8e, 0x9d, 0x56, 0x6a, 0xa0, 0x66, 0xb5, 0xb5, 0x59, 0x9c, 0xe7,
	0x20, 0xf2, 0x20, 0x02, 0xaf, 0x9d, 0x9e, 0x55, 0x0e, 0x3c, 0xf8, 0xf5, 0x4d, 0x9e, 0xe2, 0x1a,
	0x17, 0x11, 0x38, 0x23, 0x5b, 0xd0, 0x11, 0xb0, 0x58, 0x68, 0x65, 0x09, 0x78, 0x73, 0x0c, 0x38,
	0x96, 0xc3, 0x78, 0x9e, 0xc9, 0x65, 0x2d, 0xa9, 0x80, 0xbe, 0xf2, 0x27, 0xdb, 0x78, 0x35, 0x60,
	0x82, 0x1e, 0x53, 0x57, 0x9a, 0xed, 0x53, 0x38, 0x7b, 0xc7, 0x22, 0x8f, 0x6b, 0x73, 0x8d, 0x72,
	0xb3, 0x62, 0x5d, 0xcb, 0x1b, 0x5f, 0x64, 0x36, 0xb2, 0x81, 0x71, 0x18, 0xb1, 0x37, 0xe0, 0x0a,
	0x9b, 0x7a, 0xda, 0x42, 0x03, 0x35, 0x2b, 0x56, 0x25, 0xbb, 0xe9, 0x7a, 0xfa, 0x36, 0x5e, 0xcc,
	0x2b, 0x40, 0x08, 0xae, 0xf5, 0x0e, 0x7a, 0xdd, 0x5e, 0xbf, 0x63, 0x3d, 0xdb, 0xeb, 0x77, 0x5f,
	0x76, 0xae, 0xfc, 0x47, 0x96, 0x71, 0x35, 0x7f, 0x81, 0xf4, 0x73, 0x84, 0x6f, 0x67, 0xa2, 0x4a,
	0xb2, 0x7d, 0xc6, 0x7c, 0x49, 0xf2, 0x48, 0xd6, 0x6b, 0x01, 0x0f, 0x59, 0xc0, 0x81, 0x3c, 0xc1,
	0x95, 0x8c, 0x32, 0xf5, 0x64, 0x9b, 0xaa, 0x2d, 0xbd, 0x58, 0x3e, 0x15, 0xdc, 0xf5, 0xac, 0xff,
	0x79, 0xf6, 0x45, 0xee, 0xe1, 0x65, 0x9e, 0xf6, 0x29, 0x70, 0xc1, 0x0e, 0xe2, 0xd1, 0x00, 0x22,
	0xd9, 0x85, 0xb2, 0x55, 0x1b, 0x5f, 0xf7, 0xe4, 0xad, 0xfe, 0x19, 0xe1, 0x95, 0x09, 0xf9, 0xff,
	0x5d, 0x7e, 0xb2, 0x83, 0xe7, 0xd5, 0x23, 0x51, 0x3d, 0xbd, 0x53, 0x9c, 0x25, 0xf7, 0x3a, 0x54,
	0x88, 0xfe, 0xbd, 0x84, 0xf5, 0xa9, 0x6a, 0xaa, 0x77, 0xbf, 0x37, 0x13, 0x99, 0x76, 0x49, 0x43,
	0x39, 0x42, 0x9b, 0x05, 0x84, 0xa4, 0xdb, 0x45, 0x52, 0x8f, 0x67, 0x20, 0x25, 0x81, 0x54, 0x18,
	0x79, 0x8d, 0xaf, 0x32, 0xd5, 0x93, 0xfc, 0x26, 0xd2, 0xe6, 0x2e, 0x3f, 0x47, 0x2b, 0x6c, 0xa2,
	0xb7, 0x85, 0xc3, 0x30, 0x5f, 0x3c, 0x0c, 0xad, 0xaf, 0x25, 0xbc, 0x92, 0x97, 0x5a, 0x41, 0x9d,
	0x23, 0xbc, 0xfa, 0xc7, 0x1d, 0x41, 0x1e, 0xce, 0xb6, 0x54, 0xea, 0xd7, 0x27, 0x66, 0xba, 0x93,
	0xae, 0x38, 0xfd, 0xee, 0xfb, 0x2f, 0xdf, 0x3e, 0x94, 0x1a, 0xfa, 0x5a, 0xba, 0x39, 0xfd, 0xdf,
	0x42, 0xf9, 0x4e, 0xb6, 0xb5, 0x77, 0xd0, 0x7d, 0xf2, 0x09, 0xe1, 0xb5, 0x29, 0x4f, 0x82, 0x5c,
	0x46, 0xbc, 0xfa, 0xee, 0x5f, 0x49, 0x4c, 0x1b, 0x62, 0x7d, 0x43, 0xd6, 0x7c, 0x43, 0x27, 0x69,
	0xcd, 0x70, 0xb1, 0xd4, 0x26, 0x7a, 0x80, 0xda, 0x21, 0x5e, 0x77, 0xd9, 0xa8, 0x30, 0x4d, 0x7b,
	0xb1, 0xed, 0xb8, 0xa7, 0x10, 0x78, 0x87, 0xa9, 0x1a, 0x87, 0xe8, 0xd5, 0x6e, 0xe6, 0x39, 0x64,
	0xbe, 0x13, 0x0c, 0x0d, 0x16, 0x0d, 0xcd, 0x21, 0x04, 0x52, 0x2b, 0x53, 0x99, 0x9c, 0x90, 0xf2,
	0xc9, 0x9f, 0xcd, 0x23, 0xf9, 0xf1, 0x03, 0xa1, 0xc1, 0x82, 0x74, 0xde, 0xfe, 0x19, 0x00, 0x00,
	0xff, 0xff, 0x85, 0x4c, 0x16, 0x72, 0x04, 0x07, 0x00, 0x00,
}
