// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/pubsub/v1beta2/pubsub.proto

/*
Package pubsub is a generated protocol buffer package.

It is generated from these files:
	google/pubsub/v1beta2/pubsub.proto

It has these top-level messages:
	Topic
	PubsubMessage
	GetTopicRequest
	PublishRequest
	PublishResponse
	ListTopicsRequest
	ListTopicsResponse
	ListTopicSubscriptionsRequest
	ListTopicSubscriptionsResponse
	DeleteTopicRequest
	Subscription
	PushConfig
	ReceivedMessage
	GetSubscriptionRequest
	ListSubscriptionsRequest
	ListSubscriptionsResponse
	DeleteSubscriptionRequest
	ModifyPushConfigRequest
	PullRequest
	PullResponse
	ModifyAckDeadlineRequest
	AcknowledgeRequest
*/
package pubsub

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/empty"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A topic resource.
type Topic struct {
	// Name of the topic.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *Topic) Reset()                    { *m = Topic{} }
func (m *Topic) String() string            { return proto.CompactTextString(m) }
func (*Topic) ProtoMessage()               {}
func (*Topic) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Topic) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A message data and its attributes.
type PubsubMessage struct {
	// The message payload. For JSON requests, the value of this field must be
	// base64-encoded.
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// Optional attributes for this message.
	Attributes map[string]string `protobuf:"bytes,2,rep,name=attributes" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// ID of this message assigned by the server at publication time. Guaranteed
	// to be unique within the topic. This value may be read by a subscriber
	// that receives a PubsubMessage via a Pull call or a push delivery. It must
	// not be populated by a publisher in a Publish call.
	MessageId string `protobuf:"bytes,3,opt,name=message_id,json=messageId" json:"message_id,omitempty"`
}

func (m *PubsubMessage) Reset()                    { *m = PubsubMessage{} }
func (m *PubsubMessage) String() string            { return proto.CompactTextString(m) }
func (*PubsubMessage) ProtoMessage()               {}
func (*PubsubMessage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *PubsubMessage) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *PubsubMessage) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *PubsubMessage) GetMessageId() string {
	if m != nil {
		return m.MessageId
	}
	return ""
}

// Request for the GetTopic method.
type GetTopicRequest struct {
	// The name of the topic to get.
	Topic string `protobuf:"bytes,1,opt,name=topic" json:"topic,omitempty"`
}

func (m *GetTopicRequest) Reset()                    { *m = GetTopicRequest{} }
func (m *GetTopicRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTopicRequest) ProtoMessage()               {}
func (*GetTopicRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *GetTopicRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

// Request for the Publish method.
type PublishRequest struct {
	// The messages in the request will be published on this topic.
	Topic string `protobuf:"bytes,1,opt,name=topic" json:"topic,omitempty"`
	// The messages to publish.
	Messages []*PubsubMessage `protobuf:"bytes,2,rep,name=messages" json:"messages,omitempty"`
}

func (m *PublishRequest) Reset()                    { *m = PublishRequest{} }
func (m *PublishRequest) String() string            { return proto.CompactTextString(m) }
func (*PublishRequest) ProtoMessage()               {}
func (*PublishRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *PublishRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *PublishRequest) GetMessages() []*PubsubMessage {
	if m != nil {
		return m.Messages
	}
	return nil
}

// Response for the Publish method.
type PublishResponse struct {
	// The server-assigned ID of each published message, in the same order as
	// the messages in the request. IDs are guaranteed to be unique within
	// the topic.
	MessageIds []string `protobuf:"bytes,1,rep,name=message_ids,json=messageIds" json:"message_ids,omitempty"`
}

func (m *PublishResponse) Reset()                    { *m = PublishResponse{} }
func (m *PublishResponse) String() string            { return proto.CompactTextString(m) }
func (*PublishResponse) ProtoMessage()               {}
func (*PublishResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *PublishResponse) GetMessageIds() []string {
	if m != nil {
		return m.MessageIds
	}
	return nil
}

// Request for the ListTopics method.
type ListTopicsRequest struct {
	// The name of the cloud project that topics belong to.
	Project string `protobuf:"bytes,1,opt,name=project" json:"project,omitempty"`
	// Maximum number of topics to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The value returned by the last ListTopicsResponse; indicates that this is
	// a continuation of a prior ListTopics call, and that the system should
	// return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListTopicsRequest) Reset()                    { *m = ListTopicsRequest{} }
func (m *ListTopicsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTopicsRequest) ProtoMessage()               {}
func (*ListTopicsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *ListTopicsRequest) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *ListTopicsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTopicsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the ListTopics method.
type ListTopicsResponse struct {
	// The resulting topics.
	Topics []*Topic `protobuf:"bytes,1,rep,name=topics" json:"topics,omitempty"`
	// If not empty, indicates that there may be more topics that match the
	// request; this value should be passed in a new ListTopicsRequest.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListTopicsResponse) Reset()                    { *m = ListTopicsResponse{} }
func (m *ListTopicsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTopicsResponse) ProtoMessage()               {}
func (*ListTopicsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *ListTopicsResponse) GetTopics() []*Topic {
	if m != nil {
		return m.Topics
	}
	return nil
}

func (m *ListTopicsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the ListTopicSubscriptions method.
type ListTopicSubscriptionsRequest struct {
	// The name of the topic that subscriptions are attached to.
	Topic string `protobuf:"bytes,1,opt,name=topic" json:"topic,omitempty"`
	// Maximum number of subscription names to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The value returned by the last ListTopicSubscriptionsResponse; indicates
	// that this is a continuation of a prior ListTopicSubscriptions call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListTopicSubscriptionsRequest) Reset()                    { *m = ListTopicSubscriptionsRequest{} }
func (m *ListTopicSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTopicSubscriptionsRequest) ProtoMessage()               {}
func (*ListTopicSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *ListTopicSubscriptionsRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *ListTopicSubscriptionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTopicSubscriptionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the ListTopicSubscriptions method.
type ListTopicSubscriptionsResponse struct {
	// The names of the subscriptions that match the request.
	Subscriptions []string `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
	// If not empty, indicates that there may be more subscriptions that match
	// the request; this value should be passed in a new
	// ListTopicSubscriptionsRequest to get more subscriptions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListTopicSubscriptionsResponse) Reset()                    { *m = ListTopicSubscriptionsResponse{} }
func (m *ListTopicSubscriptionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTopicSubscriptionsResponse) ProtoMessage()               {}
func (*ListTopicSubscriptionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *ListTopicSubscriptionsResponse) GetSubscriptions() []string {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

func (m *ListTopicSubscriptionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the DeleteTopic method.
type DeleteTopicRequest struct {
	// Name of the topic to delete.
	Topic string `protobuf:"bytes,1,opt,name=topic" json:"topic,omitempty"`
}

func (m *DeleteTopicRequest) Reset()                    { *m = DeleteTopicRequest{} }
func (m *DeleteTopicRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteTopicRequest) ProtoMessage()               {}
func (*DeleteTopicRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *DeleteTopicRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

// A subscription resource.
type Subscription struct {
	// Name of the subscription.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The name of the topic from which this subscription is receiving messages.
	// This will be present if and only if the subscription has not been detached
	// from its topic.
	Topic string `protobuf:"bytes,2,opt,name=topic" json:"topic,omitempty"`
	// If push delivery is used with this subscription, this field is
	// used to configure it. An empty pushConfig signifies that the subscriber
	// will pull and ack messages using API methods.
	PushConfig *PushConfig `protobuf:"bytes,4,opt,name=push_config,json=pushConfig" json:"push_config,omitempty"`
	// This value is the maximum time after a subscriber receives a message
	// before the subscriber should acknowledge the message. After message
	// delivery but before the ack deadline expires and before the message is
	// acknowledged, it is an outstanding message and will not be delivered
	// again during that time (on a best-effort basis).
	//
	// For pull delivery this value
	// is used as the initial value for the ack deadline. It may be overridden
	// for a specific message by calling ModifyAckDeadline.
	//
	// For push delivery, this value is also used to set the request timeout for
	// the call to the push endpoint.
	//
	// If the subscriber never acknowledges the message, the Pub/Sub
	// system will eventually redeliver the message.
	AckDeadlineSeconds int32 `protobuf:"varint,5,opt,name=ack_deadline_seconds,json=ackDeadlineSeconds" json:"ack_deadline_seconds,omitempty"`
}

func (m *Subscription) Reset()                    { *m = Subscription{} }
func (m *Subscription) String() string            { return proto.CompactTextString(m) }
func (*Subscription) ProtoMessage()               {}
func (*Subscription) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *Subscription) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Subscription) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *Subscription) GetPushConfig() *PushConfig {
	if m != nil {
		return m.PushConfig
	}
	return nil
}

func (m *Subscription) GetAckDeadlineSeconds() int32 {
	if m != nil {
		return m.AckDeadlineSeconds
	}
	return 0
}

// Configuration for a push delivery endpoint.
type PushConfig struct {
	// A URL locating the endpoint to which messages should be pushed.
	// For example, a Webhook endpoint might use "https://example.com/push".
	PushEndpoint string `protobuf:"bytes,1,opt,name=push_endpoint,json=pushEndpoint" json:"push_endpoint,omitempty"`
	// Endpoint configuration attributes.
	//
	// Every endpoint has a set of API supported attributes that can be used to
	// control different aspects of the message delivery.
	//
	// The currently supported attribute is `x-goog-version`, which you can
	// use to change the format of the push message. This attribute
	// indicates the version of the data expected by the endpoint. This
	// controls the shape of the envelope (i.e. its fields and metadata).
	// The endpoint version is based on the version of the Pub/Sub
	// API.
	//
	// If not present during the CreateSubscription call, it will default to
	// the version of the API used to make such call. If not present during a
	// ModifyPushConfig call, its value will not be changed. GetSubscription
	// calls will always return a valid version, even if the subscription was
	// created without this attribute.
	//
	// The possible values for this attribute are:
	//
	// * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
	// * `v1beta2`: uses the push format defined in the v1beta2 Pub/Sub API.
	//
	Attributes map[string]string `protobuf:"bytes,2,rep,name=attributes" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *PushConfig) Reset()                    { *m = PushConfig{} }
func (m *PushConfig) String() string            { return proto.CompactTextString(m) }
func (*PushConfig) ProtoMessage()               {}
func (*PushConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *PushConfig) GetPushEndpoint() string {
	if m != nil {
		return m.PushEndpoint
	}
	return ""
}

func (m *PushConfig) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// A message and its corresponding acknowledgment ID.
type ReceivedMessage struct {
	// This ID can be used to acknowledge the received message.
	AckId string `protobuf:"bytes,1,opt,name=ack_id,json=ackId" json:"ack_id,omitempty"`
	// The message.
	Message *PubsubMessage `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
}

func (m *ReceivedMessage) Reset()                    { *m = ReceivedMessage{} }
func (m *ReceivedMessage) String() string            { return proto.CompactTextString(m) }
func (*ReceivedMessage) ProtoMessage()               {}
func (*ReceivedMessage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *ReceivedMessage) GetAckId() string {
	if m != nil {
		return m.AckId
	}
	return ""
}

func (m *ReceivedMessage) GetMessage() *PubsubMessage {
	if m != nil {
		return m.Message
	}
	return nil
}

// Request for the GetSubscription method.
type GetSubscriptionRequest struct {
	// The name of the subscription to get.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *GetSubscriptionRequest) Reset()                    { *m = GetSubscriptionRequest{} }
func (m *GetSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetSubscriptionRequest) ProtoMessage()               {}
func (*GetSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *GetSubscriptionRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

// Request for the ListSubscriptions method.
type ListSubscriptionsRequest struct {
	// The name of the cloud project that subscriptions belong to.
	Project string `protobuf:"bytes,1,opt,name=project" json:"project,omitempty"`
	// Maximum number of subscriptions to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The value returned by the last ListSubscriptionsResponse; indicates that
	// this is a continuation of a prior ListSubscriptions call, and that the
	// system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListSubscriptionsRequest) Reset()                    { *m = ListSubscriptionsRequest{} }
func (m *ListSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListSubscriptionsRequest) ProtoMessage()               {}
func (*ListSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *ListSubscriptionsRequest) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *ListSubscriptionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSubscriptionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the ListSubscriptions method.
type ListSubscriptionsResponse struct {
	// The subscriptions that match the request.
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
	// If not empty, indicates that there may be more subscriptions that match
	// the request; this value should be passed in a new ListSubscriptionsRequest
	// to get more subscriptions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListSubscriptionsResponse) Reset()                    { *m = ListSubscriptionsResponse{} }
func (m *ListSubscriptionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListSubscriptionsResponse) ProtoMessage()               {}
func (*ListSubscriptionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *ListSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

func (m *ListSubscriptionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the DeleteSubscription method.
type DeleteSubscriptionRequest struct {
	// The subscription to delete.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *DeleteSubscriptionRequest) Reset()                    { *m = DeleteSubscriptionRequest{} }
func (m *DeleteSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteSubscriptionRequest) ProtoMessage()               {}
func (*DeleteSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *DeleteSubscriptionRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

// Request for the ModifyPushConfig method.
type ModifyPushConfigRequest struct {
	// The name of the subscription.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// The push configuration for future deliveries.
	//
	// An empty pushConfig indicates that the Pub/Sub system should
	// stop pushing messages from the given subscription and allow
	// messages to be pulled and acknowledged - effectively pausing
	// the subscription if Pull is not called.
	PushConfig *PushConfig `protobuf:"bytes,2,opt,name=push_config,json=pushConfig" json:"push_config,omitempty"`
}

func (m *ModifyPushConfigRequest) Reset()                    { *m = ModifyPushConfigRequest{} }
func (m *ModifyPushConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*ModifyPushConfigRequest) ProtoMessage()               {}
func (*ModifyPushConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *ModifyPushConfigRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *ModifyPushConfigRequest) GetPushConfig() *PushConfig {
	if m != nil {
		return m.PushConfig
	}
	return nil
}

// Request for the Pull method.
type PullRequest struct {
	// The subscription from which messages should be pulled.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// If this is specified as true the system will respond immediately even if
	// it is not able to return a message in the Pull response. Otherwise the
	// system is allowed to wait until at least one message is available rather
	// than returning no messages. The client may cancel the request if it does
	// not wish to wait any longer for the response.
	ReturnImmediately bool `protobuf:"varint,2,opt,name=return_immediately,json=returnImmediately" json:"return_immediately,omitempty"`
	// The maximum number of messages returned for this request. The Pub/Sub
	// system may return fewer than the number specified.
	MaxMessages int32 `protobuf:"varint,3,opt,name=max_messages,json=maxMessages" json:"max_messages,omitempty"`
}

func (m *PullRequest) Reset()                    { *m = PullRequest{} }
func (m *PullRequest) String() string            { return proto.CompactTextString(m) }
func (*PullRequest) ProtoMessage()               {}
func (*PullRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *PullRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *PullRequest) GetReturnImmediately() bool {
	if m != nil {
		return m.ReturnImmediately
	}
	return false
}

func (m *PullRequest) GetMaxMessages() int32 {
	if m != nil {
		return m.MaxMessages
	}
	return 0
}

// Response for the Pull method.
type PullResponse struct {
	// Received Pub/Sub messages. The Pub/Sub system will return zero messages if
	// there are no more available in the backlog. The Pub/Sub system may return
	// fewer than the maxMessages requested even if there are more messages
	// available in the backlog.
	ReceivedMessages []*ReceivedMessage `protobuf:"bytes,1,rep,name=received_messages,json=receivedMessages" json:"received_messages,omitempty"`
}

func (m *PullResponse) Reset()                    { *m = PullResponse{} }
func (m *PullResponse) String() string            { return proto.CompactTextString(m) }
func (*PullResponse) ProtoMessage()               {}
func (*PullResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *PullResponse) GetReceivedMessages() []*ReceivedMessage {
	if m != nil {
		return m.ReceivedMessages
	}
	return nil
}

// Request for the ModifyAckDeadline method.
type ModifyAckDeadlineRequest struct {
	// The name of the subscription.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// The acknowledgment ID.
	AckId string `protobuf:"bytes,2,opt,name=ack_id,json=ackId" json:"ack_id,omitempty"`
	// The new ack deadline with respect to the time this request was sent to the
	// Pub/Sub system. Must be >= 0. For example, if the value is 10, the new ack
	// deadline will expire 10 seconds after the ModifyAckDeadline call was made.
	// Specifying zero may immediately make the message available for another pull
	// request.
	AckDeadlineSeconds int32 `protobuf:"varint,3,opt,name=ack_deadline_seconds,json=ackDeadlineSeconds" json:"ack_deadline_seconds,omitempty"`
}

func (m *ModifyAckDeadlineRequest) Reset()                    { *m = ModifyAckDeadlineRequest{} }
func (m *ModifyAckDeadlineRequest) String() string            { return proto.CompactTextString(m) }
func (*ModifyAckDeadlineRequest) ProtoMessage()               {}
func (*ModifyAckDeadlineRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *ModifyAckDeadlineRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *ModifyAckDeadlineRequest) GetAckId() string {
	if m != nil {
		return m.AckId
	}
	return ""
}

func (m *ModifyAckDeadlineRequest) GetAckDeadlineSeconds() int32 {
	if m != nil {
		return m.AckDeadlineSeconds
	}
	return 0
}

// Request for the Acknowledge method.
type AcknowledgeRequest struct {
	// The subscription whose message is being acknowledged.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// The acknowledgment ID for the messages being acknowledged that was returned
	// by the Pub/Sub system in the Pull response. Must not be empty.
	AckIds []string `protobuf:"bytes,2,rep,name=ack_ids,json=ackIds" json:"ack_ids,omitempty"`
}

func (m *AcknowledgeRequest) Reset()                    { *m = AcknowledgeRequest{} }
func (m *AcknowledgeRequest) String() string            { return proto.CompactTextString(m) }
func (*AcknowledgeRequest) ProtoMessage()               {}
func (*AcknowledgeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *AcknowledgeRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *AcknowledgeRequest) GetAckIds() []string {
	if m != nil {
		return m.AckIds
	}
	return nil
}

func init() {
	proto.RegisterType((*Topic)(nil), "google.pubsub.v1beta2.Topic")
	proto.RegisterType((*PubsubMessage)(nil), "google.pubsub.v1beta2.PubsubMessage")
	proto.RegisterType((*GetTopicRequest)(nil), "google.pubsub.v1beta2.GetTopicRequest")
	proto.RegisterType((*PublishRequest)(nil), "google.pubsub.v1beta2.PublishRequest")
	proto.RegisterType((*PublishResponse)(nil), "google.pubsub.v1beta2.PublishResponse")
	proto.RegisterType((*ListTopicsRequest)(nil), "google.pubsub.v1beta2.ListTopicsRequest")
	proto.RegisterType((*ListTopicsResponse)(nil), "google.pubsub.v1beta2.ListTopicsResponse")
	proto.RegisterType((*ListTopicSubscriptionsRequest)(nil), "google.pubsub.v1beta2.ListTopicSubscriptionsRequest")
	proto.RegisterType((*ListTopicSubscriptionsResponse)(nil), "google.pubsub.v1beta2.ListTopicSubscriptionsResponse")
	proto.RegisterType((*DeleteTopicRequest)(nil), "google.pubsub.v1beta2.DeleteTopicRequest")
	proto.RegisterType((*Subscription)(nil), "google.pubsub.v1beta2.Subscription")
	proto.RegisterType((*PushConfig)(nil), "google.pubsub.v1beta2.PushConfig")
	proto.RegisterType((*ReceivedMessage)(nil), "google.pubsub.v1beta2.ReceivedMessage")
	proto.RegisterType((*GetSubscriptionRequest)(nil), "google.pubsub.v1beta2.GetSubscriptionRequest")
	proto.RegisterType((*ListSubscriptionsRequest)(nil), "google.pubsub.v1beta2.ListSubscriptionsRequest")
	proto.RegisterType((*ListSubscriptionsResponse)(nil), "google.pubsub.v1beta2.ListSubscriptionsResponse")
	proto.RegisterType((*DeleteSubscriptionRequest)(nil), "google.pubsub.v1beta2.DeleteSubscriptionRequest")
	proto.RegisterType((*ModifyPushConfigRequest)(nil), "google.pubsub.v1beta2.ModifyPushConfigRequest")
	proto.RegisterType((*PullRequest)(nil), "google.pubsub.v1beta2.PullRequest")
	proto.RegisterType((*PullResponse)(nil), "google.pubsub.v1beta2.PullResponse")
	proto.RegisterType((*ModifyAckDeadlineRequest)(nil), "google.pubsub.v1beta2.ModifyAckDeadlineRequest")
	proto.RegisterType((*AcknowledgeRequest)(nil), "google.pubsub.v1beta2.AcknowledgeRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Subscriber service

type SubscriberClient interface {
	// Creates a subscription to a given topic for a given subscriber.
	// If the subscription already exists, returns ALREADY_EXISTS.
	// If the corresponding topic doesn't exist, returns NOT_FOUND.
	//
	// If the name is not provided in the request, the server will assign a random
	// name for this subscription on the same project as the topic.
	CreateSubscription(ctx context.Context, in *Subscription, opts ...grpc.CallOption) (*Subscription, error)
	// Gets the configuration details of a subscription.
	GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error)
	// Lists matching subscriptions.
	ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription. All pending messages in the subscription
	// are immediately dropped. Calls to Pull after deletion will return
	// NOT_FOUND. After a subscription is deleted, a new one may be created with
	// the same name, but the new one has no association with the old
	// subscription, or its topic unless the same topic is specified.
	DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error)
	// Modifies the ack deadline for a specific message. This method is useful to
	// indicate that more time is needed to process a message by the subscriber,
	// or to make the message available for redelivery if the processing was
	// interrupted.
	ModifyAckDeadline(ctx context.Context, in *ModifyAckDeadlineRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error)
	// Acknowledges the messages associated with the ack tokens in the
	// AcknowledgeRequest. The Pub/Sub system can remove the relevant messages
	// from the subscription.
	//
	// Acknowledging a message whose ack deadline has expired may succeed,
	// but such a message may be redelivered later. Acknowledging a message more
	// than once will not result in an error.
	Acknowledge(ctx context.Context, in *AcknowledgeRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error)
	// Pulls messages from the server. Returns an empty list if there are no
	// messages available in the backlog. The server may return UNAVAILABLE if
	// there are too many concurrent pull requests pending for the given
	// subscription.
	Pull(ctx context.Context, in *PullRequest, opts ...grpc.CallOption) (*PullResponse, error)
	// Modifies the PushConfig for a specified subscription.
	//
	// This may be used to change a push subscription to a pull one (signified
	// by an empty PushConfig) or vice versa, or change the endpoint URL and other
	// attributes of a push subscription. Messages will accumulate for
	// delivery continuously through the call regardless of changes to the
	// PushConfig.
	ModifyPushConfig(ctx context.Context, in *ModifyPushConfigRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error)
}

type subscriberClient struct {
	cc *grpc.ClientConn
}

func NewSubscriberClient(cc *grpc.ClientConn) SubscriberClient {
	return &subscriberClient{cc}
}

func (c *subscriberClient) CreateSubscription(ctx context.Context, in *Subscription, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/CreateSubscription", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/GetSubscription", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error) {
	out := new(ListSubscriptionsResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/ListSubscriptions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error) {
	out := new(google_protobuf.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/DeleteSubscription", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ModifyAckDeadline(ctx context.Context, in *ModifyAckDeadlineRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error) {
	out := new(google_protobuf.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/ModifyAckDeadline", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) Acknowledge(ctx context.Context, in *AcknowledgeRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error) {
	out := new(google_protobuf.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/Acknowledge", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) Pull(ctx context.Context, in *PullRequest, opts ...grpc.CallOption) (*PullResponse, error) {
	out := new(PullResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/Pull", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ModifyPushConfig(ctx context.Context, in *ModifyPushConfigRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error) {
	out := new(google_protobuf.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/ModifyPushConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Subscriber service

type SubscriberServer interface {
	// Creates a subscription to a given topic for a given subscriber.
	// If the subscription already exists, returns ALREADY_EXISTS.
	// If the corresponding topic doesn't exist, returns NOT_FOUND.
	//
	// If the name is not provided in the request, the server will assign a random
	// name for this subscription on the same project as the topic.
	CreateSubscription(context.Context, *Subscription) (*Subscription, error)
	// Gets the configuration details of a subscription.
	GetSubscription(context.Context, *GetSubscriptionRequest) (*Subscription, error)
	// Lists matching subscriptions.
	ListSubscriptions(context.Context, *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription. All pending messages in the subscription
	// are immediately dropped. Calls to Pull after deletion will return
	// NOT_FOUND. After a subscription is deleted, a new one may be created with
	// the same name, but the new one has no association with the old
	// subscription, or its topic unless the same topic is specified.
	DeleteSubscription(context.Context, *DeleteSubscriptionRequest) (*google_protobuf.Empty, error)
	// Modifies the ack deadline for a specific message. This method is useful to
	// indicate that more time is needed to process a message by the subscriber,
	// or to make the message available for redelivery if the processing was
	// interrupted.
	ModifyAckDeadline(context.Context, *ModifyAckDeadlineRequest) (*google_protobuf.Empty, error)
	// Acknowledges the messages associated with the ack tokens in the
	// AcknowledgeRequest. The Pub/Sub system can remove the relevant messages
	// from the subscription.
	//
	// Acknowledging a message whose ack deadline has expired may succeed,
	// but such a message may be redelivered later. Acknowledging a message more
	// than once will not result in an error.
	Acknowledge(context.Context, *AcknowledgeRequest) (*google_protobuf.Empty, error)
	// Pulls messages from the server. Returns an empty list if there are no
	// messages available in the backlog. The server may return UNAVAILABLE if
	// there are too many concurrent pull requests pending for the given
	// subscription.
	Pull(context.Context, *PullRequest) (*PullResponse, error)
	// Modifies the PushConfig for a specified subscription.
	//
	// This may be used to change a push subscription to a pull one (signified
	// by an empty PushConfig) or vice versa, or change the endpoint URL and other
	// attributes of a push subscription. Messages will accumulate for
	// delivery continuously through the call regardless of changes to the
	// PushConfig.
	ModifyPushConfig(context.Context, *ModifyPushConfigRequest) (*google_protobuf.Empty, error)
}

func RegisterSubscriberServer(s *grpc.Server, srv SubscriberServer) {
	s.RegisterService(&_Subscriber_serviceDesc, srv)
}

func _Subscriber_CreateSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Subscription)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).CreateSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/CreateSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).CreateSubscription(ctx, req.(*Subscription))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_GetSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).GetSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/GetSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).GetSubscription(ctx, req.(*GetSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ListSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ListSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/ListSubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ListSubscriptions(ctx, req.(*ListSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_DeleteSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).DeleteSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/DeleteSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).DeleteSubscription(ctx, req.(*DeleteSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ModifyAckDeadline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyAckDeadlineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ModifyAckDeadline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/ModifyAckDeadline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ModifyAckDeadline(ctx, req.(*ModifyAckDeadlineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_Acknowledge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcknowledgeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).Acknowledge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/Acknowledge",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).Acknowledge(ctx, req.(*AcknowledgeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_Pull_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PullRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).Pull(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/Pull",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).Pull(ctx, req.(*PullRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ModifyPushConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyPushConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ModifyPushConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/ModifyPushConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ModifyPushConfig(ctx, req.(*ModifyPushConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Subscriber_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.pubsub.v1beta2.Subscriber",
	HandlerType: (*SubscriberServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSubscription",
			Handler:    _Subscriber_CreateSubscription_Handler,
		},
		{
			MethodName: "GetSubscription",
			Handler:    _Subscriber_GetSubscription_Handler,
		},
		{
			MethodName: "ListSubscriptions",
			Handler:    _Subscriber_ListSubscriptions_Handler,
		},
		{
			MethodName: "DeleteSubscription",
			Handler:    _Subscriber_DeleteSubscription_Handler,
		},
		{
			MethodName: "ModifyAckDeadline",
			Handler:    _Subscriber_ModifyAckDeadline_Handler,
		},
		{
			MethodName: "Acknowledge",
			Handler:    _Subscriber_Acknowledge_Handler,
		},
		{
			MethodName: "Pull",
			Handler:    _Subscriber_Pull_Handler,
		},
		{
			MethodName: "ModifyPushConfig",
			Handler:    _Subscriber_ModifyPushConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/pubsub/v1beta2/pubsub.proto",
}

// Client API for Publisher service

type PublisherClient interface {
	// Creates the given topic with the given name.
	CreateTopic(ctx context.Context, in *Topic, opts ...grpc.CallOption) (*Topic, error)
	// Adds one or more messages to the topic. Returns NOT_FOUND if the topic does
	// not exist.
	Publish(ctx context.Context, in *PublishRequest, opts ...grpc.CallOption) (*PublishResponse, error)
	// Gets the configuration of a topic.
	GetTopic(ctx context.Context, in *GetTopicRequest, opts ...grpc.CallOption) (*Topic, error)
	// Lists matching topics.
	ListTopics(ctx context.Context, in *ListTopicsRequest, opts ...grpc.CallOption) (*ListTopicsResponse, error)
	// Lists the name of the subscriptions for this topic.
	ListTopicSubscriptions(ctx context.Context, in *ListTopicSubscriptionsRequest, opts ...grpc.CallOption) (*ListTopicSubscriptionsResponse, error)
	// Deletes the topic with the given name. Returns NOT_FOUND if the topic does
	// not exist. After a topic is deleted, a new topic may be created with the
	// same name; this is an entirely new topic with none of the old
	// configuration or subscriptions. Existing subscriptions to this topic are
	// not deleted.
	DeleteTopic(ctx context.Context, in *DeleteTopicRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error)
}

type publisherClient struct {
	cc *grpc.ClientConn
}

func NewPublisherClient(cc *grpc.ClientConn) PublisherClient {
	return &publisherClient{cc}
}

func (c *publisherClient) CreateTopic(ctx context.Context, in *Topic, opts ...grpc.CallOption) (*Topic, error) {
	out := new(Topic)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/CreateTopic", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) Publish(ctx context.Context, in *PublishRequest, opts ...grpc.CallOption) (*PublishResponse, error) {
	out := new(PublishResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/Publish", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) GetTopic(ctx context.Context, in *GetTopicRequest, opts ...grpc.CallOption) (*Topic, error) {
	out := new(Topic)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/GetTopic", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) ListTopics(ctx context.Context, in *ListTopicsRequest, opts ...grpc.CallOption) (*ListTopicsResponse, error) {
	out := new(ListTopicsResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/ListTopics", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) ListTopicSubscriptions(ctx context.Context, in *ListTopicSubscriptionsRequest, opts ...grpc.CallOption) (*ListTopicSubscriptionsResponse, error) {
	out := new(ListTopicSubscriptionsResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/ListTopicSubscriptions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) DeleteTopic(ctx context.Context, in *DeleteTopicRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error) {
	out := new(google_protobuf.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/DeleteTopic", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Publisher service

type PublisherServer interface {
	// Creates the given topic with the given name.
	CreateTopic(context.Context, *Topic) (*Topic, error)
	// Adds one or more messages to the topic. Returns NOT_FOUND if the topic does
	// not exist.
	Publish(context.Context, *PublishRequest) (*PublishResponse, error)
	// Gets the configuration of a topic.
	GetTopic(context.Context, *GetTopicRequest) (*Topic, error)
	// Lists matching topics.
	ListTopics(context.Context, *ListTopicsRequest) (*ListTopicsResponse, error)
	// Lists the name of the subscriptions for this topic.
	ListTopicSubscriptions(context.Context, *ListTopicSubscriptionsRequest) (*ListTopicSubscriptionsResponse, error)
	// Deletes the topic with the given name. Returns NOT_FOUND if the topic does
	// not exist. After a topic is deleted, a new topic may be created with the
	// same name; this is an entirely new topic with none of the old
	// configuration or subscriptions. Existing subscriptions to this topic are
	// not deleted.
	DeleteTopic(context.Context, *DeleteTopicRequest) (*google_protobuf.Empty, error)
}

func RegisterPublisherServer(s *grpc.Server, srv PublisherServer) {
	s.RegisterService(&_Publisher_serviceDesc, srv)
}

func _Publisher_CreateTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Topic)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).CreateTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/CreateTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).CreateTopic(ctx, req.(*Topic))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_Publish_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PublishRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).Publish(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/Publish",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).Publish(ctx, req.(*PublishRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_GetTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTopicRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).GetTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/GetTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).GetTopic(ctx, req.(*GetTopicRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_ListTopics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTopicsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).ListTopics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/ListTopics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).ListTopics(ctx, req.(*ListTopicsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_ListTopicSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTopicSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).ListTopicSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/ListTopicSubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).ListTopicSubscriptions(ctx, req.(*ListTopicSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_DeleteTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTopicRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).DeleteTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/DeleteTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).DeleteTopic(ctx, req.(*DeleteTopicRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Publisher_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.pubsub.v1beta2.Publisher",
	HandlerType: (*PublisherServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTopic",
			Handler:    _Publisher_CreateTopic_Handler,
		},
		{
			MethodName: "Publish",
			Handler:    _Publisher_Publish_Handler,
		},
		{
			MethodName: "GetTopic",
			Handler:    _Publisher_GetTopic_Handler,
		},
		{
			MethodName: "ListTopics",
			Handler:    _Publisher_ListTopics_Handler,
		},
		{
			MethodName: "ListTopicSubscriptions",
			Handler:    _Publisher_ListTopicSubscriptions_Handler,
		},
		{
			MethodName: "DeleteTopic",
			Handler:    _Publisher_DeleteTopic_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/pubsub/v1beta2/pubsub.proto",
}

func init() { proto.RegisterFile("google/pubsub/v1beta2/pubsub.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1107 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0x5f, 0x6f, 0xdb, 0x54,
	0x14, 0x97, 0x93, 0xfe, 0xcb, 0x71, 0x4a, 0xda, 0xab, 0xad, 0x73, 0x53, 0x06, 0x9d, 0x37, 0x4a,
	0x86, 0xb4, 0x64, 0x0b, 0x45, 0x42, 0x8c, 0x7f, 0xed, 0x56, 0x4d, 0x91, 0xa8, 0xc8, 0xdc, 0x3e,
	0xa0, 0x09, 0x2d, 0x72, 0xec, 0x5b, 0xc7, 0xc4, 0xb1, 0x3d, 0x5f, 0xbb, 0x34, 0x7b, 0x43, 0x08,
	0xc1, 0x13, 0x1f, 0x85, 0xaf, 0xc0, 0x03, 0x1f, 0x82, 0xaf, 0x83, 0x7c, 0xef, 0xb5, 0x63, 0xa7,
	0xbe, 0xa9, 0xdb, 0x89, 0x37, 0xdf, 0x73, 0xcf, 0xff, 0x73, 0x7e, 0xe7, 0x1e, 0x83, 0x6a, 0x79,
	0x9e, 0xe5, 0xe0, 0x8e, 0x1f, 0x0d, 0x49, 0x34, 0xec, 0x9c, 0x3f, 0x19, 0xe2, 0x50, 0xef, 0xf2,
	0x63, 0xdb, 0x0f, 0xbc, 0xd0, 0x43, 0xb7, 0x19, 0x4f, 0x9b, 0x13, 0x39, 0x4f, 0x73, 0x27, 0x11,
	0x8d, 0x99, 0x86, 0xd1, 0x59, 0x07, 0x4f, 0xfc, 0x70, 0xca, 0x64, 0xd4, 0x1d, 0x58, 0x3e, 0xf5,
	0x7c, 0xdb, 0x40, 0x08, 0x96, 0x5c, 0x7d, 0x82, 0x15, 0x69, 0x57, 0x6a, 0xd5, 0x34, 0xfa, 0xad,
	0xfe, 0x2b, 0xc1, 0x7a, 0x9f, 0x2a, 0x3b, 0xc6, 0x84, 0xe8, 0x16, 0x8e, 0xb9, 0x4c, 0x3d, 0xd4,
	0x29, 0x57, 0x5d, 0xa3, 0xdf, 0xe8, 0x14, 0x40, 0x0f, 0xc3, 0xc0, 0x1e, 0x46, 0x21, 0x26, 0x4a,
	0x65, 0xb7, 0xda, 0x92, 0xbb, 0xfb, 0xed, 0x42, 0x5f, 0xda, 0x39, 0x6d, 0xed, 0x83, 0x54, 0xec,
	0xc8, 0x0d, 0x83, 0xa9, 0x96, 0xd1, 0x83, 0xee, 0x02, 0x4c, 0x18, 0xdb, 0xc0, 0x36, 0x95, 0x2a,
	0xf5, 0xaa, 0xc6, 0x29, 0x3d, 0xb3, 0xf9, 0x15, 0x34, 0xe6, 0xa4, 0xd1, 0x06, 0x54, 0xc7, 0x78,
	0xca, 0x03, 0x88, 0x3f, 0xd1, 0x2d, 0x58, 0x3e, 0xd7, 0x9d, 0x08, 0x2b, 0x15, 0x4a, 0x63, 0x87,
	0x2f, 0x2a, 0x9f, 0x4b, 0xea, 0xc7, 0xd0, 0x78, 0x81, 0x43, 0x1a, 0xb9, 0x86, 0xdf, 0x44, 0x98,
	0x84, 0x31, 0x73, 0x18, 0x9f, 0xb9, 0x02, 0x76, 0x50, 0x47, 0xf0, 0x5e, 0x3f, 0x1a, 0x3a, 0x36,
	0x19, 0x2d, 0xe4, 0x43, 0xdf, 0xc2, 0x1a, 0x77, 0x2e, 0x49, 0xc1, 0x83, 0x32, 0x29, 0xd0, 0x52,
	0x29, 0xb5, 0x0b, 0x8d, 0xd4, 0x12, 0xf1, 0x3d, 0x97, 0x60, 0xf4, 0x21, 0xc8, 0xb3, 0x1c, 0x10,
	0x45, 0xda, 0xad, 0xb6, 0x6a, 0x1a, 0xa4, 0x49, 0x20, 0xaa, 0x0d, 0x9b, 0xdf, 0xd9, 0x84, 0xc5,
	0x41, 0x12, 0x07, 0x15, 0x58, 0xf5, 0x03, 0xef, 0x27, 0x6c, 0x84, 0xdc, 0xc5, 0xe4, 0x88, 0x76,
	0xa0, 0xe6, 0xc7, 0xca, 0x88, 0xfd, 0x96, 0xe5, 0x64, 0x59, 0x5b, 0x8b, 0x09, 0x27, 0xf6, 0x5b,
	0x1c, 0x27, 0x9c, 0x5e, 0x86, 0xde, 0x18, 0xbb, 0x49, 0xc2, 0x63, 0xca, 0x69, 0x4c, 0x50, 0x03,
	0x40, 0x59, 0x53, 0xdc, 0xc3, 0x7d, 0x58, 0xa1, 0xf1, 0x33, 0xe7, 0xe4, 0xee, 0xfb, 0x82, 0xa0,
	0x59, 0xa6, 0x39, 0x2f, 0xda, 0x83, 0x86, 0x8b, 0x2f, 0xc2, 0x41, 0xc6, 0x1e, 0xab, 0xd0, 0x7a,
	0x4c, 0xee, 0xa7, 0x36, 0xdf, 0xc0, 0xdd, 0xd4, 0xe6, 0x49, 0x34, 0x24, 0x46, 0x60, 0xfb, 0xa1,
	0xed, 0xb9, 0x64, 0x71, 0x2d, 0xde, 0x25, 0x4c, 0x17, 0x3e, 0x10, 0x99, 0xe4, 0x21, 0x3f, 0x80,
	0x75, 0x92, 0xbd, 0xe0, 0x65, 0xc9, 0x13, 0x4b, 0x87, 0xf8, 0x09, 0xa0, 0xe7, 0xd8, 0xc1, 0x21,
	0x2e, 0xd1, 0x8b, 0x7f, 0x49, 0x50, 0xcf, 0xfa, 0x54, 0x84, 0xd9, 0x99, 0x68, 0x25, 0x9b, 0x92,
	0x43, 0x90, 0xfd, 0x88, 0x8c, 0x06, 0x86, 0xe7, 0x9e, 0xd9, 0x96, 0xb2, 0xb4, 0x2b, 0xb5, 0xe4,
	0xee, 0x3d, 0x61, 0x87, 0x92, 0xd1, 0x33, 0xca, 0xa8, 0x81, 0x9f, 0x7e, 0xa3, 0xc7, 0x70, 0x4b,
	0x37, 0xc6, 0x03, 0x13, 0xeb, 0xa6, 0x63, 0xbb, 0x78, 0x40, 0xb0, 0xe1, 0xb9, 0x26, 0x51, 0x96,
	0x69, 0x86, 0x91, 0x6e, 0x8c, 0x9f, 0xf3, 0xab, 0x13, 0x76, 0xa3, 0xfe, 0x23, 0x01, 0xcc, 0x94,
	0xa1, 0xfb, 0xb0, 0x4e, 0x9d, 0xc0, 0xae, 0xe9, 0x7b, 0xb6, 0x9b, 0xb4, 0x67, 0x3d, 0x26, 0x1e,
	0x71, 0x1a, 0x7a, 0x59, 0x30, 0x4d, 0x9e, 0x5c, 0xe9, 0xe8, 0xa2, 0x51, 0xf2, 0xae, 0xb3, 0x62,
	0x04, 0x0d, 0x0d, 0x1b, 0xd8, 0x3e, 0xc7, 0x66, 0x32, 0x06, 0x6f, 0xc3, 0x4a, 0x9c, 0x0a, 0xdb,
	0x4c, 0x0a, 0xa4, 0x1b, 0xe3, 0x9e, 0x89, 0xbe, 0x86, 0x55, 0x0e, 0x4e, 0xaa, 0xa5, 0xec, 0x0c,
	0x48, 0x84, 0xd4, 0x2f, 0x61, 0xeb, 0x05, 0x0e, 0xb3, 0x25, 0x4e, 0x1a, 0x42, 0x85, 0x7a, 0xb6,
	0xbf, 0x92, 0xcc, 0x65, 0x69, 0xaa, 0x0f, 0x4a, 0xdc, 0xba, 0x85, 0x40, 0xf9, 0x7f, 0x66, 0xc2,
	0x9f, 0x12, 0x6c, 0x17, 0x98, 0xe4, 0x40, 0xe9, 0x15, 0x01, 0x45, 0xee, 0xde, 0x17, 0xe4, 0x24,
	0x17, 0xf6, 0x0d, 0xd1, 0xf4, 0x0d, 0x6c, 0x33, 0x34, 0xdd, 0x34, 0x87, 0xbf, 0x48, 0x70, 0xe7,
	0xd8, 0x33, 0xed, 0xb3, 0x69, 0x06, 0x04, 0xe5, 0xe5, 0xe7, 0x71, 0x56, 0xb9, 0x01, 0xce, 0xd4,
	0x5f, 0x25, 0x90, 0xfb, 0x91, 0xe3, 0x5c, 0xc7, 0xee, 0x23, 0x40, 0x01, 0x0e, 0xa3, 0xc0, 0x1d,
	0xd8, 0x93, 0x09, 0x36, 0x6d, 0x3d, 0xc4, 0xce, 0x94, 0x9a, 0x5f, 0xd3, 0x36, 0xd9, 0x4d, 0x6f,
	0x76, 0x81, 0xee, 0x41, 0x7d, 0xa2, 0x5f, 0x0c, 0xd2, 0x17, 0xab, 0x4a, 0xeb, 0x2e, 0x4f, 0xf4,
	0x8b, 0xe3, 0xe4, 0x39, 0x32, 0xa0, 0xce, 0x9c, 0xe0, 0xd5, 0x3c, 0x81, 0xcd, 0x80, 0xa3, 0x60,
	0x26, 0xc7, 0x2a, 0xba, 0x27, 0x88, 0x6f, 0x0e, 0x35, 0xda, 0x46, 0x90, 0x27, 0x10, 0xf5, 0x77,
	0x09, 0x14, 0x96, 0xee, 0x83, 0xd9, 0xf4, 0xb8, 0x4e, 0xdc, 0x33, 0x20, 0x56, 0xb2, 0x40, 0x14,
	0x8d, 0xaa, 0xaa, 0x70, 0x54, 0xbd, 0x04, 0x74, 0x60, 0x8c, 0x5d, 0xef, 0x67, 0x07, 0x9b, 0xd6,
	0xb5, 0x5c, 0xb8, 0x03, 0xab, 0xcc, 0x05, 0x36, 0xad, 0x6a, 0xda, 0x0a, 0xf5, 0x81, 0x74, 0xff,
	0x58, 0x01, 0xe0, 0x7d, 0x38, 0xc4, 0x01, 0x7a, 0x0d, 0xe8, 0x59, 0x80, 0xf5, 0x7c, 0x6f, 0xa2,
	0x32, 0x68, 0x68, 0x96, 0x61, 0x42, 0x98, 0xae, 0x34, 0x39, 0xd2, 0x23, 0x81, 0x5c, 0xf1, 0x90,
	0x29, 0x67, 0xe6, 0x9c, 0xad, 0x1c, 0x39, 0xc8, 0xa3, 0x8e, 0x40, 0x52, 0x34, 0x8f, 0x9a, 0x8f,
	0xcb, 0x0b, 0xf0, 0xfe, 0x7b, 0x9d, 0x3c, 0x94, 0x39, 0x6f, 0x44, 0x7a, 0x84, 0x53, 0xa0, 0xb9,
	0x95, 0x4a, 0xf0, 0x75, 0xb8, 0x7d, 0x14, 0xaf, 0xc3, 0xe8, 0x47, 0xd8, 0xbc, 0xd4, 0x89, 0xc2,
	0xb8, 0x44, 0x3d, 0x2b, 0xd4, 0xde, 0x07, 0x39, 0xd3, 0x5e, 0xe8, 0xa1, 0x40, 0xef, 0xe5, 0x16,
	0x14, 0x6a, 0xfc, 0x1e, 0x96, 0x62, 0x7c, 0x22, 0x55, 0x38, 0x5c, 0xd2, 0x09, 0x22, 0x2c, 0x6c,
	0x0e, 0xe0, 0xaf, 0x60, 0x63, 0x7e, 0xf2, 0xa1, 0xf6, 0xc2, 0xf8, 0x2f, 0x8d, 0x48, 0x91, 0xb3,
	0xdd, 0xbf, 0x97, 0xa0, 0xc6, 0x97, 0x5b, 0x1c, 0xa0, 0x1e, 0xc8, 0x0c, 0x09, 0xec, 0xcf, 0x63,
	0xe1, 0xce, 0xd8, 0x5c, 0x78, 0x8b, 0x7e, 0x80, 0x55, 0xae, 0x17, 0x7d, 0x24, 0x7e, 0x6b, 0x33,
	0xeb, 0x7b, 0x73, 0xef, 0x2a, 0x36, 0x9e, 0x8e, 0x3e, 0xac, 0x25, 0x7f, 0x08, 0x68, 0x4f, 0x8c,
	0xa3, 0xec, 0xda, 0x76, 0x85, 0xaf, 0x3a, 0xc0, 0x6c, 0x83, 0x46, 0xad, 0x05, 0x08, 0xc8, 0xed,
	0xf3, 0xcd, 0x87, 0x25, 0x38, 0xb9, 0xd3, 0xbf, 0x49, 0xb0, 0x55, 0xbc, 0xbe, 0xa2, 0xfd, 0xab,
	0xb4, 0x14, 0xe2, 0xf4, 0xb3, 0x6b, 0x4a, 0xa5, 0xc9, 0x93, 0x33, 0x5b, 0xad, 0xb0, 0xdd, 0x2f,
	0x6f, 0xbe, 0xa2, 0x0e, 0x3a, 0xb4, 0x60, 0xdb, 0xf0, 0x26, 0xc5, 0x7a, 0x0e, 0x65, 0xb6, 0x4f,
	0xf5, 0x63, 0x91, 0xbe, 0xf4, 0xea, 0x29, 0xe7, 0xb2, 0x3c, 0x47, 0x77, 0xad, 0xb6, 0x17, 0x58,
	0x1d, 0x0b, 0xbb, 0x54, 0x61, 0x87, 0x5d, 0xe9, 0xbe, 0x4d, 0xe6, 0x7e, 0xa5, 0x9f, 0xb2, 0xe3,
	0x70, 0x85, 0xf2, 0x7d, 0xfa, 0x5f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xe2, 0x2d, 0xb0, 0x67, 0x71,
	0x0f, 0x00, 0x00,
}
