// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/kube-reporting/metering-operator/pkg/apis/metering/v1"
	scheme "github.com/kube-reporting/metering-operator/pkg/generated/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ReportDataSourcesGetter has a method to return a ReportDataSourceInterface.
// A group's client should implement this interface.
type ReportDataSourcesGetter interface {
	ReportDataSources(namespace string) ReportDataSourceInterface
}

// ReportDataSourceInterface has methods to work with ReportDataSource resources.
type ReportDataSourceInterface interface {
	Create(ctx context.Context, reportDataSource *v1.ReportDataSource, opts metav1.CreateOptions) (*v1.ReportDataSource, error)
	Update(ctx context.Context, reportDataSource *v1.ReportDataSource, opts metav1.UpdateOptions) (*v1.ReportDataSource, error)
	UpdateStatus(ctx context.Context, reportDataSource *v1.ReportDataSource, opts metav1.UpdateOptions) (*v1.ReportDataSource, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.ReportDataSource, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ReportDataSourceList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ReportDataSource, err error)
	ReportDataSourceExpansion
}

// reportDataSources implements ReportDataSourceInterface
type reportDataSources struct {
	client rest.Interface
	ns     string
}

// newReportDataSources returns a ReportDataSources
func newReportDataSources(c *MeteringV1Client, namespace string) *reportDataSources {
	return &reportDataSources{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the reportDataSource, and returns the corresponding reportDataSource object, and an error if there is any.
func (c *reportDataSources) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.ReportDataSource, err error) {
	result = &v1.ReportDataSource{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("reportdatasources").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ReportDataSources that match those selectors.
func (c *reportDataSources) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ReportDataSourceList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ReportDataSourceList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("reportdatasources").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested reportDataSources.
func (c *reportDataSources) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("reportdatasources").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a reportDataSource and creates it.  Returns the server's representation of the reportDataSource, and an error, if there is any.
func (c *reportDataSources) Create(ctx context.Context, reportDataSource *v1.ReportDataSource, opts metav1.CreateOptions) (result *v1.ReportDataSource, err error) {
	result = &v1.ReportDataSource{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("reportdatasources").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(reportDataSource).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a reportDataSource and updates it. Returns the server's representation of the reportDataSource, and an error, if there is any.
func (c *reportDataSources) Update(ctx context.Context, reportDataSource *v1.ReportDataSource, opts metav1.UpdateOptions) (result *v1.ReportDataSource, err error) {
	result = &v1.ReportDataSource{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("reportdatasources").
		Name(reportDataSource.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(reportDataSource).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *reportDataSources) UpdateStatus(ctx context.Context, reportDataSource *v1.ReportDataSource, opts metav1.UpdateOptions) (result *v1.ReportDataSource, err error) {
	result = &v1.ReportDataSource{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("reportdatasources").
		Name(reportDataSource.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(reportDataSource).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the reportDataSource and deletes it. Returns an error if one occurs.
func (c *reportDataSources) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("reportdatasources").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *reportDataSources) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("reportdatasources").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched reportDataSource.
func (c *reportDataSources) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ReportDataSource, err error) {
	result = &v1.ReportDataSource{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("reportdatasources").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
