// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/redis/v1beta1/cloud_redis.proto

package redis // import "google.golang.org/genproto/googleapis/cloud/redis/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Represents the different states of a Redis instance.
type Instance_State int32

const (
	// Not set.
	Instance_STATE_UNSPECIFIED Instance_State = 0
	// Redis instance is being created.
	Instance_CREATING Instance_State = 1
	// Redis instance has been created and is fully usable.
	Instance_READY Instance_State = 2
	// Redis instance configuration is being updated. Certain kinds of updates
	// may cause the instance to become unusable while the update is in
	// progress.
	Instance_UPDATING Instance_State = 3
	// Redis instance is being deleted.
	Instance_DELETING Instance_State = 4
	// Redis instance is being repaired and may be unusable. Details can be
	// found in the `status_message` field.
	Instance_REPAIRING Instance_State = 5
	// Maintenance is being performed on this Redis instance.
	Instance_MAINTENANCE Instance_State = 6
)

var Instance_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "CREATING",
	2: "READY",
	3: "UPDATING",
	4: "DELETING",
	5: "REPAIRING",
	6: "MAINTENANCE",
}
var Instance_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"CREATING":          1,
	"READY":             2,
	"UPDATING":          3,
	"DELETING":          4,
	"REPAIRING":         5,
	"MAINTENANCE":       6,
}

func (x Instance_State) String() string {
	return proto.EnumName(Instance_State_name, int32(x))
}
func (Instance_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_93920e123363dc4d, []int{0, 0}
}

// Available service tiers to choose from
type Instance_Tier int32

const (
	// Not set.
	Instance_TIER_UNSPECIFIED Instance_Tier = 0
	// BASIC tier: standalone instance
	Instance_BASIC Instance_Tier = 1
	// STANDARD_HA tier: highly available primary/replica instances
	Instance_STANDARD_HA Instance_Tier = 3
)

var Instance_Tier_name = map[int32]string{
	0: "TIER_UNSPECIFIED",
	1: "BASIC",
	3: "STANDARD_HA",
}
var Instance_Tier_value = map[string]int32{
	"TIER_UNSPECIFIED": 0,
	"BASIC":            1,
	"STANDARD_HA":      3,
}

func (x Instance_Tier) String() string {
	return proto.EnumName(Instance_Tier_name, int32(x))
}
func (Instance_Tier) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_93920e123363dc4d, []int{0, 1}
}

// A Google Cloud Redis instance.
type Instance struct {
	// Required. Unique name of the resource in this scope including project and
	// location using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	//
	// Note: Redis instances are managed and addressed at regional level so
	// location_id here refers to a GCP region; however, users get to choose which
	// specific zone (or collection of zones for cross-zone instances) an instance
	// should be provisioned in. Refer to [location_id] and
	// [alternative_location_id] fields for more details.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An arbitrary and optional user-provided name for the instance.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Resource labels to represent user provided metadata
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The zone where the instance will be provisioned. If not provided,
	// the service will choose a zone for the instance. For STANDARD_HA tier,
	// instances will be created across two zones for protection against zonal
	// failures. if [alternative_location_id] is also provided, it must be
	// different from [location_id].
	LocationId string `protobuf:"bytes,4,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	// Optional. Only applicable to STANDARD_HA tier which protects the instance
	// against zonal failures by provisioning it across two zones. If provided, it
	// must be a different zone from the one provided in [location_id].
	AlternativeLocationId string `protobuf:"bytes,5,opt,name=alternative_location_id,json=alternativeLocationId,proto3" json:"alternative_location_id,omitempty"`
	// Optional. The version of Redis software.
	// If not provided, latest supported version will be used.
	RedisVersion string `protobuf:"bytes,7,opt,name=redis_version,json=redisVersion,proto3" json:"redis_version,omitempty"`
	// Optional. The CIDR range of internal addresses that are reserved for this
	// instance. If not provided, the service will choose an unused /29 block,
	// for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be unique
	// and non-overlapping with existing subnets in a network.
	ReservedIpRange string `protobuf:"bytes,9,opt,name=reserved_ip_range,json=reservedIpRange,proto3" json:"reserved_ip_range,omitempty"`
	// Output only. Hostname or IP address of the exposed redis endpoint used by
	// clients to connect to the service.
	Host string `protobuf:"bytes,10,opt,name=host,proto3" json:"host,omitempty"`
	// Output only. The port number of the exposed redis endpoint.
	Port int32 `protobuf:"varint,11,opt,name=port,proto3" json:"port,omitempty"`
	// Output only. The current zone where the Redis endpoint is placed. In
	// single zone deployments, this will always be the same as [location_id]
	// provided by the user at creation time. In cross-zone instances (only
	// applicable in STANDARD_HA tier), this can be either [location_id] or
	// [alternative_location_id] and can change on a failover event.
	CurrentLocationId string `protobuf:"bytes,12,opt,name=current_location_id,json=currentLocationId,proto3" json:"current_location_id,omitempty"`
	// Output only. The time the instance was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,13,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The current state of this instance.
	State Instance_State `protobuf:"varint,14,opt,name=state,proto3,enum=google.cloud.redis.v1beta1.Instance_State" json:"state,omitempty"`
	// Output only. Additional information about the current status of this
	// instance, if available.
	StatusMessage string `protobuf:"bytes,15,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Optional. Redis configuration parameters, according to
	// http://redis.io/topics/config. Currently, the only supported parameters
	// are:
	//  * maxmemory-policy
	//  * notify-keyspace-events
	RedisConfigs map[string]string `protobuf:"bytes,16,rep,name=redis_configs,json=redisConfigs,proto3" json:"redis_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The service tier of the instance.
	Tier Instance_Tier `protobuf:"varint,17,opt,name=tier,proto3,enum=google.cloud.redis.v1beta1.Instance_Tier" json:"tier,omitempty"`
	// Required. Redis memory size in GB.
	MemorySizeGb int32 `protobuf:"varint,18,opt,name=memory_size_gb,json=memorySizeGb,proto3" json:"memory_size_gb,omitempty"`
	// Optional. The full name of the Google Compute Engine
	// [network](/compute/docs/networks-and-firewalls#networks) to which the
	// instance is connected. If left unspecified, the `default` network
	// will be used.
	AuthorizedNetwork    string   `protobuf:"bytes,20,opt,name=authorized_network,json=authorizedNetwork,proto3" json:"authorized_network,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Instance) Reset()         { *m = Instance{} }
func (m *Instance) String() string { return proto.CompactTextString(m) }
func (*Instance) ProtoMessage()    {}
func (*Instance) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_93920e123363dc4d, []int{0}
}
func (m *Instance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Instance.Unmarshal(m, b)
}
func (m *Instance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Instance.Marshal(b, m, deterministic)
}
func (dst *Instance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Instance.Merge(dst, src)
}
func (m *Instance) XXX_Size() int {
	return xxx_messageInfo_Instance.Size(m)
}
func (m *Instance) XXX_DiscardUnknown() {
	xxx_messageInfo_Instance.DiscardUnknown(m)
}

var xxx_messageInfo_Instance proto.InternalMessageInfo

func (m *Instance) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Instance) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Instance) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Instance) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

func (m *Instance) GetAlternativeLocationId() string {
	if m != nil {
		return m.AlternativeLocationId
	}
	return ""
}

func (m *Instance) GetRedisVersion() string {
	if m != nil {
		return m.RedisVersion
	}
	return ""
}

func (m *Instance) GetReservedIpRange() string {
	if m != nil {
		return m.ReservedIpRange
	}
	return ""
}

func (m *Instance) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *Instance) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *Instance) GetCurrentLocationId() string {
	if m != nil {
		return m.CurrentLocationId
	}
	return ""
}

func (m *Instance) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Instance) GetState() Instance_State {
	if m != nil {
		return m.State
	}
	return Instance_STATE_UNSPECIFIED
}

func (m *Instance) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *Instance) GetRedisConfigs() map[string]string {
	if m != nil {
		return m.RedisConfigs
	}
	return nil
}

func (m *Instance) GetTier() Instance_Tier {
	if m != nil {
		return m.Tier
	}
	return Instance_TIER_UNSPECIFIED
}

func (m *Instance) GetMemorySizeGb() int32 {
	if m != nil {
		return m.MemorySizeGb
	}
	return 0
}

func (m *Instance) GetAuthorizedNetwork() string {
	if m != nil {
		return m.AuthorizedNetwork
	}
	return ""
}

// Request for [ListInstances][google.cloud.redis.v1beta1.CloudRedis.ListInstances].
type ListInstancesRequest struct {
	// Required. The resource name of the instance location using the form:
	//     `projects/{project_id}/locations/{location_id}`
	// where `location_id` refers to a GCP region
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 1000 will be used by the service.
	// Regardless of the page_size value, the response may include a partial list
	// and a caller should only rely on response's
	// [next_page_token][CloudRedis.ListInstancesResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request,
	// if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesRequest) Reset()         { *m = ListInstancesRequest{} }
func (m *ListInstancesRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstancesRequest) ProtoMessage()    {}
func (*ListInstancesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_93920e123363dc4d, []int{1}
}
func (m *ListInstancesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesRequest.Unmarshal(m, b)
}
func (m *ListInstancesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesRequest.Marshal(b, m, deterministic)
}
func (dst *ListInstancesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesRequest.Merge(dst, src)
}
func (m *ListInstancesRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstancesRequest.Size(m)
}
func (m *ListInstancesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesRequest proto.InternalMessageInfo

func (m *ListInstancesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListInstancesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstancesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for [ListInstances][google.cloud.redis.v1beta1.CloudRedis.ListInstances].
type ListInstancesResponse struct {
	// A list of Redis instances in the project in the specified location,
	// or across all locations.
	//
	// If the `location_id` in the parent field of the request is "-", all regions
	// available to the project are queried, and the results aggregated.
	// If in such an aggregated query a location is unavailable, a dummy Redis
	// entry is included in the response with the "name" field set to a value of
	// the form projects/{project_id}/locations/{location_id}/instances/- and the
	// "status" field set to ERROR and "status_message" field set to "location not
	// available for ListInstances".
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesResponse) Reset()         { *m = ListInstancesResponse{} }
func (m *ListInstancesResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstancesResponse) ProtoMessage()    {}
func (*ListInstancesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_93920e123363dc4d, []int{2}
}
func (m *ListInstancesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesResponse.Unmarshal(m, b)
}
func (m *ListInstancesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesResponse.Marshal(b, m, deterministic)
}
func (dst *ListInstancesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesResponse.Merge(dst, src)
}
func (m *ListInstancesResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstancesResponse.Size(m)
}
func (m *ListInstancesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesResponse proto.InternalMessageInfo

func (m *ListInstancesResponse) GetInstances() []*Instance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *ListInstancesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for [GetInstance][google.cloud.redis.v1beta1.CloudRedis.GetInstance].
type GetInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetInstanceRequest) Reset()         { *m = GetInstanceRequest{} }
func (m *GetInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*GetInstanceRequest) ProtoMessage()    {}
func (*GetInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_93920e123363dc4d, []int{3}
}
func (m *GetInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInstanceRequest.Unmarshal(m, b)
}
func (m *GetInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *GetInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInstanceRequest.Merge(dst, src)
}
func (m *GetInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_GetInstanceRequest.Size(m)
}
func (m *GetInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetInstanceRequest proto.InternalMessageInfo

func (m *GetInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for [CreateInstance][google.cloud.redis.v1beta1.CloudRedis.CreateInstance].
type CreateInstanceRequest struct {
	// Required. The resource name of the instance location using the form:
	//     `projects/{project_id}/locations/{location_id}`
	// where `location_id` refers to a GCP region
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The logical name of the Redis instance in the customer project
	// with the following restrictions:
	//
	// * Must contain only lowercase letters, numbers, and hyphens.
	// * Must start with a letter.
	// * Must be between 1-40 characters.
	// * Must end with a number or a letter.
	// * Must be unique within the customer project / location
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Required. A Redis [Instance] resource
	Instance             *Instance `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateInstanceRequest) Reset()         { *m = CreateInstanceRequest{} }
func (m *CreateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateInstanceRequest) ProtoMessage()    {}
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_93920e123363dc4d, []int{4}
}
func (m *CreateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstanceRequest.Unmarshal(m, b)
}
func (m *CreateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *CreateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstanceRequest.Merge(dst, src)
}
func (m *CreateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateInstanceRequest.Size(m)
}
func (m *CreateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstanceRequest proto.InternalMessageInfo

func (m *CreateInstanceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

// Request for [UpdateInstance][google.cloud.redis.v1beta1.CloudRedis.UpdateInstance].
type UpdateInstanceRequest struct {
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. The elements of the repeated paths field may only include these
	// fields from [Instance][CloudRedis.Instance]:
	// * `display_name`
	// * `labels`
	// * `memory_size_gb`
	// * `redis_config`
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Update description.
	// Only fields specified in update_mask are updated.
	Instance             *Instance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *UpdateInstanceRequest) Reset()         { *m = UpdateInstanceRequest{} }
func (m *UpdateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateInstanceRequest) ProtoMessage()    {}
func (*UpdateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_93920e123363dc4d, []int{5}
}
func (m *UpdateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInstanceRequest.Unmarshal(m, b)
}
func (m *UpdateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInstanceRequest.Merge(dst, src)
}
func (m *UpdateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateInstanceRequest.Size(m)
}
func (m *UpdateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInstanceRequest proto.InternalMessageInfo

func (m *UpdateInstanceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

// Request for [DeleteInstance][google.cloud.redis.v1beta1.CloudRedis.DeleteInstance].
type DeleteInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInstanceRequest) Reset()         { *m = DeleteInstanceRequest{} }
func (m *DeleteInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteInstanceRequest) ProtoMessage()    {}
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_93920e123363dc4d, []int{6}
}
func (m *DeleteInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInstanceRequest.Unmarshal(m, b)
}
func (m *DeleteInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInstanceRequest.Merge(dst, src)
}
func (m *DeleteInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteInstanceRequest.Size(m)
}
func (m *DeleteInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInstanceRequest proto.InternalMessageInfo

func (m *DeleteInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// This location metadata represents additional configuration options for a
// given location where a Redis instance may be created. All fields are output
// only. It is returned as content of the
// `google.cloud.location.Location.metadata` field.
type LocationMetadata struct {
	// Output only. The set of available zones in the location. The map is keyed
	// by the lowercase ID of each zone, as defined by GCE. These keys can be
	// specified in `location_id` or `alternative_location_id` fields when
	// creating a Redis instance.
	AvailableZones       map[string]*ZoneMetadata `protobuf:"bytes,1,rep,name=available_zones,json=availableZones,proto3" json:"available_zones,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *LocationMetadata) Reset()         { *m = LocationMetadata{} }
func (m *LocationMetadata) String() string { return proto.CompactTextString(m) }
func (*LocationMetadata) ProtoMessage()    {}
func (*LocationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_93920e123363dc4d, []int{7}
}
func (m *LocationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocationMetadata.Unmarshal(m, b)
}
func (m *LocationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocationMetadata.Marshal(b, m, deterministic)
}
func (dst *LocationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocationMetadata.Merge(dst, src)
}
func (m *LocationMetadata) XXX_Size() int {
	return xxx_messageInfo_LocationMetadata.Size(m)
}
func (m *LocationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LocationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LocationMetadata proto.InternalMessageInfo

func (m *LocationMetadata) GetAvailableZones() map[string]*ZoneMetadata {
	if m != nil {
		return m.AvailableZones
	}
	return nil
}

// Defines specific information for a particular zone. Currently empty and
// reserved for future use only.
type ZoneMetadata struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ZoneMetadata) Reset()         { *m = ZoneMetadata{} }
func (m *ZoneMetadata) String() string { return proto.CompactTextString(m) }
func (*ZoneMetadata) ProtoMessage()    {}
func (*ZoneMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_93920e123363dc4d, []int{8}
}
func (m *ZoneMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ZoneMetadata.Unmarshal(m, b)
}
func (m *ZoneMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ZoneMetadata.Marshal(b, m, deterministic)
}
func (dst *ZoneMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ZoneMetadata.Merge(dst, src)
}
func (m *ZoneMetadata) XXX_Size() int {
	return xxx_messageInfo_ZoneMetadata.Size(m)
}
func (m *ZoneMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ZoneMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ZoneMetadata proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Instance)(nil), "google.cloud.redis.v1beta1.Instance")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.redis.v1beta1.Instance.LabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.redis.v1beta1.Instance.RedisConfigsEntry")
	proto.RegisterType((*ListInstancesRequest)(nil), "google.cloud.redis.v1beta1.ListInstancesRequest")
	proto.RegisterType((*ListInstancesResponse)(nil), "google.cloud.redis.v1beta1.ListInstancesResponse")
	proto.RegisterType((*GetInstanceRequest)(nil), "google.cloud.redis.v1beta1.GetInstanceRequest")
	proto.RegisterType((*CreateInstanceRequest)(nil), "google.cloud.redis.v1beta1.CreateInstanceRequest")
	proto.RegisterType((*UpdateInstanceRequest)(nil), "google.cloud.redis.v1beta1.UpdateInstanceRequest")
	proto.RegisterType((*DeleteInstanceRequest)(nil), "google.cloud.redis.v1beta1.DeleteInstanceRequest")
	proto.RegisterType((*LocationMetadata)(nil), "google.cloud.redis.v1beta1.LocationMetadata")
	proto.RegisterMapType((map[string]*ZoneMetadata)(nil), "google.cloud.redis.v1beta1.LocationMetadata.AvailableZonesEntry")
	proto.RegisterType((*ZoneMetadata)(nil), "google.cloud.redis.v1beta1.ZoneMetadata")
	proto.RegisterEnum("google.cloud.redis.v1beta1.Instance_State", Instance_State_name, Instance_State_value)
	proto.RegisterEnum("google.cloud.redis.v1beta1.Instance_Tier", Instance_Tier_name, Instance_Tier_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// CloudRedisClient is the client API for CloudRedis service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudRedisClient interface {
	// Lists all Redis instances owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets the details of a specific Redis instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Creates a Redis instance based on the specified tier and memory size.
	//
	// By default, the instance is peered to the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// instance will be fully functional. Completed longrunning.Operation will
	// contain the new instance object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the metadata and configuration of a specific Redis instance.
	//
	// Completed longrunning.Operation will contain the new instance object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a specific Redis instance.  Instance stops serving and data is
	// deleted.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type cloudRedisClient struct {
	cc *grpc.ClientConn
}

func NewCloudRedisClient(cc *grpc.ClientConn) CloudRedisClient {
	return &cloudRedisClient{cc}
}

func (c *cloudRedisClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/ListInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/GetInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/CreateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/UpdateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/DeleteInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudRedisServer is the server API for CloudRedis service.
type CloudRedisServer interface {
	// Lists all Redis instances owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets the details of a specific Redis instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Creates a Redis instance based on the specified tier and memory size.
	//
	// By default, the instance is peered to the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// instance will be fully functional. Completed longrunning.Operation will
	// contain the new instance object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunning.Operation, error)
	// Updates the metadata and configuration of a specific Redis instance.
	//
	// Completed longrunning.Operation will contain the new instance object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunning.Operation, error)
	// Deletes a specific Redis instance.  Instance stops serving and data is
	// deleted.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunning.Operation, error)
}

func RegisterCloudRedisServer(s *grpc.Server, srv CloudRedisServer) {
	s.RegisterService(&_CloudRedis_serviceDesc, srv)
}

func _CloudRedis_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/CreateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/UpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/DeleteInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudRedis_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.redis.v1beta1.CloudRedis",
	HandlerType: (*CloudRedisServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstances",
			Handler:    _CloudRedis_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _CloudRedis_GetInstance_Handler,
		},
		{
			MethodName: "CreateInstance",
			Handler:    _CloudRedis_CreateInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _CloudRedis_UpdateInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _CloudRedis_DeleteInstance_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/redis/v1beta1/cloud_redis.proto",
}

func init() {
	proto.RegisterFile("google/cloud/redis/v1beta1/cloud_redis.proto", fileDescriptor_cloud_redis_93920e123363dc4d)
}

var fileDescriptor_cloud_redis_93920e123363dc4d = []byte{
	// 1230 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0xdf, 0x6e, 0x1b, 0xc5,
	0x17, 0xfe, 0x6d, 0x12, 0xe7, 0x17, 0x9f, 0x4d, 0x1c, 0x67, 0x9a, 0xc0, 0xca, 0x50, 0x1a, 0xdc,
	0x82, 0x4c, 0x80, 0x5d, 0x6a, 0x50, 0x55, 0x1a, 0xf5, 0x8f, 0x63, 0x6f, 0x53, 0x4b, 0x89, 0x89,
	0xd6, 0x2e, 0x12, 0xe5, 0x62, 0x35, 0xb6, 0xa7, 0xdb, 0x6d, 0xd6, 0x3b, 0xcb, 0xce, 0xd8, 0x90,
	0xa0, 0x0a, 0x09, 0xde, 0x00, 0x24, 0x2e, 0xe1, 0x96, 0x4b, 0x78, 0x12, 0x2e, 0x78, 0x02, 0x24,
	0xae, 0x78, 0x0a, 0x34, 0x33, 0xbb, 0xb1, 0x9d, 0x6e, 0x5d, 0x37, 0x77, 0x33, 0xdf, 0xf9, 0xce,
	0xcc, 0x37, 0xe7, 0xcc, 0x37, 0x6b, 0xc3, 0x07, 0x1e, 0xa5, 0x5e, 0x40, 0xac, 0x5e, 0x40, 0x87,
	0x7d, 0x2b, 0x26, 0x7d, 0x9f, 0x59, 0xa3, 0xeb, 0x5d, 0xc2, 0xf1, 0x75, 0x85, 0xb9, 0x12, 0x33,
	0xa3, 0x98, 0x72, 0x8a, 0x4a, 0x8a, 0x6d, 0xca, 0x88, 0xa9, 0x22, 0x09, 0xbb, 0xf4, 0x66, 0xb2,
	0x12, 0x8e, 0x7c, 0x0b, 0x87, 0x21, 0xe5, 0x98, 0xfb, 0x34, 0x4c, 0x32, 0x4b, 0x57, 0x93, 0x68,
	0x40, 0x43, 0x2f, 0x1e, 0x86, 0xa1, 0x1f, 0x7a, 0x16, 0x8d, 0x48, 0x3c, 0x45, 0xda, 0x4e, 0x48,
	0x72, 0xd6, 0x1d, 0x3e, 0xb6, 0x1e, 0xfb, 0x24, 0xe8, 0xbb, 0x03, 0xcc, 0x8e, 0x13, 0xc6, 0x95,
	0xf3, 0x0c, 0xee, 0x0f, 0x08, 0xe3, 0x78, 0x10, 0x29, 0x42, 0xf9, 0xcf, 0x15, 0x58, 0x69, 0x86,
	0x8c, 0xe3, 0xb0, 0x47, 0x10, 0x82, 0xa5, 0x10, 0x0f, 0x88, 0xa1, 0x6d, 0x6b, 0x95, 0xbc, 0x23,
	0xc7, 0xe8, 0x6d, 0x58, 0xed, 0xfb, 0x2c, 0x0a, 0xf0, 0x89, 0x2b, 0x63, 0x0b, 0x32, 0xa6, 0x27,
	0x58, 0x4b, 0x50, 0x1e, 0xc0, 0x72, 0x80, 0xbb, 0x24, 0x60, 0xc6, 0xe2, 0xf6, 0x62, 0x45, 0xaf,
	0x7e, 0x64, 0xbe, 0xf8, 0xd8, 0x66, 0xba, 0x99, 0x79, 0x20, 0x53, 0xec, 0x90, 0xc7, 0x27, 0x4e,
	0x92, 0x8f, 0xae, 0x80, 0x1e, 0xd0, 0x9e, 0x3c, 0xa3, 0xeb, 0xf7, 0x8d, 0x25, 0xb9, 0x17, 0xa4,
	0x50, 0xb3, 0x8f, 0x6e, 0xc0, 0xeb, 0x38, 0xe0, 0x24, 0x0e, 0x31, 0xf7, 0x47, 0xc4, 0x9d, 0x24,
	0xe7, 0x24, 0x79, 0x6b, 0x22, 0x7c, 0x30, 0xce, 0xbb, 0x0a, 0x6b, 0x52, 0x86, 0x3b, 0x22, 0x31,
	0xf3, 0x69, 0x68, 0xfc, 0x5f, 0xb2, 0x57, 0x25, 0xf8, 0xb9, 0xc2, 0xd0, 0x0e, 0x6c, 0xc4, 0x84,
	0x91, 0x78, 0x44, 0xfa, 0xae, 0x1f, 0xb9, 0x31, 0x0e, 0x3d, 0x62, 0xe4, 0x25, 0x71, 0x3d, 0x0d,
	0x34, 0x23, 0x47, 0xc0, 0xa2, 0x54, 0x4f, 0x28, 0xe3, 0x06, 0xa8, 0x52, 0x89, 0xb1, 0xc0, 0x22,
	0x1a, 0x73, 0x43, 0xdf, 0xd6, 0x2a, 0x39, 0x47, 0x8e, 0x91, 0x09, 0x97, 0x7a, 0xc3, 0x38, 0x26,
	0x21, 0x9f, 0x12, 0xbb, 0x2a, 0xd3, 0x36, 0x92, 0xd0, 0x84, 0xd0, 0x5d, 0xd0, 0x7b, 0x31, 0xc1,
	0x9c, 0xb8, 0xa2, 0x53, 0xc6, 0xda, 0xb6, 0x56, 0xd1, 0xab, 0xa5, 0xb4, 0xa0, 0x69, 0x1b, 0xcd,
	0x4e, 0xda, 0x46, 0x07, 0x14, 0x5d, 0x00, 0xe8, 0x1e, 0xe4, 0x18, 0xc7, 0x9c, 0x18, 0x85, 0x6d,
	0xad, 0x52, 0xa8, 0xee, 0xcc, 0xd5, 0x87, 0xb6, 0xc8, 0x70, 0x54, 0x22, 0x7a, 0x07, 0x0a, 0x62,
	0x30, 0x64, 0xee, 0x80, 0x30, 0x86, 0x3d, 0x62, 0xac, 0x4b, 0xa5, 0x6b, 0x0a, 0x3d, 0x54, 0x20,
	0xfa, 0x32, 0x2d, 0x67, 0x8f, 0x86, 0x8f, 0x7d, 0x8f, 0x19, 0x45, 0xd9, 0xf8, 0x1b, 0x73, 0x6d,
	0xe8, 0x08, 0xb8, 0xae, 0x12, 0x55, 0xfb, 0x55, 0x1b, 0x12, 0x08, 0xdd, 0x86, 0x25, 0xee, 0x93,
	0xd8, 0xd8, 0x90, 0x87, 0x78, 0x6f, 0xae, 0x35, 0x3b, 0x3e, 0x89, 0x1d, 0x99, 0x86, 0xae, 0x41,
	0x61, 0x40, 0x06, 0x34, 0x3e, 0x71, 0x99, 0x7f, 0x4a, 0x5c, 0xaf, 0x6b, 0x20, 0xd9, 0x8f, 0x55,
	0x85, 0xb6, 0xfd, 0x53, 0xb2, 0xdf, 0x45, 0x1f, 0x02, 0xc2, 0x43, 0xfe, 0x84, 0xc6, 0xfe, 0x29,
	0xe9, 0xbb, 0x21, 0xe1, 0x5f, 0xd3, 0xf8, 0xd8, 0xd8, 0x54, 0x6d, 0x19, 0x47, 0x5a, 0x2a, 0x50,
	0xfa, 0x14, 0xf4, 0x89, 0xfb, 0x8a, 0x8a, 0xb0, 0x78, 0x4c, 0x4e, 0x12, 0x9f, 0x88, 0x21, 0xda,
	0x84, 0xdc, 0x08, 0x07, 0xc3, 0xd4, 0x1f, 0x6a, 0x72, 0x6b, 0xe1, 0xa6, 0x56, 0xba, 0x0b, 0x1b,
	0xcf, 0x9d, 0xf8, 0x55, 0x16, 0x28, 0x33, 0xc8, 0xc9, 0x1e, 0xa1, 0x2d, 0xd8, 0x68, 0x77, 0x6a,
	0x1d, 0xdb, 0x7d, 0xd8, 0x6a, 0x1f, 0xd9, 0xf5, 0xe6, 0xfd, 0xa6, 0xdd, 0x28, 0xfe, 0x0f, 0xad,
	0xc2, 0x4a, 0xdd, 0xb1, 0x6b, 0x9d, 0x66, 0x6b, 0xbf, 0xa8, 0xa1, 0x3c, 0xe4, 0x1c, 0xbb, 0xd6,
	0xf8, 0xa2, 0xb8, 0x20, 0x02, 0x0f, 0x8f, 0x1a, 0x2a, 0xb0, 0x28, 0x66, 0x0d, 0xfb, 0xc0, 0x96,
	0xb3, 0x25, 0xb4, 0x06, 0x79, 0xc7, 0x3e, 0xaa, 0x35, 0x1d, 0x31, 0xcd, 0xa1, 0x75, 0xd0, 0x0f,
	0x6b, 0xcd, 0x56, 0xc7, 0x6e, 0xd5, 0x5a, 0x75, 0xbb, 0xb8, 0x5c, 0xbe, 0x09, 0x4b, 0xa2, 0xa6,
	0x68, 0x13, 0x8a, 0x9d, 0xa6, 0xed, 0x9c, 0xdb, 0x32, 0x0f, 0xb9, 0xbd, 0x5a, 0xbb, 0x59, 0x2f,
	0x6a, 0x22, 0xb3, 0xdd, 0xa9, 0xb5, 0x1a, 0x35, 0xa7, 0xe1, 0x3e, 0xa8, 0x15, 0x17, 0xcb, 0x4f,
	0x61, 0xf3, 0xc0, 0x67, 0x3c, 0x6d, 0x0d, 0x73, 0xc8, 0x57, 0x43, 0xc2, 0x38, 0x7a, 0x0d, 0x96,
	0x23, 0x2c, 0x6e, 0x7b, 0x72, 0xea, 0x64, 0x86, 0xde, 0x80, 0x7c, 0x84, 0x3d, 0x22, 0xbb, 0x25,
	0x0f, 0x9f, 0x73, 0x56, 0x04, 0x20, 0x1a, 0x85, 0x2e, 0x03, 0xc8, 0x20, 0xa7, 0xc7, 0x24, 0x34,
	0x16, 0x65, 0xa2, 0xa4, 0x77, 0x04, 0x50, 0xfe, 0x41, 0x83, 0xad, 0x73, 0x9b, 0xb1, 0x88, 0x86,
	0x8c, 0xa0, 0x3d, 0xc8, 0xfb, 0x29, 0x68, 0x68, 0xf2, 0x76, 0x5e, 0x9b, 0xe7, 0x26, 0x39, 0xe3,
	0x34, 0xf4, 0x2e, 0xac, 0x87, 0xe4, 0x1b, 0xee, 0x4e, 0x28, 0x50, 0xcd, 0x59, 0x13, 0xf0, 0xd1,
	0x99, 0x8a, 0x0a, 0xa0, 0x7d, 0x72, 0xa6, 0x21, 0x3d, 0x6f, 0xc6, 0x63, 0x5a, 0xfe, 0x51, 0x83,
	0xad, 0xba, 0xf4, 0xeb, 0x79, 0xf6, 0x8b, 0xaa, 0x73, 0x05, 0xf4, 0x54, 0x90, 0x78, 0x37, 0xd4,
	0xfe, 0x90, 0x42, 0xcd, 0x3e, 0xba, 0x07, 0x2b, 0xe9, 0x4c, 0xd6, 0x67, 0xde, 0x73, 0x9e, 0x65,
	0x95, 0x7f, 0xd6, 0x60, 0xeb, 0x61, 0xd4, 0xcf, 0x10, 0xb5, 0x0b, 0xfa, 0x50, 0x06, 0xe4, 0x27,
	0x45, 0x2a, 0xcb, 0x7a, 0x8c, 0xee, 0x8b, 0xaf, 0xce, 0x21, 0x66, 0xc7, 0x0e, 0x28, 0xba, 0x18,
	0x4f, 0x09, 0x5b, 0xb8, 0x90, 0xb0, 0xf7, 0x61, 0xab, 0x41, 0x02, 0xf2, 0xbc, 0xae, 0xac, 0xd2,
	0xfe, 0xab, 0x41, 0x31, 0x7d, 0x47, 0x0f, 0x09, 0xc7, 0x7d, 0xcc, 0x31, 0xf2, 0x61, 0x1d, 0x8f,
	0xb0, 0x1f, 0xe0, 0x6e, 0x40, 0xdc, 0x53, 0x1a, 0x9e, 0xdd, 0x85, 0x7b, 0xb3, 0xa4, 0x9c, 0x5f,
	0xc6, 0xac, 0xa5, 0x6b, 0x3c, 0x12, 0x4b, 0xa8, 0x37, 0xab, 0x80, 0xa7, 0xc0, 0xd2, 0x31, 0x5c,
	0xca, 0xa0, 0x65, 0x18, 0xfd, 0xce, 0xa4, 0xd1, 0xf5, 0x6a, 0x65, 0x96, 0x12, 0xb1, 0x50, 0xaa,
	0x62, 0xf2, 0x49, 0x28, 0xc0, 0xea, 0x64, 0xa8, 0xfa, 0xf7, 0x32, 0x40, 0x5d, 0xe4, 0xcb, 0x97,
	0x06, 0xfd, 0xae, 0xc1, 0xda, 0x94, 0x2d, 0xd0, 0xcc, 0x4f, 0x72, 0x96, 0x5d, 0x4b, 0xd7, 0x5f,
	0x21, 0x43, 0x79, 0xae, 0x7c, 0xeb, 0xfb, 0xbf, 0xfe, 0xf9, 0x69, 0xe1, 0x13, 0x54, 0x3d, 0xfb,
	0x45, 0xf4, 0xad, 0xba, 0xc5, 0xb7, 0xa3, 0x98, 0x3e, 0x25, 0x3d, 0xce, 0xac, 0x1d, 0x2b, 0xfd,
	0x0a, 0x32, 0x6b, 0xe7, 0x99, 0x35, 0xf6, 0xda, 0xaf, 0x1a, 0xe8, 0x13, 0x26, 0x42, 0xe6, 0xac,
	0xed, 0x9f, 0x77, 0x5b, 0x69, 0xae, 0xbb, 0x95, 0xa5, 0x50, 0x5c, 0x9e, 0x17, 0xe8, 0x1b, 0xcb,
	0xb3, 0x76, 0x9e, 0xa1, 0xdf, 0x34, 0x28, 0x4c, 0x7b, 0x17, 0xcd, 0xac, 0x51, 0xa6, 0xcf, 0x4b,
	0x97, 0xd3, 0x94, 0x89, 0x1f, 0x76, 0xe6, 0x67, 0xe9, 0x0f, 0xbb, 0x72, 0x43, 0x0a, 0xbc, 0x53,
	0xbe, 0x40, 0x09, 0x6f, 0x9d, 0x19, 0x07, 0xfd, 0xa1, 0x41, 0x61, 0xda, 0xd1, 0xb3, 0xa5, 0x66,
	0xba, 0xff, 0x65, 0x52, 0x0f, 0xa5, 0xd4, 0xfd, 0xea, 0xee, 0x58, 0x6a, 0x2a, 0xc0, 0x9c, 0xb7,
	0xa8, 0x13, 0x9a, 0x7f, 0xd1, 0xa0, 0x30, 0xed, 0xf6, 0xd9, 0x9a, 0x33, 0x5f, 0x86, 0x97, 0x69,
	0x4e, 0xfa, 0xbf, 0x73, 0x81, 0xfe, 0xef, 0x7d, 0x07, 0x6f, 0xf5, 0xe8, 0x60, 0x86, 0xa4, 0xbd,
	0xd2, 0xd8, 0x82, 0x6d, 0x12, 0x8f, 0xfc, 0x1e, 0xd9, 0x23, 0x1c, 0x1f, 0x89, 0x67, 0xf2, 0x48,
	0x7b, 0x74, 0x37, 0xc9, 0xf4, 0x68, 0x80, 0x43, 0xcf, 0xa4, 0xb1, 0x67, 0x79, 0x24, 0x94, 0x8f,
	0xa8, 0xa5, 0x42, 0x38, 0xf2, 0x59, 0xd6, 0x1f, 0x8b, 0x5d, 0x39, 0xeb, 0x2e, 0x4b, 0xee, 0xc7,
	0xff, 0x05, 0x00, 0x00, 0xff, 0xff, 0xab, 0xc9, 0x66, 0xe4, 0x83, 0x0c, 0x00, 0x00,
}
