/**
 * (C) Copyright IBM Corp. 2021.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * IBM OpenAPI SDK Code Generator Version: 3.27.0-c07e12f4-20210209-225127
 */

// Package pushservicev1 : Operations and models for the PushServiceV1 service
package pushservicev1

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"math/rand"
	"net/http"
	"reflect"
	"time"

	"github.com/IBM/go-sdk-core/v5/core"
	common "github.com/IBM/push-notifications-go-sdk/common"
)

// PushServiceV1 : No description provided (generated by Openapi Generator
// https://github.com/openapitools/openapi-generator)
//
// Version: 1.0
type PushServiceV1 struct {
	Service *core.BaseService
}

// DefaultServiceURL is the default URL to make service requests to.
const DefaultServiceURL = "https://push-service.cloud.ibm.com/imfpush/v1"

// DefaultServiceName is the default key used to find external configuration information.
const DefaultServiceName = "push_service"

// PushServiceV1Options : Service options
type PushServiceV1Options struct {
	ServiceName   string
	URL           string
	Authenticator core.Authenticator
}

const charset = "abcdefghijklmnopqrstuvwxyz_-" +
	"ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"

var seededRand *rand.Rand = rand.New(
	rand.NewSource(time.Now().UnixNano()))

func stringWithCharset(length int) string {
	b := make([]byte, length)
	for i := range b {
		b[i] = charset[seededRand.Intn(len(charset))]
	}
	return string(b)
}

// NewPushServiceV1UsingExternalConfig : constructs an instance of PushServiceV1 with passed in options and external configuration.
func NewPushServiceV1UsingExternalConfig(options *PushServiceV1Options) (pushService *PushServiceV1, err error) {
	if options.ServiceName == "" {
		options.ServiceName = DefaultServiceName
	}

	if options.Authenticator == nil {
		options.Authenticator, err = core.GetAuthenticatorFromEnvironment(options.ServiceName)
		if err != nil {
			return
		}
	}

	pushService, err = NewPushServiceV1(options)
	if err != nil {
		return
	}

	err = pushService.Service.ConfigureService(options.ServiceName)
	if err != nil {
		return
	}

	if options.URL != "" {
		err = pushService.Service.SetServiceURL(options.URL)
	}
	return
}

// NewPushServiceV1 : constructs an instance of PushServiceV1 with passed in options.
func NewPushServiceV1(options *PushServiceV1Options) (service *PushServiceV1, err error) {
	serviceOptions := &core.ServiceOptions{
		URL:           DefaultServiceURL,
		Authenticator: options.Authenticator,
	}

	baseService, err := core.NewBaseService(serviceOptions)
	if err != nil {
		return
	}

	if options.URL != "" {
		err = baseService.SetServiceURL(options.URL)
		if err != nil {
			return
		}
	}

	service = &PushServiceV1{
		Service: baseService,
	}

	return
}

// GetServiceURLForRegion returns the service URL to be used for the specified region
func GetServiceURLForRegion(region string) (string, error) {
	return "", fmt.Errorf("service does not support regional URLs")
}

// Clone makes a copy of "pushService" suitable for processing requests.
func (pushService *PushServiceV1) Clone() *PushServiceV1 {
	if core.IsNil(pushService) {
		return nil
	}
	clone := *pushService
	clone.Service = pushService.Service.Clone()
	return &clone
}

// SetServiceURL sets the service URL
func (pushService *PushServiceV1) SetServiceURL(url string) error {
	return pushService.Service.SetServiceURL(url)
}

// GetServiceURL returns the service URL
func (pushService *PushServiceV1) GetServiceURL() string {
	return pushService.Service.GetServiceURL()
}

// SetDefaultHeaders sets HTTP headers to be sent in every request
func (pushService *PushServiceV1) SetDefaultHeaders(headers http.Header) {
	pushService.Service.SetDefaultHeaders(headers)
}

// SetEnableGzipCompression sets the service's EnableGzipCompression field
func (pushService *PushServiceV1) SetEnableGzipCompression(enableGzip bool) {
	pushService.Service.SetEnableGzipCompression(enableGzip)
}

// GetEnableGzipCompression returns the service's EnableGzipCompression field
func (pushService *PushServiceV1) GetEnableGzipCompression() bool {
	return pushService.Service.GetEnableGzipCompression()
}

// EnableRetries enables automatic retries for requests invoked for this service instance.
// If either parameter is specified as 0, then a default value is used instead.
func (pushService *PushServiceV1) EnableRetries(maxRetries int, maxRetryInterval time.Duration) {
	pushService.Service.EnableRetries(maxRetries, maxRetryInterval)
}

// DisableRetries disables automatic retries for requests invoked for this service instance.
func (pushService *PushServiceV1) DisableRetries() {
	pushService.Service.DisableRetries()
}

// GetSettings : Retrieve application settings
// Retrieves the application settings, which is referenced by the applicationId parameter.
func (pushService *PushServiceV1) GetSettings(getSettingsOptions *GetSettingsOptions) (result *AppSettingsObjResponse, response *core.DetailedResponse, err error) {
	return pushService.GetSettingsWithContext(context.Background(), getSettingsOptions)
}

// GetSettingsWithContext is an alternate form of the GetSettings method which supports a Context parameter
func (pushService *PushServiceV1) GetSettingsWithContext(ctx context.Context, getSettingsOptions *GetSettingsOptions) (result *AppSettingsObjResponse, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(getSettingsOptions, "getSettingsOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(getSettingsOptions, "getSettingsOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *getSettingsOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.GET)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range getSettingsOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "GetSettings")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	if getSettingsOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*getSettingsOptions.AppSecret))
	}
	if getSettingsOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*getSettingsOptions.AcceptLanguage))
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalAppSettingsObjResponse)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// GetApnsConf : Get the APNS settings
// Retrieves APNS credentials for the application.
func (pushService *PushServiceV1) GetApnsConf(getApnsConfOptions *GetApnsConfOptions) (result *ApnsCertUploadResponse, response *core.DetailedResponse, err error) {
	return pushService.GetApnsConfWithContext(context.Background(), getApnsConfOptions)
}

// GetApnsConfWithContext is an alternate form of the GetApnsConf method which supports a Context parameter
func (pushService *PushServiceV1) GetApnsConfWithContext(ctx context.Context, getApnsConfOptions *GetApnsConfOptions) (result *ApnsCertUploadResponse, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(getApnsConfOptions, "getApnsConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(getApnsConfOptions, "getApnsConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *getApnsConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.GET)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/apnsConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range getApnsConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "GetApnsConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	if getApnsConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*getApnsConfOptions.AcceptLanguage))
	}
	if getApnsConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*getApnsConfOptions.AppSecret))
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalApnsCertUploadResponse)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// SaveApnsConf : Updates APNS settings
// Uploads an APNS certificate to the application referenced by the applicationId.
func (pushService *PushServiceV1) SaveApnsConf(saveApnsConfOptions *SaveApnsConfOptions) (result *ApnsCertUploadResponse, response *core.DetailedResponse, err error) {
	return pushService.SaveApnsConfWithContext(context.Background(), saveApnsConfOptions)
}

// SaveApnsConfWithContext is an alternate form of the SaveApnsConf method which supports a Context parameter
func (pushService *PushServiceV1) SaveApnsConfWithContext(ctx context.Context, saveApnsConfOptions *SaveApnsConfOptions) (result *ApnsCertUploadResponse, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(saveApnsConfOptions, "saveApnsConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(saveApnsConfOptions, "saveApnsConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *saveApnsConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.PUT)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/apnsConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range saveApnsConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "SaveApnsConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	if saveApnsConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*saveApnsConfOptions.AcceptLanguage))
	}
	if saveApnsConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*saveApnsConfOptions.AppSecret))
	}

	builder.AddFormData("password", "", "", fmt.Sprint(*saveApnsConfOptions.Password))
	builder.AddFormData("isSandBox", "", "", fmt.Sprint(*saveApnsConfOptions.IsSandBox))
	builder.AddFormData("certificate", fmt.Sprintf("%s.p12", stringWithCharset(24)),
		core.StringNilMapper(saveApnsConfOptions.CertificateContentType), saveApnsConfOptions.Certificate)

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalApnsCertUploadResponse)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// DeleteApnsConf : Delete APNS settings
// Deletes the APNS settings to the application referenced by the applicationId.
func (pushService *PushServiceV1) DeleteApnsConf(deleteApnsConfOptions *DeleteApnsConfOptions) (response *core.DetailedResponse, err error) {
	return pushService.DeleteApnsConfWithContext(context.Background(), deleteApnsConfOptions)
}

// DeleteApnsConfWithContext is an alternate form of the DeleteApnsConf method which supports a Context parameter
func (pushService *PushServiceV1) DeleteApnsConfWithContext(ctx context.Context, deleteApnsConfOptions *DeleteApnsConfOptions) (response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(deleteApnsConfOptions, "deleteApnsConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(deleteApnsConfOptions, "deleteApnsConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *deleteApnsConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.DELETE)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/apnsConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range deleteApnsConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "DeleteApnsConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	if deleteApnsConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*deleteApnsConfOptions.AcceptLanguage))
	}
	if deleteApnsConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*deleteApnsConfOptions.AppSecret))
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	response, err = pushService.Service.Request(request, nil)

	return
}

// GetGCMConf : Get the GCM settings
// Retrieves GCM credentials for the application.
func (pushService *PushServiceV1) GetGCMConf(getGCMConfOptions *GetGCMConfOptions) (result *GCMCredendialsModel, response *core.DetailedResponse, err error) {
	return pushService.GetGCMConfWithContext(context.Background(), getGCMConfOptions)
}

// GetGCMConfWithContext is an alternate form of the GetGCMConf method which supports a Context parameter
func (pushService *PushServiceV1) GetGCMConfWithContext(ctx context.Context, getGCMConfOptions *GetGCMConfOptions) (result *GCMCredendialsModel, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(getGCMConfOptions, "getGCMConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(getGCMConfOptions, "getGCMConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *getGCMConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.GET)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/gcmConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range getGCMConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "GetGCMConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	if getGCMConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*getGCMConfOptions.AcceptLanguage))
	}
	if getGCMConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*getGCMConfOptions.AppSecret))
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalGCMCredendialsModel)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// SaveGCMConf : Updates GCM settings
// Updates the GCM credentials of the application referenced by the applicationId.
func (pushService *PushServiceV1) SaveGCMConf(saveGCMConfOptions *SaveGCMConfOptions) (result *GCMCredendialsModel, response *core.DetailedResponse, err error) {
	return pushService.SaveGCMConfWithContext(context.Background(), saveGCMConfOptions)
}

// SaveGCMConfWithContext is an alternate form of the SaveGCMConf method which supports a Context parameter
func (pushService *PushServiceV1) SaveGCMConfWithContext(ctx context.Context, saveGCMConfOptions *SaveGCMConfOptions) (result *GCMCredendialsModel, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(saveGCMConfOptions, "saveGCMConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(saveGCMConfOptions, "saveGCMConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *saveGCMConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.PUT)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/gcmConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range saveGCMConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "SaveGCMConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	builder.AddHeader("Content-Type", "application/json")
	if saveGCMConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*saveGCMConfOptions.AcceptLanguage))
	}
	if saveGCMConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*saveGCMConfOptions.AppSecret))
	}

	body := make(map[string]interface{})
	if saveGCMConfOptions.ApiKey != nil {
		body["apiKey"] = saveGCMConfOptions.ApiKey
	}
	if saveGCMConfOptions.SenderID != nil {
		body["senderId"] = saveGCMConfOptions.SenderID
	}
	_, err = builder.SetBodyContentJSON(body)
	if err != nil {
		return
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalGCMCredendialsModel)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// DeleteGCMConf : Delete GCM settings
// Deletes the GCM credentials of the application, which is referenced by the applicationId parameter.
func (pushService *PushServiceV1) DeleteGCMConf(deleteGCMConfOptions *DeleteGCMConfOptions) (response *core.DetailedResponse, err error) {
	return pushService.DeleteGCMConfWithContext(context.Background(), deleteGCMConfOptions)
}

// DeleteGCMConfWithContext is an alternate form of the DeleteGCMConf method which supports a Context parameter
func (pushService *PushServiceV1) DeleteGCMConfWithContext(ctx context.Context, deleteGCMConfOptions *DeleteGCMConfOptions) (response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(deleteGCMConfOptions, "deleteGCMConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(deleteGCMConfOptions, "deleteGCMConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *deleteGCMConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.DELETE)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/gcmConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range deleteGCMConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "DeleteGCMConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	if deleteGCMConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*deleteGCMConfOptions.AcceptLanguage))
	}
	if deleteGCMConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*deleteGCMConfOptions.AppSecret))
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	response, err = pushService.Service.Request(request, nil)

	return
}

// GetWebpushServerKey : Get the Web Push Server Key
// Retrieves Web Push Server Key (VAPID).
func (pushService *PushServiceV1) GetWebpushServerKey(getWebpushServerKeyOptions *GetWebpushServerKeyOptions) (result *ApplicationServerKeyModel, response *core.DetailedResponse, err error) {
	return pushService.GetWebpushServerKeyWithContext(context.Background(), getWebpushServerKeyOptions)
}

// GetWebpushServerKeyWithContext is an alternate form of the GetWebpushServerKey method which supports a Context parameter
func (pushService *PushServiceV1) GetWebpushServerKeyWithContext(ctx context.Context, getWebpushServerKeyOptions *GetWebpushServerKeyOptions) (result *ApplicationServerKeyModel, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(getWebpushServerKeyOptions, "getWebpushServerKeyOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(getWebpushServerKeyOptions, "getWebpushServerKeyOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *getWebpushServerKeyOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.GET)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/webpushServerKey`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range getWebpushServerKeyOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "GetWebpushServerKey")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	if getWebpushServerKeyOptions.ClientSecret != nil {
		builder.AddHeader("clientSecret", fmt.Sprint(*getWebpushServerKeyOptions.ClientSecret))
	}
	if getWebpushServerKeyOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*getWebpushServerKeyOptions.AcceptLanguage))
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalApplicationServerKeyModel)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// GetSafariWebConf : Get the Safari Push Notifications settings
// Retrieves Safari Push Notifications settings for the application.
func (pushService *PushServiceV1) GetSafariWebConf(getSafariWebConfOptions *GetSafariWebConfOptions) (result *SafariCertUploadResponse, response *core.DetailedResponse, err error) {
	return pushService.GetSafariWebConfWithContext(context.Background(), getSafariWebConfOptions)
}

// GetSafariWebConfWithContext is an alternate form of the GetSafariWebConf method which supports a Context parameter
func (pushService *PushServiceV1) GetSafariWebConfWithContext(ctx context.Context, getSafariWebConfOptions *GetSafariWebConfOptions) (result *SafariCertUploadResponse, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(getSafariWebConfOptions, "getSafariWebConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(getSafariWebConfOptions, "getSafariWebConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *getSafariWebConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.GET)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/safariWebConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range getSafariWebConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "GetSafariWebConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	if getSafariWebConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*getSafariWebConfOptions.AcceptLanguage))
	}
	if getSafariWebConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*getSafariWebConfOptions.AppSecret))
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalSafariCertUploadResponse)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// SaveSafariWebConf : Updates Safari Push Notifications settings
// Uploads Safari Push Notifications settings to the application referenced by the applicationId. The settings include
// providing a web push certificate and other credentials. If none of the icons are provided then default icons will be
// used. These images populate the icons displayed to the user in the permission prompt, Notification Center and the
// notification itself.
func (pushService *PushServiceV1) SaveSafariWebConf(saveSafariWebConfOptions *SaveSafariWebConfOptions) (result *SafariCertUploadResponse, response *core.DetailedResponse, err error) {
	return pushService.SaveSafariWebConfWithContext(context.Background(), saveSafariWebConfOptions)
}

// SaveSafariWebConfWithContext is an alternate form of the SaveSafariWebConf method which supports a Context parameter
func (pushService *PushServiceV1) SaveSafariWebConfWithContext(ctx context.Context, saveSafariWebConfOptions *SaveSafariWebConfOptions) (result *SafariCertUploadResponse, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(saveSafariWebConfOptions, "saveSafariWebConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(saveSafariWebConfOptions, "saveSafariWebConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *saveSafariWebConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.PUT)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/safariWebConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range saveSafariWebConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "SaveSafariWebConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	if saveSafariWebConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*saveSafariWebConfOptions.AcceptLanguage))
	}
	if saveSafariWebConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*saveSafariWebConfOptions.AppSecret))
	}

	builder.AddFormData("password", "", "", fmt.Sprint(*saveSafariWebConfOptions.Password))
	builder.AddFormData("certificate", fmt.Sprintf("%s.p12", stringWithCharset(24)),
		core.StringNilMapper(saveSafariWebConfOptions.CertificateContentType), saveSafariWebConfOptions.Certificate)
	builder.AddFormData("websiteName", "", "", fmt.Sprint(*saveSafariWebConfOptions.WebsiteName))
	builder.AddFormData("urlFormatString", "", "", fmt.Sprint(*saveSafariWebConfOptions.UrlFormatString))
	builder.AddFormData("websitePushID", "", "", fmt.Sprint(*saveSafariWebConfOptions.WebsitePushID))
	builder.AddFormData("webSiteUrl", "", "", fmt.Sprint(*saveSafariWebConfOptions.WebSiteURL))
	if saveSafariWebConfOptions.Icon16x16 != nil {
		builder.AddFormData("icon_16x16", fmt.Sprintf("%s.p12", stringWithCharset(12)),
			core.StringNilMapper(saveSafariWebConfOptions.Icon16x16ContentType), saveSafariWebConfOptions.Icon16x16)
	}
	if saveSafariWebConfOptions.Icon16x162x != nil {
		builder.AddFormData("icon_16x16@2x", fmt.Sprintf("%s.p12", stringWithCharset(12)),
			core.StringNilMapper(saveSafariWebConfOptions.Icon16x162xContentType), saveSafariWebConfOptions.Icon16x162x)
	}
	if saveSafariWebConfOptions.Icon32x32 != nil {
		builder.AddFormData("icon_32x32", fmt.Sprintf("%s.p12", stringWithCharset(12)),
			core.StringNilMapper(saveSafariWebConfOptions.Icon32x32ContentType), saveSafariWebConfOptions.Icon32x32)
	}
	if saveSafariWebConfOptions.Icon32x322x != nil {
		builder.AddFormData("icon_32x32@2x", fmt.Sprintf("%s.p12", stringWithCharset(12)),
			core.StringNilMapper(saveSafariWebConfOptions.Icon32x322xContentType), saveSafariWebConfOptions.Icon32x322x)
	}
	if saveSafariWebConfOptions.Icon128x128 != nil {
		builder.AddFormData("icon_128x128", fmt.Sprintf("%s.p12", stringWithCharset(12)),
			core.StringNilMapper(saveSafariWebConfOptions.Icon128x128ContentType), saveSafariWebConfOptions.Icon128x128)
	}
	if saveSafariWebConfOptions.Icon128x1282x != nil {
		builder.AddFormData("icon_128x128@2x", fmt.Sprintf("%s.p12", stringWithCharset(12)),
			core.StringNilMapper(saveSafariWebConfOptions.Icon128x1282xContentType), saveSafariWebConfOptions.Icon128x1282x)
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalSafariCertUploadResponse)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// DeleteSafariWebConf : Delete Safari Push Notifications settings
// Deletes the Safari Push Notifications settings of the application, which is referenced by the applicationId
// parameter.
func (pushService *PushServiceV1) DeleteSafariWebConf(deleteSafariWebConfOptions *DeleteSafariWebConfOptions) (response *core.DetailedResponse, err error) {
	return pushService.DeleteSafariWebConfWithContext(context.Background(), deleteSafariWebConfOptions)
}

// DeleteSafariWebConfWithContext is an alternate form of the DeleteSafariWebConf method which supports a Context parameter
func (pushService *PushServiceV1) DeleteSafariWebConfWithContext(ctx context.Context, deleteSafariWebConfOptions *DeleteSafariWebConfOptions) (response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(deleteSafariWebConfOptions, "deleteSafariWebConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(deleteSafariWebConfOptions, "deleteSafariWebConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *deleteSafariWebConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.DELETE)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/safariWebConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range deleteSafariWebConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "DeleteSafariWebConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	if deleteSafariWebConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*deleteSafariWebConfOptions.AcceptLanguage))
	}
	if deleteSafariWebConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*deleteSafariWebConfOptions.AppSecret))
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	response, err = pushService.Service.Request(request, nil)

	return
}

// GetGcmConfPublic : Get the GCM senderId
// Retrieves GCM senderId only for the application.
func (pushService *PushServiceV1) GetGcmConfPublic(getGcmConfPublicOptions *GetGcmConfPublicOptions) (result *GCMCredendialsPublicModel, response *core.DetailedResponse, err error) {
	return pushService.GetGcmConfPublicWithContext(context.Background(), getGcmConfPublicOptions)
}

// GetGcmConfPublicWithContext is an alternate form of the GetGcmConfPublic method which supports a Context parameter
func (pushService *PushServiceV1) GetGcmConfPublicWithContext(ctx context.Context, getGcmConfPublicOptions *GetGcmConfPublicOptions) (result *GCMCredendialsPublicModel, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(getGcmConfPublicOptions, "getGcmConfPublicOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(getGcmConfPublicOptions, "getGcmConfPublicOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *getGcmConfPublicOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.GET)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/gcmConfPublic`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range getGcmConfPublicOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "GetGcmConfPublic")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	if getGcmConfPublicOptions.ClientSecret != nil {
		builder.AddHeader("clientSecret", fmt.Sprint(*getGcmConfPublicOptions.ClientSecret))
	}
	if getGcmConfPublicOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*getGcmConfPublicOptions.AcceptLanguage))
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalGCMCredendialsPublicModel)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// GetChromeWebConf : Get the Chrome WebPush settings
// Retrieves Chrome WebPush credentials for the application.
func (pushService *PushServiceV1) GetChromeWebConf(getChromeWebConfOptions *GetChromeWebConfOptions) (result *ChromeWebPushCredendialsModel, response *core.DetailedResponse, err error) {
	return pushService.GetChromeWebConfWithContext(context.Background(), getChromeWebConfOptions)
}

// GetChromeWebConfWithContext is an alternate form of the GetChromeWebConf method which supports a Context parameter
func (pushService *PushServiceV1) GetChromeWebConfWithContext(ctx context.Context, getChromeWebConfOptions *GetChromeWebConfOptions) (result *ChromeWebPushCredendialsModel, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(getChromeWebConfOptions, "getChromeWebConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(getChromeWebConfOptions, "getChromeWebConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *getChromeWebConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.GET)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/chromeWebConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range getChromeWebConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "GetChromeWebConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	if getChromeWebConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*getChromeWebConfOptions.AcceptLanguage))
	}
	if getChromeWebConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*getChromeWebConfOptions.AppSecret))
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalChromeWebPushCredendialsModel)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// SaveChromeWebConf : Updates Chrome WebPush settings
// Updates the Chrome WebPush credentials of the application referenced by the applicationId.
func (pushService *PushServiceV1) SaveChromeWebConf(saveChromeWebConfOptions *SaveChromeWebConfOptions) (result *ChromeWebPushCredendialsModel, response *core.DetailedResponse, err error) {
	return pushService.SaveChromeWebConfWithContext(context.Background(), saveChromeWebConfOptions)
}

// SaveChromeWebConfWithContext is an alternate form of the SaveChromeWebConf method which supports a Context parameter
func (pushService *PushServiceV1) SaveChromeWebConfWithContext(ctx context.Context, saveChromeWebConfOptions *SaveChromeWebConfOptions) (result *ChromeWebPushCredendialsModel, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(saveChromeWebConfOptions, "saveChromeWebConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(saveChromeWebConfOptions, "saveChromeWebConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *saveChromeWebConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.PUT)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/chromeWebConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range saveChromeWebConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "SaveChromeWebConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	builder.AddHeader("Content-Type", "application/json")
	if saveChromeWebConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*saveChromeWebConfOptions.AcceptLanguage))
	}
	if saveChromeWebConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*saveChromeWebConfOptions.AppSecret))
	}

	body := make(map[string]interface{})
	if saveChromeWebConfOptions.ApiKey != nil {
		body["apiKey"] = saveChromeWebConfOptions.ApiKey
	}
	if saveChromeWebConfOptions.WebSiteURL != nil {
		body["webSiteUrl"] = saveChromeWebConfOptions.WebSiteURL
	}
	_, err = builder.SetBodyContentJSON(body)
	if err != nil {
		return
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalChromeWebPushCredendialsModel)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// DeleteChromeWebConf : Delete Chrome WebPush Settings
// Deletes the Chrome WebPush credentials of the application, which is referenced by the applicationId parameter.
func (pushService *PushServiceV1) DeleteChromeWebConf(deleteChromeWebConfOptions *DeleteChromeWebConfOptions) (response *core.DetailedResponse, err error) {
	return pushService.DeleteChromeWebConfWithContext(context.Background(), deleteChromeWebConfOptions)
}

// DeleteChromeWebConfWithContext is an alternate form of the DeleteChromeWebConf method which supports a Context parameter
func (pushService *PushServiceV1) DeleteChromeWebConfWithContext(ctx context.Context, deleteChromeWebConfOptions *DeleteChromeWebConfOptions) (response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(deleteChromeWebConfOptions, "deleteChromeWebConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(deleteChromeWebConfOptions, "deleteChromeWebConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *deleteChromeWebConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.DELETE)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/chromeWebConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range deleteChromeWebConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "DeleteChromeWebConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	if deleteChromeWebConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*deleteChromeWebConfOptions.AcceptLanguage))
	}
	if deleteChromeWebConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*deleteChromeWebConfOptions.AppSecret))
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	response, err = pushService.Service.Request(request, nil)

	return
}

// GetFirefoxWebConf : Get the Firefox WebPush settings
// Retrieves Firefox WebPush credentials for the application.
func (pushService *PushServiceV1) GetFirefoxWebConf(getFirefoxWebConfOptions *GetFirefoxWebConfOptions) (result *FirefoxWebPushCredendialsModel, response *core.DetailedResponse, err error) {
	return pushService.GetFirefoxWebConfWithContext(context.Background(), getFirefoxWebConfOptions)
}

// GetFirefoxWebConfWithContext is an alternate form of the GetFirefoxWebConf method which supports a Context parameter
func (pushService *PushServiceV1) GetFirefoxWebConfWithContext(ctx context.Context, getFirefoxWebConfOptions *GetFirefoxWebConfOptions) (result *FirefoxWebPushCredendialsModel, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(getFirefoxWebConfOptions, "getFirefoxWebConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(getFirefoxWebConfOptions, "getFirefoxWebConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *getFirefoxWebConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.GET)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/firefoxWebConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range getFirefoxWebConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "GetFirefoxWebConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	if getFirefoxWebConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*getFirefoxWebConfOptions.AcceptLanguage))
	}
	if getFirefoxWebConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*getFirefoxWebConfOptions.AppSecret))
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalFirefoxWebPushCredendialsModel)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// SaveFirefoxWebConf : Updates Firefox WebPush settings
// Updates the Firefox WebPush credentials of the application referenced by the applicationId.
func (pushService *PushServiceV1) SaveFirefoxWebConf(saveFirefoxWebConfOptions *SaveFirefoxWebConfOptions) (result *FirefoxWebPushCredendialsModel, response *core.DetailedResponse, err error) {
	return pushService.SaveFirefoxWebConfWithContext(context.Background(), saveFirefoxWebConfOptions)
}

// SaveFirefoxWebConfWithContext is an alternate form of the SaveFirefoxWebConf method which supports a Context parameter
func (pushService *PushServiceV1) SaveFirefoxWebConfWithContext(ctx context.Context, saveFirefoxWebConfOptions *SaveFirefoxWebConfOptions) (result *FirefoxWebPushCredendialsModel, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(saveFirefoxWebConfOptions, "saveFirefoxWebConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(saveFirefoxWebConfOptions, "saveFirefoxWebConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *saveFirefoxWebConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.PUT)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/firefoxWebConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range saveFirefoxWebConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "SaveFirefoxWebConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	builder.AddHeader("Content-Type", "application/json")
	if saveFirefoxWebConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*saveFirefoxWebConfOptions.AcceptLanguage))
	}
	if saveFirefoxWebConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*saveFirefoxWebConfOptions.AppSecret))
	}

	body := make(map[string]interface{})
	if saveFirefoxWebConfOptions.WebSiteURL != nil {
		body["webSiteUrl"] = saveFirefoxWebConfOptions.WebSiteURL
	}
	_, err = builder.SetBodyContentJSON(body)
	if err != nil {
		return
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalFirefoxWebPushCredendialsModel)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// DeleteFirefoxWebConf : Delete Firefox WebPush Settings
// Deletes the Firefox WebPush credentials of the application, which is referenced by the applicationId parameter.
func (pushService *PushServiceV1) DeleteFirefoxWebConf(deleteFirefoxWebConfOptions *DeleteFirefoxWebConfOptions) (response *core.DetailedResponse, err error) {
	return pushService.DeleteFirefoxWebConfWithContext(context.Background(), deleteFirefoxWebConfOptions)
}

// DeleteFirefoxWebConfWithContext is an alternate form of the DeleteFirefoxWebConf method which supports a Context parameter
func (pushService *PushServiceV1) DeleteFirefoxWebConfWithContext(ctx context.Context, deleteFirefoxWebConfOptions *DeleteFirefoxWebConfOptions) (response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(deleteFirefoxWebConfOptions, "deleteFirefoxWebConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(deleteFirefoxWebConfOptions, "deleteFirefoxWebConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *deleteFirefoxWebConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.DELETE)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/firefoxWebConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range deleteFirefoxWebConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "DeleteFirefoxWebConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	if deleteFirefoxWebConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*deleteFirefoxWebConfOptions.AcceptLanguage))
	}
	if deleteFirefoxWebConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*deleteFirefoxWebConfOptions.AppSecret))
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	response, err = pushService.Service.Request(request, nil)

	return
}

// GetChromeAppExtConf : Get the Chorme Apps-Extentions Push credentials settings
// Retrieves Chorme Apps-Extentions Push credentials settings for the application.
func (pushService *PushServiceV1) GetChromeAppExtConf(getChromeAppExtConfOptions *GetChromeAppExtConfOptions) (result *GCMCredendialsModel, response *core.DetailedResponse, err error) {
	return pushService.GetChromeAppExtConfWithContext(context.Background(), getChromeAppExtConfOptions)
}

// GetChromeAppExtConfWithContext is an alternate form of the GetChromeAppExtConf method which supports a Context parameter
func (pushService *PushServiceV1) GetChromeAppExtConfWithContext(ctx context.Context, getChromeAppExtConfOptions *GetChromeAppExtConfOptions) (result *GCMCredendialsModel, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(getChromeAppExtConfOptions, "getChromeAppExtConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(getChromeAppExtConfOptions, "getChromeAppExtConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *getChromeAppExtConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.GET)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/chromeAppExtConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range getChromeAppExtConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "GetChromeAppExtConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	if getChromeAppExtConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*getChromeAppExtConfOptions.AcceptLanguage))
	}
	if getChromeAppExtConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*getChromeAppExtConfOptions.AppSecret))
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalGCMCredendialsModel)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// SaveChromeAppExtConf : Updates Chorme Apps-Extentions Push credentials settings
// Updates the Chorme Apps-Extentions Push credentials settings of the application referenced by the applicationId.
func (pushService *PushServiceV1) SaveChromeAppExtConf(saveChromeAppExtConfOptions *SaveChromeAppExtConfOptions) (result *GCMCredendialsModel, response *core.DetailedResponse, err error) {
	return pushService.SaveChromeAppExtConfWithContext(context.Background(), saveChromeAppExtConfOptions)
}

// SaveChromeAppExtConfWithContext is an alternate form of the SaveChromeAppExtConf method which supports a Context parameter
func (pushService *PushServiceV1) SaveChromeAppExtConfWithContext(ctx context.Context, saveChromeAppExtConfOptions *SaveChromeAppExtConfOptions) (result *GCMCredendialsModel, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(saveChromeAppExtConfOptions, "saveChromeAppExtConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(saveChromeAppExtConfOptions, "saveChromeAppExtConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *saveChromeAppExtConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.PUT)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/chromeAppExtConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range saveChromeAppExtConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "SaveChromeAppExtConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	builder.AddHeader("Content-Type", "application/json")
	if saveChromeAppExtConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*saveChromeAppExtConfOptions.AcceptLanguage))
	}
	if saveChromeAppExtConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*saveChromeAppExtConfOptions.AppSecret))
	}

	body := make(map[string]interface{})
	if saveChromeAppExtConfOptions.ApiKey != nil {
		body["apiKey"] = saveChromeAppExtConfOptions.ApiKey
	}
	if saveChromeAppExtConfOptions.SenderID != nil {
		body["senderId"] = saveChromeAppExtConfOptions.SenderID
	}
	_, err = builder.SetBodyContentJSON(body)
	if err != nil {
		return
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalGCMCredendialsModel)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// DeleteChromeAppExtConf : Delete Chorme Apps-Extentions Push credentials settings
// Deletes the push credentials settings for Chrome Apps-Extensions of the application, which is referenced by the
// applicationId parameter.
func (pushService *PushServiceV1) DeleteChromeAppExtConf(deleteChromeAppExtConfOptions *DeleteChromeAppExtConfOptions) (response *core.DetailedResponse, err error) {
	return pushService.DeleteChromeAppExtConfWithContext(context.Background(), deleteChromeAppExtConfOptions)
}

// DeleteChromeAppExtConfWithContext is an alternate form of the DeleteChromeAppExtConf method which supports a Context parameter
func (pushService *PushServiceV1) DeleteChromeAppExtConfWithContext(ctx context.Context, deleteChromeAppExtConfOptions *DeleteChromeAppExtConfOptions) (response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(deleteChromeAppExtConfOptions, "deleteChromeAppExtConfOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(deleteChromeAppExtConfOptions, "deleteChromeAppExtConfOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *deleteChromeAppExtConfOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.DELETE)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/chromeAppExtConf`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range deleteChromeAppExtConfOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "DeleteChromeAppExtConf")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	if deleteChromeAppExtConfOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*deleteChromeAppExtConfOptions.AcceptLanguage))
	}
	if deleteChromeAppExtConfOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*deleteChromeAppExtConfOptions.AppSecret))
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	response, err = pushService.Service.Request(request, nil)

	return
}

// GetChromeAppExtConfPublic : Get the GCM senderId for Chorme Apps-Extentions Push credentials
// Retrieves GCM senderId only for Chorme Apps-Extentions Push credentials of the application.
func (pushService *PushServiceV1) GetChromeAppExtConfPublic(getChromeAppExtConfPublicOptions *GetChromeAppExtConfPublicOptions) (result *GCMCredendialsPublicModel, response *core.DetailedResponse, err error) {
	return pushService.GetChromeAppExtConfPublicWithContext(context.Background(), getChromeAppExtConfPublicOptions)
}

// GetChromeAppExtConfPublicWithContext is an alternate form of the GetChromeAppExtConfPublic method which supports a Context parameter
func (pushService *PushServiceV1) GetChromeAppExtConfPublicWithContext(ctx context.Context, getChromeAppExtConfPublicOptions *GetChromeAppExtConfPublicOptions) (result *GCMCredendialsPublicModel, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(getChromeAppExtConfPublicOptions, "getChromeAppExtConfPublicOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(getChromeAppExtConfPublicOptions, "getChromeAppExtConfPublicOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *getChromeAppExtConfPublicOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.GET)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/settings/chromeAppExtConfPublic`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range getChromeAppExtConfPublicOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "GetChromeAppExtConfPublic")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	if getChromeAppExtConfPublicOptions.ClientSecret != nil {
		builder.AddHeader("clientSecret", fmt.Sprint(*getChromeAppExtConfPublicOptions.ClientSecret))
	}
	if getChromeAppExtConfPublicOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*getChromeAppExtConfPublicOptions.AcceptLanguage))
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalGCMCredendialsPublicModel)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// SendMessage : Send message with different options
// When the request to send the message is accepted, sends push notifications to the specified targets and returns HTTP
// return code 202. The sent messages are stored and would auto expire in 10 days. You would not be able to retrieve
// information about a message using GET, after this specified time limit. Available in server side frameworks.
func (pushService *PushServiceV1) SendMessage(sendMessageOptions *SendMessageOptions) (result *MessageResponseModel, response *core.DetailedResponse, err error) {
	return pushService.SendMessageWithContext(context.Background(), sendMessageOptions)
}

// SendMessageWithContext is an alternate form of the SendMessage method which supports a Context parameter
func (pushService *PushServiceV1) SendMessageWithContext(ctx context.Context, sendMessageOptions *SendMessageOptions) (result *MessageResponseModel, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(sendMessageOptions, "sendMessageOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(sendMessageOptions, "sendMessageOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *sendMessageOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.POST)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/messages`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range sendMessageOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "SendMessage")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	builder.AddHeader("Content-Type", "application/json")
	if sendMessageOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*sendMessageOptions.AcceptLanguage))
	}

	body := make(map[string]interface{})
	if sendMessageOptions.Message != nil {
		body["message"] = sendMessageOptions.Message
	}
	if sendMessageOptions.Settings != nil {
		body["settings"] = sendMessageOptions.Settings
	}
	if sendMessageOptions.Validate != nil {
		body["validate"] = sendMessageOptions.Validate
	}
	if sendMessageOptions.Target != nil {
		body["target"] = sendMessageOptions.Target
	}
	_, err = builder.SetBodyContentJSON(body)
	if err != nil {
		return
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalMessageResponseModel)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// SendMessagesInBulk : Send Bulk Messages
// Send bulk messages with different options to be specified. The sent messages are stored and would auto expire in 10
// days. You would not be able to retrieve information about a message using GET, after this specified time limit.
// Available in server side frameworks.
func (pushService *PushServiceV1) SendMessagesInBulk(sendMessagesInBulkOptions *SendMessagesInBulkOptions) (result *MessagesArrayModel, response *core.DetailedResponse, err error) {
	return pushService.SendMessagesInBulkWithContext(context.Background(), sendMessagesInBulkOptions)
}

// SendMessagesInBulkWithContext is an alternate form of the SendMessagesInBulk method which supports a Context parameter
func (pushService *PushServiceV1) SendMessagesInBulkWithContext(ctx context.Context, sendMessagesInBulkOptions *SendMessagesInBulkOptions) (result *MessagesArrayModel, response *core.DetailedResponse, err error) {
	err = core.ValidateNotNil(sendMessagesInBulkOptions, "sendMessagesInBulkOptions cannot be nil")
	if err != nil {
		return
	}
	err = core.ValidateStruct(sendMessagesInBulkOptions, "sendMessagesInBulkOptions")
	if err != nil {
		return
	}

	pathParamsMap := map[string]string{
		"applicationId": *sendMessagesInBulkOptions.ApplicationID,
	}

	builder := core.NewRequestBuilder(core.POST)
	builder = builder.WithContext(ctx)
	builder.EnableGzipCompression = pushService.GetEnableGzipCompression()
	_, err = builder.ResolveRequestURL(pushService.Service.Options.URL, `/apps/{applicationId}/messages/bulk`, pathParamsMap)
	if err != nil {
		return
	}

	for headerName, headerValue := range sendMessagesInBulkOptions.Headers {
		builder.AddHeader(headerName, headerValue)
	}

	sdkHeaders := common.GetSdkHeaders("push_service", "V1", "SendMessagesInBulk")
	for headerName, headerValue := range sdkHeaders {
		builder.AddHeader(headerName, headerValue)
	}
	builder.AddHeader("Accept", "application/json")
	builder.AddHeader("Content-Type", "application/json")
	if sendMessagesInBulkOptions.AcceptLanguage != nil {
		builder.AddHeader("Accept-Language", fmt.Sprint(*sendMessagesInBulkOptions.AcceptLanguage))
	}
	if sendMessagesInBulkOptions.AppSecret != nil {
		builder.AddHeader("appSecret", fmt.Sprint(*sendMessagesInBulkOptions.AppSecret))
	}

	_, err = builder.SetBodyContentJSON(sendMessagesInBulkOptions.Body)
	if err != nil {
		return
	}

	request, err := builder.Build()
	if err != nil {
		return
	}

	var rawResponse map[string]json.RawMessage
	response, err = pushService.Service.Request(request, &rawResponse)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(rawResponse, "", &result, UnmarshalMessagesArrayModel)
	if err != nil {
		return
	}
	response.Result = result

	return
}

// Apns : Settings specific to iOS platform.
type Apns struct {
	// The number to display as the badge of the application icon.
	Badge *int64 `json:"badge,omitempty"`

	// The category identifier to be used for the interactive push notifications.
	InteractiveCategory *string `json:"interactiveCategory,omitempty"`

	// __Deprecated__. Use __'interactiveCategory'__ for interactive push notification.
	Category *string `json:"category,omitempty"`

	// The title for the Action key.
	IosActionKey *string `json:"iosActionKey,omitempty"`

	// Custom JSON payload that will be sent as part of the notification message.
	Payload interface{} `json:"payload,omitempty"`

	// The name of the sound file in the application bundle. The sound of this file is played as an alert.
	Sound *string `json:"sound,omitempty"`

	// The key to a title string in the Localizable.strings file for the current localization. The key string can be
	// formatted with %@ and %n$@ specifiers to take the variables specified in the titleLocArgs array.
	TitleLocKey *string `json:"titleLocKey,omitempty"`

	// A key to an alert-message string in a Localizabl.strings file for the current localization (which is set by the
	// userÃ¢â‚¬â„¢s language preference).
	//   The key string can be formatted with %@ and %n$@ specifiers to take the variables specified in the locArgs array.
	LocKey *string `json:"locKey,omitempty"`

	// The filename of an image file in the app bundle, with or without the filename extension. The image is used as the
	// launch image when users tap the action button or move the action slider.
	LaunchImage *string `json:"launchImage,omitempty"`

	// Variable string values to appear in place of the format specifiers in title-loc-key.
	TitleLocArgs []string `json:"titleLocArgs,omitempty"`

	// Variable string values to appear in place of the format specifiers in locKey.
	LocArgs []string `json:"locArgs,omitempty"`

	// The title of Rich Push notifications (Supported only on iOS 10 and above).
	Title *string `json:"title,omitempty"`

	// The subtitle of the Rich Notifications.(Supported only on iOS 10 and above).
	Subtitle *string `json:"subtitle,omitempty"`

	// The link to the iOS notifications media (video, audio, GIF, images - Supported only on iOS 10 and above).
	AttachmentURL *string `json:"attachmentUrl,omitempty"`

	Type *string `json:"type,omitempty"`

	// Multiple notifications with the same collapse identifier are displayed to the user as a single notification.
	ApnsCollapseID *string `json:"apnsCollapseId,omitempty"`

	// An app-specific identifier for grouping related notifications. This value corresponds to the threadIdentifier
	// property in the UNNotificationContent object.
	ApnsThreadID *string `json:"apnsThreadId,omitempty"`

	// The string the notification adds to the category’s summary format string.
	ApnsGroupSummaryArg *string `json:"apnsGroupSummaryArg,omitempty"`

	// The number of items the notification adds to the category’s summary format string.
	ApnsGroupSummaryArgCount *int64 `json:"apnsGroupSummaryArgCount,omitempty"`
}

// Constants associated with the Apns.Type property.
const (
	Apns_Type_Default = "DEFAULT"
	Apns_Type_Mixed   = "MIXED"
	Apns_Type_Silent  = "SILENT"
)

// UnmarshalApns unmarshals an instance of Apns from the specified map of raw messages.
func UnmarshalApns(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(Apns)
	err = core.UnmarshalPrimitive(m, "badge", &obj.Badge)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "interactiveCategory", &obj.InteractiveCategory)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "category", &obj.Category)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "iosActionKey", &obj.IosActionKey)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "payload", &obj.Payload)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "sound", &obj.Sound)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "titleLocKey", &obj.TitleLocKey)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "locKey", &obj.LocKey)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "launchImage", &obj.LaunchImage)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "titleLocArgs", &obj.TitleLocArgs)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "locArgs", &obj.LocArgs)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "title", &obj.Title)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "subtitle", &obj.Subtitle)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "attachmentUrl", &obj.AttachmentURL)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "type", &obj.Type)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "apnsCollapseId", &obj.ApnsCollapseID)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "apnsThreadId", &obj.ApnsThreadID)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "apnsGroupSummaryArg", &obj.ApnsGroupSummaryArg)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "apnsGroupSummaryArgCount", &obj.ApnsGroupSummaryArgCount)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// ApplicationServerKeyModel : ApplicationServerKeyModel struct
type ApplicationServerKeyModel struct {
	// Application Server key for Web Push Identification.
	WebpushServerKey *string `json:"webpushServerKey" validate:"required"`
}

// UnmarshalApplicationServerKeyModel unmarshals an instance of ApplicationServerKeyModel from the specified map of raw messages.
func UnmarshalApplicationServerKeyModel(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(ApplicationServerKeyModel)
	err = core.UnmarshalPrimitive(m, "webpushServerKey", &obj.WebpushServerKey)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// ChromeAppExt : Web Push Notifications settings specific to Chrome  browser.
type ChromeAppExt struct {
	// Dozed devices to display only the latest notification and discard old low priority notifications.
	CollapseKey *string `json:"collapseKey,omitempty"`

	// When this parameter is set to true, it indicates that the message should not be sent until the device becomes
	// active.
	DelayWhileIdle *bool `json:"delayWhileIdle,omitempty"`

	// Specifies the title to be set for the WebPush Notification.
	Title *string `json:"title,omitempty"`

	// The URL of the icon to be set for the WebPush Notification.
	IconURL *string `json:"iconUrl,omitempty"`

	// This parameter specifies how long (in seconds) the message should be kept in GCM storage if the device is offline.
	TimeToLive *int64 `json:"timeToLive,omitempty"`

	// Custom JSON payload that will be sent as part of the notification message.
	Payload *string `json:"payload,omitempty"`
}

// UnmarshalChromeAppExt unmarshals an instance of ChromeAppExt from the specified map of raw messages.
func UnmarshalChromeAppExt(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(ChromeAppExt)
	err = core.UnmarshalPrimitive(m, "collapseKey", &obj.CollapseKey)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "delayWhileIdle", &obj.DelayWhileIdle)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "title", &obj.Title)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "iconUrl", &obj.IconURL)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "timeToLive", &obj.TimeToLive)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "payload", &obj.Payload)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// ChromeWeb : Web Push Notifications settings specific to Chrome  browser.
type ChromeWeb struct {
	// Specifies the title to be set for the WebPush Notification.
	Title *string `json:"title,omitempty"`

	// The URL of the icon to be set for the WebPush Notification.
	IconURL *string `json:"iconUrl,omitempty"`

	// This parameter specifies how long (in seconds) the message should be kept in GCM storage if the device is offline.
	TimeToLive *int64 `json:"timeToLive,omitempty"`

	// Custom JSON payload that will be sent as part of the
	//   notification message.
	Payload *string `json:"payload,omitempty"`
}

// UnmarshalChromeWeb unmarshals an instance of ChromeWeb from the specified map of raw messages.
func UnmarshalChromeWeb(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(ChromeWeb)
	err = core.UnmarshalPrimitive(m, "title", &obj.Title)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "iconUrl", &obj.IconURL)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "timeToLive", &obj.TimeToLive)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "payload", &obj.Payload)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// ChromeWebPushCredendialsModel : ChromeWebPushCredendialsModel struct
type ChromeWebPushCredendialsModel struct {
	// An API key that gives the push service an authorized access to Google services that is used for Chrome Web Push.
	ApiKey *string `json:"apiKey" validate:"required"`

	// The URL of the WebSite / WebApp that should be permitted to subscribe to WebPush.
	WebSiteURL *string `json:"webSiteUrl" validate:"required"`
}

// NewChromeWebPushCredendialsModel : Instantiate ChromeWebPushCredendialsModel (Generic Model Constructor)
func (*PushServiceV1) NewChromeWebPushCredendialsModel(apiKey string, webSiteURL string) (model *ChromeWebPushCredendialsModel, err error) {
	model = &ChromeWebPushCredendialsModel{
		ApiKey:     core.StringPtr(apiKey),
		WebSiteURL: core.StringPtr(webSiteURL),
	}
	err = core.ValidateStruct(model, "required parameters")
	return
}

// UnmarshalChromeWebPushCredendialsModel unmarshals an instance of ChromeWebPushCredendialsModel from the specified map of raw messages.
func UnmarshalChromeWebPushCredendialsModel(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(ChromeWebPushCredendialsModel)
	err = core.UnmarshalPrimitive(m, "apiKey", &obj.ApiKey)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "webSiteUrl", &obj.WebSiteURL)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// DeleteApnsConfOptions : The DeleteApnsConf options.
type DeleteApnsConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewDeleteApnsConfOptions : Instantiate DeleteApnsConfOptions
func (*PushServiceV1) NewDeleteApnsConfOptions(applicationID string) *DeleteApnsConfOptions {
	return &DeleteApnsConfOptions{
		ApplicationID: core.StringPtr(applicationID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *DeleteApnsConfOptions) SetApplicationID(applicationID string) *DeleteApnsConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *DeleteApnsConfOptions) SetAcceptLanguage(acceptLanguage string) *DeleteApnsConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *DeleteApnsConfOptions) SetAppSecret(appSecret string) *DeleteApnsConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *DeleteApnsConfOptions) SetHeaders(param map[string]string) *DeleteApnsConfOptions {
	options.Headers = param
	return options
}

// DeleteChromeAppExtConfOptions : The DeleteChromeAppExtConf options.
type DeleteChromeAppExtConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewDeleteChromeAppExtConfOptions : Instantiate DeleteChromeAppExtConfOptions
func (*PushServiceV1) NewDeleteChromeAppExtConfOptions(applicationID string) *DeleteChromeAppExtConfOptions {
	return &DeleteChromeAppExtConfOptions{
		ApplicationID: core.StringPtr(applicationID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *DeleteChromeAppExtConfOptions) SetApplicationID(applicationID string) *DeleteChromeAppExtConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *DeleteChromeAppExtConfOptions) SetAcceptLanguage(acceptLanguage string) *DeleteChromeAppExtConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *DeleteChromeAppExtConfOptions) SetAppSecret(appSecret string) *DeleteChromeAppExtConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *DeleteChromeAppExtConfOptions) SetHeaders(param map[string]string) *DeleteChromeAppExtConfOptions {
	options.Headers = param
	return options
}

// DeleteChromeWebConfOptions : The DeleteChromeWebConf options.
type DeleteChromeWebConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewDeleteChromeWebConfOptions : Instantiate DeleteChromeWebConfOptions
func (*PushServiceV1) NewDeleteChromeWebConfOptions(applicationID string) *DeleteChromeWebConfOptions {
	return &DeleteChromeWebConfOptions{
		ApplicationID: core.StringPtr(applicationID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *DeleteChromeWebConfOptions) SetApplicationID(applicationID string) *DeleteChromeWebConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *DeleteChromeWebConfOptions) SetAcceptLanguage(acceptLanguage string) *DeleteChromeWebConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *DeleteChromeWebConfOptions) SetAppSecret(appSecret string) *DeleteChromeWebConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *DeleteChromeWebConfOptions) SetHeaders(param map[string]string) *DeleteChromeWebConfOptions {
	options.Headers = param
	return options
}

// DeleteFirefoxWebConfOptions : The DeleteFirefoxWebConf options.
type DeleteFirefoxWebConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewDeleteFirefoxWebConfOptions : Instantiate DeleteFirefoxWebConfOptions
func (*PushServiceV1) NewDeleteFirefoxWebConfOptions(applicationID string) *DeleteFirefoxWebConfOptions {
	return &DeleteFirefoxWebConfOptions{
		ApplicationID: core.StringPtr(applicationID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *DeleteFirefoxWebConfOptions) SetApplicationID(applicationID string) *DeleteFirefoxWebConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *DeleteFirefoxWebConfOptions) SetAcceptLanguage(acceptLanguage string) *DeleteFirefoxWebConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *DeleteFirefoxWebConfOptions) SetAppSecret(appSecret string) *DeleteFirefoxWebConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *DeleteFirefoxWebConfOptions) SetHeaders(param map[string]string) *DeleteFirefoxWebConfOptions {
	options.Headers = param
	return options
}

// DeleteGCMConfOptions : The DeleteGCMConf options.
type DeleteGCMConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewDeleteGCMConfOptions : Instantiate DeleteGCMConfOptions
func (*PushServiceV1) NewDeleteGCMConfOptions(applicationID string) *DeleteGCMConfOptions {
	return &DeleteGCMConfOptions{
		ApplicationID: core.StringPtr(applicationID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *DeleteGCMConfOptions) SetApplicationID(applicationID string) *DeleteGCMConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *DeleteGCMConfOptions) SetAcceptLanguage(acceptLanguage string) *DeleteGCMConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *DeleteGCMConfOptions) SetAppSecret(appSecret string) *DeleteGCMConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *DeleteGCMConfOptions) SetHeaders(param map[string]string) *DeleteGCMConfOptions {
	options.Headers = param
	return options
}

// DeleteSafariWebConfOptions : The DeleteSafariWebConf options.
type DeleteSafariWebConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewDeleteSafariWebConfOptions : Instantiate DeleteSafariWebConfOptions
func (*PushServiceV1) NewDeleteSafariWebConfOptions(applicationID string) *DeleteSafariWebConfOptions {
	return &DeleteSafariWebConfOptions{
		ApplicationID: core.StringPtr(applicationID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *DeleteSafariWebConfOptions) SetApplicationID(applicationID string) *DeleteSafariWebConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *DeleteSafariWebConfOptions) SetAcceptLanguage(acceptLanguage string) *DeleteSafariWebConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *DeleteSafariWebConfOptions) SetAppSecret(appSecret string) *DeleteSafariWebConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *DeleteSafariWebConfOptions) SetHeaders(param map[string]string) *DeleteSafariWebConfOptions {
	options.Headers = param
	return options
}

// FirefoxWeb : Web Push Notifications settings specific to Mozilla Firefox browser platforms.
type FirefoxWeb struct {
	// Specifies the title to be set for the WebPush Notification.
	Title *string `json:"title,omitempty"`

	// The URL of the icon to be set for the WebPush Notification.
	IconURL *string `json:"iconUrl,omitempty"`

	// This parameter specifies how long (in seconds) the message should be kept in GCM storage if the device is offline.
	TimeToLive *int64 `json:"timeToLive,omitempty"`

	// Custom JSON payload that will be sent as part of the notification message.
	Payload *string `json:"payload,omitempty"`
}

// UnmarshalFirefoxWeb unmarshals an instance of FirefoxWeb from the specified map of raw messages.
func UnmarshalFirefoxWeb(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(FirefoxWeb)
	err = core.UnmarshalPrimitive(m, "title", &obj.Title)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "iconUrl", &obj.IconURL)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "timeToLive", &obj.TimeToLive)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "payload", &obj.Payload)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// FirefoxWebPushCredendialsModel : FirefoxWebPushCredendialsModel struct
type FirefoxWebPushCredendialsModel struct {
	// The URL of the WebSite / WebApp that should be permitted to subscribe to WebPush.
	WebSiteURL *string `json:"webSiteUrl" validate:"required"`
}

// NewFirefoxWebPushCredendialsModel : Instantiate FirefoxWebPushCredendialsModel (Generic Model Constructor)
func (*PushServiceV1) NewFirefoxWebPushCredendialsModel(webSiteURL string) (model *FirefoxWebPushCredendialsModel, err error) {
	model = &FirefoxWebPushCredendialsModel{
		WebSiteURL: core.StringPtr(webSiteURL),
	}
	err = core.ValidateStruct(model, "required parameters")
	return
}

// UnmarshalFirefoxWebPushCredendialsModel unmarshals an instance of FirefoxWebPushCredendialsModel from the specified map of raw messages.
func UnmarshalFirefoxWebPushCredendialsModel(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(FirefoxWebPushCredendialsModel)
	err = core.UnmarshalPrimitive(m, "webSiteUrl", &obj.WebSiteURL)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// GCMCredendialsModel : GCMCredendialsModel struct
type GCMCredendialsModel struct {
	// An API key that gives the push service an authorized access to Google services.
	ApiKey *string `json:"apiKey" validate:"required"`

	// Project Number in the Google Developers Console.
	SenderID *string `json:"senderId" validate:"required"`
}

// NewGCMCredendialsModel : Instantiate GCMCredendialsModel (Generic Model Constructor)
func (*PushServiceV1) NewGCMCredendialsModel(apiKey string, senderID string) (model *GCMCredendialsModel, err error) {
	model = &GCMCredendialsModel{
		ApiKey:   core.StringPtr(apiKey),
		SenderID: core.StringPtr(senderID),
	}
	err = core.ValidateStruct(model, "required parameters")
	return
}

// UnmarshalGCMCredendialsModel unmarshals an instance of GCMCredendialsModel from the specified map of raw messages.
func UnmarshalGCMCredendialsModel(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(GCMCredendialsModel)
	err = core.UnmarshalPrimitive(m, "apiKey", &obj.ApiKey)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "senderId", &obj.SenderID)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// GCMCredendialsPublicModel : GCMCredendialsPublicModel struct
type GCMCredendialsPublicModel struct {
	// Project Number in the Google Developers Console.
	SenderID *string `json:"senderId" validate:"required"`
}

// UnmarshalGCMCredendialsPublicModel unmarshals an instance of GCMCredendialsPublicModel from the specified map of raw messages.
func UnmarshalGCMCredendialsPublicModel(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(GCMCredendialsPublicModel)
	err = core.UnmarshalPrimitive(m, "senderId", &obj.SenderID)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// Gcm : Settings specific to Android platform.
type Gcm struct {
	// Dozed devices to display only the latest notification and discard old low priority notifications.
	CollapseKey *string `json:"collapseKey,omitempty"`

	// The category identifier to be used for the interactive push notifications.
	InteractiveCategory *string `json:"interactiveCategory,omitempty"`

	// Specify the name of the icon to be displayed for the notification. Make sure the icon is already packaged with the
	// client application.
	Icon *string `json:"icon,omitempty"`

	// When this parameter is set to true, it indicates that the
	//   message should not be sent until the device becomes active.
	DelayWhileIdle *bool `json:"delayWhileIdle,omitempty"`

	// Device group messaging makes it possible for every app instance in a group to reflect the latest messaging state.
	Sync *bool `json:"sync,omitempty"`

	// private/public - Visibility of this notification, which affects how and when the notifications are revealed on a
	// secure locked screen.
	Visibility *string `json:"visibility,omitempty"`

	// Content specified will show up on a secure locked screen on the device when visibility is set to Private.
	Redact *string `json:"redact,omitempty"`

	// unique Id of the channel to add channel properties.
	ChannelID *string `json:"channelId,omitempty"`

	// Custom JSON payload that will be sent as part of the notification message.
	Payload interface{} `json:"payload,omitempty"`

	// A string value that indicates the priority of this notification. Allowed values are 'max', 'high', 'default', 'low'
	// and 'min'. High/Max priority notifications along with 'sound' field may be used for Heads up notification in Android
	// 5.0 or higher.sampleval='low'.
	Priority *string `json:"priority,omitempty"`

	// The sound file (on device) that will be attempted to play when the notification arrives on the device.
	Sound *string `json:"sound,omitempty"`

	// This parameter specifies how long (in seconds) the message
	//   should be kept in GCM storage if the device is offline.
	TimeToLive *int64 `json:"timeToLive,omitempty"`

	// Allows setting the notification LED color on receiving push notification .
	Lights *Lights `json:"lights,omitempty"`

	// The title of Rich Push notifications.
	AndroidTitle *string `json:"androidTitle,omitempty"`

	// Set this notification to be part of a group of notifications sharing the same key. Grouped notifications may display
	// in a cluster or stack on devices which support such rendering.
	GroupID *string `json:"groupId,omitempty"`

	// Options to specify for Android expandable notifications. The types of expandable notifications are
	// picture_notification, bigtext_notification, inbox_notification.
	Style *Style `json:"style,omitempty"`

	Type *string `json:"type,omitempty"`
}

// Constants associated with the Gcm.Type property.
const (
	Gcm_Type_Default = "DEFAULT"
	Gcm_Type_Silent  = "SILENT"
)

// UnmarshalGcm unmarshals an instance of Gcm from the specified map of raw messages.
func UnmarshalGcm(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(Gcm)
	err = core.UnmarshalPrimitive(m, "collapseKey", &obj.CollapseKey)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "interactiveCategory", &obj.InteractiveCategory)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "icon", &obj.Icon)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "delayWhileIdle", &obj.DelayWhileIdle)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "sync", &obj.Sync)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "visibility", &obj.Visibility)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "redact", &obj.Redact)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "channelId", &obj.ChannelID)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "payload", &obj.Payload)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "priority", &obj.Priority)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "sound", &obj.Sound)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "timeToLive", &obj.TimeToLive)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(m, "lights", &obj.Lights, UnmarshalLights)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "androidTitle", &obj.AndroidTitle)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "groupId", &obj.GroupID)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(m, "style", &obj.Style, UnmarshalStyle)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "type", &obj.Type)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// GetApnsConfOptions : The GetApnsConf options.
type GetApnsConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewGetApnsConfOptions : Instantiate GetApnsConfOptions
func (*PushServiceV1) NewGetApnsConfOptions(applicationID string) *GetApnsConfOptions {
	return &GetApnsConfOptions{
		ApplicationID: core.StringPtr(applicationID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *GetApnsConfOptions) SetApplicationID(applicationID string) *GetApnsConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *GetApnsConfOptions) SetAcceptLanguage(acceptLanguage string) *GetApnsConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *GetApnsConfOptions) SetAppSecret(appSecret string) *GetApnsConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *GetApnsConfOptions) SetHeaders(param map[string]string) *GetApnsConfOptions {
	options.Headers = param
	return options
}

// GetChromeAppExtConfOptions : The GetChromeAppExtConf options.
type GetChromeAppExtConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewGetChromeAppExtConfOptions : Instantiate GetChromeAppExtConfOptions
func (*PushServiceV1) NewGetChromeAppExtConfOptions(applicationID string) *GetChromeAppExtConfOptions {
	return &GetChromeAppExtConfOptions{
		ApplicationID: core.StringPtr(applicationID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *GetChromeAppExtConfOptions) SetApplicationID(applicationID string) *GetChromeAppExtConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *GetChromeAppExtConfOptions) SetAcceptLanguage(acceptLanguage string) *GetChromeAppExtConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *GetChromeAppExtConfOptions) SetAppSecret(appSecret string) *GetChromeAppExtConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *GetChromeAppExtConfOptions) SetHeaders(param map[string]string) *GetChromeAppExtConfOptions {
	options.Headers = param
	return options
}

// GetChromeAppExtConfPublicOptions : The GetChromeAppExtConfPublic options.
type GetChromeAppExtConfPublicOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// The clientSecret associated with this application.
	ClientSecret *string

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewGetChromeAppExtConfPublicOptions : Instantiate GetChromeAppExtConfPublicOptions
func (*PushServiceV1) NewGetChromeAppExtConfPublicOptions(applicationID string) *GetChromeAppExtConfPublicOptions {
	return &GetChromeAppExtConfPublicOptions{
		ApplicationID: core.StringPtr(applicationID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *GetChromeAppExtConfPublicOptions) SetApplicationID(applicationID string) *GetChromeAppExtConfPublicOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetClientSecret : Allow user to set ClientSecret
func (options *GetChromeAppExtConfPublicOptions) SetClientSecret(clientSecret string) *GetChromeAppExtConfPublicOptions {
	options.ClientSecret = core.StringPtr(clientSecret)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *GetChromeAppExtConfPublicOptions) SetAcceptLanguage(acceptLanguage string) *GetChromeAppExtConfPublicOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *GetChromeAppExtConfPublicOptions) SetHeaders(param map[string]string) *GetChromeAppExtConfPublicOptions {
	options.Headers = param
	return options
}

// GetChromeWebConfOptions : The GetChromeWebConf options.
type GetChromeWebConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewGetChromeWebConfOptions : Instantiate GetChromeWebConfOptions
func (*PushServiceV1) NewGetChromeWebConfOptions(applicationID string) *GetChromeWebConfOptions {
	return &GetChromeWebConfOptions{
		ApplicationID: core.StringPtr(applicationID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *GetChromeWebConfOptions) SetApplicationID(applicationID string) *GetChromeWebConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *GetChromeWebConfOptions) SetAcceptLanguage(acceptLanguage string) *GetChromeWebConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *GetChromeWebConfOptions) SetAppSecret(appSecret string) *GetChromeWebConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *GetChromeWebConfOptions) SetHeaders(param map[string]string) *GetChromeWebConfOptions {
	options.Headers = param
	return options
}

// GetFirefoxWebConfOptions : The GetFirefoxWebConf options.
type GetFirefoxWebConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewGetFirefoxWebConfOptions : Instantiate GetFirefoxWebConfOptions
func (*PushServiceV1) NewGetFirefoxWebConfOptions(applicationID string) *GetFirefoxWebConfOptions {
	return &GetFirefoxWebConfOptions{
		ApplicationID: core.StringPtr(applicationID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *GetFirefoxWebConfOptions) SetApplicationID(applicationID string) *GetFirefoxWebConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *GetFirefoxWebConfOptions) SetAcceptLanguage(acceptLanguage string) *GetFirefoxWebConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *GetFirefoxWebConfOptions) SetAppSecret(appSecret string) *GetFirefoxWebConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *GetFirefoxWebConfOptions) SetHeaders(param map[string]string) *GetFirefoxWebConfOptions {
	options.Headers = param
	return options
}

// GetGCMConfOptions : The GetGCMConf options.
type GetGCMConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewGetGCMConfOptions : Instantiate GetGCMConfOptions
func (*PushServiceV1) NewGetGCMConfOptions(applicationID string) *GetGCMConfOptions {
	return &GetGCMConfOptions{
		ApplicationID: core.StringPtr(applicationID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *GetGCMConfOptions) SetApplicationID(applicationID string) *GetGCMConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *GetGCMConfOptions) SetAcceptLanguage(acceptLanguage string) *GetGCMConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *GetGCMConfOptions) SetAppSecret(appSecret string) *GetGCMConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *GetGCMConfOptions) SetHeaders(param map[string]string) *GetGCMConfOptions {
	options.Headers = param
	return options
}

// GetGcmConfPublicOptions : The GetGcmConfPublic options.
type GetGcmConfPublicOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// The clientSecret associated with this application.
	ClientSecret *string

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewGetGcmConfPublicOptions : Instantiate GetGcmConfPublicOptions
func (*PushServiceV1) NewGetGcmConfPublicOptions(applicationID string) *GetGcmConfPublicOptions {
	return &GetGcmConfPublicOptions{
		ApplicationID: core.StringPtr(applicationID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *GetGcmConfPublicOptions) SetApplicationID(applicationID string) *GetGcmConfPublicOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetClientSecret : Allow user to set ClientSecret
func (options *GetGcmConfPublicOptions) SetClientSecret(clientSecret string) *GetGcmConfPublicOptions {
	options.ClientSecret = core.StringPtr(clientSecret)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *GetGcmConfPublicOptions) SetAcceptLanguage(acceptLanguage string) *GetGcmConfPublicOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *GetGcmConfPublicOptions) SetHeaders(param map[string]string) *GetGcmConfPublicOptions {
	options.Headers = param
	return options
}

// GetSafariWebConfOptions : The GetSafariWebConf options.
type GetSafariWebConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewGetSafariWebConfOptions : Instantiate GetSafariWebConfOptions
func (*PushServiceV1) NewGetSafariWebConfOptions(applicationID string) *GetSafariWebConfOptions {
	return &GetSafariWebConfOptions{
		ApplicationID: core.StringPtr(applicationID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *GetSafariWebConfOptions) SetApplicationID(applicationID string) *GetSafariWebConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *GetSafariWebConfOptions) SetAcceptLanguage(acceptLanguage string) *GetSafariWebConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *GetSafariWebConfOptions) SetAppSecret(appSecret string) *GetSafariWebConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *GetSafariWebConfOptions) SetHeaders(param map[string]string) *GetSafariWebConfOptions {
	options.Headers = param
	return options
}

// GetSettingsOptions : The GetSettings options.
type GetSettingsOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// Deprecated, use Authorization instead.
	AppSecret *string

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewGetSettingsOptions : Instantiate GetSettingsOptions
func (*PushServiceV1) NewGetSettingsOptions(applicationID string) *GetSettingsOptions {
	return &GetSettingsOptions{
		ApplicationID: core.StringPtr(applicationID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *GetSettingsOptions) SetApplicationID(applicationID string) *GetSettingsOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *GetSettingsOptions) SetAppSecret(appSecret string) *GetSettingsOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *GetSettingsOptions) SetAcceptLanguage(acceptLanguage string) *GetSettingsOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *GetSettingsOptions) SetHeaders(param map[string]string) *GetSettingsOptions {
	options.Headers = param
	return options
}

// GetWebpushServerKeyOptions : The GetWebpushServerKey options.
type GetWebpushServerKeyOptions struct {
	// Unique ID of the application server for the IBM Cloud Push Notification Service identification for web push
	// communication.
	ApplicationID *string `validate:"required,ne="`

	// Deprecated, use Authorization instead.
	ClientSecret *string

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewGetWebpushServerKeyOptions : Instantiate GetWebpushServerKeyOptions
func (*PushServiceV1) NewGetWebpushServerKeyOptions(applicationID string) *GetWebpushServerKeyOptions {
	return &GetWebpushServerKeyOptions{
		ApplicationID: core.StringPtr(applicationID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *GetWebpushServerKeyOptions) SetApplicationID(applicationID string) *GetWebpushServerKeyOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetClientSecret : Allow user to set ClientSecret
func (options *GetWebpushServerKeyOptions) SetClientSecret(clientSecret string) *GetWebpushServerKeyOptions {
	options.ClientSecret = core.StringPtr(clientSecret)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *GetWebpushServerKeyOptions) SetAcceptLanguage(acceptLanguage string) *GetWebpushServerKeyOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *GetWebpushServerKeyOptions) SetHeaders(param map[string]string) *GetWebpushServerKeyOptions {
	options.Headers = param
	return options
}

// Lights : Allows setting the notification LED color on receiving push notification .
type Lights struct {
	// The color of the led. The hardware will do its best approximation.
	LedArgb *string `json:"ledArgb,omitempty"`

	// The number of milliseconds for the LED to be on while it's flashing. The hardware will do its best approximation.
	LedOnMs *int64 `json:"ledOnMs,omitempty"`

	// The number of milliseconds for the LED to be off while it's flashing. The hardware will do its best approximation.
	LedOffMs *string `json:"ledOffMs,omitempty"`
}

// UnmarshalLights unmarshals an instance of Lights from the specified map of raw messages.
func UnmarshalLights(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(Lights)
	err = core.UnmarshalPrimitive(m, "ledArgb", &obj.LedArgb)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "ledOnMs", &obj.LedOnMs)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "ledOffMs", &obj.LedOffMs)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// Message : Details of the content of the notification message.
type Message struct {
	// The notification message to be shown to the user.
	Alert *string `json:"alert,omitempty"`

	// An optional URL that can be sent along with the alert.
	URL *string `json:"url,omitempty"`
}

// UnmarshalMessage unmarshals an instance of Message from the specified map of raw messages.
func UnmarshalMessage(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(Message)
	err = core.UnmarshalPrimitive(m, "alert", &obj.Alert)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "url", &obj.URL)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// MessageResponseModel : MessageResponseModel struct
type MessageResponseModel struct {
	Message *SendMessageBody `json:"message,omitempty"`

	// Unique Id for the message.
	MessageID *string `json:"messageId,omitempty"`
}

// UnmarshalMessageResponseModel unmarshals an instance of MessageResponseModel from the specified map of raw messages.
func UnmarshalMessageResponseModel(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(MessageResponseModel)
	err = core.UnmarshalModel(m, "message", &obj.Message, UnmarshalSendMessageBody)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "messageId", &obj.MessageID)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// MessagesArrayModel : MessagesArrayModel struct
type MessagesArrayModel struct {
	// An array of messages.
	Messages []MessagesList `json:"messages,omitempty"`
}

// UnmarshalMessagesArrayModel unmarshals an instance of MessagesArrayModel from the specified map of raw messages.
func UnmarshalMessagesArrayModel(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(MessagesArrayModel)
	err = core.UnmarshalModel(m, "messages", &obj.Messages, UnmarshalMessagesList)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// MessagesList : MessagesList struct
type MessagesList struct {
	// Created time of the message.
	CreatedTime *string `json:"createdTime,omitempty"`

	// Unique identifier of the message.
	MessageID *string `json:"messageId,omitempty"`

	// Message text.
	Alert *string `json:"alert,omitempty"`

	// The URL to the message resource.
	Href *string `json:"href,omitempty"`
}

// UnmarshalMessagesList unmarshals an instance of MessagesList from the specified map of raw messages.
func UnmarshalMessagesList(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(MessagesList)
	err = core.UnmarshalPrimitive(m, "createdTime", &obj.CreatedTime)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "messageId", &obj.MessageID)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "alert", &obj.Alert)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "href", &obj.Href)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// SafariWeb : Web Push Notifications settings specific to Safari  browser.
type SafariWeb struct {
	// Specifies the title to be set for the Safari Push Notifications.
	Title *string `json:"title,omitempty"`

	// The URL arguments that need to be used with this notification. This has to provided in the form of a JSON Array.
	UrlArgs []string `json:"urlArgs,omitempty"`

	// The label of the action button.
	Action *string `json:"action,omitempty"`
}

// UnmarshalSafariWeb unmarshals an instance of SafariWeb from the specified map of raw messages.
func UnmarshalSafariWeb(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(SafariWeb)
	err = core.UnmarshalPrimitive(m, "title", &obj.Title)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "urlArgs", &obj.UrlArgs)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "action", &obj.Action)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// SaveApnsConfOptions : The SaveApnsConf options.
type SaveApnsConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// Password for the APNS certificate.
	Password *string `validate:"required"`

	// Type of the APNS certificate.
	IsSandBox *bool `validate:"required"`

	// The APNS certificate.
	Certificate io.ReadCloser `validate:"required"`

	// The content type of certificate.
	CertificateContentType *string

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewSaveApnsConfOptions : Instantiate SaveApnsConfOptions
func (*PushServiceV1) NewSaveApnsConfOptions(applicationID string, password string, isSandBox bool, certificate io.ReadCloser) *SaveApnsConfOptions {
	return &SaveApnsConfOptions{
		ApplicationID: core.StringPtr(applicationID),
		Password:      core.StringPtr(password),
		IsSandBox:     core.BoolPtr(isSandBox),
		Certificate:   certificate,
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *SaveApnsConfOptions) SetApplicationID(applicationID string) *SaveApnsConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetPassword : Allow user to set Password
func (options *SaveApnsConfOptions) SetPassword(password string) *SaveApnsConfOptions {
	options.Password = core.StringPtr(password)
	return options
}

// SetIsSandBox : Allow user to set IsSandBox
func (options *SaveApnsConfOptions) SetIsSandBox(isSandBox bool) *SaveApnsConfOptions {
	options.IsSandBox = core.BoolPtr(isSandBox)
	return options
}

// SetCertificate : Allow user to set Certificate
func (options *SaveApnsConfOptions) SetCertificate(certificate io.ReadCloser) *SaveApnsConfOptions {
	options.Certificate = certificate
	return options
}

// SetCertificateContentType : Allow user to set CertificateContentType
func (options *SaveApnsConfOptions) SetCertificateContentType(certificateContentType string) *SaveApnsConfOptions {
	options.CertificateContentType = core.StringPtr(certificateContentType)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *SaveApnsConfOptions) SetAcceptLanguage(acceptLanguage string) *SaveApnsConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *SaveApnsConfOptions) SetAppSecret(appSecret string) *SaveApnsConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *SaveApnsConfOptions) SetHeaders(param map[string]string) *SaveApnsConfOptions {
	options.Headers = param
	return options
}

// SaveChromeAppExtConfOptions : The SaveChromeAppExtConf options.
type SaveChromeAppExtConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// An API key that gives the push service an authorized access to Google services.
	ApiKey *string `validate:"required"`

	// Project Number in the Google Developers Console.
	SenderID *string `validate:"required"`

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewSaveChromeAppExtConfOptions : Instantiate SaveChromeAppExtConfOptions
func (*PushServiceV1) NewSaveChromeAppExtConfOptions(applicationID string, apiKey string, senderID string) *SaveChromeAppExtConfOptions {
	return &SaveChromeAppExtConfOptions{
		ApplicationID: core.StringPtr(applicationID),
		ApiKey:        core.StringPtr(apiKey),
		SenderID:      core.StringPtr(senderID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *SaveChromeAppExtConfOptions) SetApplicationID(applicationID string) *SaveChromeAppExtConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetApiKey : Allow user to set ApiKey
func (options *SaveChromeAppExtConfOptions) SetApiKey(apiKey string) *SaveChromeAppExtConfOptions {
	options.ApiKey = core.StringPtr(apiKey)
	return options
}

// SetSenderID : Allow user to set SenderID
func (options *SaveChromeAppExtConfOptions) SetSenderID(senderID string) *SaveChromeAppExtConfOptions {
	options.SenderID = core.StringPtr(senderID)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *SaveChromeAppExtConfOptions) SetAcceptLanguage(acceptLanguage string) *SaveChromeAppExtConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *SaveChromeAppExtConfOptions) SetAppSecret(appSecret string) *SaveChromeAppExtConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *SaveChromeAppExtConfOptions) SetHeaders(param map[string]string) *SaveChromeAppExtConfOptions {
	options.Headers = param
	return options
}

// SaveChromeWebConfOptions : The SaveChromeWebConf options.
type SaveChromeWebConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// An API key that gives the push service an authorized access to Google services that is used for Chrome Web Push.
	ApiKey *string `validate:"required"`

	// The URL of the WebSite / WebApp that should be permitted to subscribe to WebPush.
	WebSiteURL *string `validate:"required"`

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewSaveChromeWebConfOptions : Instantiate SaveChromeWebConfOptions
func (*PushServiceV1) NewSaveChromeWebConfOptions(applicationID string, apiKey string, webSiteURL string) *SaveChromeWebConfOptions {
	return &SaveChromeWebConfOptions{
		ApplicationID: core.StringPtr(applicationID),
		ApiKey:        core.StringPtr(apiKey),
		WebSiteURL:    core.StringPtr(webSiteURL),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *SaveChromeWebConfOptions) SetApplicationID(applicationID string) *SaveChromeWebConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetApiKey : Allow user to set ApiKey
func (options *SaveChromeWebConfOptions) SetApiKey(apiKey string) *SaveChromeWebConfOptions {
	options.ApiKey = core.StringPtr(apiKey)
	return options
}

// SetWebSiteURL : Allow user to set WebSiteURL
func (options *SaveChromeWebConfOptions) SetWebSiteURL(webSiteURL string) *SaveChromeWebConfOptions {
	options.WebSiteURL = core.StringPtr(webSiteURL)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *SaveChromeWebConfOptions) SetAcceptLanguage(acceptLanguage string) *SaveChromeWebConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *SaveChromeWebConfOptions) SetAppSecret(appSecret string) *SaveChromeWebConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *SaveChromeWebConfOptions) SetHeaders(param map[string]string) *SaveChromeWebConfOptions {
	options.Headers = param
	return options
}

// SaveFirefoxWebConfOptions : The SaveFirefoxWebConf options.
type SaveFirefoxWebConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// The URL of the WebSite / WebApp that should be permitted to subscribe to WebPush.
	WebSiteURL *string `validate:"required"`

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewSaveFirefoxWebConfOptions : Instantiate SaveFirefoxWebConfOptions
func (*PushServiceV1) NewSaveFirefoxWebConfOptions(applicationID string, webSiteURL string) *SaveFirefoxWebConfOptions {
	return &SaveFirefoxWebConfOptions{
		ApplicationID: core.StringPtr(applicationID),
		WebSiteURL:    core.StringPtr(webSiteURL),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *SaveFirefoxWebConfOptions) SetApplicationID(applicationID string) *SaveFirefoxWebConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetWebSiteURL : Allow user to set WebSiteURL
func (options *SaveFirefoxWebConfOptions) SetWebSiteURL(webSiteURL string) *SaveFirefoxWebConfOptions {
	options.WebSiteURL = core.StringPtr(webSiteURL)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *SaveFirefoxWebConfOptions) SetAcceptLanguage(acceptLanguage string) *SaveFirefoxWebConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *SaveFirefoxWebConfOptions) SetAppSecret(appSecret string) *SaveFirefoxWebConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *SaveFirefoxWebConfOptions) SetHeaders(param map[string]string) *SaveFirefoxWebConfOptions {
	options.Headers = param
	return options
}

// SaveGCMConfOptions : The SaveGCMConf options.
type SaveGCMConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// An API key that gives the push service an authorized access to Google services.
	ApiKey *string `validate:"required"`

	// Project Number in the Google Developers Console.
	SenderID *string `validate:"required"`

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewSaveGCMConfOptions : Instantiate SaveGCMConfOptions
func (*PushServiceV1) NewSaveGCMConfOptions(applicationID string, apiKey string, senderID string) *SaveGCMConfOptions {
	return &SaveGCMConfOptions{
		ApplicationID: core.StringPtr(applicationID),
		ApiKey:        core.StringPtr(apiKey),
		SenderID:      core.StringPtr(senderID),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *SaveGCMConfOptions) SetApplicationID(applicationID string) *SaveGCMConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetApiKey : Allow user to set ApiKey
func (options *SaveGCMConfOptions) SetApiKey(apiKey string) *SaveGCMConfOptions {
	options.ApiKey = core.StringPtr(apiKey)
	return options
}

// SetSenderID : Allow user to set SenderID
func (options *SaveGCMConfOptions) SetSenderID(senderID string) *SaveGCMConfOptions {
	options.SenderID = core.StringPtr(senderID)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *SaveGCMConfOptions) SetAcceptLanguage(acceptLanguage string) *SaveGCMConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *SaveGCMConfOptions) SetAppSecret(appSecret string) *SaveGCMConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *SaveGCMConfOptions) SetHeaders(param map[string]string) *SaveGCMConfOptions {
	options.Headers = param
	return options
}

// SaveSafariWebConfOptions : The SaveSafariWebConf options.
type SaveSafariWebConfOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// Password for the web push certificate.
	Password *string `validate:"required"`

	// The Safari web push certificate (p12 format).
	Certificate io.ReadCloser `validate:"required"`

	// The website name. This is the heading used in Notification Center.
	WebsiteName *string `validate:"required"`

	// The URL to go to when the notification is clicked. Use %@ as a placeholder for arguments you fill in when delivering
	// your notification. This URL must use the http or https scheme; otherwise, it is invalid.
	UrlFormatString *string `validate:"required"`

	// Unique reverse-domain string for your Website Push ID such as web.com.example.domain (the string must start with
	// web).
	WebsitePushID *string `validate:"required"`

	// The URL of the website that should be permitted to subscribe to Safari Push Notifications.
	WebSiteURL *string `validate:"required"`

	// The content type of certificate.
	CertificateContentType *string

	// PNG icon file of 16x16 size.
	Icon16x16 io.ReadCloser

	// The content type of icon16x16.
	Icon16x16ContentType *string

	// PNG icon file of 16x16@2x size.
	Icon16x162x io.ReadCloser

	// The content type of icon16x162x.
	Icon16x162xContentType *string

	// PNG icon file of 32x32 size.
	Icon32x32 io.ReadCloser

	// The content type of icon32x32.
	Icon32x32ContentType *string

	// PNG icon file of 32x32@2x size.
	Icon32x322x io.ReadCloser

	// The content type of icon32x322x.
	Icon32x322xContentType *string

	// PNG icon file of 128x128 size.
	Icon128x128 io.ReadCloser

	// The content type of icon128x128.
	Icon128x128ContentType *string

	// PNG icon file of 128x128@2x size.
	Icon128x1282x io.ReadCloser

	// The content type of icon128x1282x.
	Icon128x1282xContentType *string

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewSaveSafariWebConfOptions : Instantiate SaveSafariWebConfOptions
func (*PushServiceV1) NewSaveSafariWebConfOptions(applicationID string, password string, certificate io.ReadCloser, websiteName string, urlFormatString string, websitePushID string, webSiteURL string) *SaveSafariWebConfOptions {
	return &SaveSafariWebConfOptions{
		ApplicationID:   core.StringPtr(applicationID),
		Password:        core.StringPtr(password),
		Certificate:     certificate,
		WebsiteName:     core.StringPtr(websiteName),
		UrlFormatString: core.StringPtr(urlFormatString),
		WebsitePushID:   core.StringPtr(websitePushID),
		WebSiteURL:      core.StringPtr(webSiteURL),
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *SaveSafariWebConfOptions) SetApplicationID(applicationID string) *SaveSafariWebConfOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetPassword : Allow user to set Password
func (options *SaveSafariWebConfOptions) SetPassword(password string) *SaveSafariWebConfOptions {
	options.Password = core.StringPtr(password)
	return options
}

// SetCertificate : Allow user to set Certificate
func (options *SaveSafariWebConfOptions) SetCertificate(certificate io.ReadCloser) *SaveSafariWebConfOptions {
	options.Certificate = certificate
	return options
}

// SetWebsiteName : Allow user to set WebsiteName
func (options *SaveSafariWebConfOptions) SetWebsiteName(websiteName string) *SaveSafariWebConfOptions {
	options.WebsiteName = core.StringPtr(websiteName)
	return options
}

// SetUrlFormatString : Allow user to set UrlFormatString
func (options *SaveSafariWebConfOptions) SetUrlFormatString(urlFormatString string) *SaveSafariWebConfOptions {
	options.UrlFormatString = core.StringPtr(urlFormatString)
	return options
}

// SetWebsitePushID : Allow user to set WebsitePushID
func (options *SaveSafariWebConfOptions) SetWebsitePushID(websitePushID string) *SaveSafariWebConfOptions {
	options.WebsitePushID = core.StringPtr(websitePushID)
	return options
}

// SetWebSiteURL : Allow user to set WebSiteURL
func (options *SaveSafariWebConfOptions) SetWebSiteURL(webSiteURL string) *SaveSafariWebConfOptions {
	options.WebSiteURL = core.StringPtr(webSiteURL)
	return options
}

// SetCertificateContentType : Allow user to set CertificateContentType
func (options *SaveSafariWebConfOptions) SetCertificateContentType(certificateContentType string) *SaveSafariWebConfOptions {
	options.CertificateContentType = core.StringPtr(certificateContentType)
	return options
}

// SetIcon16x16 : Allow user to set Icon16x16
func (options *SaveSafariWebConfOptions) SetIcon16x16(icon16x16 io.ReadCloser) *SaveSafariWebConfOptions {
	options.Icon16x16 = icon16x16
	return options
}

// SetIcon16x16ContentType : Allow user to set Icon16x16ContentType
func (options *SaveSafariWebConfOptions) SetIcon16x16ContentType(icon16x16ContentType string) *SaveSafariWebConfOptions {
	options.Icon16x16ContentType = core.StringPtr(icon16x16ContentType)
	return options
}

// SetIcon16x162x : Allow user to set Icon16x162x
func (options *SaveSafariWebConfOptions) SetIcon16x162x(icon16x162x io.ReadCloser) *SaveSafariWebConfOptions {
	options.Icon16x162x = icon16x162x
	return options
}

// SetIcon16x162xContentType : Allow user to set Icon16x162xContentType
func (options *SaveSafariWebConfOptions) SetIcon16x162xContentType(icon16x162xContentType string) *SaveSafariWebConfOptions {
	options.Icon16x162xContentType = core.StringPtr(icon16x162xContentType)
	return options
}

// SetIcon32x32 : Allow user to set Icon32x32
func (options *SaveSafariWebConfOptions) SetIcon32x32(icon32x32 io.ReadCloser) *SaveSafariWebConfOptions {
	options.Icon32x32 = icon32x32
	return options
}

// SetIcon32x32ContentType : Allow user to set Icon32x32ContentType
func (options *SaveSafariWebConfOptions) SetIcon32x32ContentType(icon32x32ContentType string) *SaveSafariWebConfOptions {
	options.Icon32x32ContentType = core.StringPtr(icon32x32ContentType)
	return options
}

// SetIcon32x322x : Allow user to set Icon32x322x
func (options *SaveSafariWebConfOptions) SetIcon32x322x(icon32x322x io.ReadCloser) *SaveSafariWebConfOptions {
	options.Icon32x322x = icon32x322x
	return options
}

// SetIcon32x322xContentType : Allow user to set Icon32x322xContentType
func (options *SaveSafariWebConfOptions) SetIcon32x322xContentType(icon32x322xContentType string) *SaveSafariWebConfOptions {
	options.Icon32x322xContentType = core.StringPtr(icon32x322xContentType)
	return options
}

// SetIcon128x128 : Allow user to set Icon128x128
func (options *SaveSafariWebConfOptions) SetIcon128x128(icon128x128 io.ReadCloser) *SaveSafariWebConfOptions {
	options.Icon128x128 = icon128x128
	return options
}

// SetIcon128x128ContentType : Allow user to set Icon128x128ContentType
func (options *SaveSafariWebConfOptions) SetIcon128x128ContentType(icon128x128ContentType string) *SaveSafariWebConfOptions {
	options.Icon128x128ContentType = core.StringPtr(icon128x128ContentType)
	return options
}

// SetIcon128x1282x : Allow user to set Icon128x1282x
func (options *SaveSafariWebConfOptions) SetIcon128x1282x(icon128x1282x io.ReadCloser) *SaveSafariWebConfOptions {
	options.Icon128x1282x = icon128x1282x
	return options
}

// SetIcon128x1282xContentType : Allow user to set Icon128x1282xContentType
func (options *SaveSafariWebConfOptions) SetIcon128x1282xContentType(icon128x1282xContentType string) *SaveSafariWebConfOptions {
	options.Icon128x1282xContentType = core.StringPtr(icon128x1282xContentType)
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *SaveSafariWebConfOptions) SetAcceptLanguage(acceptLanguage string) *SaveSafariWebConfOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *SaveSafariWebConfOptions) SetAppSecret(appSecret string) *SaveSafariWebConfOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *SaveSafariWebConfOptions) SetHeaders(param map[string]string) *SaveSafariWebConfOptions {
	options.Headers = param
	return options
}

// SendMessageOptions : The SendMessage options.
type SendMessageOptions struct {
	// Unique ID of the application using the push service.
	ApplicationID *string `validate:"required,ne="`

	// Details of the content of the notification message.
	Message *Message `validate:"required"`

	// Additional properties that can be configured for the notification.
	Settings *Settings

	// Validate the devices.
	Validate *bool

	// An optional target for the message. Specify one of the target parameters to choose the recipients of the
	// notification. If no target is specified, a broadcast notification will be sent to all the registered devices.
	Target *Target

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewSendMessageOptions : Instantiate SendMessageOptions
func (*PushServiceV1) NewSendMessageOptions(applicationID string, message *Message) *SendMessageOptions {
	return &SendMessageOptions{
		ApplicationID: core.StringPtr(applicationID),
		Message:       message,
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *SendMessageOptions) SetApplicationID(applicationID string) *SendMessageOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetMessage : Allow user to set Message
func (options *SendMessageOptions) SetMessage(message *Message) *SendMessageOptions {
	options.Message = message
	return options
}

// SetSettings : Allow user to set Settings
func (options *SendMessageOptions) SetSettings(settings *Settings) *SendMessageOptions {
	options.Settings = settings
	return options
}

// SetValidate : Allow user to set Validate
func (options *SendMessageOptions) SetValidate(validate bool) *SendMessageOptions {
	options.Validate = core.BoolPtr(validate)
	return options
}

// SetTarget : Allow user to set Target
func (options *SendMessageOptions) SetTarget(target *Target) *SendMessageOptions {
	options.Target = target
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *SendMessageOptions) SetAcceptLanguage(acceptLanguage string) *SendMessageOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *SendMessageOptions) SetHeaders(param map[string]string) *SendMessageOptions {
	options.Headers = param
	return options
}

// SendMessagesInBulkOptions : The SendMessagesInBulk options.
type SendMessagesInBulkOptions struct {
	// Application ID.
	ApplicationID *string `validate:"required,ne="`

	Body []SendMessageBody `validate:"required"`

	// The preferred language to use for error messages.
	AcceptLanguage *string

	// Deprecated, use Authorization instead.
	AppSecret *string

	// Allows users to set headers on API requests
	Headers map[string]string
}

// NewSendMessagesInBulkOptions : Instantiate SendMessagesInBulkOptions
func (*PushServiceV1) NewSendMessagesInBulkOptions(applicationID string, body []SendMessageBody) *SendMessagesInBulkOptions {
	return &SendMessagesInBulkOptions{
		ApplicationID: core.StringPtr(applicationID),
		Body:          body,
	}
}

// SetApplicationID : Allow user to set ApplicationID
func (options *SendMessagesInBulkOptions) SetApplicationID(applicationID string) *SendMessagesInBulkOptions {
	options.ApplicationID = core.StringPtr(applicationID)
	return options
}

// SetBody : Allow user to set Body
func (options *SendMessagesInBulkOptions) SetBody(body []SendMessageBody) *SendMessagesInBulkOptions {
	options.Body = body
	return options
}

// SetAcceptLanguage : Allow user to set AcceptLanguage
func (options *SendMessagesInBulkOptions) SetAcceptLanguage(acceptLanguage string) *SendMessagesInBulkOptions {
	options.AcceptLanguage = core.StringPtr(acceptLanguage)
	return options
}

// SetAppSecret : Allow user to set AppSecret
func (options *SendMessagesInBulkOptions) SetAppSecret(appSecret string) *SendMessagesInBulkOptions {
	options.AppSecret = core.StringPtr(appSecret)
	return options
}

// SetHeaders : Allow user to set Headers
func (options *SendMessagesInBulkOptions) SetHeaders(param map[string]string) *SendMessagesInBulkOptions {
	options.Headers = param
	return options
}

// Settings : Additional properties that can be configured for the notification.
type Settings struct {
	// Settings specific to iOS platform.
	Apns *Apns `json:"apns,omitempty"`

	// Settings specific to Android platform.
	Gcm *Gcm `json:"gcm,omitempty"`

	// Web Push Notifications settings specific to Mozilla Firefox browser platforms.
	FirefoxWeb *FirefoxWeb `json:"firefoxWeb,omitempty"`

	// Web Push Notifications settings specific to Chrome  browser.
	ChromeWeb *ChromeWeb `json:"chromeWeb,omitempty"`

	// Web Push Notifications settings specific to Safari  browser.
	SafariWeb *SafariWeb `json:"safariWeb,omitempty"`

	// Web Push Notifications settings specific to Chrome  browser.
	ChromeAppExt *ChromeAppExt `json:"chromeAppExt,omitempty"`
}

// UnmarshalSettings unmarshals an instance of Settings from the specified map of raw messages.
func UnmarshalSettings(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(Settings)
	err = core.UnmarshalModel(m, "apns", &obj.Apns, UnmarshalApns)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(m, "gcm", &obj.Gcm, UnmarshalGcm)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(m, "firefoxWeb", &obj.FirefoxWeb, UnmarshalFirefoxWeb)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(m, "chromeWeb", &obj.ChromeWeb, UnmarshalChromeWeb)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(m, "safariWeb", &obj.SafariWeb, UnmarshalSafariWeb)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(m, "chromeAppExt", &obj.ChromeAppExt, UnmarshalChromeAppExt)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// Style : Options to specify for Android expandable notifications. The types of expandable notifications are
// picture_notification, bigtext_notification, inbox_notification.
type Style struct {
	// Specifies the type of expandable notifications.  The possible values are bigtext_notification, picture_notification,
	// inbox_notification.
	Type *string `json:"type,omitempty"`

	// Specifies the title of the notification.  The title is displayed when the notification is expanded.  Title must be
	// specified for all three expandable notification.
	Title *string `json:"title,omitempty"`

	// An URL from which the picture has to be obtained for the notification.  Must be specified for picture_notification.
	URL *string `json:"url,omitempty"`

	// The big text that needs to be displayed on expanding a bigtext_notification.  Must be specified for
	// bigtext_notification.
	Text *string `json:"text,omitempty"`

	// An array of strings that is to be displayed in inbox style for inbox_notification.  Must be specified for
	// inbox_notification.
	Lines []string `json:"lines,omitempty"`
}

// UnmarshalStyle unmarshals an instance of Style from the specified map of raw messages.
func UnmarshalStyle(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(Style)
	err = core.UnmarshalPrimitive(m, "type", &obj.Type)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "title", &obj.Title)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "url", &obj.URL)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "text", &obj.Text)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "lines", &obj.Lines)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// Target : An optional target for the message. Specify one of the target parameters to choose the recipients of the
// notification. If no target is specified, a broadcast notification will be sent to all the registered devices.
type Target struct {
	// Send notification to the list of specified devices.
	DeviceIds []string `json:"deviceIds,omitempty"`

	// Send notification to the specified userIds.
	UserIds []string `json:"userIds,omitempty"`

	// Send notification to the devices of the specified platforms. 'A' for apple (iOS) devices, 'G' for google (Android)
	// devices, 'WEB_CHROME' for Chrome Web Browsers, 'WEB_FIREFOX' for Firefox Web Browsers, 'WEB_SAFARI' for Safari Push
	// Notifications and 'APPEXT_CHROME' for Chrome App Extension.
	Platforms []string `json:"platforms,omitempty"`

	// Send notification to the devices that have subscribed to any of
	//   these tags.
	TagNames []string `json:"tagNames,omitempty"`
}

// UnmarshalTarget unmarshals an instance of Target from the specified map of raw messages.
func UnmarshalTarget(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(Target)
	err = core.UnmarshalPrimitive(m, "deviceIds", &obj.DeviceIds)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "userIds", &obj.UserIds)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "platforms", &obj.Platforms)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "tagNames", &obj.TagNames)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// ApnsCertUploadResponse : ApnsCertUploadResponse struct
type ApnsCertUploadResponse struct {
	// The APNS certificate file name.
	Certificate *string `json:"certificate,omitempty"`

	// Certificate type.
	IsSandBox *bool `json:"isSandBox,omitempty"`

	// The date until which the certificate is valid.
	ValidUntil *string `json:"validUntil,omitempty"`
}

// UnmarshalApnsCertUploadResponse unmarshals an instance of ApnsCertUploadResponse from the specified map of raw messages.
func UnmarshalApnsCertUploadResponse(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(ApnsCertUploadResponse)
	err = core.UnmarshalPrimitive(m, "certificate", &obj.Certificate)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "isSandBox", &obj.IsSandBox)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "validUntil", &obj.ValidUntil)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// AppSettingsObjResponse : AppSettingsObjResponse struct
type AppSettingsObjResponse struct {
	// The link to the APNS configuration.
	ApnsConf *string `json:"apnsConf,omitempty"`

	// The link to the GCM configuration.
	GcmConf *string `json:"gcmConf,omitempty"`

	// The link to the Chrome webpush configuration.
	ChromeWebConf *string `json:"chromeWebConf,omitempty"`

	// The link to the Safari Push configuration.
	SafariWebConf *string `json:"safariWebConf,omitempty"`

	// The link to the Firefox webpush configuration.
	FirefoxWebConf *string `json:"firefoxWebConf,omitempty"`
}

// UnmarshalAppSettingsObjResponse unmarshals an instance of AppSettingsObjResponse from the specified map of raw messages.
func UnmarshalAppSettingsObjResponse(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(AppSettingsObjResponse)
	err = core.UnmarshalPrimitive(m, "apnsConf", &obj.ApnsConf)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "gcmConf", &obj.GcmConf)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "chromeWebConf", &obj.ChromeWebConf)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "safariWebConf", &obj.SafariWebConf)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "firefoxWebConf", &obj.FirefoxWebConf)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// SafariCertUploadResponse : SafariCertUploadResponse struct
type SafariCertUploadResponse struct {
	// The APNS certificate file name.
	Certificate *string `json:"certificate,omitempty"`

	// The website name. This is the heading used in Notification Center.
	WebsiteName *string `json:"websiteName,omitempty"`

	// The URL to go when the notification is clicked.
	UrlFormatString *string `json:"urlFormatString,omitempty"`

	// Unique reverse-domain string for your Website Push ID.
	WebsitePushID interface{} `json:"websitePushID,omitempty"`

	// The URL of the website that should be permitted to subscribe to Safari Push Notifications.
	WebSiteURL interface{} `json:"webSiteUrl,omitempty"`
}

// UnmarshalSafariCertUploadResponse unmarshals an instance of SafariCertUploadResponse from the specified map of raw messages.
func UnmarshalSafariCertUploadResponse(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(SafariCertUploadResponse)
	err = core.UnmarshalPrimitive(m, "certificate", &obj.Certificate)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "websiteName", &obj.WebsiteName)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "urlFormatString", &obj.UrlFormatString)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "websitePushID", &obj.WebsitePushID)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "webSiteUrl", &obj.WebSiteURL)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}

// SendMessageBody : SendMessageBody struct
type SendMessageBody struct {
	// Details of the content of the notification message.
	Message *Message `json:"message" validate:"required"`

	// Additional properties that can be configured for the notification.
	Settings *Settings `json:"settings,omitempty"`

	// Validate the devices.
	Validate *bool `json:"validate,omitempty"`

	// An optional target for the message. Specify one of the target parameters to choose the recipients of the
	// notification. If no target is specified, a broadcast notification will be sent to all the registered devices.
	Target *Target `json:"target,omitempty"`
}

// NewSendMessageBody : Instantiate SendMessageBody (Generic Model Constructor)
func (*PushServiceV1) NewSendMessageBody(message *Message) (model *SendMessageBody, err error) {
	model = &SendMessageBody{
		Message: message,
	}
	err = core.ValidateStruct(model, "required parameters")
	return
}

// UnmarshalSendMessageBody unmarshals an instance of SendMessageBody from the specified map of raw messages.
func UnmarshalSendMessageBody(m map[string]json.RawMessage, result interface{}) (err error) {
	obj := new(SendMessageBody)
	err = core.UnmarshalModel(m, "message", &obj.Message, UnmarshalMessage)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(m, "settings", &obj.Settings, UnmarshalSettings)
	if err != nil {
		return
	}
	err = core.UnmarshalPrimitive(m, "validate", &obj.Validate)
	if err != nil {
		return
	}
	err = core.UnmarshalModel(m, "target", &obj.Target, UnmarshalTarget)
	if err != nil {
		return
	}
	reflect.ValueOf(result).Elem().Set(reflect.ValueOf(obj))
	return
}
