// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SAPProfile s a p profile
// swagger:model SAPProfile
type SAPProfile struct {

	// Has certification been performed on profile
	// Required: true
	Certified *bool `json:"certified"`

	// Amount of cores
	// Required: true
	Cores *int64 `json:"cores"`

	// Amount of memory (in GB)
	// Required: true
	Memory *int64 `json:"memory"`

	// SAP Profile ID
	// Required: true
	ProfileID *string `json:"profileID"`

	// Type of profile
	// Required: true
	// Enum: [balanced compute memory non-production ultra-memory]
	Type *string `json:"type"`
}

// Validate validates this s a p profile
func (m *SAPProfile) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCertified(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCores(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMemory(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProfileID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SAPProfile) validateCertified(formats strfmt.Registry) error {

	if err := validate.Required("certified", "body", m.Certified); err != nil {
		return err
	}

	return nil
}

func (m *SAPProfile) validateCores(formats strfmt.Registry) error {

	if err := validate.Required("cores", "body", m.Cores); err != nil {
		return err
	}

	return nil
}

func (m *SAPProfile) validateMemory(formats strfmt.Registry) error {

	if err := validate.Required("memory", "body", m.Memory); err != nil {
		return err
	}

	return nil
}

func (m *SAPProfile) validateProfileID(formats strfmt.Registry) error {

	if err := validate.Required("profileID", "body", m.ProfileID); err != nil {
		return err
	}

	return nil
}

var sAPProfileTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["balanced","compute","memory","non-production","ultra-memory"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		sAPProfileTypeTypePropEnum = append(sAPProfileTypeTypePropEnum, v)
	}
}

const (

	// SAPProfileTypeBalanced captures enum value "balanced"
	SAPProfileTypeBalanced string = "balanced"

	// SAPProfileTypeCompute captures enum value "compute"
	SAPProfileTypeCompute string = "compute"

	// SAPProfileTypeMemory captures enum value "memory"
	SAPProfileTypeMemory string = "memory"

	// SAPProfileTypeNonProduction captures enum value "non-production"
	SAPProfileTypeNonProduction string = "non-production"

	// SAPProfileTypeUltraMemory captures enum value "ultra-memory"
	SAPProfileTypeUltraMemory string = "ultra-memory"
)

// prop value enum
func (m *SAPProfile) validateTypeEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, sAPProfileTypeTypePropEnum); err != nil {
		return err
	}
	return nil
}

func (m *SAPProfile) validateType(formats strfmt.Registry) error {

	if err := validate.Required("type", "body", m.Type); err != nil {
		return err
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SAPProfile) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SAPProfile) UnmarshalBinary(b []byte) error {
	var res SAPProfile
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
