// Code generated by go-swagger; DO NOT EDIT.

package p_cloud_tenants

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/IBM-Cloud/power-go-client/power/models"
)

// NewPcloudTenantsPutParams creates a new PcloudTenantsPutParams object
// with the default values initialized.
func NewPcloudTenantsPutParams() *PcloudTenantsPutParams {
	var ()
	return &PcloudTenantsPutParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewPcloudTenantsPutParamsWithTimeout creates a new PcloudTenantsPutParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewPcloudTenantsPutParamsWithTimeout(timeout time.Duration) *PcloudTenantsPutParams {
	var ()
	return &PcloudTenantsPutParams{

		timeout: timeout,
	}
}

// NewPcloudTenantsPutParamsWithContext creates a new PcloudTenantsPutParams object
// with the default values initialized, and the ability to set a context for a request
func NewPcloudTenantsPutParamsWithContext(ctx context.Context) *PcloudTenantsPutParams {
	var ()
	return &PcloudTenantsPutParams{

		Context: ctx,
	}
}

// NewPcloudTenantsPutParamsWithHTTPClient creates a new PcloudTenantsPutParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewPcloudTenantsPutParamsWithHTTPClient(client *http.Client) *PcloudTenantsPutParams {
	var ()
	return &PcloudTenantsPutParams{
		HTTPClient: client,
	}
}

/*PcloudTenantsPutParams contains all the parameters to send to the API endpoint
for the pcloud tenants put operation typically these are written to a http.Request
*/
type PcloudTenantsPutParams struct {

	/*Body
	  Parameters for updating a Tenant

	*/
	Body *models.TenantUpdate
	/*TenantID
	  Tenant ID of a pcloud tenant

	*/
	TenantID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the pcloud tenants put params
func (o *PcloudTenantsPutParams) WithTimeout(timeout time.Duration) *PcloudTenantsPutParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the pcloud tenants put params
func (o *PcloudTenantsPutParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the pcloud tenants put params
func (o *PcloudTenantsPutParams) WithContext(ctx context.Context) *PcloudTenantsPutParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the pcloud tenants put params
func (o *PcloudTenantsPutParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the pcloud tenants put params
func (o *PcloudTenantsPutParams) WithHTTPClient(client *http.Client) *PcloudTenantsPutParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the pcloud tenants put params
func (o *PcloudTenantsPutParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the pcloud tenants put params
func (o *PcloudTenantsPutParams) WithBody(body *models.TenantUpdate) *PcloudTenantsPutParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the pcloud tenants put params
func (o *PcloudTenantsPutParams) SetBody(body *models.TenantUpdate) {
	o.Body = body
}

// WithTenantID adds the tenantID to the pcloud tenants put params
func (o *PcloudTenantsPutParams) WithTenantID(tenantID string) *PcloudTenantsPutParams {
	o.SetTenantID(tenantID)
	return o
}

// SetTenantID adds the tenantId to the pcloud tenants put params
func (o *PcloudTenantsPutParams) SetTenantID(tenantID string) {
	o.TenantID = tenantID
}

// WriteToRequest writes these params to a swagger request
func (o *PcloudTenantsPutParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param tenant_id
	if err := r.SetPathParam("tenant_id", o.TenantID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
