// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transfer

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateServer = "CreateServer"

// CreateServerRequest generates a "aws/request.Request" representing the
// client's request for the CreateServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateServer for more information on using the CreateServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateServerRequest method.
//    req, resp := client.CreateServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateServer
func (c *Transfer) CreateServerRequest(input *CreateServerInput) (req *request.Request, output *CreateServerOutput) {
	op := &request.Operation{
		Name:       opCreateServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServerInput{}
	}

	output = &CreateServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateServer API operation for AWS Transfer Family.
//
// Instantiates an autoscaling virtual server based on the selected file transfer
// protocol in AWS. When you make updates to your file transfer protocol-enabled
// server or when you work with users, use the service-generated ServerId property
// that is assigned to the newly created server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation CreateServer for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceExistsException
//   The requested resource does not exist.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateServer
func (c *Transfer) CreateServer(input *CreateServerInput) (*CreateServerOutput, error) {
	req, out := c.CreateServerRequest(input)
	return out, req.Send()
}

// CreateServerWithContext is the same as CreateServer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) CreateServerWithContext(ctx aws.Context, input *CreateServerInput, opts ...request.Option) (*CreateServerOutput, error) {
	req, out := c.CreateServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserRequest method.
//    req, resp := client.CreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateUser
func (c *Transfer) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUser API operation for AWS Transfer Family.
//
// Creates a user and associates them with an existing file transfer protocol-enabled
// server. You can only create and associate users with servers that have the
// IdentityProviderType set to SERVICE_MANAGED. Using parameters for CreateUser,
// you can specify the user name, set the home directory, store the user's public
// key, and assign the user's AWS Identity and Access Management (IAM) role.
// You can also optionally add a scope-down policy, and assign metadata with
// tags that can be used to group and search for users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation CreateUser for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceExistsException
//   The requested resource does not exist.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the AWS Transfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateUser
func (c *Transfer) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) CreateUserWithContext(ctx aws.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteServer = "DeleteServer"

// DeleteServerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteServer for more information on using the DeleteServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteServerRequest method.
//    req, resp := client.DeleteServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteServer
func (c *Transfer) DeleteServerRequest(input *DeleteServerInput) (req *request.Request, output *DeleteServerOutput) {
	op := &request.Operation{
		Name:       opDeleteServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServerInput{}
	}

	output = &DeleteServerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteServer API operation for AWS Transfer Family.
//
// Deletes the file transfer protocol-enabled server that you specify.
//
// No response returns from this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation DeleteServer for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the AWS Transfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteServer
func (c *Transfer) DeleteServer(input *DeleteServerInput) (*DeleteServerOutput, error) {
	req, out := c.DeleteServerRequest(input)
	return out, req.Send()
}

// DeleteServerWithContext is the same as DeleteServer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DeleteServerWithContext(ctx aws.Context, input *DeleteServerInput, opts ...request.Option) (*DeleteServerOutput, error) {
	req, out := c.DeleteServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSshPublicKey = "DeleteSshPublicKey"

// DeleteSshPublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSshPublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSshPublicKey for more information on using the DeleteSshPublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSshPublicKeyRequest method.
//    req, resp := client.DeleteSshPublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteSshPublicKey
func (c *Transfer) DeleteSshPublicKeyRequest(input *DeleteSshPublicKeyInput) (req *request.Request, output *DeleteSshPublicKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteSshPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSshPublicKeyInput{}
	}

	output = &DeleteSshPublicKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSshPublicKey API operation for AWS Transfer Family.
//
// Deletes a user's Secure Shell (SSH) public key.
//
// No response is returned from this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation DeleteSshPublicKey for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the AWS Transfer
//   Family service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteSshPublicKey
func (c *Transfer) DeleteSshPublicKey(input *DeleteSshPublicKeyInput) (*DeleteSshPublicKeyOutput, error) {
	req, out := c.DeleteSshPublicKeyRequest(input)
	return out, req.Send()
}

// DeleteSshPublicKeyWithContext is the same as DeleteSshPublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSshPublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DeleteSshPublicKeyWithContext(ctx aws.Context, input *DeleteSshPublicKeyInput, opts ...request.Option) (*DeleteSshPublicKeyOutput, error) {
	req, out := c.DeleteSshPublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteUser
func (c *Transfer) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUser API operation for AWS Transfer Family.
//
// Deletes the user belonging to a file transfer protocol-enabled server you
// specify.
//
// No response returns from this operation.
//
// When you delete a user from a server, the user's information is lost.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation DeleteUser for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the AWS Transfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteUser
func (c *Transfer) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeServer = "DescribeServer"

// DescribeServerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeServer for more information on using the DescribeServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeServerRequest method.
//    req, resp := client.DescribeServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeServer
func (c *Transfer) DescribeServerRequest(input *DescribeServerInput) (req *request.Request, output *DescribeServerOutput) {
	op := &request.Operation{
		Name:       opDescribeServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServerInput{}
	}

	output = &DescribeServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeServer API operation for AWS Transfer Family.
//
// Describes a file transfer protocol-enabled server that you specify by passing
// the ServerId parameter.
//
// The response contains a description of a server's properties. When you set
// EndpointType to VPC, the response will contain the EndpointDetails.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation DescribeServer for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the AWS Transfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeServer
func (c *Transfer) DescribeServer(input *DescribeServerInput) (*DescribeServerOutput, error) {
	req, out := c.DescribeServerRequest(input)
	return out, req.Send()
}

// DescribeServerWithContext is the same as DescribeServer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DescribeServerWithContext(ctx aws.Context, input *DescribeServerInput, opts ...request.Option) (*DescribeServerOutput, error) {
	req, out := c.DescribeServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUser = "DescribeUser"

// DescribeUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUser for more information on using the DescribeUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserRequest method.
//    req, resp := client.DescribeUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeUser
func (c *Transfer) DescribeUserRequest(input *DescribeUserInput) (req *request.Request, output *DescribeUserOutput) {
	op := &request.Operation{
		Name:       opDescribeUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserInput{}
	}

	output = &DescribeUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUser API operation for AWS Transfer Family.
//
// Describes the user assigned to the specific file transfer protocol-enabled
// server, as identified by its ServerId property.
//
// The response from this call returns the properties of the user associated
// with the ServerId value that was specified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation DescribeUser for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the AWS Transfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeUser
func (c *Transfer) DescribeUser(input *DescribeUserInput) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	return out, req.Send()
}

// DescribeUserWithContext is the same as DescribeUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DescribeUserWithContext(ctx aws.Context, input *DescribeUserInput, opts ...request.Option) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportSshPublicKey = "ImportSshPublicKey"

// ImportSshPublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the ImportSshPublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportSshPublicKey for more information on using the ImportSshPublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportSshPublicKeyRequest method.
//    req, resp := client.ImportSshPublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ImportSshPublicKey
func (c *Transfer) ImportSshPublicKeyRequest(input *ImportSshPublicKeyInput) (req *request.Request, output *ImportSshPublicKeyOutput) {
	op := &request.Operation{
		Name:       opImportSshPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportSshPublicKeyInput{}
	}

	output = &ImportSshPublicKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportSshPublicKey API operation for AWS Transfer Family.
//
// Adds a Secure Shell (SSH) public key to a user account identified by a UserName
// value assigned to the specific file transfer protocol-enabled server, identified
// by ServerId.
//
// The response returns the UserName value, the ServerId value, and the name
// of the SshPublicKeyId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation ImportSshPublicKey for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceExistsException
//   The requested resource does not exist.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the AWS Transfer
//   Family service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ImportSshPublicKey
func (c *Transfer) ImportSshPublicKey(input *ImportSshPublicKeyInput) (*ImportSshPublicKeyOutput, error) {
	req, out := c.ImportSshPublicKeyRequest(input)
	return out, req.Send()
}

// ImportSshPublicKeyWithContext is the same as ImportSshPublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See ImportSshPublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ImportSshPublicKeyWithContext(ctx aws.Context, input *ImportSshPublicKeyInput, opts ...request.Option) (*ImportSshPublicKeyOutput, error) {
	req, out := c.ImportSshPublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListServers = "ListServers"

// ListServersRequest generates a "aws/request.Request" representing the
// client's request for the ListServers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServers for more information on using the ListServers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListServersRequest method.
//    req, resp := client.ListServersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers
func (c *Transfer) ListServersRequest(input *ListServersInput) (req *request.Request, output *ListServersOutput) {
	op := &request.Operation{
		Name:       opListServers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServersInput{}
	}

	output = &ListServersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServers API operation for AWS Transfer Family.
//
// Lists the file transfer protocol-enabled servers that are associated with
// your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation ListServers for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidNextTokenException
//   The NextToken parameter that was passed is invalid.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers
func (c *Transfer) ListServers(input *ListServersInput) (*ListServersOutput, error) {
	req, out := c.ListServersRequest(input)
	return out, req.Send()
}

// ListServersWithContext is the same as ListServers with the addition of
// the ability to pass a context and additional request options.
//
// See ListServers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListServersWithContext(ctx aws.Context, input *ListServersInput, opts ...request.Option) (*ListServersOutput, error) {
	req, out := c.ListServersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServersPages iterates over the pages of a ListServers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListServers operation.
//    pageNum := 0
//    err := client.ListServersPages(params,
//        func(page *transfer.ListServersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Transfer) ListServersPages(input *ListServersInput, fn func(*ListServersOutput, bool) bool) error {
	return c.ListServersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServersPagesWithContext same as ListServersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListServersPagesWithContext(ctx aws.Context, input *ListServersInput, fn func(*ListServersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListTagsForResource
func (c *Transfer) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Transfer Family.
//
// Lists all of the tags associated with the Amazon Resource Number (ARN) you
// specify. The resource can be a user, server, or role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidNextTokenException
//   The NextToken parameter that was passed is invalid.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListTagsForResource
func (c *Transfer) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTagsForResource operation.
//    pageNum := 0
//    err := client.ListTagsForResourcePages(params,
//        func(page *transfer.ListTagsForResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Transfer) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListUsers
func (c *Transfer) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for AWS Transfer Family.
//
// Lists the users for a file transfer protocol-enabled server that you specify
// by passing the ServerId parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation ListUsers for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidNextTokenException
//   The NextToken parameter that was passed is invalid.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the AWS Transfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListUsers
func (c *Transfer) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUsersPages iterates over the pages of a ListUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUsers operation.
//    pageNum := 0
//    err := client.ListUsersPages(params,
//        func(page *transfer.ListUsersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Transfer) ListUsersPages(input *ListUsersInput, fn func(*ListUsersOutput, bool) bool) error {
	return c.ListUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUsersPagesWithContext same as ListUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListUsersPagesWithContext(ctx aws.Context, input *ListUsersInput, fn func(*ListUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUsersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartServer = "StartServer"

// StartServerRequest generates a "aws/request.Request" representing the
// client's request for the StartServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartServer for more information on using the StartServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartServerRequest method.
//    req, resp := client.StartServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StartServer
func (c *Transfer) StartServerRequest(input *StartServerInput) (req *request.Request, output *StartServerOutput) {
	op := &request.Operation{
		Name:       opStartServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartServerInput{}
	}

	output = &StartServerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartServer API operation for AWS Transfer Family.
//
// Changes the state of a file transfer protocol-enabled server from OFFLINE
// to ONLINE. It has no impact on a server that is already ONLINE. An ONLINE
// server can accept and process file transfer jobs.
//
// The state of STARTING indicates that the server is in an intermediate state,
// either not fully able to respond, or not fully online. The values of START_FAILED
// can indicate an error condition.
//
// No response is returned from this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation StartServer for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the AWS Transfer
//   Family service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StartServer
func (c *Transfer) StartServer(input *StartServerInput) (*StartServerOutput, error) {
	req, out := c.StartServerRequest(input)
	return out, req.Send()
}

// StartServerWithContext is the same as StartServer with the addition of
// the ability to pass a context and additional request options.
//
// See StartServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) StartServerWithContext(ctx aws.Context, input *StartServerInput, opts ...request.Option) (*StartServerOutput, error) {
	req, out := c.StartServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopServer = "StopServer"

// StopServerRequest generates a "aws/request.Request" representing the
// client's request for the StopServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopServer for more information on using the StopServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopServerRequest method.
//    req, resp := client.StopServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StopServer
func (c *Transfer) StopServerRequest(input *StopServerInput) (req *request.Request, output *StopServerOutput) {
	op := &request.Operation{
		Name:       opStopServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopServerInput{}
	}

	output = &StopServerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopServer API operation for AWS Transfer Family.
//
// Changes the state of a file transfer protocol-enabled server from ONLINE
// to OFFLINE. An OFFLINE server cannot accept and process file transfer jobs.
// Information tied to your server, such as server and user properties, are
// not affected by stopping your server. Stopping the server will not reduce
// or impact your file transfer protocol endpoint billing.
//
// The state of STOPPING indicates that the server is in an intermediate state,
// either not fully able to respond, or not fully offline. The values of STOP_FAILED
// can indicate an error condition.
//
// No response is returned from this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation StopServer for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the AWS Transfer
//   Family service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StopServer
func (c *Transfer) StopServer(input *StopServerInput) (*StopServerOutput, error) {
	req, out := c.StopServerRequest(input)
	return out, req.Send()
}

// StopServerWithContext is the same as StopServer with the addition of
// the ability to pass a context and additional request options.
//
// See StopServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) StopServerWithContext(ctx aws.Context, input *StopServerInput, opts ...request.Option) (*StopServerOutput, error) {
	req, out := c.StopServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TagResource
func (c *Transfer) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Transfer Family.
//
// Attaches a key-value pair to a resource, as identified by its Amazon Resource
// Name (ARN). Resources are users, servers, roles, and other entities.
//
// There is no response returned from this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the AWS Transfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TagResource
func (c *Transfer) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestIdentityProvider = "TestIdentityProvider"

// TestIdentityProviderRequest generates a "aws/request.Request" representing the
// client's request for the TestIdentityProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestIdentityProvider for more information on using the TestIdentityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestIdentityProviderRequest method.
//    req, resp := client.TestIdentityProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TestIdentityProvider
func (c *Transfer) TestIdentityProviderRequest(input *TestIdentityProviderInput) (req *request.Request, output *TestIdentityProviderOutput) {
	op := &request.Operation{
		Name:       opTestIdentityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestIdentityProviderInput{}
	}

	output = &TestIdentityProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestIdentityProvider API operation for AWS Transfer Family.
//
// If the IdentityProviderType of a file transfer protocol-enabled server is
// API_Gateway, tests whether your API Gateway is set up successfully. We highly
// recommend that you call this operation to test your authentication method
// as soon as you create your server. By doing so, you can troubleshoot issues
// with the API Gateway integration to ensure that your users can successfully
// use the service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation TestIdentityProvider for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the AWS Transfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TestIdentityProvider
func (c *Transfer) TestIdentityProvider(input *TestIdentityProviderInput) (*TestIdentityProviderOutput, error) {
	req, out := c.TestIdentityProviderRequest(input)
	return out, req.Send()
}

// TestIdentityProviderWithContext is the same as TestIdentityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See TestIdentityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) TestIdentityProviderWithContext(ctx aws.Context, input *TestIdentityProviderInput, opts ...request.Option) (*TestIdentityProviderOutput, error) {
	req, out := c.TestIdentityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UntagResource
func (c *Transfer) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Transfer Family.
//
// Detaches a key-value pair from a resource, as identified by its Amazon Resource
// Name (ARN). Resources are users, servers, roles, and other entities.
//
// No response is returned from this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the AWS Transfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UntagResource
func (c *Transfer) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServer = "UpdateServer"

// UpdateServerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServer for more information on using the UpdateServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateServerRequest method.
//    req, resp := client.UpdateServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateServer
func (c *Transfer) UpdateServerRequest(input *UpdateServerInput) (req *request.Request, output *UpdateServerOutput) {
	op := &request.Operation{
		Name:       opUpdateServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServerInput{}
	}

	output = &UpdateServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateServer API operation for AWS Transfer Family.
//
// Updates the file transfer protocol-enabled server's properties after that
// server has been created.
//
// The UpdateServer call returns the ServerId of the server you updated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation UpdateServer for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * ConflictException
//   This exception is thrown when the UpdatServer is called for a file transfer
//   protocol-enabled server that has VPC as the endpoint type and the server's
//   VpcEndpointID is not in the available state.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceExistsException
//   The requested resource does not exist.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the AWS Transfer
//   Family service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateServer
func (c *Transfer) UpdateServer(input *UpdateServerInput) (*UpdateServerOutput, error) {
	req, out := c.UpdateServerRequest(input)
	return out, req.Send()
}

// UpdateServerWithContext is the same as UpdateServer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) UpdateServerWithContext(ctx aws.Context, input *UpdateServerInput, opts ...request.Option) (*UpdateServerOutput, error) {
	req, out := c.UpdateServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUser for more information on using the UpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserRequest method.
//    req, resp := client.UpdateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateUser
func (c *Transfer) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUser API operation for AWS Transfer Family.
//
// Assigns new properties to a user. Parameters you pass modify any or all of
// the following: the home directory, role, and policy for the UserName and
// ServerId you specify.
//
// The response returns the ServerId and the UserName for the updated user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation UpdateUser for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the AWS Transfer Family service is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the AWS Transfer Family
//   service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the AWS Transfer
//   Family service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateUser
func (c *Transfer) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	return out, req.Send()
}

// UpdateUserWithContext is the same as UpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) UpdateUserWithContext(ctx aws.Context, input *UpdateUserInput, opts ...request.Option) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the UpdatServer is called for a file transfer
// protocol-enabled server that has VPC as the endpoint type and the server's
// VpcEndpointID is not in the available state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateServerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate.
	// Required when Protocols is set to FTPS.
	//
	// To request a new public certificate, see Request a public certificate (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html)
	// in the AWS Certificate Manager User Guide.
	//
	// To import an existing certificate into ACM, see Importing certificates into
	// ACM (https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html)
	// in the AWS Certificate Manager User Guide.
	//
	// To request a private certificate to use FTPS through private IP addresses,
	// see Request a private certificate (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html)
	// in the AWS Certificate Manager User Guide.
	//
	// Certificates with the following cryptographic algorithms and key sizes are
	// supported:
	//
	//    * 2048-bit RSA (RSA_2048)
	//
	//    * 4096-bit RSA (RSA_4096)
	//
	//    * Elliptic Prime Curve 256 bit (EC_prime256v1)
	//
	//    * Elliptic Prime Curve 384 bit (EC_secp384r1)
	//
	//    * Elliptic Prime Curve 521 bit (EC_secp521r1)
	//
	// The certificate must be a valid SSL/TLS X.509 version 3 certificate with
	// FQDN or IP address specified and information about the issuer.
	Certificate *string `type:"string"`

	// The virtual private cloud (VPC) endpoint settings that are configured for
	// your file transfer protocol-enabled server. When you host your endpoint within
	// your VPC, you can make it accessible only to resources within your VPC, or
	// you can attach Elastic IPs and make it accessible to clients over the internet.
	// Your VPC's default security groups are automatically assigned to your endpoint.
	EndpointDetails *EndpointDetails `type:"structure"`

	// The type of VPC endpoint that you want your file transfer protocol-enabled
	// server to connect to. You can choose to connect to the public internet or
	// a VPC endpoint. With a VPC endpoint, you can restrict access to your server
	// and resources only within your VPC.
	//
	// It is recommended that you use VPC as the EndpointType. With this endpoint
	// type, you have the option to directly associate up to three Elastic IPv4
	// addresses (BYO IP included) with your server's endpoint and use VPC security
	// groups to restrict traffic by the client's public IP address. This is not
	// possible with EndpointType set to VPC_ENDPOINT.
	EndpointType *string `type:"string" enum:"EndpointType"`

	// The RSA private key as generated by the ssh-keygen -N "" -m PEM -f my-new-server-key
	// command.
	//
	// If you aren't planning to migrate existing users from an existing SFTP-enabled
	// server to a new server, don't update the host key. Accidentally changing
	// a server's host key can be disruptive.
	//
	// For more information, see Change the host key for your SFTP-enabled server
	// (https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key)
	// in the AWS Transfer Family User Guide.
	HostKey *string `type:"string" sensitive:"true"`

	// Required when IdentityProviderType is set to API_GATEWAY. Accepts an array
	// containing all of the information required to call a customer-supplied authentication
	// API, including the API Gateway URL. Not required when IdentityProviderType
	// is set to SERVICE_MANAGED.
	IdentityProviderDetails *IdentityProviderDetails `type:"structure"`

	// Specifies the mode of authentication for a file transfer protocol-enabled
	// server. The default value is SERVICE_MANAGED, which allows you to store and
	// access user credentials within the AWS Transfer Family service. Use the API_GATEWAY
	// value to integrate with an identity provider of your choosing. The API_GATEWAY
	// setting requires you to provide an API Gateway endpoint URL to call for authentication
	// using the IdentityProviderDetails parameter.
	IdentityProviderType *string `type:"string" enum:"IdentityProviderType"`

	// Allows the service to write your users' activity to your Amazon CloudWatch
	// logs for monitoring and auditing purposes.
	LoggingRole *string `min:"20" type:"string"`

	// Specifies the file transfer protocol or protocols over which your file transfer
	// protocol client can connect to your server's endpoint. The available protocols
	// are:
	//
	//    * SFTP (Secure Shell (SSH) File Transfer Protocol): File transfer over
	//    SSH
	//
	//    * FTPS (File Transfer Protocol Secure): File transfer with TLS encryption
	//
	//    * FTP (File Transfer Protocol): Unencrypted file transfer
	//
	// If you select FTPS, you must choose a certificate stored in AWS Certificate
	// Manager (ACM) which will be used to identify your server when clients connect
	// to it over FTPS.
	//
	// If Protocol includes either FTP or FTPS, then the EndpointType must be VPC
	// and the IdentityProviderType must be API_GATEWAY.
	//
	// If Protocol includes FTP, then AddressAllocationIds cannot be associated.
	//
	// If Protocol is set only to SFTP, the EndpointType can be set to PUBLIC and
	// the IdentityProviderType can be set to SERVICE_MANAGED.
	Protocols []*string `min:"1" type:"list"`

	// Key-value pairs that can be used to group and search for file transfer protocol-enabled
	// servers.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServerInput"}
	if s.LoggingRole != nil && len(*s.LoggingRole) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("LoggingRole", 20))
	}
	if s.Protocols != nil && len(s.Protocols) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Protocols", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.EndpointDetails != nil {
		if err := s.EndpointDetails.Validate(); err != nil {
			invalidParams.AddNested("EndpointDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.IdentityProviderDetails != nil {
		if err := s.IdentityProviderDetails.Validate(); err != nil {
			invalidParams.AddNested("IdentityProviderDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificate sets the Certificate field's value.
func (s *CreateServerInput) SetCertificate(v string) *CreateServerInput {
	s.Certificate = &v
	return s
}

// SetEndpointDetails sets the EndpointDetails field's value.
func (s *CreateServerInput) SetEndpointDetails(v *EndpointDetails) *CreateServerInput {
	s.EndpointDetails = v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *CreateServerInput) SetEndpointType(v string) *CreateServerInput {
	s.EndpointType = &v
	return s
}

// SetHostKey sets the HostKey field's value.
func (s *CreateServerInput) SetHostKey(v string) *CreateServerInput {
	s.HostKey = &v
	return s
}

// SetIdentityProviderDetails sets the IdentityProviderDetails field's value.
func (s *CreateServerInput) SetIdentityProviderDetails(v *IdentityProviderDetails) *CreateServerInput {
	s.IdentityProviderDetails = v
	return s
}

// SetIdentityProviderType sets the IdentityProviderType field's value.
func (s *CreateServerInput) SetIdentityProviderType(v string) *CreateServerInput {
	s.IdentityProviderType = &v
	return s
}

// SetLoggingRole sets the LoggingRole field's value.
func (s *CreateServerInput) SetLoggingRole(v string) *CreateServerInput {
	s.LoggingRole = &v
	return s
}

// SetProtocols sets the Protocols field's value.
func (s *CreateServerInput) SetProtocols(v []*string) *CreateServerInput {
	s.Protocols = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServerInput) SetTags(v []*Tag) *CreateServerInput {
	s.Tags = v
	return s
}

type CreateServerOutput struct {
	_ struct{} `type:"structure"`

	// The service-assigned ID of the file transfer protocol-enabled server that
	// is created.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServerOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *CreateServerOutput) SetServerId(v string) *CreateServerOutput {
	s.ServerId = &v
	return s
}

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// The landing directory (folder) for a user when they log in to the file transfer
	// protocol-enabled server using the client.
	//
	// An example is your-Amazon-S3-bucket-name>/home/username .
	HomeDirectory *string `type:"string"`

	// Logical directory mappings that specify what Amazon S3 paths and keys should
	// be visible to your user and how you want to make them visible. You will need
	// to specify the "Entry" and "Target" pair, where Entry shows how the path
	// is made visible and Target is the actual Amazon S3 path. If you only specify
	// a target, it will be displayed as is. You will need to also make sure that
	// your IAM role provides access to paths in Target. The following is an example.
	//
	// '[ "/bucket2/documentation", { "Entry": "your-personal-report.pdf", "Target":
	// "/bucket3/customized-reports/${transfer:UserName}.pdf" } ]'
	//
	// In most cases, you can use this value instead of the scope-down policy to
	// lock your user down to the designated home directory ("chroot"). To do this,
	// you can set Entry to '/' and set Target to the HomeDirectory parameter value.
	//
	// If the target of a logical directory entry does not exist in Amazon S3, the
	// entry will be ignored. As a workaround, you can use the Amazon S3 api to
	// create 0 byte objects as place holders for your directory. If using the CLI,
	// use the s3api call instead of s3 so you can use the put-object operation.
	// For example, you use the following: aws s3api put-object --bucket bucketname
	// --key path/to/folder/. Make sure that the end of the key name ends in a '/'
	// for it to be considered a folder.
	HomeDirectoryMappings []*HomeDirectoryMapEntry `min:"1" type:"list"`

	// The type of landing directory (folder) you want your users' home directory
	// to be when they log into the file transfer protocol-enabled server. If you
	// set it to PATH, the user will see the absolute Amazon S3 bucket paths as
	// is in their file transfer protocol clients. If you set it LOGICAL, you will
	// need to provide mappings in the HomeDirectoryMappings for how you want to
	// make Amazon S3 paths visible to your users.
	HomeDirectoryType *string `type:"string" enum:"HomeDirectoryType"`

	// A scope-down policy for your user so you can use the same IAM role across
	// multiple users. This policy scopes down user access to portions of their
	// Amazon S3 bucket. Variables that you can use inside this policy include ${Transfer:UserName},
	// ${Transfer:HomeDirectory}, and ${Transfer:HomeBucket}.
	//
	// For scope-down policies, AWS Transfer Family stores the policy as a JSON
	// blob, instead of the Amazon Resource Name (ARN) of the policy. You save the
	// policy as a JSON blob and pass it in the Policy argument.
	//
	// For an example of a scope-down policy, see Creating a scope-down policy (https://docs.aws.amazon.com/transfer/latest/userguide/users.html#users-policies-scope-down).
	//
	// For more information, see AssumeRole (https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html)
	// in the AWS Security Token Service API Reference.
	Policy *string `type:"string"`

	// The IAM role that controls your users' access to your Amazon S3 bucket. The
	// policies attached to this role will determine the level of access you want
	// to provide your users when transferring files into and out of your Amazon
	// S3 bucket or buckets. The IAM role should also contain a trust relationship
	// that allows the file transfer protocol-enabled server to access your resources
	// when servicing your users' transfer requests.
	//
	// Role is a required field
	Role *string `min:"20" type:"string" required:"true"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server instance. This is the specific server that you added your user to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// The public portion of the Secure Shell (SSH) key used to authenticate the
	// user to the file transfer protocol-enabled server.
	SshPublicKeyBody *string `type:"string"`

	// Key-value pairs that can be used to group and search for users. Tags are
	// metadata attached to users for any purpose.
	Tags []*Tag `min:"1" type:"list"`

	// A unique string that identifies a user and is associated with a file transfer
	// protocol-enabled server as specified by the ServerId. This user name must
	// be a minimum of 3 and a maximum of 32 characters long. The following are
	// valid characters: a-z, A-Z, 0-9, underscore, and hyphen. The user name can't
	// start with a hyphen.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.HomeDirectoryMappings != nil && len(s.HomeDirectoryMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HomeDirectoryMappings", 1))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Role != nil && len(*s.Role) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Role", 20))
	}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 3))
	}
	if s.HomeDirectoryMappings != nil {
		for i, v := range s.HomeDirectoryMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HomeDirectoryMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHomeDirectory sets the HomeDirectory field's value.
func (s *CreateUserInput) SetHomeDirectory(v string) *CreateUserInput {
	s.HomeDirectory = &v
	return s
}

// SetHomeDirectoryMappings sets the HomeDirectoryMappings field's value.
func (s *CreateUserInput) SetHomeDirectoryMappings(v []*HomeDirectoryMapEntry) *CreateUserInput {
	s.HomeDirectoryMappings = v
	return s
}

// SetHomeDirectoryType sets the HomeDirectoryType field's value.
func (s *CreateUserInput) SetHomeDirectoryType(v string) *CreateUserInput {
	s.HomeDirectoryType = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *CreateUserInput) SetPolicy(v string) *CreateUserInput {
	s.Policy = &v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateUserInput) SetRole(v string) *CreateUserInput {
	s.Role = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *CreateUserInput) SetServerId(v string) *CreateUserInput {
	s.ServerId = &v
	return s
}

// SetSshPublicKeyBody sets the SshPublicKeyBody field's value.
func (s *CreateUserInput) SetSshPublicKeyBody(v string) *CreateUserInput {
	s.SshPublicKeyBody = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateUserInput) SetTags(v []*Tag) *CreateUserInput {
	s.Tags = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *CreateUserInput) SetUserName(v string) *CreateUserInput {
	s.UserName = &v
	return s
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the file transfer protocol-enabled server that the user is attached
	// to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// A unique string that identifies a user account associated with a file transfer
	// protocol-enabled server.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *CreateUserOutput) SetServerId(v string) *CreateUserOutput {
	s.ServerId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *CreateUserOutput) SetUserName(v string) *CreateUserOutput {
	s.UserName = &v
	return s
}

type DeleteServerInput struct {
	_ struct{} `type:"structure"`

	// A unique system-assigned identifier for a file transfer protocol-enabled
	// server instance.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServerInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *DeleteServerInput) SetServerId(v string) *DeleteServerInput {
	s.ServerId = &v
	return s
}

type DeleteServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServerOutput) GoString() string {
	return s.String()
}

type DeleteSshPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server instance that has the user assigned to it.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// A unique identifier used to reference your user's specific SSH key.
	//
	// SshPublicKeyId is a required field
	SshPublicKeyId *string `min:"21" type:"string" required:"true"`

	// A unique string that identifies a user whose public key is being deleted.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSshPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSshPublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSshPublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSshPublicKeyInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.SshPublicKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("SshPublicKeyId"))
	}
	if s.SshPublicKeyId != nil && len(*s.SshPublicKeyId) < 21 {
		invalidParams.Add(request.NewErrParamMinLen("SshPublicKeyId", 21))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *DeleteSshPublicKeyInput) SetServerId(v string) *DeleteSshPublicKeyInput {
	s.ServerId = &v
	return s
}

// SetSshPublicKeyId sets the SshPublicKeyId field's value.
func (s *DeleteSshPublicKeyInput) SetSshPublicKeyId(v string) *DeleteSshPublicKeyInput {
	s.SshPublicKeyId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DeleteSshPublicKeyInput) SetUserName(v string) *DeleteSshPublicKeyInput {
	s.UserName = &v
	return s
}

type DeleteSshPublicKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSshPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSshPublicKeyOutput) GoString() string {
	return s.String()
}

type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server instance that has the user assigned to it.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// A unique string that identifies a user that is being deleted from a file
	// transfer protocol-enabled server.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *DeleteUserInput) SetServerId(v string) *DeleteUserInput {
	s.ServerId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DeleteUserInput) SetUserName(v string) *DeleteUserInput {
	s.UserName = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

type DescribeServerInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeServerInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *DescribeServerInput) SetServerId(v string) *DescribeServerInput {
	s.ServerId = &v
	return s
}

type DescribeServerOutput struct {
	_ struct{} `type:"structure"`

	// An array containing the properties of a file transfer protocol-enabled server
	// with the ServerID you specified.
	//
	// Server is a required field
	Server *DescribedServer `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServerOutput) GoString() string {
	return s.String()
}

// SetServer sets the Server field's value.
func (s *DescribeServerOutput) SetServer(v *DescribedServer) *DescribeServerOutput {
	s.Server = v
	return s
}

type DescribeUserInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server that has this user assigned.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// The name of the user assigned to one or more file transfer protocol-enabled
	// servers. User names are part of the sign-in credentials to use the AWS Transfer
	// Family service and perform file transfer tasks.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *DescribeUserInput) SetServerId(v string) *DescribeUserInput {
	s.ServerId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DescribeUserInput) SetUserName(v string) *DescribeUserInput {
	s.UserName = &v
	return s
}

type DescribeUserOutput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server that has this user assigned.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// An array containing the properties of the user account for the ServerID value
	// that you specified.
	//
	// User is a required field
	User *DescribedUser `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *DescribeUserOutput) SetServerId(v string) *DescribeUserOutput {
	s.ServerId = &v
	return s
}

// SetUser sets the User field's value.
func (s *DescribeUserOutput) SetUser(v *DescribedUser) *DescribeUserOutput {
	s.User = v
	return s
}

// Describes the properties of a file transfer protocol-enabled server that
// was specified. Information returned includes the following: the server Amazon
// Resource Name (ARN), the certificate ARN (if the FTPS protocol was selected),
// the endpoint type and details, the authentication configuration and type,
// the logging role, the file transfer protocol or protocols, the server ID
// and state, and assigned tags or metadata.
type DescribedServer struct {
	_ struct{} `type:"structure"`

	// Specifies the unique Amazon Resource Name (ARN) for a file transfer protocol-enabled
	// server to be described.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Specifies the ARN of the AWS Certificate Manager (ACM) certificate. Required
	// when Protocols is set to FTPS.
	Certificate *string `type:"string"`

	// Specifies the virtual private cloud (VPC) endpoint settings that you configured
	// for your file transfer protocol-enabled server.
	EndpointDetails *EndpointDetails `type:"structure"`

	// Defines the type of endpoint that your file transfer protocol-enabled server
	// is connected to. If your server is connected to a VPC endpoint, your server
	// isn't accessible over the public internet.
	EndpointType *string `type:"string" enum:"EndpointType"`

	// Specifies the Base64-encoded SHA256 fingerprint of the server's host key.
	// This value is equivalent to the output of the ssh-keygen -l -f my-new-server-key
	// command.
	HostKeyFingerprint *string `type:"string"`

	// Specifies information to call a customer-supplied authentication API. This
	// field is not populated when the IdentityProviderType of a file transfer protocol-enabled
	// server is SERVICE_MANAGED.
	IdentityProviderDetails *IdentityProviderDetails `type:"structure"`

	// Specifies the mode of authentication method enabled for this service. A value
	// of SERVICE_MANAGED means that you are using this file transfer protocol-enabled
	// server to store and access user credentials within the service. A value of
	// API_GATEWAY indicates that you have integrated an API Gateway endpoint that
	// will be invoked for authenticating your user into the service.
	IdentityProviderType *string `type:"string" enum:"IdentityProviderType"`

	// Specifies the AWS Identity and Access Management (IAM) role that allows a
	// file transfer protocol-enabled server to turn on Amazon CloudWatch logging
	// for Amazon S3 events. When set, user activity can be viewed in your CloudWatch
	// logs.
	LoggingRole *string `min:"20" type:"string"`

	// Specifies the file transfer protocol or protocols over which your file transfer
	// protocol client can connect to your server's endpoint. The available protocols
	// are:
	//
	//    * SFTP (Secure Shell (SSH) File Transfer Protocol): File transfer over
	//    SSH
	//
	//    * FTPS (File Transfer Protocol Secure): File transfer with TLS encryption
	//
	//    * FTP (File Transfer Protocol): Unencrypted file transfer
	Protocols []*string `min:"1" type:"list"`

	// Specifies the unique system-assigned identifier for a file transfer protocol-enabled
	// server that you instantiate.
	ServerId *string `min:"19" type:"string"`

	// Specifies the condition of a file transfer protocol-enabled server for the
	// server that was described. A value of ONLINE indicates that the server can
	// accept jobs and transfer files. A State value of OFFLINE means that the server
	// cannot perform file transfer operations.
	//
	// The states of STARTING and STOPPING indicate that the server is in an intermediate
	// state, either not fully able to respond, or not fully offline. The values
	// of START_FAILED or STOP_FAILED can indicate an error condition.
	State *string `type:"string" enum:"State"`

	// Specifies the key-value pairs that you can use to search for and group file
	// transfer protocol-enabled servers that were assigned to the server that was
	// described.
	Tags []*Tag `min:"1" type:"list"`

	// Specifies the number of users that are assigned to a file transfer protocol-enabled
	// server you specified with the ServerId.
	UserCount *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribedServer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribedServer) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribedServer) SetArn(v string) *DescribedServer {
	s.Arn = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *DescribedServer) SetCertificate(v string) *DescribedServer {
	s.Certificate = &v
	return s
}

// SetEndpointDetails sets the EndpointDetails field's value.
func (s *DescribedServer) SetEndpointDetails(v *EndpointDetails) *DescribedServer {
	s.EndpointDetails = v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *DescribedServer) SetEndpointType(v string) *DescribedServer {
	s.EndpointType = &v
	return s
}

// SetHostKeyFingerprint sets the HostKeyFingerprint field's value.
func (s *DescribedServer) SetHostKeyFingerprint(v string) *DescribedServer {
	s.HostKeyFingerprint = &v
	return s
}

// SetIdentityProviderDetails sets the IdentityProviderDetails field's value.
func (s *DescribedServer) SetIdentityProviderDetails(v *IdentityProviderDetails) *DescribedServer {
	s.IdentityProviderDetails = v
	return s
}

// SetIdentityProviderType sets the IdentityProviderType field's value.
func (s *DescribedServer) SetIdentityProviderType(v string) *DescribedServer {
	s.IdentityProviderType = &v
	return s
}

// SetLoggingRole sets the LoggingRole field's value.
func (s *DescribedServer) SetLoggingRole(v string) *DescribedServer {
	s.LoggingRole = &v
	return s
}

// SetProtocols sets the Protocols field's value.
func (s *DescribedServer) SetProtocols(v []*string) *DescribedServer {
	s.Protocols = v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *DescribedServer) SetServerId(v string) *DescribedServer {
	s.ServerId = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribedServer) SetState(v string) *DescribedServer {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribedServer) SetTags(v []*Tag) *DescribedServer {
	s.Tags = v
	return s
}

// SetUserCount sets the UserCount field's value.
func (s *DescribedServer) SetUserCount(v int64) *DescribedServer {
	s.UserCount = &v
	return s
}

// Returns properties of the user that you want to describe.
type DescribedUser struct {
	_ struct{} `type:"structure"`

	// Specifies the unique Amazon Resource Name (ARN) for the user that was requested
	// to be described.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Specifies the landing directory (or folder), which is the location that files
	// are written to or read from in an Amazon S3 bucket, for the described user.
	// An example is your-Amazon-S3-bucket-name>/home/username .
	HomeDirectory *string `type:"string"`

	// Specifies the logical directory mappings that specify what Amazon S3 paths
	// and keys should be visible to your user and how you want to make them visible.
	// You will need to specify the "Entry" and "Target" pair, where Entry shows
	// how the path is made visible and Target is the actual Amazon S3 path. If
	// you only specify a target, it will be displayed as is. You will need to also
	// make sure that your AWS Identity and Access Management (IAM) role provides
	// access to paths in Target.
	//
	// In most cases, you can use this value instead of the scope-down policy to
	// lock your user down to the designated home directory ("chroot"). To do this,
	// you can set Entry to '/' and set Target to the HomeDirectory parameter value.
	HomeDirectoryMappings []*HomeDirectoryMapEntry `min:"1" type:"list"`

	// Specifies the type of landing directory (folder) you mapped for your users
	// to see when they log into the file transfer protocol-enabled server. If you
	// set it to PATH, the user will see the absolute Amazon S3 bucket paths as
	// is in their file transfer protocol clients. If you set it LOGICAL, you will
	// need to provide mappings in the HomeDirectoryMappings for how you want to
	// make Amazon S3 paths visible to your users.
	HomeDirectoryType *string `type:"string" enum:"HomeDirectoryType"`

	// Specifies the name of the policy in use for the described user.
	Policy *string `type:"string"`

	// Specifies the IAM role that controls your users' access to your Amazon S3
	// bucket. The policies attached to this role will determine the level of access
	// you want to provide your users when transferring files into and out of your
	// Amazon S3 bucket or buckets. The IAM role should also contain a trust relationship
	// that allows a file transfer protocol-enabled server to access your resources
	// when servicing your users' transfer requests.
	Role *string `min:"20" type:"string"`

	// Specifies the public key portion of the Secure Shell (SSH) keys stored for
	// the described user.
	SshPublicKeys []*SshPublicKey `type:"list"`

	// Specifies the key-value pairs for the user requested. Tag can be used to
	// search for and group users for a variety of purposes.
	Tags []*Tag `min:"1" type:"list"`

	// Specifies the name of the user that was requested to be described. User names
	// are used for authentication purposes. This is the string that will be used
	// by your user when they log in to your file transfer protocol-enabled server.
	UserName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s DescribedUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribedUser) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribedUser) SetArn(v string) *DescribedUser {
	s.Arn = &v
	return s
}

// SetHomeDirectory sets the HomeDirectory field's value.
func (s *DescribedUser) SetHomeDirectory(v string) *DescribedUser {
	s.HomeDirectory = &v
	return s
}

// SetHomeDirectoryMappings sets the HomeDirectoryMappings field's value.
func (s *DescribedUser) SetHomeDirectoryMappings(v []*HomeDirectoryMapEntry) *DescribedUser {
	s.HomeDirectoryMappings = v
	return s
}

// SetHomeDirectoryType sets the HomeDirectoryType field's value.
func (s *DescribedUser) SetHomeDirectoryType(v string) *DescribedUser {
	s.HomeDirectoryType = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *DescribedUser) SetPolicy(v string) *DescribedUser {
	s.Policy = &v
	return s
}

// SetRole sets the Role field's value.
func (s *DescribedUser) SetRole(v string) *DescribedUser {
	s.Role = &v
	return s
}

// SetSshPublicKeys sets the SshPublicKeys field's value.
func (s *DescribedUser) SetSshPublicKeys(v []*SshPublicKey) *DescribedUser {
	s.SshPublicKeys = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribedUser) SetTags(v []*Tag) *DescribedUser {
	s.Tags = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DescribedUser) SetUserName(v string) *DescribedUser {
	s.UserName = &v
	return s
}

// The virtual private cloud (VPC) endpoint settings that are configured for
// your file transfer protocol-enabled server. With a VPC endpoint, you can
// restrict access to your server and resources only within your VPC. To control
// incoming internet traffic, invoke the UpdateServer API and attach an Elastic
// IP to your server's endpoint.
type EndpointDetails struct {
	_ struct{} `type:"structure"`

	// A list of address allocation IDs that are required to attach an Elastic IP
	// address to your file transfer protocol-enabled server's endpoint. This is
	// only valid in the UpdateServer API.
	//
	// This property can only be use when EndpointType is set to VPC.
	AddressAllocationIds []*string `type:"list"`

	// A list of subnet IDs that are required to host your file transfer protocol-enabled
	// server endpoint in your VPC.
	//
	// This property can only be used when EndpointType is set to VPC.
	SubnetIds []*string `type:"list"`

	// The ID of the VPC endpoint.
	//
	// This property can only be used when EndpointType is set to VPC_ENDPOINT.
	VpcEndpointId *string `min:"22" type:"string"`

	// The VPC ID of the VPC in which a file transfer protocol-enabled server's
	// endpoint will be hosted.
	//
	// This property can only be used when EndpointType is set to VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s EndpointDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EndpointDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EndpointDetails"}
	if s.VpcEndpointId != nil && len(*s.VpcEndpointId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("VpcEndpointId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressAllocationIds sets the AddressAllocationIds field's value.
func (s *EndpointDetails) SetAddressAllocationIds(v []*string) *EndpointDetails {
	s.AddressAllocationIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *EndpointDetails) SetSubnetIds(v []*string) *EndpointDetails {
	s.SubnetIds = v
	return s
}

// SetVpcEndpointId sets the VpcEndpointId field's value.
func (s *EndpointDetails) SetVpcEndpointId(v string) *EndpointDetails {
	s.VpcEndpointId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *EndpointDetails) SetVpcId(v string) *EndpointDetails {
	s.VpcId = &v
	return s
}

// Represents an object that contains entries and a targets for HomeDirectoryMappings.
type HomeDirectoryMapEntry struct {
	_ struct{} `type:"structure"`

	// Represents an entry and a target for HomeDirectoryMappings.
	//
	// Entry is a required field
	Entry *string `type:"string" required:"true"`

	// Represents the map target that is used in a HomeDirectorymapEntry.
	//
	// Target is a required field
	Target *string `type:"string" required:"true"`
}

// String returns the string representation
func (s HomeDirectoryMapEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HomeDirectoryMapEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HomeDirectoryMapEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HomeDirectoryMapEntry"}
	if s.Entry == nil {
		invalidParams.Add(request.NewErrParamRequired("Entry"))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntry sets the Entry field's value.
func (s *HomeDirectoryMapEntry) SetEntry(v string) *HomeDirectoryMapEntry {
	s.Entry = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *HomeDirectoryMapEntry) SetTarget(v string) *HomeDirectoryMapEntry {
	s.Target = &v
	return s
}

// Returns information related to the type of user authentication that is in
// use for a file transfer protocol-enabled server's users. A server can have
// only one method of authentication.
type IdentityProviderDetails struct {
	_ struct{} `type:"structure"`

	// Provides the type of InvocationRole used to authenticate the user account.
	InvocationRole *string `min:"20" type:"string"`

	// Provides the location of the service endpoint used to authenticate users.
	Url *string `type:"string"`
}

// String returns the string representation
func (s IdentityProviderDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityProviderDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IdentityProviderDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IdentityProviderDetails"}
	if s.InvocationRole != nil && len(*s.InvocationRole) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("InvocationRole", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInvocationRole sets the InvocationRole field's value.
func (s *IdentityProviderDetails) SetInvocationRole(v string) *IdentityProviderDetails {
	s.InvocationRole = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *IdentityProviderDetails) SetUrl(v string) *IdentityProviderDetails {
	s.Url = &v
	return s
}

type ImportSshPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// The public key portion of an SSH key pair.
	//
	// SshPublicKeyBody is a required field
	SshPublicKeyBody *string `type:"string" required:"true"`

	// The name of the user account that is assigned to one or more file transfer
	// protocol-enabled servers.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s ImportSshPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportSshPublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportSshPublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportSshPublicKeyInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.SshPublicKeyBody == nil {
		invalidParams.Add(request.NewErrParamRequired("SshPublicKeyBody"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *ImportSshPublicKeyInput) SetServerId(v string) *ImportSshPublicKeyInput {
	s.ServerId = &v
	return s
}

// SetSshPublicKeyBody sets the SshPublicKeyBody field's value.
func (s *ImportSshPublicKeyInput) SetSshPublicKeyBody(v string) *ImportSshPublicKeyInput {
	s.SshPublicKeyBody = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ImportSshPublicKeyInput) SetUserName(v string) *ImportSshPublicKeyInput {
	s.UserName = &v
	return s
}

// Identifies the user, the file transfer protocol-enabled server they belong
// to, and the identifier of the SSH public key associated with that user. A
// user can have more than one key on each server that they are associated with.
type ImportSshPublicKeyOutput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// The name given to a public key by the system that was imported.
	//
	// SshPublicKeyId is a required field
	SshPublicKeyId *string `min:"21" type:"string" required:"true"`

	// A user name assigned to the ServerID value that you specified.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s ImportSshPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportSshPublicKeyOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *ImportSshPublicKeyOutput) SetServerId(v string) *ImportSshPublicKeyOutput {
	s.ServerId = &v
	return s
}

// SetSshPublicKeyId sets the SshPublicKeyId field's value.
func (s *ImportSshPublicKeyOutput) SetSshPublicKeyId(v string) *ImportSshPublicKeyOutput {
	s.SshPublicKeyId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ImportSshPublicKeyOutput) SetUserName(v string) *ImportSshPublicKeyOutput {
	s.UserName = &v
	return s
}

// This exception is thrown when an error occurs in the AWS Transfer Family
// service.
type InternalServiceError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServiceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServiceError) GoString() string {
	return s.String()
}

func newErrorInternalServiceError(v protocol.ResponseMetadata) error {
	return &InternalServiceError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceError) Code() string {
	return "InternalServiceError"
}

// Message returns the exception's message.
func (s *InternalServiceError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceError) OrigErr() error {
	return nil
}

func (s *InternalServiceError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceError) RequestID() string {
	return s.RespMetadata.RequestID
}

// The NextToken parameter that was passed is invalid.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the client submits a malformed request.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListServersInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of file transfer protocol-enabled servers to return
	// as a response to the ListServers query.
	MaxResults *int64 `min:"1" type:"integer"`

	// When additional results are obtained from theListServers command, a NextToken
	// parameter is returned in the output. You can then pass the NextToken parameter
	// in a subsequent command to continue listing additional file transfer protocol-enabled
	// servers.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListServersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServersInput) SetMaxResults(v int64) *ListServersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServersInput) SetNextToken(v string) *ListServersInput {
	s.NextToken = &v
	return s
}

type ListServersOutput struct {
	_ struct{} `type:"structure"`

	// When you can get additional results from the ListServers operation, a NextToken
	// parameter is returned in the output. In a following command, you can pass
	// in the NextToken parameter to continue listing additional file transfer protocol-enabled
	// servers.
	NextToken *string `min:"1" type:"string"`

	// An array of file transfer protocol-enabled servers that were listed.
	//
	// Servers is a required field
	Servers []*ListedServer `type:"list" required:"true"`
}

// String returns the string representation
func (s ListServersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServersOutput) SetNextToken(v string) *ListServersOutput {
	s.NextToken = &v
	return s
}

// SetServers sets the Servers field's value.
func (s *ListServersOutput) SetServers(v []*ListedServer) *ListServersOutput {
	s.Servers = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Requests the tags associated with a particular Amazon Resource Name (ARN).
	// An ARN is an identifier for a specific AWS resource, such as a server, user,
	// or role.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Specifies the number of tags to return as a response to the ListTagsForResource
	// request.
	MaxResults *int64 `min:"1" type:"integer"`

	// When you request additional results from the ListTagsForResource operation,
	// a NextToken parameter is returned in the input. You can then pass in a subsequent
	// command to the NextToken parameter to continue listing additional tags.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListTagsForResourceInput) SetArn(v string) *ListTagsForResourceInput {
	s.Arn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN you specified to list the tags of.
	Arn *string `min:"20" type:"string"`

	// When you can get additional results from the ListTagsForResource call, a
	// NextToken parameter is returned in the output. You can then pass in a subsequent
	// command to the NextToken parameter to continue listing additional tags.
	NextToken *string `min:"1" type:"string"`

	// Key-value pairs that are assigned to a resource, usually for the purpose
	// of grouping and searching for items. Tags are metadata that you define.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListTagsForResourceOutput) SetArn(v string) *ListTagsForResourceOutput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of users to return as a response to the ListUsers request.
	MaxResults *int64 `min:"1" type:"integer"`

	// When you can get additional results from the ListUsers call, a NextToken
	// parameter is returned in the output. You can then pass in a subsequent command
	// to the NextToken parameter to continue listing additional users.
	NextToken *string `min:"1" type:"string"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server that has users assigned to it.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUsersInput) SetMaxResults(v int64) *ListUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersInput) SetNextToken(v string) *ListUsersInput {
	s.NextToken = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *ListUsersInput) SetServerId(v string) *ListUsersInput {
	s.ServerId = &v
	return s
}

type ListUsersOutput struct {
	_ struct{} `type:"structure"`

	// When you can get additional results from the ListUsers call, a NextToken
	// parameter is returned in the output. You can then pass in a subsequent command
	// to the NextToken parameter to continue listing additional users.
	NextToken *string `min:"1" type:"string"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server that the users are assigned to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// Returns the user accounts and their properties for the ServerId value that
	// you specify.
	//
	// Users is a required field
	Users []*ListedUser `type:"list" required:"true"`
}

// String returns the string representation
func (s ListUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersOutput) SetNextToken(v string) *ListUsersOutput {
	s.NextToken = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *ListUsersOutput) SetServerId(v string) *ListUsersOutput {
	s.ServerId = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *ListUsersOutput) SetUsers(v []*ListedUser) *ListUsersOutput {
	s.Users = v
	return s
}

// Returns properties of a file transfer protocol-enabled server that was specified.
type ListedServer struct {
	_ struct{} `type:"structure"`

	// Specifies the unique Amazon Resource Name (ARN) for a file transfer protocol-enabled
	// server to be listed.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Specifies the type of VPC endpoint that your file transfer protocol-enabled
	// server is connected to. If your server is connected to a VPC endpoint, your
	// server isn't accessible over the public internet.
	EndpointType *string `type:"string" enum:"EndpointType"`

	// Specifies the authentication method used to validate a user for a file transfer
	// protocol-enabled server that was specified. This can include Secure Shell
	// (SSH), user name and password combinations, or your own custom authentication
	// method. Valid values include SERVICE_MANAGED or API_GATEWAY.
	IdentityProviderType *string `type:"string" enum:"IdentityProviderType"`

	// Specifies the AWS Identity and Access Management (IAM) role that allows a
	// file transfer protocol-enabled server to turn on Amazon CloudWatch logging.
	LoggingRole *string `min:"20" type:"string"`

	// Specifies the unique system assigned identifier for a file transfer protocol-enabled
	// servers that were listed.
	ServerId *string `min:"19" type:"string"`

	// Specifies the condition of a file transfer protocol-enabled server for the
	// server that was described. A value of ONLINE indicates that the server can
	// accept jobs and transfer files. A State value of OFFLINE means that the server
	// cannot perform file transfer operations.
	//
	// The states of STARTING and STOPPING indicate that the server is in an intermediate
	// state, either not fully able to respond, or not fully offline. The values
	// of START_FAILED or STOP_FAILED can indicate an error condition.
	State *string `type:"string" enum:"State"`

	// Specifies the number of users that are assigned to a file transfer protocol-enabled
	// server you specified with the ServerId.
	UserCount *int64 `type:"integer"`
}

// String returns the string representation
func (s ListedServer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListedServer) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListedServer) SetArn(v string) *ListedServer {
	s.Arn = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *ListedServer) SetEndpointType(v string) *ListedServer {
	s.EndpointType = &v
	return s
}

// SetIdentityProviderType sets the IdentityProviderType field's value.
func (s *ListedServer) SetIdentityProviderType(v string) *ListedServer {
	s.IdentityProviderType = &v
	return s
}

// SetLoggingRole sets the LoggingRole field's value.
func (s *ListedServer) SetLoggingRole(v string) *ListedServer {
	s.LoggingRole = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *ListedServer) SetServerId(v string) *ListedServer {
	s.ServerId = &v
	return s
}

// SetState sets the State field's value.
func (s *ListedServer) SetState(v string) *ListedServer {
	s.State = &v
	return s
}

// SetUserCount sets the UserCount field's value.
func (s *ListedServer) SetUserCount(v int64) *ListedServer {
	s.UserCount = &v
	return s
}

// Returns properties of the user that you specify.
type ListedUser struct {
	_ struct{} `type:"structure"`

	// Provides the unique Amazon Resource Name (ARN) for the user that you want
	// to learn about.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Specifies the location that files are written to or read from an Amazon S3
	// bucket for the user you specify by their ARN.
	HomeDirectory *string `type:"string"`

	// Specifies the type of landing directory (folder) you mapped for your users'
	// home directory. If you set it to PATH, the user will see the absolute Amazon
	// S3 bucket paths as is in their file transfer protocol clients. If you set
	// it LOGICAL, you will need to provide mappings in the HomeDirectoryMappings
	// for how you want to make Amazon S3 paths visible to your users.
	HomeDirectoryType *string `type:"string" enum:"HomeDirectoryType"`

	// Specifies the role that is in use by this user. A role is an AWS Identity
	// and Access Management (IAM) entity that, in this case, allows a file transfer
	// protocol-enabled server to act on a user's behalf. It allows the server to
	// inherit the trust relationship that enables that user to perform file operations
	// to their Amazon S3 bucket.
	Role *string `min:"20" type:"string"`

	// Specifies the number of SSH public keys stored for the user you specified.
	SshPublicKeyCount *int64 `type:"integer"`

	// Specifies the name of the user whose ARN was specified. User names are used
	// for authentication purposes.
	UserName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s ListedUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListedUser) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListedUser) SetArn(v string) *ListedUser {
	s.Arn = &v
	return s
}

// SetHomeDirectory sets the HomeDirectory field's value.
func (s *ListedUser) SetHomeDirectory(v string) *ListedUser {
	s.HomeDirectory = &v
	return s
}

// SetHomeDirectoryType sets the HomeDirectoryType field's value.
func (s *ListedUser) SetHomeDirectoryType(v string) *ListedUser {
	s.HomeDirectoryType = &v
	return s
}

// SetRole sets the Role field's value.
func (s *ListedUser) SetRole(v string) *ListedUser {
	s.Role = &v
	return s
}

// SetSshPublicKeyCount sets the SshPublicKeyCount field's value.
func (s *ListedUser) SetSshPublicKeyCount(v int64) *ListedUser {
	s.SshPublicKeyCount = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ListedUser) SetUserName(v string) *ListedUser {
	s.UserName = &v
	return s
}

// The requested resource does not exist.
type ResourceExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Resource is a required field
	Resource *string `type:"string" required:"true"`

	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceExistsException) GoString() string {
	return s.String()
}

func newErrorResourceExistsException(v protocol.ResponseMetadata) error {
	return &ResourceExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceExistsException) Code() string {
	return "ResourceExistsException"
}

// Message returns the exception's message.
func (s *ResourceExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceExistsException) OrigErr() error {
	return nil
}

func (s *ResourceExistsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when a resource is not found by the AWS Transfer
// Family service.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Resource is a required field
	Resource *string `type:"string" required:"true"`

	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request has failed because the AWS Transfer Family service is not available.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information about the public Secure Shell (SSH) key that is associated
// with a user account for the specific file transfer protocol-enabled server
// (as identified by ServerId). The information returned includes the date the
// key was imported, the public key contents, and the public key ID. A user
// can store more than one SSH public key associated with their user name on
// a specific server.
type SshPublicKey struct {
	_ struct{} `type:"structure"`

	// Specifies the date that the public key was added to the user account.
	//
	// DateImported is a required field
	DateImported *time.Time `type:"timestamp" required:"true"`

	// Specifies the content of the SSH public key as specified by the PublicKeyId.
	//
	// SshPublicKeyBody is a required field
	SshPublicKeyBody *string `type:"string" required:"true"`

	// Specifies the SshPublicKeyId parameter contains the identifier of the public
	// key.
	//
	// SshPublicKeyId is a required field
	SshPublicKeyId *string `min:"21" type:"string" required:"true"`
}

// String returns the string representation
func (s SshPublicKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SshPublicKey) GoString() string {
	return s.String()
}

// SetDateImported sets the DateImported field's value.
func (s *SshPublicKey) SetDateImported(v time.Time) *SshPublicKey {
	s.DateImported = &v
	return s
}

// SetSshPublicKeyBody sets the SshPublicKeyBody field's value.
func (s *SshPublicKey) SetSshPublicKeyBody(v string) *SshPublicKey {
	s.SshPublicKeyBody = &v
	return s
}

// SetSshPublicKeyId sets the SshPublicKeyId field's value.
func (s *SshPublicKey) SetSshPublicKeyId(v string) *SshPublicKey {
	s.SshPublicKeyId = &v
	return s
}

type StartServerInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server that you start.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation
func (s StartServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartServerInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *StartServerInput) SetServerId(v string) *StartServerInput {
	s.ServerId = &v
	return s
}

type StartServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartServerOutput) GoString() string {
	return s.String()
}

type StopServerInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server that you stopped.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation
func (s StopServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopServerInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *StopServerInput) SetServerId(v string) *StopServerInput {
	s.ServerId = &v
	return s
}

type StopServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopServerOutput) GoString() string {
	return s.String()
}

// Creates a key-value pair for a specific resource. Tags are metadata that
// you can use to search for and group a resource for various purposes. You
// can apply tags to servers, users, and roles. A tag key can take more than
// one value. For example, to group servers for accounting purposes, you might
// create a tag called Group and assign the values Research and Accounting to
// that group.
type Tag struct {
	_ struct{} `type:"structure"`

	// The name assigned to the tag that you create.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// Contains one or more values that you assigned to the key name you create.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) for a specific AWS resource, such as a server,
	// user, or role.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Key-value pairs assigned to ARNs that you can use to group and search for
	// resources by type. You can attach this metadata to user accounts for any
	// purpose.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *TagResourceInput) SetArn(v string) *TagResourceInput {
	s.Arn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type TestIdentityProviderInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned identifier for a specific file transfer protocol-enabled
	// server. That server's user authentication method is tested with a user name
	// and password.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// The type of file transfer protocol to be tested.
	//
	// The available protocols are:
	//
	//    * Secure Shell (SSH) File Transfer Protocol (SFTP)
	//
	//    * File Transfer Protocol Secure (FTPS)
	//
	//    * File Transfer Protocol (FTP)
	ServerProtocol *string `type:"string" enum:"Protocol"`

	// The source IP address of the user account to be tested.
	SourceIp *string `type:"string"`

	// The name of the user account to be tested.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`

	// The password of the user account to be tested.
	UserPassword *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s TestIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestIdentityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestIdentityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestIdentityProviderInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *TestIdentityProviderInput) SetServerId(v string) *TestIdentityProviderInput {
	s.ServerId = &v
	return s
}

// SetServerProtocol sets the ServerProtocol field's value.
func (s *TestIdentityProviderInput) SetServerProtocol(v string) *TestIdentityProviderInput {
	s.ServerProtocol = &v
	return s
}

// SetSourceIp sets the SourceIp field's value.
func (s *TestIdentityProviderInput) SetSourceIp(v string) *TestIdentityProviderInput {
	s.SourceIp = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *TestIdentityProviderInput) SetUserName(v string) *TestIdentityProviderInput {
	s.UserName = &v
	return s
}

// SetUserPassword sets the UserPassword field's value.
func (s *TestIdentityProviderInput) SetUserPassword(v string) *TestIdentityProviderInput {
	s.UserPassword = &v
	return s
}

type TestIdentityProviderOutput struct {
	_ struct{} `type:"structure"`

	// A message that indicates whether the test was successful or not.
	Message *string `type:"string"`

	// The response that is returned from your API Gateway.
	Response *string `type:"string"`

	// The HTTP status code that is the response from your API Gateway.
	//
	// StatusCode is a required field
	StatusCode *int64 `type:"integer" required:"true"`

	// The endpoint of the service used to authenticate a user.
	//
	// Url is a required field
	Url *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TestIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestIdentityProviderOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *TestIdentityProviderOutput) SetMessage(v string) *TestIdentityProviderOutput {
	s.Message = &v
	return s
}

// SetResponse sets the Response field's value.
func (s *TestIdentityProviderOutput) SetResponse(v string) *TestIdentityProviderOutput {
	s.Response = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *TestIdentityProviderOutput) SetStatusCode(v int64) *TestIdentityProviderOutput {
	s.StatusCode = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *TestIdentityProviderOutput) SetUrl(v string) *TestIdentityProviderOutput {
	s.Url = &v
	return s
}

// The request was denied due to request throttling.
//
// HTTP Status Code: 400
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	RetryAfterSeconds *string `type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The value of the resource that will have the tag removed. An Amazon Resource
	// Name (ARN) is an identifier for a specific AWS resource, such as a server,
	// user, or role.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// TagKeys are key-value pairs assigned to ARNs that can be used to group and
	// search for resources by type. This metadata can be attached to resources
	// for any purpose.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UntagResourceInput) SetArn(v string) *UntagResourceInput {
	s.Arn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateServerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate.
	// Required when Protocols is set to FTPS.
	//
	// To request a new public certificate, see Request a public certificate (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html)
	// in the AWS Certificate Manager User Guide.
	//
	// To import an existing certificate into ACM, see Importing certificates into
	// ACM (https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html)
	// in the AWS Certificate Manager User Guide.
	//
	// To request a private certificate to use FTPS through private IP addresses,
	// see Request a private certificate (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html)
	// in the AWS Certificate Manager User Guide.
	//
	// Certificates with the following cryptographic algorithms and key sizes are
	// supported:
	//
	//    * 2048-bit RSA (RSA_2048)
	//
	//    * 4096-bit RSA (RSA_4096)
	//
	//    * Elliptic Prime Curve 256 bit (EC_prime256v1)
	//
	//    * Elliptic Prime Curve 384 bit (EC_secp384r1)
	//
	//    * Elliptic Prime Curve 521 bit (EC_secp521r1)
	//
	// The certificate must be a valid SSL/TLS X.509 version 3 certificate with
	// FQDN or IP address specified and information about the issuer.
	Certificate *string `type:"string"`

	// The virtual private cloud (VPC) endpoint settings that are configured for
	// your file transfer protocol-enabled server. With a VPC endpoint, you can
	// restrict access to your server to resources only within your VPC. To control
	// incoming internet traffic, you will need to associate one or more Elastic
	// IP addresses with your server's endpoint.
	EndpointDetails *EndpointDetails `type:"structure"`

	// The type of endpoint that you want your file transfer protocol-enabled server
	// to connect to. You can choose to connect to the public internet or a VPC
	// endpoint. With a VPC endpoint, you can restrict access to your server and
	// resources only within your VPC.
	//
	// It is recommended that you use VPC as the EndpointType. With this endpoint
	// type, you have the option to directly associate up to three Elastic IPv4
	// addresses (BYO IP included) with your server's endpoint and use VPC security
	// groups to restrict traffic by the client's public IP address. This is not
	// possible with EndpointType set to VPC_ENDPOINT.
	EndpointType *string `type:"string" enum:"EndpointType"`

	// The RSA private key as generated by ssh-keygen -N "" -m PEM -f my-new-server-key.
	//
	// If you aren't planning to migrate existing users from an existing file transfer
	// protocol-enabled server to a new server, don't update the host key. Accidentally
	// changing a server's host key can be disruptive.
	//
	// For more information, see Change the host key for your SFTP-enabled server
	// (https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key)
	// in the AWS Transfer Family User Guide.
	HostKey *string `type:"string" sensitive:"true"`

	// An array containing all of the information required to call a customer's
	// authentication API method.
	IdentityProviderDetails *IdentityProviderDetails `type:"structure"`

	// Changes the AWS Identity and Access Management (IAM) role that allows Amazon
	// S3 events to be logged in Amazon CloudWatch, turning logging on or off.
	LoggingRole *string `type:"string"`

	// Specifies the file transfer protocol or protocols over which your file transfer
	// protocol client can connect to your server's endpoint. The available protocols
	// are:
	//
	//    * Secure Shell (SSH) File Transfer Protocol (SFTP): File transfer over
	//    SSH
	//
	//    * File Transfer Protocol Secure (FTPS): File transfer with TLS encryption
	//
	//    * File Transfer Protocol (FTP): Unencrypted file transfer
	//
	// If you select FTPS, you must choose a certificate stored in AWS Certificate
	// Manager (ACM) which will be used to identify your server when clients connect
	// to it over FTPS.
	//
	// If Protocol includes either FTP or FTPS, then the EndpointType must be VPC
	// and the IdentityProviderType must be API_GATEWAY.
	//
	// If Protocol includes FTP, then AddressAllocationIds cannot be associated.
	//
	// If Protocol is set only to SFTP, the EndpointType can be set to PUBLIC and
	// the IdentityProviderType can be set to SERVICE_MANAGED.
	Protocols []*string `min:"1" type:"list"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server instance that the user account is assigned to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServerInput"}
	if s.Protocols != nil && len(s.Protocols) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Protocols", 1))
	}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.EndpointDetails != nil {
		if err := s.EndpointDetails.Validate(); err != nil {
			invalidParams.AddNested("EndpointDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.IdentityProviderDetails != nil {
		if err := s.IdentityProviderDetails.Validate(); err != nil {
			invalidParams.AddNested("IdentityProviderDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificate sets the Certificate field's value.
func (s *UpdateServerInput) SetCertificate(v string) *UpdateServerInput {
	s.Certificate = &v
	return s
}

// SetEndpointDetails sets the EndpointDetails field's value.
func (s *UpdateServerInput) SetEndpointDetails(v *EndpointDetails) *UpdateServerInput {
	s.EndpointDetails = v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *UpdateServerInput) SetEndpointType(v string) *UpdateServerInput {
	s.EndpointType = &v
	return s
}

// SetHostKey sets the HostKey field's value.
func (s *UpdateServerInput) SetHostKey(v string) *UpdateServerInput {
	s.HostKey = &v
	return s
}

// SetIdentityProviderDetails sets the IdentityProviderDetails field's value.
func (s *UpdateServerInput) SetIdentityProviderDetails(v *IdentityProviderDetails) *UpdateServerInput {
	s.IdentityProviderDetails = v
	return s
}

// SetLoggingRole sets the LoggingRole field's value.
func (s *UpdateServerInput) SetLoggingRole(v string) *UpdateServerInput {
	s.LoggingRole = &v
	return s
}

// SetProtocols sets the Protocols field's value.
func (s *UpdateServerInput) SetProtocols(v []*string) *UpdateServerInput {
	s.Protocols = v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *UpdateServerInput) SetServerId(v string) *UpdateServerInput {
	s.ServerId = &v
	return s
}

type UpdateServerOutput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server that the user account is assigned to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServerOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *UpdateServerOutput) SetServerId(v string) *UpdateServerOutput {
	s.ServerId = &v
	return s
}

type UpdateUserInput struct {
	_ struct{} `type:"structure"`

	// Specifies the landing directory (folder) for a user when they log in to the
	// file transfer protocol-enabled server using their file transfer protocol
	// client.
	//
	// An example is your-Amazon-S3-bucket-name>/home/username.
	HomeDirectory *string `type:"string"`

	// Logical directory mappings that specify what Amazon S3 paths and keys should
	// be visible to your user and how you want to make them visible. You will need
	// to specify the "Entry" and "Target" pair, where Entry shows how the path
	// is made visible and Target is the actual Amazon S3 path. If you only specify
	// a target, it will be displayed as is. You will need to also make sure that
	// your IAM role provides access to paths in Target. The following is an example.
	//
	// '[ "/bucket2/documentation", { "Entry": "your-personal-report.pdf", "Target":
	// "/bucket3/customized-reports/${transfer:UserName}.pdf" } ]'
	//
	// In most cases, you can use this value instead of the scope-down policy to
	// lock your user down to the designated home directory ("chroot"). To do this,
	// you can set Entry to '/' and set Target to the HomeDirectory parameter value.
	//
	// If the target of a logical directory entry does not exist in Amazon S3, the
	// entry will be ignored. As a workaround, you can use the Amazon S3 api to
	// create 0 byte objects as place holders for your directory. If using the CLI,
	// use the s3api call instead of s3 so you can use the put-object operation.
	// For example, you use the following: aws s3api put-object --bucket bucketname
	// --key path/to/folder/. Make sure that the end of the key name ends in a /
	// for it to be considered a folder.
	HomeDirectoryMappings []*HomeDirectoryMapEntry `min:"1" type:"list"`

	// The type of landing directory (folder) you want your users' home directory
	// to be when they log into the file transfer protocol-enabled server. If you
	// set it to PATH, the user will see the absolute Amazon S3 bucket paths as
	// is in their file transfer protocol clients. If you set it LOGICAL, you will
	// need to provide mappings in the HomeDirectoryMappings for how you want to
	// make Amazon S3 paths visible to your users.
	HomeDirectoryType *string `type:"string" enum:"HomeDirectoryType"`

	// Allows you to supply a scope-down policy for your user so you can use the
	// same IAM role across multiple users. The policy scopes down user access to
	// portions of your Amazon S3 bucket. Variables you can use inside this policy
	// include ${Transfer:UserName}, ${Transfer:HomeDirectory}, and ${Transfer:HomeBucket}.
	//
	// For scope-down policies, AWS Transfer Family stores the policy as a JSON
	// blob, instead of the Amazon Resource Name (ARN) of the policy. You save the
	// policy as a JSON blob and pass it in the Policy argument.
	//
	// For an example of a scope-down policy, see Creating a scope-down policy (https://docs.aws.amazon.com/transfer/latest/userguide/users.html#users-policies-scope-down).
	//
	// For more information, see AssumeRole (https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html)
	// in the AWS Security Token Service API Reference.
	Policy *string `type:"string"`

	// The IAM role that controls your users' access to your Amazon S3 bucket. The
	// policies attached to this role will determine the level of access you want
	// to provide your users when transferring files into and out of your Amazon
	// S3 bucket or buckets. The IAM role should also contain a trust relationship
	// that allows the file transfer protocol-enabled server to access your resources
	// when servicing your users' transfer requests.
	Role *string `min:"20" type:"string"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server instance that the user account is assigned to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// A unique string that identifies a user and is associated with a file transfer
	// protocol-enabled server as specified by the ServerId. This is the string
	// that will be used by your user when they log in to your server. This user
	// name is a minimum of 3 and a maximum of 32 characters long. The following
	// are valid characters: a-z, A-Z, 0-9, underscore, and hyphen. The user name
	// can't start with a hyphen.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserInput"}
	if s.HomeDirectoryMappings != nil && len(s.HomeDirectoryMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HomeDirectoryMappings", 1))
	}
	if s.Role != nil && len(*s.Role) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Role", 20))
	}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 3))
	}
	if s.HomeDirectoryMappings != nil {
		for i, v := range s.HomeDirectoryMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HomeDirectoryMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHomeDirectory sets the HomeDirectory field's value.
func (s *UpdateUserInput) SetHomeDirectory(v string) *UpdateUserInput {
	s.HomeDirectory = &v
	return s
}

// SetHomeDirectoryMappings sets the HomeDirectoryMappings field's value.
func (s *UpdateUserInput) SetHomeDirectoryMappings(v []*HomeDirectoryMapEntry) *UpdateUserInput {
	s.HomeDirectoryMappings = v
	return s
}

// SetHomeDirectoryType sets the HomeDirectoryType field's value.
func (s *UpdateUserInput) SetHomeDirectoryType(v string) *UpdateUserInput {
	s.HomeDirectoryType = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *UpdateUserInput) SetPolicy(v string) *UpdateUserInput {
	s.Policy = &v
	return s
}

// SetRole sets the Role field's value.
func (s *UpdateUserInput) SetRole(v string) *UpdateUserInput {
	s.Role = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *UpdateUserInput) SetServerId(v string) *UpdateUserInput {
	s.ServerId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateUserInput) SetUserName(v string) *UpdateUserInput {
	s.UserName = &v
	return s
}

// UpdateUserResponse returns the user name and file transfer protocol-enabled
// server identifier for the request to update a user's properties.
type UpdateUserOutput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server instance that the user account is assigned to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// The unique identifier for a user that is assigned to a file transfer protocol-enabled
	// server instance that was specified in the request.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *UpdateUserOutput) SetServerId(v string) *UpdateUserOutput {
	s.ServerId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateUserOutput) SetUserName(v string) *UpdateUserOutput {
	s.UserName = &v
	return s
}

const (
	// EndpointTypePublic is a EndpointType enum value
	EndpointTypePublic = "PUBLIC"

	// EndpointTypeVpc is a EndpointType enum value
	EndpointTypeVpc = "VPC"

	// EndpointTypeVpcEndpoint is a EndpointType enum value
	EndpointTypeVpcEndpoint = "VPC_ENDPOINT"
)

const (
	// HomeDirectoryTypePath is a HomeDirectoryType enum value
	HomeDirectoryTypePath = "PATH"

	// HomeDirectoryTypeLogical is a HomeDirectoryType enum value
	HomeDirectoryTypeLogical = "LOGICAL"
)

// Returns information related to the type of user authentication that is in
// use for a file transfer protocol-enabled server's users. For SERVICE_MANAGED
// authentication, the Secure Shell (SSH) public keys are stored with a user
// on the server instance. For API_GATEWAY authentication, your custom authentication
// method is implemented by using an API call. The server can have only one
// method of authentication.
const (
	// IdentityProviderTypeServiceManaged is a IdentityProviderType enum value
	IdentityProviderTypeServiceManaged = "SERVICE_MANAGED"

	// IdentityProviderTypeApiGateway is a IdentityProviderType enum value
	IdentityProviderTypeApiGateway = "API_GATEWAY"
)

const (
	// ProtocolSftp is a Protocol enum value
	ProtocolSftp = "SFTP"

	// ProtocolFtp is a Protocol enum value
	ProtocolFtp = "FTP"

	// ProtocolFtps is a Protocol enum value
	ProtocolFtps = "FTPS"
)

// Describes the condition of a file transfer protocol-enabled server with respect
// to its ability to perform file operations. There are six possible states:
// OFFLINE, ONLINE, STARTING, STOPPING, START_FAILED, and STOP_FAILED.
//
// OFFLINE indicates that the server exists, but that it is not available for
// file operations. ONLINE indicates that the server is available to perform
// file operations. STARTING indicates that the server's was instantiated, but
// the server is not yet available to perform file operations. Under normal
// conditions, it can take a couple of minutes for the server to be completely
// operational. Both START_FAILED and STOP_FAILED are error conditions.
const (
	// StateOffline is a State enum value
	StateOffline = "OFFLINE"

	// StateOnline is a State enum value
	StateOnline = "ONLINE"

	// StateStarting is a State enum value
	StateStarting = "STARTING"

	// StateStopping is a State enum value
	StateStopping = "STOPPING"

	// StateStartFailed is a State enum value
	StateStartFailed = "START_FAILED"

	// StateStopFailed is a State enum value
	StateStopFailed = "STOP_FAILED"
)
