// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CloudInstanceReference cloud instance reference
// swagger:model CloudInstanceReference
type CloudInstanceReference struct {

	// Cloud Instance Capabilities
	Capabilities []string `json:"capabilities"`

	// Cloud Instance ID
	// Required: true
	CloudInstanceID *string `json:"cloudInstanceID"`

	// Indicates if the cloud instance is enabled
	// Required: true
	Enabled *bool `json:"enabled"`

	// Link to Cloud Instance resource
	// Required: true
	Href *string `json:"href"`

	// Indicates if the cloud instance is initialized and ready for use
	// Required: true
	Initialized *bool `json:"initialized"`

	// Limits on the cloud instance
	// Required: true
	Limits *CloudInstanceUsageLimits `json:"limits"`

	// Cloud Instance Name
	// Required: true
	Name *string `json:"name"`

	// The region the cloud instance lives
	// Required: true
	Region *string `json:"region"`
}

// Validate validates this cloud instance reference
func (m *CloudInstanceReference) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCloudInstanceID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEnabled(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHref(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInitialized(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLimits(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudInstanceReference) validateCloudInstanceID(formats strfmt.Registry) error {

	if err := validate.Required("cloudInstanceID", "body", m.CloudInstanceID); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstanceReference) validateEnabled(formats strfmt.Registry) error {

	if err := validate.Required("enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstanceReference) validateHref(formats strfmt.Registry) error {

	if err := validate.Required("href", "body", m.Href); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstanceReference) validateInitialized(formats strfmt.Registry) error {

	if err := validate.Required("initialized", "body", m.Initialized); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstanceReference) validateLimits(formats strfmt.Registry) error {

	if err := validate.Required("limits", "body", m.Limits); err != nil {
		return err
	}

	if m.Limits != nil {
		if err := m.Limits.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("limits")
			}
			return err
		}
	}

	return nil
}

func (m *CloudInstanceReference) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *CloudInstanceReference) validateRegion(formats strfmt.Registry) error {

	if err := validate.Required("region", "body", m.Region); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CloudInstanceReference) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloudInstanceReference) UnmarshalBinary(b []byte) error {
	var res CloudInstanceReference
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
