#!/bin/bash
# ******************************************************************************
# IBM Cloud Kubernetes Service, 5737-D43
# (C) Copyright IBM Corp. 2019, 2021 All Rights Reserved.
#
# SPDX-License-Identifier: Apache2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ******************************************************************************

if [[ -z "${1}" || "${1}" == "--help" || "${1}" == "-h" ]]; then
    echo "This script copies the kubeconfig into the tests/fvt directory to set up the FVT Tester"
    echo "Usage: ${0} <cluster_name>"
    exit 0
fi

echo "Copying kubeconfig for cluster ${1}"

cp "${HOME}/.bluemix/plugins/container-service/clusters/${1}-admin/kube-config-*.yml" ../tests/fvt/kubeconfig
cp "${HOME}/.bluemix/plugins/container-service/clusters/${1}-admin/*.pem" ../tests/fvt/
