// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rdsdataservice

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opBatchExecuteStatement = "BatchExecuteStatement"

// BatchExecuteStatementRequest generates a "aws/request.Request" representing the
// client's request for the BatchExecuteStatement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchExecuteStatement for more information on using the BatchExecuteStatement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchExecuteStatementRequest method.
//    req, resp := client.BatchExecuteStatementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/BatchExecuteStatement
func (c *RDSDataService) BatchExecuteStatementRequest(input *BatchExecuteStatementInput) (req *request.Request, output *BatchExecuteStatementOutput) {
	op := &request.Operation{
		Name:       opBatchExecuteStatement,
		HTTPMethod: "POST",
		HTTPPath:   "/BatchExecute",
	}

	if input == nil {
		input = &BatchExecuteStatementInput{}
	}

	output = &BatchExecuteStatementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchExecuteStatement API operation for AWS RDS DataService.
//
// Runs a batch SQL statement over an array of data.
//
// You can run bulk update and insert operations for multiple records using
// a DML statement with different parameter sets. Bulk operations can provide
// a significant performance improvement over individual insert and update operations.
//
// If a call isn't part of a transaction because it doesn't include the transactionID
// parameter, changes that result from the call are committed automatically.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RDS DataService's
// API operation BatchExecuteStatement for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   There is an error in the call or in a SQL statement.
//
//   * StatementTimeoutException
//   The execution of the SQL statement timed out.
//
//   * InternalServerErrorException
//   An internal error occurred.
//
//   * ForbiddenException
//   There are insufficient privileges to make the call.
//
//   * ServiceUnavailableError
//   The service specified by the resourceArn parameter is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/BatchExecuteStatement
func (c *RDSDataService) BatchExecuteStatement(input *BatchExecuteStatementInput) (*BatchExecuteStatementOutput, error) {
	req, out := c.BatchExecuteStatementRequest(input)
	return out, req.Send()
}

// BatchExecuteStatementWithContext is the same as BatchExecuteStatement with the addition of
// the ability to pass a context and additional request options.
//
// See BatchExecuteStatement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDSDataService) BatchExecuteStatementWithContext(ctx aws.Context, input *BatchExecuteStatementInput, opts ...request.Option) (*BatchExecuteStatementOutput, error) {
	req, out := c.BatchExecuteStatementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBeginTransaction = "BeginTransaction"

// BeginTransactionRequest generates a "aws/request.Request" representing the
// client's request for the BeginTransaction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BeginTransaction for more information on using the BeginTransaction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BeginTransactionRequest method.
//    req, resp := client.BeginTransactionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/BeginTransaction
func (c *RDSDataService) BeginTransactionRequest(input *BeginTransactionInput) (req *request.Request, output *BeginTransactionOutput) {
	op := &request.Operation{
		Name:       opBeginTransaction,
		HTTPMethod: "POST",
		HTTPPath:   "/BeginTransaction",
	}

	if input == nil {
		input = &BeginTransactionInput{}
	}

	output = &BeginTransactionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BeginTransaction API operation for AWS RDS DataService.
//
// Starts a SQL transaction.
//
//    <important> <p>A transaction can run for a maximum of 24 hours. A transaction
//    is terminated and rolled back automatically after 24 hours.</p> <p>A transaction
//    times out if no calls use its transaction ID in three minutes. If a transaction
//    times out before it's committed, it's rolled back automatically.</p> <p>DDL
//    statements inside a transaction cause an implicit commit. We recommend
//    that you run each DDL statement in a separate <code>ExecuteStatement</code>
//    call with <code>continueAfterTimeout</code> enabled.</p> </important>
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RDS DataService's
// API operation BeginTransaction for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   There is an error in the call or in a SQL statement.
//
//   * StatementTimeoutException
//   The execution of the SQL statement timed out.
//
//   * InternalServerErrorException
//   An internal error occurred.
//
//   * ForbiddenException
//   There are insufficient privileges to make the call.
//
//   * ServiceUnavailableError
//   The service specified by the resourceArn parameter is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/BeginTransaction
func (c *RDSDataService) BeginTransaction(input *BeginTransactionInput) (*BeginTransactionOutput, error) {
	req, out := c.BeginTransactionRequest(input)
	return out, req.Send()
}

// BeginTransactionWithContext is the same as BeginTransaction with the addition of
// the ability to pass a context and additional request options.
//
// See BeginTransaction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDSDataService) BeginTransactionWithContext(ctx aws.Context, input *BeginTransactionInput, opts ...request.Option) (*BeginTransactionOutput, error) {
	req, out := c.BeginTransactionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCommitTransaction = "CommitTransaction"

// CommitTransactionRequest generates a "aws/request.Request" representing the
// client's request for the CommitTransaction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CommitTransaction for more information on using the CommitTransaction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CommitTransactionRequest method.
//    req, resp := client.CommitTransactionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/CommitTransaction
func (c *RDSDataService) CommitTransactionRequest(input *CommitTransactionInput) (req *request.Request, output *CommitTransactionOutput) {
	op := &request.Operation{
		Name:       opCommitTransaction,
		HTTPMethod: "POST",
		HTTPPath:   "/CommitTransaction",
	}

	if input == nil {
		input = &CommitTransactionInput{}
	}

	output = &CommitTransactionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CommitTransaction API operation for AWS RDS DataService.
//
// Ends a SQL transaction started with the BeginTransaction operation and commits
// the changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RDS DataService's
// API operation CommitTransaction for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   There is an error in the call or in a SQL statement.
//
//   * StatementTimeoutException
//   The execution of the SQL statement timed out.
//
//   * InternalServerErrorException
//   An internal error occurred.
//
//   * ForbiddenException
//   There are insufficient privileges to make the call.
//
//   * ServiceUnavailableError
//   The service specified by the resourceArn parameter is not available.
//
//   * NotFoundException
//   The resourceArn, secretArn, or transactionId value can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/CommitTransaction
func (c *RDSDataService) CommitTransaction(input *CommitTransactionInput) (*CommitTransactionOutput, error) {
	req, out := c.CommitTransactionRequest(input)
	return out, req.Send()
}

// CommitTransactionWithContext is the same as CommitTransaction with the addition of
// the ability to pass a context and additional request options.
//
// See CommitTransaction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDSDataService) CommitTransactionWithContext(ctx aws.Context, input *CommitTransactionInput, opts ...request.Option) (*CommitTransactionOutput, error) {
	req, out := c.CommitTransactionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExecuteSql = "ExecuteSql"

// ExecuteSqlRequest generates a "aws/request.Request" representing the
// client's request for the ExecuteSql operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExecuteSql for more information on using the ExecuteSql
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExecuteSqlRequest method.
//    req, resp := client.ExecuteSqlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/ExecuteSql
//
// Deprecated: The ExecuteSql API is deprecated, please use the ExecuteStatement API.
func (c *RDSDataService) ExecuteSqlRequest(input *ExecuteSqlInput) (req *request.Request, output *ExecuteSqlOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ExecuteSql, has been deprecated")
	}
	op := &request.Operation{
		Name:       opExecuteSql,
		HTTPMethod: "POST",
		HTTPPath:   "/ExecuteSql",
	}

	if input == nil {
		input = &ExecuteSqlInput{}
	}

	output = &ExecuteSqlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExecuteSql API operation for AWS RDS DataService.
//
// Runs one or more SQL statements.
//
// This operation is deprecated. Use the BatchExecuteStatement or ExecuteStatement
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RDS DataService's
// API operation ExecuteSql for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   There is an error in the call or in a SQL statement.
//
//   * InternalServerErrorException
//   An internal error occurred.
//
//   * ForbiddenException
//   There are insufficient privileges to make the call.
//
//   * ServiceUnavailableError
//   The service specified by the resourceArn parameter is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/ExecuteSql
//
// Deprecated: The ExecuteSql API is deprecated, please use the ExecuteStatement API.
func (c *RDSDataService) ExecuteSql(input *ExecuteSqlInput) (*ExecuteSqlOutput, error) {
	req, out := c.ExecuteSqlRequest(input)
	return out, req.Send()
}

// ExecuteSqlWithContext is the same as ExecuteSql with the addition of
// the ability to pass a context and additional request options.
//
// See ExecuteSql for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: The ExecuteSql API is deprecated, please use the ExecuteStatement API.
func (c *RDSDataService) ExecuteSqlWithContext(ctx aws.Context, input *ExecuteSqlInput, opts ...request.Option) (*ExecuteSqlOutput, error) {
	req, out := c.ExecuteSqlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExecuteStatement = "ExecuteStatement"

// ExecuteStatementRequest generates a "aws/request.Request" representing the
// client's request for the ExecuteStatement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExecuteStatement for more information on using the ExecuteStatement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExecuteStatementRequest method.
//    req, resp := client.ExecuteStatementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/ExecuteStatement
func (c *RDSDataService) ExecuteStatementRequest(input *ExecuteStatementInput) (req *request.Request, output *ExecuteStatementOutput) {
	op := &request.Operation{
		Name:       opExecuteStatement,
		HTTPMethod: "POST",
		HTTPPath:   "/Execute",
	}

	if input == nil {
		input = &ExecuteStatementInput{}
	}

	output = &ExecuteStatementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExecuteStatement API operation for AWS RDS DataService.
//
// Runs a SQL statement against a database.
//
// If a call isn't part of a transaction because it doesn't include the transactionID
// parameter, changes that result from the call are committed automatically.
//
// The response size limit is 1 MB. If the call returns more than 1 MB of response
// data, the call is terminated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RDS DataService's
// API operation ExecuteStatement for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   There is an error in the call or in a SQL statement.
//
//   * StatementTimeoutException
//   The execution of the SQL statement timed out.
//
//   * InternalServerErrorException
//   An internal error occurred.
//
//   * ForbiddenException
//   There are insufficient privileges to make the call.
//
//   * ServiceUnavailableError
//   The service specified by the resourceArn parameter is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/ExecuteStatement
func (c *RDSDataService) ExecuteStatement(input *ExecuteStatementInput) (*ExecuteStatementOutput, error) {
	req, out := c.ExecuteStatementRequest(input)
	return out, req.Send()
}

// ExecuteStatementWithContext is the same as ExecuteStatement with the addition of
// the ability to pass a context and additional request options.
//
// See ExecuteStatement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDSDataService) ExecuteStatementWithContext(ctx aws.Context, input *ExecuteStatementInput, opts ...request.Option) (*ExecuteStatementOutput, error) {
	req, out := c.ExecuteStatementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRollbackTransaction = "RollbackTransaction"

// RollbackTransactionRequest generates a "aws/request.Request" representing the
// client's request for the RollbackTransaction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RollbackTransaction for more information on using the RollbackTransaction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RollbackTransactionRequest method.
//    req, resp := client.RollbackTransactionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/RollbackTransaction
func (c *RDSDataService) RollbackTransactionRequest(input *RollbackTransactionInput) (req *request.Request, output *RollbackTransactionOutput) {
	op := &request.Operation{
		Name:       opRollbackTransaction,
		HTTPMethod: "POST",
		HTTPPath:   "/RollbackTransaction",
	}

	if input == nil {
		input = &RollbackTransactionInput{}
	}

	output = &RollbackTransactionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RollbackTransaction API operation for AWS RDS DataService.
//
// Performs a rollback of a transaction. Rolling back a transaction cancels
// its changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RDS DataService's
// API operation RollbackTransaction for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   There is an error in the call or in a SQL statement.
//
//   * StatementTimeoutException
//   The execution of the SQL statement timed out.
//
//   * InternalServerErrorException
//   An internal error occurred.
//
//   * ForbiddenException
//   There are insufficient privileges to make the call.
//
//   * ServiceUnavailableError
//   The service specified by the resourceArn parameter is not available.
//
//   * NotFoundException
//   The resourceArn, secretArn, or transactionId value can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/RollbackTransaction
func (c *RDSDataService) RollbackTransaction(input *RollbackTransactionInput) (*RollbackTransactionOutput, error) {
	req, out := c.RollbackTransactionRequest(input)
	return out, req.Send()
}

// RollbackTransactionWithContext is the same as RollbackTransaction with the addition of
// the ability to pass a context and additional request options.
//
// See RollbackTransaction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDSDataService) RollbackTransactionWithContext(ctx aws.Context, input *RollbackTransactionInput, opts ...request.Option) (*RollbackTransactionOutput, error) {
	req, out := c.RollbackTransactionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Contains an array.
type ArrayValue struct {
	_ struct{} `type:"structure"`

	// An array of arrays.
	ArrayValues []*ArrayValue `locationName:"arrayValues" type:"list"`

	// An array of Boolean values.
	BooleanValues []*bool `locationName:"booleanValues" type:"list"`

	// An array of integers.
	DoubleValues []*float64 `locationName:"doubleValues" type:"list"`

	// An array of floating point numbers.
	LongValues []*int64 `locationName:"longValues" type:"list"`

	// An array of strings.
	StringValues []*string `locationName:"stringValues" type:"list"`
}

// String returns the string representation
func (s ArrayValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArrayValue) GoString() string {
	return s.String()
}

// SetArrayValues sets the ArrayValues field's value.
func (s *ArrayValue) SetArrayValues(v []*ArrayValue) *ArrayValue {
	s.ArrayValues = v
	return s
}

// SetBooleanValues sets the BooleanValues field's value.
func (s *ArrayValue) SetBooleanValues(v []*bool) *ArrayValue {
	s.BooleanValues = v
	return s
}

// SetDoubleValues sets the DoubleValues field's value.
func (s *ArrayValue) SetDoubleValues(v []*float64) *ArrayValue {
	s.DoubleValues = v
	return s
}

// SetLongValues sets the LongValues field's value.
func (s *ArrayValue) SetLongValues(v []*int64) *ArrayValue {
	s.LongValues = v
	return s
}

// SetStringValues sets the StringValues field's value.
func (s *ArrayValue) SetStringValues(v []*string) *ArrayValue {
	s.StringValues = v
	return s
}

// There is an error in the call or in a SQL statement.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message returned by this BadRequestException error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request parameters represent the input of a SQL statement over an array
// of data.
type BatchExecuteStatementInput struct {
	_ struct{} `type:"structure"`

	// The name of the database.
	Database *string `locationName:"database" type:"string"`

	// The parameter set for the batch operation.
	//
	// The SQL statement is executed as many times as the number of parameter sets
	// provided. To execute a SQL statement with no parameters, use one of the following
	// options:
	//
	//    * Specify one or more empty parameter sets.
	//
	//    * Use the ExecuteStatement operation instead of the BatchExecuteStatement
	//    operation.
	//
	// Array parameters are not supported.
	ParameterSets [][]*SqlParameter `locationName:"parameterSets" type:"list"`

	// The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"11" type:"string" required:"true"`

	// The name of the database schema.
	Schema *string `locationName:"schema" type:"string"`

	// The name or ARN of the secret that enables access to the DB cluster.
	//
	// SecretArn is a required field
	SecretArn *string `locationName:"secretArn" min:"11" type:"string" required:"true"`

	// The SQL statement to run.
	//
	// Sql is a required field
	Sql *string `locationName:"sql" type:"string" required:"true"`

	// The identifier of a transaction that was started by using the BeginTransaction
	// operation. Specify the transaction ID of the transaction that you want to
	// include the SQL statement in.
	//
	// If the SQL statement is not part of a transaction, don't set this parameter.
	TransactionId *string `locationName:"transactionId" type:"string"`
}

// String returns the string representation
func (s BatchExecuteStatementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchExecuteStatementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchExecuteStatementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchExecuteStatementInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 11))
	}
	if s.SecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("SecretArn", 11))
	}
	if s.Sql == nil {
		invalidParams.Add(request.NewErrParamRequired("Sql"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *BatchExecuteStatementInput) SetDatabase(v string) *BatchExecuteStatementInput {
	s.Database = &v
	return s
}

// SetParameterSets sets the ParameterSets field's value.
func (s *BatchExecuteStatementInput) SetParameterSets(v [][]*SqlParameter) *BatchExecuteStatementInput {
	s.ParameterSets = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *BatchExecuteStatementInput) SetResourceArn(v string) *BatchExecuteStatementInput {
	s.ResourceArn = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *BatchExecuteStatementInput) SetSchema(v string) *BatchExecuteStatementInput {
	s.Schema = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *BatchExecuteStatementInput) SetSecretArn(v string) *BatchExecuteStatementInput {
	s.SecretArn = &v
	return s
}

// SetSql sets the Sql field's value.
func (s *BatchExecuteStatementInput) SetSql(v string) *BatchExecuteStatementInput {
	s.Sql = &v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *BatchExecuteStatementInput) SetTransactionId(v string) *BatchExecuteStatementInput {
	s.TransactionId = &v
	return s
}

// The response elements represent the output of a SQL statement over an array
// of data.
type BatchExecuteStatementOutput struct {
	_ struct{} `type:"structure"`

	// The execution results of each batch entry.
	UpdateResults []*UpdateResult `locationName:"updateResults" type:"list"`
}

// String returns the string representation
func (s BatchExecuteStatementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchExecuteStatementOutput) GoString() string {
	return s.String()
}

// SetUpdateResults sets the UpdateResults field's value.
func (s *BatchExecuteStatementOutput) SetUpdateResults(v []*UpdateResult) *BatchExecuteStatementOutput {
	s.UpdateResults = v
	return s
}

// The request parameters represent the input of a request to start a SQL transaction.
type BeginTransactionInput struct {
	_ struct{} `type:"structure"`

	// The name of the database.
	Database *string `locationName:"database" type:"string"`

	// The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"11" type:"string" required:"true"`

	// The name of the database schema.
	Schema *string `locationName:"schema" type:"string"`

	// The name or ARN of the secret that enables access to the DB cluster.
	//
	// SecretArn is a required field
	SecretArn *string `locationName:"secretArn" min:"11" type:"string" required:"true"`
}

// String returns the string representation
func (s BeginTransactionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BeginTransactionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BeginTransactionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BeginTransactionInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 11))
	}
	if s.SecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("SecretArn", 11))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *BeginTransactionInput) SetDatabase(v string) *BeginTransactionInput {
	s.Database = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *BeginTransactionInput) SetResourceArn(v string) *BeginTransactionInput {
	s.ResourceArn = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *BeginTransactionInput) SetSchema(v string) *BeginTransactionInput {
	s.Schema = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *BeginTransactionInput) SetSecretArn(v string) *BeginTransactionInput {
	s.SecretArn = &v
	return s
}

// The response elements represent the output of a request to start a SQL transaction.
type BeginTransactionOutput struct {
	_ struct{} `type:"structure"`

	// The transaction ID of the transaction started by the call.
	TransactionId *string `locationName:"transactionId" type:"string"`
}

// String returns the string representation
func (s BeginTransactionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BeginTransactionOutput) GoString() string {
	return s.String()
}

// SetTransactionId sets the TransactionId field's value.
func (s *BeginTransactionOutput) SetTransactionId(v string) *BeginTransactionOutput {
	s.TransactionId = &v
	return s
}

// Contains the metadata for a column.
type ColumnMetadata struct {
	_ struct{} `type:"structure"`

	// The type of the column.
	ArrayBaseColumnType *int64 `locationName:"arrayBaseColumnType" type:"integer"`

	// A value that indicates whether the column increments automatically.
	IsAutoIncrement *bool `locationName:"isAutoIncrement" type:"boolean"`

	// A value that indicates whether the column is case-sensitive.
	IsCaseSensitive *bool `locationName:"isCaseSensitive" type:"boolean"`

	// A value that indicates whether the column contains currency values.
	IsCurrency *bool `locationName:"isCurrency" type:"boolean"`

	// A value that indicates whether an integer column is signed.
	IsSigned *bool `locationName:"isSigned" type:"boolean"`

	// The label for the column.
	Label *string `locationName:"label" type:"string"`

	// The name of the column.
	Name *string `locationName:"name" type:"string"`

	// A value that indicates whether the column is nullable.
	Nullable *int64 `locationName:"nullable" type:"integer"`

	// The precision value of a decimal number column.
	Precision *int64 `locationName:"precision" type:"integer"`

	// The scale value of a decimal number column.
	Scale *int64 `locationName:"scale" type:"integer"`

	// The name of the schema that owns the table that includes the column.
	SchemaName *string `locationName:"schemaName" type:"string"`

	// The name of the table that includes the column.
	TableName *string `locationName:"tableName" type:"string"`

	// The type of the column.
	Type *int64 `locationName:"type" type:"integer"`

	// The database-specific data type of the column.
	TypeName *string `locationName:"typeName" type:"string"`
}

// String returns the string representation
func (s ColumnMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ColumnMetadata) GoString() string {
	return s.String()
}

// SetArrayBaseColumnType sets the ArrayBaseColumnType field's value.
func (s *ColumnMetadata) SetArrayBaseColumnType(v int64) *ColumnMetadata {
	s.ArrayBaseColumnType = &v
	return s
}

// SetIsAutoIncrement sets the IsAutoIncrement field's value.
func (s *ColumnMetadata) SetIsAutoIncrement(v bool) *ColumnMetadata {
	s.IsAutoIncrement = &v
	return s
}

// SetIsCaseSensitive sets the IsCaseSensitive field's value.
func (s *ColumnMetadata) SetIsCaseSensitive(v bool) *ColumnMetadata {
	s.IsCaseSensitive = &v
	return s
}

// SetIsCurrency sets the IsCurrency field's value.
func (s *ColumnMetadata) SetIsCurrency(v bool) *ColumnMetadata {
	s.IsCurrency = &v
	return s
}

// SetIsSigned sets the IsSigned field's value.
func (s *ColumnMetadata) SetIsSigned(v bool) *ColumnMetadata {
	s.IsSigned = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *ColumnMetadata) SetLabel(v string) *ColumnMetadata {
	s.Label = &v
	return s
}

// SetName sets the Name field's value.
func (s *ColumnMetadata) SetName(v string) *ColumnMetadata {
	s.Name = &v
	return s
}

// SetNullable sets the Nullable field's value.
func (s *ColumnMetadata) SetNullable(v int64) *ColumnMetadata {
	s.Nullable = &v
	return s
}

// SetPrecision sets the Precision field's value.
func (s *ColumnMetadata) SetPrecision(v int64) *ColumnMetadata {
	s.Precision = &v
	return s
}

// SetScale sets the Scale field's value.
func (s *ColumnMetadata) SetScale(v int64) *ColumnMetadata {
	s.Scale = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *ColumnMetadata) SetSchemaName(v string) *ColumnMetadata {
	s.SchemaName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ColumnMetadata) SetTableName(v string) *ColumnMetadata {
	s.TableName = &v
	return s
}

// SetType sets the Type field's value.
func (s *ColumnMetadata) SetType(v int64) *ColumnMetadata {
	s.Type = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ColumnMetadata) SetTypeName(v string) *ColumnMetadata {
	s.TypeName = &v
	return s
}

// The request parameters represent the input of a commit transaction request.
type CommitTransactionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"11" type:"string" required:"true"`

	// The name or ARN of the secret that enables access to the DB cluster.
	//
	// SecretArn is a required field
	SecretArn *string `locationName:"secretArn" min:"11" type:"string" required:"true"`

	// The identifier of the transaction to end and commit.
	//
	// TransactionId is a required field
	TransactionId *string `locationName:"transactionId" type:"string" required:"true"`
}

// String returns the string representation
func (s CommitTransactionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommitTransactionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CommitTransactionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CommitTransactionInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 11))
	}
	if s.SecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("SecretArn", 11))
	}
	if s.TransactionId == nil {
		invalidParams.Add(request.NewErrParamRequired("TransactionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CommitTransactionInput) SetResourceArn(v string) *CommitTransactionInput {
	s.ResourceArn = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *CommitTransactionInput) SetSecretArn(v string) *CommitTransactionInput {
	s.SecretArn = &v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *CommitTransactionInput) SetTransactionId(v string) *CommitTransactionInput {
	s.TransactionId = &v
	return s
}

// The response elements represent the output of a commit transaction request.
type CommitTransactionOutput struct {
	_ struct{} `type:"structure"`

	// The status of the commit operation.
	TransactionStatus *string `locationName:"transactionStatus" type:"string"`
}

// String returns the string representation
func (s CommitTransactionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommitTransactionOutput) GoString() string {
	return s.String()
}

// SetTransactionStatus sets the TransactionStatus field's value.
func (s *CommitTransactionOutput) SetTransactionStatus(v string) *CommitTransactionOutput {
	s.TransactionStatus = &v
	return s
}

// The request parameters represent the input of a request to run one or more
// SQL statements.
type ExecuteSqlInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the secret that enables access to the DB
	// cluster.
	//
	// AwsSecretStoreArn is a required field
	AwsSecretStoreArn *string `locationName:"awsSecretStoreArn" min:"11" type:"string" required:"true"`

	// The name of the database.
	Database *string `locationName:"database" type:"string"`

	// The ARN of the Aurora Serverless DB cluster.
	//
	// DbClusterOrInstanceArn is a required field
	DbClusterOrInstanceArn *string `locationName:"dbClusterOrInstanceArn" min:"11" type:"string" required:"true"`

	// The name of the database schema.
	Schema *string `locationName:"schema" type:"string"`

	// One or more SQL statements to run on the DB cluster.
	//
	// You can separate SQL statements from each other with a semicolon (;). Any
	// valid SQL statement is permitted, including data definition, data manipulation,
	// and commit statements.
	//
	// SqlStatements is a required field
	SqlStatements *string `locationName:"sqlStatements" type:"string" required:"true"`
}

// String returns the string representation
func (s ExecuteSqlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecuteSqlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecuteSqlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecuteSqlInput"}
	if s.AwsSecretStoreArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsSecretStoreArn"))
	}
	if s.AwsSecretStoreArn != nil && len(*s.AwsSecretStoreArn) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("AwsSecretStoreArn", 11))
	}
	if s.DbClusterOrInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DbClusterOrInstanceArn"))
	}
	if s.DbClusterOrInstanceArn != nil && len(*s.DbClusterOrInstanceArn) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("DbClusterOrInstanceArn", 11))
	}
	if s.SqlStatements == nil {
		invalidParams.Add(request.NewErrParamRequired("SqlStatements"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsSecretStoreArn sets the AwsSecretStoreArn field's value.
func (s *ExecuteSqlInput) SetAwsSecretStoreArn(v string) *ExecuteSqlInput {
	s.AwsSecretStoreArn = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *ExecuteSqlInput) SetDatabase(v string) *ExecuteSqlInput {
	s.Database = &v
	return s
}

// SetDbClusterOrInstanceArn sets the DbClusterOrInstanceArn field's value.
func (s *ExecuteSqlInput) SetDbClusterOrInstanceArn(v string) *ExecuteSqlInput {
	s.DbClusterOrInstanceArn = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *ExecuteSqlInput) SetSchema(v string) *ExecuteSqlInput {
	s.Schema = &v
	return s
}

// SetSqlStatements sets the SqlStatements field's value.
func (s *ExecuteSqlInput) SetSqlStatements(v string) *ExecuteSqlInput {
	s.SqlStatements = &v
	return s
}

// The response elements represent the output of a request to run one or more
// SQL statements.
type ExecuteSqlOutput struct {
	_ struct{} `type:"structure"`

	// The results of the SQL statement or statements.
	SqlStatementResults []*SqlStatementResult `locationName:"sqlStatementResults" type:"list"`
}

// String returns the string representation
func (s ExecuteSqlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecuteSqlOutput) GoString() string {
	return s.String()
}

// SetSqlStatementResults sets the SqlStatementResults field's value.
func (s *ExecuteSqlOutput) SetSqlStatementResults(v []*SqlStatementResult) *ExecuteSqlOutput {
	s.SqlStatementResults = v
	return s
}

// The request parameters represent the input of a request to run a SQL statement
// against a database.
type ExecuteStatementInput struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether to continue running the statement after the
	// call times out. By default, the statement stops running when the call times
	// out.
	//
	// For DDL statements, we recommend continuing to run the statement after the
	// call times out. When a DDL statement terminates before it is finished running,
	// it can result in errors and possibly corrupted data structures.
	ContinueAfterTimeout *bool `locationName:"continueAfterTimeout" type:"boolean"`

	// The name of the database.
	Database *string `locationName:"database" type:"string"`

	// A value that indicates whether to include metadata in the results.
	IncludeResultMetadata *bool `locationName:"includeResultMetadata" type:"boolean"`

	// The parameters for the SQL statement.
	//
	// Array parameters are not supported.
	Parameters []*SqlParameter `locationName:"parameters" type:"list"`

	// The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"11" type:"string" required:"true"`

	// Options that control how the result set is returned.
	ResultSetOptions *ResultSetOptions `locationName:"resultSetOptions" type:"structure"`

	// The name of the database schema.
	Schema *string `locationName:"schema" type:"string"`

	// The name or ARN of the secret that enables access to the DB cluster.
	//
	// SecretArn is a required field
	SecretArn *string `locationName:"secretArn" min:"11" type:"string" required:"true"`

	// The SQL statement to run.
	//
	// Sql is a required field
	Sql *string `locationName:"sql" type:"string" required:"true"`

	// The identifier of a transaction that was started by using the BeginTransaction
	// operation. Specify the transaction ID of the transaction that you want to
	// include the SQL statement in.
	//
	// If the SQL statement is not part of a transaction, don't set this parameter.
	TransactionId *string `locationName:"transactionId" type:"string"`
}

// String returns the string representation
func (s ExecuteStatementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecuteStatementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecuteStatementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecuteStatementInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 11))
	}
	if s.SecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("SecretArn", 11))
	}
	if s.Sql == nil {
		invalidParams.Add(request.NewErrParamRequired("Sql"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContinueAfterTimeout sets the ContinueAfterTimeout field's value.
func (s *ExecuteStatementInput) SetContinueAfterTimeout(v bool) *ExecuteStatementInput {
	s.ContinueAfterTimeout = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *ExecuteStatementInput) SetDatabase(v string) *ExecuteStatementInput {
	s.Database = &v
	return s
}

// SetIncludeResultMetadata sets the IncludeResultMetadata field's value.
func (s *ExecuteStatementInput) SetIncludeResultMetadata(v bool) *ExecuteStatementInput {
	s.IncludeResultMetadata = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ExecuteStatementInput) SetParameters(v []*SqlParameter) *ExecuteStatementInput {
	s.Parameters = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ExecuteStatementInput) SetResourceArn(v string) *ExecuteStatementInput {
	s.ResourceArn = &v
	return s
}

// SetResultSetOptions sets the ResultSetOptions field's value.
func (s *ExecuteStatementInput) SetResultSetOptions(v *ResultSetOptions) *ExecuteStatementInput {
	s.ResultSetOptions = v
	return s
}

// SetSchema sets the Schema field's value.
func (s *ExecuteStatementInput) SetSchema(v string) *ExecuteStatementInput {
	s.Schema = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *ExecuteStatementInput) SetSecretArn(v string) *ExecuteStatementInput {
	s.SecretArn = &v
	return s
}

// SetSql sets the Sql field's value.
func (s *ExecuteStatementInput) SetSql(v string) *ExecuteStatementInput {
	s.Sql = &v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *ExecuteStatementInput) SetTransactionId(v string) *ExecuteStatementInput {
	s.TransactionId = &v
	return s
}

// The response elements represent the output of a request to run a SQL statement
// against a database.
type ExecuteStatementOutput struct {
	_ struct{} `type:"structure"`

	// Metadata for the columns included in the results.
	ColumnMetadata []*ColumnMetadata `locationName:"columnMetadata" type:"list"`

	// Values for fields generated during the request.
	//
	//    <note> <p>The <code>generatedFields</code> data isn't supported by Aurora
	//    PostgreSQL. To get the values of generated fields, use the <code>RETURNING</code>
	//    clause. For more information, see <a href="https://www.postgresql.org/docs/10/dml-returning.html">Returning
	//    Data From Modified Rows</a> in the PostgreSQL documentation.</p> </note>
	GeneratedFields []*Field `locationName:"generatedFields" type:"list"`

	// The number of records updated by the request.
	NumberOfRecordsUpdated *int64 `locationName:"numberOfRecordsUpdated" type:"long"`

	// The records returned by the SQL statement.
	Records [][]*Field `locationName:"records" type:"list"`
}

// String returns the string representation
func (s ExecuteStatementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecuteStatementOutput) GoString() string {
	return s.String()
}

// SetColumnMetadata sets the ColumnMetadata field's value.
func (s *ExecuteStatementOutput) SetColumnMetadata(v []*ColumnMetadata) *ExecuteStatementOutput {
	s.ColumnMetadata = v
	return s
}

// SetGeneratedFields sets the GeneratedFields field's value.
func (s *ExecuteStatementOutput) SetGeneratedFields(v []*Field) *ExecuteStatementOutput {
	s.GeneratedFields = v
	return s
}

// SetNumberOfRecordsUpdated sets the NumberOfRecordsUpdated field's value.
func (s *ExecuteStatementOutput) SetNumberOfRecordsUpdated(v int64) *ExecuteStatementOutput {
	s.NumberOfRecordsUpdated = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *ExecuteStatementOutput) SetRecords(v [][]*Field) *ExecuteStatementOutput {
	s.Records = v
	return s
}

// Contains a value.
type Field struct {
	_ struct{} `type:"structure"`

	// An array of values.
	ArrayValue *ArrayValue `locationName:"arrayValue" type:"structure"`

	// A value of BLOB data type.
	//
	// BlobValue is automatically base64 encoded/decoded by the SDK.
	BlobValue []byte `locationName:"blobValue" type:"blob"`

	// A value of Boolean data type.
	BooleanValue *bool `locationName:"booleanValue" type:"boolean"`

	// A value of double data type.
	DoubleValue *float64 `locationName:"doubleValue" type:"double"`

	// A NULL value.
	IsNull *bool `locationName:"isNull" type:"boolean"`

	// A value of long data type.
	LongValue *int64 `locationName:"longValue" type:"long"`

	// A value of string data type.
	StringValue *string `locationName:"stringValue" type:"string"`
}

// String returns the string representation
func (s Field) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Field) GoString() string {
	return s.String()
}

// SetArrayValue sets the ArrayValue field's value.
func (s *Field) SetArrayValue(v *ArrayValue) *Field {
	s.ArrayValue = v
	return s
}

// SetBlobValue sets the BlobValue field's value.
func (s *Field) SetBlobValue(v []byte) *Field {
	s.BlobValue = v
	return s
}

// SetBooleanValue sets the BooleanValue field's value.
func (s *Field) SetBooleanValue(v bool) *Field {
	s.BooleanValue = &v
	return s
}

// SetDoubleValue sets the DoubleValue field's value.
func (s *Field) SetDoubleValue(v float64) *Field {
	s.DoubleValue = &v
	return s
}

// SetIsNull sets the IsNull field's value.
func (s *Field) SetIsNull(v bool) *Field {
	s.IsNull = &v
	return s
}

// SetLongValue sets the LongValue field's value.
func (s *Field) SetLongValue(v int64) *Field {
	s.LongValue = &v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *Field) SetStringValue(v string) *Field {
	s.StringValue = &v
	return s
}

// There are insufficient privileges to make the call.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message returned by this ForbiddenException error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An internal error occurred.
type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resourceArn, secretArn, or transactionId value can't be found.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message returned by this NotFoundException error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A record returned by a call.
type Record struct {
	_ struct{} `type:"structure"`

	// The values returned in the record.
	Values []*Value `locationName:"values" type:"list"`
}

// String returns the string representation
func (s Record) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Record) GoString() string {
	return s.String()
}

// SetValues sets the Values field's value.
func (s *Record) SetValues(v []*Value) *Record {
	s.Values = v
	return s
}

// The result set returned by a SQL statement.
type ResultFrame struct {
	_ struct{} `type:"structure"`

	// The records in the result set.
	Records []*Record `locationName:"records" type:"list"`

	// The result-set metadata in the result set.
	ResultSetMetadata *ResultSetMetadata `locationName:"resultSetMetadata" type:"structure"`
}

// String returns the string representation
func (s ResultFrame) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultFrame) GoString() string {
	return s.String()
}

// SetRecords sets the Records field's value.
func (s *ResultFrame) SetRecords(v []*Record) *ResultFrame {
	s.Records = v
	return s
}

// SetResultSetMetadata sets the ResultSetMetadata field's value.
func (s *ResultFrame) SetResultSetMetadata(v *ResultSetMetadata) *ResultFrame {
	s.ResultSetMetadata = v
	return s
}

// The metadata of the result set returned by a SQL statement.
type ResultSetMetadata struct {
	_ struct{} `type:"structure"`

	// The number of columns in the result set.
	ColumnCount *int64 `locationName:"columnCount" type:"long"`

	// The metadata of the columns in the result set.
	ColumnMetadata []*ColumnMetadata `locationName:"columnMetadata" type:"list"`
}

// String returns the string representation
func (s ResultSetMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultSetMetadata) GoString() string {
	return s.String()
}

// SetColumnCount sets the ColumnCount field's value.
func (s *ResultSetMetadata) SetColumnCount(v int64) *ResultSetMetadata {
	s.ColumnCount = &v
	return s
}

// SetColumnMetadata sets the ColumnMetadata field's value.
func (s *ResultSetMetadata) SetColumnMetadata(v []*ColumnMetadata) *ResultSetMetadata {
	s.ColumnMetadata = v
	return s
}

// Options that control how the result set is returned.
type ResultSetOptions struct {
	_ struct{} `type:"structure"`

	// A value that indicates how a field of DECIMAL type is represented in the
	// response. The value of STRING, the default, specifies that it is converted
	// to a String value. The value of DOUBLE_OR_LONG specifies that it is converted
	// to a Long value if its scale is 0, or to a Double value otherwise.
	//
	// Conversion to Double or Long can result in roundoff errors due to precision
	// loss. We recommend converting to String, especially when working with currency
	// values.
	DecimalReturnType *string `locationName:"decimalReturnType" type:"string" enum:"DecimalReturnType"`
}

// String returns the string representation
func (s ResultSetOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultSetOptions) GoString() string {
	return s.String()
}

// SetDecimalReturnType sets the DecimalReturnType field's value.
func (s *ResultSetOptions) SetDecimalReturnType(v string) *ResultSetOptions {
	s.DecimalReturnType = &v
	return s
}

// The request parameters represent the input of a request to perform a rollback
// of a transaction.
type RollbackTransactionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"11" type:"string" required:"true"`

	// The name or ARN of the secret that enables access to the DB cluster.
	//
	// SecretArn is a required field
	SecretArn *string `locationName:"secretArn" min:"11" type:"string" required:"true"`

	// The identifier of the transaction to roll back.
	//
	// TransactionId is a required field
	TransactionId *string `locationName:"transactionId" type:"string" required:"true"`
}

// String returns the string representation
func (s RollbackTransactionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RollbackTransactionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RollbackTransactionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RollbackTransactionInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 11))
	}
	if s.SecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArn"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("SecretArn", 11))
	}
	if s.TransactionId == nil {
		invalidParams.Add(request.NewErrParamRequired("TransactionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *RollbackTransactionInput) SetResourceArn(v string) *RollbackTransactionInput {
	s.ResourceArn = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *RollbackTransactionInput) SetSecretArn(v string) *RollbackTransactionInput {
	s.SecretArn = &v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *RollbackTransactionInput) SetTransactionId(v string) *RollbackTransactionInput {
	s.TransactionId = &v
	return s
}

// The response elements represent the output of a request to perform a rollback
// of a transaction.
type RollbackTransactionOutput struct {
	_ struct{} `type:"structure"`

	// The status of the rollback operation.
	TransactionStatus *string `locationName:"transactionStatus" type:"string"`
}

// String returns the string representation
func (s RollbackTransactionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RollbackTransactionOutput) GoString() string {
	return s.String()
}

// SetTransactionStatus sets the TransactionStatus field's value.
func (s *RollbackTransactionOutput) SetTransactionStatus(v string) *RollbackTransactionOutput {
	s.TransactionStatus = &v
	return s
}

// The service specified by the resourceArn parameter is not available.
type ServiceUnavailableError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableError) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableError(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableError) Code() string {
	return "ServiceUnavailableError"
}

// Message returns the exception's message.
func (s *ServiceUnavailableError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableError) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableError) RequestID() string {
	return s.RespMetadata.RequestID
}

// A parameter used in a SQL statement.
type SqlParameter struct {
	_ struct{} `type:"structure"`

	// The name of the parameter.
	Name *string `locationName:"name" type:"string"`

	// A hint that specifies the correct object type for data type mapping.
	//
	// Values:
	//
	//    * DECIMAL - The corresponding String parameter value is sent as an object
	//    of DECIMAL type to the database.
	//
	//    * TIMESTAMP - The corresponding String parameter value is sent as an object
	//    of TIMESTAMP type to the database. The accepted format is YYYY-MM-DD HH:MM:SS[.FFF].
	//
	//    * TIME - The corresponding String parameter value is sent as an object
	//    of TIME type to the database. The accepted format is HH:MM:SS[.FFF].
	//
	//    * DATE - The corresponding String parameter value is sent as an object
	//    of DATE type to the database. The accepted format is YYYY-MM-DD.
	TypeHint *string `locationName:"typeHint" type:"string" enum:"TypeHint"`

	// The value of the parameter.
	Value *Field `locationName:"value" type:"structure"`
}

// String returns the string representation
func (s SqlParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SqlParameter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *SqlParameter) SetName(v string) *SqlParameter {
	s.Name = &v
	return s
}

// SetTypeHint sets the TypeHint field's value.
func (s *SqlParameter) SetTypeHint(v string) *SqlParameter {
	s.TypeHint = &v
	return s
}

// SetValue sets the Value field's value.
func (s *SqlParameter) SetValue(v *Field) *SqlParameter {
	s.Value = v
	return s
}

// The result of a SQL statement.
//
//    <important> <p>This data type is deprecated.</p> </important>
type SqlStatementResult struct {
	_ struct{} `type:"structure"`

	// The number of records updated by a SQL statement.
	NumberOfRecordsUpdated *int64 `locationName:"numberOfRecordsUpdated" type:"long"`

	// The result set of the SQL statement.
	ResultFrame *ResultFrame `locationName:"resultFrame" type:"structure"`
}

// String returns the string representation
func (s SqlStatementResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SqlStatementResult) GoString() string {
	return s.String()
}

// SetNumberOfRecordsUpdated sets the NumberOfRecordsUpdated field's value.
func (s *SqlStatementResult) SetNumberOfRecordsUpdated(v int64) *SqlStatementResult {
	s.NumberOfRecordsUpdated = &v
	return s
}

// SetResultFrame sets the ResultFrame field's value.
func (s *SqlStatementResult) SetResultFrame(v *ResultFrame) *SqlStatementResult {
	s.ResultFrame = v
	return s
}

// The execution of the SQL statement timed out.
type StatementTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The database connection ID that executed the SQL statement.
	DbConnectionId *int64 `locationName:"dbConnectionId" type:"long"`

	// The error message returned by this StatementTimeoutException error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s StatementTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StatementTimeoutException) GoString() string {
	return s.String()
}

func newErrorStatementTimeoutException(v protocol.ResponseMetadata) error {
	return &StatementTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *StatementTimeoutException) Code() string {
	return "StatementTimeoutException"
}

// Message returns the exception's message.
func (s *StatementTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *StatementTimeoutException) OrigErr() error {
	return nil
}

func (s *StatementTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *StatementTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *StatementTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure value returned by a call.
type StructValue struct {
	_ struct{} `type:"structure"`

	// The attributes returned in the record.
	Attributes []*Value `locationName:"attributes" type:"list"`
}

// String returns the string representation
func (s StructValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StructValue) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *StructValue) SetAttributes(v []*Value) *StructValue {
	s.Attributes = v
	return s
}

// The response elements represent the results of an update.
type UpdateResult struct {
	_ struct{} `type:"structure"`

	// Values for fields generated during the request.
	GeneratedFields []*Field `locationName:"generatedFields" type:"list"`
}

// String returns the string representation
func (s UpdateResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResult) GoString() string {
	return s.String()
}

// SetGeneratedFields sets the GeneratedFields field's value.
func (s *UpdateResult) SetGeneratedFields(v []*Field) *UpdateResult {
	s.GeneratedFields = v
	return s
}

// Contains the value of a column.
//
//    <important> <p>This data type is deprecated.</p> </important>
type Value struct {
	_ struct{} `type:"structure"`

	// An array of column values.
	ArrayValues []*Value `locationName:"arrayValues" type:"list"`

	// A value for a column of big integer data type.
	BigIntValue *int64 `locationName:"bigIntValue" type:"long"`

	// A value for a column of BIT data type.
	BitValue *bool `locationName:"bitValue" type:"boolean"`

	// A value for a column of BLOB data type.
	//
	// BlobValue is automatically base64 encoded/decoded by the SDK.
	BlobValue []byte `locationName:"blobValue" type:"blob"`

	// A value for a column of double data type.
	DoubleValue *float64 `locationName:"doubleValue" type:"double"`

	// A value for a column of integer data type.
	IntValue *int64 `locationName:"intValue" type:"integer"`

	// A NULL value.
	IsNull *bool `locationName:"isNull" type:"boolean"`

	// A value for a column of real data type.
	RealValue *float64 `locationName:"realValue" type:"float"`

	// A value for a column of string data type.
	StringValue *string `locationName:"stringValue" type:"string"`

	// A value for a column of STRUCT data type.
	StructValue *StructValue `locationName:"structValue" type:"structure"`
}

// String returns the string representation
func (s Value) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Value) GoString() string {
	return s.String()
}

// SetArrayValues sets the ArrayValues field's value.
func (s *Value) SetArrayValues(v []*Value) *Value {
	s.ArrayValues = v
	return s
}

// SetBigIntValue sets the BigIntValue field's value.
func (s *Value) SetBigIntValue(v int64) *Value {
	s.BigIntValue = &v
	return s
}

// SetBitValue sets the BitValue field's value.
func (s *Value) SetBitValue(v bool) *Value {
	s.BitValue = &v
	return s
}

// SetBlobValue sets the BlobValue field's value.
func (s *Value) SetBlobValue(v []byte) *Value {
	s.BlobValue = v
	return s
}

// SetDoubleValue sets the DoubleValue field's value.
func (s *Value) SetDoubleValue(v float64) *Value {
	s.DoubleValue = &v
	return s
}

// SetIntValue sets the IntValue field's value.
func (s *Value) SetIntValue(v int64) *Value {
	s.IntValue = &v
	return s
}

// SetIsNull sets the IsNull field's value.
func (s *Value) SetIsNull(v bool) *Value {
	s.IsNull = &v
	return s
}

// SetRealValue sets the RealValue field's value.
func (s *Value) SetRealValue(v float64) *Value {
	s.RealValue = &v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *Value) SetStringValue(v string) *Value {
	s.StringValue = &v
	return s
}

// SetStructValue sets the StructValue field's value.
func (s *Value) SetStructValue(v *StructValue) *Value {
	s.StructValue = v
	return s
}

const (
	// DecimalReturnTypeDoubleOrLong is a DecimalReturnType enum value
	DecimalReturnTypeDoubleOrLong = "DOUBLE_OR_LONG"

	// DecimalReturnTypeString is a DecimalReturnType enum value
	DecimalReturnTypeString = "STRING"
)

// DecimalReturnType_Values returns all elements of the DecimalReturnType enum
func DecimalReturnType_Values() []string {
	return []string{
		DecimalReturnTypeDoubleOrLong,
		DecimalReturnTypeString,
	}
}

const (
	// TypeHintDate is a TypeHint enum value
	TypeHintDate = "DATE"

	// TypeHintDecimal is a TypeHint enum value
	TypeHintDecimal = "DECIMAL"

	// TypeHintTime is a TypeHint enum value
	TypeHintTime = "TIME"

	// TypeHintTimestamp is a TypeHint enum value
	TypeHintTimestamp = "TIMESTAMP"
)

// TypeHint_Values returns all elements of the TypeHint enum
func TypeHint_Values() []string {
	return []string{
		TypeHintDate,
		TypeHintDecimal,
		TypeHintTime,
		TypeHintTimestamp,
	}
}
