// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisableAddOnInput struct {
	_ struct{} `type:"structure"`

	// The add-on type to disable.
	//
	// AddOnType is a required field
	AddOnType AddOnType `locationName:"addOnType" type:"string" required:"true" enum:"true"`

	// The name of the source resource from which to disable the add-on.
	//
	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableAddOnInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableAddOnInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisableAddOnInput"}
	if len(s.AddOnType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("AddOnType"))
	}

	if s.ResourceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisableAddOnOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of your request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DisableAddOnOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisableAddOn = "DisableAddOn"

// DisableAddOnRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Disables an add-on for an Amazon Lightsail resource. For more information,
// see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
//
//    // Example sending a request using DisableAddOnRequest.
//    req := client.DisableAddOnRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DisableAddOn
func (c *Client) DisableAddOnRequest(input *DisableAddOnInput) DisableAddOnRequest {
	op := &aws.Operation{
		Name:       opDisableAddOn,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableAddOnInput{}
	}

	req := c.newRequest(op, input, &DisableAddOnOutput{})
	return DisableAddOnRequest{Request: req, Input: input, Copy: c.DisableAddOnRequest}
}

// DisableAddOnRequest is the request type for the
// DisableAddOn API operation.
type DisableAddOnRequest struct {
	*aws.Request
	Input *DisableAddOnInput
	Copy  func(*DisableAddOnInput) DisableAddOnRequest
}

// Send marshals and sends the DisableAddOn API request.
func (r DisableAddOnRequest) Send(ctx context.Context) (*DisableAddOnResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableAddOnResponse{
		DisableAddOnOutput: r.Request.Data.(*DisableAddOnOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableAddOnResponse is the response type for the
// DisableAddOn API operation.
type DisableAddOnResponse struct {
	*DisableAddOnOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableAddOn request.
func (r *DisableAddOnResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
