// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package groundstation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListMissionProfilesInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMissionProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListMissionProfilesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListMissionProfilesOutput struct {
	_ struct{} `type:"structure"`

	MissionProfileList []MissionProfileListItem `locationName:"missionProfileList" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMissionProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListMissionProfilesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.MissionProfileList != nil {
		v := s.MissionProfileList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "missionProfileList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListMissionProfiles = "ListMissionProfiles"

// ListMissionProfilesRequest returns a request value for making API operation for
// AWS Ground Station.
//
// Returns a list of mission profiles.
//
//    // Example sending a request using ListMissionProfilesRequest.
//    req := client.ListMissionProfilesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListMissionProfiles
func (c *Client) ListMissionProfilesRequest(input *ListMissionProfilesInput) ListMissionProfilesRequest {
	op := &aws.Operation{
		Name:       opListMissionProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/missionprofile",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMissionProfilesInput{}
	}

	req := c.newRequest(op, input, &ListMissionProfilesOutput{})
	return ListMissionProfilesRequest{Request: req, Input: input, Copy: c.ListMissionProfilesRequest}
}

// ListMissionProfilesRequest is the request type for the
// ListMissionProfiles API operation.
type ListMissionProfilesRequest struct {
	*aws.Request
	Input *ListMissionProfilesInput
	Copy  func(*ListMissionProfilesInput) ListMissionProfilesRequest
}

// Send marshals and sends the ListMissionProfiles API request.
func (r ListMissionProfilesRequest) Send(ctx context.Context) (*ListMissionProfilesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListMissionProfilesResponse{
		ListMissionProfilesOutput: r.Request.Data.(*ListMissionProfilesOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListMissionProfilesRequestPaginator returns a paginator for ListMissionProfiles.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListMissionProfilesRequest(input)
//   p := groundstation.NewListMissionProfilesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListMissionProfilesPaginator(req ListMissionProfilesRequest) ListMissionProfilesPaginator {
	return ListMissionProfilesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListMissionProfilesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListMissionProfilesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListMissionProfilesPaginator struct {
	aws.Pager
}

func (p *ListMissionProfilesPaginator) CurrentPage() *ListMissionProfilesOutput {
	return p.Pager.CurrentPage().(*ListMissionProfilesOutput)
}

// ListMissionProfilesResponse is the response type for the
// ListMissionProfiles API operation.
type ListMissionProfilesResponse struct {
	*ListMissionProfilesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListMissionProfiles request.
func (r *ListMissionProfilesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
