// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetSecurityConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is a continuation call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetSecurityConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSecurityConfigurationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetSecurityConfigurationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetSecurityConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token, if there are more security configurations to return.
	NextToken *string `type:"string"`

	// A list of security configurations.
	SecurityConfigurations []SecurityConfiguration `type:"list"`
}

// String returns the string representation
func (s GetSecurityConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetSecurityConfigurations = "GetSecurityConfigurations"

// GetSecurityConfigurationsRequest returns a request value for making API operation for
// AWS Glue.
//
// Retrieves a list of all security configurations.
//
//    // Example sending a request using GetSecurityConfigurationsRequest.
//    req := client.GetSecurityConfigurationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfigurations
func (c *Client) GetSecurityConfigurationsRequest(input *GetSecurityConfigurationsInput) GetSecurityConfigurationsRequest {
	op := &aws.Operation{
		Name:       opGetSecurityConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetSecurityConfigurationsInput{}
	}

	req := c.newRequest(op, input, &GetSecurityConfigurationsOutput{})
	return GetSecurityConfigurationsRequest{Request: req, Input: input, Copy: c.GetSecurityConfigurationsRequest}
}

// GetSecurityConfigurationsRequest is the request type for the
// GetSecurityConfigurations API operation.
type GetSecurityConfigurationsRequest struct {
	*aws.Request
	Input *GetSecurityConfigurationsInput
	Copy  func(*GetSecurityConfigurationsInput) GetSecurityConfigurationsRequest
}

// Send marshals and sends the GetSecurityConfigurations API request.
func (r GetSecurityConfigurationsRequest) Send(ctx context.Context) (*GetSecurityConfigurationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSecurityConfigurationsResponse{
		GetSecurityConfigurationsOutput: r.Request.Data.(*GetSecurityConfigurationsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetSecurityConfigurationsRequestPaginator returns a paginator for GetSecurityConfigurations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetSecurityConfigurationsRequest(input)
//   p := glue.NewGetSecurityConfigurationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetSecurityConfigurationsPaginator(req GetSecurityConfigurationsRequest) GetSecurityConfigurationsPaginator {
	return GetSecurityConfigurationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetSecurityConfigurationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetSecurityConfigurationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetSecurityConfigurationsPaginator struct {
	aws.Pager
}

func (p *GetSecurityConfigurationsPaginator) CurrentPage() *GetSecurityConfigurationsOutput {
	return p.Pager.CurrentPage().(*GetSecurityConfigurationsOutput)
}

// GetSecurityConfigurationsResponse is the response type for the
// GetSecurityConfigurations API operation.
type GetSecurityConfigurationsResponse struct {
	*GetSecurityConfigurationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSecurityConfigurations request.
func (r *GetSecurityConfigurationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
