// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dax

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeSubnetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	//
	// The value for MaxResults must be between 20 and 100.
	MaxResults *int64 `type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `type:"string"`

	// The name of the subnet group.
	SubnetGroupNames []string `type:"list"`
}

// String returns the string representation
func (s DescribeSubnetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeSubnetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string `type:"string"`

	// An array of subnet groups. Each element in the array represents a single
	// subnet group.
	SubnetGroups []SubnetGroup `type:"list"`
}

// String returns the string representation
func (s DescribeSubnetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeSubnetGroups = "DescribeSubnetGroups"

// DescribeSubnetGroupsRequest returns a request value for making API operation for
// Amazon DynamoDB Accelerator (DAX).
//
// Returns a list of subnet group descriptions. If a subnet group name is specified,
// the list will contain only the description of that group.
//
//    // Example sending a request using DescribeSubnetGroupsRequest.
//    req := client.DescribeSubnetGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeSubnetGroups
func (c *Client) DescribeSubnetGroupsRequest(input *DescribeSubnetGroupsInput) DescribeSubnetGroupsRequest {
	op := &aws.Operation{
		Name:       opDescribeSubnetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSubnetGroupsInput{}
	}

	req := c.newRequest(op, input, &DescribeSubnetGroupsOutput{})
	return DescribeSubnetGroupsRequest{Request: req, Input: input, Copy: c.DescribeSubnetGroupsRequest}
}

// DescribeSubnetGroupsRequest is the request type for the
// DescribeSubnetGroups API operation.
type DescribeSubnetGroupsRequest struct {
	*aws.Request
	Input *DescribeSubnetGroupsInput
	Copy  func(*DescribeSubnetGroupsInput) DescribeSubnetGroupsRequest
}

// Send marshals and sends the DescribeSubnetGroups API request.
func (r DescribeSubnetGroupsRequest) Send(ctx context.Context) (*DescribeSubnetGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeSubnetGroupsResponse{
		DescribeSubnetGroupsOutput: r.Request.Data.(*DescribeSubnetGroupsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeSubnetGroupsResponse is the response type for the
// DescribeSubnetGroups API operation.
type DescribeSubnetGroupsResponse struct {
	*DescribeSubnetGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeSubnetGroups request.
func (r *DescribeSubnetGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
