// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetFaceSearchInput struct {
	_ struct{} `type:"structure"`

	// The job identifer for the search request. You get the job identifier from
	// an initial call to StartFaceSearch.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// Maximum number of results to return per paginated call. The largest value
	// you can specify is 1000. If you specify a value greater than 1000, a maximum
	// of 1000 results is returned. The default value is 1000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more search results
	// to retrieve), Amazon Rekognition Video returns a pagination token in the
	// response. You can use this pagination token to retrieve the next set of search
	// results.
	NextToken *string `type:"string"`

	// Sort to use for grouping faces in the response. Use TIMESTAMP to group faces
	// by the time that they are recognized. Use INDEX to sort by recognized faces.
	SortBy FaceSearchSortBy `type:"string" enum:"true"`
}

// String returns the string representation
func (s GetFaceSearchInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFaceSearchInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetFaceSearchInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetFaceSearchOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the face search job.
	JobStatus VideoJobStatus `type:"string" enum:"true"`

	// If the response is truncated, Amazon Rekognition Video returns this token
	// that you can use in the subsequent request to retrieve the next set of search
	// results.
	NextToken *string `type:"string"`

	// An array of persons, PersonMatch, in the video whose face(s) match the face(s)
	// in an Amazon Rekognition collection. It also includes time information for
	// when persons are matched in the video. You specify the input collection in
	// an initial call to StartFaceSearch. Each Persons element includes a time
	// the person was matched, face match details (FaceMatches) for matching faces
	// in the collection, and person information (Person) for the matched person.
	Persons []PersonMatch `type:"list"`

	// If the job fails, StatusMessage provides a descriptive error message.
	StatusMessage *string `type:"string"`

	// Information about a video that Amazon Rekognition analyzed. Videometadata
	// is returned in every page of paginated responses from a Amazon Rekognition
	// Video operation.
	VideoMetadata *VideoMetadata `type:"structure"`
}

// String returns the string representation
func (s GetFaceSearchOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetFaceSearch = "GetFaceSearch"

// GetFaceSearchRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Gets the face search results for Amazon Rekognition Video face search started
// by StartFaceSearch. The search returns faces in a collection that match the
// faces of persons detected in a video. It also includes the time(s) that faces
// are matched in the video.
//
// Face search in a video is an asynchronous operation. You start face search
// by calling to StartFaceSearch which returns a job identifier (JobId). When
// the search operation finishes, Amazon Rekognition Video publishes a completion
// status to the Amazon Simple Notification Service topic registered in the
// initial call to StartFaceSearch. To get the search results, first check that
// the status value published to the Amazon SNS topic is SUCCEEDED. If so, call
// GetFaceSearch and pass the job identifier (JobId) from the initial call to
// StartFaceSearch.
//
// For more information, see Searching Faces in a Collection in the Amazon Rekognition
// Developer Guide.
//
// The search results are retured in an array, Persons, of PersonMatch objects.
// EachPersonMatch element contains details about the matching faces in the
// input collection, person information (facial attributes, bounding boxes,
// and person identifer) for the matched person, and the time the person was
// matched in the video.
//
// GetFaceSearch only returns the default facial attributes (BoundingBox, Confidence,
// Landmarks, Pose, and Quality). The other facial attributes listed in the
// Face object of the following response syntax are not returned. For more information,
// see FaceDetail in the Amazon Rekognition Developer Guide.
//
// By default, the Persons array is sorted by the time, in milliseconds from
// the start of the video, persons are matched. You can also sort by persons
// by specifying INDEX for the SORTBY input parameter.
//
//    // Example sending a request using GetFaceSearchRequest.
//    req := client.GetFaceSearchRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetFaceSearchRequest(input *GetFaceSearchInput) GetFaceSearchRequest {
	op := &aws.Operation{
		Name:       opGetFaceSearch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetFaceSearchInput{}
	}

	req := c.newRequest(op, input, &GetFaceSearchOutput{})
	return GetFaceSearchRequest{Request: req, Input: input, Copy: c.GetFaceSearchRequest}
}

// GetFaceSearchRequest is the request type for the
// GetFaceSearch API operation.
type GetFaceSearchRequest struct {
	*aws.Request
	Input *GetFaceSearchInput
	Copy  func(*GetFaceSearchInput) GetFaceSearchRequest
}

// Send marshals and sends the GetFaceSearch API request.
func (r GetFaceSearchRequest) Send(ctx context.Context) (*GetFaceSearchResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetFaceSearchResponse{
		GetFaceSearchOutput: r.Request.Data.(*GetFaceSearchOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetFaceSearchRequestPaginator returns a paginator for GetFaceSearch.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetFaceSearchRequest(input)
//   p := rekognition.NewGetFaceSearchRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetFaceSearchPaginator(req GetFaceSearchRequest) GetFaceSearchPaginator {
	return GetFaceSearchPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetFaceSearchInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetFaceSearchPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetFaceSearchPaginator struct {
	aws.Pager
}

func (p *GetFaceSearchPaginator) CurrentPage() *GetFaceSearchOutput {
	return p.Pager.CurrentPage().(*GetFaceSearchOutput)
}

// GetFaceSearchResponse is the response type for the
// GetFaceSearch API operation.
type GetFaceSearchResponse struct {
	*GetFaceSearchOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetFaceSearch request.
func (r *GetFaceSearchResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
