// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package daxiface provides an interface to enable mocking the Amazon DynamoDB Accelerator (DAX) service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package daxiface

import (
	"github.com/aws/aws-sdk-go-v2/service/dax"
)

// ClientAPI provides an interface to enable mocking the
// dax.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon DAX.
//    func myFunc(svc daxiface.ClientAPI) bool {
//        // Make svc.CreateCluster request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := dax.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        daxiface.ClientPI
//    }
//    func (m *mockClientClient) CreateCluster(input *dax.CreateClusterInput) (*dax.CreateClusterOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateClusterRequest(*dax.CreateClusterInput) dax.CreateClusterRequest

	CreateParameterGroupRequest(*dax.CreateParameterGroupInput) dax.CreateParameterGroupRequest

	CreateSubnetGroupRequest(*dax.CreateSubnetGroupInput) dax.CreateSubnetGroupRequest

	DecreaseReplicationFactorRequest(*dax.DecreaseReplicationFactorInput) dax.DecreaseReplicationFactorRequest

	DeleteClusterRequest(*dax.DeleteClusterInput) dax.DeleteClusterRequest

	DeleteParameterGroupRequest(*dax.DeleteParameterGroupInput) dax.DeleteParameterGroupRequest

	DeleteSubnetGroupRequest(*dax.DeleteSubnetGroupInput) dax.DeleteSubnetGroupRequest

	DescribeClustersRequest(*dax.DescribeClustersInput) dax.DescribeClustersRequest

	DescribeDefaultParametersRequest(*dax.DescribeDefaultParametersInput) dax.DescribeDefaultParametersRequest

	DescribeEventsRequest(*dax.DescribeEventsInput) dax.DescribeEventsRequest

	DescribeParameterGroupsRequest(*dax.DescribeParameterGroupsInput) dax.DescribeParameterGroupsRequest

	DescribeParametersRequest(*dax.DescribeParametersInput) dax.DescribeParametersRequest

	DescribeSubnetGroupsRequest(*dax.DescribeSubnetGroupsInput) dax.DescribeSubnetGroupsRequest

	IncreaseReplicationFactorRequest(*dax.IncreaseReplicationFactorInput) dax.IncreaseReplicationFactorRequest

	ListTagsRequest(*dax.ListTagsInput) dax.ListTagsRequest

	RebootNodeRequest(*dax.RebootNodeInput) dax.RebootNodeRequest

	TagResourceRequest(*dax.TagResourceInput) dax.TagResourceRequest

	UntagResourceRequest(*dax.UntagResourceInput) dax.UntagResourceRequest

	UpdateClusterRequest(*dax.UpdateClusterInput) dax.UpdateClusterRequest

	UpdateParameterGroupRequest(*dax.UpdateParameterGroupInput) dax.UpdateParameterGroupRequest

	UpdateSubnetGroupRequest(*dax.UpdateSubnetGroupInput) dax.UpdateSubnetGroupRequest
}

var _ ClientAPI = (*dax.Client)(nil)
