// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteApiMappingInput struct {
	_ struct{} `type:"structure"`

	// ApiMappingId is a required field
	ApiMappingId *string `location:"uri" locationName:"apiMappingId" type:"string" required:"true"`

	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApiMappingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApiMappingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteApiMappingInput"}

	if s.ApiMappingId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiMappingId"))
	}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteApiMappingInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiMappingId != nil {
		v := *s.ApiMappingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiMappingId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "domainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteApiMappingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApiMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteApiMappingOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteApiMapping = "DeleteApiMapping"

// DeleteApiMappingRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Deletes an API mapping.
//
//    // Example sending a request using DeleteApiMappingRequest.
//    req := client.DeleteApiMappingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteApiMapping
func (c *Client) DeleteApiMappingRequest(input *DeleteApiMappingInput) DeleteApiMappingRequest {
	op := &aws.Operation{
		Name:       opDeleteApiMapping,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domainnames/{domainName}/apimappings/{apiMappingId}",
	}

	if input == nil {
		input = &DeleteApiMappingInput{}
	}

	req := c.newRequest(op, input, &DeleteApiMappingOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteApiMappingRequest{Request: req, Input: input, Copy: c.DeleteApiMappingRequest}
}

// DeleteApiMappingRequest is the request type for the
// DeleteApiMapping API operation.
type DeleteApiMappingRequest struct {
	*aws.Request
	Input *DeleteApiMappingInput
	Copy  func(*DeleteApiMappingInput) DeleteApiMappingRequest
}

// Send marshals and sends the DeleteApiMapping API request.
func (r DeleteApiMappingRequest) Send(ctx context.Context) (*DeleteApiMappingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteApiMappingResponse{
		DeleteApiMappingOutput: r.Request.Data.(*DeleteApiMappingOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteApiMappingResponse is the response type for the
// DeleteApiMapping API operation.
type DeleteApiMappingResponse struct {
	*DeleteApiMappingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteApiMapping request.
func (r *DeleteApiMappingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
