// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.10.1
// source: envoy/extensions/filters/network/redis_proxy/v3/redis_proxy.proto

package envoy_extensions_filters_network_redis_proxy_v3

import (
	_ "github.com/cncf/udpa/go/udpa/annotations"
	_ "github.com/envoyproxy/go-control-plane/envoy/annotations"
	v3 "github.com/envoyproxy/go-control-plane/envoy/config/core/v3"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// ReadPolicy controls how Envoy routes read commands to Redis nodes. This is currently
// supported for Redis Cluster. All ReadPolicy settings except MASTER may return stale data
// because replication is asynchronous and requires some delay. You need to ensure that your
// application can tolerate stale data.
type RedisProxy_ConnPoolSettings_ReadPolicy int32

const (
	// Default mode. Read from the current primary node.
	RedisProxy_ConnPoolSettings_MASTER RedisProxy_ConnPoolSettings_ReadPolicy = 0
	// Read from the primary, but if it is unavailable, read from replica nodes.
	RedisProxy_ConnPoolSettings_PREFER_MASTER RedisProxy_ConnPoolSettings_ReadPolicy = 1
	// Read from replica nodes. If multiple replica nodes are present within a shard, a random
	// node is selected. Healthy nodes have precedent over unhealthy nodes.
	RedisProxy_ConnPoolSettings_REPLICA RedisProxy_ConnPoolSettings_ReadPolicy = 2
	// Read from the replica nodes (similar to REPLICA), but if all replicas are unavailable (not
	// present or unhealthy), read from the primary.
	RedisProxy_ConnPoolSettings_PREFER_REPLICA RedisProxy_ConnPoolSettings_ReadPolicy = 3
	// Read from any node of the cluster. A random node is selected among the primary and
	// replicas, healthy nodes have precedent over unhealthy nodes.
	RedisProxy_ConnPoolSettings_ANY RedisProxy_ConnPoolSettings_ReadPolicy = 4
)

// Enum value maps for RedisProxy_ConnPoolSettings_ReadPolicy.
var (
	RedisProxy_ConnPoolSettings_ReadPolicy_name = map[int32]string{
		0: "MASTER",
		1: "PREFER_MASTER",
		2: "REPLICA",
		3: "PREFER_REPLICA",
		4: "ANY",
	}
	RedisProxy_ConnPoolSettings_ReadPolicy_value = map[string]int32{
		"MASTER":         0,
		"PREFER_MASTER":  1,
		"REPLICA":        2,
		"PREFER_REPLICA": 3,
		"ANY":            4,
	}
)

func (x RedisProxy_ConnPoolSettings_ReadPolicy) Enum() *RedisProxy_ConnPoolSettings_ReadPolicy {
	p := new(RedisProxy_ConnPoolSettings_ReadPolicy)
	*p = x
	return p
}

func (x RedisProxy_ConnPoolSettings_ReadPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RedisProxy_ConnPoolSettings_ReadPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_enumTypes[0].Descriptor()
}

func (RedisProxy_ConnPoolSettings_ReadPolicy) Type() protoreflect.EnumType {
	return &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_enumTypes[0]
}

func (x RedisProxy_ConnPoolSettings_ReadPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RedisProxy_ConnPoolSettings_ReadPolicy.Descriptor instead.
func (RedisProxy_ConnPoolSettings_ReadPolicy) EnumDescriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0, 0, 0}
}

type RedisProxy_RedisFault_RedisFaultType int32

const (
	// Delays requests. This is the base fault; other faults can have delays added.
	RedisProxy_RedisFault_DELAY RedisProxy_RedisFault_RedisFaultType = 0
	// Returns errors on requests.
	RedisProxy_RedisFault_ERROR RedisProxy_RedisFault_RedisFaultType = 1
)

// Enum value maps for RedisProxy_RedisFault_RedisFaultType.
var (
	RedisProxy_RedisFault_RedisFaultType_name = map[int32]string{
		0: "DELAY",
		1: "ERROR",
	}
	RedisProxy_RedisFault_RedisFaultType_value = map[string]int32{
		"DELAY": 0,
		"ERROR": 1,
	}
)

func (x RedisProxy_RedisFault_RedisFaultType) Enum() *RedisProxy_RedisFault_RedisFaultType {
	p := new(RedisProxy_RedisFault_RedisFaultType)
	*p = x
	return p
}

func (x RedisProxy_RedisFault_RedisFaultType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RedisProxy_RedisFault_RedisFaultType) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_enumTypes[1].Descriptor()
}

func (RedisProxy_RedisFault_RedisFaultType) Type() protoreflect.EnumType {
	return &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_enumTypes[1]
}

func (x RedisProxy_RedisFault_RedisFaultType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RedisProxy_RedisFault_RedisFaultType.Descriptor instead.
func (RedisProxy_RedisFault_RedisFaultType) EnumDescriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0, 2, 0}
}

// [#next-free-field: 9]
type RedisProxy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The prefix to use when emitting :ref:`statistics <config_network_filters_redis_proxy_stats>`.
	StatPrefix string `protobuf:"bytes,1,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"`
	// Network settings for the connection pool to the upstream clusters.
	Settings *RedisProxy_ConnPoolSettings `protobuf:"bytes,3,opt,name=settings,proto3" json:"settings,omitempty"`
	// Indicates that latency stat should be computed in microseconds. By default it is computed in
	// milliseconds. This does not apply to upstream command stats currently.
	LatencyInMicros bool `protobuf:"varint,4,opt,name=latency_in_micros,json=latencyInMicros,proto3" json:"latency_in_micros,omitempty"`
	// List of **unique** prefixes used to separate keys from different workloads to different
	// clusters. Envoy will always favor the longest match first in case of overlap. A catch-all
	// cluster can be used to forward commands when there is no match. Time complexity of the
	// lookups are in O(min(longest key prefix, key length)).
	//
	// Example:
	//
	// .. code-block:: yaml
	//
	//    prefix_routes:
	//      routes:
	//        - prefix: "ab"
	//          cluster: "cluster_a"
	//        - prefix: "abc"
	//          cluster: "cluster_b"
	//
	// When using the above routes, the following prefixes would be sent to:
	//
	// * ``get abc:users`` would retrieve the key 'abc:users' from cluster_b.
	// * ``get ab:users`` would retrieve the key 'ab:users' from cluster_a.
	// * ``get z:users`` would return a NoUpstreamHost error. A :ref:`catch-all
	//   route<envoy_api_field_extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.catch_all_route>`
	//   would have retrieved the key from that cluster instead.
	//
	// See the :ref:`configuration section
	// <arch_overview_redis_configuration>` of the architecture overview for recommendations on
	// configuring the backing clusters.
	PrefixRoutes *RedisProxy_PrefixRoutes `protobuf:"bytes,5,opt,name=prefix_routes,json=prefixRoutes,proto3" json:"prefix_routes,omitempty"`
	// Authenticate Redis client connections locally by forcing downstream clients to issue a `Redis
	// AUTH command <https://redis.io/commands/auth>`_ with this password before enabling any other
	// command. If an AUTH command's password matches this password, an "OK" response will be returned
	// to the client. If the AUTH command password does not match this password, then an "ERR invalid
	// password" error will be returned. If any other command is received before AUTH when this
	// password is set, then a "NOAUTH Authentication required." error response will be sent to the
	// client. If an AUTH command is received when the password is not set, then an "ERR Client sent
	// AUTH, but no password is set" error will be returned.
	DownstreamAuthPassword *v3.DataSource `protobuf:"bytes,6,opt,name=downstream_auth_password,json=downstreamAuthPassword,proto3" json:"downstream_auth_password,omitempty"`
	// List of faults to inject. Faults currently come in two flavors:
	// - Delay, which delays a request.
	// - Error, which responds to a request with an error. Errors can also have delays attached.
	//
	// Example:
	//
	// .. code-block:: yaml
	//
	//    faults:
	//    - fault_type: ERROR
	//      fault_enabled:
	//        default_value:
	//          numerator: 10
	//          denominator: HUNDRED
	//        runtime_key: "bogus_key"
	//        commands:
	//        - GET
	//      - fault_type: DELAY
	//        fault_enabled:
	//          default_value:
	//            numerator: 10
	//            denominator: HUNDRED
	//          runtime_key: "bogus_key"
	//        delay: 2s
	//
	// See the :ref:`fault injection section
	// <config_network_filters_redis_proxy_fault_injection>` for more information on how to configure this.
	Faults []*RedisProxy_RedisFault `protobuf:"bytes,8,rep,name=faults,proto3" json:"faults,omitempty"`
	// If a username is provided an ACL style AUTH command will be required with a username and password.
	// Authenticate Redis client connections locally by forcing downstream clients to issue a `Redis
	// AUTH command <https://redis.io/commands/auth>`_ with this username and the *downstream_auth_password*
	// before enabling any other command. If an AUTH command's username and password matches this username
	// and the *downstream_auth_password* , an "OK" response will be returned to the client. If the AUTH
	// command username or password does not match this username or the *downstream_auth_password*, then an
	// "WRONGPASS invalid username-password pair" error will be returned. If any other command is received before AUTH when this
	// password is set, then a "NOAUTH Authentication required." error response will be sent to the
	// client. If an AUTH command is received when the password is not set, then an "ERR Client sent
	// AUTH, but no ACL is set" error will be returned.
	DownstreamAuthUsername *v3.DataSource `protobuf:"bytes,7,opt,name=downstream_auth_username,json=downstreamAuthUsername,proto3" json:"downstream_auth_username,omitempty"`
	// Deprecated: Do not use.
	HiddenEnvoyDeprecatedCluster string `protobuf:"bytes,2,opt,name=hidden_envoy_deprecated_cluster,json=hiddenEnvoyDeprecatedCluster,proto3" json:"hidden_envoy_deprecated_cluster,omitempty"`
}

func (x *RedisProxy) Reset() {
	*x = RedisProxy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RedisProxy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisProxy) ProtoMessage() {}

func (x *RedisProxy) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisProxy.ProtoReflect.Descriptor instead.
func (*RedisProxy) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0}
}

func (x *RedisProxy) GetStatPrefix() string {
	if x != nil {
		return x.StatPrefix
	}
	return ""
}

func (x *RedisProxy) GetSettings() *RedisProxy_ConnPoolSettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *RedisProxy) GetLatencyInMicros() bool {
	if x != nil {
		return x.LatencyInMicros
	}
	return false
}

func (x *RedisProxy) GetPrefixRoutes() *RedisProxy_PrefixRoutes {
	if x != nil {
		return x.PrefixRoutes
	}
	return nil
}

func (x *RedisProxy) GetDownstreamAuthPassword() *v3.DataSource {
	if x != nil {
		return x.DownstreamAuthPassword
	}
	return nil
}

func (x *RedisProxy) GetFaults() []*RedisProxy_RedisFault {
	if x != nil {
		return x.Faults
	}
	return nil
}

func (x *RedisProxy) GetDownstreamAuthUsername() *v3.DataSource {
	if x != nil {
		return x.DownstreamAuthUsername
	}
	return nil
}

// Deprecated: Do not use.
func (x *RedisProxy) GetHiddenEnvoyDeprecatedCluster() string {
	if x != nil {
		return x.HiddenEnvoyDeprecatedCluster
	}
	return ""
}

// RedisProtocolOptions specifies Redis upstream protocol options. This object is used in
// :ref:`typed_extension_protocol_options<envoy_api_field_config.cluster.v3.Cluster.typed_extension_protocol_options>`,
// keyed by the name `envoy.filters.network.redis_proxy`.
type RedisProtocolOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Upstream server password as defined by the `requirepass` directive
	// <https://redis.io/topics/config>`_ in the server's configuration file.
	AuthPassword *v3.DataSource `protobuf:"bytes,1,opt,name=auth_password,json=authPassword,proto3" json:"auth_password,omitempty"`
	// Upstream server username as defined by the `user` directive
	// <https://redis.io/topics/acl>`_ in the server's configuration file.
	AuthUsername *v3.DataSource `protobuf:"bytes,2,opt,name=auth_username,json=authUsername,proto3" json:"auth_username,omitempty"`
}

func (x *RedisProtocolOptions) Reset() {
	*x = RedisProtocolOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RedisProtocolOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisProtocolOptions) ProtoMessage() {}

func (x *RedisProtocolOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisProtocolOptions.ProtoReflect.Descriptor instead.
func (*RedisProtocolOptions) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{1}
}

func (x *RedisProtocolOptions) GetAuthPassword() *v3.DataSource {
	if x != nil {
		return x.AuthPassword
	}
	return nil
}

func (x *RedisProtocolOptions) GetAuthUsername() *v3.DataSource {
	if x != nil {
		return x.AuthUsername
	}
	return nil
}

// Redis connection pool settings.
// [#next-free-field: 9]
type RedisProxy_ConnPoolSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Per-operation timeout in milliseconds. The timer starts when the first
	// command of a pipeline is written to the backend connection. Each response received from Redis
	// resets the timer since it signifies that the next command is being processed by the backend.
	// The only exception to this behavior is when a connection to a backend is not yet established.
	// In that case, the connect timeout on the cluster will govern the timeout until the connection
	// is ready.
	OpTimeout *duration.Duration `protobuf:"bytes,1,opt,name=op_timeout,json=opTimeout,proto3" json:"op_timeout,omitempty"`
	// Use hash tagging on every redis key to guarantee that keys with the same hash tag will be
	// forwarded to the same upstream. The hash key used for determining the upstream in a
	// consistent hash ring configuration will be computed from the hash tagged key instead of the
	// whole key. The algorithm used to compute the hash tag is identical to the `redis-cluster
	// implementation <https://redis.io/topics/cluster-spec#keys-hash-tags>`_.
	//
	// Examples:
	//
	// * '{user1000}.following' and '{user1000}.followers' **will** be sent to the same upstream
	// * '{user1000}.following' and '{user1001}.following' **might** be sent to the same upstream
	EnableHashtagging bool `protobuf:"varint,2,opt,name=enable_hashtagging,json=enableHashtagging,proto3" json:"enable_hashtagging,omitempty"`
	// Accept `moved and ask redirection
	// <https://redis.io/topics/cluster-spec#redirection-and-resharding>`_ errors from upstream
	// redis servers, and retry commands to the specified target server. The target server does not
	// need to be known to the cluster manager. If the command cannot be redirected, then the
	// original error is passed downstream unchanged. By default, this support is not enabled.
	EnableRedirection bool `protobuf:"varint,3,opt,name=enable_redirection,json=enableRedirection,proto3" json:"enable_redirection,omitempty"`
	// Maximum size of encoded request buffer before flush is triggered and encoded requests
	// are sent upstream. If this is unset, the buffer flushes whenever it receives data
	// and performs no batching.
	// This feature makes it possible for multiple clients to send requests to Envoy and have
	// them batched- for example if one is running several worker processes, each with its own
	// Redis connection. There is no benefit to using this with a single downstream process.
	// Recommended size (if enabled) is 1024 bytes.
	MaxBufferSizeBeforeFlush uint32 `protobuf:"varint,4,opt,name=max_buffer_size_before_flush,json=maxBufferSizeBeforeFlush,proto3" json:"max_buffer_size_before_flush,omitempty"`
	// The encoded request buffer is flushed N milliseconds after the first request has been
	// encoded, unless the buffer size has already exceeded `max_buffer_size_before_flush`.
	// If `max_buffer_size_before_flush` is not set, this flush timer is not used. Otherwise,
	// the timer should be set according to the number of clients, overall request rate and
	// desired maximum latency for a single command. For example, if there are many requests
	// being batched together at a high rate, the buffer will likely be filled before the timer
	// fires. Alternatively, if the request rate is lower the buffer will not be filled as often
	// before the timer fires.
	// If `max_buffer_size_before_flush` is set, but `buffer_flush_timeout` is not, the latter
	// defaults to 3ms.
	BufferFlushTimeout *duration.Duration `protobuf:"bytes,5,opt,name=buffer_flush_timeout,json=bufferFlushTimeout,proto3" json:"buffer_flush_timeout,omitempty"`
	// `max_upstream_unknown_connections` controls how many upstream connections to unknown hosts
	// can be created at any given time by any given worker thread (see `enable_redirection` for
	// more details). If the host is unknown and a connection cannot be created due to enforcing
	// this limit, then redirection will fail and the original redirection error will be passed
	// downstream unchanged. This limit defaults to 100.
	MaxUpstreamUnknownConnections *wrappers.UInt32Value `protobuf:"bytes,6,opt,name=max_upstream_unknown_connections,json=maxUpstreamUnknownConnections,proto3" json:"max_upstream_unknown_connections,omitempty"`
	// Enable per-command statistics per upstream cluster, in addition to the filter level aggregate
	// count. These commands are measured in microseconds.
	EnableCommandStats bool `protobuf:"varint,8,opt,name=enable_command_stats,json=enableCommandStats,proto3" json:"enable_command_stats,omitempty"`
	// Read policy. The default is to read from the primary.
	ReadPolicy RedisProxy_ConnPoolSettings_ReadPolicy `protobuf:"varint,7,opt,name=read_policy,json=readPolicy,proto3,enum=envoy.extensions.filters.network.redis_proxy.v3.RedisProxy_ConnPoolSettings_ReadPolicy" json:"read_policy,omitempty"`
}

func (x *RedisProxy_ConnPoolSettings) Reset() {
	*x = RedisProxy_ConnPoolSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RedisProxy_ConnPoolSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisProxy_ConnPoolSettings) ProtoMessage() {}

func (x *RedisProxy_ConnPoolSettings) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisProxy_ConnPoolSettings.ProtoReflect.Descriptor instead.
func (*RedisProxy_ConnPoolSettings) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0, 0}
}

func (x *RedisProxy_ConnPoolSettings) GetOpTimeout() *duration.Duration {
	if x != nil {
		return x.OpTimeout
	}
	return nil
}

func (x *RedisProxy_ConnPoolSettings) GetEnableHashtagging() bool {
	if x != nil {
		return x.EnableHashtagging
	}
	return false
}

func (x *RedisProxy_ConnPoolSettings) GetEnableRedirection() bool {
	if x != nil {
		return x.EnableRedirection
	}
	return false
}

func (x *RedisProxy_ConnPoolSettings) GetMaxBufferSizeBeforeFlush() uint32 {
	if x != nil {
		return x.MaxBufferSizeBeforeFlush
	}
	return 0
}

func (x *RedisProxy_ConnPoolSettings) GetBufferFlushTimeout() *duration.Duration {
	if x != nil {
		return x.BufferFlushTimeout
	}
	return nil
}

func (x *RedisProxy_ConnPoolSettings) GetMaxUpstreamUnknownConnections() *wrappers.UInt32Value {
	if x != nil {
		return x.MaxUpstreamUnknownConnections
	}
	return nil
}

func (x *RedisProxy_ConnPoolSettings) GetEnableCommandStats() bool {
	if x != nil {
		return x.EnableCommandStats
	}
	return false
}

func (x *RedisProxy_ConnPoolSettings) GetReadPolicy() RedisProxy_ConnPoolSettings_ReadPolicy {
	if x != nil {
		return x.ReadPolicy
	}
	return RedisProxy_ConnPoolSettings_MASTER
}

type RedisProxy_PrefixRoutes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of prefix routes.
	Routes []*RedisProxy_PrefixRoutes_Route `protobuf:"bytes,1,rep,name=routes,proto3" json:"routes,omitempty"`
	// Indicates that prefix matching should be case insensitive.
	CaseInsensitive bool `protobuf:"varint,2,opt,name=case_insensitive,json=caseInsensitive,proto3" json:"case_insensitive,omitempty"`
	// Optional catch-all route to forward commands that doesn't match any of the routes. The
	// catch-all route becomes required when no routes are specified.
	CatchAllRoute *RedisProxy_PrefixRoutes_Route `protobuf:"bytes,4,opt,name=catch_all_route,json=catchAllRoute,proto3" json:"catch_all_route,omitempty"`
	// Deprecated: Do not use.
	HiddenEnvoyDeprecatedCatchAllCluster string `protobuf:"bytes,3,opt,name=hidden_envoy_deprecated_catch_all_cluster,json=hiddenEnvoyDeprecatedCatchAllCluster,proto3" json:"hidden_envoy_deprecated_catch_all_cluster,omitempty"`
}

func (x *RedisProxy_PrefixRoutes) Reset() {
	*x = RedisProxy_PrefixRoutes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RedisProxy_PrefixRoutes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisProxy_PrefixRoutes) ProtoMessage() {}

func (x *RedisProxy_PrefixRoutes) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisProxy_PrefixRoutes.ProtoReflect.Descriptor instead.
func (*RedisProxy_PrefixRoutes) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0, 1}
}

func (x *RedisProxy_PrefixRoutes) GetRoutes() []*RedisProxy_PrefixRoutes_Route {
	if x != nil {
		return x.Routes
	}
	return nil
}

func (x *RedisProxy_PrefixRoutes) GetCaseInsensitive() bool {
	if x != nil {
		return x.CaseInsensitive
	}
	return false
}

func (x *RedisProxy_PrefixRoutes) GetCatchAllRoute() *RedisProxy_PrefixRoutes_Route {
	if x != nil {
		return x.CatchAllRoute
	}
	return nil
}

// Deprecated: Do not use.
func (x *RedisProxy_PrefixRoutes) GetHiddenEnvoyDeprecatedCatchAllCluster() string {
	if x != nil {
		return x.HiddenEnvoyDeprecatedCatchAllCluster
	}
	return ""
}

// RedisFault defines faults used for fault injection.
type RedisProxy_RedisFault struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Fault type.
	FaultType RedisProxy_RedisFault_RedisFaultType `protobuf:"varint,1,opt,name=fault_type,json=faultType,proto3,enum=envoy.extensions.filters.network.redis_proxy.v3.RedisProxy_RedisFault_RedisFaultType" json:"fault_type,omitempty"`
	// Percentage of requests fault applies to.
	FaultEnabled *v3.RuntimeFractionalPercent `protobuf:"bytes,2,opt,name=fault_enabled,json=faultEnabled,proto3" json:"fault_enabled,omitempty"`
	// Delay for all faults. If not set, defaults to zero
	Delay *duration.Duration `protobuf:"bytes,3,opt,name=delay,proto3" json:"delay,omitempty"`
	// Commands fault is restricted to, if any. If not set, fault applies to all commands
	// other than auth and ping (due to special handling of those commands in Envoy).
	Commands []string `protobuf:"bytes,4,rep,name=commands,proto3" json:"commands,omitempty"`
}

func (x *RedisProxy_RedisFault) Reset() {
	*x = RedisProxy_RedisFault{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RedisProxy_RedisFault) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisProxy_RedisFault) ProtoMessage() {}

func (x *RedisProxy_RedisFault) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisProxy_RedisFault.ProtoReflect.Descriptor instead.
func (*RedisProxy_RedisFault) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0, 2}
}

func (x *RedisProxy_RedisFault) GetFaultType() RedisProxy_RedisFault_RedisFaultType {
	if x != nil {
		return x.FaultType
	}
	return RedisProxy_RedisFault_DELAY
}

func (x *RedisProxy_RedisFault) GetFaultEnabled() *v3.RuntimeFractionalPercent {
	if x != nil {
		return x.FaultEnabled
	}
	return nil
}

func (x *RedisProxy_RedisFault) GetDelay() *duration.Duration {
	if x != nil {
		return x.Delay
	}
	return nil
}

func (x *RedisProxy_RedisFault) GetCommands() []string {
	if x != nil {
		return x.Commands
	}
	return nil
}

type RedisProxy_PrefixRoutes_Route struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// String prefix that must match the beginning of the keys. Envoy will always favor the
	// longest match.
	Prefix string `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// Indicates if the prefix needs to be removed from the key when forwarded.
	RemovePrefix bool `protobuf:"varint,2,opt,name=remove_prefix,json=removePrefix,proto3" json:"remove_prefix,omitempty"`
	// Upstream cluster to forward the command to.
	Cluster string `protobuf:"bytes,3,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Indicates that the route has a request mirroring policy.
	RequestMirrorPolicy []*RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy `protobuf:"bytes,4,rep,name=request_mirror_policy,json=requestMirrorPolicy,proto3" json:"request_mirror_policy,omitempty"`
}

func (x *RedisProxy_PrefixRoutes_Route) Reset() {
	*x = RedisProxy_PrefixRoutes_Route{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RedisProxy_PrefixRoutes_Route) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisProxy_PrefixRoutes_Route) ProtoMessage() {}

func (x *RedisProxy_PrefixRoutes_Route) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisProxy_PrefixRoutes_Route.ProtoReflect.Descriptor instead.
func (*RedisProxy_PrefixRoutes_Route) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *RedisProxy_PrefixRoutes_Route) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

func (x *RedisProxy_PrefixRoutes_Route) GetRemovePrefix() bool {
	if x != nil {
		return x.RemovePrefix
	}
	return false
}

func (x *RedisProxy_PrefixRoutes_Route) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *RedisProxy_PrefixRoutes_Route) GetRequestMirrorPolicy() []*RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy {
	if x != nil {
		return x.RequestMirrorPolicy
	}
	return nil
}

// The router is capable of shadowing traffic from one cluster to another. The current
// implementation is "fire and forget," meaning Envoy will not wait for the shadow cluster to
// respond before returning the response from the primary cluster. All normal statistics are
// collected for the shadow cluster making this feature useful for testing.
type RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the cluster that requests will be mirrored to. The cluster must
	// exist in the cluster manager configuration.
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// If not specified or the runtime key is not present, all requests to the target cluster
	// will be mirrored.
	//
	// If specified, Envoy will lookup the runtime key to get the percentage of requests to the
	// mirror.
	RuntimeFraction *v3.RuntimeFractionalPercent `protobuf:"bytes,2,opt,name=runtime_fraction,json=runtimeFraction,proto3" json:"runtime_fraction,omitempty"`
	// Set this to TRUE to only mirror write commands, this is effectively replicating the
	// writes in a "fire and forget" manner.
	ExcludeReadCommands bool `protobuf:"varint,3,opt,name=exclude_read_commands,json=excludeReadCommands,proto3" json:"exclude_read_commands,omitempty"`
}

func (x *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) Reset() {
	*x = RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) ProtoMessage() {}

func (x *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy.ProtoReflect.Descriptor instead.
func (*RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP(), []int{0, 1, 0, 0}
}

func (x *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) GetRuntimeFraction() *v3.RuntimeFractionalPercent {
	if x != nil {
		return x.RuntimeFraction
	}
	return nil
}

func (x *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) GetExcludeReadCommands() bool {
	if x != nil {
		return x.ExcludeReadCommands
	}
	return false
}

var File_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto protoreflect.FileDescriptor

var file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDesc = []byte{
	0x0a, 0x41, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2f, 0x72, 0x65, 0x64, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2f, 0x76,
	0x33, 0x2f, 0x72, 0x65, 0x64, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x2f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x78,
	0x79, 0x2e, 0x76, 0x33, 0x1a, 0x1f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x75, 0x64, 0x70, 0x61,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x75, 0x64, 0x70, 0x61,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x65, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x75, 0x64,
	0x70, 0x61, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x75, 0x64, 0x70,
	0x61, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe7, 0x17, 0x0a, 0x0a, 0x52, 0x65, 0x64, 0x69,
	0x73, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x12, 0x28, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x5f, 0x70,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04,
	0x72, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x12, 0x72, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x78,
	0x79, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x64, 0x69, 0x73, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x2e,
	0x43, 0x6f, 0x6e, 0x6e, 0x50, 0x6f, 0x6f, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f,
	0x69, 0x6e, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x49, 0x6e, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x12, 0x6d, 0x0a, 0x0d, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73,
	0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x64, 0x69, 0x73, 0x50,
	0x72, 0x6f, 0x78, 0x79, 0x2e, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x73, 0x52, 0x0c, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12,
	0x62, 0x0a, 0x18, 0x64, 0x6f, 0x77, 0x6e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x61, 0x75,
	0x74, 0x68, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x06, 0xb8, 0xb7, 0x8b, 0xa4, 0x02, 0x01, 0x52, 0x16, 0x64, 0x6f, 0x77,
	0x6e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x41, 0x75, 0x74, 0x68, 0x50, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x12, 0x5e, 0x0a, 0x06, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x64, 0x69, 0x73, 0x50, 0x72, 0x6f, 0x78, 0x79,
	0x2e, 0x52, 0x65, 0x64, 0x69, 0x73, 0x46, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x73, 0x12, 0x62, 0x0a, 0x18, 0x64, 0x6f, 0x77, 0x6e, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x06, 0xb8, 0xb7, 0x8b, 0xa4, 0x02, 0x01, 0x52,
	0x16, 0x64, 0x6f, 0x77, 0x6e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x41, 0x75, 0x74, 0x68, 0x55,
	0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x1f, 0x68, 0x69, 0x64, 0x64, 0x65,
	0x6e, 0x5f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x5f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x08, 0x18, 0x01, 0xb8, 0xee, 0xf2, 0xd2, 0x05, 0x01, 0x52, 0x1c, 0x68, 0x69, 0x64, 0x64,
	0x65, 0x6e, 0x45, 0x6e, 0x76, 0x6f, 0x79, 0x44, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x1a, 0xae, 0x06, 0x0a, 0x10, 0x43, 0x6f, 0x6e,
	0x6e, 0x50, 0x6f, 0x6f, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x42, 0x0a,
	0x0a, 0x6f, 0x70, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0xaa, 0x01, 0x02, 0x08, 0x01, 0x52, 0x09, 0x6f, 0x70, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x12, 0x2d, 0x0a, 0x12, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x68, 0x61, 0x73, 0x68,
	0x74, 0x61, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x61, 0x73, 0x68, 0x74, 0x61, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x12, 0x2d, 0x0a, 0x12, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3e, 0x0a, 0x1c, 0x6d, 0x61, 0x78, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x5f, 0x66, 0x6c, 0x75, 0x73, 0x68, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x18, 0x6d, 0x61, 0x78, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72,
	0x53, 0x69, 0x7a, 0x65, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x46, 0x6c, 0x75, 0x73, 0x68, 0x12,
	0x4b, 0x0a, 0x14, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x66, 0x6c, 0x75, 0x73, 0x68, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72,
	0x46, 0x6c, 0x75, 0x73, 0x68, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x65, 0x0a, 0x20,
	0x6d, 0x61, 0x78, 0x5f, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x75, 0x6e, 0x6b,
	0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x1d, 0x6d, 0x61, 0x78, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x55, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x12, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x82, 0x01, 0x0a, 0x0b, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x57, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x72,
	0x65, 0x64, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65,
	0x64, 0x69, 0x73, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x50, 0x6f, 0x6f,
	0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a,
	0x72, 0x65, 0x61, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x7e, 0x0a, 0x0a, 0x52, 0x65,
	0x61, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1b, 0x0a, 0x06, 0x4d, 0x41, 0x53, 0x54,
	0x45, 0x52, 0x10, 0x00, 0x1a, 0x0f, 0xf2, 0x98, 0xfe, 0x8f, 0x05, 0x09, 0x0a, 0x07, 0x50, 0x52,
	0x49, 0x4d, 0x41, 0x52, 0x59, 0x12, 0x29, 0x0a, 0x0d, 0x50, 0x52, 0x45, 0x46, 0x45, 0x52, 0x5f,
	0x4d, 0x41, 0x53, 0x54, 0x45, 0x52, 0x10, 0x01, 0x1a, 0x16, 0xf2, 0x98, 0xfe, 0x8f, 0x05, 0x10,
	0x0a, 0x0e, 0x50, 0x52, 0x45, 0x46, 0x45, 0x52, 0x5f, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59,
	0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x10, 0x02, 0x12, 0x12, 0x0a,
	0x0e, 0x50, 0x52, 0x45, 0x46, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x10,
	0x03, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4e, 0x59, 0x10, 0x04, 0x3a, 0x4d, 0x9a, 0xc5, 0x88, 0x1e,
	0x48, 0x0a, 0x46, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x72,
	0x65, 0x64, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65,
	0x64, 0x69, 0x73, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x50, 0x6f, 0x6f,
	0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x1a, 0xd4, 0x08, 0x0a, 0x0c, 0x50, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x66, 0x0a, 0x06, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x72, 0x65,
	0x64, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x64,
	0x69, 0x73, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x73, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x06, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x63, 0x61,
	0x73, 0x65, 0x49, 0x6e, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x12, 0x76, 0x0a,
	0x0f, 0x63, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x5f,
	0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x64, 0x69, 0x73, 0x50, 0x72,
	0x6f, 0x78, 0x79, 0x2e, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73,
	0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x0d, 0x63, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6c, 0x6c,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x61, 0x0a, 0x29, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x5f,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x5f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x63, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0x18, 0x01, 0xb8, 0xee, 0xf2, 0xd2,
	0x05, 0x01, 0x52, 0x24, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x45, 0x6e, 0x76, 0x6f, 0x79, 0x44,
	0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x43, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6c,
	0x6c, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x1a, 0x8a, 0x05, 0x0a, 0x05, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x12, 0x20, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x72, 0x03, 0x28, 0xe8, 0x07, 0x52, 0x06, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x5f, 0x70,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x72, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x21, 0x0a, 0x07, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72,
	0x02, 0x10, 0x01, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x96, 0x01, 0x0a,
	0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x72, 0x72, 0x6f, 0x72, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x62, 0x2e, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e,
	0x72, 0x65, 0x64, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x76, 0x33, 0x2e, 0x52,
	0x65, 0x64, 0x69, 0x73, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x4d, 0x69, 0x72, 0x72, 0x6f, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x13, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x69, 0x72, 0x72, 0x6f, 0x72, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a, 0xac, 0x02, 0x0a, 0x13, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x4d, 0x69, 0x72, 0x72, 0x6f, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x21, 0x0a,
	0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07,
	0xfa, 0x42, 0x04, 0x72, 0x02, 0x10, 0x01, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x59, 0x0a, 0x10, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x66, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x33, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x52, 0x0f, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x15, 0x65,
	0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x52, 0x65, 0x61, 0x64, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x3a,
	0x63, 0x9a, 0xc5, 0x88, 0x1e, 0x5e, 0x0a, 0x5c, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x65, 0x64, 0x69, 0x73, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x50, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x69, 0x72, 0x72, 0x6f, 0x72, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x3a, 0x4f, 0x9a, 0xc5, 0x88, 0x1e, 0x4a, 0x0a, 0x48, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x5f, 0x70,
	0x72, 0x6f, 0x78, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x64, 0x69, 0x73, 0x50, 0x72, 0x6f,
	0x78, 0x79, 0x2e, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x3a, 0x49, 0x9a, 0xc5, 0x88, 0x1e, 0x44, 0x0a, 0x42, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x5f,
	0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x64, 0x69, 0x73, 0x50, 0x72,
	0x6f, 0x78, 0x79, 0x2e, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73,
	0x1a, 0xe0, 0x02, 0x0a, 0x0a, 0x52, 0x65, 0x64, 0x69, 0x73, 0x46, 0x61, 0x75, 0x6c, 0x74, 0x12,
	0x7e, 0x0a, 0x0a, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x55, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x64, 0x69, 0x73, 0x50, 0x72, 0x6f, 0x78, 0x79,
	0x2e, 0x52, 0x65, 0x64, 0x69, 0x73, 0x46, 0x61, 0x75, 0x6c, 0x74, 0x2e, 0x52, 0x65, 0x64, 0x69,
	0x73, 0x46, 0x61, 0x75, 0x6c, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x09, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x5d, 0x0a, 0x0d, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50,
	0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x0c, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x2f,
	0x0a, 0x05, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x12,
	0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x22, 0x26, 0x0a, 0x0e, 0x52,
	0x65, 0x64, 0x69, 0x73, 0x46, 0x61, 0x75, 0x6c, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x09, 0x0a,
	0x05, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f,
	0x52, 0x10, 0x01, 0x3a, 0x3c, 0x9a, 0xc5, 0x88, 0x1e, 0x37, 0x0a, 0x35, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x5f, 0x70, 0x72,
	0x6f, 0x78, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x64, 0x69, 0x73, 0x50, 0x72, 0x6f, 0x78,
	0x79, 0x22, 0xfc, 0x01, 0x0a, 0x14, 0x52, 0x65, 0x64, 0x69, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4d, 0x0a, 0x0d, 0x61, 0x75,
	0x74, 0x68, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x06, 0xb8, 0xb7, 0x8b, 0xa4, 0x02, 0x01, 0x52, 0x0c, 0x61, 0x75, 0x74,
	0x68, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x4d, 0x0a, 0x0d, 0x61, 0x75, 0x74,
	0x68, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x42, 0x06, 0xb8, 0xb7, 0x8b, 0xa4, 0x02, 0x01, 0x52, 0x0c, 0x61, 0x75, 0x74, 0x68,
	0x55, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x3a, 0x46, 0x9a, 0xc5, 0x88, 0x1e, 0x41, 0x0a,
	0x3f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x72, 0x65, 0x64,
	0x69, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x64, 0x69,
	0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x42, 0x5a, 0x0a, 0x3d, 0x69, 0x6f, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x70, 0x72, 0x6f, 0x78,
	0x79, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x76,
	0x33, 0x42, 0x0f, 0x52, 0x65, 0x64, 0x69, 0x73, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0xba, 0x80, 0xc8, 0xd1, 0x06, 0x02, 0x10, 0x02, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescOnce sync.Once
	file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescData = file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDesc
)

func file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescGZIP() []byte {
	file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescOnce.Do(func() {
		file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescData = protoimpl.X.CompressGZIP(file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescData)
	})
	return file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDescData
}

var file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_goTypes = []interface{}{
	(RedisProxy_ConnPoolSettings_ReadPolicy)(0),               // 0: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings.ReadPolicy
	(RedisProxy_RedisFault_RedisFaultType)(0),                 // 1: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.RedisFault.RedisFaultType
	(*RedisProxy)(nil),                                        // 2: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy
	(*RedisProtocolOptions)(nil),                              // 3: envoy.extensions.filters.network.redis_proxy.v3.RedisProtocolOptions
	(*RedisProxy_ConnPoolSettings)(nil),                       // 4: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings
	(*RedisProxy_PrefixRoutes)(nil),                           // 5: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes
	(*RedisProxy_RedisFault)(nil),                             // 6: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.RedisFault
	(*RedisProxy_PrefixRoutes_Route)(nil),                     // 7: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route
	(*RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy)(nil), // 8: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route.RequestMirrorPolicy
	(*v3.DataSource)(nil),                                     // 9: envoy.config.core.v3.DataSource
	(*duration.Duration)(nil),                                 // 10: google.protobuf.Duration
	(*wrappers.UInt32Value)(nil),                              // 11: google.protobuf.UInt32Value
	(*v3.RuntimeFractionalPercent)(nil),                       // 12: envoy.config.core.v3.RuntimeFractionalPercent
}
var file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_depIdxs = []int32{
	4,  // 0: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.settings:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings
	5,  // 1: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.prefix_routes:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes
	9,  // 2: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.downstream_auth_password:type_name -> envoy.config.core.v3.DataSource
	6,  // 3: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.faults:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.RedisFault
	9,  // 4: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.downstream_auth_username:type_name -> envoy.config.core.v3.DataSource
	9,  // 5: envoy.extensions.filters.network.redis_proxy.v3.RedisProtocolOptions.auth_password:type_name -> envoy.config.core.v3.DataSource
	9,  // 6: envoy.extensions.filters.network.redis_proxy.v3.RedisProtocolOptions.auth_username:type_name -> envoy.config.core.v3.DataSource
	10, // 7: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings.op_timeout:type_name -> google.protobuf.Duration
	10, // 8: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings.buffer_flush_timeout:type_name -> google.protobuf.Duration
	11, // 9: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings.max_upstream_unknown_connections:type_name -> google.protobuf.UInt32Value
	0,  // 10: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings.read_policy:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.ConnPoolSettings.ReadPolicy
	7,  // 11: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.routes:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route
	7,  // 12: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.catch_all_route:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route
	1,  // 13: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.RedisFault.fault_type:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.RedisFault.RedisFaultType
	12, // 14: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.RedisFault.fault_enabled:type_name -> envoy.config.core.v3.RuntimeFractionalPercent
	10, // 15: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.RedisFault.delay:type_name -> google.protobuf.Duration
	8,  // 16: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route.request_mirror_policy:type_name -> envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route.RequestMirrorPolicy
	12, // 17: envoy.extensions.filters.network.redis_proxy.v3.RedisProxy.PrefixRoutes.Route.RequestMirrorPolicy.runtime_fraction:type_name -> envoy.config.core.v3.RuntimeFractionalPercent
	18, // [18:18] is the sub-list for method output_type
	18, // [18:18] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_init() }
func file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_init() {
	if File_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RedisProxy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RedisProtocolOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RedisProxy_ConnPoolSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RedisProxy_PrefixRoutes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RedisProxy_RedisFault); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RedisProxy_PrefixRoutes_Route); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_goTypes,
		DependencyIndexes: file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_depIdxs,
		EnumInfos:         file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_enumTypes,
		MessageInfos:      file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_msgTypes,
	}.Build()
	File_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto = out.File
	file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_rawDesc = nil
	file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_goTypes = nil
	file_envoy_extensions_filters_network_redis_proxy_v3_redis_proxy_proto_depIdxs = nil
}
