// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package eventbridgeiface provides an interface to enable mocking the Amazon EventBridge service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package eventbridgeiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/eventbridge"
)

// EventBridgeAPI provides an interface to enable mocking the
// eventbridge.EventBridge service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon EventBridge.
//    func myFunc(svc eventbridgeiface.EventBridgeAPI) bool {
//        // Make svc.ActivateEventSource request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := eventbridge.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockEventBridgeClient struct {
//        eventbridgeiface.EventBridgeAPI
//    }
//    func (m *mockEventBridgeClient) ActivateEventSource(input *eventbridge.ActivateEventSourceInput) (*eventbridge.ActivateEventSourceOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockEventBridgeClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type EventBridgeAPI interface {
	ActivateEventSource(*eventbridge.ActivateEventSourceInput) (*eventbridge.ActivateEventSourceOutput, error)
	ActivateEventSourceWithContext(aws.Context, *eventbridge.ActivateEventSourceInput, ...request.Option) (*eventbridge.ActivateEventSourceOutput, error)
	ActivateEventSourceRequest(*eventbridge.ActivateEventSourceInput) (*request.Request, *eventbridge.ActivateEventSourceOutput)

	CancelReplay(*eventbridge.CancelReplayInput) (*eventbridge.CancelReplayOutput, error)
	CancelReplayWithContext(aws.Context, *eventbridge.CancelReplayInput, ...request.Option) (*eventbridge.CancelReplayOutput, error)
	CancelReplayRequest(*eventbridge.CancelReplayInput) (*request.Request, *eventbridge.CancelReplayOutput)

	CreateArchive(*eventbridge.CreateArchiveInput) (*eventbridge.CreateArchiveOutput, error)
	CreateArchiveWithContext(aws.Context, *eventbridge.CreateArchiveInput, ...request.Option) (*eventbridge.CreateArchiveOutput, error)
	CreateArchiveRequest(*eventbridge.CreateArchiveInput) (*request.Request, *eventbridge.CreateArchiveOutput)

	CreateEventBus(*eventbridge.CreateEventBusInput) (*eventbridge.CreateEventBusOutput, error)
	CreateEventBusWithContext(aws.Context, *eventbridge.CreateEventBusInput, ...request.Option) (*eventbridge.CreateEventBusOutput, error)
	CreateEventBusRequest(*eventbridge.CreateEventBusInput) (*request.Request, *eventbridge.CreateEventBusOutput)

	CreatePartnerEventSource(*eventbridge.CreatePartnerEventSourceInput) (*eventbridge.CreatePartnerEventSourceOutput, error)
	CreatePartnerEventSourceWithContext(aws.Context, *eventbridge.CreatePartnerEventSourceInput, ...request.Option) (*eventbridge.CreatePartnerEventSourceOutput, error)
	CreatePartnerEventSourceRequest(*eventbridge.CreatePartnerEventSourceInput) (*request.Request, *eventbridge.CreatePartnerEventSourceOutput)

	DeactivateEventSource(*eventbridge.DeactivateEventSourceInput) (*eventbridge.DeactivateEventSourceOutput, error)
	DeactivateEventSourceWithContext(aws.Context, *eventbridge.DeactivateEventSourceInput, ...request.Option) (*eventbridge.DeactivateEventSourceOutput, error)
	DeactivateEventSourceRequest(*eventbridge.DeactivateEventSourceInput) (*request.Request, *eventbridge.DeactivateEventSourceOutput)

	DeleteArchive(*eventbridge.DeleteArchiveInput) (*eventbridge.DeleteArchiveOutput, error)
	DeleteArchiveWithContext(aws.Context, *eventbridge.DeleteArchiveInput, ...request.Option) (*eventbridge.DeleteArchiveOutput, error)
	DeleteArchiveRequest(*eventbridge.DeleteArchiveInput) (*request.Request, *eventbridge.DeleteArchiveOutput)

	DeleteEventBus(*eventbridge.DeleteEventBusInput) (*eventbridge.DeleteEventBusOutput, error)
	DeleteEventBusWithContext(aws.Context, *eventbridge.DeleteEventBusInput, ...request.Option) (*eventbridge.DeleteEventBusOutput, error)
	DeleteEventBusRequest(*eventbridge.DeleteEventBusInput) (*request.Request, *eventbridge.DeleteEventBusOutput)

	DeletePartnerEventSource(*eventbridge.DeletePartnerEventSourceInput) (*eventbridge.DeletePartnerEventSourceOutput, error)
	DeletePartnerEventSourceWithContext(aws.Context, *eventbridge.DeletePartnerEventSourceInput, ...request.Option) (*eventbridge.DeletePartnerEventSourceOutput, error)
	DeletePartnerEventSourceRequest(*eventbridge.DeletePartnerEventSourceInput) (*request.Request, *eventbridge.DeletePartnerEventSourceOutput)

	DeleteRule(*eventbridge.DeleteRuleInput) (*eventbridge.DeleteRuleOutput, error)
	DeleteRuleWithContext(aws.Context, *eventbridge.DeleteRuleInput, ...request.Option) (*eventbridge.DeleteRuleOutput, error)
	DeleteRuleRequest(*eventbridge.DeleteRuleInput) (*request.Request, *eventbridge.DeleteRuleOutput)

	DescribeArchive(*eventbridge.DescribeArchiveInput) (*eventbridge.DescribeArchiveOutput, error)
	DescribeArchiveWithContext(aws.Context, *eventbridge.DescribeArchiveInput, ...request.Option) (*eventbridge.DescribeArchiveOutput, error)
	DescribeArchiveRequest(*eventbridge.DescribeArchiveInput) (*request.Request, *eventbridge.DescribeArchiveOutput)

	DescribeEventBus(*eventbridge.DescribeEventBusInput) (*eventbridge.DescribeEventBusOutput, error)
	DescribeEventBusWithContext(aws.Context, *eventbridge.DescribeEventBusInput, ...request.Option) (*eventbridge.DescribeEventBusOutput, error)
	DescribeEventBusRequest(*eventbridge.DescribeEventBusInput) (*request.Request, *eventbridge.DescribeEventBusOutput)

	DescribeEventSource(*eventbridge.DescribeEventSourceInput) (*eventbridge.DescribeEventSourceOutput, error)
	DescribeEventSourceWithContext(aws.Context, *eventbridge.DescribeEventSourceInput, ...request.Option) (*eventbridge.DescribeEventSourceOutput, error)
	DescribeEventSourceRequest(*eventbridge.DescribeEventSourceInput) (*request.Request, *eventbridge.DescribeEventSourceOutput)

	DescribePartnerEventSource(*eventbridge.DescribePartnerEventSourceInput) (*eventbridge.DescribePartnerEventSourceOutput, error)
	DescribePartnerEventSourceWithContext(aws.Context, *eventbridge.DescribePartnerEventSourceInput, ...request.Option) (*eventbridge.DescribePartnerEventSourceOutput, error)
	DescribePartnerEventSourceRequest(*eventbridge.DescribePartnerEventSourceInput) (*request.Request, *eventbridge.DescribePartnerEventSourceOutput)

	DescribeReplay(*eventbridge.DescribeReplayInput) (*eventbridge.DescribeReplayOutput, error)
	DescribeReplayWithContext(aws.Context, *eventbridge.DescribeReplayInput, ...request.Option) (*eventbridge.DescribeReplayOutput, error)
	DescribeReplayRequest(*eventbridge.DescribeReplayInput) (*request.Request, *eventbridge.DescribeReplayOutput)

	DescribeRule(*eventbridge.DescribeRuleInput) (*eventbridge.DescribeRuleOutput, error)
	DescribeRuleWithContext(aws.Context, *eventbridge.DescribeRuleInput, ...request.Option) (*eventbridge.DescribeRuleOutput, error)
	DescribeRuleRequest(*eventbridge.DescribeRuleInput) (*request.Request, *eventbridge.DescribeRuleOutput)

	DisableRule(*eventbridge.DisableRuleInput) (*eventbridge.DisableRuleOutput, error)
	DisableRuleWithContext(aws.Context, *eventbridge.DisableRuleInput, ...request.Option) (*eventbridge.DisableRuleOutput, error)
	DisableRuleRequest(*eventbridge.DisableRuleInput) (*request.Request, *eventbridge.DisableRuleOutput)

	EnableRule(*eventbridge.EnableRuleInput) (*eventbridge.EnableRuleOutput, error)
	EnableRuleWithContext(aws.Context, *eventbridge.EnableRuleInput, ...request.Option) (*eventbridge.EnableRuleOutput, error)
	EnableRuleRequest(*eventbridge.EnableRuleInput) (*request.Request, *eventbridge.EnableRuleOutput)

	ListArchives(*eventbridge.ListArchivesInput) (*eventbridge.ListArchivesOutput, error)
	ListArchivesWithContext(aws.Context, *eventbridge.ListArchivesInput, ...request.Option) (*eventbridge.ListArchivesOutput, error)
	ListArchivesRequest(*eventbridge.ListArchivesInput) (*request.Request, *eventbridge.ListArchivesOutput)

	ListEventBuses(*eventbridge.ListEventBusesInput) (*eventbridge.ListEventBusesOutput, error)
	ListEventBusesWithContext(aws.Context, *eventbridge.ListEventBusesInput, ...request.Option) (*eventbridge.ListEventBusesOutput, error)
	ListEventBusesRequest(*eventbridge.ListEventBusesInput) (*request.Request, *eventbridge.ListEventBusesOutput)

	ListEventSources(*eventbridge.ListEventSourcesInput) (*eventbridge.ListEventSourcesOutput, error)
	ListEventSourcesWithContext(aws.Context, *eventbridge.ListEventSourcesInput, ...request.Option) (*eventbridge.ListEventSourcesOutput, error)
	ListEventSourcesRequest(*eventbridge.ListEventSourcesInput) (*request.Request, *eventbridge.ListEventSourcesOutput)

	ListPartnerEventSourceAccounts(*eventbridge.ListPartnerEventSourceAccountsInput) (*eventbridge.ListPartnerEventSourceAccountsOutput, error)
	ListPartnerEventSourceAccountsWithContext(aws.Context, *eventbridge.ListPartnerEventSourceAccountsInput, ...request.Option) (*eventbridge.ListPartnerEventSourceAccountsOutput, error)
	ListPartnerEventSourceAccountsRequest(*eventbridge.ListPartnerEventSourceAccountsInput) (*request.Request, *eventbridge.ListPartnerEventSourceAccountsOutput)

	ListPartnerEventSources(*eventbridge.ListPartnerEventSourcesInput) (*eventbridge.ListPartnerEventSourcesOutput, error)
	ListPartnerEventSourcesWithContext(aws.Context, *eventbridge.ListPartnerEventSourcesInput, ...request.Option) (*eventbridge.ListPartnerEventSourcesOutput, error)
	ListPartnerEventSourcesRequest(*eventbridge.ListPartnerEventSourcesInput) (*request.Request, *eventbridge.ListPartnerEventSourcesOutput)

	ListReplays(*eventbridge.ListReplaysInput) (*eventbridge.ListReplaysOutput, error)
	ListReplaysWithContext(aws.Context, *eventbridge.ListReplaysInput, ...request.Option) (*eventbridge.ListReplaysOutput, error)
	ListReplaysRequest(*eventbridge.ListReplaysInput) (*request.Request, *eventbridge.ListReplaysOutput)

	ListRuleNamesByTarget(*eventbridge.ListRuleNamesByTargetInput) (*eventbridge.ListRuleNamesByTargetOutput, error)
	ListRuleNamesByTargetWithContext(aws.Context, *eventbridge.ListRuleNamesByTargetInput, ...request.Option) (*eventbridge.ListRuleNamesByTargetOutput, error)
	ListRuleNamesByTargetRequest(*eventbridge.ListRuleNamesByTargetInput) (*request.Request, *eventbridge.ListRuleNamesByTargetOutput)

	ListRules(*eventbridge.ListRulesInput) (*eventbridge.ListRulesOutput, error)
	ListRulesWithContext(aws.Context, *eventbridge.ListRulesInput, ...request.Option) (*eventbridge.ListRulesOutput, error)
	ListRulesRequest(*eventbridge.ListRulesInput) (*request.Request, *eventbridge.ListRulesOutput)

	ListTagsForResource(*eventbridge.ListTagsForResourceInput) (*eventbridge.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *eventbridge.ListTagsForResourceInput, ...request.Option) (*eventbridge.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*eventbridge.ListTagsForResourceInput) (*request.Request, *eventbridge.ListTagsForResourceOutput)

	ListTargetsByRule(*eventbridge.ListTargetsByRuleInput) (*eventbridge.ListTargetsByRuleOutput, error)
	ListTargetsByRuleWithContext(aws.Context, *eventbridge.ListTargetsByRuleInput, ...request.Option) (*eventbridge.ListTargetsByRuleOutput, error)
	ListTargetsByRuleRequest(*eventbridge.ListTargetsByRuleInput) (*request.Request, *eventbridge.ListTargetsByRuleOutput)

	PutEvents(*eventbridge.PutEventsInput) (*eventbridge.PutEventsOutput, error)
	PutEventsWithContext(aws.Context, *eventbridge.PutEventsInput, ...request.Option) (*eventbridge.PutEventsOutput, error)
	PutEventsRequest(*eventbridge.PutEventsInput) (*request.Request, *eventbridge.PutEventsOutput)

	PutPartnerEvents(*eventbridge.PutPartnerEventsInput) (*eventbridge.PutPartnerEventsOutput, error)
	PutPartnerEventsWithContext(aws.Context, *eventbridge.PutPartnerEventsInput, ...request.Option) (*eventbridge.PutPartnerEventsOutput, error)
	PutPartnerEventsRequest(*eventbridge.PutPartnerEventsInput) (*request.Request, *eventbridge.PutPartnerEventsOutput)

	PutPermission(*eventbridge.PutPermissionInput) (*eventbridge.PutPermissionOutput, error)
	PutPermissionWithContext(aws.Context, *eventbridge.PutPermissionInput, ...request.Option) (*eventbridge.PutPermissionOutput, error)
	PutPermissionRequest(*eventbridge.PutPermissionInput) (*request.Request, *eventbridge.PutPermissionOutput)

	PutRule(*eventbridge.PutRuleInput) (*eventbridge.PutRuleOutput, error)
	PutRuleWithContext(aws.Context, *eventbridge.PutRuleInput, ...request.Option) (*eventbridge.PutRuleOutput, error)
	PutRuleRequest(*eventbridge.PutRuleInput) (*request.Request, *eventbridge.PutRuleOutput)

	PutTargets(*eventbridge.PutTargetsInput) (*eventbridge.PutTargetsOutput, error)
	PutTargetsWithContext(aws.Context, *eventbridge.PutTargetsInput, ...request.Option) (*eventbridge.PutTargetsOutput, error)
	PutTargetsRequest(*eventbridge.PutTargetsInput) (*request.Request, *eventbridge.PutTargetsOutput)

	RemovePermission(*eventbridge.RemovePermissionInput) (*eventbridge.RemovePermissionOutput, error)
	RemovePermissionWithContext(aws.Context, *eventbridge.RemovePermissionInput, ...request.Option) (*eventbridge.RemovePermissionOutput, error)
	RemovePermissionRequest(*eventbridge.RemovePermissionInput) (*request.Request, *eventbridge.RemovePermissionOutput)

	RemoveTargets(*eventbridge.RemoveTargetsInput) (*eventbridge.RemoveTargetsOutput, error)
	RemoveTargetsWithContext(aws.Context, *eventbridge.RemoveTargetsInput, ...request.Option) (*eventbridge.RemoveTargetsOutput, error)
	RemoveTargetsRequest(*eventbridge.RemoveTargetsInput) (*request.Request, *eventbridge.RemoveTargetsOutput)

	StartReplay(*eventbridge.StartReplayInput) (*eventbridge.StartReplayOutput, error)
	StartReplayWithContext(aws.Context, *eventbridge.StartReplayInput, ...request.Option) (*eventbridge.StartReplayOutput, error)
	StartReplayRequest(*eventbridge.StartReplayInput) (*request.Request, *eventbridge.StartReplayOutput)

	TagResource(*eventbridge.TagResourceInput) (*eventbridge.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *eventbridge.TagResourceInput, ...request.Option) (*eventbridge.TagResourceOutput, error)
	TagResourceRequest(*eventbridge.TagResourceInput) (*request.Request, *eventbridge.TagResourceOutput)

	TestEventPattern(*eventbridge.TestEventPatternInput) (*eventbridge.TestEventPatternOutput, error)
	TestEventPatternWithContext(aws.Context, *eventbridge.TestEventPatternInput, ...request.Option) (*eventbridge.TestEventPatternOutput, error)
	TestEventPatternRequest(*eventbridge.TestEventPatternInput) (*request.Request, *eventbridge.TestEventPatternOutput)

	UntagResource(*eventbridge.UntagResourceInput) (*eventbridge.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *eventbridge.UntagResourceInput, ...request.Option) (*eventbridge.UntagResourceOutput, error)
	UntagResourceRequest(*eventbridge.UntagResourceInput) (*request.Request, *eventbridge.UntagResourceOutput)

	UpdateArchive(*eventbridge.UpdateArchiveInput) (*eventbridge.UpdateArchiveOutput, error)
	UpdateArchiveWithContext(aws.Context, *eventbridge.UpdateArchiveInput, ...request.Option) (*eventbridge.UpdateArchiveOutput, error)
	UpdateArchiveRequest(*eventbridge.UpdateArchiveInput) (*request.Request, *eventbridge.UpdateArchiveOutput)
}

var _ EventBridgeAPI = (*eventbridge.EventBridge)(nil)
