package servicefabricmesh

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/servicefabricmesh/mgmt/2018-07-01-preview/servicefabricmesh"

// ApplicationProperties this type describes properties of an application resource.
type ApplicationProperties struct {
	// Description - User readable description of the application.
	Description *string `json:"description,omitempty"`
	// DebugParams - Internal use.
	DebugParams *string `json:"debugParams,omitempty"`
	// Services - describes the services in the application.
	Services *[]ServiceResourceDescription `json:"services,omitempty"`
	// HealthState - READ-ONLY; Describes the health state of an application resource. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"healthState,omitempty"`
	// UnhealthyEvaluation - READ-ONLY; When the application's health state is not 'Ok', this additional details from service fabric Health Manager for the user to know why the application is marked unhealthy.
	UnhealthyEvaluation *string `json:"unhealthyEvaluation,omitempty"`
	// Status - READ-ONLY; Status of the application resource. Possible values include: 'Invalid', 'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
	Status ApplicationResourceStatus `json:"status,omitempty"`
	// StatusDetails - READ-ONLY; Gives additional information about the current status of the application deployment.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// ServiceNames - READ-ONLY; Names of the services in the application.
	ServiceNames *[]string `json:"serviceNames,omitempty"`
	// Diagnostics - Describes the diagnostics definition and usage for an application resource.
	Diagnostics *DiagnosticsDescription `json:"diagnostics,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationProperties.
func (ap ApplicationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Description != nil {
		objectMap["description"] = ap.Description
	}
	if ap.DebugParams != nil {
		objectMap["debugParams"] = ap.DebugParams
	}
	if ap.Services != nil {
		objectMap["services"] = ap.Services
	}
	if ap.Diagnostics != nil {
		objectMap["diagnostics"] = ap.Diagnostics
	}
	return json.Marshal(objectMap)
}

// ApplicationResourceDescription this type describes an application resource.
type ApplicationResourceDescription struct {
	autorest.Response `json:"-"`
	// ApplicationResourceProperties - This type describes properties of an application resource.
	*ApplicationResourceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationResourceDescription.
func (ard ApplicationResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ard.ApplicationResourceProperties != nil {
		objectMap["properties"] = ard.ApplicationResourceProperties
	}
	if ard.Tags != nil {
		objectMap["tags"] = ard.Tags
	}
	if ard.Location != nil {
		objectMap["location"] = ard.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationResourceDescription struct.
func (ard *ApplicationResourceDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationResourceProperties ApplicationResourceProperties
				err = json.Unmarshal(*v, &applicationResourceProperties)
				if err != nil {
					return err
				}
				ard.ApplicationResourceProperties = &applicationResourceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ard.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ard.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ard.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ard.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ard.Location = &location
			}
		}
	}

	return nil
}

// ApplicationResourceDescriptionList a pageable list of application resources.
type ApplicationResourceDescriptionList struct {
	autorest.Response `json:"-"`
	// Value - One page of the list.
	Value *[]ApplicationResourceDescription `json:"value,omitempty"`
	// NextLink - URI to fetch the next page of the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationResourceDescriptionListIterator provides access to a complete listing of
// ApplicationResourceDescription values.
type ApplicationResourceDescriptionListIterator struct {
	i    int
	page ApplicationResourceDescriptionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationResourceDescriptionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationResourceDescriptionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationResourceDescriptionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationResourceDescriptionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationResourceDescriptionListIterator) Response() ApplicationResourceDescriptionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationResourceDescriptionListIterator) Value() ApplicationResourceDescription {
	if !iter.page.NotDone() {
		return ApplicationResourceDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationResourceDescriptionListIterator type.
func NewApplicationResourceDescriptionListIterator(page ApplicationResourceDescriptionListPage) ApplicationResourceDescriptionListIterator {
	return ApplicationResourceDescriptionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ardl ApplicationResourceDescriptionList) IsEmpty() bool {
	return ardl.Value == nil || len(*ardl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ardl ApplicationResourceDescriptionList) hasNextLink() bool {
	return ardl.NextLink != nil && len(*ardl.NextLink) != 0
}

// applicationResourceDescriptionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ardl ApplicationResourceDescriptionList) applicationResourceDescriptionListPreparer(ctx context.Context) (*http.Request, error) {
	if !ardl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ardl.NextLink)))
}

// ApplicationResourceDescriptionListPage contains a page of ApplicationResourceDescription values.
type ApplicationResourceDescriptionListPage struct {
	fn   func(context.Context, ApplicationResourceDescriptionList) (ApplicationResourceDescriptionList, error)
	ardl ApplicationResourceDescriptionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationResourceDescriptionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationResourceDescriptionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ardl)
		if err != nil {
			return err
		}
		page.ardl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationResourceDescriptionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationResourceDescriptionListPage) NotDone() bool {
	return !page.ardl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationResourceDescriptionListPage) Response() ApplicationResourceDescriptionList {
	return page.ardl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationResourceDescriptionListPage) Values() []ApplicationResourceDescription {
	if page.ardl.IsEmpty() {
		return nil
	}
	return *page.ardl.Value
}

// Creates a new instance of the ApplicationResourceDescriptionListPage type.
func NewApplicationResourceDescriptionListPage(cur ApplicationResourceDescriptionList, getNextPage func(context.Context, ApplicationResourceDescriptionList) (ApplicationResourceDescriptionList, error)) ApplicationResourceDescriptionListPage {
	return ApplicationResourceDescriptionListPage{
		fn:   getNextPage,
		ardl: cur,
	}
}

// ApplicationResourceProperties this type describes properties of an application resource.
type ApplicationResourceProperties struct {
	// ProvisioningState - READ-ONLY; State of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Description - User readable description of the application.
	Description *string `json:"description,omitempty"`
	// DebugParams - Internal use.
	DebugParams *string `json:"debugParams,omitempty"`
	// Services - describes the services in the application.
	Services *[]ServiceResourceDescription `json:"services,omitempty"`
	// HealthState - READ-ONLY; Describes the health state of an application resource. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"healthState,omitempty"`
	// UnhealthyEvaluation - READ-ONLY; When the application's health state is not 'Ok', this additional details from service fabric Health Manager for the user to know why the application is marked unhealthy.
	UnhealthyEvaluation *string `json:"unhealthyEvaluation,omitempty"`
	// Status - READ-ONLY; Status of the application resource. Possible values include: 'Invalid', 'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
	Status ApplicationResourceStatus `json:"status,omitempty"`
	// StatusDetails - READ-ONLY; Gives additional information about the current status of the application deployment.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// ServiceNames - READ-ONLY; Names of the services in the application.
	ServiceNames *[]string `json:"serviceNames,omitempty"`
	// Diagnostics - Describes the diagnostics definition and usage for an application resource.
	Diagnostics *DiagnosticsDescription `json:"diagnostics,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationResourceProperties.
func (arp ApplicationResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arp.Description != nil {
		objectMap["description"] = arp.Description
	}
	if arp.DebugParams != nil {
		objectMap["debugParams"] = arp.DebugParams
	}
	if arp.Services != nil {
		objectMap["services"] = arp.Services
	}
	if arp.Diagnostics != nil {
		objectMap["diagnostics"] = arp.Diagnostics
	}
	return json.Marshal(objectMap)
}

// AvailableOperationDisplay an operation available at the listed Azure resource provider.
type AvailableOperationDisplay struct {
	// Provider - Name of the operation provider.
	Provider *string `json:"provider,omitempty"`
	// Resource - Name of the resource on which the operation is available.
	Resource *string `json:"resource,omitempty"`
	// Operation - Name of the available operation.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the available operation.
	Description *string `json:"description,omitempty"`
}

// AzureInternalMonitoringPipelineSinkDescription diagnostics settings for Geneva.
type AzureInternalMonitoringPipelineSinkDescription struct {
	// AccountName - Azure Internal monitoring pipeline account.
	AccountName *string `json:"accountName,omitempty"`
	// Namespace - Azure Internal monitoring pipeline account namespace.
	Namespace *string `json:"namespace,omitempty"`
	// MaConfigURL - Azure Internal monitoring agent configuration.
	MaConfigURL *string `json:"maConfigUrl,omitempty"`
	// FluentdConfigURL - Azure Internal monitoring agent fluentd configuration.
	FluentdConfigURL interface{} `json:"fluentdConfigUrl,omitempty"`
	// AutoKeyConfigURL - Azure Internal monitoring pipeline autokey associated with the certificate.
	AutoKeyConfigURL *string `json:"autoKeyConfigUrl,omitempty"`
	// Name - Name of the sink. This value is referenced by DiagnosticsReferenceDescription
	Name *string `json:"name,omitempty"`
	// Description - A description of the sink.
	Description *string `json:"description,omitempty"`
	// Kind - Possible values include: 'KindDiagnosticsSinkProperties', 'KindAzureInternalMonitoringPipeline'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureInternalMonitoringPipelineSinkDescription.
func (aimpsd AzureInternalMonitoringPipelineSinkDescription) MarshalJSON() ([]byte, error) {
	aimpsd.Kind = KindAzureInternalMonitoringPipeline
	objectMap := make(map[string]interface{})
	if aimpsd.AccountName != nil {
		objectMap["accountName"] = aimpsd.AccountName
	}
	if aimpsd.Namespace != nil {
		objectMap["namespace"] = aimpsd.Namespace
	}
	if aimpsd.MaConfigURL != nil {
		objectMap["maConfigUrl"] = aimpsd.MaConfigURL
	}
	if aimpsd.FluentdConfigURL != nil {
		objectMap["fluentdConfigUrl"] = aimpsd.FluentdConfigURL
	}
	if aimpsd.AutoKeyConfigURL != nil {
		objectMap["autoKeyConfigUrl"] = aimpsd.AutoKeyConfigURL
	}
	if aimpsd.Name != nil {
		objectMap["name"] = aimpsd.Name
	}
	if aimpsd.Description != nil {
		objectMap["description"] = aimpsd.Description
	}
	if aimpsd.Kind != "" {
		objectMap["kind"] = aimpsd.Kind
	}
	return json.Marshal(objectMap)
}

// AsAzureInternalMonitoringPipelineSinkDescription is the BasicDiagnosticsSinkProperties implementation for AzureInternalMonitoringPipelineSinkDescription.
func (aimpsd AzureInternalMonitoringPipelineSinkDescription) AsAzureInternalMonitoringPipelineSinkDescription() (*AzureInternalMonitoringPipelineSinkDescription, bool) {
	return &aimpsd, true
}

// AsDiagnosticsSinkProperties is the BasicDiagnosticsSinkProperties implementation for AzureInternalMonitoringPipelineSinkDescription.
func (aimpsd AzureInternalMonitoringPipelineSinkDescription) AsDiagnosticsSinkProperties() (*DiagnosticsSinkProperties, bool) {
	return nil, false
}

// AsBasicDiagnosticsSinkProperties is the BasicDiagnosticsSinkProperties implementation for AzureInternalMonitoringPipelineSinkDescription.
func (aimpsd AzureInternalMonitoringPipelineSinkDescription) AsBasicDiagnosticsSinkProperties() (BasicDiagnosticsSinkProperties, bool) {
	return &aimpsd, true
}

// ContainerCodePackageProperties describes a container and its runtime properties.
type ContainerCodePackageProperties struct {
	// Name - The name of the code package.
	Name *string `json:"name,omitempty"`
	// Image - The Container image to use.
	Image *string `json:"image,omitempty"`
	// ImageRegistryCredential - Image registry credential.
	ImageRegistryCredential *ImageRegistryCredential `json:"imageRegistryCredential,omitempty"`
	// Entrypoint - Override for the default entry point in the container.
	Entrypoint *string `json:"entrypoint,omitempty"`
	// Commands - Command array to execute within the container in exec form.
	Commands *[]string `json:"commands,omitempty"`
	// EnvironmentVariables - The environment variables to set in this container
	EnvironmentVariables *[]EnvironmentVariable `json:"environmentVariables,omitempty"`
	// Settings - The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath". The path for Windows container is "C:\\secrets". The path for Linux container is "/var/secrets".
	Settings *[]Setting `json:"settings,omitempty"`
	// Labels - The labels to set in this container.
	Labels *[]ContainerLabel `json:"labels,omitempty"`
	// Endpoints - The endpoints exposed by this container.
	Endpoints *[]EndpointProperties `json:"endpoints,omitempty"`
	// Resources - This type describes the resource requirements for a container or a service.
	Resources *ResourceRequirements `json:"resources,omitempty"`
	// VolumeRefs - The volumes to be attached to the container.
	VolumeRefs *[]ContainerVolume `json:"volumeRefs,omitempty"`
	// InstanceView - READ-ONLY; Runtime information of a container instance.
	InstanceView *ContainerInstanceView `json:"instanceView,omitempty"`
	// Diagnostics - Reference to sinks in DiagnosticsDescription.
	Diagnostics *DiagnosticsRef `json:"diagnostics,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerCodePackageProperties.
func (ccpp ContainerCodePackageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccpp.Name != nil {
		objectMap["name"] = ccpp.Name
	}
	if ccpp.Image != nil {
		objectMap["image"] = ccpp.Image
	}
	if ccpp.ImageRegistryCredential != nil {
		objectMap["imageRegistryCredential"] = ccpp.ImageRegistryCredential
	}
	if ccpp.Entrypoint != nil {
		objectMap["entrypoint"] = ccpp.Entrypoint
	}
	if ccpp.Commands != nil {
		objectMap["commands"] = ccpp.Commands
	}
	if ccpp.EnvironmentVariables != nil {
		objectMap["environmentVariables"] = ccpp.EnvironmentVariables
	}
	if ccpp.Settings != nil {
		objectMap["settings"] = ccpp.Settings
	}
	if ccpp.Labels != nil {
		objectMap["labels"] = ccpp.Labels
	}
	if ccpp.Endpoints != nil {
		objectMap["endpoints"] = ccpp.Endpoints
	}
	if ccpp.Resources != nil {
		objectMap["resources"] = ccpp.Resources
	}
	if ccpp.VolumeRefs != nil {
		objectMap["volumeRefs"] = ccpp.VolumeRefs
	}
	if ccpp.Diagnostics != nil {
		objectMap["diagnostics"] = ccpp.Diagnostics
	}
	return json.Marshal(objectMap)
}

// ContainerEvent a container event.
type ContainerEvent struct {
	// Name - The name of the container event.
	Name *string `json:"name,omitempty"`
	// Count - The count of the event.
	Count *int32 `json:"count,omitempty"`
	// FirstTimestamp - Date/time of the first event.
	FirstTimestamp *string `json:"firstTimestamp,omitempty"`
	// LastTimestamp - Date/time of the last event.
	LastTimestamp *string `json:"lastTimestamp,omitempty"`
	// Message - The event message
	Message *string `json:"message,omitempty"`
	// Type - The event type.
	Type *string `json:"type,omitempty"`
}

// ContainerInstanceView runtime information of a container instance.
type ContainerInstanceView struct {
	// RestartCount - The number of times the container has been restarted.
	RestartCount *int32 `json:"restartCount,omitempty"`
	// CurrentState - Current container instance state.
	CurrentState *ContainerState `json:"currentState,omitempty"`
	// PreviousState - Previous container instance state.
	PreviousState *ContainerState `json:"previousState,omitempty"`
	// Events - The events of this container instance.
	Events *[]ContainerEvent `json:"events,omitempty"`
}

// ContainerLabel describes a container label.
type ContainerLabel struct {
	// Name - The name of the container label.
	Name *string `json:"name,omitempty"`
	// Value - The value of the container label.
	Value *string `json:"value,omitempty"`
}

// ContainerLogs the logs of the container.
type ContainerLogs struct {
	autorest.Response `json:"-"`
	// Content - content of the log.
	Content *string `json:"content,omitempty"`
}

// ContainerState the container state.
type ContainerState struct {
	// State - The state of this container
	State *string `json:"state,omitempty"`
	// StartTime - Date/time when the container state started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// ExitCode - The container exit code.
	ExitCode *string `json:"exitCode,omitempty"`
	// FinishTime - Date/time when the container state finished.
	FinishTime *date.Time `json:"finishTime,omitempty"`
	// DetailStatus - Human-readable status of this state.
	DetailStatus *string `json:"detailStatus,omitempty"`
}

// ContainerVolume describes how a volume is attached to a container.
type ContainerVolume struct {
	// Name - Name of the volume.
	Name *string `json:"name,omitempty"`
	// ReadOnly - The flag indicating whether the volume is read only. Default is 'false'.
	ReadOnly *bool `json:"readOnly,omitempty"`
	// DestinationPath - The path within the container at which the volume should be mounted. Only valid path characters are allowed.
	DestinationPath *string `json:"destinationPath,omitempty"`
}

// DiagnosticsDescription describes the diagnostics options available
type DiagnosticsDescription struct {
	// Sinks - List of supported sinks that can be referenced.
	Sinks *[]BasicDiagnosticsSinkProperties `json:"sinks,omitempty"`
	// Enabled - Status of whether or not sinks are enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// DefaultSinkRefs - The sinks to be used if diagnostics is enabled. Sink choices can be overridden at the service and code package level.
	DefaultSinkRefs *[]string `json:"defaultSinkRefs,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DiagnosticsDescription struct.
func (dd *DiagnosticsDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sinks":
			if v != nil {
				sinks, err := unmarshalBasicDiagnosticsSinkPropertiesArray(*v)
				if err != nil {
					return err
				}
				dd.Sinks = &sinks
			}
		case "enabled":
			if v != nil {
				var enabled bool
				err = json.Unmarshal(*v, &enabled)
				if err != nil {
					return err
				}
				dd.Enabled = &enabled
			}
		case "defaultSinkRefs":
			if v != nil {
				var defaultSinkRefs []string
				err = json.Unmarshal(*v, &defaultSinkRefs)
				if err != nil {
					return err
				}
				dd.DefaultSinkRefs = &defaultSinkRefs
			}
		}
	}

	return nil
}

// DiagnosticsRef reference to sinks in DiagnosticsDescription.
type DiagnosticsRef struct {
	// Enabled - Status of whether or not sinks are enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// SinkRefs - List of sinks to be used if enabled. References the list of sinks in DiagnosticsDescription.
	SinkRefs *[]string `json:"sinkRefs,omitempty"`
}

// BasicDiagnosticsSinkProperties properties of a DiagnosticsSink.
type BasicDiagnosticsSinkProperties interface {
	AsAzureInternalMonitoringPipelineSinkDescription() (*AzureInternalMonitoringPipelineSinkDescription, bool)
	AsDiagnosticsSinkProperties() (*DiagnosticsSinkProperties, bool)
}

// DiagnosticsSinkProperties properties of a DiagnosticsSink.
type DiagnosticsSinkProperties struct {
	// Name - Name of the sink. This value is referenced by DiagnosticsReferenceDescription
	Name *string `json:"name,omitempty"`
	// Description - A description of the sink.
	Description *string `json:"description,omitempty"`
	// Kind - Possible values include: 'KindDiagnosticsSinkProperties', 'KindAzureInternalMonitoringPipeline'
	Kind Kind `json:"kind,omitempty"`
}

func unmarshalBasicDiagnosticsSinkProperties(body []byte) (BasicDiagnosticsSinkProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindAzureInternalMonitoringPipeline):
		var aimpsd AzureInternalMonitoringPipelineSinkDescription
		err := json.Unmarshal(body, &aimpsd)
		return aimpsd, err
	default:
		var dsp DiagnosticsSinkProperties
		err := json.Unmarshal(body, &dsp)
		return dsp, err
	}
}
func unmarshalBasicDiagnosticsSinkPropertiesArray(body []byte) ([]BasicDiagnosticsSinkProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dspArray := make([]BasicDiagnosticsSinkProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dsp, err := unmarshalBasicDiagnosticsSinkProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		dspArray[index] = dsp
	}
	return dspArray, nil
}

// MarshalJSON is the custom marshaler for DiagnosticsSinkProperties.
func (dsp DiagnosticsSinkProperties) MarshalJSON() ([]byte, error) {
	dsp.Kind = KindDiagnosticsSinkProperties
	objectMap := make(map[string]interface{})
	if dsp.Name != nil {
		objectMap["name"] = dsp.Name
	}
	if dsp.Description != nil {
		objectMap["description"] = dsp.Description
	}
	if dsp.Kind != "" {
		objectMap["kind"] = dsp.Kind
	}
	return json.Marshal(objectMap)
}

// AsAzureInternalMonitoringPipelineSinkDescription is the BasicDiagnosticsSinkProperties implementation for DiagnosticsSinkProperties.
func (dsp DiagnosticsSinkProperties) AsAzureInternalMonitoringPipelineSinkDescription() (*AzureInternalMonitoringPipelineSinkDescription, bool) {
	return nil, false
}

// AsDiagnosticsSinkProperties is the BasicDiagnosticsSinkProperties implementation for DiagnosticsSinkProperties.
func (dsp DiagnosticsSinkProperties) AsDiagnosticsSinkProperties() (*DiagnosticsSinkProperties, bool) {
	return &dsp, true
}

// AsBasicDiagnosticsSinkProperties is the BasicDiagnosticsSinkProperties implementation for DiagnosticsSinkProperties.
func (dsp DiagnosticsSinkProperties) AsBasicDiagnosticsSinkProperties() (BasicDiagnosticsSinkProperties, bool) {
	return &dsp, true
}

// EndpointProperties describes a container endpoint.
type EndpointProperties struct {
	// Name - The name of the endpoint.
	Name *string `json:"name,omitempty"`
	// Port - Port used by the container.
	Port *int32 `json:"port,omitempty"`
}

// EnvironmentVariable describes an environment variable for the container.
type EnvironmentVariable struct {
	// Name - The name of the environment variable.
	Name *string `json:"name,omitempty"`
	// Value - The value of the environment variable.
	Value *string `json:"value,omitempty"`
}

// ErrorModel the error details.
type ErrorModel struct {
	// Code - The error code.
	Code *string `json:"code,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
}

// ImageRegistryCredential image registry credential.
type ImageRegistryCredential struct {
	// Server - Docker image registry server, without protocol such as `http` and `https`.
	Server *string `json:"server,omitempty"`
	// Username - The username for the private registry.
	Username *string `json:"username,omitempty"`
	// Password - The password for the private registry.
	Password *string `json:"password,omitempty"`
}

// IngressConfig describes public connectivity configuration for the network.
type IngressConfig struct {
	// QosLevel - The QoS tier for ingress. Possible values include: 'Bronze'
	QosLevel IngressQoSLevel `json:"qosLevel,omitempty"`
	// Layer4 - Configuration for layer4 public connectivity for this network.
	Layer4 *[]Layer4IngressConfig `json:"layer4,omitempty"`
	// PublicIPAddress - READ-ONLY; The public IP address for reaching this network.
	PublicIPAddress *string `json:"publicIPAddress,omitempty"`
}

// MarshalJSON is the custom marshaler for IngressConfig.
func (ic IngressConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ic.QosLevel != "" {
		objectMap["qosLevel"] = ic.QosLevel
	}
	if ic.Layer4 != nil {
		objectMap["layer4"] = ic.Layer4
	}
	return json.Marshal(objectMap)
}

// Layer4IngressConfig describes the layer4 configuration for public connectivity for this network.
type Layer4IngressConfig struct {
	// Name - Layer4 ingress config name.
	Name *string `json:"name,omitempty"`
	// PublicPort - Specifies the public port at which the service endpoint below needs to be exposed.
	PublicPort *int32 `json:"publicPort,omitempty"`
	// ApplicationName - The application name which contains the service to be exposed.
	ApplicationName *string `json:"applicationName,omitempty"`
	// ServiceName - The service whose endpoint needs to be exposed at the public port.
	ServiceName *string `json:"serviceName,omitempty"`
	// EndpointName - The service endpoint that needs to be exposed.
	EndpointName *string `json:"endpointName,omitempty"`
}

// ManagedProxyResource the resource model definition for Azure Resource Manager proxy resource. It will
// have everything other than required location and tags. This proxy resource is explicitly created or
// updated by including it in the parent resource.
type ManagedProxyResource struct {
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedProxyResource.
func (mpr ManagedProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mpr.Name != nil {
		objectMap["name"] = mpr.Name
	}
	return json.Marshal(objectMap)
}

// NetworkProperties describes a network.
type NetworkProperties struct {
	// Description - User readable description of the network.
	Description *string `json:"description,omitempty"`
	// AddressPrefix - the address prefix for this network.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// IngressConfig - Configuration for public connectivity for this network.
	IngressConfig *IngressConfig `json:"ingressConfig,omitempty"`
}

// NetworkRef describes a network reference in a service.
type NetworkRef struct {
	// Name - Name of the network.
	Name *string `json:"name,omitempty"`
}

// NetworkResourceDescription this type describes a network resource.
type NetworkResourceDescription struct {
	autorest.Response `json:"-"`
	// NetworkResourceProperties - Describes properties of a network resource.
	*NetworkResourceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkResourceDescription.
func (nrd NetworkResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nrd.NetworkResourceProperties != nil {
		objectMap["properties"] = nrd.NetworkResourceProperties
	}
	if nrd.Tags != nil {
		objectMap["tags"] = nrd.Tags
	}
	if nrd.Location != nil {
		objectMap["location"] = nrd.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NetworkResourceDescription struct.
func (nrd *NetworkResourceDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var networkResourceProperties NetworkResourceProperties
				err = json.Unmarshal(*v, &networkResourceProperties)
				if err != nil {
					return err
				}
				nrd.NetworkResourceProperties = &networkResourceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				nrd.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nrd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nrd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nrd.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				nrd.Location = &location
			}
		}
	}

	return nil
}

// NetworkResourceDescriptionList a pageable list of network resources.
type NetworkResourceDescriptionList struct {
	autorest.Response `json:"-"`
	// Value - One page of the list.
	Value *[]NetworkResourceDescription `json:"value,omitempty"`
	// NextLink - URI to fetch the next page of the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// NetworkResourceDescriptionListIterator provides access to a complete listing of
// NetworkResourceDescription values.
type NetworkResourceDescriptionListIterator struct {
	i    int
	page NetworkResourceDescriptionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NetworkResourceDescriptionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkResourceDescriptionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NetworkResourceDescriptionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NetworkResourceDescriptionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NetworkResourceDescriptionListIterator) Response() NetworkResourceDescriptionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NetworkResourceDescriptionListIterator) Value() NetworkResourceDescription {
	if !iter.page.NotDone() {
		return NetworkResourceDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NetworkResourceDescriptionListIterator type.
func NewNetworkResourceDescriptionListIterator(page NetworkResourceDescriptionListPage) NetworkResourceDescriptionListIterator {
	return NetworkResourceDescriptionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nrdl NetworkResourceDescriptionList) IsEmpty() bool {
	return nrdl.Value == nil || len(*nrdl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (nrdl NetworkResourceDescriptionList) hasNextLink() bool {
	return nrdl.NextLink != nil && len(*nrdl.NextLink) != 0
}

// networkResourceDescriptionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nrdl NetworkResourceDescriptionList) networkResourceDescriptionListPreparer(ctx context.Context) (*http.Request, error) {
	if !nrdl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nrdl.NextLink)))
}

// NetworkResourceDescriptionListPage contains a page of NetworkResourceDescription values.
type NetworkResourceDescriptionListPage struct {
	fn   func(context.Context, NetworkResourceDescriptionList) (NetworkResourceDescriptionList, error)
	nrdl NetworkResourceDescriptionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NetworkResourceDescriptionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkResourceDescriptionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.nrdl)
		if err != nil {
			return err
		}
		page.nrdl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NetworkResourceDescriptionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NetworkResourceDescriptionListPage) NotDone() bool {
	return !page.nrdl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NetworkResourceDescriptionListPage) Response() NetworkResourceDescriptionList {
	return page.nrdl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NetworkResourceDescriptionListPage) Values() []NetworkResourceDescription {
	if page.nrdl.IsEmpty() {
		return nil
	}
	return *page.nrdl.Value
}

// Creates a new instance of the NetworkResourceDescriptionListPage type.
func NewNetworkResourceDescriptionListPage(cur NetworkResourceDescriptionList, getNextPage func(context.Context, NetworkResourceDescriptionList) (NetworkResourceDescriptionList, error)) NetworkResourceDescriptionListPage {
	return NetworkResourceDescriptionListPage{
		fn:   getNextPage,
		nrdl: cur,
	}
}

// NetworkResourceProperties describes properties of a network resource.
type NetworkResourceProperties struct {
	// ProvisioningState - READ-ONLY; State of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Description - User readable description of the network.
	Description *string `json:"description,omitempty"`
	// AddressPrefix - the address prefix for this network.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// IngressConfig - Configuration for public connectivity for this network.
	IngressConfig *IngressConfig `json:"ingressConfig,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkResourceProperties.
func (nrp NetworkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nrp.Description != nil {
		objectMap["description"] = nrp.Description
	}
	if nrp.AddressPrefix != nil {
		objectMap["addressPrefix"] = nrp.AddressPrefix
	}
	if nrp.IngressConfig != nil {
		objectMap["ingressConfig"] = nrp.IngressConfig
	}
	return json.Marshal(objectMap)
}

// OperationListResult describes the result of the request to list Service Fabric operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Service Fabric operations supported by the Microsoft.ServiceFabric resource provider.
	Value *[]OperationResult `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if olr.Value != nil {
		objectMap["value"] = olr.Value
	}
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of OperationResult values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() OperationResult {
	if !iter.page.NotDone() {
		return OperationResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of OperationResult values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []OperationResult {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationResult list of operations available at the listed Azure resource provider.
type OperationResult struct {
	// Name - The name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *AvailableOperationDisplay `json:"display,omitempty"`
	// Origin - Origin result
	Origin *string `json:"origin,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProvisionedResourceProperties describes common properties of a provisioned resource.
type ProvisionedResourceProperties struct {
	// ProvisioningState - READ-ONLY; State of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ProxyResource the resource model definition for Azure Resource Manager proxy resource. It will have
// everything other than required location and tags.
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pr.Location != nil {
		objectMap["location"] = pr.Location
	}
	return json.Marshal(objectMap)
}

// Resource the resource model definition for Azure Resource Manager resource.
type Resource struct {
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	return json.Marshal(objectMap)
}

// ResourceLimits this type describes the resource limits for a given container. It describes the most
// amount of resources a container is allowed to use before being restarted.
type ResourceLimits struct {
	// MemoryInGB - The memory limit in GB.
	MemoryInGB *float64 `json:"memoryInGB,omitempty"`
	// CPU - CPU limits in cores. At present, only full cores are supported.
	CPU *float64 `json:"cpu,omitempty"`
}

// ResourceRequests this type describes the requested resources for a given container. It describes the
// least amount of resources required for the container. A container can consume more than requested
// resources up to the specified limits before being restarted. Currently, the requested resources are
// treated as limits.
type ResourceRequests struct {
	// MemoryInGB - The memory request in GB for this container.
	MemoryInGB *float64 `json:"memoryInGB,omitempty"`
	// CPU - Requested number of CPU cores. At present, only full cores are supported.
	CPU *float64 `json:"cpu,omitempty"`
}

// ResourceRequirements this type describes the resource requirements for a container or a service.
type ResourceRequirements struct {
	// Requests - Describes the requested resources for a given container.
	Requests *ResourceRequests `json:"requests,omitempty"`
	// Limits - Describes the maximum limits on the resources for a given container.
	Limits *ResourceLimits `json:"limits,omitempty"`
}

// ServiceList a pageable list of all services in an application.
type ServiceList struct {
	autorest.Response `json:"-"`
	// Value - One page of the list.
	Value *[]ServiceResourceDescription `json:"value,omitempty"`
	// NextLink - URI to fetch the next page of the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceListIterator provides access to a complete listing of ServiceResourceDescription values.
type ServiceListIterator struct {
	i    int
	page ServiceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceListIterator) Response() ServiceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceListIterator) Value() ServiceResourceDescription {
	if !iter.page.NotDone() {
		return ServiceResourceDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceListIterator type.
func NewServiceListIterator(page ServiceListPage) ServiceListIterator {
	return ServiceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sl ServiceList) IsEmpty() bool {
	return sl.Value == nil || len(*sl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sl ServiceList) hasNextLink() bool {
	return sl.NextLink != nil && len(*sl.NextLink) != 0
}

// serviceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sl ServiceList) serviceListPreparer(ctx context.Context) (*http.Request, error) {
	if !sl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sl.NextLink)))
}

// ServiceListPage contains a page of ServiceResourceDescription values.
type ServiceListPage struct {
	fn func(context.Context, ServiceList) (ServiceList, error)
	sl ServiceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sl)
		if err != nil {
			return err
		}
		page.sl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceListPage) NotDone() bool {
	return !page.sl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceListPage) Response() ServiceList {
	return page.sl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceListPage) Values() []ServiceResourceDescription {
	if page.sl.IsEmpty() {
		return nil
	}
	return *page.sl.Value
}

// Creates a new instance of the ServiceListPage type.
func NewServiceListPage(cur ServiceList, getNextPage func(context.Context, ServiceList) (ServiceList, error)) ServiceListPage {
	return ServiceListPage{
		fn: getNextPage,
		sl: cur,
	}
}

// ServiceReplicaDescription this type describes a replica of a service resource.
type ServiceReplicaDescription struct {
	autorest.Response `json:"-"`
	// ReplicaName - Name of the replica.
	ReplicaName *string `json:"replicaName,omitempty"`
	// OsType - The Operating system type required by the code in service.
	// . Possible values include: 'Linux', 'Windows'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// CodePackages - Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
	CodePackages *[]ContainerCodePackageProperties `json:"codePackages,omitempty"`
	// NetworkRefs - The names of the private networks that this service needs to be part of.
	NetworkRefs *[]NetworkRef `json:"networkRefs,omitempty"`
	// Diagnostics - Reference to sinks in DiagnosticsDescription.
	Diagnostics *DiagnosticsRef `json:"diagnostics,omitempty"`
}

// ServiceReplicaList a pageable list of replicas of a service resource.
type ServiceReplicaList struct {
	autorest.Response `json:"-"`
	// Value - One page of the list.
	Value *[]ServiceReplicaDescription `json:"value,omitempty"`
	// NextLink - URI to fetch the next page of the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceReplicaListIterator provides access to a complete listing of ServiceReplicaDescription values.
type ServiceReplicaListIterator struct {
	i    int
	page ServiceReplicaListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceReplicaListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceReplicaListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceReplicaListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceReplicaListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceReplicaListIterator) Response() ServiceReplicaList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceReplicaListIterator) Value() ServiceReplicaDescription {
	if !iter.page.NotDone() {
		return ServiceReplicaDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceReplicaListIterator type.
func NewServiceReplicaListIterator(page ServiceReplicaListPage) ServiceReplicaListIterator {
	return ServiceReplicaListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (srl ServiceReplicaList) IsEmpty() bool {
	return srl.Value == nil || len(*srl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (srl ServiceReplicaList) hasNextLink() bool {
	return srl.NextLink != nil && len(*srl.NextLink) != 0
}

// serviceReplicaListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (srl ServiceReplicaList) serviceReplicaListPreparer(ctx context.Context) (*http.Request, error) {
	if !srl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(srl.NextLink)))
}

// ServiceReplicaListPage contains a page of ServiceReplicaDescription values.
type ServiceReplicaListPage struct {
	fn  func(context.Context, ServiceReplicaList) (ServiceReplicaList, error)
	srl ServiceReplicaList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceReplicaListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceReplicaListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.srl)
		if err != nil {
			return err
		}
		page.srl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceReplicaListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceReplicaListPage) NotDone() bool {
	return !page.srl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceReplicaListPage) Response() ServiceReplicaList {
	return page.srl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceReplicaListPage) Values() []ServiceReplicaDescription {
	if page.srl.IsEmpty() {
		return nil
	}
	return *page.srl.Value
}

// Creates a new instance of the ServiceReplicaListPage type.
func NewServiceReplicaListPage(cur ServiceReplicaList, getNextPage func(context.Context, ServiceReplicaList) (ServiceReplicaList, error)) ServiceReplicaListPage {
	return ServiceReplicaListPage{
		fn:  getNextPage,
		srl: cur,
	}
}

// ServiceReplicaProperties describes the properties of a service replica.
type ServiceReplicaProperties struct {
	// OsType - The Operating system type required by the code in service.
	// . Possible values include: 'Linux', 'Windows'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// CodePackages - Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
	CodePackages *[]ContainerCodePackageProperties `json:"codePackages,omitempty"`
	// NetworkRefs - The names of the private networks that this service needs to be part of.
	NetworkRefs *[]NetworkRef `json:"networkRefs,omitempty"`
	// Diagnostics - Reference to sinks in DiagnosticsDescription.
	Diagnostics *DiagnosticsRef `json:"diagnostics,omitempty"`
}

// ServiceResourceDescription this type describes a service resource.
type ServiceResourceDescription struct {
	autorest.Response `json:"-"`
	// ServiceResourceProperties - This type describes properties of a service resource.
	*ServiceResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceResourceDescription.
func (srd ServiceResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if srd.ServiceResourceProperties != nil {
		objectMap["properties"] = srd.ServiceResourceProperties
	}
	if srd.Name != nil {
		objectMap["name"] = srd.Name
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceResourceDescription struct.
func (srd *ServiceResourceDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceResourceProperties ServiceResourceProperties
				err = json.Unmarshal(*v, &serviceResourceProperties)
				if err != nil {
					return err
				}
				srd.ServiceResourceProperties = &serviceResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				srd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				srd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				srd.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceResourceProperties this type describes properties of a service resource.
type ServiceResourceProperties struct {
	// Description - User readable description of the service.
	Description *string `json:"description,omitempty"`
	// ReplicaCount - The number of replicas of the service to create. Defaults to 1 if not specified.
	ReplicaCount *int32 `json:"replicaCount,omitempty"`
	// HealthState - The health state of a resource such as Application, Service, or Network. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"healthState,omitempty"`
	// Status - READ-ONLY; Represents the status of the service. Possible values include: 'ServiceResourceStatusUnknown', 'ServiceResourceStatusActive', 'ServiceResourceStatusUpgrading', 'ServiceResourceStatusDeleting', 'ServiceResourceStatusCreating', 'ServiceResourceStatusFailed'
	Status ServiceResourceStatus `json:"status,omitempty"`
	// OsType - The Operating system type required by the code in service.
	// . Possible values include: 'Linux', 'Windows'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// CodePackages - Describes the set of code packages that forms the service. A code package describes the container and the properties for running it. All the code packages are started together on the same host and share the same context (network, process etc.).
	CodePackages *[]ContainerCodePackageProperties `json:"codePackages,omitempty"`
	// NetworkRefs - The names of the private networks that this service needs to be part of.
	NetworkRefs *[]NetworkRef `json:"networkRefs,omitempty"`
	// Diagnostics - Reference to sinks in DiagnosticsDescription.
	Diagnostics *DiagnosticsRef `json:"diagnostics,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceResourceProperties.
func (srp ServiceResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if srp.Description != nil {
		objectMap["description"] = srp.Description
	}
	if srp.ReplicaCount != nil {
		objectMap["replicaCount"] = srp.ReplicaCount
	}
	if srp.HealthState != "" {
		objectMap["healthState"] = srp.HealthState
	}
	if srp.OsType != "" {
		objectMap["osType"] = srp.OsType
	}
	if srp.CodePackages != nil {
		objectMap["codePackages"] = srp.CodePackages
	}
	if srp.NetworkRefs != nil {
		objectMap["networkRefs"] = srp.NetworkRefs
	}
	if srp.Diagnostics != nil {
		objectMap["diagnostics"] = srp.Diagnostics
	}
	return json.Marshal(objectMap)
}

// Setting describes a setting for the container.
type Setting struct {
	// Name - The name of the setting.
	Name *string `json:"name,omitempty"`
	// Value - The value of the setting.
	Value *string `json:"value,omitempty"`
}

// TrackedResource the resource model definition for Azure Resource Manager tracked top-level resource.
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// VolumeProperties this type describes properties of a volume resource.
type VolumeProperties struct {
	// Description - User readable description of the volume.
	Description *string `json:"description,omitempty"`
	// Provider - Provider of the volume.
	Provider *string `json:"provider,omitempty"`
	// AzureFileParameters - This type describes a volume provided by an Azure Files file share.
	AzureFileParameters *VolumeProviderParametersAzureFile `json:"azureFileParameters,omitempty"`
}

// VolumeProviderParametersAzureFile this type describes a volume provided by an Azure Files file share.
type VolumeProviderParametersAzureFile struct {
	// AccountName - Name of the Azure storage account for the File Share.
	AccountName *string `json:"accountName,omitempty"`
	// AccountKey - Access key of the Azure storage account for the File Share.
	AccountKey *string `json:"accountKey,omitempty"`
	// ShareName - Name of the Azure Files file share that provides storage for the volume.
	ShareName *string `json:"shareName,omitempty"`
}

// VolumeResourceDescription this type describes a volume resource.
type VolumeResourceDescription struct {
	autorest.Response `json:"-"`
	// VolumeResourceProperties - Describes properties of a volume resource.
	*VolumeResourceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for VolumeResourceDescription.
func (vrd VolumeResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vrd.VolumeResourceProperties != nil {
		objectMap["properties"] = vrd.VolumeResourceProperties
	}
	if vrd.Tags != nil {
		objectMap["tags"] = vrd.Tags
	}
	if vrd.Location != nil {
		objectMap["location"] = vrd.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VolumeResourceDescription struct.
func (vrd *VolumeResourceDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var volumeResourceProperties VolumeResourceProperties
				err = json.Unmarshal(*v, &volumeResourceProperties)
				if err != nil {
					return err
				}
				vrd.VolumeResourceProperties = &volumeResourceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vrd.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vrd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vrd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vrd.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vrd.Location = &location
			}
		}
	}

	return nil
}

// VolumeResourceDescriptionList a pageable list of volume resources.
type VolumeResourceDescriptionList struct {
	autorest.Response `json:"-"`
	// Value - One page of the list.
	Value *[]VolumeResourceDescription `json:"value,omitempty"`
	// NextLink - URI to fetch the next page of the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// VolumeResourceDescriptionListIterator provides access to a complete listing of VolumeResourceDescription
// values.
type VolumeResourceDescriptionListIterator struct {
	i    int
	page VolumeResourceDescriptionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VolumeResourceDescriptionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VolumeResourceDescriptionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VolumeResourceDescriptionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VolumeResourceDescriptionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VolumeResourceDescriptionListIterator) Response() VolumeResourceDescriptionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VolumeResourceDescriptionListIterator) Value() VolumeResourceDescription {
	if !iter.page.NotDone() {
		return VolumeResourceDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VolumeResourceDescriptionListIterator type.
func NewVolumeResourceDescriptionListIterator(page VolumeResourceDescriptionListPage) VolumeResourceDescriptionListIterator {
	return VolumeResourceDescriptionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vrdl VolumeResourceDescriptionList) IsEmpty() bool {
	return vrdl.Value == nil || len(*vrdl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vrdl VolumeResourceDescriptionList) hasNextLink() bool {
	return vrdl.NextLink != nil && len(*vrdl.NextLink) != 0
}

// volumeResourceDescriptionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vrdl VolumeResourceDescriptionList) volumeResourceDescriptionListPreparer(ctx context.Context) (*http.Request, error) {
	if !vrdl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vrdl.NextLink)))
}

// VolumeResourceDescriptionListPage contains a page of VolumeResourceDescription values.
type VolumeResourceDescriptionListPage struct {
	fn   func(context.Context, VolumeResourceDescriptionList) (VolumeResourceDescriptionList, error)
	vrdl VolumeResourceDescriptionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VolumeResourceDescriptionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VolumeResourceDescriptionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vrdl)
		if err != nil {
			return err
		}
		page.vrdl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VolumeResourceDescriptionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VolumeResourceDescriptionListPage) NotDone() bool {
	return !page.vrdl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VolumeResourceDescriptionListPage) Response() VolumeResourceDescriptionList {
	return page.vrdl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VolumeResourceDescriptionListPage) Values() []VolumeResourceDescription {
	if page.vrdl.IsEmpty() {
		return nil
	}
	return *page.vrdl.Value
}

// Creates a new instance of the VolumeResourceDescriptionListPage type.
func NewVolumeResourceDescriptionListPage(cur VolumeResourceDescriptionList, getNextPage func(context.Context, VolumeResourceDescriptionList) (VolumeResourceDescriptionList, error)) VolumeResourceDescriptionListPage {
	return VolumeResourceDescriptionListPage{
		fn:   getNextPage,
		vrdl: cur,
	}
}

// VolumeResourceProperties describes properties of a volume resource.
type VolumeResourceProperties struct {
	// ProvisioningState - READ-ONLY; State of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Description - User readable description of the volume.
	Description *string `json:"description,omitempty"`
	// Provider - Provider of the volume.
	Provider *string `json:"provider,omitempty"`
	// AzureFileParameters - This type describes a volume provided by an Azure Files file share.
	AzureFileParameters *VolumeProviderParametersAzureFile `json:"azureFileParameters,omitempty"`
}

// MarshalJSON is the custom marshaler for VolumeResourceProperties.
func (vrp VolumeResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vrp.Description != nil {
		objectMap["description"] = vrp.Description
	}
	if vrp.Provider != nil {
		objectMap["provider"] = vrp.Provider
	}
	if vrp.AzureFileParameters != nil {
		objectMap["azureFileParameters"] = vrp.AzureFileParameters
	}
	return json.Marshal(objectMap)
}
