package postgresqlflexibleservers

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/postgresql/mgmt/2020-02-14-preview/postgresqlflexibleservers"

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// CapabilitiesListResult location capability
type CapabilitiesListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A list of supported capabilities.
	Value *[]CapabilityProperties `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// CapabilitiesListResultIterator provides access to a complete listing of CapabilityProperties values.
type CapabilitiesListResultIterator struct {
	i    int
	page CapabilitiesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CapabilitiesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CapabilitiesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CapabilitiesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CapabilitiesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CapabilitiesListResultIterator) Response() CapabilitiesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CapabilitiesListResultIterator) Value() CapabilityProperties {
	if !iter.page.NotDone() {
		return CapabilityProperties{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CapabilitiesListResultIterator type.
func NewCapabilitiesListResultIterator(page CapabilitiesListResultPage) CapabilitiesListResultIterator {
	return CapabilitiesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr CapabilitiesListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (clr CapabilitiesListResult) hasNextLink() bool {
	return clr.NextLink != nil && len(*clr.NextLink) != 0
}

// capabilitiesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr CapabilitiesListResult) capabilitiesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !clr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// CapabilitiesListResultPage contains a page of CapabilityProperties values.
type CapabilitiesListResultPage struct {
	fn  func(context.Context, CapabilitiesListResult) (CapabilitiesListResult, error)
	clr CapabilitiesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CapabilitiesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CapabilitiesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.clr)
		if err != nil {
			return err
		}
		page.clr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CapabilitiesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CapabilitiesListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CapabilitiesListResultPage) Response() CapabilitiesListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CapabilitiesListResultPage) Values() []CapabilityProperties {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the CapabilitiesListResultPage type.
func NewCapabilitiesListResultPage(cur CapabilitiesListResult, getNextPage func(context.Context, CapabilitiesListResult) (CapabilitiesListResult, error)) CapabilitiesListResultPage {
	return CapabilitiesListResultPage{
		fn:  getNextPage,
		clr: cur,
	}
}

// CapabilityProperties location capabilities.
type CapabilityProperties struct {
	// Zone - READ-ONLY; zone name
	Zone *string `json:"zone,omitempty"`
	// SupportedFlexibleServerEditions - READ-ONLY
	SupportedFlexibleServerEditions *[]ServerEditionCapability `json:"supportedFlexibleServerEditions,omitempty"`
}

// CloudError an error response from the Batch service.
type CloudError struct {
	Error *ErrorResponse `json:"error,omitempty"`
}

// Configuration represents a Configuration.
type Configuration struct {
	autorest.Response `json:"-"`
	// ConfigurationProperties - The properties of a configuration.
	*ConfigurationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Configuration.
func (c Configuration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ConfigurationProperties != nil {
		objectMap["properties"] = c.ConfigurationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Configuration struct.
func (c *Configuration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var configurationProperties ConfigurationProperties
				err = json.Unmarshal(*v, &configurationProperties)
				if err != nil {
					return err
				}
				c.ConfigurationProperties = &configurationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ConfigurationListResult a list of server configurations.
type ConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server configurations.
	Value *[]Configuration `json:"value,omitempty"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// ConfigurationListResultIterator provides access to a complete listing of Configuration values.
type ConfigurationListResultIterator struct {
	i    int
	page ConfigurationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConfigurationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConfigurationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConfigurationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConfigurationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConfigurationListResultIterator) Response() ConfigurationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConfigurationListResultIterator) Value() Configuration {
	if !iter.page.NotDone() {
		return Configuration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConfigurationListResultIterator type.
func NewConfigurationListResultIterator(page ConfigurationListResultPage) ConfigurationListResultIterator {
	return ConfigurationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr ConfigurationListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (clr ConfigurationListResult) hasNextLink() bool {
	return clr.NextLink != nil && len(*clr.NextLink) != 0
}

// configurationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr ConfigurationListResult) configurationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !clr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// ConfigurationListResultPage contains a page of Configuration values.
type ConfigurationListResultPage struct {
	fn  func(context.Context, ConfigurationListResult) (ConfigurationListResult, error)
	clr ConfigurationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConfigurationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConfigurationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.clr)
		if err != nil {
			return err
		}
		page.clr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConfigurationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConfigurationListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConfigurationListResultPage) Response() ConfigurationListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConfigurationListResultPage) Values() []Configuration {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the ConfigurationListResultPage type.
func NewConfigurationListResultPage(cur ConfigurationListResult, getNextPage func(context.Context, ConfigurationListResult) (ConfigurationListResult, error)) ConfigurationListResultPage {
	return ConfigurationListResultPage{
		fn:  getNextPage,
		clr: cur,
	}
}

// ConfigurationProperties the properties of a configuration.
type ConfigurationProperties struct {
	// Value - Value of the configuration.
	Value *string `json:"value,omitempty"`
	// Description - READ-ONLY; Description of the configuration.
	Description *string `json:"description,omitempty"`
	// DefaultValue - READ-ONLY; Default value of the configuration.
	DefaultValue *string `json:"defaultValue,omitempty"`
	// DataType - READ-ONLY; Data type of the configuration. Possible values include: 'Boolean', 'Numeric', 'Integer', 'Enumeration'
	DataType ConfigurationDataType `json:"dataType,omitempty"`
	// AllowedValues - READ-ONLY; Allowed values of the configuration.
	AllowedValues *string `json:"allowedValues,omitempty"`
	// Source - Source of the configuration.
	Source *string `json:"source,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationProperties.
func (cp ConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.Value != nil {
		objectMap["value"] = cp.Value
	}
	if cp.Source != nil {
		objectMap["source"] = cp.Source
	}
	return json.Marshal(objectMap)
}

// ConfigurationsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ConfigurationsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConfigurationsClient) (Configuration, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConfigurationsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConfigurationsUpdateFuture.Result.
func (future *ConfigurationsUpdateFuture) result(client ConfigurationsClient) (c Configuration, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ConfigurationsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.ConfigurationsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.UpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ConfigurationsUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DelegatedSubnetUsage delegated subnet usage data.
type DelegatedSubnetUsage struct {
	// SubnetName - READ-ONLY; name of the subnet
	SubnetName *string `json:"subnetName,omitempty"`
	// Usage - READ-ONLY; Number of used delegated subnets
	Usage *int64 `json:"usage,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.)
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorResponse `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// FirewallRule represents a server firewall rule.
type FirewallRule struct {
	autorest.Response `json:"-"`
	// FirewallRuleProperties - The properties of a firewall rule.
	*FirewallRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallRule.
func (fr FirewallRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fr.FirewallRuleProperties != nil {
		objectMap["properties"] = fr.FirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallRule struct.
func (fr *FirewallRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var firewallRuleProperties FirewallRuleProperties
				err = json.Unmarshal(*v, &firewallRuleProperties)
				if err != nil {
					return err
				}
				fr.FirewallRuleProperties = &firewallRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fr.Type = &typeVar
			}
		}
	}

	return nil
}

// FirewallRuleListResult a list of firewall rules.
type FirewallRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of firewall rules in a server.
	Value *[]FirewallRule `json:"value,omitempty"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// FirewallRuleListResultIterator provides access to a complete listing of FirewallRule values.
type FirewallRuleListResultIterator struct {
	i    int
	page FirewallRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FirewallRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FirewallRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FirewallRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FirewallRuleListResultIterator) Response() FirewallRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FirewallRuleListResultIterator) Value() FirewallRule {
	if !iter.page.NotDone() {
		return FirewallRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FirewallRuleListResultIterator type.
func NewFirewallRuleListResultIterator(page FirewallRuleListResultPage) FirewallRuleListResultIterator {
	return FirewallRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (frlr FirewallRuleListResult) IsEmpty() bool {
	return frlr.Value == nil || len(*frlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (frlr FirewallRuleListResult) hasNextLink() bool {
	return frlr.NextLink != nil && len(*frlr.NextLink) != 0
}

// firewallRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (frlr FirewallRuleListResult) firewallRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !frlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(frlr.NextLink)))
}

// FirewallRuleListResultPage contains a page of FirewallRule values.
type FirewallRuleListResultPage struct {
	fn   func(context.Context, FirewallRuleListResult) (FirewallRuleListResult, error)
	frlr FirewallRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FirewallRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.frlr)
		if err != nil {
			return err
		}
		page.frlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FirewallRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FirewallRuleListResultPage) NotDone() bool {
	return !page.frlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FirewallRuleListResultPage) Response() FirewallRuleListResult {
	return page.frlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FirewallRuleListResultPage) Values() []FirewallRule {
	if page.frlr.IsEmpty() {
		return nil
	}
	return *page.frlr.Value
}

// Creates a new instance of the FirewallRuleListResultPage type.
func NewFirewallRuleListResultPage(cur FirewallRuleListResult, getNextPage func(context.Context, FirewallRuleListResult) (FirewallRuleListResult, error)) FirewallRuleListResultPage {
	return FirewallRuleListResultPage{
		fn:   getNextPage,
		frlr: cur,
	}
}

// FirewallRuleProperties the properties of a server firewall rule.
type FirewallRuleProperties struct {
	// StartIPAddress - The start IP address of the server firewall rule. Must be IPv4 format.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	// EndIPAddress - The end IP address of the server firewall rule. Must be IPv4 format.
	EndIPAddress *string `json:"endIpAddress,omitempty"`
}

// FirewallRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FirewallRulesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FirewallRulesClient) (FirewallRule, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FirewallRulesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FirewallRulesCreateOrUpdateFuture.Result.
func (future *FirewallRulesCreateOrUpdateFuture) result(client FirewallRulesClient) (fr FirewallRule, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.FirewallRulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.FirewallRulesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fr.Response.Response, err = future.GetResult(sender); err == nil && fr.Response.Response.StatusCode != http.StatusNoContent {
		fr, err = client.CreateOrUpdateResponder(fr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.FirewallRulesCreateOrUpdateFuture", "Result", fr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FirewallRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FirewallRulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FirewallRulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FirewallRulesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FirewallRulesDeleteFuture.Result.
func (future *FirewallRulesDeleteFuture) result(client FirewallRulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.FirewallRulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.FirewallRulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'SystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// MaintenanceWindow maintenance window of a server.
type MaintenanceWindow struct {
	// CustomWindow - indicates whether custom window is enabled or disabled
	CustomWindow *string `json:"customWindow,omitempty"`
	// StartHour - start hour for maintenance window
	StartHour *int32 `json:"startHour,omitempty"`
	// StartMinute - start minute for maintenance window
	StartMinute *int32 `json:"startMinute,omitempty"`
	// DayOfWeek - day of week for maintenance window
	DayOfWeek *int32 `json:"dayOfWeek,omitempty"`
}

// NameAvailability represents a resource name availability.
type NameAvailability struct {
	autorest.Response `json:"-"`
	// Message - Error Message.
	Message *string `json:"message,omitempty"`
	// NameAvailable - Indicates whether the resource name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Name - name of the PostgreSQL server.
	Name *string `json:"name,omitempty"`
	// Type - type of the server
	Type *string `json:"type,omitempty"`
}

// NameAvailabilityRequest request from client to check resource name availability.
type NameAvailabilityRequest struct {
	// Name - Resource name to verify.
	Name *string `json:"name,omitempty"`
	// Type - Resource type used for verification.
	Type *string `json:"type,omitempty"`
}

// Operation REST API operation definition.
type Operation struct {
	// Name - READ-ONLY; The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; The localized display information for this particular operation or action.
	Display *OperationDisplay `json:"display,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation. Possible values include: 'NotSpecified', 'User', 'System'
	Origin OperationOrigin `json:"origin,omitempty"`
	// Properties - READ-ONLY; Additional descriptions for the operation.
	Properties map[string]interface{} `json:"properties"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.IsDataAction != nil {
		objectMap["isDataAction"] = o.IsDataAction
	}
	return json.Marshal(objectMap)
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Operation resource provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Localized friendly name for the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; Operation description.
	Description *string `json:"description,omitempty"`
}

// OperationListResult a list of resource provider operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - Collection of available operation details
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// Plan plan for the resource.
type Plan struct {
	// Name - A user defined name of the 3rd Party Artifact that is being procured.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
	Publisher *string `json:"publisher,omitempty"`
	// Product - The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact at the time of Data Market onboarding.
	Product *string `json:"product,omitempty"`
	// PromotionCode - A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Version - The version of the desired product/artifact.
	Version *string `json:"version,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// ResourceModelWithAllowedPropertySet the resource model definition containing the full set of allowed
// properties for a resource. Except properties bag, there cannot be a top level property outside of this
// set.
type ResourceModelWithAllowedPropertySet struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ManagedBy - The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Kind - Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
	Kind *string `json:"kind,omitempty"`
	// Etag - READ-ONLY; The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags     map[string]*string                           `json:"tags"`
	Identity *ResourceModelWithAllowedPropertySetIdentity `json:"identity,omitempty"`
	Sku      *ResourceModelWithAllowedPropertySetSku      `json:"sku,omitempty"`
	Plan     *ResourceModelWithAllowedPropertySetPlan     `json:"plan,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceModelWithAllowedPropertySet.
func (rmwaps ResourceModelWithAllowedPropertySet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmwaps.Location != nil {
		objectMap["location"] = rmwaps.Location
	}
	if rmwaps.ManagedBy != nil {
		objectMap["managedBy"] = rmwaps.ManagedBy
	}
	if rmwaps.Kind != nil {
		objectMap["kind"] = rmwaps.Kind
	}
	if rmwaps.Tags != nil {
		objectMap["tags"] = rmwaps.Tags
	}
	if rmwaps.Identity != nil {
		objectMap["identity"] = rmwaps.Identity
	}
	if rmwaps.Sku != nil {
		objectMap["sku"] = rmwaps.Sku
	}
	if rmwaps.Plan != nil {
		objectMap["plan"] = rmwaps.Plan
	}
	return json.Marshal(objectMap)
}

// ResourceModelWithAllowedPropertySetIdentity ...
type ResourceModelWithAllowedPropertySetIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'SystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceModelWithAllowedPropertySetIdentity.
func (rmwaps ResourceModelWithAllowedPropertySetIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmwaps.Type != "" {
		objectMap["type"] = rmwaps.Type
	}
	return json.Marshal(objectMap)
}

// ResourceModelWithAllowedPropertySetPlan ...
type ResourceModelWithAllowedPropertySetPlan struct {
	// Name - A user defined name of the 3rd Party Artifact that is being procured.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
	Publisher *string `json:"publisher,omitempty"`
	// Product - The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact at the time of Data Market onboarding.
	Product *string `json:"product,omitempty"`
	// PromotionCode - A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Version - The version of the desired product/artifact.
	Version *string `json:"version,omitempty"`
}

// ResourceModelWithAllowedPropertySetSku ...
type ResourceModelWithAllowedPropertySetSku struct {
	// Name - The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
	Name *string `json:"name,omitempty"`
	// Tier - The tier of the particular SKU, e.g. Burstable. Possible values include: 'Burstable', 'GeneralPurpose', 'MemoryOptimized'
	Tier SkuTier `json:"tier,omitempty"`
}

// Server represents a server.
type Server struct {
	autorest.Response `json:"-"`
	// Identity - The Azure Active Directory identity of the server.
	Identity *Identity `json:"identity,omitempty"`
	// Sku - The SKU (pricing tier) of the server.
	Sku *Sku `json:"sku,omitempty"`
	// ServerProperties - Properties of the server.
	*ServerProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Server.
func (s Server) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Identity != nil {
		objectMap["identity"] = s.Identity
	}
	if s.Sku != nil {
		objectMap["sku"] = s.Sku
	}
	if s.ServerProperties != nil {
		objectMap["properties"] = s.ServerProperties
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Server struct.
func (s *Server) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				s.Identity = &identity
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				s.Sku = &sku
			}
		case "properties":
			if v != nil {
				var serverProperties ServerProperties
				err = json.Unmarshal(*v, &serverProperties)
				if err != nil {
					return err
				}
				s.ServerProperties = &serverProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerEditionCapability server edition capabilities.
type ServerEditionCapability struct {
	// Name - READ-ONLY; Server edition name
	Name *string `json:"name,omitempty"`
	// SupportedStorageEditions - READ-ONLY
	SupportedStorageEditions *[]StorageEditionCapability `json:"supportedStorageEditions,omitempty"`
	// SupportedServerVersions - READ-ONLY
	SupportedServerVersions *[]ServerVersionCapability `json:"supportedServerVersions,omitempty"`
}

// ServerForUpdate represents a server to be updated.
type ServerForUpdate struct {
	// Location - The location the resource resides in.
	Location *string `json:"location,omitempty"`
	// Sku - The SKU (pricing tier) of the server.
	Sku *Sku `json:"sku,omitempty"`
	// ServerPropertiesForUpdate - Properties of the server.
	*ServerPropertiesForUpdate `json:"properties,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServerForUpdate.
func (sfu ServerForUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sfu.Location != nil {
		objectMap["location"] = sfu.Location
	}
	if sfu.Sku != nil {
		objectMap["sku"] = sfu.Sku
	}
	if sfu.ServerPropertiesForUpdate != nil {
		objectMap["properties"] = sfu.ServerPropertiesForUpdate
	}
	if sfu.Tags != nil {
		objectMap["tags"] = sfu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerForUpdate struct.
func (sfu *ServerForUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sfu.Location = &location
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sfu.Sku = &sku
			}
		case "properties":
			if v != nil {
				var serverPropertiesForUpdate ServerPropertiesForUpdate
				err = json.Unmarshal(*v, &serverPropertiesForUpdate)
				if err != nil {
					return err
				}
				sfu.ServerPropertiesForUpdate = &serverPropertiesForUpdate
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sfu.Tags = tags
			}
		}
	}

	return nil
}

// ServerListResult a list of servers.
type ServerListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of flexible servers
	Value *[]Server `json:"value,omitempty"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerListResultIterator provides access to a complete listing of Server values.
type ServerListResultIterator struct {
	i    int
	page ServerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerListResultIterator) Response() ServerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerListResultIterator) Value() Server {
	if !iter.page.NotDone() {
		return Server{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerListResultIterator type.
func NewServerListResultIterator(page ServerListResultPage) ServerListResultIterator {
	return ServerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr ServerListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slr ServerListResult) hasNextLink() bool {
	return slr.NextLink != nil && len(*slr.NextLink) != 0
}

// serverListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr ServerListResult) serverListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !slr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// ServerListResultPage contains a page of Server values.
type ServerListResultPage struct {
	fn  func(context.Context, ServerListResult) (ServerListResult, error)
	slr ServerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slr)
		if err != nil {
			return err
		}
		page.slr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerListResultPage) Response() ServerListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerListResultPage) Values() []Server {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the ServerListResultPage type.
func NewServerListResultPage(cur ServerListResult, getNextPage func(context.Context, ServerListResult) (ServerListResult, error)) ServerListResultPage {
	return ServerListResultPage{
		fn:  getNextPage,
		slr: cur,
	}
}

// ServerProperties the properties of a server.
type ServerProperties struct {
	// AdministratorLogin - The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The administrator login password (required for server creation).
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// Version - PostgreSQL Server version. Possible values include: 'OneTwo', 'OneOne'
	Version ServerVersion `json:"version,omitempty"`
	// State - READ-ONLY; A state of a server that is visible to user. Possible values include: 'ServerStateReady', 'ServerStateDropping', 'ServerStateDisabled', 'ServerStateStarting', 'ServerStateStopping', 'ServerStateStopped', 'ServerStateUpdating'
	State ServerState `json:"state,omitempty"`
	// HaState - READ-ONLY; A state of a HA server that is visible to user. Possible values include: 'NotEnabled', 'CreatingStandby', 'ReplicatingData', 'FailingOver', 'Healthy', 'RemovingStandby'
	HaState ServerHAState `json:"haState,omitempty"`
	// FullyQualifiedDomainName - READ-ONLY; The fully qualified domain name of a server.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty"`
	// DisplayName - The display name of a server.
	DisplayName *string `json:"displayName,omitempty"`
	// StorageProfile - Storage profile of a server.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`
	// PublicNetworkAccess - READ-ONLY; public network access is enabled or not. Possible values include: 'ServerPublicNetworkAccessStateEnabled', 'ServerPublicNetworkAccessStateDisabled'
	PublicNetworkAccess ServerPublicNetworkAccessState `json:"publicNetworkAccess,omitempty"`
	// MaintenanceWindow - Maintenance window of a server.
	MaintenanceWindow *MaintenanceWindow `json:"maintenanceWindow,omitempty"`
	// HaEnabled - stand by count value can be either enabled or disabled. Possible values include: 'Enabled', 'Disabled'
	HaEnabled HAEnabledEnum `json:"haEnabled,omitempty"`
	// SourceServerName - The source PostgreSQL server name to restore from.
	SourceServerName *string `json:"sourceServerName,omitempty"`
	// SourceSubscriptionID - The subscription id of source serve PostgreSQL server name to restore from.
	SourceSubscriptionID *string `json:"sourceSubscriptionId,omitempty"`
	// SourceResourceGroupName - The resource group name of source serve PostgreSQL server name to restore from.
	SourceResourceGroupName *string `json:"sourceResourceGroupName,omitempty"`
	// PointInTimeUTC - Restore point creation time (ISO8601 format), specifying the time to restore from.
	PointInTimeUTC *date.Time `json:"pointInTimeUTC,omitempty"`
	// AvailabilityZone - availability Zone information of the server.
	AvailabilityZone *string `json:"availabilityZone,omitempty"`
	// StandbyAvailabilityZone - READ-ONLY; availability Zone information of the server.
	StandbyAvailabilityZone *string `json:"standbyAvailabilityZone,omitempty"`
	// ByokEnforcement - READ-ONLY; Status showing whether the data encryption is enabled with customer-managed keys.
	ByokEnforcement          *string                                   `json:"byokEnforcement,omitempty"`
	DelegatedSubnetArguments *ServerPropertiesDelegatedSubnetArguments `json:"delegatedSubnetArguments,omitempty"`
	// CreateMode - The mode to create a new PostgreSQL server. Possible values include: 'Default', 'PointInTimeRestore'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServerProperties.
func (sp ServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.AdministratorLogin != nil {
		objectMap["administratorLogin"] = sp.AdministratorLogin
	}
	if sp.AdministratorLoginPassword != nil {
		objectMap["administratorLoginPassword"] = sp.AdministratorLoginPassword
	}
	if sp.Version != "" {
		objectMap["version"] = sp.Version
	}
	if sp.DisplayName != nil {
		objectMap["displayName"] = sp.DisplayName
	}
	if sp.StorageProfile != nil {
		objectMap["storageProfile"] = sp.StorageProfile
	}
	if sp.MaintenanceWindow != nil {
		objectMap["maintenanceWindow"] = sp.MaintenanceWindow
	}
	if sp.HaEnabled != "" {
		objectMap["haEnabled"] = sp.HaEnabled
	}
	if sp.SourceServerName != nil {
		objectMap["sourceServerName"] = sp.SourceServerName
	}
	if sp.SourceSubscriptionID != nil {
		objectMap["sourceSubscriptionId"] = sp.SourceSubscriptionID
	}
	if sp.SourceResourceGroupName != nil {
		objectMap["sourceResourceGroupName"] = sp.SourceResourceGroupName
	}
	if sp.PointInTimeUTC != nil {
		objectMap["pointInTimeUTC"] = sp.PointInTimeUTC
	}
	if sp.AvailabilityZone != nil {
		objectMap["availabilityZone"] = sp.AvailabilityZone
	}
	if sp.DelegatedSubnetArguments != nil {
		objectMap["delegatedSubnetArguments"] = sp.DelegatedSubnetArguments
	}
	if sp.CreateMode != "" {
		objectMap["createMode"] = sp.CreateMode
	}
	if sp.Tags != nil {
		objectMap["tags"] = sp.Tags
	}
	return json.Marshal(objectMap)
}

// ServerPropertiesDelegatedSubnetArguments ...
type ServerPropertiesDelegatedSubnetArguments struct {
	// SubnetArmResourceID - delegated subnet arm resource id.
	SubnetArmResourceID *string `json:"subnetArmResourceId,omitempty"`
}

// ServerPropertiesForUpdate ...
type ServerPropertiesForUpdate struct {
	// AdministratorLoginPassword - The password of the administrator login.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// StorageProfile - Storage profile of a server.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`
	// HaEnabled - stand by count value can be either enabled or disabled. Possible values include: 'Enabled', 'Disabled'
	HaEnabled HAEnabledEnum `json:"haEnabled,omitempty"`
	// MaintenanceWindow - Maintenance window of a server.
	MaintenanceWindow *MaintenanceWindow `json:"maintenanceWindow,omitempty"`
}

// ServersCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (Server, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServersCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServersCreateFuture.Result.
func (future *ServersCreateFuture) result(client ServersClient) (s Server, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ServersCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.ServersCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ServersCreateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServersDeleteFuture.Result.
func (future *ServersDeleteFuture) result(client ServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ServersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.ServersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServersRestartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersRestartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServersRestartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServersRestartFuture.Result.
func (future *ServersRestartFuture) result(client ServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ServersRestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.ServersRestartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServersStartFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServersStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServersStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServersStartFuture.Result.
func (future *ServersStartFuture) result(client ServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ServersStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.ServersStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServersStopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServersStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServersStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServersStopFuture.Result.
func (future *ServersStopFuture) result(client ServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ServersStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.ServersStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (Server, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServersUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServersUpdateFuture.Result.
func (future *ServersUpdateFuture) result(client ServersClient) (s Server, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ServersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("postgresqlflexibleservers.ServersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.UpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "postgresqlflexibleservers.ServersUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerVersionCapability server version capabilities.
type ServerVersionCapability struct {
	// Name - READ-ONLY; server version
	Name *string `json:"name,omitempty"`
	// SupportedVcores - READ-ONLY
	SupportedVcores *[]VcoreCapability `json:"supportedVcores,omitempty"`
}

// Sku sku information related properties of a server.
type Sku struct {
	// Name - The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
	Name *string `json:"name,omitempty"`
	// Tier - The tier of the particular SKU, e.g. Burstable. Possible values include: 'Burstable', 'GeneralPurpose', 'MemoryOptimized'
	Tier SkuTier `json:"tier,omitempty"`
}

// StorageEditionCapability storage edition capability
type StorageEditionCapability struct {
	// Name - READ-ONLY; storage edition name
	Name *string `json:"name,omitempty"`
	// SupportedStorageMB - READ-ONLY
	SupportedStorageMB *[]StorageMBCapability `json:"supportedStorageMB,omitempty"`
}

// StorageMBCapability storage size in MB capability
type StorageMBCapability struct {
	// Name - READ-ONLY; storage MB name
	Name *string `json:"name,omitempty"`
	// SupportedIops - READ-ONLY; supported IOPS
	SupportedIops *int64 `json:"supportedIops,omitempty"`
	// StorageSizeMB - READ-ONLY; storage size in MB
	StorageSizeMB *int64 `json:"storageSizeMB,omitempty"`
}

// StorageProfile storage Profile properties of a server
type StorageProfile struct {
	// BackupRetentionDays - Backup retention days for the server.
	BackupRetentionDays *int32 `json:"backupRetentionDays,omitempty"`
	// StorageMB - Max storage allowed for a server.
	StorageMB *int32 `json:"storageMB,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// VcoreCapability vcores capability
type VcoreCapability struct {
	// Name - READ-ONLY; vCore name
	Name *string `json:"name,omitempty"`
	// VCores - READ-ONLY; supported vCores
	VCores *int64 `json:"vCores,omitempty"`
	// SupportedIops - READ-ONLY; supported IOPS
	SupportedIops *int64 `json:"supportedIops,omitempty"`
	// SupportedMemoryPerVcoreMB - READ-ONLY; supported memory per vCore in MB
	SupportedMemoryPerVcoreMB *int64 `json:"supportedMemoryPerVcoreMB,omitempty"`
}

// VirtualNetworkSubnetUsageParameter virtual network subnet usage parameter
type VirtualNetworkSubnetUsageParameter struct {
	// VirtualNetworkArmResourceID - Virtual network resource id.
	VirtualNetworkArmResourceID *string `json:"virtualNetworkArmResourceId,omitempty"`
}

// VirtualNetworkSubnetUsageResult virtual network subnet usage data.
type VirtualNetworkSubnetUsageResult struct {
	autorest.Response `json:"-"`
	// DelegatedSubnetsUsage - READ-ONLY
	DelegatedSubnetsUsage *[]DelegatedSubnetUsage `json:"delegatedSubnetsUsage,omitempty"`
}
