package kusto

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/kusto/mgmt/2018-09-07-preview/kusto"

// AzureCapacity ...
type AzureCapacity struct {
	// ScaleType - Scale type. Possible values include: 'Automatic', 'Manual', 'None'
	ScaleType AzureScaleType `json:"scaleType,omitempty"`
	// Minimum - Minimum allowed capacity.
	Minimum *int32 `json:"minimum,omitempty"`
	// Maximum - Maximum allowed capacity.
	Maximum *int32 `json:"maximum,omitempty"`
	// Default - The default capacity that would be used.
	Default *int32 `json:"default,omitempty"`
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// AzureResourceSku ...
type AzureResourceSku struct {
	// ResourceType - Resource Namespace and Type.
	ResourceType *string `json:"resourceType,omitempty"`
	// Sku - The SKU details.
	Sku *AzureSku `json:"sku,omitempty"`
	// Capacity - The SKU capacity.
	Capacity *AzureCapacity `json:"capacity,omitempty"`
}

// AzureSku ...
type AzureSku struct {
	// Name - SKU name. Possible values include: 'KC8', 'KC16', 'KS8', 'KS16', 'D13V2', 'D14V2', 'L8', 'L16'
	Name AzureSkuName `json:"name,omitempty"`
	// Capacity - SKU capacity.
	Capacity *int32 `json:"capacity,omitempty"`
	// Tier - SKU tier.
	Tier *string `json:"tier,omitempty"`
}

// CheckNameResult ...
type CheckNameResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - Specifies a Boolean value that indicates if the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Name - The name that was checked.
	Name *string `json:"name,omitempty"`
	// Message - Message indicating an unavailable name due to a conflict, or a description of the naming rules that are violated.
	Message *string `json:"message,omitempty"`
}

// CloudError an error response from Kusto.
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from Kusto.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for displaying in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// Cluster class representing a Kusto cluster.
type Cluster struct {
	autorest.Response `json:"-"`
	// Etag - READ-ONLY; An ETag of the resource created.
	Etag *string `json:"etag,omitempty"`
	// Sku - The SKU of the cluster.
	Sku                *AzureSku `json:"sku,omitempty"`
	*ClusterProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Sku != nil {
		objectMap["sku"] = c.Sku
	}
	if c.ClusterProperties != nil {
		objectMap["properties"] = c.ClusterProperties
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Cluster struct.
func (c *Cluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				c.Etag = &etag
			}
		case "sku":
			if v != nil {
				var sku AzureSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				c.Sku = &sku
			}
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				c.ClusterProperties = &clusterProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ClusterCheckNameRequest ...
type ClusterCheckNameRequest struct {
	// Name - Cluster name.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource, Microsoft.Kusto/clusters.
	Type *string `json:"type,omitempty"`
}

// ClusterListResult the list Kusto clusters operation response.
type ClusterListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto clusters.
	Value *[]Cluster `json:"value,omitempty"`
}

// ClusterProperties class representing the Kusto cluster properties.
type ClusterProperties struct {
	// State - READ-ONLY; The state of the resource. Possible values include: 'StateCreating', 'StateUnavailable', 'StateRunning', 'StateDeleting', 'StateDeleted', 'StateStopping', 'StateStopped', 'StateStarting'
	State State `json:"state,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioned state of the resource. Possible values include: 'Running', 'Creating', 'Deleting', 'Succeeded', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// URI - READ-ONLY; The cluster URI.
	URI *string `json:"uri,omitempty"`
	// DataIngestionURI - READ-ONLY; The cluster data ingestion URI.
	DataIngestionURI *string `json:"dataIngestionUri,omitempty"`
	// TrustedExternalTenants - The cluster's external tenants.
	TrustedExternalTenants *[]TrustedExternalTenant `json:"trustedExternalTenants,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterProperties.
func (cp ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.TrustedExternalTenants != nil {
		objectMap["trustedExternalTenants"] = cp.TrustedExternalTenants
	}
	return json.Marshal(objectMap)
}

// ClustersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersCreateOrUpdateFuture.Result.
func (future *ClustersCreateOrUpdateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateOrUpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.ClustersCreateOrUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersDeleteFuture.Result.
func (future *ClustersDeleteFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersStartFuture.Result.
func (future *ClustersStartFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersStopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ClustersStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersStopFuture.Result.
func (future *ClustersStopFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersUpdateFuture.Result.
func (future *ClustersUpdateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.UpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.ClustersUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClusterUpdate class representing an update to a Kusto cluster.
type ClusterUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Etag - READ-ONLY; An ETag of the resource updated.
	Etag *string `json:"etag,omitempty"`
	// Sku - The SKU of the cluster.
	Sku                *AzureSku `json:"sku,omitempty"`
	*ClusterProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpdate.
func (cu ClusterUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cu.Tags != nil {
		objectMap["tags"] = cu.Tags
	}
	if cu.Location != nil {
		objectMap["location"] = cu.Location
	}
	if cu.Sku != nil {
		objectMap["sku"] = cu.Sku
	}
	if cu.ClusterProperties != nil {
		objectMap["properties"] = cu.ClusterProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterUpdate struct.
func (cu *ClusterUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cu.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cu.Location = &location
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				cu.Etag = &etag
			}
		case "sku":
			if v != nil {
				var sku AzureSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				cu.Sku = &sku
			}
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				cu.ClusterProperties = &clusterProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cu.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cu.Type = &typeVar
			}
		}
	}

	return nil
}

// Database class representing a Kusto database.
type Database struct {
	autorest.Response `json:"-"`
	// Etag - READ-ONLY; An ETag of the resource created.
	Etag                *string `json:"etag,omitempty"`
	*DatabaseProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Database.
func (d Database) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DatabaseProperties != nil {
		objectMap["properties"] = d.DatabaseProperties
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Database struct.
func (d *Database) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				d.Etag = &etag
			}
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				d.DatabaseProperties = &databaseProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseCheckNameRequest ...
type DatabaseCheckNameRequest struct {
	// Name - Database name.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource, Microsoft.Kusto/clusters/databases.
	Type *string `json:"type,omitempty"`
}

// DatabaseListResult the list Kusto databases operation response.
type DatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto databases.
	Value *[]Database `json:"value,omitempty"`
}

// DatabasePrincipal ...
type DatabasePrincipal struct {
	// Role - Database principal role. Possible values include: 'Admin', 'Ingestor', 'Monitor', 'User', 'UnrestrictedViewers', 'Viewer'
	Role DatabasePrincipalRole `json:"role,omitempty"`
	// Name - Database principal name.
	Name *string `json:"name,omitempty"`
	// Type - Database principal type. Possible values include: 'DatabasePrincipalTypeApp', 'DatabasePrincipalTypeGroup', 'DatabasePrincipalTypeUser'
	Type DatabasePrincipalType `json:"type,omitempty"`
	// Fqn - Database principal fully qualified name.
	Fqn *string `json:"fqn,omitempty"`
	// Email - Database principal email if exists.
	Email *string `json:"email,omitempty"`
	// AppID - Application id - relevant only for application principal type.
	AppID *string `json:"appId,omitempty"`
}

// DatabasePrincipalListRequest the list Kusto database principals operation request.
type DatabasePrincipalListRequest struct {
	// Value - The list of Kusto database principals.
	Value *[]DatabasePrincipal `json:"value,omitempty"`
}

// DatabasePrincipalListResult the list Kusto database principals operation response.
type DatabasePrincipalListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto database principals.
	Value *[]DatabasePrincipal `json:"value,omitempty"`
}

// DatabaseProperties class representing the Kusto database properties.
type DatabaseProperties struct {
	// ProvisioningState - READ-ONLY; The provisioned state of the resource. Possible values include: 'Running', 'Creating', 'Deleting', 'Succeeded', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// SoftDeletePeriodInDays - The number of days data should be kept before it stops being accessible to queries.
	SoftDeletePeriodInDays *int32 `json:"softDeletePeriodInDays,omitempty"`
	// HotCachePeriodInDays - The number of days of data that should be kept in cache for fast queries.
	HotCachePeriodInDays *int32 `json:"hotCachePeriodInDays,omitempty"`
	// Statistics - The statistics of the database.
	Statistics *DatabaseStatistics `json:"statistics,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseProperties.
func (dp DatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.SoftDeletePeriodInDays != nil {
		objectMap["softDeletePeriodInDays"] = dp.SoftDeletePeriodInDays
	}
	if dp.HotCachePeriodInDays != nil {
		objectMap["hotCachePeriodInDays"] = dp.HotCachePeriodInDays
	}
	if dp.Statistics != nil {
		objectMap["statistics"] = dp.Statistics
	}
	return json.Marshal(objectMap)
}

// DatabasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesCreateOrUpdateFuture.Result.
func (future *DatabasesCreateOrUpdateFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DatabasesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.DatabasesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.DatabasesCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesDeleteFuture.Result.
func (future *DatabasesDeleteFuture) result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DatabasesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.DatabasesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseStatistics ...
type DatabaseStatistics struct {
	// Size - The database size - the total size of compressed data and index in bytes.
	Size *float64 `json:"size,omitempty"`
}

// DatabasesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesUpdateFuture.Result.
func (future *DatabasesUpdateFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DatabasesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.DatabasesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.UpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.DatabasesUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseUpdate class representing an update to a Kusto database.
type DatabaseUpdate struct {
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Etag - READ-ONLY; An ETag of the resource updated.
	Etag                *string `json:"etag,omitempty"`
	*DatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseUpdate.
func (du DatabaseUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if du.Location != nil {
		objectMap["location"] = du.Location
	}
	if du.DatabaseProperties != nil {
		objectMap["properties"] = du.DatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseUpdate struct.
func (du *DatabaseUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				du.Location = &location
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				du.Etag = &etag
			}
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				du.DatabaseProperties = &databaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				du.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				du.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				du.Type = &typeVar
			}
		}
	}

	return nil
}

// EventHubConnection class representing an event hub connection.
type EventHubConnection struct {
	autorest.Response `json:"-"`
	// Location - Resource location.
	Location                      *string `json:"location,omitempty"`
	*EventHubConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubConnection.
func (ehc EventHubConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ehc.Location != nil {
		objectMap["location"] = ehc.Location
	}
	if ehc.EventHubConnectionProperties != nil {
		objectMap["properties"] = ehc.EventHubConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EventHubConnection struct.
func (ehc *EventHubConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ehc.Location = &location
			}
		case "properties":
			if v != nil {
				var eventHubConnectionProperties EventHubConnectionProperties
				err = json.Unmarshal(*v, &eventHubConnectionProperties)
				if err != nil {
					return err
				}
				ehc.EventHubConnectionProperties = &eventHubConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ehc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ehc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ehc.Type = &typeVar
			}
		}
	}

	return nil
}

// EventHubConnectionListResult the list Kusto event hub connections operation response.
type EventHubConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto event hub connections.
	Value *[]EventHubConnection `json:"value,omitempty"`
}

// EventHubConnectionProperties class representing the Kusto event hub connection properties.
type EventHubConnectionProperties struct {
	// EventHubResourceID - The resource ID of the event hub to be used to create a data connection.
	EventHubResourceID *string `json:"eventHubResourceId,omitempty"`
	// ConsumerGroup - The event hub consumer group.
	ConsumerGroup *string `json:"consumerGroup,omitempty"`
	// TableName - The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string `json:"tableName,omitempty"`
	// MappingRuleName - The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string `json:"mappingRuleName,omitempty"`
	// DataFormat - The data format of the message. Optionally the data format can be added to each message. Possible values include: 'MULTIJSON', 'JSON', 'CSV'
	DataFormat DataFormat `json:"dataFormat,omitempty"`
}

// EventHubConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EventHubConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EventHubConnectionsClient) (EventHubConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EventHubConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EventHubConnectionsCreateOrUpdateFuture.Result.
func (future *EventHubConnectionsCreateOrUpdateFuture) result(client EventHubConnectionsClient) (ehc EventHubConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.EventHubConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.EventHubConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ehc.Response.Response, err = future.GetResult(sender); err == nil && ehc.Response.Response.StatusCode != http.StatusNoContent {
		ehc, err = client.CreateOrUpdateResponder(ehc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.EventHubConnectionsCreateOrUpdateFuture", "Result", ehc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EventHubConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EventHubConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EventHubConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EventHubConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EventHubConnectionsDeleteFuture.Result.
func (future *EventHubConnectionsDeleteFuture) result(client EventHubConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.EventHubConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.EventHubConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EventHubConnectionsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EventHubConnectionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EventHubConnectionsClient) (EventHubConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EventHubConnectionsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EventHubConnectionsUpdateFuture.Result.
func (future *EventHubConnectionsUpdateFuture) result(client EventHubConnectionsClient) (ehc EventHubConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.EventHubConnectionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("kusto.EventHubConnectionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ehc.Response.Response, err = future.GetResult(sender); err == nil && ehc.Response.Response.StatusCode != http.StatusNoContent {
		ehc, err = client.UpdateResponder(ehc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.EventHubConnectionsUpdateFuture", "Result", ehc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EventHubConnectionUpdate class representing an update to event hub connection.
type EventHubConnectionUpdate struct {
	// Location - Resource location.
	Location                      *string `json:"location,omitempty"`
	*EventHubConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubConnectionUpdate.
func (ehcu EventHubConnectionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ehcu.Location != nil {
		objectMap["location"] = ehcu.Location
	}
	if ehcu.EventHubConnectionProperties != nil {
		objectMap["properties"] = ehcu.EventHubConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EventHubConnectionUpdate struct.
func (ehcu *EventHubConnectionUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ehcu.Location = &location
			}
		case "properties":
			if v != nil {
				var eventHubConnectionProperties EventHubConnectionProperties
				err = json.Unmarshal(*v, &eventHubConnectionProperties)
				if err != nil {
					return err
				}
				ehcu.EventHubConnectionProperties = &eventHubConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ehcu.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ehcu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ehcu.Type = &typeVar
			}
		}
	}

	return nil
}

// EventHubConnectionValidation class representing an event hub connection validation.
type EventHubConnectionValidation struct {
	// EventhubConnectionName - The name of the event hub connection.
	EventhubConnectionName        *string `json:"eventhubConnectionName,omitempty"`
	*EventHubConnectionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubConnectionValidation.
func (ehcv EventHubConnectionValidation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ehcv.EventhubConnectionName != nil {
		objectMap["eventhubConnectionName"] = ehcv.EventhubConnectionName
	}
	if ehcv.EventHubConnectionProperties != nil {
		objectMap["properties"] = ehcv.EventHubConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EventHubConnectionValidation struct.
func (ehcv *EventHubConnectionValidation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "eventhubConnectionName":
			if v != nil {
				var eventhubConnectionName string
				err = json.Unmarshal(*v, &eventhubConnectionName)
				if err != nil {
					return err
				}
				ehcv.EventhubConnectionName = &eventhubConnectionName
			}
		case "properties":
			if v != nil {
				var eventHubConnectionProperties EventHubConnectionProperties
				err = json.Unmarshal(*v, &eventHubConnectionProperties)
				if err != nil {
					return err
				}
				ehcv.EventHubConnectionProperties = &eventHubConnectionProperties
			}
		}
	}

	return nil
}

// EventHubConnectionValidationListResult the list Kusto event hub connection validation result.
type EventHubConnectionValidationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto event hub connection validation errors.
	Value *[]EventHubConnectionValidationResult `json:"value,omitempty"`
}

// EventHubConnectionValidationResult ...
type EventHubConnectionValidationResult struct {
	// ErrorMessage - A message which indicates a problem in event hub connection validation.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// ListResourceSkusResult list of available SKUs for an existing Kusto Cluster.
type ListResourceSkusResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of available SKUs for an existing resource.
	Value *[]AzureResourceSku `json:"value,omitempty"`
}

// ListSkusResult list of available SKUs for a new Kusto Cluster.
type ListSkusResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of available SKUs for new resources.
	Value *[]AzureSku `json:"value,omitempty"`
}

// Operation ...
type Operation struct {
	// Name - This is of the format {provider}/{resource}/{operation}.
	Name       *string           `json:"name,omitempty"`
	Display    *OperationDisplay `json:"display,omitempty"`
	Origin     *string           `json:"origin,omitempty"`
	Properties interface{}       `json:"properties,omitempty"`
}

// OperationDisplay ...
type OperationDisplay struct {
	Provider *string `json:"provider,omitempty"`
	// Operation - For example: read, write, delete.
	Operation   *string `json:"operation,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Description *string `json:"description,omitempty"`
}

// OperationListResult ...
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// TrustedExternalTenant ...
type TrustedExternalTenant struct {
	// Value - GUID representing an external tenant.
	Value *string `json:"value,omitempty"`
}
