package hybridnetwork

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/hybridnetwork/mgmt/2020-01-01-preview/hybridnetwork"

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// CustomProfile specifies the custom settings for the virtual machine.
type CustomProfile struct {
	// MetadataConfigurationPath - Path for metadata configuration.
	MetadataConfigurationPath *string `json:"metadataConfigurationPath,omitempty"`
}

// DataDisk specifies information about the operating system disk used by the virtual machine. <br><br> For
// more information about disks, see [About disks and VHDs for Azure virtual
// machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
type DataDisk struct {
	// CreateOption - Specifies how the virtual machine should be created. Possible values include: 'Unknown', 'Empty'
	CreateOption DiskCreateOptionTypes `json:"createOption,omitempty"`
	// Name - The name of data disk.
	Name *string `json:"name,omitempty"`
	// DiskSizeGB - Specifies the size of an empty disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
}

// Device device resource.
type Device struct {
	autorest.Response `json:"-"`
	// BasicDevicePropertiesFormat - Device properties.
	BasicDevicePropertiesFormat `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Device.
func (d Device) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = d.BasicDevicePropertiesFormat
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Device struct.
func (d *Device) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				basicDevicePropertiesFormat, err := unmarshalBasicDevicePropertiesFormat(*v)
				if err != nil {
					return err
				}
				d.BasicDevicePropertiesFormat = basicDevicePropertiesFormat
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DeviceListResult response for devices API service call.
type DeviceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of devices.
	Value *[]Device `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DeviceListResult.
func (dlr DeviceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dlr.Value != nil {
		objectMap["value"] = dlr.Value
	}
	return json.Marshal(objectMap)
}

// DeviceListResultIterator provides access to a complete listing of Device values.
type DeviceListResultIterator struct {
	i    int
	page DeviceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeviceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeviceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeviceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeviceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeviceListResultIterator) Response() DeviceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeviceListResultIterator) Value() Device {
	if !iter.page.NotDone() {
		return Device{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeviceListResultIterator type.
func NewDeviceListResultIterator(page DeviceListResultPage) DeviceListResultIterator {
	return DeviceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dlr DeviceListResult) IsEmpty() bool {
	return dlr.Value == nil || len(*dlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dlr DeviceListResult) hasNextLink() bool {
	return dlr.NextLink != nil && len(*dlr.NextLink) != 0
}

// deviceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlr DeviceListResult) deviceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlr.NextLink)))
}

// DeviceListResultPage contains a page of Device values.
type DeviceListResultPage struct {
	fn  func(context.Context, DeviceListResult) (DeviceListResult, error)
	dlr DeviceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeviceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeviceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dlr)
		if err != nil {
			return err
		}
		page.dlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeviceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeviceListResultPage) NotDone() bool {
	return !page.dlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeviceListResultPage) Response() DeviceListResult {
	return page.dlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeviceListResultPage) Values() []Device {
	if page.dlr.IsEmpty() {
		return nil
	}
	return *page.dlr.Value
}

// Creates a new instance of the DeviceListResultPage type.
func NewDeviceListResultPage(cur DeviceListResult, getNextPage func(context.Context, DeviceListResult) (DeviceListResult, error)) DeviceListResultPage {
	return DeviceListResultPage{
		fn:  getNextPage,
		dlr: cur,
	}
}

// BasicDevicePropertiesFormat device properties.
type BasicDevicePropertiesFormat interface {
	AsDevicePropertiesFormat() (*DevicePropertiesFormat, bool)
}

// DevicePropertiesFormat device properties.
type DevicePropertiesFormat struct {
	// Status - READ-ONLY; The current device status. Possible values include: 'StatusUnknown', 'StatusNotRegistered', 'StatusRegistered', 'StatusDeleted'
	Status Status `json:"status,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the device resource. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateSucceeded', 'ProvisioningStateAccepted', 'ProvisioningStateDeleting', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeleted'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// AzureStackEdge - The reference to the Azure stack edge device.
	AzureStackEdge *SubResource `json:"azureStackEdge,omitempty"`
	// NetworkFunctions - READ-ONLY; The list of network functions deployed on the device.
	NetworkFunctions *[]SubResource `json:"networkFunctions,omitempty"`
	// DeviceType - Possible values include: 'DeviceTypeDevicePropertiesFormat'
	DeviceType DeviceType `json:"deviceType,omitempty"`
}

func unmarshalBasicDevicePropertiesFormat(body []byte) (BasicDevicePropertiesFormat, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["deviceType"] {
	default:
		var dpf DevicePropertiesFormat
		err := json.Unmarshal(body, &dpf)
		return dpf, err
	}
}
func unmarshalBasicDevicePropertiesFormatArray(body []byte) ([]BasicDevicePropertiesFormat, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dpfArray := make([]BasicDevicePropertiesFormat, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dpf, err := unmarshalBasicDevicePropertiesFormat(*rawMessage)
		if err != nil {
			return nil, err
		}
		dpfArray[index] = dpf
	}
	return dpfArray, nil
}

// MarshalJSON is the custom marshaler for DevicePropertiesFormat.
func (dpf DevicePropertiesFormat) MarshalJSON() ([]byte, error) {
	dpf.DeviceType = DeviceTypeDevicePropertiesFormat
	objectMap := make(map[string]interface{})
	if dpf.AzureStackEdge != nil {
		objectMap["azureStackEdge"] = dpf.AzureStackEdge
	}
	if dpf.DeviceType != "" {
		objectMap["deviceType"] = dpf.DeviceType
	}
	return json.Marshal(objectMap)
}

// AsDevicePropertiesFormat is the BasicDevicePropertiesFormat implementation for DevicePropertiesFormat.
func (dpf DevicePropertiesFormat) AsDevicePropertiesFormat() (*DevicePropertiesFormat, bool) {
	return &dpf, true
}

// AsBasicDevicePropertiesFormat is the BasicDevicePropertiesFormat implementation for DevicePropertiesFormat.
func (dpf DevicePropertiesFormat) AsBasicDevicePropertiesFormat() (BasicDevicePropertiesFormat, bool) {
	return &dpf, true
}

// DeviceRegistrationKey the device registration key.
type DeviceRegistrationKey struct {
	autorest.Response `json:"-"`
	// RegistrationKey - READ-ONLY; The registration key for the device.
	RegistrationKey *string `json:"registrationKey,omitempty"`
}

// DevicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (Device, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesCreateOrUpdateFuture.Result.
func (future *DevicesCreateOrUpdateFuture) result(client DevicesClient) (d Device, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.DevicesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.DevicesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hybridnetwork.DevicesCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DevicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesDeleteFuture.Result.
func (future *DevicesDeleteFuture) result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.DevicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.DevicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// ImageReference the image reference properties.
type ImageReference struct {
	// Publisher - The image publisher.
	Publisher *string `json:"publisher,omitempty"`
	// Offer - Specifies the offer of the image used to create the virtual machine.
	Offer *string `json:"offer,omitempty"`
	// Sku - The image SKU.
	Sku *string `json:"sku,omitempty"`
	// Version - Specifies the version of the image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
	Version *string `json:"version,omitempty"`
	// ExactVersion - Specifies in decimal numbers, the exact version of image used to create the virtual machine.
	ExactVersion *string `json:"exactVersion,omitempty"`
}

// LinuxConfiguration specifies the Linux operating system settings on the virtual machine.
type LinuxConfiguration struct {
	// SSH - Specifies the ssh key configuration for a Linux OS.
	SSH *SSHConfiguration `json:"ssh,omitempty"`
}

// NetworkFunction network function resource response.
type NetworkFunction struct {
	autorest.Response `json:"-"`
	// NetworkFunctionPropertiesFormat - Network function properties.
	*NetworkFunctionPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkFunction.
func (nf NetworkFunction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nf.NetworkFunctionPropertiesFormat != nil {
		objectMap["properties"] = nf.NetworkFunctionPropertiesFormat
	}
	if nf.Etag != nil {
		objectMap["etag"] = nf.Etag
	}
	if nf.Tags != nil {
		objectMap["tags"] = nf.Tags
	}
	if nf.Location != nil {
		objectMap["location"] = nf.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NetworkFunction struct.
func (nf *NetworkFunction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var networkFunctionPropertiesFormat NetworkFunctionPropertiesFormat
				err = json.Unmarshal(*v, &networkFunctionPropertiesFormat)
				if err != nil {
					return err
				}
				nf.NetworkFunctionPropertiesFormat = &networkFunctionPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				nf.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				nf.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				nf.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nf.Type = &typeVar
			}
		}
	}

	return nil
}

// NetworkFunctionListResult response for network function API service call.
type NetworkFunctionListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of network function resources in a subscription or resource group.
	Value *[]NetworkFunction `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkFunctionListResult.
func (nflr NetworkFunctionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nflr.Value != nil {
		objectMap["value"] = nflr.Value
	}
	return json.Marshal(objectMap)
}

// NetworkFunctionListResultIterator provides access to a complete listing of NetworkFunction values.
type NetworkFunctionListResultIterator struct {
	i    int
	page NetworkFunctionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NetworkFunctionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkFunctionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NetworkFunctionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NetworkFunctionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NetworkFunctionListResultIterator) Response() NetworkFunctionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NetworkFunctionListResultIterator) Value() NetworkFunction {
	if !iter.page.NotDone() {
		return NetworkFunction{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NetworkFunctionListResultIterator type.
func NewNetworkFunctionListResultIterator(page NetworkFunctionListResultPage) NetworkFunctionListResultIterator {
	return NetworkFunctionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nflr NetworkFunctionListResult) IsEmpty() bool {
	return nflr.Value == nil || len(*nflr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (nflr NetworkFunctionListResult) hasNextLink() bool {
	return nflr.NextLink != nil && len(*nflr.NextLink) != 0
}

// networkFunctionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nflr NetworkFunctionListResult) networkFunctionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !nflr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nflr.NextLink)))
}

// NetworkFunctionListResultPage contains a page of NetworkFunction values.
type NetworkFunctionListResultPage struct {
	fn   func(context.Context, NetworkFunctionListResult) (NetworkFunctionListResult, error)
	nflr NetworkFunctionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NetworkFunctionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkFunctionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.nflr)
		if err != nil {
			return err
		}
		page.nflr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NetworkFunctionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NetworkFunctionListResultPage) NotDone() bool {
	return !page.nflr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NetworkFunctionListResultPage) Response() NetworkFunctionListResult {
	return page.nflr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NetworkFunctionListResultPage) Values() []NetworkFunction {
	if page.nflr.IsEmpty() {
		return nil
	}
	return *page.nflr.Value
}

// Creates a new instance of the NetworkFunctionListResultPage type.
func NewNetworkFunctionListResultPage(cur NetworkFunctionListResult, getNextPage func(context.Context, NetworkFunctionListResult) (NetworkFunctionListResult, error)) NetworkFunctionListResultPage {
	return NetworkFunctionListResultPage{
		fn:   getNextPage,
		nflr: cur,
	}
}

// NetworkFunctionPropertiesFormat network function properties.
type NetworkFunctionPropertiesFormat struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the network function resource. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateSucceeded', 'ProvisioningStateAccepted', 'ProvisioningStateDeleting', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeleted'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Device - The reference to the device resource.
	Device *SubResource `json:"device,omitempty"`
	// SkuName - The sku name for the network function.
	SkuName *string `json:"skuName,omitempty"`
	// SkuType - READ-ONLY; The sku type for the network function. Possible values include: 'SkuTypeUnknown', 'SkuTypeEvolvedPacketCore', 'SkuTypeSDWAN', 'SkuTypeFirewall'
	SkuType SkuType `json:"skuType,omitempty"`
	// VendorName - The vendor name for the network function.
	VendorName *string `json:"vendorName,omitempty"`
	// ServiceKey - READ-ONLY; The service key for the network function resource.
	ServiceKey *string `json:"serviceKey,omitempty"`
	// VendorProvisioningState - READ-ONLY; The vendor provisioning state for the network function resource. Possible values include: 'VendorProvisioningStateUnknown', 'VendorProvisioningStateNotProvisioned', 'VendorProvisioningStateProvisioning', 'VendorProvisioningStateProvisioned', 'VendorProvisioningStateDeprovisioned', 'VendorProvisioningStateUserDataValidationFailed'
	VendorProvisioningState VendorProvisioningState `json:"vendorProvisioningState,omitempty"`
	// ManagedApplication - READ-ONLY; The resource URI of the managed application.
	ManagedApplication *SubResource `json:"managedApplication,omitempty"`
	// ManagedApplicationParameters - The parameters for the managed application.
	ManagedApplicationParameters interface{} `json:"managedApplicationParameters,omitempty"`
	// NetworkFunctionUserConfigurations - The network function configurations from the user.
	NetworkFunctionUserConfigurations *[]NetworkFunctionUserConfiguration `json:"networkFunctionUserConfigurations,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkFunctionPropertiesFormat.
func (nfpf NetworkFunctionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nfpf.Device != nil {
		objectMap["device"] = nfpf.Device
	}
	if nfpf.SkuName != nil {
		objectMap["skuName"] = nfpf.SkuName
	}
	if nfpf.VendorName != nil {
		objectMap["vendorName"] = nfpf.VendorName
	}
	if nfpf.ManagedApplicationParameters != nil {
		objectMap["managedApplicationParameters"] = nfpf.ManagedApplicationParameters
	}
	if nfpf.NetworkFunctionUserConfigurations != nil {
		objectMap["networkFunctionUserConfigurations"] = nfpf.NetworkFunctionUserConfigurations
	}
	return json.Marshal(objectMap)
}

// NetworkFunctionRoleConfiguration network function role configuration.
type NetworkFunctionRoleConfiguration struct {
	// RoleName - The name of the network function role.
	RoleName *string `json:"roleName,omitempty"`
	// RoleType - Role type. Possible values include: 'NetworkFunctionRoleConfigurationTypeUnknown', 'NetworkFunctionRoleConfigurationTypeVirtualMachine'
	RoleType NetworkFunctionRoleConfigurationType `json:"roleType,omitempty"`
	// VirtualMachineSize - The size of the virtual machine. Possible values include: 'VirtualMachineSizeTypesUnknown', 'VirtualMachineSizeTypesStandardD1V2', 'VirtualMachineSizeTypesStandardD2V2', 'VirtualMachineSizeTypesStandardD3V2', 'VirtualMachineSizeTypesStandardD4V2', 'VirtualMachineSizeTypesStandardD5V2', 'VirtualMachineSizeTypesStandardD11V2', 'VirtualMachineSizeTypesStandardD12V2', 'VirtualMachineSizeTypesStandardD13V2', 'VirtualMachineSizeTypesStandardDS1V2', 'VirtualMachineSizeTypesStandardDS2V2', 'VirtualMachineSizeTypesStandardDS3V2', 'VirtualMachineSizeTypesStandardDS4V2', 'VirtualMachineSizeTypesStandardDS5V2', 'VirtualMachineSizeTypesStandardDS11V2', 'VirtualMachineSizeTypesStandardDS12V2', 'VirtualMachineSizeTypesStandardDS13V2', 'VirtualMachineSizeTypesStandardF1', 'VirtualMachineSizeTypesStandardF2', 'VirtualMachineSizeTypesStandardF4', 'VirtualMachineSizeTypesStandardF8', 'VirtualMachineSizeTypesStandardF16', 'VirtualMachineSizeTypesStandardF1s', 'VirtualMachineSizeTypesStandardF2s', 'VirtualMachineSizeTypesStandardF4s', 'VirtualMachineSizeTypesStandardF8s', 'VirtualMachineSizeTypesStandardF16s'
	VirtualMachineSize VirtualMachineSizeTypes `json:"virtualMachineSize,omitempty"`
	// OsProfile - Specifies the operating system settings for the role instance. This value can be updated during the deployment of network function.
	OsProfile *OsProfile `json:"osProfile,omitempty"`
	// UserDataTemplate - The user data template for customers. This is a json schema template describing the format and data type of user data parameters.
	UserDataTemplate interface{} `json:"userDataTemplate,omitempty"`
	// UserDataParameters - The user parameters for customers. The format of user data parameters has to be matched with the provided user data template.
	UserDataParameters interface{} `json:"userDataParameters,omitempty"`
	// NetworkInterfaces - The network interface configurations.
	NetworkInterfaces *[]NetworkInterface `json:"networkInterfaces,omitempty"`
	// StorageProfile - Specifies the storage settings for the virtual machine disks.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`
	// CustomProfile - Specifies the custom settings for the virtual machine.
	CustomProfile *CustomProfile `json:"customProfile,omitempty"`
}

// NetworkFunctionRoleInstanceListResult list of role instances of vendor network function.
type NetworkFunctionRoleInstanceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A list of role instances.
	Value *[]RoleInstance `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// NetworkFunctionRoleInstanceListResultIterator provides access to a complete listing of RoleInstance
// values.
type NetworkFunctionRoleInstanceListResultIterator struct {
	i    int
	page NetworkFunctionRoleInstanceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NetworkFunctionRoleInstanceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkFunctionRoleInstanceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NetworkFunctionRoleInstanceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NetworkFunctionRoleInstanceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NetworkFunctionRoleInstanceListResultIterator) Response() NetworkFunctionRoleInstanceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NetworkFunctionRoleInstanceListResultIterator) Value() RoleInstance {
	if !iter.page.NotDone() {
		return RoleInstance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NetworkFunctionRoleInstanceListResultIterator type.
func NewNetworkFunctionRoleInstanceListResultIterator(page NetworkFunctionRoleInstanceListResultPage) NetworkFunctionRoleInstanceListResultIterator {
	return NetworkFunctionRoleInstanceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nfrilr NetworkFunctionRoleInstanceListResult) IsEmpty() bool {
	return nfrilr.Value == nil || len(*nfrilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (nfrilr NetworkFunctionRoleInstanceListResult) hasNextLink() bool {
	return nfrilr.NextLink != nil && len(*nfrilr.NextLink) != 0
}

// networkFunctionRoleInstanceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nfrilr NetworkFunctionRoleInstanceListResult) networkFunctionRoleInstanceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !nfrilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nfrilr.NextLink)))
}

// NetworkFunctionRoleInstanceListResultPage contains a page of RoleInstance values.
type NetworkFunctionRoleInstanceListResultPage struct {
	fn     func(context.Context, NetworkFunctionRoleInstanceListResult) (NetworkFunctionRoleInstanceListResult, error)
	nfrilr NetworkFunctionRoleInstanceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NetworkFunctionRoleInstanceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkFunctionRoleInstanceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.nfrilr)
		if err != nil {
			return err
		}
		page.nfrilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NetworkFunctionRoleInstanceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NetworkFunctionRoleInstanceListResultPage) NotDone() bool {
	return !page.nfrilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NetworkFunctionRoleInstanceListResultPage) Response() NetworkFunctionRoleInstanceListResult {
	return page.nfrilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NetworkFunctionRoleInstanceListResultPage) Values() []RoleInstance {
	if page.nfrilr.IsEmpty() {
		return nil
	}
	return *page.nfrilr.Value
}

// Creates a new instance of the NetworkFunctionRoleInstanceListResultPage type.
func NewNetworkFunctionRoleInstanceListResultPage(cur NetworkFunctionRoleInstanceListResult, getNextPage func(context.Context, NetworkFunctionRoleInstanceListResult) (NetworkFunctionRoleInstanceListResult, error)) NetworkFunctionRoleInstanceListResultPage {
	return NetworkFunctionRoleInstanceListResultPage{
		fn:     getNextPage,
		nfrilr: cur,
	}
}

// NetworkFunctionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type NetworkFunctionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(NetworkFunctionsClient) (NetworkFunction, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *NetworkFunctionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for NetworkFunctionsCreateOrUpdateFuture.Result.
func (future *NetworkFunctionsCreateOrUpdateFuture) result(client NetworkFunctionsClient) (nf NetworkFunction, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.NetworkFunctionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.NetworkFunctionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if nf.Response.Response, err = future.GetResult(sender); err == nil && nf.Response.Response.StatusCode != http.StatusNoContent {
		nf, err = client.CreateOrUpdateResponder(nf.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hybridnetwork.NetworkFunctionsCreateOrUpdateFuture", "Result", nf.Response.Response, "Failure responding to request")
		}
	}
	return
}

// NetworkFunctionsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type NetworkFunctionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(NetworkFunctionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *NetworkFunctionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for NetworkFunctionsDeleteFuture.Result.
func (future *NetworkFunctionsDeleteFuture) result(client NetworkFunctionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.NetworkFunctionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.NetworkFunctionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// NetworkFunctionSkuDetails the network function sku details.
type NetworkFunctionSkuDetails struct {
	autorest.Response `json:"-"`
	// SkuType - The network function sku type. Possible values include: 'SkuTypeUnknown', 'SkuTypeEvolvedPacketCore', 'SkuTypeSDWAN', 'SkuTypeFirewall'
	SkuType SkuType `json:"skuType,omitempty"`
	// Value - The network function sku role details.
	Value *[]NetworkFunctionSkuRoleDetails `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkFunctionSkuDetails.
func (nfsd NetworkFunctionSkuDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nfsd.SkuType != "" {
		objectMap["skuType"] = nfsd.SkuType
	}
	if nfsd.Value != nil {
		objectMap["value"] = nfsd.Value
	}
	return json.Marshal(objectMap)
}

// NetworkFunctionSkuDetailsIterator provides access to a complete listing of NetworkFunctionSkuRoleDetails
// values.
type NetworkFunctionSkuDetailsIterator struct {
	i    int
	page NetworkFunctionSkuDetailsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NetworkFunctionSkuDetailsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkFunctionSkuDetailsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NetworkFunctionSkuDetailsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NetworkFunctionSkuDetailsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NetworkFunctionSkuDetailsIterator) Response() NetworkFunctionSkuDetails {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NetworkFunctionSkuDetailsIterator) Value() NetworkFunctionSkuRoleDetails {
	if !iter.page.NotDone() {
		return NetworkFunctionSkuRoleDetails{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NetworkFunctionSkuDetailsIterator type.
func NewNetworkFunctionSkuDetailsIterator(page NetworkFunctionSkuDetailsPage) NetworkFunctionSkuDetailsIterator {
	return NetworkFunctionSkuDetailsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nfsd NetworkFunctionSkuDetails) IsEmpty() bool {
	return nfsd.Value == nil || len(*nfsd.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (nfsd NetworkFunctionSkuDetails) hasNextLink() bool {
	return nfsd.NextLink != nil && len(*nfsd.NextLink) != 0
}

// networkFunctionSkuDetailsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nfsd NetworkFunctionSkuDetails) networkFunctionSkuDetailsPreparer(ctx context.Context) (*http.Request, error) {
	if !nfsd.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nfsd.NextLink)))
}

// NetworkFunctionSkuDetailsPage contains a page of NetworkFunctionSkuRoleDetails values.
type NetworkFunctionSkuDetailsPage struct {
	fn   func(context.Context, NetworkFunctionSkuDetails) (NetworkFunctionSkuDetails, error)
	nfsd NetworkFunctionSkuDetails
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NetworkFunctionSkuDetailsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkFunctionSkuDetailsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.nfsd)
		if err != nil {
			return err
		}
		page.nfsd = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NetworkFunctionSkuDetailsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NetworkFunctionSkuDetailsPage) NotDone() bool {
	return !page.nfsd.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NetworkFunctionSkuDetailsPage) Response() NetworkFunctionSkuDetails {
	return page.nfsd
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NetworkFunctionSkuDetailsPage) Values() []NetworkFunctionSkuRoleDetails {
	if page.nfsd.IsEmpty() {
		return nil
	}
	return *page.nfsd.Value
}

// Creates a new instance of the NetworkFunctionSkuDetailsPage type.
func NewNetworkFunctionSkuDetailsPage(cur NetworkFunctionSkuDetails, getNextPage func(context.Context, NetworkFunctionSkuDetails) (NetworkFunctionSkuDetails, error)) NetworkFunctionSkuDetailsPage {
	return NetworkFunctionSkuDetailsPage{
		fn:   getNextPage,
		nfsd: cur,
	}
}

// NetworkFunctionSkuListResult a list of available network function skus.
type NetworkFunctionSkuListResult struct {
	autorest.Response `json:"-"`
	// Value - The network function vendor sku overview properties.
	Value *[]SkuOverview `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkFunctionSkuListResult.
func (nfslr NetworkFunctionSkuListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nfslr.Value != nil {
		objectMap["value"] = nfslr.Value
	}
	return json.Marshal(objectMap)
}

// NetworkFunctionSkuListResultIterator provides access to a complete listing of SkuOverview values.
type NetworkFunctionSkuListResultIterator struct {
	i    int
	page NetworkFunctionSkuListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NetworkFunctionSkuListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkFunctionSkuListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NetworkFunctionSkuListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NetworkFunctionSkuListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NetworkFunctionSkuListResultIterator) Response() NetworkFunctionSkuListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NetworkFunctionSkuListResultIterator) Value() SkuOverview {
	if !iter.page.NotDone() {
		return SkuOverview{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NetworkFunctionSkuListResultIterator type.
func NewNetworkFunctionSkuListResultIterator(page NetworkFunctionSkuListResultPage) NetworkFunctionSkuListResultIterator {
	return NetworkFunctionSkuListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nfslr NetworkFunctionSkuListResult) IsEmpty() bool {
	return nfslr.Value == nil || len(*nfslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (nfslr NetworkFunctionSkuListResult) hasNextLink() bool {
	return nfslr.NextLink != nil && len(*nfslr.NextLink) != 0
}

// networkFunctionSkuListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nfslr NetworkFunctionSkuListResult) networkFunctionSkuListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !nfslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nfslr.NextLink)))
}

// NetworkFunctionSkuListResultPage contains a page of SkuOverview values.
type NetworkFunctionSkuListResultPage struct {
	fn    func(context.Context, NetworkFunctionSkuListResult) (NetworkFunctionSkuListResult, error)
	nfslr NetworkFunctionSkuListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NetworkFunctionSkuListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkFunctionSkuListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.nfslr)
		if err != nil {
			return err
		}
		page.nfslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NetworkFunctionSkuListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NetworkFunctionSkuListResultPage) NotDone() bool {
	return !page.nfslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NetworkFunctionSkuListResultPage) Response() NetworkFunctionSkuListResult {
	return page.nfslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NetworkFunctionSkuListResultPage) Values() []SkuOverview {
	if page.nfslr.IsEmpty() {
		return nil
	}
	return *page.nfslr.Value
}

// Creates a new instance of the NetworkFunctionSkuListResultPage type.
func NewNetworkFunctionSkuListResultPage(cur NetworkFunctionSkuListResult, getNextPage func(context.Context, NetworkFunctionSkuListResult) (NetworkFunctionSkuListResult, error)) NetworkFunctionSkuListResultPage {
	return NetworkFunctionSkuListResultPage{
		fn:    getNextPage,
		nfslr: cur,
	}
}

// NetworkFunctionSkuRoleDetails the network function user configuration.
type NetworkFunctionSkuRoleDetails struct {
	// RoleName - The name of the network function role.
	RoleName *string `json:"roleName,omitempty"`
	// UserDataTemplate - The user data template for customers.
	UserDataTemplate interface{} `json:"userDataTemplate,omitempty"`
	// UserDataParameters - The user parameters for customers.
	UserDataParameters interface{} `json:"userDataParameters,omitempty"`
	// NetworkInterfaces - The network interface configuration.
	NetworkInterfaces *[]NetworkInterface `json:"networkInterfaces,omitempty"`
}

// NetworkFunctionTemplate the network function template.
type NetworkFunctionTemplate struct {
	// NetworkFunctionRoleConfigurations - An array of network function role definitions.
	NetworkFunctionRoleConfigurations *[]NetworkFunctionRoleConfiguration `json:"networkFunctionRoleConfigurations,omitempty"`
}

// NetworkFunctionUserConfiguration the network function user configuration.
type NetworkFunctionUserConfiguration struct {
	// RoleName - The name of the network function role.
	RoleName *string `json:"roleName,omitempty"`
	// UserDataParameters - The user data parameters from the customer.
	UserDataParameters interface{} `json:"userDataParameters,omitempty"`
	// NetworkInterfaces - The network interface configuration.
	NetworkInterfaces *[]NetworkInterface `json:"networkInterfaces,omitempty"`
	// OsProfile - Specifies the operating system settings for the role instance.
	OsProfile *NetworkFunctionUserConfigurationOsProfile `json:"osProfile,omitempty"`
}

// NetworkFunctionUserConfigurationOsProfile specifies the operating system settings for the role instance.
type NetworkFunctionUserConfigurationOsProfile struct {
	// CustomData - Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the virtual machine. The maximum length of the binary array is 65535 bytes. <br><br> **Note: Do not pass any secrets or passwords in customData property** <br><br> This property cannot be updated after the VM is created. <br><br> customData is passed to the VM to be saved as a file. For more information see [Custom Data on Azure VMs](https://azure.microsoft.com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/) <br><br> For using cloud-init for your Linux VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
	CustomData *string `json:"customData,omitempty"`
}

// NetworkFunctionVendor the network function vendor.
type NetworkFunctionVendor struct {
	// VendorDetails - Vendors of Hybrid Network service provider.
	*VendorDetails `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkFunctionVendor.
func (nfv NetworkFunctionVendor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nfv.VendorDetails != nil {
		objectMap["properties"] = nfv.VendorDetails
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NetworkFunctionVendor struct.
func (nfv *NetworkFunctionVendor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vendorDetails VendorDetails
				err = json.Unmarshal(*v, &vendorDetails)
				if err != nil {
					return err
				}
				nfv.VendorDetails = &vendorDetails
			}
		}
	}

	return nil
}

// NetworkFunctionVendorConfiguration network function vendor configuration.
type NetworkFunctionVendorConfiguration struct {
	// RoleName - The name of the vendor network function role.
	RoleName *string `json:"roleName,omitempty"`
	// OsProfile - Specifies the operating system settings for the role instance.
	OsProfile *OsProfile `json:"osProfile,omitempty"`
	// UserDataParameters - READ-ONLY; The user parameters from the customer.
	UserDataParameters interface{} `json:"userDataParameters,omitempty"`
	// NetworkInterfaces - The network interface configurations.
	NetworkInterfaces *[]NetworkInterface `json:"networkInterfaces,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkFunctionVendorConfiguration.
func (nfvc NetworkFunctionVendorConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nfvc.RoleName != nil {
		objectMap["roleName"] = nfvc.RoleName
	}
	if nfvc.OsProfile != nil {
		objectMap["osProfile"] = nfvc.OsProfile
	}
	if nfvc.NetworkInterfaces != nil {
		objectMap["networkInterfaces"] = nfvc.NetworkInterfaces
	}
	return json.Marshal(objectMap)
}

// NetworkFunctionVendorListResult the network function vendor list result.
type NetworkFunctionVendorListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of available network function vendors and skus.
	Value *[]NetworkFunctionVendor `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkFunctionVendorListResult.
func (nfvlr NetworkFunctionVendorListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nfvlr.Value != nil {
		objectMap["value"] = nfvlr.Value
	}
	return json.Marshal(objectMap)
}

// NetworkFunctionVendorListResultIterator provides access to a complete listing of NetworkFunctionVendor
// values.
type NetworkFunctionVendorListResultIterator struct {
	i    int
	page NetworkFunctionVendorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NetworkFunctionVendorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkFunctionVendorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NetworkFunctionVendorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NetworkFunctionVendorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NetworkFunctionVendorListResultIterator) Response() NetworkFunctionVendorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NetworkFunctionVendorListResultIterator) Value() NetworkFunctionVendor {
	if !iter.page.NotDone() {
		return NetworkFunctionVendor{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NetworkFunctionVendorListResultIterator type.
func NewNetworkFunctionVendorListResultIterator(page NetworkFunctionVendorListResultPage) NetworkFunctionVendorListResultIterator {
	return NetworkFunctionVendorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nfvlr NetworkFunctionVendorListResult) IsEmpty() bool {
	return nfvlr.Value == nil || len(*nfvlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (nfvlr NetworkFunctionVendorListResult) hasNextLink() bool {
	return nfvlr.NextLink != nil && len(*nfvlr.NextLink) != 0
}

// networkFunctionVendorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nfvlr NetworkFunctionVendorListResult) networkFunctionVendorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !nfvlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nfvlr.NextLink)))
}

// NetworkFunctionVendorListResultPage contains a page of NetworkFunctionVendor values.
type NetworkFunctionVendorListResultPage struct {
	fn    func(context.Context, NetworkFunctionVendorListResult) (NetworkFunctionVendorListResult, error)
	nfvlr NetworkFunctionVendorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NetworkFunctionVendorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkFunctionVendorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.nfvlr)
		if err != nil {
			return err
		}
		page.nfvlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NetworkFunctionVendorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NetworkFunctionVendorListResultPage) NotDone() bool {
	return !page.nfvlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NetworkFunctionVendorListResultPage) Response() NetworkFunctionVendorListResult {
	return page.nfvlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NetworkFunctionVendorListResultPage) Values() []NetworkFunctionVendor {
	if page.nfvlr.IsEmpty() {
		return nil
	}
	return *page.nfvlr.Value
}

// Creates a new instance of the NetworkFunctionVendorListResultPage type.
func NewNetworkFunctionVendorListResultPage(cur NetworkFunctionVendorListResult, getNextPage func(context.Context, NetworkFunctionVendorListResult) (NetworkFunctionVendorListResult, error)) NetworkFunctionVendorListResultPage {
	return NetworkFunctionVendorListResultPage{
		fn:    getNextPage,
		nfvlr: cur,
	}
}

// NetworkInterface network interface properties.
type NetworkInterface struct {
	// NetworkInterfaceName - The name of the network interface.
	NetworkInterfaceName *string `json:"networkInterfaceName,omitempty"`
	// MacAddress - The MAC address of the network interface.
	MacAddress *string `json:"macAddress,omitempty"`
	// IPConfigurations - A list of IP configurations of the network interface.
	IPConfigurations *[]NetworkInterfaceIPConfiguration `json:"ipConfigurations,omitempty"`
	// VMSwitchType - The type of the VM switch. Possible values include: 'VMSwitchTypeUnknown', 'VMSwitchTypeManagement', 'VMSwitchTypeWan', 'VMSwitchTypeLan'
	VMSwitchType VMSwitchType `json:"vmSwitchType,omitempty"`
}

// NetworkInterfaceIPConfiguration network interface IP configuration properties.
type NetworkInterfaceIPConfiguration struct {
	// IPAllocationMethod - IP address allocation method. Possible values include: 'IPAllocationMethodUnknown', 'IPAllocationMethodStatic', 'IPAllocationMethodDynamic'
	IPAllocationMethod IPAllocationMethod `json:"ipAllocationMethod,omitempty"`
	// IPAddress - The value of the IP address.
	IPAddress *string `json:"ipAddress,omitempty"`
	// Subnet - The value of the subnet.
	Subnet *string `json:"subnet,omitempty"`
	// Gateway - The value of the gateway.
	Gateway *string `json:"gateway,omitempty"`
	// IPVersion - IP address version. Possible values include: 'IPVersionUnknown', 'IPVersionIPv4'
	IPVersion IPVersion `json:"ipVersion,omitempty"`
	// DNSServers - The list of DNS servers IP addresses.
	DNSServers *[]string `json:"dnsServers,omitempty"`
}

// Operation object that describes a single Microsoft.HybridNetwork operation.
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.HybridNetwork.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Registration definition, registration assignment, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationList a list of the operations.
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; A list of Microsoft.HybridNetwork operations.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(cur OperationList, getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// OsDisk specifies information about the operating system disk used by the virtual machine. <br><br> For
// more information about disks, see [About disks and VHDs for Azure virtual
// machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
type OsDisk struct {
	// OsType - The OS type. Possible values include: 'OperatingSystemTypesUnknown', 'OperatingSystemTypesWindows', 'OperatingSystemTypesLinux'
	OsType OperatingSystemTypes `json:"osType,omitempty"`
	// Name - The VHD name.
	Name *string `json:"name,omitempty"`
	// Vhd - The virtual hard disk.
	Vhd *VirtualHardDisk `json:"vhd,omitempty"`
	// DiskSizeGB - Specifies the size of os disk in gigabytes. This is the fully expanded disk size needed of the VHD image on the ASE. This disk size should be greater than the size of the VHD provided in vhdUri.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
}

// OsProfile specifies the operating system settings for the role instance.
type OsProfile struct {
	// AdminUsername - Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
	AdminUsername *string `json:"adminUsername,omitempty"`
	// LinuxConfiguration - Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
	LinuxConfiguration *LinuxConfiguration `json:"linuxConfiguration,omitempty"`
	// CustomData - Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the virtual machine. The maximum length of the binary array is 65535 bytes. <br><br> **Note: Do not pass any secrets or passwords in customData property** <br><br> This property cannot be updated after the VM is created. <br><br> customData is passed to the VM to be saved as a file. For more information see [Custom Data on Azure VMs](https://azure.microsoft.com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/) <br><br> For using cloud-init for your Linux VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
	CustomData *string `json:"customData,omitempty"`
	// CustomDataRequired - Indicates if custom data is required to deploy this role.
	CustomDataRequired *bool `json:"customDataRequired,omitempty"`
}

// PreviewSubscription customer subscription which can use a sku.
type PreviewSubscription struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; The preview subscription ID.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ARM ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// PreviewSubscriptionsList a list of customer subscriptions which can use a sku.
type PreviewSubscriptionsList struct {
	autorest.Response `json:"-"`
	// Value - A list of preview subscriptions.
	Value *[]PreviewSubscription `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PreviewSubscriptionsList.
func (psl PreviewSubscriptionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if psl.Value != nil {
		objectMap["value"] = psl.Value
	}
	return json.Marshal(objectMap)
}

// PreviewSubscriptionsListIterator provides access to a complete listing of PreviewSubscription values.
type PreviewSubscriptionsListIterator struct {
	i    int
	page PreviewSubscriptionsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PreviewSubscriptionsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PreviewSubscriptionsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PreviewSubscriptionsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PreviewSubscriptionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PreviewSubscriptionsListIterator) Response() PreviewSubscriptionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PreviewSubscriptionsListIterator) Value() PreviewSubscription {
	if !iter.page.NotDone() {
		return PreviewSubscription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PreviewSubscriptionsListIterator type.
func NewPreviewSubscriptionsListIterator(page PreviewSubscriptionsListPage) PreviewSubscriptionsListIterator {
	return PreviewSubscriptionsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (psl PreviewSubscriptionsList) IsEmpty() bool {
	return psl.Value == nil || len(*psl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (psl PreviewSubscriptionsList) hasNextLink() bool {
	return psl.NextLink != nil && len(*psl.NextLink) != 0
}

// previewSubscriptionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (psl PreviewSubscriptionsList) previewSubscriptionsListPreparer(ctx context.Context) (*http.Request, error) {
	if !psl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(psl.NextLink)))
}

// PreviewSubscriptionsListPage contains a page of PreviewSubscription values.
type PreviewSubscriptionsListPage struct {
	fn  func(context.Context, PreviewSubscriptionsList) (PreviewSubscriptionsList, error)
	psl PreviewSubscriptionsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PreviewSubscriptionsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PreviewSubscriptionsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.psl)
		if err != nil {
			return err
		}
		page.psl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PreviewSubscriptionsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PreviewSubscriptionsListPage) NotDone() bool {
	return !page.psl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PreviewSubscriptionsListPage) Response() PreviewSubscriptionsList {
	return page.psl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PreviewSubscriptionsListPage) Values() []PreviewSubscription {
	if page.psl.IsEmpty() {
		return nil
	}
	return *page.psl.Value
}

// Creates a new instance of the PreviewSubscriptionsListPage type.
func NewPreviewSubscriptionsListPage(cur PreviewSubscriptionsList, getNextPage func(context.Context, PreviewSubscriptionsList) (PreviewSubscriptionsList, error)) PreviewSubscriptionsListPage {
	return PreviewSubscriptionsListPage{
		fn:  getNextPage,
		psl: cur,
	}
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// RoleInstance the role instance sub resource.
type RoleInstance struct {
	autorest.Response `json:"-"`
	// Name - The role instance name.
	Name *string `json:"name,omitempty"`
	// ID - The ARM ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
	// RoleInstanceProperties - The role instance properties.
	*RoleInstanceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleInstance.
func (ri RoleInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ri.Name != nil {
		objectMap["name"] = ri.Name
	}
	if ri.ID != nil {
		objectMap["id"] = ri.ID
	}
	if ri.Type != nil {
		objectMap["type"] = ri.Type
	}
	if ri.RoleInstanceProperties != nil {
		objectMap["properties"] = ri.RoleInstanceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleInstance struct.
func (ri *RoleInstance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ri.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ri.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ri.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var roleInstanceProperties RoleInstanceProperties
				err = json.Unmarshal(*v, &roleInstanceProperties)
				if err != nil {
					return err
				}
				ri.RoleInstanceProperties = &roleInstanceProperties
			}
		}
	}

	return nil
}

// RoleInstanceProperties the role instance properties of the network function.
type RoleInstanceProperties struct {
	// OperationalState - The operational state of the role instance. Possible values include: 'OperationalStateUnknown', 'OperationalStateStopped', 'OperationalStateRunning', 'OperationalStateStopping', 'OperationalStateStarting'
	OperationalState OperationalState `json:"operationalState,omitempty"`
}

// RoleInstancesRestartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RoleInstancesRestartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RoleInstancesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RoleInstancesRestartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RoleInstancesRestartFuture.Result.
func (future *RoleInstancesRestartFuture) result(client RoleInstancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.RoleInstancesRestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.RoleInstancesRestartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RoleInstancesStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RoleInstancesStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RoleInstancesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RoleInstancesStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RoleInstancesStartFuture.Result.
func (future *RoleInstancesStartFuture) result(client RoleInstancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.RoleInstancesStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.RoleInstancesStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RoleInstancesStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RoleInstancesStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RoleInstancesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RoleInstancesStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RoleInstancesStopFuture.Result.
func (future *RoleInstancesStopFuture) result(client RoleInstancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.RoleInstancesStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.RoleInstancesStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SkuOverview the network function sku overview.
type SkuOverview struct {
	// SkuName - The vendor sku name.
	SkuName *string `json:"skuName,omitempty"`
	// SkuType - The vendor sku type. Possible values include: 'SkuTypeUnknown', 'SkuTypeEvolvedPacketCore', 'SkuTypeSDWAN', 'SkuTypeFirewall'
	SkuType SkuType `json:"skuType,omitempty"`
}

// SSHConfiguration SSH configuration for Linux based VMs running on Azure
type SSHConfiguration struct {
	// PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
	PublicKeys *[]SSHPublicKey `json:"publicKeys,omitempty"`
}

// SSHPublicKey contains information about SSH certificate public key and the path on the Linux VM where
// the public key is placed.
type SSHPublicKey struct {
	// Path - Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
	Path *string `json:"path,omitempty"`
	// KeyData - SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
	KeyData *string `json:"keyData,omitempty"`
}

// StorageProfile specifies the storage settings for the virtual machine disks.
type StorageProfile struct {
	// ImageReference - The image reference properties.
	ImageReference *ImageReference `json:"imageReference,omitempty"`
	// OsDisk - Specifies information about the operating system disk used by the virtual machine.
	OsDisk *OsDisk `json:"osDisk,omitempty"`
	// DataDisks - Specifies the parameters that are used to add a data disk to a virtual machine.
	DataDisks *[]DataDisk `json:"dataDisks,omitempty"`
}

// SubResource reference to another sub resource.
type SubResource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// TagsObject tags object for patch operations.
type TagsObject struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsObject.
func (toVar TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if toVar.Tags != nil {
		objectMap["tags"] = toVar.Tags
	}
	return json.Marshal(objectMap)
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// Vendor vendor resource.
type Vendor struct {
	autorest.Response `json:"-"`
	// VendorPropertiesFormat - Vendor properties.
	*VendorPropertiesFormat `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Vendor.
func (vVar Vendor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vVar.VendorPropertiesFormat != nil {
		objectMap["properties"] = vVar.VendorPropertiesFormat
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Vendor struct.
func (vVar *Vendor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vendorPropertiesFormat VendorPropertiesFormat
				err = json.Unmarshal(*v, &vendorPropertiesFormat)
				if err != nil {
					return err
				}
				vVar.VendorPropertiesFormat = &vendorPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vVar.Type = &typeVar
			}
		}
	}

	return nil
}

// VendorDetails the network function vendor details.
type VendorDetails struct {
	// VendorName - The network function vendor name.
	VendorName *string `json:"vendorName,omitempty"`
	// SkuList - The network function sku list.
	SkuList *[]SkuOverview `json:"skuList,omitempty"`
}

// VendorListResult response for vendors API service call.
type VendorListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of vendors.
	Value *[]Vendor `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for VendorListResult.
func (vlr VendorListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vlr.Value != nil {
		objectMap["value"] = vlr.Value
	}
	return json.Marshal(objectMap)
}

// VendorListResultIterator provides access to a complete listing of Vendor values.
type VendorListResultIterator struct {
	i    int
	page VendorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VendorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VendorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VendorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VendorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VendorListResultIterator) Response() VendorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VendorListResultIterator) Value() Vendor {
	if !iter.page.NotDone() {
		return Vendor{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VendorListResultIterator type.
func NewVendorListResultIterator(page VendorListResultPage) VendorListResultIterator {
	return VendorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vlr VendorListResult) IsEmpty() bool {
	return vlr.Value == nil || len(*vlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vlr VendorListResult) hasNextLink() bool {
	return vlr.NextLink != nil && len(*vlr.NextLink) != 0
}

// vendorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vlr VendorListResult) vendorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vlr.NextLink)))
}

// VendorListResultPage contains a page of Vendor values.
type VendorListResultPage struct {
	fn  func(context.Context, VendorListResult) (VendorListResult, error)
	vlr VendorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VendorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VendorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vlr)
		if err != nil {
			return err
		}
		page.vlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VendorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VendorListResultPage) NotDone() bool {
	return !page.vlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VendorListResultPage) Response() VendorListResult {
	return page.vlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VendorListResultPage) Values() []Vendor {
	if page.vlr.IsEmpty() {
		return nil
	}
	return *page.vlr.Value
}

// Creates a new instance of the VendorListResultPage type.
func NewVendorListResultPage(cur VendorListResult, getNextPage func(context.Context, VendorListResult) (VendorListResult, error)) VendorListResultPage {
	return VendorListResultPage{
		fn:  getNextPage,
		vlr: cur,
	}
}

// VendorNetworkFunction vendor network function sub resource.
type VendorNetworkFunction struct {
	autorest.Response `json:"-"`
	// VendorNetworkFunctionPropertiesFormat - Network function details.
	*VendorNetworkFunctionPropertiesFormat `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VendorNetworkFunction.
func (vnf VendorNetworkFunction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnf.VendorNetworkFunctionPropertiesFormat != nil {
		objectMap["properties"] = vnf.VendorNetworkFunctionPropertiesFormat
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VendorNetworkFunction struct.
func (vnf *VendorNetworkFunction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vendorNetworkFunctionPropertiesFormat VendorNetworkFunctionPropertiesFormat
				err = json.Unmarshal(*v, &vendorNetworkFunctionPropertiesFormat)
				if err != nil {
					return err
				}
				vnf.VendorNetworkFunctionPropertiesFormat = &vendorNetworkFunctionPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vnf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vnf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vnf.Type = &typeVar
			}
		}
	}

	return nil
}

// VendorNetworkFunctionListResult response for vendors API service call.
type VendorNetworkFunctionListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of vendor network functions.
	Value *[]VendorNetworkFunction `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for VendorNetworkFunctionListResult.
func (vnflr VendorNetworkFunctionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnflr.Value != nil {
		objectMap["value"] = vnflr.Value
	}
	return json.Marshal(objectMap)
}

// VendorNetworkFunctionListResultIterator provides access to a complete listing of VendorNetworkFunction
// values.
type VendorNetworkFunctionListResultIterator struct {
	i    int
	page VendorNetworkFunctionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VendorNetworkFunctionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VendorNetworkFunctionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VendorNetworkFunctionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VendorNetworkFunctionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VendorNetworkFunctionListResultIterator) Response() VendorNetworkFunctionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VendorNetworkFunctionListResultIterator) Value() VendorNetworkFunction {
	if !iter.page.NotDone() {
		return VendorNetworkFunction{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VendorNetworkFunctionListResultIterator type.
func NewVendorNetworkFunctionListResultIterator(page VendorNetworkFunctionListResultPage) VendorNetworkFunctionListResultIterator {
	return VendorNetworkFunctionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnflr VendorNetworkFunctionListResult) IsEmpty() bool {
	return vnflr.Value == nil || len(*vnflr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vnflr VendorNetworkFunctionListResult) hasNextLink() bool {
	return vnflr.NextLink != nil && len(*vnflr.NextLink) != 0
}

// vendorNetworkFunctionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnflr VendorNetworkFunctionListResult) vendorNetworkFunctionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vnflr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnflr.NextLink)))
}

// VendorNetworkFunctionListResultPage contains a page of VendorNetworkFunction values.
type VendorNetworkFunctionListResultPage struct {
	fn    func(context.Context, VendorNetworkFunctionListResult) (VendorNetworkFunctionListResult, error)
	vnflr VendorNetworkFunctionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VendorNetworkFunctionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VendorNetworkFunctionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vnflr)
		if err != nil {
			return err
		}
		page.vnflr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VendorNetworkFunctionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VendorNetworkFunctionListResultPage) NotDone() bool {
	return !page.vnflr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VendorNetworkFunctionListResultPage) Response() VendorNetworkFunctionListResult {
	return page.vnflr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VendorNetworkFunctionListResultPage) Values() []VendorNetworkFunction {
	if page.vnflr.IsEmpty() {
		return nil
	}
	return *page.vnflr.Value
}

// Creates a new instance of the VendorNetworkFunctionListResultPage type.
func NewVendorNetworkFunctionListResultPage(cur VendorNetworkFunctionListResult, getNextPage func(context.Context, VendorNetworkFunctionListResult) (VendorNetworkFunctionListResult, error)) VendorNetworkFunctionListResultPage {
	return VendorNetworkFunctionListResultPage{
		fn:    getNextPage,
		vnflr: cur,
	}
}

// VendorNetworkFunctionPropertiesFormat vendor network function properties.
type VendorNetworkFunctionPropertiesFormat struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the vendor network function sub resource. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateSucceeded', 'ProvisioningStateAccepted', 'ProvisioningStateDeleting', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeleted'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// VendorProvisioningState - The vendor controlled provisioning state of the vendor network function. Possible values include: 'VendorProvisioningStateUnknown', 'VendorProvisioningStateNotProvisioned', 'VendorProvisioningStateProvisioning', 'VendorProvisioningStateProvisioned', 'VendorProvisioningStateDeprovisioned', 'VendorProvisioningStateUserDataValidationFailed'
	VendorProvisioningState VendorProvisioningState `json:"vendorProvisioningState,omitempty"`
	// SkuName - READ-ONLY; The name of the sku.
	SkuName *string `json:"skuName,omitempty"`
	// SkuType - READ-ONLY; The sku type. Possible values include: 'SkuTypeUnknown', 'SkuTypeEvolvedPacketCore', 'SkuTypeSDWAN', 'SkuTypeFirewall'
	SkuType SkuType `json:"skuType,omitempty"`
	// NetworkFunctionVendorConfigurations - An array of network function vendor configurations.
	NetworkFunctionVendorConfigurations *[]NetworkFunctionVendorConfiguration `json:"networkFunctionVendorConfigurations,omitempty"`
}

// MarshalJSON is the custom marshaler for VendorNetworkFunctionPropertiesFormat.
func (vnfpf VendorNetworkFunctionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnfpf.VendorProvisioningState != "" {
		objectMap["vendorProvisioningState"] = vnfpf.VendorProvisioningState
	}
	if vnfpf.NetworkFunctionVendorConfigurations != nil {
		objectMap["networkFunctionVendorConfigurations"] = vnfpf.NetworkFunctionVendorConfigurations
	}
	return json.Marshal(objectMap)
}

// VendorNetworkFunctionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VendorNetworkFunctionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VendorNetworkFunctionsClient) (VendorNetworkFunction, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VendorNetworkFunctionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VendorNetworkFunctionsCreateOrUpdateFuture.Result.
func (future *VendorNetworkFunctionsCreateOrUpdateFuture) result(client VendorNetworkFunctionsClient) (vnf VendorNetworkFunction, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorNetworkFunctionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.VendorNetworkFunctionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vnf.Response.Response, err = future.GetResult(sender); err == nil && vnf.Response.Response.StatusCode != http.StatusNoContent {
		vnf, err = client.CreateOrUpdateResponder(vnf.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hybridnetwork.VendorNetworkFunctionsCreateOrUpdateFuture", "Result", vnf.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VendorPropertiesFormat vendor properties.
type VendorPropertiesFormat struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the vendor resource. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateSucceeded', 'ProvisioningStateAccepted', 'ProvisioningStateDeleting', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeleted'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Skus - READ-ONLY; A list of IDs of the vendor skus offered by the vendor.
	Skus *[]SubResource `json:"skus,omitempty"`
}

// VendorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VendorsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VendorsClient) (Vendor, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VendorsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VendorsCreateOrUpdateFuture.Result.
func (future *VendorsCreateOrUpdateFuture) result(client VendorsClient) (vVar Vendor, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.VendorsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vVar.Response.Response, err = future.GetResult(sender); err == nil && vVar.Response.Response.StatusCode != http.StatusNoContent {
		vVar, err = client.CreateOrUpdateResponder(vVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hybridnetwork.VendorsCreateOrUpdateFuture", "Result", vVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VendorsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VendorsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VendorsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VendorsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VendorsDeleteFuture.Result.
func (future *VendorsDeleteFuture) result(client VendorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.VendorsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VendorSku sku sub resource.
type VendorSku struct {
	autorest.Response `json:"-"`
	// VendorSkuPropertiesFormat - Vendor sku details.
	*VendorSkuPropertiesFormat `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VendorSku.
func (vs VendorSku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vs.VendorSkuPropertiesFormat != nil {
		objectMap["properties"] = vs.VendorSkuPropertiesFormat
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VendorSku struct.
func (vs *VendorSku) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vendorSkuPropertiesFormat VendorSkuPropertiesFormat
				err = json.Unmarshal(*v, &vendorSkuPropertiesFormat)
				if err != nil {
					return err
				}
				vs.VendorSkuPropertiesFormat = &vendorSkuPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vs.Type = &typeVar
			}
		}
	}

	return nil
}

// VendorSkuListResult response for list vendor sku API service call.
type VendorSkuListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of vendor skus offered by the vendor.
	Value *[]VendorSku `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for VendorSkuListResult.
func (vslr VendorSkuListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vslr.Value != nil {
		objectMap["value"] = vslr.Value
	}
	return json.Marshal(objectMap)
}

// VendorSkuListResultIterator provides access to a complete listing of VendorSku values.
type VendorSkuListResultIterator struct {
	i    int
	page VendorSkuListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VendorSkuListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VendorSkuListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VendorSkuListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VendorSkuListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VendorSkuListResultIterator) Response() VendorSkuListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VendorSkuListResultIterator) Value() VendorSku {
	if !iter.page.NotDone() {
		return VendorSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VendorSkuListResultIterator type.
func NewVendorSkuListResultIterator(page VendorSkuListResultPage) VendorSkuListResultIterator {
	return VendorSkuListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vslr VendorSkuListResult) IsEmpty() bool {
	return vslr.Value == nil || len(*vslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vslr VendorSkuListResult) hasNextLink() bool {
	return vslr.NextLink != nil && len(*vslr.NextLink) != 0
}

// vendorSkuListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vslr VendorSkuListResult) vendorSkuListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vslr.NextLink)))
}

// VendorSkuListResultPage contains a page of VendorSku values.
type VendorSkuListResultPage struct {
	fn   func(context.Context, VendorSkuListResult) (VendorSkuListResult, error)
	vslr VendorSkuListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VendorSkuListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VendorSkuListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vslr)
		if err != nil {
			return err
		}
		page.vslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VendorSkuListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VendorSkuListResultPage) NotDone() bool {
	return !page.vslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VendorSkuListResultPage) Response() VendorSkuListResult {
	return page.vslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VendorSkuListResultPage) Values() []VendorSku {
	if page.vslr.IsEmpty() {
		return nil
	}
	return *page.vslr.Value
}

// Creates a new instance of the VendorSkuListResultPage type.
func NewVendorSkuListResultPage(cur VendorSkuListResult, getNextPage func(context.Context, VendorSkuListResult) (VendorSkuListResult, error)) VendorSkuListResultPage {
	return VendorSkuListResultPage{
		fn:   getNextPage,
		vslr: cur,
	}
}

// VendorSkuPreviewCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VendorSkuPreviewCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VendorSkuPreviewClient) (PreviewSubscription, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VendorSkuPreviewCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VendorSkuPreviewCreateOrUpdateFuture.Result.
func (future *VendorSkuPreviewCreateOrUpdateFuture) result(client VendorSkuPreviewClient) (ps PreviewSubscription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorSkuPreviewCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.VendorSkuPreviewCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ps.Response.Response, err = future.GetResult(sender); err == nil && ps.Response.Response.StatusCode != http.StatusNoContent {
		ps, err = client.CreateOrUpdateResponder(ps.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hybridnetwork.VendorSkuPreviewCreateOrUpdateFuture", "Result", ps.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VendorSkuPreviewDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VendorSkuPreviewDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VendorSkuPreviewClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VendorSkuPreviewDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VendorSkuPreviewDeleteFuture.Result.
func (future *VendorSkuPreviewDeleteFuture) result(client VendorSkuPreviewClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorSkuPreviewDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.VendorSkuPreviewDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VendorSkuPropertiesFormat sku properties
type VendorSkuPropertiesFormat struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the vendor sku sub resource. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateSucceeded', 'ProvisioningStateAccepted', 'ProvisioningStateDeleting', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeleted'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// SkuType - The sku type. Possible values include: 'SkuTypeUnknown', 'SkuTypeEvolvedPacketCore', 'SkuTypeSDWAN', 'SkuTypeFirewall'
	SkuType SkuType `json:"skuType,omitempty"`
	// DeploymentMode - The sku deployment mode. Possible values include: 'SkuDeploymentModeUnknown', 'SkuDeploymentModeAzure', 'SkuDeploymentModePrivateEdgeZone'
	DeploymentMode SkuDeploymentMode `json:"deploymentMode,omitempty"`
	// Preview - Indicates if the vendor sku is in preview mode.
	Preview *bool `json:"preview,omitempty"`
	// ManagedApplicationParameters - The parameters for the managed application to be supplied by the vendor.
	ManagedApplicationParameters interface{} `json:"managedApplicationParameters,omitempty"`
	// ManagedApplicationTemplate - The template for the managed application deployment.
	ManagedApplicationTemplate interface{} `json:"managedApplicationTemplate,omitempty"`
	// NetworkFunctionTemplate - The template definition of the network function.
	NetworkFunctionTemplate *NetworkFunctionTemplate `json:"networkFunctionTemplate,omitempty"`
}

// MarshalJSON is the custom marshaler for VendorSkuPropertiesFormat.
func (vspf VendorSkuPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vspf.SkuType != "" {
		objectMap["skuType"] = vspf.SkuType
	}
	if vspf.DeploymentMode != "" {
		objectMap["deploymentMode"] = vspf.DeploymentMode
	}
	if vspf.Preview != nil {
		objectMap["preview"] = vspf.Preview
	}
	if vspf.ManagedApplicationParameters != nil {
		objectMap["managedApplicationParameters"] = vspf.ManagedApplicationParameters
	}
	if vspf.ManagedApplicationTemplate != nil {
		objectMap["managedApplicationTemplate"] = vspf.ManagedApplicationTemplate
	}
	if vspf.NetworkFunctionTemplate != nil {
		objectMap["networkFunctionTemplate"] = vspf.NetworkFunctionTemplate
	}
	return json.Marshal(objectMap)
}

// VendorSkusCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VendorSkusCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VendorSkusClient) (VendorSku, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VendorSkusCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VendorSkusCreateOrUpdateFuture.Result.
func (future *VendorSkusCreateOrUpdateFuture) result(client VendorSkusClient) (vs VendorSku, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorSkusCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.VendorSkusCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vs.Response.Response, err = future.GetResult(sender); err == nil && vs.Response.Response.StatusCode != http.StatusNoContent {
		vs, err = client.CreateOrUpdateResponder(vs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hybridnetwork.VendorSkusCreateOrUpdateFuture", "Result", vs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VendorSkusDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VendorSkusDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VendorSkusClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VendorSkusDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VendorSkusDeleteFuture.Result.
func (future *VendorSkusDeleteFuture) result(client VendorSkusClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybridnetwork.VendorSkusDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybridnetwork.VendorSkusDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualHardDisk describes the uri of a disk.
type VirtualHardDisk struct {
	// URI - Specifies the virtual hard disk's uri.
	URI *string `json:"uri,omitempty"`
}
