package eventgrid

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/eventgrid/mgmt/2018-05-01-preview/eventgrid"

// BasicDeadLetterDestination information about the dead letter destination for an event subscription. To configure a
// deadletter destination, do not directly instantiate an object of this class. Instead, instantiate an object of a
// derived class. Currently, StorageBlobDeadLetterDestination is the only class that derives from this class.
type BasicDeadLetterDestination interface {
	AsStorageBlobDeadLetterDestination() (*StorageBlobDeadLetterDestination, bool)
	AsDeadLetterDestination() (*DeadLetterDestination, bool)
}

// DeadLetterDestination information about the dead letter destination for an event subscription. To configure
// a deadletter destination, do not directly instantiate an object of this class. Instead, instantiate an
// object of a derived class. Currently, StorageBlobDeadLetterDestination is the only class that derives from
// this class.
type DeadLetterDestination struct {
	// EndpointType - Possible values include: 'EndpointTypeDeadLetterDestination', 'EndpointTypeStorageBlob'
	EndpointType EndpointTypeBasicDeadLetterDestination `json:"endpointType,omitempty"`
}

func unmarshalBasicDeadLetterDestination(body []byte) (BasicDeadLetterDestination, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["endpointType"] {
	case string(EndpointTypeStorageBlob):
		var sbdld StorageBlobDeadLetterDestination
		err := json.Unmarshal(body, &sbdld)
		return sbdld, err
	default:
		var dld DeadLetterDestination
		err := json.Unmarshal(body, &dld)
		return dld, err
	}
}
func unmarshalBasicDeadLetterDestinationArray(body []byte) ([]BasicDeadLetterDestination, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dldArray := make([]BasicDeadLetterDestination, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dld, err := unmarshalBasicDeadLetterDestination(*rawMessage)
		if err != nil {
			return nil, err
		}
		dldArray[index] = dld
	}
	return dldArray, nil
}

// MarshalJSON is the custom marshaler for DeadLetterDestination.
func (dld DeadLetterDestination) MarshalJSON() ([]byte, error) {
	dld.EndpointType = EndpointTypeDeadLetterDestination
	objectMap := make(map[string]interface{})
	if dld.EndpointType != "" {
		objectMap["endpointType"] = dld.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsStorageBlobDeadLetterDestination is the BasicDeadLetterDestination implementation for DeadLetterDestination.
func (dld DeadLetterDestination) AsStorageBlobDeadLetterDestination() (*StorageBlobDeadLetterDestination, bool) {
	return nil, false
}

// AsDeadLetterDestination is the BasicDeadLetterDestination implementation for DeadLetterDestination.
func (dld DeadLetterDestination) AsDeadLetterDestination() (*DeadLetterDestination, bool) {
	return &dld, true
}

// AsBasicDeadLetterDestination is the BasicDeadLetterDestination implementation for DeadLetterDestination.
func (dld DeadLetterDestination) AsBasicDeadLetterDestination() (BasicDeadLetterDestination, bool) {
	return &dld, true
}

// EventHubEventSubscriptionDestination information about the event hub destination for an event
// subscription
type EventHubEventSubscriptionDestination struct {
	// EventHubEventSubscriptionDestinationProperties - Event Hub Properties of the event subscription destination
	*EventHubEventSubscriptionDestinationProperties `json:"properties,omitempty"`
	// EndpointType - Possible values include: 'EndpointTypeEventSubscriptionDestination', 'EndpointTypeWebHook', 'EndpointTypeEventHub', 'EndpointTypeStorageQueue', 'EndpointTypeHybridConnection'
	EndpointType EndpointType `json:"endpointType,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	ehesd.EndpointType = EndpointTypeEventHub
	objectMap := make(map[string]interface{})
	if ehesd.EventHubEventSubscriptionDestinationProperties != nil {
		objectMap["properties"] = ehesd.EventHubEventSubscriptionDestinationProperties
	}
	if ehesd.EndpointType != "" {
		objectMap["endpointType"] = ehesd.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsWebHookEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventHubEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool) {
	return &ehesd, true
}

// AsStorageQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) AsStorageQueueEventSubscriptionDestination() (*StorageQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsHybridConnectionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) AsHybridConnectionEventSubscriptionDestination() (*HybridConnectionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) AsEventSubscriptionDestination() (*EventSubscriptionDestination, bool) {
	return nil, false
}

// AsBasicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) AsBasicEventSubscriptionDestination() (BasicEventSubscriptionDestination, bool) {
	return &ehesd, true
}

// UnmarshalJSON is the custom unmarshaler for EventHubEventSubscriptionDestination struct.
func (ehesd *EventHubEventSubscriptionDestination) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventHubEventSubscriptionDestinationProperties EventHubEventSubscriptionDestinationProperties
				err = json.Unmarshal(*v, &eventHubEventSubscriptionDestinationProperties)
				if err != nil {
					return err
				}
				ehesd.EventHubEventSubscriptionDestinationProperties = &eventHubEventSubscriptionDestinationProperties
			}
		case "endpointType":
			if v != nil {
				var endpointType EndpointType
				err = json.Unmarshal(*v, &endpointType)
				if err != nil {
					return err
				}
				ehesd.EndpointType = endpointType
			}
		}
	}

	return nil
}

// EventHubEventSubscriptionDestinationProperties the properties for a event hub destination.
type EventHubEventSubscriptionDestinationProperties struct {
	// ResourceID - The Azure Resource Id that represents the endpoint of an Event Hub destination of an event subscription.
	ResourceID *string `json:"resourceId,omitempty"`
}

// EventSubscription event Subscription
type EventSubscription struct {
	autorest.Response `json:"-"`
	// EventSubscriptionProperties - Properties of the event subscription
	*EventSubscriptionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventSubscription.
func (es EventSubscription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if es.EventSubscriptionProperties != nil {
		objectMap["properties"] = es.EventSubscriptionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EventSubscription struct.
func (es *EventSubscription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventSubscriptionProperties EventSubscriptionProperties
				err = json.Unmarshal(*v, &eventSubscriptionProperties)
				if err != nil {
					return err
				}
				es.EventSubscriptionProperties = &eventSubscriptionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				es.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				es.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				es.Type = &typeVar
			}
		}
	}

	return nil
}

// BasicEventSubscriptionDestination information about the destination for an event subscription
type BasicEventSubscriptionDestination interface {
	AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool)
	AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool)
	AsStorageQueueEventSubscriptionDestination() (*StorageQueueEventSubscriptionDestination, bool)
	AsHybridConnectionEventSubscriptionDestination() (*HybridConnectionEventSubscriptionDestination, bool)
	AsEventSubscriptionDestination() (*EventSubscriptionDestination, bool)
}

// EventSubscriptionDestination information about the destination for an event subscription
type EventSubscriptionDestination struct {
	// EndpointType - Possible values include: 'EndpointTypeEventSubscriptionDestination', 'EndpointTypeWebHook', 'EndpointTypeEventHub', 'EndpointTypeStorageQueue', 'EndpointTypeHybridConnection'
	EndpointType EndpointType `json:"endpointType,omitempty"`
}

func unmarshalBasicEventSubscriptionDestination(body []byte) (BasicEventSubscriptionDestination, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["endpointType"] {
	case string(EndpointTypeWebHook):
		var whesd WebHookEventSubscriptionDestination
		err := json.Unmarshal(body, &whesd)
		return whesd, err
	case string(EndpointTypeEventHub):
		var ehesd EventHubEventSubscriptionDestination
		err := json.Unmarshal(body, &ehesd)
		return ehesd, err
	case string(EndpointTypeStorageQueue):
		var sqesd StorageQueueEventSubscriptionDestination
		err := json.Unmarshal(body, &sqesd)
		return sqesd, err
	case string(EndpointTypeHybridConnection):
		var hcesd HybridConnectionEventSubscriptionDestination
		err := json.Unmarshal(body, &hcesd)
		return hcesd, err
	default:
		var esd EventSubscriptionDestination
		err := json.Unmarshal(body, &esd)
		return esd, err
	}
}
func unmarshalBasicEventSubscriptionDestinationArray(body []byte) ([]BasicEventSubscriptionDestination, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	esdArray := make([]BasicEventSubscriptionDestination, len(rawMessages))

	for index, rawMessage := range rawMessages {
		esd, err := unmarshalBasicEventSubscriptionDestination(*rawMessage)
		if err != nil {
			return nil, err
		}
		esdArray[index] = esd
	}
	return esdArray, nil
}

// MarshalJSON is the custom marshaler for EventSubscriptionDestination.
func (esd EventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	esd.EndpointType = EndpointTypeEventSubscriptionDestination
	objectMap := make(map[string]interface{})
	if esd.EndpointType != "" {
		objectMap["endpointType"] = esd.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsWebHookEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventSubscriptionDestination.
func (esd EventSubscriptionDestination) AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventHubEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventSubscriptionDestination.
func (esd EventSubscriptionDestination) AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool) {
	return nil, false
}

// AsStorageQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventSubscriptionDestination.
func (esd EventSubscriptionDestination) AsStorageQueueEventSubscriptionDestination() (*StorageQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsHybridConnectionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventSubscriptionDestination.
func (esd EventSubscriptionDestination) AsHybridConnectionEventSubscriptionDestination() (*HybridConnectionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventSubscriptionDestination.
func (esd EventSubscriptionDestination) AsEventSubscriptionDestination() (*EventSubscriptionDestination, bool) {
	return &esd, true
}

// AsBasicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for EventSubscriptionDestination.
func (esd EventSubscriptionDestination) AsBasicEventSubscriptionDestination() (BasicEventSubscriptionDestination, bool) {
	return &esd, true
}

// EventSubscriptionFilter filter for the Event Subscription
type EventSubscriptionFilter struct {
	// SubjectBeginsWith - An optional string to filter events for an event subscription based on a resource path prefix.
	// The format of this depends on the publisher of the events.
	// Wildcard characters are not supported in this path.
	SubjectBeginsWith *string `json:"subjectBeginsWith,omitempty"`
	// SubjectEndsWith - An optional string to filter events for an event subscription based on a resource path suffix.
	// Wildcard characters are not supported in this path.
	SubjectEndsWith *string `json:"subjectEndsWith,omitempty"`
	// IncludedEventTypes - A list of applicable event types that need to be part of the event subscription.
	// If it is desired to subscribe to all event types, the string "all" needs to be specified as an element in this list.
	IncludedEventTypes *[]string `json:"includedEventTypes,omitempty"`
	// IsSubjectCaseSensitive - Specifies if the SubjectBeginsWith and SubjectEndsWith properties of the filter
	// should be compared in a case sensitive manner.
	IsSubjectCaseSensitive *bool `json:"isSubjectCaseSensitive,omitempty"`
}

// EventSubscriptionFullURL full endpoint url of an event subscription
type EventSubscriptionFullURL struct {
	autorest.Response `json:"-"`
	// EndpointURL - The URL that represents the endpoint of the destination of an event subscription.
	EndpointURL *string `json:"endpointUrl,omitempty"`
}

// EventSubscriptionProperties properties of the Event Subscription
type EventSubscriptionProperties struct {
	// Topic - READ-ONLY; Name of the topic of the event subscription.
	Topic *string `json:"topic,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the event subscription. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Canceled', 'Failed', 'AwaitingManualAction'
	ProvisioningState EventSubscriptionProvisioningState `json:"provisioningState,omitempty"`
	// Destination - Information about the destination where events have to be delivered for the event subscription.
	Destination BasicEventSubscriptionDestination `json:"destination,omitempty"`
	// Filter - Information about the filter for the event subscription.
	Filter *EventSubscriptionFilter `json:"filter,omitempty"`
	// Labels - List of user defined labels.
	Labels *[]string `json:"labels,omitempty"`
	// EventDeliverySchema - The event delivery schema for the event subscription. Possible values include: 'EventGridSchema', 'InputEventSchema', 'CloudEventV01Schema'
	EventDeliverySchema EventDeliverySchema `json:"eventDeliverySchema,omitempty"`
	// RetryPolicy - The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
	RetryPolicy *RetryPolicy `json:"retryPolicy,omitempty"`
	// DeadLetterDestination - The DeadLetter destination of the event subscription.
	DeadLetterDestination BasicDeadLetterDestination `json:"deadLetterDestination,omitempty"`
}

// MarshalJSON is the custom marshaler for EventSubscriptionProperties.
func (esp EventSubscriptionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["destination"] = esp.Destination
	if esp.Filter != nil {
		objectMap["filter"] = esp.Filter
	}
	if esp.Labels != nil {
		objectMap["labels"] = esp.Labels
	}
	if esp.EventDeliverySchema != "" {
		objectMap["eventDeliverySchema"] = esp.EventDeliverySchema
	}
	if esp.RetryPolicy != nil {
		objectMap["retryPolicy"] = esp.RetryPolicy
	}
	objectMap["deadLetterDestination"] = esp.DeadLetterDestination
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EventSubscriptionProperties struct.
func (esp *EventSubscriptionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "topic":
			if v != nil {
				var topic string
				err = json.Unmarshal(*v, &topic)
				if err != nil {
					return err
				}
				esp.Topic = &topic
			}
		case "provisioningState":
			if v != nil {
				var provisioningState EventSubscriptionProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				esp.ProvisioningState = provisioningState
			}
		case "destination":
			if v != nil {
				destination, err := unmarshalBasicEventSubscriptionDestination(*v)
				if err != nil {
					return err
				}
				esp.Destination = destination
			}
		case "filter":
			if v != nil {
				var filter EventSubscriptionFilter
				err = json.Unmarshal(*v, &filter)
				if err != nil {
					return err
				}
				esp.Filter = &filter
			}
		case "labels":
			if v != nil {
				var labels []string
				err = json.Unmarshal(*v, &labels)
				if err != nil {
					return err
				}
				esp.Labels = &labels
			}
		case "eventDeliverySchema":
			if v != nil {
				var eventDeliverySchema EventDeliverySchema
				err = json.Unmarshal(*v, &eventDeliverySchema)
				if err != nil {
					return err
				}
				esp.EventDeliverySchema = eventDeliverySchema
			}
		case "retryPolicy":
			if v != nil {
				var retryPolicy RetryPolicy
				err = json.Unmarshal(*v, &retryPolicy)
				if err != nil {
					return err
				}
				esp.RetryPolicy = &retryPolicy
			}
		case "deadLetterDestination":
			if v != nil {
				deadLetterDestination, err := unmarshalBasicDeadLetterDestination(*v)
				if err != nil {
					return err
				}
				esp.DeadLetterDestination = deadLetterDestination
			}
		}
	}

	return nil
}

// EventSubscriptionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EventSubscriptionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EventSubscriptionsClient) (EventSubscription, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EventSubscriptionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EventSubscriptionsCreateOrUpdateFuture.Result.
func (future *EventSubscriptionsCreateOrUpdateFuture) result(client EventSubscriptionsClient) (es EventSubscription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("eventgrid.EventSubscriptionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if es.Response.Response, err = future.GetResult(sender); err == nil && es.Response.Response.StatusCode != http.StatusNoContent {
		es, err = client.CreateOrUpdateResponder(es.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsCreateOrUpdateFuture", "Result", es.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EventSubscriptionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EventSubscriptionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EventSubscriptionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EventSubscriptionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EventSubscriptionsDeleteFuture.Result.
func (future *EventSubscriptionsDeleteFuture) result(client EventSubscriptionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("eventgrid.EventSubscriptionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EventSubscriptionsListResult result of the List EventSubscriptions operation
type EventSubscriptionsListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of EventSubscriptions
	Value *[]EventSubscription `json:"value,omitempty"`
}

// EventSubscriptionsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EventSubscriptionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EventSubscriptionsClient) (EventSubscription, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EventSubscriptionsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EventSubscriptionsUpdateFuture.Result.
func (future *EventSubscriptionsUpdateFuture) result(client EventSubscriptionsClient) (es EventSubscription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("eventgrid.EventSubscriptionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if es.Response.Response, err = future.GetResult(sender); err == nil && es.Response.Response.StatusCode != http.StatusNoContent {
		es, err = client.UpdateResponder(es.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.EventSubscriptionsUpdateFuture", "Result", es.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EventSubscriptionUpdateParameters properties of the Event Subscription update
type EventSubscriptionUpdateParameters struct {
	// Destination - Information about the destination where events have to be delivered for the event subscription.
	Destination BasicEventSubscriptionDestination `json:"destination,omitempty"`
	// Filter - Information about the filter for the event subscription.
	Filter *EventSubscriptionFilter `json:"filter,omitempty"`
	// Labels - List of user defined labels.
	Labels *[]string `json:"labels,omitempty"`
	// EventDeliverySchema - The event delivery schema for the event subscription. Possible values include: 'EventGridSchema', 'InputEventSchema', 'CloudEventV01Schema'
	EventDeliverySchema EventDeliverySchema `json:"eventDeliverySchema,omitempty"`
	// RetryPolicy - The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
	RetryPolicy *RetryPolicy `json:"retryPolicy,omitempty"`
	// DeadLetterDestination - The DeadLetter destination of the event subscription.
	DeadLetterDestination BasicDeadLetterDestination `json:"deadLetterDestination,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EventSubscriptionUpdateParameters struct.
func (esup *EventSubscriptionUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "destination":
			if v != nil {
				destination, err := unmarshalBasicEventSubscriptionDestination(*v)
				if err != nil {
					return err
				}
				esup.Destination = destination
			}
		case "filter":
			if v != nil {
				var filter EventSubscriptionFilter
				err = json.Unmarshal(*v, &filter)
				if err != nil {
					return err
				}
				esup.Filter = &filter
			}
		case "labels":
			if v != nil {
				var labels []string
				err = json.Unmarshal(*v, &labels)
				if err != nil {
					return err
				}
				esup.Labels = &labels
			}
		case "eventDeliverySchema":
			if v != nil {
				var eventDeliverySchema EventDeliverySchema
				err = json.Unmarshal(*v, &eventDeliverySchema)
				if err != nil {
					return err
				}
				esup.EventDeliverySchema = eventDeliverySchema
			}
		case "retryPolicy":
			if v != nil {
				var retryPolicy RetryPolicy
				err = json.Unmarshal(*v, &retryPolicy)
				if err != nil {
					return err
				}
				esup.RetryPolicy = &retryPolicy
			}
		case "deadLetterDestination":
			if v != nil {
				deadLetterDestination, err := unmarshalBasicDeadLetterDestination(*v)
				if err != nil {
					return err
				}
				esup.DeadLetterDestination = deadLetterDestination
			}
		}
	}

	return nil
}

// EventType event Type for a subject under a topic
type EventType struct {
	// EventTypeProperties - Properties of the event type.
	*EventTypeProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventType.
func (et EventType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if et.EventTypeProperties != nil {
		objectMap["properties"] = et.EventTypeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EventType struct.
func (et *EventType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventTypeProperties EventTypeProperties
				err = json.Unmarshal(*v, &eventTypeProperties)
				if err != nil {
					return err
				}
				et.EventTypeProperties = &eventTypeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				et.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				et.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				et.Type = &typeVar
			}
		}
	}

	return nil
}

// EventTypeProperties properties of the event type
type EventTypeProperties struct {
	// DisplayName - Display name of the event type.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Description of the event type.
	Description *string `json:"description,omitempty"`
	// SchemaURL - Url of the schema for this event type.
	SchemaURL *string `json:"schemaUrl,omitempty"`
}

// EventTypesListResult result of the List Event Types operation
type EventTypesListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of event types
	Value *[]EventType `json:"value,omitempty"`
}

// HybridConnectionEventSubscriptionDestination information about the HybridConnection destination for an
// event subscription.
type HybridConnectionEventSubscriptionDestination struct {
	// HybridConnectionEventSubscriptionDestinationProperties - Hybrid connection Properties of the event subscription destination
	*HybridConnectionEventSubscriptionDestinationProperties `json:"properties,omitempty"`
	// EndpointType - Possible values include: 'EndpointTypeEventSubscriptionDestination', 'EndpointTypeWebHook', 'EndpointTypeEventHub', 'EndpointTypeStorageQueue', 'EndpointTypeHybridConnection'
	EndpointType EndpointType `json:"endpointType,omitempty"`
}

// MarshalJSON is the custom marshaler for HybridConnectionEventSubscriptionDestination.
func (hcesd HybridConnectionEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	hcesd.EndpointType = EndpointTypeHybridConnection
	objectMap := make(map[string]interface{})
	if hcesd.HybridConnectionEventSubscriptionDestinationProperties != nil {
		objectMap["properties"] = hcesd.HybridConnectionEventSubscriptionDestinationProperties
	}
	if hcesd.EndpointType != "" {
		objectMap["endpointType"] = hcesd.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsWebHookEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for HybridConnectionEventSubscriptionDestination.
func (hcesd HybridConnectionEventSubscriptionDestination) AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventHubEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for HybridConnectionEventSubscriptionDestination.
func (hcesd HybridConnectionEventSubscriptionDestination) AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool) {
	return nil, false
}

// AsStorageQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for HybridConnectionEventSubscriptionDestination.
func (hcesd HybridConnectionEventSubscriptionDestination) AsStorageQueueEventSubscriptionDestination() (*StorageQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsHybridConnectionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for HybridConnectionEventSubscriptionDestination.
func (hcesd HybridConnectionEventSubscriptionDestination) AsHybridConnectionEventSubscriptionDestination() (*HybridConnectionEventSubscriptionDestination, bool) {
	return &hcesd, true
}

// AsEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for HybridConnectionEventSubscriptionDestination.
func (hcesd HybridConnectionEventSubscriptionDestination) AsEventSubscriptionDestination() (*EventSubscriptionDestination, bool) {
	return nil, false
}

// AsBasicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for HybridConnectionEventSubscriptionDestination.
func (hcesd HybridConnectionEventSubscriptionDestination) AsBasicEventSubscriptionDestination() (BasicEventSubscriptionDestination, bool) {
	return &hcesd, true
}

// UnmarshalJSON is the custom unmarshaler for HybridConnectionEventSubscriptionDestination struct.
func (hcesd *HybridConnectionEventSubscriptionDestination) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hybridConnectionEventSubscriptionDestinationProperties HybridConnectionEventSubscriptionDestinationProperties
				err = json.Unmarshal(*v, &hybridConnectionEventSubscriptionDestinationProperties)
				if err != nil {
					return err
				}
				hcesd.HybridConnectionEventSubscriptionDestinationProperties = &hybridConnectionEventSubscriptionDestinationProperties
			}
		case "endpointType":
			if v != nil {
				var endpointType EndpointType
				err = json.Unmarshal(*v, &endpointType)
				if err != nil {
					return err
				}
				hcesd.EndpointType = endpointType
			}
		}
	}

	return nil
}

// HybridConnectionEventSubscriptionDestinationProperties the properties for a hybrid connection
// destination.
type HybridConnectionEventSubscriptionDestinationProperties struct {
	// ResourceID - The Azure Resource ID of an hybrid connection that is the destination of an event subscription.
	ResourceID *string `json:"resourceId,omitempty"`
}

// BasicInputSchemaMapping by default, Event Grid expects events to be in the Event Grid event schema. Specifying an
// input schema mapping enables publishing to Event Grid using a custom input schema. Currently, the only supported
// type of InputSchemaMapping is 'JsonInputSchemaMapping'.
type BasicInputSchemaMapping interface {
	AsJSONInputSchemaMapping() (*JSONInputSchemaMapping, bool)
	AsInputSchemaMapping() (*InputSchemaMapping, bool)
}

// InputSchemaMapping by default, Event Grid expects events to be in the Event Grid event schema. Specifying an
// input schema mapping enables publishing to Event Grid using a custom input schema. Currently, the only
// supported type of InputSchemaMapping is 'JsonInputSchemaMapping'.
type InputSchemaMapping struct {
	// InputSchemaMappingType - Possible values include: 'InputSchemaMappingTypeInputSchemaMapping', 'InputSchemaMappingTypeJSON'
	InputSchemaMappingType InputSchemaMappingType `json:"inputSchemaMappingType,omitempty"`
}

func unmarshalBasicInputSchemaMapping(body []byte) (BasicInputSchemaMapping, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["inputSchemaMappingType"] {
	case string(InputSchemaMappingTypeJSON):
		var jism JSONInputSchemaMapping
		err := json.Unmarshal(body, &jism)
		return jism, err
	default:
		var ism InputSchemaMapping
		err := json.Unmarshal(body, &ism)
		return ism, err
	}
}
func unmarshalBasicInputSchemaMappingArray(body []byte) ([]BasicInputSchemaMapping, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ismArray := make([]BasicInputSchemaMapping, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ism, err := unmarshalBasicInputSchemaMapping(*rawMessage)
		if err != nil {
			return nil, err
		}
		ismArray[index] = ism
	}
	return ismArray, nil
}

// MarshalJSON is the custom marshaler for InputSchemaMapping.
func (ism InputSchemaMapping) MarshalJSON() ([]byte, error) {
	ism.InputSchemaMappingType = InputSchemaMappingTypeInputSchemaMapping
	objectMap := make(map[string]interface{})
	if ism.InputSchemaMappingType != "" {
		objectMap["inputSchemaMappingType"] = ism.InputSchemaMappingType
	}
	return json.Marshal(objectMap)
}

// AsJSONInputSchemaMapping is the BasicInputSchemaMapping implementation for InputSchemaMapping.
func (ism InputSchemaMapping) AsJSONInputSchemaMapping() (*JSONInputSchemaMapping, bool) {
	return nil, false
}

// AsInputSchemaMapping is the BasicInputSchemaMapping implementation for InputSchemaMapping.
func (ism InputSchemaMapping) AsInputSchemaMapping() (*InputSchemaMapping, bool) {
	return &ism, true
}

// AsBasicInputSchemaMapping is the BasicInputSchemaMapping implementation for InputSchemaMapping.
func (ism InputSchemaMapping) AsBasicInputSchemaMapping() (BasicInputSchemaMapping, bool) {
	return &ism, true
}

// JSONField this is used to express the source of an input schema mapping for a single target field in the
// Event Grid Event schema. This is currently used in the mappings for the 'id','topic' and 'eventTime'
// properties. This represents a field in the input event schema.
type JSONField struct {
	// SourceField - Name of a field in the input event schema that's to be used as the source of a mapping.
	SourceField *string `json:"sourceField,omitempty"`
}

// JSONFieldWithDefault this is used to express the source of an input schema mapping for a single target
// field in the Event Grid Event schema. This is currently used in the mappings for the
// 'subject','eventType' and 'dataVersion' properties. This represents a field in the input event schema
// along with a default value to be used, and at least one of these two properties should be provided.
type JSONFieldWithDefault struct {
	// SourceField - Name of a field in the input event schema that's to be used as the source of a mapping.
	SourceField *string `json:"sourceField,omitempty"`
	// DefaultValue - The default value to be used for mapping when a SourceField is not provided or if there's no property with the specified name in the published JSON event payload.
	DefaultValue *string `json:"defaultValue,omitempty"`
}

// JSONInputSchemaMapping this enables publishing to Event Grid using a custom input schema. This can be
// used to map properties from a custom input JSON schema to the Event Grid event schema.
type JSONInputSchemaMapping struct {
	// JSONInputSchemaMappingProperties - JSON Properties of the input schema mapping
	*JSONInputSchemaMappingProperties `json:"properties,omitempty"`
	// InputSchemaMappingType - Possible values include: 'InputSchemaMappingTypeInputSchemaMapping', 'InputSchemaMappingTypeJSON'
	InputSchemaMappingType InputSchemaMappingType `json:"inputSchemaMappingType,omitempty"`
}

// MarshalJSON is the custom marshaler for JSONInputSchemaMapping.
func (jism JSONInputSchemaMapping) MarshalJSON() ([]byte, error) {
	jism.InputSchemaMappingType = InputSchemaMappingTypeJSON
	objectMap := make(map[string]interface{})
	if jism.JSONInputSchemaMappingProperties != nil {
		objectMap["properties"] = jism.JSONInputSchemaMappingProperties
	}
	if jism.InputSchemaMappingType != "" {
		objectMap["inputSchemaMappingType"] = jism.InputSchemaMappingType
	}
	return json.Marshal(objectMap)
}

// AsJSONInputSchemaMapping is the BasicInputSchemaMapping implementation for JSONInputSchemaMapping.
func (jism JSONInputSchemaMapping) AsJSONInputSchemaMapping() (*JSONInputSchemaMapping, bool) {
	return &jism, true
}

// AsInputSchemaMapping is the BasicInputSchemaMapping implementation for JSONInputSchemaMapping.
func (jism JSONInputSchemaMapping) AsInputSchemaMapping() (*InputSchemaMapping, bool) {
	return nil, false
}

// AsBasicInputSchemaMapping is the BasicInputSchemaMapping implementation for JSONInputSchemaMapping.
func (jism JSONInputSchemaMapping) AsBasicInputSchemaMapping() (BasicInputSchemaMapping, bool) {
	return &jism, true
}

// UnmarshalJSON is the custom unmarshaler for JSONInputSchemaMapping struct.
func (jism *JSONInputSchemaMapping) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var JSONInputSchemaMappingProperties JSONInputSchemaMappingProperties
				err = json.Unmarshal(*v, &JSONInputSchemaMappingProperties)
				if err != nil {
					return err
				}
				jism.JSONInputSchemaMappingProperties = &JSONInputSchemaMappingProperties
			}
		case "inputSchemaMappingType":
			if v != nil {
				var inputSchemaMappingType InputSchemaMappingType
				err = json.Unmarshal(*v, &inputSchemaMappingType)
				if err != nil {
					return err
				}
				jism.InputSchemaMappingType = inputSchemaMappingType
			}
		}
	}

	return nil
}

// JSONInputSchemaMappingProperties this can be used to map properties of a source schema (or default
// values, for certain supported properties) to properties of the EventGridEvent schema.
type JSONInputSchemaMappingProperties struct {
	// ID - The mapping information for the Id property of the Event Grid Event.
	ID *JSONField `json:"id,omitempty"`
	// Topic - The mapping information for the Topic property of the Event Grid Event.
	Topic *JSONField `json:"topic,omitempty"`
	// EventTime - The mapping information for the EventTime property of the Event Grid Event.
	EventTime *JSONField `json:"eventTime,omitempty"`
	// EventType - The mapping information for the EventType property of the Event Grid Event.
	EventType *JSONFieldWithDefault `json:"eventType,omitempty"`
	// Subject - The mapping information for the Subject property of the Event Grid Event.
	Subject *JSONFieldWithDefault `json:"subject,omitempty"`
	// DataVersion - The mapping information for the DataVersion property of the Event Grid Event.
	DataVersion *JSONFieldWithDefault `json:"dataVersion,omitempty"`
}

// Operation represents an operation returned by the GetOperations request
type Operation struct {
	// Name - Name of the operation
	Name *string `json:"name,omitempty"`
	// Display - Display name of the operation
	Display *OperationInfo `json:"display,omitempty"`
	// Origin - Origin of the operation
	Origin *string `json:"origin,omitempty"`
	// Properties - Properties of the operation
	Properties interface{} `json:"properties,omitempty"`
}

// OperationInfo information about an operation
type OperationInfo struct {
	// Provider - Name of the provider
	Provider *string `json:"provider,omitempty"`
	// Resource - Name of the resource type
	Resource *string `json:"resource,omitempty"`
	// Operation - Name of the operation
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation
	Description *string `json:"description,omitempty"`
}

// OperationsListResult result of the List Operations operation
type OperationsListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of operations
	Value *[]Operation `json:"value,omitempty"`
}

// Resource definition of a Resource
type Resource struct {
	// ID - READ-ONLY; Fully qualified identifier of the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// RetryPolicy information about the retry policy for an event subscription
type RetryPolicy struct {
	// MaxDeliveryAttempts - Maximum number of delivery retry attempts for events.
	MaxDeliveryAttempts *int32 `json:"maxDeliveryAttempts,omitempty"`
	// EventTimeToLiveInMinutes - Time To Live (in minutes) for events.
	EventTimeToLiveInMinutes *int32 `json:"eventTimeToLiveInMinutes,omitempty"`
}

// StorageBlobDeadLetterDestination information about the storage blob based dead letter destination.
type StorageBlobDeadLetterDestination struct {
	// StorageBlobDeadLetterDestinationProperties - The properties of the Storage Blob based deadletter destination
	*StorageBlobDeadLetterDestinationProperties `json:"properties,omitempty"`
	// EndpointType - Possible values include: 'EndpointTypeDeadLetterDestination', 'EndpointTypeStorageBlob'
	EndpointType EndpointTypeBasicDeadLetterDestination `json:"endpointType,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageBlobDeadLetterDestination.
func (sbdld StorageBlobDeadLetterDestination) MarshalJSON() ([]byte, error) {
	sbdld.EndpointType = EndpointTypeStorageBlob
	objectMap := make(map[string]interface{})
	if sbdld.StorageBlobDeadLetterDestinationProperties != nil {
		objectMap["properties"] = sbdld.StorageBlobDeadLetterDestinationProperties
	}
	if sbdld.EndpointType != "" {
		objectMap["endpointType"] = sbdld.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsStorageBlobDeadLetterDestination is the BasicDeadLetterDestination implementation for StorageBlobDeadLetterDestination.
func (sbdld StorageBlobDeadLetterDestination) AsStorageBlobDeadLetterDestination() (*StorageBlobDeadLetterDestination, bool) {
	return &sbdld, true
}

// AsDeadLetterDestination is the BasicDeadLetterDestination implementation for StorageBlobDeadLetterDestination.
func (sbdld StorageBlobDeadLetterDestination) AsDeadLetterDestination() (*DeadLetterDestination, bool) {
	return nil, false
}

// AsBasicDeadLetterDestination is the BasicDeadLetterDestination implementation for StorageBlobDeadLetterDestination.
func (sbdld StorageBlobDeadLetterDestination) AsBasicDeadLetterDestination() (BasicDeadLetterDestination, bool) {
	return &sbdld, true
}

// UnmarshalJSON is the custom unmarshaler for StorageBlobDeadLetterDestination struct.
func (sbdld *StorageBlobDeadLetterDestination) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storageBlobDeadLetterDestinationProperties StorageBlobDeadLetterDestinationProperties
				err = json.Unmarshal(*v, &storageBlobDeadLetterDestinationProperties)
				if err != nil {
					return err
				}
				sbdld.StorageBlobDeadLetterDestinationProperties = &storageBlobDeadLetterDestinationProperties
			}
		case "endpointType":
			if v != nil {
				var endpointType EndpointTypeBasicDeadLetterDestination
				err = json.Unmarshal(*v, &endpointType)
				if err != nil {
					return err
				}
				sbdld.EndpointType = endpointType
			}
		}
	}

	return nil
}

// StorageBlobDeadLetterDestinationProperties properties of the storage blob based dead letter destination.
type StorageBlobDeadLetterDestinationProperties struct {
	// ResourceID - The Azure Resource ID of the storage account that is the destination of the deadletter events
	ResourceID *string `json:"resourceId,omitempty"`
	// BlobContainerName - The name of the Storage blob container that is the destination of the deadletter events
	BlobContainerName *string `json:"blobContainerName,omitempty"`
}

// StorageQueueEventSubscriptionDestination information about the storage queue destination for an event
// subscription.
type StorageQueueEventSubscriptionDestination struct {
	// StorageQueueEventSubscriptionDestinationProperties - Storage Queue Properties of the event subscription destination
	*StorageQueueEventSubscriptionDestinationProperties `json:"properties,omitempty"`
	// EndpointType - Possible values include: 'EndpointTypeEventSubscriptionDestination', 'EndpointTypeWebHook', 'EndpointTypeEventHub', 'EndpointTypeStorageQueue', 'EndpointTypeHybridConnection'
	EndpointType EndpointType `json:"endpointType,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageQueueEventSubscriptionDestination.
func (sqesd StorageQueueEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	sqesd.EndpointType = EndpointTypeStorageQueue
	objectMap := make(map[string]interface{})
	if sqesd.StorageQueueEventSubscriptionDestinationProperties != nil {
		objectMap["properties"] = sqesd.StorageQueueEventSubscriptionDestinationProperties
	}
	if sqesd.EndpointType != "" {
		objectMap["endpointType"] = sqesd.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsWebHookEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for StorageQueueEventSubscriptionDestination.
func (sqesd StorageQueueEventSubscriptionDestination) AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventHubEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for StorageQueueEventSubscriptionDestination.
func (sqesd StorageQueueEventSubscriptionDestination) AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool) {
	return nil, false
}

// AsStorageQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for StorageQueueEventSubscriptionDestination.
func (sqesd StorageQueueEventSubscriptionDestination) AsStorageQueueEventSubscriptionDestination() (*StorageQueueEventSubscriptionDestination, bool) {
	return &sqesd, true
}

// AsHybridConnectionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for StorageQueueEventSubscriptionDestination.
func (sqesd StorageQueueEventSubscriptionDestination) AsHybridConnectionEventSubscriptionDestination() (*HybridConnectionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for StorageQueueEventSubscriptionDestination.
func (sqesd StorageQueueEventSubscriptionDestination) AsEventSubscriptionDestination() (*EventSubscriptionDestination, bool) {
	return nil, false
}

// AsBasicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for StorageQueueEventSubscriptionDestination.
func (sqesd StorageQueueEventSubscriptionDestination) AsBasicEventSubscriptionDestination() (BasicEventSubscriptionDestination, bool) {
	return &sqesd, true
}

// UnmarshalJSON is the custom unmarshaler for StorageQueueEventSubscriptionDestination struct.
func (sqesd *StorageQueueEventSubscriptionDestination) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storageQueueEventSubscriptionDestinationProperties StorageQueueEventSubscriptionDestinationProperties
				err = json.Unmarshal(*v, &storageQueueEventSubscriptionDestinationProperties)
				if err != nil {
					return err
				}
				sqesd.StorageQueueEventSubscriptionDestinationProperties = &storageQueueEventSubscriptionDestinationProperties
			}
		case "endpointType":
			if v != nil {
				var endpointType EndpointType
				err = json.Unmarshal(*v, &endpointType)
				if err != nil {
					return err
				}
				sqesd.EndpointType = endpointType
			}
		}
	}

	return nil
}

// StorageQueueEventSubscriptionDestinationProperties the properties for a storage queue destination.
type StorageQueueEventSubscriptionDestinationProperties struct {
	// ResourceID - The Azure Resource ID of the storage account that contains the queue that is the destination of an event subscription.
	ResourceID *string `json:"resourceId,omitempty"`
	// QueueName - The name of the Storage queue under a storage account that is the destination of an event subscription.
	QueueName *string `json:"queueName,omitempty"`
}

// Topic eventGrid Topic
type Topic struct {
	autorest.Response `json:"-"`
	// TopicProperties - Properties of the topic
	*TopicProperties `json:"properties,omitempty"`
	// Location - Location of the resource
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the resource
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified identifier of the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Topic.
func (t Topic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.TopicProperties != nil {
		objectMap["properties"] = t.TopicProperties
	}
	if t.Location != nil {
		objectMap["location"] = t.Location
	}
	if t.Tags != nil {
		objectMap["tags"] = t.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Topic struct.
func (t *Topic) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var topicProperties TopicProperties
				err = json.Unmarshal(*v, &topicProperties)
				if err != nil {
					return err
				}
				t.TopicProperties = &topicProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				t.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				t.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		}
	}

	return nil
}

// TopicProperties properties of the Topic
type TopicProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the topic. Possible values include: 'TopicProvisioningStateCreating', 'TopicProvisioningStateUpdating', 'TopicProvisioningStateDeleting', 'TopicProvisioningStateSucceeded', 'TopicProvisioningStateCanceled', 'TopicProvisioningStateFailed'
	ProvisioningState TopicProvisioningState `json:"provisioningState,omitempty"`
	// Endpoint - READ-ONLY; Endpoint for the topic.
	Endpoint *string `json:"endpoint,omitempty"`
	// InputSchema - This determines the format that Event Grid should expect for incoming events published to the topic. Possible values include: 'InputSchemaEventGridSchema', 'InputSchemaCustomEventSchema', 'InputSchemaCloudEventV01Schema'
	InputSchema InputSchema `json:"inputSchema,omitempty"`
	// InputSchemaMapping - This enables publishing using custom event schemas. An InputSchemaMapping can be specified to map various properties of a source schema to various required properties of the EventGridEvent schema.
	InputSchemaMapping BasicInputSchemaMapping `json:"inputSchemaMapping,omitempty"`
}

// MarshalJSON is the custom marshaler for TopicProperties.
func (tp TopicProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.InputSchema != "" {
		objectMap["inputSchema"] = tp.InputSchema
	}
	objectMap["inputSchemaMapping"] = tp.InputSchemaMapping
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TopicProperties struct.
func (tp *TopicProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "provisioningState":
			if v != nil {
				var provisioningState TopicProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				tp.ProvisioningState = provisioningState
			}
		case "endpoint":
			if v != nil {
				var endpoint string
				err = json.Unmarshal(*v, &endpoint)
				if err != nil {
					return err
				}
				tp.Endpoint = &endpoint
			}
		case "inputSchema":
			if v != nil {
				var inputSchema InputSchema
				err = json.Unmarshal(*v, &inputSchema)
				if err != nil {
					return err
				}
				tp.InputSchema = inputSchema
			}
		case "inputSchemaMapping":
			if v != nil {
				inputSchemaMapping, err := unmarshalBasicInputSchemaMapping(*v)
				if err != nil {
					return err
				}
				tp.InputSchemaMapping = inputSchemaMapping
			}
		}
	}

	return nil
}

// TopicRegenerateKeyRequest topic regenerate share access key request
type TopicRegenerateKeyRequest struct {
	// KeyName - Key name to regenerate key1 or key2
	KeyName *string `json:"keyName,omitempty"`
}

// TopicsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TopicsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TopicsClient) (Topic, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TopicsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TopicsCreateOrUpdateFuture.Result.
func (future *TopicsCreateOrUpdateFuture) result(client TopicsClient) (t Topic, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.TopicsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("eventgrid.TopicsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.CreateOrUpdateResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.TopicsCreateOrUpdateFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TopicsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type TopicsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TopicsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TopicsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TopicsDeleteFuture.Result.
func (future *TopicsDeleteFuture) result(client TopicsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.TopicsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("eventgrid.TopicsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// TopicSharedAccessKeys shared access keys of the Topic
type TopicSharedAccessKeys struct {
	autorest.Response `json:"-"`
	// Key1 - Shared access key1 for the topic.
	Key1 *string `json:"key1,omitempty"`
	// Key2 - Shared access key2 for the topic.
	Key2 *string `json:"key2,omitempty"`
}

// TopicsListResult result of the List Topics operation
type TopicsListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of Topics
	Value *[]Topic `json:"value,omitempty"`
}

// TopicsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type TopicsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TopicsClient) (Topic, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TopicsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TopicsUpdateFuture.Result.
func (future *TopicsUpdateFuture) result(client TopicsClient) (t Topic, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "eventgrid.TopicsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("eventgrid.TopicsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.UpdateResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "eventgrid.TopicsUpdateFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TopicTypeInfo properties of a topic type info.
type TopicTypeInfo struct {
	autorest.Response `json:"-"`
	// TopicTypeProperties - Properties of the topic type info
	*TopicTypeProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TopicTypeInfo.
func (tti TopicTypeInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tti.TopicTypeProperties != nil {
		objectMap["properties"] = tti.TopicTypeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TopicTypeInfo struct.
func (tti *TopicTypeInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var topicTypeProperties TopicTypeProperties
				err = json.Unmarshal(*v, &topicTypeProperties)
				if err != nil {
					return err
				}
				tti.TopicTypeProperties = &topicTypeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tti.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tti.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tti.Type = &typeVar
			}
		}
	}

	return nil
}

// TopicTypeProperties properties of a topic type.
type TopicTypeProperties struct {
	// Provider - Namespace of the provider of the topic type.
	Provider *string `json:"provider,omitempty"`
	// DisplayName - Display Name for the topic type.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Description of the topic type.
	Description *string `json:"description,omitempty"`
	// ResourceRegionType - Region type of the resource. Possible values include: 'RegionalResource', 'GlobalResource'
	ResourceRegionType ResourceRegionType `json:"resourceRegionType,omitempty"`
	// ProvisioningState - Provisioning state of the topic type. Possible values include: 'TopicTypeProvisioningStateCreating', 'TopicTypeProvisioningStateUpdating', 'TopicTypeProvisioningStateDeleting', 'TopicTypeProvisioningStateSucceeded', 'TopicTypeProvisioningStateCanceled', 'TopicTypeProvisioningStateFailed'
	ProvisioningState TopicTypeProvisioningState `json:"provisioningState,omitempty"`
	// SupportedLocations - List of locations supported by this topic type.
	SupportedLocations *[]string `json:"supportedLocations,omitempty"`
}

// TopicTypesListResult result of the List Topic Types operation
type TopicTypesListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of topic types
	Value *[]TopicTypeInfo `json:"value,omitempty"`
}

// TopicUpdateParameters properties of the Topic update
type TopicUpdateParameters struct {
	// Tags - Tags of the resource
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TopicUpdateParameters.
func (tup TopicUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tup.Tags != nil {
		objectMap["tags"] = tup.Tags
	}
	return json.Marshal(objectMap)
}

// TrackedResource definition of a Tracked Resource
type TrackedResource struct {
	// Location - Location of the resource
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the resource
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified identifier of the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// WebHookEventSubscriptionDestination information about the webhook destination for an event subscription
type WebHookEventSubscriptionDestination struct {
	// WebHookEventSubscriptionDestinationProperties - WebHook Properties of the event subscription destination
	*WebHookEventSubscriptionDestinationProperties `json:"properties,omitempty"`
	// EndpointType - Possible values include: 'EndpointTypeEventSubscriptionDestination', 'EndpointTypeWebHook', 'EndpointTypeEventHub', 'EndpointTypeStorageQueue', 'EndpointTypeHybridConnection'
	EndpointType EndpointType `json:"endpointType,omitempty"`
}

// MarshalJSON is the custom marshaler for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	whesd.EndpointType = EndpointTypeWebHook
	objectMap := make(map[string]interface{})
	if whesd.WebHookEventSubscriptionDestinationProperties != nil {
		objectMap["properties"] = whesd.WebHookEventSubscriptionDestinationProperties
	}
	if whesd.EndpointType != "" {
		objectMap["endpointType"] = whesd.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsWebHookEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool) {
	return &whesd, true
}

// AsEventHubEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool) {
	return nil, false
}

// AsStorageQueueEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) AsStorageQueueEventSubscriptionDestination() (*StorageQueueEventSubscriptionDestination, bool) {
	return nil, false
}

// AsHybridConnectionEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) AsHybridConnectionEventSubscriptionDestination() (*HybridConnectionEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) AsEventSubscriptionDestination() (*EventSubscriptionDestination, bool) {
	return nil, false
}

// AsBasicEventSubscriptionDestination is the BasicEventSubscriptionDestination implementation for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) AsBasicEventSubscriptionDestination() (BasicEventSubscriptionDestination, bool) {
	return &whesd, true
}

// UnmarshalJSON is the custom unmarshaler for WebHookEventSubscriptionDestination struct.
func (whesd *WebHookEventSubscriptionDestination) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var webHookEventSubscriptionDestinationProperties WebHookEventSubscriptionDestinationProperties
				err = json.Unmarshal(*v, &webHookEventSubscriptionDestinationProperties)
				if err != nil {
					return err
				}
				whesd.WebHookEventSubscriptionDestinationProperties = &webHookEventSubscriptionDestinationProperties
			}
		case "endpointType":
			if v != nil {
				var endpointType EndpointType
				err = json.Unmarshal(*v, &endpointType)
				if err != nil {
					return err
				}
				whesd.EndpointType = endpointType
			}
		}
	}

	return nil
}

// WebHookEventSubscriptionDestinationProperties information about the webhook destination properties for
// an event subscription.
type WebHookEventSubscriptionDestinationProperties struct {
	// EndpointURL - The URL that represents the endpoint of the destination of an event subscription.
	EndpointURL *string `json:"endpointUrl,omitempty"`
	// EndpointBaseURL - READ-ONLY; The base URL that represents the endpoint of the destination of an event subscription.
	EndpointBaseURL *string `json:"endpointBaseUrl,omitempty"`
}

// MarshalJSON is the custom marshaler for WebHookEventSubscriptionDestinationProperties.
func (whesdp WebHookEventSubscriptionDestinationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if whesdp.EndpointURL != nil {
		objectMap["endpointUrl"] = whesdp.EndpointURL
	}
	return json.Marshal(objectMap)
}
