package alertsmanagementapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/alertsmanagement/mgmt/2019-06-01-preview/alertsmanagement"
	"github.com/Azure/go-autorest/autorest"
)

// ActionRulesClientAPI contains the set of methods on the ActionRulesClient type.
type ActionRulesClientAPI interface {
	CreateUpdate(ctx context.Context, resourceGroupName string, actionRuleName string, actionRule alertsmanagement.ActionRule) (result alertsmanagement.ActionRule, err error)
	Delete(ctx context.Context, resourceGroupName string, actionRuleName string) (result alertsmanagement.Bool, err error)
	GetByName(ctx context.Context, resourceGroupName string, actionRuleName string) (result alertsmanagement.ActionRule, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, targetResourceGroup string, targetResourceType string, targetResource string, severity alertsmanagement.Severity, monitorService alertsmanagement.MonitorService, impactedScope string, description string, alertRuleID string, actionGroup string, name string) (result alertsmanagement.ActionRulesListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, targetResourceGroup string, targetResourceType string, targetResource string, severity alertsmanagement.Severity, monitorService alertsmanagement.MonitorService, impactedScope string, description string, alertRuleID string, actionGroup string, name string) (result alertsmanagement.ActionRulesListIterator, err error)
	ListBySubscription(ctx context.Context, targetResourceGroup string, targetResourceType string, targetResource string, severity alertsmanagement.Severity, monitorService alertsmanagement.MonitorService, impactedScope string, description string, alertRuleID string, actionGroup string, name string) (result alertsmanagement.ActionRulesListPage, err error)
	ListBySubscriptionComplete(ctx context.Context, targetResourceGroup string, targetResourceType string, targetResource string, severity alertsmanagement.Severity, monitorService alertsmanagement.MonitorService, impactedScope string, description string, alertRuleID string, actionGroup string, name string) (result alertsmanagement.ActionRulesListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, actionRuleName string, actionRulePatch alertsmanagement.PatchObject) (result alertsmanagement.ActionRule, err error)
}

var _ ActionRulesClientAPI = (*alertsmanagement.ActionRulesClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result alertsmanagement.OperationsListPage, err error)
	ListComplete(ctx context.Context) (result alertsmanagement.OperationsListIterator, err error)
}

var _ OperationsClientAPI = (*alertsmanagement.OperationsClient)(nil)

// AlertsClientAPI contains the set of methods on the AlertsClient type.
type AlertsClientAPI interface {
	ChangeState(ctx context.Context, alertID string, newState alertsmanagement.AlertState) (result alertsmanagement.Alert, err error)
	GetAll(ctx context.Context, targetResource string, targetResourceType string, targetResourceGroup string, monitorService alertsmanagement.MonitorService, monitorCondition alertsmanagement.MonitorCondition, severity alertsmanagement.Severity, alertState alertsmanagement.AlertState, alertRule string, smartGroupID string, includeContext *bool, includeEgressConfig *bool, pageCount *int32, sortBy alertsmanagement.AlertsSortByFields, sortOrder string, selectParameter string, timeRange alertsmanagement.TimeRange, customTimeRange string) (result alertsmanagement.AlertsListPage, err error)
	GetAllComplete(ctx context.Context, targetResource string, targetResourceType string, targetResourceGroup string, monitorService alertsmanagement.MonitorService, monitorCondition alertsmanagement.MonitorCondition, severity alertsmanagement.Severity, alertState alertsmanagement.AlertState, alertRule string, smartGroupID string, includeContext *bool, includeEgressConfig *bool, pageCount *int32, sortBy alertsmanagement.AlertsSortByFields, sortOrder string, selectParameter string, timeRange alertsmanagement.TimeRange, customTimeRange string) (result alertsmanagement.AlertsListIterator, err error)
	GetByID(ctx context.Context, alertID string) (result alertsmanagement.Alert, err error)
	GetHistory(ctx context.Context, alertID string) (result alertsmanagement.AlertModification, err error)
	GetSummary(ctx context.Context, groupby alertsmanagement.AlertsSummaryGroupByFields, includeSmartGroupsCount *bool, targetResource string, targetResourceType string, targetResourceGroup string, monitorService alertsmanagement.MonitorService, monitorCondition alertsmanagement.MonitorCondition, severity alertsmanagement.Severity, alertState alertsmanagement.AlertState, alertRule string, timeRange alertsmanagement.TimeRange, customTimeRange string) (result alertsmanagement.AlertsSummary, err error)
	MetaData(ctx context.Context) (result alertsmanagement.AlertsMetaData, err error)
}

var _ AlertsClientAPI = (*alertsmanagement.AlertsClient)(nil)

// SmartGroupsClientAPI contains the set of methods on the SmartGroupsClient type.
type SmartGroupsClientAPI interface {
	ChangeState(ctx context.Context, smartGroupID string, newState alertsmanagement.AlertState) (result alertsmanagement.SmartGroup, err error)
	GetAll(ctx context.Context, targetResource string, targetResourceGroup string, targetResourceType string, monitorService alertsmanagement.MonitorService, monitorCondition alertsmanagement.MonitorCondition, severity alertsmanagement.Severity, smartGroupState alertsmanagement.AlertState, timeRange alertsmanagement.TimeRange, pageCount *int32, sortBy alertsmanagement.SmartGroupsSortByFields, sortOrder string) (result alertsmanagement.SmartGroupsListPage, err error)
	GetAllComplete(ctx context.Context, targetResource string, targetResourceGroup string, targetResourceType string, monitorService alertsmanagement.MonitorService, monitorCondition alertsmanagement.MonitorCondition, severity alertsmanagement.Severity, smartGroupState alertsmanagement.AlertState, timeRange alertsmanagement.TimeRange, pageCount *int32, sortBy alertsmanagement.SmartGroupsSortByFields, sortOrder string) (result alertsmanagement.SmartGroupsListIterator, err error)
	GetByID(ctx context.Context, smartGroupID string) (result alertsmanagement.SmartGroup, err error)
	GetHistory(ctx context.Context, smartGroupID string) (result alertsmanagement.SmartGroupModification, err error)
}

var _ SmartGroupsClientAPI = (*alertsmanagement.SmartGroupsClient)(nil)

// SmartDetectorAlertRulesClientAPI contains the set of methods on the SmartDetectorAlertRulesClient type.
type SmartDetectorAlertRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, alertRuleName string, parameters alertsmanagement.AlertRule) (result alertsmanagement.AlertRule, err error)
	Delete(ctx context.Context, resourceGroupName string, alertRuleName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, alertRuleName string, expandDetector *bool) (result alertsmanagement.AlertRule, err error)
	List(ctx context.Context, expandDetector *bool) (result alertsmanagement.AlertRulesListPage, err error)
	ListComplete(ctx context.Context, expandDetector *bool) (result alertsmanagement.AlertRulesListIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, expandDetector *bool) (result alertsmanagement.AlertRulesListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, expandDetector *bool) (result alertsmanagement.AlertRulesListIterator, err error)
	Patch(ctx context.Context, resourceGroupName string, alertRuleName string, parameters alertsmanagement.AlertRulePatchObject) (result alertsmanagement.AlertRule, err error)
}

var _ SmartDetectorAlertRulesClientAPI = (*alertsmanagement.SmartDetectorAlertRulesClient)(nil)
