package jobapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/datalake/analytics/2016-11-01/job"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/gofrs/uuid"
)

// PipelineClientAPI contains the set of methods on the PipelineClient type.
type PipelineClientAPI interface {
	Get(ctx context.Context, accountName string, pipelineIdentity uuid.UUID, startDateTime *date.Time, endDateTime *date.Time) (result job.PipelineInformation, err error)
	List(ctx context.Context, accountName string, startDateTime *date.Time, endDateTime *date.Time) (result job.PipelineInformationListResultPage, err error)
	ListComplete(ctx context.Context, accountName string, startDateTime *date.Time, endDateTime *date.Time) (result job.PipelineInformationListResultIterator, err error)
}

var _ PipelineClientAPI = (*job.PipelineClient)(nil)

// RecurrenceClientAPI contains the set of methods on the RecurrenceClient type.
type RecurrenceClientAPI interface {
	Get(ctx context.Context, accountName string, recurrenceIdentity uuid.UUID, startDateTime *date.Time, endDateTime *date.Time) (result job.RecurrenceInformation, err error)
	List(ctx context.Context, accountName string, startDateTime *date.Time, endDateTime *date.Time) (result job.RecurrenceInformationListResultPage, err error)
	ListComplete(ctx context.Context, accountName string, startDateTime *date.Time, endDateTime *date.Time) (result job.RecurrenceInformationListResultIterator, err error)
}

var _ RecurrenceClientAPI = (*job.RecurrenceClient)(nil)

// ClientAPI contains the set of methods on the Client type.
type ClientAPI interface {
	Build(ctx context.Context, accountName string, parameters job.BuildJobParameters) (result job.Information, err error)
	Cancel(ctx context.Context, accountName string, jobIdentity uuid.UUID) (result autorest.Response, err error)
	Create(ctx context.Context, accountName string, jobIdentity uuid.UUID, parameters job.CreateJobParameters) (result job.Information, err error)
	Get(ctx context.Context, accountName string, jobIdentity uuid.UUID) (result job.Information, err error)
	GetDebugDataPath(ctx context.Context, accountName string, jobIdentity uuid.UUID) (result job.DataPath, err error)
	GetStatistics(ctx context.Context, accountName string, jobIdentity uuid.UUID) (result job.Statistics, err error)
	List(ctx context.Context, accountName string, filter string, top *int32, skip *int32, selectParameter string, orderby string, count *bool) (result job.InfoListResultPage, err error)
	ListComplete(ctx context.Context, accountName string, filter string, top *int32, skip *int32, selectParameter string, orderby string, count *bool) (result job.InfoListResultIterator, err error)
}

var _ ClientAPI = (*job.Client)(nil)
