package databoxedge

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/databoxedge/mgmt/2020-12-01/databoxedge"

// BasicAddon role Addon
type BasicAddon interface {
	AsArcAddon() (*ArcAddon, bool)
	AsIoTAddon() (*IoTAddon, bool)
	AsAddon() (*Addon, bool)
}

// Addon role Addon
type Addon struct {
	autorest.Response `json:"-"`
	// SystemData - Addon type
	SystemData *SystemData `json:"systemData,omitempty"`
	// Kind - Possible values include: 'KindAddon', 'KindArcForKubernetes', 'KindIotEdge'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

func unmarshalBasicAddon(body []byte) (BasicAddon, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindArcForKubernetes):
		var aa ArcAddon
		err := json.Unmarshal(body, &aa)
		return aa, err
	case string(KindIotEdge):
		var ita IoTAddon
		err := json.Unmarshal(body, &ita)
		return ita, err
	default:
		var a Addon
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicAddonArray(body []byte) ([]BasicAddon, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAddon, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAddon(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Addon.
func (a Addon) MarshalJSON() ([]byte, error) {
	a.Kind = KindAddon
	objectMap := make(map[string]interface{})
	if a.SystemData != nil {
		objectMap["systemData"] = a.SystemData
	}
	if a.Kind != "" {
		objectMap["kind"] = a.Kind
	}
	return json.Marshal(objectMap)
}

// AsArcAddon is the BasicAddon implementation for Addon.
func (a Addon) AsArcAddon() (*ArcAddon, bool) {
	return nil, false
}

// AsIoTAddon is the BasicAddon implementation for Addon.
func (a Addon) AsIoTAddon() (*IoTAddon, bool) {
	return nil, false
}

// AsAddon is the BasicAddon implementation for Addon.
func (a Addon) AsAddon() (*Addon, bool) {
	return &a, true
}

// AsBasicAddon is the BasicAddon implementation for Addon.
func (a Addon) AsBasicAddon() (BasicAddon, bool) {
	return &a, true
}

// AddonList collection of all the Role addon on the Azure Stack Edge device.
type AddonList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The Value.
	Value *[]BasicAddon `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AddonList struct.
func (al *AddonList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicAddonArray(*v)
				if err != nil {
					return err
				}
				al.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				al.NextLink = &nextLink
			}
		}
	}

	return nil
}

// AddonListIterator provides access to a complete listing of Addon values.
type AddonListIterator struct {
	i    int
	page AddonListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AddonListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddonListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AddonListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AddonListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AddonListIterator) Response() AddonList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AddonListIterator) Value() BasicAddon {
	if !iter.page.NotDone() {
		return Addon{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AddonListIterator type.
func NewAddonListIterator(page AddonListPage) AddonListIterator {
	return AddonListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AddonList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al AddonList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// addonListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AddonList) addonListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AddonListPage contains a page of BasicAddon values.
type AddonListPage struct {
	fn func(context.Context, AddonList) (AddonList, error)
	al AddonList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AddonListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddonListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AddonListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AddonListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AddonListPage) Response() AddonList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AddonListPage) Values() []BasicAddon {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AddonListPage type.
func NewAddonListPage(cur AddonList, getNextPage func(context.Context, AddonList) (AddonList, error)) AddonListPage {
	return AddonListPage{
		fn: getNextPage,
		al: cur,
	}
}

// AddonModel ...
type AddonModel struct {
	autorest.Response `json:"-"`
	Value             BasicAddon `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AddonModel struct.
func (am *AddonModel) UnmarshalJSON(body []byte) error {
	a, err := unmarshalBasicAddon(body)
	if err != nil {
		return err
	}
	am.Value = a

	return nil
}

// AddonsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AddonsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AddonsClient) (AddonModel, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AddonsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AddonsCreateOrUpdateFuture.Result.
func (future *AddonsCreateOrUpdateFuture) result(client AddonsClient) (am AddonModel, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.AddonsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.AddonsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if am.Response.Response, err = future.GetResult(sender); err == nil && am.Response.Response.StatusCode != http.StatusNoContent {
		am, err = client.CreateOrUpdateResponder(am.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.AddonsCreateOrUpdateFuture", "Result", am.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AddonsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type AddonsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AddonsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AddonsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AddonsDeleteFuture.Result.
func (future *AddonsDeleteFuture) result(client AddonsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.AddonsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.AddonsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Address the shipping address of the customer.
type Address struct {
	// AddressLine1 - The address line1.
	AddressLine1 *string `json:"addressLine1,omitempty"`
	// AddressLine2 - The address line2.
	AddressLine2 *string `json:"addressLine2,omitempty"`
	// AddressLine3 - The address line3.
	AddressLine3 *string `json:"addressLine3,omitempty"`
	// PostalCode - The postal code.
	PostalCode *string `json:"postalCode,omitempty"`
	// City - The city name.
	City *string `json:"city,omitempty"`
	// State - The state name.
	State *string `json:"state,omitempty"`
	// Country - The country name.
	Country *string `json:"country,omitempty"`
}

// Alert alert on the data box edge/gateway device.
type Alert struct {
	autorest.Response `json:"-"`
	// SystemData - Alert generated in the resource
	SystemData *SystemData `json:"systemData,omitempty"`
	// AlertProperties - READ-ONLY; Properties of alert.
	*AlertProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Alert.
func (a Alert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.SystemData != nil {
		objectMap["systemData"] = a.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Alert struct.
func (a *Alert) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				a.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var alertProperties AlertProperties
				err = json.Unmarshal(*v, &alertProperties)
				if err != nil {
					return err
				}
				a.AlertProperties = &alertProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AlertErrorDetails error details for the alert.
type AlertErrorDetails struct {
	// ErrorCode - READ-ONLY; Error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - READ-ONLY; Error Message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Occurrences - READ-ONLY; Number of occurrences.
	Occurrences *int32 `json:"occurrences,omitempty"`
}

// AlertList collection of alerts.
type AlertList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The value.
	Value *[]Alert `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AlertListIterator provides access to a complete listing of Alert values.
type AlertListIterator struct {
	i    int
	page AlertListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertListIterator) Response() AlertList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertListIterator) Value() Alert {
	if !iter.page.NotDone() {
		return Alert{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertListIterator type.
func NewAlertListIterator(page AlertListPage) AlertListIterator {
	return AlertListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AlertList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al AlertList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// alertListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AlertList) alertListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AlertListPage contains a page of Alert values.
type AlertListPage struct {
	fn func(context.Context, AlertList) (AlertList, error)
	al AlertList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertListPage) Response() AlertList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertListPage) Values() []Alert {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AlertListPage type.
func NewAlertListPage(cur AlertList, getNextPage func(context.Context, AlertList) (AlertList, error)) AlertListPage {
	return AlertListPage{
		fn: getNextPage,
		al: cur,
	}
}

// AlertProperties properties of alert.
type AlertProperties struct {
	// Title - READ-ONLY; Alert title.
	Title *string `json:"title,omitempty"`
	// AlertType - READ-ONLY; Alert type.
	AlertType *string `json:"alertType,omitempty"`
	// AppearedAtDateTime - READ-ONLY; UTC time when the alert appeared.
	AppearedAtDateTime *date.Time `json:"appearedAtDateTime,omitempty"`
	// Recommendation - READ-ONLY; Alert recommendation.
	Recommendation *string `json:"recommendation,omitempty"`
	// Severity - READ-ONLY; Severity of the alert. Possible values include: 'Informational', 'Warning', 'Critical'
	Severity AlertSeverity `json:"severity,omitempty"`
	// ErrorDetails - READ-ONLY; Error details of the alert.
	ErrorDetails *AlertErrorDetails `json:"errorDetails,omitempty"`
	// DetailedInformation - READ-ONLY; Alert details.
	DetailedInformation map[string]*string `json:"detailedInformation"`
}

// MarshalJSON is the custom marshaler for AlertProperties.
func (ap AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ArcAddon arc Addon.
type ArcAddon struct {
	// ArcAddonProperties - Properties specific to Arc addon.
	*ArcAddonProperties `json:"properties,omitempty"`
	// SystemData - Addon type
	SystemData *SystemData `json:"systemData,omitempty"`
	// Kind - Possible values include: 'KindAddon', 'KindArcForKubernetes', 'KindIotEdge'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ArcAddon.
func (aa ArcAddon) MarshalJSON() ([]byte, error) {
	aa.Kind = KindArcForKubernetes
	objectMap := make(map[string]interface{})
	if aa.ArcAddonProperties != nil {
		objectMap["properties"] = aa.ArcAddonProperties
	}
	if aa.SystemData != nil {
		objectMap["systemData"] = aa.SystemData
	}
	if aa.Kind != "" {
		objectMap["kind"] = aa.Kind
	}
	return json.Marshal(objectMap)
}

// AsArcAddon is the BasicAddon implementation for ArcAddon.
func (aa ArcAddon) AsArcAddon() (*ArcAddon, bool) {
	return &aa, true
}

// AsIoTAddon is the BasicAddon implementation for ArcAddon.
func (aa ArcAddon) AsIoTAddon() (*IoTAddon, bool) {
	return nil, false
}

// AsAddon is the BasicAddon implementation for ArcAddon.
func (aa ArcAddon) AsAddon() (*Addon, bool) {
	return nil, false
}

// AsBasicAddon is the BasicAddon implementation for ArcAddon.
func (aa ArcAddon) AsBasicAddon() (BasicAddon, bool) {
	return &aa, true
}

// UnmarshalJSON is the custom unmarshaler for ArcAddon struct.
func (aa *ArcAddon) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var arcAddonProperties ArcAddonProperties
				err = json.Unmarshal(*v, &arcAddonProperties)
				if err != nil {
					return err
				}
				aa.ArcAddonProperties = &arcAddonProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				aa.SystemData = &systemData
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				aa.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aa.Type = &typeVar
			}
		}
	}

	return nil
}

// ArcAddonProperties arc addon properties.
type ArcAddonProperties struct {
	// SubscriptionID - Arc resource subscription Id
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroupName - Arc resource group name
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// ResourceName - Arc resource Name
	ResourceName *string `json:"resourceName,omitempty"`
	// ResourceLocation - Arc resource location
	ResourceLocation *string `json:"resourceLocation,omitempty"`
	// Version - READ-ONLY; Arc resource version
	Version *string `json:"version,omitempty"`
	// HostPlatform - READ-ONLY; Host OS supported by the Arc addon. Possible values include: 'Windows', 'Linux'
	HostPlatform PlatformType `json:"hostPlatform,omitempty"`
	// HostPlatformType - READ-ONLY; Platform where the runtime is hosted. Possible values include: 'KubernetesCluster', 'LinuxVM'
	HostPlatformType HostPlatformType `json:"hostPlatformType,omitempty"`
	// ProvisioningState - READ-ONLY; Addon Provisioning State. Possible values include: 'Invalid', 'Creating', 'Created', 'Updating', 'Reconfiguring', 'Failed', 'Deleting'
	ProvisioningState AddonState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ArcAddonProperties.
func (aap ArcAddonProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aap.SubscriptionID != nil {
		objectMap["subscriptionId"] = aap.SubscriptionID
	}
	if aap.ResourceGroupName != nil {
		objectMap["resourceGroupName"] = aap.ResourceGroupName
	}
	if aap.ResourceName != nil {
		objectMap["resourceName"] = aap.ResourceName
	}
	if aap.ResourceLocation != nil {
		objectMap["resourceLocation"] = aap.ResourceLocation
	}
	return json.Marshal(objectMap)
}

// ARMBaseModel represents the base class for all object models.
type ARMBaseModel struct {
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// AsymmetricEncryptedSecret represent the secrets intended for encryption with asymmetric key pair.
type AsymmetricEncryptedSecret struct {
	// Value - The value of the secret.
	Value *string `json:"value,omitempty"`
	// EncryptionCertThumbprint - Thumbprint certificate used to encrypt \"Value\". If the value is unencrypted, it will be null.
	EncryptionCertThumbprint *string `json:"encryptionCertThumbprint,omitempty"`
	// EncryptionAlgorithm - The algorithm used to encrypt "Value". Possible values include: 'None', 'AES256', 'RSAESPKCS1V15'
	EncryptionAlgorithm EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`
}

// Authentication authentication mechanism for IoT devices.
type Authentication struct {
	// SymmetricKey - Symmetric key for authentication.
	SymmetricKey *SymmetricKey `json:"symmetricKey,omitempty"`
}

// AzureContainerInfo azure container mapping of the endpoint.
type AzureContainerInfo struct {
	// StorageAccountCredentialID - ID of the storage account credential used to access storage.
	StorageAccountCredentialID *string `json:"storageAccountCredentialId,omitempty"`
	// ContainerName - Container name (Based on the data format specified, this represents the name of Azure Files/Page blob/Block blob).
	ContainerName *string `json:"containerName,omitempty"`
	// DataFormat - Storage format used for the file represented by the share. Possible values include: 'BlockBlob', 'PageBlob', 'AzureFile'
	DataFormat AzureContainerDataFormat `json:"dataFormat,omitempty"`
}

// BandwidthSchedule the bandwidth schedule details.
type BandwidthSchedule struct {
	autorest.Response `json:"-"`
	// SystemData - Bandwidth object related to ASE resource
	SystemData *SystemData `json:"systemData,omitempty"`
	// BandwidthScheduleProperties - The properties of the bandwidth schedule.
	*BandwidthScheduleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BandwidthSchedule.
func (bs BandwidthSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bs.SystemData != nil {
		objectMap["systemData"] = bs.SystemData
	}
	if bs.BandwidthScheduleProperties != nil {
		objectMap["properties"] = bs.BandwidthScheduleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BandwidthSchedule struct.
func (bs *BandwidthSchedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				bs.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var bandwidthScheduleProperties BandwidthScheduleProperties
				err = json.Unmarshal(*v, &bandwidthScheduleProperties)
				if err != nil {
					return err
				}
				bs.BandwidthScheduleProperties = &bandwidthScheduleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bs.Type = &typeVar
			}
		}
	}

	return nil
}

// BandwidthScheduleProperties the properties of the bandwidth schedule.
type BandwidthScheduleProperties struct {
	// Start - The start time of the schedule in UTC.
	Start *string `json:"start,omitempty"`
	// Stop - The stop time of the schedule in UTC.
	Stop *string `json:"stop,omitempty"`
	// RateInMbps - The bandwidth rate in Mbps.
	RateInMbps *int32 `json:"rateInMbps,omitempty"`
	// Days - The days of the week when this schedule is applicable.
	Days *[]DayOfWeek `json:"days,omitempty"`
}

// BandwidthSchedulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BandwidthSchedulesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BandwidthSchedulesClient) (BandwidthSchedule, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BandwidthSchedulesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BandwidthSchedulesCreateOrUpdateFuture.Result.
func (future *BandwidthSchedulesCreateOrUpdateFuture) result(client BandwidthSchedulesClient) (bs BandwidthSchedule, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.BandwidthSchedulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.BandwidthSchedulesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bs.Response.Response, err = future.GetResult(sender); err == nil && bs.Response.Response.StatusCode != http.StatusNoContent {
		bs, err = client.CreateOrUpdateResponder(bs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.BandwidthSchedulesCreateOrUpdateFuture", "Result", bs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BandwidthSchedulesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BandwidthSchedulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BandwidthSchedulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BandwidthSchedulesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BandwidthSchedulesDeleteFuture.Result.
func (future *BandwidthSchedulesDeleteFuture) result(client BandwidthSchedulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.BandwidthSchedulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.BandwidthSchedulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BandwidthSchedulesList the collection of bandwidth schedules.
type BandwidthSchedulesList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of bandwidth schedules.
	Value *[]BandwidthSchedule `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BandwidthSchedulesListIterator provides access to a complete listing of BandwidthSchedule values.
type BandwidthSchedulesListIterator struct {
	i    int
	page BandwidthSchedulesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BandwidthSchedulesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BandwidthSchedulesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BandwidthSchedulesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BandwidthSchedulesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BandwidthSchedulesListIterator) Response() BandwidthSchedulesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BandwidthSchedulesListIterator) Value() BandwidthSchedule {
	if !iter.page.NotDone() {
		return BandwidthSchedule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BandwidthSchedulesListIterator type.
func NewBandwidthSchedulesListIterator(page BandwidthSchedulesListPage) BandwidthSchedulesListIterator {
	return BandwidthSchedulesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bsl BandwidthSchedulesList) IsEmpty() bool {
	return bsl.Value == nil || len(*bsl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bsl BandwidthSchedulesList) hasNextLink() bool {
	return bsl.NextLink != nil && len(*bsl.NextLink) != 0
}

// bandwidthSchedulesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bsl BandwidthSchedulesList) bandwidthSchedulesListPreparer(ctx context.Context) (*http.Request, error) {
	if !bsl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bsl.NextLink)))
}

// BandwidthSchedulesListPage contains a page of BandwidthSchedule values.
type BandwidthSchedulesListPage struct {
	fn  func(context.Context, BandwidthSchedulesList) (BandwidthSchedulesList, error)
	bsl BandwidthSchedulesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BandwidthSchedulesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BandwidthSchedulesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bsl)
		if err != nil {
			return err
		}
		page.bsl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BandwidthSchedulesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BandwidthSchedulesListPage) NotDone() bool {
	return !page.bsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BandwidthSchedulesListPage) Response() BandwidthSchedulesList {
	return page.bsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BandwidthSchedulesListPage) Values() []BandwidthSchedule {
	if page.bsl.IsEmpty() {
		return nil
	}
	return *page.bsl.Value
}

// Creates a new instance of the BandwidthSchedulesListPage type.
func NewBandwidthSchedulesListPage(cur BandwidthSchedulesList, getNextPage func(context.Context, BandwidthSchedulesList) (BandwidthSchedulesList, error)) BandwidthSchedulesListPage {
	return BandwidthSchedulesListPage{
		fn:  getNextPage,
		bsl: cur,
	}
}

// ClientAccessRight the mapping between a particular client IP and the type of access client has on the
// NFS share.
type ClientAccessRight struct {
	// Client - IP of the client.
	Client *string `json:"client,omitempty"`
	// AccessPermission - Type of access to be allowed for the client. Possible values include: 'NoAccess', 'ReadOnly', 'ReadWrite'
	AccessPermission ClientPermissionType `json:"accessPermission,omitempty"`
}

// CloudEdgeManagementRole cloudEdgeManagementRole role.
type CloudEdgeManagementRole struct {
	// CloudEdgeManagementRoleProperties - Properties specific to CloudEdgeManagementRole role.
	*CloudEdgeManagementRoleProperties `json:"properties,omitempty"`
	// SystemData - Role configured on ASE resource
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindRole', 'KindCloudEdgeManagement', 'KindIOT', 'KindKubernetes', 'KindMEC'
	Kind KindBasicRole `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudEdgeManagementRole.
func (cemr CloudEdgeManagementRole) MarshalJSON() ([]byte, error) {
	cemr.Kind = KindCloudEdgeManagement
	objectMap := make(map[string]interface{})
	if cemr.CloudEdgeManagementRoleProperties != nil {
		objectMap["properties"] = cemr.CloudEdgeManagementRoleProperties
	}
	if cemr.SystemData != nil {
		objectMap["systemData"] = cemr.SystemData
	}
	if cemr.Kind != "" {
		objectMap["kind"] = cemr.Kind
	}
	return json.Marshal(objectMap)
}

// AsCloudEdgeManagementRole is the BasicRole implementation for CloudEdgeManagementRole.
func (cemr CloudEdgeManagementRole) AsCloudEdgeManagementRole() (*CloudEdgeManagementRole, bool) {
	return &cemr, true
}

// AsIoTRole is the BasicRole implementation for CloudEdgeManagementRole.
func (cemr CloudEdgeManagementRole) AsIoTRole() (*IoTRole, bool) {
	return nil, false
}

// AsKubernetesRole is the BasicRole implementation for CloudEdgeManagementRole.
func (cemr CloudEdgeManagementRole) AsKubernetesRole() (*KubernetesRole, bool) {
	return nil, false
}

// AsMECRole is the BasicRole implementation for CloudEdgeManagementRole.
func (cemr CloudEdgeManagementRole) AsMECRole() (*MECRole, bool) {
	return nil, false
}

// AsRole is the BasicRole implementation for CloudEdgeManagementRole.
func (cemr CloudEdgeManagementRole) AsRole() (*Role, bool) {
	return nil, false
}

// AsBasicRole is the BasicRole implementation for CloudEdgeManagementRole.
func (cemr CloudEdgeManagementRole) AsBasicRole() (BasicRole, bool) {
	return &cemr, true
}

// UnmarshalJSON is the custom unmarshaler for CloudEdgeManagementRole struct.
func (cemr *CloudEdgeManagementRole) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cloudEdgeManagementRoleProperties CloudEdgeManagementRoleProperties
				err = json.Unmarshal(*v, &cloudEdgeManagementRoleProperties)
				if err != nil {
					return err
				}
				cemr.CloudEdgeManagementRoleProperties = &cloudEdgeManagementRoleProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				cemr.SystemData = &systemData
			}
		case "kind":
			if v != nil {
				var kind KindBasicRole
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cemr.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cemr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cemr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cemr.Type = &typeVar
			}
		}
	}

	return nil
}

// CloudEdgeManagementRoleProperties cloudEdgeManagement Role properties.
type CloudEdgeManagementRoleProperties struct {
	// LocalManagementStatus - READ-ONLY; Local Edge Management Status. Possible values include: 'RoleStatusEnabled', 'RoleStatusDisabled'
	LocalManagementStatus RoleStatus `json:"localManagementStatus,omitempty"`
	// EdgeProfile - READ-ONLY; Edge Profile of the resource
	EdgeProfile *EdgeProfile `json:"edgeProfile,omitempty"`
	// RoleStatus - Role status. Possible values include: 'RoleStatusEnabled', 'RoleStatusDisabled'
	RoleStatus RoleStatus `json:"roleStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudEdgeManagementRoleProperties.
func (cemrp CloudEdgeManagementRoleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cemrp.RoleStatus != "" {
		objectMap["roleStatus"] = cemrp.RoleStatus
	}
	return json.Marshal(objectMap)
}

// CloudError an error response from the service.
type CloudError struct {
	// Error - The error details.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// CniConfig cni configuration
type CniConfig struct {
	// Type - READ-ONLY; Cni type
	Type *string `json:"type,omitempty"`
	// Version - READ-ONLY; Cni version
	Version *string `json:"version,omitempty"`
	// PodSubnet - READ-ONLY; Pod Subnet
	PodSubnet *string `json:"podSubnet,omitempty"`
	// ServiceSubnet - READ-ONLY; Service subnet
	ServiceSubnet *string `json:"serviceSubnet,omitempty"`
}

// ComputeResource compute infrastructure Resource
type ComputeResource struct {
	// ProcessorCount - Processor count
	ProcessorCount *int32 `json:"processorCount,omitempty"`
	// MemoryInGB - Memory in GB
	MemoryInGB *int64 `json:"memoryInGB,omitempty"`
}

// ContactDetails contains all the contact details of the customer.
type ContactDetails struct {
	// ContactPerson - The contact person name.
	ContactPerson *string `json:"contactPerson,omitempty"`
	// CompanyName - The name of the company.
	CompanyName *string `json:"companyName,omitempty"`
	// Phone - The phone number.
	Phone *string `json:"phone,omitempty"`
	// EmailList - The email list.
	EmailList *[]string `json:"emailList,omitempty"`
}

// Container represents a container on the  Data Box Edge/Gateway device.
type Container struct {
	autorest.Response `json:"-"`
	// SystemData - Container in DataBoxEdge Resource
	SystemData *SystemData `json:"systemData,omitempty"`
	// ContainerProperties - The container properties.
	*ContainerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Container.
func (c Container) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.SystemData != nil {
		objectMap["systemData"] = c.SystemData
	}
	if c.ContainerProperties != nil {
		objectMap["properties"] = c.ContainerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Container struct.
func (c *Container) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				c.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var containerProperties ContainerProperties
				err = json.Unmarshal(*v, &containerProperties)
				if err != nil {
					return err
				}
				c.ContainerProperties = &containerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ContainerList collection of all the containers on the Data Box Edge/Gateway device.
type ContainerList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of containers.
	Value *[]Container `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ContainerListIterator provides access to a complete listing of Container values.
type ContainerListIterator struct {
	i    int
	page ContainerListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ContainerListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContainerListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ContainerListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ContainerListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ContainerListIterator) Response() ContainerList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ContainerListIterator) Value() Container {
	if !iter.page.NotDone() {
		return Container{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ContainerListIterator type.
func NewContainerListIterator(page ContainerListPage) ContainerListIterator {
	return ContainerListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl ContainerList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cl ContainerList) hasNextLink() bool {
	return cl.NextLink != nil && len(*cl.NextLink) != 0
}

// containerListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl ContainerList) containerListPreparer(ctx context.Context) (*http.Request, error) {
	if !cl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// ContainerListPage contains a page of Container values.
type ContainerListPage struct {
	fn func(context.Context, ContainerList) (ContainerList, error)
	cl ContainerList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ContainerListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContainerListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cl)
		if err != nil {
			return err
		}
		page.cl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ContainerListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ContainerListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ContainerListPage) Response() ContainerList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ContainerListPage) Values() []Container {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the ContainerListPage type.
func NewContainerListPage(cur ContainerList, getNextPage func(context.Context, ContainerList) (ContainerList, error)) ContainerListPage {
	return ContainerListPage{
		fn: getNextPage,
		cl: cur,
	}
}

// ContainerProperties the container properties.
type ContainerProperties struct {
	// ContainerStatus - READ-ONLY; Current status of the container. Possible values include: 'ContainerStatusOK', 'ContainerStatusOffline', 'ContainerStatusUnknown', 'ContainerStatusUpdating', 'ContainerStatusNeedsAttention'
	ContainerStatus ContainerStatus `json:"containerStatus,omitempty"`
	// DataFormat - DataFormat for Container. Possible values include: 'BlockBlob', 'PageBlob', 'AzureFile'
	DataFormat AzureContainerDataFormat `json:"dataFormat,omitempty"`
	// RefreshDetails - READ-ONLY; Details of the refresh job on this container.
	RefreshDetails *RefreshDetails `json:"refreshDetails,omitempty"`
	// CreatedDateTime - READ-ONLY; The UTC time when container got created.
	CreatedDateTime *date.Time `json:"createdDateTime,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerProperties.
func (cp ContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.DataFormat != "" {
		objectMap["dataFormat"] = cp.DataFormat
	}
	return json.Marshal(objectMap)
}

// ContainersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ContainersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ContainersClient) (Container, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ContainersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ContainersCreateOrUpdateFuture.Result.
func (future *ContainersCreateOrUpdateFuture) result(client ContainersClient) (c Container, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.ContainersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.ContainersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateOrUpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.ContainersCreateOrUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ContainersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ContainersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ContainersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ContainersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ContainersDeleteFuture.Result.
func (future *ContainersDeleteFuture) result(client ContainersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.ContainersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.ContainersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ContainersRefreshFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ContainersRefreshFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ContainersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ContainersRefreshFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ContainersRefreshFuture.Result.
func (future *ContainersRefreshFuture) result(client ContainersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.ContainersRefreshFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.ContainersRefreshFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DCAccessCode DC Access code in the case of Self Managed Shipping.
type DCAccessCode struct {
	autorest.Response `json:"-"`
	// DCAccessCodeProperties - DCAccessCode properties.
	*DCAccessCodeProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DCAccessCode.
func (dac DCAccessCode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dac.DCAccessCodeProperties != nil {
		objectMap["properties"] = dac.DCAccessCodeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DCAccessCode struct.
func (dac *DCAccessCode) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dCAccessCodeProperties DCAccessCodeProperties
				err = json.Unmarshal(*v, &dCAccessCodeProperties)
				if err != nil {
					return err
				}
				dac.DCAccessCodeProperties = &dCAccessCodeProperties
			}
		}
	}

	return nil
}

// DCAccessCodeProperties dCAccessCode Properties.
type DCAccessCodeProperties struct {
	// AuthCode - DCAccess Code for the Self Managed shipment.
	AuthCode *string `json:"authCode,omitempty"`
}

// Device the Data Box Edge/Gateway device.
type Device struct {
	autorest.Response `json:"-"`
	// Location - The location of the device. This is a supported and registered Azure geographical region (for example, West US, East US, or Southeast Asia). The geographical region of a device cannot be changed once it is created, but if an identical geographical region is specified on update, the request will succeed.
	Location *string `json:"location,omitempty"`
	// Tags - The list of tags that describe the device. These tags can be used to view and group this device (across resource groups).
	Tags map[string]*string `json:"tags"`
	// Sku - The SKU type.
	Sku *Sku `json:"sku,omitempty"`
	// Etag - The etag for the devices.
	Etag *string `json:"etag,omitempty"`
	// Identity - Msi identity of the resource
	Identity *ResourceIdentity `json:"identity,omitempty"`
	// Kind - READ-ONLY; The etag for the devices. Possible values include: 'AzureDataBoxGateway', 'AzureStackEdge', 'AzureStackHub', 'AzureModularDataCentre'
	Kind DeviceKind `json:"kind,omitempty"`
	// SystemData - DataBoxEdge Resource
	SystemData *SystemData `json:"systemData,omitempty"`
	// DeviceProperties - READ-ONLY; The properties of the Data Box Edge/Gateway device.
	*DeviceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Device.
func (d Device) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	if d.Sku != nil {
		objectMap["sku"] = d.Sku
	}
	if d.Etag != nil {
		objectMap["etag"] = d.Etag
	}
	if d.Identity != nil {
		objectMap["identity"] = d.Identity
	}
	if d.SystemData != nil {
		objectMap["systemData"] = d.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Device struct.
func (d *Device) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				d.Sku = &sku
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				d.Etag = &etag
			}
		case "identity":
			if v != nil {
				var identity ResourceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				d.Identity = &identity
			}
		case "kind":
			if v != nil {
				var kind DeviceKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				d.Kind = kind
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				d.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var deviceProperties DeviceProperties
				err = json.Unmarshal(*v, &deviceProperties)
				if err != nil {
					return err
				}
				d.DeviceProperties = &deviceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DeviceExtendedInfo the extended Info of the Data Box Edge/Gateway device.
type DeviceExtendedInfo struct {
	autorest.Response `json:"-"`
	// DeviceExtendedInfoProperties - The extended info properties.
	*DeviceExtendedInfoProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DeviceExtendedInfo.
func (dei DeviceExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dei.DeviceExtendedInfoProperties != nil {
		objectMap["properties"] = dei.DeviceExtendedInfoProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DeviceExtendedInfo struct.
func (dei *DeviceExtendedInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var deviceExtendedInfoProperties DeviceExtendedInfoProperties
				err = json.Unmarshal(*v, &deviceExtendedInfoProperties)
				if err != nil {
					return err
				}
				dei.DeviceExtendedInfoProperties = &deviceExtendedInfoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dei.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dei.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dei.Type = &typeVar
			}
		}
	}

	return nil
}

// DeviceExtendedInfoPatch the Data Box Edge/Gateway device extended info patch.
type DeviceExtendedInfoPatch struct {
	// ClientSecretStoreID - The Key Vault ARM Id for client secrets
	ClientSecretStoreID *string `json:"clientSecretStoreId,omitempty"`
	// ClientSecretStoreURL - The url to access the Client Key Vault
	ClientSecretStoreURL *string `json:"clientSecretStoreUrl,omitempty"`
	// ChannelIntegrityKeyName - The name for Channel Integrity Key stored in the Client Key Vault
	ChannelIntegrityKeyName *string `json:"channelIntegrityKeyName,omitempty"`
	// ChannelIntegrityKeyVersion - The version of Channel Integrity Key stored in the Client Key Vault
	ChannelIntegrityKeyVersion *string `json:"channelIntegrityKeyVersion,omitempty"`
	// SyncStatus - For changing or to initiate the resync to key-vault set the status to KeyVaultSyncPending, rest of the status will not be applicable. Possible values include: 'KeyVaultSynced', 'KeyVaultSyncFailed', 'KeyVaultNotConfigured', 'KeyVaultSyncPending', 'KeyVaultSyncing'
	SyncStatus KeyVaultSyncStatus `json:"syncStatus,omitempty"`
}

// DeviceExtendedInfoProperties the properties of the Data Box Edge/Gateway device extended info.
type DeviceExtendedInfoProperties struct {
	// EncryptionKeyThumbprint - The digital signature of encrypted certificate.
	EncryptionKeyThumbprint *string `json:"encryptionKeyThumbprint,omitempty"`
	// EncryptionKey - The public part of the encryption certificate. Client uses this to encrypt any secret.
	EncryptionKey *string `json:"encryptionKey,omitempty"`
	// ResourceKey - READ-ONLY; The Resource ID of the Resource.
	ResourceKey *string `json:"resourceKey,omitempty"`
	// ClientSecretStoreID - The Key Vault ARM Id for client secrets
	ClientSecretStoreID *string `json:"clientSecretStoreId,omitempty"`
	// ClientSecretStoreURL - The url to access the Client Key Vault
	ClientSecretStoreURL *string `json:"clientSecretStoreUrl,omitempty"`
	// ChannelIntegrityKeyName - The name of Channel Integrity Key stored in the Client Key Vault
	ChannelIntegrityKeyName *string `json:"channelIntegrityKeyName,omitempty"`
	// ChannelIntegrityKeyVersion - The version of Channel Integrity Key stored in the Client Key Vault
	ChannelIntegrityKeyVersion *string `json:"channelIntegrityKeyVersion,omitempty"`
	// KeyVaultSyncStatus - Key vault sync status. Possible values include: 'KeyVaultSynced', 'KeyVaultSyncFailed', 'KeyVaultNotConfigured', 'KeyVaultSyncPending', 'KeyVaultSyncing'
	KeyVaultSyncStatus KeyVaultSyncStatus `json:"keyVaultSyncStatus,omitempty"`
	// DeviceSecrets - READ-ONLY; Device secrets, will be returned only with ODataFilter $expand=deviceSecrets
	DeviceSecrets *DeviceSecrets `json:"deviceSecrets,omitempty"`
}

// MarshalJSON is the custom marshaler for DeviceExtendedInfoProperties.
func (deip DeviceExtendedInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if deip.EncryptionKeyThumbprint != nil {
		objectMap["encryptionKeyThumbprint"] = deip.EncryptionKeyThumbprint
	}
	if deip.EncryptionKey != nil {
		objectMap["encryptionKey"] = deip.EncryptionKey
	}
	if deip.ClientSecretStoreID != nil {
		objectMap["clientSecretStoreId"] = deip.ClientSecretStoreID
	}
	if deip.ClientSecretStoreURL != nil {
		objectMap["clientSecretStoreUrl"] = deip.ClientSecretStoreURL
	}
	if deip.ChannelIntegrityKeyName != nil {
		objectMap["channelIntegrityKeyName"] = deip.ChannelIntegrityKeyName
	}
	if deip.ChannelIntegrityKeyVersion != nil {
		objectMap["channelIntegrityKeyVersion"] = deip.ChannelIntegrityKeyVersion
	}
	if deip.KeyVaultSyncStatus != "" {
		objectMap["keyVaultSyncStatus"] = deip.KeyVaultSyncStatus
	}
	return json.Marshal(objectMap)
}

// DeviceList the collection of Data Box Edge/Gateway devices.
type DeviceList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of Data Box Edge/Gateway devices.
	Value *[]Device `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeviceListIterator provides access to a complete listing of Device values.
type DeviceListIterator struct {
	i    int
	page DeviceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeviceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeviceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeviceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeviceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeviceListIterator) Response() DeviceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeviceListIterator) Value() Device {
	if !iter.page.NotDone() {
		return Device{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeviceListIterator type.
func NewDeviceListIterator(page DeviceListPage) DeviceListIterator {
	return DeviceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dl DeviceList) IsEmpty() bool {
	return dl.Value == nil || len(*dl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dl DeviceList) hasNextLink() bool {
	return dl.NextLink != nil && len(*dl.NextLink) != 0
}

// deviceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dl DeviceList) deviceListPreparer(ctx context.Context) (*http.Request, error) {
	if !dl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dl.NextLink)))
}

// DeviceListPage contains a page of Device values.
type DeviceListPage struct {
	fn func(context.Context, DeviceList) (DeviceList, error)
	dl DeviceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeviceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeviceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dl)
		if err != nil {
			return err
		}
		page.dl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeviceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeviceListPage) NotDone() bool {
	return !page.dl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeviceListPage) Response() DeviceList {
	return page.dl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeviceListPage) Values() []Device {
	if page.dl.IsEmpty() {
		return nil
	}
	return *page.dl.Value
}

// Creates a new instance of the DeviceListPage type.
func NewDeviceListPage(cur DeviceList, getNextPage func(context.Context, DeviceList) (DeviceList, error)) DeviceListPage {
	return DeviceListPage{
		fn: getNextPage,
		dl: cur,
	}
}

// DevicePatch the Data Box Edge/Gateway device patch.
type DevicePatch struct {
	// Tags - The tags attached to the Data Box Edge/Gateway resource.
	Tags map[string]*string `json:"tags"`
	// Identity - Msi identity of the resource
	Identity *ResourceIdentity `json:"identity,omitempty"`
	// DevicePropertiesPatch - The properties associated with the Data Box Edge/Gateway resource
	*DevicePropertiesPatch `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DevicePatch.
func (dp DevicePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.Tags != nil {
		objectMap["tags"] = dp.Tags
	}
	if dp.Identity != nil {
		objectMap["identity"] = dp.Identity
	}
	if dp.DevicePropertiesPatch != nil {
		objectMap["properties"] = dp.DevicePropertiesPatch
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DevicePatch struct.
func (dp *DevicePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dp.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ResourceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				dp.Identity = &identity
			}
		case "properties":
			if v != nil {
				var devicePropertiesPatch DevicePropertiesPatch
				err = json.Unmarshal(*v, &devicePropertiesPatch)
				if err != nil {
					return err
				}
				dp.DevicePropertiesPatch = &devicePropertiesPatch
			}
		}
	}

	return nil
}

// DeviceProperties the properties of the Data Box Edge/Gateway device.
type DeviceProperties struct {
	// DataBoxEdgeDeviceStatus - The status of the Data Box Edge/Gateway device. Possible values include: 'ReadyToSetup', 'Online', 'Offline', 'NeedsAttention', 'Disconnected', 'PartiallyDisconnected', 'Maintenance'
	DataBoxEdgeDeviceStatus DeviceStatus `json:"dataBoxEdgeDeviceStatus,omitempty"`
	// SerialNumber - READ-ONLY; The Serial Number of Data Box Edge/Gateway device.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// Description - READ-ONLY; The Description of the Data Box Edge/Gateway device.
	Description *string `json:"description,omitempty"`
	// ModelDescription - READ-ONLY; The description of the Data Box Edge/Gateway device model.
	ModelDescription *string `json:"modelDescription,omitempty"`
	// DeviceType - READ-ONLY; The type of the Data Box Edge/Gateway device. Possible values include: 'DataBoxEdgeDevice'
	DeviceType DeviceType `json:"deviceType,omitempty"`
	// FriendlyName - READ-ONLY; The Data Box Edge/Gateway device name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// Culture - READ-ONLY; The Data Box Edge/Gateway device culture.
	Culture *string `json:"culture,omitempty"`
	// DeviceModel - READ-ONLY; The Data Box Edge/Gateway device model.
	DeviceModel *string `json:"deviceModel,omitempty"`
	// DeviceSoftwareVersion - READ-ONLY; The Data Box Edge/Gateway device software version.
	DeviceSoftwareVersion *string `json:"deviceSoftwareVersion,omitempty"`
	// DeviceLocalCapacity - READ-ONLY; The Data Box Edge/Gateway device local capacity in MB.
	DeviceLocalCapacity *int64 `json:"deviceLocalCapacity,omitempty"`
	// TimeZone - READ-ONLY; The Data Box Edge/Gateway device timezone.
	TimeZone *string `json:"timeZone,omitempty"`
	// DeviceHcsVersion - READ-ONLY; The device software version number of the device (eg: 1.2.18105.6).
	DeviceHcsVersion *string `json:"deviceHcsVersion,omitempty"`
	// ConfiguredRoleTypes - READ-ONLY; Type of compute roles configured.
	ConfiguredRoleTypes *[]RoleTypes `json:"configuredRoleTypes,omitempty"`
	// NodeCount - READ-ONLY; The number of nodes in the cluster.
	NodeCount *int32 `json:"nodeCount,omitempty"`
	// ResourceMoveDetails - READ-ONLY; The details of the move operation on this resource.
	ResourceMoveDetails *ResourceMoveDetails `json:"resourceMoveDetails,omitempty"`
	// EdgeProfile - READ-ONLY; The details of Edge Profile for this resource
	EdgeProfile *EdgeProfile `json:"edgeProfile,omitempty"`
}

// MarshalJSON is the custom marshaler for DeviceProperties.
func (dp DeviceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.DataBoxEdgeDeviceStatus != "" {
		objectMap["dataBoxEdgeDeviceStatus"] = dp.DataBoxEdgeDeviceStatus
	}
	return json.Marshal(objectMap)
}

// DevicePropertiesPatch the Data Box Edge/Gateway device properties patch.
type DevicePropertiesPatch struct {
	// EdgeProfile - Edge Profile property of the Data Box Edge/Gateway device
	EdgeProfile *EdgeProfilePatch `json:"edgeProfile,omitempty"`
}

// DevicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (Device, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesCreateOrUpdateFuture.Result.
func (future *DevicesCreateOrUpdateFuture) result(client DevicesClient) (d Device, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.DevicesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.DevicesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.DevicesCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DevicesCreateOrUpdateSecuritySettingsFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type DevicesCreateOrUpdateSecuritySettingsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesCreateOrUpdateSecuritySettingsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesCreateOrUpdateSecuritySettingsFuture.Result.
func (future *DevicesCreateOrUpdateSecuritySettingsFuture) result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.DevicesCreateOrUpdateSecuritySettingsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.DevicesCreateOrUpdateSecuritySettingsFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesDeleteFuture.Result.
func (future *DevicesDeleteFuture) result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.DevicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.DevicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesDownloadUpdatesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesDownloadUpdatesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesDownloadUpdatesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesDownloadUpdatesFuture.Result.
func (future *DevicesDownloadUpdatesFuture) result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.DevicesDownloadUpdatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.DevicesDownloadUpdatesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeviceSecrets device Secrets
type DeviceSecrets struct {
	// HcsDataVolumeBitLockerExternalKey - Keyvault Id of HcsDataVolumeBitLockerExternalKey
	HcsDataVolumeBitLockerExternalKey *Secret `json:"hcsDataVolumeBitLockerExternalKey,omitempty"`
	// HcsInternalVolumeBitLockerExternalKey - Keyvault Id of HcsInternalVolumeBitLockerExternalKey
	HcsInternalVolumeBitLockerExternalKey *Secret `json:"hcsInternalVolumeBitLockerExternalKey,omitempty"`
	// SystemVolumeBitLockerRecoveryKey - Keyvault Id of SystemVolumeBitLockerRecoveryKey
	SystemVolumeBitLockerRecoveryKey *Secret `json:"systemVolumeBitLockerRecoveryKey,omitempty"`
	// SedEncryptionExternalKeyID - Keyvault Id of SEDEncryptionExternalKeyId
	SedEncryptionExternalKeyID *Secret `json:"sedEncryptionExternalKeyId,omitempty"`
	// SedEncryptionExternalKey - Keyvault Id of SEDEncryptionExternalKey
	SedEncryptionExternalKey *Secret `json:"sedEncryptionExternalKey,omitempty"`
	// BmcDefaultUserPassword - Keyvault Id of BMCDefaultUserPassword
	BmcDefaultUserPassword *Secret `json:"bmcDefaultUserPassword,omitempty"`
	// RotateKeyForDataVolumeBitlocker - Keyvault Id of RotateKeyForDataVolumeBitlocker
	RotateKeyForDataVolumeBitlocker *Secret `json:"rotateKeyForDataVolumeBitlocker,omitempty"`
	// RotateKeysForSedDrivesSerialized - Keyvault Id of RotateKeysForSedDrivesSerialized
	RotateKeysForSedDrivesSerialized *Secret `json:"rotateKeysForSedDrivesSerialized,omitempty"`
}

// DevicesInstallUpdatesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesInstallUpdatesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesInstallUpdatesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesInstallUpdatesFuture.Result.
func (future *DevicesInstallUpdatesFuture) result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.DevicesInstallUpdatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.DevicesInstallUpdatesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesScanForUpdatesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesScanForUpdatesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesScanForUpdatesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesScanForUpdatesFuture.Result.
func (future *DevicesScanForUpdatesFuture) result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.DevicesScanForUpdatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.DevicesScanForUpdatesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EdgeProfile details about Edge Profile for the resource
type EdgeProfile struct {
	// Subscription - Edge Profile Subscription
	Subscription *EdgeProfileSubscription `json:"subscription,omitempty"`
}

// EdgeProfilePatch the Data Box Edge/Gateway Edge Profile patch.
type EdgeProfilePatch struct {
	// Subscription - The Data Box Edge/Gateway Edge Profile Subscription patch
	Subscription *EdgeProfileSubscriptionPatch `json:"subscription,omitempty"`
}

// EdgeProfileSubscription subscription details for the Edge Profile
type EdgeProfileSubscription struct {
	// RegistrationID - Edge Subscription Registration ID
	RegistrationID *string `json:"registrationId,omitempty"`
	// ID - ARM ID of the subscription
	ID *string `json:"id,omitempty"`
	// State - Possible values include: 'Registered', 'Warned', 'Suspended', 'Deleted', 'Unregistered'
	State                   SubscriptionState `json:"state,omitempty"`
	RegistrationDate        *string           `json:"registrationDate,omitempty"`
	SubscriptionID          *string           `json:"subscriptionId,omitempty"`
	*SubscriptionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for EdgeProfileSubscription.
func (eps EdgeProfileSubscription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eps.RegistrationID != nil {
		objectMap["registrationId"] = eps.RegistrationID
	}
	if eps.ID != nil {
		objectMap["id"] = eps.ID
	}
	if eps.State != "" {
		objectMap["state"] = eps.State
	}
	if eps.RegistrationDate != nil {
		objectMap["registrationDate"] = eps.RegistrationDate
	}
	if eps.SubscriptionID != nil {
		objectMap["subscriptionId"] = eps.SubscriptionID
	}
	if eps.SubscriptionProperties != nil {
		objectMap["properties"] = eps.SubscriptionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EdgeProfileSubscription struct.
func (eps *EdgeProfileSubscription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "registrationId":
			if v != nil {
				var registrationID string
				err = json.Unmarshal(*v, &registrationID)
				if err != nil {
					return err
				}
				eps.RegistrationID = &registrationID
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				eps.ID = &ID
			}
		case "state":
			if v != nil {
				var state SubscriptionState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				eps.State = state
			}
		case "registrationDate":
			if v != nil {
				var registrationDate string
				err = json.Unmarshal(*v, &registrationDate)
				if err != nil {
					return err
				}
				eps.RegistrationDate = &registrationDate
			}
		case "subscriptionId":
			if v != nil {
				var subscriptionID string
				err = json.Unmarshal(*v, &subscriptionID)
				if err != nil {
					return err
				}
				eps.SubscriptionID = &subscriptionID
			}
		case "properties":
			if v != nil {
				var subscriptionProperties SubscriptionProperties
				err = json.Unmarshal(*v, &subscriptionProperties)
				if err != nil {
					return err
				}
				eps.SubscriptionProperties = &subscriptionProperties
			}
		}
	}

	return nil
}

// EdgeProfileSubscriptionPatch the Data Box Edge/Gateway Edge Profile Subscription patch.
type EdgeProfileSubscriptionPatch struct {
	// ID - The path ID that uniquely identifies the subscription of the edge profile.
	ID *string `json:"id,omitempty"`
}

// EtcdInfo etcd configuration
type EtcdInfo struct {
	// Type - READ-ONLY; Etcd type
	Type *string `json:"type,omitempty"`
	// Version - READ-ONLY; Etcd version
	Version *string `json:"version,omitempty"`
}

// FileEventTrigger trigger details.
type FileEventTrigger struct {
	// FileTriggerProperties - File trigger properties.
	*FileTriggerProperties `json:"properties,omitempty"`
	// SystemData - Trigger in DataBoxEdge Resource
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindTrigger', 'KindFileEvent', 'KindPeriodicTimerEvent'
	Kind KindBasicTrigger `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for FileEventTrigger.
func (fet FileEventTrigger) MarshalJSON() ([]byte, error) {
	fet.Kind = KindFileEvent
	objectMap := make(map[string]interface{})
	if fet.FileTriggerProperties != nil {
		objectMap["properties"] = fet.FileTriggerProperties
	}
	if fet.SystemData != nil {
		objectMap["systemData"] = fet.SystemData
	}
	if fet.Kind != "" {
		objectMap["kind"] = fet.Kind
	}
	return json.Marshal(objectMap)
}

// AsFileEventTrigger is the BasicTrigger implementation for FileEventTrigger.
func (fet FileEventTrigger) AsFileEventTrigger() (*FileEventTrigger, bool) {
	return &fet, true
}

// AsPeriodicTimerEventTrigger is the BasicTrigger implementation for FileEventTrigger.
func (fet FileEventTrigger) AsPeriodicTimerEventTrigger() (*PeriodicTimerEventTrigger, bool) {
	return nil, false
}

// AsTrigger is the BasicTrigger implementation for FileEventTrigger.
func (fet FileEventTrigger) AsTrigger() (*Trigger, bool) {
	return nil, false
}

// AsBasicTrigger is the BasicTrigger implementation for FileEventTrigger.
func (fet FileEventTrigger) AsBasicTrigger() (BasicTrigger, bool) {
	return &fet, true
}

// UnmarshalJSON is the custom unmarshaler for FileEventTrigger struct.
func (fet *FileEventTrigger) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileTriggerProperties FileTriggerProperties
				err = json.Unmarshal(*v, &fileTriggerProperties)
				if err != nil {
					return err
				}
				fet.FileTriggerProperties = &fileTriggerProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				fet.SystemData = &systemData
			}
		case "kind":
			if v != nil {
				var kind KindBasicTrigger
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fet.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fet.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fet.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fet.Type = &typeVar
			}
		}
	}

	return nil
}

// FileSourceInfo file source details.
type FileSourceInfo struct {
	// ShareID - File share ID.
	ShareID *string `json:"shareId,omitempty"`
}

// FileTriggerProperties file trigger properties.
type FileTriggerProperties struct {
	// SourceInfo - File event source details.
	SourceInfo *FileSourceInfo `json:"sourceInfo,omitempty"`
	// SinkInfo - Role sink info.
	SinkInfo *RoleSinkInfo `json:"sinkInfo,omitempty"`
	// CustomContextTag - A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger is intended for certain specific IoT modules in the device, the tag can be the name or the image URL of the module.
	CustomContextTag *string `json:"customContextTag,omitempty"`
}

// GenerateCertResponse used in activation key generation flow.
type GenerateCertResponse struct {
	autorest.Response `json:"-"`
	// PublicKey - Gets or sets base64 encoded certificate raw data,
	// this is the public part needed to be uploaded to cert vault
	PublicKey *string `json:"publicKey,omitempty"`
	// PrivateKey - Gets or sets base64 encoded private part of the certificate,
	// needed to form the activation key
	PrivateKey *string `json:"privateKey,omitempty"`
	// ExpiryTimeInUTC - Gets or sets expiry time in UTC
	ExpiryTimeInUTC *string `json:"expiryTimeInUTC,omitempty"`
}

// ImageRepositoryCredential image repository credential.
type ImageRepositoryCredential struct {
	// ImageRepositoryURL - Image repository url (e.g.: mcr.microsoft.com).
	ImageRepositoryURL *string `json:"imageRepositoryUrl,omitempty"`
	// UserName - Repository user name.
	UserName *string `json:"userName,omitempty"`
	// Password - Repository user password.
	Password *AsymmetricEncryptedSecret `json:"password,omitempty"`
}

// IoTAddon ioT Addon.
type IoTAddon struct {
	// IoTAddonProperties - Properties specific to IOT addon.
	*IoTAddonProperties `json:"properties,omitempty"`
	// SystemData - Addon type
	SystemData *SystemData `json:"systemData,omitempty"`
	// Kind - Possible values include: 'KindAddon', 'KindArcForKubernetes', 'KindIotEdge'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTAddon.
func (ita IoTAddon) MarshalJSON() ([]byte, error) {
	ita.Kind = KindIotEdge
	objectMap := make(map[string]interface{})
	if ita.IoTAddonProperties != nil {
		objectMap["properties"] = ita.IoTAddonProperties
	}
	if ita.SystemData != nil {
		objectMap["systemData"] = ita.SystemData
	}
	if ita.Kind != "" {
		objectMap["kind"] = ita.Kind
	}
	return json.Marshal(objectMap)
}

// AsArcAddon is the BasicAddon implementation for IoTAddon.
func (ita IoTAddon) AsArcAddon() (*ArcAddon, bool) {
	return nil, false
}

// AsIoTAddon is the BasicAddon implementation for IoTAddon.
func (ita IoTAddon) AsIoTAddon() (*IoTAddon, bool) {
	return &ita, true
}

// AsAddon is the BasicAddon implementation for IoTAddon.
func (ita IoTAddon) AsAddon() (*Addon, bool) {
	return nil, false
}

// AsBasicAddon is the BasicAddon implementation for IoTAddon.
func (ita IoTAddon) AsBasicAddon() (BasicAddon, bool) {
	return &ita, true
}

// UnmarshalJSON is the custom unmarshaler for IoTAddon struct.
func (ita *IoTAddon) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ioTAddonProperties IoTAddonProperties
				err = json.Unmarshal(*v, &ioTAddonProperties)
				if err != nil {
					return err
				}
				ita.IoTAddonProperties = &ioTAddonProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ita.SystemData = &systemData
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ita.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ita.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ita.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ita.Type = &typeVar
			}
		}
	}

	return nil
}

// IoTAddonProperties ioT addon properties.
type IoTAddonProperties struct {
	// IoTDeviceDetails - IoT device metadata to which appliance needs to be connected.
	IoTDeviceDetails *IoTDeviceInfo `json:"ioTDeviceDetails,omitempty"`
	// IoTEdgeDeviceDetails - IoT edge device to which the IoT Addon needs to be configured.
	IoTEdgeDeviceDetails *IoTDeviceInfo `json:"ioTEdgeDeviceDetails,omitempty"`
	// Version - READ-ONLY; Version of IoT running on the appliance.
	Version *string `json:"version,omitempty"`
	// HostPlatform - READ-ONLY; Host OS supported by the IoT addon. Possible values include: 'Windows', 'Linux'
	HostPlatform PlatformType `json:"hostPlatform,omitempty"`
	// HostPlatformType - READ-ONLY; Platform where the runtime is hosted. Possible values include: 'KubernetesCluster', 'LinuxVM'
	HostPlatformType HostPlatformType `json:"hostPlatformType,omitempty"`
	// ProvisioningState - READ-ONLY; Addon Provisioning State. Possible values include: 'Invalid', 'Creating', 'Created', 'Updating', 'Reconfiguring', 'Failed', 'Deleting'
	ProvisioningState AddonState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTAddonProperties.
func (itap IoTAddonProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itap.IoTDeviceDetails != nil {
		objectMap["ioTDeviceDetails"] = itap.IoTDeviceDetails
	}
	if itap.IoTEdgeDeviceDetails != nil {
		objectMap["ioTEdgeDeviceDetails"] = itap.IoTEdgeDeviceDetails
	}
	return json.Marshal(objectMap)
}

// IoTDeviceInfo metadata of IoT device/IoT Edge device to be configured.
type IoTDeviceInfo struct {
	// DeviceID - ID of the IoT device/edge device.
	DeviceID *string `json:"deviceId,omitempty"`
	// IoTHostHub - Host name for the IoT hub associated to the device.
	IoTHostHub *string `json:"ioTHostHub,omitempty"`
	// IoTHostHubID - Id for the IoT hub associated to the device.
	IoTHostHubID *string `json:"ioTHostHubId,omitempty"`
	// Authentication - Encrypted IoT device/IoT edge device connection string.
	Authentication *Authentication `json:"authentication,omitempty"`
}

// IoTEdgeAgentInfo ioT edge agent details is optional, this will be used for download system Agent module
// while bootstrapping IoT Role if specified.
type IoTEdgeAgentInfo struct {
	// ImageName - Name of the IoT edge agent image.
	ImageName *string `json:"imageName,omitempty"`
	// Tag - Image Tag.
	Tag *string `json:"tag,omitempty"`
	// ImageRepository - Image repository details.
	ImageRepository *ImageRepositoryCredential `json:"imageRepository,omitempty"`
}

// IoTRole compute role.
type IoTRole struct {
	// IoTRoleProperties - Properties specific to IoT role.
	*IoTRoleProperties `json:"properties,omitempty"`
	// SystemData - Role configured on ASE resource
	SystemData *SystemData `json:"systemData,omitempty"`
	// Kind - Possible values include: 'KindRole', 'KindCloudEdgeManagement', 'KindIOT', 'KindKubernetes', 'KindMEC'
	Kind KindBasicRole `json:"kind,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTRole.
func (itr IoTRole) MarshalJSON() ([]byte, error) {
	itr.Kind = KindIOT
	objectMap := make(map[string]interface{})
	if itr.IoTRoleProperties != nil {
		objectMap["properties"] = itr.IoTRoleProperties
	}
	if itr.SystemData != nil {
		objectMap["systemData"] = itr.SystemData
	}
	if itr.Kind != "" {
		objectMap["kind"] = itr.Kind
	}
	return json.Marshal(objectMap)
}

// AsCloudEdgeManagementRole is the BasicRole implementation for IoTRole.
func (itr IoTRole) AsCloudEdgeManagementRole() (*CloudEdgeManagementRole, bool) {
	return nil, false
}

// AsIoTRole is the BasicRole implementation for IoTRole.
func (itr IoTRole) AsIoTRole() (*IoTRole, bool) {
	return &itr, true
}

// AsKubernetesRole is the BasicRole implementation for IoTRole.
func (itr IoTRole) AsKubernetesRole() (*KubernetesRole, bool) {
	return nil, false
}

// AsMECRole is the BasicRole implementation for IoTRole.
func (itr IoTRole) AsMECRole() (*MECRole, bool) {
	return nil, false
}

// AsRole is the BasicRole implementation for IoTRole.
func (itr IoTRole) AsRole() (*Role, bool) {
	return nil, false
}

// AsBasicRole is the BasicRole implementation for IoTRole.
func (itr IoTRole) AsBasicRole() (BasicRole, bool) {
	return &itr, true
}

// UnmarshalJSON is the custom unmarshaler for IoTRole struct.
func (itr *IoTRole) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ioTRoleProperties IoTRoleProperties
				err = json.Unmarshal(*v, &ioTRoleProperties)
				if err != nil {
					return err
				}
				itr.IoTRoleProperties = &ioTRoleProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				itr.SystemData = &systemData
			}
		case "kind":
			if v != nil {
				var kind KindBasicRole
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				itr.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				itr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				itr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				itr.Type = &typeVar
			}
		}
	}

	return nil
}

// IoTRoleProperties ioT role properties.
type IoTRoleProperties struct {
	// HostPlatform - Host OS supported by the IoT role. Possible values include: 'Windows', 'Linux'
	HostPlatform PlatformType `json:"hostPlatform,omitempty"`
	// IoTDeviceDetails - IoT device metadata to which data box edge device needs to be connected.
	IoTDeviceDetails *IoTDeviceInfo `json:"ioTDeviceDetails,omitempty"`
	// IoTEdgeDeviceDetails - IoT edge device to which the IoT role needs to be configured.
	IoTEdgeDeviceDetails *IoTDeviceInfo `json:"ioTEdgeDeviceDetails,omitempty"`
	// ShareMappings - Mount points of shares in role(s).
	ShareMappings *[]MountPointMap `json:"shareMappings,omitempty"`
	// IoTEdgeAgentInfo - Iot edge agent details to download the agent and bootstrap iot runtime.
	IoTEdgeAgentInfo *IoTEdgeAgentInfo `json:"ioTEdgeAgentInfo,omitempty"`
	// HostPlatformType - READ-ONLY; Platform where the Iot runtime is hosted. Possible values include: 'KubernetesCluster', 'LinuxVM'
	HostPlatformType HostPlatformType `json:"hostPlatformType,omitempty"`
	// ComputeResource - Resource allocation
	ComputeResource *ComputeResource `json:"computeResource,omitempty"`
	// RoleStatus - Role status. Possible values include: 'RoleStatusEnabled', 'RoleStatusDisabled'
	RoleStatus RoleStatus `json:"roleStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTRoleProperties.
func (itrp IoTRoleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itrp.HostPlatform != "" {
		objectMap["hostPlatform"] = itrp.HostPlatform
	}
	if itrp.IoTDeviceDetails != nil {
		objectMap["ioTDeviceDetails"] = itrp.IoTDeviceDetails
	}
	if itrp.IoTEdgeDeviceDetails != nil {
		objectMap["ioTEdgeDeviceDetails"] = itrp.IoTEdgeDeviceDetails
	}
	if itrp.ShareMappings != nil {
		objectMap["shareMappings"] = itrp.ShareMappings
	}
	if itrp.IoTEdgeAgentInfo != nil {
		objectMap["ioTEdgeAgentInfo"] = itrp.IoTEdgeAgentInfo
	}
	if itrp.ComputeResource != nil {
		objectMap["computeResource"] = itrp.ComputeResource
	}
	if itrp.RoleStatus != "" {
		objectMap["roleStatus"] = itrp.RoleStatus
	}
	return json.Marshal(objectMap)
}

// Ipv4Config details related to the IPv4 address configuration.
type Ipv4Config struct {
	// IPAddress - READ-ONLY; The IPv4 address of the network adapter.
	IPAddress *string `json:"ipAddress,omitempty"`
	// Subnet - READ-ONLY; The IPv4 subnet of the network adapter.
	Subnet *string `json:"subnet,omitempty"`
	// Gateway - READ-ONLY; The IPv4 gateway of the network adapter.
	Gateway *string `json:"gateway,omitempty"`
}

// Ipv6Config details related to the IPv6 address configuration.
type Ipv6Config struct {
	// IPAddress - READ-ONLY; The IPv6 address of the network adapter.
	IPAddress *string `json:"ipAddress,omitempty"`
	// PrefixLength - READ-ONLY; The IPv6 prefix of the network adapter.
	PrefixLength *int32 `json:"prefixLength,omitempty"`
	// Gateway - READ-ONLY; The IPv6 gateway of the network adapter.
	Gateway *string `json:"gateway,omitempty"`
}

// Job a device job.
type Job struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Status - READ-ONLY; The current status of the job. Possible values include: 'JobStatusInvalid', 'JobStatusRunning', 'JobStatusSucceeded', 'JobStatusFailed', 'JobStatusCanceled', 'JobStatusPaused', 'JobStatusScheduled'
	Status JobStatus `json:"status,omitempty"`
	// StartTime - READ-ONLY; The UTC date and time at which the job started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The UTC date and time at which the job completed.
	EndTime *date.Time `json:"endTime,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of the job that is complete.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// Error - READ-ONLY; The error details.
	Error *JobErrorDetails `json:"error,omitempty"`
	// JobProperties - READ-ONLY; The properties of the job.
	*JobProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Job struct.
func (j *Job) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				j.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				j.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				j.Type = &typeVar
			}
		case "status":
			if v != nil {
				var status JobStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				j.Status = status
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				j.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				j.EndTime = &endTime
			}
		case "percentComplete":
			if v != nil {
				var percentComplete int32
				err = json.Unmarshal(*v, &percentComplete)
				if err != nil {
					return err
				}
				j.PercentComplete = &percentComplete
			}
		case "error":
			if v != nil {
				var errorVar JobErrorDetails
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				j.Error = &errorVar
			}
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				j.JobProperties = &jobProperties
			}
		}
	}

	return nil
}

// JobErrorDetails the job error information containing the list of job errors.
type JobErrorDetails struct {
	// ErrorDetails - READ-ONLY; The error details.
	ErrorDetails *[]JobErrorItem `json:"errorDetails,omitempty"`
	// Code - READ-ONLY; The code intended for programmatic access.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The message that describes the error in detail.
	Message *string `json:"message,omitempty"`
}

// JobErrorItem the job error items.
type JobErrorItem struct {
	// Recommendations - READ-ONLY; The recommended actions.
	Recommendations *[]string `json:"recommendations,omitempty"`
	// Code - READ-ONLY; The code intended for programmatic access.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The message that describes the error in detail.
	Message *string `json:"message,omitempty"`
}

// JobProperties the properties for the job.
type JobProperties struct {
	// JobType - READ-ONLY; The type of the job. Possible values include: 'JobTypeInvalid', 'JobTypeScanForUpdates', 'JobTypeDownloadUpdates', 'JobTypeInstallUpdates', 'JobTypeRefreshShare', 'JobTypeRefreshContainer', 'JobTypeBackup', 'JobTypeRestore', 'JobTypeTriggerSupportPackage'
	JobType JobType `json:"jobType,omitempty"`
	// CurrentStage - READ-ONLY; Current stage of the update operation. Possible values include: 'UpdateOperationStageUnknown', 'UpdateOperationStageInitial', 'UpdateOperationStageScanStarted', 'UpdateOperationStageScanComplete', 'UpdateOperationStageScanFailed', 'UpdateOperationStageDownloadStarted', 'UpdateOperationStageDownloadComplete', 'UpdateOperationStageDownloadFailed', 'UpdateOperationStageInstallStarted', 'UpdateOperationStageInstallComplete', 'UpdateOperationStageInstallFailed', 'UpdateOperationStageRebootInitiated', 'UpdateOperationStageSuccess', 'UpdateOperationStageFailure', 'UpdateOperationStageRescanStarted', 'UpdateOperationStageRescanComplete', 'UpdateOperationStageRescanFailed'
	CurrentStage UpdateOperationStage `json:"currentStage,omitempty"`
	// DownloadProgress - READ-ONLY; The download progress.
	DownloadProgress *UpdateDownloadProgress `json:"downloadProgress,omitempty"`
	// InstallProgress - READ-ONLY; The install progress.
	InstallProgress *UpdateInstallProgress `json:"installProgress,omitempty"`
	// TotalRefreshErrors - READ-ONLY; Total number of errors encountered during the refresh process.
	TotalRefreshErrors *int32 `json:"totalRefreshErrors,omitempty"`
	// ErrorManifestFile - READ-ONLY; Local share/remote container relative path to the error manifest file of the refresh.
	ErrorManifestFile *string `json:"errorManifestFile,omitempty"`
	// RefreshedEntityID - READ-ONLY; ARM ID of the entity that was refreshed.
	RefreshedEntityID *string `json:"refreshedEntityId,omitempty"`
	// Folder - If only subfolders need to be refreshed, then the subfolder path inside the share or container. (The path is empty if there are no subfolders.)
	Folder *string `json:"folder,omitempty"`
}

// MarshalJSON is the custom marshaler for JobProperties.
func (jp JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jp.Folder != nil {
		objectMap["folder"] = jp.Folder
	}
	return json.Marshal(objectMap)
}

// KubernetesClusterInfo kubernetes cluster configuration
type KubernetesClusterInfo struct {
	// EtcdInfo - READ-ONLY; Etcd configuration
	EtcdInfo *EtcdInfo `json:"etcdInfo,omitempty"`
	// Nodes - READ-ONLY; Kubernetes cluster nodes
	Nodes *[]NodeInfo `json:"nodes,omitempty"`
	// Version - Kubernetes cluster version
	Version *string `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for KubernetesClusterInfo.
func (kci KubernetesClusterInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kci.Version != nil {
		objectMap["version"] = kci.Version
	}
	return json.Marshal(objectMap)
}

// KubernetesIPConfiguration kubernetes node IP configuration
type KubernetesIPConfiguration struct {
	// Port - READ-ONLY; Port of the Kubernetes node.
	Port *string `json:"port,omitempty"`
	// IPAddress - IP address of the Kubernetes node.
	IPAddress *string `json:"ipAddress,omitempty"`
}

// MarshalJSON is the custom marshaler for KubernetesIPConfiguration.
func (kic KubernetesIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kic.IPAddress != nil {
		objectMap["ipAddress"] = kic.IPAddress
	}
	return json.Marshal(objectMap)
}

// KubernetesRole kubernetes role.
type KubernetesRole struct {
	// KubernetesRoleProperties - Properties specific to Kubernetes role.
	*KubernetesRoleProperties `json:"properties,omitempty"`
	// SystemData - Role configured on ASE resource
	SystemData *SystemData `json:"systemData,omitempty"`
	// Kind - Possible values include: 'KindRole', 'KindCloudEdgeManagement', 'KindIOT', 'KindKubernetes', 'KindMEC'
	Kind KindBasicRole `json:"kind,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for KubernetesRole.
func (kr KubernetesRole) MarshalJSON() ([]byte, error) {
	kr.Kind = KindKubernetes
	objectMap := make(map[string]interface{})
	if kr.KubernetesRoleProperties != nil {
		objectMap["properties"] = kr.KubernetesRoleProperties
	}
	if kr.SystemData != nil {
		objectMap["systemData"] = kr.SystemData
	}
	if kr.Kind != "" {
		objectMap["kind"] = kr.Kind
	}
	return json.Marshal(objectMap)
}

// AsCloudEdgeManagementRole is the BasicRole implementation for KubernetesRole.
func (kr KubernetesRole) AsCloudEdgeManagementRole() (*CloudEdgeManagementRole, bool) {
	return nil, false
}

// AsIoTRole is the BasicRole implementation for KubernetesRole.
func (kr KubernetesRole) AsIoTRole() (*IoTRole, bool) {
	return nil, false
}

// AsKubernetesRole is the BasicRole implementation for KubernetesRole.
func (kr KubernetesRole) AsKubernetesRole() (*KubernetesRole, bool) {
	return &kr, true
}

// AsMECRole is the BasicRole implementation for KubernetesRole.
func (kr KubernetesRole) AsMECRole() (*MECRole, bool) {
	return nil, false
}

// AsRole is the BasicRole implementation for KubernetesRole.
func (kr KubernetesRole) AsRole() (*Role, bool) {
	return nil, false
}

// AsBasicRole is the BasicRole implementation for KubernetesRole.
func (kr KubernetesRole) AsBasicRole() (BasicRole, bool) {
	return &kr, true
}

// UnmarshalJSON is the custom unmarshaler for KubernetesRole struct.
func (kr *KubernetesRole) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var kubernetesRoleProperties KubernetesRoleProperties
				err = json.Unmarshal(*v, &kubernetesRoleProperties)
				if err != nil {
					return err
				}
				kr.KubernetesRoleProperties = &kubernetesRoleProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				kr.SystemData = &systemData
			}
		case "kind":
			if v != nil {
				var kind KindBasicRole
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				kr.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				kr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				kr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				kr.Type = &typeVar
			}
		}
	}

	return nil
}

// KubernetesRoleCompute kubernetes role compute resource
type KubernetesRoleCompute struct {
	// VMProfile - VM profile
	VMProfile *string `json:"vmProfile,omitempty"`
	// MemoryInBytes - READ-ONLY; Memory in bytes
	MemoryInBytes *int64 `json:"memoryInBytes,omitempty"`
	// ProcessorCount - READ-ONLY; Processor count
	ProcessorCount *int32 `json:"processorCount,omitempty"`
}

// MarshalJSON is the custom marshaler for KubernetesRoleCompute.
func (krc KubernetesRoleCompute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if krc.VMProfile != nil {
		objectMap["vmProfile"] = krc.VMProfile
	}
	return json.Marshal(objectMap)
}

// KubernetesRoleNetwork kubernetes role network resource
type KubernetesRoleNetwork struct {
	// CniConfig - READ-ONLY; Cni configuration
	CniConfig *CniConfig `json:"cniConfig,omitempty"`
	// LoadBalancerConfig - READ-ONLY; Load balancer configuration
	LoadBalancerConfig *LoadBalancerConfig `json:"loadBalancerConfig,omitempty"`
}

// KubernetesRoleProperties kubernetes role properties.
type KubernetesRoleProperties struct {
	// HostPlatform - Host OS supported by the Kubernetes role. Possible values include: 'Windows', 'Linux'
	HostPlatform PlatformType `json:"hostPlatform,omitempty"`
	// ProvisioningState - READ-ONLY; State of Kubernetes deployment. Possible values include: 'KubernetesStateInvalid', 'KubernetesStateCreating', 'KubernetesStateCreated', 'KubernetesStateUpdating', 'KubernetesStateReconfiguring', 'KubernetesStateFailed', 'KubernetesStateDeleting'
	ProvisioningState KubernetesState `json:"provisioningState,omitempty"`
	// HostPlatformType - READ-ONLY; Platform where the runtime is hosted. Possible values include: 'KubernetesCluster', 'LinuxVM'
	HostPlatformType HostPlatformType `json:"hostPlatformType,omitempty"`
	// KubernetesClusterInfo - Kubernetes cluster configuration
	KubernetesClusterInfo *KubernetesClusterInfo `json:"kubernetesClusterInfo,omitempty"`
	// KubernetesRoleResources - Kubernetes role resources
	KubernetesRoleResources *KubernetesRoleResources `json:"kubernetesRoleResources,omitempty"`
	// RoleStatus - Role status. Possible values include: 'RoleStatusEnabled', 'RoleStatusDisabled'
	RoleStatus RoleStatus `json:"roleStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for KubernetesRoleProperties.
func (krp KubernetesRoleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if krp.HostPlatform != "" {
		objectMap["hostPlatform"] = krp.HostPlatform
	}
	if krp.KubernetesClusterInfo != nil {
		objectMap["kubernetesClusterInfo"] = krp.KubernetesClusterInfo
	}
	if krp.KubernetesRoleResources != nil {
		objectMap["kubernetesRoleResources"] = krp.KubernetesRoleResources
	}
	if krp.RoleStatus != "" {
		objectMap["roleStatus"] = krp.RoleStatus
	}
	return json.Marshal(objectMap)
}

// KubernetesRoleResources kubernetes role resources
type KubernetesRoleResources struct {
	// Storage - Kubernetes role storage resource
	Storage *KubernetesRoleStorage `json:"storage,omitempty"`
	// Compute - Kubernetes role compute resource
	Compute *KubernetesRoleCompute `json:"compute,omitempty"`
	// Network - READ-ONLY; Kubernetes role network resource
	Network *KubernetesRoleNetwork `json:"network,omitempty"`
}

// MarshalJSON is the custom marshaler for KubernetesRoleResources.
func (krr KubernetesRoleResources) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if krr.Storage != nil {
		objectMap["storage"] = krr.Storage
	}
	if krr.Compute != nil {
		objectMap["compute"] = krr.Compute
	}
	return json.Marshal(objectMap)
}

// KubernetesRoleStorage kubernetes role storage resource
type KubernetesRoleStorage struct {
	// StorageClasses - READ-ONLY; Kubernetes storage class info.
	StorageClasses *[]KubernetesRoleStorageClassInfo `json:"storageClasses,omitempty"`
	// Endpoints - Mount points of shares in role(s).
	Endpoints *[]MountPointMap `json:"endpoints,omitempty"`
}

// MarshalJSON is the custom marshaler for KubernetesRoleStorage.
func (krs KubernetesRoleStorage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if krs.Endpoints != nil {
		objectMap["endpoints"] = krs.Endpoints
	}
	return json.Marshal(objectMap)
}

// KubernetesRoleStorageClassInfo kubernetes storage class info.
type KubernetesRoleStorageClassInfo struct {
	// Name - READ-ONLY; Storage class name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Storage class type.
	Type *string `json:"type,omitempty"`
	// PosixCompliant - READ-ONLY; If provisioned storage is posix compliant. Possible values include: 'PosixComplianceStatusInvalid', 'PosixComplianceStatusEnabled', 'PosixComplianceStatusDisabled'
	PosixCompliant PosixComplianceStatus `json:"posixCompliant,omitempty"`
}

// LoadBalancerConfig load balancer configuration
type LoadBalancerConfig struct {
	// Type - READ-ONLY; Load balancer type
	Type *string `json:"type,omitempty"`
	// Version - READ-ONLY; Load balancer version
	Version *string `json:"version,omitempty"`
}

// MECRole MEC role.
type MECRole struct {
	// MECRoleProperties - Properties specific to MEC role.
	*MECRoleProperties `json:"properties,omitempty"`
	// SystemData - Role configured on ASE resource
	SystemData *SystemData `json:"systemData,omitempty"`
	// Kind - Possible values include: 'KindRole', 'KindCloudEdgeManagement', 'KindIOT', 'KindKubernetes', 'KindMEC'
	Kind KindBasicRole `json:"kind,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MECRole.
func (mr MECRole) MarshalJSON() ([]byte, error) {
	mr.Kind = KindMEC
	objectMap := make(map[string]interface{})
	if mr.MECRoleProperties != nil {
		objectMap["properties"] = mr.MECRoleProperties
	}
	if mr.SystemData != nil {
		objectMap["systemData"] = mr.SystemData
	}
	if mr.Kind != "" {
		objectMap["kind"] = mr.Kind
	}
	return json.Marshal(objectMap)
}

// AsCloudEdgeManagementRole is the BasicRole implementation for MECRole.
func (mr MECRole) AsCloudEdgeManagementRole() (*CloudEdgeManagementRole, bool) {
	return nil, false
}

// AsIoTRole is the BasicRole implementation for MECRole.
func (mr MECRole) AsIoTRole() (*IoTRole, bool) {
	return nil, false
}

// AsKubernetesRole is the BasicRole implementation for MECRole.
func (mr MECRole) AsKubernetesRole() (*KubernetesRole, bool) {
	return nil, false
}

// AsMECRole is the BasicRole implementation for MECRole.
func (mr MECRole) AsMECRole() (*MECRole, bool) {
	return &mr, true
}

// AsRole is the BasicRole implementation for MECRole.
func (mr MECRole) AsRole() (*Role, bool) {
	return nil, false
}

// AsBasicRole is the BasicRole implementation for MECRole.
func (mr MECRole) AsBasicRole() (BasicRole, bool) {
	return &mr, true
}

// UnmarshalJSON is the custom unmarshaler for MECRole struct.
func (mr *MECRole) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mECRoleProperties MECRoleProperties
				err = json.Unmarshal(*v, &mECRoleProperties)
				if err != nil {
					return err
				}
				mr.MECRoleProperties = &mECRoleProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mr.SystemData = &systemData
			}
		case "kind":
			if v != nil {
				var kind KindBasicRole
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mr.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mr.Type = &typeVar
			}
		}
	}

	return nil
}

// MECRoleProperties MEC role properties.
type MECRoleProperties struct {
	// ConnectionString - Activation key of the MEC.
	ConnectionString *AsymmetricEncryptedSecret `json:"connectionString,omitempty"`
	// RoleStatus - Role status. Possible values include: 'RoleStatusEnabled', 'RoleStatusDisabled'
	RoleStatus RoleStatus `json:"roleStatus,omitempty"`
}

// MetricConfiguration metric configuration.
type MetricConfiguration struct {
	// ResourceID - The Resource ID on which the metrics should be pushed.
	ResourceID *string `json:"resourceId,omitempty"`
	// MdmAccount - The MDM account to which the counters should be pushed.
	MdmAccount *string `json:"mdmAccount,omitempty"`
	// MetricNameSpace - The MDM namespace to which the counters should be pushed. This is required if MDMAccount is specified
	MetricNameSpace *string `json:"metricNameSpace,omitempty"`
	// CounterSets - Host name for the IoT hub associated to the device.
	CounterSets *[]MetricCounterSet `json:"counterSets,omitempty"`
}

// MetricCounter the metric counter
type MetricCounter struct {
	// Name - The counter name.
	Name *string `json:"name,omitempty"`
	// Instance - The instance from which counter should be collected.
	Instance *string `json:"instance,omitempty"`
	// DimensionFilter - The dimension filter.
	DimensionFilter *[]MetricDimension `json:"dimensionFilter,omitempty"`
	// AdditionalDimensions - The additional dimensions to be added to metric.
	AdditionalDimensions *[]MetricDimension `json:"additionalDimensions,omitempty"`
}

// MetricCounterSet the metric counter set
type MetricCounterSet struct {
	// Counters - The counters that should be collected in this set.
	Counters *[]MetricCounter `json:"counters,omitempty"`
}

// MetricDimension the metric dimension
type MetricDimension struct {
	// SourceType - The dimension type.
	SourceType *string `json:"sourceType,omitempty"`
	// SourceName - The dimension value.
	SourceName *string `json:"sourceName,omitempty"`
}

// MetricDimensionV1 metric Dimension v1.
type MetricDimensionV1 struct {
	// Name - Name of the metrics dimension.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of the metrics dimension.
	DisplayName *string `json:"displayName,omitempty"`
	// ToBeExportedForShoebox - To be exported to shoe box.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// MetricSpecificationV1 metric specification version 1.
type MetricSpecificationV1 struct {
	// Name - Name of the metric.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of the metric.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Description of the metric to be displayed.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Metric units. Possible values include: 'NotSpecified', 'Percent', 'Count', 'Seconds', 'Milliseconds', 'Bytes', 'BytesPerSecond', 'CountPerSecond'
	Unit MetricUnit `json:"unit,omitempty"`
	// AggregationType - Metric aggregation type. Possible values include: 'MetricAggregationTypeNotSpecified', 'MetricAggregationTypeNone', 'MetricAggregationTypeAverage', 'MetricAggregationTypeMinimum', 'MetricAggregationTypeMaximum', 'MetricAggregationTypeTotal', 'MetricAggregationTypeCount'
	AggregationType MetricAggregationType `json:"aggregationType,omitempty"`
	// Dimensions - Metric dimensions, other than default dimension which is resource.
	Dimensions *[]MetricDimensionV1 `json:"dimensions,omitempty"`
	// FillGapWithZero - Set true to fill the gaps with zero.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// Category - Metric category. Possible values include: 'Capacity', 'Transaction'
	Category MetricCategory `json:"category,omitempty"`
	// ResourceIDDimensionNameOverride - Resource name override.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`
	// SupportedTimeGrainTypes - Support granularity of metrics.
	SupportedTimeGrainTypes *[]TimeGrain `json:"supportedTimeGrainTypes,omitempty"`
	// SupportedAggregationTypes - Support metric aggregation type.
	SupportedAggregationTypes *[]MetricAggregationType `json:"supportedAggregationTypes,omitempty"`
}

// MonitoringConfigCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MonitoringConfigCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MonitoringConfigClient) (MonitoringMetricConfiguration, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MonitoringConfigCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MonitoringConfigCreateOrUpdateFuture.Result.
func (future *MonitoringConfigCreateOrUpdateFuture) result(client MonitoringConfigClient) (mmc MonitoringMetricConfiguration, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.MonitoringConfigCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.MonitoringConfigCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mmc.Response.Response, err = future.GetResult(sender); err == nil && mmc.Response.Response.StatusCode != http.StatusNoContent {
		mmc, err = client.CreateOrUpdateResponder(mmc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.MonitoringConfigCreateOrUpdateFuture", "Result", mmc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MonitoringConfigDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MonitoringConfigDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MonitoringConfigClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MonitoringConfigDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MonitoringConfigDeleteFuture.Result.
func (future *MonitoringConfigDeleteFuture) result(client MonitoringConfigClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.MonitoringConfigDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.MonitoringConfigDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// MonitoringMetricConfiguration the metric setting details for the role
type MonitoringMetricConfiguration struct {
	autorest.Response `json:"-"`
	// MonitoringMetricConfigurationProperties - The metric setting properties.
	*MonitoringMetricConfigurationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MonitoringMetricConfiguration.
func (mmc MonitoringMetricConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mmc.MonitoringMetricConfigurationProperties != nil {
		objectMap["properties"] = mmc.MonitoringMetricConfigurationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MonitoringMetricConfiguration struct.
func (mmc *MonitoringMetricConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var monitoringMetricConfigurationProperties MonitoringMetricConfigurationProperties
				err = json.Unmarshal(*v, &monitoringMetricConfigurationProperties)
				if err != nil {
					return err
				}
				mmc.MonitoringMetricConfigurationProperties = &monitoringMetricConfigurationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mmc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mmc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mmc.Type = &typeVar
			}
		}
	}

	return nil
}

// MonitoringMetricConfigurationList collection of metric configurations.
type MonitoringMetricConfigurationList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of metric configurations.
	Value *[]MonitoringMetricConfiguration `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MonitoringMetricConfigurationListIterator provides access to a complete listing of
// MonitoringMetricConfiguration values.
type MonitoringMetricConfigurationListIterator struct {
	i    int
	page MonitoringMetricConfigurationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MonitoringMetricConfigurationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitoringMetricConfigurationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MonitoringMetricConfigurationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MonitoringMetricConfigurationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MonitoringMetricConfigurationListIterator) Response() MonitoringMetricConfigurationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MonitoringMetricConfigurationListIterator) Value() MonitoringMetricConfiguration {
	if !iter.page.NotDone() {
		return MonitoringMetricConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MonitoringMetricConfigurationListIterator type.
func NewMonitoringMetricConfigurationListIterator(page MonitoringMetricConfigurationListPage) MonitoringMetricConfigurationListIterator {
	return MonitoringMetricConfigurationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mmcl MonitoringMetricConfigurationList) IsEmpty() bool {
	return mmcl.Value == nil || len(*mmcl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mmcl MonitoringMetricConfigurationList) hasNextLink() bool {
	return mmcl.NextLink != nil && len(*mmcl.NextLink) != 0
}

// monitoringMetricConfigurationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mmcl MonitoringMetricConfigurationList) monitoringMetricConfigurationListPreparer(ctx context.Context) (*http.Request, error) {
	if !mmcl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mmcl.NextLink)))
}

// MonitoringMetricConfigurationListPage contains a page of MonitoringMetricConfiguration values.
type MonitoringMetricConfigurationListPage struct {
	fn   func(context.Context, MonitoringMetricConfigurationList) (MonitoringMetricConfigurationList, error)
	mmcl MonitoringMetricConfigurationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MonitoringMetricConfigurationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitoringMetricConfigurationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mmcl)
		if err != nil {
			return err
		}
		page.mmcl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MonitoringMetricConfigurationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MonitoringMetricConfigurationListPage) NotDone() bool {
	return !page.mmcl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MonitoringMetricConfigurationListPage) Response() MonitoringMetricConfigurationList {
	return page.mmcl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MonitoringMetricConfigurationListPage) Values() []MonitoringMetricConfiguration {
	if page.mmcl.IsEmpty() {
		return nil
	}
	return *page.mmcl.Value
}

// Creates a new instance of the MonitoringMetricConfigurationListPage type.
func NewMonitoringMetricConfigurationListPage(cur MonitoringMetricConfigurationList, getNextPage func(context.Context, MonitoringMetricConfigurationList) (MonitoringMetricConfigurationList, error)) MonitoringMetricConfigurationListPage {
	return MonitoringMetricConfigurationListPage{
		fn:   getNextPage,
		mmcl: cur,
	}
}

// MonitoringMetricConfigurationProperties metrics properties
type MonitoringMetricConfigurationProperties struct {
	// MetricConfigurations - The metrics configuration details
	MetricConfigurations *[]MetricConfiguration `json:"metricConfigurations,omitempty"`
}

// MountPointMap the share mount point.
type MountPointMap struct {
	// ShareID - ID of the share mounted to the role VM.
	ShareID *string `json:"shareId,omitempty"`
	// RoleID - READ-ONLY; ID of the role to which share is mounted.
	RoleID *string `json:"roleId,omitempty"`
	// MountPoint - READ-ONLY; Mount point for the share.
	MountPoint *string `json:"mountPoint,omitempty"`
	// MountType - READ-ONLY; Mounting type. Possible values include: 'Volume', 'HostPath'
	MountType MountType `json:"mountType,omitempty"`
	// RoleType - READ-ONLY; Role type. Possible values include: 'IOT', 'ASA', 'Functions', 'Cognitive', 'MEC', 'CloudEdgeManagement', 'Kubernetes'
	RoleType RoleTypes `json:"roleType,omitempty"`
}

// MarshalJSON is the custom marshaler for MountPointMap.
func (mpm MountPointMap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mpm.ShareID != nil {
		objectMap["shareId"] = mpm.ShareID
	}
	return json.Marshal(objectMap)
}

// MoveRequest resource Move details
type MoveRequest struct {
	// TargetResourceGroup - Target resource group ARMId
	TargetResourceGroup *string `json:"targetResourceGroup,omitempty"`
	// Resources - List of resources to be moved
	Resources *[]string `json:"resources,omitempty"`
}

// NetworkAdapter represents the networkAdapter on a device.
type NetworkAdapter struct {
	// AdapterID - READ-ONLY; Instance ID of network adapter.
	AdapterID *string `json:"adapterId,omitempty"`
	// AdapterPosition - READ-ONLY; Hardware position of network adapter.
	AdapterPosition *NetworkAdapterPosition `json:"adapterPosition,omitempty"`
	// Index - READ-ONLY; Logical index of the adapter.
	Index *int32 `json:"index,omitempty"`
	// NodeID - READ-ONLY; Node ID of the network adapter.
	NodeID *string `json:"nodeId,omitempty"`
	// NetworkAdapterName - READ-ONLY; Network adapter name.
	NetworkAdapterName *string `json:"networkAdapterName,omitempty"`
	// Label - READ-ONLY; Hardware label for the adapter.
	Label *string `json:"label,omitempty"`
	// MacAddress - READ-ONLY; MAC address.
	MacAddress *string `json:"macAddress,omitempty"`
	// LinkSpeed - READ-ONLY; Link speed.
	LinkSpeed *int64 `json:"linkSpeed,omitempty"`
	// Status - READ-ONLY; Value indicating whether this adapter is valid. Possible values include: 'Inactive', 'Active'
	Status NetworkAdapterStatus `json:"status,omitempty"`
	// RdmaStatus - Value indicating whether this adapter is RDMA capable. Possible values include: 'Incapable', 'Capable'
	RdmaStatus NetworkAdapterRDMAStatus `json:"rdmaStatus,omitempty"`
	// DhcpStatus - Value indicating whether this adapter has DHCP enabled. Possible values include: 'NetworkAdapterDHCPStatusDisabled', 'NetworkAdapterDHCPStatusEnabled'
	DhcpStatus NetworkAdapterDHCPStatus `json:"dhcpStatus,omitempty"`
	// Ipv4Configuration - READ-ONLY; The IPv4 configuration of the network adapter.
	Ipv4Configuration *Ipv4Config `json:"ipv4Configuration,omitempty"`
	// Ipv6Configuration - READ-ONLY; The IPv6 configuration of the network adapter.
	Ipv6Configuration *Ipv6Config `json:"ipv6Configuration,omitempty"`
	// Ipv6LinkLocalAddress - READ-ONLY; The IPv6 local address.
	Ipv6LinkLocalAddress *string `json:"ipv6LinkLocalAddress,omitempty"`
	// DNSServers - READ-ONLY; The list of DNS Servers of the device.
	DNSServers *[]string `json:"dnsServers,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkAdapter.
func (na NetworkAdapter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if na.RdmaStatus != "" {
		objectMap["rdmaStatus"] = na.RdmaStatus
	}
	if na.DhcpStatus != "" {
		objectMap["dhcpStatus"] = na.DhcpStatus
	}
	return json.Marshal(objectMap)
}

// NetworkAdapterPosition the network adapter position.
type NetworkAdapterPosition struct {
	// NetworkGroup - READ-ONLY; The network group. Possible values include: 'NetworkGroupNone', 'NetworkGroupNonRDMA', 'NetworkGroupRDMA'
	NetworkGroup NetworkGroup `json:"networkGroup,omitempty"`
	// Port - READ-ONLY; The port.
	Port *int32 `json:"port,omitempty"`
}

// NetworkSettings the network settings of a device.
type NetworkSettings struct {
	autorest.Response `json:"-"`
	// NetworkSettingsProperties - READ-ONLY; The properties of network settings of a device.
	*NetworkSettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkSettings.
func (ns NetworkSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NetworkSettings struct.
func (ns *NetworkSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var networkSettingsProperties NetworkSettingsProperties
				err = json.Unmarshal(*v, &networkSettingsProperties)
				if err != nil {
					return err
				}
				ns.NetworkSettingsProperties = &networkSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ns.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ns.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ns.Type = &typeVar
			}
		}
	}

	return nil
}

// NetworkSettingsProperties the properties of network settings.
type NetworkSettingsProperties struct {
	// NetworkAdapters - READ-ONLY; The network adapter list on the device.
	NetworkAdapters *[]NetworkAdapter `json:"networkAdapters,omitempty"`
}

// Node represents a single node in a Data box Edge/Gateway device
// Gateway devices, standalone Edge devices and a single node cluster Edge device will all have 1 node
// Multi-node Edge devices will have more than 1 nodes
type Node struct {
	// NodeProperties - READ-ONLY; The properties of the node
	*NodeProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Node.
func (n Node) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Node struct.
func (n *Node) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var nodeProperties NodeProperties
				err = json.Unmarshal(*v, &nodeProperties)
				if err != nil {
					return err
				}
				n.NodeProperties = &nodeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				n.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				n.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				n.Type = &typeVar
			}
		}
	}

	return nil
}

// NodeInfo kubernetes node info
type NodeInfo struct {
	// Name - READ-ONLY; Node name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Node type - Master/Worker. Possible values include: 'KubernetesNodeTypeInvalid', 'KubernetesNodeTypeMaster', 'KubernetesNodeTypeWorker'
	Type KubernetesNodeType `json:"type,omitempty"`
	// IPConfiguration - IP Configuration of the Kubernetes node.
	IPConfiguration *[]KubernetesIPConfiguration `json:"ipConfiguration,omitempty"`
}

// MarshalJSON is the custom marshaler for NodeInfo.
func (ni NodeInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ni.IPConfiguration != nil {
		objectMap["ipConfiguration"] = ni.IPConfiguration
	}
	return json.Marshal(objectMap)
}

// NodeList collection of Nodes.
type NodeList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of Nodes.
	Value *[]Node `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for NodeList.
func (nl NodeList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nl.NextLink != nil {
		objectMap["nextLink"] = nl.NextLink
	}
	return json.Marshal(objectMap)
}

// NodeListIterator provides access to a complete listing of Node values.
type NodeListIterator struct {
	i    int
	page NodeListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NodeListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NodeListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NodeListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NodeListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NodeListIterator) Response() NodeList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NodeListIterator) Value() Node {
	if !iter.page.NotDone() {
		return Node{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NodeListIterator type.
func NewNodeListIterator(page NodeListPage) NodeListIterator {
	return NodeListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nl NodeList) IsEmpty() bool {
	return nl.Value == nil || len(*nl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (nl NodeList) hasNextLink() bool {
	return nl.NextLink != nil && len(*nl.NextLink) != 0
}

// nodeListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nl NodeList) nodeListPreparer(ctx context.Context) (*http.Request, error) {
	if !nl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nl.NextLink)))
}

// NodeListPage contains a page of Node values.
type NodeListPage struct {
	fn func(context.Context, NodeList) (NodeList, error)
	nl NodeList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NodeListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NodeListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.nl)
		if err != nil {
			return err
		}
		page.nl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NodeListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NodeListPage) NotDone() bool {
	return !page.nl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NodeListPage) Response() NodeList {
	return page.nl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NodeListPage) Values() []Node {
	if page.nl.IsEmpty() {
		return nil
	}
	return *page.nl.Value
}

// Creates a new instance of the NodeListPage type.
func NewNodeListPage(cur NodeList, getNextPage func(context.Context, NodeList) (NodeList, error)) NodeListPage {
	return NodeListPage{
		fn: getNextPage,
		nl: cur,
	}
}

// NodeProperties this class represents the nodes in a highly available cluster
type NodeProperties struct {
	// NodeStatus - READ-ONLY; The current status of the individual node. Possible values include: 'NodeStatusUnknown', 'NodeStatusUp', 'NodeStatusDown', 'NodeStatusRebooting', 'NodeStatusShuttingDown'
	NodeStatus NodeStatus `json:"nodeStatus,omitempty"`
	// NodeChassisSerialNumber - READ-ONLY; Serial number of the Chassis
	NodeChassisSerialNumber *string `json:"nodeChassisSerialNumber,omitempty"`
	// NodeSerialNumber - READ-ONLY; Serial number of the individual node
	NodeSerialNumber *string `json:"nodeSerialNumber,omitempty"`
	// NodeDisplayName - READ-ONLY; Display Name of the individual node
	NodeDisplayName *string `json:"nodeDisplayName,omitempty"`
	// NodeFriendlySoftwareVersion - READ-ONLY; Friendly software version name that is currently installed on the node
	NodeFriendlySoftwareVersion *string `json:"nodeFriendlySoftwareVersion,omitempty"`
	// NodeHcsVersion - READ-ONLY; HCS version that is currently installed on the node
	NodeHcsVersion *string `json:"nodeHcsVersion,omitempty"`
	// NodeInstanceID - READ-ONLY; Guid instance id of the node
	NodeInstanceID *string `json:"nodeInstanceId,omitempty"`
}

// Operation operations.
type Operation struct {
	// Name - Name of the operation.
	Name *string `json:"name,omitempty"`
	// IsDataAction - Is data action.
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - Properties displayed for the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - Origin of the operation.
	Origin *string `json:"origin,omitempty"`
	// OperationProperties - Operation properties.
	*OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.IsDataAction != nil {
		objectMap["isDataAction"] = o.IsDataAction
	}
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.Origin != nil {
		objectMap["origin"] = o.Origin
	}
	if o.OperationProperties != nil {
		objectMap["properties"] = o.OperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Operation struct.
func (o *Operation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "isDataAction":
			if v != nil {
				var isDataAction bool
				err = json.Unmarshal(*v, &isDataAction)
				if err != nil {
					return err
				}
				o.IsDataAction = &isDataAction
			}
		case "display":
			if v != nil {
				var display OperationDisplay
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				o.Display = &display
			}
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				o.Origin = &origin
			}
		case "properties":
			if v != nil {
				var operationProperties OperationProperties
				err = json.Unmarshal(*v, &operationProperties)
				if err != nil {
					return err
				}
				o.OperationProperties = &operationProperties
			}
		}
	}

	return nil
}

// OperationDisplay operation display properties.
type OperationDisplay struct {
	// Provider - Provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - The type of resource in which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation to be performed on the resource.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation to be performed.
	Description *string `json:"description,omitempty"`
}

// OperationProperties operation properties.
type OperationProperties struct {
	// ServiceSpecification - Service specification.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsList the list of operations used for the discovery of available provider operations.
type OperationsList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationsListIterator provides access to a complete listing of Operation values.
type OperationsListIterator struct {
	i    int
	page OperationsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationsListIterator) Response() OperationsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationsListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationsListIterator type.
func NewOperationsListIterator(page OperationsListPage) OperationsListIterator {
	return OperationsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationsList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationsList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationsList) operationsListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationsListPage contains a page of Operation values.
type OperationsListPage struct {
	fn func(context.Context, OperationsList) (OperationsList, error)
	ol OperationsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationsListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationsListPage) Response() OperationsList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationsListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationsListPage type.
func NewOperationsListPage(cur OperationsList, getNextPage func(context.Context, OperationsList) (OperationsList, error)) OperationsListPage {
	return OperationsListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// Order the order details.
type Order struct {
	autorest.Response `json:"-"`
	// OrderProperties - The order properties.
	*OrderProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Order.
func (o Order) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.OrderProperties != nil {
		objectMap["properties"] = o.OrderProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Order struct.
func (o *Order) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var orderProperties OrderProperties
				err = json.Unmarshal(*v, &orderProperties)
				if err != nil {
					return err
				}
				o.OrderProperties = &orderProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				o.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				o.Type = &typeVar
			}
		}
	}

	return nil
}

// OrderList list of order entities.
type OrderList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of orders.
	Value *[]Order `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// OrderListIterator provides access to a complete listing of Order values.
type OrderListIterator struct {
	i    int
	page OrderListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OrderListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OrderListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OrderListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OrderListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OrderListIterator) Response() OrderList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OrderListIterator) Value() Order {
	if !iter.page.NotDone() {
		return Order{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OrderListIterator type.
func NewOrderListIterator(page OrderListPage) OrderListIterator {
	return OrderListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OrderList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OrderList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// orderListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OrderList) orderListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OrderListPage contains a page of Order values.
type OrderListPage struct {
	fn func(context.Context, OrderList) (OrderList, error)
	ol OrderList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OrderListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OrderListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OrderListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OrderListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OrderListPage) Response() OrderList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OrderListPage) Values() []Order {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OrderListPage type.
func NewOrderListPage(cur OrderList, getNextPage func(context.Context, OrderList) (OrderList, error)) OrderListPage {
	return OrderListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// OrderProperties order properties.
type OrderProperties struct {
	// ContactInformation - The contact details.
	ContactInformation *ContactDetails `json:"contactInformation,omitempty"`
	// ShippingAddress - The shipping address.
	ShippingAddress *Address `json:"shippingAddress,omitempty"`
	// CurrentStatus - READ-ONLY; Current status of the order.
	CurrentStatus *OrderStatus `json:"currentStatus,omitempty"`
	// OrderHistory - READ-ONLY; List of status changes in the order.
	OrderHistory *[]OrderStatus `json:"orderHistory,omitempty"`
	// SerialNumber - READ-ONLY; Serial number of the device.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// DeliveryTrackingInfo - READ-ONLY; Tracking information for the package delivered to the customer whether it has an original or a replacement device.
	DeliveryTrackingInfo *[]TrackingInfo `json:"deliveryTrackingInfo,omitempty"`
	// ReturnTrackingInfo - READ-ONLY; Tracking information for the package returned from the customer whether it has an original or a replacement device.
	ReturnTrackingInfo *[]TrackingInfo `json:"returnTrackingInfo,omitempty"`
	// ShipmentType - ShipmentType of the order. Possible values include: 'NotApplicable', 'ShippedToCustomer', 'SelfPickup'
	ShipmentType ShipmentType `json:"shipmentType,omitempty"`
}

// MarshalJSON is the custom marshaler for OrderProperties.
func (op OrderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if op.ContactInformation != nil {
		objectMap["contactInformation"] = op.ContactInformation
	}
	if op.ShippingAddress != nil {
		objectMap["shippingAddress"] = op.ShippingAddress
	}
	if op.ShipmentType != "" {
		objectMap["shipmentType"] = op.ShipmentType
	}
	return json.Marshal(objectMap)
}

// OrdersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type OrdersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(OrdersClient) (Order, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *OrdersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for OrdersCreateOrUpdateFuture.Result.
func (future *OrdersCreateOrUpdateFuture) result(client OrdersClient) (o Order, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.OrdersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.OrdersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if o.Response.Response, err = future.GetResult(sender); err == nil && o.Response.Response.StatusCode != http.StatusNoContent {
		o, err = client.CreateOrUpdateResponder(o.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.OrdersCreateOrUpdateFuture", "Result", o.Response.Response, "Failure responding to request")
		}
	}
	return
}

// OrdersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type OrdersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(OrdersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *OrdersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for OrdersDeleteFuture.Result.
func (future *OrdersDeleteFuture) result(client OrdersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.OrdersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.OrdersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// OrderStatus represents a single status change.
type OrderStatus struct {
	// Status - Status of the order as per the allowed status types. Possible values include: 'Untracked', 'AwaitingFulfilment', 'AwaitingPreparation', 'AwaitingShipment', 'Shipped', 'Arriving', 'Delivered', 'ReplacementRequested', 'LostDevice', 'Declined', 'ReturnInitiated', 'AwaitingReturnShipment', 'ShippedBack', 'CollectedAtMicrosoft', 'AwaitingPickup', 'PickupCompleted', 'AwaitingDrop'
	Status OrderState `json:"status,omitempty"`
	// UpdateDateTime - READ-ONLY; Time of status update.
	UpdateDateTime *date.Time `json:"updateDateTime,omitempty"`
	// Comments - Comments related to this status change.
	Comments *string `json:"comments,omitempty"`
	// TrackingInformation - READ-ONLY; Tracking information related to the state in the ordering flow
	TrackingInformation *TrackingInfo `json:"trackingInformation,omitempty"`
	// AdditionalOrderDetails - READ-ONLY; Dictionary to hold generic information which is not stored
	// by the already existing properties
	AdditionalOrderDetails map[string]*string `json:"additionalOrderDetails"`
}

// MarshalJSON is the custom marshaler for OrderStatus.
func (osVar OrderStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if osVar.Status != "" {
		objectMap["status"] = osVar.Status
	}
	if osVar.Comments != nil {
		objectMap["comments"] = osVar.Comments
	}
	return json.Marshal(objectMap)
}

// PeriodicTimerEventTrigger trigger details.
type PeriodicTimerEventTrigger struct {
	// PeriodicTimerProperties - Periodic timer trigger properties.
	*PeriodicTimerProperties `json:"properties,omitempty"`
	// SystemData - Trigger in DataBoxEdge Resource
	SystemData *SystemData `json:"systemData,omitempty"`
	// Kind - Possible values include: 'KindTrigger', 'KindFileEvent', 'KindPeriodicTimerEvent'
	Kind KindBasicTrigger `json:"kind,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PeriodicTimerEventTrigger.
func (ptet PeriodicTimerEventTrigger) MarshalJSON() ([]byte, error) {
	ptet.Kind = KindPeriodicTimerEvent
	objectMap := make(map[string]interface{})
	if ptet.PeriodicTimerProperties != nil {
		objectMap["properties"] = ptet.PeriodicTimerProperties
	}
	if ptet.SystemData != nil {
		objectMap["systemData"] = ptet.SystemData
	}
	if ptet.Kind != "" {
		objectMap["kind"] = ptet.Kind
	}
	return json.Marshal(objectMap)
}

// AsFileEventTrigger is the BasicTrigger implementation for PeriodicTimerEventTrigger.
func (ptet PeriodicTimerEventTrigger) AsFileEventTrigger() (*FileEventTrigger, bool) {
	return nil, false
}

// AsPeriodicTimerEventTrigger is the BasicTrigger implementation for PeriodicTimerEventTrigger.
func (ptet PeriodicTimerEventTrigger) AsPeriodicTimerEventTrigger() (*PeriodicTimerEventTrigger, bool) {
	return &ptet, true
}

// AsTrigger is the BasicTrigger implementation for PeriodicTimerEventTrigger.
func (ptet PeriodicTimerEventTrigger) AsTrigger() (*Trigger, bool) {
	return nil, false
}

// AsBasicTrigger is the BasicTrigger implementation for PeriodicTimerEventTrigger.
func (ptet PeriodicTimerEventTrigger) AsBasicTrigger() (BasicTrigger, bool) {
	return &ptet, true
}

// UnmarshalJSON is the custom unmarshaler for PeriodicTimerEventTrigger struct.
func (ptet *PeriodicTimerEventTrigger) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var periodicTimerProperties PeriodicTimerProperties
				err = json.Unmarshal(*v, &periodicTimerProperties)
				if err != nil {
					return err
				}
				ptet.PeriodicTimerProperties = &periodicTimerProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ptet.SystemData = &systemData
			}
		case "kind":
			if v != nil {
				var kind KindBasicTrigger
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ptet.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ptet.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ptet.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ptet.Type = &typeVar
			}
		}
	}

	return nil
}

// PeriodicTimerProperties periodic timer trigger properties.
type PeriodicTimerProperties struct {
	// SourceInfo - Periodic timer details.
	SourceInfo *PeriodicTimerSourceInfo `json:"sourceInfo,omitempty"`
	// SinkInfo - Role Sink information.
	SinkInfo *RoleSinkInfo `json:"sinkInfo,omitempty"`
	// CustomContextTag - A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger is intended for certain specific IoT modules in the device, the tag can be the name or the image URL of the module.
	CustomContextTag *string `json:"customContextTag,omitempty"`
}

// PeriodicTimerSourceInfo periodic timer event source.
type PeriodicTimerSourceInfo struct {
	// StartTime - The time of the day that results in a valid trigger. Schedule is computed with reference to the time specified upto seconds. If timezone is not specified the time will considered to be in device timezone. The value will always be returned as UTC time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// Schedule - Periodic frequency at which timer event needs to be raised. Supports daily, hourly, minutes, and seconds.
	Schedule *string `json:"schedule,omitempty"`
	// Topic - Topic where periodic events are published to IoT device.
	Topic *string `json:"topic,omitempty"`
}

// RawCertificateData raw Certificate Data.
type RawCertificateData struct {
	// AuthenticationType - The authentication type. Possible values include: 'AuthenticationTypeInvalid', 'AuthenticationTypeAzureActiveDirectory'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
	// Certificate - The base64 encoded certificate raw data.
	Certificate *string `json:"certificate,omitempty"`
}

// RefreshDetails fields for tracking refresh job on the share or container.
type RefreshDetails struct {
	// InProgressRefreshJobID - If a refresh job is currently in progress on this share or container, this field indicates the ARM resource ID of that job. The field is empty if no job is in progress.
	InProgressRefreshJobID *string `json:"inProgressRefreshJobId,omitempty"`
	// LastCompletedRefreshJobTimeInUTC - Indicates the completed time for the last refresh job on this particular share or container, if any.This could be a failed job or a successful job.
	LastCompletedRefreshJobTimeInUTC *date.Time `json:"lastCompletedRefreshJobTimeInUTC,omitempty"`
	// ErrorManifestFile - Indicates the relative path of the error xml for the last refresh job on this particular share or container, if any. This could be a failed job or a successful job.
	ErrorManifestFile *string `json:"errorManifestFile,omitempty"`
	// LastJob - Indicates the id of the last refresh job on this particular share or container,if any. This could be a failed job or a successful job.
	LastJob *string `json:"lastJob,omitempty"`
}

// ResourceIdentity msi identity details of the resource
type ResourceIdentity struct {
	// Type - Identity type. Possible values include: 'MsiIdentityTypeNone', 'MsiIdentityTypeSystemAssigned', 'MsiIdentityTypeUserAssigned'
	Type MsiIdentityType `json:"type,omitempty"`
	// PrincipalID - READ-ONLY; Service Principal Id backing the Msi
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; Home Tenant Id
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceIdentity.
func (ri ResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ri.Type != "" {
		objectMap["type"] = ri.Type
	}
	return json.Marshal(objectMap)
}

// ResourceMoveDetails fields for tracking resource move
type ResourceMoveDetails struct {
	// OperationInProgress - Denotes whether move operation is in progress. Possible values include: 'ResourceMoveStatusNone', 'ResourceMoveStatusResourceMoveInProgress', 'ResourceMoveStatusResourceMoveFailed'
	OperationInProgress ResourceMoveStatus `json:"operationInProgress,omitempty"`
	// OperationInProgressLockTimeoutInUTC - Denotes the timeout of the operation to finish
	OperationInProgressLockTimeoutInUTC *date.Time `json:"operationInProgressLockTimeoutInUTC,omitempty"`
}

// ResourceTypeSku resource type Sku object
type ResourceTypeSku struct {
	// ResourceType - READ-ONLY; The resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// Skus - READ-ONLY; The skus.
	Skus *[]SkuInformation `json:"skus,omitempty"`
}

// BasicRole compute role.
type BasicRole interface {
	AsCloudEdgeManagementRole() (*CloudEdgeManagementRole, bool)
	AsIoTRole() (*IoTRole, bool)
	AsKubernetesRole() (*KubernetesRole, bool)
	AsMECRole() (*MECRole, bool)
	AsRole() (*Role, bool)
}

// Role compute role.
type Role struct {
	autorest.Response `json:"-"`
	// SystemData - Role configured on ASE resource
	SystemData *SystemData `json:"systemData,omitempty"`
	// Kind - Possible values include: 'KindRole', 'KindCloudEdgeManagement', 'KindIOT', 'KindKubernetes', 'KindMEC'
	Kind KindBasicRole `json:"kind,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

func unmarshalBasicRole(body []byte) (BasicRole, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindCloudEdgeManagement):
		var cemr CloudEdgeManagementRole
		err := json.Unmarshal(body, &cemr)
		return cemr, err
	case string(KindIOT):
		var itr IoTRole
		err := json.Unmarshal(body, &itr)
		return itr, err
	case string(KindKubernetes):
		var kr KubernetesRole
		err := json.Unmarshal(body, &kr)
		return kr, err
	case string(KindMEC):
		var mr MECRole
		err := json.Unmarshal(body, &mr)
		return mr, err
	default:
		var r Role
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicRoleArray(body []byte) ([]BasicRole, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicRole, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicRole(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Role.
func (r Role) MarshalJSON() ([]byte, error) {
	r.Kind = KindRole
	objectMap := make(map[string]interface{})
	if r.SystemData != nil {
		objectMap["systemData"] = r.SystemData
	}
	if r.Kind != "" {
		objectMap["kind"] = r.Kind
	}
	return json.Marshal(objectMap)
}

// AsCloudEdgeManagementRole is the BasicRole implementation for Role.
func (r Role) AsCloudEdgeManagementRole() (*CloudEdgeManagementRole, bool) {
	return nil, false
}

// AsIoTRole is the BasicRole implementation for Role.
func (r Role) AsIoTRole() (*IoTRole, bool) {
	return nil, false
}

// AsKubernetesRole is the BasicRole implementation for Role.
func (r Role) AsKubernetesRole() (*KubernetesRole, bool) {
	return nil, false
}

// AsMECRole is the BasicRole implementation for Role.
func (r Role) AsMECRole() (*MECRole, bool) {
	return nil, false
}

// AsRole is the BasicRole implementation for Role.
func (r Role) AsRole() (*Role, bool) {
	return &r, true
}

// AsBasicRole is the BasicRole implementation for Role.
func (r Role) AsBasicRole() (BasicRole, bool) {
	return &r, true
}

// RoleList collection of all the roles on the Data Box Edge device.
type RoleList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The Value.
	Value *[]BasicRole `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RoleList struct.
func (rl *RoleList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicRoleArray(*v)
				if err != nil {
					return err
				}
				rl.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				rl.NextLink = &nextLink
			}
		}
	}

	return nil
}

// RoleListIterator provides access to a complete listing of Role values.
type RoleListIterator struct {
	i    int
	page RoleListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleListIterator) Response() RoleList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleListIterator) Value() BasicRole {
	if !iter.page.NotDone() {
		return Role{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleListIterator type.
func NewRoleListIterator(page RoleListPage) RoleListIterator {
	return RoleListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rl RoleList) IsEmpty() bool {
	return rl.Value == nil || len(*rl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rl RoleList) hasNextLink() bool {
	return rl.NextLink != nil && len(*rl.NextLink) != 0
}

// roleListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rl RoleList) roleListPreparer(ctx context.Context) (*http.Request, error) {
	if !rl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rl.NextLink)))
}

// RoleListPage contains a page of BasicRole values.
type RoleListPage struct {
	fn func(context.Context, RoleList) (RoleList, error)
	rl RoleList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rl)
		if err != nil {
			return err
		}
		page.rl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleListPage) NotDone() bool {
	return !page.rl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleListPage) Response() RoleList {
	return page.rl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleListPage) Values() []BasicRole {
	if page.rl.IsEmpty() {
		return nil
	}
	return *page.rl.Value
}

// Creates a new instance of the RoleListPage type.
func NewRoleListPage(cur RoleList, getNextPage func(context.Context, RoleList) (RoleList, error)) RoleListPage {
	return RoleListPage{
		fn: getNextPage,
		rl: cur,
	}
}

// RoleModel ...
type RoleModel struct {
	autorest.Response `json:"-"`
	Value             BasicRole `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RoleModel struct.
func (rm *RoleModel) UnmarshalJSON(body []byte) error {
	r, err := unmarshalBasicRole(body)
	if err != nil {
		return err
	}
	rm.Value = r

	return nil
}

// RolesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RolesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RolesClient) (RoleModel, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RolesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RolesCreateOrUpdateFuture.Result.
func (future *RolesCreateOrUpdateFuture) result(client RolesClient) (rm RoleModel, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.RolesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.RolesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rm.Response.Response, err = future.GetResult(sender); err == nil && rm.Response.Response.StatusCode != http.StatusNoContent {
		rm, err = client.CreateOrUpdateResponder(rm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.RolesCreateOrUpdateFuture", "Result", rm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RolesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RolesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RolesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RolesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RolesDeleteFuture.Result.
func (future *RolesDeleteFuture) result(client RolesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.RolesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.RolesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RoleSinkInfo compute role against which events will be raised.
type RoleSinkInfo struct {
	// RoleID - Compute role ID.
	RoleID *string `json:"roleId,omitempty"`
}

// Secret holds device secret either as a KeyVault reference or as an encrypted value.
type Secret struct {
	// EncryptedSecret - Encrypted (using device public key) secret value.
	EncryptedSecret *AsymmetricEncryptedSecret `json:"encryptedSecret,omitempty"`
	// KeyVaultID - Id of the Key-Vault where secret is stored (ex: secrets/AuthClientSecret/82ef4346187a4033a10d629cde07d740).
	KeyVaultID *string `json:"keyVaultId,omitempty"`
}

// SecuritySettings the security settings of a device.
type SecuritySettings struct {
	// SecuritySettingsProperties - Properties of the security settings.
	*SecuritySettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SecuritySettings.
func (ss SecuritySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.SecuritySettingsProperties != nil {
		objectMap["properties"] = ss.SecuritySettingsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecuritySettings struct.
func (ss *SecuritySettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securitySettingsProperties SecuritySettingsProperties
				err = json.Unmarshal(*v, &securitySettingsProperties)
				if err != nil {
					return err
				}
				ss.SecuritySettingsProperties = &securitySettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ss.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ss.Type = &typeVar
			}
		}
	}

	return nil
}

// SecuritySettingsProperties the properties of security settings.
type SecuritySettingsProperties struct {
	// DeviceAdminPassword - Device administrator password as an encrypted string (encrypted using RSA PKCS #1) is used to sign into the  local web UI of the device. The Actual password should have at least 8 characters that are a combination of  uppercase, lowercase, numeric, and special characters.
	DeviceAdminPassword *AsymmetricEncryptedSecret `json:"deviceAdminPassword,omitempty"`
}

// ServiceSpecification service specification.
type ServiceSpecification struct {
	// MetricSpecifications - Metric specification as defined by shoebox.
	MetricSpecifications *[]MetricSpecificationV1 `json:"metricSpecifications,omitempty"`
}

// Share represents a share on the  Data Box Edge/Gateway device.
type Share struct {
	autorest.Response `json:"-"`
	// SystemData - Share on ASE device
	SystemData *SystemData `json:"systemData,omitempty"`
	// ShareProperties - The share properties.
	*ShareProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Share.
func (s Share) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SystemData != nil {
		objectMap["systemData"] = s.SystemData
	}
	if s.ShareProperties != nil {
		objectMap["properties"] = s.ShareProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Share struct.
func (s *Share) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				s.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var shareProperties ShareProperties
				err = json.Unmarshal(*v, &shareProperties)
				if err != nil {
					return err
				}
				s.ShareProperties = &shareProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ShareAccessRight specifies the mapping between this particular user and the type of access he has on
// shares on this device.
type ShareAccessRight struct {
	// ShareID - The share ID.
	ShareID *string `json:"shareId,omitempty"`
	// AccessType - Type of access to be allowed on the share for this user. Possible values include: 'Change', 'Read', 'Custom'
	AccessType ShareAccessType `json:"accessType,omitempty"`
}

// ShareList collection of all the shares on the Data Box Edge/Gateway device.
type ShareList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of shares.
	Value *[]Share `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ShareListIterator provides access to a complete listing of Share values.
type ShareListIterator struct {
	i    int
	page ShareListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ShareListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ShareListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ShareListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ShareListIterator) Response() ShareList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ShareListIterator) Value() Share {
	if !iter.page.NotDone() {
		return Share{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ShareListIterator type.
func NewShareListIterator(page ShareListPage) ShareListIterator {
	return ShareListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sl ShareList) IsEmpty() bool {
	return sl.Value == nil || len(*sl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sl ShareList) hasNextLink() bool {
	return sl.NextLink != nil && len(*sl.NextLink) != 0
}

// shareListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sl ShareList) shareListPreparer(ctx context.Context) (*http.Request, error) {
	if !sl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sl.NextLink)))
}

// ShareListPage contains a page of Share values.
type ShareListPage struct {
	fn func(context.Context, ShareList) (ShareList, error)
	sl ShareList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ShareListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sl)
		if err != nil {
			return err
		}
		page.sl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ShareListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ShareListPage) NotDone() bool {
	return !page.sl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ShareListPage) Response() ShareList {
	return page.sl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ShareListPage) Values() []Share {
	if page.sl.IsEmpty() {
		return nil
	}
	return *page.sl.Value
}

// Creates a new instance of the ShareListPage type.
func NewShareListPage(cur ShareList, getNextPage func(context.Context, ShareList) (ShareList, error)) ShareListPage {
	return ShareListPage{
		fn: getNextPage,
		sl: cur,
	}
}

// ShareProperties the share properties.
type ShareProperties struct {
	// Description - Description for the share.
	Description *string `json:"description,omitempty"`
	// ShareStatus - Current status of the share. Possible values include: 'ShareStatusOffline', 'ShareStatusUnknown', 'ShareStatusOK', 'ShareStatusUpdating', 'ShareStatusNeedsAttention'
	ShareStatus ShareStatus `json:"shareStatus,omitempty"`
	// MonitoringStatus - Current monitoring status of the share. Possible values include: 'Enabled', 'Disabled'
	MonitoringStatus MonitoringStatus `json:"monitoringStatus,omitempty"`
	// AzureContainerInfo - Azure container mapping for the share.
	AzureContainerInfo *AzureContainerInfo `json:"azureContainerInfo,omitempty"`
	// AccessProtocol - Access protocol to be used by the share. Possible values include: 'SMB', 'NFS'
	AccessProtocol ShareAccessProtocol `json:"accessProtocol,omitempty"`
	// UserAccessRights - Mapping of users and corresponding access rights on the share (required for SMB protocol).
	UserAccessRights *[]UserAccessRight `json:"userAccessRights,omitempty"`
	// ClientAccessRights - List of IP addresses and corresponding access rights on the share(required for NFS protocol).
	ClientAccessRights *[]ClientAccessRight `json:"clientAccessRights,omitempty"`
	// RefreshDetails - Details of the refresh job on this share.
	RefreshDetails *RefreshDetails `json:"refreshDetails,omitempty"`
	// ShareMappings - READ-ONLY; Share mount point to the role.
	ShareMappings *[]MountPointMap `json:"shareMappings,omitempty"`
	// DataPolicy - Data policy of the share. Possible values include: 'Cloud', 'Local'
	DataPolicy DataPolicy `json:"dataPolicy,omitempty"`
}

// MarshalJSON is the custom marshaler for ShareProperties.
func (sp ShareProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.Description != nil {
		objectMap["description"] = sp.Description
	}
	if sp.ShareStatus != "" {
		objectMap["shareStatus"] = sp.ShareStatus
	}
	if sp.MonitoringStatus != "" {
		objectMap["monitoringStatus"] = sp.MonitoringStatus
	}
	if sp.AzureContainerInfo != nil {
		objectMap["azureContainerInfo"] = sp.AzureContainerInfo
	}
	if sp.AccessProtocol != "" {
		objectMap["accessProtocol"] = sp.AccessProtocol
	}
	if sp.UserAccessRights != nil {
		objectMap["userAccessRights"] = sp.UserAccessRights
	}
	if sp.ClientAccessRights != nil {
		objectMap["clientAccessRights"] = sp.ClientAccessRights
	}
	if sp.RefreshDetails != nil {
		objectMap["refreshDetails"] = sp.RefreshDetails
	}
	if sp.DataPolicy != "" {
		objectMap["dataPolicy"] = sp.DataPolicy
	}
	return json.Marshal(objectMap)
}

// SharesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SharesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SharesClient) (Share, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SharesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SharesCreateOrUpdateFuture.Result.
func (future *SharesCreateOrUpdateFuture) result(client SharesClient) (s Share, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.SharesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.SharesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateOrUpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.SharesCreateOrUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SharesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type SharesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SharesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SharesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SharesDeleteFuture.Result.
func (future *SharesDeleteFuture) result(client SharesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.SharesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.SharesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SharesRefreshFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SharesRefreshFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SharesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SharesRefreshFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SharesRefreshFuture.Result.
func (future *SharesRefreshFuture) result(client SharesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.SharesRefreshFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.SharesRefreshFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Sku the SKU type.
type Sku struct {
	// Name - SKU name. Possible values include: 'Gateway', 'Edge', 'TEA1Node', 'TEA1NodeUPS', 'TEA1NodeHeater', 'TEA1NodeUPSHeater', 'TEA4NodeHeater', 'TEA4NodeUPSHeater', 'TMA', 'TDC', 'TCASmall', 'GPU', 'TCALarge', 'EdgePBase', 'EdgePHigh', 'EdgePRBase', 'EdgePRBaseUPS', 'EdgeMRMini', 'RCASmall', 'RCALarge', 'RDC'
	Name SkuName `json:"name,omitempty"`
	// Tier - The SKU tier. This is based on the SKU name. Possible values include: 'Standard'
	Tier SkuTier `json:"tier,omitempty"`
}

// SkuCapability the metadata to describe the capability.
type SkuCapability struct {
	// Name - READ-ONLY; An invariant to describe the feature.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; An invariant if the feature is measured by quantity.
	Value *string `json:"value,omitempty"`
}

// SkuCost the metadata for retrieving price info.
type SkuCost struct {
	// MeterID - READ-ONLY; Used for querying price from commerce.
	MeterID *string `json:"meterId,omitempty"`
	// Quantity - READ-ONLY; The cost quantity.
	Quantity *int64 `json:"quantity,omitempty"`
	// ExtendedUnit - READ-ONLY; The extended unit.
	ExtendedUnit *string `json:"extendedUnit,omitempty"`
}

// SkuInformation sku information
type SkuInformation struct {
	// Name - READ-ONLY; The sku name.
	Name *string `json:"name,omitempty"`
	// Tier - READ-ONLY; The sku tier.
	Tier *string `json:"tier,omitempty"`
	// Kind - READ-ONLY; The sku kind.
	Kind *string `json:"kind,omitempty"`
	// Family - READ-ONLY; The Sku family.
	Family *string `json:"family,omitempty"`
	// Costs - READ-ONLY; The pricing info of the Sku.
	Costs *[]SkuCost `json:"costs,omitempty"`
	// Locations - READ-ONLY; The locations where Sku is available.
	Locations *[]string `json:"locations,omitempty"`
	// LocationInfo - READ-ONLY; The locations where Sku is available with zones and sites info
	LocationInfo *[]SkuLocationInfo `json:"locationInfo,omitempty"`
	// RequiredQuotaIds - READ-ONLY; The required quotaIds for the sku to be available.
	RequiredQuotaIds *[]string `json:"requiredQuotaIds,omitempty"`
	// RequiredFeatures - READ-ONLY; The required features for the sku to be available.
	RequiredFeatures *[]string `json:"requiredFeatures,omitempty"`
}

// SkuInformationList list of SKU Information objects
type SkuInformationList struct {
	// Value - READ-ONLY; List of ResourceTypeSku objects
	Value *[]ResourceTypeSku `json:"value,omitempty"`
	// NextLink - READ-ONLY; Links to the next set of results
	NextLink *string `json:"nextLink,omitempty"`
}

// SkuList list of SKU Information objects.
type SkuList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of ResourceType Sku
	Value *[]SkuType `json:"value,omitempty"`
	// NextLink - READ-ONLY; Links to the next set of results
	NextLink *string `json:"nextLink,omitempty"`
}

// SkuListIterator provides access to a complete listing of SkuType values.
type SkuListIterator struct {
	i    int
	page SkuListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SkuListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkuListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SkuListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SkuListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SkuListIterator) Response() SkuList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SkuListIterator) Value() SkuType {
	if !iter.page.NotDone() {
		return SkuType{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SkuListIterator type.
func NewSkuListIterator(page SkuListPage) SkuListIterator {
	return SkuListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sl SkuList) IsEmpty() bool {
	return sl.Value == nil || len(*sl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sl SkuList) hasNextLink() bool {
	return sl.NextLink != nil && len(*sl.NextLink) != 0
}

// skuListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sl SkuList) skuListPreparer(ctx context.Context) (*http.Request, error) {
	if !sl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sl.NextLink)))
}

// SkuListPage contains a page of SkuType values.
type SkuListPage struct {
	fn func(context.Context, SkuList) (SkuList, error)
	sl SkuList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SkuListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkuListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sl)
		if err != nil {
			return err
		}
		page.sl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SkuListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SkuListPage) NotDone() bool {
	return !page.sl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SkuListPage) Response() SkuList {
	return page.sl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SkuListPage) Values() []SkuType {
	if page.sl.IsEmpty() {
		return nil
	}
	return *page.sl.Value
}

// Creates a new instance of the SkuListPage type.
func NewSkuListPage(cur SkuList, getNextPage func(context.Context, SkuList) (SkuList, error)) SkuListPage {
	return SkuListPage{
		fn: getNextPage,
		sl: cur,
	}
}

// SkuLocationInfo the location info.
type SkuLocationInfo struct {
	// Location - READ-ONLY; The location.
	Location *string `json:"location,omitempty"`
	// Zones - READ-ONLY; The zones.
	Zones *[]string `json:"zones,omitempty"`
	// Sites - READ-ONLY; The sites.
	Sites *[]string `json:"sites,omitempty"`
}

// SkuType the Sku information.
type SkuType struct {
	// ResourceType - READ-ONLY; The type of the resource.
	ResourceType *string `json:"resourceType,omitempty"`
	// Name - READ-ONLY; The Sku name. Possible values include: 'Gateway', 'Edge', 'TEA1Node', 'TEA1NodeUPS', 'TEA1NodeHeater', 'TEA1NodeUPSHeater', 'TEA4NodeHeater', 'TEA4NodeUPSHeater', 'TMA', 'TDC', 'TCASmall', 'GPU', 'TCALarge', 'EdgePBase', 'EdgePHigh', 'EdgePRBase', 'EdgePRBaseUPS', 'EdgeMRMini', 'RCASmall', 'RCALarge', 'RDC'
	Name SkuName `json:"name,omitempty"`
	// Kind - READ-ONLY; The Sku kind.
	Kind *string `json:"kind,omitempty"`
	// Tier - READ-ONLY; The Sku tier. Possible values include: 'Standard'
	Tier SkuTier `json:"tier,omitempty"`
	// Size - READ-ONLY; The Sku kind.
	Size *string `json:"size,omitempty"`
	// Family - READ-ONLY; The Sku family.
	Family *string `json:"family,omitempty"`
	// Locations - READ-ONLY; Availability of the Sku for the region.
	Locations *[]string `json:"locations,omitempty"`
	// APIVersions - READ-ONLY; The API versions in which Sku is available.
	APIVersions *[]string `json:"apiVersions,omitempty"`
	// LocationInfo - READ-ONLY; Availability of the Sku for the location/zone/site.
	LocationInfo *[]SkuLocationInfo `json:"locationInfo,omitempty"`
	// Costs - READ-ONLY; The pricing info of the Sku.
	Costs *[]SkuCost `json:"costs,omitempty"`
	// SignupOption - READ-ONLY; Sku can be signed up by customer or not. Possible values include: 'SkuSignupOptionNone', 'SkuSignupOptionAvailable'
	SignupOption SkuSignupOption `json:"signupOption,omitempty"`
	// Version - READ-ONLY; Availability of the Sku as preview/stable. Possible values include: 'Stable', 'Preview'
	Version SkuVersion `json:"version,omitempty"`
	// Availability - READ-ONLY; Links to the next set of results. Possible values include: 'Available', 'Unavailable'
	Availability SkuAvailability `json:"availability,omitempty"`
	// ShipmentTypes - READ-ONLY; List of Shipment Types supported by this SKU
	ShipmentTypes *[]ShipmentType `json:"shipmentTypes,omitempty"`
	// Capabilities - READ-ONLY; The capability info of the SKU.
	Capabilities *[]SkuCapability `json:"capabilities,omitempty"`
}

// StorageAccount represents a Storage Account on the  Data Box Edge/Gateway device.
type StorageAccount struct {
	autorest.Response `json:"-"`
	// SystemData - StorageAccount object on ASE device
	SystemData *SystemData `json:"systemData,omitempty"`
	// StorageAccountProperties - The Storage Account properties.
	*StorageAccountProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageAccount.
func (sa StorageAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sa.SystemData != nil {
		objectMap["systemData"] = sa.SystemData
	}
	if sa.StorageAccountProperties != nil {
		objectMap["properties"] = sa.StorageAccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StorageAccount struct.
func (sa *StorageAccount) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sa.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var storageAccountProperties StorageAccountProperties
				err = json.Unmarshal(*v, &storageAccountProperties)
				if err != nil {
					return err
				}
				sa.StorageAccountProperties = &storageAccountProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sa.Type = &typeVar
			}
		}
	}

	return nil
}

// StorageAccountCredential the storage account credential.
type StorageAccountCredential struct {
	autorest.Response `json:"-"`
	// SystemData - StorageAccountCredential object
	SystemData *SystemData `json:"systemData,omitempty"`
	// StorageAccountCredentialProperties - The storage account credential properties.
	*StorageAccountCredentialProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageAccountCredential.
func (sac StorageAccountCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sac.SystemData != nil {
		objectMap["systemData"] = sac.SystemData
	}
	if sac.StorageAccountCredentialProperties != nil {
		objectMap["properties"] = sac.StorageAccountCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StorageAccountCredential struct.
func (sac *StorageAccountCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sac.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var storageAccountCredentialProperties StorageAccountCredentialProperties
				err = json.Unmarshal(*v, &storageAccountCredentialProperties)
				if err != nil {
					return err
				}
				sac.StorageAccountCredentialProperties = &storageAccountCredentialProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sac.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sac.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sac.Type = &typeVar
			}
		}
	}

	return nil
}

// StorageAccountCredentialList the collection of storage account credentials.
type StorageAccountCredentialList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The value.
	Value *[]StorageAccountCredential `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// StorageAccountCredentialListIterator provides access to a complete listing of StorageAccountCredential
// values.
type StorageAccountCredentialListIterator struct {
	i    int
	page StorageAccountCredentialListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StorageAccountCredentialListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageAccountCredentialListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StorageAccountCredentialListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StorageAccountCredentialListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StorageAccountCredentialListIterator) Response() StorageAccountCredentialList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StorageAccountCredentialListIterator) Value() StorageAccountCredential {
	if !iter.page.NotDone() {
		return StorageAccountCredential{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StorageAccountCredentialListIterator type.
func NewStorageAccountCredentialListIterator(page StorageAccountCredentialListPage) StorageAccountCredentialListIterator {
	return StorageAccountCredentialListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sacl StorageAccountCredentialList) IsEmpty() bool {
	return sacl.Value == nil || len(*sacl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sacl StorageAccountCredentialList) hasNextLink() bool {
	return sacl.NextLink != nil && len(*sacl.NextLink) != 0
}

// storageAccountCredentialListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sacl StorageAccountCredentialList) storageAccountCredentialListPreparer(ctx context.Context) (*http.Request, error) {
	if !sacl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sacl.NextLink)))
}

// StorageAccountCredentialListPage contains a page of StorageAccountCredential values.
type StorageAccountCredentialListPage struct {
	fn   func(context.Context, StorageAccountCredentialList) (StorageAccountCredentialList, error)
	sacl StorageAccountCredentialList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StorageAccountCredentialListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageAccountCredentialListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sacl)
		if err != nil {
			return err
		}
		page.sacl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StorageAccountCredentialListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StorageAccountCredentialListPage) NotDone() bool {
	return !page.sacl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StorageAccountCredentialListPage) Response() StorageAccountCredentialList {
	return page.sacl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StorageAccountCredentialListPage) Values() []StorageAccountCredential {
	if page.sacl.IsEmpty() {
		return nil
	}
	return *page.sacl.Value
}

// Creates a new instance of the StorageAccountCredentialListPage type.
func NewStorageAccountCredentialListPage(cur StorageAccountCredentialList, getNextPage func(context.Context, StorageAccountCredentialList) (StorageAccountCredentialList, error)) StorageAccountCredentialListPage {
	return StorageAccountCredentialListPage{
		fn:   getNextPage,
		sacl: cur,
	}
}

// StorageAccountCredentialProperties the storage account credential properties.
type StorageAccountCredentialProperties struct {
	// Alias - Alias for the storage account.
	Alias *string `json:"alias,omitempty"`
	// UserName - Username for the storage account.
	UserName *string `json:"userName,omitempty"`
	// AccountKey - Encrypted storage key.
	AccountKey *AsymmetricEncryptedSecret `json:"accountKey,omitempty"`
	// ConnectionString - Connection string for the storage account. Use this string if username and account key are not specified.
	ConnectionString *string `json:"connectionString,omitempty"`
	// SslStatus - Signifies whether SSL needs to be enabled or not. Possible values include: 'SSLStatusEnabled', 'SSLStatusDisabled'
	SslStatus SSLStatus `json:"sslStatus,omitempty"`
	// BlobDomainName - Blob end point for private clouds.
	BlobDomainName *string `json:"blobDomainName,omitempty"`
	// AccountType - Type of storage accessed on the storage account. Possible values include: 'GeneralPurposeStorage', 'BlobStorage'
	AccountType AccountType `json:"accountType,omitempty"`
	// StorageAccountID - Id of the storage account.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
}

// StorageAccountCredentialsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type StorageAccountCredentialsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StorageAccountCredentialsClient) (StorageAccountCredential, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StorageAccountCredentialsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StorageAccountCredentialsCreateOrUpdateFuture.Result.
func (future *StorageAccountCredentialsCreateOrUpdateFuture) result(client StorageAccountCredentialsClient) (sac StorageAccountCredential, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.StorageAccountCredentialsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.StorageAccountCredentialsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sac.Response.Response, err = future.GetResult(sender); err == nil && sac.Response.Response.StatusCode != http.StatusNoContent {
		sac, err = client.CreateOrUpdateResponder(sac.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.StorageAccountCredentialsCreateOrUpdateFuture", "Result", sac.Response.Response, "Failure responding to request")
		}
	}
	return
}

// StorageAccountCredentialsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type StorageAccountCredentialsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StorageAccountCredentialsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StorageAccountCredentialsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StorageAccountCredentialsDeleteFuture.Result.
func (future *StorageAccountCredentialsDeleteFuture) result(client StorageAccountCredentialsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.StorageAccountCredentialsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.StorageAccountCredentialsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// StorageAccountList collection of all the Storage Accounts on the Data Box Edge/Gateway device.
type StorageAccountList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of storageAccounts.
	Value *[]StorageAccount `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// StorageAccountListIterator provides access to a complete listing of StorageAccount values.
type StorageAccountListIterator struct {
	i    int
	page StorageAccountListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StorageAccountListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageAccountListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StorageAccountListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StorageAccountListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StorageAccountListIterator) Response() StorageAccountList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StorageAccountListIterator) Value() StorageAccount {
	if !iter.page.NotDone() {
		return StorageAccount{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StorageAccountListIterator type.
func NewStorageAccountListIterator(page StorageAccountListPage) StorageAccountListIterator {
	return StorageAccountListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sal StorageAccountList) IsEmpty() bool {
	return sal.Value == nil || len(*sal.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sal StorageAccountList) hasNextLink() bool {
	return sal.NextLink != nil && len(*sal.NextLink) != 0
}

// storageAccountListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sal StorageAccountList) storageAccountListPreparer(ctx context.Context) (*http.Request, error) {
	if !sal.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sal.NextLink)))
}

// StorageAccountListPage contains a page of StorageAccount values.
type StorageAccountListPage struct {
	fn  func(context.Context, StorageAccountList) (StorageAccountList, error)
	sal StorageAccountList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StorageAccountListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageAccountListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sal)
		if err != nil {
			return err
		}
		page.sal = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StorageAccountListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StorageAccountListPage) NotDone() bool {
	return !page.sal.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StorageAccountListPage) Response() StorageAccountList {
	return page.sal
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StorageAccountListPage) Values() []StorageAccount {
	if page.sal.IsEmpty() {
		return nil
	}
	return *page.sal.Value
}

// Creates a new instance of the StorageAccountListPage type.
func NewStorageAccountListPage(cur StorageAccountList, getNextPage func(context.Context, StorageAccountList) (StorageAccountList, error)) StorageAccountListPage {
	return StorageAccountListPage{
		fn:  getNextPage,
		sal: cur,
	}
}

// StorageAccountProperties the storage account properties.
type StorageAccountProperties struct {
	// Description - Description for the storage Account.
	Description *string `json:"description,omitempty"`
	// StorageAccountStatus - Current status of the storage account. Possible values include: 'StorageAccountStatusOK', 'StorageAccountStatusOffline', 'StorageAccountStatusUnknown', 'StorageAccountStatusUpdating', 'StorageAccountStatusNeedsAttention'
	StorageAccountStatus StorageAccountStatus `json:"storageAccountStatus,omitempty"`
	// DataPolicy - Data policy of the storage Account. Possible values include: 'Cloud', 'Local'
	DataPolicy DataPolicy `json:"dataPolicy,omitempty"`
	// StorageAccountCredentialID - Storage Account Credential Id
	StorageAccountCredentialID *string `json:"storageAccountCredentialId,omitempty"`
	// BlobEndpoint - READ-ONLY; BlobEndpoint of Storage Account
	BlobEndpoint *string `json:"blobEndpoint,omitempty"`
	// ContainerCount - READ-ONLY; The Container Count. Present only for Storage Accounts with DataPolicy set to Cloud.
	ContainerCount *int32 `json:"containerCount,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageAccountProperties.
func (sap StorageAccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sap.Description != nil {
		objectMap["description"] = sap.Description
	}
	if sap.StorageAccountStatus != "" {
		objectMap["storageAccountStatus"] = sap.StorageAccountStatus
	}
	if sap.DataPolicy != "" {
		objectMap["dataPolicy"] = sap.DataPolicy
	}
	if sap.StorageAccountCredentialID != nil {
		objectMap["storageAccountCredentialId"] = sap.StorageAccountCredentialID
	}
	return json.Marshal(objectMap)
}

// StorageAccountsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type StorageAccountsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StorageAccountsClient) (StorageAccount, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StorageAccountsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StorageAccountsCreateOrUpdateFuture.Result.
func (future *StorageAccountsCreateOrUpdateFuture) result(client StorageAccountsClient) (sa StorageAccount, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.StorageAccountsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.StorageAccountsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sa.Response.Response, err = future.GetResult(sender); err == nil && sa.Response.Response.StatusCode != http.StatusNoContent {
		sa, err = client.CreateOrUpdateResponder(sa.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.StorageAccountsCreateOrUpdateFuture", "Result", sa.Response.Response, "Failure responding to request")
		}
	}
	return
}

// StorageAccountsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type StorageAccountsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StorageAccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StorageAccountsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StorageAccountsDeleteFuture.Result.
func (future *StorageAccountsDeleteFuture) result(client StorageAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.StorageAccountsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.StorageAccountsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SubscriptionProperties ...
type SubscriptionProperties struct {
	TenantID            *string                           `json:"tenantId,omitempty"`
	LocationPlacementID *string                           `json:"locationPlacementId,omitempty"`
	QuotaID             *string                           `json:"quotaId,omitempty"`
	SerializedDetails   *string                           `json:"serializedDetails,omitempty"`
	RegisteredFeatures  *[]SubscriptionRegisteredFeatures `json:"registeredFeatures,omitempty"`
}

// SubscriptionRegisteredFeatures ...
type SubscriptionRegisteredFeatures struct {
	Name  *string `json:"name,omitempty"`
	State *string `json:"state,omitempty"`
}

// SymmetricKey symmetric key for authentication.
type SymmetricKey struct {
	// ConnectionString - Connection string based on the symmetric key.
	ConnectionString *AsymmetricEncryptedSecret `json:"connectionString,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The type of identity that last modified the resource.
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TrackingInfo tracking courier information.
type TrackingInfo struct {
	// SerialNumber - Serial number of the device being tracked.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// CarrierName - Name of the carrier used in the delivery.
	CarrierName *string `json:"carrierName,omitempty"`
	// TrackingID - Tracking ID of the shipment.
	TrackingID *string `json:"trackingId,omitempty"`
	// TrackingURL - Tracking URL of the shipment.
	TrackingURL *string `json:"trackingUrl,omitempty"`
}

// BasicTrigger trigger details.
type BasicTrigger interface {
	AsFileEventTrigger() (*FileEventTrigger, bool)
	AsPeriodicTimerEventTrigger() (*PeriodicTimerEventTrigger, bool)
	AsTrigger() (*Trigger, bool)
}

// Trigger trigger details.
type Trigger struct {
	autorest.Response `json:"-"`
	// SystemData - Trigger in DataBoxEdge Resource
	SystemData *SystemData `json:"systemData,omitempty"`
	// Kind - Possible values include: 'KindTrigger', 'KindFileEvent', 'KindPeriodicTimerEvent'
	Kind KindBasicTrigger `json:"kind,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

func unmarshalBasicTrigger(body []byte) (BasicTrigger, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindFileEvent):
		var fet FileEventTrigger
		err := json.Unmarshal(body, &fet)
		return fet, err
	case string(KindPeriodicTimerEvent):
		var ptet PeriodicTimerEventTrigger
		err := json.Unmarshal(body, &ptet)
		return ptet, err
	default:
		var t Trigger
		err := json.Unmarshal(body, &t)
		return t, err
	}
}
func unmarshalBasicTriggerArray(body []byte) ([]BasicTrigger, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tArray := make([]BasicTrigger, len(rawMessages))

	for index, rawMessage := range rawMessages {
		t, err := unmarshalBasicTrigger(*rawMessage)
		if err != nil {
			return nil, err
		}
		tArray[index] = t
	}
	return tArray, nil
}

// MarshalJSON is the custom marshaler for Trigger.
func (t Trigger) MarshalJSON() ([]byte, error) {
	t.Kind = KindTrigger
	objectMap := make(map[string]interface{})
	if t.SystemData != nil {
		objectMap["systemData"] = t.SystemData
	}
	if t.Kind != "" {
		objectMap["kind"] = t.Kind
	}
	return json.Marshal(objectMap)
}

// AsFileEventTrigger is the BasicTrigger implementation for Trigger.
func (t Trigger) AsFileEventTrigger() (*FileEventTrigger, bool) {
	return nil, false
}

// AsPeriodicTimerEventTrigger is the BasicTrigger implementation for Trigger.
func (t Trigger) AsPeriodicTimerEventTrigger() (*PeriodicTimerEventTrigger, bool) {
	return nil, false
}

// AsTrigger is the BasicTrigger implementation for Trigger.
func (t Trigger) AsTrigger() (*Trigger, bool) {
	return &t, true
}

// AsBasicTrigger is the BasicTrigger implementation for Trigger.
func (t Trigger) AsBasicTrigger() (BasicTrigger, bool) {
	return &t, true
}

// TriggerList collection of all trigger on the data box edge device.
type TriggerList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of triggers.
	Value *[]BasicTrigger `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for TriggerList struct.
func (tl *TriggerList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicTriggerArray(*v)
				if err != nil {
					return err
				}
				tl.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				tl.NextLink = &nextLink
			}
		}
	}

	return nil
}

// TriggerListIterator provides access to a complete listing of Trigger values.
type TriggerListIterator struct {
	i    int
	page TriggerListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TriggerListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TriggerListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TriggerListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TriggerListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TriggerListIterator) Response() TriggerList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TriggerListIterator) Value() BasicTrigger {
	if !iter.page.NotDone() {
		return Trigger{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TriggerListIterator type.
func NewTriggerListIterator(page TriggerListPage) TriggerListIterator {
	return TriggerListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tl TriggerList) IsEmpty() bool {
	return tl.Value == nil || len(*tl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tl TriggerList) hasNextLink() bool {
	return tl.NextLink != nil && len(*tl.NextLink) != 0
}

// triggerListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tl TriggerList) triggerListPreparer(ctx context.Context) (*http.Request, error) {
	if !tl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tl.NextLink)))
}

// TriggerListPage contains a page of BasicTrigger values.
type TriggerListPage struct {
	fn func(context.Context, TriggerList) (TriggerList, error)
	tl TriggerList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TriggerListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TriggerListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tl)
		if err != nil {
			return err
		}
		page.tl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TriggerListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TriggerListPage) NotDone() bool {
	return !page.tl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TriggerListPage) Response() TriggerList {
	return page.tl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TriggerListPage) Values() []BasicTrigger {
	if page.tl.IsEmpty() {
		return nil
	}
	return *page.tl.Value
}

// Creates a new instance of the TriggerListPage type.
func NewTriggerListPage(cur TriggerList, getNextPage func(context.Context, TriggerList) (TriggerList, error)) TriggerListPage {
	return TriggerListPage{
		fn: getNextPage,
		tl: cur,
	}
}

// TriggerModel ...
type TriggerModel struct {
	autorest.Response `json:"-"`
	Value             BasicTrigger `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for TriggerModel struct.
func (tm *TriggerModel) UnmarshalJSON(body []byte) error {
	t, err := unmarshalBasicTrigger(body)
	if err != nil {
		return err
	}
	tm.Value = t

	return nil
}

// TriggersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TriggersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TriggersClient) (TriggerModel, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TriggersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TriggersCreateOrUpdateFuture.Result.
func (future *TriggersCreateOrUpdateFuture) result(client TriggersClient) (tm TriggerModel, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.TriggersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.TriggersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tm.Response.Response, err = future.GetResult(sender); err == nil && tm.Response.Response.StatusCode != http.StatusNoContent {
		tm, err = client.CreateOrUpdateResponder(tm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.TriggersCreateOrUpdateFuture", "Result", tm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TriggersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TriggersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TriggersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TriggersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TriggersDeleteFuture.Result.
func (future *TriggersDeleteFuture) result(client TriggersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.TriggersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.TriggersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// UpdateDownloadProgress details about the download progress of update.
type UpdateDownloadProgress struct {
	// DownloadPhase - READ-ONLY; The download phase. Possible values include: 'Unknown', 'Initializing', 'Downloading', 'Verifying'
	DownloadPhase DownloadPhase `json:"downloadPhase,omitempty"`
	// PercentComplete - READ-ONLY; Percentage of completion.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// TotalBytesToDownload - READ-ONLY; Total bytes to download.
	TotalBytesToDownload *float64 `json:"totalBytesToDownload,omitempty"`
	// TotalBytesDownloaded - READ-ONLY; Total bytes downloaded.
	TotalBytesDownloaded *float64 `json:"totalBytesDownloaded,omitempty"`
	// NumberOfUpdatesToDownload - READ-ONLY; Number of updates to download.
	NumberOfUpdatesToDownload *int32 `json:"numberOfUpdatesToDownload,omitempty"`
	// NumberOfUpdatesDownloaded - READ-ONLY; Number of updates downloaded.
	NumberOfUpdatesDownloaded *int32 `json:"numberOfUpdatesDownloaded,omitempty"`
}

// UpdateInstallProgress progress details during installation of updates.
type UpdateInstallProgress struct {
	// PercentComplete - READ-ONLY; Percentage completed.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// NumberOfUpdatesToInstall - READ-ONLY; Number of updates to install.
	NumberOfUpdatesToInstall *int32 `json:"numberOfUpdatesToInstall,omitempty"`
	// NumberOfUpdatesInstalled - READ-ONLY; Number of updates installed.
	NumberOfUpdatesInstalled *int32 `json:"numberOfUpdatesInstalled,omitempty"`
}

// UpdateSummary details about ongoing updates and availability of updates on the device.
type UpdateSummary struct {
	autorest.Response `json:"-"`
	// UpdateSummaryProperties - The device update information summary.
	*UpdateSummaryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateSummary.
func (us UpdateSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if us.UpdateSummaryProperties != nil {
		objectMap["properties"] = us.UpdateSummaryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateSummary struct.
func (us *UpdateSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateSummaryProperties UpdateSummaryProperties
				err = json.Unmarshal(*v, &updateSummaryProperties)
				if err != nil {
					return err
				}
				us.UpdateSummaryProperties = &updateSummaryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				us.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				us.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				us.Type = &typeVar
			}
		}
	}

	return nil
}

// UpdateSummaryProperties the device update information summary.
type UpdateSummaryProperties struct {
	// DeviceVersionNumber - The current version of the device in format: 1.2.17312.13.",
	DeviceVersionNumber *string `json:"deviceVersionNumber,omitempty"`
	// FriendlyDeviceVersionName - The current version of the device in text format.
	FriendlyDeviceVersionName *string `json:"friendlyDeviceVersionName,omitempty"`
	// DeviceLastScannedDateTime - The last time when a scan was done on the device.
	DeviceLastScannedDateTime *date.Time `json:"deviceLastScannedDateTime,omitempty"`
	// LastCompletedScanJobDateTime - The time when the last scan job was completed (success/cancelled/failed) on the appliance.
	LastCompletedScanJobDateTime *date.Time `json:"lastCompletedScanJobDateTime,omitempty"`
	// LastCompletedDownloadJobDateTime - READ-ONLY; The time when the last Download job was completed (success/cancelled/failed) on the appliance.
	LastCompletedDownloadJobDateTime *date.Time `json:"lastCompletedDownloadJobDateTime,omitempty"`
	// LastCompletedInstallJobDateTime - READ-ONLY; The time when the last Install job was completed (success/cancelled/failed) on the appliance.
	LastCompletedInstallJobDateTime *date.Time `json:"lastCompletedInstallJobDateTime,omitempty"`
	// TotalNumberOfUpdatesAvailable - READ-ONLY; The number of updates available for the current device version as per the last device scan.
	TotalNumberOfUpdatesAvailable *int32 `json:"totalNumberOfUpdatesAvailable,omitempty"`
	// TotalNumberOfUpdatesPendingDownload - READ-ONLY; The total number of items pending download.
	TotalNumberOfUpdatesPendingDownload *int32 `json:"totalNumberOfUpdatesPendingDownload,omitempty"`
	// TotalNumberOfUpdatesPendingInstall - READ-ONLY; The total number of items pending install.
	TotalNumberOfUpdatesPendingInstall *int32 `json:"totalNumberOfUpdatesPendingInstall,omitempty"`
	// RebootBehavior - READ-ONLY; Indicates if updates are available and at least one of the updates needs a reboot. Possible values include: 'NeverReboots', 'RequiresReboot', 'RequestReboot'
	RebootBehavior InstallRebootBehavior `json:"rebootBehavior,omitempty"`
	// OngoingUpdateOperation - READ-ONLY; The current update operation. Possible values include: 'UpdateOperationNone', 'UpdateOperationScan', 'UpdateOperationDownload', 'UpdateOperationInstall'
	OngoingUpdateOperation UpdateOperation `json:"ongoingUpdateOperation,omitempty"`
	// InProgressDownloadJobID - READ-ONLY; The job ID of the download job in progress.
	InProgressDownloadJobID *string `json:"inProgressDownloadJobId,omitempty"`
	// InProgressInstallJobID - READ-ONLY; The job ID of the install job in progress.
	InProgressInstallJobID *string `json:"inProgressInstallJobId,omitempty"`
	// InProgressDownloadJobStartedDateTime - READ-ONLY; The time when the currently running download (if any) started.
	InProgressDownloadJobStartedDateTime *date.Time `json:"inProgressDownloadJobStartedDateTime,omitempty"`
	// InProgressInstallJobStartedDateTime - READ-ONLY; The time when the currently running install (if any) started.
	InProgressInstallJobStartedDateTime *date.Time `json:"inProgressInstallJobStartedDateTime,omitempty"`
	// UpdateTitles - READ-ONLY; The list of updates available for install.
	UpdateTitles *[]string `json:"updateTitles,omitempty"`
	// TotalUpdateSizeInBytes - READ-ONLY; The total size of updates available for download in bytes.
	TotalUpdateSizeInBytes *float64 `json:"totalUpdateSizeInBytes,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateSummaryProperties.
func (usp UpdateSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if usp.DeviceVersionNumber != nil {
		objectMap["deviceVersionNumber"] = usp.DeviceVersionNumber
	}
	if usp.FriendlyDeviceVersionName != nil {
		objectMap["friendlyDeviceVersionName"] = usp.FriendlyDeviceVersionName
	}
	if usp.DeviceLastScannedDateTime != nil {
		objectMap["deviceLastScannedDateTime"] = usp.DeviceLastScannedDateTime
	}
	if usp.LastCompletedScanJobDateTime != nil {
		objectMap["lastCompletedScanJobDateTime"] = usp.LastCompletedScanJobDateTime
	}
	return json.Marshal(objectMap)
}

// UploadCertificateRequest the upload certificate request.
type UploadCertificateRequest struct {
	// RawCertificateData - The Base 64 encoded certificate raw data.
	*RawCertificateData `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UploadCertificateRequest.
func (ucr UploadCertificateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ucr.RawCertificateData != nil {
		objectMap["properties"] = ucr.RawCertificateData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UploadCertificateRequest struct.
func (ucr *UploadCertificateRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var rawCertificateData RawCertificateData
				err = json.Unmarshal(*v, &rawCertificateData)
				if err != nil {
					return err
				}
				ucr.RawCertificateData = &rawCertificateData
			}
		}
	}

	return nil
}

// UploadCertificateResponse the upload registration certificate response.
type UploadCertificateResponse struct {
	autorest.Response `json:"-"`
	// AuthType - Specifies authentication type. Possible values include: 'AuthenticationTypeInvalid', 'AuthenticationTypeAzureActiveDirectory'
	AuthType AuthenticationType `json:"authType,omitempty"`
	// ResourceID - READ-ONLY; The resource ID of the Data Box Edge/Gateway device.
	ResourceID *string `json:"resourceId,omitempty"`
	// AadAuthority - READ-ONLY; Azure Active Directory tenant authority.
	AadAuthority *string `json:"aadAuthority,omitempty"`
	// AadTenantID - READ-ONLY; Azure Active Directory tenant ID.
	AadTenantID *string `json:"aadTenantId,omitempty"`
	// ServicePrincipalClientID - READ-ONLY; Azure Active Directory service principal client ID.
	ServicePrincipalClientID *string `json:"servicePrincipalClientId,omitempty"`
	// ServicePrincipalObjectID - READ-ONLY; Azure Active Directory service principal object ID.
	ServicePrincipalObjectID *string `json:"servicePrincipalObjectId,omitempty"`
	// AzureManagementEndpointAudience - READ-ONLY; The azure management endpoint audience.
	AzureManagementEndpointAudience *string `json:"azureManagementEndpointAudience,omitempty"`
	// AadAudience - READ-ONLY; Identifier of the target resource that is the recipient of the requested token.
	AadAudience *string `json:"aadAudience,omitempty"`
}

// MarshalJSON is the custom marshaler for UploadCertificateResponse.
func (ucr UploadCertificateResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ucr.AuthType != "" {
		objectMap["authType"] = ucr.AuthType
	}
	return json.Marshal(objectMap)
}

// User represents a user who has access to one or more shares on the Data Box Edge/Gateway device.
type User struct {
	autorest.Response `json:"-"`
	// SystemData - User in DataBoxEdge Resource
	SystemData *SystemData `json:"systemData,omitempty"`
	// UserProperties - The storage account credential properties.
	*UserProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for User.
func (u User) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.SystemData != nil {
		objectMap["systemData"] = u.SystemData
	}
	if u.UserProperties != nil {
		objectMap["properties"] = u.UserProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for User struct.
func (u *User) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				u.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var userProperties UserProperties
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				u.UserProperties = &userProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				u.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				u.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				u.Type = &typeVar
			}
		}
	}

	return nil
}

// UserAccessRight the mapping between a particular user and the access type on the SMB share.
type UserAccessRight struct {
	// UserID - User ID (already existing in the device).
	UserID *string `json:"userId,omitempty"`
	// AccessType - Type of access to be allowed for the user. Possible values include: 'Change', 'Read', 'Custom'
	AccessType ShareAccessType `json:"accessType,omitempty"`
}

// UserList collection of users.
type UserList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of users.
	Value *[]User `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UserListIterator provides access to a complete listing of User values.
type UserListIterator struct {
	i    int
	page UserListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UserListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UserListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UserListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UserListIterator) Response() UserList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UserListIterator) Value() User {
	if !iter.page.NotDone() {
		return User{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UserListIterator type.
func NewUserListIterator(page UserListPage) UserListIterator {
	return UserListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ul UserList) IsEmpty() bool {
	return ul.Value == nil || len(*ul.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ul UserList) hasNextLink() bool {
	return ul.NextLink != nil && len(*ul.NextLink) != 0
}

// userListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ul UserList) userListPreparer(ctx context.Context) (*http.Request, error) {
	if !ul.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ul.NextLink)))
}

// UserListPage contains a page of User values.
type UserListPage struct {
	fn func(context.Context, UserList) (UserList, error)
	ul UserList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UserListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ul)
		if err != nil {
			return err
		}
		page.ul = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UserListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UserListPage) NotDone() bool {
	return !page.ul.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UserListPage) Response() UserList {
	return page.ul
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UserListPage) Values() []User {
	if page.ul.IsEmpty() {
		return nil
	}
	return *page.ul.Value
}

// Creates a new instance of the UserListPage type.
func NewUserListPage(cur UserList, getNextPage func(context.Context, UserList) (UserList, error)) UserListPage {
	return UserListPage{
		fn: getNextPage,
		ul: cur,
	}
}

// UserProperties the user properties.
type UserProperties struct {
	// EncryptedPassword - The password details.
	EncryptedPassword *AsymmetricEncryptedSecret `json:"encryptedPassword,omitempty"`
	// ShareAccessRights - READ-ONLY; List of shares that the user has rights on. This field should not be specified during user creation.
	ShareAccessRights *[]ShareAccessRight `json:"shareAccessRights,omitempty"`
	// UserType - Type of the user. Possible values include: 'UserTypeShare', 'UserTypeLocalManagement', 'UserTypeARM'
	UserType UserType `json:"userType,omitempty"`
}

// MarshalJSON is the custom marshaler for UserProperties.
func (up UserProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if up.EncryptedPassword != nil {
		objectMap["encryptedPassword"] = up.EncryptedPassword
	}
	if up.UserType != "" {
		objectMap["userType"] = up.UserType
	}
	return json.Marshal(objectMap)
}

// UsersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type UsersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(UsersClient) (User, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *UsersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for UsersCreateOrUpdateFuture.Result.
func (future *UsersCreateOrUpdateFuture) result(client UsersClient) (u User, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.UsersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.UsersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if u.Response.Response, err = future.GetResult(sender); err == nil && u.Response.Response.StatusCode != http.StatusNoContent {
		u, err = client.CreateOrUpdateResponder(u.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.UsersCreateOrUpdateFuture", "Result", u.Response.Response, "Failure responding to request")
		}
	}
	return
}

// UsersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UsersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(UsersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *UsersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for UsersDeleteFuture.Result.
func (future *UsersDeleteFuture) result(client UsersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.UsersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databoxedge.UsersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}
