// Package generated Code generated by go-bindata. (@generated) DO NOT EDIT.
// sources:
// translations/OWNERS
// translations/extract.py
// translations/kubectl/OWNERS
// translations/kubectl/de_DE/LC_MESSAGES/k8s.mo
// translations/kubectl/de_DE/LC_MESSAGES/k8s.po
// translations/kubectl/default/LC_MESSAGES/k8s.mo
// translations/kubectl/default/LC_MESSAGES/k8s.po
// translations/kubectl/en_US/LC_MESSAGES/k8s.mo
// translations/kubectl/en_US/LC_MESSAGES/k8s.po
// translations/kubectl/fr_FR/LC_MESSAGES/k8s.mo
// translations/kubectl/fr_FR/LC_MESSAGES/k8s.po
// translations/kubectl/it_IT/LC_MESSAGES/k8s.mo
// translations/kubectl/it_IT/LC_MESSAGES/k8s.po
// translations/kubectl/ja_JP/LC_MESSAGES/k8s.mo
// translations/kubectl/ja_JP/LC_MESSAGES/k8s.po
// translations/kubectl/ko_KR/LC_MESSAGES/k8s.mo
// translations/kubectl/ko_KR/LC_MESSAGES/k8s.po
// translations/kubectl/pt_BR/LC_MESSAGES/k8s.mo
// translations/kubectl/pt_BR/LC_MESSAGES/k8s.po
// translations/kubectl/template.pot
// translations/kubectl/zh_CN/LC_MESSAGES/k8s.mo
// translations/kubectl/zh_CN/LC_MESSAGES/k8s.po
// translations/kubectl/zh_TW/LC_MESSAGES/k8s.mo
// translations/kubectl/zh_TW/LC_MESSAGES/k8s.po
// translations/test/default/LC_MESSAGES/k8s.mo
// translations/test/default/LC_MESSAGES/k8s.po
// translations/test/en_US/LC_MESSAGES/k8s.mo
// translations/test/en_US/LC_MESSAGES/k8s.po
package generated

import (
	"fmt"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

// Name return file name
func (fi bindataFileInfo) Name() string {
	return fi.name
}

// Size return file size
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}

// Mode return file mode
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}

// Mode return file modify time
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}

// IsDir return file whether a directory
func (fi bindataFileInfo) IsDir() bool {
	return fi.mode&os.ModeDir != 0
}

// Sys return file is sys mode
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _translationsOwners = []byte(`# See the OWNERS docs at https://go.k8s.io/owners

reviewers:
  - brendandburns
approvers:
  - sig-cli-maintainers
  - brendandburns
`)

func translationsOwnersBytes() ([]byte, error) {
	return _translationsOwners, nil
}

func translationsOwners() (*asset, error) {
	bytes, err := translationsOwnersBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/OWNERS", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsExtractPy = []byte(`#!/usr/bin/env python

# Copyright 2017 The Kubernetes Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Extract strings from command files and externalize into translation files.
Expects to be run from the root directory of the repository.

Usage:
   extract.py pkg/kubectl/cmd/apply.go

"""
import fileinput
import sys
import re

class MatchHandler(object):
    """ Simple holder for a regular expression and a function
    to run if that regular expression matches a line.
    The function should expect (re.match, file, linenumber) as parameters
    """
    def __init__(self, regex, replace_fn):
        self.regex = re.compile(regex)
        self.replace_fn = replace_fn

def short_replace(match, file, line_number):
    """Replace a Short: ... cobra command description with an internationalization
    """
    sys.stdout.write('{}i18n.T({}),\n'.format(match.group(1), match.group(2)))

SHORT_MATCH = MatchHandler(r'(\s+Short:\s+)("[^"]+"),', short_replace)

def import_replace(match, file, line_number):
    """Add an extra import for the i18n library.
    Doesn't try to be smart and detect if it's already present, assumes a
    gofmt round wil fix things.
    """
    sys.stdout.write('{}\n"k8s.io/kubectl/pkg/util/i18n"\n'.format(match.group(1)))

IMPORT_MATCH = MatchHandler('(.*"k8s.io/kubectl/pkg/cmd/util")', import_replace)


def string_flag_replace(match, file, line_number):
    """Replace a cmd.Flags().String("...", "", "...") with an internationalization
    """
    sys.stdout.write('{}i18n.T("{})"))\n'.format(match.group(1), match.group(2)))

STRING_FLAG_MATCH = MatchHandler('(\s+cmd\.Flags\(\).String\("[^"]*", "[^"]*", )"([^"]*)"\)', string_flag_replace)


def long_string_replace(match, file, line_number):
    return '{}i18n.T({}){}'.format(match.group(1), match.group(2), match.group(3))

LONG_DESC_MATCH = MatchHandler('(LongDesc\()(` + "`" + `[^` + "`" + `]+` + "`" + `)([^\n]\n)', long_string_replace)

EXAMPLE_MATCH = MatchHandler('(Examples\()(` + "`" + `[^` + "`" + `]+` + "`" + `)([^\n]\n)', long_string_replace)

def replace(filename, matchers, multiline_matchers):
    """Given a file and a set of matchers, run those matchers
    across the file and replace it with the results.
    """
    # Run all the matchers
    line_number = 0
    for line in fileinput.input(filename, inplace=True):
        line_number += 1
        matched = False
        for matcher in matchers:
            match = matcher.regex.match(line)
            if match:
                matcher.replace_fn(match, filename, line_number)
                matched = True
                break
        if not matched:
            sys.stdout.write(line)
    sys.stdout.flush()
    with open(filename, 'r') as datafile:
        content = datafile.read()
        for matcher in multiline_matchers:
            match = matcher.regex.search(content)
            while match:
                rep = matcher.replace_fn(match, filename, 0)
                # Escape back references in the replacement string
                # (And escape for Python)
                # (And escape for regex)
                rep = re.sub('\\\\(\\d)', '\\\\\\\\\\1', rep)
                content = matcher.regex.sub(rep, content, 1)
                match = matcher.regex.search(content)
        sys.stdout.write(content)

    # gofmt the file again
    from subprocess import call
    call(["goimports", "-w", filename])

replace(sys.argv[1], [SHORT_MATCH, IMPORT_MATCH, STRING_FLAG_MATCH], [LONG_DESC_MATCH, EXAMPLE_MATCH])
`)

func translationsExtractPyBytes() ([]byte, error) {
	return _translationsExtractPy, nil
}

func translationsExtractPy() (*asset, error) {
	bytes, err := translationsExtractPyBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/extract.py", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlOwners = []byte(`# See the OWNERS docs at https://go.k8s.io/owners

approvers:
- sig-cli-maintainers
reviewers:
- sig-cli
`)

func translationsKubectlOwnersBytes() ([]byte, error) {
	return _translationsKubectlOwners, nil
}

func translationsKubectlOwners() (*asset, error) {
	bytes, err := translationsKubectlOwnersBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/OWNERS", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlDe_deLc_messagesK8sMo = []byte("\xde\x12\x04\x95\x00\x00\x00\x00\xd5\x00\x00\x00\x1c\x00\x00\x00\xc4\x06\x00\x00%\x01\x00\x00l\r\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\xdc\x00\x00\x00\x01\x12\x00\x00\xb6\x00\x00\x00\xde\x12\x00\x00\v\x02\x00\x00\x95\x13\x00\x00\x1f\x01\x00\x00\xa1\x15\x00\x00z\x00\x00\x00\xc1\x16\x00\x00_\x02\x00\x00<\x17\x00\x00\u007f\x01\x00\x00\x9c\x19\x00\x00\x8f\x01\x00\x00\x1c\x1b\x00\x00k\x01\x00\x00\xac\x1c\x00\x00k\x01\x00\x00\x18\x1e\x00\x00>\x01\x00\x00\x84\x1f\x00\x00\x03\x02\x00\x00\xc3 \x00\x00o\x01\x00\x00\xc7\"\x00\x00H\x05\x00\x007$\x00\x00g\x02\x00\x00\x80)\x00\x00\x1b\x02\x00\x00\xe8+\x00\x00q\x01\x00\x00\x04.\x00\x00\xa8\x01\x00\x00v/\x00\x00\xd4\x01\x00\x00\x1f1\x00\x00\x02\x02\x00\x00\xf42\x00\x00\xb4\x00\x00\x00\xf74\x00\x00\xb7\x02\x00\x00\xac5\x00\x00\x92\x03\x00\x00d8\x00\x00\xbf\x01\x00\x00\xf7;\x00\x00=\x00\x00\x00\xb7=\x00\x00;\x00\x00\x00\xf5=\x00\x00\xcd\x02\x00\x001>\x00\x00<\x00\x00\x00\xff@\x00\x00P\x00\x00\x00<A\x00\x00S\x00\x00\x00\x8dA\x00\x00<\x00\x00\x00\xe1A\x00\x00\xac\x01\x00\x00\x1eB\x00\x00\x13\x03\x00\x00\xcbC\x00\x00\xea\x01\x00\x00\xdfF\x00\x00\xfa\x01\x00\x00\xcaH\x00\x00\xda\x01\x00\x00\xc5J\x00\x00c\x01\x00\x00\xa0L\x00\x00T\x01\x00\x00\x04N\x00\x00\xba\x06\x00\x00YO\x00\x00\xf9\x01\x00\x00\x14V\x00\x00\xe0\x02\x00\x00\x0eX\x00\x00\x02\x03\x00\x00\xefZ\x00\x00\xfb\x00\x00\x00\xf2]\x00\x00\xa5\x01\x00\x00\xee^\x00\x00\xb4\x01\x00\x00\x94`\x00\x00\x18\x00\x00\x00Ib\x00\x00<\x00\x00\x00bb\x00\x00=\x00\x00\x00\x9fb\x00\x00\xc6\x00\x00\x00\xddb\x00\x00g\x02\x00\x00\xa4c\x00\x00.\x00\x00\x00\ff\x00\x001\x03\x00\x00;f\x00\x00g\x00\x00\x00mi\x00\x00Q\x00\x00\x00\xd5i\x00\x00R\x00\x00\x00'j\x00\x00\"\x00\x00\x00zj\x00\x00X\x02\x00\x00\x9dj\x00\x004\x00\x00\x00\xf6l\x00\x00}\x00\x00\x00+m\x00\x00k\x01\x00\x00\xa9m\x00\x00\x81\a\x00\x00\x15o\x00\x00f\x01\x00\x00\x97v\x00\x00\x85\x00\x00\x00\xfew\x00\x00\xea\x00\x00\x00\x84x\x00\x00\xd9\x00\x00\x00oy\x00\x00\n\x05\x00\x00Iz\x00\x00\x10\x05\x00\x00T\u007f\x00\x00\x1c\x00\x00\x00e\x84\x00\x00\x1e\x00\x00\x00\x82\x84\x00\x00\x98\x02\x00\x00\xa1\x84\x00\x00\xbc\x01\x00\x00:\x87\x00\x00\x9c\x01\x00\x00\xf7\x88\x00\x00q\x01\x00\x00\x94\x8a\x00\x00\x05\x01\x00\x00\x06\x8c\x00\x00\xdf\x01\x00\x00\f\x8d\x00\x00\x1c\x01\x00\x00\xec\x8e\x00\x00\x9d\x00\x00\x00\t\x90\x00\x00X\x00\x00\x00\xa7\x90\x00\x00%\x02\x00\x00\x00\x91\x00\x00o\x00\x00\x00&\x93\x00\x00u\x00\x00\x00\x96\x93\x00\x00\x01\x01\x00\x00\f\x94\x00\x00v\x00\x00\x00\x0e\x95\x00\x00t\x00\x00\x00\x85\x95\x00\x00\xef\x00\x00\x00\xfa\x95\x00\x00}\x00\x00\x00\xea\x96\x00\x00j\x00\x00\x00h\x97\x00\x00\xc4\x01\x00\x00\u04d7\x00\x00;\x00\x00\x00\x98\x99\x00\x008\x00\x00\x00\u0519\x00\x001\x00\x00\x00\r\x9a\x00\x007\x00\x00\x00?\x9a\x00\x00\xb0\x00\x00\x00w\x9a\x00\x00[\x00\x00\x00(\x9b\x00\x00J\x00\x00\x00\x84\x9b\x00\x00a\x00\x00\x00\u03db\x00\x00\xbd\x00\x00\x001\x9c\x00\x009\x00\x00\x00\xef\x9c\x00\x00\xc5\x00\x00\x00)\x9d\x00\x008\x00\x00\x00\xef\x9d\x00\x00%\x00\x00\x00(\x9e\x00\x00W\x00\x00\x00N\x9e\x00\x00\x1d\x00\x00\x00\xa6\x9e\x00\x00=\x00\x00\x00\u011e\x00\x00u\x00\x00\x00\x02\x9f\x00\x004\x00\x00\x00x\x9f\x00\x00-\x00\x00\x00\xad\x9f\x00\x00\xa3\x00\x00\x00\u06df\x00\x003\x00\x00\x00\u007f\xa0\x00\x002\x00\x00\x00\xb3\xa0\x00\x008\x00\x00\x00\xe6\xa0\x00\x00\x1e\x00\x00\x00\x1f\xa1\x00\x00\x1a\x00\x00\x00>\xa1\x00\x009\x00\x00\x00Y\xa1\x00\x00\x13\x00\x00\x00\x93\xa1\x00\x00\x1b\x00\x00\x00\xa7\xa1\x00\x00@\x00\x00\x00\u00e1\x00\x00,\x00\x00\x00\x04\xa2\x00\x00*\x00\x00\x001\xa2\x00\x007\x00\x00\x00\\\xa2\x00\x00'\x00\x00\x00\x94\xa2\x00\x00&\x00\x00\x00\xbc\xa2\x00\x00.\x00\x00\x00\xe3\xa2\x00\x00=\x00\x00\x00\x12\xa3\x00\x00*\x00\x00\x00P\xa3\x00\x000\x00\x00\x00{\xa3\x00\x00,\x00\x00\x00\xac\xa3\x00\x00\x1f\x00\x00\x00\u0663\x00\x00]\x00\x00\x00\xf9\xa3\x00\x000\x00\x00\x00W\xa4\x00\x000\x00\x00\x00\x88\xa4\x00\x00\"\x00\x00\x00\xb9\xa4\x00\x00?\x00\x00\x00\u0724\x00\x00\x1d\x00\x00\x00\x1c\xa5\x00\x00,\x00\x00\x00:\xa5\x00\x00+\x00\x00\x00g\xa5\x00\x00$\x00\x00\x00\x93\xa5\x00\x00\x14\x00\x00\x00\xb8\xa5\x00\x00*\x00\x00\x00\u0365\x00\x00A\x00\x00\x00\xf8\xa5\x00\x00\x1d\x00\x00\x00:\xa6\x00\x00\x1c\x00\x00\x00X\xa6\x00\x00\x1a\x00\x00\x00u\xa6\x00\x00)\x00\x00\x00\x90\xa6\x00\x006\x00\x00\x00\xba\xa6\x00\x00\x1d\x00\x00\x00\xf1\xa6\x00\x00\x19\x00\x00\x00\x0f\xa7\x00\x00 \x00\x00\x00)\xa7\x00\x00v\x00\x00\x00J\xa7\x00\x00(\x00\x00\x00\xc1\xa7\x00\x00\x16\x00\x00\x00\xea\xa7\x00\x00p\x00\x00\x00\x01\xa8\x00\x00\x1b\x00\x00\x00r\xa8\x00\x00\x18\x00\x00\x00\x8e\xa8\x00\x00\x1a\x00\x00\x00\xa7\xa8\x00\x00$\x00\x00\x00\u00a8\x00\x00\x1d\x00\x00\x00\xe7\xa8\x00\x00\x17\x00\x00\x00\x05\xa9\x00\x00a\x00\x00\x00\x1d\xa9\x00\x00s\x00\x00\x00\u007f\xa9\x00\x00B\x00\x00\x00\xf3\xa9\x00\x00+\x00\x00\x006\xaa\x00\x00+\x00\x00\x00b\xaa\x00\x006\x00\x00\x00\x8e\xaa\x00\x00;\x00\x00\x00\u016a\x00\x00q\x00\x00\x00\x01\xab\x00\x00/\x00\x00\x00s\xab\x00\x001\x00\x00\x00\xa3\xab\x00\x00'\x00\x00\x00\u056b\x00\x00'\x00\x00\x00\xfd\xab\x00\x00\x18\x00\x00\x00%\xac\x00\x00&\x00\x00\x00>\xac\x00\x00%\x00\x00\x00e\xac\x00\x00(\x00\x00\x00\x8b\xac\x00\x00K\x00\x00\x00\xb4\xac\x00\x00 \x00\x00\x00\x00\xad\x00\x00_\x00\x00\x00!\xad\x00\x00\x1e\x00\x00\x00\x81\xad\x00\x00\"\x00\x00\x00\xa0\xad\x00\x00\"\x00\x00\x00\u00ed\x00\x00\x1f\x00\x00\x00\xe6\xad\x00\x00-\x00\x00\x00\x06\xae\x00\x00-\x00\x00\x004\xae\x00\x009\x00\x00\x00b\xae\x00\x00\x1e\x00\x00\x00\x9c\xae\x00\x00\x19\x00\x00\x00\xbb\xae\x00\x00c\x00\x00\x00\u056e\x00\x00#\x00\x00\x009\xaf\x00\x00\x82\x00\x00\x00]\xaf\x00\x00H\x00\x00\x00\xe0\xaf\x00\x00&\x00\x00\x00)\xb0\x00\x00e\x00\x00\x00P\xb0\x00\x00z\x00\x00\x00\xb6\xb0\x00\x00J\x00\x00\x001\xb1\x00\x00\xe5\x00\x00\x00|\xb1\x00\x00W\x00\x00\x00b\xb2\x00\x00E\x00\x00\x00\xba\xb2\x00\x00a\x00\x00\x00\x00\xb3\x00\x00v\x00\x00\x00b\xb3\x00\x00\x1c\x00\x00\x00\u0673\x00\x00T\x00\x00\x00\xf6\xb3\x00\x00\x17\x00\x00\x00K\xb4\x00\x009\x00\x00\x00c\xb4\x00\x00\x1e\x00\x00\x00\x9d\xb4\x00\x00=\x00\x00\x00\xbc\xb4\x00\x00$\x00\x00\x00\xfa\xb4\x00\x00\x1f\x00\x00\x00\x1f\xb5\x00\x00&\x00\x00\x00?\xb5\x00\x00+\x00\x00\x00f\xb5\x00\x00G\x00\x00\x00\x92\xb5\x00\x00\x14\x00\x00\x00\u06b5\x00\x00/\x00\x00\x00\xef\xb5\x00\x00\xd3\x01\x00\x00\x1f\xb6\x00\x00\xdd\x00\x00\x00\xf3\xb7\x00\x00\xb8\x00\x00\x00\u0478\x00\x00J\x02\x00\x00\x8a\xb9\x00\x00\x14\x01\x00\x00\u057b\x00\x00\x87\x00\x00\x00\xea\xbc\x00\x00y\x02\x00\x00r\xbd\x00\x00\xa7\x01\x00\x00\xec\xbf\x00\x00\xb2\x01\x00\x00\x94\xc1\x00\x00|\x01\x00\x00G\xc3\x00\x00\u007f\x01\x00\x00\xc4\xc4\x00\x00>\x01\x00\x00D\xc6\x00\x00\x1b\x02\x00\x00\x83\xc7\x00\x00\x89\x01\x00\x00\x9f\xc9\x00\x00\xc9\x05\x00\x00)\xcb\x00\x00\x82\x02\x00\x00\xf3\xd0\x00\x009\x02\x00\x00v\xd3\x00\x00\xbc\x01\x00\x00\xb0\xd5\x00\x00\xc3\x01\x00\x00m\xd7\x00\x00\xf8\x01\x00\x001\xd9\x00\x00 \x02\x00\x00*\xdb\x00\x00\xc1\x00\x00\x00K\xdd\x00\x00\xc9\x02\x00\x00\r\xde\x00\x00\xa6\x03\x00\x00\xd7\xe0\x00\x00\xed\x01\x00\x00~\xe4\x00\x00D\x00\x00\x00l\xe6\x00\x00B\x00\x00\x00\xb1\xe6\x00\x00\xee\x02\x00\x00\xf4\xe6\x00\x00N\x00\x00\x00\xe3\xe9\x00\x00U\x00\x00\x002\xea\x00\x00W\x00\x00\x00\x88\xea\x00\x00E\x00\x00\x00\xe0\xea\x00\x00\xbf\x01\x00\x00&\xeb\x00\x000\x03\x00\x00\xe6\xec\x00\x00\x1d\x02\x00\x00\x17\xf0\x00\x00\xf9\x01\x00\x005\xf2\x00\x00\xd7\x01\x00\x00/\xf4\x00\x00k\x01\x00\x00\a\xf6\x00\x00N\x01\x00\x00s\xf7\x00\x00\xed\x06\x00\x00\xc2\xf8\x00\x00.\x02\x00\x00\xb0\xff\x00\x00\x1c\x03\x00\x00\xdf\x01\x01\x00-\x03\x00\x00\xfc\x04\x01\x00\b\x01\x00\x00*\b\x01\x00\xc7\x01\x00\x003\t\x01\x00\xef\x01\x00\x00\xfb\n\x01\x00\x1d\x00\x00\x00\xeb\f\x01\x00C\x00\x00\x00\t\r\x01\x00<\x00\x00\x00M\r\x01\x00\xd9\x00\x00\x00\x8a\r\x01\x00\xa8\x02\x00\x00d\x0e\x01\x004\x00\x00\x00\r\x11\x01\x00\x9c\x03\x00\x00B\x11\x01\x00{\x00\x00\x00\xdf\x14\x01\x00a\x00\x00\x00[\x15\x01\x00V\x00\x00\x00\xbd\x15\x01\x00/\x00\x00\x00\x14\x16\x01\x00\x97\x02\x00\x00D\x16\x01\x009\x00\x00\x00\xdc\x18\x01\x00\x9b\x00\x00\x00\x16\x19\x01\x00m\x01\x00\x00\xb2\x19\x01\x00\r\b\x00\x00 \x1b\x01\x00\x94\x01\x00\x00.#\x01\x00\x90\x00\x00\x00\xc3$\x01\x00\x0f\x01\x00\x00T%\x01\x00\xf7\x00\x00\x00d&\x01\x00\x9e\x05\x00\x00\\'\x01\x00\xaa\x05\x00\x00\xfb,\x01\x00#\x00\x00\x00\xa62\x01\x00%\x00\x00\x00\xca2\x01\x00\xed\x02\x00\x00\xf02\x01\x00\xd1\x01\x00\x00\xde5\x01\x00\xd1\x01\x00\x00\xb07\x01\x00\x8b\x01\x00\x00\x829\x01\x00\xfe\x00\x00\x00\x0e;\x01\x00\x04\x02\x00\x00\r<\x01\x00)\x01\x00\x00\x12>\x01\x00\xa5\x00\x00\x00<?\x01\x00Z\x00\x00\x00\xe2?\x01\x006\x02\x00\x00=@\x01\x00p\x00\x00\x00tB\x01\x00w\x00\x00\x00\xe5B\x01\x00\x12\x01\x00\x00]C\x01\x00r\x00\x00\x00pD\x01\x00v\x00\x00\x00\xe3D\x01\x00\xf4\x00\x00\x00ZE\x01\x00\u007f\x00\x00\x00OF\x01\x00l\x00\x00\x00\xcfF\x01\x00\xe8\x01\x00\x00<G\x01\x00A\x00\x00\x00%I\x01\x00>\x00\x00\x00gI\x01\x005\x00\x00\x00\xa6I\x01\x00=\x00\x00\x00\xdcI\x01\x00\xc0\x00\x00\x00\x1aJ\x01\x00p\x00\x00\x00\xdbJ\x01\x00Z\x00\x00\x00LK\x01\x00{\x00\x00\x00\xa7K\x01\x00\xe0\x00\x00\x00#L\x01\x006\x00\x00\x00\x04M\x01\x00\xfe\x00\x00\x00;M\x01\x00M\x00\x00\x00:N\x01\x00*\x00\x00\x00\x88N\x01\x00m\x00\x00\x00\xb3N\x01\x00\"\x00\x00\x00!O\x01\x00C\x00\x00\x00DO\x01\x00\x8e\x00\x00\x00\x88O\x01\x00:\x00\x00\x00\x17P\x01\x003\x00\x00\x00RP\x01\x00\xb7\x00\x00\x00\x86P\x01\x00?\x00\x00\x00>Q\x01\x00/\x00\x00\x00~Q\x01\x00?\x00\x00\x00\xaeQ\x01\x00$\x00\x00\x00\xeeQ\x01\x00 \x00\x00\x00\x13R\x01\x00B\x00\x00\x004R\x01\x00\x17\x00\x00\x00wR\x01\x00 \x00\x00\x00\x8fR\x01\x00L\x00\x00\x00\xb0R\x01\x000\x00\x00\x00\xfdR\x01\x000\x00\x00\x00.S\x01\x00;\x00\x00\x00_S\x01\x00,\x00\x00\x00\x9bS\x01\x001\x00\x00\x00\xc8S\x01\x00@\x00\x00\x00\xfaS\x01\x00P\x00\x00\x00;T\x01\x002\x00\x00\x00\x8cT\x01\x005\x00\x00\x00\xbfT\x01\x005\x00\x00\x00\xf5T\x01\x00$\x00\x00\x00+U\x01\x00f\x00\x00\x00PU\x01\x001\x00\x00\x00\xb7U\x01\x002\x00\x00\x00\xe9U\x01\x00)\x00\x00\x00\x1cV\x01\x00R\x00\x00\x00FV\x01\x00&\x00\x00\x00\x99V\x01\x00.\x00\x00\x00\xc0V\x01\x00,\x00\x00\x00\xefV\x01\x00$\x00\x00\x00\x1cW\x01\x00\x12\x00\x00\x00AW\x01\x003\x00\x00\x00TW\x01\x00L\x00\x00\x00\x88W\x01\x00!\x00\x00\x00\xd5W\x01\x00\x1b\x00\x00\x00\xf7W\x01\x00\x1c\x00\x00\x00\x13X\x01\x00+\x00\x00\x000X\x01\x00?\x00\x00\x00\\X\x01\x00&\x00\x00\x00\x9cX\x01\x00\x1b\x00\x00\x00\xc3X\x01\x00$\x00\x00\x00\xdfX\x01\x00\x8a\x00\x00\x00\x04Y\x01\x009\x00\x00\x00\x8fY\x01\x00\x17\x00\x00\x00\xc9Y\x01\x00\x81\x00\x00\x00\xe1Y\x01\x00\x1f\x00\x00\x00cZ\x01\x00\x1f\x00\x00\x00\x83Z\x01\x00!\x00\x00\x00\xa3Z\x01\x00+\x00\x00\x00\xc5Z\x01\x00 \x00\x00\x00\xf1Z\x01\x00\x1d\x00\x00\x00\x12[\x01\x00\\\x00\x00\x000[\x01\x00\x90\x00\x00\x00\x8d[\x01\x00E\x00\x00\x00\x1e\\\x01\x00;\x00\x00\x00d\\\x01\x00.\x00\x00\x00\xa0\\\x01\x009\x00\x00\x00\xcf\\\x01\x00B\x00\x00\x00\t]\x01\x00w\x00\x00\x00L]\x01\x003\x00\x00\x00\xc4]\x01\x007\x00\x00\x00\xf8]\x01\x003\x00\x00\x000^\x01\x005\x00\x00\x00d^\x01\x00\"\x00\x00\x00\x9a^\x01\x00/\x00\x00\x00\xbd^\x01\x00+\x00\x00\x00\xed^\x01\x00,\x00\x00\x00\x19_\x01\x00W\x00\x00\x00F_\x01\x00%\x00\x00\x00\x9e_\x01\x00a\x00\x00\x00\xc4_\x01\x00%\x00\x00\x00&`\x01\x00-\x00\x00\x00L`\x01\x00-\x00\x00\x00z`\x01\x00*\x00\x00\x00\xa8`\x01\x005\x00\x00\x00\xd3`\x01\x005\x00\x00\x00\ta\x01\x00D\x00\x00\x00?a\x01\x00\x1c\x00\x00\x00\x84a\x01\x00\x1a\x00\x00\x00\xa1a\x01\x00n\x00\x00\x00\xbca\x01\x008\x00\x00\x00+b\x01\x00\x80\x00\x00\x00db\x01\x00W\x00\x00\x00\xe5b\x01\x00$\x00\x00\x00=c\x01\x00g\x00\x00\x00bc\x01\x00\x8d\x00\x00\x00\xcac\x01\x00R\x00\x00\x00Xd\x01\x00\xee\x00\x00\x00\xabd\x01\x00p\x00\x00\x00\x9ae\x01\x00L\x00\x00\x00\vf\x01\x00j\x00\x00\x00Xf\x01\x00}\x00\x00\x00\xc3f\x01\x00#\x00\x00\x00Ag\x01\x00Y\x00\x00\x00eg\x01\x00 \x00\x00\x00\xbfg\x01\x00B\x00\x00\x00\xe0g\x01\x00)\x00\x00\x00#h\x01\x00E\x00\x00\x00Mh\x01\x000\x00\x00\x00\x93h\x01\x00*\x00\x00\x00\xc4h\x01\x006\x00\x00\x00\xefh\x01\x007\x00\x00\x00&i\x01\x00V\x00\x00\x00^i\x01\x00\x15\x00\x00\x00\xb5i\x01\x003\x00\x00\x00\xcbi\x01\x00\x01\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb1\x00\x00\x00 \x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x87\x00\x00\x00\u007f\x00\x00\x00\x00\x00\x00\x001\x00\x00\x00\x00\x00\x00\x00e\x00\x00\x00a\x00\x00\x00\v\x00\x00\x00\x00\x00\x00\x00\xb6\x00\x00\x00\x17\x00\x00\x00\xcc\x00\x00\x00\x0e\x00\x00\x00r\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00*\x00\x00\x00c\x00\x00\x00\x8f\x00\x00\x00<\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x00\x00Y\x00\x00\x00\xc4\x00\x00\x00>\x00\x00\x00\x8a\x00\x00\x00\xb3\x00\x00\x00.\x00\x00\x00\x00\x00\x00\x00\x9c\x00\x00\x00\r\x00\x00\x00&\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\f\x00\x00\x00\xbb\x00\x00\x00\x95\x00\x00\x00j\x00\x00\x00\xc5\x00\x00\x00p\x00\x00\x00t\x00\x00\x00A\x00\x00\x00\x93\x00\x00\x00\x0f\x00\x00\x00`\x00\x00\x00s\x00\x00\x00\xc3\x00\x00\x00\x83\x00\x00\x00\x00\x00\x00\x00\x96\x00\x00\x00!\x00\x00\x00\x00\x00\x00\x00#\x00\x00\x00\x9d\x00\x00\x00\x00\x00\x00\x00R\x00\x00\x00\x92\x00\x00\x003\x00\x00\x00\xa3\x00\x00\x008\x00\x00\x00\xd1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x00\x00\x00G\x00\x00\x00\xba\x00\x00\x00\x8e\x00\x00\x00}\x00\x00\x00\x9b\x00\x00\x00%\x00\x00\x00\xa8\x00\x00\x00\x00\x00\x00\x00;\x00\x00\x00\xa2\x00\x00\x00H\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00m\x00\x00\x00\x00\x00\x00\x00\"\x00\x00\x00\t\x00\x00\x00^\x00\x00\x00\xa9\x00\x00\x00\xc7\x00\x00\x00k\x00\x00\x00\xc2\x00\x00\x00\x94\x00\x00\x007\x00\x00\x00~\x00\x00\x00{\x00\x00\x00N\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcf\x00\x00\x00\x00\x00\x00\x00\x97\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00:\x00\x00\x00\x00\x00\x00\x00,\x00\x00\x00\xb7\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00C\x00\x00\x00\xd3\x00\x00\x00\x1e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00f\x00\x00\x00n\x00\x00\x00Q\x00\x00\x00\x1f\x00\x00\x00\xaa\x00\x00\x00b\x00\x00\x00\xc8\x00\x00\x00\n\x00\x00\x00O\x00\x00\x00y\x00\x00\x00\xa5\x00\x00\x00\x05\x00\x00\x00\x15\x00\x00\x00-\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00/\x00\x00\x00\x91\x00\x00\x00\x81\x00\x00\x00)\x00\x00\x009\x00\x00\x00\x8c\x00\x00\x00i\x00\x00\x00\xab\x00\x00\x00\x00\x00\x00\x00$\x00\x00\x00+\x00\x00\x00g\x00\x00\x00\xbd\x00\x00\x00\xa0\x00\x00\x00W\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\xae\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\xcd\x00\x00\x00\\\x00\x00\x00\xc1\x00\x00\x004\x00\x00\x006\x00\x00\x00D\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x00\x00\x00\x1a\x00\x00\x00\x00\x00\x00\x00\xd0\x00\x00\x00\xb0\x00\x00\x00\x00\x00\x00\x00\a\x00\x00\x00\x98\x00\x00\x00\x00\x00\x00\x00'\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00J\x00\x00\x00\x00\x00\x00\x00\xb5\x00\x00\x00\x1b\x00\x00\x00u\x00\x00\x00\xbc\x00\x00\x00\xbe\x00\x00\x00[\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x00\x00q\x00\x00\x00\xaf\x00\x00\x00\x00\x00\x00\x00E\x00\x00\x00x\x00\x00\x00l\x00\x00\x00F\x00\x00\x00\xb4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00X\x00\x00\x00\xad\x00\x00\x00\xd4\x00\x00\x005\x00\x00\x00\xca\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x00\x00\x00o\x00\x00\x00\xac\x00\x00\x00\x00\x00\x00\x00\xc6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x00\x00\x00\x00\x00\x00Z\x00\x00\x00\xc9\x00\x00\x00\x00\x00\x00\x00v\x00\x00\x00\x00\x00\x00\x00\xa1\x00\x00\x00\x00\x00\x00\x00\x82\x00\x00\x00\xbf\x00\x00\x00P\x00\x00\x00\x1d\x00\x00\x00\x88\x00\x00\x00\xb8\x00\x00\x00\xce\x00\x00\x00\x00\x00\x00\x00T\x00\x00\x00\x00\x00\x00\x00S\x00\x00\x00\xa4\x00\x00\x00\x00\x00\x00\x00=\x00\x00\x00\x00\x00\x00\x00\xa7\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00|\x00\x00\x00\x04\x00\x00\x00\x85\x00\x00\x00]\x00\x00\x00B\x00\x00\x00M\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00@\x00\x00\x00w\x00\x00\x00K\x00\x00\x00_\x00\x00\x00\x89\x00\x00\x00\x19\x00\x00\x00\xd2\x00\x00\x00\xb9\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\xc0\x00\x00\x002\x00\x00\x00\xd5\x00\x00\x00h\x00\x00\x00\x18\x00\x00\x00\x9a\x00\x00\x00V\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00I\x00\x00\x00?\x00\x00\x00L\x00\x00\x000\x00\x00\x00\x16\x00\x00\x00d\x00\x00\x00\x80\x00\x00\x00z\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00U\x00\x00\x00\x00\n\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the cluster-admin ClusterRole\n\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin ClusterRole\n\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a new configmap named my-config based on folder bar\n\t\t  kubectl create configmap my-config --from-file=path/to/bar\n\n\t\t  # Create a new configmap named my-config with specified keys instead of file basenames on disk\n\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1.txt --from-file=key2=/path/to/bar/file2.txt\n\n\t\t  # Create a new configmap named my-config with key1=config1 and key2=config2\n\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-literal=key2=config2\x00\n\t\t  # If you don't already have a .dockercfg file, you can create a dockercfg secret directly by using:\n\t\t  kubectl create secret docker-registry my-secret --docker-server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL\x00\n\t\t  # Show metrics for all nodes\n\t\t  kubectl top node\n\n\t\t  # Show metrics for a given node\n\t\t  kubectl top node NODE_NAME\x00\n\t\t# Apply the configuration in pod.json to a pod.\n\t\tkubectl apply -f ./pod.json\n\n\t\t# Apply the JSON passed into stdin to a pod.\n\t\tcat pod.json | kubectl apply -f -\n\n\t\t# Note: --prune is still in Alpha\n\t\t# Apply the configuration in manifest.yaml that matches label app=nginx and delete all the other resources that are not in the file and match label app=nginx.\n\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n\n\t\t# Apply the configuration in manifest.yaml and delete all the other configmaps that are not in the file.\n\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/ConfigMap\x00\n\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and 10, no target CPU utilization specified so a default autoscaling policy will be used:\n\t\tkubectl autoscale deployment foo --min=2 --max=10\n\n\t\t# Auto scale a replication controller \"foo\", with the number of pods between 1 and 5, target CPU utilization at 80%:\n\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80\x00\n\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n\t\tkubectl convert -f pod.yaml\n\n\t\t# Convert the live state of the resource specified by 'pod.yaml' to the latest version\n\t\t# and print to stdout in json format.\n\t\tkubectl convert -f pod.yaml --local -o json\n\n\t\t# Convert all files under current directory to latest version and create them all.\n\t\tkubectl convert -f . | kubectl create -f -\x00\n\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods\n\n\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --resource=pods\n\n\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a new resourcequota named my-quota\n\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,replicationcontrollers=2,resourcequotas=1,secrets=5,persistentvolumeclaims=10\n\n\t\t# Create a new resourcequota named best-effort\n\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort\x00\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=rails label\n\t\t# and require at least one of them being available at any point in time.\n\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-available=1\n\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=nginx label\n\t\t# and require at least half of the pods selected to be available at any point in time.\n\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%\x00\n\t\t# Create a pod using the data in pod.json.\n\t\tkubectl create -f ./pod.json\n\n\t\t# Create a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl create -f -\n\n\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format then create the resource using the edited data.\n\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json\x00\n\t\t# Create a service for a replicated nginx, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rc nginx --port=80 --target-port=8000\n\n\t\t# Create a service for a replication controller identified by type and name specified in \"nginx-controller.yaml\", which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n\n\t\t# Create a service for a pod valid-pod, which serves on port 444 with the name \"frontend\"\n\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n\n\t\t# Create a second service based on the above service, exposing the container port 8443 as port 443 with the name \"nginx-https\"\n\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-https\n\n\t\t# Create a service for a replicated streaming application on port 4100 balancing UDP traffic and named 'video-stream'.\n\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-stream\n\n\t\t# Create a service for a replicated nginx using replica set, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rs nginx --port=80 --target-port=8000\n\n\t\t# Create a service for an nginx deployment, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose deployment nginx --port=80 --target-port=8000\x00\n\t\t# Delete a pod using the type and name specified in pod.json.\n\t\tkubectl delete -f ./pod.json\n\n\t\t# Delete a pod based on the type and name in the JSON passed into stdin.\n\t\tcat pod.json | kubectl delete -f -\n\n\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n\t\tkubectl delete pod,service baz foo\n\n\t\t# Delete pods and services with label name=myLabel.\n\t\tkubectl delete pods,services -l name=myLabel\n\n\t\t# Delete a pod with minimal delay\n\t\tkubectl delete pod foo --now\n\n\t\t# Force delete a pod on a dead node\n\t\tkubectl delete pod foo --grace-period=0 --force\n\n\t\t# Delete all pods\n\t\tkubectl delete pods --all\x00\n\t\t# Describe a node\n\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n\n\t\t# Describe a pod\n\t\tkubectl describe pods/nginx\n\n\t\t# Describe a pod identified by type and name in \"pod.json\"\n\t\tkubectl describe -f pod.json\n\n\t\t# Describe all pods\n\t\tkubectl describe pods\n\n\t\t# Describe pods by label name=myLabel\n\t\tkubectl describe po -l name=myLabel\n\n\t\t# Describe all pods managed by the 'frontend' replication controller (rc-created pods\n\t\t# get the name of the rc as a prefix in the pod the name).\n\t\tkubectl describe pods frontend\x00\n\t\t# Drain node \"foo\", even if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n\t\t$ kubectl drain foo --force\n\n\t\t# As above, but abort if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a grace period of 15 minutes.\n\t\t$ kubectl drain foo --grace-period=900\x00\n\t\t# Edit the service named 'docker-registry':\n\t\tkubectl edit svc/docker-registry\n\n\t\t# Use an alternative editor\n\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n\n\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n\t\tkubectl edit job.v1.batch/myjob -o json\n\n\t\t# Edit the deployment 'mydeployment' in YAML and save the modified config in its annotation:\n\t\tkubectl edit deployment/mydeployment -o yaml --save-config\x00\n\t\t# Get output from running 'date' from pod 123456-7890, using the first container by default\n\t\tkubectl exec 123456-7890 date\n\n\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n\t\tkubectl exec 123456-7890 -c ruby-container date\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il\x00\n\t\t# Get output from running pod 123456-7890, using the first container by default\n\t\tkubectl attach 123456-7890\n\n\t\t# Get output from ruby-container from pod 123456-7890\n\t\tkubectl attach 123456-7890 -c ruby-container\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n\n\t\t# Get output from the first pod of a ReplicaSet named nginx\n\t\tkubectl attach rs/nginx\n\t\t\x00\n\t\t# Get the documentation of the resource and its fields\n\t\tkubectl explain pods\n\n\t\t# Get the documentation of a specific field of a resource\n\t\tkubectl explain pods.spec.containers\x00\n\t\t# Install bash completion on a Mac using homebrew\n\t\tbrew install bash-completion\n\t\tprintf \"\n# Bash completion support\nsource $(brew --prefix)/etc/bash_completion\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for bash into the current shell\n\t\tsource <(kubectl completion bash)\n\n\t\t# Write bash completion code to a file and source if from .bash_profile\n\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n\t\tprintf \"\n# Kubectl shell completion\nsource '$HOME/.kube/completion.bash.inc'\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for zsh[1] into the current shell\n\t\tsource <(kubectl completion zsh)\x00\n\t\t# List all pods in ps output format.\n\t\tkubectl get pods\n\n\t\t# List all pods in ps output format with more information (such as node name).\n\t\tkubectl get pods -o wide\n\n\t\t# List a single replication controller with specified NAME in ps output format.\n\t\tkubectl get replicationcontroller web\n\n\t\t# List a single pod in JSON output format.\n\t\tkubectl get -o json pod web-pod-13je7\n\n\t\t# List a pod identified by type and name specified in \"pod.yaml\" in JSON output format.\n\t\tkubectl get -f pod.yaml -o json\n\n\t\t# Return only the phase value of the specified pod.\n\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n\n\t\t# List all replication controllers and services together in ps output format.\n\t\tkubectl get rc,services\n\n\t\t# List one or more resources by their type and names.\n\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n\n\t\t# List all resources with different types.\n\t\tkubectl get all\x00\n\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports 5000 and 6000 in the pod\n\t\tkubectl port-forward mypod 5000 6000\n\n\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 8888:5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod :5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 0:5000\x00\n\t\t# Mark node \"foo\" as schedulable.\n\t\t$ kubectl uncordon foo\x00\n\t\t# Mark node \"foo\" as unschedulable.\n\t\tkubectl cordon foo\x00\n\t\t# Partially update a node using strategic merge patch\n\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Partially update a node identified by the type and name specified in \"node.json\" using strategic merge patch\n\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Update a container's image; spec.containers[*].name is required because it's a merge key\n\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n\n\t\t# Update a container's image using a json patch with positional arrays\n\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", \"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'\x00\n\t\t# Print flags inherited by all commands\n\t\tkubectl options\x00\n\t\t# Print the address of the master and cluster services\n\t\tkubectl cluster-info\x00\n\t\t# Print the client and server versions for the current context\n\t\tkubectl version\x00\n\t\t# Print the supported API versions\n\t\tkubectl api-versions\x00\n\t\t# Replace a pod using the data in pod.json.\n\t\tkubectl replace -f ./pod.json\n\n\t\t# Replace a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl replace -f -\n\n\t\t# Update a single-container pod's image version (tag) to v4\n\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/\x01:v4/' | kubectl replace -f -\n\n\t\t# Force replace, delete and then re-create the resource\n\t\tkubectl replace --force -f ./pod.json\x00\n\t\t# Return snapshot logs from pod nginx with only one container\n\t\tkubectl logs nginx\n\n\t\t# Return snapshot logs for the pods defined by label app=nginx\n\t\tkubectl logs -lapp=nginx\n\n\t\t# Return snapshot of previous terminated ruby container logs from pod web-1\n\t\tkubectl logs -p -c ruby web-1\n\n\t\t# Begin streaming the logs of the ruby container in pod web-1\n\t\tkubectl logs -f -c ruby web-1\n\n\t\t# Display only the most recent 20 lines of output in pod nginx\n\t\tkubectl logs --tail=20 nginx\n\n\t\t# Show all logs from pod nginx written in the last hour\n\t\tkubectl logs --since=1h nginx\n\n\t\t# Return snapshot logs from first container of a job named hello\n\t\tkubectl logs job/hello\n\n\t\t# Return snapshot logs from container nginx-1 of a deployment named nginx\n\t\tkubectl logs deployment/nginx -c nginx-1\x00\n\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static content from ./local/www/\n\t\tkubectl proxy --port=8011 --www=./local/www/\n\n\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n\t\t# The chosen port for the server will be output to stdout.\n\t\tkubectl proxy --port=0\n\n\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-api\n\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/pods/\n\t\tkubectl proxy --api-prefix=/k8s-api\x00\n\t\t# Scale a replicaset named 'foo' to 3.\n\t\tkubectl scale --replicas=3 rs/foo\n\n\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" to 3.\n\t\tkubectl scale --replicas=3 -f foo.yaml\n\n\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n\n\t\t# Scale multiple replication controllers.\n\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n\n\t\t# Scale job named 'cron' to 3.\n\t\tkubectl scale --replicas=3 job/cron\x00\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file.\n\t\tkubectl apply set-last-applied -f deploy.yaml\n\n\t\t# Execute set-last-applied against each configuration file in a directory.\n\t\tkubectl apply set-last-applied -f path/\n\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file, will create the annotation if it does not already exist.\n\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n\t\t\x00\n\t\t# Show metrics for all pods in the default namespace\n\t\tkubectl top pod\n\n\t\t# Show metrics for all pods in the given namespace\n\t\tkubectl top pod --namespace=NAMESPACE\n\n\t\t# Show metrics for a given pod and its containers\n\t\tkubectl top pod POD_NAME --containers\n\n\t\t# Show metrics for the pods defined by label name=myLabel\n\t\tkubectl top pod -l name=myLabel\x00\n\t\t# Shut down foo.\n\t\tkubectl stop replicationcontroller foo\n\n\t\t# Stop pods and services with label name=myLabel.\n\t\tkubectl stop pods,services -l name=myLabel\n\n\t\t# Shut down the service defined in service.json\n\t\tkubectl stop -f service.json\n\n\t\t# Shut down all resources in the path/to/resources directory\n\t\tkubectl stop -f path/to/resources\x00\n\t\t# Start a single instance of nginx.\n\t\tkubectl run nginx --image=nginx\n\n\t\t# Start a single instance of hazelcast and let the container expose port 5701 .\n\t\tkubectl run hazelcast --image=hazelcast --port=5701\n\n\t\t# Start a single instance of hazelcast and set environment variables \"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --env=\"POD_NAMESPACE=default\"\n\n\t\t# Start a replicated instance of nginx.\n\t\tkubectl run nginx --image=nginx --replicas=5\n\n\t\t# Dry run. Print the corresponding API objects without creating them.\n\t\tkubectl run nginx --image=nginx --dry-run\n\n\t\t# Start a single instance of nginx, but overload the spec of the deployment with a partial set of values parsed from JSON.\n\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", \"spec\": { ... } }'\n\n\t\t# Start a pod of busybox and keep it in the foreground, don't restart it if it exits.\n\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n\n\t\t# Start the nginx container using the default command, but use custom arguments (arg1 .. argN) for that command.\n\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n\n\t\t# Start the nginx container using a different command and custom arguments.\n\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n\n\t\t# Start the perl container to compute \u03c0 to 2000 places and print it out.\n\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\n\n\t\t# Start the cron job to compute \u03c0 to 2000 places and print it out every 5 minutes.\n\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\x00\n\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-user' and effect 'NoSchedule'.\n\t\t# If a taint with that key and effect already exists, its value is replaced as specified.\n\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n\n\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect 'NoSchedule' if one exists.\n\t\tkubectl taint nodes foo dedicated:NoSchedule-\n\n\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n\t\tkubectl taint nodes foo dedicated-\x00\n\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n\t\tkubectl label pods foo unhealthy=true\n\n\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', overwriting any existing value.\n\t\tkubectl label --overwrite pods foo status=unhealthy\n\n\t\t# Update all pods in the namespace\n\t\tkubectl label pods --all status=unhealthy\n\n\t\t# Update a pod identified by the type and name in \"pod.json\"\n\t\tkubectl label -f pod.json status=unhealthy\n\n\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n\t\tkubectl label pods foo status=unhealthy --resource-version=1\n\n\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n\t\t# Does not require the --overwrite flag.\n\t\tkubectl label pods foo bar-\x00\n\t\t# Update pods of frontend-v1 using new replication controller data in frontend-v2.json.\n\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n\n\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n\n\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the image, and switching the\n\t\t# name of the replication controller.\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n\n\t\t# Update the pods of frontend by just changing the image, and keeping the old name.\n\t\tkubectl rolling-update frontend --image=image:v2\n\n\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to frontend-v2).\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback\x00\n\t\t# View the last-applied-configuration annotations by type/name in YAML.\n\t\tkubectl apply view-last-applied deployment/nginx\n\n\t\t# View the last-applied-configuration annotations by file in JSON\n\t\tkubectl apply view-last-applied -f deploy.yaml -o json\x00\n\t\tApply a configuration to a resource by filename or stdin.\n\t\tThis resource will be created if it doesn't exist yet.\n\t\tTo use 'apply', always create the resource initially with either 'apply' or 'create --save-config'.\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not use unless you are aware of what the current state is. See https://issues.k8s.io/34274.\x00\n\t\tConvert config files between different API versions. Both YAML\n\t\tand JSON formats are accepted.\n\n\t\tThe command takes filename, directory, or URL as input, and convert it into format\n\t\tof version specified by --output-version flag. If target version is not specified or\n\t\tnot supported, convert to latest version.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change to output destination.\x00\n\t\tCreate a ClusterRole.\x00\n\t\tCreate a ClusterRoleBinding for a particular ClusterRole.\x00\n\t\tCreate a RoleBinding for a particular Role or ClusterRole.\x00\n\t\tCreate a TLS secret from the given public/private key pair.\n\n\t\tThe public/private key pair must exist before hand. The public key certificate must be .PEM encoded and match the given private key.\x00\n\t\tCreate a configmap based on a file, directory, or specified literal value.\n\n\t\tA single configmap may package one or more key/value pairs.\n\n\t\tWhen creating a configmap based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a configmap based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the configmap.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a namespace with the specified name.\x00\n\t\tCreate a new secret for use with Docker registries.\n\n\t\tDockercfg secrets are used to authenticate against Docker registries.\n\n\t\tWhen using the Docker command line to push images, you can authenticate to a given registry by running\n\n\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n\n    That produces a ~/.dockercfg file that is used by subsequent 'docker push' and 'docker pull' commands to\n\t\tauthenticate to the registry. The email address is optional.\n\n\t\tWhen creating applications, you may have a Docker registry that requires authentication.  In order for the\n\t\tnodes to pull images on your behalf, they have to have the credentials.  You can provide this information\n\t\tby creating a dockercfg secret and attaching it to your service account.\x00\n\t\tCreate a pod disruption budget with the specified name, selector, and desired minimum available pods\x00\n\t\tCreate a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted.\x00\n\t\tCreate a resourcequota with the specified name, hard limits and optional scopes\x00\n\t\tCreate a role with single rule.\x00\n\t\tCreate a secret based on a file, directory, or specified literal value.\n\n\t\tA single secret may package one or more key/value pairs.\n\n\t\tWhen creating a secret based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a secret based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the secret.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a service account with the specified name.\x00\n\t\tCreate and run a particular image, possibly replicated.\n\n\t\tCreates a deployment or job to manage the created container(s).\x00\n\t\tCreates an autoscaler that automatically chooses and sets the number of pods that run in a kubernetes cluster.\n\n\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and creates an autoscaler that uses the given resource as a reference.\n\t\tAn autoscaler can automatically increase or decrease number of pods deployed within the system as needed.\x00\n\t\tDelete resources by filenames, stdin, resources and names, or by resources and label selector.\n\n\t\tJSON and YAML formats are accepted. Only one type of the arguments may be specified: filenames,\n\t\tresources and names, or resources and label selector.\n\n\t\tSome resources, such as pods, support graceful deletion. These resources define a default period\n\t\tbefore they are forcibly terminated (the grace period) but you may override that value with\n\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. Because these resources often\n\t\trepresent entities in the cluster, deletion may not be acknowledged immediately. If the node\n\t\thosting a pod is down or cannot reach the API server, termination may take significantly longer\n\t\tthan the grace period. To force delete a resource,\tyou must pass a grace\tperiod of 0 and specify\n\t\tthe --force flag.\n\n\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the pod's processes have been\n\t\tterminated, which can leave those processes running until the node detects the deletion and\n\t\tcompletes graceful deletion. If your processes use shared storage or talk to a remote API and\n\t\tdepend on the name of the pod to identify themselves, force deleting those pods may result in\n\t\tmultiple processes running on different machines using the same identification which may lead\n\t\tto data corruption or inconsistency. Only force delete pods when you are sure the pod is\n\t\tterminated, or if your application can tolerate multiple copies of the same pod running at once.\n\t\tAlso, if you force delete pods the scheduler may place new pods on those nodes before the node\n\t\thas released those resources and causing those pods to be evicted immediately.\n\n\t\tNote that the delete command does NOT do resource version checks, so if someone\n\t\tsubmits an update to a resource right when you submit a delete, their update\n\t\twill be lost along with the rest of the resource.\x00\n\t\tDeprecated: Gracefully shut down a resource by name or filename.\n\n\t\tThe stop command is deprecated, all its functionalities are covered by delete command.\n\t\tSee 'kubectl delete --help' for more details.\n\n\t\tAttempts to shut down and delete a resource that supports graceful termination.\n\t\tIf the resource is scalable it will be scaled to 0 before deletion.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n\n\t\tThe top-node command allows you to see the resource consumption of nodes.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n\n\t\tThe 'top pod' command allows you to see the resource consumption of pods.\n\n\t\tDue to the metrics pipeline delay, they may be unavailable for a few minutes\n\t\tsince pod creation.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage.\n\n\t\tThe top command allows you to see the resource consumption for nodes or pods.\n\n\t\tThis command requires Heapster to be correctly configured and working on the server. \x00\n\t\tDrain node in preparation for maintenance.\n\n\t\tThe given node will be marked unschedulable to prevent new pods from arriving.\n\t\t'drain' evicts the pods if the APIServer supports eviction\n\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use normal DELETE\n\t\tto delete the pods.\n\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot be deleted through\n\t\tthe API server).  If there are DaemonSet-managed pods, drain will not proceed\n\t\twithout --ignore-daemonsets, and regardless it will not delete any\n\t\tDaemonSet-managed pods, because those pods would be immediately replaced by the\n\t\tDaemonSet controller, which ignores unschedulable markings.  If there are any\n\t\tpods that are neither mirror pods nor managed by ReplicationController,\n\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete any pods unless you\n\t\tuse --force.  --force will also allow deletion to proceed if the managing resource of one\n\t\tor more pods is missing.\n\n\t\t'drain' waits for graceful termination. You should not operate on the machine until\n\t\tthe command completes.\n\n\t\tWhen you are ready to put the node back into service, use kubectl uncordon, which\n\t\twill make the node schedulable again.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)\x00\n\t\tEdit a resource from the default editor.\n\n\t\tThe edit command allows you to directly edit any API resource you can retrieve via the\n\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, or EDITOR\n\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for Windows.\n\t\tYou can edit multiple objects, although changes are applied one at a time. The command\n\t\taccepts filenames as well as command line arguments, although the files you point to must\n\t\tbe previously saved versions of resources.\n\n\t\tEditing is done with the API version used to fetch the resource.\n\t\tTo edit using a specific API version, fully-qualify the resource, version, and group.\n\n\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n\n\t\tThe flag --windows-line-endings can be used to force Windows line endings,\n\t\totherwise the default for your operating system will be used.\n\n\t\tIn the event an error occurs while updating, a temporary file will be created on disk\n\t\tthat contains your unapplied changes. The most common error when updating a resource\n\t\tis another editor changing the resource on the server. When this occurs, you will have\n\t\tto apply your changes to the newer version of the resource, or update your temporary\n\t\tsaved copy to include the latest resource version.\x00\n\t\tMark node as schedulable.\x00\n\t\tMark node as unschedulable.\x00\n\t\tOutput shell completion code for the specified shell (bash or zsh).\n\t\tThe shell code must be evaluated to provide interactive\n\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n\t\tthe .bash_profile.\n\n\t\tNote: this requires the bash-completion framework, which is not installed\n\t\tby default on Mac.  This can be installed by using homebrew:\n\n\t\t    $ brew install bash-completion\n\n\t\tOnce installed, bash_completion must be evaluated.  This can be done by adding the\n\t\tfollowing line to the .bash_profile\n\n\t\t    $ source $(brew --prefix)/etc/bash_completion\n\n\t\tNote for zsh users: [1] zsh completions are only supported in versions of zsh >= 5.2\x00\n\t\tPerform a rolling update of the given ReplicationController.\n\n\t\tReplaces the specified replication controller with a new replication controller by updating one pod at a time to use the\n\t\tnew PodTemplate. The new-controller.json must specify the same namespace as the\n\t\texisting replication controller and overwrite at least one (common) label in its replicaSelector.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)\x00\n\t\tReplace a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted. If replacing an existing resource, the\n\t\tcomplete resource spec must be provided. This can be obtained by\n\n\t\t    $ kubectl get TYPE NAME -o yaml\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or Job.\n\n\t\tScale also allows users to specify one or more preconditions for the scale action.\n\n\t\tIf --current-replicas or --resource-version is specified, it is validated before the\n\t\tscale is attempted, and it is guaranteed that the precondition holds true when the\n\t\tscale is sent to the server.\x00\n\t\tSet the latest last-applied-configuration annotations by setting it to match the contents of a file.\n\t\tThis results in the last-applied-configuration being updated as though 'kubectl apply -f <file>' was run,\n\t\twithout updating any other parts of the object.\x00\n\t\tTo proxy all of the kubernetes api and nothing else, use:\n\n\t\t    $ kubectl proxy --api-prefix=/\n\n\t\tTo proxy only part of the kubernetes api and also some static files:\n\n\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/api/\n\n\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n\n\t\tTo proxy the entire kubernetes api at a different root, use:\n\n\t\t    $ kubectl proxy --api-prefix=/custom/\n\n\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'\x00\n\t\tUpdate field(s) of a resource using strategic merge patch\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t  # Create a new TLS secret named tls-secret with the given key pair:\n\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/to/tls.key\x00\n\t  # Create a new namespace named my-namespace\n\t  kubectl create namespace my-namespace\x00\n\t  # Create a new secret named my-secret with keys for each file in folder bar\n\t  kubectl create secret generic my-secret --from-file=path/to/bar\n\n\t  # Create a new secret named my-secret with specified keys instead of names on disk\n\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/.ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n\n\t  # Create a new secret named my-secret with key1=supersecret and key2=topsecret\n\t  kubectl create secret generic my-secret --from-literal=key1=supersecret --from-literal=key2=topsecret\x00\n\t  # Create a new service account named my-service-account\n\t  kubectl create serviceaccount my-service-account\x00\n\t# Create a new ExternalName service named my-ns \n\tkubectl create service externalname my-ns --external-name bar.com\x00\n\tCreate an ExternalName service with the specified name.\n\n\tExternalName service references to an external DNS address instead of\n\tonly pods, which will allow application authors to reference services\n\tthat exist off platform, on other clusters, or locally.\x00\n\tHelp provides help for any command in the application.\n\tSimply type kubectl help [path to command] for full details.\x00\n    # Create a new LoadBalancer service named my-lbs\n    kubectl create service loadbalancer my-lbs --tcp=5678:8080\x00\n    # Create a new clusterIP service named my-cs\n    kubectl create service clusterip my-cs --tcp=5678:8080\n\n    # Create a new clusterIP service named my-cs (in headless mode)\n    kubectl create service clusterip my-cs --clusterip=\"None\"\x00\n    # Create a new deployment named my-dep that runs the busybox image.\n    kubectl create deployment my-dep --image=busybox\x00\n    # Create a new nodeport service named my-ns\n    kubectl create service nodeport my-ns --tcp=5678:8080\x00\n    # Dump current cluster state to stdout\n    kubectl cluster-info dump\n\n    # Dump current cluster state to /path/to/cluster-state\n    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n\n    # Dump all namespaces to stdout\n    kubectl cluster-info dump --all-namespaces\n\n    # Dump a set of namespaces to /path/to/cluster-state\n    kubectl cluster-info dump --namespaces default,kube-system --output-directory=/path/to/cluster-state\x00\n    Create a LoadBalancer service with the specified name.\x00\n    Create a clusterIP service with the specified name.\x00\n    Create a deployment with the specified name.\x00\n    Create a nodeport service with the specified name.\x00\n  Display addresses of the master and services with label kubernetes.io/cluster-service=true\n  To further debug and diagnose cluster problems, use 'kubectl cluster-info dump'.\x00A comma-delimited set of quota scopes that must all match each object tracked by the quota.\x00A comma-delimited set of resource=quantity pairs that define a hard limit.\x00A label selector to use for this budget. Only equality-based selector requirements are supported.\x00A label selector to use for this service. Only equality-based selector requirements are supported. If empty (the default) infer the selector from the replication controller or replica set.)\x00A schedule in the Cron format the job should be run with.\x00Additional external IP address (not managed by Kubernetes) to accept for the service. If this IP is routed to a node, the service can be accessed by this IP in addition to its generated service IP.\x00Apply a configuration to a resource by filename or stdin\x00Approve a certificate signing request\x00Assign your own ClusterIP or set to 'None' for a 'headless' service (no loadbalancing).\x00Attach to a running container\x00Auto-scale a Deployment, ReplicaSet, or ReplicationController\x00ClusterIP to be assigned to the service. Leave empty to auto-allocate, or set to 'None' to create a headless service.\x00ClusterRole this ClusterRoleBinding should reference\x00ClusterRole this RoleBinding should reference\x00Container name which will have its image upgraded. Only relevant when --image is specified, ignored otherwise. Required when using --image on a multi-container pod\x00Convert config files between different API versions\x00Copy files and directories to and from containers.\x00Create a ClusterRoleBinding for a particular ClusterRole\x00Create a LoadBalancer service.\x00Create a NodePort service.\x00Create a RoleBinding for a particular Role or ClusterRole\x00Create a TLS secret\x00Create a clusterIP service.\x00Create a configmap from a local file, directory or literal value\x00Create a deployment with the specified name.\x00Create a namespace with the specified name\x00Create a pod disruption budget with the specified name.\x00Create a quota with the specified name.\x00Create a resource by filename or stdin\x00Create a secret for use with a Docker registry\x00Create a secret from a local file, directory or literal value\x00Create a secret using specified subcommand\x00Create a service account with the specified name\x00Create a service using specified subcommand.\x00Create an ExternalName service.\x00Delete resources by filenames, stdin, resources and names, or by resources and label selector\x00Delete the specified cluster from the kubeconfig\x00Delete the specified context from the kubeconfig\x00Deny a certificate signing request\x00Deprecated: Gracefully shut down a resource by name or filename\x00Describe one or many contexts\x00Display Resource (CPU/Memory) usage of nodes\x00Display Resource (CPU/Memory) usage of pods\x00Display Resource (CPU/Memory) usage.\x00Display cluster info\x00Display clusters defined in the kubeconfig\x00Display merged kubeconfig settings or a specified kubeconfig file\x00Display one or many resources\x00Displays the current-context\x00Documentation of resources\x00Drain node in preparation for maintenance\x00Dump lots of relevant info for debugging and diagnosis\x00Edit a resource on the server\x00Email for Docker registry\x00Execute a command in a container\x00Explicit policy for when to pull container images. Required when --image is same as existing image, ignored otherwise.\x00Forward one or more local ports to a pod\x00Help about any command\x00IP to assign to the Load Balancer. If empty, an ephemeral IP will be created and used (cloud-provider specific).\x00Manage a deployment rollout\x00Mark node as schedulable\x00Mark node as unschedulable\x00Mark the provided resource as paused\x00Modify certificate resources.\x00Modify kubeconfig files\x00Name or number for the port on the container that the service should direct traffic to. Optional.\x00Only return logs after a specific date (RFC3339). Defaults to all logs. Only one of since-time / since may be used.\x00Output shell completion code for the specified shell (bash or zsh)\x00Password for Docker registry authentication\x00Path to PEM encoded public key certificate.\x00Path to private key associated with given certificate.\x00Perform a rolling update of the given ReplicationController\x00Precondition for resource version. Requires that the current resource version match this value in order to scale.\x00Print the client and server version information\x00Print the list of flags inherited by all commands\x00Print the logs for a container in a pod\x00Replace a resource by filename or stdin\x00Resume a paused resource\x00Role this RoleBinding should reference\x00Run a particular image on the cluster\x00Run a proxy to the Kubernetes API server\x00Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job\x00Set specific features on objects\x00Set the last-applied-configuration annotation on a live object to match the contents of a file.\x00Set the selector on a resource\x00Sets a cluster entry in kubeconfig\x00Sets a context entry in kubeconfig\x00Sets a user entry in kubeconfig\x00Sets an individual value in a kubeconfig file\x00Sets the current-context in a kubeconfig file\x00Show details of a specific resource or group of resources\x00Show the status of the rollout\x00Synonym for --target-port\x00Take a replication controller, service, deployment or pod and expose it as a new Kubernetes Service\x00The image for the container to run.\x00The image pull policy for the container. If left empty, this value will not be specified by the client and defaulted by the server\x00The minimum number or percentage of available pods this budget requires.\x00The name for the newly created object.\x00The name for the newly created object. If not specified, the name of the input resource will be used.\x00The name of the API generator to use, see http://kubernetes.io/docs/user-guide/kubectl-conventions/#generators for a list.\x00The name of the API generator to use. Currently there is only 1 generator.\x00The name of the API generator to use. There are 2 generators: 'service/v1' and 'service/v2'. The only difference between them is that service port in v1 is named 'default', while it is left unnamed in v2. Default is 'service/v2'.\x00The name of the generator to use for creating a service.  Only used if --expose is true\x00The network protocol for the service to be created. Default is 'TCP'.\x00The port that the service should serve on. Copied from the resource being exposed, if unspecified\x00The port that this container exposes.  If --expose is true, this is also the port used by the service that is created.\x00The type of secret to create\x00Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is 'ClusterIP'.\x00Undo a previous rollout\x00Update field(s) of a resource using strategic merge patch\x00Update image of a pod template\x00Update resource requests/limits on objects with pod templates\x00Update the annotations on a resource\x00Update the labels on a resource\x00Update the taints on one or more nodes\x00Username for Docker registry authentication\x00View latest last-applied-configuration annotations of a resource/object\x00View rollout history\x00kubectl controls the Kubernetes cluster manager\x00Project-Id-Version: kubernetes\nReport-Msgid-Bugs-To: EMAIL\nPOT-Creation-Date: 2017-09-02 01:36+0200\nPO-Revision-Date: 2017-09-02 01:36+0200\nLanguage: de_DE\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 8bit\nPlural-Forms: nplurals=2; plural=(n != 1);\nLast-Translator: Steffen Schmitz <steffenschmitz@hotmail.de>\nLanguage-Team: Steffen Schmitz <steffenschmitz@hotmail.de>\nX-Generator: Poedit 1.8.7.1\nX-Poedit-SourceCharset: UTF-8\n\x00\n\t\t # Erstellt ein ClusterRoleBinding f\u00fcr user1, user2 und group1 mit der ClusterRole cluster-admin\n\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Erstellt ein RoleBinding f\u00fcr user1, user2 und group1 mit der ClusterRole admin\n\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Erstellt eine neue ConfigMap mit dem Namen my-config basierend auf dem Ordner bar\n\t\t  kubectl create configmap my-config --from-file=path/to/bar\n\n\t\t  # Erstellt eine neue ConfigMap mit dem Namen my-config mit den angegebenen Keys statt des Dateinamens auf der Festplatte.\n\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1.txt --from-file=key2=/path/to/bar/file2.txt\n\n\t\t  # Erstellt eine neue ConfigMap mit dem Namen my-config mit key1=config1 und key2=config2\n\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-literal=key2=config2\x00\n\t\t  # Wenn keine .dockercfg Datei existiert, kann direkt ein dockercfg Secret erstellen mit:\n\t\t  kubectl create secret docker-registry my-secret --docker-server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL\x00\n\t\t  # Zeige Metriken f\u00fcr alle Nodes\n\t\t  kubectl top node\n\n\t\t  # Zeige Metriken f\u00fcr den gegebenen Node\n\t\t  kubectl top node NODE_NAME\x00\n\t\t# Wende die Konfiguration in pod.json auf einen Pod an.\n\t\tkubectl apply -f ./pod.json\n\n\t\t# Wende die JSON-Daten von stdin auf einen Pod an.\n\t\tcat pod.json | kubectl apply -f -\n\n\t\t# Hinweis: --prune ist noch in Alpha\n\t\t# Wende die Konfiguration, mit dem Label app=nginx, im manifest.yaml an und l\u00f6sche alle Resourcen, die nicht in der Datei sind oder nicht das Label app=nginx besitzen.\n\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n\n\t\t# Wende die Konfiguration im manifest.yaml an und l\u00f6sche alle ConfigMaps, die nicht in der Datei sind.\n\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/ConfigMap\x00\n\t\t# Auto-skaliere ein Deployment \"foo\", mit einer Anzahl an Pods zwischen 2 und 10, eine Ziel-CPU-Auslastung ist angegeben, sodass eine Standard-autoskalierungsregel verwendet wird:\n\t\tkubectl autoscale deployment foo --min=2 --max=10\n\n\t\t# Auto-skaliere einen Replication-Controller \"foo\", mit einer Anzahl an Pods zwischen 1 und 5, mit einer Ziel-CPU-Auslastung von 80%:\n\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80\x00\n\t\t# Konvertiere 'pod.yaml' zur neuesten Version und schreibe auf stdout.\n\t\tkubectl convert -f pod.yaml\n\n\t\t# Konvertiere den aktuellen Zustand der Resource, die in 'pod.yaml' angegeben ist, zur neuesten Version\n\t\t# und schreibe auf stdout im JSON-Format.\n\t\tkubectl convert -f pod.yaml --local -o json\n\n\t\t# Konvertiere alle Dateien im aktuellen Ordner zur neuesten Version und erstelle sie.\n\t\tkubectl convert -f . | kubectl create -f -\x00\n\t\t# Erstellt eine ClusterRole \"pod-reader\", die es Nutzern erlaubt \"get\", \"watch\" und \"list\" auf den Pods auszuf\u00fchren\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods\n\n\t\t# Erstellt eine ClusterRole \"pod-reader\" mit dem angegebenen ResourceName\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods --resource-name=readablepod\x00\n\t\t# Erstellt eine Role \"pod-reader\", die es dem Nutzer erlaubt \"get\", \"watch\" und \"list\" auf den Pods auszuf\u00fchren\n\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --resource=pods\n\n\t\t# Erstellt eine Role \"pod-reader\" mit dem angegebenen ResourceName\n\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --resource=pods --resource-name=readablepod\x00\n\t\t# Erstellt eine neue ResourceQuota my-quota\n\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,replicationcontrollers=2,resourcequotas=1,secrets=5,persistentvolumeclaims=10\n\n\t\t# Erstellt eine neue ResourceQuota best-effort\n\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort\x00\n\t\t# Erstellt ein Pod-Disruption-Budget my-pdb, dass alle Pods mit dem Label app=rails ausw\u00e4hlt\n\t\t# und sicherstellt, dass mindestens einer von ihnen zu jedem Zeitpunkt verf\u00fcgbar ist.\n\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-available=1\n\n\t\t# Erstellt ein Pod-Disruption-Budget my-pdb, dass alle Pods mit dem Label app=nginx ausw\u00e4hlt\n\t\t# und sicherstellt, dass mindestens die H\u00e4lfte der gew\u00e4hlten Pods zu jedem Zeitpunkt verf\u00fcgbar ist.\n\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%\x00\n\t\t# Erstellt einen Pod mit den Daten in pod.json.\n\t\tkubectl create -f ./pod.json\n\n\t\t# Erstellt einen Pod basierend auf den JSON-Daten von stdin.\n\t\tcat pod.json | kubectl create -f -\n\n\t\t# Ver\u00e4ndert die Daten in docker-registry.yaml in JSON mit dem v1 API Format und erstellt eine Resource mit den ver\u00e4nderten Daten.\n\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json\x00\n\t\t# Erstellt einen Service f\u00fcr einen replizierten nginx, der auf Port 80 h\u00f6rt und verbindet sich mit den Containern auf Port 8000.\n\t\tkubectl expose rc nginx --port=80 --target-port=8000\n\n\t\t# Erstellt einen Service f\u00fcr einen Replication-Controller, der \u00fcber type und name in \"nginx-controller.yaml\" identifiziert wird, auf Port 80 h\u00f6rt und verbindet sich mit den Containern auf Port 8000.\n\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n\n\t\t# Erstellt einen Service, mit dem Namen \"frontend\", f\u00fcr einen Pod valid-pod, der auf port 444 h\u00f6rt\n\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n\n\t\t# Erstellt einen zweiten Service basierend auf dem vorherigen Service, der den Container Port 8443 auf Port 443 mit dem Namen \"nginx-https\" anbietet\n\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-https\n\n\t\t# Erstellt einen Service f\u00fcr eine Replicated-Streaming-Application auf Port 4100, die UDP-Traffic verarbeitet und 'video-stream' hei\u00dft.\n\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-stream\n\n\t\t# Erstellt einen Service f\u00fcr einen replizierten nginx mit einem Replica-Set, dass auf Port 80 h\u00f6rt und verbindet sich mit den Containern auf Port 8000.\n\t\tkubectl expose rs nginx --port=80 --target-port=8000\n\n\t\t# Erstellt einen Service f\u00fcr ein nginx Deployment, dass auf Port 80 h\u00f6rt und verbindet sich mit den Containern auf Port 8000.\n\t\tkubectl expose deployment nginx --port=80 --target-port=8000\x00\n\t\t# L\u00f6scht einen Pod mit type und name aus pod.json.\n\t\tkubectl delete -f ./pod.json\n\n\t\t# L\u00f6scht einen Pod mit dem type und name aus den JSON-Daten von stdin.\n\t\tcat pod.json | kubectl delete -f -\n\n\t\t# L\u00f6scht Pods und Services mit den Namen \"baz\" und \"foo\"\n\t\tkubectl delete pod,service baz foo\n\n\t\t# L\u00f6scht Pods und Services mit dem Label name=myLabel.\n\t\tkubectl delete pods,services -l name=myLabel\n\n\t\t# L\u00f6scht einen Pod mit minimaler Verz\u00f6gerung\n\t\tkubectl delete pod foo --now\n\n\t\t# Erzwingt das L\u00f6schen eines Pods auf einem toten Node\n\t\tkubectl delete pod foo --grace-period=0 --force\n\n\t\t# L\u00f6scht alle Pods\n\t\tkubectl delete pods --all\x00\n\t\t# Beschreibt einen Knoten\n\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n\n\t\t# Beschreibt einen Pod\n\t\tkubectl describe pods/nginx\n\n\t\t# Beschreibt einen Pod mit type und name aus \"pod.json\"\n\t\tkubectl describe -f pod.json\n\n\t\t# Beschreibt alle Pods\n\t\tkubectl describe pods\n\n\t\t# Beschreibt Pods mit dem Label name=myLabel\n\t\tkubectl describe po -l name=myLabel\n\n\t\t# Beschreibt alle Pods, die vom ReplicationController 'frontend' verwaltet werden (rc-erstellte Pods\n\t\t# bekommen den Namen des rc als Prefix im Podnamen).\n\t\tkubectl describe pods frontend\x00\n\t\t# Leere den Knoten \"foo\", selbst wenn er Pods enth\u00e4lt, die nicht von einem ReplicationController, ReplicaSet, Job, DaemonSet oder StatefulSet verwaltet werden.\n\t\t$ kubectl drain foo --force\n\n\t\t# Wie zuvor, aber es wird abgebrochen, wenn er Pods enth\u00e4lt, die nicht von einem ReplicationController, ReplicaSet, Job, DaemonSet oder StatefulSet verwaltet werden und mit einer Schonfrist von 15 Minuten.\n\t\t$ kubectl drain foo --grace-period=900\x00\n\t\t# Bearbeite den Service 'docker-registry':\n\t\tkubectl edit svc/docker-registry\n\n\t\t# Benutze einen anderen Editor\n\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n\n\t\t# Bearbeite den Job 'myjob' in JSON mit dem v1 API Format:\n\t\tkubectl edit job.v1.batch/myjob -o json\n\n\t\t# Bearbeite das Deployment 'mydeployment' in YAML und speichere die ver\u00e4nderte Konfiguration in ihrer Annotation:\n\t\tkubectl edit deployment/mydeployment -o yaml --save-config\x00\n\t\t# Erhalte die Ausgabe vom Aufruf von 'date' auf dem Pod 123456-7890, mit dem ersten Container als Standard\n\t\tkubectl exec 123456-7890 date\n\n\t\t# Erhalte die Ausgabe vom Aufruf von 'date' im Ruby-Container aus dem Pod 123456-7890\n\t\tkubectl exec 123456-7890 -c ruby-container date\n\n\t\t# Wechsle in den Terminal-Modus und sende stdin zu 'bash' im Ruby-Container aus dem Pod 123456-7890\n\t\t# und sende stdout/stderr von 'bash' zur\u00fcck zum Client\n\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il\x00\n\t\t# Erhalte die Ausgabe vom laufenden Pod 123456-7890, mit dem ersten Container als Standard\n\t\tkubectl attach 123456-7890\n\n\t\t# Erhalte die Ausgabe vom Ruby-Container aus dem Pod 123456-7890\n\t\tkubectl attach 123456-7890 -c ruby-container\n\n\t\t# Wechsle in den Terminal-Modus und sende stdin zu 'bash' im Ruby-Container aus dem Pod 123456-7890\n\t\t# und sende stdout/stderr von 'bash' zur\u00fcck zum Client\n\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n\n\t\t# Erhalte die Ausgabe vom ersten Pod eines ReplicaSets nginx\n\t\tkubectl attach rs/nginx\n\t\t\x00\n\t\t# Erhalte die Dokumentation einer Resource und ihrer Felder\n\t\tkubectl explain pods\n\n\t\t# Erhalte die Dokumentation eines speziellen Felds einer Resource\n\t\tkubectl explain pods.spec.containers\x00\n\t\t# Installiere bash completion auf einem Mac mit homebrew\n\t\tbrew install bash-completion\n\t\tprintf \"\n# Bash completion support\nsource $(brew --prefix)/etc/bash_completion\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Lade den kubectl-Completion-Code f\u00fcr bash in der aktuellen Shell\n\t\tsource <(kubectl completion bash)\n\n\t\t# Schreibe den Bash-Completion-Code in eine Datei und source sie im .bash_profile\n\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n\t\tprintf \"\n# Kubectl shell completion\nsource '$HOME/.kube/completion.bash.inc'\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Lade den kubectl-Completion-Code f\u00fcr zsh[1] in die aktuelle Shell\n\t\tsource <(kubectl completion zsh)\x00\n\t\t# Liste alle Pods im ps-Format auf.\n\t\tkubectl get pods\n\n\t\t# Liste alle Pods im ps-Format mit zus\u00e4tzlichen Informationen (wie dem Knotennamen) auf.\n\t\tkubectl get pods -o wide\n\n\t\t# Liste alle einzelnen ReplicationController mit dem angegebenen Namen im ps-Format auf.\n\t\tkubectl get replicationcontroller web\n\n\t\t# Liste einen einzelnen Pod im JSON-Format auf.\n\t\tkubectl get -o json pod web-pod-13je7\n\n\t\t# Liste einen Pod mit Typ und Namen aus \"pod.yaml\" im JSON-Format auf.\n\t\tkubectl get -f pod.yaml -o json\n\n\t\t# Gib nur den phase-Wert des angegebenen Pods zur\u00fcck.\n\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n\n\t\t# Liste alle ReplicationController und Services im ps-Format auf.\n\t\tkubectl get rc,services\n\n\t\t# Liste eine oder mehrere Resourcen \u00fcber ihren Typ und Namen auf.\n\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n\n\t\t# Liste alle Resourcen mit verschiedenen Typen auf.\n\t\tkubectl get all\x00\n\t\t# H\u00f6rt lokal auf Port 5000 und 6000 und leitet Daten zum/vom Port 5000 und 6000 weiter an den Pod\n\t\tkubectl port-forward mypod 5000 6000\n\n\t\t# H\u00f6rt lokal auf Port 8888 und leitet an Port 5000 des Pods weiter\n\t\tkubectl port-forward mypod 8888:5000\n\n\t\t# H\u00f6rt auf einen zuf\u00e4lligen lokalen Port und leitet an Port 5000 des Pods weiter\n\t\tkubectl port-forward mypod :5000\n\n\t\t# H\u00f6rt auf einen zuf\u00e4lligen lokalen Port und leitet an Port 5000 des Pods weiter\n\t\tkubectl port-forward mypod 0:5000\x00\n\t\t# Markiere Knoten \"foo\" als schedulable.\n\t\t$ kubectl uncordon foo\x00\n\t\t# Markiere Knoten \"foo\" als unschedulable.\n\t\tkubectl cordon foo\x00\n\t\t# Aktualisiere einen Knoten teilweise mit einem Strategic-Merge-Patch\n\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Aktualisiere einen Knoten, mit type und name aus \"node.json\", mit einem Strategic-Merge-Patch\n\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Aktualisiere das Image eines Containers; spec.containers[*].name ist erforderlich, da es der Merge-Key ist\n\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n\n\t\t# Aktualisiere das Image eines Containers mit einem JSON-Patch mit Positional-Arrays\n\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", \"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'\x00\n\t\t# Gebe Optionen aus, die an alle Kommandos vererbt werden\n\t\tkubectl options\x00\n\t\t# Gebe die Adresse des Masters und des Cluster-Services aus\n\t\tkubectl cluster-info\x00\n\t\t# Gebe die Client- und Server-Versionen des aktuellen Kontexts aus\n\t\tkubectl version\x00\n\t\t# Gebe die unterst\u00fctzten API Versionen aus\n\t\tkubectl api-versions\x00\n\t\t# Ersetze einen Pod mit den Daten aus pod.json.\n\t\tkubectl replace -f ./pod.json\n\n\t\t# Ersetze einen Pod mit den JSON-Daten von stdin.\n\t\tcat pod.json | kubectl replace -f -\n\n\t\t# Setze die Pod-Image-Version (tag) eines einzelnen Containers zu v4\n\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/\x01:v4/' | kubectl replace -f -\n\n\t\t# Erzwinge das Ersetzen, L\u00f6schen und Neu-Erstellen der Resource\n\t\tkubectl replace --force -f ./pod.json\x00\n\t\t# Gib die Snapshot-Logs des Pods nginx mit nur einem Container zur\u00fcck\n\t\tkubectl logs nginx\n\n\t\t# Gib die Snapshot-Logs f\u00fcr die Pods mit dem Label app=nginx zur\u00fcck\n\t\tkubectl logs -lapp=nginx\n\n\t\t# Gib die Snapshot-Logs des zuvor gel\u00f6schten Ruby-Containers des Pods web-1 zur\u00fcck\n\t\tkubectl logs -p -c ruby web-1\n\n\t\t# Starte das Streaming der Logs vom Ruby-Container im Pod web-1\n\t\tkubectl logs -f -c ruby web-1\n\n\t\t# Zeige die letzten 20 Zeilen der Ausgabe des Pods nginx\n\t\tkubectl logs --tail=20 nginx\n\n\t\t# Zeige alle Logs der letzten Stunde des Pods nginx an\n\t\tkubectl logs --since=1h nginx\n\n\t\t# Gib die Snapshot-Logs des ersten Containers des Jobs hello zur\u00fcck\n\t\tkubectl logs job/hello\n\n\t\t# Gib die Snapshot-Logs des Containers nginx-1 eines Deployments nginx zur\u00fcck\n\t\tkubectl logs deployment/nginx -c nginx-1\x00\n\t\t# Starte einen Proxy zum Kubernetes-Apiserver auf Port 8011 und sende statische Inhalte von ./local/www/\n\t\tkubectl proxy --port=8011 --www=./local/www/\n\n\t\t# Starte einen Proxy zum Kubernetes-Apiserver auf einem zuf\u00e4lligen lokalen Port.\n\t\t# Der gew\u00e4hlte Port f\u00fcr den Server wird im stdout zur\u00fcckgegeben.\n\t\tkubectl proxy --port=0\n\n\t\t# Starte einen Proxy zum Kubernetes-Apiserver und \u00e4ndere das API-Prefix zu k8s-api\n\t\t# Damit ist die Pods-API bspw. unter localhost:8001/k8s-api/v1/pods/ erreichbar\n\t\tkubectl proxy --api-prefix=/k8s-api\x00\n\t\t# Skaliere ein ReplicaSet 'foo' auf 3.\n\t\tkubectl scale --replicas=3 rs/foo\n\n\t\t# Skaliere eine Resource mit type und name aus \"foo.yaml\" auf 3.\n\t\tkubectl scale --replicas=3 -f foo.yaml\n\n\t\t# Wenn die aktuelle Gr\u00f6\u00dfe des Deployments mysql 2 ist, skaliere mysql auf 3.\n\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n\n\t\t# Skaliere mehrere MultiplicationController.\n\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n\n\t\t# Skaliere den Job cron auf 3.\n\t\tkubectl scale --replicas=3 job/cron\x00\n\t\t# Setze die Last-Applied-Configuration einer Resource auf den Inhalt einer Datei.\n\t\tkubectl apply set-last-applied -f deploy.yaml\n\n\t\t# F\u00fchre Set-Last-Applied auf jeder Konfigurationsdatei in einem Ordner aus.\n\t\tkubectl apply set-last-applied -f path/\n\n\t\t# Setze die Last-Applied-Configuration einer Resource auf den Inhalt einer Datei; erstellt die Annotation, wenn sie noch nicht existiert.\n\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n\t\t\x00\n\t\t# Zeige Metriken f\u00fcr alle Pods im Namespace default\n\t\tkubectl top pod\n\n\t\t# Zeige Metriken f\u00fcr alle Pods im gegebenen namespace\n\t\tkubectl top pod --namespace=NAMESPACE\n\n\t\t# Zeige Metriken f\u00fcr den gebenen Pod und seine Container\n\t\tkubectl top pod POD_NAME --containers\n\n\t\t# Zeige Metriken f\u00fcr Pods mit dem Label name=myLabel\n\t\tkubectl top pod -l name=myLabel\x00\n\t\t# Stoppe foo.\n\t\tkubectl stop replicationcontroller foo\n\n\t\t# Stoppe Pods und Services mit dem Label name=myLabel.\n\t\tkubectl stop pods,services -l name=myLabel\n\n\t\t# Stoppe den in service.json definierten Service\n\t\tkubectl stop -f service.json\n\n\t\t# Stoppe alle Resourcen im Ordner path/to/resources\n\t\tkubectl stop -f path/to/resources\x00\n\t\t# Starte eine einzelne Instanz von nginx.\n\t\tkubectl run nginx --image=nginx\n\n\t\t# Starte eine einzelne Instanz von hazelcast und \u00f6ffne Port 5701 auf dem Container.\n\t\tkubectl run hazelcast --image=hazelcast --port=5701\n\n\t\t# Starte eine einzelne Instanz von hazelcast und setze die Umgebungs-variablen \"DNS_DOMAIN=cluster\" und \"POD_NAMESPACE=default\" im Container.\n\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --env=\"POD_NAMESPACE=default\"\n\n\t\t# Starte eine replizierte Instanz von nginx.\n\t\tkubectl run nginx --image=nginx --replicas=5\n\n\t\t# Testlauf. Zeige die zugeh\u00f6rigen API Objekte ohne sie zu erstellen.\n\t\tkubectl run nginx --image=nginx --dry-run\n\n\t\t# Starte eine einzelne Instanz von nginx, aber \u00fcberlade die Spec des Deployments mit einer Teilmenge von JSON-Werten.\n\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", \"spec\": { ... } }'\n\n\t\t# Starte einen busybox Pod und lass ihn im Vordergrund laufen; starte ihn nicht neu, wenn er existiert.\n\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n\n\t\t# Starte einen nginx-Container mit dem Standardkommando, aber \u00fcbergebe die Parameter (arg1 .. argN) an das Kommando.\n\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n\n\t\t# Starte den nginx-Container mit einem anderen Kommando und Parametern.\n\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n\n\t\t# Starte den perl-Container, um \u03c0 auf 2000 Stellen zu berechnen und gib es aus.\n\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\n\n\t\t# Starte den cron-Job, um \u03c0 auf 2000 Stellen zu berechnen und gib sie alle 5 Minuten aus.\n\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\x00\n\t\t# Aktualisiere Knoten 'foo' mit einem Taint mit dem Key 'dedicated', dem Value 'special-user' und dem Effect 'NoSchedule'.\n\t\t# Wenn ein Taint mit dem Key und Effect schon existiert, wird sein Value mit den gegebenen Werten ersetzt.\n\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n\n\t\t# Entferne vom Knoten 'foo' den Taint mit dem Key 'dedicated' und dem Effect 'NoSchedule', wenn er existiert.\n\t\tkubectl taint nodes foo dedicated:NoSchedule-\n\n\t\t# Entferne vom Knoten 'foo' alle Tains mit dem Key 'dedicated'\n\t\tkubectl taint nodes foo dedicated-\x00\n\t\t# Aktualisiere den Pod 'foo' mit dem Label 'unhealthy' und dem Value 'true'.\n\t\tkubectl label pods foo unhealthy=true\n\n\t\t# Aktualisiere den Pod 'foo' mit dem Label 'status' und dem Value 'unhealthy' und \u00fcberschreibe alle bisherigen Values.\n\t\tkubectl label --overwrite pods foo status=unhealthy\n\n\t\t# Aktualisiere alle Pods im Namespace\n\t\tkubectl label pods --all status=unhealthy\n\n\t\t# Aktualisiere den Pod mit type und name aus \"pod.json\"\n\t\tkubectl label -f pod.json status=unhealthy\n\n\t\t# Aktualisiere den Pod 'foo', wenn die Resource sich nicht von version 1 unterscheidet.\n\t\tkubectl label pods foo status=unhealthy --resource-version=1\n\n\t\t# Aktualisiere den Pod 'foo', indem das Label 'bar' gel\u00f6scht wird, wenn es existiert.\n\t\t# Ben\u00f6tigt kein --overwrite flag.\n\t\tkubectl label pods foo bar-\x00\n\t\t# Aktualisiere die Pods in frontend-v1 mit den neuen Replication-Controller Daten in frontend-v2.json.\n\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n\n\t\t# Aktualisiere die Pods in frontend-v1 mit den JSON-Daten von stdin.\n\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n\n\t\t# Aktualisiere die Pods von frontend-v1 auf frontend-v2, indem das Image ge\u00e4ndert wird und\n\t\t# der Name des ReplicationControllers.\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n\n\t\t# Aktualisiere die Pods in frontend, indem das Image ge\u00e4ndert, aber der alte Name beibehalten wird.\n\t\tkubectl rolling-update frontend --image=image:v2\n\n\t\t# Breche ein laufendes Rollout (von frontend-v1 zu frontend-v2) ab und mache es r\u00fcckg\u00e4ngig.\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback\x00\n\t\t# Zeige die Annotation Last-Applied-Configuration mit type/name in YAML an.\n\t\tkubectl apply view-last-applied deployment/nginx\n\n\t\t# Zeige die Annotation Last-applied-configuration mit der Datei in JSON an\n\t\tkubectl apply view-last-applied -f deploy.yaml -o json\x00\n\t\tWende eine Konfiguration auf eine Resource mit Dateinamen oder stdin an.\n\t\tDie Resource wird erstellt, wenn sie noch nicht existiert.\n\t\tUm 'apply' zu benutzen, muss die Resource initital mit 'apply' oder 'create --save-config' erstellt werden.\n\n\t\tJSON- und YAML-Formate werden akzeptiert.\n\n\t\tAlpha Disclaimer: Die --prune Funktion ist noch nicht fertig. Benutze sie nicht, wenn der aktuelle Zustand nicht bekannt ist. Siehe https://issues.k8s.io/34274.\x00\n\t\tKonvertiere Konfigurationsdateien zwischen API Versionen. Sowohl YAML-\n\t\talsauch JSON-Formate werden akzeptiert.\n\n\t\tDer Befehlt akzeptiert Dateinamen, Ordner  oder URL als Parameter und konvertiert es ins Format\n\t\tder mit --output-version gegebenen Version. Wenn die Zielversion nicht \n\t\tangegeben wird oder ung\u00fcltig ist, wird die neueste Version verwendet.\n\n\t\tDie Standardausgabe wird auf stdout im YAML-Format ausgegeben. Man kann die Option -o verwenden,\n\t\tum das Ausgabeziel festzulegen.\x00\n\t\tErstelle eine ClusterRole.\x00\n\t\tErstelle ein ClusterRoleBinding f\u00fcr eine bestimmte ClusterRole.\x00\n\t\tErstelle ein RoleBinding f\u00fcr eine bestimmte ClusterRole.\x00\n\t\tErstelle ein TLS-Secret vom gegebenen Public/Private-Schl\u00fcsselpaar.\n\n\t\tDas Public/Private-Schl\u00fcsselpaar muss vorab bestehen. Das Public-Key-Zertifikat muss im PEM-Format sein und zum gegebenen Private-Key passen.\x00\n\t\tErstelle eine ConfigMap basierend auf einer Datei, einem Order oder einem gegebenen Wert.\n\n\t\tEine einzelne ConfigMap kann eins oder mehr Key/Value-Paare beinhalten.\n\n\t\tWenn man eine ConfigMap von einer Datei erstellt, wird der Key standardm\u00e4\u00dfig der Name der Datei, und der Wert wird\n\t\tstandardm\u00e4\u00dfig der Dateiinhalt. Wenn der Dateiname ein ung\u00fcltiger Key ist, kann ein anderer Key angegeben werden.\n\n\t\tWenn man eine ConfigMap von einem Ordner erstellt, wird jede Datei, deren Name ein g\u00fcltiger Key ist\n\t\tin die ConfigMap aufgenommen. Jegliche Eintr\u00e4ge im Ordner, die keine regul\u00e4ren Dateien sind, werden ignoriert (z.B. SubDirectories, \n\t\tSymLinks, Devices, Pipes, usw).\x00\n\t\tErstelle einen Namespace mit dem gegebenen Namen.\x00\n\t\tErstelle ein Secret f\u00fcr die Benutzung mit Docker-Registries.\n\n\t\tDockercfg Secrets werden f\u00fcr die Authentifizierung bei Docker-Registries benutzt.\n\n\t\tWenn die Docker-command -line zum pushen von Images benutzt wird, kann man sich bei einer gegebenen Registry authentifizieren mit\n\n\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n\n    Dies produziert eine ~/.dockercfg Datei, die f\u00fcr folgende 'docker push' und 'docker pull' Befehle genutzt wird,\n\t\tum sich an der Registry zu authentifizieren. Die E-Mail-Adresse ist optional.\n\n\t\tBei der Erstellung von Applikationen, kann eine Docker-Registry eine Authentifizierung verlangen. Damit\n\t\tdeine Knoten in deinem Namen Images herunterladen k\u00f6nnen, ben\u00f6tigen sie die Credentials.  Man kann diese Information bereitstellen\n\t\tindem man ein dockercfg secret erstellt und zu seinem ServiceAccount hinzuf\u00fcgt.\x00\n\t\tErstelle ein Pod-Disruption-Budget mit dem gegebenen name, selector und der gew\u00fcnschten Mindestanzahl verf\u00fcgbarer Pods\x00\n\t\tErstelle eine Resource mit Dateinamen oder stdin.\n\n\t\tJSON- und YAML-Formate werden akzeptiert.\x00\n\t\tErstelle eine ResourceQuota mit dem gegebenen name, hard limits und optional scopes\x00\n\t\tErstelle eine Role mit einer einzelnen Rule.\x00\n\t\tErstelle ein Secret basierend auf einer Datei, einem Ordner oder einem gegebenen Wert.\n\n\t\tEin einzelnes Secret kann eins oder mehr Key/Value-Paare beinhalten.\n\n\t\tWenn man ein Secret von einer Datei erstellt, wird der Key standardm\u00e4\u00dfig der Name der Datei, und der Wert wird\n\t\tstandardm\u00e4\u00dfig der Dateiinhalt. Wenn der Dateiname ein ung\u00fcltiger Key ist, kann ein anderer Key angegeben werden.\n\n\t\tWenn man ein Secret von einem Ordner erstellt, wird jede Datei, deren Name ein g\u00fcltiger Key ist\n\t\tin das Secret aufgenommen. Jegliche Eintr\u00e4ge im Ordner, die keine regul\u00e4ren Dateien sind, werden ignoriert (z.B. SubDirectories, \n\t\tSymLinks, Devices, Pipes, usw).\x00\n\t\tErstelle einen ServiceAccount mit dem gegebenen Namen.\x00\n\t\tErstelle und starte ein bestimmtes Image, m\u00f6glicherweise repliziert.\n\n\t\tErstellt ein Deployment oder Job, um den/die erstellten Container zu verwalten.\x00\n\t\tErstellt einen AutoScaler der die Anzahl der Pods, die im Kubernetes-Cluster laufen, automatisch w\u00e4hlt und anpasst.\n\n\t\tSucht ein Deployment, ReplicaSet oder ReplicationController mit Namen name und erstellt einen AutoScaler, der die Resource als Referenz nimmt.\n\t\tEin AutoScaler kann die Anzahl der im System deployten Pods nach Bedarf erh\u00f6hen oder verringern.\x00\n\t\tL\u00f6scht die Resourcen mit Dateinamen, stdin, resources- und names- oder mit resources- und label-Selektor.\n\n\t\tJSON- und YAML-Formate werden akzeptiert. Nur einer der Parameter darf verwendet werden: Dateiname,\n\t\tresources- und names-, oder resources- und label-Selektor.\n\n\t\tManche Resourcen, zum Beispiel Pods, unterst\u00fctzen grazi\u00f6ses L\u00f6schen. Sie definieren einen Standardzeitraum\n\t\tbevor das L\u00f6schen erzwungen wird (grace-period), aber dieser Wert kann \u00fcberschrieben werden mit\n\t\tder --grace-period Option, oder mit --now, das die grace-period auf 1 setzt. Da diese Resourcen\n\t\th\u00e4ufig Einheiten im Cluster sind, kann das L\u00f6schen nicht immer direkt best\u00e4tigt werden. Wenn der Knoten\n\t\tauf dem der Pod l\u00e4uft nicht verf\u00fcgbar ist, oder den API Server nicht erreichen kann, kann das L\u00f6schen bedeutend l\u00e4nger dauern\n\t\tals die grace-period. Um das L\u00f6schen zu erzwingen, muss eine grace-period von 0 \u00fcbergeben werden\n\t\tund die --force Option gesetzt sein.\n\n\t\tWICHTIG: Ein erzwungenes L\u00f6schen wartet nicht auf die Best\u00e4tigung, dass der Prozess\n\t\tbeendet wurde, was den Prozess am Leben erhalten kann, bis der Knoten die L\u00f6schung erkennt\n\t\tund das grazi\u00f6se L\u00f6schen beendet. Wenn Prozesse Shared-Storage oder eine Remote-API verwenden und\n\t\tden Namen des Pods brauchen, um sich selbst zu identifizieren, kann das erzwungene L\u00f6schen dazu f\u00fchren, dass\n\t\tmehrere Prozesse auf der gleichen Maschine die gleiche Identit\u00e4t verwenden, was zu\n\t\tDatenkorruption oder Inkonsistenz f\u00fchren kann. Erzwinge nur ein L\u00f6schen, wenn sichergestellt ist, dass der Pod\n\t\tgel\u00f6scht ist, oder wenn die Anwendung mehrere gleichzeitig laufende Kopien verarbeiten kann.\n\t\tAu\u00dferdem kann es passieren, dass der Scheduler neue Pods auf dem Knoten plaziert, bevor der Knoten\n\t\tdie Resourcen freigegeben hat, sodass diese Pods direkt entfernt werden.\n\n\t\tBer\u00fccksichtige au\u00dferdem, dass der Delete-Befehl KEINE versionen pr\u00fcft, sodass, wenn jemand\n\t\tein Update einer Resource gleichzeitig mit Deinem delete anst\u00f6\u00dft, dessen Update\n\t\tmit dem Rest der Resource entfernt wird.\x00\n\t\tVeraltet: Fahre eine Resource mit Namen oder Dateinamen grazi\u00f6s heruter.\n\n\t\tDer Stop-Befehl ist veraltet und alle Funktioneren werden mit dem Delete-Befehl abgedeckt.\n\t\tSiehe 'kubectl delete --help' f\u00fcr mehr Details.\n\n\t\tVersucht eine Resource, die grazi\u00f6ses L\u00f6schen unterst\u00fctzt, herunterzufahren und zu l\u00f6schen.\n\t\tWenn die Resource skaliert werden kann, wird sie vor dem L\u00f6schen auf 0 skaliert.\x00\n\t\tZeigt die Resourcennutzung (CPU/Memory/Storage) von Knoten.\n\n\t\tDer top-node-Befehl erlaubt es, die Resourcennutzung von Knoten zu betrachten.\x00\n\t\tZeigt die Resourcennutzung (CPU/Memory/Storage) von Pods.\n\n\t\tDer 'top pod'-Befehl erlaubt es, die Resourcennutzung von Pods zu betrachten.\n\n\t\tAufgrund der Metrik-Pipeline-Verz\u00f6gerung, k\u00f6nnen sie f\u00fcr ein paar Minuten nicht verf\u00fcgbar sein,\n\t\tnach der Pod-Erstellung.\x00\n\t\tZeige Resourcennutzung (CPU/Memory/Storage).\n\n\t\tDer top-Befehl erlaubt es, die Resourcennutzung von Knoten oder Pods zu betrachten.\n\n\t\tDieser Befehl ben\u00f6tigt eine korrekt konfigurierte und funktionierende Heapster-Installation auf dem Server. \x00\n\t\tLeere Knoten, um eine Wartung vorzubereiten.\n\n\t\tDer gegebene Knoten wird als unschedulable markiert, um die Zuordnung von neuen Pods zu verhindern.\n\t\t'drain' entfernt den Pod, falls der API-Server die Entfernung unterst\u00fctzt\n\t\t(http://kubernetes.io/docs/admin/disruptions/). Wenn nicht, wird ein normales DELETE verwendet,\n\t\tum die Pods zu l\u00f6schen.\n\t\t'drain' entfernt oder l\u00f6scht alle Pods mit der Ausnahme von Mirror-Pods (welche vom API Server nicht gel\u00f6scht werden k\u00f6nnen)\n\t\tWenn DaemonSet-verwaltete Pods existieren, wird 'drain' nicht fortgesetzt\n\t\tohne die --ignore-daemonsets Option, und es wird in keinem Fall\n\t\tDaemonSet-verwaltete Pods l\u00f6schen, weil diese Pods direkt ersetzt w\u00fcrden durch den\n\t\tDaemonSet-Controller, der unschedulable Markierungen ignoriert.  Wenn es irgendwelche\n\t\tPods gibt, die weder Mirror-Pods sind, noch von einem ReplicationController,\n\t\tReplicaSet, DaemonSet, StatefulSet oder Job verwaltet werden, wird drain keine Pods l\u00f6schen, au\u00dfer die\n\t\t--force Option ist gesetzt.  --force l\u00e4sst das L\u00f6schen selbst zu, wenn die verwaltende Resource von einem\n\t\toder mehreren Pods fehlt.\n\n\t\t'drain' wartet auf eine grazi\u00f6se L\u00f6schung. Man sollte auf der Maschine nichts tun, w\u00e4hrend\n\t\tder Befehl l\u00e4uft.\n\n\t\tWenn der Knoten wieder bereit ist die Arbeit aufzunehmen, benutze kubectl uncordon,\n\t\twas den Knoten als schedulable markiert.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)\x00\n\t\tBearbeite eine Resource mit dem Standardeditor.\n\n\t\tDer edit-Befehl erlaubt es jede API Resource direkt zu bearbeiten, wenn sie mit den\n\t\tCommand-Line-Tools erreichbar ist. Er \u00f6ffnet den Editor, der in der KUBE_EDITOR oder EDITOR\n\t\tUmgebunsvariable festgelegt ist, oder 'vi' auf Linux und 'notepad' auf Windows.\n\t\tEs ist m\u00f6glich mehrere Objekte zu bearbeiten, aber die \u00c4nderungen werden nacheinander angewendet. Der Befehl\n\t\takzeptiert Dateinamen und Command-Line-Parameter, aber die verwendeten Dateien m\u00fcssen\n\t\tvorab gespeicherte Versionen von Resourcen sein.\n\n\t\tDie Bearbeitung verwendet die API Version, die genutzt wurde, um die Resource zu lesen.\n\t\tUm eine spezifische API Version zu verwenden, muss die vollst\u00e4ndige Resource, Version und Group angegeben werden.\n\n\t\tDas Standardformat ist YAML. Um mit JSON zu arbeiten, setze \"-o json\".\n\n\t\tDie Option --windows-line-endings kann benutzt werden, um Windows Zeilen-umbr\u00fcche zu verwenden,\n\t\tansonsten wird der Standard des Betriebssystems verwendet.\n\n\t\tFalls beim Update ein Fehler auftritt, wird eine tempor\u00e4re Datei auf der Festplatte angelegt,\n\t\tdie die nicht verarbeiteten \u00c4nderungen enth\u00e4lt. Der h\u00e4ufigste Fehler beim Bearbeiten einer Resource\n\t\tist ein anderer Editor, der die Resource auf dem Server \u00e4ndert. Wenn das auftritt, muss man\n\t\tseine \u00c4nderungen auf die neue Version anwenden oder seine tempor\u00e4re\n\t\tgespeicherte Kopie mit der neuesten Resourcenversion aktualisieren.\x00\n\t\tMarkiere Knoten als schedulable.\x00\n\t\tMarkiere Knoten als unschedulable.\x00\n\t\tGibt den Shell-Completion-Code f\u00fcr die angegebene Shell aus (bash oder zsh).\n\t\tDer Shell-Code muss f\u00fcr eine interaktive Vervollst\u00e4ndigung von kubectl \n\t\tausgewertet werden. Das ist m\u00f6glich, indem man\n\t\tdie .bash_profile Datei sourcet.\n\n\t\tHinweis: Dies setzt das Bash-Completion-Framework voraus, das auf dem Mac nicht standardm\u00e4\u00dfig installiert ist. \n\t\tEs kann mit homebrew installiert werden:\n\n\t\t    $ brew install bash-completion\n\n\t\tSobald es installiert ist, muss bash_completion ausgewertet werden. Dies wird erreicht, indem man\n\t\tdie folgende Zeile zur .bash_profile-Datei hinzuf\u00fcgt\n\n\t\t    $ source $(brew --prefix)/etc/bash_completion\n\n\t\tHinweis f\u00fcr zsh Nutzer: [1] zsh completions werden nur in Versionen von zsh >= 5.2 unterst\u00fctzt\x00\n\t\tF\u00fchre ein Rolling-Update des gegebenen ReplicationControllers aus.\n\n\t\tErsetzt den gegebenen ReplicationController mit einem neuen Replication-Controller, indem die neue PodTampleta Pod f\u00fcr Pod\n\t\tangewendet wird. Die new-controller.json muss den gleichen Namespace wie\n\t\tder aktuelle ReplicationController besitzen und mindestens ein gemeinsames Label im ReplicaSelector \u00fcberschreiben.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)\x00\n\t\tErsetze eine Resource mit Dateinamen oder stdin.\n\n\t\tJSON- and YAML-Formate werden akzeptiert. Wenn eine existierende Resource ersetzt wird,\n\t\tmuss die vollst\u00e4ndige spSpecec mitgegeben werden. Diese kann hiermit ausgelesen werden\n\n\t\t    $ kubectl get TYPE NAME -o yaml\n\n\t\tBitte konsultiere https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html um zu erfahren, ob ein Feld ver\u00e4ndert werden darf.\x00\n\t\tSetze eine neue Gr\u00f6\u00dfe f\u00fcr ein Deployment, ReplicaSet, Replication-Contoller oder Job.\n\n\t\tScale erlaubt es Nutzern eine oder mehr Voraussetzungen f\u00fcr die Aktion festzulegen.\n\n\t\tWenn --current-replicas oder --resource-version gegeben ist, wird es validiert, bevor\n\t\tscale versucht wird, und es wird garantiert, dass die Voraussetzungen erf\u00fcllt sind, wenn\n\t\tscale zum Server geschickt wird.\x00\n\t\tSetze die aktuelle Annotation Last-Applied-Configuration auf den Inhalt der Datei.\n\t\tDas bedeutet, dass Last-Applied-Configuration aktualisiert wird, als ob 'kubectl apply -f <file>' ausgef\u00fchrt wurde,\n\t\tohne andere Teile des Objekts zu aktualisieren.\x00\n\t\tProxy alle Teile der Kubernetes-API und sonst nichts:\n\n\t\t    $ kubectl proxy --api-prefix=/\n\n\t\tProxy nur bestimmte Teile der Kubernetes-API und einige statische Dateien:\n\n\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/api/\n\n\t\tDer Befehl oben l\u00e4sst dich 'curl localhost:8001/api/v1/pods' aufrufen.\n\n\t\tProxy alle Teile der Kubernetes-API auf einem anderen root:\n\n\t\t    $ kubectl proxy --api-prefix=/custom/\n\n\t\tDer Befehl oben l\u00e4sst dich 'curl localhost:8001/custom/api/v1/pods' aufrufen\x00\n\t\tAktualisiere Felder einer Resource mit einem Strategic-Merge-Patch\n\n\t\tJSON- und YAML-Formate werden akzeptiert.\n\n\t\tBitte konsultiere https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html um zu erfahren, ob ein Feld mutable ist.\x00\n\t  # Erstelle ein neues TLS Secret tl-secret mit dem gegebenen Schl\u00fcsselpaar:\n\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/to/tls.key\x00\n\t  # Erstelle einen neuen Namespace my-namespace\n\t  kubectl create namespace my-namespace\x00\n\t  # Erstelle ein neues Secret my-secret mit einem Key f\u00fcr jede Datei im Ordner bar\n\t  kubectl create secret generic my-secret --from-file=path/to/bar\n\n\t  # Erstelle ein neues Secret my-secret mit den gegebenen Keys statt der Namen auf der Festplatte\n\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/.ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n\n\t  # Erstelle ein neues Scret my-secret mit key1=supersecret und key2=topsecret\n\t  kubectl create secret generic my-secret --from-literal=key1=supersecret --from-literal=key2=topsecret\x00\n\t  # Erstelle einen neuen ServiceAccount my-service-account\n\t  kubectl create serviceaccount my-service-account\x00\n\t# Erstelle einen neuen ExternalName-Service my-ns \n\tkubectl create service externalname my-ns --external-name bar.com\x00\n\tErstelle einen ExternalName-Service mit den gegebenen Namen.\n\n\tExternalName service referenziert eine externe DNS Adresse statt\n\teines pods, was Anwendungsautoren erlaubt, einen Service zu referenzieren,\n\tder abseits der Platform, auf anderen Clustern oder lokal exisiert.\x00\n\tHelp hilft bei jedem Befehl in der Anwendung.\n\tGib einfach kubectl help [path to command] f\u00fcr alle Details ein.\x00\n    # Erstelle einen neuen LoadBalancer-Service my-lbs\n    kubectl create service loadbalancer my-lbs --tcp=5678:8080\x00\n    # Erstelle einen neuen ClusterIP-Service my-cs\n    kubectl create service clusterip my-cs --tcp=5678:8080\n\n    # Erstelle einen neuen ClusterIP-Service my-cs (im headless-Modus)\n    kubectl create service clusterip my-cs --clusterip=\"None\"\x00\n    # Erstelle ein neues Deployment my-dep, dass das busybox-Image nutzt.\n    kubectl create deployment my-dep --image=busybox\x00\n    # Erstelle einen neuen NodePort-Service my-ns\n    kubectl create service nodeport my-ns --tcp=5678:8080\x00\n    # Schreibe den aktuellen Cluster-Zustand auf stdout\n    kubectl cluster-info dump\n\n    # Schreibe aktuellen Cluster-Zustand in /path/to/cluster-state\n    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n\n    # Schreibe alle Namespaces auf stdout\n    kubectl cluster-info dump --all-namespaces\n\n    # Schreibe eine Menge an Namespaces in /path/to/cluster-state\n    kubectl cluster-info dump --namespaces default,kube-system --output-directory=/path/to/cluster-state\x00\n    Erstelle einen LoadBalancer-Service mit dem gegebenen Namen.\x00\n    Erstelle einen ClusterIP-Service mit dem gegebenen Namen.\x00\n    Erstelle ein Deployment mit dem gegebenen Namen.\x00\n    Erstelle einen NodePort-Service mit dem gegebenen Namen.\x00\n  Zeigt Adressen des Master und von Services mit Label kubernetes.io/cluster-service=true\n  F\u00fcr das weitere Debugging und die Diagnose von Clusterproblemen nutze 'kubectl cluster-info dump'.\x00Eine komma-separierte Menge von Quota-Scopes, die zu jedem Object passen muss, dass von der Quota betroffen ist.\x00Eine komma-separierte Menge von resource=quantity Paaren, die ein hartes Limit definieren.\x00Ein Label-Selektor, der f\u00fcr das Budget benutzt werden kann. Nur gleichheits-basierte Auswahlkriterien werden unterst\u00fctzt.\x00Ein Label-Selektor, der f\u00fcr den Service benutzt werden kann. Nur gleichheits-basierte Auswahlkriterien werden unterst\u00fctzt. Wenn er leer ist (standard), wird der Selektor vom ReplicationController oder ReplicaSet abgeleitet\x00Ein Schedule im Cron Format, dass der Job nutzen soll.\x00Zus\u00e4tzliche, externe IP Adressen (die nicht von Kubernetes verwaltet werden), die der Service akzeptieren soll. Wenn diese IP zu einem Knoten gerouted wird, kann der Service \u00fcber die IP angesprochen werden, zus\u00e4tzlich zu seiner generierten Service-IP.\x00Wende eine Konfiguration auf eine Resource \u00fcber den Dateinamen oder stdin an\x00Genehmige eine Certificate-Signing-Request\x00Weise Deine eigene ClusterIP zu oder setze sie auf 'None' f\u00fcr einen 'headless'-Service (kein LoadBalancing).\x00Weise einem laufenden Container zu\x00Auto-skaliere ein Deployment, ReplicaSet oder ReplicationController\x00ClusterIP, die dem Service zugewiesen werden soll. Freilassen, f\u00fcr automatische Zuweisung oder auf 'None' setzen f\u00fcr einen headless-Service.\x00ClusterRole, die das ClusterRoleBinding referenzieren soll\x00ClusterRole, die das RoleBinding referenzieren soll\x00Name des Containers dessen Image aktualisiert wird. Nur relevant, wenn --image angegeben ist, sonst ignoriert. Verpflichtend, wenn --image auf einem Multi-Container-Pod verwendet wird\x00Konvertiere Config-Dateien zwischen verschiedenen API Versionen\x00Kopiere Dateien und Ordner aus/in Container(n).\x00Erstelle ein ClusterRoleBinding f\u00fcr eine bestimmte ClusterRole\x00Erstelle einen LoadBalancer-Service.\x00Erstelle einen NodePort-Service.\x00Erstelle ein RoleBinding f\u00fcr eine bestimmte Role oder ClusterRole\x00Erstelle ein TLS-Secret\x00Erstelle einen ClusterIP-Service\x00Erstelle eine ConfigMap von einer Datei, einem Ordner oder einem festen Wert\x00Erstelle ein Deployment mit dem gegebenen Namen.\x00Erstelle einen Namespace mit dem gegebenen Namen\x00Erstelle ein Pod-Disruption-Budget mit dem gegebenen Namen.\x00Erstelle eine Quota mit dem gegebenen Namen.\x00Erstelle eine Resource von einer Datei oder stdin\x00Erstelle ein Secret f\u00fcr die Benutzung mit einer Docker-Registry\x00Erstelle ein Secret von einer lokalen Datei, einem Ordner oder einem festen Wert\x00Erstelle ein Secret mit dem angegebenen Sub-Befehl\x00Erstelle einen ServiceAccount mit dem gegebenen Namen\x00Erstelle einen Servuce mit dem angegebenen Sub-Befehl\x00Erstelle einen ExternalName-Service.\x00L\u00f6sche Resourcen von einer Datei, stdin, resources- und names- oder mit resources- und label-Selektor\x00L\u00f6sche das angegebene Cluster aus der kubeconfig\x00L\u00f6sche den angegebenen Kontext aus der kubeconfig\x00Lehne eine Certificate-Signing-Request ab\x00Veraltet: Grazi\u00f6ses herunterfahren einer Resource \u00fcber den Namen oder Dateinamen\x00Beschreibe einen oder mehrere Kontexte\x00Zeige Resourcennutzung (CPU/Memory) von Knoten\x00Zeige Resourcennutzung (CPU/Memory) von Pods\x00Zeige Resourcennutzung (CPU/Memory).\x00Zeige Cluster-Info\x00Zeige Cluster, die in der kubeconfig definiert sind\x00Zeige vereinte kubeconfig-Einstellungen oder die angegebene kubeconfig-Datei\x00Zeige eine oder mehrere Resourcen\x00Zeige den aktuellen Kontext\x00Dokumentation einer Resource\x00Leere Knoten, um eine Wartung vorzubereiten\x00Zeige viele relevante Informationen f\u00fcr Debugging und Diagnose\x00Bearbeite eine Resource auf dem Server\x00E-Mail f\u00fcr Docker-Registry\x00F\u00fchre einen Befehl im Container aus\x00Explizite Vorgabe, wann Container-Images gepullt werden. Verpflichtend, wenn --image ist gleich dem aktuellen Image ist - sonst ignoriert.\x00Leite einen oder mehrere lokale Ports an einen Pod weiter\x00Hilfe f\u00fcr jeden Befehl\x00IP, die dem Load-Balancer zugewiesen wird. Falls leer, wird eine tempor\u00e4re IP erstellt und verwendet (Cloud-Provider spezifisch)\x00Verwalte ein Deployment-Rollout\x00Markiere Knoten als schedulable\x00Markiere Knoten als unschedulable\x00Markiere die gegebene Resource als pausiert\x00Ver\u00e4ndere Certificate-Resources\x00Ver\u00e4ndere kubeconfig Dateien\x00Name oder Nummer des Ports in dem Container, zu dem der Service Daten leiten soll. Optional.\x00Zeige nur Logs nach einem bestimmten Datum (RFC3339) an. Zeigt standardm\u00e4\u00dfig alle logs. Es kann entweder since-time oder since benutzt werden.\x00Zeige Shell-Completion-Code f\u00fcr die angegebene Shell (bash oder zsh)\x00Passwort f\u00fcr die Authentifizierung bei der Docker-Registry\x00Pfad des Public-Key-Zertifikats im PEM-Format.\x00Pfad zum Private-Key, der zum gegebenen Zertifikat passt.\x00F\u00fchre ein Rolling-Update des gegebenen ReplicationControllers aus\x00Vorbedingung f\u00fcr Resource-Version. Verlangt, dass die aktuelle Resource-Version diesen Wert erf\u00fcllt, um zu skalieren.\x00Schreibt die Client- und Server-Versionsinformation\x00Schreibt die Liste von Optionen, die alle Befehle erben\x00Schreibt die Logs f\u00fcr einen Container in einem Pod\x00Ersetze eine Resource von einem Dateinamen oder stdin\x00Setze eine pausierte Resource fort\x00Role, die dieses RoleBinding referenzieren soll\x00Starte ein bestimmtes Image auf dem Cluster\x00Starte einen Proxy zum Kubernetes-API-Server\x00Setze eine neue Gr\u00f6\u00dfe f\u00fcr ein Deployment, ReplicaSet, ReplicationController oder Job\x00Setze bestimmte Features auf Objekten\x00Setze die Annotation Last-Applied-Configuration auf einem Live-Objekt auf den Inhalt einer Datei.\x00Setze den Selektor auf einer Resource\x00Setze einen Cluster-Eintrag in der kubeconfig\x00Setze einen Kontext-Eintrag in der kubeconfig\x00Setze einen User-Eintrag in der kubeconfig\x00Setze einen einzelnen Value in einer kubeconfig-Datei\x00Setze den aktuellen Kontext in einer kubeconfig-Datei\x00Zeige Details zu einer bestimmten Resource oder Gruppe von Resourcen\x00Zeige den Status des Rollout\x00Synonym f\u00fcr --target-port\x00Nehme einen Replication Controller, Service, Deployment oder Pod und biete ihn als neuen Kubernetes-Service an\x00Das Image, dass auf dem Container gestartet werden soll.\x00Die Image-Pull-Policy f\u00fcr den Container. Wenn leer, wird der Wert nicht vom Client gesetzt, sondern standardm\u00e4\u00dfig vom Server.\x00Die minimale Anzahl oder Prozentzahl von verf\u00fcgbaren Pods, die das Budget voraussetzt.\x00Der Name des neu erstellten Objekts.\x00Der Name des neu erstellten Objekts. Falls nicht angegeben, wird der Name der Input-Resource verwendet.\x00Der Name des zu verwendenden API-Generators. Siehe http://kubernetes.io/docs/user-guide/kubectl-conventions/#generators f\u00fcr eine \u00dcbersicht.\x00Der Name des zu verwendenden API-Generators. Zur Zeit gibt es nur einen Generator.\x00Der Name des zu verwendenden API-Generators. Es gibt zwei Generatoren: 'service/v1' und 'service/v2'. Der einzige Unterschied ist, dass der Serviceport in v1 'default' hei\u00dft, w\u00e4hrend er in v2 unbenannt bleibt. Standard ist 'service/v2'.\x00Der Name des zu verwendenden Generators, um einen Service zu erstellen. Wird nur benutzt, wenn --expose true ist\x00Das Netzwerkprotokoll, f\u00fcr den zu erstellenden Service. Standard ist 'TCP'.\x00Der Port auf den der Service h\u00f6ren soll. Wird von der angebotenen Resource kopiert, falls nicht angegeben\x00Der Port, den der Container anbietet.  Wenn --expose true ist, ist es auch der Port, den der zu erstellende Service verwendet\x00Der Typ des zu erstellenden Secrets\x00Typ f\u00fcr diesen Service: ClusterIP, NodePort oder LoadBalancer. Standard ist 'ClusterIP'.\x00Widerrufe ein vorheriges Rollout\x00Aktualisiere Felder einer Resource mit einem Strategic-Merge-Patch\x00Aktualisiere das Image einer Pod-Template\x00Aktualisiere Resourcen requests/limits auf Objekten mit Pod-Templates\x00Aktualisiere die Annotationen auf einer Resource\x00Aktualisiere die Labels auf einer Resource\x00Aktualisiere die Taints auf einem oder mehreren Knoten\x00Username f\u00fcr Authentifizierung bei der Docker-Registry\x00Zeige die aktuelle Annotation Last-Applied-Configuration einer Resource / eines Object\x00Zeige rollout-Verlauf\x00kubectl kontrolliert den Kubernetes-Cluster-Manager\x00")

func translationsKubectlDe_deLc_messagesK8sMoBytes() ([]byte, error) {
	return _translationsKubectlDe_deLc_messagesK8sMo, nil
}

func translationsKubectlDe_deLc_messagesK8sMo() (*asset, error) {
	bytes, err := translationsKubectlDe_deLc_messagesK8sMoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/de_DE/LC_MESSAGES/k8s.mo", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlDe_deLc_messagesK8sPo = []byte(`# German translation.
# Copyright (C) 2017
# This file is distributed under the same license as the Kubernetes package.
# FIRST AUTHOR steffenschmitz@hotmail.de, 2017.
#
#, fuzzy
msgid ""
msgstr ""
"Project-Id-Version: kubernetes\n"
"Report-Msgid-Bugs-To: EMAIL\n"
"POT-Creation-Date: 2017-09-02 01:36+0200\n"
"PO-Revision-Date: 2017-09-02 01:36+0200\n"
"Language: de_DE\n"
"MIME-Version: 1.0\n"
"Content-Type: text/plain; charset=UTF-8\n"
"Content-Transfer-Encoding: 8bit\n"
"Plural-Forms: nplurals=2; plural=(n != 1);\n"
"Last-Translator: Steffen Schmitz <steffenschmitz@hotmail.de>\n"
"Language-Team: Steffen Schmitz <steffenschmitz@hotmail.de>\n"
"X-Generator: Poedit 1.8.7.1\n"
"X-Poedit-SourceCharset: UTF-8\n"

#: pkg/kubectl/cmd/create_clusterrolebinding.go:35
msgid ""
"\n"
"\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the "
"cluster-admin ClusterRole\n"
"\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-"
"admin --user=user1 --user=user2 --group=group1"
msgstr ""
"\n"
"\t\t # Erstellt ein ClusterRoleBinding für user1, user2 und group1 mit der "
"ClusterRole cluster-admin\n"
"\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-"
"admin --user=user1 --user=user2 --group=group1"

#: pkg/kubectl/cmd/create_rolebinding.go:35
msgid ""
"\n"
"\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin "
"ClusterRole\n"
"\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --"
"user=user2 --group=group1"
msgstr ""
"\n"
"\t\t  # Erstellt ein RoleBinding für user1, user2 und group1 mit der "
"ClusterRole admin\n"
"\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --"
"user=user2 --group=group1"

#: pkg/kubectl/cmd/create_configmap.go:44
msgid ""
"\n"
"\t\t  # Create a new configmap named my-config based on folder bar\n"
"\t\t  kubectl create configmap my-config --from-file=path/to/bar\n"
"\n"
"\t\t  # Create a new configmap named my-config with specified keys instead "
"of file basenames on disk\n"
"\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1."
"txt --from-file=key2=/path/to/bar/file2.txt\n"
"\n"
"\t\t  # Create a new configmap named my-config with key1=config1 and "
"key2=config2\n"
"\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-"
"literal=key2=config2"
msgstr ""
"\n"
"\t\t  # Erstellt eine neue ConfigMap mit dem Namen my-config basierend auf "
"dem Ordner bar\n"
"\t\t  kubectl create configmap my-config --from-file=path/to/bar\n"
"\n"
"\t\t  # Erstellt eine neue ConfigMap mit dem Namen my-config mit den "
"angegebenen Keys statt des Dateinamens auf der Festplatte.\n"
"\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1."
"txt --from-file=key2=/path/to/bar/file2.txt\n"
"\n"
"\t\t  # Erstellt eine neue ConfigMap mit dem Namen my-config mit key1=config1"
" und key2=config2\n"
"\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-"
"literal=key2=config2"

#: pkg/kubectl/cmd/create_secret.go:135
msgid ""
"\n"
"\t\t  # If you don't already have a .dockercfg file, you can create a "
"dockercfg secret directly by using:\n"
"\t\t  kubectl create secret docker-registry my-secret --docker-"
"server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-"
"password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL"
msgstr ""
"\n"
"\t\t  # Wenn keine .dockercfg Datei existiert, kann direkt ein "
"dockercfg Secret erstellen mit:\n"
"\t\t  kubectl create secret docker-registry my-secret --docker-"
"server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-"
"password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL"

#: pkg/kubectl/cmd/top_node.go:65
msgid ""
"\n"
"\t\t  # Show metrics for all nodes\n"
"\t\t  kubectl top node\n"
"\n"
"\t\t  # Show metrics for a given node\n"
"\t\t  kubectl top node NODE_NAME"
msgstr ""
"\n"
"\t\t  # Zeige Metriken für alle Nodes\n"
"\t\t  kubectl top node\n"
"\n"
"\t\t  # Zeige Metriken für den gegebenen Node\n"
"\t\t  kubectl top node NODE_NAME"

#: pkg/kubectl/cmd/apply.go:84
msgid ""
"\n"
"\t\t# Apply the configuration in pod.json to a pod.\n"
"\t\tkubectl apply -f ./pod.json\n"
"\n"
"\t\t# Apply the JSON passed into stdin to a pod.\n"
"\t\tcat pod.json | kubectl apply -f -\n"
"\n"
"\t\t# Note: --prune is still in Alpha\n"
"\t\t# Apply the configuration in manifest.yaml that matches label app=nginx "
"and delete all the other resources that are not in the file and match label "
"app=nginx.\n"
"\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n"
"\n"
"\t\t# Apply the configuration in manifest.yaml and delete all the other "
"configmaps that are not in the file.\n"
"\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/"
"ConfigMap"
msgstr ""
"\n"
"\t\t# Wende die Konfiguration in pod.json auf einen Pod an.\n"
"\t\tkubectl apply -f ./pod.json\n"
"\n"
"\t\t# Wende die JSON-Daten von stdin auf einen Pod an.\n"
"\t\tcat pod.json | kubectl apply -f -\n"
"\n"
"\t\t# Hinweis: --prune ist noch in Alpha\n"
"\t\t# Wende die Konfiguration, mit dem Label app=nginx, im manifest.yaml "
"an und lösche alle Resourcen, die nicht in der Datei sind oder nicht das "
"Label app=nginx besitzen.\n"
"\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n"
"\n"
"\t\t# Wende die Konfiguration im manifest.yaml an und lösche alle ConfigMaps, "
"die nicht in der Datei sind.\n"
"\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/"
"ConfigMap"

#: pkg/kubectl/cmd/autoscale.go:40
#, c-format
msgid ""
"\n"
"\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and "
"10, no target CPU utilization specified so a default autoscaling policy will "
"be used:\n"
"\t\tkubectl autoscale deployment foo --min=2 --max=10\n"
"\n"
"\t\t# Auto scale a replication controller \"foo\", with the number of pods "
"between 1 and 5, target CPU utilization at 80%:\n"
"\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80"
msgstr ""
"\n"
"\t\t# Auto-skaliere ein Deployment \"foo\", mit einer Anzahl an Pods zwischen "
"2 und 10, eine Ziel-CPU-Auslastung ist angegeben, sodass eine Standard-"
"autoskalierungsregel verwendet wird:\n"
"\t\tkubectl autoscale deployment foo --min=2 --max=10\n"
"\n"
"\t\t# Auto-skaliere einen Replication-Controller \"foo\", mit einer Anzahl an "
"Pods zwischen 1 und 5, mit einer Ziel-CPU-Auslastung von 80%:\n"
"\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80"

#: pkg/kubectl/cmd/convert.go:49
msgid ""
"\n"
"\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n"
"\t\tkubectl convert -f pod.yaml\n"
"\n"
"\t\t# Convert the live state of the resource specified by 'pod.yaml' to the "
"latest version\n"
"\t\t# and print to stdout in json format.\n"
"\t\tkubectl convert -f pod.yaml --local -o json\n"
"\n"
"\t\t# Convert all files under current directory to latest version and create "
"them all.\n"
"\t\tkubectl convert -f . | kubectl create -f -"
msgstr ""
"\n"
"\t\t# Konvertiere 'pod.yaml' zur neuesten Version und schreibe auf stdout.\n"
"\t\tkubectl convert -f pod.yaml\n"
"\n"
"\t\t# Konvertiere den aktuellen Zustand der Resource, die in 'pod.yaml' "
"angegeben ist, zur neuesten Version\n"
"\t\t# und schreibe auf stdout im JSON-Format.\n"
"\t\tkubectl convert -f pod.yaml --local -o json\n"
"\n"
"\t\t# Konvertiere alle Dateien im aktuellen Ordner zur neuesten Version und "
"erstelle sie.\n"
"\t\tkubectl convert -f . | kubectl create -f -"

#: pkg/kubectl/cmd/create_clusterrole.go:34
msgid ""
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform "
"\"get\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods\n"
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods --resource-name=readablepod"
msgstr ""
"\n"
"\t\t# Erstellt eine ClusterRole \"pod-reader\", die es Nutzern erlaubt "
"\"get\", \"watch\" und \"list\" auf den Pods auszuführen\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods\n"
"\n"
"\t\t# Erstellt eine ClusterRole \"pod-reader\" mit dem angegebenen "
"ResourceName\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods --resource-name=readablepod"

#: pkg/kubectl/cmd/create_role.go:41
msgid ""
"\n"
"\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get"
"\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --"
"resource=pods\n"
"\n"
"\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --"
"resource=pods --resource-name=readablepod"
msgstr ""
"\n"
"\t\t# Erstellt eine Role \"pod-reader\", die es dem Nutzer erlaubt "
"\"get\", \"watch\" und \"list\" auf den Pods auszuführen\n"
"\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --"
"resource=pods\n"
"\n"
"\t\t# Erstellt eine Role \"pod-reader\" mit dem angegebenen ResourceName\n"
"\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --"
"resource=pods --resource-name=readablepod"

#: pkg/kubectl/cmd/create_quota.go:35
msgid ""
"\n"
"\t\t# Create a new resourcequota named my-quota\n"
"\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,"
"replicationcontrollers=2,resourcequotas=1,secrets=5,"
"persistentvolumeclaims=10\n"
"\n"
"\t\t# Create a new resourcequota named best-effort\n"
"\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort"
msgstr ""
"\n"
"\t\t# Erstellt eine neue ResourceQuota my-quota\n"
"\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,"
"replicationcontrollers=2,resourcequotas=1,secrets=5,"
"persistentvolumeclaims=10\n"
"\n"
"\t\t# Erstellt eine neue ResourceQuota best-effort\n"
"\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort"

#: pkg/kubectl/cmd/create_pdb.go:35
#, c-format
msgid ""
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=rails label\n"
"\t\t# and require at least one of them being available at any point in "
"time.\n"
"\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-"
"available=1\n"
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=nginx label\n"
"\t\t# and require at least half of the pods selected to be available at any "
"point in time.\n"
"\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%"
msgstr ""
"\n"
"\t\t# Erstellt ein Pod-Disruption-Budget my-pdb, dass alle Pods mit "
"dem Label app=rails auswählt\n"
"\t\t# und sicherstellt, dass mindestens einer von ihnen zu jedem Zeitpunkt "
"verfügbar ist.\n"
"\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-"
"available=1\n"
"\n"
"\t\t# Erstellt ein Pod-Disruption-Budget my-pdb, dass alle Pods mit "
"dem Label app=nginx auswählt\n"
"\t\t# und sicherstellt, dass mindestens die Hälfte der gewählten Pods zu "
"jedem Zeitpunkt verfügbar ist.\n"
"\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%"

#: pkg/kubectl/cmd/create.go:47
msgid ""
"\n"
"\t\t# Create a pod using the data in pod.json.\n"
"\t\tkubectl create -f ./pod.json\n"
"\n"
"\t\t# Create a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl create -f -\n"
"\n"
"\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format "
"then create the resource using the edited data.\n"
"\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json"
msgstr ""
"\n"
"\t\t# Erstellt einen Pod mit den Daten in pod.json.\n"
"\t\tkubectl create -f ./pod.json\n"
"\n"
"\t\t# Erstellt einen Pod basierend auf den JSON-Daten von stdin.\n"
"\t\tcat pod.json | kubectl create -f -\n"
"\n"
"\t\t# Verändert die Daten in docker-registry.yaml in JSON mit dem v1 API "
"Format und erstellt eine Resource mit den veränderten Daten.\n"
"\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json"

#: pkg/kubectl/cmd/expose.go:53
msgid ""
"\n"
"\t\t# Create a service for a replicated nginx, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose rc nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a replication controller identified by type and "
"name specified in \"nginx-controller.yaml\", which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a pod valid-pod, which serves on port 444 with "
"the name \"frontend\"\n"
"\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n"
"\n"
"\t\t# Create a second service based on the above service, exposing the "
"container port 8443 as port 443 with the name \"nginx-https\"\n"
"\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-"
"https\n"
"\n"
"\t\t# Create a service for a replicated streaming application on port 4100 "
"balancing UDP traffic and named 'video-stream'.\n"
"\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-"
"stream\n"
"\n"
"\t\t# Create a service for a replicated nginx using replica set, which "
"serves on port 80 and connects to the containers on port 8000.\n"
"\t\tkubectl expose rs nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for an nginx deployment, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose deployment nginx --port=80 --target-port=8000"
msgstr ""
"\n"
"\t\t# Erstellt einen Service für einen replizierten nginx, der auf Port 80 "
"hört und verbindet sich mit den Containern auf Port 8000.\n"
"\t\tkubectl expose rc nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Erstellt einen Service für einen Replication-Controller, der über type "
"und name in \"nginx-controller.yaml\" identifiziert wird, auf Port 80 "
"hört und verbindet sich mit den Containern auf Port 8000.\n"
"\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n"
"\n"
"\t\t# Erstellt einen Service, mit dem Namen \"frontend\", für einen Pod "
"valid-pod, der auf port 444 hört\n"
"\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n"
"\n"
"\t\t# Erstellt einen zweiten Service basierend auf dem vorherigen Service, "
"der den Container Port 8443 auf Port 443 mit dem Namen \"nginx-https\" "
"anbietet\n"
"\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-"
"https\n"
"\n"
"\t\t# Erstellt einen Service für eine Replicated-Streaming-Application auf "
"Port 4100, die UDP-Traffic verarbeitet und 'video-stream' heißt.\n"
"\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-"
"stream\n"
"\n"
"\t\t# Erstellt einen Service für einen replizierten nginx mit einem Replica-"
"Set, dass auf Port 80 hört und verbindet sich mit den Containern auf Port 8000.\n"
"\t\tkubectl expose rs nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Erstellt einen Service für ein nginx Deployment, dass auf Port 80 hört "
"und verbindet sich mit den Containern auf Port 8000.\n"
"\t\tkubectl expose deployment nginx --port=80 --target-port=8000"

#: pkg/kubectl/cmd/delete.go:68
msgid ""
"\n"
"\t\t# Delete a pod using the type and name specified in pod.json.\n"
"\t\tkubectl delete -f ./pod.json\n"
"\n"
"\t\t# Delete a pod based on the type and name in the JSON passed into "
"stdin.\n"
"\t\tcat pod.json | kubectl delete -f -\n"
"\n"
"\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n"
"\t\tkubectl delete pod,service baz foo\n"
"\n"
"\t\t# Delete pods and services with label name=myLabel.\n"
"\t\tkubectl delete pods,services -l name=myLabel\n"
"\n"
"\t\t# Delete a pod with minimal delay\n"
"\t\tkubectl delete pod foo --now\n"
"\n"
"\t\t# Force delete a pod on a dead node\n"
"\t\tkubectl delete pod foo --grace-period=0 --force\n"
"\n"
"\t\t# Delete all pods\n"
"\t\tkubectl delete pods --all"
msgstr ""
"\n"
"\t\t# Löscht einen Pod mit type und name aus pod.json.\n"
"\t\tkubectl delete -f ./pod.json\n"
"\n"
"\t\t# Löscht einen Pod mit dem type und name aus den JSON-Daten von stdin.\n"
"\t\tcat pod.json | kubectl delete -f -\n"
"\n"
"\t\t# Löscht Pods und Services mit den Namen \"baz\" und \"foo\"\n"
"\t\tkubectl delete pod,service baz foo\n"
"\n"
"\t\t# Löscht Pods und Services mit dem Label name=myLabel.\n"
"\t\tkubectl delete pods,services -l name=myLabel\n"
"\n"
"\t\t# Löscht einen Pod mit minimaler Verzögerung\n"
"\t\tkubectl delete pod foo --now\n"
"\n"
"\t\t# Erzwingt das Löschen eines Pods auf einem toten Node\n"
"\t\tkubectl delete pod foo --grace-period=0 --force\n"
"\n"
"\t\t# Löscht alle Pods\n"
"\t\tkubectl delete pods --all"

#: pkg/kubectl/cmd/describe.go:54
msgid ""
"\n"
"\t\t# Describe a node\n"
"\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n"
"\n"
"\t\t# Describe a pod\n"
"\t\tkubectl describe pods/nginx\n"
"\n"
"\t\t# Describe a pod identified by type and name in \"pod.json\"\n"
"\t\tkubectl describe -f pod.json\n"
"\n"
"\t\t# Describe all pods\n"
"\t\tkubectl describe pods\n"
"\n"
"\t\t# Describe pods by label name=myLabel\n"
"\t\tkubectl describe po -l name=myLabel\n"
"\n"
"\t\t# Describe all pods managed by the 'frontend' replication controller (rc-"
"created pods\n"
"\t\t# get the name of the rc as a prefix in the pod the name).\n"
"\t\tkubectl describe pods frontend"
msgstr ""
"\n"
"\t\t# Beschreibt einen Knoten\n"
"\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n"
"\n"
"\t\t# Beschreibt einen Pod\n"
"\t\tkubectl describe pods/nginx\n"
"\n"
"\t\t# Beschreibt einen Pod mit type und name aus \"pod.json\"\n"
"\t\tkubectl describe -f pod.json\n"
"\n"
"\t\t# Beschreibt alle Pods\n"
"\t\tkubectl describe pods\n"
"\n"
"\t\t# Beschreibt Pods mit dem Label name=myLabel\n"
"\t\tkubectl describe po -l name=myLabel\n"
"\n"
"\t\t# Beschreibt alle Pods, die vom ReplicationController 'frontend' "
"verwaltet werden (rc-erstellte Pods\n"
"\t\t# bekommen den Namen des rc als Prefix im Podnamen).\n"
"\t\tkubectl describe pods frontend"

#: pkg/kubectl/cmd/drain.go:165
msgid ""
"\n"
"\t\t# Drain node \"foo\", even if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n"
"\t\t$ kubectl drain foo --force\n"
"\n"
"\t\t# As above, but abort if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a "
"grace period of 15 minutes.\n"
"\t\t$ kubectl drain foo --grace-period=900"
msgstr ""
"\n"
"\t\t# Leere den Knoten \"foo\", selbst wenn er Pods enthält, die nicht von "
"einem ReplicationController, ReplicaSet, Job, DaemonSet oder StatefulSet "
"verwaltet werden.\n"
"\t\t$ kubectl drain foo --force\n"
"\n"
"\t\t# Wie zuvor, aber es wird abgebrochen, wenn er Pods enthält, die nicht von "
"einem ReplicationController, ReplicaSet, Job, DaemonSet oder StatefulSet "
"verwaltet werden und mit einer Schonfrist von 15 Minuten.\n"
"\t\t$ kubectl drain foo --grace-period=900"

#: pkg/kubectl/cmd/edit.go:80
msgid ""
"\n"
"\t\t# Edit the service named 'docker-registry':\n"
"\t\tkubectl edit svc/docker-registry\n"
"\n"
"\t\t# Use an alternative editor\n"
"\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n"
"\n"
"\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n"
"\t\tkubectl edit job.v1.batch/myjob -o json\n"
"\n"
"\t\t# Edit the deployment 'mydeployment' in YAML and save the modified "
"config in its annotation:\n"
"\t\tkubectl edit deployment/mydeployment -o yaml --save-config"
msgstr ""
"\n"
"\t\t# Bearbeite den Service 'docker-registry':\n"
"\t\tkubectl edit svc/docker-registry\n"
"\n"
"\t\t# Benutze einen anderen Editor\n"
"\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n"
"\n"
"\t\t# Bearbeite den Job 'myjob' in JSON mit dem v1 API Format:\n"
"\t\tkubectl edit job.v1.batch/myjob -o json\n"
"\n"
"\t\t# Bearbeite das Deployment 'mydeployment' in YAML und speichere die "
"veränderte Konfiguration in ihrer Annotation:\n"
"\t\tkubectl edit deployment/mydeployment -o yaml --save-config"

#: pkg/kubectl/cmd/exec.go:41
msgid ""
"\n"
"\t\t# Get output from running 'date' from pod 123456-7890, using the first "
"container by default\n"
"\t\tkubectl exec 123456-7890 date\n"
"\n"
"\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n"
"\t\tkubectl exec 123456-7890 -c ruby-container date\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il"
msgstr ""
"\n"
"\t\t# Erhalte die Ausgabe vom Aufruf von 'date' auf dem Pod 123456-7890, mit "
"dem ersten Container als Standard\n"
"\t\tkubectl exec 123456-7890 date\n"
"\n"
"\t\t# Erhalte die Ausgabe vom Aufruf von 'date' im Ruby-Container aus dem Pod "
"123456-7890\n"
"\t\tkubectl exec 123456-7890 -c ruby-container date\n"
"\n"
"\t\t# Wechsle in den Terminal-Modus und sende stdin zu 'bash' im Ruby-Container "
"aus dem Pod 123456-7890\n"
"\t\t# und sende stdout/stderr von 'bash' zurück zum Client\n"
"\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il"

#: pkg/kubectl/cmd/attach.go:42
msgid ""
"\n"
"\t\t# Get output from running pod 123456-7890, using the first container by "
"default\n"
"\t\tkubectl attach 123456-7890\n"
"\n"
"\t\t# Get output from ruby-container from pod 123456-7890\n"
"\t\tkubectl attach 123456-7890 -c ruby-container\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n"
"\n"
"\t\t# Get output from the first pod of a ReplicaSet named nginx\n"
"\t\tkubectl attach rs/nginx\n"
"\t\t"
msgstr ""
"\n"
"\t\t# Erhalte die Ausgabe vom laufenden Pod 123456-7890, mit dem ersten "
"Container als Standard\n"
"\t\tkubectl attach 123456-7890\n"
"\n"
"\t\t# Erhalte die Ausgabe vom Ruby-Container aus dem Pod 123456-7890\n"
"\t\tkubectl attach 123456-7890 -c ruby-container\n"
"\n"
"\t\t# Wechsle in den Terminal-Modus und sende stdin zu 'bash' im Ruby-Container "
"aus dem Pod 123456-7890\n"
"\t\t# und sende stdout/stderr von 'bash' zurück zum Client\n"
"\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n"
"\n"
"\t\t# Erhalte die Ausgabe vom ersten Pod eines ReplicaSets nginx\n"
"\t\tkubectl attach rs/nginx\n"
"\t\t"

#: pkg/kubectl/cmd/explain.go:39
msgid ""
"\n"
"\t\t# Get the documentation of the resource and its fields\n"
"\t\tkubectl explain pods\n"
"\n"
"\t\t# Get the documentation of a specific field of a resource\n"
"\t\tkubectl explain pods.spec.containers"
msgstr ""
"\n"
"\t\t# Erhalte die Dokumentation einer Resource und ihrer Felder\n"
"\t\tkubectl explain pods\n"
"\n"
"\t\t# Erhalte die Dokumentation eines speziellen Felds einer Resource\n"
"\t\tkubectl explain pods.spec.containers"

#: pkg/kubectl/cmd/completion.go:65
msgid ""
"\n"
"\t\t# Install bash completion on a Mac using homebrew\n"
"\t\tbrew install bash-completion\n"
"\t\tprintf \"\n"
"# Bash completion support\n"
"source $(brew --prefix)/etc/bash_completion\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for bash into the current shell\n"
"\t\tsource <(kubectl completion bash)\n"
"\n"
"\t\t# Write bash completion code to a file and source if from .bash_profile\n"
"\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n"
"\t\tprintf \"\n"
"# Kubectl shell completion\n"
"source '$HOME/.kube/completion.bash.inc'\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for zsh[1] into the current shell\n"
"\t\tsource <(kubectl completion zsh)"
msgstr ""
"\n"
"\t\t# Installiere bash completion auf einem Mac mit homebrew\n"
"\t\tbrew install bash-completion\n"
"\t\tprintf \"\n"
"# Bash completion support\n"
"source $(brew --prefix)/etc/bash_completion\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Lade den kubectl-Completion-Code für bash in der aktuellen Shell\n"
"\t\tsource <(kubectl completion bash)\n"
"\n"
"\t\t# Schreibe den Bash-Completion-Code in eine Datei und source sie im "
".bash_profile\n"
"\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n"
"\t\tprintf \"\n"
"# Kubectl shell completion\n"
"source '$HOME/.kube/completion.bash.inc'\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Lade den kubectl-Completion-Code für zsh[1] in die aktuelle Shell\n"
"\t\tsource <(kubectl completion zsh)"

#: pkg/kubectl/cmd/get.go:64
msgid ""
"\n"
"\t\t# List all pods in ps output format.\n"
"\t\tkubectl get pods\n"
"\n"
"\t\t# List all pods in ps output format with more information (such as node "
"name).\n"
"\t\tkubectl get pods -o wide\n"
"\n"
"\t\t# List a single replication controller with specified NAME in ps output "
"format.\n"
"\t\tkubectl get replicationcontroller web\n"
"\n"
"\t\t# List a single pod in JSON output format.\n"
"\t\tkubectl get -o json pod web-pod-13je7\n"
"\n"
"\t\t# List a pod identified by type and name specified in \"pod.yaml\" in "
"JSON output format.\n"
"\t\tkubectl get -f pod.yaml -o json\n"
"\n"
"\t\t# Return only the phase value of the specified pod.\n"
"\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n"
"\n"
"\t\t# List all replication controllers and services together in ps output "
"format.\n"
"\t\tkubectl get rc,services\n"
"\n"
"\t\t# List one or more resources by their type and names.\n"
"\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n"
"\n"
"\t\t# List all resources with different types.\n"
"\t\tkubectl get all"
msgstr ""
"\n"
"\t\t# Liste alle Pods im ps-Format auf.\n"
"\t\tkubectl get pods\n"
"\n"
"\t\t# Liste alle Pods im ps-Format mit zusätzlichen Informationen (wie dem "
"Knotennamen) auf.\n"
"\t\tkubectl get pods -o wide\n"
"\n"
"\t\t# Liste alle einzelnen ReplicationController mit dem angegebenen Namen im "
"ps-Format auf.\n"
"\t\tkubectl get replicationcontroller web\n"
"\n"
"\t\t# Liste einen einzelnen Pod im JSON-Format auf.\n"
"\t\tkubectl get -o json pod web-pod-13je7\n"
"\n"
"\t\t# Liste einen Pod mit Typ und Namen aus \"pod.yaml\" im JSON-Format auf.\n"
"\t\tkubectl get -f pod.yaml -o json\n"
"\n"
"\t\t# Gib nur den phase-Wert des angegebenen Pods zurück.\n"
"\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n"
"\n"
"\t\t# Liste alle ReplicationController und Services im ps-Format auf.\n"
"\t\tkubectl get rc,services\n"
"\n"
"\t\t# Liste eine oder mehrere Resourcen über ihren Typ und Namen auf.\n"
"\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n"
"\n"
"\t\t# Liste alle Resourcen mit verschiedenen Typen auf.\n"
"\t\tkubectl get all"

#: pkg/kubectl/cmd/portforward.go:53
msgid ""
"\n"
"\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports "
"5000 and 6000 in the pod\n"
"\t\tkubectl port-forward mypod 5000 6000\n"
"\n"
"\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 8888:5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod :5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 0:5000"
msgstr ""
"\n"
"\t\t# Hört lokal auf Port 5000 und 6000 und leitet Daten zum/vom Port 5000 und "
"6000 weiter an den Pod\n"
"\t\tkubectl port-forward mypod 5000 6000\n"
"\n"
"\t\t# Hört lokal auf Port 8888 und leitet an Port 5000 des Pods weiter\n"
"\t\tkubectl port-forward mypod 8888:5000\n"
"\n"
"\t\t# Hört auf einen zufälligen lokalen Port und leitet an Port 5000 des Pods "
"weiter\n"
"\t\tkubectl port-forward mypod :5000\n"
"\n"
"\t\t# Hört auf einen zufälligen lokalen Port und leitet an Port 5000 des Pods "
"weiter\n"
"\t\tkubectl port-forward mypod 0:5000"

#: pkg/kubectl/cmd/drain.go:118
msgid ""
"\n"
"\t\t# Mark node \"foo\" as schedulable.\n"
"\t\t$ kubectl uncordon foo"
msgstr ""
"\n"
"\t\t# Markiere Knoten \"foo\" als schedulable.\n"
"\t\t$ kubectl uncordon foo"

#: pkg/kubectl/cmd/drain.go:93
msgid ""
"\n"
"\t\t# Mark node \"foo\" as unschedulable.\n"
"\t\tkubectl cordon foo"
msgstr ""
"\n"
"\t\t# Markiere Knoten \"foo\" als unschedulable.\n"
"\t\tkubectl cordon foo"

#: pkg/kubectl/cmd/patch.go:66
msgid ""
"\n"
"\t\t# Partially update a node using strategic merge patch\n"
"\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Partially update a node identified by the type and name specified in "
"\"node.json\" using strategic merge patch\n"
"\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Update a container's image; spec.containers[*].name is required "
"because it's a merge key\n"
"\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":"
"\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n"
"\n"
"\t\t# Update a container's image using a json patch with positional arrays\n"
"\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", "
"\"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'"
msgstr ""
"\n"
"\t\t# Aktualisiere einen Knoten teilweise mit einem Strategic-Merge-Patch\n"
"\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Aktualisiere einen Knoten, mit type und name aus \"node.json\", mit einem "
"Strategic-Merge-Patch\n"
"\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Aktualisiere das Image eines Containers; spec.containers[*].name ist "
"erforderlich, da es der Merge-Key ist\n"
"\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":"
"\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n"
"\n"
"\t\t# Aktualisiere das Image eines Containers mit einem JSON-Patch mit "
"Positional-Arrays\n"
"\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", "
"\"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'"

#: pkg/kubectl/cmd/options.go:29
msgid ""
"\n"
"\t\t# Print flags inherited by all commands\n"
"\t\tkubectl options"
msgstr ""
"\n"
"\t\t# Gebe Optionen aus, die an alle Kommandos vererbt werden\n"
"\t\tkubectl options"

#: pkg/kubectl/cmd/clusterinfo.go:41
msgid ""
"\n"
"\t\t# Print the address of the master and cluster services\n"
"\t\tkubectl cluster-info"
msgstr ""
"\n"
"\t\t# Gebe die Adresse des Masters und des Cluster-Services aus\n"
"\t\tkubectl cluster-info"

#: pkg/kubectl/cmd/version.go:32
msgid ""
"\n"
"\t\t# Print the client and server versions for the current context\n"
"\t\tkubectl version"
msgstr ""
"\n"
"\t\t# Gebe die Client- und Server-Versionen des aktuellen Kontexts aus\n"
"\t\tkubectl version"

#: pkg/kubectl/cmd/apiversions.go:34
msgid ""
"\n"
"\t\t# Print the supported API versions\n"
"\t\tkubectl api-versions"
msgstr ""
"\n"
"\t\t# Gebe die unterstützten API Versionen aus\n"
"\t\tkubectl api-versions"

#: pkg/kubectl/cmd/replace.go:50
msgid ""
"\n"
"\t\t# Replace a pod using the data in pod.json.\n"
"\t\tkubectl replace -f ./pod.json\n"
"\n"
"\t\t# Replace a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl replace -f -\n"
"\n"
"\t\t# Update a single-container pod's image version (tag) to v4\n"
"\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/:v4/' | "
"kubectl replace -f -\n"
"\n"
"\t\t# Force replace, delete and then re-create the resource\n"
"\t\tkubectl replace --force -f ./pod.json"
msgstr ""
"\n"
"\t\t# Ersetze einen Pod mit den Daten aus pod.json.\n"
"\t\tkubectl replace -f ./pod.json\n"
"\n"
"\t\t# Ersetze einen Pod mit den JSON-Daten von stdin.\n"
"\t\tcat pod.json | kubectl replace -f -\n"
"\n"
"\t\t# Setze die Pod-Image-Version (tag) eines einzelnen Containers zu v4\n"
"\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/:v4/' | "
"kubectl replace -f -\n"
"\n"
"\t\t# Erzwinge das Ersetzen, Löschen und Neu-Erstellen der Resource\n"
"\t\tkubectl replace --force -f ./pod.json"

#: pkg/kubectl/cmd/logs.go:40
msgid ""
"\n"
"\t\t# Return snapshot logs from pod nginx with only one container\n"
"\t\tkubectl logs nginx\n"
"\n"
"\t\t# Return snapshot logs for the pods defined by label app=nginx\n"
"\t\tkubectl logs -lapp=nginx\n"
"\n"
"\t\t# Return snapshot of previous terminated ruby container logs from pod "
"web-1\n"
"\t\tkubectl logs -p -c ruby web-1\n"
"\n"
"\t\t# Begin streaming the logs of the ruby container in pod web-1\n"
"\t\tkubectl logs -f -c ruby web-1\n"
"\n"
"\t\t# Display only the most recent 20 lines of output in pod nginx\n"
"\t\tkubectl logs --tail=20 nginx\n"
"\n"
"\t\t# Show all logs from pod nginx written in the last hour\n"
"\t\tkubectl logs --since=1h nginx\n"
"\n"
"\t\t# Return snapshot logs from first container of a job named hello\n"
"\t\tkubectl logs job/hello\n"
"\n"
"\t\t# Return snapshot logs from container nginx-1 of a deployment named "
"nginx\n"
"\t\tkubectl logs deployment/nginx -c nginx-1"
msgstr ""
"\n"
"\t\t# Gib die Snapshot-Logs des Pods nginx mit nur einem Container zurück\n"
"\t\tkubectl logs nginx\n"
"\n"
"\t\t# Gib die Snapshot-Logs für die Pods mit dem Label app=nginx zurück\n"
"\t\tkubectl logs -lapp=nginx\n"
"\n"
"\t\t# Gib die Snapshot-Logs des zuvor gelöschten Ruby-Containers des Pods "
"web-1 zurück\n"
"\t\tkubectl logs -p -c ruby web-1\n"
"\n"
"\t\t# Starte das Streaming der Logs vom Ruby-Container im Pod web-1\n"
"\t\tkubectl logs -f -c ruby web-1\n"
"\n"
"\t\t# Zeige die letzten 20 Zeilen der Ausgabe des Pods nginx\n"
"\t\tkubectl logs --tail=20 nginx\n"
"\n"
"\t\t# Zeige alle Logs der letzten Stunde des Pods nginx an\n"
"\t\tkubectl logs --since=1h nginx\n"
"\n"
"\t\t# Gib die Snapshot-Logs des ersten Containers des Jobs hello zurück\n"
"\t\tkubectl logs job/hello\n"
"\n"
"\t\t# Gib die Snapshot-Logs des Containers nginx-1 eines Deployments nginx "
"zurück\n"
"\t\tkubectl logs deployment/nginx -c nginx-1"

#: pkg/kubectl/cmd/proxy.go:53
msgid ""
"\n"
"\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static "
"content from ./local/www/\n"
"\t\tkubectl proxy --port=8011 --www=./local/www/\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n"
"\t\t# The chosen port for the server will be output to stdout.\n"
"\t\tkubectl proxy --port=0\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-"
"api\n"
"\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/"
"pods/\n"
"\t\tkubectl proxy --api-prefix=/k8s-api"
msgstr ""
"\n"
"\t\t# Starte einen Proxy zum Kubernetes-Apiserver auf Port 8011 und sende "
"statische Inhalte von ./local/www/\n"
"\t\tkubectl proxy --port=8011 --www=./local/www/\n"
"\n"
"\t\t# Starte einen Proxy zum Kubernetes-Apiserver auf einem zufälligen lokalen "
"Port.\n"
"\t\t# Der gewählte Port für den Server wird im stdout zurückgegeben.\n"
"\t\tkubectl proxy --port=0\n"
"\n"
"\t\t# Starte einen Proxy zum Kubernetes-Apiserver und ändere das API-Prefix "
"zu k8s-api\n"
"\t\t# Damit ist die Pods-API bspw. unter localhost:8001/k8s-api/v1/pods/ "
"erreichbar\n"
"\t\tkubectl proxy --api-prefix=/k8s-api"

#: pkg/kubectl/cmd/scale.go:43
msgid ""
"\n"
"\t\t# Scale a replicaset named 'foo' to 3.\n"
"\t\tkubectl scale --replicas=3 rs/foo\n"
"\n"
"\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" "
"to 3.\n"
"\t\tkubectl scale --replicas=3 -f foo.yaml\n"
"\n"
"\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n"
"\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n"
"\n"
"\t\t# Scale multiple replication controllers.\n"
"\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n"
"\n"
"\t\t# Scale job named 'cron' to 3.\n"
"\t\tkubectl scale --replicas=3 job/cron"
msgstr ""
"\n"
"\t\t# Skaliere ein ReplicaSet 'foo' auf 3.\n"
"\t\tkubectl scale --replicas=3 rs/foo\n"
"\n"
"\t\t# Skaliere eine Resource mit type und name aus \"foo.yaml\" auf 3.\n"
"\t\tkubectl scale --replicas=3 -f foo.yaml\n"
"\n"
"\t\t# Wenn die aktuelle Größe des Deployments mysql 2 ist, skaliere mysql auf 3.\n"
"\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n"
"\n"
"\t\t# Skaliere mehrere MultiplicationController.\n"
"\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n"
"\n"
"\t\t# Skaliere den Job cron auf 3.\n"
"\t\tkubectl scale --replicas=3 job/cron"

#: pkg/kubectl/cmd/apply_set_last_applied.go:67
msgid ""
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml\n"
"\n"
"\t\t# Execute set-last-applied against each configuration file in a "
"directory.\n"
"\t\tkubectl apply set-last-applied -f path/\n"
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file, will create the annotation if it does not already exist.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n"
"\t\t"
msgstr ""
"\n"
"\t\t# Setze die Last-Applied-Configuration einer Resource auf den Inhalt einer "
"Datei.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml\n"
"\n"
"\t\t# Führe Set-Last-Applied auf jeder Konfigurationsdatei in einem Ordner aus.\n"
"\t\tkubectl apply set-last-applied -f path/\n"
"\n"
"\t\t# Setze die Last-Applied-Configuration einer Resource auf den Inhalt einer "
"Datei; erstellt die Annotation, wenn sie noch nicht existiert.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n"
"\t\t"

#: pkg/kubectl/cmd/top_pod.go:61
msgid ""
"\n"
"\t\t# Show metrics for all pods in the default namespace\n"
"\t\tkubectl top pod\n"
"\n"
"\t\t# Show metrics for all pods in the given namespace\n"
"\t\tkubectl top pod --namespace=NAMESPACE\n"
"\n"
"\t\t# Show metrics for a given pod and its containers\n"
"\t\tkubectl top pod POD_NAME --containers\n"
"\n"
"\t\t# Show metrics for the pods defined by label name=myLabel\n"
"\t\tkubectl top pod -l name=myLabel"
msgstr ""
"\n"
"\t\t# Zeige Metriken für alle Pods im Namespace default\n"
"\t\tkubectl top pod\n"
"\n"
"\t\t# Zeige Metriken für alle Pods im gegebenen namespace\n"
"\t\tkubectl top pod --namespace=NAMESPACE\n"
"\n"
"\t\t# Zeige Metriken für den gebenen Pod und seine Container\n"
"\t\tkubectl top pod POD_NAME --containers\n"
"\n"
"\t\t# Zeige Metriken für Pods mit dem Label name=myLabel\n"
"\t\tkubectl top pod -l name=myLabel"

#: pkg/kubectl/cmd/stop.go:40
msgid ""
"\n"
"\t\t# Shut down foo.\n"
"\t\tkubectl stop replicationcontroller foo\n"
"\n"
"\t\t# Stop pods and services with label name=myLabel.\n"
"\t\tkubectl stop pods,services -l name=myLabel\n"
"\n"
"\t\t# Shut down the service defined in service.json\n"
"\t\tkubectl stop -f service.json\n"
"\n"
"\t\t# Shut down all resources in the path/to/resources directory\n"
"\t\tkubectl stop -f path/to/resources"
msgstr ""
"\n"
"\t\t# Stoppe foo.\n"
"\t\tkubectl stop replicationcontroller foo\n"
"\n"
"\t\t# Stoppe Pods und Services mit dem Label name=myLabel.\n"
"\t\tkubectl stop pods,services -l name=myLabel\n"
"\n"
"\t\t# Stoppe den in service.json definierten Service\n"
"\t\tkubectl stop -f service.json\n"
"\n"
"\t\t# Stoppe alle Resourcen im Ordner path/to/resources\n"
"\t\tkubectl stop -f path/to/resources"

#: pkg/kubectl/cmd/run.go:57
msgid ""
"\n"
"\t\t# Start a single instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx\n"
"\n"
"\t\t# Start a single instance of hazelcast and let the container expose port "
"5701 .\n"
"\t\tkubectl run hazelcast --image=hazelcast --port=5701\n"
"\n"
"\t\t# Start a single instance of hazelcast and set environment variables "
"\"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n"
"\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --"
"env=\"POD_NAMESPACE=default\"\n"
"\n"
"\t\t# Start a replicated instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx --replicas=5\n"
"\n"
"\t\t# Dry run. Print the corresponding API objects without creating them.\n"
"\t\tkubectl run nginx --image=nginx --dry-run\n"
"\n"
"\t\t# Start a single instance of nginx, but overload the spec of the "
"deployment with a partial set of values parsed from JSON.\n"
"\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", "
"\"spec\": { ... } }'\n"
"\n"
"\t\t# Start a pod of busybox and keep it in the foreground, don't restart it "
"if it exits.\n"
"\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n"
"\n"
"\t\t# Start the nginx container using the default command, but use custom "
"arguments (arg1 .. argN) for that command.\n"
"\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n"
"\n"
"\t\t# Start the nginx container using a different command and custom "
"arguments.\n"
"\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n"
"\n"
"\t\t# Start the perl container to compute π to 2000 places and print it "
"out.\n"
"\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -"
"wle 'print bpi(2000)'\n"
"\n"
"\t\t# Start the cron job to compute π to 2000 places and print it out every "
"5 minutes.\n"
"\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --"
"restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'"
msgstr ""
"\n"
"\t\t# Starte eine einzelne Instanz von nginx.\n"
"\t\tkubectl run nginx --image=nginx\n"
"\n"
"\t\t# Starte eine einzelne Instanz von hazelcast und öffne Port 5701 auf dem "
"Container.\n"
"\t\tkubectl run hazelcast --image=hazelcast --port=5701\n"
"\n"
"\t\t# Starte eine einzelne Instanz von hazelcast und setze die Umgebungs-"
"variablen \"DNS_DOMAIN=cluster\" und \"POD_NAMESPACE=default\" im Container.\n"
"\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --"
"env=\"POD_NAMESPACE=default\"\n"
"\n"
"\t\t# Starte eine replizierte Instanz von nginx.\n"
"\t\tkubectl run nginx --image=nginx --replicas=5\n"
"\n"
"\t\t# Testlauf. Zeige die zugehörigen API Objekte ohne sie zu erstellen.\n"
"\t\tkubectl run nginx --image=nginx --dry-run\n"
"\n"
"\t\t# Starte eine einzelne Instanz von nginx, aber überlade die Spec des "
"Deployments mit einer Teilmenge von JSON-Werten.\n"
"\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", "
"\"spec\": { ... } }'\n"
"\n"
"\t\t# Starte einen busybox Pod und lass ihn im Vordergrund laufen; starte ihn "
"nicht neu, wenn er existiert.\n"
"\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n"
"\n"
"\t\t# Starte einen nginx-Container mit dem Standardkommando, aber übergebe "
"die Parameter (arg1 .. argN) an das Kommando.\n"
"\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n"
"\n"
"\t\t# Starte den nginx-Container mit einem anderen Kommando und Parametern.\n"
"\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n"
"\n"
"\t\t# Starte den perl-Container, um π auf 2000 Stellen zu berechnen und gib es "
"aus.\n"
"\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -"
"wle 'print bpi(2000)'\n"
"\n"
"\t\t# Starte den cron-Job, um π auf 2000 Stellen zu berechnen und gib sie alle "
"5 Minuten aus.\n"
"\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --"
"restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'"

#: pkg/kubectl/cmd/taint.go:67
msgid ""
"\n"
"\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-"
"user' and effect 'NoSchedule'.\n"
"\t\t# If a taint with that key and effect already exists, its value is "
"replaced as specified.\n"
"\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n"
"\n"
"\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect "
"'NoSchedule' if one exists.\n"
"\t\tkubectl taint nodes foo dedicated:NoSchedule-\n"
"\n"
"\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n"
"\t\tkubectl taint nodes foo dedicated-"
msgstr ""
"\n"
"\t\t# Aktualisiere Knoten 'foo' mit einem Taint mit dem Key 'dedicated', dem "
"Value 'special-user' und dem Effect 'NoSchedule'.\n"
"\t\t# Wenn ein Taint mit dem Key und Effect schon existiert, wird sein Value "
"mit den gegebenen Werten ersetzt.\n"
"\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n"
"\n"
"\t\t# Entferne vom Knoten 'foo' den Taint mit dem Key 'dedicated' und dem Effect "
"'NoSchedule', wenn er existiert.\n"
"\t\tkubectl taint nodes foo dedicated:NoSchedule-\n"
"\n"
"\t\t# Entferne vom Knoten 'foo' alle Tains mit dem Key 'dedicated'\n"
"\t\tkubectl taint nodes foo dedicated-"

#: pkg/kubectl/cmd/label.go:77
msgid ""
"\n"
"\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n"
"\t\tkubectl label pods foo unhealthy=true\n"
"\n"
"\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', "
"overwriting any existing value.\n"
"\t\tkubectl label --overwrite pods foo status=unhealthy\n"
"\n"
"\t\t# Update all pods in the namespace\n"
"\t\tkubectl label pods --all status=unhealthy\n"
"\n"
"\t\t# Update a pod identified by the type and name in \"pod.json\"\n"
"\t\tkubectl label -f pod.json status=unhealthy\n"
"\n"
"\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n"
"\t\tkubectl label pods foo status=unhealthy --resource-version=1\n"
"\n"
"\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n"
"\t\t# Does not require the --overwrite flag.\n"
"\t\tkubectl label pods foo bar-"
msgstr ""
"\n"
"\t\t# Aktualisiere den Pod 'foo' mit dem Label 'unhealthy' und dem Value "
"'true'.\n"
"\t\tkubectl label pods foo unhealthy=true\n"
"\n"
"\t\t# Aktualisiere den Pod 'foo' mit dem Label 'status' und dem Value "
"'unhealthy' und überschreibe alle bisherigen Values.\n"
"\t\tkubectl label --overwrite pods foo status=unhealthy\n"
"\n"
"\t\t# Aktualisiere alle Pods im Namespace\n"
"\t\tkubectl label pods --all status=unhealthy\n"
"\n"
"\t\t# Aktualisiere den Pod mit type und name aus \"pod.json\"\n"
"\t\tkubectl label -f pod.json status=unhealthy\n"
"\n"
"\t\t# Aktualisiere den Pod 'foo', wenn die Resource sich nicht von version 1 "
"unterscheidet.\n"
"\t\tkubectl label pods foo status=unhealthy --resource-version=1\n"
"\n"
"\t\t# Aktualisiere den Pod 'foo', indem das Label 'bar' gelöscht wird, wenn es "
"existiert.\n"
"\t\t# Benötigt kein --overwrite flag.\n"
"\t\tkubectl label pods foo bar-"

#: pkg/kubectl/cmd/rollingupdate.go:54
msgid ""
"\n"
"\t\t# Update pods of frontend-v1 using new replication controller data in "
"frontend-v2.json.\n"
"\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n"
"\n"
"\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n"
"\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n"
"\n"
"\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the "
"image, and switching the\n"
"\t\t# name of the replication controller.\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n"
"\n"
"\t\t# Update the pods of frontend by just changing the image, and keeping "
"the old name.\n"
"\t\tkubectl rolling-update frontend --image=image:v2\n"
"\n"
"\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to "
"frontend-v2).\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback"
msgstr ""
"\n"
"\t\t# Aktualisiere die Pods in frontend-v1 mit den neuen Replication-"
"Controller Daten in frontend-v2.json.\n"
"\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n"
"\n"
"\t\t# Aktualisiere die Pods in frontend-v1 mit den JSON-Daten von stdin.\n"
"\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n"
"\n"
"\t\t# Aktualisiere die Pods von frontend-v1 auf frontend-v2, indem das Image "
"geändert wird und\n"
"\t\t# der Name des ReplicationControllers.\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n"
"\n"
"\t\t# Aktualisiere die Pods in frontend, indem das Image geändert, aber der "
"alte Name beibehalten wird.\n"
"\t\tkubectl rolling-update frontend --image=image:v2\n"
"\n"
"\t\t# Breche ein laufendes Rollout (von frontend-v1 zu frontend-v2) ab und "
"mache es rückgängig.\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback"

#: pkg/kubectl/cmd/apply_view_last_applied.go:52
msgid ""
"\n"
"\t\t# View the last-applied-configuration annotations by type/name in YAML.\n"
"\t\tkubectl apply view-last-applied deployment/nginx\n"
"\n"
"\t\t# View the last-applied-configuration annotations by file in JSON\n"
"\t\tkubectl apply view-last-applied -f deploy.yaml -o json"
msgstr ""
"\n"
"\t\t# Zeige die Annotation Last-Applied-Configuration mit type/name in YAML an.\n"
"\t\tkubectl apply view-last-applied deployment/nginx\n"
"\n"
"\t\t# Zeige die Annotation Last-applied-configuration mit der Datei in JSON an\n"
"\t\tkubectl apply view-last-applied -f deploy.yaml -o json"

#: pkg/kubectl/cmd/apply.go:75
msgid ""
"\n"
"\t\tApply a configuration to a resource by filename or stdin.\n"
"\t\tThis resource will be created if it doesn't exist yet.\n"
"\t\tTo use 'apply', always create the resource initially with either 'apply' "
"or 'create --save-config'.\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not "
"use unless you are aware of what the current state is. See https://issues."
"k8s.io/34274."
msgstr ""
"\n"
"\t\tWende eine Konfiguration auf eine Resource mit Dateinamen oder stdin an.\n"
"\t\tDie Resource wird erstellt, wenn sie noch nicht existiert.\n"
"\t\tUm 'apply' zu benutzen, muss die Resource initital mit 'apply' oder "
"'create --save-config' erstellt werden.\n"
"\n"
"\t\tJSON- und YAML-Formate werden akzeptiert.\n"
"\n"
"\t\tAlpha Disclaimer: Die --prune Funktion ist noch nicht fertig. Benutze sie "
"nicht, wenn der aktuelle Zustand nicht bekannt ist. Siehe https://issues.k8s."
"io/34274."

#: pkg/kubectl/cmd/convert.go:38
msgid ""
"\n"
"\t\tConvert config files between different API versions. Both YAML\n"
"\t\tand JSON formats are accepted.\n"
"\n"
"\t\tThe command takes filename, directory, or URL as input, and convert it "
"into format\n"
"\t\tof version specified by --output-version flag. If target version is not "
"specified or\n"
"\t\tnot supported, convert to latest version.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change to output destination."
msgstr ""
"\n"
"\t\tKonvertiere Konfigurationsdateien zwischen API Versionen. Sowohl YAML-\n"
"\t\talsauch JSON-Formate werden akzeptiert.\n"
"\n"
"\t\tDer Befehlt akzeptiert Dateinamen, Ordner  oder URL als Parameter und "
"konvertiert es ins Format\n"
"\t\tder mit --output-version gegebenen Version. Wenn die Zielversion nicht \n"
"\t\tangegeben wird oder ungültig ist, wird die neueste Version verwendet.\n"
"\n"
"\t\tDie Standardausgabe wird auf stdout im YAML-Format ausgegeben. Man kann "
"die Option -o verwenden,\n"
"\t\tum das Ausgabeziel festzulegen."

#: pkg/kubectl/cmd/create_clusterrole.go:31
msgid ""
"\n"
"\t\tCreate a ClusterRole."
msgstr ""
"\n"
"\t\tErstelle eine ClusterRole."

#: pkg/kubectl/cmd/create_clusterrolebinding.go:32
msgid ""
"\n"
"\t\tCreate a ClusterRoleBinding for a particular ClusterRole."
msgstr ""
"\n"
"\t\tErstelle ein ClusterRoleBinding für eine bestimmte ClusterRole."

#: pkg/kubectl/cmd/create_rolebinding.go:32
msgid ""
"\n"
"\t\tCreate a RoleBinding for a particular Role or ClusterRole."
msgstr ""
"\n"
"\t\tErstelle ein RoleBinding für eine bestimmte ClusterRole."

#: pkg/kubectl/cmd/create_secret.go:200
msgid ""
"\n"
"\t\tCreate a TLS secret from the given public/private key pair.\n"
"\n"
"\t\tThe public/private key pair must exist before hand. The public key "
"certificate must be .PEM encoded and match the given private key."
msgstr ""
"\n"
"\t\tErstelle ein TLS-Secret vom gegebenen Public/Private-Schlüsselpaar.\n"
"\n"
"\t\tDas Public/Private-Schlüsselpaar muss vorab bestehen. Das Public-Key-"
"Zertifikat muss im PEM-Format sein und zum gegebenen Private-Key passen."

#: pkg/kubectl/cmd/create_configmap.go:32
msgid ""
"\n"
"\t\tCreate a configmap based on a file, directory, or specified literal "
"value.\n"
"\n"
"\t\tA single configmap may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a configmap based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a configmap based on a directory, each file whose basename "
"is a valid key in the directory will be\n"
"\t\tpackaged into the configmap.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."
msgstr ""
"\n"
"\t\tErstelle eine ConfigMap basierend auf einer Datei, einem Order oder einem "
"gegebenen Wert.\n"
"\n"
"\t\tEine einzelne ConfigMap kann eins oder mehr Key/Value-Paare beinhalten.\n"
"\n"
"\t\tWenn man eine ConfigMap von einer Datei erstellt, wird der Key standard"
"mäßig der Name der Datei, und der Wert wird\n"
"\t\tstandardmäßig der Dateiinhalt. Wenn der Dateiname ein ungültiger Key ist, "
"kann ein anderer Key angegeben werden.\n"
"\n"
"\t\tWenn man eine ConfigMap von einem Ordner erstellt, wird jede Datei, deren "
"Name ein gültiger Key ist\n"
"\t\tin die ConfigMap aufgenommen. Jegliche Einträge im Ordner, die keine "
"regulären Dateien sind, werden ignoriert (z.B. SubDirectories, \n"
"\t\tSymLinks, Devices, Pipes, usw)."

#: pkg/kubectl/cmd/create_namespace.go:32
msgid ""
"\n"
"\t\tCreate a namespace with the specified name."
msgstr ""
"\n"
"\t\tErstelle einen Namespace mit dem gegebenen Namen."

#: pkg/kubectl/cmd/create_secret.go:119
msgid ""
"\n"
"\t\tCreate a new secret for use with Docker registries.\n"
"\n"
"\t\tDockercfg secrets are used to authenticate against Docker registries.\n"
"\n"
"\t\tWhen using the Docker command line to push images, you can authenticate "
"to a given registry by running\n"
"\n"
"\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --"
"password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n"
"\n"
"    That produces a ~/.dockercfg file that is used by subsequent 'docker "
"push' and 'docker pull' commands to\n"
"\t\tauthenticate to the registry. The email address is optional.\n"
"\n"
"\t\tWhen creating applications, you may have a Docker registry that requires "
"authentication.  In order for the\n"
"\t\tnodes to pull images on your behalf, they have to have the credentials.  "
"You can provide this information\n"
"\t\tby creating a dockercfg secret and attaching it to your service account."
msgstr ""
"\n"
"\t\tErstelle ein Secret für die Benutzung mit Docker-Registries.\n"
"\n"
"\t\tDockercfg Secrets werden für die Authentifizierung bei Docker-Registries "
"benutzt.\n"
"\n"
"\t\tWenn die Docker-command -line zum pushen von Images benutzt wird, kann man "
"sich bei einer gegebenen Registry authentifizieren mit\n"
"\n"
"\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --"
"password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n"
"\n"
"    Dies produziert eine ~/.dockercfg Datei, die für folgende 'docker push' "
"und 'docker pull' Befehle genutzt wird,\n"
"\t\tum sich an der Registry zu authentifizieren. Die E-Mail-Adresse ist "
"optional.\n"
"\n"
"\t\tBei der Erstellung von Applikationen, kann eine Docker-Registry eine "
"Authentifizierung verlangen. Damit\n"
"\t\tdeine Knoten in deinem Namen Images herunterladen können, benötigen sie "
"die Credentials.  "
"Man kann diese Information bereitstellen\n"
"\t\tindem man ein dockercfg secret erstellt und zu seinem ServiceAccount "
"hinzufügt."

#: pkg/kubectl/cmd/create_pdb.go:32
msgid ""
"\n"
"\t\tCreate a pod disruption budget with the specified name, selector, and "
"desired minimum available pods"
msgstr ""
"\n"
"\t\tErstelle ein Pod-Disruption-Budget mit dem gegebenen name, selector und "
"der gewünschten Mindestanzahl verfügbarer Pods"

#: pkg/kubectl/cmd/create.go:42
msgid ""
"\n"
"\t\tCreate a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted."
msgstr ""
"\n"
"\t\tErstelle eine Resource mit Dateinamen oder stdin.\n"
"\n"
"\t\tJSON- und YAML-Formate werden akzeptiert."

#: pkg/kubectl/cmd/create_quota.go:32
msgid ""
"\n"
"\t\tCreate a resourcequota with the specified name, hard limits and optional "
"scopes"
msgstr ""
"\n"
"\t\tErstelle eine ResourceQuota mit dem gegebenen name, hard limits und optional "
"scopes"

#: pkg/kubectl/cmd/create_role.go:38
msgid ""
"\n"
"\t\tCreate a role with single rule."
msgstr ""
"\n"
"\t\tErstelle eine Role mit einer einzelnen Rule."

#: pkg/kubectl/cmd/create_secret.go:47
msgid ""
"\n"
"\t\tCreate a secret based on a file, directory, or specified literal value.\n"
"\n"
"\t\tA single secret may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a secret based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a secret based on a directory, each file whose basename is "
"a valid key in the directory will be\n"
"\t\tpackaged into the secret.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."
msgstr ""
"\n"
"\t\tErstelle ein Secret basierend auf einer Datei, einem Ordner oder einem "
"gegebenen Wert.\n"
"\n"
"\t\tEin einzelnes Secret kann eins oder mehr Key/Value-Paare beinhalten.\n"
"\n"
"\t\tWenn man ein Secret von einer Datei erstellt, wird der Key standard"
"mäßig der Name der Datei, und der Wert wird\n"
"\t\tstandardmäßig der Dateiinhalt. Wenn der Dateiname ein ungültiger Key ist, "
"kann ein anderer Key angegeben werden.\n"
"\n"
"\t\tWenn man ein Secret von einem Ordner erstellt, wird jede Datei, deren "
"Name ein gültiger Key ist\n"
"\t\tin das Secret aufgenommen. Jegliche Einträge im Ordner, die keine "
"regulären Dateien sind, werden ignoriert (z.B. SubDirectories, \n"
"\t\tSymLinks, Devices, Pipes, usw)."

#: pkg/kubectl/cmd/create_serviceaccount.go:32
msgid ""
"\n"
"\t\tCreate a service account with the specified name."
msgstr ""
"\n"
"\t\tErstelle einen ServiceAccount mit dem gegebenen Namen."

#: pkg/kubectl/cmd/run.go:52
msgid ""
"\n"
"\t\tCreate and run a particular image, possibly replicated.\n"
"\n"
"\t\tCreates a deployment or job to manage the created container(s)."
msgstr ""
"\n"
"\t\tErstelle und starte ein bestimmtes Image, möglicherweise repliziert.\n"
"\n"
"\t\tErstellt ein Deployment oder Job, um den/die erstellten Container zu "
"verwalten."

#: pkg/kubectl/cmd/autoscale.go:34
msgid ""
"\n"
"\t\tCreates an autoscaler that automatically chooses and sets the number of "
"pods that run in a kubernetes cluster.\n"
"\n"
"\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and "
"creates an autoscaler that uses the given resource as a reference.\n"
"\t\tAn autoscaler can automatically increase or decrease number of pods "
"deployed within the system as needed."
msgstr ""
"\n"
"\t\tErstellt einen AutoScaler der die Anzahl der Pods, die im Kubernetes-"
"Cluster laufen, automatisch wählt und anpasst.\n"
"\n"
"\t\tSucht ein Deployment, ReplicaSet oder ReplicationController mit Namen name "
"und erstellt einen AutoScaler, der die Resource als Referenz nimmt.\n"
"\t\tEin AutoScaler kann die Anzahl der im System deployten Pods nach Bedarf "
"erhöhen oder verringern."

#: pkg/kubectl/cmd/delete.go:40
msgid ""
"\n"
"\t\tDelete resources by filenames, stdin, resources and names, or by "
"resources and label selector.\n"
"\n"
"\t\tJSON and YAML formats are accepted. Only one type of the arguments may "
"be specified: filenames,\n"
"\t\tresources and names, or resources and label selector.\n"
"\n"
"\t\tSome resources, such as pods, support graceful deletion. These resources "
"define a default period\n"
"\t\tbefore they are forcibly terminated (the grace period) but you may "
"override that value with\n"
"\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. "
"Because these resources often\n"
"\t\trepresent entities in the cluster, deletion may not be acknowledged "
"immediately. If the node\n"
"\t\thosting a pod is down or cannot reach the API server, termination may "
"take significantly longer\n"
"\t\tthan the grace period. To force delete a resource,\tyou must pass a grace"
"\tperiod of 0 and specify\n"
"\t\tthe --force flag.\n"
"\n"
"\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the "
"pod's processes have been\n"
"\t\tterminated, which can leave those processes running until the node "
"detects the deletion and\n"
"\t\tcompletes graceful deletion. If your processes use shared storage or "
"talk to a remote API and\n"
"\t\tdepend on the name of the pod to identify themselves, force deleting "
"those pods may result in\n"
"\t\tmultiple processes running on different machines using the same "
"identification which may lead\n"
"\t\tto data corruption or inconsistency. Only force delete pods when you are "
"sure the pod is\n"
"\t\tterminated, or if your application can tolerate multiple copies of the "
"same pod running at once.\n"
"\t\tAlso, if you force delete pods the scheduler may place new pods on those "
"nodes before the node\n"
"\t\thas released those resources and causing those pods to be evicted "
"immediately.\n"
"\n"
"\t\tNote that the delete command does NOT do resource version checks, so if "
"someone\n"
"\t\tsubmits an update to a resource right when you submit a delete, their "
"update\n"
"\t\twill be lost along with the rest of the resource."
msgstr ""
"\n"
"\t\tLöscht die Resourcen mit Dateinamen, stdin, resources- und names- oder mit "
"resources- und label-Selektor.\n"
"\n"
"\t\tJSON- und YAML-Formate werden akzeptiert. Nur einer der Parameter darf "
"verwendet werden: Dateiname,\n"
"\t\tresources- und names-, oder resources- und label-Selektor.\n"
"\n"
"\t\tManche Resourcen, zum Beispiel Pods, unterstützen graziöses Löschen. Sie "
"definieren einen Standardzeitraum\n"
"\t\tbevor das Löschen erzwungen wird (grace-period), aber dieser Wert kann "
"überschrieben werden mit\n"
"\t\tder --grace-period Option, oder mit --now, das die grace-period auf 1 "
"setzt. "
"Da diese Resourcen\n"
"\t\thäufig Einheiten im Cluster sind, kann das Löschen nicht immer direkt "
"bestätigt werden. Wenn der Knoten\n"
"\t\tauf dem der Pod läuft nicht verfügbar ist, oder den API Server nicht "
"erreichen kann, kann das Löschen bedeutend länger dauern\n"
"\t\tals die grace-period. Um das Löschen zu erzwingen, muss eine grace-period "
"von 0 übergeben werden\n"
"\t\tund die --force Option gesetzt sein.\n"
"\n"
"\t\tWICHTIG: Ein erzwungenes Löschen wartet nicht auf die Bestätigung, dass "
"der Prozess\n"
"\t\tbeendet wurde, was den Prozess am Leben erhalten kann, bis der Knoten "
"die Löschung erkennt\n"
"\t\tund das graziöse Löschen beendet. Wenn Prozesse Shared-Storage oder eine "
"Remote-API verwenden und\n"
"\t\tden Namen des Pods brauchen, um sich selbst zu identifizieren, kann das "
"erzwungene Löschen dazu führen, dass\n"
"\t\tmehrere Prozesse auf der gleichen Maschine die gleiche Identität verwenden, "
"was zu\n"
"\t\tDatenkorruption oder Inkonsistenz führen kann. Erzwinge nur ein "
"Löschen, wenn sichergestellt ist, dass der Pod\n"
"\t\tgelöscht ist, oder wenn die Anwendung mehrere gleichzeitig laufende "
"Kopien verarbeiten kann.\n"
"\t\tAußerdem kann es passieren, dass der Scheduler neue Pods auf dem Knoten "
"plaziert, bevor der Knoten\n"
"\t\tdie Resourcen freigegeben hat, sodass diese Pods direkt entfernt werden.\n"
"\n"
"\t\tBerücksichtige außerdem, dass der Delete-Befehl KEINE versionen prüft, "
"sodass, wenn jemand\n"
"\t\tein Update einer Resource gleichzeitig mit Deinem delete anstößt, dessen "
"Update\n"
"\t\tmit dem Rest der Resource entfernt wird."

#: pkg/kubectl/cmd/stop.go:31
msgid ""
"\n"
"\t\tDeprecated: Gracefully shut down a resource by name or filename.\n"
"\n"
"\t\tThe stop command is deprecated, all its functionalities are covered by "
"delete command.\n"
"\t\tSee 'kubectl delete --help' for more details.\n"
"\n"
"\t\tAttempts to shut down and delete a resource that supports graceful "
"termination.\n"
"\t\tIf the resource is scalable it will be scaled to 0 before deletion."
msgstr ""
"\n"
"\t\tVeraltet: Fahre eine Resource mit Namen oder Dateinamen graziös heruter.\n"
"\n"
"\t\tDer Stop-Befehl ist veraltet und alle Funktioneren werden mit dem Delete-"
"Befehl abgedeckt.\n"
"\t\tSiehe 'kubectl delete --help' für mehr Details.\n"
"\n"
"\t\tVersucht eine Resource, die graziöses Löschen unterstützt, herunterzufahren "
"und zu löschen.\n"
"\t\tWenn die Resource skaliert werden kann, wird sie vor dem Löschen auf 0 "
"skaliert."

#: pkg/kubectl/cmd/top_node.go:60
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n"
"\n"
"\t\tThe top-node command allows you to see the resource consumption of nodes."
msgstr ""
"\n"
"\t\tZeigt die Resourcennutzung (CPU/Memory/Storage) von Knoten.\n"
"\n"
"\t\tDer top-node-Befehl erlaubt es, die Resourcennutzung von Knoten zu "
"betrachten."

#: pkg/kubectl/cmd/top_pod.go:53
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n"
"\n"
"\t\tThe 'top pod' command allows you to see the resource consumption of "
"pods.\n"
"\n"
"\t\tDue to the metrics pipeline delay, they may be unavailable for a few "
"minutes\n"
"\t\tsince pod creation."
msgstr ""
"\n"
"\t\tZeigt die Resourcennutzung (CPU/Memory/Storage) von Pods.\n"
"\n"
"\t\tDer 'top pod'-Befehl erlaubt es, die Resourcennutzung von Pods zu "
"betrachten.\n"
"\n"
"\t\tAufgrund der Metrik-Pipeline-Verzögerung, können sie für ein paar Minuten "
"nicht verfügbar sein,\n"
"\t\tnach der Pod-Erstellung."

#: pkg/kubectl/cmd/top.go:33
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage.\n"
"\n"
"\t\tThe top command allows you to see the resource consumption for nodes or "
"pods.\n"
"\n"
"\t\tThis command requires Heapster to be correctly configured and working on "
"the server. "
msgstr ""
"\n"
"\t\tZeige Resourcennutzung (CPU/Memory/Storage).\n"
"\n"
"\t\tDer top-Befehl erlaubt es, die Resourcennutzung von Knoten oder Pods zu "
"betrachten.\n"
"\n"
"\t\tDieser Befehl benötigt eine korrekt konfigurierte und funktionierende "
"Heapster-Installation auf dem Server. "

#: pkg/kubectl/cmd/drain.go:140
msgid ""
"\n"
"\t\tDrain node in preparation for maintenance.\n"
"\n"
"\t\tThe given node will be marked unschedulable to prevent new pods from "
"arriving.\n"
"\t\t'drain' evicts the pods if the APIServer supports eviction\n"
"\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use "
"normal DELETE\n"
"\t\tto delete the pods.\n"
"\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot "
"be deleted through\n"
"\t\tthe API server).  If there are DaemonSet-managed pods, drain will not "
"proceed\n"
"\t\twithout --ignore-daemonsets, and regardless it will not delete any\n"
"\t\tDaemonSet-managed pods, because those pods would be immediately replaced "
"by the\n"
"\t\tDaemonSet controller, which ignores unschedulable markings.  If there "
"are any\n"
"\t\tpods that are neither mirror pods nor managed by ReplicationController,\n"
"\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete "
"any pods unless you\n"
"\t\tuse --force.  --force will also allow deletion to proceed if the "
"managing resource of one\n"
"\t\tor more pods is missing.\n"
"\n"
"\t\t'drain' waits for graceful termination. You should not operate on the "
"machine until\n"
"\t\tthe command completes.\n"
"\n"
"\t\tWhen you are ready to put the node back into service, use kubectl "
"uncordon, which\n"
"\t\twill make the node schedulable again.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)"
msgstr ""
"\n"
"\t\tLeere Knoten, um eine Wartung vorzubereiten.\n"
"\n"
"\t\tDer gegebene Knoten wird als unschedulable markiert, um die Zuordnung von "
"neuen Pods zu verhindern.\n"
"\t\t'drain' entfernt den Pod, falls der API-Server die Entfernung unterstützt\n"
"\t\t(http://kubernetes.io/docs/admin/disruptions/). Wenn nicht, wird ein "
"normales DELETE verwendet,\n"
"\t\tum die Pods zu löschen.\n"
"\t\t'drain' entfernt oder löscht alle Pods mit der Ausnahme von Mirror-Pods ("
"welche vom API Server nicht gelöscht werden können)\n"
"\t\tWenn DaemonSet-verwaltete Pods existieren, wird 'drain' "
"nicht fortgesetzt\n"
"\t\tohne die --ignore-daemonsets Option, und es wird in keinem Fall\n"
"\t\tDaemonSet-verwaltete Pods löschen, weil diese Pods direkt ersetzt würden "
"durch den\n"
"\t\tDaemonSet-Controller, der unschedulable Markierungen ignoriert.  Wenn es "
"irgendwelche\n"
"\t\tPods gibt, die weder Mirror-Pods sind, noch von einem ReplicationController,\n"
"\t\tReplicaSet, DaemonSet, StatefulSet oder Job verwaltet werden, wird drain "
"keine Pods löschen, außer die\n"
"\t\t--force Option ist gesetzt.  --force lässt das Löschen selbst zu, wenn die "
"verwaltende Resource von einem\n"
"\t\toder mehreren Pods fehlt.\n"
"\n"
"\t\t'drain' wartet auf eine graziöse Löschung. Man sollte auf der Maschine "
"nichts tun, während\n"
"\t\tder Befehl läuft.\n"
"\n"
"\t\tWenn der Knoten wieder bereit ist die Arbeit aufzunehmen, benutze kubectl "
"uncordon,\n"
"\t\twas den Knoten als schedulable markiert.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)"

#: pkg/kubectl/cmd/edit.go:56
msgid ""
"\n"
"\t\tEdit a resource from the default editor.\n"
"\n"
"\t\tThe edit command allows you to directly edit any API resource you can "
"retrieve via the\n"
"\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, "
"or EDITOR\n"
"\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for "
"Windows.\n"
"\t\tYou can edit multiple objects, although changes are applied one at a "
"time. The command\n"
"\t\taccepts filenames as well as command line arguments, although the files "
"you point to must\n"
"\t\tbe previously saved versions of resources.\n"
"\n"
"\t\tEditing is done with the API version used to fetch the resource.\n"
"\t\tTo edit using a specific API version, fully-qualify the resource, "
"version, and group.\n"
"\n"
"\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n"
"\n"
"\t\tThe flag --windows-line-endings can be used to force Windows line "
"endings,\n"
"\t\totherwise the default for your operating system will be used.\n"
"\n"
"\t\tIn the event an error occurs while updating, a temporary file will be "
"created on disk\n"
"\t\tthat contains your unapplied changes. The most common error when "
"updating a resource\n"
"\t\tis another editor changing the resource on the server. When this occurs, "
"you will have\n"
"\t\tto apply your changes to the newer version of the resource, or update "
"your temporary\n"
"\t\tsaved copy to include the latest resource version."
msgstr ""
"\n"
"\t\tBearbeite eine Resource mit dem Standardeditor.\n"
"\n"
"\t\tDer edit-Befehl erlaubt es jede API Resource direkt zu bearbeiten, wenn "
"sie mit den\n"
"\t\tCommand-Line-Tools erreichbar ist. Er öffnet den Editor, der in der "
"KUBE_EDITOR oder EDITOR\n"
"\t\tUmgebunsvariable festgelegt ist, oder 'vi' auf Linux und "
"'notepad' auf Windows.\n"
"\t\tEs ist möglich mehrere Objekte zu bearbeiten, aber die Änderungen werden "
"nacheinander angewendet. Der Befehl\n"
"\t\takzeptiert Dateinamen und Command-Line-Parameter, aber die verwendeten "
"Dateien müssen\n"
"\t\tvorab gespeicherte Versionen von Resourcen sein.\n"
"\n"
"\t\tDie Bearbeitung verwendet die API Version, die genutzt wurde, um die "
"Resource zu lesen.\n"
"\t\tUm eine spezifische API Version zu verwenden, muss die vollständige "
"Resource, Version und Group angegeben werden.\n"
"\n"
"\t\tDas Standardformat ist YAML. Um mit JSON zu arbeiten, setze \"-o json\".\n"
"\n"
"\t\tDie Option --windows-line-endings kann benutzt werden, um Windows Zeilen-"
"umbrüche zu verwenden,\n"
"\t\tansonsten wird der Standard des Betriebssystems verwendet.\n"
"\n"
"\t\tFalls beim Update ein Fehler auftritt, wird eine temporäre Datei auf der "
"Festplatte angelegt,\n"
"\t\tdie die nicht verarbeiteten Änderungen enthält. Der häufigste Fehler beim "
"Bearbeiten einer Resource\n"
"\t\tist ein anderer Editor, der die Resource auf dem Server ändert. Wenn das "
"auftritt, muss man\n"
"\t\tseine Änderungen auf die neue Version anwenden oder seine temporäre\n"
"\t\tgespeicherte Kopie mit der neuesten Resourcenversion aktualisieren."

#: pkg/kubectl/cmd/drain.go:115
msgid ""
"\n"
"\t\tMark node as schedulable."
msgstr ""
"\n"
"\t\tMarkiere Knoten als schedulable."

#: pkg/kubectl/cmd/drain.go:90
msgid ""
"\n"
"\t\tMark node as unschedulable."
msgstr ""
"\n"
"\t\tMarkiere Knoten als unschedulable."

#: pkg/kubectl/cmd/completion.go:47
msgid ""
"\n"
"\t\tOutput shell completion code for the specified shell (bash or zsh).\n"
"\t\tThe shell code must be evaluated to provide interactive\n"
"\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n"
"\t\tthe .bash_profile.\n"
"\n"
"\t\tNote: this requires the bash-completion framework, which is not "
"installed\n"
"\t\tby default on Mac.  This can be installed by using homebrew:\n"
"\n"
"\t\t    $ brew install bash-completion\n"
"\n"
"\t\tOnce installed, bash_completion must be evaluated.  This can be done by "
"adding the\n"
"\t\tfollowing line to the .bash_profile\n"
"\n"
"\t\t    $ source $(brew --prefix)/etc/bash_completion\n"
"\n"
"\t\tNote for zsh users: [1] zsh completions are only supported in versions "
"of zsh >= 5.2"
msgstr ""
"\n"
"\t\tGibt den Shell-Completion-Code für die angegebene Shell aus (bash oder zsh).\n"
"\t\tDer Shell-Code muss für eine interaktive Vervollständigung von kubectl \n"
"\t\tausgewertet werden. Das ist möglich, indem man\n"
"\t\tdie .bash_profile Datei sourcet.\n"
"\n"
"\t\tHinweis: Dies setzt das Bash-Completion-Framework voraus, das auf dem Mac "
"nicht standardmäßig installiert ist. \n"
"\t\tEs kann mit homebrew installiert werden:\n"
"\n"
"\t\t    $ brew install bash-completion\n"
"\n"
"\t\tSobald es installiert ist, muss bash_completion ausgewertet werden. Dies "
"wird erreicht, indem man\n"
"\t\tdie folgende Zeile zur .bash_profile-Datei hinzufügt\n"
"\n"
"\t\t    $ source $(brew --prefix)/etc/bash_completion\n"
"\n"
"\t\tHinweis für zsh Nutzer: [1] zsh completions werden nur in Versionen "
"von zsh >= 5.2 unterstützt"

#: pkg/kubectl/cmd/rollingupdate.go:45
msgid ""
"\n"
"\t\tPerform a rolling update of the given ReplicationController.\n"
"\n"
"\t\tReplaces the specified replication controller with a new replication "
"controller by updating one pod at a time to use the\n"
"\t\tnew PodTemplate. The new-controller.json must specify the same namespace "
"as the\n"
"\t\texisting replication controller and overwrite at least one (common) "
"label in its replicaSelector.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)"
msgstr ""
"\n"
"\t\tFühre ein Rolling-Update des gegebenen ReplicationControllers aus.\n"
"\n"
"\t\tErsetzt den gegebenen ReplicationController mit einem neuen Replication-"
"Controller, indem die neue PodTampleta Pod für Pod\n"
"\t\tangewendet wird. Die new-controller.json muss den gleichen Namespace wie\n"
"\t\tder aktuelle ReplicationController besitzen und mindestens ein "
"gemeinsames Label im ReplicaSelector überschreiben.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)"

#: pkg/kubectl/cmd/replace.go:40
msgid ""
"\n"
"\t\tReplace a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted. If replacing an existing resource, "
"the\n"
"\t\tcomplete resource spec must be provided. This can be obtained by\n"
"\n"
"\t\t    $ kubectl get TYPE NAME -o yaml\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."
msgstr ""
"\n"
"\t\tErsetze eine Resource mit Dateinamen oder stdin.\n"
"\n"
"\t\tJSON- and YAML-Formate werden akzeptiert. Wenn eine existierende Resource "
"ersetzt wird,\n"
"\t\tmuss die vollständige spSpecec mitgegeben werden. Diese kann hiermit "
"ausgelesen werden\n"
"\n"
"\t\t    $ kubectl get TYPE NAME -o yaml\n"
"\n"
"\t\tBitte konsultiere https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html um zu erfahren, ob ein Feld verändert werden darf."

#: pkg/kubectl/cmd/scale.go:34
msgid ""
"\n"
"\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or "
"Job.\n"
"\n"
"\t\tScale also allows users to specify one or more preconditions for the "
"scale action.\n"
"\n"
"\t\tIf --current-replicas or --resource-version is specified, it is "
"validated before the\n"
"\t\tscale is attempted, and it is guaranteed that the precondition holds "
"true when the\n"
"\t\tscale is sent to the server."
msgstr ""
"\n"
"\t\tSetze eine neue Größe für ein Deployment, ReplicaSet, Replication-"
"Contoller oder Job.\n"
"\n"
"\t\tScale erlaubt es Nutzern eine oder mehr Voraussetzungen für die Aktion "
"festzulegen.\n"
"\n"
"\t\tWenn --current-replicas oder --resource-version gegeben ist, wird "
"es validiert, bevor\n"
"\t\tscale versucht wird, und es wird garantiert, dass die Voraussetzungen "
"erfüllt sind, wenn\n"
"\t\tscale zum Server geschickt wird."

#: pkg/kubectl/cmd/apply_set_last_applied.go:62
msgid ""
"\n"
"\t\tSet the latest last-applied-configuration annotations by setting it to "
"match the contents of a file.\n"
"\t\tThis results in the last-applied-configuration being updated as though "
"'kubectl apply -f <file>' was run,\n"
"\t\twithout updating any other parts of the object."
msgstr ""
"\n"
"\t\tSetze die aktuelle Annotation Last-Applied-Configuration auf den Inhalt "
"der Datei.\n"
"\t\tDas bedeutet, dass Last-Applied-Configuration aktualisiert wird, als ob "
"'kubectl apply -f <file>' ausgeführt wurde,\n"
"\t\tohne andere Teile des Objekts zu aktualisieren."

#: pkg/kubectl/cmd/proxy.go:36
msgid ""
"\n"
"\t\tTo proxy all of the kubernetes api and nothing else, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/\n"
"\n"
"\t\tTo proxy only part of the kubernetes api and also some static files:\n"
"\n"
"\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/"
"api/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n"
"\n"
"\t\tTo proxy the entire kubernetes api at a different root, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/custom/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'"
msgstr ""
"\n"
"\t\tProxy alle Teile der Kubernetes-API und sonst nichts:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/\n"
"\n"
"\t\tProxy nur bestimmte Teile der Kubernetes-API und einige statische Dateien:\n"
"\n"
"\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/"
"api/\n"
"\n"
"\t\tDer Befehl oben lässt dich 'curl localhost:8001/api/v1/pods' aufrufen.\n"
"\n"
"\t\tProxy alle Teile der Kubernetes-API auf einem anderen root:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/custom/\n"
"\n"
"\t\tDer Befehl oben lässt dich 'curl localhost:8001/custom/api/v1/pods' "
"aufrufen"

#: pkg/kubectl/cmd/patch.go:59
msgid ""
"\n"
"\t\tUpdate field(s) of a resource using strategic merge patch\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."
msgstr ""
"\n"
"\t\tAktualisiere Felder einer Resource mit einem Strategic-Merge-Patch\n"
"\n"
"\t\tJSON- und YAML-Formate werden akzeptiert.\n"
"\n"
"\t\tBitte konsultiere https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html um zu erfahren, ob ein Feld mutable ist."

#: pkg/kubectl/cmd/label.go:70
#, c-format
msgid ""
"\n"
"\t\tUpdate the labels on a resource.\n"
"\n"
"\t\t* A label must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* If --overwrite is true, then existing labels can be overwritten, "
"otherwise attempting to overwrite a label will result in an error.\n"
"\t\t* If --resource-version is specified, then updates will use this "
"resource version, otherwise the existing resource-version will be used."
msgstr ""

#: pkg/kubectl/cmd/taint.go:58
#, c-format
msgid ""
"\n"
"\t\tUpdate the taints on one or more nodes.\n"
"\n"
"\t\t* A taint consists of a key, value, and effect. As an argument here, it "
"is expressed as key=value:effect.\n"
"\t\t* The key must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* The value must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[2]d characters.\n"
"\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n"
"\t\t* Currently taint can only apply to node."
msgstr ""

#: pkg/kubectl/cmd/apply_view_last_applied.go:46
msgid ""
"\n"
"\t\tView the latest last-applied-configuration annotations by type/name or "
"file.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change output format."
msgstr ""

#: pkg/kubectl/cmd/cp.go:37
msgid ""
"\n"
"\t    # !!!Important Note!!!\n"
"\t    # Requires that the 'tar' binary is present in your container\n"
"\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n"
"\n"
"\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in "
"the default namespace\n"
"\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n"
"\n"
"        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific "
"container\n"
"\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n"
"\n"
"\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace "
"<some-namespace>\n"
"\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n"
"\n"
"\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n"
"\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar"
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:205
msgid ""
"\n"
"\t  # Create a new TLS secret named tls-secret with the given key pair:\n"
"\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/"
"to/tls.key"
msgstr ""
"\n"
"\t  # Erstelle ein neues TLS Secret tl-secret mit dem gegebenen Schlüsselpaar:\n"
"\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/"
"to/tls.key"

#: pkg/kubectl/cmd/create_namespace.go:35
msgid ""
"\n"
"\t  # Create a new namespace named my-namespace\n"
"\t  kubectl create namespace my-namespace"
msgstr ""
"\n"
"\t  # Erstelle einen neuen Namespace my-namespace\n"
"\t  kubectl create namespace my-namespace"

#: pkg/kubectl/cmd/create_secret.go:59
msgid ""
"\n"
"\t  # Create a new secret named my-secret with keys for each file in folder "
"bar\n"
"\t  kubectl create secret generic my-secret --from-file=path/to/bar\n"
"\n"
"\t  # Create a new secret named my-secret with specified keys instead of "
"names on disk\n"
"\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/."
"ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n"
"\n"
"\t  # Create a new secret named my-secret with key1=supersecret and "
"key2=topsecret\n"
"\t  kubectl create secret generic my-secret --from-literal=key1=supersecret "
"--from-literal=key2=topsecret"
msgstr ""
"\n"
"\t  # Erstelle ein neues Secret my-secret mit einem Key für jede Datei "
"im Ordner bar\n"
"\t  kubectl create secret generic my-secret --from-file=path/to/bar\n"
"\n"
"\t  # Erstelle ein neues Secret my-secret mit den gegebenen Keys statt "
"der Namen auf der Festplatte\n"
"\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/."
"ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n"
"\n"
"\t  # Erstelle ein neues Scret my-secret mit key1=supersecret und "
"key2=topsecret\n"
"\t  kubectl create secret generic my-secret --from-literal=key1=supersecret "
"--from-literal=key2=topsecret"

#: pkg/kubectl/cmd/create_serviceaccount.go:35
msgid ""
"\n"
"\t  # Create a new service account named my-service-account\n"
"\t  kubectl create serviceaccount my-service-account"
msgstr ""
"\n"
"\t  # Erstelle einen neuen ServiceAccount my-service-account\n"
"\t  kubectl create serviceaccount my-service-account"

#: pkg/kubectl/cmd/create_service.go:232
msgid ""
"\n"
"\t# Create a new ExternalName service named my-ns \n"
"\tkubectl create service externalname my-ns --external-name bar.com"
msgstr ""
"\n"
"\t# Erstelle einen neuen ExternalName-Service my-ns \n"
"\tkubectl create service externalname my-ns --external-name bar.com"

#: pkg/kubectl/cmd/create_service.go:225
msgid ""
"\n"
"\tCreate an ExternalName service with the specified name.\n"
"\n"
"\tExternalName service references to an external DNS address instead of\n"
"\tonly pods, which will allow application authors to reference services\n"
"\tthat exist off platform, on other clusters, or locally."
msgstr ""
"\n"
"\tErstelle einen ExternalName-Service mit den gegebenen Namen.\n"
"\n"
"\tExternalName service referenziert eine externe DNS Adresse statt\n"
"\teines pods, was Anwendungsautoren erlaubt, einen Service zu referenzieren,\n"
"\tder abseits der Platform, auf anderen Clustern oder lokal exisiert."

#: pkg/kubectl/cmd/help.go:30
msgid ""
"\n"
"\tHelp provides help for any command in the application.\n"
"\tSimply type kubectl help [path to command] for full details."
msgstr ""
"\n"
"\tHelp hilft bei jedem Befehl in der Anwendung.\n"
"\tGib einfach kubectl help [path to command] für alle Details ein."

#: pkg/kubectl/cmd/create_service.go:173
msgid ""
"\n"
"    # Create a new LoadBalancer service named my-lbs\n"
"    kubectl create service loadbalancer my-lbs --tcp=5678:8080"
msgstr ""
"\n"
"    # Erstelle einen neuen LoadBalancer-Service my-lbs\n"
"    kubectl create service loadbalancer my-lbs --tcp=5678:8080"

#: pkg/kubectl/cmd/create_service.go:53
msgid ""
"\n"
"    # Create a new clusterIP service named my-cs\n"
"    kubectl create service clusterip my-cs --tcp=5678:8080\n"
"\n"
"    # Create a new clusterIP service named my-cs (in headless mode)\n"
"    kubectl create service clusterip my-cs --clusterip=\"None\""
msgstr ""
"\n"
"    # Erstelle einen neuen ClusterIP-Service my-cs\n"
"    kubectl create service clusterip my-cs --tcp=5678:8080\n"
"\n"
"    # Erstelle einen neuen ClusterIP-Service my-cs (im headless-Modus)\n"
"    kubectl create service clusterip my-cs --clusterip=\"None\""

#: pkg/kubectl/cmd/create_deployment.go:36
msgid ""
"\n"
"    # Create a new deployment named my-dep that runs the busybox image.\n"
"    kubectl create deployment my-dep --image=busybox"
msgstr ""
"\n"
"    # Erstelle ein neues Deployment my-dep, dass das busybox-Image "
"nutzt.\n"
"    kubectl create deployment my-dep --image=busybox"

#: pkg/kubectl/cmd/create_service.go:116
msgid ""
"\n"
"    # Create a new nodeport service named my-ns\n"
"    kubectl create service nodeport my-ns --tcp=5678:8080"
msgstr ""
"\n"
"    # Erstelle einen neuen NodePort-Service my-ns\n"
"    kubectl create service nodeport my-ns --tcp=5678:8080"

#: pkg/kubectl/cmd/clusterinfo_dump.go:62
msgid ""
"\n"
"    # Dump current cluster state to stdout\n"
"    kubectl cluster-info dump\n"
"\n"
"    # Dump current cluster state to /path/to/cluster-state\n"
"    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n"
"\n"
"    # Dump all namespaces to stdout\n"
"    kubectl cluster-info dump --all-namespaces\n"
"\n"
"    # Dump a set of namespaces to /path/to/cluster-state\n"
"    kubectl cluster-info dump --namespaces default,kube-system --output-"
"directory=/path/to/cluster-state"
msgstr ""
"\n"
"    # Schreibe den aktuellen Cluster-Zustand auf stdout\n"
"    kubectl cluster-info dump\n"
"\n"
"    # Schreibe aktuellen Cluster-Zustand in /path/to/cluster-state\n"
"    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n"
"\n"
"    # Schreibe alle Namespaces auf stdout\n"
"    kubectl cluster-info dump --all-namespaces\n"
"\n"
"    # Schreibe eine Menge an Namespaces in /path/to/cluster-state\n"
"    kubectl cluster-info dump --namespaces default,kube-system --output-"
"directory=/path/to/cluster-state"

#: pkg/kubectl/cmd/annotate.go:78
msgid ""
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend'.\n"
"    # If the same annotation is set multiple times, only the last value will "
"be applied\n"
"    kubectl annotate pods foo description='my frontend'\n"
"\n"
"    # Update a pod identified by type and name in \"pod.json\"\n"
"    kubectl annotate -f pod.json description='my frontend'\n"
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend running nginx', overwriting any existing value.\n"
"    kubectl annotate --overwrite pods foo description='my frontend running "
"nginx'\n"
"\n"
"    # Update all pods in the namespace\n"
"    kubectl annotate pods --all description='my frontend running nginx'\n"
"\n"
"    # Update pod 'foo' only if the resource is unchanged from version 1.\n"
"    kubectl annotate pods foo description='my frontend running nginx' --"
"resource-version=1\n"
"\n"
"    # Update pod 'foo' by removing an annotation named 'description' if it "
"exists.\n"
"    # Does not require the --overwrite flag.\n"
"    kubectl annotate pods foo description-"
msgstr ""

#: pkg/kubectl/cmd/create_service.go:170
msgid ""
"\n"
"    Create a LoadBalancer service with the specified name."
msgstr ""
"\n"
"    Erstelle einen LoadBalancer-Service mit dem gegebenen Namen."

#: pkg/kubectl/cmd/create_service.go:50
msgid ""
"\n"
"    Create a clusterIP service with the specified name."
msgstr ""
"\n"
"    Erstelle einen ClusterIP-Service mit dem gegebenen Namen."

#: pkg/kubectl/cmd/create_deployment.go:33
msgid ""
"\n"
"    Create a deployment with the specified name."
msgstr ""
"\n"
"    Erstelle ein Deployment mit dem gegebenen Namen."

#: pkg/kubectl/cmd/create_service.go:113
msgid ""
"\n"
"    Create a nodeport service with the specified name."
msgstr ""
"\n"
"    Erstelle einen NodePort-Service mit dem gegebenen Namen."

#: pkg/kubectl/cmd/clusterinfo_dump.go:53
msgid ""
"\n"
"    Dumps cluster info out suitable for debugging and diagnosing cluster "
"problems.  By default, dumps everything to\n"
"    stdout. You can optionally specify a directory with --output-directory.  "
"If you specify a directory, kubernetes will\n"
"    build a set of files in that directory.  By default only dumps things in "
"the 'kube-system' namespace, but you can\n"
"    switch to a different namespace with the --namespaces flag, or specify --"
"all-namespaces to dump all namespaces.\n"
"\n"
"    The command also dumps the logs of all of the pods in the cluster, these "
"logs are dumped into different directories\n"
"    based on namespace and pod name."
msgstr ""

#: pkg/kubectl/cmd/clusterinfo.go:37
msgid ""
"\n"
"  Display addresses of the master and services with label kubernetes.io/"
"cluster-service=true\n"
"  To further debug and diagnose cluster problems, use 'kubectl cluster-info "
"dump'."
msgstr ""
"\n"
"  Zeigt Adressen des Master und von Services mit Label kubernetes.io/"
"cluster-service=true\n"
"  Für das weitere Debugging und die Diagnose von Clusterproblemen nutze "
"'kubectl cluster-info dump'."

#: pkg/kubectl/cmd/create_quota.go:62
msgid ""
"A comma-delimited set of quota scopes that must all match each object "
"tracked by the quota."
msgstr ""
"Eine komma-separierte Menge von Quota-Scopes, die zu jedem Object passen "
"muss, dass von der Quota betroffen ist."

#: pkg/kubectl/cmd/create_quota.go:61
msgid ""
"A comma-delimited set of resource=quantity pairs that define a hard limit."
msgstr ""
"Eine komma-separierte Menge von resource=quantity Paaren, die ein hartes "
"Limit definieren."

#: pkg/kubectl/cmd/create_pdb.go:64
msgid ""
"A label selector to use for this budget. Only equality-based selector "
"requirements are supported."
msgstr ""
"Ein Label-Selektor, der für das Budget benutzt werden kann. Nur gleichheits-"
"basierte Auswahlkriterien werden unterstützt."

#: pkg/kubectl/cmd/expose.go:104
msgid ""
"A label selector to use for this service. Only equality-based selector "
"requirements are supported. If empty (the default) infer the selector from "
"the replication controller or replica set.)"
msgstr ""
"Ein Label-Selektor, der für den Service benutzt werden kann. Nur gleichheits-"
"basierte Auswahlkriterien werden unterstützt. Wenn er leer ist (standard), wird "
"der Selektor vom ReplicationController oder ReplicaSet abgeleitet"

#: pkg/kubectl/cmd/run.go:139
msgid "A schedule in the Cron format the job should be run with."
msgstr "Ein Schedule im Cron Format, dass der Job nutzen soll."

#: pkg/kubectl/cmd/expose.go:109
msgid ""
"Additional external IP address (not managed by Kubernetes) to accept for the "
"service. If this IP is routed to a node, the service can be accessed by this "
"IP in addition to its generated service IP."
msgstr ""
"Zusätzliche, externe IP Adressen (die nicht von Kubernetes verwaltet werden), "
"die der Service akzeptieren soll. Wenn diese IP zu einem Knoten gerouted wird, "
"kann der Service über die IP angesprochen werden, zusätzlich zu seiner "
"generierten Service-IP."

#: pkg/kubectl/cmd/expose.go:110 pkg/kubectl/cmd/run.go:122
msgid ""
"An inline JSON override for the generated object. If this is non-empty, it "
"is used to override the generated object. Requires that the object supply a "
"valid apiVersion field."
msgstr ""

#: pkg/kubectl/cmd/run.go:137
msgid ""
"An inline JSON override for the generated service object. If this is non-"
"empty, it is used to override the generated object. Requires that the object "
"supply a valid apiVersion field.  Only used if --expose is true."
msgstr ""

#: pkg/kubectl/cmd/apply.go:104
msgid "Apply a configuration to a resource by filename or stdin"
msgstr "Wende eine Konfiguration auf eine Resource über den Dateinamen oder "
"stdin an"

#: pkg/kubectl/cmd/certificates.go:72
msgid "Approve a certificate signing request"
msgstr "Genehmige eine Certificate-Signing-Request"

#: pkg/kubectl/cmd/create_service.go:82
msgid ""
"Assign your own ClusterIP or set to 'None' for a 'headless' service (no "
"loadbalancing)."
msgstr ""
"Weise Deine eigene ClusterIP zu oder setze sie auf 'None' für einen 'headless'-"
"Service (kein LoadBalancing)."

#: pkg/kubectl/cmd/attach.go:70
msgid "Attach to a running container"
msgstr "Weise einem laufenden Container zu"

#: pkg/kubectl/cmd/autoscale.go:56
msgid "Auto-scale a Deployment, ReplicaSet, or ReplicationController"
msgstr "Auto-skaliere ein Deployment, ReplicaSet oder ReplicationController"

#: pkg/kubectl/cmd/expose.go:113
msgid ""
"ClusterIP to be assigned to the service. Leave empty to auto-allocate, or "
"set to 'None' to create a headless service."
msgstr ""
"ClusterIP, die dem Service zugewiesen werden soll. Freilassen, für "
"automatische Zuweisung oder auf 'None' setzen für einen headless-Service."

#: pkg/kubectl/cmd/create_clusterrolebinding.go:56
msgid "ClusterRole this ClusterRoleBinding should reference"
msgstr "ClusterRole, die das ClusterRoleBinding referenzieren soll"

#: pkg/kubectl/cmd/create_rolebinding.go:56
msgid "ClusterRole this RoleBinding should reference"
msgstr "ClusterRole, die das RoleBinding referenzieren soll"

#: pkg/kubectl/cmd/rollingupdate.go:102
msgid ""
"Container name which will have its image upgraded. Only relevant when --"
"image is specified, ignored otherwise. Required when using --image on a "
"multi-container pod"
msgstr ""
"Name des Containers dessen Image aktualisiert wird. Nur relevant, wenn "
"--image angegeben ist, sonst ignoriert. Verpflichtend, wenn --image auf einem "
"Multi-Container-Pod verwendet wird"

#: pkg/kubectl/cmd/convert.go:68
msgid "Convert config files between different API versions"
msgstr "Konvertiere Config-Dateien zwischen verschiedenen API Versionen"

#: pkg/kubectl/cmd/cp.go:65
msgid "Copy files and directories to and from containers."
msgstr "Kopiere Dateien und Ordner aus/in Container(n)."

#: pkg/kubectl/cmd/create_clusterrolebinding.go:44
msgid "Create a ClusterRoleBinding for a particular ClusterRole"
msgstr "Erstelle ein ClusterRoleBinding für eine bestimmte ClusterRole"

#: pkg/kubectl/cmd/create_service.go:182
msgid "Create a LoadBalancer service."
msgstr "Erstelle einen LoadBalancer-Service."

#: pkg/kubectl/cmd/create_service.go:125
msgid "Create a NodePort service."
msgstr "Erstelle einen NodePort-Service."

#: pkg/kubectl/cmd/create_rolebinding.go:44
msgid "Create a RoleBinding for a particular Role or ClusterRole"
msgstr "Erstelle ein RoleBinding für eine bestimmte Role oder ClusterRole"

#: pkg/kubectl/cmd/create_secret.go:214
msgid "Create a TLS secret"
msgstr "Erstelle ein TLS-Secret"

#: pkg/kubectl/cmd/create_service.go:69
msgid "Create a clusterIP service."
msgstr "Erstelle einen ClusterIP-Service"

#: pkg/kubectl/cmd/create_configmap.go:60
msgid "Create a configmap from a local file, directory or literal value"
msgstr "Erstelle eine ConfigMap von einer Datei, einem Ordner oder einem "
"festen Wert"

#: pkg/kubectl/cmd/create_deployment.go:46
msgid "Create a deployment with the specified name."
msgstr "Erstelle ein Deployment mit dem gegebenen Namen."

#: pkg/kubectl/cmd/create_namespace.go:45
msgid "Create a namespace with the specified name"
msgstr "Erstelle einen Namespace mit dem gegebenen Namen"

#: pkg/kubectl/cmd/create_pdb.go:50
msgid "Create a pod disruption budget with the specified name."
msgstr "Erstelle ein Pod-Disruption-Budget mit dem gegebenen Namen."

#: pkg/kubectl/cmd/create_quota.go:48
msgid "Create a quota with the specified name."
msgstr "Erstelle eine Quota mit dem gegebenen Namen."

#: pkg/kubectl/cmd/create.go:63
msgid "Create a resource by filename or stdin"
msgstr "Erstelle eine Resource von einer Datei oder stdin"

#: pkg/kubectl/cmd/create_secret.go:144
msgid "Create a secret for use with a Docker registry"
msgstr "Erstelle ein Secret für die Benutzung mit einer Docker-Registry"

#: pkg/kubectl/cmd/create_secret.go:74
msgid "Create a secret from a local file, directory or literal value"
msgstr "Erstelle ein Secret von einer lokalen Datei, einem Ordner oder einem "
"festen Wert"

#: pkg/kubectl/cmd/create_secret.go:35
msgid "Create a secret using specified subcommand"
msgstr "Erstelle ein Secret mit dem angegebenen Sub-Befehl"

#: pkg/kubectl/cmd/create_serviceaccount.go:45
msgid "Create a service account with the specified name"
msgstr "Erstelle einen ServiceAccount mit dem gegebenen Namen"

#: pkg/kubectl/cmd/create_service.go:37
msgid "Create a service using specified subcommand."
msgstr "Erstelle einen Servuce mit dem angegebenen Sub-Befehl"

#: pkg/kubectl/cmd/create_service.go:241
msgid "Create an ExternalName service."
msgstr "Erstelle einen ExternalName-Service."

#: pkg/kubectl/cmd/delete.go:132
msgid ""
"Delete resources by filenames, stdin, resources and names, or by resources "
"and label selector"
msgstr "Lösche Resourcen von einer Datei, stdin, resources- und names- oder mit "
"resources- und label-Selektor"

#: pkg/kubectl/cmd/config/delete_cluster.go:39
msgid "Delete the specified cluster from the kubeconfig"
msgstr "Lösche das angegebene Cluster aus der kubeconfig"

#: pkg/kubectl/cmd/config/delete_context.go:39
msgid "Delete the specified context from the kubeconfig"
msgstr "Lösche den angegebenen Kontext aus der kubeconfig"

#: pkg/kubectl/cmd/certificates.go:122
msgid "Deny a certificate signing request"
msgstr "Lehne eine Certificate-Signing-Request ab"

#: pkg/kubectl/cmd/stop.go:59
msgid "Deprecated: Gracefully shut down a resource by name or filename"
msgstr "Veraltet: Graziöses herunterfahren einer Resource über den Namen "
"oder Dateinamen"

#: pkg/kubectl/cmd/config/get_contexts.go:64
msgid "Describe one or many contexts"
msgstr "Beschreibe einen oder mehrere Kontexte"

#: pkg/kubectl/cmd/top_node.go:78
msgid "Display Resource (CPU/Memory) usage of nodes"
msgstr "Zeige Resourcennutzung (CPU/Memory) von Knoten"

#: pkg/kubectl/cmd/top_pod.go:80
msgid "Display Resource (CPU/Memory) usage of pods"
msgstr "Zeige Resourcennutzung (CPU/Memory) von Pods"

#: pkg/kubectl/cmd/top.go:44
msgid "Display Resource (CPU/Memory) usage."
msgstr "Zeige Resourcennutzung (CPU/Memory)."

#: pkg/kubectl/cmd/clusterinfo.go:51
msgid "Display cluster info"
msgstr "Zeige Cluster-Info"

#: pkg/kubectl/cmd/config/get_clusters.go:41
msgid "Display clusters defined in the kubeconfig"
msgstr "Zeige Cluster, die in der kubeconfig definiert sind"

#: pkg/kubectl/cmd/config/view.go:67
msgid "Display merged kubeconfig settings or a specified kubeconfig file"
msgstr "Zeige vereinte kubeconfig-Einstellungen oder die angegebene kubeconfig-"
"Datei"

#: pkg/kubectl/cmd/get.go:111
msgid "Display one or many resources"
msgstr "Zeige eine oder mehrere Resourcen"

#: pkg/kubectl/cmd/config/current_context.go:49
msgid "Displays the current-context"
msgstr "Zeige den aktuellen Kontext"

#: pkg/kubectl/cmd/explain.go:51
msgid "Documentation of resources"
msgstr "Dokumentation einer Resource"

#: pkg/kubectl/cmd/drain.go:178
msgid "Drain node in preparation for maintenance"
msgstr "Leere Knoten, um eine Wartung vorzubereiten"

#: pkg/kubectl/cmd/clusterinfo_dump.go:39
msgid "Dump lots of relevant info for debugging and diagnosis"
msgstr "Zeige viele relevante Informationen für Debugging und Diagnose"

#: pkg/kubectl/cmd/edit.go:110
msgid "Edit a resource on the server"
msgstr "Bearbeite eine Resource auf dem Server"

#: pkg/kubectl/cmd/create_secret.go:160
msgid "Email for Docker registry"
msgstr "E-Mail für Docker-Registry"

#: pkg/kubectl/cmd/exec.go:69
msgid "Execute a command in a container"
msgstr "Führe einen Befehl im Container aus"

#: pkg/kubectl/cmd/rollingupdate.go:103
msgid ""
"Explicit policy for when to pull container images. Required when --image is "
"same as existing image, ignored otherwise."
msgstr ""
"Explizite Vorgabe, wann Container-Images gepullt werden. Verpflichtend, wenn "
"--image ist gleich dem aktuellen Image ist - sonst ignoriert."

#: pkg/kubectl/cmd/portforward.go:76
msgid "Forward one or more local ports to a pod"
msgstr "Leite einen oder mehrere lokale Ports an einen Pod weiter"

#: pkg/kubectl/cmd/help.go:37
msgid "Help about any command"
msgstr "Hilfe für jeden Befehl"

#: pkg/kubectl/cmd/expose.go:103
msgid ""
"IP to assign to the Load Balancer. If empty, an ephemeral IP will be created "
"and used (cloud-provider specific)."
msgstr ""
"IP, die dem Load-Balancer zugewiesen wird. Falls leer, wird eine temporäre IP "
"erstellt und verwendet (Cloud-Provider spezifisch)"

#: pkg/kubectl/cmd/expose.go:112
msgid ""
"If non-empty, set the session affinity for the service to this; legal "
"values: 'None', 'ClientIP'"
msgstr ""

#: pkg/kubectl/cmd/annotate.go:136
msgid ""
"If non-empty, the annotation update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."
msgstr ""

#: pkg/kubectl/cmd/label.go:134
msgid ""
"If non-empty, the labels update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."
msgstr ""

#: pkg/kubectl/cmd/rollingupdate.go:99
msgid ""
"Image to use for upgrading the replication controller. Must be distinct from "
"the existing image (either new image or new image tag).  Can not be used "
"with --filename/-f"
msgstr ""

#: pkg/kubectl/cmd/rollout/rollout.go:47
msgid "Manage a deployment rollout"
msgstr "Verwalte ein Deployment-Rollout"

#: pkg/kubectl/cmd/drain.go:128
msgid "Mark node as schedulable"
msgstr "Markiere Knoten als schedulable"

#: pkg/kubectl/cmd/drain.go:103
msgid "Mark node as unschedulable"
msgstr "Markiere Knoten als unschedulable"

#: pkg/kubectl/cmd/rollout/rollout_pause.go:74
msgid "Mark the provided resource as paused"
msgstr "Markiere die gegebene Resource als pausiert"

#: pkg/kubectl/cmd/certificates.go:36
msgid "Modify certificate resources."
msgstr "Verändere Certificate-Resources"

#: pkg/kubectl/cmd/config/config.go:40
msgid "Modify kubeconfig files"
msgstr "Verändere kubeconfig Dateien"

#: pkg/kubectl/cmd/expose.go:108
msgid ""
"Name or number for the port on the container that the service should direct "
"traffic to. Optional."
msgstr ""
"Name oder Nummer des Ports in dem Container, zu dem der Service Daten leiten "
"soll. Optional."

#: pkg/kubectl/cmd/logs.go:113
msgid ""
"Only return logs after a specific date (RFC3339). Defaults to all logs. Only "
"one of since-time / since may be used."
msgstr ""
"Zeige nur Logs nach einem bestimmten Datum (RFC3339) an. Zeigt standardmäßig "
"alle logs. Es kann entweder since-time oder since benutzt werden."

#: pkg/kubectl/cmd/completion.go:104
msgid "Output shell completion code for the specified shell (bash or zsh)"
msgstr "Zeige Shell-Completion-Code für die angegebene Shell (bash oder zsh)"

#: pkg/kubectl/cmd/convert.go:85
msgid ""
"Output the formatted object with the given group version (for ex: "
"'extensions/v1beta1').)"
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:158
msgid "Password for Docker registry authentication"
msgstr "Passwort für die Authentifizierung bei der Docker-Registry"

#: pkg/kubectl/cmd/create_secret.go:226
msgid "Path to PEM encoded public key certificate."
msgstr "Pfad des Public-Key-Zertifikats im PEM-Format."

#: pkg/kubectl/cmd/create_secret.go:227
msgid "Path to private key associated with given certificate."
msgstr "Pfad zum Private-Key, der zum gegebenen Zertifikat passt."

#: pkg/kubectl/cmd/rollingupdate.go:85
msgid "Perform a rolling update of the given ReplicationController"
msgstr "Führe ein Rolling-Update des gegebenen ReplicationControllers aus"

#: pkg/kubectl/cmd/scale.go:83
msgid ""
"Precondition for resource version. Requires that the current resource "
"version match this value in order to scale."
msgstr ""
"Vorbedingung für Resource-Version. Verlangt, dass die aktuelle Resource-"
"Version diesen Wert erfüllt, um zu skalieren."

#: pkg/kubectl/cmd/version.go:40
msgid "Print the client and server version information"
msgstr "Schreibt die Client- und Server-Versionsinformation"

#: pkg/kubectl/cmd/options.go:38
msgid "Print the list of flags inherited by all commands"
msgstr "Schreibt die Liste von Optionen, die alle Befehle erben"

#: pkg/kubectl/cmd/logs.go:93
msgid "Print the logs for a container in a pod"
msgstr "Schreibt die Logs für einen Container in einem Pod"

#: pkg/kubectl/cmd/replace.go:71
msgid "Replace a resource by filename or stdin"
msgstr "Ersetze eine Resource von einem Dateinamen oder stdin"

#: pkg/kubectl/cmd/rollout/rollout_resume.go:72
msgid "Resume a paused resource"
msgstr "Setze eine pausierte Resource fort"

#: pkg/kubectl/cmd/create_rolebinding.go:57
msgid "Role this RoleBinding should reference"
msgstr "Role, die dieses RoleBinding referenzieren soll"

#: pkg/kubectl/cmd/run.go:97
msgid "Run a particular image on the cluster"
msgstr "Starte ein bestimmtes Image auf dem Cluster"

#: pkg/kubectl/cmd/proxy.go:69
msgid "Run a proxy to the Kubernetes API server"
msgstr "Starte einen Proxy zum Kubernetes-API-Server"

#: pkg/kubectl/cmd/create_secret.go:161
msgid "Server location for Docker registry"
msgstr ""

#: pkg/kubectl/cmd/scale.go:71
msgid ""
"Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job"
msgstr ""
"Setze eine neue Größe für ein Deployment, ReplicaSet, ReplicationController "
"oder Job"

#: pkg/kubectl/cmd/set/set.go:38
msgid "Set specific features on objects"
msgstr "Setze bestimmte Features auf Objekten"

#: pkg/kubectl/cmd/apply_set_last_applied.go:83
msgid ""
"Set the last-applied-configuration annotation on a live object to match the "
"contents of a file."
msgstr ""
"Setze die Annotation Last-Applied-Configuration auf einem Live-Objekt auf den "
"Inhalt einer Datei."

#: pkg/kubectl/cmd/set/set_selector.go:82
msgid "Set the selector on a resource"
msgstr "Setze den Selektor auf einer Resource"

#: pkg/kubectl/cmd/config/create_cluster.go:68
msgid "Sets a cluster entry in kubeconfig"
msgstr "Setze einen Cluster-Eintrag in der kubeconfig"

#: pkg/kubectl/cmd/config/create_context.go:58
msgid "Sets a context entry in kubeconfig"
msgstr "Setze einen Kontext-Eintrag in der kubeconfig"

#: pkg/kubectl/cmd/config/create_authinfo.go:104
msgid "Sets a user entry in kubeconfig"
msgstr "Setze einen User-Eintrag in der kubeconfig"

#: pkg/kubectl/cmd/config/set.go:60
msgid "Sets an individual value in a kubeconfig file"
msgstr "Setze einen einzelnen Value in einer kubeconfig-Datei"

#: pkg/kubectl/cmd/config/use_context.go:49
msgid "Sets the current-context in a kubeconfig file"
msgstr "Setze den aktuellen Kontext in einer kubeconfig-Datei"

#: pkg/kubectl/cmd/describe.go:86
msgid "Show details of a specific resource or group of resources"
msgstr "Zeige Details zu einer bestimmten Resource oder Gruppe von "
"Resourcen"

#: pkg/kubectl/cmd/rollout/rollout_status.go:58
msgid "Show the status of the rollout"
msgstr "Zeige den Status des Rollout"

#: pkg/kubectl/cmd/expose.go:106
msgid "Synonym for --target-port"
msgstr "Synonym für --target-port"

#: pkg/kubectl/cmd/expose.go:88
msgid ""
"Take a replication controller, service, deployment or pod and expose it as a "
"new Kubernetes Service"
msgstr ""
"Nehme einen Replication Controller, Service, Deployment oder Pod und biete "
"ihn als neuen Kubernetes-Service an"

#: pkg/kubectl/cmd/run.go:117
msgid "The image for the container to run."
msgstr "Das Image, dass auf dem Container gestartet werden soll."

#: pkg/kubectl/cmd/run.go:119
msgid ""
"The image pull policy for the container. If left empty, this value will not "
"be specified by the client and defaulted by the server"
msgstr ""
"Die Image-Pull-Policy für den Container. Wenn leer, wird der Wert nicht vom "
"Client gesetzt, sondern standardmäßig vom Server."

#: pkg/kubectl/cmd/rollingupdate.go:101
msgid ""
"The key to use to differentiate between two different controllers, default "
"'deployment'.  Only relevant when --image is specified, ignored otherwise"
msgstr ""

#: pkg/kubectl/cmd/create_pdb.go:63
msgid ""
"The minimum number or percentage of available pods this budget requires."
msgstr ""
"Die minimale Anzahl oder Prozentzahl von verfügbaren Pods, die das Budget "
"voraussetzt."

#: pkg/kubectl/cmd/expose.go:111
msgid "The name for the newly created object."
msgstr "Der Name des neu erstellten Objekts."

#: pkg/kubectl/cmd/autoscale.go:72
msgid ""
"The name for the newly created object. If not specified, the name of the "
"input resource will be used."
msgstr ""
"Der Name des neu erstellten Objekts. Falls nicht angegeben, wird der Name "
"der Input-Resource verwendet."

#: pkg/kubectl/cmd/run.go:116
msgid ""
"The name of the API generator to use, see http://kubernetes.io/docs/user-"
"guide/kubectl-conventions/#generators for a list."
msgstr ""
"Der Name des zu verwendenden API-Generators. Siehe http://kubernetes.io/docs/"
"user-guide/kubectl-conventions/#generators für eine Übersicht."

#: pkg/kubectl/cmd/autoscale.go:67
msgid ""
"The name of the API generator to use. Currently there is only 1 generator."
msgstr ""
"Der Name des zu verwendenden API-Generators. Zur Zeit gibt es nur einen "
"Generator."

#: pkg/kubectl/cmd/expose.go:99
msgid ""
"The name of the API generator to use. There are 2 generators: 'service/v1' "
"and 'service/v2'. The only difference between them is that service port in "
"v1 is named 'default', while it is left unnamed in v2. Default is 'service/"
"v2'."
msgstr ""
"Der Name des zu verwendenden API-Generators. Es gibt zwei Generatoren: "
"'service/v1' und 'service/v2'. Der einzige Unterschied ist, dass der "
"Serviceport in v1 'default' heißt, während er in v2 unbenannt bleibt. "
"Standard ist 'service/v2'."

#: pkg/kubectl/cmd/run.go:136
msgid ""
"The name of the generator to use for creating a service.  Only used if --"
"expose is true"
msgstr ""
"Der Name des zu verwendenden Generators, um einen Service zu erstellen. Wird "
"nur benutzt, wenn --expose true ist"

#: pkg/kubectl/cmd/expose.go:100
msgid "The network protocol for the service to be created. Default is 'TCP'."
msgstr "Das Netzwerkprotokoll, für den zu erstellenden Service. Standard ist "
"'TCP'."

#: pkg/kubectl/cmd/expose.go:101
msgid ""
"The port that the service should serve on. Copied from the resource being "
"exposed, if unspecified"
msgstr ""
"Der Port auf den der Service hören soll. Wird von der angebotenen Resource "
"kopiert, falls nicht angegeben"

#: pkg/kubectl/cmd/run.go:124
msgid ""
"The port that this container exposes.  If --expose is true, this is also the "
"port used by the service that is created."
msgstr ""
"Der Port, den der Container anbietet.  Wenn --expose true ist, ist es auch "
"der Port, den der zu erstellende Service verwendet"

#: pkg/kubectl/cmd/run.go:134
msgid ""
"The resource requirement limits for this container.  For example, 'cpu=200m,"
"memory=512Mi'.  Note that server side components may assign limits depending "
"on the server configuration, such as limit ranges."
msgstr ""

#: pkg/kubectl/cmd/run.go:133
msgid ""
"The resource requirement requests for this container.  For example, "
"'cpu=100m,memory=256Mi'.  Note that server side components may assign "
"requests depending on the server configuration, such as limit ranges."
msgstr ""

#: pkg/kubectl/cmd/run.go:131
msgid ""
"The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  "
"If set to 'Always' a deployment is created, if set to 'OnFailure' a job is "
"created, if set to 'Never', a regular pod is created. For the latter two --"
"replicas must be 1.  Default 'Always', for CronJobs ` + "`" + `Never` + "`" + `."
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:88
msgid "The type of secret to create"
msgstr "Der Typ des zu erstellenden Secrets"

#: pkg/kubectl/cmd/expose.go:102
msgid ""
"Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is "
"'ClusterIP'."
msgstr ""
"Typ für diesen Service: ClusterIP, NodePort oder LoadBalancer. Standard ist "
"'ClusterIP'."

#: pkg/kubectl/cmd/rollout/rollout_undo.go:72
msgid "Undo a previous rollout"
msgstr "Widerrufe ein vorheriges Rollout"

#: pkg/kubectl/cmd/config/unset.go:48
msgid "Unsets an individual value in a kubeconfig file"
msgstr ""

#: pkg/kubectl/cmd/patch.go:96
msgid "Update field(s) of a resource using strategic merge patch"
msgstr "Aktualisiere Felder einer Resource mit einem Strategic-Merge-Patch"

#: pkg/kubectl/cmd/set/set_image.go:95
msgid "Update image of a pod template"
msgstr "Aktualisiere das Image einer Pod-Template"

#: pkg/kubectl/cmd/set/set_resources.go:102
msgid "Update resource requests/limits on objects with pod templates"
msgstr "Aktualisiere Resourcen requests/limits auf Objekten mit Pod-Templates"

#: pkg/kubectl/cmd/annotate.go:116
msgid "Update the annotations on a resource"
msgstr "Aktualisiere die Annotationen auf einer Resource"

#: pkg/kubectl/cmd/label.go:114
msgid "Update the labels on a resource"
msgstr "Aktualisiere die Labels auf einer Resource"

#: pkg/kubectl/cmd/taint.go:87
msgid "Update the taints on one or more nodes"
msgstr "Aktualisiere die Taints auf einem oder mehreren Knoten"

#: pkg/kubectl/cmd/create_secret.go:156
msgid "Username for Docker registry authentication"
msgstr "Username für Authentifizierung bei der Docker-Registry"

#: pkg/kubectl/cmd/apply_view_last_applied.go:64
msgid "View latest last-applied-configuration annotations of a resource/object"
msgstr "Zeige die aktuelle Annotation Last-Applied-Configuration einer Resource "
"/ eines Object"

#: pkg/kubectl/cmd/rollout/rollout_history.go:52
msgid "View rollout history"
msgstr "Zeige rollout-Verlauf"

#: pkg/kubectl/cmd/clusterinfo_dump.go:46
msgid ""
"Where to output the files.  If empty or '-' uses stdout, otherwise creates a "
"directory hierarchy in that directory"
msgstr ""

#: pkg/kubectl/cmd/run_test.go:85
msgid "dummy restart flag)"
msgstr ""

#: pkg/kubectl/cmd/create_service.go:254
msgid "external name of service"
msgstr ""

#: pkg/kubectl/cmd/cmd.go:227
msgid "kubectl controls the Kubernetes cluster manager"
msgstr "kubectl kontrolliert den Kubernetes-Cluster-Manager"
`)

func translationsKubectlDe_deLc_messagesK8sPoBytes() ([]byte, error) {
	return _translationsKubectlDe_deLc_messagesK8sPo, nil
}

func translationsKubectlDe_deLc_messagesK8sPo() (*asset, error) {
	bytes, err := translationsKubectlDe_deLc_messagesK8sPoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/de_DE/LC_MESSAGES/k8s.po", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlDefaultLc_messagesK8sMo = []byte("\xde\x12\x04\x95\x00\x00\x00\x00\xeb\x00\x00\x00\x1c\x00\x00\x00t\a\x00\x009\x01\x00\x00\xcc\x0e\x00\x00\x00\x00\x00\x00\xb0\x13\x00\x00\xdc\x00\x00\x00\xb1\x13\x00\x00\xb6\x00\x00\x00\x8e\x14\x00\x00\v\x02\x00\x00E\x15\x00\x00\x1f\x01\x00\x00Q\x17\x00\x00z\x00\x00\x00q\x18\x00\x00_\x02\x00\x00\xec\x18\x00\x00\u007f\x01\x00\x00L\x1b\x00\x00\x8f\x01\x00\x00\xcc\x1c\x00\x00k\x01\x00\x00\\\x1e\x00\x00k\x01\x00\x00\xc8\x1f\x00\x00>\x01\x00\x004!\x00\x00\x03\x02\x00\x00s\"\x00\x00o\x01\x00\x00w$\x00\x00H\x05\x00\x00\xe7%\x00\x00g\x02\x00\x000+\x00\x00\x1b\x02\x00\x00\x98-\x00\x00q\x01\x00\x00\xb4/\x00\x00\xa8\x01\x00\x00&1\x00\x00\xd4\x01\x00\x00\xcf2\x00\x00\x02\x02\x00\x00\xa44\x00\x00\xb4\x00\x00\x00\xa76\x00\x00\xb7\x02\x00\x00\\7\x00\x00\x92\x03\x00\x00\x14:\x00\x00\xbf\x01\x00\x00\xa7=\x00\x00=\x00\x00\x00g?\x00\x00;\x00\x00\x00\xa5?\x00\x00\xcd\x02\x00\x00\xe1?\x00\x00<\x00\x00\x00\xafB\x00\x00P\x00\x00\x00\xecB\x00\x00S\x00\x00\x00=C\x00\x00<\x00\x00\x00\x91C\x00\x00\xac\x01\x00\x00\xceC\x00\x00\x13\x03\x00\x00{E\x00\x00\xea\x01\x00\x00\x8fH\x00\x00\xfa\x01\x00\x00zJ\x00\x00\xda\x01\x00\x00uL\x00\x00c\x01\x00\x00PN\x00\x00T\x01\x00\x00\xb4O\x00\x00\xba\x06\x00\x00\tQ\x00\x00\xf9\x01\x00\x00\xc4W\x00\x00\xe0\x02\x00\x00\xbeY\x00\x00\x02\x03\x00\x00\x9f\\\x00\x00\xfb\x00\x00\x00\xa2_\x00\x00\xa5\x01\x00\x00\x9e`\x00\x00\xb4\x01\x00\x00Db\x00\x00\x18\x00\x00\x00\xf9c\x00\x00<\x00\x00\x00\x12d\x00\x00=\x00\x00\x00Od\x00\x00\xc6\x00\x00\x00\x8dd\x00\x00g\x02\x00\x00Te\x00\x00.\x00\x00\x00\xbcg\x00\x001\x03\x00\x00\xebg\x00\x00g\x00\x00\x00\x1dk\x00\x00Q\x00\x00\x00\x85k\x00\x00R\x00\x00\x00\xd7k\x00\x00\"\x00\x00\x00*l\x00\x00X\x02\x00\x00Ml\x00\x004\x00\x00\x00\xa6n\x00\x00}\x00\x00\x00\xdbn\x00\x00k\x01\x00\x00Yo\x00\x00\x81\a\x00\x00\xc5p\x00\x00f\x01\x00\x00Gx\x00\x00\x85\x00\x00\x00\xaey\x00\x00\xea\x00\x00\x004z\x00\x00\xd9\x00\x00\x00\x1f{\x00\x00\n\x05\x00\x00\xf9{\x00\x00\x10\x05\x00\x00\x04\x81\x00\x00\x1c\x00\x00\x00\x15\x86\x00\x00\x1e\x00\x00\x002\x86\x00\x00\x98\x02\x00\x00Q\x86\x00\x00\xbc\x01\x00\x00\xea\x88\x00\x00\x9c\x01\x00\x00\xa7\x8a\x00\x00q\x01\x00\x00D\x8c\x00\x00\x05\x01\x00\x00\xb6\x8d\x00\x00\xdf\x01\x00\x00\xbc\x8e\x00\x00\x1c\x01\x00\x00\x9c\x90\x00\x00\xc1\x01\x00\x00\xb9\x91\x00\x00\x1b\x02\x00\x00{\x93\x00\x00\xc0\x00\x00\x00\x97\x95\x00\x00\xd5\x02\x00\x00X\x96\x00\x00\x9d\x00\x00\x00.\x99\x00\x00X\x00\x00\x00\u0319\x00\x00%\x02\x00\x00%\x9a\x00\x00o\x00\x00\x00K\x9c\x00\x00u\x00\x00\x00\xbb\x9c\x00\x00\x01\x01\x00\x001\x9d\x00\x00v\x00\x00\x003\x9e\x00\x00t\x00\x00\x00\xaa\x9e\x00\x00\xef\x00\x00\x00\x1f\x9f\x00\x00}\x00\x00\x00\x0f\xa0\x00\x00j\x00\x00\x00\x8d\xa0\x00\x00\xc4\x01\x00\x00\xf8\xa0\x00\x00\xf7\x03\x00\x00\xbd\xa2\x00\x00;\x00\x00\x00\xb5\xa6\x00\x008\x00\x00\x00\xf1\xa6\x00\x001\x00\x00\x00*\xa7\x00\x007\x00\x00\x00\\\xa7\x00\x00u\x02\x00\x00\x94\xa7\x00\x00\xb0\x00\x00\x00\n\xaa\x00\x00[\x00\x00\x00\xbb\xaa\x00\x00J\x00\x00\x00\x17\xab\x00\x00a\x00\x00\x00b\xab\x00\x00\xbd\x00\x00\x00\u012b\x00\x009\x00\x00\x00\x82\xac\x00\x00\xc5\x00\x00\x00\xbc\xac\x00\x00\xae\x00\x00\x00\x82\xad\x00\x00\xd6\x00\x00\x001\xae\x00\x008\x00\x00\x00\b\xaf\x00\x00%\x00\x00\x00A\xaf\x00\x00W\x00\x00\x00g\xaf\x00\x00\x1d\x00\x00\x00\xbf\xaf\x00\x00=\x00\x00\x00\u076f\x00\x00u\x00\x00\x00\x1b\xb0\x00\x004\x00\x00\x00\x91\xb0\x00\x00-\x00\x00\x00\u01b0\x00\x00\xa3\x00\x00\x00\xf4\xb0\x00\x003\x00\x00\x00\x98\xb1\x00\x002\x00\x00\x00\u0331\x00\x008\x00\x00\x00\xff\xb1\x00\x00\x1e\x00\x00\x008\xb2\x00\x00\x1a\x00\x00\x00W\xb2\x00\x009\x00\x00\x00r\xb2\x00\x00\x13\x00\x00\x00\xac\xb2\x00\x00\x1b\x00\x00\x00\xc0\xb2\x00\x00@\x00\x00\x00\u0732\x00\x00,\x00\x00\x00\x1d\xb3\x00\x00*\x00\x00\x00J\xb3\x00\x007\x00\x00\x00u\xb3\x00\x00'\x00\x00\x00\xad\xb3\x00\x00&\x00\x00\x00\u0573\x00\x00.\x00\x00\x00\xfc\xb3\x00\x00=\x00\x00\x00+\xb4\x00\x00*\x00\x00\x00i\xb4\x00\x000\x00\x00\x00\x94\xb4\x00\x00,\x00\x00\x00\u0174\x00\x00\x1f\x00\x00\x00\xf2\xb4\x00\x00]\x00\x00\x00\x12\xb5\x00\x000\x00\x00\x00p\xb5\x00\x000\x00\x00\x00\xa1\xb5\x00\x00\"\x00\x00\x00\u04b5\x00\x00?\x00\x00\x00\xf5\xb5\x00\x00\x1d\x00\x00\x005\xb6\x00\x00,\x00\x00\x00S\xb6\x00\x00+\x00\x00\x00\x80\xb6\x00\x00$\x00\x00\x00\xac\xb6\x00\x00\x14\x00\x00\x00\u0476\x00\x00*\x00\x00\x00\xe6\xb6\x00\x00A\x00\x00\x00\x11\xb7\x00\x00\x1d\x00\x00\x00S\xb7\x00\x00\x1c\x00\x00\x00q\xb7\x00\x00\x1a\x00\x00\x00\x8e\xb7\x00\x00)\x00\x00\x00\xa9\xb7\x00\x006\x00\x00\x00\u04f7\x00\x00\x1d\x00\x00\x00\n\xb8\x00\x00\x19\x00\x00\x00(\xb8\x00\x00 \x00\x00\x00B\xb8\x00\x00v\x00\x00\x00c\xb8\x00\x00(\x00\x00\x00\u06b8\x00\x00\x16\x00\x00\x00\x03\xb9\x00\x00p\x00\x00\x00\x1a\xb9\x00\x00`\x00\x00\x00\x8b\xb9\x00\x00\x9b\x00\x00\x00\xec\xb9\x00\x00\x97\x00\x00\x00\x88\xba\x00\x00\xa8\x00\x00\x00 \xbb\x00\x00\x1b\x00\x00\x00\u027b\x00\x00\x18\x00\x00\x00\xe5\xbb\x00\x00\x1a\x00\x00\x00\xfe\xbb\x00\x00$\x00\x00\x00\x19\xbc\x00\x00\x1d\x00\x00\x00>\xbc\x00\x00\x17\x00\x00\x00\\\xbc\x00\x00a\x00\x00\x00t\xbc\x00\x00s\x00\x00\x00\u05bc\x00\x00B\x00\x00\x00J\xbd\x00\x00Y\x00\x00\x00\x8d\xbd\x00\x00+\x00\x00\x00\xe7\xbd\x00\x00+\x00\x00\x00\x13\xbe\x00\x006\x00\x00\x00?\xbe\x00\x00;\x00\x00\x00v\xbe\x00\x00q\x00\x00\x00\xb2\xbe\x00\x00/\x00\x00\x00$\xbf\x00\x001\x00\x00\x00T\xbf\x00\x00'\x00\x00\x00\x86\xbf\x00\x00'\x00\x00\x00\xae\xbf\x00\x00\x18\x00\x00\x00\u05bf\x00\x00&\x00\x00\x00\xef\xbf\x00\x00%\x00\x00\x00\x16\xc0\x00\x00(\x00\x00\x00<\xc0\x00\x00#\x00\x00\x00e\xc0\x00\x00K\x00\x00\x00\x89\xc0\x00\x00 \x00\x00\x00\xd5\xc0\x00\x00_\x00\x00\x00\xf6\xc0\x00\x00\x1e\x00\x00\x00V\xc1\x00\x00\"\x00\x00\x00u\xc1\x00\x00\"\x00\x00\x00\x98\xc1\x00\x00\x1f\x00\x00\x00\xbb\xc1\x00\x00-\x00\x00\x00\xdb\xc1\x00\x00-\x00\x00\x00\t\xc2\x00\x009\x00\x00\x007\xc2\x00\x00\x1e\x00\x00\x00q\xc2\x00\x00\x19\x00\x00\x00\x90\xc2\x00\x00c\x00\x00\x00\xaa\xc2\x00\x00#\x00\x00\x00\x0e\xc3\x00\x00\x82\x00\x00\x002\xc3\x00\x00\x94\x00\x00\x00\xb5\xc3\x00\x00H\x00\x00\x00J\xc4\x00\x00&\x00\x00\x00\x93\xc4\x00\x00e\x00\x00\x00\xba\xc4\x00\x00z\x00\x00\x00 \xc5\x00\x00J\x00\x00\x00\x9b\xc5\x00\x00\xe5\x00\x00\x00\xe6\xc5\x00\x00W\x00\x00\x00\xcc\xc6\x00\x00E\x00\x00\x00$\xc7\x00\x00a\x00\x00\x00j\xc7\x00\x00v\x00\x00\x00\xcc\xc7\x00\x00\xcb\x00\x00\x00C\xc8\x00\x00\xcf\x00\x00\x00\x0f\xc9\x00\x00\x1e\x01\x00\x00\xdf\xc9\x00\x00\x1c\x00\x00\x00\xfe\xca\x00\x00T\x00\x00\x00\x1b\xcb\x00\x00\x17\x00\x00\x00p\xcb\x00\x00/\x00\x00\x00\x88\xcb\x00\x009\x00\x00\x00\xb8\xcb\x00\x00\x1e\x00\x00\x00\xf2\xcb\x00\x00=\x00\x00\x00\x11\xcc\x00\x00$\x00\x00\x00O\xcc\x00\x00\x1f\x00\x00\x00t\xcc\x00\x00&\x00\x00\x00\x94\xcc\x00\x00+\x00\x00\x00\xbb\xcc\x00\x00G\x00\x00\x00\xe7\xcc\x00\x00\x14\x00\x00\x00/\xcd\x00\x00r\x00\x00\x00D\xcd\x00\x00\x13\x00\x00\x00\xb7\xcd\x00\x00\x18\x00\x00\x00\xcb\xcd\x00\x00/\x00\x00\x00\xe4\xcd\x00\x00\xb1\x01\x00\x00\x14\xce\x00\x00\xdc\x00\x00\x00\xc6\xcf\x00\x00\xb6\x00\x00\x00\xa3\xd0\x00\x00\v\x02\x00\x00Z\xd1\x00\x00\x1f\x01\x00\x00f\xd3\x00\x00z\x00\x00\x00\x86\xd4\x00\x00_\x02\x00\x00\x01\xd5\x00\x00\u007f\x01\x00\x00a\xd7\x00\x00\x8f\x01\x00\x00\xe1\xd8\x00\x00k\x01\x00\x00q\xda\x00\x00k\x01\x00\x00\xdd\xdb\x00\x00>\x01\x00\x00I\xdd\x00\x00\x03\x02\x00\x00\x88\xde\x00\x00o\x01\x00\x00\x8c\xe0\x00\x00H\x05\x00\x00\xfc\xe1\x00\x00g\x02\x00\x00E\xe7\x00\x00\x1b\x02\x00\x00\xad\xe9\x00\x00q\x01\x00\x00\xc9\xeb\x00\x00\xa8\x01\x00\x00;\xed\x00\x00\xd4\x01\x00\x00\xe4\xee\x00\x00\x02\x02\x00\x00\xb9\xf0\x00\x00\xb4\x00\x00\x00\xbc\xf2\x00\x00\xb7\x02\x00\x00q\xf3\x00\x00\x92\x03\x00\x00)\xf6\x00\x00\xbf\x01\x00\x00\xbc\xf9\x00\x00=\x00\x00\x00|\xfb\x00\x00;\x00\x00\x00\xba\xfb\x00\x00\xcd\x02\x00\x00\xf6\xfb\x00\x00<\x00\x00\x00\xc4\xfe\x00\x00P\x00\x00\x00\x01\xff\x00\x00S\x00\x00\x00R\xff\x00\x00<\x00\x00\x00\xa6\xff\x00\x00\xac\x01\x00\x00\xe3\xff\x00\x00\x13\x03\x00\x00\x90\x01\x01\x00\xea\x01\x00\x00\xa4\x04\x01\x00\xfa\x01\x00\x00\x8f\x06\x01\x00\xda\x01\x00\x00\x8a\b\x01\x00c\x01\x00\x00e\n\x01\x00T\x01\x00\x00\xc9\v\x01\x00\xba\x06\x00\x00\x1e\r\x01\x00\xf9\x01\x00\x00\xd9\x13\x01\x00\xe0\x02\x00\x00\xd3\x15\x01\x00\x02\x03\x00\x00\xb4\x18\x01\x00\xfb\x00\x00\x00\xb7\x1b\x01\x00\xa5\x01\x00\x00\xb3\x1c\x01\x00\xb4\x01\x00\x00Y\x1e\x01\x00\x18\x00\x00\x00\x0e \x01\x00<\x00\x00\x00' \x01\x00=\x00\x00\x00d \x01\x00\xc6\x00\x00\x00\xa2 \x01\x00g\x02\x00\x00i!\x01\x00.\x00\x00\x00\xd1#\x01\x001\x03\x00\x00\x00$\x01\x00g\x00\x00\x002'\x01\x00Q\x00\x00\x00\x9a'\x01\x00R\x00\x00\x00\xec'\x01\x00\"\x00\x00\x00?(\x01\x00X\x02\x00\x00b(\x01\x004\x00\x00\x00\xbb*\x01\x00}\x00\x00\x00\xf0*\x01\x00k\x01\x00\x00n+\x01\x00\x81\a\x00\x00\xda,\x01\x00f\x01\x00\x00\\4\x01\x00\x85\x00\x00\x00\xc35\x01\x00\xea\x00\x00\x00I6\x01\x00\xd9\x00\x00\x0047\x01\x00\n\x05\x00\x00\x0e8\x01\x00\x10\x05\x00\x00\x19=\x01\x00\x1c\x00\x00\x00*B\x01\x00\x1e\x00\x00\x00GB\x01\x00\x98\x02\x00\x00fB\x01\x00\xbc\x01\x00\x00\xffD\x01\x00\x9c\x01\x00\x00\xbcF\x01\x00q\x01\x00\x00YH\x01\x00\x05\x01\x00\x00\xcbI\x01\x00\xdf\x01\x00\x00\xd1J\x01\x00\x1c\x01\x00\x00\xb1L\x01\x00\xc1\x01\x00\x00\xceM\x01\x00\x1b\x02\x00\x00\x90O\x01\x00\xc0\x00\x00\x00\xacQ\x01\x00\xd5\x02\x00\x00mR\x01\x00\x9d\x00\x00\x00CU\x01\x00X\x00\x00\x00\xe1U\x01\x00%\x02\x00\x00:V\x01\x00o\x00\x00\x00`X\x01\x00u\x00\x00\x00\xd0X\x01\x00\x01\x01\x00\x00FY\x01\x00v\x00\x00\x00HZ\x01\x00t\x00\x00\x00\xbfZ\x01\x00\xef\x00\x00\x004[\x01\x00}\x00\x00\x00$\\\x01\x00j\x00\x00\x00\xa2\\\x01\x00\xc4\x01\x00\x00\r]\x01\x00\xf7\x03\x00\x00\xd2^\x01\x00;\x00\x00\x00\xcab\x01\x008\x00\x00\x00\x06c\x01\x001\x00\x00\x00?c\x01\x007\x00\x00\x00qc\x01\x00u\x02\x00\x00\xa9c\x01\x00\xb0\x00\x00\x00\x1ff\x01\x00[\x00\x00\x00\xd0f\x01\x00J\x00\x00\x00,g\x01\x00a\x00\x00\x00wg\x01\x00\xbd\x00\x00\x00\xd9g\x01\x009\x00\x00\x00\x97h\x01\x00\xc5\x00\x00\x00\xd1h\x01\x00\xae\x00\x00\x00\x97i\x01\x00\xd6\x00\x00\x00Fj\x01\x008\x00\x00\x00\x1dk\x01\x00%\x00\x00\x00Vk\x01\x00W\x00\x00\x00|k\x01\x00\x1d\x00\x00\x00\xd4k\x01\x00=\x00\x00\x00\xf2k\x01\x00u\x00\x00\x000l\x01\x004\x00\x00\x00\xa6l\x01\x00-\x00\x00\x00\xdbl\x01\x00\xa3\x00\x00\x00\tm\x01\x003\x00\x00\x00\xadm\x01\x002\x00\x00\x00\xe1m\x01\x008\x00\x00\x00\x14n\x01\x00\x1e\x00\x00\x00Mn\x01\x00\x1a\x00\x00\x00ln\x01\x009\x00\x00\x00\x87n\x01\x00\x13\x00\x00\x00\xc1n\x01\x00\x1b\x00\x00\x00\xd5n\x01\x00@\x00\x00\x00\xf1n\x01\x00,\x00\x00\x002o\x01\x00*\x00\x00\x00_o\x01\x007\x00\x00\x00\x8ao\x01\x00'\x00\x00\x00\xc2o\x01\x00&\x00\x00\x00\xeao\x01\x00.\x00\x00\x00\x11p\x01\x00=\x00\x00\x00@p\x01\x00*\x00\x00\x00~p\x01\x000\x00\x00\x00\xa9p\x01\x00,\x00\x00\x00\xdap\x01\x00\x1f\x00\x00\x00\aq\x01\x00]\x00\x00\x00'q\x01\x000\x00\x00\x00\x85q\x01\x000\x00\x00\x00\xb6q\x01\x00\"\x00\x00\x00\xe7q\x01\x00?\x00\x00\x00\nr\x01\x00\x1d\x00\x00\x00Jr\x01\x00,\x00\x00\x00hr\x01\x00+\x00\x00\x00\x95r\x01\x00$\x00\x00\x00\xc1r\x01\x00\x14\x00\x00\x00\xe6r\x01\x00*\x00\x00\x00\xfbr\x01\x00A\x00\x00\x00&s\x01\x00\x1d\x00\x00\x00hs\x01\x00\x1c\x00\x00\x00\x86s\x01\x00\x1a\x00\x00\x00\xa3s\x01\x00)\x00\x00\x00\xbes\x01\x006\x00\x00\x00\xe8s\x01\x00\x1d\x00\x00\x00\x1ft\x01\x00\x19\x00\x00\x00=t\x01\x00 \x00\x00\x00Wt\x01\x00v\x00\x00\x00xt\x01\x00(\x00\x00\x00\xeft\x01\x00\x16\x00\x00\x00\x18u\x01\x00p\x00\x00\x00/u\x01\x00`\x00\x00\x00\xa0u\x01\x00\x9b\x00\x00\x00\x01v\x01\x00\x97\x00\x00\x00\x9dv\x01\x00\xa8\x00\x00\x005w\x01\x00\x1b\x00\x00\x00\xdew\x01\x00\x18\x00\x00\x00\xfaw\x01\x00\x1a\x00\x00\x00\x13x\x01\x00$\x00\x00\x00.x\x01\x00\x1d\x00\x00\x00Sx\x01\x00\x17\x00\x00\x00qx\x01\x00a\x00\x00\x00\x89x\x01\x00s\x00\x00\x00\xebx\x01\x00B\x00\x00\x00_y\x01\x00Y\x00\x00\x00\xa2y\x01\x00+\x00\x00\x00\xfcy\x01\x00+\x00\x00\x00(z\x01\x006\x00\x00\x00Tz\x01\x00;\x00\x00\x00\x8bz\x01\x00q\x00\x00\x00\xc7z\x01\x00/\x00\x00\x009{\x01\x001\x00\x00\x00i{\x01\x00'\x00\x00\x00\x9b{\x01\x00'\x00\x00\x00\xc3{\x01\x00\x18\x00\x00\x00\xeb{\x01\x00&\x00\x00\x00\x04|\x01\x00%\x00\x00\x00+|\x01\x00(\x00\x00\x00Q|\x01\x00#\x00\x00\x00z|\x01\x00K\x00\x00\x00\x9e|\x01\x00 \x00\x00\x00\xea|\x01\x00_\x00\x00\x00\v}\x01\x00\x1e\x00\x00\x00k}\x01\x00\"\x00\x00\x00\x8a}\x01\x00\"\x00\x00\x00\xad}\x01\x00\x1f\x00\x00\x00\xd0}\x01\x00-\x00\x00\x00\xf0}\x01\x00-\x00\x00\x00\x1e~\x01\x009\x00\x00\x00L~\x01\x00\x1e\x00\x00\x00\x86~\x01\x00\x19\x00\x00\x00\xa5~\x01\x00c\x00\x00\x00\xbf~\x01\x00#\x00\x00\x00#\u007f\x01\x00\x82\x00\x00\x00G\u007f\x01\x00\x94\x00\x00\x00\xca\u007f\x01\x00H\x00\x00\x00_\x80\x01\x00&\x00\x00\x00\xa8\x80\x01\x00e\x00\x00\x00\u03c0\x01\x00z\x00\x00\x005\x81\x01\x00J\x00\x00\x00\xb0\x81\x01\x00\xe5\x00\x00\x00\xfb\x81\x01\x00W\x00\x00\x00\xe1\x82\x01\x00E\x00\x00\x009\x83\x01\x00a\x00\x00\x00\u007f\x83\x01\x00v\x00\x00\x00\xe1\x83\x01\x00\xcb\x00\x00\x00X\x84\x01\x00\xcf\x00\x00\x00$\x85\x01\x00\x1e\x01\x00\x00\xf4\x85\x01\x00\x1c\x00\x00\x00\x13\x87\x01\x00T\x00\x00\x000\x87\x01\x00\x17\x00\x00\x00\x85\x87\x01\x00/\x00\x00\x00\x9d\x87\x01\x009\x00\x00\x00\u0347\x01\x00\x1e\x00\x00\x00\a\x88\x01\x00=\x00\x00\x00&\x88\x01\x00$\x00\x00\x00d\x88\x01\x00\x1f\x00\x00\x00\x89\x88\x01\x00&\x00\x00\x00\xa9\x88\x01\x00+\x00\x00\x00\u0408\x01\x00G\x00\x00\x00\xfc\x88\x01\x00\x14\x00\x00\x00D\x89\x01\x00r\x00\x00\x00Y\x89\x01\x00\x13\x00\x00\x00\u0309\x01\x00\x18\x00\x00\x00\xe0\x89\x01\x00/\x00\x00\x00\xf9\x89\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00^\x00\x00\x00\\\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\x00\x00\x00\xc4\x00\x00\x00\x0f\x00\x00\x00\xc3\x00\x00\x00\x00\x00\x00\x00-\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\xeb\x00\x00\x00c\x00\x00\x00\x00\x00\x00\x001\x00\x00\x00o\x00\x00\x00}\x00\x00\x00\x00\x00\x00\x00J\x00\x00\x00\x00\x00\x00\x00\xd8\x00\x00\x00\x98\x00\x00\x00U\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdb\x00\x00\x00\x17\x00\x00\x00u\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc9\x00\x00\x00\xb7\x00\x00\x00\xd7\x00\x00\x00*\x00\x00\x00\x99\x00\x00\x00\x00\x00\x00\x00\x1f\x00\x00\x00\x84\x00\x00\x00\x9c\x00\x00\x00\xe6\x00\x00\x00\x9d\x00\x00\x00\xc5\x00\x00\x00\xd9\x00\x00\x00\xb9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x19\x00\x00\x00\xcd\x00\x00\x00\xcb\x00\x00\x00y\x00\x00\x00\x97\x00\x00\x00\xba\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00C\x00\x00\x00\x93\x00\x00\x00\xad\x00\x00\x00\xe1\x00\x00\x00\xa6\x00\x00\x00\xd0\x00\x00\x00r\x00\x00\x00+\x00\x00\x006\x00\x00\x00\x00\x00\x00\x00\xa5\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00h\x00\x00\x00\xa0\x00\x00\x00\x00\x00\x00\x00\xd1\x00\x00\x00\xde\x00\x00\x00;\x00\x00\x00\x00\x00\x00\x00\xe9\x00\x00\x00\xe7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00z\x00\x00\x00/\x00\x00\x00V\x00\x00\x00\x8d\x00\x00\x00\xe3\x00\x00\x00!\x00\x00\x00~\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd3\x00\x00\x00\x88\x00\x00\x00l\x00\x00\x00s\x00\x00\x00g\x00\x00\x00\x05\x00\x00\x00\xc6\x00\x00\x00#\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\xb1\x00\x00\x00\x00\x00\x00\x00\xc2\x00\x00\x00\x13\x00\x00\x00S\x00\x00\x00G\x00\x00\x00$\x00\x00\x00\xc1\x00\x00\x00\xb5\x00\x00\x00X\x00\x00\x00m\x00\x00\x00\t\x00\x00\x00x\x00\x00\x00\xb8\x00\x00\x00\xbd\x00\x00\x00k\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<\x00\x00\x00E\x00\x00\x00\xbf\x00\x00\x00\xbc\x00\x00\x00\x00\x00\x00\x00:\x00\x00\x00\x82\x00\x00\x00\x81\x00\x00\x00&\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x00\x00[\x00\x00\x00I\x00\x00\x00e\x00\x00\x00\x04\x00\x00\x00>\x00\x00\x00\b\x00\x00\x00\x94\x00\x00\x00\x8f\x00\x00\x00\xce\x00\x00\x00?\x00\x00\x00Y\x00\x00\x00\xda\x00\x00\x00\x15\x00\x00\x00\x00\x00\x00\x00'\x00\x00\x004\x00\x00\x00\xcc\x00\x00\x00\f\x00\x00\x005\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\xbb\x00\x00\x00\x00\x00\x00\x00\xa9\x00\x00\x00\x9e\x00\x00\x00\x00\x00\x00\x00\xe5\x00\x00\x00\x00\x00\x00\x00O\x00\x00\x00 \x00\x00\x00)\x00\x00\x00\xcf\x00\x00\x00\x00\x00\x00\x00\x1b\x00\x00\x00Z\x00\x00\x00\"\x00\x00\x00\x00\x00\x00\x00v\x00\x00\x00]\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00a\x00\x00\x00j\x00\x00\x008\x00\x00\x00\xa3\x00\x00\x00q\x00\x00\x00t\x00\x00\x00_\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\v\x00\x00\x00@\x00\x00\x00\xd2\x00\x00\x00,\x00\x00\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\xc8\x00\x00\x00\x95\x00\x00\x00\x06\x00\x00\x00\xa8\x00\x00\x00\xae\x00\x00\x00\xa1\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x0e\x00\x00\x00{\x00\x00\x00\xa7\x00\x00\x00\x00\x00\x00\x00\xb6\x00\x00\x00i\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd5\x00\x00\x00L\x00\x00\x00\x00\x00\x00\x00\xea\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00w\x00\x00\x00\x12\x00\x00\x00=\x00\x00\x00\xaf\x00\x00\x00\a\x00\x00\x00\xdf\x00\x00\x00\xc0\x00\x00\x00N\x00\x00\x00%\x00\x00\x009\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00.\x00\x00\x00\x00\x00\x00\x00\u007f\x00\x00\x00\xbe\x00\x00\x00\xe2\x00\x00\x00\x00\x00\x00\x00P\x00\x00\x00\xb3\x00\x00\x00\r\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00R\x00\x00\x00D\x00\x00\x00B\x00\x00\x00n\x00\x00\x00\x00\x00\x00\x00\xd6\x00\x00\x00\x83\x00\x00\x00\n\x00\x00\x00W\x00\x00\x00\x14\x00\x00\x00Q\x00\x00\x00\xd4\x00\x00\x00d\x00\x00\x00\xac\x00\x00\x00\x16\x00\x00\x00\x96\x00\x00\x00K\x00\x00\x002\x00\x00\x00\x1a\x00\x00\x00\xb4\x00\x00\x00f\x00\x00\x00\xa2\x00\x00\x00\xe8\x00\x00\x00\x02\x00\x00\x00A\x00\x00\x00\xe4\x00\x00\x00\x8c\x00\x00\x00\x9a\x00\x00\x00`\x00\x00\x00\xab\x00\x00\x00M\x00\x00\x007\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\xdc\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x00\x00\x89\x00\x00\x00\x00\x00\x00\x00\xdd\x00\x00\x00\x8e\x00\x00\x00\xca\x00\x00\x00H\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x00\x00\x00\x00\x00\x00\x1c\x00\x00\x00\xb0\x00\x00\x00\x00\x00\x00\x00|\x00\x00\x003\x00\x00\x00T\x00\x00\x00\x87\x00\x00\x00b\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\xaa\x00\x00\x00\xa4\x00\x00\x00\x00\x00\x00\x00p\x00\x00\x00\xc7\x00\x00\x00\x8b\x00\x00\x00\x00\n\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the cluster-admin ClusterRole\n\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin ClusterRole\n\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a new configmap named my-config based on folder bar\n\t\t  kubectl create configmap my-config --from-file=path/to/bar\n\n\t\t  # Create a new configmap named my-config with specified keys instead of file basenames on disk\n\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1.txt --from-file=key2=/path/to/bar/file2.txt\n\n\t\t  # Create a new configmap named my-config with key1=config1 and key2=config2\n\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-literal=key2=config2\x00\n\t\t  # If you don't already have a .dockercfg file, you can create a dockercfg secret directly by using:\n\t\t  kubectl create secret docker-registry my-secret --docker-server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL\x00\n\t\t  # Show metrics for all nodes\n\t\t  kubectl top node\n\n\t\t  # Show metrics for a given node\n\t\t  kubectl top node NODE_NAME\x00\n\t\t# Apply the configuration in pod.json to a pod.\n\t\tkubectl apply -f ./pod.json\n\n\t\t# Apply the JSON passed into stdin to a pod.\n\t\tcat pod.json | kubectl apply -f -\n\n\t\t# Note: --prune is still in Alpha\n\t\t# Apply the configuration in manifest.yaml that matches label app=nginx and delete all the other resources that are not in the file and match label app=nginx.\n\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n\n\t\t# Apply the configuration in manifest.yaml and delete all the other configmaps that are not in the file.\n\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/ConfigMap\x00\n\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and 10, no target CPU utilization specified so a default autoscaling policy will be used:\n\t\tkubectl autoscale deployment foo --min=2 --max=10\n\n\t\t# Auto scale a replication controller \"foo\", with the number of pods between 1 and 5, target CPU utilization at 80%:\n\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80\x00\n\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n\t\tkubectl convert -f pod.yaml\n\n\t\t# Convert the live state of the resource specified by 'pod.yaml' to the latest version\n\t\t# and print to stdout in json format.\n\t\tkubectl convert -f pod.yaml --local -o json\n\n\t\t# Convert all files under current directory to latest version and create them all.\n\t\tkubectl convert -f . | kubectl create -f -\x00\n\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods\n\n\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --resource=pods\n\n\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a new resourcequota named my-quota\n\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,replicationcontrollers=2,resourcequotas=1,secrets=5,persistentvolumeclaims=10\n\n\t\t# Create a new resourcequota named best-effort\n\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort\x00\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=rails label\n\t\t# and require at least one of them being available at any point in time.\n\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-available=1\n\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=nginx label\n\t\t# and require at least half of the pods selected to be available at any point in time.\n\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%\x00\n\t\t# Create a pod using the data in pod.json.\n\t\tkubectl create -f ./pod.json\n\n\t\t# Create a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl create -f -\n\n\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format then create the resource using the edited data.\n\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json\x00\n\t\t# Create a service for a replicated nginx, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rc nginx --port=80 --target-port=8000\n\n\t\t# Create a service for a replication controller identified by type and name specified in \"nginx-controller.yaml\", which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n\n\t\t# Create a service for a pod valid-pod, which serves on port 444 with the name \"frontend\"\n\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n\n\t\t# Create a second service based on the above service, exposing the container port 8443 as port 443 with the name \"nginx-https\"\n\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-https\n\n\t\t# Create a service for a replicated streaming application on port 4100 balancing UDP traffic and named 'video-stream'.\n\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-stream\n\n\t\t# Create a service for a replicated nginx using replica set, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rs nginx --port=80 --target-port=8000\n\n\t\t# Create a service for an nginx deployment, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose deployment nginx --port=80 --target-port=8000\x00\n\t\t# Delete a pod using the type and name specified in pod.json.\n\t\tkubectl delete -f ./pod.json\n\n\t\t# Delete a pod based on the type and name in the JSON passed into stdin.\n\t\tcat pod.json | kubectl delete -f -\n\n\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n\t\tkubectl delete pod,service baz foo\n\n\t\t# Delete pods and services with label name=myLabel.\n\t\tkubectl delete pods,services -l name=myLabel\n\n\t\t# Delete a pod with minimal delay\n\t\tkubectl delete pod foo --now\n\n\t\t# Force delete a pod on a dead node\n\t\tkubectl delete pod foo --grace-period=0 --force\n\n\t\t# Delete all pods\n\t\tkubectl delete pods --all\x00\n\t\t# Describe a node\n\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n\n\t\t# Describe a pod\n\t\tkubectl describe pods/nginx\n\n\t\t# Describe a pod identified by type and name in \"pod.json\"\n\t\tkubectl describe -f pod.json\n\n\t\t# Describe all pods\n\t\tkubectl describe pods\n\n\t\t# Describe pods by label name=myLabel\n\t\tkubectl describe po -l name=myLabel\n\n\t\t# Describe all pods managed by the 'frontend' replication controller (rc-created pods\n\t\t# get the name of the rc as a prefix in the pod the name).\n\t\tkubectl describe pods frontend\x00\n\t\t# Drain node \"foo\", even if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n\t\t$ kubectl drain foo --force\n\n\t\t# As above, but abort if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a grace period of 15 minutes.\n\t\t$ kubectl drain foo --grace-period=900\x00\n\t\t# Edit the service named 'docker-registry':\n\t\tkubectl edit svc/docker-registry\n\n\t\t# Use an alternative editor\n\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n\n\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n\t\tkubectl edit job.v1.batch/myjob -o json\n\n\t\t# Edit the deployment 'mydeployment' in YAML and save the modified config in its annotation:\n\t\tkubectl edit deployment/mydeployment -o yaml --save-config\x00\n\t\t# Get output from running 'date' from pod 123456-7890, using the first container by default\n\t\tkubectl exec 123456-7890 date\n\n\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n\t\tkubectl exec 123456-7890 -c ruby-container date\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il\x00\n\t\t# Get output from running pod 123456-7890, using the first container by default\n\t\tkubectl attach 123456-7890\n\n\t\t# Get output from ruby-container from pod 123456-7890\n\t\tkubectl attach 123456-7890 -c ruby-container\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n\n\t\t# Get output from the first pod of a ReplicaSet named nginx\n\t\tkubectl attach rs/nginx\n\t\t\x00\n\t\t# Get the documentation of the resource and its fields\n\t\tkubectl explain pods\n\n\t\t# Get the documentation of a specific field of a resource\n\t\tkubectl explain pods.spec.containers\x00\n\t\t# Install bash completion on a Mac using homebrew\n\t\tbrew install bash-completion\n\t\tprintf \"\n# Bash completion support\nsource $(brew --prefix)/etc/bash_completion\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for bash into the current shell\n\t\tsource <(kubectl completion bash)\n\n\t\t# Write bash completion code to a file and source if from .bash_profile\n\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n\t\tprintf \"\n# Kubectl shell completion\nsource '$HOME/.kube/completion.bash.inc'\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for zsh[1] into the current shell\n\t\tsource <(kubectl completion zsh)\x00\n\t\t# List all pods in ps output format.\n\t\tkubectl get pods\n\n\t\t# List all pods in ps output format with more information (such as node name).\n\t\tkubectl get pods -o wide\n\n\t\t# List a single replication controller with specified NAME in ps output format.\n\t\tkubectl get replicationcontroller web\n\n\t\t# List a single pod in JSON output format.\n\t\tkubectl get -o json pod web-pod-13je7\n\n\t\t# List a pod identified by type and name specified in \"pod.yaml\" in JSON output format.\n\t\tkubectl get -f pod.yaml -o json\n\n\t\t# Return only the phase value of the specified pod.\n\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n\n\t\t# List all replication controllers and services together in ps output format.\n\t\tkubectl get rc,services\n\n\t\t# List one or more resources by their type and names.\n\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n\n\t\t# List all resources with different types.\n\t\tkubectl get all\x00\n\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports 5000 and 6000 in the pod\n\t\tkubectl port-forward mypod 5000 6000\n\n\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 8888:5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod :5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 0:5000\x00\n\t\t# Mark node \"foo\" as schedulable.\n\t\t$ kubectl uncordon foo\x00\n\t\t# Mark node \"foo\" as unschedulable.\n\t\tkubectl cordon foo\x00\n\t\t# Partially update a node using strategic merge patch\n\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Partially update a node identified by the type and name specified in \"node.json\" using strategic merge patch\n\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Update a container's image; spec.containers[*].name is required because it's a merge key\n\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n\n\t\t# Update a container's image using a json patch with positional arrays\n\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", \"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'\x00\n\t\t# Print flags inherited by all commands\n\t\tkubectl options\x00\n\t\t# Print the address of the master and cluster services\n\t\tkubectl cluster-info\x00\n\t\t# Print the client and server versions for the current context\n\t\tkubectl version\x00\n\t\t# Print the supported API versions\n\t\tkubectl api-versions\x00\n\t\t# Replace a pod using the data in pod.json.\n\t\tkubectl replace -f ./pod.json\n\n\t\t# Replace a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl replace -f -\n\n\t\t# Update a single-container pod's image version (tag) to v4\n\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/\x01:v4/' | kubectl replace -f -\n\n\t\t# Force replace, delete and then re-create the resource\n\t\tkubectl replace --force -f ./pod.json\x00\n\t\t# Return snapshot logs from pod nginx with only one container\n\t\tkubectl logs nginx\n\n\t\t# Return snapshot logs for the pods defined by label app=nginx\n\t\tkubectl logs -lapp=nginx\n\n\t\t# Return snapshot of previous terminated ruby container logs from pod web-1\n\t\tkubectl logs -p -c ruby web-1\n\n\t\t# Begin streaming the logs of the ruby container in pod web-1\n\t\tkubectl logs -f -c ruby web-1\n\n\t\t# Display only the most recent 20 lines of output in pod nginx\n\t\tkubectl logs --tail=20 nginx\n\n\t\t# Show all logs from pod nginx written in the last hour\n\t\tkubectl logs --since=1h nginx\n\n\t\t# Return snapshot logs from first container of a job named hello\n\t\tkubectl logs job/hello\n\n\t\t# Return snapshot logs from container nginx-1 of a deployment named nginx\n\t\tkubectl logs deployment/nginx -c nginx-1\x00\n\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static content from ./local/www/\n\t\tkubectl proxy --port=8011 --www=./local/www/\n\n\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n\t\t# The chosen port for the server will be output to stdout.\n\t\tkubectl proxy --port=0\n\n\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-api\n\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/pods/\n\t\tkubectl proxy --api-prefix=/k8s-api\x00\n\t\t# Scale a replicaset named 'foo' to 3.\n\t\tkubectl scale --replicas=3 rs/foo\n\n\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" to 3.\n\t\tkubectl scale --replicas=3 -f foo.yaml\n\n\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n\n\t\t# Scale multiple replication controllers.\n\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n\n\t\t# Scale job named 'cron' to 3.\n\t\tkubectl scale --replicas=3 job/cron\x00\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file.\n\t\tkubectl apply set-last-applied -f deploy.yaml\n\n\t\t# Execute set-last-applied against each configuration file in a directory.\n\t\tkubectl apply set-last-applied -f path/\n\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file, will create the annotation if it does not already exist.\n\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n\t\t\x00\n\t\t# Show metrics for all pods in the default namespace\n\t\tkubectl top pod\n\n\t\t# Show metrics for all pods in the given namespace\n\t\tkubectl top pod --namespace=NAMESPACE\n\n\t\t# Show metrics for a given pod and its containers\n\t\tkubectl top pod POD_NAME --containers\n\n\t\t# Show metrics for the pods defined by label name=myLabel\n\t\tkubectl top pod -l name=myLabel\x00\n\t\t# Shut down foo.\n\t\tkubectl stop replicationcontroller foo\n\n\t\t# Stop pods and services with label name=myLabel.\n\t\tkubectl stop pods,services -l name=myLabel\n\n\t\t# Shut down the service defined in service.json\n\t\tkubectl stop -f service.json\n\n\t\t# Shut down all resources in the path/to/resources directory\n\t\tkubectl stop -f path/to/resources\x00\n\t\t# Start a single instance of nginx.\n\t\tkubectl run nginx --image=nginx\n\n\t\t# Start a single instance of hazelcast and let the container expose port 5701 .\n\t\tkubectl run hazelcast --image=hazelcast --port=5701\n\n\t\t# Start a single instance of hazelcast and set environment variables \"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --env=\"POD_NAMESPACE=default\"\n\n\t\t# Start a replicated instance of nginx.\n\t\tkubectl run nginx --image=nginx --replicas=5\n\n\t\t# Dry run. Print the corresponding API objects without creating them.\n\t\tkubectl run nginx --image=nginx --dry-run\n\n\t\t# Start a single instance of nginx, but overload the spec of the deployment with a partial set of values parsed from JSON.\n\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", \"spec\": { ... } }'\n\n\t\t# Start a pod of busybox and keep it in the foreground, don't restart it if it exits.\n\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n\n\t\t# Start the nginx container using the default command, but use custom arguments (arg1 .. argN) for that command.\n\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n\n\t\t# Start the nginx container using a different command and custom arguments.\n\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n\n\t\t# Start the perl container to compute \u03c0 to 2000 places and print it out.\n\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\n\n\t\t# Start the cron job to compute \u03c0 to 2000 places and print it out every 5 minutes.\n\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\x00\n\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-user' and effect 'NoSchedule'.\n\t\t# If a taint with that key and effect already exists, its value is replaced as specified.\n\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n\n\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect 'NoSchedule' if one exists.\n\t\tkubectl taint nodes foo dedicated:NoSchedule-\n\n\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n\t\tkubectl taint nodes foo dedicated-\x00\n\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n\t\tkubectl label pods foo unhealthy=true\n\n\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', overwriting any existing value.\n\t\tkubectl label --overwrite pods foo status=unhealthy\n\n\t\t# Update all pods in the namespace\n\t\tkubectl label pods --all status=unhealthy\n\n\t\t# Update a pod identified by the type and name in \"pod.json\"\n\t\tkubectl label -f pod.json status=unhealthy\n\n\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n\t\tkubectl label pods foo status=unhealthy --resource-version=1\n\n\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n\t\t# Does not require the --overwrite flag.\n\t\tkubectl label pods foo bar-\x00\n\t\t# Update pods of frontend-v1 using new replication controller data in frontend-v2.json.\n\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n\n\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n\n\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the image, and switching the\n\t\t# name of the replication controller.\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n\n\t\t# Update the pods of frontend by just changing the image, and keeping the old name.\n\t\tkubectl rolling-update frontend --image=image:v2\n\n\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to frontend-v2).\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback\x00\n\t\t# View the last-applied-configuration annotations by type/name in YAML.\n\t\tkubectl apply view-last-applied deployment/nginx\n\n\t\t# View the last-applied-configuration annotations by file in JSON\n\t\tkubectl apply view-last-applied -f deploy.yaml -o json\x00\n\t\tApply a configuration to a resource by filename or stdin.\n\t\tThis resource will be created if it doesn't exist yet.\n\t\tTo use 'apply', always create the resource initially with either 'apply' or 'create --save-config'.\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not use unless you are aware of what the current state is. See https://issues.k8s.io/34274.\x00\n\t\tConvert config files between different API versions. Both YAML\n\t\tand JSON formats are accepted.\n\n\t\tThe command takes filename, directory, or URL as input, and convert it into format\n\t\tof version specified by --output-version flag. If target version is not specified or\n\t\tnot supported, convert to latest version.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change to output destination.\x00\n\t\tCreate a ClusterRole.\x00\n\t\tCreate a ClusterRoleBinding for a particular ClusterRole.\x00\n\t\tCreate a RoleBinding for a particular Role or ClusterRole.\x00\n\t\tCreate a TLS secret from the given public/private key pair.\n\n\t\tThe public/private key pair must exist before hand. The public key certificate must be .PEM encoded and match the given private key.\x00\n\t\tCreate a configmap based on a file, directory, or specified literal value.\n\n\t\tA single configmap may package one or more key/value pairs.\n\n\t\tWhen creating a configmap based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a configmap based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the configmap.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a namespace with the specified name.\x00\n\t\tCreate a new secret for use with Docker registries.\n\n\t\tDockercfg secrets are used to authenticate against Docker registries.\n\n\t\tWhen using the Docker command line to push images, you can authenticate to a given registry by running\n\n\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n\n    That produces a ~/.dockercfg file that is used by subsequent 'docker push' and 'docker pull' commands to\n\t\tauthenticate to the registry. The email address is optional.\n\n\t\tWhen creating applications, you may have a Docker registry that requires authentication.  In order for the\n\t\tnodes to pull images on your behalf, they have to have the credentials.  You can provide this information\n\t\tby creating a dockercfg secret and attaching it to your service account.\x00\n\t\tCreate a pod disruption budget with the specified name, selector, and desired minimum available pods\x00\n\t\tCreate a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted.\x00\n\t\tCreate a resourcequota with the specified name, hard limits and optional scopes\x00\n\t\tCreate a role with single rule.\x00\n\t\tCreate a secret based on a file, directory, or specified literal value.\n\n\t\tA single secret may package one or more key/value pairs.\n\n\t\tWhen creating a secret based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a secret based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the secret.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a service account with the specified name.\x00\n\t\tCreate and run a particular image, possibly replicated.\n\n\t\tCreates a deployment or job to manage the created container(s).\x00\n\t\tCreates an autoscaler that automatically chooses and sets the number of pods that run in a kubernetes cluster.\n\n\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and creates an autoscaler that uses the given resource as a reference.\n\t\tAn autoscaler can automatically increase or decrease number of pods deployed within the system as needed.\x00\n\t\tDelete resources by filenames, stdin, resources and names, or by resources and label selector.\n\n\t\tJSON and YAML formats are accepted. Only one type of the arguments may be specified: filenames,\n\t\tresources and names, or resources and label selector.\n\n\t\tSome resources, such as pods, support graceful deletion. These resources define a default period\n\t\tbefore they are forcibly terminated (the grace period) but you may override that value with\n\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. Because these resources often\n\t\trepresent entities in the cluster, deletion may not be acknowledged immediately. If the node\n\t\thosting a pod is down or cannot reach the API server, termination may take significantly longer\n\t\tthan the grace period. To force delete a resource,\tyou must pass a grace\tperiod of 0 and specify\n\t\tthe --force flag.\n\n\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the pod's processes have been\n\t\tterminated, which can leave those processes running until the node detects the deletion and\n\t\tcompletes graceful deletion. If your processes use shared storage or talk to a remote API and\n\t\tdepend on the name of the pod to identify themselves, force deleting those pods may result in\n\t\tmultiple processes running on different machines using the same identification which may lead\n\t\tto data corruption or inconsistency. Only force delete pods when you are sure the pod is\n\t\tterminated, or if your application can tolerate multiple copies of the same pod running at once.\n\t\tAlso, if you force delete pods the scheduler may place new pods on those nodes before the node\n\t\thas released those resources and causing those pods to be evicted immediately.\n\n\t\tNote that the delete command does NOT do resource version checks, so if someone\n\t\tsubmits an update to a resource right when you submit a delete, their update\n\t\twill be lost along with the rest of the resource.\x00\n\t\tDeprecated: Gracefully shut down a resource by name or filename.\n\n\t\tThe stop command is deprecated, all its functionalities are covered by delete command.\n\t\tSee 'kubectl delete --help' for more details.\n\n\t\tAttempts to shut down and delete a resource that supports graceful termination.\n\t\tIf the resource is scalable it will be scaled to 0 before deletion.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n\n\t\tThe top-node command allows you to see the resource consumption of nodes.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n\n\t\tThe 'top pod' command allows you to see the resource consumption of pods.\n\n\t\tDue to the metrics pipeline delay, they may be unavailable for a few minutes\n\t\tsince pod creation.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage.\n\n\t\tThe top command allows you to see the resource consumption for nodes or pods.\n\n\t\tThis command requires Heapster to be correctly configured and working on the server. \x00\n\t\tDrain node in preparation for maintenance.\n\n\t\tThe given node will be marked unschedulable to prevent new pods from arriving.\n\t\t'drain' evicts the pods if the APIServer supports eviction\n\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use normal DELETE\n\t\tto delete the pods.\n\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot be deleted through\n\t\tthe API server).  If there are DaemonSet-managed pods, drain will not proceed\n\t\twithout --ignore-daemonsets, and regardless it will not delete any\n\t\tDaemonSet-managed pods, because those pods would be immediately replaced by the\n\t\tDaemonSet controller, which ignores unschedulable markings.  If there are any\n\t\tpods that are neither mirror pods nor managed by ReplicationController,\n\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete any pods unless you\n\t\tuse --force.  --force will also allow deletion to proceed if the managing resource of one\n\t\tor more pods is missing.\n\n\t\t'drain' waits for graceful termination. You should not operate on the machine until\n\t\tthe command completes.\n\n\t\tWhen you are ready to put the node back into service, use kubectl uncordon, which\n\t\twill make the node schedulable again.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)\x00\n\t\tEdit a resource from the default editor.\n\n\t\tThe edit command allows you to directly edit any API resource you can retrieve via the\n\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, or EDITOR\n\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for Windows.\n\t\tYou can edit multiple objects, although changes are applied one at a time. The command\n\t\taccepts filenames as well as command line arguments, although the files you point to must\n\t\tbe previously saved versions of resources.\n\n\t\tEditing is done with the API version used to fetch the resource.\n\t\tTo edit using a specific API version, fully-qualify the resource, version, and group.\n\n\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n\n\t\tThe flag --windows-line-endings can be used to force Windows line endings,\n\t\totherwise the default for your operating system will be used.\n\n\t\tIn the event an error occurs while updating, a temporary file will be created on disk\n\t\tthat contains your unapplied changes. The most common error when updating a resource\n\t\tis another editor changing the resource on the server. When this occurs, you will have\n\t\tto apply your changes to the newer version of the resource, or update your temporary\n\t\tsaved copy to include the latest resource version.\x00\n\t\tMark node as schedulable.\x00\n\t\tMark node as unschedulable.\x00\n\t\tOutput shell completion code for the specified shell (bash or zsh).\n\t\tThe shell code must be evaluated to provide interactive\n\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n\t\tthe .bash_profile.\n\n\t\tNote: this requires the bash-completion framework, which is not installed\n\t\tby default on Mac.  This can be installed by using homebrew:\n\n\t\t    $ brew install bash-completion\n\n\t\tOnce installed, bash_completion must be evaluated.  This can be done by adding the\n\t\tfollowing line to the .bash_profile\n\n\t\t    $ source $(brew --prefix)/etc/bash_completion\n\n\t\tNote for zsh users: [1] zsh completions are only supported in versions of zsh >= 5.2\x00\n\t\tPerform a rolling update of the given ReplicationController.\n\n\t\tReplaces the specified replication controller with a new replication controller by updating one pod at a time to use the\n\t\tnew PodTemplate. The new-controller.json must specify the same namespace as the\n\t\texisting replication controller and overwrite at least one (common) label in its replicaSelector.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)\x00\n\t\tReplace a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted. If replacing an existing resource, the\n\t\tcomplete resource spec must be provided. This can be obtained by\n\n\t\t    $ kubectl get TYPE NAME -o yaml\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or Job.\n\n\t\tScale also allows users to specify one or more preconditions for the scale action.\n\n\t\tIf --current-replicas or --resource-version is specified, it is validated before the\n\t\tscale is attempted, and it is guaranteed that the precondition holds true when the\n\t\tscale is sent to the server.\x00\n\t\tSet the latest last-applied-configuration annotations by setting it to match the contents of a file.\n\t\tThis results in the last-applied-configuration being updated as though 'kubectl apply -f <file>' was run,\n\t\twithout updating any other parts of the object.\x00\n\t\tTo proxy all of the kubernetes api and nothing else, use:\n\n\t\t    $ kubectl proxy --api-prefix=/\n\n\t\tTo proxy only part of the kubernetes api and also some static files:\n\n\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/api/\n\n\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n\n\t\tTo proxy the entire kubernetes api at a different root, use:\n\n\t\t    $ kubectl proxy --api-prefix=/custom/\n\n\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'\x00\n\t\tUpdate field(s) of a resource using strategic merge patch\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tUpdate the labels on a resource.\n\n\t\t* A label must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* If --overwrite is true, then existing labels can be overwritten, otherwise attempting to overwrite a label will result in an error.\n\t\t* If --resource-version is specified, then updates will use this resource version, otherwise the existing resource-version will be used.\x00\n\t\tUpdate the taints on one or more nodes.\n\n\t\t* A taint consists of a key, value, and effect. As an argument here, it is expressed as key=value:effect.\n\t\t* The key must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* The value must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[2]d characters.\n\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n\t\t* Currently taint can only apply to node.\x00\n\t\tView the latest last-applied-configuration annotations by type/name or file.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change output format.\x00\n\t    # !!!Important Note!!!\n\t    # Requires that the 'tar' binary is present in your container\n\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n\n\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in the default namespace\n\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n\n        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific container\n\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n\n\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace <some-namespace>\n\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n\n\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar\x00\n\t  # Create a new TLS secret named tls-secret with the given key pair:\n\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/to/tls.key\x00\n\t  # Create a new namespace named my-namespace\n\t  kubectl create namespace my-namespace\x00\n\t  # Create a new secret named my-secret with keys for each file in folder bar\n\t  kubectl create secret generic my-secret --from-file=path/to/bar\n\n\t  # Create a new secret named my-secret with specified keys instead of names on disk\n\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/.ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n\n\t  # Create a new secret named my-secret with key1=supersecret and key2=topsecret\n\t  kubectl create secret generic my-secret --from-literal=key1=supersecret --from-literal=key2=topsecret\x00\n\t  # Create a new service account named my-service-account\n\t  kubectl create serviceaccount my-service-account\x00\n\t# Create a new ExternalName service named my-ns \n\tkubectl create service externalname my-ns --external-name bar.com\x00\n\tCreate an ExternalName service with the specified name.\n\n\tExternalName service references to an external DNS address instead of\n\tonly pods, which will allow application authors to reference services\n\tthat exist off platform, on other clusters, or locally.\x00\n\tHelp provides help for any command in the application.\n\tSimply type kubectl help [path to command] for full details.\x00\n    # Create a new LoadBalancer service named my-lbs\n    kubectl create service loadbalancer my-lbs --tcp=5678:8080\x00\n    # Create a new clusterIP service named my-cs\n    kubectl create service clusterip my-cs --tcp=5678:8080\n\n    # Create a new clusterIP service named my-cs (in headless mode)\n    kubectl create service clusterip my-cs --clusterip=\"None\"\x00\n    # Create a new deployment named my-dep that runs the busybox image.\n    kubectl create deployment my-dep --image=busybox\x00\n    # Create a new nodeport service named my-ns\n    kubectl create service nodeport my-ns --tcp=5678:8080\x00\n    # Dump current cluster state to stdout\n    kubectl cluster-info dump\n\n    # Dump current cluster state to /path/to/cluster-state\n    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n\n    # Dump all namespaces to stdout\n    kubectl cluster-info dump --all-namespaces\n\n    # Dump a set of namespaces to /path/to/cluster-state\n    kubectl cluster-info dump --namespaces default,kube-system --output-directory=/path/to/cluster-state\x00\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend'.\n    # If the same annotation is set multiple times, only the last value will be applied\n    kubectl annotate pods foo description='my frontend'\n\n    # Update a pod identified by type and name in \"pod.json\"\n    kubectl annotate -f pod.json description='my frontend'\n\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend running nginx', overwriting any existing value.\n    kubectl annotate --overwrite pods foo description='my frontend running nginx'\n\n    # Update all pods in the namespace\n    kubectl annotate pods --all description='my frontend running nginx'\n\n    # Update pod 'foo' only if the resource is unchanged from version 1.\n    kubectl annotate pods foo description='my frontend running nginx' --resource-version=1\n\n    # Update pod 'foo' by removing an annotation named 'description' if it exists.\n    # Does not require the --overwrite flag.\n    kubectl annotate pods foo description-\x00\n    Create a LoadBalancer service with the specified name.\x00\n    Create a clusterIP service with the specified name.\x00\n    Create a deployment with the specified name.\x00\n    Create a nodeport service with the specified name.\x00\n    Dumps cluster info out suitable for debugging and diagnosing cluster problems.  By default, dumps everything to\n    stdout. You can optionally specify a directory with --output-directory.  If you specify a directory, kubernetes will\n    build a set of files in that directory.  By default only dumps things in the 'kube-system' namespace, but you can\n    switch to a different namespace with the --namespaces flag, or specify --all-namespaces to dump all namespaces.\n\n    The command also dumps the logs of all of the pods in the cluster, these logs are dumped into different directories\n    based on namespace and pod name.\x00\n  Display addresses of the master and services with label kubernetes.io/cluster-service=true\n  To further debug and diagnose cluster problems, use 'kubectl cluster-info dump'.\x00A comma-delimited set of quota scopes that must all match each object tracked by the quota.\x00A comma-delimited set of resource=quantity pairs that define a hard limit.\x00A label selector to use for this budget. Only equality-based selector requirements are supported.\x00A label selector to use for this service. Only equality-based selector requirements are supported. If empty (the default) infer the selector from the replication controller or replica set.)\x00A schedule in the Cron format the job should be run with.\x00Additional external IP address (not managed by Kubernetes) to accept for the service. If this IP is routed to a node, the service can be accessed by this IP in addition to its generated service IP.\x00An inline JSON override for the generated object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.\x00An inline JSON override for the generated service object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.  Only used if --expose is true.\x00Apply a configuration to a resource by filename or stdin\x00Approve a certificate signing request\x00Assign your own ClusterIP or set to 'None' for a 'headless' service (no loadbalancing).\x00Attach to a running container\x00Auto-scale a Deployment, ReplicaSet, or ReplicationController\x00ClusterIP to be assigned to the service. Leave empty to auto-allocate, or set to 'None' to create a headless service.\x00ClusterRole this ClusterRoleBinding should reference\x00ClusterRole this RoleBinding should reference\x00Container name which will have its image upgraded. Only relevant when --image is specified, ignored otherwise. Required when using --image on a multi-container pod\x00Convert config files between different API versions\x00Copy files and directories to and from containers.\x00Create a ClusterRoleBinding for a particular ClusterRole\x00Create a LoadBalancer service.\x00Create a NodePort service.\x00Create a RoleBinding for a particular Role or ClusterRole\x00Create a TLS secret\x00Create a clusterIP service.\x00Create a configmap from a local file, directory or literal value\x00Create a deployment with the specified name.\x00Create a namespace with the specified name\x00Create a pod disruption budget with the specified name.\x00Create a quota with the specified name.\x00Create a resource by filename or stdin\x00Create a secret for use with a Docker registry\x00Create a secret from a local file, directory or literal value\x00Create a secret using specified subcommand\x00Create a service account with the specified name\x00Create a service using specified subcommand.\x00Create an ExternalName service.\x00Delete resources by filenames, stdin, resources and names, or by resources and label selector\x00Delete the specified cluster from the kubeconfig\x00Delete the specified context from the kubeconfig\x00Deny a certificate signing request\x00Deprecated: Gracefully shut down a resource by name or filename\x00Describe one or many contexts\x00Display Resource (CPU/Memory) usage of nodes\x00Display Resource (CPU/Memory) usage of pods\x00Display Resource (CPU/Memory) usage.\x00Display cluster info\x00Display clusters defined in the kubeconfig\x00Display merged kubeconfig settings or a specified kubeconfig file\x00Display one or many resources\x00Displays the current-context\x00Documentation of resources\x00Drain node in preparation for maintenance\x00Dump lots of relevant info for debugging and diagnosis\x00Edit a resource on the server\x00Email for Docker registry\x00Execute a command in a container\x00Explicit policy for when to pull container images. Required when --image is same as existing image, ignored otherwise.\x00Forward one or more local ports to a pod\x00Help about any command\x00IP to assign to the Load Balancer. If empty, an ephemeral IP will be created and used (cloud-provider specific).\x00If non-empty, set the session affinity for the service to this; legal values: 'None', 'ClientIP'\x00If non-empty, the annotation update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00If non-empty, the labels update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00Image to use for upgrading the replication controller. Must be distinct from the existing image (either new image or new image tag).  Can not be used with --filename/-f\x00Manage a deployment rollout\x00Mark node as schedulable\x00Mark node as unschedulable\x00Mark the provided resource as paused\x00Modify certificate resources.\x00Modify kubeconfig files\x00Name or number for the port on the container that the service should direct traffic to. Optional.\x00Only return logs after a specific date (RFC3339). Defaults to all logs. Only one of since-time / since may be used.\x00Output shell completion code for the specified shell (bash or zsh)\x00Output the formatted object with the given group version (for ex: 'extensions/v1beta1').)\x00Password for Docker registry authentication\x00Path to PEM encoded public key certificate.\x00Path to private key associated with given certificate.\x00Perform a rolling update of the given ReplicationController\x00Precondition for resource version. Requires that the current resource version match this value in order to scale.\x00Print the client and server version information\x00Print the list of flags inherited by all commands\x00Print the logs for a container in a pod\x00Replace a resource by filename or stdin\x00Resume a paused resource\x00Role this RoleBinding should reference\x00Run a particular image on the cluster\x00Run a proxy to the Kubernetes API server\x00Server location for Docker registry\x00Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job\x00Set specific features on objects\x00Set the last-applied-configuration annotation on a live object to match the contents of a file.\x00Set the selector on a resource\x00Sets a cluster entry in kubeconfig\x00Sets a context entry in kubeconfig\x00Sets a user entry in kubeconfig\x00Sets an individual value in a kubeconfig file\x00Sets the current-context in a kubeconfig file\x00Show details of a specific resource or group of resources\x00Show the status of the rollout\x00Synonym for --target-port\x00Take a replication controller, service, deployment or pod and expose it as a new Kubernetes Service\x00The image for the container to run.\x00The image pull policy for the container. If left empty, this value will not be specified by the client and defaulted by the server\x00The key to use to differentiate between two different controllers, default 'deployment'.  Only relevant when --image is specified, ignored otherwise\x00The minimum number or percentage of available pods this budget requires.\x00The name for the newly created object.\x00The name for the newly created object. If not specified, the name of the input resource will be used.\x00The name of the API generator to use, see http://kubernetes.io/docs/user-guide/kubectl-conventions/#generators for a list.\x00The name of the API generator to use. Currently there is only 1 generator.\x00The name of the API generator to use. There are 2 generators: 'service/v1' and 'service/v2'. The only difference between them is that service port in v1 is named 'default', while it is left unnamed in v2. Default is 'service/v2'.\x00The name of the generator to use for creating a service.  Only used if --expose is true\x00The network protocol for the service to be created. Default is 'TCP'.\x00The port that the service should serve on. Copied from the resource being exposed, if unspecified\x00The port that this container exposes.  If --expose is true, this is also the port used by the service that is created.\x00The resource requirement limits for this container.  For example, 'cpu=200m,memory=512Mi'.  Note that server side components may assign limits depending on the server configuration, such as limit ranges.\x00The resource requirement requests for this container.  For example, 'cpu=100m,memory=256Mi'.  Note that server side components may assign requests depending on the server configuration, such as limit ranges.\x00The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  If set to 'Always' a deployment is created, if set to 'OnFailure' a job is created, if set to 'Never', a regular pod is created. For the latter two --replicas must be 1.  Default 'Always', for CronJobs `Never`.\x00The type of secret to create\x00Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is 'ClusterIP'.\x00Undo a previous rollout\x00Unsets an individual value in a kubeconfig file\x00Update field(s) of a resource using strategic merge patch\x00Update image of a pod template\x00Update resource requests/limits on objects with pod templates\x00Update the annotations on a resource\x00Update the labels on a resource\x00Update the taints on one or more nodes\x00Username for Docker registry authentication\x00View latest last-applied-configuration annotations of a resource/object\x00View rollout history\x00Where to output the files.  If empty or '-' uses stdout, otherwise creates a directory hierarchy in that directory\x00dummy restart flag)\x00external name of service\x00kubectl controls the Kubernetes cluster manager\x00Project-Id-Version: gettext-go-examples-hello\nReport-Msgid-Bugs-To: EMAIL\nPOT-Creation-Date: 2017-03-14 21:32-0700\nPO-Revision-Date: 2017-05-24 18:01+0800\nLast-Translator: Brendan Burns <brendan.d.burns@gmail.com>\nLanguage-Team: \nLanguage: en\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 8bit\nX-Generator: Poedit 1.8.12\nX-Poedit-SourceCharset: UTF-8\nPlural-Forms: nplurals=2; plural=(n != 1);\n\x00\n\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the cluster-admin ClusterRole\n\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin ClusterRole\n\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a new configmap named my-config based on folder bar\n\t\t  kubectl create configmap my-config --from-file=path/to/bar\n\n\t\t  # Create a new configmap named my-config with specified keys instead of file basenames on disk\n\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1.txt --from-file=key2=/path/to/bar/file2.txt\n\n\t\t  # Create a new configmap named my-config with key1=config1 and key2=config2\n\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-literal=key2=config2\x00\n\t\t  # If you don't already have a .dockercfg file, you can create a dockercfg secret directly by using:\n\t\t  kubectl create secret docker-registry my-secret --docker-server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL\x00\n\t\t  # Show metrics for all nodes\n\t\t  kubectl top node\n\n\t\t  # Show metrics for a given node\n\t\t  kubectl top node NODE_NAME\x00\n\t\t# Apply the configuration in pod.json to a pod.\n\t\tkubectl apply -f ./pod.json\n\n\t\t# Apply the JSON passed into stdin to a pod.\n\t\tcat pod.json | kubectl apply -f -\n\n\t\t# Note: --prune is still in Alpha\n\t\t# Apply the configuration in manifest.yaml that matches label app=nginx and delete all the other resources that are not in the file and match label app=nginx.\n\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n\n\t\t# Apply the configuration in manifest.yaml and delete all the other configmaps that are not in the file.\n\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/ConfigMap\x00\n\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and 10, no target CPU utilization specified so a default autoscaling policy will be used:\n\t\tkubectl autoscale deployment foo --min=2 --max=10\n\n\t\t# Auto scale a replication controller \"foo\", with the number of pods between 1 and 5, target CPU utilization at 80%:\n\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80\x00\n\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n\t\tkubectl convert -f pod.yaml\n\n\t\t# Convert the live state of the resource specified by 'pod.yaml' to the latest version\n\t\t# and print to stdout in json format.\n\t\tkubectl convert -f pod.yaml --local -o json\n\n\t\t# Convert all files under current directory to latest version and create them all.\n\t\tkubectl convert -f . | kubectl create -f -\x00\n\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods\n\n\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --resource=pods\n\n\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a new resourcequota named my-quota\n\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,replicationcontrollers=2,resourcequotas=1,secrets=5,persistentvolumeclaims=10\n\n\t\t# Create a new resourcequota named best-effort\n\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort\x00\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=rails label\n\t\t# and require at least one of them being available at any point in time.\n\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-available=1\n\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=nginx label\n\t\t# and require at least half of the pods selected to be available at any point in time.\n\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%\x00\n\t\t# Create a pod using the data in pod.json.\n\t\tkubectl create -f ./pod.json\n\n\t\t# Create a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl create -f -\n\n\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format then create the resource using the edited data.\n\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json\x00\n\t\t# Create a service for a replicated nginx, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rc nginx --port=80 --target-port=8000\n\n\t\t# Create a service for a replication controller identified by type and name specified in \"nginx-controller.yaml\", which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n\n\t\t# Create a service for a pod valid-pod, which serves on port 444 with the name \"frontend\"\n\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n\n\t\t# Create a second service based on the above service, exposing the container port 8443 as port 443 with the name \"nginx-https\"\n\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-https\n\n\t\t# Create a service for a replicated streaming application on port 4100 balancing UDP traffic and named 'video-stream'.\n\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-stream\n\n\t\t# Create a service for a replicated nginx using replica set, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rs nginx --port=80 --target-port=8000\n\n\t\t# Create a service for an nginx deployment, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose deployment nginx --port=80 --target-port=8000\x00\n\t\t# Delete a pod using the type and name specified in pod.json.\n\t\tkubectl delete -f ./pod.json\n\n\t\t# Delete a pod based on the type and name in the JSON passed into stdin.\n\t\tcat pod.json | kubectl delete -f -\n\n\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n\t\tkubectl delete pod,service baz foo\n\n\t\t# Delete pods and services with label name=myLabel.\n\t\tkubectl delete pods,services -l name=myLabel\n\n\t\t# Delete a pod with minimal delay\n\t\tkubectl delete pod foo --now\n\n\t\t# Force delete a pod on a dead node\n\t\tkubectl delete pod foo --grace-period=0 --force\n\n\t\t# Delete all pods\n\t\tkubectl delete pods --all\x00\n\t\t# Describe a node\n\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n\n\t\t# Describe a pod\n\t\tkubectl describe pods/nginx\n\n\t\t# Describe a pod identified by type and name in \"pod.json\"\n\t\tkubectl describe -f pod.json\n\n\t\t# Describe all pods\n\t\tkubectl describe pods\n\n\t\t# Describe pods by label name=myLabel\n\t\tkubectl describe po -l name=myLabel\n\n\t\t# Describe all pods managed by the 'frontend' replication controller (rc-created pods\n\t\t# get the name of the rc as a prefix in the pod the name).\n\t\tkubectl describe pods frontend\x00\n\t\t# Drain node \"foo\", even if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n\t\t$ kubectl drain foo --force\n\n\t\t# As above, but abort if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a grace period of 15 minutes.\n\t\t$ kubectl drain foo --grace-period=900\x00\n\t\t# Edit the service named 'docker-registry':\n\t\tkubectl edit svc/docker-registry\n\n\t\t# Use an alternative editor\n\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n\n\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n\t\tkubectl edit job.v1.batch/myjob -o json\n\n\t\t# Edit the deployment 'mydeployment' in YAML and save the modified config in its annotation:\n\t\tkubectl edit deployment/mydeployment -o yaml --save-config\x00\n\t\t# Get output from running 'date' from pod 123456-7890, using the first container by default\n\t\tkubectl exec 123456-7890 date\n\n\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n\t\tkubectl exec 123456-7890 -c ruby-container date\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il\x00\n\t\t# Get output from running pod 123456-7890, using the first container by default\n\t\tkubectl attach 123456-7890\n\n\t\t# Get output from ruby-container from pod 123456-7890\n\t\tkubectl attach 123456-7890 -c ruby-container\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n\n\t\t# Get output from the first pod of a ReplicaSet named nginx\n\t\tkubectl attach rs/nginx\n\t\t\x00\n\t\t# Get the documentation of the resource and its fields\n\t\tkubectl explain pods\n\n\t\t# Get the documentation of a specific field of a resource\n\t\tkubectl explain pods.spec.containers\x00\n\t\t# Install bash completion on a Mac using homebrew\n\t\tbrew install bash-completion\n\t\tprintf \"\n# Bash completion support\nsource $(brew --prefix)/etc/bash_completion\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for bash into the current shell\n\t\tsource <(kubectl completion bash)\n\n\t\t# Write bash completion code to a file and source if from .bash_profile\n\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n\t\tprintf \"\n# Kubectl shell completion\nsource '$HOME/.kube/completion.bash.inc'\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for zsh[1] into the current shell\n\t\tsource <(kubectl completion zsh)\x00\n\t\t# List all pods in ps output format.\n\t\tkubectl get pods\n\n\t\t# List all pods in ps output format with more information (such as node name).\n\t\tkubectl get pods -o wide\n\n\t\t# List a single replication controller with specified NAME in ps output format.\n\t\tkubectl get replicationcontroller web\n\n\t\t# List a single pod in JSON output format.\n\t\tkubectl get -o json pod web-pod-13je7\n\n\t\t# List a pod identified by type and name specified in \"pod.yaml\" in JSON output format.\n\t\tkubectl get -f pod.yaml -o json\n\n\t\t# Return only the phase value of the specified pod.\n\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n\n\t\t# List all replication controllers and services together in ps output format.\n\t\tkubectl get rc,services\n\n\t\t# List one or more resources by their type and names.\n\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n\n\t\t# List all resources with different types.\n\t\tkubectl get all\x00\n\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports 5000 and 6000 in the pod\n\t\tkubectl port-forward mypod 5000 6000\n\n\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 8888:5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod :5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 0:5000\x00\n\t\t# Mark node \"foo\" as schedulable.\n\t\t$ kubectl uncordon foo\x00\n\t\t# Mark node \"foo\" as unschedulable.\n\t\tkubectl cordon foo\x00\n\t\t# Partially update a node using strategic merge patch\n\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Partially update a node identified by the type and name specified in \"node.json\" using strategic merge patch\n\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Update a container's image; spec.containers[*].name is required because it's a merge key\n\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n\n\t\t# Update a container's image using a json patch with positional arrays\n\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", \"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'\x00\n\t\t# Print flags inherited by all commands\n\t\tkubectl options\x00\n\t\t# Print the address of the master and cluster services\n\t\tkubectl cluster-info\x00\n\t\t# Print the client and server versions for the current context\n\t\tkubectl version\x00\n\t\t# Print the supported API versions\n\t\tkubectl api-versions\x00\n\t\t# Replace a pod using the data in pod.json.\n\t\tkubectl replace -f ./pod.json\n\n\t\t# Replace a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl replace -f -\n\n\t\t# Update a single-container pod's image version (tag) to v4\n\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/\x01:v4/' | kubectl replace -f -\n\n\t\t# Force replace, delete and then re-create the resource\n\t\tkubectl replace --force -f ./pod.json\x00\n\t\t# Return snapshot logs from pod nginx with only one container\n\t\tkubectl logs nginx\n\n\t\t# Return snapshot logs for the pods defined by label app=nginx\n\t\tkubectl logs -lapp=nginx\n\n\t\t# Return snapshot of previous terminated ruby container logs from pod web-1\n\t\tkubectl logs -p -c ruby web-1\n\n\t\t# Begin streaming the logs of the ruby container in pod web-1\n\t\tkubectl logs -f -c ruby web-1\n\n\t\t# Display only the most recent 20 lines of output in pod nginx\n\t\tkubectl logs --tail=20 nginx\n\n\t\t# Show all logs from pod nginx written in the last hour\n\t\tkubectl logs --since=1h nginx\n\n\t\t# Return snapshot logs from first container of a job named hello\n\t\tkubectl logs job/hello\n\n\t\t# Return snapshot logs from container nginx-1 of a deployment named nginx\n\t\tkubectl logs deployment/nginx -c nginx-1\x00\n\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static content from ./local/www/\n\t\tkubectl proxy --port=8011 --www=./local/www/\n\n\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n\t\t# The chosen port for the server will be output to stdout.\n\t\tkubectl proxy --port=0\n\n\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-api\n\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/pods/\n\t\tkubectl proxy --api-prefix=/k8s-api\x00\n\t\t# Scale a replicaset named 'foo' to 3.\n\t\tkubectl scale --replicas=3 rs/foo\n\n\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" to 3.\n\t\tkubectl scale --replicas=3 -f foo.yaml\n\n\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n\n\t\t# Scale multiple replication controllers.\n\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n\n\t\t# Scale job named 'cron' to 3.\n\t\tkubectl scale --replicas=3 job/cron\x00\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file.\n\t\tkubectl apply set-last-applied -f deploy.yaml\n\n\t\t# Execute set-last-applied against each configuration file in a directory.\n\t\tkubectl apply set-last-applied -f path/\n\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file, will create the annotation if it does not already exist.\n\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n\t\t\x00\n\t\t# Show metrics for all pods in the default namespace\n\t\tkubectl top pod\n\n\t\t# Show metrics for all pods in the given namespace\n\t\tkubectl top pod --namespace=NAMESPACE\n\n\t\t# Show metrics for a given pod and its containers\n\t\tkubectl top pod POD_NAME --containers\n\n\t\t# Show metrics for the pods defined by label name=myLabel\n\t\tkubectl top pod -l name=myLabel\x00\n\t\t# Shut down foo.\n\t\tkubectl stop replicationcontroller foo\n\n\t\t# Stop pods and services with label name=myLabel.\n\t\tkubectl stop pods,services -l name=myLabel\n\n\t\t# Shut down the service defined in service.json\n\t\tkubectl stop -f service.json\n\n\t\t# Shut down all resources in the path/to/resources directory\n\t\tkubectl stop -f path/to/resources\x00\n\t\t# Start a single instance of nginx.\n\t\tkubectl run nginx --image=nginx\n\n\t\t# Start a single instance of hazelcast and let the container expose port 5701 .\n\t\tkubectl run hazelcast --image=hazelcast --port=5701\n\n\t\t# Start a single instance of hazelcast and set environment variables \"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --env=\"POD_NAMESPACE=default\"\n\n\t\t# Start a replicated instance of nginx.\n\t\tkubectl run nginx --image=nginx --replicas=5\n\n\t\t# Dry run. Print the corresponding API objects without creating them.\n\t\tkubectl run nginx --image=nginx --dry-run\n\n\t\t# Start a single instance of nginx, but overload the spec of the deployment with a partial set of values parsed from JSON.\n\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", \"spec\": { ... } }'\n\n\t\t# Start a pod of busybox and keep it in the foreground, don't restart it if it exits.\n\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n\n\t\t# Start the nginx container using the default command, but use custom arguments (arg1 .. argN) for that command.\n\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n\n\t\t# Start the nginx container using a different command and custom arguments.\n\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n\n\t\t# Start the perl container to compute \u03c0 to 2000 places and print it out.\n\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\n\n\t\t# Start the cron job to compute \u03c0 to 2000 places and print it out every 5 minutes.\n\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\x00\n\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-user' and effect 'NoSchedule'.\n\t\t# If a taint with that key and effect already exists, its value is replaced as specified.\n\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n\n\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect 'NoSchedule' if one exists.\n\t\tkubectl taint nodes foo dedicated:NoSchedule-\n\n\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n\t\tkubectl taint nodes foo dedicated-\x00\n\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n\t\tkubectl label pods foo unhealthy=true\n\n\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', overwriting any existing value.\n\t\tkubectl label --overwrite pods foo status=unhealthy\n\n\t\t# Update all pods in the namespace\n\t\tkubectl label pods --all status=unhealthy\n\n\t\t# Update a pod identified by the type and name in \"pod.json\"\n\t\tkubectl label -f pod.json status=unhealthy\n\n\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n\t\tkubectl label pods foo status=unhealthy --resource-version=1\n\n\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n\t\t# Does not require the --overwrite flag.\n\t\tkubectl label pods foo bar-\x00\n\t\t# Update pods of frontend-v1 using new replication controller data in frontend-v2.json.\n\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n\n\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n\n\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the image, and switching the\n\t\t# name of the replication controller.\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n\n\t\t# Update the pods of frontend by just changing the image, and keeping the old name.\n\t\tkubectl rolling-update frontend --image=image:v2\n\n\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to frontend-v2).\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback\x00\n\t\t# View the last-applied-configuration annotations by type/name in YAML.\n\t\tkubectl apply view-last-applied deployment/nginx\n\n\t\t# View the last-applied-configuration annotations by file in JSON\n\t\tkubectl apply view-last-applied -f deploy.yaml -o json\x00\n\t\tApply a configuration to a resource by filename or stdin.\n\t\tThis resource will be created if it doesn't exist yet.\n\t\tTo use 'apply', always create the resource initially with either 'apply' or 'create --save-config'.\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not use unless you are aware of what the current state is. See https://issues.k8s.io/34274.\x00\n\t\tConvert config files between different API versions. Both YAML\n\t\tand JSON formats are accepted.\n\n\t\tThe command takes filename, directory, or URL as input, and convert it into format\n\t\tof version specified by --output-version flag. If target version is not specified or\n\t\tnot supported, convert to latest version.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change to output destination.\x00\n\t\tCreate a ClusterRole.\x00\n\t\tCreate a ClusterRoleBinding for a particular ClusterRole.\x00\n\t\tCreate a RoleBinding for a particular Role or ClusterRole.\x00\n\t\tCreate a TLS secret from the given public/private key pair.\n\n\t\tThe public/private key pair must exist before hand. The public key certificate must be .PEM encoded and match the given private key.\x00\n\t\tCreate a configmap based on a file, directory, or specified literal value.\n\n\t\tA single configmap may package one or more key/value pairs.\n\n\t\tWhen creating a configmap based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a configmap based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the configmap.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a namespace with the specified name.\x00\n\t\tCreate a new secret for use with Docker registries.\n\n\t\tDockercfg secrets are used to authenticate against Docker registries.\n\n\t\tWhen using the Docker command line to push images, you can authenticate to a given registry by running\n\n\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n\n    That produces a ~/.dockercfg file that is used by subsequent 'docker push' and 'docker pull' commands to\n\t\tauthenticate to the registry. The email address is optional.\n\n\t\tWhen creating applications, you may have a Docker registry that requires authentication.  In order for the\n\t\tnodes to pull images on your behalf, they have to have the credentials.  You can provide this information\n\t\tby creating a dockercfg secret and attaching it to your service account.\x00\n\t\tCreate a pod disruption budget with the specified name, selector, and desired minimum available pods\x00\n\t\tCreate a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted.\x00\n\t\tCreate a resourcequota with the specified name, hard limits and optional scopes\x00\n\t\tCreate a role with single rule.\x00\n\t\tCreate a secret based on a file, directory, or specified literal value.\n\n\t\tA single secret may package one or more key/value pairs.\n\n\t\tWhen creating a secret based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a secret based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the secret.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a service account with the specified name.\x00\n\t\tCreate and run a particular image, possibly replicated.\n\n\t\tCreates a deployment or job to manage the created container(s).\x00\n\t\tCreates an autoscaler that automatically chooses and sets the number of pods that run in a kubernetes cluster.\n\n\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and creates an autoscaler that uses the given resource as a reference.\n\t\tAn autoscaler can automatically increase or decrease number of pods deployed within the system as needed.\x00\n\t\tDelete resources by filenames, stdin, resources and names, or by resources and label selector.\n\n\t\tJSON and YAML formats are accepted. Only one type of the arguments may be specified: filenames,\n\t\tresources and names, or resources and label selector.\n\n\t\tSome resources, such as pods, support graceful deletion. These resources define a default period\n\t\tbefore they are forcibly terminated (the grace period) but you may override that value with\n\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. Because these resources often\n\t\trepresent entities in the cluster, deletion may not be acknowledged immediately. If the node\n\t\thosting a pod is down or cannot reach the API server, termination may take significantly longer\n\t\tthan the grace period. To force delete a resource,\tyou must pass a grace\tperiod of 0 and specify\n\t\tthe --force flag.\n\n\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the pod's processes have been\n\t\tterminated, which can leave those processes running until the node detects the deletion and\n\t\tcompletes graceful deletion. If your processes use shared storage or talk to a remote API and\n\t\tdepend on the name of the pod to identify themselves, force deleting those pods may result in\n\t\tmultiple processes running on different machines using the same identification which may lead\n\t\tto data corruption or inconsistency. Only force delete pods when you are sure the pod is\n\t\tterminated, or if your application can tolerate multiple copies of the same pod running at once.\n\t\tAlso, if you force delete pods the scheduler may place new pods on those nodes before the node\n\t\thas released those resources and causing those pods to be evicted immediately.\n\n\t\tNote that the delete command does NOT do resource version checks, so if someone\n\t\tsubmits an update to a resource right when you submit a delete, their update\n\t\twill be lost along with the rest of the resource.\x00\n\t\tDeprecated: Gracefully shut down a resource by name or filename.\n\n\t\tThe stop command is deprecated, all its functionalities are covered by delete command.\n\t\tSee 'kubectl delete --help' for more details.\n\n\t\tAttempts to shut down and delete a resource that supports graceful termination.\n\t\tIf the resource is scalable it will be scaled to 0 before deletion.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n\n\t\tThe top-node command allows you to see the resource consumption of nodes.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n\n\t\tThe 'top pod' command allows you to see the resource consumption of pods.\n\n\t\tDue to the metrics pipeline delay, they may be unavailable for a few minutes\n\t\tsince pod creation.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage.\n\n\t\tThe top command allows you to see the resource consumption for nodes or pods.\n\n\t\tThis command requires Heapster to be correctly configured and working on the server. \x00\n\t\tDrain node in preparation for maintenance.\n\n\t\tThe given node will be marked unschedulable to prevent new pods from arriving.\n\t\t'drain' evicts the pods if the APIServer supports eviction\n\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use normal DELETE\n\t\tto delete the pods.\n\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot be deleted through\n\t\tthe API server).  If there are DaemonSet-managed pods, drain will not proceed\n\t\twithout --ignore-daemonsets, and regardless it will not delete any\n\t\tDaemonSet-managed pods, because those pods would be immediately replaced by the\n\t\tDaemonSet controller, which ignores unschedulable markings.  If there are any\n\t\tpods that are neither mirror pods nor managed by ReplicationController,\n\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete any pods unless you\n\t\tuse --force.  --force will also allow deletion to proceed if the managing resource of one\n\t\tor more pods is missing.\n\n\t\t'drain' waits for graceful termination. You should not operate on the machine until\n\t\tthe command completes.\n\n\t\tWhen you are ready to put the node back into service, use kubectl uncordon, which\n\t\twill make the node schedulable again.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)\x00\n\t\tEdit a resource from the default editor.\n\n\t\tThe edit command allows you to directly edit any API resource you can retrieve via the\n\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, or EDITOR\n\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for Windows.\n\t\tYou can edit multiple objects, although changes are applied one at a time. The command\n\t\taccepts filenames as well as command line arguments, although the files you point to must\n\t\tbe previously saved versions of resources.\n\n\t\tEditing is done with the API version used to fetch the resource.\n\t\tTo edit using a specific API version, fully-qualify the resource, version, and group.\n\n\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n\n\t\tThe flag --windows-line-endings can be used to force Windows line endings,\n\t\totherwise the default for your operating system will be used.\n\n\t\tIn the event an error occurs while updating, a temporary file will be created on disk\n\t\tthat contains your unapplied changes. The most common error when updating a resource\n\t\tis another editor changing the resource on the server. When this occurs, you will have\n\t\tto apply your changes to the newer version of the resource, or update your temporary\n\t\tsaved copy to include the latest resource version.\x00\n\t\tMark node as schedulable.\x00\n\t\tMark node as unschedulable.\x00\n\t\tOutput shell completion code for the specified shell (bash or zsh).\n\t\tThe shell code must be evaluated to provide interactive\n\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n\t\tthe .bash_profile.\n\n\t\tNote: this requires the bash-completion framework, which is not installed\n\t\tby default on Mac.  This can be installed by using homebrew:\n\n\t\t    $ brew install bash-completion\n\n\t\tOnce installed, bash_completion must be evaluated.  This can be done by adding the\n\t\tfollowing line to the .bash_profile\n\n\t\t    $ source $(brew --prefix)/etc/bash_completion\n\n\t\tNote for zsh users: [1] zsh completions are only supported in versions of zsh >= 5.2\x00\n\t\tPerform a rolling update of the given ReplicationController.\n\n\t\tReplaces the specified replication controller with a new replication controller by updating one pod at a time to use the\n\t\tnew PodTemplate. The new-controller.json must specify the same namespace as the\n\t\texisting replication controller and overwrite at least one (common) label in its replicaSelector.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)\x00\n\t\tReplace a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted. If replacing an existing resource, the\n\t\tcomplete resource spec must be provided. This can be obtained by\n\n\t\t    $ kubectl get TYPE NAME -o yaml\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or Job.\n\n\t\tScale also allows users to specify one or more preconditions for the scale action.\n\n\t\tIf --current-replicas or --resource-version is specified, it is validated before the\n\t\tscale is attempted, and it is guaranteed that the precondition holds true when the\n\t\tscale is sent to the server.\x00\n\t\tSet the latest last-applied-configuration annotations by setting it to match the contents of a file.\n\t\tThis results in the last-applied-configuration being updated as though 'kubectl apply -f <file>' was run,\n\t\twithout updating any other parts of the object.\x00\n\t\tTo proxy all of the kubernetes api and nothing else, use:\n\n\t\t    $ kubectl proxy --api-prefix=/\n\n\t\tTo proxy only part of the kubernetes api and also some static files:\n\n\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/api/\n\n\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n\n\t\tTo proxy the entire kubernetes api at a different root, use:\n\n\t\t    $ kubectl proxy --api-prefix=/custom/\n\n\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'\x00\n\t\tUpdate field(s) of a resource using strategic merge patch\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tUpdate the labels on a resource.\n\n\t\t* A label must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* If --overwrite is true, then existing labels can be overwritten, otherwise attempting to overwrite a label will result in an error.\n\t\t* If --resource-version is specified, then updates will use this resource version, otherwise the existing resource-version will be used.\x00\n\t\tUpdate the taints on one or more nodes.\n\n\t\t* A taint consists of a key, value, and effect. As an argument here, it is expressed as key=value:effect.\n\t\t* The key must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* The value must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[2]d characters.\n\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n\t\t* Currently taint can only apply to node.\x00\n\t\tView the latest last-applied-configuration annotations by type/name or file.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change output format.\x00\n\t    # !!!Important Note!!!\n\t    # Requires that the 'tar' binary is present in your container\n\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n\n\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in the default namespace\n\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n\n        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific container\n\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n\n\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace <some-namespace>\n\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n\n\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar\x00\n\t  # Create a new TLS secret named tls-secret with the given key pair:\n\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/to/tls.key\x00\n\t  # Create a new namespace named my-namespace\n\t  kubectl create namespace my-namespace\x00\n\t  # Create a new secret named my-secret with keys for each file in folder bar\n\t  kubectl create secret generic my-secret --from-file=path/to/bar\n\n\t  # Create a new secret named my-secret with specified keys instead of names on disk\n\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/.ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n\n\t  # Create a new secret named my-secret with key1=supersecret and key2=topsecret\n\t  kubectl create secret generic my-secret --from-literal=key1=supersecret --from-literal=key2=topsecret\x00\n\t  # Create a new service account named my-service-account\n\t  kubectl create serviceaccount my-service-account\x00\n\t# Create a new ExternalName service named my-ns \n\tkubectl create service externalname my-ns --external-name bar.com\x00\n\tCreate an ExternalName service with the specified name.\n\n\tExternalName service references to an external DNS address instead of\n\tonly pods, which will allow application authors to reference services\n\tthat exist off platform, on other clusters, or locally.\x00\n\tHelp provides help for any command in the application.\n\tSimply type kubectl help [path to command] for full details.\x00\n    # Create a new LoadBalancer service named my-lbs\n    kubectl create service loadbalancer my-lbs --tcp=5678:8080\x00\n    # Create a new clusterIP service named my-cs\n    kubectl create service clusterip my-cs --tcp=5678:8080\n\n    # Create a new clusterIP service named my-cs (in headless mode)\n    kubectl create service clusterip my-cs --clusterip=\"None\"\x00\n    # Create a new deployment named my-dep that runs the busybox image.\n    kubectl create deployment my-dep --image=busybox\x00\n    # Create a new nodeport service named my-ns\n    kubectl create service nodeport my-ns --tcp=5678:8080\x00\n    # Dump current cluster state to stdout\n    kubectl cluster-info dump\n\n    # Dump current cluster state to /path/to/cluster-state\n    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n\n    # Dump all namespaces to stdout\n    kubectl cluster-info dump --all-namespaces\n\n    # Dump a set of namespaces to /path/to/cluster-state\n    kubectl cluster-info dump --namespaces default,kube-system --output-directory=/path/to/cluster-state\x00\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend'.\n    # If the same annotation is set multiple times, only the last value will be applied\n    kubectl annotate pods foo description='my frontend'\n\n    # Update a pod identified by type and name in \"pod.json\"\n    kubectl annotate -f pod.json description='my frontend'\n\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend running nginx', overwriting any existing value.\n    kubectl annotate --overwrite pods foo description='my frontend running nginx'\n\n    # Update all pods in the namespace\n    kubectl annotate pods --all description='my frontend running nginx'\n\n    # Update pod 'foo' only if the resource is unchanged from version 1.\n    kubectl annotate pods foo description='my frontend running nginx' --resource-version=1\n\n    # Update pod 'foo' by removing an annotation named 'description' if it exists.\n    # Does not require the --overwrite flag.\n    kubectl annotate pods foo description-\x00\n    Create a LoadBalancer service with the specified name.\x00\n    Create a clusterIP service with the specified name.\x00\n    Create a deployment with the specified name.\x00\n    Create a nodeport service with the specified name.\x00\n    Dumps cluster info out suitable for debugging and diagnosing cluster problems.  By default, dumps everything to\n    stdout. You can optionally specify a directory with --output-directory.  If you specify a directory, kubernetes will\n    build a set of files in that directory.  By default only dumps things in the 'kube-system' namespace, but you can\n    switch to a different namespace with the --namespaces flag, or specify --all-namespaces to dump all namespaces.\n\n    The command also dumps the logs of all of the pods in the cluster, these logs are dumped into different directories\n    based on namespace and pod name.\x00\n  Display addresses of the master and services with label kubernetes.io/cluster-service=true\n  To further debug and diagnose cluster problems, use 'kubectl cluster-info dump'.\x00A comma-delimited set of quota scopes that must all match each object tracked by the quota.\x00A comma-delimited set of resource=quantity pairs that define a hard limit.\x00A label selector to use for this budget. Only equality-based selector requirements are supported.\x00A label selector to use for this service. Only equality-based selector requirements are supported. If empty (the default) infer the selector from the replication controller or replica set.)\x00A schedule in the Cron format the job should be run with.\x00Additional external IP address (not managed by Kubernetes) to accept for the service. If this IP is routed to a node, the service can be accessed by this IP in addition to its generated service IP.\x00An inline JSON override for the generated object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.\x00An inline JSON override for the generated service object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.  Only used if --expose is true.\x00Apply a configuration to a resource by filename or stdin\x00Approve a certificate signing request\x00Assign your own ClusterIP or set to 'None' for a 'headless' service (no loadbalancing).\x00Attach to a running container\x00Auto-scale a Deployment, ReplicaSet, or ReplicationController\x00ClusterIP to be assigned to the service. Leave empty to auto-allocate, or set to 'None' to create a headless service.\x00ClusterRole this ClusterRoleBinding should reference\x00ClusterRole this RoleBinding should reference\x00Container name which will have its image upgraded. Only relevant when --image is specified, ignored otherwise. Required when using --image on a multi-container pod\x00Convert config files between different API versions\x00Copy files and directories to and from containers.\x00Create a ClusterRoleBinding for a particular ClusterRole\x00Create a LoadBalancer service.\x00Create a NodePort service.\x00Create a RoleBinding for a particular Role or ClusterRole\x00Create a TLS secret\x00Create a clusterIP service.\x00Create a configmap from a local file, directory or literal value\x00Create a deployment with the specified name.\x00Create a namespace with the specified name\x00Create a pod disruption budget with the specified name.\x00Create a quota with the specified name.\x00Create a resource by filename or stdin\x00Create a secret for use with a Docker registry\x00Create a secret from a local file, directory or literal value\x00Create a secret using specified subcommand\x00Create a service account with the specified name\x00Create a service using specified subcommand.\x00Create an ExternalName service.\x00Delete resources by filenames, stdin, resources and names, or by resources and label selector\x00Delete the specified cluster from the kubeconfig\x00Delete the specified context from the kubeconfig\x00Deny a certificate signing request\x00Deprecated: Gracefully shut down a resource by name or filename\x00Describe one or many contexts\x00Display Resource (CPU/Memory) usage of nodes\x00Display Resource (CPU/Memory) usage of pods\x00Display Resource (CPU/Memory) usage.\x00Display cluster info\x00Display clusters defined in the kubeconfig\x00Display merged kubeconfig settings or a specified kubeconfig file\x00Display one or many resources\x00Displays the current-context\x00Documentation of resources\x00Drain node in preparation for maintenance\x00Dump lots of relevant info for debugging and diagnosis\x00Edit a resource on the server\x00Email for Docker registry\x00Execute a command in a container\x00Explicit policy for when to pull container images. Required when --image is same as existing image, ignored otherwise.\x00Forward one or more local ports to a pod\x00Help about any command\x00IP to assign to the Load Balancer. If empty, an ephemeral IP will be created and used (cloud-provider specific).\x00If non-empty, set the session affinity for the service to this; legal values: 'None', 'ClientIP'\x00If non-empty, the annotation update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00If non-empty, the labels update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00Image to use for upgrading the replication controller. Must be distinct from the existing image (either new image or new image tag).  Can not be used with --filename/-f\x00Manage a deployment rollout\x00Mark node as schedulable\x00Mark node as unschedulable\x00Mark the provided resource as paused\x00Modify certificate resources.\x00Modify kubeconfig files\x00Name or number for the port on the container that the service should direct traffic to. Optional.\x00Only return logs after a specific date (RFC3339). Defaults to all logs. Only one of since-time / since may be used.\x00Output shell completion code for the specified shell (bash or zsh)\x00Output the formatted object with the given group version (for ex: 'extensions/v1beta1').)\x00Password for Docker registry authentication\x00Path to PEM encoded public key certificate.\x00Path to private key associated with given certificate.\x00Perform a rolling update of the given ReplicationController\x00Precondition for resource version. Requires that the current resource version match this value in order to scale.\x00Print the client and server version information\x00Print the list of flags inherited by all commands\x00Print the logs for a container in a pod\x00Replace a resource by filename or stdin\x00Resume a paused resource\x00Role this RoleBinding should reference\x00Run a particular image on the cluster\x00Run a proxy to the Kubernetes API server\x00Server location for Docker registry\x00Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job\x00Set specific features on objects\x00Set the last-applied-configuration annotation on a live object to match the contents of a file.\x00Set the selector on a resource\x00Sets a cluster entry in kubeconfig\x00Sets a context entry in kubeconfig\x00Sets a user entry in kubeconfig\x00Sets an individual value in a kubeconfig file\x00Sets the current-context in a kubeconfig file\x00Show details of a specific resource or group of resources\x00Show the status of the rollout\x00Synonym for --target-port\x00Take a replication controller, service, deployment or pod and expose it as a new Kubernetes Service\x00The image for the container to run.\x00The image pull policy for the container. If left empty, this value will not be specified by the client and defaulted by the server\x00The key to use to differentiate between two different controllers, default 'deployment'.  Only relevant when --image is specified, ignored otherwise\x00The minimum number or percentage of available pods this budget requires.\x00The name for the newly created object.\x00The name for the newly created object. If not specified, the name of the input resource will be used.\x00The name of the API generator to use, see http://kubernetes.io/docs/user-guide/kubectl-conventions/#generators for a list.\x00The name of the API generator to use. Currently there is only 1 generator.\x00The name of the API generator to use. There are 2 generators: 'service/v1' and 'service/v2'. The only difference between them is that service port in v1 is named 'default', while it is left unnamed in v2. Default is 'service/v2'.\x00The name of the generator to use for creating a service.  Only used if --expose is true\x00The network protocol for the service to be created. Default is 'TCP'.\x00The port that the service should serve on. Copied from the resource being exposed, if unspecified\x00The port that this container exposes.  If --expose is true, this is also the port used by the service that is created.\x00The resource requirement limits for this container.  For example, 'cpu=200m,memory=512Mi'.  Note that server side components may assign limits depending on the server configuration, such as limit ranges.\x00The resource requirement requests for this container.  For example, 'cpu=100m,memory=256Mi'.  Note that server side components may assign requests depending on the server configuration, such as limit ranges.\x00The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  If set to 'Always' a deployment is created, if set to 'OnFailure' a job is created, if set to 'Never', a regular pod is created. For the latter two --replicas must be 1.  Default 'Always', for CronJobs `Never`.\x00The type of secret to create\x00Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is 'ClusterIP'.\x00Undo a previous rollout\x00Unsets an individual value in a kubeconfig file\x00Update field(s) of a resource using strategic merge patch\x00Update image of a pod template\x00Update resource requests/limits on objects with pod templates\x00Update the annotations on a resource\x00Update the labels on a resource\x00Update the taints on one or more nodes\x00Username for Docker registry authentication\x00View latest last-applied-configuration annotations of a resource/object\x00View rollout history\x00Where to output the files.  If empty or '-' uses stdout, otherwise creates a directory hierarchy in that directory\x00dummy restart flag)\x00external name of service\x00kubectl controls the Kubernetes cluster manager\x00")

func translationsKubectlDefaultLc_messagesK8sMoBytes() ([]byte, error) {
	return _translationsKubectlDefaultLc_messagesK8sMo, nil
}

func translationsKubectlDefaultLc_messagesK8sMo() (*asset, error) {
	bytes, err := translationsKubectlDefaultLc_messagesK8sMoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/default/LC_MESSAGES/k8s.mo", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlDefaultLc_messagesK8sPo = []byte(`# Test translations for unit tests.
# Copyright (C) 2016
# This file is distributed under the same license as the Kubernetes package.
# FIRST AUTHOR brendan.d.burns@gmail.com, 2016.
#
msgid ""
msgstr ""
"Project-Id-Version: gettext-go-examples-hello\n"
"Report-Msgid-Bugs-To: EMAIL\n"
"POT-Creation-Date: 2017-03-14 21:32-0700\n"
"PO-Revision-Date: 2017-05-24 18:01+0800\n"
"Last-Translator: Brendan Burns <brendan.d.burns@gmail.com>\n"
"Language-Team: \n"
"Language: en\n"
"MIME-Version: 1.0\n"
"Content-Type: text/plain; charset=UTF-8\n"
"Content-Transfer-Encoding: 8bit\n"
"X-Generator: Poedit 1.8.12\n"
"X-Poedit-SourceCharset: UTF-8\n"
"Plural-Forms: nplurals=2; plural=(n != 1);\n"

#: pkg/kubectl/cmd/create_clusterrolebinding.go:35
msgid ""
"\n"
"\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the "
"cluster-admin ClusterRole\n"
"\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-"
"admin --user=user1 --user=user2 --group=group1"
msgstr ""
"\n"
"\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the "
"cluster-admin ClusterRole\n"
"\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-"
"admin --user=user1 --user=user2 --group=group1"

#: pkg/kubectl/cmd/create_rolebinding.go:35
msgid ""
"\n"
"\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin "
"ClusterRole\n"
"\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --"
"user=user2 --group=group1"
msgstr ""
"\n"
"\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin "
"ClusterRole\n"
"\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --"
"user=user2 --group=group1"

#: pkg/kubectl/cmd/create_configmap.go:44
msgid ""
"\n"
"\t\t  # Create a new configmap named my-config based on folder bar\n"
"\t\t  kubectl create configmap my-config --from-file=path/to/bar\n"
"\n"
"\t\t  # Create a new configmap named my-config with specified keys instead "
"of file basenames on disk\n"
"\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1."
"txt --from-file=key2=/path/to/bar/file2.txt\n"
"\n"
"\t\t  # Create a new configmap named my-config with key1=config1 and "
"key2=config2\n"
"\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-"
"literal=key2=config2"
msgstr ""
"\n"
"\t\t  # Create a new configmap named my-config based on folder bar\n"
"\t\t  kubectl create configmap my-config --from-file=path/to/bar\n"
"\n"
"\t\t  # Create a new configmap named my-config with specified keys instead "
"of file basenames on disk\n"
"\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1."
"txt --from-file=key2=/path/to/bar/file2.txt\n"
"\n"
"\t\t  # Create a new configmap named my-config with key1=config1 and "
"key2=config2\n"
"\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-"
"literal=key2=config2"

#: pkg/kubectl/cmd/create_secret.go:135
msgid ""
"\n"
"\t\t  # If you don't already have a .dockercfg file, you can create a "
"dockercfg secret directly by using:\n"
"\t\t  kubectl create secret docker-registry my-secret --docker-"
"server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-"
"password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL"
msgstr ""
"\n"
"\t\t  # If you don't already have a .dockercfg file, you can create a "
"dockercfg secret directly by using:\n"
"\t\t  kubectl create secret docker-registry my-secret --docker-"
"server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-"
"password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL"

#: pkg/kubectl/cmd/top_node.go:65
msgid ""
"\n"
"\t\t  # Show metrics for all nodes\n"
"\t\t  kubectl top node\n"
"\n"
"\t\t  # Show metrics for a given node\n"
"\t\t  kubectl top node NODE_NAME"
msgstr ""
"\n"
"\t\t  # Show metrics for all nodes\n"
"\t\t  kubectl top node\n"
"\n"
"\t\t  # Show metrics for a given node\n"
"\t\t  kubectl top node NODE_NAME"

#: pkg/kubectl/cmd/apply.go:84
msgid ""
"\n"
"\t\t# Apply the configuration in pod.json to a pod.\n"
"\t\tkubectl apply -f ./pod.json\n"
"\n"
"\t\t# Apply the JSON passed into stdin to a pod.\n"
"\t\tcat pod.json | kubectl apply -f -\n"
"\n"
"\t\t# Note: --prune is still in Alpha\n"
"\t\t# Apply the configuration in manifest.yaml that matches label app=nginx "
"and delete all the other resources that are not in the file and match label "
"app=nginx.\n"
"\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n"
"\n"
"\t\t# Apply the configuration in manifest.yaml and delete all the other "
"configmaps that are not in the file.\n"
"\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/"
"ConfigMap"
msgstr ""
"\n"
"\t\t# Apply the configuration in pod.json to a pod.\n"
"\t\tkubectl apply -f ./pod.json\n"
"\n"
"\t\t# Apply the JSON passed into stdin to a pod.\n"
"\t\tcat pod.json | kubectl apply -f -\n"
"\n"
"\t\t# Note: --prune is still in Alpha\n"
"\t\t# Apply the configuration in manifest.yaml that matches label app=nginx "
"and delete all the other resources that are not in the file and match label "
"app=nginx.\n"
"\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n"
"\n"
"\t\t# Apply the configuration in manifest.yaml and delete all the other "
"configmaps that are not in the file.\n"
"\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/"
"ConfigMap"

#: pkg/kubectl/cmd/autoscale.go:40
#, c-format
msgid ""
"\n"
"\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and "
"10, no target CPU utilization specified so a default autoscaling policy will "
"be used:\n"
"\t\tkubectl autoscale deployment foo --min=2 --max=10\n"
"\n"
"\t\t# Auto scale a replication controller \"foo\", with the number of pods "
"between 1 and 5, target CPU utilization at 80%:\n"
"\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80"
msgstr ""
"\n"
"\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and "
"10, no target CPU utilization specified so a default autoscaling policy will "
"be used:\n"
"\t\tkubectl autoscale deployment foo --min=2 --max=10\n"
"\n"
"\t\t# Auto scale a replication controller \"foo\", with the number of pods "
"between 1 and 5, target CPU utilization at 80%:\n"
"\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80"

#: pkg/kubectl/cmd/convert.go:49
msgid ""
"\n"
"\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n"
"\t\tkubectl convert -f pod.yaml\n"
"\n"
"\t\t# Convert the live state of the resource specified by 'pod.yaml' to the "
"latest version\n"
"\t\t# and print to stdout in json format.\n"
"\t\tkubectl convert -f pod.yaml --local -o json\n"
"\n"
"\t\t# Convert all files under current directory to latest version and create "
"them all.\n"
"\t\tkubectl convert -f . | kubectl create -f -"
msgstr ""
"\n"
"\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n"
"\t\tkubectl convert -f pod.yaml\n"
"\n"
"\t\t# Convert the live state of the resource specified by 'pod.yaml' to the "
"latest version\n"
"\t\t# and print to stdout in json format.\n"
"\t\tkubectl convert -f pod.yaml --local -o json\n"
"\n"
"\t\t# Convert all files under current directory to latest version and create "
"them all.\n"
"\t\tkubectl convert -f . | kubectl create -f -"

#: pkg/kubectl/cmd/create_clusterrole.go:34
msgid ""
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform "
"\"get\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods\n"
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods --resource-name=readablepod"
msgstr ""
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform "
"\"get\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods\n"
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods --resource-name=readablepod"

#: pkg/kubectl/cmd/create_role.go:41
msgid ""
"\n"
"\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get"
"\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --"
"resource=pods\n"
"\n"
"\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --"
"resource=pods --resource-name=readablepod"
msgstr ""
"\n"
"\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get"
"\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --"
"resource=pods\n"
"\n"
"\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --"
"resource=pods --resource-name=readablepod"

#: pkg/kubectl/cmd/create_quota.go:35
msgid ""
"\n"
"\t\t# Create a new resourcequota named my-quota\n"
"\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,"
"replicationcontrollers=2,resourcequotas=1,secrets=5,"
"persistentvolumeclaims=10\n"
"\n"
"\t\t# Create a new resourcequota named best-effort\n"
"\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort"
msgstr ""
"\n"
"\t\t# Create a new resourcequota named my-quota\n"
"\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,"
"replicationcontrollers=2,resourcequotas=1,secrets=5,"
"persistentvolumeclaims=10\n"
"\n"
"\t\t# Create a new resourcequota named best-effort\n"
"\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort"

#: pkg/kubectl/cmd/create_pdb.go:35
#, c-format
msgid ""
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=rails label\n"
"\t\t# and require at least one of them being available at any point in "
"time.\n"
"\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-"
"available=1\n"
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=nginx label\n"
"\t\t# and require at least half of the pods selected to be available at any "
"point in time.\n"
"\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%"
msgstr ""
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=rails label\n"
"\t\t# and require at least one of them being available at any point in "
"time.\n"
"\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-"
"available=1\n"
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=nginx label\n"
"\t\t# and require at least half of the pods selected to be available at any "
"point in time.\n"
"\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%"

#: pkg/kubectl/cmd/create.go:47
msgid ""
"\n"
"\t\t# Create a pod using the data in pod.json.\n"
"\t\tkubectl create -f ./pod.json\n"
"\n"
"\t\t# Create a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl create -f -\n"
"\n"
"\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format "
"then create the resource using the edited data.\n"
"\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json"
msgstr ""
"\n"
"\t\t# Create a pod using the data in pod.json.\n"
"\t\tkubectl create -f ./pod.json\n"
"\n"
"\t\t# Create a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl create -f -\n"
"\n"
"\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format "
"then create the resource using the edited data.\n"
"\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json"

#: pkg/kubectl/cmd/expose.go:53
msgid ""
"\n"
"\t\t# Create a service for a replicated nginx, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose rc nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a replication controller identified by type and "
"name specified in \"nginx-controller.yaml\", which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a pod valid-pod, which serves on port 444 with "
"the name \"frontend\"\n"
"\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n"
"\n"
"\t\t# Create a second service based on the above service, exposing the "
"container port 8443 as port 443 with the name \"nginx-https\"\n"
"\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-"
"https\n"
"\n"
"\t\t# Create a service for a replicated streaming application on port 4100 "
"balancing UDP traffic and named 'video-stream'.\n"
"\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-"
"stream\n"
"\n"
"\t\t# Create a service for a replicated nginx using replica set, which "
"serves on port 80 and connects to the containers on port 8000.\n"
"\t\tkubectl expose rs nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for an nginx deployment, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose deployment nginx --port=80 --target-port=8000"
msgstr ""
"\n"
"\t\t# Create a service for a replicated nginx, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose rc nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a replication controller identified by type and "
"name specified in \"nginx-controller.yaml\", which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a pod valid-pod, which serves on port 444 with "
"the name \"frontend\"\n"
"\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n"
"\n"
"\t\t# Create a second service based on the above service, exposing the "
"container port 8443 as port 443 with the name \"nginx-https\"\n"
"\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-"
"https\n"
"\n"
"\t\t# Create a service for a replicated streaming application on port 4100 "
"balancing UDP traffic and named 'video-stream'.\n"
"\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-"
"stream\n"
"\n"
"\t\t# Create a service for a replicated nginx using replica set, which "
"serves on port 80 and connects to the containers on port 8000.\n"
"\t\tkubectl expose rs nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for an nginx deployment, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose deployment nginx --port=80 --target-port=8000"

#: pkg/kubectl/cmd/delete.go:68
msgid ""
"\n"
"\t\t# Delete a pod using the type and name specified in pod.json.\n"
"\t\tkubectl delete -f ./pod.json\n"
"\n"
"\t\t# Delete a pod based on the type and name in the JSON passed into "
"stdin.\n"
"\t\tcat pod.json | kubectl delete -f -\n"
"\n"
"\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n"
"\t\tkubectl delete pod,service baz foo\n"
"\n"
"\t\t# Delete pods and services with label name=myLabel.\n"
"\t\tkubectl delete pods,services -l name=myLabel\n"
"\n"
"\t\t# Delete a pod with minimal delay\n"
"\t\tkubectl delete pod foo --now\n"
"\n"
"\t\t# Force delete a pod on a dead node\n"
"\t\tkubectl delete pod foo --grace-period=0 --force\n"
"\n"
"\t\t# Delete all pods\n"
"\t\tkubectl delete pods --all"
msgstr ""
"\n"
"\t\t# Delete a pod using the type and name specified in pod.json.\n"
"\t\tkubectl delete -f ./pod.json\n"
"\n"
"\t\t# Delete a pod based on the type and name in the JSON passed into "
"stdin.\n"
"\t\tcat pod.json | kubectl delete -f -\n"
"\n"
"\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n"
"\t\tkubectl delete pod,service baz foo\n"
"\n"
"\t\t# Delete pods and services with label name=myLabel.\n"
"\t\tkubectl delete pods,services -l name=myLabel\n"
"\n"
"\t\t# Delete a pod with minimal delay\n"
"\t\tkubectl delete pod foo --now\n"
"\n"
"\t\t# Force delete a pod on a dead node\n"
"\t\tkubectl delete pod foo --grace-period=0 --force\n"
"\n"
"\t\t# Delete all pods\n"
"\t\tkubectl delete pods --all"

#: pkg/kubectl/cmd/describe.go:54
msgid ""
"\n"
"\t\t# Describe a node\n"
"\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n"
"\n"
"\t\t# Describe a pod\n"
"\t\tkubectl describe pods/nginx\n"
"\n"
"\t\t# Describe a pod identified by type and name in \"pod.json\"\n"
"\t\tkubectl describe -f pod.json\n"
"\n"
"\t\t# Describe all pods\n"
"\t\tkubectl describe pods\n"
"\n"
"\t\t# Describe pods by label name=myLabel\n"
"\t\tkubectl describe po -l name=myLabel\n"
"\n"
"\t\t# Describe all pods managed by the 'frontend' replication controller (rc-"
"created pods\n"
"\t\t# get the name of the rc as a prefix in the pod the name).\n"
"\t\tkubectl describe pods frontend"
msgstr ""
"\n"
"\t\t# Describe a node\n"
"\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n"
"\n"
"\t\t# Describe a pod\n"
"\t\tkubectl describe pods/nginx\n"
"\n"
"\t\t# Describe a pod identified by type and name in \"pod.json\"\n"
"\t\tkubectl describe -f pod.json\n"
"\n"
"\t\t# Describe all pods\n"
"\t\tkubectl describe pods\n"
"\n"
"\t\t# Describe pods by label name=myLabel\n"
"\t\tkubectl describe po -l name=myLabel\n"
"\n"
"\t\t# Describe all pods managed by the 'frontend' replication controller (rc-"
"created pods\n"
"\t\t# get the name of the rc as a prefix in the pod the name).\n"
"\t\tkubectl describe pods frontend"

#: pkg/kubectl/cmd/drain.go:165
msgid ""
"\n"
"\t\t# Drain node \"foo\", even if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n"
"\t\t$ kubectl drain foo --force\n"
"\n"
"\t\t# As above, but abort if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a "
"grace period of 15 minutes.\n"
"\t\t$ kubectl drain foo --grace-period=900"
msgstr ""
"\n"
"\t\t# Drain node \"foo\", even if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n"
"\t\t$ kubectl drain foo --force\n"
"\n"
"\t\t# As above, but abort if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a "
"grace period of 15 minutes.\n"
"\t\t$ kubectl drain foo --grace-period=900"

#: pkg/kubectl/cmd/edit.go:80
msgid ""
"\n"
"\t\t# Edit the service named 'docker-registry':\n"
"\t\tkubectl edit svc/docker-registry\n"
"\n"
"\t\t# Use an alternative editor\n"
"\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n"
"\n"
"\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n"
"\t\tkubectl edit job.v1.batch/myjob -o json\n"
"\n"
"\t\t# Edit the deployment 'mydeployment' in YAML and save the modified "
"config in its annotation:\n"
"\t\tkubectl edit deployment/mydeployment -o yaml --save-config"
msgstr ""
"\n"
"\t\t# Edit the service named 'docker-registry':\n"
"\t\tkubectl edit svc/docker-registry\n"
"\n"
"\t\t# Use an alternative editor\n"
"\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n"
"\n"
"\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n"
"\t\tkubectl edit job.v1.batch/myjob -o json\n"
"\n"
"\t\t# Edit the deployment 'mydeployment' in YAML and save the modified "
"config in its annotation:\n"
"\t\tkubectl edit deployment/mydeployment -o yaml --save-config"

#: pkg/kubectl/cmd/exec.go:41
msgid ""
"\n"
"\t\t# Get output from running 'date' from pod 123456-7890, using the first "
"container by default\n"
"\t\tkubectl exec 123456-7890 date\n"
"\n"
"\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n"
"\t\tkubectl exec 123456-7890 -c ruby-container date\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il"
msgstr ""
"\n"
"\t\t# Get output from running 'date' from pod 123456-7890, using the first "
"container by default\n"
"\t\tkubectl exec 123456-7890 date\n"
"\n"
"\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n"
"\t\tkubectl exec 123456-7890 -c ruby-container date\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il"

#: pkg/kubectl/cmd/attach.go:42
msgid ""
"\n"
"\t\t# Get output from running pod 123456-7890, using the first container by "
"default\n"
"\t\tkubectl attach 123456-7890\n"
"\n"
"\t\t# Get output from ruby-container from pod 123456-7890\n"
"\t\tkubectl attach 123456-7890 -c ruby-container\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n"
"\n"
"\t\t# Get output from the first pod of a ReplicaSet named nginx\n"
"\t\tkubectl attach rs/nginx\n"
"\t\t"
msgstr ""
"\n"
"\t\t# Get output from running pod 123456-7890, using the first container by "
"default\n"
"\t\tkubectl attach 123456-7890\n"
"\n"
"\t\t# Get output from ruby-container from pod 123456-7890\n"
"\t\tkubectl attach 123456-7890 -c ruby-container\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n"
"\n"
"\t\t# Get output from the first pod of a ReplicaSet named nginx\n"
"\t\tkubectl attach rs/nginx\n"
"\t\t"

#: pkg/kubectl/cmd/explain.go:39
msgid ""
"\n"
"\t\t# Get the documentation of the resource and its fields\n"
"\t\tkubectl explain pods\n"
"\n"
"\t\t# Get the documentation of a specific field of a resource\n"
"\t\tkubectl explain pods.spec.containers"
msgstr ""
"\n"
"\t\t# Get the documentation of the resource and its fields\n"
"\t\tkubectl explain pods\n"
"\n"
"\t\t# Get the documentation of a specific field of a resource\n"
"\t\tkubectl explain pods.spec.containers"

#: pkg/kubectl/cmd/completion.go:65
msgid ""
"\n"
"\t\t# Install bash completion on a Mac using homebrew\n"
"\t\tbrew install bash-completion\n"
"\t\tprintf \"\n"
"# Bash completion support\n"
"source $(brew --prefix)/etc/bash_completion\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for bash into the current shell\n"
"\t\tsource <(kubectl completion bash)\n"
"\n"
"\t\t# Write bash completion code to a file and source if from .bash_profile\n"
"\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n"
"\t\tprintf \"\n"
"# Kubectl shell completion\n"
"source '$HOME/.kube/completion.bash.inc'\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for zsh[1] into the current shell\n"
"\t\tsource <(kubectl completion zsh)"
msgstr ""
"\n"
"\t\t# Install bash completion on a Mac using homebrew\n"
"\t\tbrew install bash-completion\n"
"\t\tprintf \"\n"
"# Bash completion support\n"
"source $(brew --prefix)/etc/bash_completion\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for bash into the current shell\n"
"\t\tsource <(kubectl completion bash)\n"
"\n"
"\t\t# Write bash completion code to a file and source if from .bash_profile\n"
"\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n"
"\t\tprintf \"\n"
"# Kubectl shell completion\n"
"source '$HOME/.kube/completion.bash.inc'\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for zsh[1] into the current shell\n"
"\t\tsource <(kubectl completion zsh)"

#: pkg/kubectl/cmd/get.go:64
msgid ""
"\n"
"\t\t# List all pods in ps output format.\n"
"\t\tkubectl get pods\n"
"\n"
"\t\t# List all pods in ps output format with more information (such as node "
"name).\n"
"\t\tkubectl get pods -o wide\n"
"\n"
"\t\t# List a single replication controller with specified NAME in ps output "
"format.\n"
"\t\tkubectl get replicationcontroller web\n"
"\n"
"\t\t# List a single pod in JSON output format.\n"
"\t\tkubectl get -o json pod web-pod-13je7\n"
"\n"
"\t\t# List a pod identified by type and name specified in \"pod.yaml\" in "
"JSON output format.\n"
"\t\tkubectl get -f pod.yaml -o json\n"
"\n"
"\t\t# Return only the phase value of the specified pod.\n"
"\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n"
"\n"
"\t\t# List all replication controllers and services together in ps output "
"format.\n"
"\t\tkubectl get rc,services\n"
"\n"
"\t\t# List one or more resources by their type and names.\n"
"\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n"
"\n"
"\t\t# List all resources with different types.\n"
"\t\tkubectl get all"
msgstr ""
"\n"
"\t\t# List all pods in ps output format.\n"
"\t\tkubectl get pods\n"
"\n"
"\t\t# List all pods in ps output format with more information (such as node "
"name).\n"
"\t\tkubectl get pods -o wide\n"
"\n"
"\t\t# List a single replication controller with specified NAME in ps output "
"format.\n"
"\t\tkubectl get replicationcontroller web\n"
"\n"
"\t\t# List a single pod in JSON output format.\n"
"\t\tkubectl get -o json pod web-pod-13je7\n"
"\n"
"\t\t# List a pod identified by type and name specified in \"pod.yaml\" in "
"JSON output format.\n"
"\t\tkubectl get -f pod.yaml -o json\n"
"\n"
"\t\t# Return only the phase value of the specified pod.\n"
"\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n"
"\n"
"\t\t# List all replication controllers and services together in ps output "
"format.\n"
"\t\tkubectl get rc,services\n"
"\n"
"\t\t# List one or more resources by their type and names.\n"
"\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n"
"\n"
"\t\t# List all resources with different types.\n"
"\t\tkubectl get all"

#: pkg/kubectl/cmd/portforward.go:53
msgid ""
"\n"
"\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports 5000 and 6000 in the pod"
"\t\tkubectl port-forward pod/mypod 5000 6000"
"\n"
"\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports 5000 and 6000 in a pod selected by the deployment"
"\t\tkubectl port-forward deployment/mydeployment 5000 6000"
"\n"
"\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports 5000 and 6000 in a pod selected by the service"
"\t\tkubectl port-forward service/myservice 5000 6000"
"\n"
"\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod"
"\t\tkubectl port-forward pod/mypod 8888:5000"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod"
"\t\tkubectl port-forward pod/mypod :5000"
msgstr ""
"\n"
"\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports 5000 and 6000 in the pod"
"\t\tkubectl port-forward pod/mypod 5000 6000"
"\n"
"\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports 5000 and 6000 in a pod selected by the deployment"
"\t\tkubectl port-forward deployment/mydeployment 5000 6000"
"\n"
"\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports 5000 and 6000 in a pod selected by the service"
"\t\tkubectl port-forward service/myservice 5000 6000"
"\n"
"\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod"
"\t\tkubectl port-forward pod/mypod 8888:5000"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod"
"\t\tkubectl port-forward pod/mypod :5000"

#: pkg/kubectl/cmd/drain.go:118
msgid ""
"\n"
"\t\t# Mark node \"foo\" as schedulable.\n"
"\t\t$ kubectl uncordon foo"
msgstr ""
"\n"
"\t\t# Mark node \"foo\" as schedulable.\n"
"\t\t$ kubectl uncordon foo"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L102
#: pkg/kubectl/cmd/drain.go:93
msgid ""
"\n"
"\t\t# Mark node \"foo\" as unschedulable.\n"
"\t\tkubectl cordon foo"
msgstr ""
"\n"
"\t\t# Mark node \"foo\" as unschedulable.\n"
"\t\tkubectl cordon foo"

#: pkg/kubectl/cmd/patch.go:66
msgid ""
"\n"
"\t\t# Partially update a node using strategic merge patch\n"
"\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Partially update a node identified by the type and name specified in "
"\"node.json\" using strategic merge patch\n"
"\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Update a container's image; spec.containers[*].name is required "
"because it's a merge key\n"
"\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":"
"\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n"
"\n"
"\t\t# Update a container's image using a json patch with positional arrays\n"
"\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", "
"\"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'"
msgstr ""
"\n"
"\t\t# Partially update a node using strategic merge patch\n"
"\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Partially update a node identified by the type and name specified in "
"\"node.json\" using strategic merge patch\n"
"\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Update a container's image; spec.containers[*].name is required "
"because it's a merge key\n"
"\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":"
"\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n"
"\n"
"\t\t# Update a container's image using a json patch with positional arrays\n"
"\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", "
"\"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/options.go#L37
#: pkg/kubectl/cmd/options.go:29
msgid ""
"\n"
"\t\t# Print flags inherited by all commands\n"
"\t\tkubectl options"
msgstr ""
"\n"
"\t\t# Print flags inherited by all commands\n"
"\t\tkubectl options"

#: pkg/kubectl/cmd/clusterinfo.go:41
msgid ""
"\n"
"\t\t# Print the address of the master and cluster services\n"
"\t\tkubectl cluster-info"
msgstr ""
"\n"
"\t\t# Print the address of the master and cluster services\n"
"\t\tkubectl cluster-info"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/version.go#L39
#: pkg/kubectl/cmd/version.go:32
msgid ""
"\n"
"\t\t# Print the client and server versions for the current context\n"
"\t\tkubectl version"
msgstr ""
"\n"
"\t\t# Print the client and server versions for the current context\n"
"\t\tkubectl version"

#: pkg/kubectl/cmd/apiversions.go:34
msgid ""
"\n"
"\t\t# Print the supported API versions\n"
"\t\tkubectl api-versions"
msgstr ""
"\n"
"\t\t# Print the supported API versions\n"
"\t\tkubectl api-versions"

#: pkg/kubectl/cmd/replace.go:50
msgid ""
"\n"
"\t\t# Replace a pod using the data in pod.json.\n"
"\t\tkubectl replace -f ./pod.json\n"
"\n"
"\t\t# Replace a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl replace -f -\n"
"\n"
"\t\t# Update a single-container pod's image version (tag) to v4\n"
"\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/:v4/' | "
"kubectl replace -f -\n"
"\n"
"\t\t# Force replace, delete and then re-create the resource\n"
"\t\tkubectl replace --force -f ./pod.json"
msgstr ""
"\n"
"\t\t# Replace a pod using the data in pod.json.\n"
"\t\tkubectl replace -f ./pod.json\n"
"\n"
"\t\t# Replace a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl replace -f -\n"
"\n"
"\t\t# Update a single-container pod's image version (tag) to v4\n"
"\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/:v4/' | "
"kubectl replace -f -\n"
"\n"
"\t\t# Force replace, delete and then re-create the resource\n"
"\t\tkubectl replace --force -f ./pod.json"

#: pkg/kubectl/cmd/logs.go:40
msgid ""
"\n"
"\t\t# Return snapshot logs from pod nginx with only one container\n"
"\t\tkubectl logs nginx\n"
"\n"
"\t\t# Return snapshot logs for the pods defined by label app=nginx\n"
"\t\tkubectl logs -lapp=nginx\n"
"\n"
"\t\t# Return snapshot of previous terminated ruby container logs from pod "
"web-1\n"
"\t\tkubectl logs -p -c ruby web-1\n"
"\n"
"\t\t# Begin streaming the logs of the ruby container in pod web-1\n"
"\t\tkubectl logs -f -c ruby web-1\n"
"\n"
"\t\t# Display only the most recent 20 lines of output in pod nginx\n"
"\t\tkubectl logs --tail=20 nginx\n"
"\n"
"\t\t# Show all logs from pod nginx written in the last hour\n"
"\t\tkubectl logs --since=1h nginx\n"
"\n"
"\t\t# Return snapshot logs from first container of a job named hello\n"
"\t\tkubectl logs job/hello\n"
"\n"
"\t\t# Return snapshot logs from container nginx-1 of a deployment named "
"nginx\n"
"\t\tkubectl logs deployment/nginx -c nginx-1"
msgstr ""
"\n"
"\t\t# Return snapshot logs from pod nginx with only one container\n"
"\t\tkubectl logs nginx\n"
"\n"
"\t\t# Return snapshot logs for the pods defined by label app=nginx\n"
"\t\tkubectl logs -lapp=nginx\n"
"\n"
"\t\t# Return snapshot of previous terminated ruby container logs from pod "
"web-1\n"
"\t\tkubectl logs -p -c ruby web-1\n"
"\n"
"\t\t# Begin streaming the logs of the ruby container in pod web-1\n"
"\t\tkubectl logs -f -c ruby web-1\n"
"\n"
"\t\t# Display only the most recent 20 lines of output in pod nginx\n"
"\t\tkubectl logs --tail=20 nginx\n"
"\n"
"\t\t# Show all logs from pod nginx written in the last hour\n"
"\t\tkubectl logs --since=1h nginx\n"
"\n"
"\t\t# Return snapshot logs from first container of a job named hello\n"
"\t\tkubectl logs job/hello\n"
"\n"
"\t\t# Return snapshot logs from container nginx-1 of a deployment named "
"nginx\n"
"\t\tkubectl logs deployment/nginx -c nginx-1"

#: pkg/kubectl/cmd/proxy.go:53
msgid ""
"\n"
"\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static "
"content from ./local/www/\n"
"\t\tkubectl proxy --port=8011 --www=./local/www/\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n"
"\t\t# The chosen port for the server will be output to stdout.\n"
"\t\tkubectl proxy --port=0\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-"
"api\n"
"\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/"
"pods/\n"
"\t\tkubectl proxy --api-prefix=/k8s-api"
msgstr ""
"\n"
"\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static "
"content from ./local/www/\n"
"\t\tkubectl proxy --port=8011 --www=./local/www/\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n"
"\t\t# The chosen port for the server will be output to stdout.\n"
"\t\tkubectl proxy --port=0\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-"
"api\n"
"\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/"
"pods/\n"
"\t\tkubectl proxy --api-prefix=/k8s-api"

#: pkg/kubectl/cmd/scale.go:43
msgid ""
"\n"
"\t\t# Scale a replicaset named 'foo' to 3.\n"
"\t\tkubectl scale --replicas=3 rs/foo\n"
"\n"
"\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" "
"to 3.\n"
"\t\tkubectl scale --replicas=3 -f foo.yaml\n"
"\n"
"\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n"
"\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n"
"\n"
"\t\t# Scale multiple replication controllers.\n"
"\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n"
"\n"
"\t\t# Scale job named 'cron' to 3.\n"
"\t\tkubectl scale --replicas=3 job/cron"
msgstr ""
"\n"
"\t\t# Scale a replicaset named 'foo' to 3.\n"
"\t\tkubectl scale --replicas=3 rs/foo\n"
"\n"
"\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" "
"to 3.\n"
"\t\tkubectl scale --replicas=3 -f foo.yaml\n"
"\n"
"\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n"
"\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n"
"\n"
"\t\t# Scale multiple replication controllers.\n"
"\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n"
"\n"
"\t\t# Scale job named 'cron' to 3.\n"
"\t\tkubectl scale --replicas=3 job/cron"

#: pkg/kubectl/cmd/apply_set_last_applied.go:67
msgid ""
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml\n"
"\n"
"\t\t# Execute set-last-applied against each configuration file in a "
"directory.\n"
"\t\tkubectl apply set-last-applied -f path/\n"
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file, will create the annotation if it does not already exist.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n"
"\t\t"
msgstr ""
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml\n"
"\n"
"\t\t# Execute set-last-applied against each configuration file in a "
"directory.\n"
"\t\tkubectl apply set-last-applied -f path/\n"
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file, will create the annotation if it does not already exist.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n"
"\t\t"

#: pkg/kubectl/cmd/top_pod.go:61
msgid ""
"\n"
"\t\t# Show metrics for all pods in the default namespace\n"
"\t\tkubectl top pod\n"
"\n"
"\t\t# Show metrics for all pods in the given namespace\n"
"\t\tkubectl top pod --namespace=NAMESPACE\n"
"\n"
"\t\t# Show metrics for a given pod and its containers\n"
"\t\tkubectl top pod POD_NAME --containers\n"
"\n"
"\t\t# Show metrics for the pods defined by label name=myLabel\n"
"\t\tkubectl top pod -l name=myLabel"
msgstr ""
"\n"
"\t\t# Show metrics for all pods in the default namespace\n"
"\t\tkubectl top pod\n"
"\n"
"\t\t# Show metrics for all pods in the given namespace\n"
"\t\tkubectl top pod --namespace=NAMESPACE\n"
"\n"
"\t\t# Show metrics for a given pod and its containers\n"
"\t\tkubectl top pod POD_NAME --containers\n"
"\n"
"\t\t# Show metrics for the pods defined by label name=myLabel\n"
"\t\tkubectl top pod -l name=myLabel"

#: pkg/kubectl/cmd/stop.go:40
msgid ""
"\n"
"\t\t# Shut down foo.\n"
"\t\tkubectl stop replicationcontroller foo\n"
"\n"
"\t\t# Stop pods and services with label name=myLabel.\n"
"\t\tkubectl stop pods,services -l name=myLabel\n"
"\n"
"\t\t# Shut down the service defined in service.json\n"
"\t\tkubectl stop -f service.json\n"
"\n"
"\t\t# Shut down all resources in the path/to/resources directory\n"
"\t\tkubectl stop -f path/to/resources"
msgstr ""
"\n"
"\t\t# Shut down foo.\n"
"\t\tkubectl stop replicationcontroller foo\n"
"\n"
"\t\t# Stop pods and services with label name=myLabel.\n"
"\t\tkubectl stop pods,services -l name=myLabel\n"
"\n"
"\t\t# Shut down the service defined in service.json\n"
"\t\tkubectl stop -f service.json\n"
"\n"
"\t\t# Shut down all resources in the path/to/resources directory\n"
"\t\tkubectl stop -f path/to/resources"

#: pkg/kubectl/cmd/run.go:57
msgid ""
"\n"
"\t\t# Start a single instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx\n"
"\n"
"\t\t# Start a single instance of hazelcast and let the container expose port "
"5701 .\n"
"\t\tkubectl run hazelcast --image=hazelcast --port=5701\n"
"\n"
"\t\t# Start a single instance of hazelcast and set environment variables "
"\"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n"
"\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --"
"env=\"POD_NAMESPACE=default\"\n"
"\n"
"\t\t# Start a replicated instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx --replicas=5\n"
"\n"
"\t\t# Dry run. Print the corresponding API objects without creating them.\n"
"\t\tkubectl run nginx --image=nginx --dry-run\n"
"\n"
"\t\t# Start a single instance of nginx, but overload the spec of the "
"deployment with a partial set of values parsed from JSON.\n"
"\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", "
"\"spec\": { ... } }'\n"
"\n"
"\t\t# Start a pod of busybox and keep it in the foreground, don't restart it "
"if it exits.\n"
"\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n"
"\n"
"\t\t# Start the nginx container using the default command, but use custom "
"arguments (arg1 .. argN) for that command.\n"
"\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n"
"\n"
"\t\t# Start the nginx container using a different command and custom "
"arguments.\n"
"\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n"
"\n"
"\t\t# Start the perl container to compute π to 2000 places and print it "
"out.\n"
"\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -"
"wle 'print bpi(2000)'\n"
"\n"
"\t\t# Start the cron job to compute π to 2000 places and print it out every "
"5 minutes.\n"
"\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --"
"restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'"
msgstr ""
"\n"
"\t\t# Start a single instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx\n"
"\n"
"\t\t# Start a single instance of hazelcast and let the container expose port "
"5701 .\n"
"\t\tkubectl run hazelcast --image=hazelcast --port=5701\n"
"\n"
"\t\t# Start a single instance of hazelcast and set environment variables "
"\"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n"
"\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --"
"env=\"POD_NAMESPACE=default\"\n"
"\n"
"\t\t# Start a replicated instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx --replicas=5\n"
"\n"
"\t\t# Dry run. Print the corresponding API objects without creating them.\n"
"\t\tkubectl run nginx --image=nginx --dry-run\n"
"\n"
"\t\t# Start a single instance of nginx, but overload the spec of the "
"deployment with a partial set of values parsed from JSON.\n"
"\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", "
"\"spec\": { ... } }'\n"
"\n"
"\t\t# Start a pod of busybox and keep it in the foreground, don't restart it "
"if it exits.\n"
"\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n"
"\n"
"\t\t# Start the nginx container using the default command, but use custom "
"arguments (arg1 .. argN) for that command.\n"
"\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n"
"\n"
"\t\t# Start the nginx container using a different command and custom "
"arguments.\n"
"\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n"
"\n"
"\t\t# Start the perl container to compute π to 2000 places and print it "
"out.\n"
"\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -"
"wle 'print bpi(2000)'\n"
"\n"
"\t\t# Start the cron job to compute π to 2000 places and print it out every "
"5 minutes.\n"
"\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --"
"restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'"

#: pkg/kubectl/cmd/taint.go:67
msgid ""
"\n"
"\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-"
"user' and effect 'NoSchedule'.\n"
"\t\t# If a taint with that key and effect already exists, its value is "
"replaced as specified.\n"
"\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n"
"\n"
"\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect "
"'NoSchedule' if one exists.\n"
"\t\tkubectl taint nodes foo dedicated:NoSchedule-\n"
"\n"
"\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n"
"\t\tkubectl taint nodes foo dedicated-"
msgstr ""
"\n"
"\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-"
"user' and effect 'NoSchedule'.\n"
"\t\t# If a taint with that key and effect already exists, its value is "
"replaced as specified.\n"
"\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n"
"\n"
"\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect "
"'NoSchedule' if one exists.\n"
"\t\tkubectl taint nodes foo dedicated:NoSchedule-\n"
"\n"
"\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n"
"\t\tkubectl taint nodes foo dedicated-"

#: pkg/kubectl/cmd/label.go:77
msgid ""
"\n"
"\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n"
"\t\tkubectl label pods foo unhealthy=true\n"
"\n"
"\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', "
"overwriting any existing value.\n"
"\t\tkubectl label --overwrite pods foo status=unhealthy\n"
"\n"
"\t\t# Update all pods in the namespace\n"
"\t\tkubectl label pods --all status=unhealthy\n"
"\n"
"\t\t# Update a pod identified by the type and name in \"pod.json\"\n"
"\t\tkubectl label -f pod.json status=unhealthy\n"
"\n"
"\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n"
"\t\tkubectl label pods foo status=unhealthy --resource-version=1\n"
"\n"
"\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n"
"\t\t# Does not require the --overwrite flag.\n"
"\t\tkubectl label pods foo bar-"
msgstr ""
"\n"
"\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n"
"\t\tkubectl label pods foo unhealthy=true\n"
"\n"
"\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', "
"overwriting any existing value.\n"
"\t\tkubectl label --overwrite pods foo status=unhealthy\n"
"\n"
"\t\t# Update all pods in the namespace\n"
"\t\tkubectl label pods --all status=unhealthy\n"
"\n"
"\t\t# Update a pod identified by the type and name in \"pod.json\"\n"
"\t\tkubectl label -f pod.json status=unhealthy\n"
"\n"
"\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n"
"\t\tkubectl label pods foo status=unhealthy --resource-version=1\n"
"\n"
"\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n"
"\t\t# Does not require the --overwrite flag.\n"
"\t\tkubectl label pods foo bar-"

#: pkg/kubectl/cmd/rollingupdate.go:54
msgid ""
"\n"
"\t\t# Update pods of frontend-v1 using new replication controller data in "
"frontend-v2.json.\n"
"\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n"
"\n"
"\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n"
"\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n"
"\n"
"\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the "
"image, and switching the\n"
"\t\t# name of the replication controller.\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n"
"\n"
"\t\t# Update the pods of frontend by just changing the image, and keeping "
"the old name.\n"
"\t\tkubectl rolling-update frontend --image=image:v2\n"
"\n"
"\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to "
"frontend-v2).\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback"
msgstr ""
"\n"
"\t\t# Update pods of frontend-v1 using new replication controller data in "
"frontend-v2.json.\n"
"\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n"
"\n"
"\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n"
"\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n"
"\n"
"\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the "
"image, and switching the\n"
"\t\t# name of the replication controller.\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n"
"\n"
"\t\t# Update the pods of frontend by just changing the image, and keeping "
"the old name.\n"
"\t\tkubectl rolling-update frontend --image=image:v2\n"
"\n"
"\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to "
"frontend-v2).\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback"

#: pkg/kubectl/cmd/apply_view_last_applied.go:52
msgid ""
"\n"
"\t\t# View the last-applied-configuration annotations by type/name in YAML.\n"
"\t\tkubectl apply view-last-applied deployment/nginx\n"
"\n"
"\t\t# View the last-applied-configuration annotations by file in JSON\n"
"\t\tkubectl apply view-last-applied -f deploy.yaml -o json"
msgstr ""
"\n"
"\t\t# View the last-applied-configuration annotations by type/name in YAML.\n"
"\t\tkubectl apply view-last-applied deployment/nginx\n"
"\n"
"\t\t# View the last-applied-configuration annotations by file in JSON\n"
"\t\tkubectl apply view-last-applied -f deploy.yaml -o json"

#: pkg/kubectl/cmd/apply.go:75
msgid ""
"\n"
"\t\tApply a configuration to a resource by filename or stdin.\n"
"\t\tThis resource will be created if it doesn't exist yet.\n"
"\t\tTo use 'apply', always create the resource initially with either 'apply' "
"or 'create --save-config'.\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not "
"use unless you are aware of what the current state is. See https://issues."
"k8s.io/34274."
msgstr ""
"\n"
"\t\tApply a configuration to a resource by filename or stdin.\n"
"\t\tThis resource will be created if it doesn't exist yet.\n"
"\t\tTo use 'apply', always create the resource initially with either 'apply' "
"or 'create --save-config'.\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not "
"use unless you are aware of what the current state is. See https://issues."
"k8s.io/34274."

#: pkg/kubectl/cmd/convert.go:38
msgid ""
"\n"
"\t\tConvert config files between different API versions. Both YAML\n"
"\t\tand JSON formats are accepted.\n"
"\n"
"\t\tThe command takes filename, directory, or URL as input, and convert it "
"into format\n"
"\t\tof version specified by --output-version flag. If target version is not "
"specified or\n"
"\t\tnot supported, convert to latest version.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change to output destination."
msgstr ""
"\n"
"\t\tConvert config files between different API versions. Both YAML\n"
"\t\tand JSON formats are accepted.\n"
"\n"
"\t\tThe command takes filename, directory, or URL as input, and convert it "
"into format\n"
"\t\tof version specified by --output-version flag. If target version is not "
"specified or\n"
"\t\tnot supported, convert to latest version.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change to output destination."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L68
#: pkg/kubectl/cmd/create_clusterrole.go:31
msgid ""
"\n"
"\t\tCreate a ClusterRole."
msgstr ""
"\n"
"\t\tCreate a ClusterRole."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_clusterrolebinding.go#L43
#: pkg/kubectl/cmd/create_clusterrolebinding.go:32
msgid ""
"\n"
"\t\tCreate a ClusterRoleBinding for a particular ClusterRole."
msgstr ""
"\n"
"\t\tCreate a ClusterRoleBinding for a particular ClusterRole."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_rolebinding.go#L43
#: pkg/kubectl/cmd/create_rolebinding.go:32
msgid ""
"\n"
"\t\tCreate a RoleBinding for a particular Role or ClusterRole."
msgstr ""
"\n"
"\t\tCreate a RoleBinding for a particular Role or ClusterRole."

#: pkg/kubectl/cmd/create_secret.go:200
msgid ""
"\n"
"\t\tCreate a TLS secret from the given public/private key pair.\n"
"\n"
"\t\tThe public/private key pair must exist before hand. The public key "
"certificate must be .PEM encoded and match the given private key."
msgstr ""
"\n"
"\t\tCreate a TLS secret from the given public/private key pair.\n"
"\n"
"\t\tThe public/private key pair must exist before hand. The public key "
"certificate must be .PEM encoded and match the given private key."

#: pkg/kubectl/cmd/create_configmap.go:32
msgid ""
"\n"
"\t\tCreate a configmap based on a file, directory, or specified literal "
"value.\n"
"\n"
"\t\tA single configmap may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a configmap based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a configmap based on a directory, each file whose basename "
"is a valid key in the directory will be\n"
"\t\tpackaged into the configmap.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."
msgstr ""
"\n"
"\t\tCreate a configmap based on a file, directory, or specified literal "
"value.\n"
"\n"
"\t\tA single configmap may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a configmap based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a configmap based on a directory, each file whose basename "
"is a valid key in the directory will be\n"
"\t\tpackaged into the configmap.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_namespace.go#L44
#: pkg/kubectl/cmd/create_namespace.go:32
msgid ""
"\n"
"\t\tCreate a namespace with the specified name."
msgstr ""
"\n"
"\t\tCreate a namespace with the specified name."

#: pkg/kubectl/cmd/create_secret.go:119
msgid ""
"\n"
"\t\tCreate a new secret for use with Docker registries.\n"
"\n"
"\t\tDockercfg secrets are used to authenticate against Docker registries.\n"
"\n"
"\t\tWhen using the Docker command line to push images, you can authenticate "
"to a given registry by running\n"
"\n"
"\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --"
"password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n"
"\n"
"    That produces a ~/.dockercfg file that is used by subsequent 'docker "
"push' and 'docker pull' commands to\n"
"\t\tauthenticate to the registry. The email address is optional.\n"
"\n"
"\t\tWhen creating applications, you may have a Docker registry that requires "
"authentication.  In order for the\n"
"\t\tnodes to pull images on your behalf, they have to have the credentials.  "
"You can provide this information\n"
"\t\tby creating a dockercfg secret and attaching it to your service account."
msgstr ""
"\n"
"\t\tCreate a new secret for use with Docker registries.\n"
"\n"
"\t\tDockercfg secrets are used to authenticate against Docker registries.\n"
"\n"
"\t\tWhen using the Docker command line to push images, you can authenticate "
"to a given registry by running\n"
"\n"
"\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --"
"password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n"
"\n"
"    That produces a ~/.dockercfg file that is used by subsequent 'docker "
"push' and 'docker pull' commands to\n"
"\t\tauthenticate to the registry. The email address is optional.\n"
"\n"
"\t\tWhen creating applications, you may have a Docker registry that requires "
"authentication.  In order for the\n"
"\t\tnodes to pull images on your behalf, they have to have the credentials.  "
"You can provide this information\n"
"\t\tby creating a dockercfg secret and attaching it to your service account."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_pdb.go#L49
#: pkg/kubectl/cmd/create_pdb.go:32
msgid ""
"\n"
"\t\tCreate a pod disruption budget with the specified name, selector, and "
"desired minimum available pods"
msgstr ""
"\n"
"\t\tCreate a pod disruption budget with the specified name, selector, and "
"desired minimum available pods"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create.go#L56
#: pkg/kubectl/cmd/create.go:42
msgid ""
"\n"
"\t\tCreate a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted."
msgstr ""
"\n"
"\t\tCreate a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L47
#: pkg/kubectl/cmd/create_quota.go:32
msgid ""
"\n"
"\t\tCreate a resourcequota with the specified name, hard limits and optional "
"scopes"
msgstr ""
"\n"
"\t\tCreate a resourcequota with the specified name, hard limits and optional "
"scopes"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L47
#: pkg/kubectl/cmd/create_role.go:38
msgid ""
"\n"
"\t\tCreate a role with single rule."
msgstr ""
"\n"
"\t\tCreate a role with single rule."

#: pkg/kubectl/cmd/create_secret.go:47
msgid ""
"\n"
"\t\tCreate a secret based on a file, directory, or specified literal value.\n"
"\n"
"\t\tA single secret may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a secret based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a secret based on a directory, each file whose basename is "
"a valid key in the directory will be\n"
"\t\tpackaged into the secret.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."
msgstr ""
"\n"
"\t\tCreate a secret based on a file, directory, or specified literal value.\n"
"\n"
"\t\tA single secret may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a secret based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a secret based on a directory, each file whose basename is "
"a valid key in the directory will be\n"
"\t\tpackaged into the secret.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_serviceaccount.go#L44
#: pkg/kubectl/cmd/create_serviceaccount.go:32
msgid ""
"\n"
"\t\tCreate a service account with the specified name."
msgstr ""
"\n"
"\t\tCreate a service account with the specified name."

#: pkg/kubectl/cmd/run.go:52
msgid ""
"\n"
"\t\tCreate and run a particular image, possibly replicated.\n"
"\n"
"\t\tCreates a deployment or job to manage the created container(s)."
msgstr ""
"\n"
"\t\tCreate and run a particular image, possibly replicated.\n"
"\n"
"\t\tCreates a deployment or job to manage the created container(s)."

#: pkg/kubectl/cmd/autoscale.go:34
msgid ""
"\n"
"\t\tCreates an autoscaler that automatically chooses and sets the number of "
"pods that run in a kubernetes cluster.\n"
"\n"
"\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and "
"creates an autoscaler that uses the given resource as a reference.\n"
"\t\tAn autoscaler can automatically increase or decrease number of pods "
"deployed within the system as needed."
msgstr ""
"\n"
"\t\tCreates an autoscaler that automatically chooses and sets the number of "
"pods that run in a kubernetes cluster.\n"
"\n"
"\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and "
"creates an autoscaler that uses the given resource as a reference.\n"
"\t\tAn autoscaler can automatically increase or decrease number of pods "
"deployed within the system as needed."

#: pkg/kubectl/cmd/delete.go:40
msgid ""
"\n"
"\t\tDelete resources by filenames, stdin, resources and names, or by "
"resources and label selector.\n"
"\n"
"\t\tJSON and YAML formats are accepted. Only one type of the arguments may "
"be specified: filenames,\n"
"\t\tresources and names, or resources and label selector.\n"
"\n"
"\t\tSome resources, such as pods, support graceful deletion. These resources "
"define a default period\n"
"\t\tbefore they are forcibly terminated (the grace period) but you may "
"override that value with\n"
"\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. "
"Because these resources often\n"
"\t\trepresent entities in the cluster, deletion may not be acknowledged "
"immediately. If the node\n"
"\t\thosting a pod is down or cannot reach the API server, termination may "
"take significantly longer\n"
"\t\tthan the grace period. To force delete a resource,\tyou must pass a grace"
"\tperiod of 0 and specify\n"
"\t\tthe --force flag.\n"
"\n"
"\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the "
"pod's processes have been\n"
"\t\tterminated, which can leave those processes running until the node "
"detects the deletion and\n"
"\t\tcompletes graceful deletion. If your processes use shared storage or "
"talk to a remote API and\n"
"\t\tdepend on the name of the pod to identify themselves, force deleting "
"those pods may result in\n"
"\t\tmultiple processes running on different machines using the same "
"identification which may lead\n"
"\t\tto data corruption or inconsistency. Only force delete pods when you are "
"sure the pod is\n"
"\t\tterminated, or if your application can tolerate multiple copies of the "
"same pod running at once.\n"
"\t\tAlso, if you force delete pods the scheduler may place new pods on those "
"nodes before the node\n"
"\t\thas released those resources and causing those pods to be evicted "
"immediately.\n"
"\n"
"\t\tNote that the delete command does NOT do resource version checks, so if "
"someone\n"
"\t\tsubmits an update to a resource right when you submit a delete, their "
"update\n"
"\t\twill be lost along with the rest of the resource."
msgstr ""
"\n"
"\t\tDelete resources by filenames, stdin, resources and names, or by "
"resources and label selector.\n"
"\n"
"\t\tJSON and YAML formats are accepted. Only one type of the arguments may "
"be specified: filenames,\n"
"\t\tresources and names, or resources and label selector.\n"
"\n"
"\t\tSome resources, such as pods, support graceful deletion. These resources "
"define a default period\n"
"\t\tbefore they are forcibly terminated (the grace period) but you may "
"override that value with\n"
"\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. "
"Because these resources often\n"
"\t\trepresent entities in the cluster, deletion may not be acknowledged "
"immediately. If the node\n"
"\t\thosting a pod is down or cannot reach the API server, termination may "
"take significantly longer\n"
"\t\tthan the grace period. To force delete a resource,\tyou must pass a grace"
"\tperiod of 0 and specify\n"
"\t\tthe --force flag.\n"
"\n"
"\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the "
"pod's processes have been\n"
"\t\tterminated, which can leave those processes running until the node "
"detects the deletion and\n"
"\t\tcompletes graceful deletion. If your processes use shared storage or "
"talk to a remote API and\n"
"\t\tdepend on the name of the pod to identify themselves, force deleting "
"those pods may result in\n"
"\t\tmultiple processes running on different machines using the same "
"identification which may lead\n"
"\t\tto data corruption or inconsistency. Only force delete pods when you are "
"sure the pod is\n"
"\t\tterminated, or if your application can tolerate multiple copies of the "
"same pod running at once.\n"
"\t\tAlso, if you force delete pods the scheduler may place new pods on those "
"nodes before the node\n"
"\t\thas released those resources and causing those pods to be evicted "
"immediately.\n"
"\n"
"\t\tNote that the delete command does NOT do resource version checks, so if "
"someone\n"
"\t\tsubmits an update to a resource right when you submit a delete, their "
"update\n"
"\t\twill be lost along with the rest of the resource."

#: pkg/kubectl/cmd/stop.go:31
msgid ""
"\n"
"\t\tDeprecated: Gracefully shut down a resource by name or filename.\n"
"\n"
"\t\tThe stop command is deprecated, all its functionalities are covered by "
"delete command.\n"
"\t\tSee 'kubectl delete --help' for more details.\n"
"\n"
"\t\tAttempts to shut down and delete a resource that supports graceful "
"termination.\n"
"\t\tIf the resource is scalable it will be scaled to 0 before deletion."
msgstr ""
"\n"
"\t\tDeprecated: Gracefully shut down a resource by name or filename.\n"
"\n"
"\t\tThe stop command is deprecated, all its functionalities are covered by "
"delete command.\n"
"\t\tSee 'kubectl delete --help' for more details.\n"
"\n"
"\t\tAttempts to shut down and delete a resource that supports graceful "
"termination.\n"
"\t\tIf the resource is scalable it will be scaled to 0 before deletion."

#: pkg/kubectl/cmd/top_node.go:60
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n"
"\n"
"\t\tThe top-node command allows you to see the resource consumption of nodes."
msgstr ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n"
"\n"
"\t\tThe top-node command allows you to see the resource consumption of nodes."

#: pkg/kubectl/cmd/top_pod.go:53
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n"
"\n"
"\t\tThe 'top pod' command allows you to see the resource consumption of "
"pods.\n"
"\n"
"\t\tDue to the metrics pipeline delay, they may be unavailable for a few "
"minutes\n"
"\t\tsince pod creation."
msgstr ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n"
"\n"
"\t\tThe 'top pod' command allows you to see the resource consumption of "
"pods.\n"
"\n"
"\t\tDue to the metrics pipeline delay, they may be unavailable for a few "
"minutes\n"
"\t\tsince pod creation."

#: pkg/kubectl/cmd/top.go:33
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage.\n"
"\n"
"\t\tThe top command allows you to see the resource consumption for nodes or "
"pods.\n"
"\n"
"\t\tThis command requires Heapster to be correctly configured and working on "
"the server. "
msgstr ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage.\n"
"\n"
"\t\tThe top command allows you to see the resource consumption for nodes or "
"pods.\n"
"\n"
"\t\tThis command requires Heapster to be correctly configured and working on "
"the server. "

#: pkg/kubectl/cmd/drain.go:140
msgid ""
"\n"
"\t\tDrain node in preparation for maintenance.\n"
"\n"
"\t\tThe given node will be marked unschedulable to prevent new pods from "
"arriving.\n"
"\t\t'drain' evicts the pods if the APIServer supports eviction\n"
"\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use "
"normal DELETE\n"
"\t\tto delete the pods.\n"
"\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot "
"be deleted through\n"
"\t\tthe API server).  If there are DaemonSet-managed pods, drain will not "
"proceed\n"
"\t\twithout --ignore-daemonsets, and regardless it will not delete any\n"
"\t\tDaemonSet-managed pods, because those pods would be immediately replaced "
"by the\n"
"\t\tDaemonSet controller, which ignores unschedulable markings.  If there "
"are any\n"
"\t\tpods that are neither mirror pods nor managed by ReplicationController,\n"
"\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete "
"any pods unless you\n"
"\t\tuse --force.  --force will also allow deletion to proceed if the "
"managing resource of one\n"
"\t\tor more pods is missing.\n"
"\n"
"\t\t'drain' waits for graceful termination. You should not operate on the "
"machine until\n"
"\t\tthe command completes.\n"
"\n"
"\t\tWhen you are ready to put the node back into service, use kubectl "
"uncordon, which\n"
"\t\twill make the node schedulable again.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)"
msgstr ""
"\n"
"\t\tDrain node in preparation for maintenance.\n"
"\n"
"\t\tThe given node will be marked unschedulable to prevent new pods from "
"arriving.\n"
"\t\t'drain' evicts the pods if the APIServer supports eviction\n"
"\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use "
"normal DELETE\n"
"\t\tto delete the pods.\n"
"\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot "
"be deleted through\n"
"\t\tthe API server).  If there are DaemonSet-managed pods, drain will not "
"proceed\n"
"\t\twithout --ignore-daemonsets, and regardless it will not delete any\n"
"\t\tDaemonSet-managed pods, because those pods would be immediately replaced "
"by the\n"
"\t\tDaemonSet controller, which ignores unschedulable markings.  If there "
"are any\n"
"\t\tpods that are neither mirror pods nor managed by ReplicationController,\n"
"\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete "
"any pods unless you\n"
"\t\tuse --force.  --force will also allow deletion to proceed if the "
"managing resource of one\n"
"\t\tor more pods is missing.\n"
"\n"
"\t\t'drain' waits for graceful termination. You should not operate on the "
"machine until\n"
"\t\tthe command completes.\n"
"\n"
"\t\tWhen you are ready to put the node back into service, use kubectl "
"uncordon, which\n"
"\t\twill make the node schedulable again.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)"

#: pkg/kubectl/cmd/edit.go:56
msgid ""
"\n"
"\t\tEdit a resource from the default editor.\n"
"\n"
"\t\tThe edit command allows you to directly edit any API resource you can "
"retrieve via the\n"
"\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, "
"or EDITOR\n"
"\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for "
"Windows.\n"
"\t\tYou can edit multiple objects, although changes are applied one at a "
"time. The command\n"
"\t\taccepts filenames as well as command line arguments, although the files "
"you point to must\n"
"\t\tbe previously saved versions of resources.\n"
"\n"
"\t\tEditing is done with the API version used to fetch the resource.\n"
"\t\tTo edit using a specific API version, fully-qualify the resource, "
"version, and group.\n"
"\n"
"\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n"
"\n"
"\t\tThe flag --windows-line-endings can be used to force Windows line "
"endings,\n"
"\t\totherwise the default for your operating system will be used.\n"
"\n"
"\t\tIn the event an error occurs while updating, a temporary file will be "
"created on disk\n"
"\t\tthat contains your unapplied changes. The most common error when "
"updating a resource\n"
"\t\tis another editor changing the resource on the server. When this occurs, "
"you will have\n"
"\t\tto apply your changes to the newer version of the resource, or update "
"your temporary\n"
"\t\tsaved copy to include the latest resource version."
msgstr ""
"\n"
"\t\tEdit a resource from the default editor.\n"
"\n"
"\t\tThe edit command allows you to directly edit any API resource you can "
"retrieve via the\n"
"\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, "
"or EDITOR\n"
"\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for "
"Windows.\n"
"\t\tYou can edit multiple objects, although changes are applied one at a "
"time. The command\n"
"\t\taccepts filenames as well as command line arguments, although the files "
"you point to must\n"
"\t\tbe previously saved versions of resources.\n"
"\n"
"\t\tEditing is done with the API version used to fetch the resource.\n"
"\t\tTo edit using a specific API version, fully-qualify the resource, "
"version, and group.\n"
"\n"
"\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n"
"\n"
"\t\tThe flag --windows-line-endings can be used to force Windows line "
"endings,\n"
"\t\totherwise the default for your operating system will be used.\n"
"\n"
"\t\tIn the event an error occurs while updating, a temporary file will be "
"created on disk\n"
"\t\tthat contains your unapplied changes. The most common error when "
"updating a resource\n"
"\t\tis another editor changing the resource on the server. When this occurs, "
"you will have\n"
"\t\tto apply your changes to the newer version of the resource, or update "
"your temporary\n"
"\t\tsaved copy to include the latest resource version."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L127
#: pkg/kubectl/cmd/drain.go:115
msgid ""
"\n"
"\t\tMark node as schedulable."
msgstr ""
"\n"
"\t\tMark node as schedulable."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L102
#: pkg/kubectl/cmd/drain.go:90
msgid ""
"\n"
"\t\tMark node as unschedulable."
msgstr ""
"\n"
"\t\tMark node as unschedulable."

#: pkg/kubectl/cmd/completion.go:47
msgid ""
"\n"
"\t\tOutput shell completion code for the specified shell (bash or zsh).\n"
"\t\tThe shell code must be evaluated to provide interactive\n"
"\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n"
"\t\tthe .bash_profile.\n"
"\n"
"\t\tNote: this requires the bash-completion framework, which is not "
"installed\n"
"\t\tby default on Mac.  This can be installed by using homebrew:\n"
"\n"
"\t\t    $ brew install bash-completion\n"
"\n"
"\t\tOnce installed, bash_completion must be evaluated.  This can be done by "
"adding the\n"
"\t\tfollowing line to the .bash_profile\n"
"\n"
"\t\t    $ source $(brew --prefix)/etc/bash_completion\n"
"\n"
"\t\tNote for zsh users: [1] zsh completions are only supported in versions "
"of zsh >= 5.2"
msgstr ""
"\n"
"\t\tOutput shell completion code for the specified shell (bash or zsh).\n"
"\t\tThe shell code must be evaluated to provide interactive\n"
"\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n"
"\t\tthe .bash_profile.\n"
"\n"
"\t\tNote: this requires the bash-completion framework, which is not "
"installed\n"
"\t\tby default on Mac.  This can be installed by using homebrew:\n"
"\n"
"\t\t    $ brew install bash-completion\n"
"\n"
"\t\tOnce installed, bash_completion must be evaluated.  This can be done by "
"adding the\n"
"\t\tfollowing line to the .bash_profile\n"
"\n"
"\t\t    $ source $(brew --prefix)/etc/bash_completion\n"
"\n"
"\t\tNote for zsh users: [1] zsh completions are only supported in versions "
"of zsh >= 5.2"

#: pkg/kubectl/cmd/rollingupdate.go:45
msgid ""
"\n"
"\t\tPerform a rolling update of the given ReplicationController.\n"
"\n"
"\t\tReplaces the specified replication controller with a new replication "
"controller by updating one pod at a time to use the\n"
"\t\tnew PodTemplate. The new-controller.json must specify the same namespace "
"as the\n"
"\t\texisting replication controller and overwrite at least one (common) "
"label in its replicaSelector.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)"
msgstr ""
"\n"
"\t\tPerform a rolling update of the given ReplicationController.\n"
"\n"
"\t\tReplaces the specified replication controller with a new replication "
"controller by updating one pod at a time to use the\n"
"\t\tnew PodTemplate. The new-controller.json must specify the same namespace "
"as the\n"
"\t\texisting replication controller and overwrite at least one (common) "
"label in its replicaSelector.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)"

#: pkg/kubectl/cmd/replace.go:40
msgid ""
"\n"
"\t\tReplace a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted. If replacing an existing resource, "
"the\n"
"\t\tcomplete resource spec must be provided. This can be obtained by\n"
"\n"
"\t\t    $ kubectl get TYPE NAME -o yaml\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."
msgstr ""
"\n"
"\t\tReplace a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted. If replacing an existing resource, "
"the\n"
"\t\tcomplete resource spec must be provided. This can be obtained by\n"
"\n"
"\t\t    $ kubectl get TYPE NAME -o yaml\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."

#: pkg/kubectl/cmd/scale.go:34
msgid ""
"\n"
"\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or "
"Job.\n"
"\n"
"\t\tScale also allows users to specify one or more preconditions for the "
"scale action.\n"
"\n"
"\t\tIf --current-replicas or --resource-version is specified, it is "
"validated before the\n"
"\t\tscale is attempted, and it is guaranteed that the precondition holds "
"true when the\n"
"\t\tscale is sent to the server."
msgstr ""
"\n"
"\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or "
"Job.\n"
"\n"
"\t\tScale also allows users to specify one or more preconditions for the "
"scale action.\n"
"\n"
"\t\tIf --current-replicas or --resource-version is specified, it is "
"validated before the\n"
"\t\tscale is attempted, and it is guaranteed that the precondition holds "
"true when the\n"
"\t\tscale is sent to the server."

#: pkg/kubectl/cmd/apply_set_last_applied.go:62
msgid ""
"\n"
"\t\tSet the latest last-applied-configuration annotations by setting it to "
"match the contents of a file.\n"
"\t\tThis results in the last-applied-configuration being updated as though "
"'kubectl apply -f <file>' was run,\n"
"\t\twithout updating any other parts of the object."
msgstr ""
"\n"
"\t\tSet the latest last-applied-configuration annotations by setting it to "
"match the contents of a file.\n"
"\t\tThis results in the last-applied-configuration being updated as though "
"'kubectl apply -f <file>' was run,\n"
"\t\twithout updating any other parts of the object."

#: pkg/kubectl/cmd/proxy.go:36
msgid ""
"\n"
"\t\tTo proxy all of the kubernetes api and nothing else, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/\n"
"\n"
"\t\tTo proxy only part of the kubernetes api and also some static files:\n"
"\n"
"\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/"
"api/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n"
"\n"
"\t\tTo proxy the entire kubernetes api at a different root, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/custom/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'"
msgstr ""
"\n"
"\t\tTo proxy all of the kubernetes api and nothing else, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/\n"
"\n"
"\t\tTo proxy only part of the kubernetes api and also some static files:\n"
"\n"
"\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/"
"api/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n"
"\n"
"\t\tTo proxy the entire kubernetes api at a different root, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/custom/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'"

#: pkg/kubectl/cmd/patch.go:59
msgid ""
"\n"
"\t\tUpdate field(s) of a resource using strategic merge patch\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."
msgstr ""
"\n"
"\t\tUpdate field(s) of a resource using strategic merge patch\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."

#: pkg/kubectl/cmd/label.go:70
#, c-format
msgid ""
"\n"
"\t\tUpdate the labels on a resource.\n"
"\n"
"\t\t* A label must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* If --overwrite is true, then existing labels can be overwritten, "
"otherwise attempting to overwrite a label will result in an error.\n"
"\t\t* If --resource-version is specified, then updates will use this "
"resource version, otherwise the existing resource-version will be used."
msgstr ""
"\n"
"\t\tUpdate the labels on a resource.\n"
"\n"
"\t\t* A label must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* If --overwrite is true, then existing labels can be overwritten, "
"otherwise attempting to overwrite a label will result in an error.\n"
"\t\t* If --resource-version is specified, then updates will use this "
"resource version, otherwise the existing resource-version will be used."

#: pkg/kubectl/cmd/taint.go:58
#, c-format
msgid ""
"\n"
"\t\tUpdate the taints on one or more nodes.\n"
"\n"
"\t\t* A taint consists of a key, value, and effect. As an argument here, it "
"is expressed as key=value:effect.\n"
"\t\t* The key must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* The value must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[2]d characters.\n"
"\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n"
"\t\t* Currently taint can only apply to node."
msgstr ""
"\n"
"\t\tUpdate the taints on one or more nodes.\n"
"\n"
"\t\t* A taint consists of a key, value, and effect. As an argument here, it "
"is expressed as key=value:effect.\n"
"\t\t* The key must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* The value must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[2]d characters.\n"
"\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n"
"\t\t* Currently taint can only apply to node."

#: pkg/kubectl/cmd/apply_view_last_applied.go:46
msgid ""
"\n"
"\t\tView the latest last-applied-configuration annotations by type/name or "
"file.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change output format."
msgstr ""
"\n"
"\t\tView the latest last-applied-configuration annotations by type/name or "
"file.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change output format."

#: pkg/kubectl/cmd/cp.go:37
msgid ""
"\n"
"\t    # !!!Important Note!!!\n"
"\t    # Requires that the 'tar' binary is present in your container\n"
"\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n"
"\n"
"\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in "
"the default namespace\n"
"\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n"
"\n"
"        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific "
"container\n"
"\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n"
"\n"
"\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace "
"<some-namespace>\n"
"\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n"
"\n"
"\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n"
"\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar"
msgstr ""
"\n"
"\t    # !!!Important Note!!!\n"
"\t    # Requires that the 'tar' binary is present in your container\n"
"\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n"
"\n"
"\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in "
"the default namespace\n"
"\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n"
"\n"
"        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific "
"container\n"
"\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n"
"\n"
"\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace "
"<some-namespace>\n"
"\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n"
"\n"
"\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n"
"\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar"

#: pkg/kubectl/cmd/create_secret.go:205
msgid ""
"\n"
"\t  # Create a new TLS secret named tls-secret with the given key pair:\n"
"\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/"
"to/tls.key"
msgstr ""
"\n"
"\t  # Create a new TLS secret named tls-secret with the given key pair:\n"
"\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/"
"to/tls.key"

#: pkg/kubectl/cmd/create_namespace.go:35
msgid ""
"\n"
"\t  # Create a new namespace named my-namespace\n"
"\t  kubectl create namespace my-namespace"
msgstr ""
"\n"
"\t  # Create a new namespace named my-namespace\n"
"\t  kubectl create namespace my-namespace"

#: pkg/kubectl/cmd/create_secret.go:59
msgid ""
"\n"
"\t  # Create a new secret named my-secret with keys for each file in folder "
"bar\n"
"\t  kubectl create secret generic my-secret --from-file=path/to/bar\n"
"\n"
"\t  # Create a new secret named my-secret with specified keys instead of "
"names on disk\n"
"\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/."
"ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n"
"\n"
"\t  # Create a new secret named my-secret with key1=supersecret and "
"key2=topsecret\n"
"\t  kubectl create secret generic my-secret --from-literal=key1=supersecret "
"--from-literal=key2=topsecret"
msgstr ""
"\n"
"\t  # Create a new secret named my-secret with keys for each file in folder "
"bar\n"
"\t  kubectl create secret generic my-secret --from-file=path/to/bar\n"
"\n"
"\t  # Create a new secret named my-secret with specified keys instead of "
"names on disk\n"
"\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/."
"ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n"
"\n"
"\t  # Create a new secret named my-secret with key1=supersecret and "
"key2=topsecret\n"
"\t  kubectl create secret generic my-secret --from-literal=key1=supersecret "
"--from-literal=key2=topsecret"

#: pkg/kubectl/cmd/create_serviceaccount.go:35
msgid ""
"\n"
"\t  # Create a new service account named my-service-account\n"
"\t  kubectl create serviceaccount my-service-account"
msgstr ""
"\n"
"\t  # Create a new service account named my-service-account\n"
"\t  kubectl create serviceaccount my-service-account"

#: pkg/kubectl/cmd/create_service.go:232
msgid ""
"\n"
"\t# Create a new ExternalName service named my-ns \n"
"\tkubectl create service externalname my-ns --external-name bar.com"
msgstr ""
"\n"
"\t# Create a new ExternalName service named my-ns \n"
"\tkubectl create service externalname my-ns --external-name bar.com"

#: pkg/kubectl/cmd/create_service.go:225
msgid ""
"\n"
"\tCreate an ExternalName service with the specified name.\n"
"\n"
"\tExternalName service references to an external DNS address instead of\n"
"\tonly pods, which will allow application authors to reference services\n"
"\tthat exist off platform, on other clusters, or locally."
msgstr ""
"\n"
"\tCreate an ExternalName service with the specified name.\n"
"\n"
"\tExternalName service references to an external DNS address instead of\n"
"\tonly pods, which will allow application authors to reference services\n"
"\tthat exist off platform, on other clusters, or locally."

#: pkg/kubectl/cmd/help.go:30
msgid ""
"\n"
"\tHelp provides help for any command in the application.\n"
"\tSimply type kubectl help [path to command] for full details."
msgstr ""
"\n"
"\tHelp provides help for any command in the application.\n"
"\tSimply type kubectl help [path to command] for full details."

#: pkg/kubectl/cmd/create_service.go:173
msgid ""
"\n"
"    # Create a new LoadBalancer service named my-lbs\n"
"    kubectl create service loadbalancer my-lbs --tcp=5678:8080"
msgstr ""
"\n"
"    # Create a new LoadBalancer service named my-lbs\n"
"    kubectl create service loadbalancer my-lbs --tcp=5678:8080"

#: pkg/kubectl/cmd/create_service.go:53
msgid ""
"\n"
"    # Create a new clusterIP service named my-cs\n"
"    kubectl create service clusterip my-cs --tcp=5678:8080\n"
"\n"
"    # Create a new clusterIP service named my-cs (in headless mode)\n"
"    kubectl create service clusterip my-cs --clusterip=\"None\""
msgstr ""
"\n"
"    # Create a new clusterIP service named my-cs\n"
"    kubectl create service clusterip my-cs --tcp=5678:8080\n"
"\n"
"    # Create a new clusterIP service named my-cs (in headless mode)\n"
"    kubectl create service clusterip my-cs --clusterip=\"None\""

#: pkg/kubectl/cmd/create_deployment.go:36
msgid ""
"\n"
"    # Create a new deployment named my-dep that runs the busybox image.\n"
"    kubectl create deployment my-dep --image=busybox"
msgstr ""
"\n"
"    # Create a new deployment named my-dep that runs the busybox image.\n"
"    kubectl create deployment my-dep --image=busybox"

#: pkg/kubectl/cmd/create_service.go:116
msgid ""
"\n"
"    # Create a new nodeport service named my-ns\n"
"    kubectl create service nodeport my-ns --tcp=5678:8080"
msgstr ""
"\n"
"    # Create a new nodeport service named my-ns\n"
"    kubectl create service nodeport my-ns --tcp=5678:8080"

#: pkg/kubectl/cmd/clusterinfo_dump.go:62
msgid ""
"\n"
"    # Dump current cluster state to stdout\n"
"    kubectl cluster-info dump\n"
"\n"
"    # Dump current cluster state to /path/to/cluster-state\n"
"    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n"
"\n"
"    # Dump all namespaces to stdout\n"
"    kubectl cluster-info dump --all-namespaces\n"
"\n"
"    # Dump a set of namespaces to /path/to/cluster-state\n"
"    kubectl cluster-info dump --namespaces default,kube-system --output-"
"directory=/path/to/cluster-state"
msgstr ""
"\n"
"    # Dump current cluster state to stdout\n"
"    kubectl cluster-info dump\n"
"\n"
"    # Dump current cluster state to /path/to/cluster-state\n"
"    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n"
"\n"
"    # Dump all namespaces to stdout\n"
"    kubectl cluster-info dump --all-namespaces\n"
"\n"
"    # Dump a set of namespaces to /path/to/cluster-state\n"
"    kubectl cluster-info dump --namespaces default,kube-system --output-"
"directory=/path/to/cluster-state"

#: pkg/kubectl/cmd/annotate.go:78
msgid ""
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend'.\n"
"    # If the same annotation is set multiple times, only the last value will "
"be applied\n"
"    kubectl annotate pods foo description='my frontend'\n"
"\n"
"    # Update a pod identified by type and name in \"pod.json\"\n"
"    kubectl annotate -f pod.json description='my frontend'\n"
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend running nginx', overwriting any existing value.\n"
"    kubectl annotate --overwrite pods foo description='my frontend running "
"nginx'\n"
"\n"
"    # Update all pods in the namespace\n"
"    kubectl annotate pods --all description='my frontend running nginx'\n"
"\n"
"    # Update pod 'foo' only if the resource is unchanged from version 1.\n"
"    kubectl annotate pods foo description='my frontend running nginx' --"
"resource-version=1\n"
"\n"
"    # Update pod 'foo' by removing an annotation named 'description' if it "
"exists.\n"
"    # Does not require the --overwrite flag.\n"
"    kubectl annotate pods foo description-"
msgstr ""
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend'.\n"
"    # If the same annotation is set multiple times, only the last value will "
"be applied\n"
"    kubectl annotate pods foo description='my frontend'\n"
"\n"
"    # Update a pod identified by type and name in \"pod.json\"\n"
"    kubectl annotate -f pod.json description='my frontend'\n"
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend running nginx', overwriting any existing value.\n"
"    kubectl annotate --overwrite pods foo description='my frontend running "
"nginx'\n"
"\n"
"    # Update all pods in the namespace\n"
"    kubectl annotate pods --all description='my frontend running nginx'\n"
"\n"
"    # Update pod 'foo' only if the resource is unchanged from version 1.\n"
"    kubectl annotate pods foo description='my frontend running nginx' --"
"resource-version=1\n"
"\n"
"    # Update pod 'foo' by removing an annotation named 'description' if it "
"exists.\n"
"    # Does not require the --overwrite flag.\n"
"    kubectl annotate pods foo description-"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_namespace.go#L44
#: pkg/kubectl/cmd/create_service.go:170
msgid ""
"\n"
"    Create a LoadBalancer service with the specified name."
msgstr ""
"\n"
"    Create a LoadBalancer service with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_serviceaccount.go#L44
#: pkg/kubectl/cmd/create_service.go:50
msgid ""
"\n"
"    Create a clusterIP service with the specified name."
msgstr ""
"\n"
"    Create a clusterIP service with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_deployment.go#L44
#: pkg/kubectl/cmd/create_deployment.go:33
msgid ""
"\n"
"    Create a deployment with the specified name."
msgstr ""
"\n"
"    Create a deployment with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_deployment.go#L44
#: pkg/kubectl/cmd/create_service.go:113
msgid ""
"\n"
"    Create a nodeport service with the specified name."
msgstr ""
"\n"
"    Create a nodeport service with the specified name."

#: pkg/kubectl/cmd/clusterinfo_dump.go:53
msgid ""
"\n"
"    Dumps cluster info out suitable for debugging and diagnosing cluster "
"problems.  By default, dumps everything to\n"
"    stdout. You can optionally specify a directory with --output-directory.  "
"If you specify a directory, kubernetes will\n"
"    build a set of files in that directory.  By default only dumps things in "
"the 'kube-system' namespace, but you can\n"
"    switch to a different namespace with the --namespaces flag, or specify --"
"all-namespaces to dump all namespaces.\n"
"\n"
"    The command also dumps the logs of all of the pods in the cluster, these "
"logs are dumped into different directories\n"
"    based on namespace and pod name."
msgstr ""
"\n"
"    Dumps cluster info out suitable for debugging and diagnosing cluster "
"problems.  By default, dumps everything to\n"
"    stdout. You can optionally specify a directory with --output-directory.  "
"If you specify a directory, kubernetes will\n"
"    build a set of files in that directory.  By default only dumps things in "
"the 'kube-system' namespace, but you can\n"
"    switch to a different namespace with the --namespaces flag, or specify --"
"all-namespaces to dump all namespaces.\n"
"\n"
"    The command also dumps the logs of all of the pods in the cluster, these "
"logs are dumped into different directories\n"
"    based on namespace and pod name."

#: pkg/kubectl/cmd/clusterinfo.go:37
msgid ""
"\n"
"  Display addresses of the master and services with label kubernetes.io/"
"cluster-service=true\n"
"  To further debug and diagnose cluster problems, use 'kubectl cluster-info "
"dump'."
msgstr ""
"\n"
"  Display addresses of the master and services with label kubernetes.io/"
"cluster-service=true\n"
"  To further debug and diagnose cluster problems, use 'kubectl cluster-info "
"dump'."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L61
#: pkg/kubectl/cmd/create_quota.go:62
msgid ""
"A comma-delimited set of quota scopes that must all match each object "
"tracked by the quota."
msgstr ""
"A comma-delimited set of quota scopes that must all match each object "
"tracked by the quota."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L60
#: pkg/kubectl/cmd/create_quota.go:61
msgid ""
"A comma-delimited set of resource=quantity pairs that define a hard limit."
msgstr ""
"A comma-delimited set of resource=quantity pairs that define a hard limit."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_pdb.go#L63
#: pkg/kubectl/cmd/create_pdb.go:64
msgid ""
"A label selector to use for this budget. Only equality-based selector "
"requirements are supported."
msgstr ""
"A label selector to use for this budget. Only equality-based selector "
"requirements are supported."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L106
#: pkg/kubectl/cmd/expose.go:104
msgid ""
"A label selector to use for this service. Only equality-based selector "
"requirements are supported. If empty (the default) infer the selector from "
"the replication controller or replica set.)"
msgstr ""
"A label selector to use for this service. Only equality-based selector "
"requirements are supported. If empty (the default) infer the selector from "
"the replication controller or replica set.)"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L136
#: pkg/kubectl/cmd/run.go:139
msgid "A schedule in the Cron format the job should be run with."
msgstr "A schedule in the Cron format the job should be run with."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L111
#: pkg/kubectl/cmd/expose.go:109
msgid ""
"Additional external IP address (not managed by Kubernetes) to accept for the "
"service. If this IP is routed to a node, the service can be accessed by this "
"IP in addition to its generated service IP."
msgstr ""
"Additional external IP address (not managed by Kubernetes) to accept for the "
"service. If this IP is routed to a node, the service can be accessed by this "
"IP in addition to its generated service IP."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L119
#: pkg/kubectl/cmd/expose.go:110 pkg/kubectl/cmd/run.go:122
msgid ""
"An inline JSON override for the generated object. If this is non-empty, it "
"is used to override the generated object. Requires that the object supply a "
"valid apiVersion field."
msgstr ""
"An inline JSON override for the generated object. If this is non-empty, it "
"is used to override the generated object. Requires that the object supply a "
"valid apiVersion field."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L134
#: pkg/kubectl/cmd/run.go:137
msgid ""
"An inline JSON override for the generated service object. If this is non-"
"empty, it is used to override the generated object. Requires that the object "
"supply a valid apiVersion field.  Only used if --expose is true."
msgstr ""
"An inline JSON override for the generated service object. If this is non-"
"empty, it is used to override the generated object. Requires that the object "
"supply a valid apiVersion field.  Only used if --expose is true."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/apply.go#L98
#: pkg/kubectl/cmd/apply.go:104
msgid "Apply a configuration to a resource by filename or stdin"
msgstr "Apply a configuration to a resource by filename or stdin"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/certificates.go#L71
#: pkg/kubectl/cmd/certificates.go:72
msgid "Approve a certificate signing request"
msgstr "Approve a certificate signing request"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L81
#: pkg/kubectl/cmd/create_service.go:82
msgid ""
"Assign your own ClusterIP or set to 'None' for a 'headless' service (no "
"loadbalancing)."
msgstr ""
"Assign your own ClusterIP or set to 'None' for a 'headless' service (no "
"loadbalancing)."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/attach.go#L64
#: pkg/kubectl/cmd/attach.go:70
msgid "Attach to a running container"
msgstr "Attach to a running container"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/autoscale.go#L55
#: pkg/kubectl/cmd/autoscale.go:56
msgid "Auto-scale a Deployment, ReplicaSet, or ReplicationController"
msgstr "Auto-scale a Deployment, ReplicaSet, or ReplicationController"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L115
#: pkg/kubectl/cmd/expose.go:113
msgid ""
"ClusterIP to be assigned to the service. Leave empty to auto-allocate, or "
"set to 'None' to create a headless service."
msgstr ""
"ClusterIP to be assigned to the service. Leave empty to auto-allocate, or "
"set to 'None' to create a headless service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_clusterrolebinding.go#L55
#: pkg/kubectl/cmd/create_clusterrolebinding.go:56
msgid "ClusterRole this ClusterRoleBinding should reference"
msgstr "ClusterRole this ClusterRoleBinding should reference"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_rolebinding.go#L55
#: pkg/kubectl/cmd/create_rolebinding.go:56
msgid "ClusterRole this RoleBinding should reference"
msgstr "ClusterRole this RoleBinding should reference"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L101
#: pkg/kubectl/cmd/rollingupdate.go:102
msgid ""
"Container name which will have its image upgraded. Only relevant when --"
"image is specified, ignored otherwise. Required when using --image on a "
"multi-container pod"
msgstr ""
"Container name which will have its image upgraded. Only relevant when --"
"image is specified, ignored otherwise. Required when using --image on a "
"multi-container pod"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/convert.go#L67
#: pkg/kubectl/cmd/convert.go:68
msgid "Convert config files between different API versions"
msgstr "Convert config files between different API versions"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/cp.go#L64
#: pkg/kubectl/cmd/cp.go:65
msgid "Copy files and directories to and from containers."
msgstr "Copy files and directories to and from containers."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_clusterrolebinding.go#L43
#: pkg/kubectl/cmd/create_clusterrolebinding.go:44
msgid "Create a ClusterRoleBinding for a particular ClusterRole"
msgstr "Create a ClusterRoleBinding for a particular ClusterRole"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L181
#: pkg/kubectl/cmd/create_service.go:182
msgid "Create a LoadBalancer service."
msgstr "Create a LoadBalancer service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L124
#: pkg/kubectl/cmd/create_service.go:125
msgid "Create a NodePort service."
msgstr "Create a NodePort service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_rolebinding.go#L43
#: pkg/kubectl/cmd/create_rolebinding.go:44
msgid "Create a RoleBinding for a particular Role or ClusterRole"
msgstr "Create a RoleBinding for a particular Role or ClusterRole"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L214
#: pkg/kubectl/cmd/create_secret.go:214
msgid "Create a TLS secret"
msgstr "Create a TLS secret"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L68
#: pkg/kubectl/cmd/create_service.go:69
msgid "Create a clusterIP service."
msgstr "Create a clusterIP service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_configmap.go#L59
#: pkg/kubectl/cmd/create_configmap.go:60
msgid "Create a configmap from a local file, directory or literal value"
msgstr "Create a configmap from a local file, directory or literal value"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_deployment.go#L44
#: pkg/kubectl/cmd/create_deployment.go:46
msgid "Create a deployment with the specified name."
msgstr "Create a deployment with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_namespace.go#L44
#: pkg/kubectl/cmd/create_namespace.go:45
msgid "Create a namespace with the specified name"
msgstr "Create a namespace with the specified name"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_pdb.go#L49
#: pkg/kubectl/cmd/create_pdb.go:50
msgid "Create a pod disruption budget with the specified name."
msgstr "Create a pod disruption budget with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L47
#: pkg/kubectl/cmd/create_quota.go:48
msgid "Create a quota with the specified name."
msgstr "Create a quota with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create.go#L56
#: pkg/kubectl/cmd/create.go:63
msgid "Create a resource by filename or stdin"
msgstr "Create a resource by filename or stdin"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L143
#: pkg/kubectl/cmd/create_secret.go:144
msgid "Create a secret for use with a Docker registry"
msgstr "Create a secret for use with a Docker registry"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L73
#: pkg/kubectl/cmd/create_secret.go:74
msgid "Create a secret from a local file, directory or literal value"
msgstr "Create a secret from a local file, directory or literal value"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L34
#: pkg/kubectl/cmd/create_secret.go:35
msgid "Create a secret using specified subcommand"
msgstr "Create a secret using specified subcommand"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_serviceaccount.go#L44
#: pkg/kubectl/cmd/create_serviceaccount.go:45
msgid "Create a service account with the specified name"
msgstr "Create a service account with the specified name"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L36
#: pkg/kubectl/cmd/create_service.go:37
msgid "Create a service using specified subcommand."
msgstr "Create a service using specified subcommand."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L240
#: pkg/kubectl/cmd/create_service.go:241
msgid "Create an ExternalName service."
msgstr "Create an ExternalName service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/delete.go#L130
#: pkg/kubectl/cmd/delete.go:132
msgid ""
"Delete resources by filenames, stdin, resources and names, or by resources "
"and label selector"
msgstr ""
"Delete resources by filenames, stdin, resources and names, or by resources "
"and label selector"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/delete_cluster.go#L38
#: pkg/kubectl/cmd/config/delete_cluster.go:39
msgid "Delete the specified cluster from the kubeconfig"
msgstr "Delete the specified cluster from the kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/delete_context.go#L38
#: pkg/kubectl/cmd/config/delete_context.go:39
msgid "Delete the specified context from the kubeconfig"
msgstr "Delete the specified context from the kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/certificates.go#L121
#: pkg/kubectl/cmd/certificates.go:122
msgid "Deny a certificate signing request"
msgstr "Deny a certificate signing request"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/stop.go#L58
#: pkg/kubectl/cmd/stop.go:59
msgid "Deprecated: Gracefully shut down a resource by name or filename"
msgstr "Deprecated: Gracefully shut down a resource by name or filename"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/get_contexts.go#L62
#: pkg/kubectl/cmd/config/get_contexts.go:64
msgid "Describe one or many contexts"
msgstr "Describe one or many contexts"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/top_node.go#L77
#: pkg/kubectl/cmd/top_node.go:78
msgid "Display Resource (CPU/Memory) usage of nodes"
msgstr "Display Resource (CPU/Memory) usage of nodes"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/top_pod.go#L79
#: pkg/kubectl/cmd/top_pod.go:80
msgid "Display Resource (CPU/Memory) usage of pods"
msgstr "Display Resource (CPU/Memory) usage of pods"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/top.go#L43
#: pkg/kubectl/cmd/top.go:44
msgid "Display Resource (CPU/Memory) usage."
msgstr "Display Resource (CPU/Memory) usage."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/clusterinfo.go#L49
#: pkg/kubectl/cmd/clusterinfo.go:51
msgid "Display cluster info"
msgstr "Display cluster info"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/get_clusters.go#L40
#: pkg/kubectl/cmd/config/get_clusters.go:41
msgid "Display clusters defined in the kubeconfig"
msgstr "Display clusters defined in the kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/view.go#L64
#: pkg/kubectl/cmd/config/view.go:67
msgid "Display merged kubeconfig settings or a specified kubeconfig file"
msgstr "Display merged kubeconfig settings or a specified kubeconfig file"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/get.go#L107
#: pkg/kubectl/cmd/get.go:111
msgid "Display one or many resources"
msgstr "Display one or many resources"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/current_context.go#L48
#: pkg/kubectl/cmd/config/current_context.go:49
msgid "Displays the current-context"
msgstr "Displays the current-context"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/explain.go#L50
#: pkg/kubectl/cmd/explain.go:51
msgid "Documentation of resources"
msgstr "Documentation of resources"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L176
#: pkg/kubectl/cmd/drain.go:178
msgid "Drain node in preparation for maintenance"
msgstr "Drain node in preparation for maintenance"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/clusterinfo_dump.go#L37
#: pkg/kubectl/cmd/clusterinfo_dump.go:39
msgid "Dump lots of relevant info for debugging and diagnosis"
msgstr "Dump lots of relevant info for debugging and diagnosis"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/edit.go#L100
#: pkg/kubectl/cmd/edit.go:110
msgid "Edit a resource on the server"
msgstr "Edit a resource on the server"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L159
#: pkg/kubectl/cmd/create_secret.go:160
msgid "Email for Docker registry"
msgstr "Email for Docker registry"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/exec.go#L68
#: pkg/kubectl/cmd/exec.go:69
msgid "Execute a command in a container"
msgstr "Execute a command in a container"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L102
#: pkg/kubectl/cmd/rollingupdate.go:103
msgid ""
"Explicit policy for when to pull container images. Required when --image is "
"same as existing image, ignored otherwise."
msgstr ""
"Explicit policy for when to pull container images. Required when --image is "
"same as existing image, ignored otherwise."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/portforward.go#L75
#: pkg/kubectl/cmd/portforward.go:76
msgid "Forward one or more local ports to a pod"
msgstr "Forward one or more local ports to a pod"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/help.go#L36
#: pkg/kubectl/cmd/help.go:37
msgid "Help about any command"
msgstr "Help about any command"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L105
#: pkg/kubectl/cmd/expose.go:103
msgid ""
"IP to assign to the Load Balancer. If empty, an ephemeral IP will be created "
"and used (cloud-provider specific)."
msgstr ""
"IP to assign to the Load Balancer. If empty, an ephemeral IP will be created "
"and used (cloud-provider specific)."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L114
#: pkg/kubectl/cmd/expose.go:112
msgid ""
"If non-empty, set the session affinity for the service to this; legal "
"values: 'None', 'ClientIP'"
msgstr ""
"If non-empty, set the session affinity for the service to this; legal "
"values: 'None', 'ClientIP'"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/annotate.go#L135
#: pkg/kubectl/cmd/annotate.go:136
msgid ""
"If non-empty, the annotation update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."
msgstr ""
"If non-empty, the annotation update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/label.go#L132
#: pkg/kubectl/cmd/label.go:134
msgid ""
"If non-empty, the labels update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."
msgstr ""
"If non-empty, the labels update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L98
#: pkg/kubectl/cmd/rollingupdate.go:99
msgid ""
"Image to use for upgrading the replication controller. Must be distinct from "
"the existing image (either new image or new image tag).  Can not be used "
"with --filename/-f"
msgstr ""
"Image to use for upgrading the replication controller. Must be distinct from "
"the existing image (either new image or new image tag).  Can not be used "
"with --filename/-f"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout.go#L46
#: pkg/kubectl/cmd/rollout/rollout.go:47
msgid "Manage a deployment rollout"
msgstr "Manage a deployment rollout"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L127
#: pkg/kubectl/cmd/drain.go:128
msgid "Mark node as schedulable"
msgstr "Mark node as schedulable"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L102
#: pkg/kubectl/cmd/drain.go:103
msgid "Mark node as unschedulable"
msgstr "Mark node as unschedulable"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_pause.go#L73
#: pkg/kubectl/cmd/rollout/rollout_pause.go:74
msgid "Mark the provided resource as paused"
msgstr "Mark the provided resource as paused"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/certificates.go#L35
#: pkg/kubectl/cmd/certificates.go:36
msgid "Modify certificate resources."
msgstr "Modify certificate resources."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/config.go#L39
#: pkg/kubectl/cmd/config/config.go:40
msgid "Modify kubeconfig files"
msgstr "Modify kubeconfig files"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L110
#: pkg/kubectl/cmd/expose.go:108
msgid ""
"Name or number for the port on the container that the service should direct "
"traffic to. Optional."
msgstr ""
"Name or number for the port on the container that the service should direct "
"traffic to. Optional."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/logs.go#L108
#: pkg/kubectl/cmd/logs.go:113
msgid ""
"Only return logs after a specific date (RFC3339). Defaults to all logs. Only "
"one of since-time / since may be used."
msgstr ""
"Only return logs after a specific date (RFC3339). Defaults to all logs. Only "
"one of since-time / since may be used."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/completion.go#L97
#: pkg/kubectl/cmd/completion.go:104
msgid "Output shell completion code for the specified shell (bash or zsh)"
msgstr "Output shell completion code for the specified shell (bash or zsh)"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/edit.go#L115
#: pkg/kubectl/cmd/convert.go:85
msgid ""
"Output the formatted object with the given group version (for ex: "
"'extensions/v1beta1').)"
msgstr ""
"Output the formatted object with the given group version (for ex: "
"'extensions/v1beta1').)"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L157
#: pkg/kubectl/cmd/create_secret.go:158
msgid "Password for Docker registry authentication"
msgstr "Password for Docker registry authentication"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L226
#: pkg/kubectl/cmd/create_secret.go:226
msgid "Path to PEM encoded public key certificate."
msgstr "Path to PEM encoded public key certificate."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L227
#: pkg/kubectl/cmd/create_secret.go:227
msgid "Path to private key associated with given certificate."
msgstr "Path to private key associated with given certificate."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L84
#: pkg/kubectl/cmd/rollingupdate.go:85
msgid "Perform a rolling update of the given ReplicationController"
msgstr "Perform a rolling update of the given ReplicationController"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/scale.go#L82
#: pkg/kubectl/cmd/scale.go:83
msgid ""
"Precondition for resource version. Requires that the current resource "
"version match this value in order to scale."
msgstr ""
"Precondition for resource version. Requires that the current resource "
"version match this value in order to scale."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/version.go#L39
#: pkg/kubectl/cmd/version.go:40
msgid "Print the client and server version information"
msgstr "Print the client and server version information"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/options.go#L37
#: pkg/kubectl/cmd/options.go:38
msgid "Print the list of flags inherited by all commands"
msgstr "Print the list of flags inherited by all commands"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/logs.go#L86
#: pkg/kubectl/cmd/logs.go:93
msgid "Print the logs for a container in a pod"
msgstr "Print the logs for a container in a pod"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/replace.go#L70
#: pkg/kubectl/cmd/replace.go:71
msgid "Replace a resource by filename or stdin"
msgstr "Replace a resource by filename or stdin"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_resume.go#L71
#: pkg/kubectl/cmd/rollout/rollout_resume.go:72
msgid "Resume a paused resource"
msgstr "Resume a paused resource"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_rolebinding.go#L56
#: pkg/kubectl/cmd/create_rolebinding.go:57
msgid "Role this RoleBinding should reference"
msgstr "Role this RoleBinding should reference"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L94
#: pkg/kubectl/cmd/run.go:97
msgid "Run a particular image on the cluster"
msgstr "Run a particular image on the cluster"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/proxy.go#L68
#: pkg/kubectl/cmd/proxy.go:69
msgid "Run a proxy to the Kubernetes API server"
msgstr "Run a proxy to the Kubernetes API server"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L161
#: pkg/kubectl/cmd/create_secret.go:161
msgid "Server location for Docker registry"
msgstr "Server location for Docker registry"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/scale.go#L71
#: pkg/kubectl/cmd/scale.go:71
msgid ""
"Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job"
msgstr ""
"Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/set/set.go#L37
#: pkg/kubectl/cmd/set/set.go:38
msgid "Set specific features on objects"
msgstr "Set specific features on objects"

#: pkg/kubectl/cmd/apply_set_last_applied.go:83
msgid ""
"Set the last-applied-configuration annotation on a live object to match the "
"contents of a file."
msgstr ""
"Set the last-applied-configuration annotation on a live object to match the "
"contents of a file."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/set/set_selector.go#L81
#: pkg/kubectl/cmd/set/set_selector.go:82
msgid "Set the selector on a resource"
msgstr "Set the selector on a resource"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_cluster.go#L67
#: pkg/kubectl/cmd/config/create_cluster.go:68
msgid "Sets a cluster entry in kubeconfig"
msgstr "Sets a cluster entry in kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_context.go#L57
#: pkg/kubectl/cmd/config/create_context.go:58
msgid "Sets a context entry in kubeconfig"
msgstr "Sets a context entry in kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_authinfo.go#L103
#: pkg/kubectl/cmd/config/create_authinfo.go:104
msgid "Sets a user entry in kubeconfig"
msgstr "Sets a user entry in kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/set.go#L59
#: pkg/kubectl/cmd/config/set.go:60
msgid "Sets an individual value in a kubeconfig file"
msgstr "Sets an individual value in a kubeconfig file"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/use_context.go#L48
#: pkg/kubectl/cmd/config/use_context.go:49
msgid "Sets the current-context in a kubeconfig file"
msgstr "Sets the current-context in a kubeconfig file"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/describe.go#L80
#: pkg/kubectl/cmd/describe.go:86
msgid "Show details of a specific resource or group of resources"
msgstr "Show details of a specific resource or group of resources"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_status.go#L57
#: pkg/kubectl/cmd/rollout/rollout_status.go:58
msgid "Show the status of the rollout"
msgstr "Show the status of the rollout"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L108
#: pkg/kubectl/cmd/expose.go:106
msgid "Synonym for --target-port"
msgstr "Synonym for --target-port"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L87
#: pkg/kubectl/cmd/expose.go:88
msgid ""
"Take a replication controller, service, deployment or pod and expose it as a "
"new Kubernetes Service"
msgstr ""
"Take a replication controller, service, deployment or pod and expose it as a "
"new Kubernetes Service"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L114
#: pkg/kubectl/cmd/run.go:117
msgid "The image for the container to run."
msgstr "The image for the container to run."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L116
#: pkg/kubectl/cmd/run.go:119
msgid ""
"The image pull policy for the container. If left empty, this value will not "
"be specified by the client and defaulted by the server"
msgstr ""
"The image pull policy for the container. If left empty, this value will not "
"be specified by the client and defaulted by the server"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L100
#: pkg/kubectl/cmd/rollingupdate.go:101
msgid ""
"The key to use to differentiate between two different controllers, default "
"'deployment'.  Only relevant when --image is specified, ignored otherwise"
msgstr ""
"The key to use to differentiate between two different controllers, default "
"'deployment'.  Only relevant when --image is specified, ignored otherwise"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_pdb.go#L62
#: pkg/kubectl/cmd/create_pdb.go:63
msgid ""
"The minimum number or percentage of available pods this budget requires."
msgstr ""
"The minimum number or percentage of available pods this budget requires."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L113
#: pkg/kubectl/cmd/expose.go:111
msgid "The name for the newly created object."
msgstr "The name for the newly created object."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/autoscale.go#L71
#: pkg/kubectl/cmd/autoscale.go:72
msgid ""
"The name for the newly created object. If not specified, the name of the "
"input resource will be used."
msgstr ""
"The name for the newly created object. If not specified, the name of the "
"input resource will be used."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L113
#: pkg/kubectl/cmd/run.go:116
msgid ""
"The name of the API generator to use, see http://kubernetes.io/docs/user-"
"guide/kubectl-conventions/#generators for a list."
msgstr ""
"The name of the API generator to use, see http://kubernetes.io/docs/user-"
"guide/kubectl-conventions/#generators for a list."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/autoscale.go#L66
#: pkg/kubectl/cmd/autoscale.go:67
msgid ""
"The name of the API generator to use. Currently there is only 1 generator."
msgstr ""
"The name of the API generator to use. Currently there is only 1 generator."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L98
#: pkg/kubectl/cmd/expose.go:99
msgid ""
"The name of the API generator to use. There are 2 generators: 'service/v1' "
"and 'service/v2'. The only difference between them is that service port in "
"v1 is named 'default', while it is left unnamed in v2. Default is 'service/"
"v2'."
msgstr ""
"The name of the API generator to use. There are 2 generators: 'service/v1' "
"and 'service/v2'. The only difference between them is that service port in "
"v1 is named 'default', while it is left unnamed in v2. Default is 'service/"
"v2'."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L133
#: pkg/kubectl/cmd/run.go:136
msgid ""
"The name of the generator to use for creating a service.  Only used if --"
"expose is true"
msgstr ""
"The name of the generator to use for creating a service.  Only used if --"
"expose is true"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L99
#: pkg/kubectl/cmd/expose.go:100
msgid "The network protocol for the service to be created. Default is 'TCP'."
msgstr "The network protocol for the service to be created. Default is 'TCP'."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L100
#: pkg/kubectl/cmd/expose.go:101
msgid ""
"The port that the service should serve on. Copied from the resource being "
"exposed, if unspecified"
msgstr ""
"The port that the service should serve on. Copied from the resource being "
"exposed, if unspecified"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L121
#: pkg/kubectl/cmd/run.go:124
msgid ""
"The port that this container exposes.  If --expose is true, this is also the "
"port used by the service that is created."
msgstr ""
"The port that this container exposes.  If --expose is true, this is also the "
"port used by the service that is created."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L131
#: pkg/kubectl/cmd/run.go:134
msgid ""
"The resource requirement limits for this container.  For example, 'cpu=200m,"
"memory=512Mi'.  Note that server side components may assign limits depending "
"on the server configuration, such as limit ranges."
msgstr ""
"The resource requirement limits for this container.  For example, 'cpu=200m,"
"memory=512Mi'.  Note that server side components may assign limits depending "
"on the server configuration, such as limit ranges."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L130
#: pkg/kubectl/cmd/run.go:133
msgid ""
"The resource requirement requests for this container.  For example, "
"'cpu=100m,memory=256Mi'.  Note that server side components may assign "
"requests depending on the server configuration, such as limit ranges."
msgstr ""
"The resource requirement requests for this container.  For example, "
"'cpu=100m,memory=256Mi'.  Note that server side components may assign "
"requests depending on the server configuration, such as limit ranges."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L128
#: pkg/kubectl/cmd/run.go:131
msgid ""
"The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  "
"If set to 'Always' a deployment is created, if set to 'OnFailure' a job is "
"created, if set to 'Never', a regular pod is created. For the latter two --"
"replicas must be 1.  Default 'Always', for CronJobs ` + "`" + `Never` + "`" + `."
msgstr ""
"The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  "
"If set to 'Always' a deployment is created, if set to 'OnFailure' a job is "
"created, if set to 'Never', a regular pod is created. For the latter two --"
"replicas must be 1.  Default 'Always', for CronJobs ` + "`" + `Never` + "`" + `."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L87
#: pkg/kubectl/cmd/create_secret.go:88
msgid "The type of secret to create"
msgstr "The type of secret to create"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L101
#: pkg/kubectl/cmd/expose.go:102
msgid ""
"Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is "
"'ClusterIP'."
msgstr ""
"Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is "
"'ClusterIP'."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_undo.go#L71
#: pkg/kubectl/cmd/rollout/rollout_undo.go:72
msgid "Undo a previous rollout"
msgstr "Undo a previous rollout"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/unset.go#L47
#: pkg/kubectl/cmd/config/unset.go:48
msgid "Unsets an individual value in a kubeconfig file"
msgstr "Unsets an individual value in a kubeconfig file"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/patch.go#L91
#: pkg/kubectl/cmd/patch.go:96
msgid "Update field(s) of a resource using strategic merge patch"
msgstr "Update field(s) of a resource using strategic merge patch"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/set/set_image.go#L94
#: pkg/kubectl/cmd/set/set_image.go:95
msgid "Update image of a pod template"
msgstr "Update image of a pod template"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/set/set_resources.go#L101
#: pkg/kubectl/cmd/set/set_resources.go:102
msgid "Update resource requests/limits on objects with pod templates"
msgstr "Update resource requests/limits on objects with pod templates"

#: pkg/kubectl/cmd/annotate.go:116
msgid "Update the annotations on a resource"
msgstr "Update the annotations on a resource"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/label.go#L109
#: pkg/kubectl/cmd/label.go:114
msgid "Update the labels on a resource"
msgstr "Update the labels on a resource"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/taint.go#L88
#: pkg/kubectl/cmd/taint.go:87
msgid "Update the taints on one or more nodes"
msgstr "Update the taints on one or more nodes"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L155
#: pkg/kubectl/cmd/create_secret.go:156
msgid "Username for Docker registry authentication"
msgstr "Username for Docker registry authentication"

#: pkg/kubectl/cmd/apply_view_last_applied.go:64
msgid "View latest last-applied-configuration annotations of a resource/object"
msgstr ""
"View latest last-applied-configuration annotations of a resource/object"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_history.go#L51
#: pkg/kubectl/cmd/rollout/rollout_history.go:52
msgid "View rollout history"
msgstr "View rollout history"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/clusterinfo_dump.go#L45
#: pkg/kubectl/cmd/clusterinfo_dump.go:46
msgid ""
"Where to output the files.  If empty or '-' uses stdout, otherwise creates a "
"directory hierarchy in that directory"
msgstr ""
"Where to output the files.  If empty or '-' uses stdout, otherwise creates a "
"directory hierarchy in that directory"

#: pkg/kubectl/cmd/run_test.go:85
msgid "dummy restart flag)"
msgstr "dummy restart flag)"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L253
#: pkg/kubectl/cmd/create_service.go:254
msgid "external name of service"
msgstr "external name of service"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/cmd.go#L217
#: pkg/kubectl/cmd/cmd.go:227
msgid "kubectl controls the Kubernetes cluster manager"
msgstr "kubectl controls the Kubernetes cluster manager"

#~ msgid ""
#~ "watch is only supported on individual resources and resource collections "
#~ "- %d resources were found"
#~ msgid_plural ""
#~ "watch is only supported on individual resources and resource collections "
#~ "- %d resources were found"
#~ msgstr[0] ""
#~ "watch is only supported on individual resources and resource collections "
#~ "- %d resource was found"
#~ msgstr[1] ""
#~ "watch is only supported on individual resources and resource collections "
#~ "- %d resources were found"
`)

func translationsKubectlDefaultLc_messagesK8sPoBytes() ([]byte, error) {
	return _translationsKubectlDefaultLc_messagesK8sPo, nil
}

func translationsKubectlDefaultLc_messagesK8sPo() (*asset, error) {
	bytes, err := translationsKubectlDefaultLc_messagesK8sPoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/default/LC_MESSAGES/k8s.po", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlEn_usLc_messagesK8sMo = []byte("\xde\x12\x04\x95\x00\x00\x00\x00\xeb\x00\x00\x00\x1c\x00\x00\x00t\a\x00\x009\x01\x00\x00\xcc\x0e\x00\x00\x00\x00\x00\x00\xb0\x13\x00\x00\xdc\x00\x00\x00\xb1\x13\x00\x00\xb6\x00\x00\x00\x8e\x14\x00\x00\v\x02\x00\x00E\x15\x00\x00\x1f\x01\x00\x00Q\x17\x00\x00z\x00\x00\x00q\x18\x00\x00_\x02\x00\x00\xec\x18\x00\x00\u007f\x01\x00\x00L\x1b\x00\x00\x8f\x01\x00\x00\xcc\x1c\x00\x00k\x01\x00\x00\\\x1e\x00\x00k\x01\x00\x00\xc8\x1f\x00\x00>\x01\x00\x004!\x00\x00\x03\x02\x00\x00s\"\x00\x00o\x01\x00\x00w$\x00\x00H\x05\x00\x00\xe7%\x00\x00g\x02\x00\x000+\x00\x00\x1b\x02\x00\x00\x98-\x00\x00q\x01\x00\x00\xb4/\x00\x00\xa8\x01\x00\x00&1\x00\x00\xd4\x01\x00\x00\xcf2\x00\x00\x02\x02\x00\x00\xa44\x00\x00\xb4\x00\x00\x00\xa76\x00\x00\xb7\x02\x00\x00\\7\x00\x00\x92\x03\x00\x00\x14:\x00\x00\xbf\x01\x00\x00\xa7=\x00\x00=\x00\x00\x00g?\x00\x00;\x00\x00\x00\xa5?\x00\x00\xcd\x02\x00\x00\xe1?\x00\x00<\x00\x00\x00\xafB\x00\x00P\x00\x00\x00\xecB\x00\x00S\x00\x00\x00=C\x00\x00<\x00\x00\x00\x91C\x00\x00\xac\x01\x00\x00\xceC\x00\x00\x13\x03\x00\x00{E\x00\x00\xea\x01\x00\x00\x8fH\x00\x00\xfa\x01\x00\x00zJ\x00\x00\xda\x01\x00\x00uL\x00\x00c\x01\x00\x00PN\x00\x00T\x01\x00\x00\xb4O\x00\x00\xba\x06\x00\x00\tQ\x00\x00\xf9\x01\x00\x00\xc4W\x00\x00\xe0\x02\x00\x00\xbeY\x00\x00\x02\x03\x00\x00\x9f\\\x00\x00\xfb\x00\x00\x00\xa2_\x00\x00\xa5\x01\x00\x00\x9e`\x00\x00\xb4\x01\x00\x00Db\x00\x00\x18\x00\x00\x00\xf9c\x00\x00<\x00\x00\x00\x12d\x00\x00=\x00\x00\x00Od\x00\x00\xc6\x00\x00\x00\x8dd\x00\x00g\x02\x00\x00Te\x00\x00.\x00\x00\x00\xbcg\x00\x001\x03\x00\x00\xebg\x00\x00g\x00\x00\x00\x1dk\x00\x00Q\x00\x00\x00\x85k\x00\x00R\x00\x00\x00\xd7k\x00\x00\"\x00\x00\x00*l\x00\x00X\x02\x00\x00Ml\x00\x004\x00\x00\x00\xa6n\x00\x00}\x00\x00\x00\xdbn\x00\x00k\x01\x00\x00Yo\x00\x00\x81\a\x00\x00\xc5p\x00\x00f\x01\x00\x00Gx\x00\x00\x85\x00\x00\x00\xaey\x00\x00\xea\x00\x00\x004z\x00\x00\xd9\x00\x00\x00\x1f{\x00\x00\n\x05\x00\x00\xf9{\x00\x00\x10\x05\x00\x00\x04\x81\x00\x00\x1c\x00\x00\x00\x15\x86\x00\x00\x1e\x00\x00\x002\x86\x00\x00\x98\x02\x00\x00Q\x86\x00\x00\xbc\x01\x00\x00\xea\x88\x00\x00\x9c\x01\x00\x00\xa7\x8a\x00\x00q\x01\x00\x00D\x8c\x00\x00\x05\x01\x00\x00\xb6\x8d\x00\x00\xdf\x01\x00\x00\xbc\x8e\x00\x00\x1c\x01\x00\x00\x9c\x90\x00\x00\xc1\x01\x00\x00\xb9\x91\x00\x00\x1b\x02\x00\x00{\x93\x00\x00\xc0\x00\x00\x00\x97\x95\x00\x00\xd5\x02\x00\x00X\x96\x00\x00\x9d\x00\x00\x00.\x99\x00\x00X\x00\x00\x00\u0319\x00\x00%\x02\x00\x00%\x9a\x00\x00o\x00\x00\x00K\x9c\x00\x00u\x00\x00\x00\xbb\x9c\x00\x00\x01\x01\x00\x001\x9d\x00\x00v\x00\x00\x003\x9e\x00\x00t\x00\x00\x00\xaa\x9e\x00\x00\xef\x00\x00\x00\x1f\x9f\x00\x00}\x00\x00\x00\x0f\xa0\x00\x00j\x00\x00\x00\x8d\xa0\x00\x00\xc4\x01\x00\x00\xf8\xa0\x00\x00\xf7\x03\x00\x00\xbd\xa2\x00\x00;\x00\x00\x00\xb5\xa6\x00\x008\x00\x00\x00\xf1\xa6\x00\x001\x00\x00\x00*\xa7\x00\x007\x00\x00\x00\\\xa7\x00\x00u\x02\x00\x00\x94\xa7\x00\x00\xb0\x00\x00\x00\n\xaa\x00\x00[\x00\x00\x00\xbb\xaa\x00\x00J\x00\x00\x00\x17\xab\x00\x00a\x00\x00\x00b\xab\x00\x00\xbd\x00\x00\x00\u012b\x00\x009\x00\x00\x00\x82\xac\x00\x00\xc5\x00\x00\x00\xbc\xac\x00\x00\xae\x00\x00\x00\x82\xad\x00\x00\xd6\x00\x00\x001\xae\x00\x008\x00\x00\x00\b\xaf\x00\x00%\x00\x00\x00A\xaf\x00\x00W\x00\x00\x00g\xaf\x00\x00\x1d\x00\x00\x00\xbf\xaf\x00\x00=\x00\x00\x00\u076f\x00\x00u\x00\x00\x00\x1b\xb0\x00\x004\x00\x00\x00\x91\xb0\x00\x00-\x00\x00\x00\u01b0\x00\x00\xa3\x00\x00\x00\xf4\xb0\x00\x003\x00\x00\x00\x98\xb1\x00\x002\x00\x00\x00\u0331\x00\x008\x00\x00\x00\xff\xb1\x00\x00\x1e\x00\x00\x008\xb2\x00\x00\x1a\x00\x00\x00W\xb2\x00\x009\x00\x00\x00r\xb2\x00\x00\x13\x00\x00\x00\xac\xb2\x00\x00\x1b\x00\x00\x00\xc0\xb2\x00\x00@\x00\x00\x00\u0732\x00\x00,\x00\x00\x00\x1d\xb3\x00\x00*\x00\x00\x00J\xb3\x00\x007\x00\x00\x00u\xb3\x00\x00'\x00\x00\x00\xad\xb3\x00\x00&\x00\x00\x00\u0573\x00\x00.\x00\x00\x00\xfc\xb3\x00\x00=\x00\x00\x00+\xb4\x00\x00*\x00\x00\x00i\xb4\x00\x000\x00\x00\x00\x94\xb4\x00\x00,\x00\x00\x00\u0174\x00\x00\x1f\x00\x00\x00\xf2\xb4\x00\x00]\x00\x00\x00\x12\xb5\x00\x000\x00\x00\x00p\xb5\x00\x000\x00\x00\x00\xa1\xb5\x00\x00\"\x00\x00\x00\u04b5\x00\x00?\x00\x00\x00\xf5\xb5\x00\x00\x1d\x00\x00\x005\xb6\x00\x00,\x00\x00\x00S\xb6\x00\x00+\x00\x00\x00\x80\xb6\x00\x00$\x00\x00\x00\xac\xb6\x00\x00\x14\x00\x00\x00\u0476\x00\x00*\x00\x00\x00\xe6\xb6\x00\x00A\x00\x00\x00\x11\xb7\x00\x00\x1d\x00\x00\x00S\xb7\x00\x00\x1c\x00\x00\x00q\xb7\x00\x00\x1a\x00\x00\x00\x8e\xb7\x00\x00)\x00\x00\x00\xa9\xb7\x00\x006\x00\x00\x00\u04f7\x00\x00\x1d\x00\x00\x00\n\xb8\x00\x00\x19\x00\x00\x00(\xb8\x00\x00 \x00\x00\x00B\xb8\x00\x00v\x00\x00\x00c\xb8\x00\x00(\x00\x00\x00\u06b8\x00\x00\x16\x00\x00\x00\x03\xb9\x00\x00p\x00\x00\x00\x1a\xb9\x00\x00`\x00\x00\x00\x8b\xb9\x00\x00\x9b\x00\x00\x00\xec\xb9\x00\x00\x97\x00\x00\x00\x88\xba\x00\x00\xa8\x00\x00\x00 \xbb\x00\x00\x1b\x00\x00\x00\u027b\x00\x00\x18\x00\x00\x00\xe5\xbb\x00\x00\x1a\x00\x00\x00\xfe\xbb\x00\x00$\x00\x00\x00\x19\xbc\x00\x00\x1d\x00\x00\x00>\xbc\x00\x00\x17\x00\x00\x00\\\xbc\x00\x00a\x00\x00\x00t\xbc\x00\x00s\x00\x00\x00\u05bc\x00\x00B\x00\x00\x00J\xbd\x00\x00Y\x00\x00\x00\x8d\xbd\x00\x00+\x00\x00\x00\xe7\xbd\x00\x00+\x00\x00\x00\x13\xbe\x00\x006\x00\x00\x00?\xbe\x00\x00;\x00\x00\x00v\xbe\x00\x00q\x00\x00\x00\xb2\xbe\x00\x00/\x00\x00\x00$\xbf\x00\x001\x00\x00\x00T\xbf\x00\x00'\x00\x00\x00\x86\xbf\x00\x00'\x00\x00\x00\xae\xbf\x00\x00\x18\x00\x00\x00\u05bf\x00\x00&\x00\x00\x00\xef\xbf\x00\x00%\x00\x00\x00\x16\xc0\x00\x00(\x00\x00\x00<\xc0\x00\x00#\x00\x00\x00e\xc0\x00\x00K\x00\x00\x00\x89\xc0\x00\x00 \x00\x00\x00\xd5\xc0\x00\x00_\x00\x00\x00\xf6\xc0\x00\x00\x1e\x00\x00\x00V\xc1\x00\x00\"\x00\x00\x00u\xc1\x00\x00\"\x00\x00\x00\x98\xc1\x00\x00\x1f\x00\x00\x00\xbb\xc1\x00\x00-\x00\x00\x00\xdb\xc1\x00\x00-\x00\x00\x00\t\xc2\x00\x009\x00\x00\x007\xc2\x00\x00\x1e\x00\x00\x00q\xc2\x00\x00\x19\x00\x00\x00\x90\xc2\x00\x00c\x00\x00\x00\xaa\xc2\x00\x00#\x00\x00\x00\x0e\xc3\x00\x00\x82\x00\x00\x002\xc3\x00\x00\x94\x00\x00\x00\xb5\xc3\x00\x00H\x00\x00\x00J\xc4\x00\x00&\x00\x00\x00\x93\xc4\x00\x00e\x00\x00\x00\xba\xc4\x00\x00z\x00\x00\x00 \xc5\x00\x00J\x00\x00\x00\x9b\xc5\x00\x00\xe5\x00\x00\x00\xe6\xc5\x00\x00W\x00\x00\x00\xcc\xc6\x00\x00E\x00\x00\x00$\xc7\x00\x00a\x00\x00\x00j\xc7\x00\x00v\x00\x00\x00\xcc\xc7\x00\x00\xcb\x00\x00\x00C\xc8\x00\x00\xcf\x00\x00\x00\x0f\xc9\x00\x00\x1e\x01\x00\x00\xdf\xc9\x00\x00\x1c\x00\x00\x00\xfe\xca\x00\x00T\x00\x00\x00\x1b\xcb\x00\x00\x17\x00\x00\x00p\xcb\x00\x00/\x00\x00\x00\x88\xcb\x00\x009\x00\x00\x00\xb8\xcb\x00\x00\x1e\x00\x00\x00\xf2\xcb\x00\x00=\x00\x00\x00\x11\xcc\x00\x00$\x00\x00\x00O\xcc\x00\x00\x1f\x00\x00\x00t\xcc\x00\x00&\x00\x00\x00\x94\xcc\x00\x00+\x00\x00\x00\xbb\xcc\x00\x00G\x00\x00\x00\xe7\xcc\x00\x00\x14\x00\x00\x00/\xcd\x00\x00r\x00\x00\x00D\xcd\x00\x00\x13\x00\x00\x00\xb7\xcd\x00\x00\x18\x00\x00\x00\xcb\xcd\x00\x00/\x00\x00\x00\xe4\xcd\x00\x00\xb1\x01\x00\x00\x14\xce\x00\x00\xdc\x00\x00\x00\xc6\xcf\x00\x00\xb6\x00\x00\x00\xa3\xd0\x00\x00\v\x02\x00\x00Z\xd1\x00\x00\x1f\x01\x00\x00f\xd3\x00\x00z\x00\x00\x00\x86\xd4\x00\x00_\x02\x00\x00\x01\xd5\x00\x00\u007f\x01\x00\x00a\xd7\x00\x00\x8f\x01\x00\x00\xe1\xd8\x00\x00k\x01\x00\x00q\xda\x00\x00k\x01\x00\x00\xdd\xdb\x00\x00>\x01\x00\x00I\xdd\x00\x00\x03\x02\x00\x00\x88\xde\x00\x00o\x01\x00\x00\x8c\xe0\x00\x00H\x05\x00\x00\xfc\xe1\x00\x00g\x02\x00\x00E\xe7\x00\x00\x1b\x02\x00\x00\xad\xe9\x00\x00q\x01\x00\x00\xc9\xeb\x00\x00\xa8\x01\x00\x00;\xed\x00\x00\xd4\x01\x00\x00\xe4\xee\x00\x00\x02\x02\x00\x00\xb9\xf0\x00\x00\xb4\x00\x00\x00\xbc\xf2\x00\x00\xb7\x02\x00\x00q\xf3\x00\x00\x92\x03\x00\x00)\xf6\x00\x00\xbf\x01\x00\x00\xbc\xf9\x00\x00=\x00\x00\x00|\xfb\x00\x00;\x00\x00\x00\xba\xfb\x00\x00\xcd\x02\x00\x00\xf6\xfb\x00\x00<\x00\x00\x00\xc4\xfe\x00\x00P\x00\x00\x00\x01\xff\x00\x00S\x00\x00\x00R\xff\x00\x00<\x00\x00\x00\xa6\xff\x00\x00\xac\x01\x00\x00\xe3\xff\x00\x00\x13\x03\x00\x00\x90\x01\x01\x00\xea\x01\x00\x00\xa4\x04\x01\x00\xfa\x01\x00\x00\x8f\x06\x01\x00\xda\x01\x00\x00\x8a\b\x01\x00c\x01\x00\x00e\n\x01\x00T\x01\x00\x00\xc9\v\x01\x00\xba\x06\x00\x00\x1e\r\x01\x00\xf9\x01\x00\x00\xd9\x13\x01\x00\xe0\x02\x00\x00\xd3\x15\x01\x00\x02\x03\x00\x00\xb4\x18\x01\x00\xfb\x00\x00\x00\xb7\x1b\x01\x00\xa5\x01\x00\x00\xb3\x1c\x01\x00\xb4\x01\x00\x00Y\x1e\x01\x00\x18\x00\x00\x00\x0e \x01\x00<\x00\x00\x00' \x01\x00=\x00\x00\x00d \x01\x00\xc6\x00\x00\x00\xa2 \x01\x00g\x02\x00\x00i!\x01\x00.\x00\x00\x00\xd1#\x01\x001\x03\x00\x00\x00$\x01\x00g\x00\x00\x002'\x01\x00Q\x00\x00\x00\x9a'\x01\x00R\x00\x00\x00\xec'\x01\x00\"\x00\x00\x00?(\x01\x00X\x02\x00\x00b(\x01\x004\x00\x00\x00\xbb*\x01\x00}\x00\x00\x00\xf0*\x01\x00k\x01\x00\x00n+\x01\x00\x81\a\x00\x00\xda,\x01\x00f\x01\x00\x00\\4\x01\x00\x85\x00\x00\x00\xc35\x01\x00\xea\x00\x00\x00I6\x01\x00\xd9\x00\x00\x0047\x01\x00\n\x05\x00\x00\x0e8\x01\x00\x10\x05\x00\x00\x19=\x01\x00\x1c\x00\x00\x00*B\x01\x00\x1e\x00\x00\x00GB\x01\x00\x98\x02\x00\x00fB\x01\x00\xbc\x01\x00\x00\xffD\x01\x00\x9c\x01\x00\x00\xbcF\x01\x00q\x01\x00\x00YH\x01\x00\x05\x01\x00\x00\xcbI\x01\x00\xdf\x01\x00\x00\xd1J\x01\x00\x1c\x01\x00\x00\xb1L\x01\x00\xc1\x01\x00\x00\xceM\x01\x00\x1b\x02\x00\x00\x90O\x01\x00\xc0\x00\x00\x00\xacQ\x01\x00\xd5\x02\x00\x00mR\x01\x00\x9d\x00\x00\x00CU\x01\x00X\x00\x00\x00\xe1U\x01\x00%\x02\x00\x00:V\x01\x00o\x00\x00\x00`X\x01\x00u\x00\x00\x00\xd0X\x01\x00\x01\x01\x00\x00FY\x01\x00v\x00\x00\x00HZ\x01\x00t\x00\x00\x00\xbfZ\x01\x00\xef\x00\x00\x004[\x01\x00}\x00\x00\x00$\\\x01\x00j\x00\x00\x00\xa2\\\x01\x00\xc4\x01\x00\x00\r]\x01\x00\xf7\x03\x00\x00\xd2^\x01\x00;\x00\x00\x00\xcab\x01\x008\x00\x00\x00\x06c\x01\x001\x00\x00\x00?c\x01\x007\x00\x00\x00qc\x01\x00u\x02\x00\x00\xa9c\x01\x00\xb0\x00\x00\x00\x1ff\x01\x00[\x00\x00\x00\xd0f\x01\x00J\x00\x00\x00,g\x01\x00a\x00\x00\x00wg\x01\x00\xbd\x00\x00\x00\xd9g\x01\x009\x00\x00\x00\x97h\x01\x00\xc5\x00\x00\x00\xd1h\x01\x00\xae\x00\x00\x00\x97i\x01\x00\xd6\x00\x00\x00Fj\x01\x008\x00\x00\x00\x1dk\x01\x00%\x00\x00\x00Vk\x01\x00W\x00\x00\x00|k\x01\x00\x1d\x00\x00\x00\xd4k\x01\x00=\x00\x00\x00\xf2k\x01\x00u\x00\x00\x000l\x01\x004\x00\x00\x00\xa6l\x01\x00-\x00\x00\x00\xdbl\x01\x00\xa3\x00\x00\x00\tm\x01\x003\x00\x00\x00\xadm\x01\x002\x00\x00\x00\xe1m\x01\x008\x00\x00\x00\x14n\x01\x00\x1e\x00\x00\x00Mn\x01\x00\x1a\x00\x00\x00ln\x01\x009\x00\x00\x00\x87n\x01\x00\x13\x00\x00\x00\xc1n\x01\x00\x1b\x00\x00\x00\xd5n\x01\x00@\x00\x00\x00\xf1n\x01\x00,\x00\x00\x002o\x01\x00*\x00\x00\x00_o\x01\x007\x00\x00\x00\x8ao\x01\x00'\x00\x00\x00\xc2o\x01\x00&\x00\x00\x00\xeao\x01\x00.\x00\x00\x00\x11p\x01\x00=\x00\x00\x00@p\x01\x00*\x00\x00\x00~p\x01\x000\x00\x00\x00\xa9p\x01\x00,\x00\x00\x00\xdap\x01\x00\x1f\x00\x00\x00\aq\x01\x00]\x00\x00\x00'q\x01\x000\x00\x00\x00\x85q\x01\x000\x00\x00\x00\xb6q\x01\x00\"\x00\x00\x00\xe7q\x01\x00?\x00\x00\x00\nr\x01\x00\x1d\x00\x00\x00Jr\x01\x00,\x00\x00\x00hr\x01\x00+\x00\x00\x00\x95r\x01\x00$\x00\x00\x00\xc1r\x01\x00\x14\x00\x00\x00\xe6r\x01\x00*\x00\x00\x00\xfbr\x01\x00A\x00\x00\x00&s\x01\x00\x1d\x00\x00\x00hs\x01\x00\x1c\x00\x00\x00\x86s\x01\x00\x1a\x00\x00\x00\xa3s\x01\x00)\x00\x00\x00\xbes\x01\x006\x00\x00\x00\xe8s\x01\x00\x1d\x00\x00\x00\x1ft\x01\x00\x19\x00\x00\x00=t\x01\x00 \x00\x00\x00Wt\x01\x00v\x00\x00\x00xt\x01\x00(\x00\x00\x00\xeft\x01\x00\x16\x00\x00\x00\x18u\x01\x00p\x00\x00\x00/u\x01\x00`\x00\x00\x00\xa0u\x01\x00\x9b\x00\x00\x00\x01v\x01\x00\x97\x00\x00\x00\x9dv\x01\x00\xa8\x00\x00\x005w\x01\x00\x1b\x00\x00\x00\xdew\x01\x00\x18\x00\x00\x00\xfaw\x01\x00\x1a\x00\x00\x00\x13x\x01\x00$\x00\x00\x00.x\x01\x00\x1d\x00\x00\x00Sx\x01\x00\x17\x00\x00\x00qx\x01\x00a\x00\x00\x00\x89x\x01\x00s\x00\x00\x00\xebx\x01\x00B\x00\x00\x00_y\x01\x00Y\x00\x00\x00\xa2y\x01\x00+\x00\x00\x00\xfcy\x01\x00+\x00\x00\x00(z\x01\x006\x00\x00\x00Tz\x01\x00;\x00\x00\x00\x8bz\x01\x00q\x00\x00\x00\xc7z\x01\x00/\x00\x00\x009{\x01\x001\x00\x00\x00i{\x01\x00'\x00\x00\x00\x9b{\x01\x00'\x00\x00\x00\xc3{\x01\x00\x18\x00\x00\x00\xeb{\x01\x00&\x00\x00\x00\x04|\x01\x00%\x00\x00\x00+|\x01\x00(\x00\x00\x00Q|\x01\x00#\x00\x00\x00z|\x01\x00K\x00\x00\x00\x9e|\x01\x00 \x00\x00\x00\xea|\x01\x00_\x00\x00\x00\v}\x01\x00\x1e\x00\x00\x00k}\x01\x00\"\x00\x00\x00\x8a}\x01\x00\"\x00\x00\x00\xad}\x01\x00\x1f\x00\x00\x00\xd0}\x01\x00-\x00\x00\x00\xf0}\x01\x00-\x00\x00\x00\x1e~\x01\x009\x00\x00\x00L~\x01\x00\x1e\x00\x00\x00\x86~\x01\x00\x19\x00\x00\x00\xa5~\x01\x00c\x00\x00\x00\xbf~\x01\x00#\x00\x00\x00#\u007f\x01\x00\x82\x00\x00\x00G\u007f\x01\x00\x94\x00\x00\x00\xca\u007f\x01\x00H\x00\x00\x00_\x80\x01\x00&\x00\x00\x00\xa8\x80\x01\x00e\x00\x00\x00\u03c0\x01\x00z\x00\x00\x005\x81\x01\x00J\x00\x00\x00\xb0\x81\x01\x00\xe5\x00\x00\x00\xfb\x81\x01\x00W\x00\x00\x00\xe1\x82\x01\x00E\x00\x00\x009\x83\x01\x00a\x00\x00\x00\u007f\x83\x01\x00v\x00\x00\x00\xe1\x83\x01\x00\xcb\x00\x00\x00X\x84\x01\x00\xcf\x00\x00\x00$\x85\x01\x00\x1e\x01\x00\x00\xf4\x85\x01\x00\x1c\x00\x00\x00\x13\x87\x01\x00T\x00\x00\x000\x87\x01\x00\x17\x00\x00\x00\x85\x87\x01\x00/\x00\x00\x00\x9d\x87\x01\x009\x00\x00\x00\u0347\x01\x00\x1e\x00\x00\x00\a\x88\x01\x00=\x00\x00\x00&\x88\x01\x00$\x00\x00\x00d\x88\x01\x00\x1f\x00\x00\x00\x89\x88\x01\x00&\x00\x00\x00\xa9\x88\x01\x00+\x00\x00\x00\u0408\x01\x00G\x00\x00\x00\xfc\x88\x01\x00\x14\x00\x00\x00D\x89\x01\x00r\x00\x00\x00Y\x89\x01\x00\x13\x00\x00\x00\u0309\x01\x00\x18\x00\x00\x00\xe0\x89\x01\x00/\x00\x00\x00\xf9\x89\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00^\x00\x00\x00\\\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\x00\x00\x00\xc4\x00\x00\x00\x0f\x00\x00\x00\xc3\x00\x00\x00\x00\x00\x00\x00-\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\xeb\x00\x00\x00c\x00\x00\x00\x00\x00\x00\x001\x00\x00\x00o\x00\x00\x00}\x00\x00\x00\x00\x00\x00\x00J\x00\x00\x00\x00\x00\x00\x00\xd8\x00\x00\x00\x98\x00\x00\x00U\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdb\x00\x00\x00\x17\x00\x00\x00u\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc9\x00\x00\x00\xb7\x00\x00\x00\xd7\x00\x00\x00*\x00\x00\x00\x99\x00\x00\x00\x00\x00\x00\x00\x1f\x00\x00\x00\x84\x00\x00\x00\x9c\x00\x00\x00\xe6\x00\x00\x00\x9d\x00\x00\x00\xc5\x00\x00\x00\xd9\x00\x00\x00\xb9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x19\x00\x00\x00\xcd\x00\x00\x00\xcb\x00\x00\x00y\x00\x00\x00\x97\x00\x00\x00\xba\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00C\x00\x00\x00\x93\x00\x00\x00\xad\x00\x00\x00\xe1\x00\x00\x00\xa6\x00\x00\x00\xd0\x00\x00\x00r\x00\x00\x00+\x00\x00\x006\x00\x00\x00\x00\x00\x00\x00\xa5\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00h\x00\x00\x00\xa0\x00\x00\x00\x00\x00\x00\x00\xd1\x00\x00\x00\xde\x00\x00\x00;\x00\x00\x00\x00\x00\x00\x00\xe9\x00\x00\x00\xe7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00z\x00\x00\x00/\x00\x00\x00V\x00\x00\x00\x8d\x00\x00\x00\xe3\x00\x00\x00!\x00\x00\x00~\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd3\x00\x00\x00\x88\x00\x00\x00l\x00\x00\x00s\x00\x00\x00g\x00\x00\x00\x05\x00\x00\x00\xc6\x00\x00\x00#\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\xb1\x00\x00\x00\x00\x00\x00\x00\xc2\x00\x00\x00\x13\x00\x00\x00S\x00\x00\x00G\x00\x00\x00$\x00\x00\x00\xc1\x00\x00\x00\xb5\x00\x00\x00X\x00\x00\x00m\x00\x00\x00\t\x00\x00\x00x\x00\x00\x00\xb8\x00\x00\x00\xbd\x00\x00\x00k\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<\x00\x00\x00E\x00\x00\x00\xbf\x00\x00\x00\xbc\x00\x00\x00\x00\x00\x00\x00:\x00\x00\x00\x82\x00\x00\x00\x81\x00\x00\x00&\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x00\x00[\x00\x00\x00I\x00\x00\x00e\x00\x00\x00\x04\x00\x00\x00>\x00\x00\x00\b\x00\x00\x00\x94\x00\x00\x00\x8f\x00\x00\x00\xce\x00\x00\x00?\x00\x00\x00Y\x00\x00\x00\xda\x00\x00\x00\x15\x00\x00\x00\x00\x00\x00\x00'\x00\x00\x004\x00\x00\x00\xcc\x00\x00\x00\f\x00\x00\x005\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\xbb\x00\x00\x00\x00\x00\x00\x00\xa9\x00\x00\x00\x9e\x00\x00\x00\x00\x00\x00\x00\xe5\x00\x00\x00\x00\x00\x00\x00O\x00\x00\x00 \x00\x00\x00)\x00\x00\x00\xcf\x00\x00\x00\x00\x00\x00\x00\x1b\x00\x00\x00Z\x00\x00\x00\"\x00\x00\x00\x00\x00\x00\x00v\x00\x00\x00]\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00a\x00\x00\x00j\x00\x00\x008\x00\x00\x00\xa3\x00\x00\x00q\x00\x00\x00t\x00\x00\x00_\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\v\x00\x00\x00@\x00\x00\x00\xd2\x00\x00\x00,\x00\x00\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\xc8\x00\x00\x00\x95\x00\x00\x00\x06\x00\x00\x00\xa8\x00\x00\x00\xae\x00\x00\x00\xa1\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x0e\x00\x00\x00{\x00\x00\x00\xa7\x00\x00\x00\x00\x00\x00\x00\xb6\x00\x00\x00i\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd5\x00\x00\x00L\x00\x00\x00\x00\x00\x00\x00\xea\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00w\x00\x00\x00\x12\x00\x00\x00=\x00\x00\x00\xaf\x00\x00\x00\a\x00\x00\x00\xdf\x00\x00\x00\xc0\x00\x00\x00N\x00\x00\x00%\x00\x00\x009\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00.\x00\x00\x00\x00\x00\x00\x00\u007f\x00\x00\x00\xbe\x00\x00\x00\xe2\x00\x00\x00\x00\x00\x00\x00P\x00\x00\x00\xb3\x00\x00\x00\r\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00R\x00\x00\x00D\x00\x00\x00B\x00\x00\x00n\x00\x00\x00\x00\x00\x00\x00\xd6\x00\x00\x00\x83\x00\x00\x00\n\x00\x00\x00W\x00\x00\x00\x14\x00\x00\x00Q\x00\x00\x00\xd4\x00\x00\x00d\x00\x00\x00\xac\x00\x00\x00\x16\x00\x00\x00\x96\x00\x00\x00K\x00\x00\x002\x00\x00\x00\x1a\x00\x00\x00\xb4\x00\x00\x00f\x00\x00\x00\xa2\x00\x00\x00\xe8\x00\x00\x00\x02\x00\x00\x00A\x00\x00\x00\xe4\x00\x00\x00\x8c\x00\x00\x00\x9a\x00\x00\x00`\x00\x00\x00\xab\x00\x00\x00M\x00\x00\x007\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\xdc\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x00\x00\x89\x00\x00\x00\x00\x00\x00\x00\xdd\x00\x00\x00\x8e\x00\x00\x00\xca\x00\x00\x00H\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x00\x00\x00\x00\x00\x00\x1c\x00\x00\x00\xb0\x00\x00\x00\x00\x00\x00\x00|\x00\x00\x003\x00\x00\x00T\x00\x00\x00\x87\x00\x00\x00b\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\xaa\x00\x00\x00\xa4\x00\x00\x00\x00\x00\x00\x00p\x00\x00\x00\xc7\x00\x00\x00\x8b\x00\x00\x00\x00\n\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the cluster-admin ClusterRole\n\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin ClusterRole\n\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a new configmap named my-config based on folder bar\n\t\t  kubectl create configmap my-config --from-file=path/to/bar\n\n\t\t  # Create a new configmap named my-config with specified keys instead of file basenames on disk\n\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1.txt --from-file=key2=/path/to/bar/file2.txt\n\n\t\t  # Create a new configmap named my-config with key1=config1 and key2=config2\n\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-literal=key2=config2\x00\n\t\t  # If you don't already have a .dockercfg file, you can create a dockercfg secret directly by using:\n\t\t  kubectl create secret docker-registry my-secret --docker-server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL\x00\n\t\t  # Show metrics for all nodes\n\t\t  kubectl top node\n\n\t\t  # Show metrics for a given node\n\t\t  kubectl top node NODE_NAME\x00\n\t\t# Apply the configuration in pod.json to a pod.\n\t\tkubectl apply -f ./pod.json\n\n\t\t# Apply the JSON passed into stdin to a pod.\n\t\tcat pod.json | kubectl apply -f -\n\n\t\t# Note: --prune is still in Alpha\n\t\t# Apply the configuration in manifest.yaml that matches label app=nginx and delete all the other resources that are not in the file and match label app=nginx.\n\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n\n\t\t# Apply the configuration in manifest.yaml and delete all the other configmaps that are not in the file.\n\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/ConfigMap\x00\n\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and 10, no target CPU utilization specified so a default autoscaling policy will be used:\n\t\tkubectl autoscale deployment foo --min=2 --max=10\n\n\t\t# Auto scale a replication controller \"foo\", with the number of pods between 1 and 5, target CPU utilization at 80%:\n\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80\x00\n\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n\t\tkubectl convert -f pod.yaml\n\n\t\t# Convert the live state of the resource specified by 'pod.yaml' to the latest version\n\t\t# and print to stdout in json format.\n\t\tkubectl convert -f pod.yaml --local -o json\n\n\t\t# Convert all files under current directory to latest version and create them all.\n\t\tkubectl convert -f . | kubectl create -f -\x00\n\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods\n\n\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --resource=pods\n\n\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a new resourcequota named my-quota\n\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,replicationcontrollers=2,resourcequotas=1,secrets=5,persistentvolumeclaims=10\n\n\t\t# Create a new resourcequota named best-effort\n\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort\x00\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=rails label\n\t\t# and require at least one of them being available at any point in time.\n\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-available=1\n\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=nginx label\n\t\t# and require at least half of the pods selected to be available at any point in time.\n\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%\x00\n\t\t# Create a pod using the data in pod.json.\n\t\tkubectl create -f ./pod.json\n\n\t\t# Create a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl create -f -\n\n\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format then create the resource using the edited data.\n\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json\x00\n\t\t# Create a service for a replicated nginx, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rc nginx --port=80 --target-port=8000\n\n\t\t# Create a service for a replication controller identified by type and name specified in \"nginx-controller.yaml\", which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n\n\t\t# Create a service for a pod valid-pod, which serves on port 444 with the name \"frontend\"\n\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n\n\t\t# Create a second service based on the above service, exposing the container port 8443 as port 443 with the name \"nginx-https\"\n\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-https\n\n\t\t# Create a service for a replicated streaming application on port 4100 balancing UDP traffic and named 'video-stream'.\n\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-stream\n\n\t\t# Create a service for a replicated nginx using replica set, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rs nginx --port=80 --target-port=8000\n\n\t\t# Create a service for an nginx deployment, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose deployment nginx --port=80 --target-port=8000\x00\n\t\t# Delete a pod using the type and name specified in pod.json.\n\t\tkubectl delete -f ./pod.json\n\n\t\t# Delete a pod based on the type and name in the JSON passed into stdin.\n\t\tcat pod.json | kubectl delete -f -\n\n\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n\t\tkubectl delete pod,service baz foo\n\n\t\t# Delete pods and services with label name=myLabel.\n\t\tkubectl delete pods,services -l name=myLabel\n\n\t\t# Delete a pod with minimal delay\n\t\tkubectl delete pod foo --now\n\n\t\t# Force delete a pod on a dead node\n\t\tkubectl delete pod foo --grace-period=0 --force\n\n\t\t# Delete all pods\n\t\tkubectl delete pods --all\x00\n\t\t# Describe a node\n\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n\n\t\t# Describe a pod\n\t\tkubectl describe pods/nginx\n\n\t\t# Describe a pod identified by type and name in \"pod.json\"\n\t\tkubectl describe -f pod.json\n\n\t\t# Describe all pods\n\t\tkubectl describe pods\n\n\t\t# Describe pods by label name=myLabel\n\t\tkubectl describe po -l name=myLabel\n\n\t\t# Describe all pods managed by the 'frontend' replication controller (rc-created pods\n\t\t# get the name of the rc as a prefix in the pod the name).\n\t\tkubectl describe pods frontend\x00\n\t\t# Drain node \"foo\", even if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n\t\t$ kubectl drain foo --force\n\n\t\t# As above, but abort if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a grace period of 15 minutes.\n\t\t$ kubectl drain foo --grace-period=900\x00\n\t\t# Edit the service named 'docker-registry':\n\t\tkubectl edit svc/docker-registry\n\n\t\t# Use an alternative editor\n\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n\n\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n\t\tkubectl edit job.v1.batch/myjob -o json\n\n\t\t# Edit the deployment 'mydeployment' in YAML and save the modified config in its annotation:\n\t\tkubectl edit deployment/mydeployment -o yaml --save-config\x00\n\t\t# Get output from running 'date' from pod 123456-7890, using the first container by default\n\t\tkubectl exec 123456-7890 date\n\n\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n\t\tkubectl exec 123456-7890 -c ruby-container date\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il\x00\n\t\t# Get output from running pod 123456-7890, using the first container by default\n\t\tkubectl attach 123456-7890\n\n\t\t# Get output from ruby-container from pod 123456-7890\n\t\tkubectl attach 123456-7890 -c ruby-container\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n\n\t\t# Get output from the first pod of a ReplicaSet named nginx\n\t\tkubectl attach rs/nginx\n\t\t\x00\n\t\t# Get the documentation of the resource and its fields\n\t\tkubectl explain pods\n\n\t\t# Get the documentation of a specific field of a resource\n\t\tkubectl explain pods.spec.containers\x00\n\t\t# Install bash completion on a Mac using homebrew\n\t\tbrew install bash-completion\n\t\tprintf \"\n# Bash completion support\nsource $(brew --prefix)/etc/bash_completion\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for bash into the current shell\n\t\tsource <(kubectl completion bash)\n\n\t\t# Write bash completion code to a file and source if from .bash_profile\n\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n\t\tprintf \"\n# Kubectl shell completion\nsource '$HOME/.kube/completion.bash.inc'\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for zsh[1] into the current shell\n\t\tsource <(kubectl completion zsh)\x00\n\t\t# List all pods in ps output format.\n\t\tkubectl get pods\n\n\t\t# List all pods in ps output format with more information (such as node name).\n\t\tkubectl get pods -o wide\n\n\t\t# List a single replication controller with specified NAME in ps output format.\n\t\tkubectl get replicationcontroller web\n\n\t\t# List a single pod in JSON output format.\n\t\tkubectl get -o json pod web-pod-13je7\n\n\t\t# List a pod identified by type and name specified in \"pod.yaml\" in JSON output format.\n\t\tkubectl get -f pod.yaml -o json\n\n\t\t# Return only the phase value of the specified pod.\n\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n\n\t\t# List all replication controllers and services together in ps output format.\n\t\tkubectl get rc,services\n\n\t\t# List one or more resources by their type and names.\n\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n\n\t\t# List all resources with different types.\n\t\tkubectl get all\x00\n\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports 5000 and 6000 in the pod\n\t\tkubectl port-forward mypod 5000 6000\n\n\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 8888:5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod :5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 0:5000\x00\n\t\t# Mark node \"foo\" as schedulable.\n\t\t$ kubectl uncordon foo\x00\n\t\t# Mark node \"foo\" as unschedulable.\n\t\tkubectl cordon foo\x00\n\t\t# Partially update a node using strategic merge patch\n\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Partially update a node identified by the type and name specified in \"node.json\" using strategic merge patch\n\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Update a container's image; spec.containers[*].name is required because it's a merge key\n\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n\n\t\t# Update a container's image using a json patch with positional arrays\n\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", \"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'\x00\n\t\t# Print flags inherited by all commands\n\t\tkubectl options\x00\n\t\t# Print the address of the master and cluster services\n\t\tkubectl cluster-info\x00\n\t\t# Print the client and server versions for the current context\n\t\tkubectl version\x00\n\t\t# Print the supported API versions\n\t\tkubectl api-versions\x00\n\t\t# Replace a pod using the data in pod.json.\n\t\tkubectl replace -f ./pod.json\n\n\t\t# Replace a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl replace -f -\n\n\t\t# Update a single-container pod's image version (tag) to v4\n\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/\x01:v4/' | kubectl replace -f -\n\n\t\t# Force replace, delete and then re-create the resource\n\t\tkubectl replace --force -f ./pod.json\x00\n\t\t# Return snapshot logs from pod nginx with only one container\n\t\tkubectl logs nginx\n\n\t\t# Return snapshot logs for the pods defined by label app=nginx\n\t\tkubectl logs -lapp=nginx\n\n\t\t# Return snapshot of previous terminated ruby container logs from pod web-1\n\t\tkubectl logs -p -c ruby web-1\n\n\t\t# Begin streaming the logs of the ruby container in pod web-1\n\t\tkubectl logs -f -c ruby web-1\n\n\t\t# Display only the most recent 20 lines of output in pod nginx\n\t\tkubectl logs --tail=20 nginx\n\n\t\t# Show all logs from pod nginx written in the last hour\n\t\tkubectl logs --since=1h nginx\n\n\t\t# Return snapshot logs from first container of a job named hello\n\t\tkubectl logs job/hello\n\n\t\t# Return snapshot logs from container nginx-1 of a deployment named nginx\n\t\tkubectl logs deployment/nginx -c nginx-1\x00\n\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static content from ./local/www/\n\t\tkubectl proxy --port=8011 --www=./local/www/\n\n\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n\t\t# The chosen port for the server will be output to stdout.\n\t\tkubectl proxy --port=0\n\n\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-api\n\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/pods/\n\t\tkubectl proxy --api-prefix=/k8s-api\x00\n\t\t# Scale a replicaset named 'foo' to 3.\n\t\tkubectl scale --replicas=3 rs/foo\n\n\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" to 3.\n\t\tkubectl scale --replicas=3 -f foo.yaml\n\n\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n\n\t\t# Scale multiple replication controllers.\n\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n\n\t\t# Scale job named 'cron' to 3.\n\t\tkubectl scale --replicas=3 job/cron\x00\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file.\n\t\tkubectl apply set-last-applied -f deploy.yaml\n\n\t\t# Execute set-last-applied against each configuration file in a directory.\n\t\tkubectl apply set-last-applied -f path/\n\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file, will create the annotation if it does not already exist.\n\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n\t\t\x00\n\t\t# Show metrics for all pods in the default namespace\n\t\tkubectl top pod\n\n\t\t# Show metrics for all pods in the given namespace\n\t\tkubectl top pod --namespace=NAMESPACE\n\n\t\t# Show metrics for a given pod and its containers\n\t\tkubectl top pod POD_NAME --containers\n\n\t\t# Show metrics for the pods defined by label name=myLabel\n\t\tkubectl top pod -l name=myLabel\x00\n\t\t# Shut down foo.\n\t\tkubectl stop replicationcontroller foo\n\n\t\t# Stop pods and services with label name=myLabel.\n\t\tkubectl stop pods,services -l name=myLabel\n\n\t\t# Shut down the service defined in service.json\n\t\tkubectl stop -f service.json\n\n\t\t# Shut down all resources in the path/to/resources directory\n\t\tkubectl stop -f path/to/resources\x00\n\t\t# Start a single instance of nginx.\n\t\tkubectl run nginx --image=nginx\n\n\t\t# Start a single instance of hazelcast and let the container expose port 5701 .\n\t\tkubectl run hazelcast --image=hazelcast --port=5701\n\n\t\t# Start a single instance of hazelcast and set environment variables \"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --env=\"POD_NAMESPACE=default\"\n\n\t\t# Start a replicated instance of nginx.\n\t\tkubectl run nginx --image=nginx --replicas=5\n\n\t\t# Dry run. Print the corresponding API objects without creating them.\n\t\tkubectl run nginx --image=nginx --dry-run\n\n\t\t# Start a single instance of nginx, but overload the spec of the deployment with a partial set of values parsed from JSON.\n\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", \"spec\": { ... } }'\n\n\t\t# Start a pod of busybox and keep it in the foreground, don't restart it if it exits.\n\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n\n\t\t# Start the nginx container using the default command, but use custom arguments (arg1 .. argN) for that command.\n\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n\n\t\t# Start the nginx container using a different command and custom arguments.\n\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n\n\t\t# Start the perl container to compute \u03c0 to 2000 places and print it out.\n\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\n\n\t\t# Start the cron job to compute \u03c0 to 2000 places and print it out every 5 minutes.\n\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\x00\n\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-user' and effect 'NoSchedule'.\n\t\t# If a taint with that key and effect already exists, its value is replaced as specified.\n\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n\n\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect 'NoSchedule' if one exists.\n\t\tkubectl taint nodes foo dedicated:NoSchedule-\n\n\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n\t\tkubectl taint nodes foo dedicated-\x00\n\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n\t\tkubectl label pods foo unhealthy=true\n\n\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', overwriting any existing value.\n\t\tkubectl label --overwrite pods foo status=unhealthy\n\n\t\t# Update all pods in the namespace\n\t\tkubectl label pods --all status=unhealthy\n\n\t\t# Update a pod identified by the type and name in \"pod.json\"\n\t\tkubectl label -f pod.json status=unhealthy\n\n\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n\t\tkubectl label pods foo status=unhealthy --resource-version=1\n\n\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n\t\t# Does not require the --overwrite flag.\n\t\tkubectl label pods foo bar-\x00\n\t\t# Update pods of frontend-v1 using new replication controller data in frontend-v2.json.\n\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n\n\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n\n\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the image, and switching the\n\t\t# name of the replication controller.\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n\n\t\t# Update the pods of frontend by just changing the image, and keeping the old name.\n\t\tkubectl rolling-update frontend --image=image:v2\n\n\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to frontend-v2).\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback\x00\n\t\t# View the last-applied-configuration annotations by type/name in YAML.\n\t\tkubectl apply view-last-applied deployment/nginx\n\n\t\t# View the last-applied-configuration annotations by file in JSON\n\t\tkubectl apply view-last-applied -f deploy.yaml -o json\x00\n\t\tApply a configuration to a resource by filename or stdin.\n\t\tThis resource will be created if it doesn't exist yet.\n\t\tTo use 'apply', always create the resource initially with either 'apply' or 'create --save-config'.\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not use unless you are aware of what the current state is. See https://issues.k8s.io/34274.\x00\n\t\tConvert config files between different API versions. Both YAML\n\t\tand JSON formats are accepted.\n\n\t\tThe command takes filename, directory, or URL as input, and convert it into format\n\t\tof version specified by --output-version flag. If target version is not specified or\n\t\tnot supported, convert to latest version.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change to output destination.\x00\n\t\tCreate a ClusterRole.\x00\n\t\tCreate a ClusterRoleBinding for a particular ClusterRole.\x00\n\t\tCreate a RoleBinding for a particular Role or ClusterRole.\x00\n\t\tCreate a TLS secret from the given public/private key pair.\n\n\t\tThe public/private key pair must exist before hand. The public key certificate must be .PEM encoded and match the given private key.\x00\n\t\tCreate a configmap based on a file, directory, or specified literal value.\n\n\t\tA single configmap may package one or more key/value pairs.\n\n\t\tWhen creating a configmap based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a configmap based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the configmap.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a namespace with the specified name.\x00\n\t\tCreate a new secret for use with Docker registries.\n\n\t\tDockercfg secrets are used to authenticate against Docker registries.\n\n\t\tWhen using the Docker command line to push images, you can authenticate to a given registry by running\n\n\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n\n    That produces a ~/.dockercfg file that is used by subsequent 'docker push' and 'docker pull' commands to\n\t\tauthenticate to the registry. The email address is optional.\n\n\t\tWhen creating applications, you may have a Docker registry that requires authentication.  In order for the\n\t\tnodes to pull images on your behalf, they have to have the credentials.  You can provide this information\n\t\tby creating a dockercfg secret and attaching it to your service account.\x00\n\t\tCreate a pod disruption budget with the specified name, selector, and desired minimum available pods\x00\n\t\tCreate a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted.\x00\n\t\tCreate a resourcequota with the specified name, hard limits and optional scopes\x00\n\t\tCreate a role with single rule.\x00\n\t\tCreate a secret based on a file, directory, or specified literal value.\n\n\t\tA single secret may package one or more key/value pairs.\n\n\t\tWhen creating a secret based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a secret based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the secret.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a service account with the specified name.\x00\n\t\tCreate and run a particular image, possibly replicated.\n\n\t\tCreates a deployment or job to manage the created container(s).\x00\n\t\tCreates an autoscaler that automatically chooses and sets the number of pods that run in a kubernetes cluster.\n\n\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and creates an autoscaler that uses the given resource as a reference.\n\t\tAn autoscaler can automatically increase or decrease number of pods deployed within the system as needed.\x00\n\t\tDelete resources by filenames, stdin, resources and names, or by resources and label selector.\n\n\t\tJSON and YAML formats are accepted. Only one type of the arguments may be specified: filenames,\n\t\tresources and names, or resources and label selector.\n\n\t\tSome resources, such as pods, support graceful deletion. These resources define a default period\n\t\tbefore they are forcibly terminated (the grace period) but you may override that value with\n\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. Because these resources often\n\t\trepresent entities in the cluster, deletion may not be acknowledged immediately. If the node\n\t\thosting a pod is down or cannot reach the API server, termination may take significantly longer\n\t\tthan the grace period. To force delete a resource,\tyou must pass a grace\tperiod of 0 and specify\n\t\tthe --force flag.\n\n\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the pod's processes have been\n\t\tterminated, which can leave those processes running until the node detects the deletion and\n\t\tcompletes graceful deletion. If your processes use shared storage or talk to a remote API and\n\t\tdepend on the name of the pod to identify themselves, force deleting those pods may result in\n\t\tmultiple processes running on different machines using the same identification which may lead\n\t\tto data corruption or inconsistency. Only force delete pods when you are sure the pod is\n\t\tterminated, or if your application can tolerate multiple copies of the same pod running at once.\n\t\tAlso, if you force delete pods the scheduler may place new pods on those nodes before the node\n\t\thas released those resources and causing those pods to be evicted immediately.\n\n\t\tNote that the delete command does NOT do resource version checks, so if someone\n\t\tsubmits an update to a resource right when you submit a delete, their update\n\t\twill be lost along with the rest of the resource.\x00\n\t\tDeprecated: Gracefully shut down a resource by name or filename.\n\n\t\tThe stop command is deprecated, all its functionalities are covered by delete command.\n\t\tSee 'kubectl delete --help' for more details.\n\n\t\tAttempts to shut down and delete a resource that supports graceful termination.\n\t\tIf the resource is scalable it will be scaled to 0 before deletion.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n\n\t\tThe top-node command allows you to see the resource consumption of nodes.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n\n\t\tThe 'top pod' command allows you to see the resource consumption of pods.\n\n\t\tDue to the metrics pipeline delay, they may be unavailable for a few minutes\n\t\tsince pod creation.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage.\n\n\t\tThe top command allows you to see the resource consumption for nodes or pods.\n\n\t\tThis command requires Heapster to be correctly configured and working on the server. \x00\n\t\tDrain node in preparation for maintenance.\n\n\t\tThe given node will be marked unschedulable to prevent new pods from arriving.\n\t\t'drain' evicts the pods if the APIServer supports eviction\n\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use normal DELETE\n\t\tto delete the pods.\n\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot be deleted through\n\t\tthe API server).  If there are DaemonSet-managed pods, drain will not proceed\n\t\twithout --ignore-daemonsets, and regardless it will not delete any\n\t\tDaemonSet-managed pods, because those pods would be immediately replaced by the\n\t\tDaemonSet controller, which ignores unschedulable markings.  If there are any\n\t\tpods that are neither mirror pods nor managed by ReplicationController,\n\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete any pods unless you\n\t\tuse --force.  --force will also allow deletion to proceed if the managing resource of one\n\t\tor more pods is missing.\n\n\t\t'drain' waits for graceful termination. You should not operate on the machine until\n\t\tthe command completes.\n\n\t\tWhen you are ready to put the node back into service, use kubectl uncordon, which\n\t\twill make the node schedulable again.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)\x00\n\t\tEdit a resource from the default editor.\n\n\t\tThe edit command allows you to directly edit any API resource you can retrieve via the\n\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, or EDITOR\n\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for Windows.\n\t\tYou can edit multiple objects, although changes are applied one at a time. The command\n\t\taccepts filenames as well as command line arguments, although the files you point to must\n\t\tbe previously saved versions of resources.\n\n\t\tEditing is done with the API version used to fetch the resource.\n\t\tTo edit using a specific API version, fully-qualify the resource, version, and group.\n\n\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n\n\t\tThe flag --windows-line-endings can be used to force Windows line endings,\n\t\totherwise the default for your operating system will be used.\n\n\t\tIn the event an error occurs while updating, a temporary file will be created on disk\n\t\tthat contains your unapplied changes. The most common error when updating a resource\n\t\tis another editor changing the resource on the server. When this occurs, you will have\n\t\tto apply your changes to the newer version of the resource, or update your temporary\n\t\tsaved copy to include the latest resource version.\x00\n\t\tMark node as schedulable.\x00\n\t\tMark node as unschedulable.\x00\n\t\tOutput shell completion code for the specified shell (bash or zsh).\n\t\tThe shell code must be evaluated to provide interactive\n\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n\t\tthe .bash_profile.\n\n\t\tNote: this requires the bash-completion framework, which is not installed\n\t\tby default on Mac.  This can be installed by using homebrew:\n\n\t\t    $ brew install bash-completion\n\n\t\tOnce installed, bash_completion must be evaluated.  This can be done by adding the\n\t\tfollowing line to the .bash_profile\n\n\t\t    $ source $(brew --prefix)/etc/bash_completion\n\n\t\tNote for zsh users: [1] zsh completions are only supported in versions of zsh >= 5.2\x00\n\t\tPerform a rolling update of the given ReplicationController.\n\n\t\tReplaces the specified replication controller with a new replication controller by updating one pod at a time to use the\n\t\tnew PodTemplate. The new-controller.json must specify the same namespace as the\n\t\texisting replication controller and overwrite at least one (common) label in its replicaSelector.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)\x00\n\t\tReplace a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted. If replacing an existing resource, the\n\t\tcomplete resource spec must be provided. This can be obtained by\n\n\t\t    $ kubectl get TYPE NAME -o yaml\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or Job.\n\n\t\tScale also allows users to specify one or more preconditions for the scale action.\n\n\t\tIf --current-replicas or --resource-version is specified, it is validated before the\n\t\tscale is attempted, and it is guaranteed that the precondition holds true when the\n\t\tscale is sent to the server.\x00\n\t\tSet the latest last-applied-configuration annotations by setting it to match the contents of a file.\n\t\tThis results in the last-applied-configuration being updated as though 'kubectl apply -f <file>' was run,\n\t\twithout updating any other parts of the object.\x00\n\t\tTo proxy all of the kubernetes api and nothing else, use:\n\n\t\t    $ kubectl proxy --api-prefix=/\n\n\t\tTo proxy only part of the kubernetes api and also some static files:\n\n\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/api/\n\n\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n\n\t\tTo proxy the entire kubernetes api at a different root, use:\n\n\t\t    $ kubectl proxy --api-prefix=/custom/\n\n\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'\x00\n\t\tUpdate field(s) of a resource using strategic merge patch\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tUpdate the labels on a resource.\n\n\t\t* A label must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* If --overwrite is true, then existing labels can be overwritten, otherwise attempting to overwrite a label will result in an error.\n\t\t* If --resource-version is specified, then updates will use this resource version, otherwise the existing resource-version will be used.\x00\n\t\tUpdate the taints on one or more nodes.\n\n\t\t* A taint consists of a key, value, and effect. As an argument here, it is expressed as key=value:effect.\n\t\t* The key must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* The value must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[2]d characters.\n\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n\t\t* Currently taint can only apply to node.\x00\n\t\tView the latest last-applied-configuration annotations by type/name or file.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change output format.\x00\n\t    # !!!Important Note!!!\n\t    # Requires that the 'tar' binary is present in your container\n\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n\n\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in the default namespace\n\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n\n        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific container\n\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n\n\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace <some-namespace>\n\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n\n\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar\x00\n\t  # Create a new TLS secret named tls-secret with the given key pair:\n\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/to/tls.key\x00\n\t  # Create a new namespace named my-namespace\n\t  kubectl create namespace my-namespace\x00\n\t  # Create a new secret named my-secret with keys for each file in folder bar\n\t  kubectl create secret generic my-secret --from-file=path/to/bar\n\n\t  # Create a new secret named my-secret with specified keys instead of names on disk\n\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/.ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n\n\t  # Create a new secret named my-secret with key1=supersecret and key2=topsecret\n\t  kubectl create secret generic my-secret --from-literal=key1=supersecret --from-literal=key2=topsecret\x00\n\t  # Create a new service account named my-service-account\n\t  kubectl create serviceaccount my-service-account\x00\n\t# Create a new ExternalName service named my-ns \n\tkubectl create service externalname my-ns --external-name bar.com\x00\n\tCreate an ExternalName service with the specified name.\n\n\tExternalName service references to an external DNS address instead of\n\tonly pods, which will allow application authors to reference services\n\tthat exist off platform, on other clusters, or locally.\x00\n\tHelp provides help for any command in the application.\n\tSimply type kubectl help [path to command] for full details.\x00\n    # Create a new LoadBalancer service named my-lbs\n    kubectl create service loadbalancer my-lbs --tcp=5678:8080\x00\n    # Create a new clusterIP service named my-cs\n    kubectl create service clusterip my-cs --tcp=5678:8080\n\n    # Create a new clusterIP service named my-cs (in headless mode)\n    kubectl create service clusterip my-cs --clusterip=\"None\"\x00\n    # Create a new deployment named my-dep that runs the busybox image.\n    kubectl create deployment my-dep --image=busybox\x00\n    # Create a new nodeport service named my-ns\n    kubectl create service nodeport my-ns --tcp=5678:8080\x00\n    # Dump current cluster state to stdout\n    kubectl cluster-info dump\n\n    # Dump current cluster state to /path/to/cluster-state\n    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n\n    # Dump all namespaces to stdout\n    kubectl cluster-info dump --all-namespaces\n\n    # Dump a set of namespaces to /path/to/cluster-state\n    kubectl cluster-info dump --namespaces default,kube-system --output-directory=/path/to/cluster-state\x00\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend'.\n    # If the same annotation is set multiple times, only the last value will be applied\n    kubectl annotate pods foo description='my frontend'\n\n    # Update a pod identified by type and name in \"pod.json\"\n    kubectl annotate -f pod.json description='my frontend'\n\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend running nginx', overwriting any existing value.\n    kubectl annotate --overwrite pods foo description='my frontend running nginx'\n\n    # Update all pods in the namespace\n    kubectl annotate pods --all description='my frontend running nginx'\n\n    # Update pod 'foo' only if the resource is unchanged from version 1.\n    kubectl annotate pods foo description='my frontend running nginx' --resource-version=1\n\n    # Update pod 'foo' by removing an annotation named 'description' if it exists.\n    # Does not require the --overwrite flag.\n    kubectl annotate pods foo description-\x00\n    Create a LoadBalancer service with the specified name.\x00\n    Create a clusterIP service with the specified name.\x00\n    Create a deployment with the specified name.\x00\n    Create a nodeport service with the specified name.\x00\n    Dumps cluster info out suitable for debugging and diagnosing cluster problems.  By default, dumps everything to\n    stdout. You can optionally specify a directory with --output-directory.  If you specify a directory, kubernetes will\n    build a set of files in that directory.  By default only dumps things in the 'kube-system' namespace, but you can\n    switch to a different namespace with the --namespaces flag, or specify --all-namespaces to dump all namespaces.\n\n    The command also dumps the logs of all of the pods in the cluster, these logs are dumped into different directories\n    based on namespace and pod name.\x00\n  Display addresses of the master and services with label kubernetes.io/cluster-service=true\n  To further debug and diagnose cluster problems, use 'kubectl cluster-info dump'.\x00A comma-delimited set of quota scopes that must all match each object tracked by the quota.\x00A comma-delimited set of resource=quantity pairs that define a hard limit.\x00A label selector to use for this budget. Only equality-based selector requirements are supported.\x00A label selector to use for this service. Only equality-based selector requirements are supported. If empty (the default) infer the selector from the replication controller or replica set.)\x00A schedule in the Cron format the job should be run with.\x00Additional external IP address (not managed by Kubernetes) to accept for the service. If this IP is routed to a node, the service can be accessed by this IP in addition to its generated service IP.\x00An inline JSON override for the generated object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.\x00An inline JSON override for the generated service object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.  Only used if --expose is true.\x00Apply a configuration to a resource by filename or stdin\x00Approve a certificate signing request\x00Assign your own ClusterIP or set to 'None' for a 'headless' service (no loadbalancing).\x00Attach to a running container\x00Auto-scale a Deployment, ReplicaSet, or ReplicationController\x00ClusterIP to be assigned to the service. Leave empty to auto-allocate, or set to 'None' to create a headless service.\x00ClusterRole this ClusterRoleBinding should reference\x00ClusterRole this RoleBinding should reference\x00Container name which will have its image upgraded. Only relevant when --image is specified, ignored otherwise. Required when using --image on a multi-container pod\x00Convert config files between different API versions\x00Copy files and directories to and from containers.\x00Create a ClusterRoleBinding for a particular ClusterRole\x00Create a LoadBalancer service.\x00Create a NodePort service.\x00Create a RoleBinding for a particular Role or ClusterRole\x00Create a TLS secret\x00Create a clusterIP service.\x00Create a configmap from a local file, directory or literal value\x00Create a deployment with the specified name.\x00Create a namespace with the specified name\x00Create a pod disruption budget with the specified name.\x00Create a quota with the specified name.\x00Create a resource by filename or stdin\x00Create a secret for use with a Docker registry\x00Create a secret from a local file, directory or literal value\x00Create a secret using specified subcommand\x00Create a service account with the specified name\x00Create a service using specified subcommand.\x00Create an ExternalName service.\x00Delete resources by filenames, stdin, resources and names, or by resources and label selector\x00Delete the specified cluster from the kubeconfig\x00Delete the specified context from the kubeconfig\x00Deny a certificate signing request\x00Deprecated: Gracefully shut down a resource by name or filename\x00Describe one or many contexts\x00Display Resource (CPU/Memory) usage of nodes\x00Display Resource (CPU/Memory) usage of pods\x00Display Resource (CPU/Memory) usage.\x00Display cluster info\x00Display clusters defined in the kubeconfig\x00Display merged kubeconfig settings or a specified kubeconfig file\x00Display one or many resources\x00Displays the current-context\x00Documentation of resources\x00Drain node in preparation for maintenance\x00Dump lots of relevant info for debugging and diagnosis\x00Edit a resource on the server\x00Email for Docker registry\x00Execute a command in a container\x00Explicit policy for when to pull container images. Required when --image is same as existing image, ignored otherwise.\x00Forward one or more local ports to a pod\x00Help about any command\x00IP to assign to the Load Balancer. If empty, an ephemeral IP will be created and used (cloud-provider specific).\x00If non-empty, set the session affinity for the service to this; legal values: 'None', 'ClientIP'\x00If non-empty, the annotation update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00If non-empty, the labels update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00Image to use for upgrading the replication controller. Must be distinct from the existing image (either new image or new image tag).  Can not be used with --filename/-f\x00Manage a deployment rollout\x00Mark node as schedulable\x00Mark node as unschedulable\x00Mark the provided resource as paused\x00Modify certificate resources.\x00Modify kubeconfig files\x00Name or number for the port on the container that the service should direct traffic to. Optional.\x00Only return logs after a specific date (RFC3339). Defaults to all logs. Only one of since-time / since may be used.\x00Output shell completion code for the specified shell (bash or zsh)\x00Output the formatted object with the given group version (for ex: 'extensions/v1beta1').)\x00Password for Docker registry authentication\x00Path to PEM encoded public key certificate.\x00Path to private key associated with given certificate.\x00Perform a rolling update of the given ReplicationController\x00Precondition for resource version. Requires that the current resource version match this value in order to scale.\x00Print the client and server version information\x00Print the list of flags inherited by all commands\x00Print the logs for a container in a pod\x00Replace a resource by filename or stdin\x00Resume a paused resource\x00Role this RoleBinding should reference\x00Run a particular image on the cluster\x00Run a proxy to the Kubernetes API server\x00Server location for Docker registry\x00Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job\x00Set specific features on objects\x00Set the last-applied-configuration annotation on a live object to match the contents of a file.\x00Set the selector on a resource\x00Sets a cluster entry in kubeconfig\x00Sets a context entry in kubeconfig\x00Sets a user entry in kubeconfig\x00Sets an individual value in a kubeconfig file\x00Sets the current-context in a kubeconfig file\x00Show details of a specific resource or group of resources\x00Show the status of the rollout\x00Synonym for --target-port\x00Take a replication controller, service, deployment or pod and expose it as a new Kubernetes Service\x00The image for the container to run.\x00The image pull policy for the container. If left empty, this value will not be specified by the client and defaulted by the server\x00The key to use to differentiate between two different controllers, default 'deployment'.  Only relevant when --image is specified, ignored otherwise\x00The minimum number or percentage of available pods this budget requires.\x00The name for the newly created object.\x00The name for the newly created object. If not specified, the name of the input resource will be used.\x00The name of the API generator to use, see http://kubernetes.io/docs/user-guide/kubectl-conventions/#generators for a list.\x00The name of the API generator to use. Currently there is only 1 generator.\x00The name of the API generator to use. There are 2 generators: 'service/v1' and 'service/v2'. The only difference between them is that service port in v1 is named 'default', while it is left unnamed in v2. Default is 'service/v2'.\x00The name of the generator to use for creating a service.  Only used if --expose is true\x00The network protocol for the service to be created. Default is 'TCP'.\x00The port that the service should serve on. Copied from the resource being exposed, if unspecified\x00The port that this container exposes.  If --expose is true, this is also the port used by the service that is created.\x00The resource requirement limits for this container.  For example, 'cpu=200m,memory=512Mi'.  Note that server side components may assign limits depending on the server configuration, such as limit ranges.\x00The resource requirement requests for this container.  For example, 'cpu=100m,memory=256Mi'.  Note that server side components may assign requests depending on the server configuration, such as limit ranges.\x00The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  If set to 'Always' a deployment is created, if set to 'OnFailure' a job is created, if set to 'Never', a regular pod is created. For the latter two --replicas must be 1.  Default 'Always', for CronJobs `Never`.\x00The type of secret to create\x00Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is 'ClusterIP'.\x00Undo a previous rollout\x00Unsets an individual value in a kubeconfig file\x00Update field(s) of a resource using strategic merge patch\x00Update image of a pod template\x00Update resource requests/limits on objects with pod templates\x00Update the annotations on a resource\x00Update the labels on a resource\x00Update the taints on one or more nodes\x00Username for Docker registry authentication\x00View latest last-applied-configuration annotations of a resource/object\x00View rollout history\x00Where to output the files.  If empty or '-' uses stdout, otherwise creates a directory hierarchy in that directory\x00dummy restart flag)\x00external name of service\x00kubectl controls the Kubernetes cluster manager\x00Project-Id-Version: gettext-go-examples-hello\nReport-Msgid-Bugs-To: EMAIL\nPOT-Creation-Date: 2017-03-14 21:32-0700\nPO-Revision-Date: 2017-03-14 21:33-0800\nLast-Translator: Brendan Burns <brendan.d.burns@gmail.com>\nLanguage-Team: \nLanguage: en\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 8bit\nX-Generator: Poedit 1.6.10\nX-Poedit-SourceCharset: UTF-8\nPlural-Forms: nplurals=2; plural=(n != 1);\n\x00\n\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the cluster-admin ClusterRole\n\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin ClusterRole\n\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a new configmap named my-config based on folder bar\n\t\t  kubectl create configmap my-config --from-file=path/to/bar\n\n\t\t  # Create a new configmap named my-config with specified keys instead of file basenames on disk\n\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1.txt --from-file=key2=/path/to/bar/file2.txt\n\n\t\t  # Create a new configmap named my-config with key1=config1 and key2=config2\n\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-literal=key2=config2\x00\n\t\t  # If you don't already have a .dockercfg file, you can create a dockercfg secret directly by using:\n\t\t  kubectl create secret docker-registry my-secret --docker-server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL\x00\n\t\t  # Show metrics for all nodes\n\t\t  kubectl top node\n\n\t\t  # Show metrics for a given node\n\t\t  kubectl top node NODE_NAME\x00\n\t\t# Apply the configuration in pod.json to a pod.\n\t\tkubectl apply -f ./pod.json\n\n\t\t# Apply the JSON passed into stdin to a pod.\n\t\tcat pod.json | kubectl apply -f -\n\n\t\t# Note: --prune is still in Alpha\n\t\t# Apply the configuration in manifest.yaml that matches label app=nginx and delete all the other resources that are not in the file and match label app=nginx.\n\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n\n\t\t# Apply the configuration in manifest.yaml and delete all the other configmaps that are not in the file.\n\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/ConfigMap\x00\n\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and 10, no target CPU utilization specified so a default autoscaling policy will be used:\n\t\tkubectl autoscale deployment foo --min=2 --max=10\n\n\t\t# Auto scale a replication controller \"foo\", with the number of pods between 1 and 5, target CPU utilization at 80%:\n\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80\x00\n\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n\t\tkubectl convert -f pod.yaml\n\n\t\t# Convert the live state of the resource specified by 'pod.yaml' to the latest version\n\t\t# and print to stdout in json format.\n\t\tkubectl convert -f pod.yaml --local -o json\n\n\t\t# Convert all files under current directory to latest version and create them all.\n\t\tkubectl convert -f . | kubectl create -f -\x00\n\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods\n\n\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --resource=pods\n\n\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a new resourcequota named my-quota\n\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,replicationcontrollers=2,resourcequotas=1,secrets=5,persistentvolumeclaims=10\n\n\t\t# Create a new resourcequota named best-effort\n\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort\x00\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=rails label\n\t\t# and require at least one of them being available at any point in time.\n\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-available=1\n\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=nginx label\n\t\t# and require at least half of the pods selected to be available at any point in time.\n\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%\x00\n\t\t# Create a pod using the data in pod.json.\n\t\tkubectl create -f ./pod.json\n\n\t\t# Create a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl create -f -\n\n\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format then create the resource using the edited data.\n\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json\x00\n\t\t# Create a service for a replicated nginx, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rc nginx --port=80 --target-port=8000\n\n\t\t# Create a service for a replication controller identified by type and name specified in \"nginx-controller.yaml\", which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n\n\t\t# Create a service for a pod valid-pod, which serves on port 444 with the name \"frontend\"\n\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n\n\t\t# Create a second service based on the above service, exposing the container port 8443 as port 443 with the name \"nginx-https\"\n\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-https\n\n\t\t# Create a service for a replicated streaming application on port 4100 balancing UDP traffic and named 'video-stream'.\n\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-stream\n\n\t\t# Create a service for a replicated nginx using replica set, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rs nginx --port=80 --target-port=8000\n\n\t\t# Create a service for an nginx deployment, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose deployment nginx --port=80 --target-port=8000\x00\n\t\t# Delete a pod using the type and name specified in pod.json.\n\t\tkubectl delete -f ./pod.json\n\n\t\t# Delete a pod based on the type and name in the JSON passed into stdin.\n\t\tcat pod.json | kubectl delete -f -\n\n\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n\t\tkubectl delete pod,service baz foo\n\n\t\t# Delete pods and services with label name=myLabel.\n\t\tkubectl delete pods,services -l name=myLabel\n\n\t\t# Delete a pod with minimal delay\n\t\tkubectl delete pod foo --now\n\n\t\t# Force delete a pod on a dead node\n\t\tkubectl delete pod foo --grace-period=0 --force\n\n\t\t# Delete all pods\n\t\tkubectl delete pods --all\x00\n\t\t# Describe a node\n\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n\n\t\t# Describe a pod\n\t\tkubectl describe pods/nginx\n\n\t\t# Describe a pod identified by type and name in \"pod.json\"\n\t\tkubectl describe -f pod.json\n\n\t\t# Describe all pods\n\t\tkubectl describe pods\n\n\t\t# Describe pods by label name=myLabel\n\t\tkubectl describe po -l name=myLabel\n\n\t\t# Describe all pods managed by the 'frontend' replication controller (rc-created pods\n\t\t# get the name of the rc as a prefix in the pod the name).\n\t\tkubectl describe pods frontend\x00\n\t\t# Drain node \"foo\", even if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n\t\t$ kubectl drain foo --force\n\n\t\t# As above, but abort if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a grace period of 15 minutes.\n\t\t$ kubectl drain foo --grace-period=900\x00\n\t\t# Edit the service named 'docker-registry':\n\t\tkubectl edit svc/docker-registry\n\n\t\t# Use an alternative editor\n\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n\n\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n\t\tkubectl edit job.v1.batch/myjob -o json\n\n\t\t# Edit the deployment 'mydeployment' in YAML and save the modified config in its annotation:\n\t\tkubectl edit deployment/mydeployment -o yaml --save-config\x00\n\t\t# Get output from running 'date' from pod 123456-7890, using the first container by default\n\t\tkubectl exec 123456-7890 date\n\n\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n\t\tkubectl exec 123456-7890 -c ruby-container date\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il\x00\n\t\t# Get output from running pod 123456-7890, using the first container by default\n\t\tkubectl attach 123456-7890\n\n\t\t# Get output from ruby-container from pod 123456-7890\n\t\tkubectl attach 123456-7890 -c ruby-container\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n\n\t\t# Get output from the first pod of a ReplicaSet named nginx\n\t\tkubectl attach rs/nginx\n\t\t\x00\n\t\t# Get the documentation of the resource and its fields\n\t\tkubectl explain pods\n\n\t\t# Get the documentation of a specific field of a resource\n\t\tkubectl explain pods.spec.containers\x00\n\t\t# Install bash completion on a Mac using homebrew\n\t\tbrew install bash-completion\n\t\tprintf \"\n# Bash completion support\nsource $(brew --prefix)/etc/bash_completion\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for bash into the current shell\n\t\tsource <(kubectl completion bash)\n\n\t\t# Write bash completion code to a file and source if from .bash_profile\n\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n\t\tprintf \"\n# Kubectl shell completion\nsource '$HOME/.kube/completion.bash.inc'\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for zsh[1] into the current shell\n\t\tsource <(kubectl completion zsh)\x00\n\t\t# List all pods in ps output format.\n\t\tkubectl get pods\n\n\t\t# List all pods in ps output format with more information (such as node name).\n\t\tkubectl get pods -o wide\n\n\t\t# List a single replication controller with specified NAME in ps output format.\n\t\tkubectl get replicationcontroller web\n\n\t\t# List a single pod in JSON output format.\n\t\tkubectl get -o json pod web-pod-13je7\n\n\t\t# List a pod identified by type and name specified in \"pod.yaml\" in JSON output format.\n\t\tkubectl get -f pod.yaml -o json\n\n\t\t# Return only the phase value of the specified pod.\n\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n\n\t\t# List all replication controllers and services together in ps output format.\n\t\tkubectl get rc,services\n\n\t\t# List one or more resources by their type and names.\n\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n\n\t\t# List all resources with different types.\n\t\tkubectl get all\x00\n\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports 5000 and 6000 in the pod\n\t\tkubectl port-forward mypod 5000 6000\n\n\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 8888:5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod :5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 0:5000\x00\n\t\t# Mark node \"foo\" as schedulable.\n\t\t$ kubectl uncordon foo\x00\n\t\t# Mark node \"foo\" as unschedulable.\n\t\tkubectl cordon foo\x00\n\t\t# Partially update a node using strategic merge patch\n\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Partially update a node identified by the type and name specified in \"node.json\" using strategic merge patch\n\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Update a container's image; spec.containers[*].name is required because it's a merge key\n\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n\n\t\t# Update a container's image using a json patch with positional arrays\n\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", \"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'\x00\n\t\t# Print flags inherited by all commands\n\t\tkubectl options\x00\n\t\t# Print the address of the master and cluster services\n\t\tkubectl cluster-info\x00\n\t\t# Print the client and server versions for the current context\n\t\tkubectl version\x00\n\t\t# Print the supported API versions\n\t\tkubectl api-versions\x00\n\t\t# Replace a pod using the data in pod.json.\n\t\tkubectl replace -f ./pod.json\n\n\t\t# Replace a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl replace -f -\n\n\t\t# Update a single-container pod's image version (tag) to v4\n\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/\x01:v4/' | kubectl replace -f -\n\n\t\t# Force replace, delete and then re-create the resource\n\t\tkubectl replace --force -f ./pod.json\x00\n\t\t# Return snapshot logs from pod nginx with only one container\n\t\tkubectl logs nginx\n\n\t\t# Return snapshot logs for the pods defined by label app=nginx\n\t\tkubectl logs -lapp=nginx\n\n\t\t# Return snapshot of previous terminated ruby container logs from pod web-1\n\t\tkubectl logs -p -c ruby web-1\n\n\t\t# Begin streaming the logs of the ruby container in pod web-1\n\t\tkubectl logs -f -c ruby web-1\n\n\t\t# Display only the most recent 20 lines of output in pod nginx\n\t\tkubectl logs --tail=20 nginx\n\n\t\t# Show all logs from pod nginx written in the last hour\n\t\tkubectl logs --since=1h nginx\n\n\t\t# Return snapshot logs from first container of a job named hello\n\t\tkubectl logs job/hello\n\n\t\t# Return snapshot logs from container nginx-1 of a deployment named nginx\n\t\tkubectl logs deployment/nginx -c nginx-1\x00\n\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static content from ./local/www/\n\t\tkubectl proxy --port=8011 --www=./local/www/\n\n\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n\t\t# The chosen port for the server will be output to stdout.\n\t\tkubectl proxy --port=0\n\n\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-api\n\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/pods/\n\t\tkubectl proxy --api-prefix=/k8s-api\x00\n\t\t# Scale a replicaset named 'foo' to 3.\n\t\tkubectl scale --replicas=3 rs/foo\n\n\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" to 3.\n\t\tkubectl scale --replicas=3 -f foo.yaml\n\n\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n\n\t\t# Scale multiple replication controllers.\n\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n\n\t\t# Scale job named 'cron' to 3.\n\t\tkubectl scale --replicas=3 job/cron\x00\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file.\n\t\tkubectl apply set-last-applied -f deploy.yaml\n\n\t\t# Execute set-last-applied against each configuration file in a directory.\n\t\tkubectl apply set-last-applied -f path/\n\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file, will create the annotation if it does not already exist.\n\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n\t\t\x00\n\t\t# Show metrics for all pods in the default namespace\n\t\tkubectl top pod\n\n\t\t# Show metrics for all pods in the given namespace\n\t\tkubectl top pod --namespace=NAMESPACE\n\n\t\t# Show metrics for a given pod and its containers\n\t\tkubectl top pod POD_NAME --containers\n\n\t\t# Show metrics for the pods defined by label name=myLabel\n\t\tkubectl top pod -l name=myLabel\x00\n\t\t# Shut down foo.\n\t\tkubectl stop replicationcontroller foo\n\n\t\t# Stop pods and services with label name=myLabel.\n\t\tkubectl stop pods,services -l name=myLabel\n\n\t\t# Shut down the service defined in service.json\n\t\tkubectl stop -f service.json\n\n\t\t# Shut down all resources in the path/to/resources directory\n\t\tkubectl stop -f path/to/resources\x00\n\t\t# Start a single instance of nginx.\n\t\tkubectl run nginx --image=nginx\n\n\t\t# Start a single instance of hazelcast and let the container expose port 5701 .\n\t\tkubectl run hazelcast --image=hazelcast --port=5701\n\n\t\t# Start a single instance of hazelcast and set environment variables \"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --env=\"POD_NAMESPACE=default\"\n\n\t\t# Start a replicated instance of nginx.\n\t\tkubectl run nginx --image=nginx --replicas=5\n\n\t\t# Dry run. Print the corresponding API objects without creating them.\n\t\tkubectl run nginx --image=nginx --dry-run\n\n\t\t# Start a single instance of nginx, but overload the spec of the deployment with a partial set of values parsed from JSON.\n\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", \"spec\": { ... } }'\n\n\t\t# Start a pod of busybox and keep it in the foreground, don't restart it if it exits.\n\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n\n\t\t# Start the nginx container using the default command, but use custom arguments (arg1 .. argN) for that command.\n\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n\n\t\t# Start the nginx container using a different command and custom arguments.\n\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n\n\t\t# Start the perl container to compute \u03c0 to 2000 places and print it out.\n\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\n\n\t\t# Start the cron job to compute \u03c0 to 2000 places and print it out every 5 minutes.\n\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\x00\n\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-user' and effect 'NoSchedule'.\n\t\t# If a taint with that key and effect already exists, its value is replaced as specified.\n\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n\n\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect 'NoSchedule' if one exists.\n\t\tkubectl taint nodes foo dedicated:NoSchedule-\n\n\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n\t\tkubectl taint nodes foo dedicated-\x00\n\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n\t\tkubectl label pods foo unhealthy=true\n\n\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', overwriting any existing value.\n\t\tkubectl label --overwrite pods foo status=unhealthy\n\n\t\t# Update all pods in the namespace\n\t\tkubectl label pods --all status=unhealthy\n\n\t\t# Update a pod identified by the type and name in \"pod.json\"\n\t\tkubectl label -f pod.json status=unhealthy\n\n\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n\t\tkubectl label pods foo status=unhealthy --resource-version=1\n\n\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n\t\t# Does not require the --overwrite flag.\n\t\tkubectl label pods foo bar-\x00\n\t\t# Update pods of frontend-v1 using new replication controller data in frontend-v2.json.\n\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n\n\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n\n\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the image, and switching the\n\t\t# name of the replication controller.\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n\n\t\t# Update the pods of frontend by just changing the image, and keeping the old name.\n\t\tkubectl rolling-update frontend --image=image:v2\n\n\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to frontend-v2).\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback\x00\n\t\t# View the last-applied-configuration annotations by type/name in YAML.\n\t\tkubectl apply view-last-applied deployment/nginx\n\n\t\t# View the last-applied-configuration annotations by file in JSON\n\t\tkubectl apply view-last-applied -f deploy.yaml -o json\x00\n\t\tApply a configuration to a resource by filename or stdin.\n\t\tThis resource will be created if it doesn't exist yet.\n\t\tTo use 'apply', always create the resource initially with either 'apply' or 'create --save-config'.\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not use unless you are aware of what the current state is. See https://issues.k8s.io/34274.\x00\n\t\tConvert config files between different API versions. Both YAML\n\t\tand JSON formats are accepted.\n\n\t\tThe command takes filename, directory, or URL as input, and convert it into format\n\t\tof version specified by --output-version flag. If target version is not specified or\n\t\tnot supported, convert to latest version.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change to output destination.\x00\n\t\tCreate a ClusterRole.\x00\n\t\tCreate a ClusterRoleBinding for a particular ClusterRole.\x00\n\t\tCreate a RoleBinding for a particular Role or ClusterRole.\x00\n\t\tCreate a TLS secret from the given public/private key pair.\n\n\t\tThe public/private key pair must exist before hand. The public key certificate must be .PEM encoded and match the given private key.\x00\n\t\tCreate a configmap based on a file, directory, or specified literal value.\n\n\t\tA single configmap may package one or more key/value pairs.\n\n\t\tWhen creating a configmap based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a configmap based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the configmap.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a namespace with the specified name.\x00\n\t\tCreate a new secret for use with Docker registries.\n\n\t\tDockercfg secrets are used to authenticate against Docker registries.\n\n\t\tWhen using the Docker command line to push images, you can authenticate to a given registry by running\n\n\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n\n    That produces a ~/.dockercfg file that is used by subsequent 'docker push' and 'docker pull' commands to\n\t\tauthenticate to the registry. The email address is optional.\n\n\t\tWhen creating applications, you may have a Docker registry that requires authentication.  In order for the\n\t\tnodes to pull images on your behalf, they have to have the credentials.  You can provide this information\n\t\tby creating a dockercfg secret and attaching it to your service account.\x00\n\t\tCreate a pod disruption budget with the specified name, selector, and desired minimum available pods\x00\n\t\tCreate a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted.\x00\n\t\tCreate a resourcequota with the specified name, hard limits and optional scopes\x00\n\t\tCreate a role with single rule.\x00\n\t\tCreate a secret based on a file, directory, or specified literal value.\n\n\t\tA single secret may package one or more key/value pairs.\n\n\t\tWhen creating a secret based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a secret based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the secret.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a service account with the specified name.\x00\n\t\tCreate and run a particular image, possibly replicated.\n\n\t\tCreates a deployment or job to manage the created container(s).\x00\n\t\tCreates an autoscaler that automatically chooses and sets the number of pods that run in a kubernetes cluster.\n\n\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and creates an autoscaler that uses the given resource as a reference.\n\t\tAn autoscaler can automatically increase or decrease number of pods deployed within the system as needed.\x00\n\t\tDelete resources by filenames, stdin, resources and names, or by resources and label selector.\n\n\t\tJSON and YAML formats are accepted. Only one type of the arguments may be specified: filenames,\n\t\tresources and names, or resources and label selector.\n\n\t\tSome resources, such as pods, support graceful deletion. These resources define a default period\n\t\tbefore they are forcibly terminated (the grace period) but you may override that value with\n\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. Because these resources often\n\t\trepresent entities in the cluster, deletion may not be acknowledged immediately. If the node\n\t\thosting a pod is down or cannot reach the API server, termination may take significantly longer\n\t\tthan the grace period. To force delete a resource,\tyou must pass a grace\tperiod of 0 and specify\n\t\tthe --force flag.\n\n\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the pod's processes have been\n\t\tterminated, which can leave those processes running until the node detects the deletion and\n\t\tcompletes graceful deletion. If your processes use shared storage or talk to a remote API and\n\t\tdepend on the name of the pod to identify themselves, force deleting those pods may result in\n\t\tmultiple processes running on different machines using the same identification which may lead\n\t\tto data corruption or inconsistency. Only force delete pods when you are sure the pod is\n\t\tterminated, or if your application can tolerate multiple copies of the same pod running at once.\n\t\tAlso, if you force delete pods the scheduler may place new pods on those nodes before the node\n\t\thas released those resources and causing those pods to be evicted immediately.\n\n\t\tNote that the delete command does NOT do resource version checks, so if someone\n\t\tsubmits an update to a resource right when you submit a delete, their update\n\t\twill be lost along with the rest of the resource.\x00\n\t\tDeprecated: Gracefully shut down a resource by name or filename.\n\n\t\tThe stop command is deprecated, all its functionalities are covered by delete command.\n\t\tSee 'kubectl delete --help' for more details.\n\n\t\tAttempts to shut down and delete a resource that supports graceful termination.\n\t\tIf the resource is scalable it will be scaled to 0 before deletion.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n\n\t\tThe top-node command allows you to see the resource consumption of nodes.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n\n\t\tThe 'top pod' command allows you to see the resource consumption of pods.\n\n\t\tDue to the metrics pipeline delay, they may be unavailable for a few minutes\n\t\tsince pod creation.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage.\n\n\t\tThe top command allows you to see the resource consumption for nodes or pods.\n\n\t\tThis command requires Heapster to be correctly configured and working on the server. \x00\n\t\tDrain node in preparation for maintenance.\n\n\t\tThe given node will be marked unschedulable to prevent new pods from arriving.\n\t\t'drain' evicts the pods if the APIServer supports eviction\n\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use normal DELETE\n\t\tto delete the pods.\n\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot be deleted through\n\t\tthe API server).  If there are DaemonSet-managed pods, drain will not proceed\n\t\twithout --ignore-daemonsets, and regardless it will not delete any\n\t\tDaemonSet-managed pods, because those pods would be immediately replaced by the\n\t\tDaemonSet controller, which ignores unschedulable markings.  If there are any\n\t\tpods that are neither mirror pods nor managed by ReplicationController,\n\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete any pods unless you\n\t\tuse --force.  --force will also allow deletion to proceed if the managing resource of one\n\t\tor more pods is missing.\n\n\t\t'drain' waits for graceful termination. You should not operate on the machine until\n\t\tthe command completes.\n\n\t\tWhen you are ready to put the node back into service, use kubectl uncordon, which\n\t\twill make the node schedulable again.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)\x00\n\t\tEdit a resource from the default editor.\n\n\t\tThe edit command allows you to directly edit any API resource you can retrieve via the\n\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, or EDITOR\n\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for Windows.\n\t\tYou can edit multiple objects, although changes are applied one at a time. The command\n\t\taccepts filenames as well as command line arguments, although the files you point to must\n\t\tbe previously saved versions of resources.\n\n\t\tEditing is done with the API version used to fetch the resource.\n\t\tTo edit using a specific API version, fully-qualify the resource, version, and group.\n\n\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n\n\t\tThe flag --windows-line-endings can be used to force Windows line endings,\n\t\totherwise the default for your operating system will be used.\n\n\t\tIn the event an error occurs while updating, a temporary file will be created on disk\n\t\tthat contains your unapplied changes. The most common error when updating a resource\n\t\tis another editor changing the resource on the server. When this occurs, you will have\n\t\tto apply your changes to the newer version of the resource, or update your temporary\n\t\tsaved copy to include the latest resource version.\x00\n\t\tMark node as schedulable.\x00\n\t\tMark node as unschedulable.\x00\n\t\tOutput shell completion code for the specified shell (bash or zsh).\n\t\tThe shell code must be evaluated to provide interactive\n\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n\t\tthe .bash_profile.\n\n\t\tNote: this requires the bash-completion framework, which is not installed\n\t\tby default on Mac.  This can be installed by using homebrew:\n\n\t\t    $ brew install bash-completion\n\n\t\tOnce installed, bash_completion must be evaluated.  This can be done by adding the\n\t\tfollowing line to the .bash_profile\n\n\t\t    $ source $(brew --prefix)/etc/bash_completion\n\n\t\tNote for zsh users: [1] zsh completions are only supported in versions of zsh >= 5.2\x00\n\t\tPerform a rolling update of the given ReplicationController.\n\n\t\tReplaces the specified replication controller with a new replication controller by updating one pod at a time to use the\n\t\tnew PodTemplate. The new-controller.json must specify the same namespace as the\n\t\texisting replication controller and overwrite at least one (common) label in its replicaSelector.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)\x00\n\t\tReplace a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted. If replacing an existing resource, the\n\t\tcomplete resource spec must be provided. This can be obtained by\n\n\t\t    $ kubectl get TYPE NAME -o yaml\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or Job.\n\n\t\tScale also allows users to specify one or more preconditions for the scale action.\n\n\t\tIf --current-replicas or --resource-version is specified, it is validated before the\n\t\tscale is attempted, and it is guaranteed that the precondition holds true when the\n\t\tscale is sent to the server.\x00\n\t\tSet the latest last-applied-configuration annotations by setting it to match the contents of a file.\n\t\tThis results in the last-applied-configuration being updated as though 'kubectl apply -f <file>' was run,\n\t\twithout updating any other parts of the object.\x00\n\t\tTo proxy all of the kubernetes api and nothing else, use:\n\n\t\t    $ kubectl proxy --api-prefix=/\n\n\t\tTo proxy only part of the kubernetes api and also some static files:\n\n\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/api/\n\n\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n\n\t\tTo proxy the entire kubernetes api at a different root, use:\n\n\t\t    $ kubectl proxy --api-prefix=/custom/\n\n\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'\x00\n\t\tUpdate field(s) of a resource using strategic merge patch\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tUpdate the labels on a resource.\n\n\t\t* A label must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* If --overwrite is true, then existing labels can be overwritten, otherwise attempting to overwrite a label will result in an error.\n\t\t* If --resource-version is specified, then updates will use this resource version, otherwise the existing resource-version will be used.\x00\n\t\tUpdate the taints on one or more nodes.\n\n\t\t* A taint consists of a key, value, and effect. As an argument here, it is expressed as key=value:effect.\n\t\t* The key must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* The value must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[2]d characters.\n\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n\t\t* Currently taint can only apply to node.\x00\n\t\tView the latest last-applied-configuration annotations by type/name or file.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change output format.\x00\n\t    # !!!Important Note!!!\n\t    # Requires that the 'tar' binary is present in your container\n\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n\n\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in the default namespace\n\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n\n        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific container\n\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n\n\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace <some-namespace>\n\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n\n\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar\x00\n\t  # Create a new TLS secret named tls-secret with the given key pair:\n\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/to/tls.key\x00\n\t  # Create a new namespace named my-namespace\n\t  kubectl create namespace my-namespace\x00\n\t  # Create a new secret named my-secret with keys for each file in folder bar\n\t  kubectl create secret generic my-secret --from-file=path/to/bar\n\n\t  # Create a new secret named my-secret with specified keys instead of names on disk\n\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/.ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n\n\t  # Create a new secret named my-secret with key1=supersecret and key2=topsecret\n\t  kubectl create secret generic my-secret --from-literal=key1=supersecret --from-literal=key2=topsecret\x00\n\t  # Create a new service account named my-service-account\n\t  kubectl create serviceaccount my-service-account\x00\n\t# Create a new ExternalName service named my-ns \n\tkubectl create service externalname my-ns --external-name bar.com\x00\n\tCreate an ExternalName service with the specified name.\n\n\tExternalName service references to an external DNS address instead of\n\tonly pods, which will allow application authors to reference services\n\tthat exist off platform, on other clusters, or locally.\x00\n\tHelp provides help for any command in the application.\n\tSimply type kubectl help [path to command] for full details.\x00\n    # Create a new LoadBalancer service named my-lbs\n    kubectl create service loadbalancer my-lbs --tcp=5678:8080\x00\n    # Create a new clusterIP service named my-cs\n    kubectl create service clusterip my-cs --tcp=5678:8080\n\n    # Create a new clusterIP service named my-cs (in headless mode)\n    kubectl create service clusterip my-cs --clusterip=\"None\"\x00\n    # Create a new deployment named my-dep that runs the busybox image.\n    kubectl create deployment my-dep --image=busybox\x00\n    # Create a new nodeport service named my-ns\n    kubectl create service nodeport my-ns --tcp=5678:8080\x00\n    # Dump current cluster state to stdout\n    kubectl cluster-info dump\n\n    # Dump current cluster state to /path/to/cluster-state\n    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n\n    # Dump all namespaces to stdout\n    kubectl cluster-info dump --all-namespaces\n\n    # Dump a set of namespaces to /path/to/cluster-state\n    kubectl cluster-info dump --namespaces default,kube-system --output-directory=/path/to/cluster-state\x00\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend'.\n    # If the same annotation is set multiple times, only the last value will be applied\n    kubectl annotate pods foo description='my frontend'\n\n    # Update a pod identified by type and name in \"pod.json\"\n    kubectl annotate -f pod.json description='my frontend'\n\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend running nginx', overwriting any existing value.\n    kubectl annotate --overwrite pods foo description='my frontend running nginx'\n\n    # Update all pods in the namespace\n    kubectl annotate pods --all description='my frontend running nginx'\n\n    # Update pod 'foo' only if the resource is unchanged from version 1.\n    kubectl annotate pods foo description='my frontend running nginx' --resource-version=1\n\n    # Update pod 'foo' by removing an annotation named 'description' if it exists.\n    # Does not require the --overwrite flag.\n    kubectl annotate pods foo description-\x00\n    Create a LoadBalancer service with the specified name.\x00\n    Create a clusterIP service with the specified name.\x00\n    Create a deployment with the specified name.\x00\n    Create a nodeport service with the specified name.\x00\n    Dumps cluster info out suitable for debugging and diagnosing cluster problems.  By default, dumps everything to\n    stdout. You can optionally specify a directory with --output-directory.  If you specify a directory, kubernetes will\n    build a set of files in that directory.  By default only dumps things in the 'kube-system' namespace, but you can\n    switch to a different namespace with the --namespaces flag, or specify --all-namespaces to dump all namespaces.\n\n    The command also dumps the logs of all of the pods in the cluster, these logs are dumped into different directories\n    based on namespace and pod name.\x00\n  Display addresses of the master and services with label kubernetes.io/cluster-service=true\n  To further debug and diagnose cluster problems, use 'kubectl cluster-info dump'.\x00A comma-delimited set of quota scopes that must all match each object tracked by the quota.\x00A comma-delimited set of resource=quantity pairs that define a hard limit.\x00A label selector to use for this budget. Only equality-based selector requirements are supported.\x00A label selector to use for this service. Only equality-based selector requirements are supported. If empty (the default) infer the selector from the replication controller or replica set.)\x00A schedule in the Cron format the job should be run with.\x00Additional external IP address (not managed by Kubernetes) to accept for the service. If this IP is routed to a node, the service can be accessed by this IP in addition to its generated service IP.\x00An inline JSON override for the generated object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.\x00An inline JSON override for the generated service object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.  Only used if --expose is true.\x00Apply a configuration to a resource by filename or stdin\x00Approve a certificate signing request\x00Assign your own ClusterIP or set to 'None' for a 'headless' service (no loadbalancing).\x00Attach to a running container\x00Auto-scale a Deployment, ReplicaSet, or ReplicationController\x00ClusterIP to be assigned to the service. Leave empty to auto-allocate, or set to 'None' to create a headless service.\x00ClusterRole this ClusterRoleBinding should reference\x00ClusterRole this RoleBinding should reference\x00Container name which will have its image upgraded. Only relevant when --image is specified, ignored otherwise. Required when using --image on a multi-container pod\x00Convert config files between different API versions\x00Copy files and directories to and from containers.\x00Create a ClusterRoleBinding for a particular ClusterRole\x00Create a LoadBalancer service.\x00Create a NodePort service.\x00Create a RoleBinding for a particular Role or ClusterRole\x00Create a TLS secret\x00Create a clusterIP service.\x00Create a configmap from a local file, directory or literal value\x00Create a deployment with the specified name.\x00Create a namespace with the specified name\x00Create a pod disruption budget with the specified name.\x00Create a quota with the specified name.\x00Create a resource by filename or stdin\x00Create a secret for use with a Docker registry\x00Create a secret from a local file, directory or literal value\x00Create a secret using specified subcommand\x00Create a service account with the specified name\x00Create a service using specified subcommand.\x00Create an ExternalName service.\x00Delete resources by filenames, stdin, resources and names, or by resources and label selector\x00Delete the specified cluster from the kubeconfig\x00Delete the specified context from the kubeconfig\x00Deny a certificate signing request\x00Deprecated: Gracefully shut down a resource by name or filename\x00Describe one or many contexts\x00Display Resource (CPU/Memory) usage of nodes\x00Display Resource (CPU/Memory) usage of pods\x00Display Resource (CPU/Memory) usage.\x00Display cluster info\x00Display clusters defined in the kubeconfig\x00Display merged kubeconfig settings or a specified kubeconfig file\x00Display one or many resources\x00Displays the current-context\x00Documentation of resources\x00Drain node in preparation for maintenance\x00Dump lots of relevant info for debugging and diagnosis\x00Edit a resource on the server\x00Email for Docker registry\x00Execute a command in a container\x00Explicit policy for when to pull container images. Required when --image is same as existing image, ignored otherwise.\x00Forward one or more local ports to a pod\x00Help about any command\x00IP to assign to the Load Balancer. If empty, an ephemeral IP will be created and used (cloud-provider specific).\x00If non-empty, set the session affinity for the service to this; legal values: 'None', 'ClientIP'\x00If non-empty, the annotation update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00If non-empty, the labels update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00Image to use for upgrading the replication controller. Must be distinct from the existing image (either new image or new image tag).  Can not be used with --filename/-f\x00Manage a deployment rollout\x00Mark node as schedulable\x00Mark node as unschedulable\x00Mark the provided resource as paused\x00Modify certificate resources.\x00Modify kubeconfig files\x00Name or number for the port on the container that the service should direct traffic to. Optional.\x00Only return logs after a specific date (RFC3339). Defaults to all logs. Only one of since-time / since may be used.\x00Output shell completion code for the specified shell (bash or zsh)\x00Output the formatted object with the given group version (for ex: 'extensions/v1beta1').)\x00Password for Docker registry authentication\x00Path to PEM encoded public key certificate.\x00Path to private key associated with given certificate.\x00Perform a rolling update of the given ReplicationController\x00Precondition for resource version. Requires that the current resource version match this value in order to scale.\x00Print the client and server version information\x00Print the list of flags inherited by all commands\x00Print the logs for a container in a pod\x00Replace a resource by filename or stdin\x00Resume a paused resource\x00Role this RoleBinding should reference\x00Run a particular image on the cluster\x00Run a proxy to the Kubernetes API server\x00Server location for Docker registry\x00Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job\x00Set specific features on objects\x00Set the last-applied-configuration annotation on a live object to match the contents of a file.\x00Set the selector on a resource\x00Sets a cluster entry in kubeconfig\x00Sets a context entry in kubeconfig\x00Sets a user entry in kubeconfig\x00Sets an individual value in a kubeconfig file\x00Sets the current-context in a kubeconfig file\x00Show details of a specific resource or group of resources\x00Show the status of the rollout\x00Synonym for --target-port\x00Take a replication controller, service, deployment or pod and expose it as a new Kubernetes Service\x00The image for the container to run.\x00The image pull policy for the container. If left empty, this value will not be specified by the client and defaulted by the server\x00The key to use to differentiate between two different controllers, default 'deployment'.  Only relevant when --image is specified, ignored otherwise\x00The minimum number or percentage of available pods this budget requires.\x00The name for the newly created object.\x00The name for the newly created object. If not specified, the name of the input resource will be used.\x00The name of the API generator to use, see http://kubernetes.io/docs/user-guide/kubectl-conventions/#generators for a list.\x00The name of the API generator to use. Currently there is only 1 generator.\x00The name of the API generator to use. There are 2 generators: 'service/v1' and 'service/v2'. The only difference between them is that service port in v1 is named 'default', while it is left unnamed in v2. Default is 'service/v2'.\x00The name of the generator to use for creating a service.  Only used if --expose is true\x00The network protocol for the service to be created. Default is 'TCP'.\x00The port that the service should serve on. Copied from the resource being exposed, if unspecified\x00The port that this container exposes.  If --expose is true, this is also the port used by the service that is created.\x00The resource requirement limits for this container.  For example, 'cpu=200m,memory=512Mi'.  Note that server side components may assign limits depending on the server configuration, such as limit ranges.\x00The resource requirement requests for this container.  For example, 'cpu=100m,memory=256Mi'.  Note that server side components may assign requests depending on the server configuration, such as limit ranges.\x00The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  If set to 'Always' a deployment is created, if set to 'OnFailure' a job is created, if set to 'Never', a regular pod is created. For the latter two --replicas must be 1.  Default 'Always', for CronJobs `Never`.\x00The type of secret to create\x00Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is 'ClusterIP'.\x00Undo a previous rollout\x00Unsets an individual value in a kubeconfig file\x00Update field(s) of a resource using strategic merge patch\x00Update image of a pod template\x00Update resource requests/limits on objects with pod templates\x00Update the annotations on a resource\x00Update the labels on a resource\x00Update the taints on one or more nodes\x00Username for Docker registry authentication\x00View latest last-applied-configuration annotations of a resource/object\x00View rollout history\x00Where to output the files.  If empty or '-' uses stdout, otherwise creates a directory hierarchy in that directory\x00dummy restart flag)\x00external name of service\x00kubectl controls the Kubernetes cluster manager\x00")

func translationsKubectlEn_usLc_messagesK8sMoBytes() ([]byte, error) {
	return _translationsKubectlEn_usLc_messagesK8sMo, nil
}

func translationsKubectlEn_usLc_messagesK8sMo() (*asset, error) {
	bytes, err := translationsKubectlEn_usLc_messagesK8sMoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/en_US/LC_MESSAGES/k8s.mo", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlEn_usLc_messagesK8sPo = []byte(`# Test translations for unit tests.
# Copyright (C) 2016
# This file is distributed under the same license as the Kubernetes package.
# FIRST AUTHOR brendan.d.burns@gmail.com, 2016.
#
msgid ""
msgstr ""
"Project-Id-Version: gettext-go-examples-hello\n"
"Report-Msgid-Bugs-To: EMAIL\n"
"POT-Creation-Date: 2017-03-14 21:32-0700\n"
"PO-Revision-Date: 2017-03-14 21:33-0800\n"
"Last-Translator: Brendan Burns <brendan.d.burns@gmail.com>\n"
"Language-Team: \n"
"Language: en\n"
"MIME-Version: 1.0\n"
"Content-Type: text/plain; charset=UTF-8\n"
"Content-Transfer-Encoding: 8bit\n"
"X-Generator: Poedit 1.6.10\n"
"X-Poedit-SourceCharset: UTF-8\n"
"Plural-Forms: nplurals=2; plural=(n != 1);\n"

#: pkg/kubectl/cmd/create_clusterrolebinding.go:35
msgid ""
"\n"
"\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the "
"cluster-admin ClusterRole\n"
"\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-"
"admin --user=user1 --user=user2 --group=group1"
msgstr ""
"\n"
"\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the "
"cluster-admin ClusterRole\n"
"\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-"
"admin --user=user1 --user=user2 --group=group1"

#: pkg/kubectl/cmd/create_rolebinding.go:35
msgid ""
"\n"
"\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin "
"ClusterRole\n"
"\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --"
"user=user2 --group=group1"
msgstr ""
"\n"
"\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin "
"ClusterRole\n"
"\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --"
"user=user2 --group=group1"

#: pkg/kubectl/cmd/create_configmap.go:44
msgid ""
"\n"
"\t\t  # Create a new configmap named my-config based on folder bar\n"
"\t\t  kubectl create configmap my-config --from-file=path/to/bar\n"
"\n"
"\t\t  # Create a new configmap named my-config with specified keys instead "
"of file basenames on disk\n"
"\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1."
"txt --from-file=key2=/path/to/bar/file2.txt\n"
"\n"
"\t\t  # Create a new configmap named my-config with key1=config1 and "
"key2=config2\n"
"\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-"
"literal=key2=config2"
msgstr ""
"\n"
"\t\t  # Create a new configmap named my-config based on folder bar\n"
"\t\t  kubectl create configmap my-config --from-file=path/to/bar\n"
"\n"
"\t\t  # Create a new configmap named my-config with specified keys instead "
"of file basenames on disk\n"
"\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1."
"txt --from-file=key2=/path/to/bar/file2.txt\n"
"\n"
"\t\t  # Create a new configmap named my-config with key1=config1 and "
"key2=config2\n"
"\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-"
"literal=key2=config2"

#: pkg/kubectl/cmd/create_secret.go:135
msgid ""
"\n"
"\t\t  # If you don't already have a .dockercfg file, you can create a "
"dockercfg secret directly by using:\n"
"\t\t  kubectl create secret docker-registry my-secret --docker-"
"server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-"
"password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL"
msgstr ""
"\n"
"\t\t  # If you don't already have a .dockercfg file, you can create a "
"dockercfg secret directly by using:\n"
"\t\t  kubectl create secret docker-registry my-secret --docker-"
"server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-"
"password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL"

#: pkg/kubectl/cmd/top_node.go:65
msgid ""
"\n"
"\t\t  # Show metrics for all nodes\n"
"\t\t  kubectl top node\n"
"\n"
"\t\t  # Show metrics for a given node\n"
"\t\t  kubectl top node NODE_NAME"
msgstr ""
"\n"
"\t\t  # Show metrics for all nodes\n"
"\t\t  kubectl top node\n"
"\n"
"\t\t  # Show metrics for a given node\n"
"\t\t  kubectl top node NODE_NAME"

#: pkg/kubectl/cmd/apply.go:84
msgid ""
"\n"
"\t\t# Apply the configuration in pod.json to a pod.\n"
"\t\tkubectl apply -f ./pod.json\n"
"\n"
"\t\t# Apply the JSON passed into stdin to a pod.\n"
"\t\tcat pod.json | kubectl apply -f -\n"
"\n"
"\t\t# Note: --prune is still in Alpha\n"
"\t\t# Apply the configuration in manifest.yaml that matches label app=nginx "
"and delete all the other resources that are not in the file and match label "
"app=nginx.\n"
"\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n"
"\n"
"\t\t# Apply the configuration in manifest.yaml and delete all the other "
"configmaps that are not in the file.\n"
"\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/"
"ConfigMap"
msgstr ""
"\n"
"\t\t# Apply the configuration in pod.json to a pod.\n"
"\t\tkubectl apply -f ./pod.json\n"
"\n"
"\t\t# Apply the JSON passed into stdin to a pod.\n"
"\t\tcat pod.json | kubectl apply -f -\n"
"\n"
"\t\t# Note: --prune is still in Alpha\n"
"\t\t# Apply the configuration in manifest.yaml that matches label app=nginx "
"and delete all the other resources that are not in the file and match label "
"app=nginx.\n"
"\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n"
"\n"
"\t\t# Apply the configuration in manifest.yaml and delete all the other "
"configmaps that are not in the file.\n"
"\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/"
"ConfigMap"

#: pkg/kubectl/cmd/autoscale.go:40
#, c-format
msgid ""
"\n"
"\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and "
"10, no target CPU utilization specified so a default autoscaling policy will "
"be used:\n"
"\t\tkubectl autoscale deployment foo --min=2 --max=10\n"
"\n"
"\t\t# Auto scale a replication controller \"foo\", with the number of pods "
"between 1 and 5, target CPU utilization at 80%:\n"
"\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80"
msgstr ""
"\n"
"\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and "
"10, no target CPU utilization specified so a default autoscaling policy will "
"be used:\n"
"\t\tkubectl autoscale deployment foo --min=2 --max=10\n"
"\n"
"\t\t# Auto scale a replication controller \"foo\", with the number of pods "
"between 1 and 5, target CPU utilization at 80%:\n"
"\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80"

#: pkg/kubectl/cmd/convert.go:49
msgid ""
"\n"
"\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n"
"\t\tkubectl convert -f pod.yaml\n"
"\n"
"\t\t# Convert the live state of the resource specified by 'pod.yaml' to the "
"latest version\n"
"\t\t# and print to stdout in json format.\n"
"\t\tkubectl convert -f pod.yaml --local -o json\n"
"\n"
"\t\t# Convert all files under current directory to latest version and create "
"them all.\n"
"\t\tkubectl convert -f . | kubectl create -f -"
msgstr ""
"\n"
"\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n"
"\t\tkubectl convert -f pod.yaml\n"
"\n"
"\t\t# Convert the live state of the resource specified by 'pod.yaml' to the "
"latest version\n"
"\t\t# and print to stdout in json format.\n"
"\t\tkubectl convert -f pod.yaml --local -o json\n"
"\n"
"\t\t# Convert all files under current directory to latest version and create "
"them all.\n"
"\t\tkubectl convert -f . | kubectl create -f -"

#: pkg/kubectl/cmd/create_clusterrole.go:34
msgid ""
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform "
"\"get\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods\n"
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods --resource-name=readablepod"
msgstr ""
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform "
"\"get\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods\n"
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods --resource-name=readablepod"

#: pkg/kubectl/cmd/create_role.go:41
msgid ""
"\n"
"\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get"
"\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --"
"resource=pods\n"
"\n"
"\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --"
"resource=pods --resource-name=readablepod"
msgstr ""
"\n"
"\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get"
"\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --"
"resource=pods\n"
"\n"
"\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --"
"resource=pods --resource-name=readablepod"

#: pkg/kubectl/cmd/create_quota.go:35
msgid ""
"\n"
"\t\t# Create a new resourcequota named my-quota\n"
"\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,"
"replicationcontrollers=2,resourcequotas=1,secrets=5,"
"persistentvolumeclaims=10\n"
"\n"
"\t\t# Create a new resourcequota named best-effort\n"
"\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort"
msgstr ""
"\n"
"\t\t# Create a new resourcequota named my-quota\n"
"\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,"
"replicationcontrollers=2,resourcequotas=1,secrets=5,"
"persistentvolumeclaims=10\n"
"\n"
"\t\t# Create a new resourcequota named best-effort\n"
"\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort"

#: pkg/kubectl/cmd/create_pdb.go:35
#, c-format
msgid ""
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=rails label\n"
"\t\t# and require at least one of them being available at any point in "
"time.\n"
"\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-"
"available=1\n"
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=nginx label\n"
"\t\t# and require at least half of the pods selected to be available at any "
"point in time.\n"
"\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%"
msgstr ""
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=rails label\n"
"\t\t# and require at least one of them being available at any point in "
"time.\n"
"\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-"
"available=1\n"
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=nginx label\n"
"\t\t# and require at least half of the pods selected to be available at any "
"point in time.\n"
"\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%"

#: pkg/kubectl/cmd/create.go:47
msgid ""
"\n"
"\t\t# Create a pod using the data in pod.json.\n"
"\t\tkubectl create -f ./pod.json\n"
"\n"
"\t\t# Create a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl create -f -\n"
"\n"
"\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format "
"then create the resource using the edited data.\n"
"\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json"
msgstr ""
"\n"
"\t\t# Create a pod using the data in pod.json.\n"
"\t\tkubectl create -f ./pod.json\n"
"\n"
"\t\t# Create a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl create -f -\n"
"\n"
"\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format "
"then create the resource using the edited data.\n"
"\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json"

#: pkg/kubectl/cmd/expose.go:53
msgid ""
"\n"
"\t\t# Create a service for a replicated nginx, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose rc nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a replication controller identified by type and "
"name specified in \"nginx-controller.yaml\", which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a pod valid-pod, which serves on port 444 with "
"the name \"frontend\"\n"
"\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n"
"\n"
"\t\t# Create a second service based on the above service, exposing the "
"container port 8443 as port 443 with the name \"nginx-https\"\n"
"\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-"
"https\n"
"\n"
"\t\t# Create a service for a replicated streaming application on port 4100 "
"balancing UDP traffic and named 'video-stream'.\n"
"\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-"
"stream\n"
"\n"
"\t\t# Create a service for a replicated nginx using replica set, which "
"serves on port 80 and connects to the containers on port 8000.\n"
"\t\tkubectl expose rs nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for an nginx deployment, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose deployment nginx --port=80 --target-port=8000"
msgstr ""
"\n"
"\t\t# Create a service for a replicated nginx, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose rc nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a replication controller identified by type and "
"name specified in \"nginx-controller.yaml\", which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a pod valid-pod, which serves on port 444 with "
"the name \"frontend\"\n"
"\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n"
"\n"
"\t\t# Create a second service based on the above service, exposing the "
"container port 8443 as port 443 with the name \"nginx-https\"\n"
"\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-"
"https\n"
"\n"
"\t\t# Create a service for a replicated streaming application on port 4100 "
"balancing UDP traffic and named 'video-stream'.\n"
"\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-"
"stream\n"
"\n"
"\t\t# Create a service for a replicated nginx using replica set, which "
"serves on port 80 and connects to the containers on port 8000.\n"
"\t\tkubectl expose rs nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for an nginx deployment, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose deployment nginx --port=80 --target-port=8000"

#: pkg/kubectl/cmd/delete.go:68
msgid ""
"\n"
"\t\t# Delete a pod using the type and name specified in pod.json.\n"
"\t\tkubectl delete -f ./pod.json\n"
"\n"
"\t\t# Delete a pod based on the type and name in the JSON passed into "
"stdin.\n"
"\t\tcat pod.json | kubectl delete -f -\n"
"\n"
"\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n"
"\t\tkubectl delete pod,service baz foo\n"
"\n"
"\t\t# Delete pods and services with label name=myLabel.\n"
"\t\tkubectl delete pods,services -l name=myLabel\n"
"\n"
"\t\t# Delete a pod with minimal delay\n"
"\t\tkubectl delete pod foo --now\n"
"\n"
"\t\t# Force delete a pod on a dead node\n"
"\t\tkubectl delete pod foo --grace-period=0 --force\n"
"\n"
"\t\t# Delete all pods\n"
"\t\tkubectl delete pods --all"
msgstr ""
"\n"
"\t\t# Delete a pod using the type and name specified in pod.json.\n"
"\t\tkubectl delete -f ./pod.json\n"
"\n"
"\t\t# Delete a pod based on the type and name in the JSON passed into "
"stdin.\n"
"\t\tcat pod.json | kubectl delete -f -\n"
"\n"
"\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n"
"\t\tkubectl delete pod,service baz foo\n"
"\n"
"\t\t# Delete pods and services with label name=myLabel.\n"
"\t\tkubectl delete pods,services -l name=myLabel\n"
"\n"
"\t\t# Delete a pod with minimal delay\n"
"\t\tkubectl delete pod foo --now\n"
"\n"
"\t\t# Force delete a pod on a dead node\n"
"\t\tkubectl delete pod foo --grace-period=0 --force\n"
"\n"
"\t\t# Delete all pods\n"
"\t\tkubectl delete pods --all"

#: pkg/kubectl/cmd/describe.go:54
msgid ""
"\n"
"\t\t# Describe a node\n"
"\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n"
"\n"
"\t\t# Describe a pod\n"
"\t\tkubectl describe pods/nginx\n"
"\n"
"\t\t# Describe a pod identified by type and name in \"pod.json\"\n"
"\t\tkubectl describe -f pod.json\n"
"\n"
"\t\t# Describe all pods\n"
"\t\tkubectl describe pods\n"
"\n"
"\t\t# Describe pods by label name=myLabel\n"
"\t\tkubectl describe po -l name=myLabel\n"
"\n"
"\t\t# Describe all pods managed by the 'frontend' replication controller (rc-"
"created pods\n"
"\t\t# get the name of the rc as a prefix in the pod the name).\n"
"\t\tkubectl describe pods frontend"
msgstr ""
"\n"
"\t\t# Describe a node\n"
"\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n"
"\n"
"\t\t# Describe a pod\n"
"\t\tkubectl describe pods/nginx\n"
"\n"
"\t\t# Describe a pod identified by type and name in \"pod.json\"\n"
"\t\tkubectl describe -f pod.json\n"
"\n"
"\t\t# Describe all pods\n"
"\t\tkubectl describe pods\n"
"\n"
"\t\t# Describe pods by label name=myLabel\n"
"\t\tkubectl describe po -l name=myLabel\n"
"\n"
"\t\t# Describe all pods managed by the 'frontend' replication controller (rc-"
"created pods\n"
"\t\t# get the name of the rc as a prefix in the pod the name).\n"
"\t\tkubectl describe pods frontend"

#: pkg/kubectl/cmd/drain.go:165
msgid ""
"\n"
"\t\t# Drain node \"foo\", even if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n"
"\t\t$ kubectl drain foo --force\n"
"\n"
"\t\t# As above, but abort if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a "
"grace period of 15 minutes.\n"
"\t\t$ kubectl drain foo --grace-period=900"
msgstr ""
"\n"
"\t\t# Drain node \"foo\", even if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n"
"\t\t$ kubectl drain foo --force\n"
"\n"
"\t\t# As above, but abort if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a "
"grace period of 15 minutes.\n"
"\t\t$ kubectl drain foo --grace-period=900"

#: pkg/kubectl/cmd/edit.go:80
msgid ""
"\n"
"\t\t# Edit the service named 'docker-registry':\n"
"\t\tkubectl edit svc/docker-registry\n"
"\n"
"\t\t# Use an alternative editor\n"
"\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n"
"\n"
"\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n"
"\t\tkubectl edit job.v1.batch/myjob -o json\n"
"\n"
"\t\t# Edit the deployment 'mydeployment' in YAML and save the modified "
"config in its annotation:\n"
"\t\tkubectl edit deployment/mydeployment -o yaml --save-config"
msgstr ""
"\n"
"\t\t# Edit the service named 'docker-registry':\n"
"\t\tkubectl edit svc/docker-registry\n"
"\n"
"\t\t# Use an alternative editor\n"
"\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n"
"\n"
"\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n"
"\t\tkubectl edit job.v1.batch/myjob -o json\n"
"\n"
"\t\t# Edit the deployment 'mydeployment' in YAML and save the modified "
"config in its annotation:\n"
"\t\tkubectl edit deployment/mydeployment -o yaml --save-config"

#: pkg/kubectl/cmd/exec.go:41
msgid ""
"\n"
"\t\t# Get output from running 'date' from pod 123456-7890, using the first "
"container by default\n"
"\t\tkubectl exec 123456-7890 date\n"
"\n"
"\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n"
"\t\tkubectl exec 123456-7890 -c ruby-container date\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il"
msgstr ""
"\n"
"\t\t# Get output from running 'date' from pod 123456-7890, using the first "
"container by default\n"
"\t\tkubectl exec 123456-7890 date\n"
"\n"
"\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n"
"\t\tkubectl exec 123456-7890 -c ruby-container date\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il"

#: pkg/kubectl/cmd/attach.go:42
msgid ""
"\n"
"\t\t# Get output from running pod 123456-7890, using the first container by "
"default\n"
"\t\tkubectl attach 123456-7890\n"
"\n"
"\t\t# Get output from ruby-container from pod 123456-7890\n"
"\t\tkubectl attach 123456-7890 -c ruby-container\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n"
"\n"
"\t\t# Get output from the first pod of a ReplicaSet named nginx\n"
"\t\tkubectl attach rs/nginx\n"
"\t\t"
msgstr ""
"\n"
"\t\t# Get output from running pod 123456-7890, using the first container by "
"default\n"
"\t\tkubectl attach 123456-7890\n"
"\n"
"\t\t# Get output from ruby-container from pod 123456-7890\n"
"\t\tkubectl attach 123456-7890 -c ruby-container\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n"
"\n"
"\t\t# Get output from the first pod of a ReplicaSet named nginx\n"
"\t\tkubectl attach rs/nginx\n"
"\t\t"

#: pkg/kubectl/cmd/explain.go:39
msgid ""
"\n"
"\t\t# Get the documentation of the resource and its fields\n"
"\t\tkubectl explain pods\n"
"\n"
"\t\t# Get the documentation of a specific field of a resource\n"
"\t\tkubectl explain pods.spec.containers"
msgstr ""
"\n"
"\t\t# Get the documentation of the resource and its fields\n"
"\t\tkubectl explain pods\n"
"\n"
"\t\t# Get the documentation of a specific field of a resource\n"
"\t\tkubectl explain pods.spec.containers"

#: pkg/kubectl/cmd/completion.go:65
msgid ""
"\n"
"\t\t# Install bash completion on a Mac using homebrew\n"
"\t\tbrew install bash-completion\n"
"\t\tprintf \"\n"
"# Bash completion support\n"
"source $(brew --prefix)/etc/bash_completion\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for bash into the current shell\n"
"\t\tsource <(kubectl completion bash)\n"
"\n"
"\t\t# Write bash completion code to a file and source if from .bash_profile\n"
"\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n"
"\t\tprintf \"\n"
"# Kubectl shell completion\n"
"source '$HOME/.kube/completion.bash.inc'\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for zsh[1] into the current shell\n"
"\t\tsource <(kubectl completion zsh)"
msgstr ""
"\n"
"\t\t# Install bash completion on a Mac using homebrew\n"
"\t\tbrew install bash-completion\n"
"\t\tprintf \"\n"
"# Bash completion support\n"
"source $(brew --prefix)/etc/bash_completion\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for bash into the current shell\n"
"\t\tsource <(kubectl completion bash)\n"
"\n"
"\t\t# Write bash completion code to a file and source if from .bash_profile\n"
"\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n"
"\t\tprintf \"\n"
"# Kubectl shell completion\n"
"source '$HOME/.kube/completion.bash.inc'\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for zsh[1] into the current shell\n"
"\t\tsource <(kubectl completion zsh)"

#: pkg/kubectl/cmd/get.go:64
msgid ""
"\n"
"\t\t# List all pods in ps output format.\n"
"\t\tkubectl get pods\n"
"\n"
"\t\t# List all pods in ps output format with more information (such as node "
"name).\n"
"\t\tkubectl get pods -o wide\n"
"\n"
"\t\t# List a single replication controller with specified NAME in ps output "
"format.\n"
"\t\tkubectl get replicationcontroller web\n"
"\n"
"\t\t# List a single pod in JSON output format.\n"
"\t\tkubectl get -o json pod web-pod-13je7\n"
"\n"
"\t\t# List a pod identified by type and name specified in \"pod.yaml\" in "
"JSON output format.\n"
"\t\tkubectl get -f pod.yaml -o json\n"
"\n"
"\t\t# Return only the phase value of the specified pod.\n"
"\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n"
"\n"
"\t\t# List all replication controllers and services together in ps output "
"format.\n"
"\t\tkubectl get rc,services\n"
"\n"
"\t\t# List one or more resources by their type and names.\n"
"\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n"
"\n"
"\t\t# List all resources with different types.\n"
"\t\tkubectl get all"
msgstr ""
"\n"
"\t\t# List all pods in ps output format.\n"
"\t\tkubectl get pods\n"
"\n"
"\t\t# List all pods in ps output format with more information (such as node "
"name).\n"
"\t\tkubectl get pods -o wide\n"
"\n"
"\t\t# List a single replication controller with specified NAME in ps output "
"format.\n"
"\t\tkubectl get replicationcontroller web\n"
"\n"
"\t\t# List a single pod in JSON output format.\n"
"\t\tkubectl get -o json pod web-pod-13je7\n"
"\n"
"\t\t# List a pod identified by type and name specified in \"pod.yaml\" in "
"JSON output format.\n"
"\t\tkubectl get -f pod.yaml -o json\n"
"\n"
"\t\t# Return only the phase value of the specified pod.\n"
"\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n"
"\n"
"\t\t# List all replication controllers and services together in ps output "
"format.\n"
"\t\tkubectl get rc,services\n"
"\n"
"\t\t# List one or more resources by their type and names.\n"
"\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n"
"\n"
"\t\t# List all resources with different types.\n"
"\t\tkubectl get all"

#: pkg/kubectl/cmd/portforward.go:53
msgid ""
"\n"
"\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports "
"5000 and 6000 in the pod\n"
"\t\tkubectl port-forward mypod 5000 6000\n"
"\n"
"\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 8888:5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod :5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 0:5000"
msgstr ""
"\n"
"\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports "
"5000 and 6000 in the pod\n"
"\t\tkubectl port-forward mypod 5000 6000\n"
"\n"
"\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 8888:5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod :5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 0:5000"

#: pkg/kubectl/cmd/drain.go:118
msgid ""
"\n"
"\t\t# Mark node \"foo\" as schedulable.\n"
"\t\t$ kubectl uncordon foo"
msgstr ""
"\n"
"\t\t# Mark node \"foo\" as schedulable.\n"
"\t\t$ kubectl uncordon foo"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L102
#: pkg/kubectl/cmd/drain.go:93
msgid ""
"\n"
"\t\t# Mark node \"foo\" as unschedulable.\n"
"\t\tkubectl cordon foo"
msgstr ""
"\n"
"\t\t# Mark node \"foo\" as unschedulable.\n"
"\t\tkubectl cordon foo"

#: pkg/kubectl/cmd/patch.go:66
msgid ""
"\n"
"\t\t# Partially update a node using strategic merge patch\n"
"\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Partially update a node identified by the type and name specified in "
"\"node.json\" using strategic merge patch\n"
"\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Update a container's image; spec.containers[*].name is required "
"because it's a merge key\n"
"\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":"
"\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n"
"\n"
"\t\t# Update a container's image using a json patch with positional arrays\n"
"\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", "
"\"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'"
msgstr ""
"\n"
"\t\t# Partially update a node using strategic merge patch\n"
"\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Partially update a node identified by the type and name specified in "
"\"node.json\" using strategic merge patch\n"
"\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Update a container's image; spec.containers[*].name is required "
"because it's a merge key\n"
"\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":"
"\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n"
"\n"
"\t\t# Update a container's image using a json patch with positional arrays\n"
"\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", "
"\"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/options.go#L37
#: pkg/kubectl/cmd/options.go:29
msgid ""
"\n"
"\t\t# Print flags inherited by all commands\n"
"\t\tkubectl options"
msgstr ""
"\n"
"\t\t# Print flags inherited by all commands\n"
"\t\tkubectl options"

#: pkg/kubectl/cmd/clusterinfo.go:41
msgid ""
"\n"
"\t\t# Print the address of the master and cluster services\n"
"\t\tkubectl cluster-info"
msgstr ""
"\n"
"\t\t# Print the address of the master and cluster services\n"
"\t\tkubectl cluster-info"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/version.go#L39
#: pkg/kubectl/cmd/version.go:32
msgid ""
"\n"
"\t\t# Print the client and server versions for the current context\n"
"\t\tkubectl version"
msgstr ""
"\n"
"\t\t# Print the client and server versions for the current context\n"
"\t\tkubectl version"

#: pkg/kubectl/cmd/apiversions.go:34
msgid ""
"\n"
"\t\t# Print the supported API versions\n"
"\t\tkubectl api-versions"
msgstr ""
"\n"
"\t\t# Print the supported API versions\n"
"\t\tkubectl api-versions"

#: pkg/kubectl/cmd/replace.go:50
msgid ""
"\n"
"\t\t# Replace a pod using the data in pod.json.\n"
"\t\tkubectl replace -f ./pod.json\n"
"\n"
"\t\t# Replace a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl replace -f -\n"
"\n"
"\t\t# Update a single-container pod's image version (tag) to v4\n"
"\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/:v4/' | "
"kubectl replace -f -\n"
"\n"
"\t\t# Force replace, delete and then re-create the resource\n"
"\t\tkubectl replace --force -f ./pod.json"
msgstr ""
"\n"
"\t\t# Replace a pod using the data in pod.json.\n"
"\t\tkubectl replace -f ./pod.json\n"
"\n"
"\t\t# Replace a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl replace -f -\n"
"\n"
"\t\t# Update a single-container pod's image version (tag) to v4\n"
"\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/:v4/' | "
"kubectl replace -f -\n"
"\n"
"\t\t# Force replace, delete and then re-create the resource\n"
"\t\tkubectl replace --force -f ./pod.json"

#: pkg/kubectl/cmd/logs.go:40
msgid ""
"\n"
"\t\t# Return snapshot logs from pod nginx with only one container\n"
"\t\tkubectl logs nginx\n"
"\n"
"\t\t# Return snapshot logs for the pods defined by label app=nginx\n"
"\t\tkubectl logs -lapp=nginx\n"
"\n"
"\t\t# Return snapshot of previous terminated ruby container logs from pod "
"web-1\n"
"\t\tkubectl logs -p -c ruby web-1\n"
"\n"
"\t\t# Begin streaming the logs of the ruby container in pod web-1\n"
"\t\tkubectl logs -f -c ruby web-1\n"
"\n"
"\t\t# Display only the most recent 20 lines of output in pod nginx\n"
"\t\tkubectl logs --tail=20 nginx\n"
"\n"
"\t\t# Show all logs from pod nginx written in the last hour\n"
"\t\tkubectl logs --since=1h nginx\n"
"\n"
"\t\t# Return snapshot logs from first container of a job named hello\n"
"\t\tkubectl logs job/hello\n"
"\n"
"\t\t# Return snapshot logs from container nginx-1 of a deployment named "
"nginx\n"
"\t\tkubectl logs deployment/nginx -c nginx-1"
msgstr ""
"\n"
"\t\t# Return snapshot logs from pod nginx with only one container\n"
"\t\tkubectl logs nginx\n"
"\n"
"\t\t# Return snapshot logs for the pods defined by label app=nginx\n"
"\t\tkubectl logs -lapp=nginx\n"
"\n"
"\t\t# Return snapshot of previous terminated ruby container logs from pod "
"web-1\n"
"\t\tkubectl logs -p -c ruby web-1\n"
"\n"
"\t\t# Begin streaming the logs of the ruby container in pod web-1\n"
"\t\tkubectl logs -f -c ruby web-1\n"
"\n"
"\t\t# Display only the most recent 20 lines of output in pod nginx\n"
"\t\tkubectl logs --tail=20 nginx\n"
"\n"
"\t\t# Show all logs from pod nginx written in the last hour\n"
"\t\tkubectl logs --since=1h nginx\n"
"\n"
"\t\t# Return snapshot logs from first container of a job named hello\n"
"\t\tkubectl logs job/hello\n"
"\n"
"\t\t# Return snapshot logs from container nginx-1 of a deployment named "
"nginx\n"
"\t\tkubectl logs deployment/nginx -c nginx-1"

#: pkg/kubectl/cmd/proxy.go:53
msgid ""
"\n"
"\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static "
"content from ./local/www/\n"
"\t\tkubectl proxy --port=8011 --www=./local/www/\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n"
"\t\t# The chosen port for the server will be output to stdout.\n"
"\t\tkubectl proxy --port=0\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-"
"api\n"
"\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/"
"pods/\n"
"\t\tkubectl proxy --api-prefix=/k8s-api"
msgstr ""
"\n"
"\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static "
"content from ./local/www/\n"
"\t\tkubectl proxy --port=8011 --www=./local/www/\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n"
"\t\t# The chosen port for the server will be output to stdout.\n"
"\t\tkubectl proxy --port=0\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-"
"api\n"
"\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/"
"pods/\n"
"\t\tkubectl proxy --api-prefix=/k8s-api"

#: pkg/kubectl/cmd/scale.go:43
msgid ""
"\n"
"\t\t# Scale a replicaset named 'foo' to 3.\n"
"\t\tkubectl scale --replicas=3 rs/foo\n"
"\n"
"\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" "
"to 3.\n"
"\t\tkubectl scale --replicas=3 -f foo.yaml\n"
"\n"
"\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n"
"\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n"
"\n"
"\t\t# Scale multiple replication controllers.\n"
"\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n"
"\n"
"\t\t# Scale job named 'cron' to 3.\n"
"\t\tkubectl scale --replicas=3 job/cron"
msgstr ""
"\n"
"\t\t# Scale a replicaset named 'foo' to 3.\n"
"\t\tkubectl scale --replicas=3 rs/foo\n"
"\n"
"\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" "
"to 3.\n"
"\t\tkubectl scale --replicas=3 -f foo.yaml\n"
"\n"
"\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n"
"\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n"
"\n"
"\t\t# Scale multiple replication controllers.\n"
"\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n"
"\n"
"\t\t# Scale job named 'cron' to 3.\n"
"\t\tkubectl scale --replicas=3 job/cron"

#: pkg/kubectl/cmd/apply_set_last_applied.go:67
msgid ""
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml\n"
"\n"
"\t\t# Execute set-last-applied against each configuration file in a "
"directory.\n"
"\t\tkubectl apply set-last-applied -f path/\n"
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file, will create the annotation if it does not already exist.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n"
"\t\t"
msgstr ""
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml\n"
"\n"
"\t\t# Execute set-last-applied against each configuration file in a "
"directory.\n"
"\t\tkubectl apply set-last-applied -f path/\n"
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file, will create the annotation if it does not already exist.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n"
"\t\t"

#: pkg/kubectl/cmd/top_pod.go:61
msgid ""
"\n"
"\t\t# Show metrics for all pods in the default namespace\n"
"\t\tkubectl top pod\n"
"\n"
"\t\t# Show metrics for all pods in the given namespace\n"
"\t\tkubectl top pod --namespace=NAMESPACE\n"
"\n"
"\t\t# Show metrics for a given pod and its containers\n"
"\t\tkubectl top pod POD_NAME --containers\n"
"\n"
"\t\t# Show metrics for the pods defined by label name=myLabel\n"
"\t\tkubectl top pod -l name=myLabel"
msgstr ""
"\n"
"\t\t# Show metrics for all pods in the default namespace\n"
"\t\tkubectl top pod\n"
"\n"
"\t\t# Show metrics for all pods in the given namespace\n"
"\t\tkubectl top pod --namespace=NAMESPACE\n"
"\n"
"\t\t# Show metrics for a given pod and its containers\n"
"\t\tkubectl top pod POD_NAME --containers\n"
"\n"
"\t\t# Show metrics for the pods defined by label name=myLabel\n"
"\t\tkubectl top pod -l name=myLabel"

#: pkg/kubectl/cmd/stop.go:40
msgid ""
"\n"
"\t\t# Shut down foo.\n"
"\t\tkubectl stop replicationcontroller foo\n"
"\n"
"\t\t# Stop pods and services with label name=myLabel.\n"
"\t\tkubectl stop pods,services -l name=myLabel\n"
"\n"
"\t\t# Shut down the service defined in service.json\n"
"\t\tkubectl stop -f service.json\n"
"\n"
"\t\t# Shut down all resources in the path/to/resources directory\n"
"\t\tkubectl stop -f path/to/resources"
msgstr ""
"\n"
"\t\t# Shut down foo.\n"
"\t\tkubectl stop replicationcontroller foo\n"
"\n"
"\t\t# Stop pods and services with label name=myLabel.\n"
"\t\tkubectl stop pods,services -l name=myLabel\n"
"\n"
"\t\t# Shut down the service defined in service.json\n"
"\t\tkubectl stop -f service.json\n"
"\n"
"\t\t# Shut down all resources in the path/to/resources directory\n"
"\t\tkubectl stop -f path/to/resources"

#: pkg/kubectl/cmd/run.go:57
msgid ""
"\n"
"\t\t# Start a single instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx\n"
"\n"
"\t\t# Start a single instance of hazelcast and let the container expose port "
"5701 .\n"
"\t\tkubectl run hazelcast --image=hazelcast --port=5701\n"
"\n"
"\t\t# Start a single instance of hazelcast and set environment variables "
"\"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n"
"\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --"
"env=\"POD_NAMESPACE=default\"\n"
"\n"
"\t\t# Start a replicated instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx --replicas=5\n"
"\n"
"\t\t# Dry run. Print the corresponding API objects without creating them.\n"
"\t\tkubectl run nginx --image=nginx --dry-run\n"
"\n"
"\t\t# Start a single instance of nginx, but overload the spec of the "
"deployment with a partial set of values parsed from JSON.\n"
"\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", "
"\"spec\": { ... } }'\n"
"\n"
"\t\t# Start a pod of busybox and keep it in the foreground, don't restart it "
"if it exits.\n"
"\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n"
"\n"
"\t\t# Start the nginx container using the default command, but use custom "
"arguments (arg1 .. argN) for that command.\n"
"\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n"
"\n"
"\t\t# Start the nginx container using a different command and custom "
"arguments.\n"
"\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n"
"\n"
"\t\t# Start the perl container to compute π to 2000 places and print it "
"out.\n"
"\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -"
"wle 'print bpi(2000)'\n"
"\n"
"\t\t# Start the cron job to compute π to 2000 places and print it out every "
"5 minutes.\n"
"\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --"
"restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'"
msgstr ""
"\n"
"\t\t# Start a single instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx\n"
"\n"
"\t\t# Start a single instance of hazelcast and let the container expose port "
"5701 .\n"
"\t\tkubectl run hazelcast --image=hazelcast --port=5701\n"
"\n"
"\t\t# Start a single instance of hazelcast and set environment variables "
"\"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n"
"\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --"
"env=\"POD_NAMESPACE=default\"\n"
"\n"
"\t\t# Start a replicated instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx --replicas=5\n"
"\n"
"\t\t# Dry run. Print the corresponding API objects without creating them.\n"
"\t\tkubectl run nginx --image=nginx --dry-run\n"
"\n"
"\t\t# Start a single instance of nginx, but overload the spec of the "
"deployment with a partial set of values parsed from JSON.\n"
"\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", "
"\"spec\": { ... } }'\n"
"\n"
"\t\t# Start a pod of busybox and keep it in the foreground, don't restart it "
"if it exits.\n"
"\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n"
"\n"
"\t\t# Start the nginx container using the default command, but use custom "
"arguments (arg1 .. argN) for that command.\n"
"\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n"
"\n"
"\t\t# Start the nginx container using a different command and custom "
"arguments.\n"
"\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n"
"\n"
"\t\t# Start the perl container to compute π to 2000 places and print it "
"out.\n"
"\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -"
"wle 'print bpi(2000)'\n"
"\n"
"\t\t# Start the cron job to compute π to 2000 places and print it out every "
"5 minutes.\n"
"\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --"
"restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'"

#: pkg/kubectl/cmd/taint.go:67
msgid ""
"\n"
"\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-"
"user' and effect 'NoSchedule'.\n"
"\t\t# If a taint with that key and effect already exists, its value is "
"replaced as specified.\n"
"\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n"
"\n"
"\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect "
"'NoSchedule' if one exists.\n"
"\t\tkubectl taint nodes foo dedicated:NoSchedule-\n"
"\n"
"\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n"
"\t\tkubectl taint nodes foo dedicated-"
msgstr ""
"\n"
"\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-"
"user' and effect 'NoSchedule'.\n"
"\t\t# If a taint with that key and effect already exists, its value is "
"replaced as specified.\n"
"\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n"
"\n"
"\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect "
"'NoSchedule' if one exists.\n"
"\t\tkubectl taint nodes foo dedicated:NoSchedule-\n"
"\n"
"\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n"
"\t\tkubectl taint nodes foo dedicated-"

#: pkg/kubectl/cmd/label.go:77
msgid ""
"\n"
"\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n"
"\t\tkubectl label pods foo unhealthy=true\n"
"\n"
"\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', "
"overwriting any existing value.\n"
"\t\tkubectl label --overwrite pods foo status=unhealthy\n"
"\n"
"\t\t# Update all pods in the namespace\n"
"\t\tkubectl label pods --all status=unhealthy\n"
"\n"
"\t\t# Update a pod identified by the type and name in \"pod.json\"\n"
"\t\tkubectl label -f pod.json status=unhealthy\n"
"\n"
"\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n"
"\t\tkubectl label pods foo status=unhealthy --resource-version=1\n"
"\n"
"\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n"
"\t\t# Does not require the --overwrite flag.\n"
"\t\tkubectl label pods foo bar-"
msgstr ""
"\n"
"\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n"
"\t\tkubectl label pods foo unhealthy=true\n"
"\n"
"\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', "
"overwriting any existing value.\n"
"\t\tkubectl label --overwrite pods foo status=unhealthy\n"
"\n"
"\t\t# Update all pods in the namespace\n"
"\t\tkubectl label pods --all status=unhealthy\n"
"\n"
"\t\t# Update a pod identified by the type and name in \"pod.json\"\n"
"\t\tkubectl label -f pod.json status=unhealthy\n"
"\n"
"\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n"
"\t\tkubectl label pods foo status=unhealthy --resource-version=1\n"
"\n"
"\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n"
"\t\t# Does not require the --overwrite flag.\n"
"\t\tkubectl label pods foo bar-"

#: pkg/kubectl/cmd/rollingupdate.go:54
msgid ""
"\n"
"\t\t# Update pods of frontend-v1 using new replication controller data in "
"frontend-v2.json.\n"
"\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n"
"\n"
"\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n"
"\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n"
"\n"
"\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the "
"image, and switching the\n"
"\t\t# name of the replication controller.\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n"
"\n"
"\t\t# Update the pods of frontend by just changing the image, and keeping "
"the old name.\n"
"\t\tkubectl rolling-update frontend --image=image:v2\n"
"\n"
"\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to "
"frontend-v2).\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback"
msgstr ""
"\n"
"\t\t# Update pods of frontend-v1 using new replication controller data in "
"frontend-v2.json.\n"
"\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n"
"\n"
"\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n"
"\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n"
"\n"
"\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the "
"image, and switching the\n"
"\t\t# name of the replication controller.\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n"
"\n"
"\t\t# Update the pods of frontend by just changing the image, and keeping "
"the old name.\n"
"\t\tkubectl rolling-update frontend --image=image:v2\n"
"\n"
"\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to "
"frontend-v2).\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback"

#: pkg/kubectl/cmd/apply_view_last_applied.go:52
msgid ""
"\n"
"\t\t# View the last-applied-configuration annotations by type/name in YAML.\n"
"\t\tkubectl apply view-last-applied deployment/nginx\n"
"\n"
"\t\t# View the last-applied-configuration annotations by file in JSON\n"
"\t\tkubectl apply view-last-applied -f deploy.yaml -o json"
msgstr ""
"\n"
"\t\t# View the last-applied-configuration annotations by type/name in YAML.\n"
"\t\tkubectl apply view-last-applied deployment/nginx\n"
"\n"
"\t\t# View the last-applied-configuration annotations by file in JSON\n"
"\t\tkubectl apply view-last-applied -f deploy.yaml -o json"

#: pkg/kubectl/cmd/apply.go:75
msgid ""
"\n"
"\t\tApply a configuration to a resource by filename or stdin.\n"
"\t\tThis resource will be created if it doesn't exist yet.\n"
"\t\tTo use 'apply', always create the resource initially with either 'apply' "
"or 'create --save-config'.\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not "
"use unless you are aware of what the current state is. See https://issues."
"k8s.io/34274."
msgstr ""
"\n"
"\t\tApply a configuration to a resource by filename or stdin.\n"
"\t\tThis resource will be created if it doesn't exist yet.\n"
"\t\tTo use 'apply', always create the resource initially with either 'apply' "
"or 'create --save-config'.\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not "
"use unless you are aware of what the current state is. See https://issues."
"k8s.io/34274."

#: pkg/kubectl/cmd/convert.go:38
msgid ""
"\n"
"\t\tConvert config files between different API versions. Both YAML\n"
"\t\tand JSON formats are accepted.\n"
"\n"
"\t\tThe command takes filename, directory, or URL as input, and convert it "
"into format\n"
"\t\tof version specified by --output-version flag. If target version is not "
"specified or\n"
"\t\tnot supported, convert to latest version.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change to output destination."
msgstr ""
"\n"
"\t\tConvert config files between different API versions. Both YAML\n"
"\t\tand JSON formats are accepted.\n"
"\n"
"\t\tThe command takes filename, directory, or URL as input, and convert it "
"into format\n"
"\t\tof version specified by --output-version flag. If target version is not "
"specified or\n"
"\t\tnot supported, convert to latest version.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change to output destination."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L68
#: pkg/kubectl/cmd/create_clusterrole.go:31
msgid ""
"\n"
"\t\tCreate a ClusterRole."
msgstr ""
"\n"
"\t\tCreate a ClusterRole."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_clusterrolebinding.go#L43
#: pkg/kubectl/cmd/create_clusterrolebinding.go:32
msgid ""
"\n"
"\t\tCreate a ClusterRoleBinding for a particular ClusterRole."
msgstr ""
"\n"
"\t\tCreate a ClusterRoleBinding for a particular ClusterRole."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_rolebinding.go#L43
#: pkg/kubectl/cmd/create_rolebinding.go:32
msgid ""
"\n"
"\t\tCreate a RoleBinding for a particular Role or ClusterRole."
msgstr ""
"\n"
"\t\tCreate a RoleBinding for a particular Role or ClusterRole."

#: pkg/kubectl/cmd/create_secret.go:200
msgid ""
"\n"
"\t\tCreate a TLS secret from the given public/private key pair.\n"
"\n"
"\t\tThe public/private key pair must exist before hand. The public key "
"certificate must be .PEM encoded and match the given private key."
msgstr ""
"\n"
"\t\tCreate a TLS secret from the given public/private key pair.\n"
"\n"
"\t\tThe public/private key pair must exist before hand. The public key "
"certificate must be .PEM encoded and match the given private key."

#: pkg/kubectl/cmd/create_configmap.go:32
msgid ""
"\n"
"\t\tCreate a configmap based on a file, directory, or specified literal "
"value.\n"
"\n"
"\t\tA single configmap may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a configmap based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a configmap based on a directory, each file whose basename "
"is a valid key in the directory will be\n"
"\t\tpackaged into the configmap.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."
msgstr ""
"\n"
"\t\tCreate a configmap based on a file, directory, or specified literal "
"value.\n"
"\n"
"\t\tA single configmap may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a configmap based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a configmap based on a directory, each file whose basename "
"is a valid key in the directory will be\n"
"\t\tpackaged into the configmap.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_namespace.go#L44
#: pkg/kubectl/cmd/create_namespace.go:32
msgid ""
"\n"
"\t\tCreate a namespace with the specified name."
msgstr ""
"\n"
"\t\tCreate a namespace with the specified name."

#: pkg/kubectl/cmd/create_secret.go:119
msgid ""
"\n"
"\t\tCreate a new secret for use with Docker registries.\n"
"\n"
"\t\tDockercfg secrets are used to authenticate against Docker registries.\n"
"\n"
"\t\tWhen using the Docker command line to push images, you can authenticate "
"to a given registry by running\n"
"\n"
"\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --"
"password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n"
"\n"
"    That produces a ~/.dockercfg file that is used by subsequent 'docker "
"push' and 'docker pull' commands to\n"
"\t\tauthenticate to the registry. The email address is optional.\n"
"\n"
"\t\tWhen creating applications, you may have a Docker registry that requires "
"authentication.  In order for the\n"
"\t\tnodes to pull images on your behalf, they have to have the credentials.  "
"You can provide this information\n"
"\t\tby creating a dockercfg secret and attaching it to your service account."
msgstr ""
"\n"
"\t\tCreate a new secret for use with Docker registries.\n"
"\n"
"\t\tDockercfg secrets are used to authenticate against Docker registries.\n"
"\n"
"\t\tWhen using the Docker command line to push images, you can authenticate "
"to a given registry by running\n"
"\n"
"\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --"
"password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n"
"\n"
"    That produces a ~/.dockercfg file that is used by subsequent 'docker "
"push' and 'docker pull' commands to\n"
"\t\tauthenticate to the registry. The email address is optional.\n"
"\n"
"\t\tWhen creating applications, you may have a Docker registry that requires "
"authentication.  In order for the\n"
"\t\tnodes to pull images on your behalf, they have to have the credentials.  "
"You can provide this information\n"
"\t\tby creating a dockercfg secret and attaching it to your service account."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_pdb.go#L49
#: pkg/kubectl/cmd/create_pdb.go:32
msgid ""
"\n"
"\t\tCreate a pod disruption budget with the specified name, selector, and "
"desired minimum available pods"
msgstr ""
"\n"
"\t\tCreate a pod disruption budget with the specified name, selector, and "
"desired minimum available pods"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create.go#L56
#: pkg/kubectl/cmd/create.go:42
msgid ""
"\n"
"\t\tCreate a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted."
msgstr ""
"\n"
"\t\tCreate a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L47
#: pkg/kubectl/cmd/create_quota.go:32
msgid ""
"\n"
"\t\tCreate a resourcequota with the specified name, hard limits and optional "
"scopes"
msgstr ""
"\n"
"\t\tCreate a resourcequota with the specified name, hard limits and optional "
"scopes"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L47
#: pkg/kubectl/cmd/create_role.go:38
msgid ""
"\n"
"\t\tCreate a role with single rule."
msgstr ""
"\n"
"\t\tCreate a role with single rule."

#: pkg/kubectl/cmd/create_secret.go:47
msgid ""
"\n"
"\t\tCreate a secret based on a file, directory, or specified literal value.\n"
"\n"
"\t\tA single secret may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a secret based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a secret based on a directory, each file whose basename is "
"a valid key in the directory will be\n"
"\t\tpackaged into the secret.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."
msgstr ""
"\n"
"\t\tCreate a secret based on a file, directory, or specified literal value.\n"
"\n"
"\t\tA single secret may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a secret based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a secret based on a directory, each file whose basename is "
"a valid key in the directory will be\n"
"\t\tpackaged into the secret.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_serviceaccount.go#L44
#: pkg/kubectl/cmd/create_serviceaccount.go:32
msgid ""
"\n"
"\t\tCreate a service account with the specified name."
msgstr ""
"\n"
"\t\tCreate a service account with the specified name."

#: pkg/kubectl/cmd/run.go:52
msgid ""
"\n"
"\t\tCreate and run a particular image, possibly replicated.\n"
"\n"
"\t\tCreates a deployment or job to manage the created container(s)."
msgstr ""
"\n"
"\t\tCreate and run a particular image, possibly replicated.\n"
"\n"
"\t\tCreates a deployment or job to manage the created container(s)."

#: pkg/kubectl/cmd/autoscale.go:34
msgid ""
"\n"
"\t\tCreates an autoscaler that automatically chooses and sets the number of "
"pods that run in a kubernetes cluster.\n"
"\n"
"\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and "
"creates an autoscaler that uses the given resource as a reference.\n"
"\t\tAn autoscaler can automatically increase or decrease number of pods "
"deployed within the system as needed."
msgstr ""
"\n"
"\t\tCreates an autoscaler that automatically chooses and sets the number of "
"pods that run in a kubernetes cluster.\n"
"\n"
"\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and "
"creates an autoscaler that uses the given resource as a reference.\n"
"\t\tAn autoscaler can automatically increase or decrease number of pods "
"deployed within the system as needed."

#: pkg/kubectl/cmd/delete.go:40
msgid ""
"\n"
"\t\tDelete resources by filenames, stdin, resources and names, or by "
"resources and label selector.\n"
"\n"
"\t\tJSON and YAML formats are accepted. Only one type of the arguments may "
"be specified: filenames,\n"
"\t\tresources and names, or resources and label selector.\n"
"\n"
"\t\tSome resources, such as pods, support graceful deletion. These resources "
"define a default period\n"
"\t\tbefore they are forcibly terminated (the grace period) but you may "
"override that value with\n"
"\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. "
"Because these resources often\n"
"\t\trepresent entities in the cluster, deletion may not be acknowledged "
"immediately. If the node\n"
"\t\thosting a pod is down or cannot reach the API server, termination may "
"take significantly longer\n"
"\t\tthan the grace period. To force delete a resource,\tyou must pass a grace"
"\tperiod of 0 and specify\n"
"\t\tthe --force flag.\n"
"\n"
"\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the "
"pod's processes have been\n"
"\t\tterminated, which can leave those processes running until the node "
"detects the deletion and\n"
"\t\tcompletes graceful deletion. If your processes use shared storage or "
"talk to a remote API and\n"
"\t\tdepend on the name of the pod to identify themselves, force deleting "
"those pods may result in\n"
"\t\tmultiple processes running on different machines using the same "
"identification which may lead\n"
"\t\tto data corruption or inconsistency. Only force delete pods when you are "
"sure the pod is\n"
"\t\tterminated, or if your application can tolerate multiple copies of the "
"same pod running at once.\n"
"\t\tAlso, if you force delete pods the scheduler may place new pods on those "
"nodes before the node\n"
"\t\thas released those resources and causing those pods to be evicted "
"immediately.\n"
"\n"
"\t\tNote that the delete command does NOT do resource version checks, so if "
"someone\n"
"\t\tsubmits an update to a resource right when you submit a delete, their "
"update\n"
"\t\twill be lost along with the rest of the resource."
msgstr ""
"\n"
"\t\tDelete resources by filenames, stdin, resources and names, or by "
"resources and label selector.\n"
"\n"
"\t\tJSON and YAML formats are accepted. Only one type of the arguments may "
"be specified: filenames,\n"
"\t\tresources and names, or resources and label selector.\n"
"\n"
"\t\tSome resources, such as pods, support graceful deletion. These resources "
"define a default period\n"
"\t\tbefore they are forcibly terminated (the grace period) but you may "
"override that value with\n"
"\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. "
"Because these resources often\n"
"\t\trepresent entities in the cluster, deletion may not be acknowledged "
"immediately. If the node\n"
"\t\thosting a pod is down or cannot reach the API server, termination may "
"take significantly longer\n"
"\t\tthan the grace period. To force delete a resource,\tyou must pass a grace"
"\tperiod of 0 and specify\n"
"\t\tthe --force flag.\n"
"\n"
"\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the "
"pod's processes have been\n"
"\t\tterminated, which can leave those processes running until the node "
"detects the deletion and\n"
"\t\tcompletes graceful deletion. If your processes use shared storage or "
"talk to a remote API and\n"
"\t\tdepend on the name of the pod to identify themselves, force deleting "
"those pods may result in\n"
"\t\tmultiple processes running on different machines using the same "
"identification which may lead\n"
"\t\tto data corruption or inconsistency. Only force delete pods when you are "
"sure the pod is\n"
"\t\tterminated, or if your application can tolerate multiple copies of the "
"same pod running at once.\n"
"\t\tAlso, if you force delete pods the scheduler may place new pods on those "
"nodes before the node\n"
"\t\thas released those resources and causing those pods to be evicted "
"immediately.\n"
"\n"
"\t\tNote that the delete command does NOT do resource version checks, so if "
"someone\n"
"\t\tsubmits an update to a resource right when you submit a delete, their "
"update\n"
"\t\twill be lost along with the rest of the resource."

#: pkg/kubectl/cmd/stop.go:31
msgid ""
"\n"
"\t\tDeprecated: Gracefully shut down a resource by name or filename.\n"
"\n"
"\t\tThe stop command is deprecated, all its functionalities are covered by "
"delete command.\n"
"\t\tSee 'kubectl delete --help' for more details.\n"
"\n"
"\t\tAttempts to shut down and delete a resource that supports graceful "
"termination.\n"
"\t\tIf the resource is scalable it will be scaled to 0 before deletion."
msgstr ""
"\n"
"\t\tDeprecated: Gracefully shut down a resource by name or filename.\n"
"\n"
"\t\tThe stop command is deprecated, all its functionalities are covered by "
"delete command.\n"
"\t\tSee 'kubectl delete --help' for more details.\n"
"\n"
"\t\tAttempts to shut down and delete a resource that supports graceful "
"termination.\n"
"\t\tIf the resource is scalable it will be scaled to 0 before deletion."

#: pkg/kubectl/cmd/top_node.go:60
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n"
"\n"
"\t\tThe top-node command allows you to see the resource consumption of nodes."
msgstr ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n"
"\n"
"\t\tThe top-node command allows you to see the resource consumption of nodes."

#: pkg/kubectl/cmd/top_pod.go:53
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n"
"\n"
"\t\tThe 'top pod' command allows you to see the resource consumption of "
"pods.\n"
"\n"
"\t\tDue to the metrics pipeline delay, they may be unavailable for a few "
"minutes\n"
"\t\tsince pod creation."
msgstr ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n"
"\n"
"\t\tThe 'top pod' command allows you to see the resource consumption of "
"pods.\n"
"\n"
"\t\tDue to the metrics pipeline delay, they may be unavailable for a few "
"minutes\n"
"\t\tsince pod creation."

#: pkg/kubectl/cmd/top.go:33
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage.\n"
"\n"
"\t\tThe top command allows you to see the resource consumption for nodes or "
"pods.\n"
"\n"
"\t\tThis command requires Heapster to be correctly configured and working on "
"the server. "
msgstr ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage.\n"
"\n"
"\t\tThe top command allows you to see the resource consumption for nodes or "
"pods.\n"
"\n"
"\t\tThis command requires Heapster to be correctly configured and working on "
"the server. "

#: pkg/kubectl/cmd/drain.go:140
msgid ""
"\n"
"\t\tDrain node in preparation for maintenance.\n"
"\n"
"\t\tThe given node will be marked unschedulable to prevent new pods from "
"arriving.\n"
"\t\t'drain' evicts the pods if the APIServer supports eviction\n"
"\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use "
"normal DELETE\n"
"\t\tto delete the pods.\n"
"\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot "
"be deleted through\n"
"\t\tthe API server).  If there are DaemonSet-managed pods, drain will not "
"proceed\n"
"\t\twithout --ignore-daemonsets, and regardless it will not delete any\n"
"\t\tDaemonSet-managed pods, because those pods would be immediately replaced "
"by the\n"
"\t\tDaemonSet controller, which ignores unschedulable markings.  If there "
"are any\n"
"\t\tpods that are neither mirror pods nor managed by ReplicationController,\n"
"\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete "
"any pods unless you\n"
"\t\tuse --force.  --force will also allow deletion to proceed if the "
"managing resource of one\n"
"\t\tor more pods is missing.\n"
"\n"
"\t\t'drain' waits for graceful termination. You should not operate on the "
"machine until\n"
"\t\tthe command completes.\n"
"\n"
"\t\tWhen you are ready to put the node back into service, use kubectl "
"uncordon, which\n"
"\t\twill make the node schedulable again.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)"
msgstr ""
"\n"
"\t\tDrain node in preparation for maintenance.\n"
"\n"
"\t\tThe given node will be marked unschedulable to prevent new pods from "
"arriving.\n"
"\t\t'drain' evicts the pods if the APIServer supports eviction\n"
"\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use "
"normal DELETE\n"
"\t\tto delete the pods.\n"
"\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot "
"be deleted through\n"
"\t\tthe API server).  If there are DaemonSet-managed pods, drain will not "
"proceed\n"
"\t\twithout --ignore-daemonsets, and regardless it will not delete any\n"
"\t\tDaemonSet-managed pods, because those pods would be immediately replaced "
"by the\n"
"\t\tDaemonSet controller, which ignores unschedulable markings.  If there "
"are any\n"
"\t\tpods that are neither mirror pods nor managed by ReplicationController,\n"
"\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete "
"any pods unless you\n"
"\t\tuse --force.  --force will also allow deletion to proceed if the "
"managing resource of one\n"
"\t\tor more pods is missing.\n"
"\n"
"\t\t'drain' waits for graceful termination. You should not operate on the "
"machine until\n"
"\t\tthe command completes.\n"
"\n"
"\t\tWhen you are ready to put the node back into service, use kubectl "
"uncordon, which\n"
"\t\twill make the node schedulable again.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)"

#: pkg/kubectl/cmd/edit.go:56
msgid ""
"\n"
"\t\tEdit a resource from the default editor.\n"
"\n"
"\t\tThe edit command allows you to directly edit any API resource you can "
"retrieve via the\n"
"\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, "
"or EDITOR\n"
"\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for "
"Windows.\n"
"\t\tYou can edit multiple objects, although changes are applied one at a "
"time. The command\n"
"\t\taccepts filenames as well as command line arguments, although the files "
"you point to must\n"
"\t\tbe previously saved versions of resources.\n"
"\n"
"\t\tEditing is done with the API version used to fetch the resource.\n"
"\t\tTo edit using a specific API version, fully-qualify the resource, "
"version, and group.\n"
"\n"
"\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n"
"\n"
"\t\tThe flag --windows-line-endings can be used to force Windows line "
"endings,\n"
"\t\totherwise the default for your operating system will be used.\n"
"\n"
"\t\tIn the event an error occurs while updating, a temporary file will be "
"created on disk\n"
"\t\tthat contains your unapplied changes. The most common error when "
"updating a resource\n"
"\t\tis another editor changing the resource on the server. When this occurs, "
"you will have\n"
"\t\tto apply your changes to the newer version of the resource, or update "
"your temporary\n"
"\t\tsaved copy to include the latest resource version."
msgstr ""
"\n"
"\t\tEdit a resource from the default editor.\n"
"\n"
"\t\tThe edit command allows you to directly edit any API resource you can "
"retrieve via the\n"
"\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, "
"or EDITOR\n"
"\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for "
"Windows.\n"
"\t\tYou can edit multiple objects, although changes are applied one at a "
"time. The command\n"
"\t\taccepts filenames as well as command line arguments, although the files "
"you point to must\n"
"\t\tbe previously saved versions of resources.\n"
"\n"
"\t\tEditing is done with the API version used to fetch the resource.\n"
"\t\tTo edit using a specific API version, fully-qualify the resource, "
"version, and group.\n"
"\n"
"\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n"
"\n"
"\t\tThe flag --windows-line-endings can be used to force Windows line "
"endings,\n"
"\t\totherwise the default for your operating system will be used.\n"
"\n"
"\t\tIn the event an error occurs while updating, a temporary file will be "
"created on disk\n"
"\t\tthat contains your unapplied changes. The most common error when "
"updating a resource\n"
"\t\tis another editor changing the resource on the server. When this occurs, "
"you will have\n"
"\t\tto apply your changes to the newer version of the resource, or update "
"your temporary\n"
"\t\tsaved copy to include the latest resource version."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L127
#: pkg/kubectl/cmd/drain.go:115
msgid ""
"\n"
"\t\tMark node as schedulable."
msgstr ""
"\n"
"\t\tMark node as schedulable."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L102
#: pkg/kubectl/cmd/drain.go:90
msgid ""
"\n"
"\t\tMark node as unschedulable."
msgstr ""
"\n"
"\t\tMark node as unschedulable."

#: pkg/kubectl/cmd/completion.go:47
msgid ""
"\n"
"\t\tOutput shell completion code for the specified shell (bash or zsh).\n"
"\t\tThe shell code must be evaluated to provide interactive\n"
"\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n"
"\t\tthe .bash_profile.\n"
"\n"
"\t\tNote: this requires the bash-completion framework, which is not "
"installed\n"
"\t\tby default on Mac.  This can be installed by using homebrew:\n"
"\n"
"\t\t    $ brew install bash-completion\n"
"\n"
"\t\tOnce installed, bash_completion must be evaluated.  This can be done by "
"adding the\n"
"\t\tfollowing line to the .bash_profile\n"
"\n"
"\t\t    $ source $(brew --prefix)/etc/bash_completion\n"
"\n"
"\t\tNote for zsh users: [1] zsh completions are only supported in versions "
"of zsh >= 5.2"
msgstr ""
"\n"
"\t\tOutput shell completion code for the specified shell (bash or zsh).\n"
"\t\tThe shell code must be evaluated to provide interactive\n"
"\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n"
"\t\tthe .bash_profile.\n"
"\n"
"\t\tNote: this requires the bash-completion framework, which is not "
"installed\n"
"\t\tby default on Mac.  This can be installed by using homebrew:\n"
"\n"
"\t\t    $ brew install bash-completion\n"
"\n"
"\t\tOnce installed, bash_completion must be evaluated.  This can be done by "
"adding the\n"
"\t\tfollowing line to the .bash_profile\n"
"\n"
"\t\t    $ source $(brew --prefix)/etc/bash_completion\n"
"\n"
"\t\tNote for zsh users: [1] zsh completions are only supported in versions "
"of zsh >= 5.2"

#: pkg/kubectl/cmd/rollingupdate.go:45
msgid ""
"\n"
"\t\tPerform a rolling update of the given ReplicationController.\n"
"\n"
"\t\tReplaces the specified replication controller with a new replication "
"controller by updating one pod at a time to use the\n"
"\t\tnew PodTemplate. The new-controller.json must specify the same namespace "
"as the\n"
"\t\texisting replication controller and overwrite at least one (common) "
"label in its replicaSelector.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)"
msgstr ""
"\n"
"\t\tPerform a rolling update of the given ReplicationController.\n"
"\n"
"\t\tReplaces the specified replication controller with a new replication "
"controller by updating one pod at a time to use the\n"
"\t\tnew PodTemplate. The new-controller.json must specify the same namespace "
"as the\n"
"\t\texisting replication controller and overwrite at least one (common) "
"label in its replicaSelector.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)"

#: pkg/kubectl/cmd/replace.go:40
msgid ""
"\n"
"\t\tReplace a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted. If replacing an existing resource, "
"the\n"
"\t\tcomplete resource spec must be provided. This can be obtained by\n"
"\n"
"\t\t    $ kubectl get TYPE NAME -o yaml\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."
msgstr ""
"\n"
"\t\tReplace a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted. If replacing an existing resource, "
"the\n"
"\t\tcomplete resource spec must be provided. This can be obtained by\n"
"\n"
"\t\t    $ kubectl get TYPE NAME -o yaml\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."

#: pkg/kubectl/cmd/scale.go:34
msgid ""
"\n"
"\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or "
"Job.\n"
"\n"
"\t\tScale also allows users to specify one or more preconditions for the "
"scale action.\n"
"\n"
"\t\tIf --current-replicas or --resource-version is specified, it is "
"validated before the\n"
"\t\tscale is attempted, and it is guaranteed that the precondition holds "
"true when the\n"
"\t\tscale is sent to the server."
msgstr ""
"\n"
"\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or "
"Job.\n"
"\n"
"\t\tScale also allows users to specify one or more preconditions for the "
"scale action.\n"
"\n"
"\t\tIf --current-replicas or --resource-version is specified, it is "
"validated before the\n"
"\t\tscale is attempted, and it is guaranteed that the precondition holds "
"true when the\n"
"\t\tscale is sent to the server."

#: pkg/kubectl/cmd/apply_set_last_applied.go:62
msgid ""
"\n"
"\t\tSet the latest last-applied-configuration annotations by setting it to "
"match the contents of a file.\n"
"\t\tThis results in the last-applied-configuration being updated as though "
"'kubectl apply -f <file>' was run,\n"
"\t\twithout updating any other parts of the object."
msgstr ""
"\n"
"\t\tSet the latest last-applied-configuration annotations by setting it to "
"match the contents of a file.\n"
"\t\tThis results in the last-applied-configuration being updated as though "
"'kubectl apply -f <file>' was run,\n"
"\t\twithout updating any other parts of the object."

#: pkg/kubectl/cmd/proxy.go:36
msgid ""
"\n"
"\t\tTo proxy all of the kubernetes api and nothing else, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/\n"
"\n"
"\t\tTo proxy only part of the kubernetes api and also some static files:\n"
"\n"
"\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/"
"api/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n"
"\n"
"\t\tTo proxy the entire kubernetes api at a different root, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/custom/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'"
msgstr ""
"\n"
"\t\tTo proxy all of the kubernetes api and nothing else, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/\n"
"\n"
"\t\tTo proxy only part of the kubernetes api and also some static files:\n"
"\n"
"\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/"
"api/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n"
"\n"
"\t\tTo proxy the entire kubernetes api at a different root, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/custom/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'"

#: pkg/kubectl/cmd/patch.go:59
msgid ""
"\n"
"\t\tUpdate field(s) of a resource using strategic merge patch\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."
msgstr ""
"\n"
"\t\tUpdate field(s) of a resource using strategic merge patch\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."

#: pkg/kubectl/cmd/label.go:70
#, c-format
msgid ""
"\n"
"\t\tUpdate the labels on a resource.\n"
"\n"
"\t\t* A label must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* If --overwrite is true, then existing labels can be overwritten, "
"otherwise attempting to overwrite a label will result in an error.\n"
"\t\t* If --resource-version is specified, then updates will use this "
"resource version, otherwise the existing resource-version will be used."
msgstr ""
"\n"
"\t\tUpdate the labels on a resource.\n"
"\n"
"\t\t* A label must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* If --overwrite is true, then existing labels can be overwritten, "
"otherwise attempting to overwrite a label will result in an error.\n"
"\t\t* If --resource-version is specified, then updates will use this "
"resource version, otherwise the existing resource-version will be used."

#: pkg/kubectl/cmd/taint.go:58
#, c-format
msgid ""
"\n"
"\t\tUpdate the taints on one or more nodes.\n"
"\n"
"\t\t* A taint consists of a key, value, and effect. As an argument here, it "
"is expressed as key=value:effect.\n"
"\t\t* The key must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* The value must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[2]d characters.\n"
"\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n"
"\t\t* Currently taint can only apply to node."
msgstr ""
"\n"
"\t\tUpdate the taints on one or more nodes.\n"
"\n"
"\t\t* A taint consists of a key, value, and effect. As an argument here, it "
"is expressed as key=value:effect.\n"
"\t\t* The key must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* The value must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[2]d characters.\n"
"\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n"
"\t\t* Currently taint can only apply to node."

#: pkg/kubectl/cmd/apply_view_last_applied.go:46
msgid ""
"\n"
"\t\tView the latest last-applied-configuration annotations by type/name or "
"file.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change output format."
msgstr ""
"\n"
"\t\tView the latest last-applied-configuration annotations by type/name or "
"file.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change output format."

#: pkg/kubectl/cmd/cp.go:37
msgid ""
"\n"
"\t    # !!!Important Note!!!\n"
"\t    # Requires that the 'tar' binary is present in your container\n"
"\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n"
"\n"
"\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in "
"the default namespace\n"
"\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n"
"\n"
"        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific "
"container\n"
"\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n"
"\n"
"\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace "
"<some-namespace>\n"
"\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n"
"\n"
"\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n"
"\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar"
msgstr ""
"\n"
"\t    # !!!Important Note!!!\n"
"\t    # Requires that the 'tar' binary is present in your container\n"
"\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n"
"\n"
"\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in "
"the default namespace\n"
"\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n"
"\n"
"        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific "
"container\n"
"\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n"
"\n"
"\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace "
"<some-namespace>\n"
"\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n"
"\n"
"\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n"
"\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar"

#: pkg/kubectl/cmd/create_secret.go:205
msgid ""
"\n"
"\t  # Create a new TLS secret named tls-secret with the given key pair:\n"
"\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/"
"to/tls.key"
msgstr ""
"\n"
"\t  # Create a new TLS secret named tls-secret with the given key pair:\n"
"\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/"
"to/tls.key"

#: pkg/kubectl/cmd/create_namespace.go:35
msgid ""
"\n"
"\t  # Create a new namespace named my-namespace\n"
"\t  kubectl create namespace my-namespace"
msgstr ""
"\n"
"\t  # Create a new namespace named my-namespace\n"
"\t  kubectl create namespace my-namespace"

#: pkg/kubectl/cmd/create_secret.go:59
msgid ""
"\n"
"\t  # Create a new secret named my-secret with keys for each file in folder "
"bar\n"
"\t  kubectl create secret generic my-secret --from-file=path/to/bar\n"
"\n"
"\t  # Create a new secret named my-secret with specified keys instead of "
"names on disk\n"
"\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/."
"ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n"
"\n"
"\t  # Create a new secret named my-secret with key1=supersecret and "
"key2=topsecret\n"
"\t  kubectl create secret generic my-secret --from-literal=key1=supersecret "
"--from-literal=key2=topsecret"
msgstr ""
"\n"
"\t  # Create a new secret named my-secret with keys for each file in folder "
"bar\n"
"\t  kubectl create secret generic my-secret --from-file=path/to/bar\n"
"\n"
"\t  # Create a new secret named my-secret with specified keys instead of "
"names on disk\n"
"\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/."
"ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n"
"\n"
"\t  # Create a new secret named my-secret with key1=supersecret and "
"key2=topsecret\n"
"\t  kubectl create secret generic my-secret --from-literal=key1=supersecret "
"--from-literal=key2=topsecret"

#: pkg/kubectl/cmd/create_serviceaccount.go:35
msgid ""
"\n"
"\t  # Create a new service account named my-service-account\n"
"\t  kubectl create serviceaccount my-service-account"
msgstr ""
"\n"
"\t  # Create a new service account named my-service-account\n"
"\t  kubectl create serviceaccount my-service-account"

#: pkg/kubectl/cmd/create_service.go:232
msgid ""
"\n"
"\t# Create a new ExternalName service named my-ns \n"
"\tkubectl create service externalname my-ns --external-name bar.com"
msgstr ""
"\n"
"\t# Create a new ExternalName service named my-ns \n"
"\tkubectl create service externalname my-ns --external-name bar.com"

#: pkg/kubectl/cmd/create_service.go:225
msgid ""
"\n"
"\tCreate an ExternalName service with the specified name.\n"
"\n"
"\tExternalName service references to an external DNS address instead of\n"
"\tonly pods, which will allow application authors to reference services\n"
"\tthat exist off platform, on other clusters, or locally."
msgstr ""
"\n"
"\tCreate an ExternalName service with the specified name.\n"
"\n"
"\tExternalName service references to an external DNS address instead of\n"
"\tonly pods, which will allow application authors to reference services\n"
"\tthat exist off platform, on other clusters, or locally."

#: pkg/kubectl/cmd/help.go:30
msgid ""
"\n"
"\tHelp provides help for any command in the application.\n"
"\tSimply type kubectl help [path to command] for full details."
msgstr ""
"\n"
"\tHelp provides help for any command in the application.\n"
"\tSimply type kubectl help [path to command] for full details."

#: pkg/kubectl/cmd/create_service.go:173
msgid ""
"\n"
"    # Create a new LoadBalancer service named my-lbs\n"
"    kubectl create service loadbalancer my-lbs --tcp=5678:8080"
msgstr ""
"\n"
"    # Create a new LoadBalancer service named my-lbs\n"
"    kubectl create service loadbalancer my-lbs --tcp=5678:8080"

#: pkg/kubectl/cmd/create_service.go:53
msgid ""
"\n"
"    # Create a new clusterIP service named my-cs\n"
"    kubectl create service clusterip my-cs --tcp=5678:8080\n"
"\n"
"    # Create a new clusterIP service named my-cs (in headless mode)\n"
"    kubectl create service clusterip my-cs --clusterip=\"None\""
msgstr ""
"\n"
"    # Create a new clusterIP service named my-cs\n"
"    kubectl create service clusterip my-cs --tcp=5678:8080\n"
"\n"
"    # Create a new clusterIP service named my-cs (in headless mode)\n"
"    kubectl create service clusterip my-cs --clusterip=\"None\""

#: pkg/kubectl/cmd/create_deployment.go:36
msgid ""
"\n"
"    # Create a new deployment named my-dep that runs the busybox image.\n"
"    kubectl create deployment my-dep --image=busybox"
msgstr ""
"\n"
"    # Create a new deployment named my-dep that runs the busybox image.\n"
"    kubectl create deployment my-dep --image=busybox"

#: pkg/kubectl/cmd/create_service.go:116
msgid ""
"\n"
"    # Create a new nodeport service named my-ns\n"
"    kubectl create service nodeport my-ns --tcp=5678:8080"
msgstr ""
"\n"
"    # Create a new nodeport service named my-ns\n"
"    kubectl create service nodeport my-ns --tcp=5678:8080"

#: pkg/kubectl/cmd/clusterinfo_dump.go:62
msgid ""
"\n"
"    # Dump current cluster state to stdout\n"
"    kubectl cluster-info dump\n"
"\n"
"    # Dump current cluster state to /path/to/cluster-state\n"
"    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n"
"\n"
"    # Dump all namespaces to stdout\n"
"    kubectl cluster-info dump --all-namespaces\n"
"\n"
"    # Dump a set of namespaces to /path/to/cluster-state\n"
"    kubectl cluster-info dump --namespaces default,kube-system --output-"
"directory=/path/to/cluster-state"
msgstr ""
"\n"
"    # Dump current cluster state to stdout\n"
"    kubectl cluster-info dump\n"
"\n"
"    # Dump current cluster state to /path/to/cluster-state\n"
"    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n"
"\n"
"    # Dump all namespaces to stdout\n"
"    kubectl cluster-info dump --all-namespaces\n"
"\n"
"    # Dump a set of namespaces to /path/to/cluster-state\n"
"    kubectl cluster-info dump --namespaces default,kube-system --output-"
"directory=/path/to/cluster-state"

#: pkg/kubectl/cmd/annotate.go:78
msgid ""
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend'.\n"
"    # If the same annotation is set multiple times, only the last value will "
"be applied\n"
"    kubectl annotate pods foo description='my frontend'\n"
"\n"
"    # Update a pod identified by type and name in \"pod.json\"\n"
"    kubectl annotate -f pod.json description='my frontend'\n"
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend running nginx', overwriting any existing value.\n"
"    kubectl annotate --overwrite pods foo description='my frontend running "
"nginx'\n"
"\n"
"    # Update all pods in the namespace\n"
"    kubectl annotate pods --all description='my frontend running nginx'\n"
"\n"
"    # Update pod 'foo' only if the resource is unchanged from version 1.\n"
"    kubectl annotate pods foo description='my frontend running nginx' --"
"resource-version=1\n"
"\n"
"    # Update pod 'foo' by removing an annotation named 'description' if it "
"exists.\n"
"    # Does not require the --overwrite flag.\n"
"    kubectl annotate pods foo description-"
msgstr ""
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend'.\n"
"    # If the same annotation is set multiple times, only the last value will "
"be applied\n"
"    kubectl annotate pods foo description='my frontend'\n"
"\n"
"    # Update a pod identified by type and name in \"pod.json\"\n"
"    kubectl annotate -f pod.json description='my frontend'\n"
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend running nginx', overwriting any existing value.\n"
"    kubectl annotate --overwrite pods foo description='my frontend running "
"nginx'\n"
"\n"
"    # Update all pods in the namespace\n"
"    kubectl annotate pods --all description='my frontend running nginx'\n"
"\n"
"    # Update pod 'foo' only if the resource is unchanged from version 1.\n"
"    kubectl annotate pods foo description='my frontend running nginx' --"
"resource-version=1\n"
"\n"
"    # Update pod 'foo' by removing an annotation named 'description' if it "
"exists.\n"
"    # Does not require the --overwrite flag.\n"
"    kubectl annotate pods foo description-"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_namespace.go#L44
#: pkg/kubectl/cmd/create_service.go:170
msgid ""
"\n"
"    Create a LoadBalancer service with the specified name."
msgstr ""
"\n"
"    Create a LoadBalancer service with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_serviceaccount.go#L44
#: pkg/kubectl/cmd/create_service.go:50
msgid ""
"\n"
"    Create a clusterIP service with the specified name."
msgstr ""
"\n"
"    Create a clusterIP service with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_deployment.go#L44
#: pkg/kubectl/cmd/create_deployment.go:33
msgid ""
"\n"
"    Create a deployment with the specified name."
msgstr ""
"\n"
"    Create a deployment with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_deployment.go#L44
#: pkg/kubectl/cmd/create_service.go:113
msgid ""
"\n"
"    Create a nodeport service with the specified name."
msgstr ""
"\n"
"    Create a nodeport service with the specified name."

#: pkg/kubectl/cmd/clusterinfo_dump.go:53
msgid ""
"\n"
"    Dumps cluster info out suitable for debugging and diagnosing cluster "
"problems.  By default, dumps everything to\n"
"    stdout. You can optionally specify a directory with --output-directory.  "
"If you specify a directory, kubernetes will\n"
"    build a set of files in that directory.  By default only dumps things in "
"the 'kube-system' namespace, but you can\n"
"    switch to a different namespace with the --namespaces flag, or specify --"
"all-namespaces to dump all namespaces.\n"
"\n"
"    The command also dumps the logs of all of the pods in the cluster, these "
"logs are dumped into different directories\n"
"    based on namespace and pod name."
msgstr ""
"\n"
"    Dumps cluster info out suitable for debugging and diagnosing cluster "
"problems.  By default, dumps everything to\n"
"    stdout. You can optionally specify a directory with --output-directory.  "
"If you specify a directory, kubernetes will\n"
"    build a set of files in that directory.  By default only dumps things in "
"the 'kube-system' namespace, but you can\n"
"    switch to a different namespace with the --namespaces flag, or specify --"
"all-namespaces to dump all namespaces.\n"
"\n"
"    The command also dumps the logs of all of the pods in the cluster, these "
"logs are dumped into different directories\n"
"    based on namespace and pod name."

#: pkg/kubectl/cmd/clusterinfo.go:37
msgid ""
"\n"
"  Display addresses of the master and services with label kubernetes.io/"
"cluster-service=true\n"
"  To further debug and diagnose cluster problems, use 'kubectl cluster-info "
"dump'."
msgstr ""
"\n"
"  Display addresses of the master and services with label kubernetes.io/"
"cluster-service=true\n"
"  To further debug and diagnose cluster problems, use 'kubectl cluster-info "
"dump'."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L61
#: pkg/kubectl/cmd/create_quota.go:62
msgid ""
"A comma-delimited set of quota scopes that must all match each object "
"tracked by the quota."
msgstr ""
"A comma-delimited set of quota scopes that must all match each object "
"tracked by the quota."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L60
#: pkg/kubectl/cmd/create_quota.go:61
msgid ""
"A comma-delimited set of resource=quantity pairs that define a hard limit."
msgstr ""
"A comma-delimited set of resource=quantity pairs that define a hard limit."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_pdb.go#L63
#: pkg/kubectl/cmd/create_pdb.go:64
msgid ""
"A label selector to use for this budget. Only equality-based selector "
"requirements are supported."
msgstr ""
"A label selector to use for this budget. Only equality-based selector "
"requirements are supported."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L106
#: pkg/kubectl/cmd/expose.go:104
msgid ""
"A label selector to use for this service. Only equality-based selector "
"requirements are supported. If empty (the default) infer the selector from "
"the replication controller or replica set.)"
msgstr ""
"A label selector to use for this service. Only equality-based selector "
"requirements are supported. If empty (the default) infer the selector from "
"the replication controller or replica set.)"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L136
#: pkg/kubectl/cmd/run.go:139
msgid "A schedule in the Cron format the job should be run with."
msgstr "A schedule in the Cron format the job should be run with."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L111
#: pkg/kubectl/cmd/expose.go:109
msgid ""
"Additional external IP address (not managed by Kubernetes) to accept for the "
"service. If this IP is routed to a node, the service can be accessed by this "
"IP in addition to its generated service IP."
msgstr ""
"Additional external IP address (not managed by Kubernetes) to accept for the "
"service. If this IP is routed to a node, the service can be accessed by this "
"IP in addition to its generated service IP."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L119
#: pkg/kubectl/cmd/expose.go:110 pkg/kubectl/cmd/run.go:122
msgid ""
"An inline JSON override for the generated object. If this is non-empty, it "
"is used to override the generated object. Requires that the object supply a "
"valid apiVersion field."
msgstr ""
"An inline JSON override for the generated object. If this is non-empty, it "
"is used to override the generated object. Requires that the object supply a "
"valid apiVersion field."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L134
#: pkg/kubectl/cmd/run.go:137
msgid ""
"An inline JSON override for the generated service object. If this is non-"
"empty, it is used to override the generated object. Requires that the object "
"supply a valid apiVersion field.  Only used if --expose is true."
msgstr ""
"An inline JSON override for the generated service object. If this is non-"
"empty, it is used to override the generated object. Requires that the object "
"supply a valid apiVersion field.  Only used if --expose is true."

#: pkg/kubectl/cmd/apply.go:104
msgid "Apply a configuration to a resource by filename or stdin"
msgstr "Apply a configuration to a resource by filename or stdin"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/certificates.go#L71
#: pkg/kubectl/cmd/certificates.go:72
msgid "Approve a certificate signing request"
msgstr "Approve a certificate signing request"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L81
#: pkg/kubectl/cmd/create_service.go:82
msgid ""
"Assign your own ClusterIP or set to 'None' for a 'headless' service (no "
"loadbalancing)."
msgstr ""
"Assign your own ClusterIP or set to 'None' for a 'headless' service (no "
"loadbalancing)."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/attach.go#L64
#: pkg/kubectl/cmd/attach.go:70
msgid "Attach to a running container"
msgstr "Attach to a running container"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/autoscale.go#L55
#: pkg/kubectl/cmd/autoscale.go:56
msgid "Auto-scale a Deployment, ReplicaSet, or ReplicationController"
msgstr "Auto-scale a Deployment, ReplicaSet, or ReplicationController"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L115
#: pkg/kubectl/cmd/expose.go:113
msgid ""
"ClusterIP to be assigned to the service. Leave empty to auto-allocate, or "
"set to 'None' to create a headless service."
msgstr ""
"ClusterIP to be assigned to the service. Leave empty to auto-allocate, or "
"set to 'None' to create a headless service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_clusterrolebinding.go#L55
#: pkg/kubectl/cmd/create_clusterrolebinding.go:56
msgid "ClusterRole this ClusterRoleBinding should reference"
msgstr "ClusterRole this ClusterRoleBinding should reference"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_rolebinding.go#L55
#: pkg/kubectl/cmd/create_rolebinding.go:56
msgid "ClusterRole this RoleBinding should reference"
msgstr "ClusterRole this RoleBinding should reference"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L101
#: pkg/kubectl/cmd/rollingupdate.go:102
msgid ""
"Container name which will have its image upgraded. Only relevant when --"
"image is specified, ignored otherwise. Required when using --image on a "
"multi-container pod"
msgstr ""
"Container name which will have its image upgraded. Only relevant when --"
"image is specified, ignored otherwise. Required when using --image on a "
"multi-container pod"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/convert.go#L67
#: pkg/kubectl/cmd/convert.go:68
msgid "Convert config files between different API versions"
msgstr "Convert config files between different API versions"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/cp.go#L64
#: pkg/kubectl/cmd/cp.go:65
msgid "Copy files and directories to and from containers."
msgstr "Copy files and directories to and from containers."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_clusterrolebinding.go#L43
#: pkg/kubectl/cmd/create_clusterrolebinding.go:44
msgid "Create a ClusterRoleBinding for a particular ClusterRole"
msgstr "Create a ClusterRoleBinding for a particular ClusterRole"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L181
#: pkg/kubectl/cmd/create_service.go:182
msgid "Create a LoadBalancer service."
msgstr "Create a LoadBalancer service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L124
#: pkg/kubectl/cmd/create_service.go:125
msgid "Create a NodePort service."
msgstr "Create a NodePort service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_rolebinding.go#L43
#: pkg/kubectl/cmd/create_rolebinding.go:44
msgid "Create a RoleBinding for a particular Role or ClusterRole"
msgstr "Create a RoleBinding for a particular Role or ClusterRole"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L214
#: pkg/kubectl/cmd/create_secret.go:214
msgid "Create a TLS secret"
msgstr "Create a TLS secret"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L68
#: pkg/kubectl/cmd/create_service.go:69
msgid "Create a clusterIP service."
msgstr "Create a clusterIP service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_configmap.go#L59
#: pkg/kubectl/cmd/create_configmap.go:60
msgid "Create a configmap from a local file, directory or literal value"
msgstr "Create a configmap from a local file, directory or literal value"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_deployment.go#L44
#: pkg/kubectl/cmd/create_deployment.go:46
msgid "Create a deployment with the specified name."
msgstr "Create a deployment with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_namespace.go#L44
#: pkg/kubectl/cmd/create_namespace.go:45
msgid "Create a namespace with the specified name"
msgstr "Create a namespace with the specified name"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_pdb.go#L49
#: pkg/kubectl/cmd/create_pdb.go:50
msgid "Create a pod disruption budget with the specified name."
msgstr "Create a pod disruption budget with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L47
#: pkg/kubectl/cmd/create_quota.go:48
msgid "Create a quota with the specified name."
msgstr "Create a quota with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create.go#L56
#: pkg/kubectl/cmd/create.go:63
msgid "Create a resource by filename or stdin"
msgstr "Create a resource by filename or stdin"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L143
#: pkg/kubectl/cmd/create_secret.go:144
msgid "Create a secret for use with a Docker registry"
msgstr "Create a secret for use with a Docker registry"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L73
#: pkg/kubectl/cmd/create_secret.go:74
msgid "Create a secret from a local file, directory or literal value"
msgstr "Create a secret from a local file, directory or literal value"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L34
#: pkg/kubectl/cmd/create_secret.go:35
msgid "Create a secret using specified subcommand"
msgstr "Create a secret using specified subcommand"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_serviceaccount.go#L44
#: pkg/kubectl/cmd/create_serviceaccount.go:45
msgid "Create a service account with the specified name"
msgstr "Create a service account with the specified name"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L36
#: pkg/kubectl/cmd/create_service.go:37
msgid "Create a service using specified subcommand."
msgstr "Create a service using specified subcommand."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L240
#: pkg/kubectl/cmd/create_service.go:241
msgid "Create an ExternalName service."
msgstr "Create an ExternalName service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/delete.go#L130
#: pkg/kubectl/cmd/delete.go:132
msgid ""
"Delete resources by filenames, stdin, resources and names, or by resources "
"and label selector"
msgstr ""
"Delete resources by filenames, stdin, resources and names, or by resources "
"and label selector"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/delete_cluster.go#L38
#: pkg/kubectl/cmd/config/delete_cluster.go:39
msgid "Delete the specified cluster from the kubeconfig"
msgstr "Delete the specified cluster from the kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/delete_context.go#L38
#: pkg/kubectl/cmd/config/delete_context.go:39
msgid "Delete the specified context from the kubeconfig"
msgstr "Delete the specified context from the kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/certificates.go#L121
#: pkg/kubectl/cmd/certificates.go:122
msgid "Deny a certificate signing request"
msgstr "Deny a certificate signing request"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/stop.go#L58
#: pkg/kubectl/cmd/stop.go:59
msgid "Deprecated: Gracefully shut down a resource by name or filename"
msgstr "Deprecated: Gracefully shut down a resource by name or filename"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/get_contexts.go#L62
#: pkg/kubectl/cmd/config/get_contexts.go:64
msgid "Describe one or many contexts"
msgstr "Describe one or many contexts"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/top_node.go#L77
#: pkg/kubectl/cmd/top_node.go:78
msgid "Display Resource (CPU/Memory) usage of nodes"
msgstr "Display Resource (CPU/Memory) usage of nodes"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/top_pod.go#L79
#: pkg/kubectl/cmd/top_pod.go:80
msgid "Display Resource (CPU/Memory) usage of pods"
msgstr "Display Resource (CPU/Memory) usage of pods"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/top.go#L43
#: pkg/kubectl/cmd/top.go:44
msgid "Display Resource (CPU/Memory) usage."
msgstr "Display Resource (CPU/Memory) usage."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/clusterinfo.go#L49
#: pkg/kubectl/cmd/clusterinfo.go:51
msgid "Display cluster info"
msgstr "Display cluster info"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/get_clusters.go#L40
#: pkg/kubectl/cmd/config/get_clusters.go:41
msgid "Display clusters defined in the kubeconfig"
msgstr "Display clusters defined in the kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/view.go#L64
#: pkg/kubectl/cmd/config/view.go:67
msgid "Display merged kubeconfig settings or a specified kubeconfig file"
msgstr "Display merged kubeconfig settings or a specified kubeconfig file"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/get.go#L107
#: pkg/kubectl/cmd/get.go:111
msgid "Display one or many resources"
msgstr "Display one or many resources"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/current_context.go#L48
#: pkg/kubectl/cmd/config/current_context.go:49
msgid "Displays the current-context"
msgstr "Displays the current-context"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/explain.go#L50
#: pkg/kubectl/cmd/explain.go:51
msgid "Documentation of resources"
msgstr "Documentation of resources"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L176
#: pkg/kubectl/cmd/drain.go:178
msgid "Drain node in preparation for maintenance"
msgstr "Drain node in preparation for maintenance"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/clusterinfo_dump.go#L37
#: pkg/kubectl/cmd/clusterinfo_dump.go:39
msgid "Dump lots of relevant info for debugging and diagnosis"
msgstr "Dump lots of relevant info for debugging and diagnosis"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/edit.go#L100
#: pkg/kubectl/cmd/edit.go:110
msgid "Edit a resource on the server"
msgstr "Edit a resource on the server"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L159
#: pkg/kubectl/cmd/create_secret.go:160
msgid "Email for Docker registry"
msgstr "Email for Docker registry"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/exec.go#L68
#: pkg/kubectl/cmd/exec.go:69
msgid "Execute a command in a container"
msgstr "Execute a command in a container"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L102
#: pkg/kubectl/cmd/rollingupdate.go:103
msgid ""
"Explicit policy for when to pull container images. Required when --image is "
"same as existing image, ignored otherwise."
msgstr ""
"Explicit policy for when to pull container images. Required when --image is "
"same as existing image, ignored otherwise."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/portforward.go#L75
#: pkg/kubectl/cmd/portforward.go:76
msgid "Forward one or more local ports to a pod"
msgstr "Forward one or more local ports to a pod"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/help.go#L36
#: pkg/kubectl/cmd/help.go:37
msgid "Help about any command"
msgstr "Help about any command"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L105
#: pkg/kubectl/cmd/expose.go:103
msgid ""
"IP to assign to the Load Balancer. If empty, an ephemeral IP will be created "
"and used (cloud-provider specific)."
msgstr ""
"IP to assign to the Load Balancer. If empty, an ephemeral IP will be created "
"and used (cloud-provider specific)."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L114
#: pkg/kubectl/cmd/expose.go:112
msgid ""
"If non-empty, set the session affinity for the service to this; legal "
"values: 'None', 'ClientIP'"
msgstr ""
"If non-empty, set the session affinity for the service to this; legal "
"values: 'None', 'ClientIP'"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/annotate.go#L135
#: pkg/kubectl/cmd/annotate.go:136
msgid ""
"If non-empty, the annotation update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."
msgstr ""
"If non-empty, the annotation update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/label.go#L132
#: pkg/kubectl/cmd/label.go:134
msgid ""
"If non-empty, the labels update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."
msgstr ""
"If non-empty, the labels update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L98
#: pkg/kubectl/cmd/rollingupdate.go:99
msgid ""
"Image to use for upgrading the replication controller. Must be distinct from "
"the existing image (either new image or new image tag).  Can not be used "
"with --filename/-f"
msgstr ""
"Image to use for upgrading the replication controller. Must be distinct from "
"the existing image (either new image or new image tag).  Can not be used "
"with --filename/-f"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout.go#L46
#: pkg/kubectl/cmd/rollout/rollout.go:47
msgid "Manage a deployment rollout"
msgstr "Manage a deployment rollout"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L127
#: pkg/kubectl/cmd/drain.go:128
msgid "Mark node as schedulable"
msgstr "Mark node as schedulable"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L102
#: pkg/kubectl/cmd/drain.go:103
msgid "Mark node as unschedulable"
msgstr "Mark node as unschedulable"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_pause.go#L73
#: pkg/kubectl/cmd/rollout/rollout_pause.go:74
msgid "Mark the provided resource as paused"
msgstr "Mark the provided resource as paused"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/certificates.go#L35
#: pkg/kubectl/cmd/certificates.go:36
msgid "Modify certificate resources."
msgstr "Modify certificate resources."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/config.go#L39
#: pkg/kubectl/cmd/config/config.go:40
msgid "Modify kubeconfig files"
msgstr "Modify kubeconfig files"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L110
#: pkg/kubectl/cmd/expose.go:108
msgid ""
"Name or number for the port on the container that the service should direct "
"traffic to. Optional."
msgstr ""
"Name or number for the port on the container that the service should direct "
"traffic to. Optional."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/logs.go#L108
#: pkg/kubectl/cmd/logs.go:113
msgid ""
"Only return logs after a specific date (RFC3339). Defaults to all logs. Only "
"one of since-time / since may be used."
msgstr ""
"Only return logs after a specific date (RFC3339). Defaults to all logs. Only "
"one of since-time / since may be used."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/completion.go#L97
#: pkg/kubectl/cmd/completion.go:104
msgid "Output shell completion code for the specified shell (bash or zsh)"
msgstr "Output shell completion code for the specified shell (bash or zsh)"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/edit.go#L115
#: pkg/kubectl/cmd/convert.go:85
msgid ""
"Output the formatted object with the given group version (for ex: "
"'extensions/v1beta1').)"
msgstr ""
"Output the formatted object with the given group version (for ex: "
"'extensions/v1beta1').)"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L157
#: pkg/kubectl/cmd/create_secret.go:158
msgid "Password for Docker registry authentication"
msgstr "Password for Docker registry authentication"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L226
#: pkg/kubectl/cmd/create_secret.go:226
msgid "Path to PEM encoded public key certificate."
msgstr "Path to PEM encoded public key certificate."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L227
#: pkg/kubectl/cmd/create_secret.go:227
msgid "Path to private key associated with given certificate."
msgstr "Path to private key associated with given certificate."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L84
#: pkg/kubectl/cmd/rollingupdate.go:85
msgid "Perform a rolling update of the given ReplicationController"
msgstr "Perform a rolling update of the given ReplicationController"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/scale.go#L82
#: pkg/kubectl/cmd/scale.go:83
msgid ""
"Precondition for resource version. Requires that the current resource "
"version match this value in order to scale."
msgstr ""
"Precondition for resource version. Requires that the current resource "
"version match this value in order to scale."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/version.go#L39
#: pkg/kubectl/cmd/version.go:40
msgid "Print the client and server version information"
msgstr "Print the client and server version information"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/options.go#L37
#: pkg/kubectl/cmd/options.go:38
msgid "Print the list of flags inherited by all commands"
msgstr "Print the list of flags inherited by all commands"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/logs.go#L86
#: pkg/kubectl/cmd/logs.go:93
msgid "Print the logs for a container in a pod"
msgstr "Print the logs for a container in a pod"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/replace.go#L70
#: pkg/kubectl/cmd/replace.go:71
msgid "Replace a resource by filename or stdin"
msgstr "Replace a resource by filename or stdin"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_resume.go#L71
#: pkg/kubectl/cmd/rollout/rollout_resume.go:72
msgid "Resume a paused resource"
msgstr "Resume a paused resource"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_rolebinding.go#L56
#: pkg/kubectl/cmd/create_rolebinding.go:57
msgid "Role this RoleBinding should reference"
msgstr "Role this RoleBinding should reference"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L94
#: pkg/kubectl/cmd/run.go:97
msgid "Run a particular image on the cluster"
msgstr "Run a particular image on the cluster"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/proxy.go#L68
#: pkg/kubectl/cmd/proxy.go:69
msgid "Run a proxy to the Kubernetes API server"
msgstr "Run a proxy to the Kubernetes API server"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L161
#: pkg/kubectl/cmd/create_secret.go:161
msgid "Server location for Docker registry"
msgstr "Server location for Docker registry"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/scale.go#L71
#: pkg/kubectl/cmd/scale.go:71
msgid ""
"Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job"
msgstr ""
"Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/set/set.go#L37
#: pkg/kubectl/cmd/set/set.go:38
msgid "Set specific features on objects"
msgstr "Set specific features on objects"

#: pkg/kubectl/cmd/apply_set_last_applied.go:83
msgid ""
"Set the last-applied-configuration annotation on a live object to match the "
"contents of a file."
msgstr ""
"Set the last-applied-configuration annotation on a live object to match the "
"contents of a file."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/set/set_selector.go#L81
#: pkg/kubectl/cmd/set/set_selector.go:82
msgid "Set the selector on a resource"
msgstr "Set the selector on a resource"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_cluster.go#L67
#: pkg/kubectl/cmd/config/create_cluster.go:68
msgid "Sets a cluster entry in kubeconfig"
msgstr "Sets a cluster entry in kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_context.go#L57
#: pkg/kubectl/cmd/config/create_context.go:58
msgid "Sets a context entry in kubeconfig"
msgstr "Sets a context entry in kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_authinfo.go#L103
#: pkg/kubectl/cmd/config/create_authinfo.go:104
msgid "Sets a user entry in kubeconfig"
msgstr "Sets a user entry in kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/set.go#L59
#: pkg/kubectl/cmd/config/set.go:60
msgid "Sets an individual value in a kubeconfig file"
msgstr "Sets an individual value in a kubeconfig file"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/use_context.go#L48
#: pkg/kubectl/cmd/config/use_context.go:49
msgid "Sets the current-context in a kubeconfig file"
msgstr "Sets the current-context in a kubeconfig file"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/describe.go#L80
#: pkg/kubectl/cmd/describe.go:86
msgid "Show details of a specific resource or group of resources"
msgstr "Show details of a specific resource or group of resources"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_status.go#L57
#: pkg/kubectl/cmd/rollout/rollout_status.go:58
msgid "Show the status of the rollout"
msgstr "Show the status of the rollout"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L108
#: pkg/kubectl/cmd/expose.go:106
msgid "Synonym for --target-port"
msgstr "Synonym for --target-port"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L87
#: pkg/kubectl/cmd/expose.go:88
msgid ""
"Take a replication controller, service, deployment or pod and expose it as a "
"new Kubernetes Service"
msgstr ""
"Take a replication controller, service, deployment or pod and expose it as a "
"new Kubernetes Service"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L114
#: pkg/kubectl/cmd/run.go:117
msgid "The image for the container to run."
msgstr "The image for the container to run."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L116
#: pkg/kubectl/cmd/run.go:119
msgid ""
"The image pull policy for the container. If left empty, this value will not "
"be specified by the client and defaulted by the server"
msgstr ""
"The image pull policy for the container. If left empty, this value will not "
"be specified by the client and defaulted by the server"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L100
#: pkg/kubectl/cmd/rollingupdate.go:101
msgid ""
"The key to use to differentiate between two different controllers, default "
"'deployment'.  Only relevant when --image is specified, ignored otherwise"
msgstr ""
"The key to use to differentiate between two different controllers, default "
"'deployment'.  Only relevant when --image is specified, ignored otherwise"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_pdb.go#L62
#: pkg/kubectl/cmd/create_pdb.go:63
msgid ""
"The minimum number or percentage of available pods this budget requires."
msgstr ""
"The minimum number or percentage of available pods this budget requires."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L113
#: pkg/kubectl/cmd/expose.go:111
msgid "The name for the newly created object."
msgstr "The name for the newly created object."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/autoscale.go#L71
#: pkg/kubectl/cmd/autoscale.go:72
msgid ""
"The name for the newly created object. If not specified, the name of the "
"input resource will be used."
msgstr ""
"The name for the newly created object. If not specified, the name of the "
"input resource will be used."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L113
#: pkg/kubectl/cmd/run.go:116
msgid ""
"The name of the API generator to use, see http://kubernetes.io/docs/user-"
"guide/kubectl-conventions/#generators for a list."
msgstr ""
"The name of the API generator to use, see http://kubernetes.io/docs/user-"
"guide/kubectl-conventions/#generators for a list."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/autoscale.go#L66
#: pkg/kubectl/cmd/autoscale.go:67
msgid ""
"The name of the API generator to use. Currently there is only 1 generator."
msgstr ""
"The name of the API generator to use. Currently there is only 1 generator."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L98
#: pkg/kubectl/cmd/expose.go:99
msgid ""
"The name of the API generator to use. There are 2 generators: 'service/v1' "
"and 'service/v2'. The only difference between them is that service port in "
"v1 is named 'default', while it is left unnamed in v2. Default is 'service/"
"v2'."
msgstr ""
"The name of the API generator to use. There are 2 generators: 'service/v1' "
"and 'service/v2'. The only difference between them is that service port in "
"v1 is named 'default', while it is left unnamed in v2. Default is 'service/"
"v2'."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L133
#: pkg/kubectl/cmd/run.go:136
msgid ""
"The name of the generator to use for creating a service.  Only used if --"
"expose is true"
msgstr ""
"The name of the generator to use for creating a service.  Only used if --"
"expose is true"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L99
#: pkg/kubectl/cmd/expose.go:100
msgid "The network protocol for the service to be created. Default is 'TCP'."
msgstr "The network protocol for the service to be created. Default is 'TCP'."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L100
#: pkg/kubectl/cmd/expose.go:101
msgid ""
"The port that the service should serve on. Copied from the resource being "
"exposed, if unspecified"
msgstr ""
"The port that the service should serve on. Copied from the resource being "
"exposed, if unspecified"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L121
#: pkg/kubectl/cmd/run.go:124
msgid ""
"The port that this container exposes.  If --expose is true, this is also the "
"port used by the service that is created."
msgstr ""
"The port that this container exposes.  If --expose is true, this is also the "
"port used by the service that is created."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L131
#: pkg/kubectl/cmd/run.go:134
msgid ""
"The resource requirement limits for this container.  For example, 'cpu=200m,"
"memory=512Mi'.  Note that server side components may assign limits depending "
"on the server configuration, such as limit ranges."
msgstr ""
"The resource requirement limits for this container.  For example, 'cpu=200m,"
"memory=512Mi'.  Note that server side components may assign limits depending "
"on the server configuration, such as limit ranges."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L130
#: pkg/kubectl/cmd/run.go:133
msgid ""
"The resource requirement requests for this container.  For example, "
"'cpu=100m,memory=256Mi'.  Note that server side components may assign "
"requests depending on the server configuration, such as limit ranges."
msgstr ""
"The resource requirement requests for this container.  For example, "
"'cpu=100m,memory=256Mi'.  Note that server side components may assign "
"requests depending on the server configuration, such as limit ranges."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L128
#: pkg/kubectl/cmd/run.go:131
msgid ""
"The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  "
"If set to 'Always' a deployment is created, if set to 'OnFailure' a job is "
"created, if set to 'Never', a regular pod is created. For the latter two --"
"replicas must be 1.  Default 'Always', for CronJobs ` + "`" + `Never` + "`" + `."
msgstr ""
"The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  "
"If set to 'Always' a deployment is created, if set to 'OnFailure' a job is "
"created, if set to 'Never', a regular pod is created. For the latter two --"
"replicas must be 1.  Default 'Always', for CronJobs ` + "`" + `Never` + "`" + `."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L87
#: pkg/kubectl/cmd/create_secret.go:88
msgid "The type of secret to create"
msgstr "The type of secret to create"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L101
#: pkg/kubectl/cmd/expose.go:102
msgid ""
"Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is "
"'ClusterIP'."
msgstr ""
"Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is "
"'ClusterIP'."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_undo.go#L71
#: pkg/kubectl/cmd/rollout/rollout_undo.go:72
msgid "Undo a previous rollout"
msgstr "Undo a previous rollout"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/unset.go#L47
#: pkg/kubectl/cmd/config/unset.go:48
msgid "Unsets an individual value in a kubeconfig file"
msgstr "Unsets an individual value in a kubeconfig file"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/patch.go#L91
#: pkg/kubectl/cmd/patch.go:96
msgid "Update field(s) of a resource using strategic merge patch"
msgstr "Update field(s) of a resource using strategic merge patch"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/set/set_image.go#L94
#: pkg/kubectl/cmd/set/set_image.go:95
msgid "Update image of a pod template"
msgstr "Update image of a pod template"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/set/set_resources.go#L101
#: pkg/kubectl/cmd/set/set_resources.go:102
msgid "Update resource requests/limits on objects with pod templates"
msgstr "Update resource requests/limits on objects with pod templates"

#: pkg/kubectl/cmd/annotate.go:116
msgid "Update the annotations on a resource"
msgstr "Update the annotations on a resource"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/label.go#L109
#: pkg/kubectl/cmd/label.go:114
msgid "Update the labels on a resource"
msgstr "Update the labels on a resource"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/taint.go#L88
#: pkg/kubectl/cmd/taint.go:87
msgid "Update the taints on one or more nodes"
msgstr "Update the taints on one or more nodes"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L155
#: pkg/kubectl/cmd/create_secret.go:156
msgid "Username for Docker registry authentication"
msgstr "Username for Docker registry authentication"

#: pkg/kubectl/cmd/apply_view_last_applied.go:64
msgid "View latest last-applied-configuration annotations of a resource/object"
msgstr ""
"View latest last-applied-configuration annotations of a resource/object"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_history.go#L51
#: pkg/kubectl/cmd/rollout/rollout_history.go:52
msgid "View rollout history"
msgstr "View rollout history"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/clusterinfo_dump.go#L45
#: pkg/kubectl/cmd/clusterinfo_dump.go:46
msgid ""
"Where to output the files.  If empty or '-' uses stdout, otherwise creates a "
"directory hierarchy in that directory"
msgstr ""
"Where to output the files.  If empty or '-' uses stdout, otherwise creates a "
"directory hierarchy in that directory"

#: pkg/kubectl/cmd/run_test.go:85
msgid "dummy restart flag)"
msgstr "dummy restart flag)"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L253
#: pkg/kubectl/cmd/create_service.go:254
msgid "external name of service"
msgstr "external name of service"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/cmd.go#L217
#: pkg/kubectl/cmd/cmd.go:227
msgid "kubectl controls the Kubernetes cluster manager"
msgstr "kubectl controls the Kubernetes cluster manager"

#~ msgid ""
#~ "watch is only supported on individual resources and resource collections "
#~ "- %d resources were found"
#~ msgid_plural ""
#~ "watch is only supported on individual resources and resource collections "
#~ "- %d resources were found"
#~ msgstr[0] ""
#~ "watch is only supported on individual resources and resource collections "
#~ "- %d resource was found"
#~ msgstr[1] ""
#~ "watch is only supported on individual resources and resource collections "
#~ "- %d resources were found"
`)

func translationsKubectlEn_usLc_messagesK8sPoBytes() ([]byte, error) {
	return _translationsKubectlEn_usLc_messagesK8sPo, nil
}

func translationsKubectlEn_usLc_messagesK8sPo() (*asset, error) {
	bytes, err := translationsKubectlEn_usLc_messagesK8sPoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/en_US/LC_MESSAGES/k8s.po", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlFr_frLc_messagesK8sMo = []byte("\xde\x12\x04\x95\x00\x00\x00\x00\x11\x00\x00\x00\x1c\x00\x00\x00\xa4\x00\x00\x00\x17\x00\x00\x00,\x01\x00\x00\x00\x00\x00\x00\x88\x01\x00\x008\x00\x00\x00\x89\x01\x00\x000\x00\x00\x00\xc2\x01\x00\x000\x00\x00\x00\xf3\x01\x00\x00\x1d\x00\x00\x00$\x02\x00\x00*\x00\x00\x00B\x02\x00\x00A\x00\x00\x00m\x02\x00\x00\x1c\x00\x00\x00\xaf\x02\x00\x00\x17\x00\x00\x00\xcc\x02\x00\x00\"\x00\x00\x00\xe4\x02\x00\x00\"\x00\x00\x00\a\x03\x00\x00\x1f\x00\x00\x00*\x03\x00\x00-\x00\x00\x00J\x03\x00\x00-\x00\x00\x00x\x03\x00\x00/\x00\x00\x00\xa6\x03\x00\x00$\x00\x00\x00\xd6\x03\x00\x00\xc5\x00\x00\x00\xfb\x03\x00\x00\xab\x01\x00\x00\xc1\x04\x00\x00O\x00\x00\x00m\x06\x00\x00-\x00\x00\x00\xbd\x06\x00\x00.\x00\x00\x00\xeb\x06\x00\x00\"\x00\x00\x00\x1a\a\x00\x00-\x00\x00\x00=\a\x00\x00W\x00\x00\x00k\a\x00\x00\x1a\x00\x00\x00\xc3\a\x00\x00 \x00\x00\x00\xde\a\x00\x00#\x00\x00\x00\xff\a\x00\x00$\x00\x00\x00#\b\x00\x00'\x00\x00\x00H\b\x00\x00;\x00\x00\x00p\b\x00\x007\x00\x00\x00\xac\b\x00\x00;\x00\x00\x00\xe4\b\x00\x00.\x00\x00\x00 \t\x00\x00\x05\x01\x00\x00O\t\x00\x00\x01\x00\x00\x00\n\x00\x00\x00\v\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\t\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\a\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\b\x00\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\f\x00\x00\x00\x05\x00\x00\x00\r\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00Apply a configuration to a resource by filename or stdin\x00Delete the specified cluster from the kubeconfig\x00Delete the specified context from the kubeconfig\x00Describe one or many contexts\x00Display clusters defined in the kubeconfig\x00Display merged kubeconfig settings or a specified kubeconfig file\x00Displays the current-context\x00Modify kubeconfig files\x00Sets a cluster entry in kubeconfig\x00Sets a context entry in kubeconfig\x00Sets a user entry in kubeconfig\x00Sets an individual value in a kubeconfig file\x00Sets the current-context in a kubeconfig file\x00Unsets an individual value in a kubeconfig file\x00Update the annotations on a resource\x00watch is only supported on individual resources and resource collections - %d resources were found\x00watch is only supported on individual resources and resource collections - %d resources were found\x00Project-Id-Version: gettext-go-examples-hello\nReport-Msgid-Bugs-To: \nPOT-Creation-Date: 2013-12-12 20:03+0000\nPO-Revision-Date: 2017-01-29 22:54-0800\nLast-Translator: Brendan Burns <brendan.d.burns@gmail.com>\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 8bit\nX-Generator: Poedit 1.6.10\nX-Poedit-SourceCharset: UTF-8\nLanguage-Team: \nPlural-Forms: nplurals=2; plural=(n > 1);\nLanguage: fr\n\x00Appliquer une configuration \u00e0 une ressource par nom de fichier ou depuis stdin\x00Supprimer le cluster sp\u00e9cifi\u00e9 du kubeconfig\x00Supprimer le contexte sp\u00e9cifi\u00e9 du kubeconfig\x00D\u00e9crire un ou plusieurs contextes\x00Afficher les cluster d\u00e9finis dans kubeconfig\x00Afficher les param\u00e8tres fusionn\u00e9s de kubeconfig ou d'un fichier kubeconfig sp\u00e9cifi\u00e9\x00Affiche le contexte actuel\x00Modifier des fichiers kubeconfig\x00D\u00e9finit un cluster dans kubeconfig\x00D\u00e9finit un contexte dans kubeconfig\x00D\u00e9finit un utilisateur dans kubeconfig\x00D\u00e9finit une valeur individuelle dans un fichier kubeconfig\x00D\u00e9finit le contexte courant dans un fichier kubeconfig\x00Supprime une valeur individuelle dans un fichier kubeconfig\x00Mettre \u00e0 jour les annotations d'une ressource\x00watch n'est compatible qu'avec les ressources individuelles et les collections de ressources.  - %d ressource a \u00e9t\u00e9 trouv\u00e9e. \x00watch n'est compatible qu'avec les ressources individuelles et les collections de ressources.  - %d ressources ont \u00e9t\u00e9 trouv\u00e9es. \x00")

func translationsKubectlFr_frLc_messagesK8sMoBytes() ([]byte, error) {
	return _translationsKubectlFr_frLc_messagesK8sMo, nil
}

func translationsKubectlFr_frLc_messagesK8sMo() (*asset, error) {
	bytes, err := translationsKubectlFr_frLc_messagesK8sMoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/fr_FR/LC_MESSAGES/k8s.mo", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlFr_frLc_messagesK8sPo = []byte(`# Test translations for unit tests.
# Copyright (C) 2016
# This file is distributed under the same license as the Kubernetes package.
# FIRST AUTHOR brendan.d.burns@gmail.com, 2016.
#
msgid ""
msgstr ""
"Project-Id-Version: gettext-go-examples-hello\n"
"Report-Msgid-Bugs-To: \n"
"POT-Creation-Date: 2013-12-12 20:03+0000\n"
"PO-Revision-Date: 2017-01-29 22:54-0800\n"
"Last-Translator: Brendan Burns <brendan.d.burns@gmail.com>\n"
"MIME-Version: 1.0\n"
"Content-Type: text/plain; charset=UTF-8\n"
"Content-Transfer-Encoding: 8bit\n"
"X-Generator: Poedit 1.6.10\n"
"X-Poedit-SourceCharset: UTF-8\n"
"Language-Team: \n"
"Plural-Forms: nplurals=2; plural=(n > 1);\n"
"Language: fr\n"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/apply.go#L98
msgid "Apply a configuration to a resource by filename or stdin"
msgstr ""
"Appliquer une configuration à une ressource par nom de fichier ou depuis "
"stdin"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/delete_cluster.go#L38
msgid "Delete the specified cluster from the kubeconfig"
msgstr "Supprimer le cluster spécifié du kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/delete_context.go#L38
msgid "Delete the specified context from the kubeconfig"
msgstr "Supprimer le contexte spécifié du kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/get_contexts.go#L62
msgid "Describe one or many contexts"
msgstr "Décrire un ou plusieurs contextes"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/get_clusters.go#L40
msgid "Display clusters defined in the kubeconfig"
msgstr "Afficher les cluster définis dans kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/view.go#L64
msgid "Display merged kubeconfig settings or a specified kubeconfig file"
msgstr ""
"Afficher les paramètres fusionnés de kubeconfig ou d'un fichier kubeconfig "
"spécifié"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/current_context.go#L48
msgid "Displays the current-context"
msgstr "Affiche le contexte actuel"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/config.go#L39
msgid "Modify kubeconfig files"
msgstr "Modifier des fichiers kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_cluster.go#L67
msgid "Sets a cluster entry in kubeconfig"
msgstr "Définit un cluster dans kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_context.go#L57
msgid "Sets a context entry in kubeconfig"
msgstr "Définit un contexte dans kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_authinfo.go#L103
msgid "Sets a user entry in kubeconfig"
msgstr "Définit un utilisateur dans kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/set.go#L59
msgid "Sets an individual value in a kubeconfig file"
msgstr "Définit une valeur individuelle dans un fichier kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/use_context.go#L48
msgid "Sets the current-context in a kubeconfig file"
msgstr "Définit le contexte courant dans un fichier kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/unset.go#L47
msgid "Unsets an individual value in a kubeconfig file"
msgstr "Supprime une valeur individuelle dans un fichier kubeconfig"

msgid "Update the annotations on a resource"
msgstr "Mettre à jour les annotations d'une ressource"

msgid ""
"watch is only supported on individual resources and resource collections - "
"%d resources were found"
msgid_plural ""
"watch is only supported on individual resources and resource collections - "
"%d resources were found"
msgstr[0] ""
"watch n'est compatible qu'avec les ressources individuelles et les "
"collections de ressources.  - %d ressource a été trouvée. "
msgstr[1] ""
"watch n'est compatible qu'avec les ressources individuelles et les "
"collections de ressources.  - %d ressources ont été trouvées. "
`)

func translationsKubectlFr_frLc_messagesK8sPoBytes() ([]byte, error) {
	return _translationsKubectlFr_frLc_messagesK8sPo, nil
}

func translationsKubectlFr_frLc_messagesK8sPo() (*asset, error) {
	bytes, err := translationsKubectlFr_frLc_messagesK8sPoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/fr_FR/LC_MESSAGES/k8s.po", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlIt_itLc_messagesK8sMo = []byte("\xde\x12\x04\x95\x00\x00\x00\x00\xeb\x00\x00\x00\x1c\x00\x00\x00t\a\x00\x009\x01\x00\x00\xcc\x0e\x00\x00\x00\x00\x00\x00\xb0\x13\x00\x00\xdc\x00\x00\x00\xb1\x13\x00\x00\xb6\x00\x00\x00\x8e\x14\x00\x00\v\x02\x00\x00E\x15\x00\x00\x1f\x01\x00\x00Q\x17\x00\x00z\x00\x00\x00q\x18\x00\x00_\x02\x00\x00\xec\x18\x00\x00\u007f\x01\x00\x00L\x1b\x00\x00\x8f\x01\x00\x00\xcc\x1c\x00\x00k\x01\x00\x00\\\x1e\x00\x00k\x01\x00\x00\xc8\x1f\x00\x00>\x01\x00\x004!\x00\x00\x03\x02\x00\x00s\"\x00\x00o\x01\x00\x00w$\x00\x00H\x05\x00\x00\xe7%\x00\x00g\x02\x00\x000+\x00\x00\x1b\x02\x00\x00\x98-\x00\x00q\x01\x00\x00\xb4/\x00\x00\xa8\x01\x00\x00&1\x00\x00\xd4\x01\x00\x00\xcf2\x00\x00\x02\x02\x00\x00\xa44\x00\x00\xb4\x00\x00\x00\xa76\x00\x00\xb7\x02\x00\x00\\7\x00\x00\x92\x03\x00\x00\x14:\x00\x00\xbf\x01\x00\x00\xa7=\x00\x00=\x00\x00\x00g?\x00\x00;\x00\x00\x00\xa5?\x00\x00\xcd\x02\x00\x00\xe1?\x00\x00<\x00\x00\x00\xafB\x00\x00P\x00\x00\x00\xecB\x00\x00S\x00\x00\x00=C\x00\x00<\x00\x00\x00\x91C\x00\x00\xac\x01\x00\x00\xceC\x00\x00\x13\x03\x00\x00{E\x00\x00\xea\x01\x00\x00\x8fH\x00\x00\xfa\x01\x00\x00zJ\x00\x00\xda\x01\x00\x00uL\x00\x00c\x01\x00\x00PN\x00\x00T\x01\x00\x00\xb4O\x00\x00\xba\x06\x00\x00\tQ\x00\x00\xf9\x01\x00\x00\xc4W\x00\x00\xe0\x02\x00\x00\xbeY\x00\x00\x02\x03\x00\x00\x9f\\\x00\x00\xfb\x00\x00\x00\xa2_\x00\x00\xa5\x01\x00\x00\x9e`\x00\x00\xb4\x01\x00\x00Db\x00\x00\x18\x00\x00\x00\xf9c\x00\x00<\x00\x00\x00\x12d\x00\x00=\x00\x00\x00Od\x00\x00\xc6\x00\x00\x00\x8dd\x00\x00g\x02\x00\x00Te\x00\x00.\x00\x00\x00\xbcg\x00\x001\x03\x00\x00\xebg\x00\x00g\x00\x00\x00\x1dk\x00\x00Q\x00\x00\x00\x85k\x00\x00R\x00\x00\x00\xd7k\x00\x00\"\x00\x00\x00*l\x00\x00X\x02\x00\x00Ml\x00\x004\x00\x00\x00\xa6n\x00\x00}\x00\x00\x00\xdbn\x00\x00k\x01\x00\x00Yo\x00\x00\x81\a\x00\x00\xc5p\x00\x00f\x01\x00\x00Gx\x00\x00\x85\x00\x00\x00\xaey\x00\x00\xea\x00\x00\x004z\x00\x00\xd9\x00\x00\x00\x1f{\x00\x00\n\x05\x00\x00\xf9{\x00\x00\x10\x05\x00\x00\x04\x81\x00\x00\x1c\x00\x00\x00\x15\x86\x00\x00\x1e\x00\x00\x002\x86\x00\x00\x98\x02\x00\x00Q\x86\x00\x00\xbc\x01\x00\x00\xea\x88\x00\x00\x9c\x01\x00\x00\xa7\x8a\x00\x00q\x01\x00\x00D\x8c\x00\x00\x05\x01\x00\x00\xb6\x8d\x00\x00\xdf\x01\x00\x00\xbc\x8e\x00\x00\x1c\x01\x00\x00\x9c\x90\x00\x00\xc1\x01\x00\x00\xb9\x91\x00\x00\x1b\x02\x00\x00{\x93\x00\x00\xc0\x00\x00\x00\x97\x95\x00\x00\xd5\x02\x00\x00X\x96\x00\x00\x9d\x00\x00\x00.\x99\x00\x00X\x00\x00\x00\u0319\x00\x00%\x02\x00\x00%\x9a\x00\x00o\x00\x00\x00K\x9c\x00\x00u\x00\x00\x00\xbb\x9c\x00\x00\x01\x01\x00\x001\x9d\x00\x00v\x00\x00\x003\x9e\x00\x00t\x00\x00\x00\xaa\x9e\x00\x00\xef\x00\x00\x00\x1f\x9f\x00\x00}\x00\x00\x00\x0f\xa0\x00\x00j\x00\x00\x00\x8d\xa0\x00\x00\xc4\x01\x00\x00\xf8\xa0\x00\x00\xf7\x03\x00\x00\xbd\xa2\x00\x00;\x00\x00\x00\xb5\xa6\x00\x008\x00\x00\x00\xf1\xa6\x00\x001\x00\x00\x00*\xa7\x00\x007\x00\x00\x00\\\xa7\x00\x00u\x02\x00\x00\x94\xa7\x00\x00\xb0\x00\x00\x00\n\xaa\x00\x00[\x00\x00\x00\xbb\xaa\x00\x00J\x00\x00\x00\x17\xab\x00\x00a\x00\x00\x00b\xab\x00\x00\xbd\x00\x00\x00\u012b\x00\x009\x00\x00\x00\x82\xac\x00\x00\xc5\x00\x00\x00\xbc\xac\x00\x00\xae\x00\x00\x00\x82\xad\x00\x00\xd6\x00\x00\x001\xae\x00\x008\x00\x00\x00\b\xaf\x00\x00%\x00\x00\x00A\xaf\x00\x00W\x00\x00\x00g\xaf\x00\x00\x1d\x00\x00\x00\xbf\xaf\x00\x00=\x00\x00\x00\u076f\x00\x00u\x00\x00\x00\x1b\xb0\x00\x004\x00\x00\x00\x91\xb0\x00\x00-\x00\x00\x00\u01b0\x00\x00\xa3\x00\x00\x00\xf4\xb0\x00\x003\x00\x00\x00\x98\xb1\x00\x002\x00\x00\x00\u0331\x00\x008\x00\x00\x00\xff\xb1\x00\x00\x1e\x00\x00\x008\xb2\x00\x00\x1a\x00\x00\x00W\xb2\x00\x009\x00\x00\x00r\xb2\x00\x00\x13\x00\x00\x00\xac\xb2\x00\x00\x1b\x00\x00\x00\xc0\xb2\x00\x00@\x00\x00\x00\u0732\x00\x00,\x00\x00\x00\x1d\xb3\x00\x00*\x00\x00\x00J\xb3\x00\x007\x00\x00\x00u\xb3\x00\x00'\x00\x00\x00\xad\xb3\x00\x00&\x00\x00\x00\u0573\x00\x00.\x00\x00\x00\xfc\xb3\x00\x00=\x00\x00\x00+\xb4\x00\x00*\x00\x00\x00i\xb4\x00\x000\x00\x00\x00\x94\xb4\x00\x00,\x00\x00\x00\u0174\x00\x00\x1f\x00\x00\x00\xf2\xb4\x00\x00]\x00\x00\x00\x12\xb5\x00\x000\x00\x00\x00p\xb5\x00\x000\x00\x00\x00\xa1\xb5\x00\x00\"\x00\x00\x00\u04b5\x00\x00?\x00\x00\x00\xf5\xb5\x00\x00\x1d\x00\x00\x005\xb6\x00\x00,\x00\x00\x00S\xb6\x00\x00+\x00\x00\x00\x80\xb6\x00\x00$\x00\x00\x00\xac\xb6\x00\x00\x14\x00\x00\x00\u0476\x00\x00*\x00\x00\x00\xe6\xb6\x00\x00A\x00\x00\x00\x11\xb7\x00\x00\x1d\x00\x00\x00S\xb7\x00\x00\x1c\x00\x00\x00q\xb7\x00\x00\x1a\x00\x00\x00\x8e\xb7\x00\x00)\x00\x00\x00\xa9\xb7\x00\x006\x00\x00\x00\u04f7\x00\x00\x1d\x00\x00\x00\n\xb8\x00\x00\x19\x00\x00\x00(\xb8\x00\x00 \x00\x00\x00B\xb8\x00\x00v\x00\x00\x00c\xb8\x00\x00(\x00\x00\x00\u06b8\x00\x00\x16\x00\x00\x00\x03\xb9\x00\x00p\x00\x00\x00\x1a\xb9\x00\x00`\x00\x00\x00\x8b\xb9\x00\x00\x9b\x00\x00\x00\xec\xb9\x00\x00\x97\x00\x00\x00\x88\xba\x00\x00\xa8\x00\x00\x00 \xbb\x00\x00\x1b\x00\x00\x00\u027b\x00\x00\x18\x00\x00\x00\xe5\xbb\x00\x00\x1a\x00\x00\x00\xfe\xbb\x00\x00$\x00\x00\x00\x19\xbc\x00\x00\x1d\x00\x00\x00>\xbc\x00\x00\x17\x00\x00\x00\\\xbc\x00\x00a\x00\x00\x00t\xbc\x00\x00s\x00\x00\x00\u05bc\x00\x00B\x00\x00\x00J\xbd\x00\x00Y\x00\x00\x00\x8d\xbd\x00\x00+\x00\x00\x00\xe7\xbd\x00\x00+\x00\x00\x00\x13\xbe\x00\x006\x00\x00\x00?\xbe\x00\x00;\x00\x00\x00v\xbe\x00\x00q\x00\x00\x00\xb2\xbe\x00\x00/\x00\x00\x00$\xbf\x00\x001\x00\x00\x00T\xbf\x00\x00'\x00\x00\x00\x86\xbf\x00\x00'\x00\x00\x00\xae\xbf\x00\x00\x18\x00\x00\x00\u05bf\x00\x00&\x00\x00\x00\xef\xbf\x00\x00%\x00\x00\x00\x16\xc0\x00\x00(\x00\x00\x00<\xc0\x00\x00#\x00\x00\x00e\xc0\x00\x00K\x00\x00\x00\x89\xc0\x00\x00 \x00\x00\x00\xd5\xc0\x00\x00_\x00\x00\x00\xf6\xc0\x00\x00\x1e\x00\x00\x00V\xc1\x00\x00\"\x00\x00\x00u\xc1\x00\x00\"\x00\x00\x00\x98\xc1\x00\x00\x1f\x00\x00\x00\xbb\xc1\x00\x00-\x00\x00\x00\xdb\xc1\x00\x00-\x00\x00\x00\t\xc2\x00\x009\x00\x00\x007\xc2\x00\x00\x1e\x00\x00\x00q\xc2\x00\x00\x19\x00\x00\x00\x90\xc2\x00\x00c\x00\x00\x00\xaa\xc2\x00\x00#\x00\x00\x00\x0e\xc3\x00\x00\x82\x00\x00\x002\xc3\x00\x00\x94\x00\x00\x00\xb5\xc3\x00\x00H\x00\x00\x00J\xc4\x00\x00&\x00\x00\x00\x93\xc4\x00\x00e\x00\x00\x00\xba\xc4\x00\x00z\x00\x00\x00 \xc5\x00\x00J\x00\x00\x00\x9b\xc5\x00\x00\xe5\x00\x00\x00\xe6\xc5\x00\x00W\x00\x00\x00\xcc\xc6\x00\x00E\x00\x00\x00$\xc7\x00\x00a\x00\x00\x00j\xc7\x00\x00v\x00\x00\x00\xcc\xc7\x00\x00\xcb\x00\x00\x00C\xc8\x00\x00\xcf\x00\x00\x00\x0f\xc9\x00\x00\x1e\x01\x00\x00\xdf\xc9\x00\x00\x1c\x00\x00\x00\xfe\xca\x00\x00T\x00\x00\x00\x1b\xcb\x00\x00\x17\x00\x00\x00p\xcb\x00\x00/\x00\x00\x00\x88\xcb\x00\x009\x00\x00\x00\xb8\xcb\x00\x00\x1e\x00\x00\x00\xf2\xcb\x00\x00=\x00\x00\x00\x11\xcc\x00\x00$\x00\x00\x00O\xcc\x00\x00\x1f\x00\x00\x00t\xcc\x00\x00&\x00\x00\x00\x94\xcc\x00\x00+\x00\x00\x00\xbb\xcc\x00\x00G\x00\x00\x00\xe7\xcc\x00\x00\x14\x00\x00\x00/\xcd\x00\x00r\x00\x00\x00D\xcd\x00\x00\x13\x00\x00\x00\xb7\xcd\x00\x00\x18\x00\x00\x00\xcb\xcd\x00\x00/\x00\x00\x00\xe4\xcd\x00\x00\xc9\x01\x00\x00\x14\xce\x00\x00\xde\x00\x00\x00\xde\xcf\x00\x00\xb9\x00\x00\x00\xbd\xd0\x00\x00*\x02\x00\x00w\xd1\x00\x00/\x01\x00\x00\xa2\xd3\x00\x00\x87\x00\x00\x00\xd2\xd4\x00\x00v\x02\x00\x00Z\xd5\x00\x00\x9d\x01\x00\x00\xd1\xd7\x00\x00\xaa\x01\x00\x00o\xd9\x00\x00z\x01\x00\x00\x1a\xdb\x00\x00|\x01\x00\x00\x95\xdc\x00\x00L\x01\x00\x00\x12\xde\x00\x00\x06\x02\x00\x00_\xdf\x00\x00~\x01\x00\x00f\xe1\x00\x00j\x05\x00\x00\xe5\xe2\x00\x00\x96\x02\x00\x00P\xe8\x00\x00#\x02\x00\x00\xe7\xea\x00\x00\x8c\x01\x00\x00\v\xed\x00\x00\xd1\x01\x00\x00\x98\xee\x00\x00\t\x02\x00\x00j\xf0\x00\x00+\x02\x00\x00t\xf2\x00\x00\xc1\x00\x00\x00\xa0\xf4\x00\x00\xe0\x02\x00\x00b\xf5\x00\x00\xd1\x03\x00\x00C\xf8\x00\x00\xbc\x01\x00\x00\x15\xfc\x00\x00E\x00\x00\x00\xd2\xfd\x00\x00F\x00\x00\x00\x18\xfe\x00\x00\x13\x03\x00\x00_\xfe\x00\x00A\x00\x00\x00s\x01\x01\x00K\x00\x00\x00\xb5\x01\x01\x00P\x00\x00\x00\x01\x02\x01\x00=\x00\x00\x00R\x02\x01\x00\xd3\x01\x00\x00\x90\x02\x01\x00)\x03\x00\x00d\x04\x01\x00\x1c\x02\x00\x00\x8e\a\x01\x00\x02\x02\x00\x00\xab\t\x01\x00\xf5\x01\x00\x00\xae\v\x01\x00\x8b\x01\x00\x00\xa4\r\x01\x00W\x01\x00\x000\x0f\x01\x00\xe2\x06\x00\x00\x88\x10\x01\x00#\x02\x00\x00k\x17\x01\x00\f\x03\x00\x00\x8f\x19\x01\x00\n\x03\x00\x00\x9c\x1c\x01\x00\x1e\x01\x00\x00\xa7\x1f\x01\x00\xc0\x01\x00\x00\xc6 \x01\x00\xf9\x01\x00\x00\x87\"\x01\x00\x17\x00\x00\x00\x81$\x01\x00=\x00\x00\x00\x99$\x01\x00>\x00\x00\x00\xd7$\x01\x00\xe0\x00\x00\x00\x16%\x01\x00\xbc\x02\x00\x00\xf7%\x01\x00/\x00\x00\x00\xb4(\x01\x00\x96\x03\x00\x00\xe4(\x01\x00h\x00\x00\x00{,\x01\x00S\x00\x00\x00\xe4,\x01\x00T\x00\x00\x008-\x01\x00(\x00\x00\x00\x8d-\x01\x00\xbe\x02\x00\x00\xb6-\x01\x005\x00\x00\x00u0\x01\x00\x82\x00\x00\x00\xab0\x01\x00\x98\x01\x00\x00.1\x01\x00^\b\x00\x00\xc72\x01\x00}\x01\x00\x00&;\x01\x00\x93\x00\x00\x00\xa4<\x01\x00\x1f\x01\x00\x008=\x01\x00\xec\x00\x00\x00X>\x01\x00F\x05\x00\x00E?\x01\x00\xf3\x05\x00\x00\x8cD\x01\x00+\x00\x00\x00\x80J\x01\x001\x00\x00\x00\xacJ\x01\x00\xf7\x02\x00\x00\xdeJ\x01\x00\xd3\x01\x00\x00\xd6M\x01\x00\xc2\x01\x00\x00\xaaO\x01\x00\x88\x01\x00\x00mQ\x01\x00'\x01\x00\x00\xf6R\x01\x00\xff\x01\x00\x00\x1eT\x01\x00=\x01\x00\x00\x1eV\x01\x00\xc2\x01\x00\x00\\W\x01\x00c\x02\x00\x00\x1fY\x01\x00\xdb\x00\x00\x00\x83[\x01\x00\x01\x03\x00\x00_\\\x01\x00\xa9\x00\x00\x00a_\x01\x00^\x00\x00\x00\v`\x01\x00N\x02\x00\x00j`\x01\x00u\x00\x00\x00\xb9b\x01\x00}\x00\x00\x00/c\x01\x00)\x01\x00\x00\xadc\x01\x00\x8b\x00\x00\x00\xd7d\x01\x00}\x00\x00\x00ce\x01\x00\x06\x01\x00\x00\xe1e\x01\x00\x84\x00\x00\x00\xe8f\x01\x00s\x00\x00\x00mg\x01\x00\xf0\x01\x00\x00\xe1g\x01\x00\x13\x04\x00\x00\xd2i\x01\x00;\x00\x00\x00\xe6m\x01\x008\x00\x00\x00\"n\x01\x002\x00\x00\x00[n\x01\x009\x00\x00\x00\x8en\x01\x00\xd5\x02\x00\x00\xc8n\x01\x00\xc8\x00\x00\x00\x9eq\x01\x00p\x00\x00\x00gr\x01\x00]\x00\x00\x00\xd8r\x01\x00l\x00\x00\x006s\x01\x00\xba\x00\x00\x00\xa3s\x01\x00B\x00\x00\x00^t\x01\x00\xca\x00\x00\x00\xa1t\x01\x00\xb5\x00\x00\x00lu\x01\x00\xe6\x00\x00\x00\"v\x01\x007\x00\x00\x00\tw\x01\x00.\x00\x00\x00Aw\x01\x00r\x00\x00\x00pw\x01\x00$\x00\x00\x00\xe3w\x01\x00<\x00\x00\x00\bx\x01\x00\x86\x00\x00\x00Ex\x01\x00:\x00\x00\x00\xccx\x01\x003\x00\x00\x00\ay\x01\x00\xc6\x00\x00\x00;y\x01\x00=\x00\x00\x00\x02z\x01\x000\x00\x00\x00@z\x01\x009\x00\x00\x00qz\x01\x00 \x00\x00\x00\xabz\x01\x00\x1a\x00\x00\x00\xccz\x01\x009\x00\x00\x00\xe7z\x01\x00\x12\x00\x00\x00!{\x01\x00\x1b\x00\x00\x004{\x01\x00H\x00\x00\x00P{\x01\x00-\x00\x00\x00\x99{\x01\x00)\x00\x00\x00\xc7{\x01\x006\x00\x00\x00\xf1{\x01\x00'\x00\x00\x00(|\x01\x00&\x00\x00\x00P|\x01\x003\x00\x00\x00w|\x01\x00E\x00\x00\x00\xab|\x01\x004\x00\x00\x00\xf1|\x01\x005\x00\x00\x00&}\x01\x007\x00\x00\x00\\}\x01\x00\x1e\x00\x00\x00\x94}\x01\x00g\x00\x00\x00\xb3}\x01\x00-\x00\x00\x00\x1b~\x01\x00-\x00\x00\x00I~\x01\x00+\x00\x00\x00w~\x01\x00A\x00\x00\x00\xa3~\x01\x00\x1b\x00\x00\x00\xe5~\x01\x007\x00\x00\x00\x01\u007f\x01\x007\x00\x00\x009\u007f\x01\x00/\x00\x00\x00q\u007f\x01\x00#\x00\x00\x00\xa1\u007f\x01\x00(\x00\x00\x00\xc5\u007f\x01\x00P\x00\x00\x00\xee\u007f\x01\x00\x1d\x00\x00\x00?\x80\x01\x00\x1d\x00\x00\x00]\x80\x01\x00\x1c\x00\x00\x00{\x80\x01\x00,\x00\x00\x00\x98\x80\x01\x00F\x00\x00\x00\u0140\x01\x00!\x00\x00\x00\f\x81\x01\x00\x1c\x00\x00\x00.\x81\x01\x00#\x00\x00\x00K\x81\x01\x00\x88\x00\x00\x00o\x81\x01\x00(\x00\x00\x00\xf8\x81\x01\x00\x1b\x00\x00\x00!\x82\x01\x00u\x00\x00\x00=\x82\x01\x00e\x00\x00\x00\xb3\x82\x01\x00\xb4\x00\x00\x00\x19\x83\x01\x00\xab\x00\x00\x00\u0383\x01\x00\xc0\x00\x00\x00z\x84\x01\x00\x1e\x00\x00\x00;\x85\x01\x00)\x00\x00\x00Z\x85\x01\x00-\x00\x00\x00\x84\x85\x01\x00$\x00\x00\x00\xb2\x85\x01\x00&\x00\x00\x00\u05c5\x01\x00\x1a\x00\x00\x00\xfe\x85\x01\x00e\x00\x00\x00\x19\x86\x01\x00\x93\x00\x00\x00\u007f\x86\x01\x00M\x00\x00\x00\x13\x87\x01\x00g\x00\x00\x00a\x87\x01\x003\x00\x00\x00\u0247\x01\x007\x00\x00\x00\xfd\x87\x01\x00D\x00\x00\x005\x88\x01\x00@\x00\x00\x00z\x88\x01\x00\x84\x00\x00\x00\xbb\x88\x01\x009\x00\x00\x00@\x89\x01\x001\x00\x00\x00z\x89\x01\x00$\x00\x00\x00\xac\x89\x01\x00+\x00\x00\x00\u0449\x01\x00\x1f\x00\x00\x00\xfd\x89\x01\x00$\x00\x00\x00\x1d\x8a\x01\x00+\x00\x00\x00B\x8a\x01\x00*\x00\x00\x00n\x8a\x01\x00+\x00\x00\x00\x99\x8a\x01\x00V\x00\x00\x00\u014a\x01\x000\x00\x00\x00\x1c\x8b\x01\x00s\x00\x00\x00M\x8b\x01\x00%\x00\x00\x00\xc1\x8b\x01\x00&\x00\x00\x00\xe7\x8b\x01\x00&\x00\x00\x00\x0e\x8c\x01\x00%\x00\x00\x005\x8c\x01\x00/\x00\x00\x00[\x8c\x01\x000\x00\x00\x00\x8b\x8c\x01\x00B\x00\x00\x00\xbc\x8c\x01\x00\x1b\x00\x00\x00\xff\x8c\x01\x00\x19\x00\x00\x00\x1b\x8d\x01\x00i\x00\x00\x005\x8d\x01\x00(\x00\x00\x00\x9f\x8d\x01\x00\x8f\x00\x00\x00\u020d\x01\x00\xa3\x00\x00\x00X\x8e\x01\x00P\x00\x00\x00\xfc\x8e\x01\x00#\x00\x00\x00M\x8f\x01\x00i\x00\x00\x00q\x8f\x01\x00\x85\x00\x00\x00\u06cf\x01\x00M\x00\x00\x00a\x90\x01\x00\x03\x01\x00\x00\xaf\x90\x01\x00i\x00\x00\x00\xb3\x91\x01\x00P\x00\x00\x00\x1d\x92\x01\x00X\x00\x00\x00n\x92\x01\x00u\x00\x00\x00\u01d2\x01\x00\xed\x00\x00\x00=\x93\x01\x00\xf8\x00\x00\x00+\x94\x01\x00H\x01\x00\x00$\x95\x01\x00\x19\x00\x00\x00m\x96\x01\x00^\x00\x00\x00\x87\x96\x01\x00\x1d\x00\x00\x00\xe6\x96\x01\x00,\x00\x00\x00\x04\x97\x01\x00=\x00\x00\x001\x97\x01\x00$\x00\x00\x00o\x97\x01\x00C\x00\x00\x00\x94\x97\x01\x00\x1f\x00\x00\x00\u0617\x01\x00\x1d\x00\x00\x00\xf8\x97\x01\x00$\x00\x00\x00\x16\x98\x01\x004\x00\x00\x00;\x98\x01\x00V\x00\x00\x00p\x98\x01\x00 \x00\x00\x00\u01d8\x01\x00\x82\x00\x00\x00\xe8\x98\x01\x00\x16\x00\x00\x00k\x99\x01\x00\x19\x00\x00\x00\x82\x99\x01\x002\x00\x00\x00\x9c\x99\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00^\x00\x00\x00\\\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\x00\x00\x00\xc4\x00\x00\x00\x0f\x00\x00\x00\xc3\x00\x00\x00\x00\x00\x00\x00-\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\xeb\x00\x00\x00c\x00\x00\x00\x00\x00\x00\x001\x00\x00\x00o\x00\x00\x00}\x00\x00\x00\x00\x00\x00\x00J\x00\x00\x00\x00\x00\x00\x00\xd8\x00\x00\x00\x98\x00\x00\x00U\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdb\x00\x00\x00\x17\x00\x00\x00u\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc9\x00\x00\x00\xb7\x00\x00\x00\xd7\x00\x00\x00*\x00\x00\x00\x99\x00\x00\x00\x00\x00\x00\x00\x1f\x00\x00\x00\x84\x00\x00\x00\x9c\x00\x00\x00\xe6\x00\x00\x00\x9d\x00\x00\x00\xc5\x00\x00\x00\xd9\x00\x00\x00\xb9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x19\x00\x00\x00\xcd\x00\x00\x00\xcb\x00\x00\x00y\x00\x00\x00\x97\x00\x00\x00\xba\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00C\x00\x00\x00\x93\x00\x00\x00\xad\x00\x00\x00\xe1\x00\x00\x00\xa6\x00\x00\x00\xd0\x00\x00\x00r\x00\x00\x00+\x00\x00\x006\x00\x00\x00\x00\x00\x00\x00\xa5\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00h\x00\x00\x00\xa0\x00\x00\x00\x00\x00\x00\x00\xd1\x00\x00\x00\xde\x00\x00\x00;\x00\x00\x00\x00\x00\x00\x00\xe9\x00\x00\x00\xe7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00z\x00\x00\x00/\x00\x00\x00V\x00\x00\x00\x8d\x00\x00\x00\xe3\x00\x00\x00!\x00\x00\x00~\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd3\x00\x00\x00\x88\x00\x00\x00l\x00\x00\x00s\x00\x00\x00g\x00\x00\x00\x05\x00\x00\x00\xc6\x00\x00\x00#\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\xb1\x00\x00\x00\x00\x00\x00\x00\xc2\x00\x00\x00\x13\x00\x00\x00S\x00\x00\x00G\x00\x00\x00$\x00\x00\x00\xc1\x00\x00\x00\xb5\x00\x00\x00X\x00\x00\x00m\x00\x00\x00\t\x00\x00\x00x\x00\x00\x00\xb8\x00\x00\x00\xbd\x00\x00\x00k\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<\x00\x00\x00E\x00\x00\x00\xbf\x00\x00\x00\xbc\x00\x00\x00\x00\x00\x00\x00:\x00\x00\x00\x82\x00\x00\x00\x81\x00\x00\x00&\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x00\x00[\x00\x00\x00I\x00\x00\x00e\x00\x00\x00\x04\x00\x00\x00>\x00\x00\x00\b\x00\x00\x00\x94\x00\x00\x00\x8f\x00\x00\x00\xce\x00\x00\x00?\x00\x00\x00Y\x00\x00\x00\xda\x00\x00\x00\x15\x00\x00\x00\x00\x00\x00\x00'\x00\x00\x004\x00\x00\x00\xcc\x00\x00\x00\f\x00\x00\x005\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\xbb\x00\x00\x00\x00\x00\x00\x00\xa9\x00\x00\x00\x9e\x00\x00\x00\x00\x00\x00\x00\xe5\x00\x00\x00\x00\x00\x00\x00O\x00\x00\x00 \x00\x00\x00)\x00\x00\x00\xcf\x00\x00\x00\x00\x00\x00\x00\x1b\x00\x00\x00Z\x00\x00\x00\"\x00\x00\x00\x00\x00\x00\x00v\x00\x00\x00]\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00a\x00\x00\x00j\x00\x00\x008\x00\x00\x00\xa3\x00\x00\x00q\x00\x00\x00t\x00\x00\x00_\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\v\x00\x00\x00@\x00\x00\x00\xd2\x00\x00\x00,\x00\x00\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\xc8\x00\x00\x00\x95\x00\x00\x00\x06\x00\x00\x00\xa8\x00\x00\x00\xae\x00\x00\x00\xa1\x00\x00\x00\x00\x00\x00\x00\x91\x00\x00\x00\x0e\x00\x00\x00{\x00\x00\x00\xa7\x00\x00\x00\x00\x00\x00\x00\xb6\x00\x00\x00i\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd5\x00\x00\x00L\x00\x00\x00\x00\x00\x00\x00\xea\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00w\x00\x00\x00\x12\x00\x00\x00=\x00\x00\x00\xaf\x00\x00\x00\a\x00\x00\x00\xdf\x00\x00\x00\xc0\x00\x00\x00N\x00\x00\x00%\x00\x00\x009\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00.\x00\x00\x00\x00\x00\x00\x00\u007f\x00\x00\x00\xbe\x00\x00\x00\xe2\x00\x00\x00\x00\x00\x00\x00P\x00\x00\x00\xb3\x00\x00\x00\r\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00R\x00\x00\x00D\x00\x00\x00B\x00\x00\x00n\x00\x00\x00\x00\x00\x00\x00\xd6\x00\x00\x00\x83\x00\x00\x00\n\x00\x00\x00W\x00\x00\x00\x14\x00\x00\x00Q\x00\x00\x00\xd4\x00\x00\x00d\x00\x00\x00\xac\x00\x00\x00\x16\x00\x00\x00\x96\x00\x00\x00K\x00\x00\x002\x00\x00\x00\x1a\x00\x00\x00\xb4\x00\x00\x00f\x00\x00\x00\xa2\x00\x00\x00\xe8\x00\x00\x00\x02\x00\x00\x00A\x00\x00\x00\xe4\x00\x00\x00\x8c\x00\x00\x00\x9a\x00\x00\x00`\x00\x00\x00\xab\x00\x00\x00M\x00\x00\x007\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\xdc\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x00\x00\x89\x00\x00\x00\x00\x00\x00\x00\xdd\x00\x00\x00\x8e\x00\x00\x00\xca\x00\x00\x00H\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x00\x00\x00\x00\x00\x00\x1c\x00\x00\x00\xb0\x00\x00\x00\x00\x00\x00\x00|\x00\x00\x003\x00\x00\x00T\x00\x00\x00\x87\x00\x00\x00b\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\xaa\x00\x00\x00\xa4\x00\x00\x00\x00\x00\x00\x00p\x00\x00\x00\xc7\x00\x00\x00\x8b\x00\x00\x00\x00\n\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the cluster-admin ClusterRole\n\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin ClusterRole\n\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a new configmap named my-config based on folder bar\n\t\t  kubectl create configmap my-config --from-file=path/to/bar\n\n\t\t  # Create a new configmap named my-config with specified keys instead of file basenames on disk\n\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1.txt --from-file=key2=/path/to/bar/file2.txt\n\n\t\t  # Create a new configmap named my-config with key1=config1 and key2=config2\n\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-literal=key2=config2\x00\n\t\t  # If you don't already have a .dockercfg file, you can create a dockercfg secret directly by using:\n\t\t  kubectl create secret docker-registry my-secret --docker-server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL\x00\n\t\t  # Show metrics for all nodes\n\t\t  kubectl top node\n\n\t\t  # Show metrics for a given node\n\t\t  kubectl top node NODE_NAME\x00\n\t\t# Apply the configuration in pod.json to a pod.\n\t\tkubectl apply -f ./pod.json\n\n\t\t# Apply the JSON passed into stdin to a pod.\n\t\tcat pod.json | kubectl apply -f -\n\n\t\t# Note: --prune is still in Alpha\n\t\t# Apply the configuration in manifest.yaml that matches label app=nginx and delete all the other resources that are not in the file and match label app=nginx.\n\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n\n\t\t# Apply the configuration in manifest.yaml and delete all the other configmaps that are not in the file.\n\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/ConfigMap\x00\n\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and 10, no target CPU utilization specified so a default autoscaling policy will be used:\n\t\tkubectl autoscale deployment foo --min=2 --max=10\n\n\t\t# Auto scale a replication controller \"foo\", with the number of pods between 1 and 5, target CPU utilization at 80%:\n\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80\x00\n\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n\t\tkubectl convert -f pod.yaml\n\n\t\t# Convert the live state of the resource specified by 'pod.yaml' to the latest version\n\t\t# and print to stdout in json format.\n\t\tkubectl convert -f pod.yaml --local -o json\n\n\t\t# Convert all files under current directory to latest version and create them all.\n\t\tkubectl convert -f . | kubectl create -f -\x00\n\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods\n\n\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --resource=pods\n\n\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a new resourcequota named my-quota\n\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,replicationcontrollers=2,resourcequotas=1,secrets=5,persistentvolumeclaims=10\n\n\t\t# Create a new resourcequota named best-effort\n\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort\x00\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=rails label\n\t\t# and require at least one of them being available at any point in time.\n\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-available=1\n\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=nginx label\n\t\t# and require at least half of the pods selected to be available at any point in time.\n\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%\x00\n\t\t# Create a pod using the data in pod.json.\n\t\tkubectl create -f ./pod.json\n\n\t\t# Create a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl create -f -\n\n\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format then create the resource using the edited data.\n\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json\x00\n\t\t# Create a service for a replicated nginx, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rc nginx --port=80 --target-port=8000\n\n\t\t# Create a service for a replication controller identified by type and name specified in \"nginx-controller.yaml\", which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n\n\t\t# Create a service for a pod valid-pod, which serves on port 444 with the name \"frontend\"\n\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n\n\t\t# Create a second service based on the above service, exposing the container port 8443 as port 443 with the name \"nginx-https\"\n\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-https\n\n\t\t# Create a service for a replicated streaming application on port 4100 balancing UDP traffic and named 'video-stream'.\n\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-stream\n\n\t\t# Create a service for a replicated nginx using replica set, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rs nginx --port=80 --target-port=8000\n\n\t\t# Create a service for an nginx deployment, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose deployment nginx --port=80 --target-port=8000\x00\n\t\t# Delete a pod using the type and name specified in pod.json.\n\t\tkubectl delete -f ./pod.json\n\n\t\t# Delete a pod based on the type and name in the JSON passed into stdin.\n\t\tcat pod.json | kubectl delete -f -\n\n\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n\t\tkubectl delete pod,service baz foo\n\n\t\t# Delete pods and services with label name=myLabel.\n\t\tkubectl delete pods,services -l name=myLabel\n\n\t\t# Delete a pod with minimal delay\n\t\tkubectl delete pod foo --now\n\n\t\t# Force delete a pod on a dead node\n\t\tkubectl delete pod foo --grace-period=0 --force\n\n\t\t# Delete all pods\n\t\tkubectl delete pods --all\x00\n\t\t# Describe a node\n\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n\n\t\t# Describe a pod\n\t\tkubectl describe pods/nginx\n\n\t\t# Describe a pod identified by type and name in \"pod.json\"\n\t\tkubectl describe -f pod.json\n\n\t\t# Describe all pods\n\t\tkubectl describe pods\n\n\t\t# Describe pods by label name=myLabel\n\t\tkubectl describe po -l name=myLabel\n\n\t\t# Describe all pods managed by the 'frontend' replication controller (rc-created pods\n\t\t# get the name of the rc as a prefix in the pod the name).\n\t\tkubectl describe pods frontend\x00\n\t\t# Drain node \"foo\", even if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n\t\t$ kubectl drain foo --force\n\n\t\t# As above, but abort if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a grace period of 15 minutes.\n\t\t$ kubectl drain foo --grace-period=900\x00\n\t\t# Edit the service named 'docker-registry':\n\t\tkubectl edit svc/docker-registry\n\n\t\t# Use an alternative editor\n\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n\n\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n\t\tkubectl edit job.v1.batch/myjob -o json\n\n\t\t# Edit the deployment 'mydeployment' in YAML and save the modified config in its annotation:\n\t\tkubectl edit deployment/mydeployment -o yaml --save-config\x00\n\t\t# Get output from running 'date' from pod 123456-7890, using the first container by default\n\t\tkubectl exec 123456-7890 date\n\n\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n\t\tkubectl exec 123456-7890 -c ruby-container date\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il\x00\n\t\t# Get output from running pod 123456-7890, using the first container by default\n\t\tkubectl attach 123456-7890\n\n\t\t# Get output from ruby-container from pod 123456-7890\n\t\tkubectl attach 123456-7890 -c ruby-container\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n\n\t\t# Get output from the first pod of a ReplicaSet named nginx\n\t\tkubectl attach rs/nginx\n\t\t\x00\n\t\t# Get the documentation of the resource and its fields\n\t\tkubectl explain pods\n\n\t\t# Get the documentation of a specific field of a resource\n\t\tkubectl explain pods.spec.containers\x00\n\t\t# Install bash completion on a Mac using homebrew\n\t\tbrew install bash-completion\n\t\tprintf \"\n# Bash completion support\nsource $(brew --prefix)/etc/bash_completion\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for bash into the current shell\n\t\tsource <(kubectl completion bash)\n\n\t\t# Write bash completion code to a file and source if from .bash_profile\n\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n\t\tprintf \"\n# Kubectl shell completion\nsource '$HOME/.kube/completion.bash.inc'\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for zsh[1] into the current shell\n\t\tsource <(kubectl completion zsh)\x00\n\t\t# List all pods in ps output format.\n\t\tkubectl get pods\n\n\t\t# List all pods in ps output format with more information (such as node name).\n\t\tkubectl get pods -o wide\n\n\t\t# List a single replication controller with specified NAME in ps output format.\n\t\tkubectl get replicationcontroller web\n\n\t\t# List a single pod in JSON output format.\n\t\tkubectl get -o json pod web-pod-13je7\n\n\t\t# List a pod identified by type and name specified in \"pod.yaml\" in JSON output format.\n\t\tkubectl get -f pod.yaml -o json\n\n\t\t# Return only the phase value of the specified pod.\n\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n\n\t\t# List all replication controllers and services together in ps output format.\n\t\tkubectl get rc,services\n\n\t\t# List one or more resources by their type and names.\n\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n\n\t\t# List all resources with different types.\n\t\tkubectl get all\x00\n\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports 5000 and 6000 in the pod\n\t\tkubectl port-forward mypod 5000 6000\n\n\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 8888:5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod :5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 0:5000\x00\n\t\t# Mark node \"foo\" as schedulable.\n\t\t$ kubectl uncordon foo\x00\n\t\t# Mark node \"foo\" as unschedulable.\n\t\tkubectl cordon foo\x00\n\t\t# Partially update a node using strategic merge patch\n\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Partially update a node identified by the type and name specified in \"node.json\" using strategic merge patch\n\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Update a container's image; spec.containers[*].name is required because it's a merge key\n\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n\n\t\t# Update a container's image using a json patch with positional arrays\n\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", \"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'\x00\n\t\t# Print flags inherited by all commands\n\t\tkubectl options\x00\n\t\t# Print the address of the master and cluster services\n\t\tkubectl cluster-info\x00\n\t\t# Print the client and server versions for the current context\n\t\tkubectl version\x00\n\t\t# Print the supported API versions\n\t\tkubectl api-versions\x00\n\t\t# Replace a pod using the data in pod.json.\n\t\tkubectl replace -f ./pod.json\n\n\t\t# Replace a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl replace -f -\n\n\t\t# Update a single-container pod's image version (tag) to v4\n\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/\x01:v4/' | kubectl replace -f -\n\n\t\t# Force replace, delete and then re-create the resource\n\t\tkubectl replace --force -f ./pod.json\x00\n\t\t# Return snapshot logs from pod nginx with only one container\n\t\tkubectl logs nginx\n\n\t\t# Return snapshot logs for the pods defined by label app=nginx\n\t\tkubectl logs -lapp=nginx\n\n\t\t# Return snapshot of previous terminated ruby container logs from pod web-1\n\t\tkubectl logs -p -c ruby web-1\n\n\t\t# Begin streaming the logs of the ruby container in pod web-1\n\t\tkubectl logs -f -c ruby web-1\n\n\t\t# Display only the most recent 20 lines of output in pod nginx\n\t\tkubectl logs --tail=20 nginx\n\n\t\t# Show all logs from pod nginx written in the last hour\n\t\tkubectl logs --since=1h nginx\n\n\t\t# Return snapshot logs from first container of a job named hello\n\t\tkubectl logs job/hello\n\n\t\t# Return snapshot logs from container nginx-1 of a deployment named nginx\n\t\tkubectl logs deployment/nginx -c nginx-1\x00\n\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static content from ./local/www/\n\t\tkubectl proxy --port=8011 --www=./local/www/\n\n\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n\t\t# The chosen port for the server will be output to stdout.\n\t\tkubectl proxy --port=0\n\n\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-api\n\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/pods/\n\t\tkubectl proxy --api-prefix=/k8s-api\x00\n\t\t# Scale a replicaset named 'foo' to 3.\n\t\tkubectl scale --replicas=3 rs/foo\n\n\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" to 3.\n\t\tkubectl scale --replicas=3 -f foo.yaml\n\n\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n\n\t\t# Scale multiple replication controllers.\n\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n\n\t\t# Scale job named 'cron' to 3.\n\t\tkubectl scale --replicas=3 job/cron\x00\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file.\n\t\tkubectl apply set-last-applied -f deploy.yaml\n\n\t\t# Execute set-last-applied against each configuration file in a directory.\n\t\tkubectl apply set-last-applied -f path/\n\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file, will create the annotation if it does not already exist.\n\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n\t\t\x00\n\t\t# Show metrics for all pods in the default namespace\n\t\tkubectl top pod\n\n\t\t# Show metrics for all pods in the given namespace\n\t\tkubectl top pod --namespace=NAMESPACE\n\n\t\t# Show metrics for a given pod and its containers\n\t\tkubectl top pod POD_NAME --containers\n\n\t\t# Show metrics for the pods defined by label name=myLabel\n\t\tkubectl top pod -l name=myLabel\x00\n\t\t# Shut down foo.\n\t\tkubectl stop replicationcontroller foo\n\n\t\t# Stop pods and services with label name=myLabel.\n\t\tkubectl stop pods,services -l name=myLabel\n\n\t\t# Shut down the service defined in service.json\n\t\tkubectl stop -f service.json\n\n\t\t# Shut down all resources in the path/to/resources directory\n\t\tkubectl stop -f path/to/resources\x00\n\t\t# Start a single instance of nginx.\n\t\tkubectl run nginx --image=nginx\n\n\t\t# Start a single instance of hazelcast and let the container expose port 5701 .\n\t\tkubectl run hazelcast --image=hazelcast --port=5701\n\n\t\t# Start a single instance of hazelcast and set environment variables \"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --env=\"POD_NAMESPACE=default\"\n\n\t\t# Start a replicated instance of nginx.\n\t\tkubectl run nginx --image=nginx --replicas=5\n\n\t\t# Dry run. Print the corresponding API objects without creating them.\n\t\tkubectl run nginx --image=nginx --dry-run\n\n\t\t# Start a single instance of nginx, but overload the spec of the deployment with a partial set of values parsed from JSON.\n\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", \"spec\": { ... } }'\n\n\t\t# Start a pod of busybox and keep it in the foreground, don't restart it if it exits.\n\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n\n\t\t# Start the nginx container using the default command, but use custom arguments (arg1 .. argN) for that command.\n\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n\n\t\t# Start the nginx container using a different command and custom arguments.\n\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n\n\t\t# Start the perl container to compute \u03c0 to 2000 places and print it out.\n\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\n\n\t\t# Start the cron job to compute \u03c0 to 2000 places and print it out every 5 minutes.\n\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\x00\n\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-user' and effect 'NoSchedule'.\n\t\t# If a taint with that key and effect already exists, its value is replaced as specified.\n\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n\n\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect 'NoSchedule' if one exists.\n\t\tkubectl taint nodes foo dedicated:NoSchedule-\n\n\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n\t\tkubectl taint nodes foo dedicated-\x00\n\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n\t\tkubectl label pods foo unhealthy=true\n\n\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', overwriting any existing value.\n\t\tkubectl label --overwrite pods foo status=unhealthy\n\n\t\t# Update all pods in the namespace\n\t\tkubectl label pods --all status=unhealthy\n\n\t\t# Update a pod identified by the type and name in \"pod.json\"\n\t\tkubectl label -f pod.json status=unhealthy\n\n\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n\t\tkubectl label pods foo status=unhealthy --resource-version=1\n\n\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n\t\t# Does not require the --overwrite flag.\n\t\tkubectl label pods foo bar-\x00\n\t\t# Update pods of frontend-v1 using new replication controller data in frontend-v2.json.\n\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n\n\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n\n\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the image, and switching the\n\t\t# name of the replication controller.\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n\n\t\t# Update the pods of frontend by just changing the image, and keeping the old name.\n\t\tkubectl rolling-update frontend --image=image:v2\n\n\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to frontend-v2).\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback\x00\n\t\t# View the last-applied-configuration annotations by type/name in YAML.\n\t\tkubectl apply view-last-applied deployment/nginx\n\n\t\t# View the last-applied-configuration annotations by file in JSON\n\t\tkubectl apply view-last-applied -f deploy.yaml -o json\x00\n\t\tApply a configuration to a resource by filename or stdin.\n\t\tThis resource will be created if it doesn't exist yet.\n\t\tTo use 'apply', always create the resource initially with either 'apply' or 'create --save-config'.\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not use unless you are aware of what the current state is. See https://issues.k8s.io/34274.\x00\n\t\tConvert config files between different API versions. Both YAML\n\t\tand JSON formats are accepted.\n\n\t\tThe command takes filename, directory, or URL as input, and convert it into format\n\t\tof version specified by --output-version flag. If target version is not specified or\n\t\tnot supported, convert to latest version.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change to output destination.\x00\n\t\tCreate a ClusterRole.\x00\n\t\tCreate a ClusterRoleBinding for a particular ClusterRole.\x00\n\t\tCreate a RoleBinding for a particular Role or ClusterRole.\x00\n\t\tCreate a TLS secret from the given public/private key pair.\n\n\t\tThe public/private key pair must exist before hand. The public key certificate must be .PEM encoded and match the given private key.\x00\n\t\tCreate a configmap based on a file, directory, or specified literal value.\n\n\t\tA single configmap may package one or more key/value pairs.\n\n\t\tWhen creating a configmap based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a configmap based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the configmap.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a namespace with the specified name.\x00\n\t\tCreate a new secret for use with Docker registries.\n\n\t\tDockercfg secrets are used to authenticate against Docker registries.\n\n\t\tWhen using the Docker command line to push images, you can authenticate to a given registry by running\n\n\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n\n    That produces a ~/.dockercfg file that is used by subsequent 'docker push' and 'docker pull' commands to\n\t\tauthenticate to the registry. The email address is optional.\n\n\t\tWhen creating applications, you may have a Docker registry that requires authentication.  In order for the\n\t\tnodes to pull images on your behalf, they have to have the credentials.  You can provide this information\n\t\tby creating a dockercfg secret and attaching it to your service account.\x00\n\t\tCreate a pod disruption budget with the specified name, selector, and desired minimum available pods\x00\n\t\tCreate a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted.\x00\n\t\tCreate a resourcequota with the specified name, hard limits and optional scopes\x00\n\t\tCreate a role with single rule.\x00\n\t\tCreate a secret based on a file, directory, or specified literal value.\n\n\t\tA single secret may package one or more key/value pairs.\n\n\t\tWhen creating a secret based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a secret based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the secret.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a service account with the specified name.\x00\n\t\tCreate and run a particular image, possibly replicated.\n\n\t\tCreates a deployment or job to manage the created container(s).\x00\n\t\tCreates an autoscaler that automatically chooses and sets the number of pods that run in a kubernetes cluster.\n\n\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and creates an autoscaler that uses the given resource as a reference.\n\t\tAn autoscaler can automatically increase or decrease number of pods deployed within the system as needed.\x00\n\t\tDelete resources by filenames, stdin, resources and names, or by resources and label selector.\n\n\t\tJSON and YAML formats are accepted. Only one type of the arguments may be specified: filenames,\n\t\tresources and names, or resources and label selector.\n\n\t\tSome resources, such as pods, support graceful deletion. These resources define a default period\n\t\tbefore they are forcibly terminated (the grace period) but you may override that value with\n\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. Because these resources often\n\t\trepresent entities in the cluster, deletion may not be acknowledged immediately. If the node\n\t\thosting a pod is down or cannot reach the API server, termination may take significantly longer\n\t\tthan the grace period. To force delete a resource,\tyou must pass a grace\tperiod of 0 and specify\n\t\tthe --force flag.\n\n\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the pod's processes have been\n\t\tterminated, which can leave those processes running until the node detects the deletion and\n\t\tcompletes graceful deletion. If your processes use shared storage or talk to a remote API and\n\t\tdepend on the name of the pod to identify themselves, force deleting those pods may result in\n\t\tmultiple processes running on different machines using the same identification which may lead\n\t\tto data corruption or inconsistency. Only force delete pods when you are sure the pod is\n\t\tterminated, or if your application can tolerate multiple copies of the same pod running at once.\n\t\tAlso, if you force delete pods the scheduler may place new pods on those nodes before the node\n\t\thas released those resources and causing those pods to be evicted immediately.\n\n\t\tNote that the delete command does NOT do resource version checks, so if someone\n\t\tsubmits an update to a resource right when you submit a delete, their update\n\t\twill be lost along with the rest of the resource.\x00\n\t\tDeprecated: Gracefully shut down a resource by name or filename.\n\n\t\tThe stop command is deprecated, all its functionalities are covered by delete command.\n\t\tSee 'kubectl delete --help' for more details.\n\n\t\tAttempts to shut down and delete a resource that supports graceful termination.\n\t\tIf the resource is scalable it will be scaled to 0 before deletion.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n\n\t\tThe top-node command allows you to see the resource consumption of nodes.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n\n\t\tThe 'top pod' command allows you to see the resource consumption of pods.\n\n\t\tDue to the metrics pipeline delay, they may be unavailable for a few minutes\n\t\tsince pod creation.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage.\n\n\t\tThe top command allows you to see the resource consumption for nodes or pods.\n\n\t\tThis command requires Heapster to be correctly configured and working on the server. \x00\n\t\tDrain node in preparation for maintenance.\n\n\t\tThe given node will be marked unschedulable to prevent new pods from arriving.\n\t\t'drain' evicts the pods if the APIServer supports eviction\n\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use normal DELETE\n\t\tto delete the pods.\n\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot be deleted through\n\t\tthe API server).  If there are DaemonSet-managed pods, drain will not proceed\n\t\twithout --ignore-daemonsets, and regardless it will not delete any\n\t\tDaemonSet-managed pods, because those pods would be immediately replaced by the\n\t\tDaemonSet controller, which ignores unschedulable markings.  If there are any\n\t\tpods that are neither mirror pods nor managed by ReplicationController,\n\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete any pods unless you\n\t\tuse --force.  --force will also allow deletion to proceed if the managing resource of one\n\t\tor more pods is missing.\n\n\t\t'drain' waits for graceful termination. You should not operate on the machine until\n\t\tthe command completes.\n\n\t\tWhen you are ready to put the node back into service, use kubectl uncordon, which\n\t\twill make the node schedulable again.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)\x00\n\t\tEdit a resource from the default editor.\n\n\t\tThe edit command allows you to directly edit any API resource you can retrieve via the\n\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, or EDITOR\n\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for Windows.\n\t\tYou can edit multiple objects, although changes are applied one at a time. The command\n\t\taccepts filenames as well as command line arguments, although the files you point to must\n\t\tbe previously saved versions of resources.\n\n\t\tEditing is done with the API version used to fetch the resource.\n\t\tTo edit using a specific API version, fully-qualify the resource, version, and group.\n\n\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n\n\t\tThe flag --windows-line-endings can be used to force Windows line endings,\n\t\totherwise the default for your operating system will be used.\n\n\t\tIn the event an error occurs while updating, a temporary file will be created on disk\n\t\tthat contains your unapplied changes. The most common error when updating a resource\n\t\tis another editor changing the resource on the server. When this occurs, you will have\n\t\tto apply your changes to the newer version of the resource, or update your temporary\n\t\tsaved copy to include the latest resource version.\x00\n\t\tMark node as schedulable.\x00\n\t\tMark node as unschedulable.\x00\n\t\tOutput shell completion code for the specified shell (bash or zsh).\n\t\tThe shell code must be evaluated to provide interactive\n\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n\t\tthe .bash_profile.\n\n\t\tNote: this requires the bash-completion framework, which is not installed\n\t\tby default on Mac.  This can be installed by using homebrew:\n\n\t\t    $ brew install bash-completion\n\n\t\tOnce installed, bash_completion must be evaluated.  This can be done by adding the\n\t\tfollowing line to the .bash_profile\n\n\t\t    $ source $(brew --prefix)/etc/bash_completion\n\n\t\tNote for zsh users: [1] zsh completions are only supported in versions of zsh >= 5.2\x00\n\t\tPerform a rolling update of the given ReplicationController.\n\n\t\tReplaces the specified replication controller with a new replication controller by updating one pod at a time to use the\n\t\tnew PodTemplate. The new-controller.json must specify the same namespace as the\n\t\texisting replication controller and overwrite at least one (common) label in its replicaSelector.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)\x00\n\t\tReplace a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted. If replacing an existing resource, the\n\t\tcomplete resource spec must be provided. This can be obtained by\n\n\t\t    $ kubectl get TYPE NAME -o yaml\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or Job.\n\n\t\tScale also allows users to specify one or more preconditions for the scale action.\n\n\t\tIf --current-replicas or --resource-version is specified, it is validated before the\n\t\tscale is attempted, and it is guaranteed that the precondition holds true when the\n\t\tscale is sent to the server.\x00\n\t\tSet the latest last-applied-configuration annotations by setting it to match the contents of a file.\n\t\tThis results in the last-applied-configuration being updated as though 'kubectl apply -f <file>' was run,\n\t\twithout updating any other parts of the object.\x00\n\t\tTo proxy all of the kubernetes api and nothing else, use:\n\n\t\t    $ kubectl proxy --api-prefix=/\n\n\t\tTo proxy only part of the kubernetes api and also some static files:\n\n\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/api/\n\n\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n\n\t\tTo proxy the entire kubernetes api at a different root, use:\n\n\t\t    $ kubectl proxy --api-prefix=/custom/\n\n\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'\x00\n\t\tUpdate field(s) of a resource using strategic merge patch\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tUpdate the labels on a resource.\n\n\t\t* A label must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* If --overwrite is true, then existing labels can be overwritten, otherwise attempting to overwrite a label will result in an error.\n\t\t* If --resource-version is specified, then updates will use this resource version, otherwise the existing resource-version will be used.\x00\n\t\tUpdate the taints on one or more nodes.\n\n\t\t* A taint consists of a key, value, and effect. As an argument here, it is expressed as key=value:effect.\n\t\t* The key must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* The value must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[2]d characters.\n\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n\t\t* Currently taint can only apply to node.\x00\n\t\tView the latest last-applied-configuration annotations by type/name or file.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change output format.\x00\n\t    # !!!Important Note!!!\n\t    # Requires that the 'tar' binary is present in your container\n\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n\n\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in the default namespace\n\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n\n        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific container\n\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n\n\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace <some-namespace>\n\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n\n\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar\x00\n\t  # Create a new TLS secret named tls-secret with the given key pair:\n\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/to/tls.key\x00\n\t  # Create a new namespace named my-namespace\n\t  kubectl create namespace my-namespace\x00\n\t  # Create a new secret named my-secret with keys for each file in folder bar\n\t  kubectl create secret generic my-secret --from-file=path/to/bar\n\n\t  # Create a new secret named my-secret with specified keys instead of names on disk\n\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/.ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n\n\t  # Create a new secret named my-secret with key1=supersecret and key2=topsecret\n\t  kubectl create secret generic my-secret --from-literal=key1=supersecret --from-literal=key2=topsecret\x00\n\t  # Create a new service account named my-service-account\n\t  kubectl create serviceaccount my-service-account\x00\n\t# Create a new ExternalName service named my-ns \n\tkubectl create service externalname my-ns --external-name bar.com\x00\n\tCreate an ExternalName service with the specified name.\n\n\tExternalName service references to an external DNS address instead of\n\tonly pods, which will allow application authors to reference services\n\tthat exist off platform, on other clusters, or locally.\x00\n\tHelp provides help for any command in the application.\n\tSimply type kubectl help [path to command] for full details.\x00\n    # Create a new LoadBalancer service named my-lbs\n    kubectl create service loadbalancer my-lbs --tcp=5678:8080\x00\n    # Create a new clusterIP service named my-cs\n    kubectl create service clusterip my-cs --tcp=5678:8080\n\n    # Create a new clusterIP service named my-cs (in headless mode)\n    kubectl create service clusterip my-cs --clusterip=\"None\"\x00\n    # Create a new deployment named my-dep that runs the busybox image.\n    kubectl create deployment my-dep --image=busybox\x00\n    # Create a new nodeport service named my-ns\n    kubectl create service nodeport my-ns --tcp=5678:8080\x00\n    # Dump current cluster state to stdout\n    kubectl cluster-info dump\n\n    # Dump current cluster state to /path/to/cluster-state\n    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n\n    # Dump all namespaces to stdout\n    kubectl cluster-info dump --all-namespaces\n\n    # Dump a set of namespaces to /path/to/cluster-state\n    kubectl cluster-info dump --namespaces default,kube-system --output-directory=/path/to/cluster-state\x00\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend'.\n    # If the same annotation is set multiple times, only the last value will be applied\n    kubectl annotate pods foo description='my frontend'\n\n    # Update a pod identified by type and name in \"pod.json\"\n    kubectl annotate -f pod.json description='my frontend'\n\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend running nginx', overwriting any existing value.\n    kubectl annotate --overwrite pods foo description='my frontend running nginx'\n\n    # Update all pods in the namespace\n    kubectl annotate pods --all description='my frontend running nginx'\n\n    # Update pod 'foo' only if the resource is unchanged from version 1.\n    kubectl annotate pods foo description='my frontend running nginx' --resource-version=1\n\n    # Update pod 'foo' by removing an annotation named 'description' if it exists.\n    # Does not require the --overwrite flag.\n    kubectl annotate pods foo description-\x00\n    Create a LoadBalancer service with the specified name.\x00\n    Create a clusterIP service with the specified name.\x00\n    Create a deployment with the specified name.\x00\n    Create a nodeport service with the specified name.\x00\n    Dumps cluster info out suitable for debugging and diagnosing cluster problems.  By default, dumps everything to\n    stdout. You can optionally specify a directory with --output-directory.  If you specify a directory, kubernetes will\n    build a set of files in that directory.  By default only dumps things in the 'kube-system' namespace, but you can\n    switch to a different namespace with the --namespaces flag, or specify --all-namespaces to dump all namespaces.\n\n    The command also dumps the logs of all of the pods in the cluster, these logs are dumped into different directories\n    based on namespace and pod name.\x00\n  Display addresses of the master and services with label kubernetes.io/cluster-service=true\n  To further debug and diagnose cluster problems, use 'kubectl cluster-info dump'.\x00A comma-delimited set of quota scopes that must all match each object tracked by the quota.\x00A comma-delimited set of resource=quantity pairs that define a hard limit.\x00A label selector to use for this budget. Only equality-based selector requirements are supported.\x00A label selector to use for this service. Only equality-based selector requirements are supported. If empty (the default) infer the selector from the replication controller or replica set.)\x00A schedule in the Cron format the job should be run with.\x00Additional external IP address (not managed by Kubernetes) to accept for the service. If this IP is routed to a node, the service can be accessed by this IP in addition to its generated service IP.\x00An inline JSON override for the generated object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.\x00An inline JSON override for the generated service object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.  Only used if --expose is true.\x00Apply a configuration to a resource by filename or stdin\x00Approve a certificate signing request\x00Assign your own ClusterIP or set to 'None' for a 'headless' service (no loadbalancing).\x00Attach to a running container\x00Auto-scale a Deployment, ReplicaSet, or ReplicationController\x00ClusterIP to be assigned to the service. Leave empty to auto-allocate, or set to 'None' to create a headless service.\x00ClusterRole this ClusterRoleBinding should reference\x00ClusterRole this RoleBinding should reference\x00Container name which will have its image upgraded. Only relevant when --image is specified, ignored otherwise. Required when using --image on a multi-container pod\x00Convert config files between different API versions\x00Copy files and directories to and from containers.\x00Create a ClusterRoleBinding for a particular ClusterRole\x00Create a LoadBalancer service.\x00Create a NodePort service.\x00Create a RoleBinding for a particular Role or ClusterRole\x00Create a TLS secret\x00Create a clusterIP service.\x00Create a configmap from a local file, directory or literal value\x00Create a deployment with the specified name.\x00Create a namespace with the specified name\x00Create a pod disruption budget with the specified name.\x00Create a quota with the specified name.\x00Create a resource by filename or stdin\x00Create a secret for use with a Docker registry\x00Create a secret from a local file, directory or literal value\x00Create a secret using specified subcommand\x00Create a service account with the specified name\x00Create a service using specified subcommand.\x00Create an ExternalName service.\x00Delete resources by filenames, stdin, resources and names, or by resources and label selector\x00Delete the specified cluster from the kubeconfig\x00Delete the specified context from the kubeconfig\x00Deny a certificate signing request\x00Deprecated: Gracefully shut down a resource by name or filename\x00Describe one or many contexts\x00Display Resource (CPU/Memory) usage of nodes\x00Display Resource (CPU/Memory) usage of pods\x00Display Resource (CPU/Memory) usage.\x00Display cluster info\x00Display clusters defined in the kubeconfig\x00Display merged kubeconfig settings or a specified kubeconfig file\x00Display one or many resources\x00Displays the current-context\x00Documentation of resources\x00Drain node in preparation for maintenance\x00Dump lots of relevant info for debugging and diagnosis\x00Edit a resource on the server\x00Email for Docker registry\x00Execute a command in a container\x00Explicit policy for when to pull container images. Required when --image is same as existing image, ignored otherwise.\x00Forward one or more local ports to a pod\x00Help about any command\x00IP to assign to the Load Balancer. If empty, an ephemeral IP will be created and used (cloud-provider specific).\x00If non-empty, set the session affinity for the service to this; legal values: 'None', 'ClientIP'\x00If non-empty, the annotation update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00If non-empty, the labels update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00Image to use for upgrading the replication controller. Must be distinct from the existing image (either new image or new image tag).  Can not be used with --filename/-f\x00Manage a deployment rollout\x00Mark node as schedulable\x00Mark node as unschedulable\x00Mark the provided resource as paused\x00Modify certificate resources.\x00Modify kubeconfig files\x00Name or number for the port on the container that the service should direct traffic to. Optional.\x00Only return logs after a specific date (RFC3339). Defaults to all logs. Only one of since-time / since may be used.\x00Output shell completion code for the specified shell (bash or zsh)\x00Output the formatted object with the given group version (for ex: 'extensions/v1beta1').)\x00Password for Docker registry authentication\x00Path to PEM encoded public key certificate.\x00Path to private key associated with given certificate.\x00Perform a rolling update of the given ReplicationController\x00Precondition for resource version. Requires that the current resource version match this value in order to scale.\x00Print the client and server version information\x00Print the list of flags inherited by all commands\x00Print the logs for a container in a pod\x00Replace a resource by filename or stdin\x00Resume a paused resource\x00Role this RoleBinding should reference\x00Run a particular image on the cluster\x00Run a proxy to the Kubernetes API server\x00Server location for Docker registry\x00Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job\x00Set specific features on objects\x00Set the last-applied-configuration annotation on a live object to match the contents of a file.\x00Set the selector on a resource\x00Sets a cluster entry in kubeconfig\x00Sets a context entry in kubeconfig\x00Sets a user entry in kubeconfig\x00Sets an individual value in a kubeconfig file\x00Sets the current-context in a kubeconfig file\x00Show details of a specific resource or group of resources\x00Show the status of the rollout\x00Synonym for --target-port\x00Take a replication controller, service, deployment or pod and expose it as a new Kubernetes Service\x00The image for the container to run.\x00The image pull policy for the container. If left empty, this value will not be specified by the client and defaulted by the server\x00The key to use to differentiate between two different controllers, default 'deployment'.  Only relevant when --image is specified, ignored otherwise\x00The minimum number or percentage of available pods this budget requires.\x00The name for the newly created object.\x00The name for the newly created object. If not specified, the name of the input resource will be used.\x00The name of the API generator to use, see http://kubernetes.io/docs/user-guide/kubectl-conventions/#generators for a list.\x00The name of the API generator to use. Currently there is only 1 generator.\x00The name of the API generator to use. There are 2 generators: 'service/v1' and 'service/v2'. The only difference between them is that service port in v1 is named 'default', while it is left unnamed in v2. Default is 'service/v2'.\x00The name of the generator to use for creating a service.  Only used if --expose is true\x00The network protocol for the service to be created. Default is 'TCP'.\x00The port that the service should serve on. Copied from the resource being exposed, if unspecified\x00The port that this container exposes.  If --expose is true, this is also the port used by the service that is created.\x00The resource requirement limits for this container.  For example, 'cpu=200m,memory=512Mi'.  Note that server side components may assign limits depending on the server configuration, such as limit ranges.\x00The resource requirement requests for this container.  For example, 'cpu=100m,memory=256Mi'.  Note that server side components may assign requests depending on the server configuration, such as limit ranges.\x00The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  If set to 'Always' a deployment is created, if set to 'OnFailure' a job is created, if set to 'Never', a regular pod is created. For the latter two --replicas must be 1.  Default 'Always', for CronJobs `Never`.\x00The type of secret to create\x00Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is 'ClusterIP'.\x00Undo a previous rollout\x00Unsets an individual value in a kubeconfig file\x00Update field(s) of a resource using strategic merge patch\x00Update image of a pod template\x00Update resource requests/limits on objects with pod templates\x00Update the annotations on a resource\x00Update the labels on a resource\x00Update the taints on one or more nodes\x00Username for Docker registry authentication\x00View latest last-applied-configuration annotations of a resource/object\x00View rollout history\x00Where to output the files.  If empty or '-' uses stdout, otherwise creates a directory hierarchy in that directory\x00dummy restart flag)\x00external name of service\x00kubectl controls the Kubernetes cluster manager\x00Project-Id-Version: kubernetes\nReport-Msgid-Bugs-To: EMAIL\nPOT-Creation-Date: 2017-03-14 21:32-0700\nPO-Revision-Date: 2017-08-28 15:20+0200\nLanguage: it_IT\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 8bit\nPlural-Forms: nplurals=2; plural=(n != 1);\nLast-Translator: Luca Berton <mr.evolution85@gmail.com>\nLanguage-Team: Luca Berton <mr.evolution85@gmail.com>\nX-Generator: Poedit 1.8.7.1\nX-Poedit-SourceCharset: UTF-8\n\x00\n\t\t # Creare un ClusterRoleBinding per user1, user2 e group1 utilizzando il cluster-admin ClusterRole\n\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Crea un RoleBinding per user1, user2, and group1 utilizzando l'admin ClusterRole\n\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Crea un nuovo configmap denominato my-config in base alla cartella bar\n\t\t  kubectl create configmap my-config --from-file=path/to/bar\n\n\t\t  # Crea un nuovo configmap denominato my-config con le chiavi specificate anzich\u00e9 i nomi dei file su disco\n\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1.txt --from-file=key2=/path/to/bar/file2.txt\n\n\t\t  # Crea un nuovo configmap denominato my-config con key1 = config1 e key2 = config2\n\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-literal=key2=config2\x00\n\t\t  # Se non si dispone ancora di un file .dockercfg, \u00e8 possibile creare un secret dockercfg direttamente utilizzando:\n\t\t  kubectl create secret docker-registry my-secret --docker-server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL\x00\n\t\t  # Mostra metriche per tutti i nodi\n\t\t kubectl top node\n\n\t\t # Mostra metriche per un determinato nodo\n\t\t kubectl top node NODE_NAME\x00\n\t\t# Applica la configurazione pod.json a un pod.\n\t\tkubectl apply -f ./pod.json\n\n\t\t# Applicare il JSON passato in stdin a un pod.\n\t\tcat pod.json | kubectl apply -f -\n\n\t\t# Nota: --prune \u00e8 ancora in in Alpha\n\t\t# Applica la configurazione manifest.yaml che corrisponde alla label app = nginx ed elimina tutte le altre risorse che non sono nel file e nella label corrispondente app = nginx.\n\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n\n\t\t# Applica la configurazione manifest.yaml ed elimina tutti gli altri configmaps non presenti nel file.\n\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/ConfigMap\x00\n\t\t#  Auto scale un deployment \"foo\", con il numero di pod compresi tra 2 e 10, utilizzo della CPU target specificato in modo da utilizzare una politica di autoscaling predefinita:\n\t\tkubectl autoscale deployment foo --min=2 --max=10\n\n\t\t# Auto scale un controller di replica \"foo\", con il numero di pod compresi tra 1 e 5, utilizzo dell'utilizzo della CPU a 80%:\n\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80\x00\n\t\t# Converte 'pod.yaml' alla versione pi\u00f9 recente e stampa in stdout.\n\t\tkubectl convert -f pod.yaml\n\n\t\t# Converte lo stato live della risorsa specificata da 'pod.yaml' nella versione pi\u00f9 recente.\n\t\t# e stampa in stdout nel formato json.\n\t\tkubectl convert -f pod.yaml --local -o json\n\n\t\t# Converte tutti i file nella directory corrente alla versione pi\u00f9 recente e li crea tutti.\n\t\tkubectl convert -f . | kubectl create -f -\x00\n\t\t# Crea un ClusterRole denominato \"pod-reader\" che consente all'utente di eseguire \"get\", \"watch\" e \"list\" sui pod\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods\n\n\t\t# Crea un ClusterRole denominato \"pod-reader\" con ResourceName specificato\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods --resource-name=readablepod\x00\n\t\t# Crea un ruolo denominato \"pod-reader\" che consente all'utente di eseguire \"get\", \"watch\" e \"list\" sui pod\n\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --resource=pods\n\n\t\t# Crea un ruolo denominato \"pod-reader\" con ResourceName specificato\n\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --resource=pods --resource-name=readablepod\x00\n\t\t# Crea una nuova resourcequota chiamata my-quota\n\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,replicationcontrollers=2,resourcequotas=1,secrets=5,persistentvolumeclaims=10\n\n\t\t# Creare una nuova resourcequota denominata best-effort\n\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort\x00\n\t\t# Crea un pod disruption budget chiamato my-pdb che seleziona tutti i pod con label app = rail\n\t\t# e richiede che almeno uno di essi sia disponibile in qualsiasi momento.\n\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-available=1\n\n\t\t# Crea un pod disruption budget con nome my-pdb che seleziona tutti i pod con label app = nginx \n\t\t# e richiede che almeno la met\u00e0 dei pod selezionati sia disponibile in qualsiasi momento.\n\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%\x00\n\t\t# Crea un pod utilizzando i dati in pod.json.\n\t\tkubectl create -f ./pod.json\n\n\t\t# Crea un pod basato sul JSON passato in stdin.\n\t\tcat pod.json | kubectl create -f -\n\n\t\t# Modifica i dati in docker-registry.yaml in JSON utilizzando il formato API v1 quindi creare la risorsa utilizzando i dati modificati.\n\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json\x00\n\t\t# Crea un servizio per un nginx replicato, che serve nella porta 80 e si collega ai container sulla porta 8000.\n\t\tkubectl expose rc nginx --port=80 --target-port=8000\n\n\t\t# Crea un servizio per un controller di replica identificato per tipo e nome specificato in \"nginx-controller.yaml\", che serve nella porta 80 e si collega ai container sulla porta 8000.\n\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n\n\t\t# Crea un servizio per un pod valid-pod, che serve nella porta 444 con il nome \"frontend\"\n\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n\n\t\t# Crea un secondo servizio basato sul servizio sopra, esponendo la porta container 8443 come porta 443 con il nome \"nginx-https\"\n\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-https\n\n\t\t#  Crea un servizio per un'applicazione di replica in porta 4100 che bilanci il traffico UDP e denominato \"video stream\".\n\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-stream\n\n\t\t# Crea un servizio per un nginx replicato utilizzando l'insieme di replica, che serve nella porta 80 e si collega ai contenitori sulla porta 8000.\n\t\tkubectl expose rs nginx --port=80 --target-port=8000\n\n\t\t# Crea un servizio per una distribuzione di nginx, che serve nella porta 80 e si collega ai contenitori della porta 8000.\n\t\tkubectl expose deployment nginx --port=80 --target-port=8000\x00\n\t\t# Elimina un pod utilizzando il tipo e il nome specificati in pod.json.\n\t\tkubectl delete -f ./pod.json\n\n\t\t# Elimina un pod in base al tipo e al nome del JSON passato in stdin.\n\t\tcat pod.json | kubectl delete -f -\n\n\t\t# Elimina i baccelli ei servizi con gli stessi nomi \"baz\" e \"foo\"\n\t\tkubectl delete pod,service baz foo\n\n\t\t# Elimina i baccelli ei servizi con il nome dell'etichetta = myLabel.\n\t\tkubectl delete pods,services -l name=myLabel\n\n\t\t# Eliminare un pod con un ritardo minimo\n\t\tkubectl delete pod foo --now\n\n\t\t# Forza elimina un pod in un nodo morto\n\t\tkubectl delete pod foo --grace-period=0 --force\n\n\t\t# Elimina tutti i pod\n\t\tkubectl delete pods --all\x00\n\t\t# Descrive un nodo\n\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n\n\t\t# Descrive un pod\n\t\tkubectl describe pods/nginx\n\n\t\t# Descrive un pod identificato da tipo e nome in \"pod.json\"\n\t\tkubectl describe -f pod.json\n\n\t\t# Descrive tutti i pod\n\t\tkubectl describe pods\n\n\t\t# Descrive i pod con label name=myLabel\n\t\tkubectl describe po -l name=myLabel\n\n\t\t# Descrivere tutti i pod gestiti dal controller di replica \"frontend\"  (rc-created pods\n\t\t# ottiene il nome del rc come un prefisso del nome pod).\n\t\tkubectl describe pods frontend\x00\n\t\t# Drain node \"foo\", anche se ci sono i baccelli non gestiti da ReplicationController, ReplicaSet, Job, DaemonSet o StatefulSet su di esso.\n\t\t$ kubectl drain foo --force\n\n\t\t# Come sopra, ma interrompere se ci sono i baccelli non gestiti da ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, e utilizzare un periodo di grazia di 15 minuti.\n\t\t$ kubectl drain foo --grace-period=900\x00\n\t\t# Modifica il servizio denominato 'docker-registry':\n\t\tkubectl edit svc/docker-registry\n\n\t\t# Usa un editor alternativo\n\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n\n\t\t# Modifica il lavoro 'myjob' in JSON utilizzando il formato API v1:\n\t\tkubectl edit job.v1.batch/myjob -o json\n\n\t\t# Modifica la distribuzione 'mydeployment' in YAML e salvare la configurazione modificata nella sua annotazione:\n\t\tkubectl edit deployment/mydeployment -o yaml --save-config\x00\n\t\t# Ottieni l'output dalla 'data' di esecuzione del pod 123456-7890, utilizzando il primo contenitore per impostazione predefinita\n\t\tkubectl exec 123456-7890 date\n\n\t\t# Ottieni l'output dalla data di esecuzione in ruby-container del pod 123456-7890\n\t\tkubectl exec 123456-7890 -c ruby-container date\n\n\t\t# Passare alla modalit\u00e0 raw terminal, invia stdin a 'bash' in ruby-container del pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il\x00\n\t\t# Ottieni l'output dal pod 123456-7890 in esecuzione, utilizzando il primo contenitore per impostazione predefinita\n\t\tkubectl attach 123456-7890\n\n\t\t#  Ottieni l'output dal  ruby-container del pod 123456-7890\n\t\tkubectl attach 123456-7890 -c ruby-container\n\n\t\t# Passa alla modalit\u00e0 raw terminal, invia stdin a 'bash' in ruby-container del pod 123456-7890\n\t\t# e invia stdout/stderr da 'bash' al client\n\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n\n\t\t# Ottieni l'output dal primo pod di una ReplicaSet denominata nginx\n\t\tkubectl attach rs/nginx\n\t\t\x00\n\t\t# Ottieni la documentazione della risorsa e i relativi campi\n\t\tkubectl explain pods\n\n\t\t# Ottieni la documentazione di un campo specifico di una risorsa\n\t\tkubectl explain pods.spec.containers\x00\n\t\t# Installa il completamento di bash su un Mac utilizzando homebrew\n\t\tbrew install bash-completion\n\t\tprintf \"\n# Bash completion support\nsource $(brew --prefix)/etc/bash_completion\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Carica il codice di completamento kubectl per bash nella shell corrente\n\t\tsource <(kubectl completion bash)\n\n\t\t# Scrive il codice di completamento bash in un file e lo carica da .bash_profile\n\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n\t\tprintf \"\n# Kubectl shell completion\nsource '$HOME/.kube/completion.bash.inc'\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Carica il codice di completamento kubectl per zsh [1] nella shell corrente\n\t\tsource <(kubectl completion zsh)\x00\n\t\t# Elenca tutti i pod in formato output ps.\n\t\tkubectl get pods\n\n\t\t# Elenca tutti i pod in formato output ps con maggiori informazioni (ad esempio il nome del nodo).\n\t\tkubectl get pods -o wide\n\n\t\t# Elenca un controller di replica singolo con NAME specificato nel formato di output ps.\n\t\tkubectl get replicationcontroller web\n\n\t\t# Elenca un singolo pod nel formato di uscita JSON.\n\t\tkubectl get -o json pod web-pod-13je7\n\n\t\t# Elenca un pod identificato per tipo e nome specificato in \"pod.yaml\" nel formato di uscita JSON.\n\t\tkubectl get -f pod.yaml -o json\n\n\t\t# Restituisce solo il valore di fase del pod specificato.\n\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n\n\t\t# Elenca tutti i controller e servizi di replica insieme in formato output ps.\n\t\tkubectl get rc,services\n\n\t\t# Elenca una o pi\u00f9 risorse per il tipo e per i nomi.\n\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n\n\t\t# Elenca tutte le risorse con tipi diversi.\n\t\tkubectl get all\x00\n\t\t# Ascolta localmente le porte 5000 e 6000, inoltrando i dati da/verso le porte 5000 e 6000 nel pod\n\t\tkubectl port-forward mypod 5000 6000\n\n\t\t# Ascolta localmente la porta 8888, inoltra a 5000 nel pod\n\t\tkubectl port-forward mypod 8888:5000\n\n\t\t# Ascolta localmente una porta casuale, inoltra a 5000 nel pod\n\t\tkubectl port-forward mypod :5000\n\n\t\t# Ascolta localmente una porta casuale, inoltra a 5000 nel pod\n\t\tkubectl port-forward mypod 0:5000\x00\n\t\t# Segna il nodo \"foo\" come programmabile.\n\t\t$ Kubectl uncordon foo\x00\n\t\t#  Segna il nodo \"foo\" come non programmabile.\n\t\tkubectl cordon foo\x00\n\t\t# Aggiorna parzialmente un nodo utilizzando merge patch strategica\n\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Aggiorna parzialmente un nodo identificato dal tipo e dal nome specificato in \"node.json\" utilizzando  merge patch strategica\n\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Aggiorna l'immagine di un contenitore; spec.containers [*]. name \u00e8 richiesto perch\u00e9 \u00e8 una chiave di fusione\n\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n\n\t\t# Aggiorna l'immagine di un contenitore utilizzando una patch json con array posizionali\n\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", \"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'\x00\n\t\t# Stampa i flag ereditati da tutti i comandi\n\t\tkubectl options\x00\n\t\t# Stampa l'indirizzo dei servizi master e cluster\n\t\tkubectl cluster-info\x00\n\t\t# Stampa le versioni client e server per il current context\n\t\tkubectl version\x00\n\t\t# Stampa le versioni API supportate\n\t\tkubectl api-versions\x00\n\t\t# Sostituire un pod utilizzando i dati in pod.json.\n\t\tkubectl replace -f ./pod.json\n\n\t\t# Sostituire un pod usando il JSON passato da stdin.\n\t\tcat pod.json | kubectl replace -f -\n\n\t\t# Aggiorna la versione dell'immagine (tag) di un singolo container di pod a v4\n\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/\x01:v4/' | kubectl replace -f -\n\n\t\t# Forza la sostituzione, cancellazione e quindi ricreare la risorsa\n\t\tkubectl replace --force -f ./pod.json\x00\n\t\t# Restituisce snapshot log dal pod nginx con un solo container\n\t\tkubectl logs nginx\n\n\t\t# Restituisce snapshot log dei pod definiti dalla label app=nginx\n\t\tkubectl logs -lapp=nginx\n\n\t\t# Restituisce snapshot log del container ruby  terminato nel pod web-1\n\t\tkubectl logs -p -c ruby web-1\n\n\t\t# Iniziare a trasmettere i log del contenitore ruby nel pod web-1\n\t\tkubectl logs -f -c ruby web-1\n\n\t\t# Visualizza solo le ultime 20 righe di output del pod nginx\n\t\tkubectl logs --tail=20 nginx\n\n\t\t# Mostra tutti i log del pod nginx scritti nell'ultima ora\n\t\tkubectl logs --since=1h nginx\n\n\t\t# Restituisce snapshot log dal primo contenitore di un lavoro chiamato hello\n\t\tkubectl logs job/hello\n\n\t\t# Restituisce snapshot logs del container nginx-1 del deployment chiamato nginx\n\t\tkubectl logs deployment/nginx -c nginx-1\x00\n\t\t# Esegui un proxy verso kubernetes apiserver sulla porta 8011, che fornisce contenuti statici da ./local/www/\n\t\tkubectl proxy --port=8011 --www=./local/www/\n\n\t\t# Esegui un proxy verso kubernetes apiserver su una porta locale arbitraria.\n\t\t# La porta selezionata per il server verr\u00e0 inviata a stdout.\n\t\tkubectl proxy --port=0\n\n\t\t# Esegui un proxy verso kubernetes apiserver, cambiando il prefisso api in k8s-api\n\t\t# Questo comporta, ad es., pod api disponibili presso localhost:8001/k8s-api/v1/pods/\n\t\tkubectl proxy --api-prefix=/k8s-api\x00\n\t\t# Scala un replicaset denominato 'foo' a 3.\n\t\tkubectl scale --replicas=3 rs/foo\n\n\t\t# Scala una risorsa identificata per tipo e nome specificato in \"foo.yaml\" a 3.\n\t\tkubectl scale --replicas=3 -f foo.yaml\n\n\t\t#  Se la distribuzione corrente di mysql \u00e8 2, scala mysql a 3.\n\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n\n\t\t# Scalare pi\u00f9 controllori di replica.\n\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n\n\t\t# Scala il lavoro denominato 'cron' a 3.\n\t\tkubectl scale --replicas=3 job/cron\x00\n\t\t# Imposta l'ultima-configurazione-applicata di una risorsa che corrisponda al contenuto di un file.\n\t\tkubectl apply set-last-applied -f deploy.yaml\n\n\t\t# Esegue set-last-applied per ogni file di configurazione in una directory.\n\t\tkubectl apply set-last-applied -f path/\n\n\t\t# Imposta la configurazione dell'ultima applicazione di una risorsa che corrisponda al contenuto di un file, creer\u00e0 l'annotazione se non esiste gi\u00e0.\n\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n\t\t\x00\n\t\t# Mostra metriche di tutti i pod nello spazio dei nomi predefinito\n\t\tkubectl top pod\n\n\t\t# Mostra metriche di tutti i pod nello spazio dei nomi specificato\n\t\tkubectl top pod --namespace=NAMESPACE\n\n\t\t# Mostra metriche per un pod e i suoi relativi container\n\t\tkubectl top pod POD_NAME --containers\n\n\t\t# Mostra metriche per i pod definiti da label name = myLabel\n\t\tkubectl top pod -l name=myLabel\x00\n\t\t# Spegni foo.\n\t\tkubectl stop replicationcontroller foo\n\n\t\t# Stop di tutti i pod e servizi con label name=myLabel.\n\t\tkubectl stop pods,services -l name=myLabel\n\n\t\t# Spegnere il servizio definito in service.json\n\t\tkubectl stop -f service.json\n\n\t\t# Spegnere tutte le resources in path/to/resources directory\n\t\tkubectl stop -f path/to/resources\x00\n\t\t# Avviare un'unica istanza di nginx.\n\t\tkubectl run nginx --image=nginx\n\n\t\t# Avviare un'unica istanza di hazelcast e lasciare che il container  esponga la porta 5701.\n\t\tkubectl run hazelcast --image=hazelcast --port=5701\n\n\t\t# Avviare una singola istanza di hazelcast ed imposta le variabili ambiente \"DNS_DOMAIN=cluster\" e \"POD_NAMESPACE=default\" nel container.\n\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --env=\"POD_NAMESPACE=default\"\n\n\t\t# Avviare un'istanza replicata di nginx.\n\t\tkubectl run nginx --image=nginx --replicas=5\n\n\t\t# Dry run. Stampare gli oggetti API corrispondenti senza crearli.\n\t\tkubectl run nginx --image=nginx --dry-run\n\n\t\t# Avviare un'unica istanza di nginx, ma overload  le spec  del deployment  con un insieme parziale di valori analizzati da JSON.\n\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", \"spec\": { ... } }'\n\n\t\t# Avviare un pod di busybox e tenerlo in primo piano, non riavviarlo se esce.\n\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n\n\t\t# Avviare il container nginx utilizzando il comando predefinito, ma utilizzare argomenti personalizzati (arg1 .. argN) per quel comando.\n\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n\n\t\t# Avviare il container  nginx utilizzando un diverso comando e argomenti personalizzati.\n\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n\n\t\t# Avviare il contenitore perl per calcolare \u03c0 a 2000 posti e stamparlo.\n\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\n\n\t\t# Avviare il cron job per calcolare \u03c0 a 2000 posti e stampare ogni 5 minuti.\n\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\x00\n\t\t# Aggiorna il nodo \"foo\" con un marcatore con il tasto 'dedicated' e il valore 'special-user' ed effettua 'NoSchedule'.\n\t\t# Se un marcatore con quel tasto e l'effetto gi\u00e0 esiste, il suo valore viene sostituito come specificato.\n\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n\n\t\t# Rimuove dal nodo 'foo' il marcatore con il tasto 'dedicated' ed effettua 'NoSchedule' se esiste.\n\t\tkubectl taint nodes foo dedicated:NoSchedule-\n\n\t\t# Rimuovi dal nodo 'foo' tutti i marcatori con chiave 'dedicated'\n\t\tkubectl taint nodes foo dedicated-\x00\n\t\t# Aggiorna il pod 'foo' con l'etichetta 'unhealthy' e il valore 'true'.\n\t\tkubectl label pods foo unhealthy=true\n\n\t\t# Aggiorna il pod 'foo' con l'etichetta 'status' e il valore 'unhealthy', sovrascrivendo qualsiasi valore esistente.\n\t\tkubectl label --overwrite pods foo status=unhealthy\n\n\t\t# Aggiorna tutti i pod nello spazio dei nomi\n\t\tkubectl label pods --all status=unhealthy\n\n\t\t# Aggiorna un pod identificato dal tipo e dal nome in \"pod.json\"\n\t\tkubectl label -f pod.json status=unhealthy\n\n\t\t# Aggiorna il pod 'foo' solo se la risorsa \u00e8 invariata dalla versione 1.\n\t\tkubectl label pods foo status=unhealthy --resource-version=1\n\n\t\t#  Aggiorna il pod 'foo' rimuovendo un'etichetta denominata 'bar' se esiste.\n\t\t# Non richiede la flag -overwrite.\n\t\tkubectl label pods foo bar-\x00\n\t\t# Aggiorna i pod di frontend-v1 usando i dati del replication controller in frontend-v2.json.\n\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n\n\t\t# Aggiorna i pod di frontend-v1 usando i dati JSON passati da stdin.\n\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n\n\t\t# Aggiorna i pod di frontend-v1 in frontend-v2  solo cambiando l'immagine e modificando\n\t\t# il nome del replication controller.\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n\n\t\t# Aggiorna i pod di frontend solo cambiando l'immaginee mantenendo il vecchio none.\n\t\tkubectl rolling-update frontend --image=image:v2\n\n\t\t#  Interrompee ed invertire un rollout esistente in corso (da frontend-v1 a frontend-v2).\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback\x00\n\t\t# Visualizza le annotazioni dell'ultima-configurazione-applicata per tipo/nome in YAML.\n\t\tkubectl apply view-last-applied deployment/nginx\n\n\t\t# # Visualizza le annotazioni dell'ultima-configurazione-applicata per file in JSON.\n\t\tkubectl apply view-last-applied -f deploy.yaml -o json\x00\n\t\tApplicare una configurazione a una risorsa per nomefile o stdin.\n\t\tQuesta risorsa verr\u00e0 creata se non esiste ancora.\n\t\tPer utilizzare 'apply', creare sempre la risorsa inizialmente con 'apply' o 'create --save-config'.\n\n\t\tSono accettati i formati JSON e YAML.\n\n\t\tDisclaimer Alpha: la funzionalit\u00e0 --prune non \u00e8 ancora completa. Non utilizzare a meno che non si sia a conoscenza di quale sia lo stato attuale. Vedi https://issues.k8s.io/34274.\x00\n\t\tConvertire i file di configurazione tra diverse versioni API. Sono\n\t\taccettati i formati YAML e JSON.\n\n\t\tIl comando prende il nome di file, la directory o l'URL come input e lo converte nel formato\n\t\tdi versione specificata dal flag -output-version. Se la versione di destinazione non \u00e8 specificata o\n\t\tnon supportata, viene convertita nella versione pi\u00f9 recente.\n\n\t\tL'output predefinito verr\u00e0 stampato su stdout nel formato YAML. Si pu\u00f2 usare l'opzione -o\n\t\tper cambiare la destinazione di output.\x00\n\t\nCrea un ClusterRole.\x00\n\t\tCrea un ClusterRoleBinding per un ClusterRole particolare.\x00\n\t\tCrea un RoleBinding per un particolare Ruolo o ClusterRole.\x00\n\t\tCrea un TLS secret dalla coppia di chiavi pubblica/privata.\n\n\t\tLa coppia di chiavi pubblica/privata deve esistere prima. Il certificato chiave pubblica deve essere .PEM codificato e corrispondere alla chiave privata data.\x00\n\t\tCreare un configmap basato su un file, una directory o un valore literal specificato.\n\n\t\tUn singolo configmap pu\u00f2 includere una o pi\u00f9 coppie chiave/valore.\n\n\t\tQuando si crea una configmap basata su un file, il valore predefinito sar\u00e0 il nome di base del file e il valore sar\u00e0\n\t\tpredefinito per il contenuto del file. Se il nome di base \u00e8 una chiave non valida, \u00e8 possibile specificare un tasto alternativo.\n\n\t\tQuando si crea un configmap basato su una directory, ogni file il cui nome di base \u00e8 una chiave valida nella directory verr\u00e0\n\t\tpacchettizzata nel configmap. Le voci di directory tranne i file regolari vengono ignorati (ad esempio sottodirectory,\n\t\tsymlinks, devices, pipes, ecc).\x00\n\t\tCreare un namespace con il nome specificato.\x00\n\t\tCreare un nuovo secret per l'utilizzo con i registri Docker.\n\n\t\tDockercfg secrets vengono utilizzati per autenticare i registri Docker.\n\n\t\tQuando utilizzi la riga di comando Docker per il push delle immagini, \u00e8 possibile eseguire l'autenticazione eseguendo correttamente un determinato registry\n\n\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n\n    Questo produce un file ~ / .dockercfg che viene utilizzato dai successivi comandi \"docker push\" e \"docker pull\"\n\t\tper autenticarsi nel registry. L'indirizzo email \u00e8 facoltativo.\n\n\t\tDurante la creazione di applicazioni, \u00e8 possibile avere un Docker registry che richiede l'autenticazione. Affinch\u00e9 i \n\t\tnodi eseguano pull di immagini per vostro conto, devono avere le credenziali. \u00c8 possibile fornire queste informazioni \n\t\tcreando un dockercfg secret e collegandolo al tuo account di servizio.\x00\n\t\tCrea un pod disruption budget con il nome specificato, selector e il numero minimo di pod disponibili\x00\n\t\tCrea una risorsa per nome file o stdin.\n\n\t\tSono accettati i formati JSON e YAML.\x00\n\t\tCrea una resourcequota con il nome specificato, hard limits e gli scope opzionali\x00\n\t\tCrea un ruolo con una singola regola.\x00\n\t\tCrea un secret basato su un file, una directory o un valore specifico literal.\n\n\t\tUn singolo secret  pu\u00f2 includere una o pi\u00f9 coppie chiave/valore.\n\n\t\tQuando si crea un secret basato su un file, la chiave per impostazione predefinita sar\u00e0 il nome di base del file e il valore sar\u00e0\n\t\tpredefinito al contenuto del file. Se il nome di base \u00e8 una chiave non valida, \u00e8 possibile specificare un tasto alternativo.\n\n\n\t\tQuando si crea un segreto basato su una directory, ogni file il cui nome di base \u00e8 una chiave valida nella directory verr\u00e0 \n\t\\paccehttizzataw in un secret.   Le voci di directory tranne i file regolari vengono ignorati (ad esempio sottodirectory,\n\t\tsymlinks, devices, pipes, ecc).\x00\n\t\tCreare un service account con il nome specificato.\x00\n\t\tCrea ed esegue un'immagine particolare, eventualmente replicata.\n\n\t\tCrea un deployment o un job per gestire i container creati.\x00\n\t\tCrea un autoscaler che automaticamente sceglie e imposta il numero di pod che vengono eseguiti in un cluster di kubernets.\n\n\t\tEsegue una ricerca di un Deployment, ReplicaSet o ReplicationController per nome e crea un autoscaler che utilizza la risorsa indicata come riferimento.\n\t\tUn autoscaler pu\u00f2 aumentare o diminuire automaticamente il numero di pod distribuiti all'interno del sistema se necessario.\x00\n\t\tCancella risorse secondo nomi di file, stdin, risorse e nomi, o per selettori di risorse e etichette.\n\n\t\tSono accettati i formati JSON e YAML. \u00c8 possibile specificare un solo tipo di argomenti: nome file,\n\t\trisorse e nomi, o risorse e selettore di etichette.\n\n\t\tAlcune risorse, come i pod, supportano cacellazione corretta. Queste risorse definiscono un periodo di default\n\t\tprima che siano forzatamente terminate (il grace period) ma si pu\u00f2 sostituire quel valore con\n\t\til falg --grace-period, o passare --now per impostare il grace-period a 1. Poich\u00e9 queste risorse spesso\n\t\trappresentano entit\u00e0 del cluster, la cancellazione non pu\u00f2 essere presa in carico immediatamente. Se il nodo\n\t\tche ospita un pod \u00e8 spento o non raggiungibile da API server, termination pu\u00f2 richiedere molto pi\u00f9 tempo\n\t\tdel grace period. Per forzare la cancellazione di una resource,\tdevi obbligatoriamente indicare un grace\tperiod di 0 e specificare\n\t\til flag --force.\n\n\t\tIMPORTANTE: Fozare la cancellazione dei pod non attende conferma che i processi del pod siano\n\t\tterminati, che pu\u00f2 lasciare questi processi in esecuzione fino a quando il nodo rileva la cancellazione\n\t\tcompletata correttamente. Se i tuoi processi utilizzano l'archiviazione condivisa o parlano con un'API remota e\n\t\tdipendono dal nome del pod per identificarsi, la forzata eliminazione di questi pod pu\u00f2 comportare\n\t\tpi\u00f9 processi in esecuzione su macchine diverse che utilizzando la stessa identificazione che pu\u00f2 portare\n\t\tcorruzione o inconsistenza dei dati. Forza i pod solo quando si \u00e8 sicuri che il pod sia\n\t\tterminato, o se la tua applicazione pu\u00f2 can tollerare pi\u00f9 copie dello stesso pod in esecuzione contemporaneamente.\n\t\tInoltre, se forzate l'eliminazione dei i nodi, lo scheduler pu\u00f2 pu\u00f2 creare nuovi nodi su questi nodi prima che il nodo\n\t\tabbia liberato quelle risorse e provocando immediatamente evict di tali pod.\n\n\n\t\tNotare che il comando di eliminazione NON fa verificare la versione delle risorse, quindi se qualcuno\n\t\tinvia un aggiornamento ad una risorsa quando invii un eliminazione, il loro aggiornamento\n\t\tsaranno persi insieme al resto della risorsa.\x00\n\t\tDeprecated: chiudere correttamente una risorsa per nome o nome file.\n\n\t\tIl comando stop \u00e8 deprecato, tutte le sue funzionalit\u00e0 sono coperte dal comando delete.\n\t\tVedere 'kubectl delete --help' per ulteriori dettagli.\n\n\t\tTenta di arrestare ed eliminare una risorsa che supporta la corretta terminazione.\n\t\tSe la risorsa \u00e8 scalabile, verr\u00e0 scalata a 0 prima dell'eliminazione.\x00\n\t\tVisualizza l'utilizzo di risorse (CPU/Memoria/Storage) dei nodi.\n\n\t\tIl comando top-node consente di visualizzare il consumo di risorse dei nodi.\x00\n\t\tVisualizza l'utilizzo di risorse (CPU/Memoria/Storage) dei pod.\n\n\t\tIl comando \"top pod\" consente di visualizzare il consumo delle risorse dei pod.\n\n\t\tA causa del ritardo della pipeline metrica, potrebbero non essere disponibili per alcuni minuti\n\t\teal momento della creazione dei pod.\x00\n\t\tVisualizza l'utilizzo di risorse (CPU/Memoria/Storage).\n\n\t\tIl comando top consente di visualizzare il consumo di risorse per nodi o pod.\n\n\t\tQuesto comando richiede che Heapster sia configurato correttamente e che funzioni sul server.\x00\n\t\tDrain node in preparazione alla manutenzione.\n\n\t\tIl nodo indicato verr\u00e0 contrassegnato unschedulable  per impedire che nuovi pod arrivino.\n\t\t'drain' evict i pod se l'APIServer supporta eviction\n\t\t(http://kubernetes.io/docs/admin/disruptions/).  Altrimenti, usa il normale DELETE\n\t\tper eliminare i pod.\n\t\tIl 'drain' evicts o la cancellazione di tutti all pod tranne mirror pods (che non possono essere eliminati\n\t\tattraverso API server).  Se ci sono i pod gestiti da  DaemonSet, drain non proceder\u00e0\n\t\tsenza --ignore-daemonsets e, a prescindere da ci\u00f2, non canceller\u00e0 alcun\n\t\tpod gestitto da DaemonSet,poich\u00e9 questi pods verrebbero immediatamente sostituiti dal\n\t\tDaemonSet controller,  che ignora le marcature unschedulable.  Se ci sono\n\t\tpod che non sono n\u00e9 mirror pod n\u00e9 gestiti dal ReplicationController,\n\t\tReplicaSet, DaemonSet, StatefulSet o Job, allora drain non canceller\u00e0 alcun pod finch\u00e9 non\n\t\tuserai --force.  --force permetter\u00e0 alla cancellazione di procedere se la risorsa gestita da uno\n\t\to pi\u00f9 pod \u00e8 mancante.\n\n\t\t'drain' attende il termine corretto. Non devi operare sulla macchina finch\u00e9\n\t\til comando non viene completato.\n\n\t\tQuando sei pronto per riportare il nodo al servizio, utilizza kubectl uncordon, per\n\t\trimettere il nodo schedulable nuovamente.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)\x00\n\t\tModificare una risorsa dall'editor predefinito.\n\n\t\tIl comando di modifica consente di modificare direttamente qualsiasi risorsa API che \u00e8 possibile recuperare tramite gli\n\t\tstrumenti di riga di comando. Apre l'editor definito dalle variabili d'ambiente\n\t\tKUBE_EDITOR o EDITOR, o ritornare a 'vi' per Linux o 'notepad' per Windows.\n\t\t\u00c8 possibile modificare pi\u00f9 oggetti, anche se le modifiche vengono applicate una alla volta. Il comando\n\t\taccetta sia nomi di file che argomenti da riga di comando, anche se i file a cui fa riferimento devono\n\t\tessere state salvate precedentemente le versioni delle risorse.\n\n\t\tLa modifica viene eseguita con la versione API utilizzata per recuperare la risorsa.\n\t\tPer modificare utilizzando una specifica versione API, fully-qualify la risorsa, versione e il gruppo.\n\n\t\tIl formato predefinito \u00e8 YAML. Per modificare in JSON, specificare \"-o json\".\n\n\t\tIl flag --windows-line-endings pu\u00f2 essere utilizzato per forzare i fine linea Windows,\n\t\taltrimenti verr\u00e0 utilizzato il default per il sistema operativo.\n\n\t\tNel caso in cui si verifica un errore durante l'aggiornamento, verr\u00e0 creato un file temporaneo sul disco\n\t\tche contiene le modifiche non apportate. L'errore pi\u00f9 comune durante l'aggiornamento di una risorsa\n\t\t\u00e8 una modifica da pare di un altro editor della risorsa sul server. Quando questo si verifica, dovrai\n\t\tapplicare le modifiche alla versione pi\u00f9 recente della risorsa o aggiornare il tua copia\n\t\ttemporanea salvata per includere l'ultima versione delle risorse.\x00\n\t\tContrassegna il nodo come programmabile.\x00\n\t\tContrassegnare il nodo come non programmabile.\x00\n\t\tIn output codice di completamento shell output per la shell specificata (bash o zsh).\n\t\tIl codice di shell deve essere valorizzato per fornire completamento\n\t\tinterattivo dei comandi kubectl. Questo pu\u00f2 essere eseguito richiamandolo\n\t\tda .bash_profile.\n\n\t\tNota: questo richiede il framework di completamento bash, che non \u00e8 installato\n\t\tper impostazione predefinita su Mac. Questo pu\u00f2 essere installato utilizzando homebrew:\n\n\t\t    $ brew install bash-completion\n\n\t\tUna volta installato, bash_completion deve essere valutato. Ci\u00f2 pu\u00f2 essere fatto aggiungendo la\n\t\tseguente riga al file .bash_profile\n\n\t\t    $ source $(brew --prefix)/etc/bash_completion\n\n\t\tNota per gli utenti zsh: [1] i completamenti zsh sono supportati solo nelle versioni zsh> = 5.2\x00\n\t\tEseguire un rolling update del ReplicationController specificato.\n\n\t\tSostituisce il replication controller specificato con un nuovo replication controller aggiornando un pod alla volta per usare il\n\t\tnuovo PodTemplate. Il new-controller.json deve specificare lo stesso namespace del\n\t\tcontroller di replica esistente e sovrascrivere almeno una etichetta (comune) nella sua replicaSelector.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)\x00\n\t\tSostituire una risorsa per nomefile o stdin.\n\n\t\tSono accettati i formati JSON e YAML. Se si sostituisce una risorsa esistente, \n\t\t\u00e8 necessario fornire la specifica completa delle risorse. Questo pu\u00f2 essere ottenuta da\n\n\t\t    $ kubectl get TYPE NAME -o yaml\n\n\t\tFare riferimento ai modelli https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html per trovare se un campo \u00e8 mutevole.\x00\n\t\tImposta una nuova dimensione per Deployment, ReplicaSet, Replication Controller, o Job.\n\n\t\tScala consente anche agli utenti di specificare una o pi\u00f9 condizioni preliminari per l'azione della scala.\n\n\t\tSe --current-replicas o --resource-version sono specificate, viene convalidata prima di\n\t\ttentare scale, ed \u00e8 garantito che la precondizione vale quando\n\t\tscale viene inviata al server..\x00\n\t\tImposta le annotazioni dell'ultima-configurazione-applicata impostandola in modo che corrisponda al contenuto di un file.\n\t\tCi\u00f2 determina l'aggiornamento dell'ultima-configurazione-applicata come se 'kubectl apply -f <file>' fosse stato eseguito,\n\t\tsenza aggiornare altre parti dell'oggetto.\x00\n\t\tPer proxy tutti i kubernetes api e nient'altro, utilizzare:\n\n\t\t    $ kubectl proxy --api-prefix=/\n\n\t\tPer proxy solo una parte dei kubernetes api e anche alcuni file static\n\n\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/api/\n\n\t\tQuanto sopra consente 'curl localhost:8001/api/v1/pods'.\n\n\t\tPer eseguire il proxy tutti i kubernetes api in una radice diversa, utilizzare:\n\n\t\t    $ kubectl proxy --api-prefix=/custom/\n\n\t\tQuanto sopra ti permette 'curl localhost:8001/custom/api/v1/pods'\x00\n\t\tAggiorna i campi di una risorsa utilizzando la merge patch strategica\n\n\t\tSono accettati i formati JSON e YAML.\n\n\t\tSi prega di fare riferimento ai modelli in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html per trovare se un campo \u00e8 mutevole.\x00\n\t\tAggiorna le label di una risorsa.\n\n\t\t* A label must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* If --overwrite is true, then existing labels can be overwritten, otherwise attempting to overwrite a label will result in an error.\n\t\t* If --resource-version is specified, then updates will use this resource version, otherwise the existing resource-version will be used.\x00\n\t\tAggiorna i marcatori su uno o pi\u00f9 nodi.\n\n\t\t* Un marcatore \u00e8 costituita da una chiave, un valore e un effetto. Come argomento qui, viene espresso come chiave = valore: effetto.\n\t\t* La chiave deve iniziare con una lettera o un numero e pu\u00f2 contenere lettere, numeri, trattini, punti e sottolineature, fino a% [1] d caratteri.\n\t\t* Il valore deve iniziare con una lettera o un numero e pu\u00f2 contenere lettere, numeri, trattini, punti e sottolineature, fino a% [2] d caratteri.\n\t\t* L'effetto deve essere NoSchedule, PreferNoSchedule o NoExecute.\n\t\t* Attualmente il marcatore pu\u00f2 essere applicato solo al nodo.\x00\n\t\tVisualizza le annotazioni dell'ultima-configurazione-applicata per tipo/nome o file.\n\n\t\tL'output predefinito verr\u00e0 stampato su stdout nel formato YAML. Si pu\u00f2 usare l'opzione -o\n\t\tPer cambiare il formato di output.\x00\n\t    #  !!!Nota importante!!!\n\t    # Richiede che il binario 'tar' sia presente nel tuo contenitore\n\t    #  immagine. Se 'tar' non \u00e8 presente, 'kubectl cp' non riesce.\n\n\t    # Copia /tmp/foo_dir directory locale in /tmp/bar_dir in un pod remoto nello spazio dei nomi predefinito\n\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n\n        # Copia /tmp/foo file locale in /tmp/bar in un pod remoto in un contenitore specifico\n\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n\n\t\t# Copia /tmp/foo file locale in /tmp/bar in un pod remoto nello spazio dei nomi <some-namespace>\n\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n\n\t\t# Copia /tmp/foo da un pod remoto in /tmp/bar localmente\n\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar\x00\n\t  # Crea un nuovo secret TLS denominato tls-secret con la coppia di dati fornita:\n\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/to/tls.key\x00\n\t  # Crea un nuovo namespace denominato my-namespace\n\t  kubectl create namespace my-namespace\x00\n\t  # Crea un nuovo secret denominato my-secret con i tasti per ogni file nella barra delle cartelle\n\t  kubectl create secret generic my-secret --from-file=path/to/bar\n\n\t  # Crea un nuovo secret denominato my-secret con le chiavi specificate anzich\u00e9 i nomi sul disco\n\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/.ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n\n\t  # Crea un nuovo secret denominato my-secret con key1 = supersecret e key2 = topsecret\n\t  kubectl create secret generic my-secret --from-literal=key1=supersecret --from-literal=key2=topsecret\x00\n\t  # Crea un nuovo service account denominato my-service-account\n\t  kubectl create serviceaccount my-service-account\x00\n\t#  Crea un nuovo servizio ExternalName denominato my-ns \n\tkubectl create service externalname my-ns --external-name bar.com\x00\n\tCrea un servizio ExternalName con il nome specificato.\n\n\tIl servizio ExternalName fa riferimento a un indirizzo DNS esterno \n\tsolo pod, che permetteranno agli autori delle applicazioni di utilizzare i servizi di riferimento\n\tche esistono fuori dalla piattaforma, su altri cluster, o localmente..\x00\n\tHelp fornisce assistenza per qualsiasi comando nell'applicazione.\n\tBasta digitare kubectl help [path to command] per i dettagli completi.\x00\n    # Creare un nuovo servizio LoadBalancer denominato my-lbs\n    kubectl create service loadbalancer my-lbs --tcp=5678:8080\x00\n    # Creare un nuovo servizio clusterIP denominato my-cs\n    kubectl create service clusterip my-cs --tcp=5678:8080\n\n    # Creare un nuovo servizio clusterIP denominato my-cs (in modalit\u00e0 headless)\n    kubectl create service clusterip my-cs --clusterip=\"None\"\x00\n    # Crea una nuovo deployment chiamato my-dep che esegue l'immagine busybox.\n    kubectl create deployment my-dep --image=busybox\x00\n    # Creare un nuovo servizio nodeport denominato my-ns\n    kubectl create service nodeport my-ns --tcp=5678:8080\x00\n    # Dump dello stato corrente del cluster verso stdout\n    kubectl cluster-info dump\n\n    # Dump dello stato corrente del cluster verso /path/to/cluster-state\n    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n\n    # Dump di tutti i namespaces verso stdout\n    kubectl cluster-info dump --all-namespaces\n\n    # Dump di un set di namespace verso /path/to/cluster-state\n    kubectl cluster-info dump --namespaces default,kube-system --output-directory=/path/to/cluster-state\x00\n    # Aggiorna il pod 'foo' con annotazione 'description'e il valore 'my frontend'.\n    # Se la stessa annotazione \u00e8 impostata pi\u00f9 volte, verr\u00e0 applicato solo l'ultimo valore\n    kubectl annotate pods foo description='my frontend'\n\n    # Aggiorna un pod identificato per tipo e nome in \"pod.json\"\n    kubectl annotate -f pod.json description='my frontend'\n\n    # Aggiorna pod 'foo' con la annotazione 'description' e il valore 'my frontend running nginx', sovrascrivendo qualsiasi valore esistente.\n    kubectl annotate --overwrite pods foo description='my frontend running nginx'\n\n    # Aggiorna tutti i baccelli nel namespace\n    kubectl annotate pods --all description='my frontend running nginx'\n\n    # Aggiorna il pod 'foo' solo se la risorsa \u00e8 invariata dalla versione 1.\n    kubectl annotate pods foo description='my frontend running nginx' --resource-version=1\n\n    # Aggiorna il pod 'foo' rimuovendo un'annotazione denominata 'descrizione' se esiste.\n    # Non richiede flag -overwrite.\n    kubectl annotate pods foo description-\x00\n    Crea un servizio LoadBalancer con il nome specificato.\x00\n    Crea un servizio clusterIP con il nome specificato.\x00\n    Creare un deployment con il nome specificato.\x00\n    Creare un servizio nodeport con il nome specificato.\x00\n    Dump delle informazioni di cluster idonee per il debug e la diagnostica di problemi di cluster. Per impostazione predefinita, tutto\n\u00a0\u00a0\u00a0\u00a0verso stdout. \u00c8 possibile specificare opzionalmente una directory con --output-directory. Se si specifica una directory, kubernetes \n    creear\u00e0 un insieme di file in quella directory. Per impostazione predefinita, dumps solo i dati del namespace \"kube-system\", ma \u00e8\n    possibile passare ad namespace diverso con il flag --namespaces o specificare --all-namespaces per il dump di tutti i namespace.\n\n\u00a0\u00a0\u00a0\u00a0 Il comando esegue dump anche dei log di tutti i pod del cluster, questi log vengono scaricati in directory differenti\n\u00a0\u00a0\u00a0\u00a0 basati sul namespace e sul nome del pod.\x00\n  Visualizza gli indirizzi del master e dei servizi con label kubernetes.io/cluster-service=true\n\u00a0\u00a0Per ulteriore debug e diagnosticare i problemi di cluster, utilizzare 'kubectl cluster-info dump'.\x00Un insieme delimitato-da-virgole di quota scopes che devono corrispondere a ciascun oggetto gestito dalla quota.\x00Un insieme delimitato-da-virgola di coppie risorsa = quantit\u00e0 che definiscono un hard limit.\x00Un label selector da utilizzare per questo budget. Sono supportati solo i selettori equality-based selector.\x00Un selettore di label da utilizzare per questo servizio. Sono supportati solo equality-based selector.  Se vuota (default) dedurre il selettore dal replication controller o replica set.)\x00Un calendario in formato Cron del lavoro che deve essere eseguito.\x00Indirizzo IP esterno aggiuntivo (non gestito da Kubernetes) da accettare per il servizio. Se questo IP viene indirizzato a un nodo, \u00e8 possibile accedere da questo IP in aggiunta al service IP generato.\x00Un override JSON inline per l'oggetto generato. Se questo non \u00e8 vuoto, viene utilizzato per ignorare l'oggetto generato. Richiede che l'oggetto fornisca un campo valido apiVersion.\x00Un override JSON inline per l'oggetto di servizio generato. Se questo non \u00e8 vuoto, viene utilizzato per ignorare l'oggetto generato. Richiede che l'oggetto fornisca un campo valido apiVersion. Utilizzato solo se --expose \u00e8 true.\x00Applica una configurazione risorsa per nomefile o stdin\x00Approva una richiesta di firma del certificato\x00Assegnare il proprio ClusterIP o impostare su 'None' per un servizio 'headless' (nessun bilanciamento del carico).\x00Collega a un container in esecuzione\x00Auto-scale a Deployment, ReplicaSet, o ReplicationController\x00ClusterIP da assegnare al servizio. Lasciare vuoto per allocare automaticamente o impostare su 'None' per creare un servizio headless.\x00ClusterRole a cui questo ClusterRoleBinding fa riferimento\x00ClusterRole a cui questo RoleBinding fa riferimento\x00Nome container che avr\u00e0 la sua immagine aggiornata. Soltanto rilevante quando --image \u00e8 specificato, altrimenti ignorato. Necessario quando si utilizza --image su un contenitore a pi\u00f9 contenitori\x00Convertire i file di configurazione tra diverse versioni APIs\x00Copiare file e directory da e verso i container.\x00Crea un ClusterRoleBinding per un ClusterRole particolare\x00Creare un servizio LoadBalancer.\x00Crea un servizio NodePort.\x00Crea un RoleBinding per un particolare Role o ClusterRole\x00Crea un secret TLS\x00Crea un servizio clusterIP.\x00Crea un configmap da un file locale, una directory o un valore letterale\x00Creare un deployment con il nome specificato.\x00Crea un namespace con il nome specificato\x00Crea un pod disruption budget con il nome specificato.\x00Crea una quota con il nome specificato.\x00Crea una risorsa per nome file o stdin\x00Crea un secret da utilizzare con un registro Docker\x00Crea un secret da un file locale, una directory o un valore letterale\x00Crea un secret utilizzando un subcommand specificato\x00Creare un account di servizio con il nome specificato\x00Crea un servizio utilizzando il subcommand specificato.\x00Crea un servizio ExternalName.\x00Elimina risorse selezionate per nomi di file, stdin, risorse e nomi, o per risorsa e selettore di label\x00Elimina il cluster specificato dal kubeconfig\x00Elimina il context specificato dal kubeconfig\x00Nega una richiesta di firma del certificato\x00Deprecated: spegne correttamente una risorsa per nome o nome file\x00Descrive uno o pi\u00f9 context\x00Visualizza l'utilizzo di risorse (CPU/Memoria) per nodo\x00Visualizza l'utilizzo di risorse (CPU/Memoria) per pod.\x00Visualizza l'utilizzo di risorse (CPU/Memoria).\x00Visualizza informazioni sul cluster\x00Mostra i cluster definiti nel kubeconfig\x00Visualizza le impostazioni merged di kubeconfig o un file kubeconfig specificato\x00Visualizza una o pi\u00f9 risorse\x00Visualizza il current-context\x00Documentazione delle risorse\x00Drain node in preparazione alla manutenzione\x00Dump di un sacco di informazioni pertinenti per il debug e la diagnosi\x00Modificare una risorsa sul server\x00Email per il registro Docker\x00Esegui un comando in un contenitore\x00Politica esplicita per il pull delle immagini container. Richiesto quando --image \u00e8 uguale all'immagine esistente, altrimenti ignorata.\x00Inoltra una o pi\u00f9 porte locali a un pod\x00Aiuto per qualsiasi comando\x00IP da assegnare al Load Balancer. Se vuota, un IP effimero verr\u00e0 creato e utilizzato (specifico per provider cloud).\x00Se non \u00e8 vuoto, impostare l'affinit\u00e0 di sessione per il servizio; Valori validi: 'None', 'ClientIP'\x00Se non \u00e8 vuoto, l'aggiornamento delle annotazioni avr\u00e0 successo solo se questa \u00e8 la resource-version corrente per l'oggetto. Valido solo quando si specifica una singola risorsa.\x00Se non vuoto, l'aggiornamento delle label avr\u00e0 successo solo se questa \u00e8 la resource-version corrente per l'oggetto. Valido solo quando si specifica una singola risorsa.\x00Immagine da utilizzare per aggiornare il replication controller. Deve essere diversa dall'immagine esistente (nuova immagine o nuovo tag immagine). Non pu\u00f2 essere utilizzata con --filename/-f\x00Gestisci un deployment rollout\x00Contrassegnare il nodo come programmabile\x00Contrassegnare il nodo come non programmabile\x00Imposta la risorsa indicata in pausa\x00Modificare le risorse del certificato.\x00Modifica i file kubeconfig\x00Nome o numero di porta nel container verso il quale il servizio deve dirigere il traffico. Opzionale.\x00Restituisce solo i log dopo una data specificata (RFC3339). Predefinito tutti i log. \u00c8 possibile utilizzare solo uno tra data-inizio/a-partire-da.\x00Codice di completamento shell di output per la shell specificata (bash o zsh)\x00Output dell'oggetto formattato con la versione del gruppo fornito (per esempio: 'extensions/v1beta1').)\x00Password per l'autenticazione al registro di Docker\x00Percorso certificato di chiave pubblica codificato PEM.\x00Percorso alla chiave privata associata a un certificato specificato.\x00Eseguire un rolling update del ReplicationController specificato\x00Prerequisito per la versione delle risorse. Richiede che la versione corrente delle risorse corrisponda a questo valore per scalare.\x00Stampa per client e server le informazioni sulla versione\x00Stampa l'elenco flag ereditati da tutti i comandi\x00Stampa i log per container in un pod\x00Sostituire una risorsa per nomefile o stdin\x00Riprendere una risorsa in pausa\x00Ruolo di riferimento per RoleBinding\x00Esegui una particolare immagine nel cluster\x00Eseguire un proxy al server Kubernetes API\x00Posizione del server per il Registro Docker\x00Imposta una nuova dimensione per Deployment, ReplicaSet, Replication Controller, o Job\x00Imposta caratteristiche specifiche sugli oggetti\x00Imposta l'annotazione dell'ultima-configurazione-applicata ad un oggetto live per abbinare il contenuto di un file.\x00Impostare il selettore di una risorsa\x00Imposta una voce cluster in kubeconfig\x00Imposta una voce context in kubeconfig\x00Imposta una voce utente in kubeconfig\x00Imposta un singolo valore in un file kubeconfig\x00Imposta il current-context in un file kubeconfig\x00Mostra i dettagli di una specifiche risorsa o un gruppo di risorse\x00Mostra lo stato del rollout\x00Sinonimo di --target-port\x00Prende un replication controller, service, deployment o un pod e lo espone come nuovo servizio Kubernetes\x00L'immagine per il container da eseguire.\x00La politica di pull dell'immagine per il container. Se lasciato vuoto, questo valore non verr\u00e0 specificato dal client e predefinito dal server\x00La chiave da utilizzare per distinguere tra due controller diversi, predefinito \"deployment\". Rilevante soltanto quando --image \u00e8 specificato, altrimenti ignorato\x00Il numero minimo o la percentuale di pod disponibili che questo budget richiede.\x00Il nome dell'oggetto appena creato.\x00Il nome dell'oggetto appena creato. Se non specificato, verr\u00e0 utilizzato il nome della risorsa di input.\x00Il nome del generatore API da utilizzare, si veda http://kubernetes.io/docs/user-guide/kubectl-conventions/#generators per un elenco.\x00Il nome del generatore API da utilizzare. Attualmente c'\u00e8 solo 1 generatore.\x00Il nome del generatore API da utilizzare. Ci sono 2 generatori: 'service/v1' e 'service/v2'. L'unica differenza tra loro \u00e8 che la porta di servizio in v1 \u00e8 denominata \"predefinita\", mentre viene lasciata unnamed in v2. Il valore predefinito \u00e8 'service/v2'.\x00Il nome del generatore da utilizzare per la creazione di un servizio. Utilizzato solo se --expose \u00e8 true\x00Il protocollo di rete per il servizio da creare. Il valore predefinito \u00e8 'TCP'.\x00La porta che il servizio deve servire. Copiato dalla risorsa esposta, se non specificata\x00La porta che questo contenitore espone. Se --expose \u00e8 true, questa \u00e8 anche la porta utilizzata dal servizio creato.\x00I limiti delle richieste di risorse per questo contenitore.  Ad esempio, 'cpu=200m,memory=512Mi'. Si noti che i componenti lato server possono assegnare i limiti a seconda della configurazione del server, ad esempio intervalli di limiti.\x00La risorsa necessita di richieste di requisiti per questo pod. Ad esempio, 'cpu = 100m, memoria = 256Mi'. Si noti che i componenti lato server possono assegnare i requisiti a seconda della configurazione del server, ad esempio intervalli di limiti.\x00La politica di riavvio per questo Pod. Valori accettati [Always, OnFailure, Never]. Se impostato su 'Always' viene creato un deployment, se impostato su 'OnFailure' viene creato un job, se impostato su 'Never', viene creato un pod. Per questi ultimi due le - repliche devono essere 1. Predefinito 'Always', per CronJobs `Never`.\x00Tipo di segreto da creare\x00Digitare per questo servizio: ClusterIP, NodePort o LoadBalancer. Ppredefinito \u00e8 'ClusterIP'.\x00Annulla un precedente rollout\x00Annulla singolo valore in un file kubeconfig\x00Aggiornare campo/i risorsa utilizzando merge patch strategici\x00Aggiorna immagine di un pod template\x00Aggiorna richieste di risorse/limiti sugli oggetti con pod template\x00Aggiorna annotazioni di risorsa\x00Aggiorna label di una risorsa\x00Aggiorna i taints su uno o pi\u00f9 nodi\x00Nome utente per l'autenticazione nel registro Docker\x00Visualizza ultime annotazioni dell'ultima configurazione applicata per risorsa/oggetto\x00Visualizza la storia del rollout\x00Dove eseguire l'output dei file. Se vuota o '-' utilizza lo stdout, altrimenti crea una gerarchia di directory in quella directory\x00flag di riavvio finto)\x00nome esterno del servizio\x00Kubectl controlla il gestore cluster di Kubernetes\x00")

func translationsKubectlIt_itLc_messagesK8sMoBytes() ([]byte, error) {
	return _translationsKubectlIt_itLc_messagesK8sMo, nil
}

func translationsKubectlIt_itLc_messagesK8sMo() (*asset, error) {
	bytes, err := translationsKubectlIt_itLc_messagesK8sMoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/it_IT/LC_MESSAGES/k8s.mo", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlIt_itLc_messagesK8sPo = []byte(`# Italian translation.
# Copyright (C) 2017
# This file is distributed under the same license as the Kubernetes package.
# FIRST AUTHOR evolution85@gmail.com, 2017.
#
msgid ""
msgstr ""
"Project-Id-Version: kubernetes\n"
"Report-Msgid-Bugs-To: EMAIL\n"
"POT-Creation-Date: 2017-03-14 21:32-0700\n"
"PO-Revision-Date: 2017-08-28 15:20+0200\n"
"Language: it_IT\n"
"MIME-Version: 1.0\n"
"Content-Type: text/plain; charset=UTF-8\n"
"Content-Transfer-Encoding: 8bit\n"
"Plural-Forms: nplurals=2; plural=(n != 1);\n"
"Last-Translator: Luca Berton <mr.evolution85@gmail.com>\n"
"Language-Team: Luca Berton <mr.evolution85@gmail.com>\n"
"X-Generator: Poedit 1.8.7.1\n"
"X-Poedit-SourceCharset: UTF-8\n"

#: pkg/kubectl/cmd/create_clusterrolebinding.go:35
msgid ""
"\n"
"\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the "
"cluster-admin ClusterRole\n"
"\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-"
"admin --user=user1 --user=user2 --group=group1"
msgstr ""
"\n"
"\t\t # Creare un ClusterRoleBinding per user1, user2 e group1 utilizzando il "
"cluster-admin ClusterRole\n"
"\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-"
"admin --user=user1 --user=user2 --group=group1"

#: pkg/kubectl/cmd/create_rolebinding.go:35
msgid ""
"\n"
"\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin "
"ClusterRole\n"
"\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --"
"user=user2 --group=group1"
msgstr ""
"\n"
"\t\t  # Crea un RoleBinding per user1, user2, and group1 utilizzando l'admin "
"ClusterRole\n"
"\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --"
"user=user2 --group=group1"

#: pkg/kubectl/cmd/create_configmap.go:44
msgid ""
"\n"
"\t\t  # Create a new configmap named my-config based on folder bar\n"
"\t\t  kubectl create configmap my-config --from-file=path/to/bar\n"
"\n"
"\t\t  # Create a new configmap named my-config with specified keys instead of "
"file basenames on disk\n"
"\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1."
"txt --from-file=key2=/path/to/bar/file2.txt\n"
"\n"
"\t\t  # Create a new configmap named my-config with key1=config1 and "
"key2=config2\n"
"\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-"
"literal=key2=config2"
msgstr ""
"\n"
"\t\t  # Crea un nuovo configmap denominato my-config in base alla cartella "
"bar\n"
"\t\t  kubectl create configmap my-config --from-file=path/to/bar\n"
"\n"
"\t\t  # Crea un nuovo configmap denominato my-config con le chiavi "
"specificate anziché i nomi dei file su disco\n"
"\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1."
"txt --from-file=key2=/path/to/bar/file2.txt\n"
"\n"
"\t\t  # Crea un nuovo configmap denominato my-config con key1 = config1 e "
"key2 = config2\n"
"\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-"
"literal=key2=config2"

#: pkg/kubectl/cmd/create_secret.go:135
msgid ""
"\n"
"\t\t  # If you don't already have a .dockercfg file, you can create a "
"dockercfg secret directly by using:\n"
"\t\t  kubectl create secret docker-registry my-secret --docker-"
"server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-"
"password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL"
msgstr ""
"\n"
"\t\t  # Se non si dispone ancora di un file .dockercfg, è possibile creare un "
"secret dockercfg direttamente utilizzando:\n"
"\t\t  kubectl create secret docker-registry my-secret --docker-"
"server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-"
"password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL"

#: pkg/kubectl/cmd/top_node.go:65
msgid ""
"\n"
"\t\t  # Show metrics for all nodes\n"
"\t\t  kubectl top node\n"
"\n"
"\t\t  # Show metrics for a given node\n"
"\t\t  kubectl top node NODE_NAME"
msgstr ""
"\n"
"\t\t  # Mostra metriche per tutti i nodi\n"
"\t\t kubectl top node\n"
"\n"
"\t\t # Mostra metriche per un determinato nodo\n"
"\t\t kubectl top node NODE_NAME"

#: pkg/kubectl/cmd/apply.go:84
msgid ""
"\n"
"\t\t# Apply the configuration in pod.json to a pod.\n"
"\t\tkubectl apply -f ./pod.json\n"
"\n"
"\t\t# Apply the JSON passed into stdin to a pod.\n"
"\t\tcat pod.json | kubectl apply -f -\n"
"\n"
"\t\t# Note: --prune is still in Alpha\n"
"\t\t# Apply the configuration in manifest.yaml that matches label app=nginx "
"and delete all the other resources that are not in the file and match label "
"app=nginx.\n"
"\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n"
"\n"
"\t\t# Apply the configuration in manifest.yaml and delete all the other "
"configmaps that are not in the file.\n"
"\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/"
"ConfigMap"
msgstr ""
"\n"
"\t\t# Applica la configurazione pod.json a un pod.\n"
"\t\tkubectl apply -f ./pod.json\n"
"\n"
"\t\t# Applicare il JSON passato in stdin a un pod.\n"
"\t\tcat pod.json | kubectl apply -f -\n"
"\n"
"\t\t# Nota: --prune è ancora in in Alpha\n"
"\t\t# Applica la configurazione manifest.yaml che corrisponde alla label app "
"= nginx ed elimina tutte le altre risorse che non sono nel file e nella label "
"corrispondente app = nginx.\n"
"\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n"
"\n"
"\t\t# Applica la configurazione manifest.yaml ed elimina tutti gli altri "
"configmaps non presenti nel file.\n"
"\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/"
"ConfigMap"

#: pkg/kubectl/cmd/autoscale.go:40
#, c-format
msgid ""
"\n"
"\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and "
"10, no target CPU utilization specified so a default autoscaling policy will "
"be used:\n"
"\t\tkubectl autoscale deployment foo --min=2 --max=10\n"
"\n"
"\t\t# Auto scale a replication controller \"foo\", with the number of pods "
"between 1 and 5, target CPU utilization at 80%:\n"
"\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80"
msgstr ""
"\n"
"\t\t#  Auto scale un deployment \"foo\", con il numero di pod compresi tra 2 "
"e 10, utilizzo della CPU target specificato in modo da utilizzare una "
"politica di autoscaling predefinita:\n"
"\t\tkubectl autoscale deployment foo --min=2 --max=10\n"
"\n"
"\t\t# Auto scale un controller di replica \"foo\", con il numero di pod "
"compresi tra 1 e 5, utilizzo dell'utilizzo della CPU a 80%:\n"
"\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80"

#: pkg/kubectl/cmd/convert.go:49
msgid ""
"\n"
"\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n"
"\t\tkubectl convert -f pod.yaml\n"
"\n"
"\t\t# Convert the live state of the resource specified by 'pod.yaml' to the "
"latest version\n"
"\t\t# and print to stdout in json format.\n"
"\t\tkubectl convert -f pod.yaml --local -o json\n"
"\n"
"\t\t# Convert all files under current directory to latest version and create "
"them all.\n"
"\t\tkubectl convert -f . | kubectl create -f -"
msgstr ""
"\n"
"\t\t# Converte 'pod.yaml' alla versione più recente e stampa in stdout.\n"
"\t\tkubectl convert -f pod.yaml\n"
"\n"
"\t\t# Converte lo stato live della risorsa specificata da 'pod.yaml' nella "
"versione più recente.\n"
"\t\t# e stampa in stdout nel formato json.\n"
"\t\tkubectl convert -f pod.yaml --local -o json\n"
"\n"
"\t\t# Converte tutti i file nella directory corrente alla versione più "
"recente e li crea tutti.\n"
"\t\tkubectl convert -f . | kubectl create -f -"

#: pkg/kubectl/cmd/create_clusterrole.go:34
msgid ""
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform "
"\"get\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods\n"
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods --resource-name=readablepod"
msgstr ""
"\n"
"\t\t# Crea un ClusterRole denominato \"pod-reader\" che consente all'utente "
"di eseguire \"get\", \"watch\" e \"list\" sui pod\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods\n"
"\n"
"\t\t# Crea un ClusterRole denominato \"pod-reader\" con ResourceName "
"specificato\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods --resource-name=readablepod"

#: pkg/kubectl/cmd/create_role.go:41
msgid ""
"\n"
"\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get\", "
"\"watch\" and \"list\" on pods\n"
"\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --"
"resource=pods\n"
"\n"
"\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --"
"resource=pods --resource-name=readablepod"
msgstr ""
"\n"
"\t\t# Crea un ruolo denominato \"pod-reader\" che consente all'utente di "
"eseguire \"get\", \"watch\" e \"list\" sui pod\n"
"\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --"
"resource=pods\n"
"\n"
"\t\t# Crea un ruolo denominato \"pod-reader\" con ResourceName specificato\n"
"\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --"
"resource=pods --resource-name=readablepod"

#: pkg/kubectl/cmd/create_quota.go:35
msgid ""
"\n"
"\t\t# Create a new resourcequota named my-quota\n"
"\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,"
"replicationcontrollers=2,resourcequotas=1,secrets=5,"
"persistentvolumeclaims=10\n"
"\n"
"\t\t# Create a new resourcequota named best-effort\n"
"\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort"
msgstr ""
"\n"
"\t\t# Crea una nuova resourcequota chiamata my-quota\n"
"\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,"
"replicationcontrollers=2,resourcequotas=1,secrets=5,"
"persistentvolumeclaims=10\n"
"\n"
"\t\t# Creare una nuova resourcequota denominata best-effort\n"
"\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort"

#: pkg/kubectl/cmd/create_pdb.go:35
#, c-format
msgid ""
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=rails label\n"
"\t\t# and require at least one of them being available at any point in time.\n"
"\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-"
"available=1\n"
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=nginx label\n"
"\t\t# and require at least half of the pods selected to be available at any "
"point in time.\n"
"\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%"
msgstr ""
"\n"
"\t\t# Crea un pod disruption budget chiamato my-pdb che seleziona tutti i pod "
"con label app = rail\n"
"\t\t# e richiede che almeno uno di essi sia disponibile in qualsiasi "
"momento.\n"
"\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-"
"available=1\n"
"\n"
"\t\t# Crea un pod disruption budget con nome my-pdb che seleziona tutti i pod "
"con label app = nginx \n"
"\t\t# e richiede che almeno la metà dei pod selezionati sia disponibile in "
"qualsiasi momento.\n"
"\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%"

#: pkg/kubectl/cmd/create.go:47
msgid ""
"\n"
"\t\t# Create a pod using the data in pod.json.\n"
"\t\tkubectl create -f ./pod.json\n"
"\n"
"\t\t# Create a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl create -f -\n"
"\n"
"\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format "
"then create the resource using the edited data.\n"
"\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json"
msgstr ""
"\n"
"\t\t# Crea un pod utilizzando i dati in pod.json.\n"
"\t\tkubectl create -f ./pod.json\n"
"\n"
"\t\t# Crea un pod basato sul JSON passato in stdin.\n"
"\t\tcat pod.json | kubectl create -f -\n"
"\n"
"\t\t# Modifica i dati in docker-registry.yaml in JSON utilizzando il formato "
"API v1 quindi creare la risorsa utilizzando i dati modificati.\n"
"\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json"

#: pkg/kubectl/cmd/expose.go:53
msgid ""
"\n"
"\t\t# Create a service for a replicated nginx, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose rc nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a replication controller identified by type and "
"name specified in \"nginx-controller.yaml\", which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a pod valid-pod, which serves on port 444 with the "
"name \"frontend\"\n"
"\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n"
"\n"
"\t\t# Create a second service based on the above service, exposing the "
"container port 8443 as port 443 with the name \"nginx-https\"\n"
"\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-"
"https\n"
"\n"
"\t\t# Create a service for a replicated streaming application on port 4100 "
"balancing UDP traffic and named 'video-stream'.\n"
"\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-"
"stream\n"
"\n"
"\t\t# Create a service for a replicated nginx using replica set, which serves "
"on port 80 and connects to the containers on port 8000.\n"
"\t\tkubectl expose rs nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for an nginx deployment, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose deployment nginx --port=80 --target-port=8000"
msgstr ""
"\n"
"\t\t# Crea un servizio per un nginx replicato, che serve nella porta 80 e si "
"collega ai container sulla porta 8000.\n"
"\t\tkubectl expose rc nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Crea un servizio per un controller di replica identificato per tipo e "
"nome specificato in \"nginx-controller.yaml\", che serve nella porta 80 e si "
"collega ai container sulla porta 8000.\n"
"\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n"
"\n"
"\t\t# Crea un servizio per un pod valid-pod, che serve nella porta 444 con il "
"nome \"frontend\"\n"
"\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n"
"\n"
"\t\t# Crea un secondo servizio basato sul servizio sopra, esponendo la porta "
"container 8443 come porta 443 con il nome \"nginx-https\"\n"
"\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-"
"https\n"
"\n"
"\t\t#  Crea un servizio per un'applicazione di replica in porta 4100 che "
"bilanci il traffico UDP e denominato \"video stream\".\n"
"\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-"
"stream\n"
"\n"
"\t\t# Crea un servizio per un nginx replicato utilizzando l'insieme di "
"replica, che serve nella porta 80 e si collega ai contenitori sulla porta "
"8000.\n"
"\t\tkubectl expose rs nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Crea un servizio per una distribuzione di nginx, che serve nella porta "
"80 e si collega ai contenitori della porta 8000.\n"
"\t\tkubectl expose deployment nginx --port=80 --target-port=8000"

#: pkg/kubectl/cmd/delete.go:68
msgid ""
"\n"
"\t\t# Delete a pod using the type and name specified in pod.json.\n"
"\t\tkubectl delete -f ./pod.json\n"
"\n"
"\t\t# Delete a pod based on the type and name in the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl delete -f -\n"
"\n"
"\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n"
"\t\tkubectl delete pod,service baz foo\n"
"\n"
"\t\t# Delete pods and services with label name=myLabel.\n"
"\t\tkubectl delete pods,services -l name=myLabel\n"
"\n"
"\t\t# Delete a pod with minimal delay\n"
"\t\tkubectl delete pod foo --now\n"
"\n"
"\t\t# Force delete a pod on a dead node\n"
"\t\tkubectl delete pod foo --grace-period=0 --force\n"
"\n"
"\t\t# Delete all pods\n"
"\t\tkubectl delete pods --all"
msgstr ""
"\n"
"\t\t# Elimina un pod utilizzando il tipo e il nome specificati in pod.json.\n"
"\t\tkubectl delete -f ./pod.json\n"
"\n"
"\t\t# Elimina un pod in base al tipo e al nome del JSON passato in stdin.\n"
"\t\tcat pod.json | kubectl delete -f -\n"
"\n"
"\t\t# Elimina i baccelli ei servizi con gli stessi nomi \"baz\" e \"foo\"\n"
"\t\tkubectl delete pod,service baz foo\n"
"\n"
"\t\t# Elimina i baccelli ei servizi con il nome dell'etichetta = myLabel.\n"
"\t\tkubectl delete pods,services -l name=myLabel\n"
"\n"
"\t\t# Eliminare un pod con un ritardo minimo\n"
"\t\tkubectl delete pod foo --now\n"
"\n"
"\t\t# Forza elimina un pod in un nodo morto\n"
"\t\tkubectl delete pod foo --grace-period=0 --force\n"
"\n"
"\t\t# Elimina tutti i pod\n"
"\t\tkubectl delete pods --all"

#: pkg/kubectl/cmd/describe.go:54
msgid ""
"\n"
"\t\t# Describe a node\n"
"\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n"
"\n"
"\t\t# Describe a pod\n"
"\t\tkubectl describe pods/nginx\n"
"\n"
"\t\t# Describe a pod identified by type and name in \"pod.json\"\n"
"\t\tkubectl describe -f pod.json\n"
"\n"
"\t\t# Describe all pods\n"
"\t\tkubectl describe pods\n"
"\n"
"\t\t# Describe pods by label name=myLabel\n"
"\t\tkubectl describe po -l name=myLabel\n"
"\n"
"\t\t# Describe all pods managed by the 'frontend' replication controller (rc-"
"created pods\n"
"\t\t# get the name of the rc as a prefix in the pod the name).\n"
"\t\tkubectl describe pods frontend"
msgstr ""
"\n"
"\t\t# Descrive un nodo\n"
"\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n"
"\n"
"\t\t# Descrive un pod\n"
"\t\tkubectl describe pods/nginx\n"
"\n"
"\t\t# Descrive un pod identificato da tipo e nome in \"pod.json\"\n"
"\t\tkubectl describe -f pod.json\n"
"\n"
"\t\t# Descrive tutti i pod\n"
"\t\tkubectl describe pods\n"
"\n"
"\t\t# Descrive i pod con label name=myLabel\n"
"\t\tkubectl describe po -l name=myLabel\n"
"\n"
"\t\t# Descrivere tutti i pod gestiti dal controller di replica \"frontend"
"\"  (rc-created pods\n"
"\t\t# ottiene il nome del rc come un prefisso del nome pod).\n"
"\t\tkubectl describe pods frontend"

#: pkg/kubectl/cmd/drain.go:165
msgid ""
"\n"
"\t\t# Drain node \"foo\", even if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n"
"\t\t$ kubectl drain foo --force\n"
"\n"
"\t\t# As above, but abort if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a "
"grace period of 15 minutes.\n"
"\t\t$ kubectl drain foo --grace-period=900"
msgstr ""
"\n"
"\t\t# Drain node \"foo\", anche se ci sono i baccelli non gestiti da "
"ReplicationController, ReplicaSet, Job, DaemonSet o StatefulSet su di esso.\n"
"\t\t$ kubectl drain foo --force\n"
"\n"
"\t\t# Come sopra, ma interrompere se ci sono i baccelli non gestiti da "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, e "
"utilizzare un periodo di grazia di 15 minuti.\n"
"\t\t$ kubectl drain foo --grace-period=900"

#: pkg/kubectl/cmd/edit.go:80
msgid ""
"\n"
"\t\t# Edit the service named 'docker-registry':\n"
"\t\tkubectl edit svc/docker-registry\n"
"\n"
"\t\t# Use an alternative editor\n"
"\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n"
"\n"
"\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n"
"\t\tkubectl edit job.v1.batch/myjob -o json\n"
"\n"
"\t\t# Edit the deployment 'mydeployment' in YAML and save the modified config "
"in its annotation:\n"
"\t\tkubectl edit deployment/mydeployment -o yaml --save-config"
msgstr ""
"\n"
"\t\t# Modifica il servizio denominato 'docker-registry':\n"
"\t\tkubectl edit svc/docker-registry\n"
"\n"
"\t\t# Usa un editor alternativo\n"
"\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n"
"\n"
"\t\t# Modifica il lavoro 'myjob' in JSON utilizzando il formato API v1:\n"
"\t\tkubectl edit job.v1.batch/myjob -o json\n"
"\n"
"\t\t# Modifica la distribuzione 'mydeployment' in YAML e salvare la "
"configurazione modificata nella sua annotazione:\n"
"\t\tkubectl edit deployment/mydeployment -o yaml --save-config"

#: pkg/kubectl/cmd/exec.go:41
msgid ""
"\n"
"\t\t# Get output from running 'date' from pod 123456-7890, using the first "
"container by default\n"
"\t\tkubectl exec 123456-7890 date\n"
"\n"
"\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n"
"\t\tkubectl exec 123456-7890 -c ruby-container date\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il"
msgstr ""
"\n"
"\t\t# Ottieni l'output dalla 'data' di esecuzione del pod 123456-7890, "
"utilizzando il primo contenitore per impostazione predefinita\n"
"\t\tkubectl exec 123456-7890 date\n"
"\n"
"\t\t# Ottieni l'output dalla data di esecuzione in ruby-container del pod "
"123456-7890\n"
"\t\tkubectl exec 123456-7890 -c ruby-container date\n"
"\n"
"\t\t# Passare alla modalità raw terminal, invia stdin a 'bash' in ruby-"
"container del pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il"

#: pkg/kubectl/cmd/attach.go:42
msgid ""
"\n"
"\t\t# Get output from running pod 123456-7890, using the first container by "
"default\n"
"\t\tkubectl attach 123456-7890\n"
"\n"
"\t\t# Get output from ruby-container from pod 123456-7890\n"
"\t\tkubectl attach 123456-7890 -c ruby-container\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n"
"\n"
"\t\t# Get output from the first pod of a ReplicaSet named nginx\n"
"\t\tkubectl attach rs/nginx\n"
"\t\t"
msgstr ""
"\n"
"\t\t# Ottieni l'output dal pod 123456-7890 in esecuzione, utilizzando il "
"primo contenitore per impostazione predefinita\n"
"\t\tkubectl attach 123456-7890\n"
"\n"
"\t\t#  Ottieni l'output dal  ruby-container del pod 123456-7890\n"
"\t\tkubectl attach 123456-7890 -c ruby-container\n"
"\n"
"\t\t# Passa alla modalità raw terminal, invia stdin a 'bash' in ruby-"
"container del pod 123456-7890\n"
"\t\t# e invia stdout/stderr da 'bash' al client\n"
"\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n"
"\n"
"\t\t# Ottieni l'output dal primo pod di una ReplicaSet denominata nginx\n"
"\t\tkubectl attach rs/nginx\n"
"\t\t"

#: pkg/kubectl/cmd/explain.go:39
msgid ""
"\n"
"\t\t# Get the documentation of the resource and its fields\n"
"\t\tkubectl explain pods\n"
"\n"
"\t\t# Get the documentation of a specific field of a resource\n"
"\t\tkubectl explain pods.spec.containers"
msgstr ""
"\n"
"\t\t# Ottieni la documentazione della risorsa e i relativi campi\n"
"\t\tkubectl explain pods\n"
"\n"
"\t\t# Ottieni la documentazione di un campo specifico di una risorsa\n"
"\t\tkubectl explain pods.spec.containers"

#: pkg/kubectl/cmd/completion.go:65
msgid ""
"\n"
"\t\t# Install bash completion on a Mac using homebrew\n"
"\t\tbrew install bash-completion\n"
"\t\tprintf \"\n"
"# Bash completion support\n"
"source $(brew --prefix)/etc/bash_completion\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for bash into the current shell\n"
"\t\tsource <(kubectl completion bash)\n"
"\n"
"\t\t# Write bash completion code to a file and source if from .bash_profile\n"
"\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n"
"\t\tprintf \"\n"
"# Kubectl shell completion\n"
"source '$HOME/.kube/completion.bash.inc'\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for zsh[1] into the current shell\n"
"\t\tsource <(kubectl completion zsh)"
msgstr ""
"\n"
"\t\t# Installa il completamento di bash su un Mac utilizzando homebrew\n"
"\t\tbrew install bash-completion\n"
"\t\tprintf \"\n"
"# Bash completion support\n"
"source $(brew --prefix)/etc/bash_completion\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Carica il codice di completamento kubectl per bash nella shell "
"corrente\n"
"\t\tsource <(kubectl completion bash)\n"
"\n"
"\t\t# Scrive il codice di completamento bash in un file e lo carica da ."
"bash_profile\n"
"\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n"
"\t\tprintf \"\n"
"# Kubectl shell completion\n"
"source '$HOME/.kube/completion.bash.inc'\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Carica il codice di completamento kubectl per zsh [1] nella shell "
"corrente\n"
"\t\tsource <(kubectl completion zsh)"

#: pkg/kubectl/cmd/get.go:64
msgid ""
"\n"
"\t\t# List all pods in ps output format.\n"
"\t\tkubectl get pods\n"
"\n"
"\t\t# List all pods in ps output format with more information (such as node "
"name).\n"
"\t\tkubectl get pods -o wide\n"
"\n"
"\t\t# List a single replication controller with specified NAME in ps output "
"format.\n"
"\t\tkubectl get replicationcontroller web\n"
"\n"
"\t\t# List a single pod in JSON output format.\n"
"\t\tkubectl get -o json pod web-pod-13je7\n"
"\n"
"\t\t# List a pod identified by type and name specified in \"pod.yaml\" in "
"JSON output format.\n"
"\t\tkubectl get -f pod.yaml -o json\n"
"\n"
"\t\t# Return only the phase value of the specified pod.\n"
"\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n"
"\n"
"\t\t# List all replication controllers and services together in ps output "
"format.\n"
"\t\tkubectl get rc,services\n"
"\n"
"\t\t# List one or more resources by their type and names.\n"
"\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n"
"\n"
"\t\t# List all resources with different types.\n"
"\t\tkubectl get all"
msgstr ""
"\n"
"\t\t# Elenca tutti i pod in formato output ps.\n"
"\t\tkubectl get pods\n"
"\n"
"\t\t# Elenca tutti i pod in formato output ps con maggiori informazioni (ad "
"esempio il nome del nodo).\n"
"\t\tkubectl get pods -o wide\n"
"\n"
"\t\t# Elenca un controller di replica singolo con NAME specificato nel "
"formato di output ps.\n"
"\t\tkubectl get replicationcontroller web\n"
"\n"
"\t\t# Elenca un singolo pod nel formato di uscita JSON.\n"
"\t\tkubectl get -o json pod web-pod-13je7\n"
"\n"
"\t\t# Elenca un pod identificato per tipo e nome specificato in \"pod.yaml\" "
"nel formato di uscita JSON.\n"
"\t\tkubectl get -f pod.yaml -o json\n"
"\n"
"\t\t# Restituisce solo il valore di fase del pod specificato.\n"
"\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n"
"\n"
"\t\t# Elenca tutti i controller e servizi di replica insieme in formato "
"output ps.\n"
"\t\tkubectl get rc,services\n"
"\n"
"\t\t# Elenca una o più risorse per il tipo e per i nomi.\n"
"\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n"
"\n"
"\t\t# Elenca tutte le risorse con tipi diversi.\n"
"\t\tkubectl get all"

#: pkg/kubectl/cmd/portforward.go:53
msgid ""
"\n"
"\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports "
"5000 and 6000 in the pod\n"
"\t\tkubectl port-forward mypod 5000 6000\n"
"\n"
"\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 8888:5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod :5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 0:5000"
msgstr ""
"\n"
"\t\t# Ascolta localmente le porte 5000 e 6000, inoltrando i dati da/verso le "
"porte 5000 e 6000 nel pod\n"
"\t\tkubectl port-forward mypod 5000 6000\n"
"\n"
"\t\t# Ascolta localmente la porta 8888, inoltra a 5000 nel pod\n"
"\t\tkubectl port-forward mypod 8888:5000\n"
"\n"
"\t\t# Ascolta localmente una porta casuale, inoltra a 5000 nel pod\n"
"\t\tkubectl port-forward mypod :5000\n"
"\n"
"\t\t# Ascolta localmente una porta casuale, inoltra a 5000 nel pod\n"
"\t\tkubectl port-forward mypod 0:5000"

#: pkg/kubectl/cmd/drain.go:118
msgid ""
"\n"
"\t\t# Mark node \"foo\" as schedulable.\n"
"\t\t$ kubectl uncordon foo"
msgstr ""
"\n"
"\t\t# Segna il nodo \"foo\" come programmabile.\n"
"\t\t$ Kubectl uncordon foo"

#: pkg/kubectl/cmd/drain.go:93
msgid ""
"\n"
"\t\t# Mark node \"foo\" as unschedulable.\n"
"\t\tkubectl cordon foo"
msgstr ""
"\n"
"\t\t#  Segna il nodo \"foo\" come non programmabile.\n"
"\t\tkubectl cordon foo"

#: pkg/kubectl/cmd/patch.go:66
msgid ""
"\n"
"\t\t# Partially update a node using strategic merge patch\n"
"\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Partially update a node identified by the type and name specified in "
"\"node.json\" using strategic merge patch\n"
"\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Update a container's image; spec.containers[*].name is required because "
"it's a merge key\n"
"\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":"
"\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n"
"\n"
"\t\t# Update a container's image using a json patch with positional arrays\n"
"\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", "
"\"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'"
msgstr ""
"\n"
"\t\t# Aggiorna parzialmente un nodo utilizzando merge patch strategica\n"
"\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Aggiorna parzialmente un nodo identificato dal tipo e dal nome "
"specificato in \"node.json\" utilizzando  merge patch strategica\n"
"\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Aggiorna l'immagine di un contenitore; spec.containers [*]. name è "
"richiesto perché è una chiave di fusione\n"
"\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":"
"\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n"
"\n"
"\t\t# Aggiorna l'immagine di un contenitore utilizzando una patch json con "
"array posizionali\n"
"\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", "
"\"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'"

#: pkg/kubectl/cmd/options.go:29
msgid ""
"\n"
"\t\t# Print flags inherited by all commands\n"
"\t\tkubectl options"
msgstr ""
"\n"
"\t\t# Stampa i flag ereditati da tutti i comandi\n"
"\t\tkubectl options"

#: pkg/kubectl/cmd/clusterinfo.go:41
msgid ""
"\n"
"\t\t# Print the address of the master and cluster services\n"
"\t\tkubectl cluster-info"
msgstr ""
"\n"
"\t\t# Stampa l'indirizzo dei servizi master e cluster\n"
"\t\tkubectl cluster-info"

#: pkg/kubectl/cmd/version.go:32
msgid ""
"\n"
"\t\t# Print the client and server versions for the current context\n"
"\t\tkubectl version"
msgstr ""
"\n"
"\t\t# Stampa le versioni client e server per il current context\n"
"\t\tkubectl version"

#: pkg/kubectl/cmd/apiversions.go:34
msgid ""
"\n"
"\t\t# Print the supported API versions\n"
"\t\tkubectl api-versions"
msgstr ""
"\n"
"\t\t# Stampa le versioni API supportate\n"
"\t\tkubectl api-versions"

#: pkg/kubectl/cmd/replace.go:50
msgid ""
"\n"
"\t\t# Replace a pod using the data in pod.json.\n"
"\t\tkubectl replace -f ./pod.json\n"
"\n"
"\t\t# Replace a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl replace -f -\n"
"\n"
"\t\t# Update a single-container pod's image version (tag) to v4\n"
"\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/:v4/' | "
"kubectl replace -f -\n"
"\n"
"\t\t# Force replace, delete and then re-create the resource\n"
"\t\tkubectl replace --force -f ./pod.json"
msgstr ""
"\n"
"\t\t# Sostituire un pod utilizzando i dati in pod.json.\n"
"\t\tkubectl replace -f ./pod.json\n"
"\n"
"\t\t# Sostituire un pod usando il JSON passato da stdin.\n"
"\t\tcat pod.json | kubectl replace -f -\n"
"\n"
"\t\t# Aggiorna la versione dell'immagine (tag) di un singolo container di pod "
"a v4\n"
"\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/:v4/' | "
"kubectl replace -f -\n"
"\n"
"\t\t# Forza la sostituzione, cancellazione e quindi ricreare la risorsa\n"
"\t\tkubectl replace --force -f ./pod.json"

#: pkg/kubectl/cmd/logs.go:40
msgid ""
"\n"
"\t\t# Return snapshot logs from pod nginx with only one container\n"
"\t\tkubectl logs nginx\n"
"\n"
"\t\t# Return snapshot logs for the pods defined by label app=nginx\n"
"\t\tkubectl logs -lapp=nginx\n"
"\n"
"\t\t# Return snapshot of previous terminated ruby container logs from pod "
"web-1\n"
"\t\tkubectl logs -p -c ruby web-1\n"
"\n"
"\t\t# Begin streaming the logs of the ruby container in pod web-1\n"
"\t\tkubectl logs -f -c ruby web-1\n"
"\n"
"\t\t# Display only the most recent 20 lines of output in pod nginx\n"
"\t\tkubectl logs --tail=20 nginx\n"
"\n"
"\t\t# Show all logs from pod nginx written in the last hour\n"
"\t\tkubectl logs --since=1h nginx\n"
"\n"
"\t\t# Return snapshot logs from first container of a job named hello\n"
"\t\tkubectl logs job/hello\n"
"\n"
"\t\t# Return snapshot logs from container nginx-1 of a deployment named "
"nginx\n"
"\t\tkubectl logs deployment/nginx -c nginx-1"
msgstr ""
"\n"
"\t\t# Restituisce snapshot log dal pod nginx con un solo container\n"
"\t\tkubectl logs nginx\n"
"\n"
"\t\t# Restituisce snapshot log dei pod definiti dalla label app=nginx\n"
"\t\tkubectl logs -lapp=nginx\n"
"\n"
"\t\t# Restituisce snapshot log del container ruby  terminato nel pod web-1\n"
"\t\tkubectl logs -p -c ruby web-1\n"
"\n"
"\t\t# Iniziare a trasmettere i log del contenitore ruby nel pod web-1\n"
"\t\tkubectl logs -f -c ruby web-1\n"
"\n"
"\t\t# Visualizza solo le ultime 20 righe di output del pod nginx\n"
"\t\tkubectl logs --tail=20 nginx\n"
"\n"
"\t\t# Mostra tutti i log del pod nginx scritti nell'ultima ora\n"
"\t\tkubectl logs --since=1h nginx\n"
"\n"
"\t\t# Restituisce snapshot log dal primo contenitore di un lavoro chiamato "
"hello\n"
"\t\tkubectl logs job/hello\n"
"\n"
"\t\t# Restituisce snapshot logs del container nginx-1 del deployment chiamato "
"nginx\n"
"\t\tkubectl logs deployment/nginx -c nginx-1"

#: pkg/kubectl/cmd/proxy.go:53
msgid ""
"\n"
"\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static "
"content from ./local/www/\n"
"\t\tkubectl proxy --port=8011 --www=./local/www/\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n"
"\t\t# The chosen port for the server will be output to stdout.\n"
"\t\tkubectl proxy --port=0\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-"
"api\n"
"\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/"
"pods/\n"
"\t\tkubectl proxy --api-prefix=/k8s-api"
msgstr ""
"\n"
"\t\t# Esegui un proxy verso kubernetes apiserver sulla porta 8011, che "
"fornisce contenuti statici da ./local/www/\n"
"\t\tkubectl proxy --port=8011 --www=./local/www/\n"
"\n"
"\t\t# Esegui un proxy verso kubernetes apiserver su una porta locale "
"arbitraria.\n"
"\t\t# La porta selezionata per il server verrà inviata a stdout.\n"
"\t\tkubectl proxy --port=0\n"
"\n"
"\t\t# Esegui un proxy verso kubernetes apiserver, cambiando il prefisso api "
"in k8s-api\n"
"\t\t# Questo comporta, ad es., pod api disponibili presso localhost:8001/k8s-"
"api/v1/pods/\n"
"\t\tkubectl proxy --api-prefix=/k8s-api"

#: pkg/kubectl/cmd/scale.go:43
msgid ""
"\n"
"\t\t# Scale a replicaset named 'foo' to 3.\n"
"\t\tkubectl scale --replicas=3 rs/foo\n"
"\n"
"\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" "
"to 3.\n"
"\t\tkubectl scale --replicas=3 -f foo.yaml\n"
"\n"
"\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n"
"\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n"
"\n"
"\t\t# Scale multiple replication controllers.\n"
"\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n"
"\n"
"\t\t# Scale job named 'cron' to 3.\n"
"\t\tkubectl scale --replicas=3 job/cron"
msgstr ""
"\n"
"\t\t# Scala un replicaset denominato 'foo' a 3.\n"
"\t\tkubectl scale --replicas=3 rs/foo\n"
"\n"
"\t\t# Scala una risorsa identificata per tipo e nome specificato in \"foo.yaml"
"\" a 3.\n"
"\t\tkubectl scale --replicas=3 -f foo.yaml\n"
"\n"
"\t\t#  Se la distribuzione corrente di mysql è 2, scala mysql a 3.\n"
"\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n"
"\n"
"\t\t# Scalare più controllori di replica.\n"
"\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n"
"\n"
"\t\t# Scala il lavoro denominato 'cron' a 3.\n"
"\t\tkubectl scale --replicas=3 job/cron"

#: pkg/kubectl/cmd/apply_set_last_applied.go:67
msgid ""
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml\n"
"\n"
"\t\t# Execute set-last-applied against each configuration file in a "
"directory.\n"
"\t\tkubectl apply set-last-applied -f path/\n"
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file, will create the annotation if it does not already exist.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n"
"\t\t"
msgstr ""
"\n"
"\t\t# Imposta l'ultima-configurazione-applicata di una risorsa che "
"corrisponda al contenuto di un file.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml\n"
"\n"
"\t\t# Esegue set-last-applied per ogni file di configurazione in una "
"directory.\n"
"\t\tkubectl apply set-last-applied -f path/\n"
"\n"
"\t\t# Imposta la configurazione dell'ultima applicazione di una risorsa che "
"corrisponda al contenuto di un file, creerà l'annotazione se non esiste già.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n"
"\t\t"

#: pkg/kubectl/cmd/top_pod.go:61
msgid ""
"\n"
"\t\t# Show metrics for all pods in the default namespace\n"
"\t\tkubectl top pod\n"
"\n"
"\t\t# Show metrics for all pods in the given namespace\n"
"\t\tkubectl top pod --namespace=NAMESPACE\n"
"\n"
"\t\t# Show metrics for a given pod and its containers\n"
"\t\tkubectl top pod POD_NAME --containers\n"
"\n"
"\t\t# Show metrics for the pods defined by label name=myLabel\n"
"\t\tkubectl top pod -l name=myLabel"
msgstr ""
"\n"
"\t\t# Mostra metriche di tutti i pod nello spazio dei nomi predefinito\n"
"\t\tkubectl top pod\n"
"\n"
"\t\t# Mostra metriche di tutti i pod nello spazio dei nomi specificato\n"
"\t\tkubectl top pod --namespace=NAMESPACE\n"
"\n"
"\t\t# Mostra metriche per un pod e i suoi relativi container\n"
"\t\tkubectl top pod POD_NAME --containers\n"
"\n"
"\t\t# Mostra metriche per i pod definiti da label name = myLabel\n"
"\t\tkubectl top pod -l name=myLabel"

#: pkg/kubectl/cmd/stop.go:40
msgid ""
"\n"
"\t\t# Shut down foo.\n"
"\t\tkubectl stop replicationcontroller foo\n"
"\n"
"\t\t# Stop pods and services with label name=myLabel.\n"
"\t\tkubectl stop pods,services -l name=myLabel\n"
"\n"
"\t\t# Shut down the service defined in service.json\n"
"\t\tkubectl stop -f service.json\n"
"\n"
"\t\t# Shut down all resources in the path/to/resources directory\n"
"\t\tkubectl stop -f path/to/resources"
msgstr ""
"\n"
"\t\t# Spegni foo.\n"
"\t\tkubectl stop replicationcontroller foo\n"
"\n"
"\t\t# Stop di tutti i pod e servizi con label name=myLabel.\n"
"\t\tkubectl stop pods,services -l name=myLabel\n"
"\n"
"\t\t# Spegnere il servizio definito in service.json\n"
"\t\tkubectl stop -f service.json\n"
"\n"
"\t\t# Spegnere tutte le resources in path/to/resources directory\n"
"\t\tkubectl stop -f path/to/resources"

#: pkg/kubectl/cmd/run.go:57
msgid ""
"\n"
"\t\t# Start a single instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx\n"
"\n"
"\t\t# Start a single instance of hazelcast and let the container expose port "
"5701 .\n"
"\t\tkubectl run hazelcast --image=hazelcast --port=5701\n"
"\n"
"\t\t# Start a single instance of hazelcast and set environment variables "
"\"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n"
"\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --"
"env=\"POD_NAMESPACE=default\"\n"
"\n"
"\t\t# Start a replicated instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx --replicas=5\n"
"\n"
"\t\t# Dry run. Print the corresponding API objects without creating them.\n"
"\t\tkubectl run nginx --image=nginx --dry-run\n"
"\n"
"\t\t# Start a single instance of nginx, but overload the spec of the "
"deployment with a partial set of values parsed from JSON.\n"
"\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", "
"\"spec\": { ... } }'\n"
"\n"
"\t\t# Start a pod of busybox and keep it in the foreground, don't restart it "
"if it exits.\n"
"\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n"
"\n"
"\t\t# Start the nginx container using the default command, but use custom "
"arguments (arg1 .. argN) for that command.\n"
"\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n"
"\n"
"\t\t# Start the nginx container using a different command and custom "
"arguments.\n"
"\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n"
"\n"
"\t\t# Start the perl container to compute π to 2000 places and print it out.\n"
"\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle "
"'print bpi(2000)'\n"
"\n"
"\t\t# Start the cron job to compute π to 2000 places and print it out every 5 "
"minutes.\n"
"\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --"
"restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'"
msgstr ""
"\n"
"\t\t# Avviare un'unica istanza di nginx.\n"
"\t\tkubectl run nginx --image=nginx\n"
"\n"
"\t\t# Avviare un'unica istanza di hazelcast e lasciare che il container  "
"esponga la porta 5701.\n"
"\t\tkubectl run hazelcast --image=hazelcast --port=5701\n"
"\n"
"\t\t# Avviare una singola istanza di hazelcast ed imposta le variabili "
"ambiente \"DNS_DOMAIN=cluster\" e \"POD_NAMESPACE=default\" nel container.\n"
"\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --"
"env=\"POD_NAMESPACE=default\"\n"
"\n"
"\t\t# Avviare un'istanza replicata di nginx.\n"
"\t\tkubectl run nginx --image=nginx --replicas=5\n"
"\n"
"\t\t# Dry run. Stampare gli oggetti API corrispondenti senza crearli.\n"
"\t\tkubectl run nginx --image=nginx --dry-run\n"
"\n"
"\t\t# Avviare un'unica istanza di nginx, ma overload  le spec  del "
"deployment  con un insieme parziale di valori analizzati da JSON.\n"
"\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", "
"\"spec\": { ... } }'\n"
"\n"
"\t\t# Avviare un pod di busybox e tenerlo in primo piano, non riavviarlo se "
"esce.\n"
"\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n"
"\n"
"\t\t# Avviare il container nginx utilizzando il comando predefinito, ma "
"utilizzare argomenti personalizzati (arg1 .. argN) per quel comando.\n"
"\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n"
"\n"
"\t\t# Avviare il container  nginx utilizzando un diverso comando e argomenti "
"personalizzati.\n"
"\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n"
"\n"
"\t\t# Avviare il contenitore perl per calcolare π a 2000 posti e stamparlo.\n"
"\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle "
"'print bpi(2000)'\n"
"\n"
"\t\t# Avviare il cron job per calcolare π a 2000 posti e stampare ogni 5 "
"minuti.\n"
"\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --"
"restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'"

#: pkg/kubectl/cmd/taint.go:67
msgid ""
"\n"
"\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-"
"user' and effect 'NoSchedule'.\n"
"\t\t# If a taint with that key and effect already exists, its value is "
"replaced as specified.\n"
"\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n"
"\n"
"\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect "
"'NoSchedule' if one exists.\n"
"\t\tkubectl taint nodes foo dedicated:NoSchedule-\n"
"\n"
"\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n"
"\t\tkubectl taint nodes foo dedicated-"
msgstr ""
"\n"
"\t\t# Aggiorna il nodo \"foo\" con un marcatore con il tasto 'dedicated' e il "
"valore 'special-user' ed effettua 'NoSchedule'.\n"
"\t\t# Se un marcatore con quel tasto e l'effetto già esiste, il suo valore "
"viene sostituito come specificato.\n"
"\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n"
"\n"
"\t\t# Rimuove dal nodo 'foo' il marcatore con il tasto 'dedicated' ed "
"effettua 'NoSchedule' se esiste.\n"
"\t\tkubectl taint nodes foo dedicated:NoSchedule-\n"
"\n"
"\t\t# Rimuovi dal nodo 'foo' tutti i marcatori con chiave 'dedicated'\n"
"\t\tkubectl taint nodes foo dedicated-"

#: pkg/kubectl/cmd/label.go:77
msgid ""
"\n"
"\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n"
"\t\tkubectl label pods foo unhealthy=true\n"
"\n"
"\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', "
"overwriting any existing value.\n"
"\t\tkubectl label --overwrite pods foo status=unhealthy\n"
"\n"
"\t\t# Update all pods in the namespace\n"
"\t\tkubectl label pods --all status=unhealthy\n"
"\n"
"\t\t# Update a pod identified by the type and name in \"pod.json\"\n"
"\t\tkubectl label -f pod.json status=unhealthy\n"
"\n"
"\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n"
"\t\tkubectl label pods foo status=unhealthy --resource-version=1\n"
"\n"
"\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n"
"\t\t# Does not require the --overwrite flag.\n"
"\t\tkubectl label pods foo bar-"
msgstr ""
"\n"
"\t\t# Aggiorna il pod 'foo' con l'etichetta 'unhealthy' e il valore 'true'.\n"
"\t\tkubectl label pods foo unhealthy=true\n"
"\n"
"\t\t# Aggiorna il pod 'foo' con l'etichetta 'status' e il valore 'unhealthy', "
"sovrascrivendo qualsiasi valore esistente.\n"
"\t\tkubectl label --overwrite pods foo status=unhealthy\n"
"\n"
"\t\t# Aggiorna tutti i pod nello spazio dei nomi\n"
"\t\tkubectl label pods --all status=unhealthy\n"
"\n"
"\t\t# Aggiorna un pod identificato dal tipo e dal nome in \"pod.json\"\n"
"\t\tkubectl label -f pod.json status=unhealthy\n"
"\n"
"\t\t# Aggiorna il pod 'foo' solo se la risorsa è invariata dalla versione 1.\n"
"\t\tkubectl label pods foo status=unhealthy --resource-version=1\n"
"\n"
"\t\t#  Aggiorna il pod 'foo' rimuovendo un'etichetta denominata 'bar' se "
"esiste.\n"
"\t\t# Non richiede la flag -overwrite.\n"
"\t\tkubectl label pods foo bar-"

#: pkg/kubectl/cmd/rollingupdate.go:54
msgid ""
"\n"
"\t\t# Update pods of frontend-v1 using new replication controller data in "
"frontend-v2.json.\n"
"\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n"
"\n"
"\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n"
"\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n"
"\n"
"\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the "
"image, and switching the\n"
"\t\t# name of the replication controller.\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n"
"\n"
"\t\t# Update the pods of frontend by just changing the image, and keeping the "
"old name.\n"
"\t\tkubectl rolling-update frontend --image=image:v2\n"
"\n"
"\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to "
"frontend-v2).\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback"
msgstr ""
"\n"
"\t\t# Aggiorna i pod di frontend-v1 usando i dati del replication controller "
"in frontend-v2.json.\n"
"\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n"
"\n"
"\t\t# Aggiorna i pod di frontend-v1 usando i dati JSON passati da stdin.\n"
"\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n"
"\n"
"\t\t# Aggiorna i pod di frontend-v1 in frontend-v2  solo cambiando l'immagine "
"e modificando\n"
"\t\t# il nome del replication controller.\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n"
"\n"
"\t\t# Aggiorna i pod di frontend solo cambiando l'immaginee mantenendo il "
"vecchio none.\n"
"\t\tkubectl rolling-update frontend --image=image:v2\n"
"\n"
"\t\t#  Interrompee ed invertire un rollout esistente in corso (da frontend-v1 "
"a frontend-v2).\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback"

#: pkg/kubectl/cmd/apply_view_last_applied.go:52
msgid ""
"\n"
"\t\t# View the last-applied-configuration annotations by type/name in YAML.\n"
"\t\tkubectl apply view-last-applied deployment/nginx\n"
"\n"
"\t\t# View the last-applied-configuration annotations by file in JSON\n"
"\t\tkubectl apply view-last-applied -f deploy.yaml -o json"
msgstr ""
"\n"
"\t\t# Visualizza le annotazioni dell'ultima-configurazione-applicata per tipo/"
"nome in YAML.\n"
"\t\tkubectl apply view-last-applied deployment/nginx\n"
"\n"
"\t\t# # Visualizza le annotazioni dell'ultima-configurazione-applicata per "
"file in JSON.\n"
"\t\tkubectl apply view-last-applied -f deploy.yaml -o json"

#: pkg/kubectl/cmd/apply.go:75
msgid ""
"\n"
"\t\tApply a configuration to a resource by filename or stdin.\n"
"\t\tThis resource will be created if it doesn't exist yet.\n"
"\t\tTo use 'apply', always create the resource initially with either 'apply' "
"or 'create --save-config'.\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not "
"use unless you are aware of what the current state is. See https://issues.k8s."
"io/34274."
msgstr ""
"\n"
"\t\tApplicare una configurazione a una risorsa per nomefile o stdin.\n"
"\t\tQuesta risorsa verrà creata se non esiste ancora.\n"
"\t\tPer utilizzare 'apply', creare sempre la risorsa inizialmente con 'apply' "
"o 'create --save-config'.\n"
"\n"
"\t\tSono accettati i formati JSON e YAML.\n"
"\n"
"\t\tDisclaimer Alpha: la funzionalità --prune non è ancora completa. Non "
"utilizzare a meno che non si sia a conoscenza di quale sia lo stato attuale. "
"Vedi https://issues.k8s.io/34274."

#: pkg/kubectl/cmd/convert.go:38
msgid ""
"\n"
"\t\tConvert config files between different API versions. Both YAML\n"
"\t\tand JSON formats are accepted.\n"
"\n"
"\t\tThe command takes filename, directory, or URL as input, and convert it "
"into format\n"
"\t\tof version specified by --output-version flag. If target version is not "
"specified or\n"
"\t\tnot supported, convert to latest version.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use -"
"o option\n"
"\t\tto change to output destination."
msgstr ""
"\n"
"\t\tConvertire i file di configurazione tra diverse versioni API. Sono\n"
"\t\taccettati i formati YAML e JSON.\n"
"\n"
"\t\tIl comando prende il nome di file, la directory o l'URL come input e lo "
"converte nel formato\n"
"\t\tdi versione specificata dal flag -output-version. Se la versione di "
"destinazione non è specificata o\n"
"\t\tnon supportata, viene convertita nella versione più recente.\n"
"\n"
"\t\tL'output predefinito verrà stampato su stdout nel formato YAML. Si può "
"usare l'opzione -o\n"
"\t\tper cambiare la destinazione di output."

#: pkg/kubectl/cmd/create_clusterrole.go:31
msgid ""
"\n"
"\t\tCreate a ClusterRole."
msgstr ""
"\n"
"\t\n"
"Crea un ClusterRole."

#: pkg/kubectl/cmd/create_clusterrolebinding.go:32
msgid ""
"\n"
"\t\tCreate a ClusterRoleBinding for a particular ClusterRole."
msgstr ""
"\n"
"\t\tCrea un ClusterRoleBinding per un ClusterRole particolare."

#: pkg/kubectl/cmd/create_rolebinding.go:32
msgid ""
"\n"
"\t\tCreate a RoleBinding for a particular Role or ClusterRole."
msgstr ""
"\n"
"\t\tCrea un RoleBinding per un particolare Ruolo o ClusterRole."

#: pkg/kubectl/cmd/create_secret.go:200
msgid ""
"\n"
"\t\tCreate a TLS secret from the given public/private key pair.\n"
"\n"
"\t\tThe public/private key pair must exist before hand. The public key "
"certificate must be .PEM encoded and match the given private key."
msgstr ""
"\n"
"\t\tCrea un TLS secret dalla coppia di chiavi pubblica/privata.\n"
"\n"
"\t\tLa coppia di chiavi pubblica/privata deve esistere prima. Il certificato "
"chiave pubblica deve essere .PEM codificato e corrispondere alla chiave "
"privata data."

#: pkg/kubectl/cmd/create_configmap.go:32
msgid ""
"\n"
"\t\tCreate a configmap based on a file, directory, or specified literal "
"value.\n"
"\n"
"\t\tA single configmap may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a configmap based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a configmap based on a directory, each file whose basename "
"is a valid key in the directory will be\n"
"\t\tpackaged into the configmap.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."
msgstr ""
"\n"
"\t\tCreare un configmap basato su un file, una directory o un valore literal "
"specificato.\n"
"\n"
"\t\tUn singolo configmap può includere una o più coppie chiave/valore.\n"
"\n"
"\t\tQuando si crea una configmap basata su un file, il valore predefinito "
"sarà il nome di base del file e il valore sarà\n"
"\t\tpredefinito per il contenuto del file. Se il nome di base è una chiave "
"non valida, è possibile specificare un tasto alternativo.\n"
"\n"
"\t\tQuando si crea un configmap basato su una directory, ogni file il cui "
"nome di base è una chiave valida nella directory verrà\n"
"\t\tpacchettizzata nel configmap. Le voci di directory tranne i file regolari "
"vengono ignorati (ad esempio sottodirectory,\n"
"\t\tsymlinks, devices, pipes, ecc)."

#: pkg/kubectl/cmd/create_namespace.go:32
msgid ""
"\n"
"\t\tCreate a namespace with the specified name."
msgstr ""
"\n"
"\t\tCreare un namespace con il nome specificato."

#: pkg/kubectl/cmd/create_secret.go:119
msgid ""
"\n"
"\t\tCreate a new secret for use with Docker registries.\n"
"\n"
"\t\tDockercfg secrets are used to authenticate against Docker registries.\n"
"\n"
"\t\tWhen using the Docker command line to push images, you can authenticate "
"to a given registry by running\n"
"\n"
"\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --"
"password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n"
"\n"
"    That produces a ~/.dockercfg file that is used by subsequent 'docker "
"push' and 'docker pull' commands to\n"
"\t\tauthenticate to the registry. The email address is optional.\n"
"\n"
"\t\tWhen creating applications, you may have a Docker registry that requires "
"authentication.  In order for the\n"
"\t\tnodes to pull images on your behalf, they have to have the credentials.  "
"You can provide this information\n"
"\t\tby creating a dockercfg secret and attaching it to your service account."
msgstr ""
"\n"
"\t\tCreare un nuovo secret per l'utilizzo con i registri Docker.\n"
"\n"
"\t\tDockercfg secrets vengono utilizzati per autenticare i registri Docker.\n"
"\n"
"\t\tQuando utilizzi la riga di comando Docker per il push delle immagini, è "
"possibile eseguire l'autenticazione eseguendo correttamente un determinato "
"registry\n"
"\n"
"\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --"
"password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n"
"\n"
"    Questo produce un file ~ / .dockercfg che viene utilizzato dai successivi "
"comandi \"docker push\" e \"docker pull\"\n"
"\t\tper autenticarsi nel registry. L'indirizzo email è facoltativo.\n"
"\n"
"\t\tDurante la creazione di applicazioni, è possibile avere un Docker "
"registry che richiede l'autenticazione. Affinché i \n"
"\t\tnodi eseguano pull di immagini per vostro conto, devono avere le "
"credenziali. È possibile fornire queste informazioni \n"
"\t\tcreando un dockercfg secret e collegandolo al tuo account di servizio."

#: pkg/kubectl/cmd/create_pdb.go:32
msgid ""
"\n"
"\t\tCreate a pod disruption budget with the specified name, selector, and "
"desired minimum available pods"
msgstr ""
"\n"
"\t\tCrea un pod disruption budget con il nome specificato, selector e il "
"numero minimo di pod disponibili"

#: pkg/kubectl/cmd/create.go:42
msgid ""
"\n"
"\t\tCreate a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted."
msgstr ""
"\n"
"\t\tCrea una risorsa per nome file o stdin.\n"
"\n"
"\t\tSono accettati i formati JSON e YAML."

#: pkg/kubectl/cmd/create_quota.go:32
msgid ""
"\n"
"\t\tCreate a resourcequota with the specified name, hard limits and optional "
"scopes"
msgstr ""
"\n"
"\t\tCrea una resourcequota con il nome specificato, hard limits e gli scope "
"opzionali"

#: pkg/kubectl/cmd/create_role.go:38
msgid ""
"\n"
"\t\tCreate a role with single rule."
msgstr ""
"\n"
"\t\tCrea un ruolo con una singola regola."

#: pkg/kubectl/cmd/create_secret.go:47
msgid ""
"\n"
"\t\tCreate a secret based on a file, directory, or specified literal value.\n"
"\n"
"\t\tA single secret may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a secret based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a secret based on a directory, each file whose basename is "
"a valid key in the directory will be\n"
"\t\tpackaged into the secret.  Any directory entries except regular files are "
"ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."
msgstr ""
"\n"
"\t\tCrea un secret basato su un file, una directory o un valore specifico "
"literal.\n"
"\n"
"\t\tUn singolo secret  può includere una o più coppie chiave/valore.\n"
"\n"
"\t\tQuando si crea un secret basato su un file, la chiave per impostazione "
"predefinita sarà il nome di base del file e il valore sarà\n"
"\t\tpredefinito al contenuto del file. Se il nome di base è una chiave non "
"valida, è possibile specificare un tasto alternativo.\n"
"\n"
"\n"
"\t\tQuando si crea un segreto basato su una directory, ogni file il cui nome "
"di base è una chiave valida nella directory verrà \n"
"\t\\paccehttizzataw in un secret.   Le voci di directory tranne i file "
"regolari vengono ignorati (ad esempio sottodirectory,\n"
"\t\tsymlinks, devices, pipes, ecc)."

#: pkg/kubectl/cmd/create_serviceaccount.go:32
msgid ""
"\n"
"\t\tCreate a service account with the specified name."
msgstr ""
"\n"
"\t\tCreare un service account con il nome specificato."

#: pkg/kubectl/cmd/run.go:52
msgid ""
"\n"
"\t\tCreate and run a particular image, possibly replicated.\n"
"\n"
"\t\tCreates a deployment or job to manage the created container(s)."
msgstr ""
"\n"
"\t\tCrea ed esegue un'immagine particolare, eventualmente replicata.\n"
"\n"
"\t\tCrea un deployment o un job per gestire i container creati."

#: pkg/kubectl/cmd/autoscale.go:34
msgid ""
"\n"
"\t\tCreates an autoscaler that automatically chooses and sets the number of "
"pods that run in a kubernetes cluster.\n"
"\n"
"\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and "
"creates an autoscaler that uses the given resource as a reference.\n"
"\t\tAn autoscaler can automatically increase or decrease number of pods "
"deployed within the system as needed."
msgstr ""
"\n"
"\t\tCrea un autoscaler che automaticamente sceglie e imposta il numero di pod "
"che vengono eseguiti in un cluster di kubernets.\n"
"\n"
"\t\tEsegue una ricerca di un Deployment, ReplicaSet o ReplicationController "
"per nome e crea un autoscaler che utilizza la risorsa indicata come "
"riferimento.\n"
"\t\tUn autoscaler può aumentare o diminuire automaticamente il numero di pod "
"distribuiti all'interno del sistema se necessario."

#: pkg/kubectl/cmd/delete.go:40
msgid ""
"\n"
"\t\tDelete resources by filenames, stdin, resources and names, or by "
"resources and label selector.\n"
"\n"
"\t\tJSON and YAML formats are accepted. Only one type of the arguments may be "
"specified: filenames,\n"
"\t\tresources and names, or resources and label selector.\n"
"\n"
"\t\tSome resources, such as pods, support graceful deletion. These resources "
"define a default period\n"
"\t\tbefore they are forcibly terminated (the grace period) but you may "
"override that value with\n"
"\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. "
"Because these resources often\n"
"\t\trepresent entities in the cluster, deletion may not be acknowledged "
"immediately. If the node\n"
"\t\thosting a pod is down or cannot reach the API server, termination may "
"take significantly longer\n"
"\t\tthan the grace period. To force delete a resource,\tyou must pass a grace"
"\tperiod of 0 and specify\n"
"\t\tthe --force flag.\n"
"\n"
"\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the "
"pod's processes have been\n"
"\t\tterminated, which can leave those processes running until the node "
"detects the deletion and\n"
"\t\tcompletes graceful deletion. If your processes use shared storage or talk "
"to a remote API and\n"
"\t\tdepend on the name of the pod to identify themselves, force deleting "
"those pods may result in\n"
"\t\tmultiple processes running on different machines using the same "
"identification which may lead\n"
"\t\tto data corruption or inconsistency. Only force delete pods when you are "
"sure the pod is\n"
"\t\tterminated, or if your application can tolerate multiple copies of the "
"same pod running at once.\n"
"\t\tAlso, if you force delete pods the scheduler may place new pods on those "
"nodes before the node\n"
"\t\thas released those resources and causing those pods to be evicted "
"immediately.\n"
"\n"
"\t\tNote that the delete command does NOT do resource version checks, so if "
"someone\n"
"\t\tsubmits an update to a resource right when you submit a delete, their "
"update\n"
"\t\twill be lost along with the rest of the resource."
msgstr ""
"\n"
"\t\tCancella risorse secondo nomi di file, stdin, risorse e nomi, o per "
"selettori di risorse e etichette.\n"
"\n"
"\t\tSono accettati i formati JSON e YAML. È possibile specificare un solo "
"tipo di argomenti: nome file,\n"
"\t\trisorse e nomi, o risorse e selettore di etichette.\n"
"\n"
"\t\tAlcune risorse, come i pod, supportano cacellazione corretta. Queste "
"risorse definiscono un periodo di default\n"
"\t\tprima che siano forzatamente terminate (il grace period) ma si può "
"sostituire quel valore con\n"
"\t\til falg --grace-period, o passare --now per impostare il grace-period a "
"1. Poiché queste risorse spesso\n"
"\t\trappresentano entità del cluster, la cancellazione non può essere presa "
"in carico immediatamente. Se il nodo\n"
"\t\tche ospita un pod è spento o non raggiungibile da API server, termination "
"può richiedere molto più tempo\n"
"\t\tdel grace period. Per forzare la cancellazione di una resource,\tdevi "
"obbligatoriamente indicare un grace\tperiod di 0 e specificare\n"
"\t\til flag --force.\n"
"\n"
"\t\tIMPORTANTE: Fozare la cancellazione dei pod non attende conferma che i "
"processi del pod siano\n"
"\t\tterminati, che può lasciare questi processi in esecuzione fino a quando "
"il nodo rileva la cancellazione\n"
"\t\tcompletata correttamente. Se i tuoi processi utilizzano l'archiviazione "
"condivisa o parlano con un'API remota e\n"
"\t\tdipendono dal nome del pod per identificarsi, la forzata eliminazione di "
"questi pod può comportare\n"
"\t\tpiù processi in esecuzione su macchine diverse che utilizzando la stessa "
"identificazione che può portare\n"
"\t\tcorruzione o inconsistenza dei dati. Forza i pod solo quando si è sicuri "
"che il pod sia\n"
"\t\tterminato, o se la tua applicazione può can tollerare più copie dello "
"stesso pod in esecuzione contemporaneamente.\n"
"\t\tInoltre, se forzate l'eliminazione dei i nodi, lo scheduler può può "
"creare nuovi nodi su questi nodi prima che il nodo\n"
"\t\tabbia liberato quelle risorse e provocando immediatamente evict di tali "
"pod.\n"
"\n"
"\n"
"\t\tNotare che il comando di eliminazione NON fa verificare la versione delle "
"risorse, quindi se qualcuno\n"
"\t\tinvia un aggiornamento ad una risorsa quando invii un eliminazione, il "
"loro aggiornamento\n"
"\t\tsaranno persi insieme al resto della risorsa."

#: pkg/kubectl/cmd/stop.go:31
msgid ""
"\n"
"\t\tDeprecated: Gracefully shut down a resource by name or filename.\n"
"\n"
"\t\tThe stop command is deprecated, all its functionalities are covered by "
"delete command.\n"
"\t\tSee 'kubectl delete --help' for more details.\n"
"\n"
"\t\tAttempts to shut down and delete a resource that supports graceful "
"termination.\n"
"\t\tIf the resource is scalable it will be scaled to 0 before deletion."
msgstr ""
"\n"
"\t\tDeprecated: chiudere correttamente una risorsa per nome o nome file.\n"
"\n"
"\t\tIl comando stop è deprecato, tutte le sue funzionalità sono coperte dal "
"comando delete.\n"
"\t\tVedere 'kubectl delete --help' per ulteriori dettagli.\n"
"\n"
"\t\tTenta di arrestare ed eliminare una risorsa che supporta la corretta "
"terminazione.\n"
"\t\tSe la risorsa è scalabile, verrà scalata a 0 prima dell'eliminazione."

#: pkg/kubectl/cmd/top_node.go:60
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n"
"\n"
"\t\tThe top-node command allows you to see the resource consumption of nodes."
msgstr ""
"\n"
"\t\tVisualizza l'utilizzo di risorse (CPU/Memoria/Storage) dei nodi.\n"
"\n"
"\t\tIl comando top-node consente di visualizzare il consumo di risorse dei "
"nodi."

#: pkg/kubectl/cmd/top_pod.go:53
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n"
"\n"
"\t\tThe 'top pod' command allows you to see the resource consumption of "
"pods.\n"
"\n"
"\t\tDue to the metrics pipeline delay, they may be unavailable for a few "
"minutes\n"
"\t\tsince pod creation."
msgstr ""
"\n"
"\t\tVisualizza l'utilizzo di risorse (CPU/Memoria/Storage) dei pod.\n"
"\n"
"\t\tIl comando \"top pod\" consente di visualizzare il consumo delle risorse "
"dei pod.\n"
"\n"
"\t\tA causa del ritardo della pipeline metrica, potrebbero non essere "
"disponibili per alcuni minuti\n"
"\t\teal momento della creazione dei pod."

#: pkg/kubectl/cmd/top.go:33
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage.\n"
"\n"
"\t\tThe top command allows you to see the resource consumption for nodes or "
"pods.\n"
"\n"
"\t\tThis command requires Heapster to be correctly configured and working on "
"the server. "
msgstr ""
"\n"
"\t\tVisualizza l'utilizzo di risorse (CPU/Memoria/Storage).\n"
"\n"
"\t\tIl comando top consente di visualizzare il consumo di risorse per nodi o "
"pod.\n"
"\n"
"\t\tQuesto comando richiede che Heapster sia configurato correttamente e che "
"funzioni sul server."

#: pkg/kubectl/cmd/drain.go:140
msgid ""
"\n"
"\t\tDrain node in preparation for maintenance.\n"
"\n"
"\t\tThe given node will be marked unschedulable to prevent new pods from "
"arriving.\n"
"\t\t'drain' evicts the pods if the APIServer supports eviction\n"
"\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use "
"normal DELETE\n"
"\t\tto delete the pods.\n"
"\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot "
"be deleted through\n"
"\t\tthe API server).  If there are DaemonSet-managed pods, drain will not "
"proceed\n"
"\t\twithout --ignore-daemonsets, and regardless it will not delete any\n"
"\t\tDaemonSet-managed pods, because those pods would be immediately replaced "
"by the\n"
"\t\tDaemonSet controller, which ignores unschedulable markings.  If there are "
"any\n"
"\t\tpods that are neither mirror pods nor managed by ReplicationController,\n"
"\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete any "
"pods unless you\n"
"\t\tuse --force.  --force will also allow deletion to proceed if the managing "
"resource of one\n"
"\t\tor more pods is missing.\n"
"\n"
"\t\t'drain' waits for graceful termination. You should not operate on the "
"machine until\n"
"\t\tthe command completes.\n"
"\n"
"\t\tWhen you are ready to put the node back into service, use kubectl "
"uncordon, which\n"
"\t\twill make the node schedulable again.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)"
msgstr ""
"\n"
"\t\tDrain node in preparazione alla manutenzione.\n"
"\n"
"\t\tIl nodo indicato verrà contrassegnato unschedulable  per impedire che "
"nuovi pod arrivino.\n"
"\t\t'drain' evict i pod se l'APIServer supporta eviction\n"
"\t\t(http://kubernetes.io/docs/admin/disruptions/).  Altrimenti, usa il "
"normale DELETE\n"
"\t\tper eliminare i pod.\n"
"\t\tIl 'drain' evicts o la cancellazione di tutti all pod tranne mirror pods "
"(che non possono essere eliminati\n"
"\t\tattraverso API server).  Se ci sono i pod gestiti da  DaemonSet, drain "
"non procederà\n"
"\t\tsenza --ignore-daemonsets e, a prescindere da ciò, non cancellerà alcun\n"
"\t\tpod gestitto da DaemonSet,poiché questi pods verrebbero immediatamente "
"sostituiti dal\n"
"\t\tDaemonSet controller,  che ignora le marcature unschedulable.  Se ci "
"sono\n"
"\t\tpod che non sono né mirror pod né gestiti dal ReplicationController,\n"
"\t\tReplicaSet, DaemonSet, StatefulSet o Job, allora drain non cancellerà "
"alcun pod finché non\n"
"\t\tuserai --force.  --force permetterà alla cancellazione di procedere se la "
"risorsa gestita da uno\n"
"\t\to più pod è mancante.\n"
"\n"
"\t\t'drain' attende il termine corretto. Non devi operare sulla macchina "
"finché\n"
"\t\til comando non viene completato.\n"
"\n"
"\t\tQuando sei pronto per riportare il nodo al servizio, utilizza kubectl "
"uncordon, per\n"
"\t\trimettere il nodo schedulable nuovamente.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)"

#: pkg/kubectl/cmd/edit.go:56
msgid ""
"\n"
"\t\tEdit a resource from the default editor.\n"
"\n"
"\t\tThe edit command allows you to directly edit any API resource you can "
"retrieve via the\n"
"\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, "
"or EDITOR\n"
"\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for "
"Windows.\n"
"\t\tYou can edit multiple objects, although changes are applied one at a "
"time. The command\n"
"\t\taccepts filenames as well as command line arguments, although the files "
"you point to must\n"
"\t\tbe previously saved versions of resources.\n"
"\n"
"\t\tEditing is done with the API version used to fetch the resource.\n"
"\t\tTo edit using a specific API version, fully-qualify the resource, "
"version, and group.\n"
"\n"
"\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n"
"\n"
"\t\tThe flag --windows-line-endings can be used to force Windows line "
"endings,\n"
"\t\totherwise the default for your operating system will be used.\n"
"\n"
"\t\tIn the event an error occurs while updating, a temporary file will be "
"created on disk\n"
"\t\tthat contains your unapplied changes. The most common error when updating "
"a resource\n"
"\t\tis another editor changing the resource on the server. When this occurs, "
"you will have\n"
"\t\tto apply your changes to the newer version of the resource, or update "
"your temporary\n"
"\t\tsaved copy to include the latest resource version."
msgstr ""
"\n"
"\t\tModificare una risorsa dall'editor predefinito.\n"
"\n"
"\t\tIl comando di modifica consente di modificare direttamente qualsiasi "
"risorsa API che è possibile recuperare tramite gli\n"
"\t\tstrumenti di riga di comando. Apre l'editor definito dalle variabili "
"d'ambiente\n"
"\t\tKUBE_EDITOR o EDITOR, o ritornare a 'vi' per Linux o 'notepad' per "
"Windows.\n"
"\t\tÈ possibile modificare più oggetti, anche se le modifiche vengono "
"applicate una alla volta. Il comando\n"
"\t\taccetta sia nomi di file che argomenti da riga di comando, anche se i "
"file a cui fa riferimento devono\n"
"\t\tessere state salvate precedentemente le versioni delle risorse.\n"
"\n"
"\t\tLa modifica viene eseguita con la versione API utilizzata per recuperare "
"la risorsa.\n"
"\t\tPer modificare utilizzando una specifica versione API, fully-qualify la "
"risorsa, versione e il gruppo.\n"
"\n"
"\t\tIl formato predefinito è YAML. Per modificare in JSON, specificare \"-o "
"json\".\n"
"\n"
"\t\tIl flag --windows-line-endings può essere utilizzato per forzare i fine "
"linea Windows,\n"
"\t\taltrimenti verrà utilizzato il default per il sistema operativo.\n"
"\n"
"\t\tNel caso in cui si verifica un errore durante l'aggiornamento, verrà "
"creato un file temporaneo sul disco\n"
"\t\tche contiene le modifiche non apportate. L'errore più comune durante "
"l'aggiornamento di una risorsa\n"
"\t\tè una modifica da pare di un altro editor della risorsa sul server. "
"Quando questo si verifica, dovrai\n"
"\t\tapplicare le modifiche alla versione più recente della risorsa o "
"aggiornare il tua copia\n"
"\t\ttemporanea salvata per includere l'ultima versione delle risorse."

#: pkg/kubectl/cmd/drain.go:115
msgid ""
"\n"
"\t\tMark node as schedulable."
msgstr ""
"\n"
"\t\tContrassegna il nodo come programmabile."

#: pkg/kubectl/cmd/drain.go:90
msgid ""
"\n"
"\t\tMark node as unschedulable."
msgstr ""
"\n"
"\t\tContrassegnare il nodo come non programmabile."

#: pkg/kubectl/cmd/completion.go:47
msgid ""
"\n"
"\t\tOutput shell completion code for the specified shell (bash or zsh).\n"
"\t\tThe shell code must be evaluated to provide interactive\n"
"\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n"
"\t\tthe .bash_profile.\n"
"\n"
"\t\tNote: this requires the bash-completion framework, which is not "
"installed\n"
"\t\tby default on Mac.  This can be installed by using homebrew:\n"
"\n"
"\t\t    $ brew install bash-completion\n"
"\n"
"\t\tOnce installed, bash_completion must be evaluated.  This can be done by "
"adding the\n"
"\t\tfollowing line to the .bash_profile\n"
"\n"
"\t\t    $ source $(brew --prefix)/etc/bash_completion\n"
"\n"
"\t\tNote for zsh users: [1] zsh completions are only supported in versions of "
"zsh >= 5.2"
msgstr ""
"\n"
"\t\tIn output codice di completamento shell output per la shell specificata "
"(bash o zsh).\n"
"\t\tIl codice di shell deve essere valorizzato per fornire completamento\n"
"\t\tinterattivo dei comandi kubectl. Questo può essere eseguito "
"richiamandolo\n"
"\t\tda .bash_profile.\n"
"\n"
"\t\tNota: questo richiede il framework di completamento bash, che non è "
"installato\n"
"\t\tper impostazione predefinita su Mac. Questo può essere installato "
"utilizzando homebrew:\n"
"\n"
"\t\t    $ brew install bash-completion\n"
"\n"
"\t\tUna volta installato, bash_completion deve essere valutato. Ciò può "
"essere fatto aggiungendo la\n"
"\t\tseguente riga al file .bash_profile\n"
"\n"
"\t\t    $ source $(brew --prefix)/etc/bash_completion\n"
"\n"
"\t\tNota per gli utenti zsh: [1] i completamenti zsh sono supportati solo "
"nelle versioni zsh> = 5.2"

#: pkg/kubectl/cmd/rollingupdate.go:45
msgid ""
"\n"
"\t\tPerform a rolling update of the given ReplicationController.\n"
"\n"
"\t\tReplaces the specified replication controller with a new replication "
"controller by updating one pod at a time to use the\n"
"\t\tnew PodTemplate. The new-controller.json must specify the same namespace "
"as the\n"
"\t\texisting replication controller and overwrite at least one (common) label "
"in its replicaSelector.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)"
msgstr ""
"\n"
"\t\tEseguire un rolling update del ReplicationController specificato.\n"
"\n"
"\t\tSostituisce il replication controller specificato con un nuovo "
"replication controller aggiornando un pod alla volta per usare il\n"
"\t\tnuovo PodTemplate. Il new-controller.json deve specificare lo stesso "
"namespace del\n"
"\t\tcontroller di replica esistente e sovrascrivere almeno una etichetta "
"(comune) nella sua replicaSelector.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)"

#: pkg/kubectl/cmd/replace.go:40
msgid ""
"\n"
"\t\tReplace a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted. If replacing an existing resource, "
"the\n"
"\t\tcomplete resource spec must be provided. This can be obtained by\n"
"\n"
"\t\t    $ kubectl get TYPE NAME -o yaml\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."
msgstr ""
"\n"
"\t\tSostituire una risorsa per nomefile o stdin.\n"
"\n"
"\t\tSono accettati i formati JSON e YAML. Se si sostituisce una risorsa "
"esistente, \n"
"\t\tè necessario fornire la specifica completa delle risorse. Questo può "
"essere ottenuta da\n"
"\n"
"\t\t    $ kubectl get TYPE NAME -o yaml\n"
"\n"
"\t\tFare riferimento ai modelli https://htmlpreview.github.io/?https://github."
"com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html "
"per trovare se un campo è mutevole."

#: pkg/kubectl/cmd/scale.go:34
msgid ""
"\n"
"\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or "
"Job.\n"
"\n"
"\t\tScale also allows users to specify one or more preconditions for the "
"scale action.\n"
"\n"
"\t\tIf --current-replicas or --resource-version is specified, it is validated "
"before the\n"
"\t\tscale is attempted, and it is guaranteed that the precondition holds true "
"when the\n"
"\t\tscale is sent to the server."
msgstr ""
"\n"
"\t\tImposta una nuova dimensione per Deployment, ReplicaSet, Replication "
"Controller, o Job.\n"
"\n"
"\t\tScala consente anche agli utenti di specificare una o più condizioni "
"preliminari per l'azione della scala.\n"
"\n"
"\t\tSe --current-replicas o --resource-version sono specificate, viene "
"convalidata prima di\n"
"\t\ttentare scale, ed è garantito che la precondizione vale quando\n"
"\t\tscale viene inviata al server.."

#: pkg/kubectl/cmd/apply_set_last_applied.go:62
msgid ""
"\n"
"\t\tSet the latest last-applied-configuration annotations by setting it to "
"match the contents of a file.\n"
"\t\tThis results in the last-applied-configuration being updated as though "
"'kubectl apply -f <file>' was run,\n"
"\t\twithout updating any other parts of the object."
msgstr ""
"\n"
"\t\tImposta le annotazioni dell'ultima-configurazione-applicata impostandola "
"in modo che corrisponda al contenuto di un file.\n"
"\t\tCiò determina l'aggiornamento dell'ultima-configurazione-applicata come "
"se 'kubectl apply -f <file>' fosse stato eseguito,\n"
"\t\tsenza aggiornare altre parti dell'oggetto."

#: pkg/kubectl/cmd/proxy.go:36
msgid ""
"\n"
"\t\tTo proxy all of the kubernetes api and nothing else, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/\n"
"\n"
"\t\tTo proxy only part of the kubernetes api and also some static files:\n"
"\n"
"\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/"
"api/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n"
"\n"
"\t\tTo proxy the entire kubernetes api at a different root, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/custom/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'"
msgstr ""
"\n"
"\t\tPer proxy tutti i kubernetes api e nient'altro, utilizzare:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/\n"
"\n"
"\t\tPer proxy solo una parte dei kubernetes api e anche alcuni file static\n"
"\n"
"\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/"
"api/\n"
"\n"
"\t\tQuanto sopra consente 'curl localhost:8001/api/v1/pods'.\n"
"\n"
"\t\tPer eseguire il proxy tutti i kubernetes api in una radice diversa, "
"utilizzare:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/custom/\n"
"\n"
"\t\tQuanto sopra ti permette 'curl localhost:8001/custom/api/v1/pods'"

#: pkg/kubectl/cmd/patch.go:59
msgid ""
"\n"
"\t\tUpdate field(s) of a resource using strategic merge patch\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."
msgstr ""
"\n"
"\t\tAggiorna i campi di una risorsa utilizzando la merge patch strategica\n"
"\n"
"\t\tSono accettati i formati JSON e YAML.\n"
"\n"
"\t\tSi prega di fare riferimento ai modelli in https://htmlpreview.github.io/?"
"https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/"
"definitions.html per trovare se un campo è mutevole."

#: pkg/kubectl/cmd/label.go:70
#, c-format
msgid ""
"\n"
"\t\tUpdate the labels on a resource.\n"
"\n"
"\t\t* A label must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* If --overwrite is true, then existing labels can be overwritten, "
"otherwise attempting to overwrite a label will result in an error.\n"
"\t\t* If --resource-version is specified, then updates will use this resource "
"version, otherwise the existing resource-version will be used."
msgstr ""
"\n"
"\t\tAggiorna le label di una risorsa.\n"
"\n"
"\t\t* A label must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* If --overwrite is true, then existing labels can be overwritten, "
"otherwise attempting to overwrite a label will result in an error.\n"
"\t\t* If --resource-version is specified, then updates will use this resource "
"version, otherwise the existing resource-version will be used."

#: pkg/kubectl/cmd/taint.go:58
#, c-format
msgid ""
"\n"
"\t\tUpdate the taints on one or more nodes.\n"
"\n"
"\t\t* A taint consists of a key, value, and effect. As an argument here, it "
"is expressed as key=value:effect.\n"
"\t\t* The key must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* The value must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[2]d characters.\n"
"\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n"
"\t\t* Currently taint can only apply to node."
msgstr ""
"\n"
"\t\tAggiorna i marcatori su uno o più nodi.\n"
"\n"
"\t\t* Un marcatore è costituita da una chiave, un valore e un effetto. Come "
"argomento qui, viene espresso come chiave = valore: effetto.\n"
"\t\t* La chiave deve iniziare con una lettera o un numero e può contenere "
"lettere, numeri, trattini, punti e sottolineature, fino a% [1] d caratteri.\n"
"\t\t* Il valore deve iniziare con una lettera o un numero e può contenere "
"lettere, numeri, trattini, punti e sottolineature, fino a% [2] d caratteri.\n"
"\t\t* L'effetto deve essere NoSchedule, PreferNoSchedule o NoExecute.\n"
"\t\t* Attualmente il marcatore può essere applicato solo al nodo."

#: pkg/kubectl/cmd/apply_view_last_applied.go:46
msgid ""
"\n"
"\t\tView the latest last-applied-configuration annotations by type/name or "
"file.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use -"
"o option\n"
"\t\tto change output format."
msgstr ""
"\n"
"\t\tVisualizza le annotazioni dell'ultima-configurazione-applicata per tipo/"
"nome o file.\n"
"\n"
"\t\tL'output predefinito verrà stampato su stdout nel formato YAML. Si può "
"usare l'opzione -o\n"
"\t\tPer cambiare il formato di output."

#: pkg/kubectl/cmd/cp.go:37
msgid ""
"\n"
"\t    # !!!Important Note!!!\n"
"\t    # Requires that the 'tar' binary is present in your container\n"
"\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n"
"\n"
"\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in "
"the default namespace\n"
"\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n"
"\n"
"        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific "
"container\n"
"\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n"
"\n"
"\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace <some-"
"namespace>\n"
"\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n"
"\n"
"\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n"
"\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar"
msgstr ""
"\n"
"\t    #  !!!Nota importante!!!\n"
"\t    # Richiede che il binario 'tar' sia presente nel tuo contenitore\n"
"\t    #  immagine. Se 'tar' non è presente, 'kubectl cp' non riesce.\n"
"\n"
"\t    # Copia /tmp/foo_dir directory locale in /tmp/bar_dir in un pod remoto "
"nello spazio dei nomi predefinito\n"
"\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n"
"\n"
"        # Copia /tmp/foo file locale in /tmp/bar in un pod remoto in un "
"contenitore specifico\n"
"\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n"
"\n"
"\t\t# Copia /tmp/foo file locale in /tmp/bar in un pod remoto nello spazio "
"dei nomi <some-namespace>\n"
"\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n"
"\n"
"\t\t# Copia /tmp/foo da un pod remoto in /tmp/bar localmente\n"
"\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar"

#: pkg/kubectl/cmd/create_secret.go:205
msgid ""
"\n"
"\t  # Create a new TLS secret named tls-secret with the given key pair:\n"
"\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/"
"to/tls.key"
msgstr ""
"\n"
"\t  # Crea un nuovo secret TLS denominato tls-secret con la coppia di dati "
"fornita:\n"
"\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/"
"to/tls.key"

#: pkg/kubectl/cmd/create_namespace.go:35
msgid ""
"\n"
"\t  # Create a new namespace named my-namespace\n"
"\t  kubectl create namespace my-namespace"
msgstr ""
"\n"
"\t  # Crea un nuovo namespace denominato my-namespace\n"
"\t  kubectl create namespace my-namespace"

#: pkg/kubectl/cmd/create_secret.go:59
msgid ""
"\n"
"\t  # Create a new secret named my-secret with keys for each file in folder "
"bar\n"
"\t  kubectl create secret generic my-secret --from-file=path/to/bar\n"
"\n"
"\t  # Create a new secret named my-secret with specified keys instead of "
"names on disk\n"
"\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/.ssh/"
"id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n"
"\n"
"\t  # Create a new secret named my-secret with key1=supersecret and "
"key2=topsecret\n"
"\t  kubectl create secret generic my-secret --from-literal=key1=supersecret --"
"from-literal=key2=topsecret"
msgstr ""
"\n"
"\t  # Crea un nuovo secret denominato my-secret con i tasti per ogni file "
"nella barra delle cartelle\n"
"\t  kubectl create secret generic my-secret --from-file=path/to/bar\n"
"\n"
"\t  # Crea un nuovo secret denominato my-secret con le chiavi specificate "
"anziché i nomi sul disco\n"
"\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/.ssh/"
"id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n"
"\n"
"\t  # Crea un nuovo secret denominato my-secret con key1 = supersecret e key2 "
"= topsecret\n"
"\t  kubectl create secret generic my-secret --from-literal=key1=supersecret --"
"from-literal=key2=topsecret"

#: pkg/kubectl/cmd/create_serviceaccount.go:35
msgid ""
"\n"
"\t  # Create a new service account named my-service-account\n"
"\t  kubectl create serviceaccount my-service-account"
msgstr ""
"\n"
"\t  # Crea un nuovo service account denominato my-service-account\n"
"\t  kubectl create serviceaccount my-service-account"

#: pkg/kubectl/cmd/create_service.go:232
msgid ""
"\n"
"\t# Create a new ExternalName service named my-ns \n"
"\tkubectl create service externalname my-ns --external-name bar.com"
msgstr ""
"\n"
"\t#  Crea un nuovo servizio ExternalName denominato my-ns \n"
"\tkubectl create service externalname my-ns --external-name bar.com"

#: pkg/kubectl/cmd/create_service.go:225
msgid ""
"\n"
"\tCreate an ExternalName service with the specified name.\n"
"\n"
"\tExternalName service references to an external DNS address instead of\n"
"\tonly pods, which will allow application authors to reference services\n"
"\tthat exist off platform, on other clusters, or locally."
msgstr ""
"\n"
"\tCrea un servizio ExternalName con il nome specificato.\n"
"\n"
"\tIl servizio ExternalName fa riferimento a un indirizzo DNS esterno \n"
"\tsolo pod, che permetteranno agli autori delle applicazioni di utilizzare i "
"servizi di riferimento\n"
"\tche esistono fuori dalla piattaforma, su altri cluster, o localmente.."

#: pkg/kubectl/cmd/help.go:30
msgid ""
"\n"
"\tHelp provides help for any command in the application.\n"
"\tSimply type kubectl help [path to command] for full details."
msgstr ""
"\n"
"\tHelp fornisce assistenza per qualsiasi comando nell'applicazione.\n"
"\tBasta digitare kubectl help [path to command] per i dettagli completi."

#: pkg/kubectl/cmd/create_service.go:173
msgid ""
"\n"
"    # Create a new LoadBalancer service named my-lbs\n"
"    kubectl create service loadbalancer my-lbs --tcp=5678:8080"
msgstr ""
"\n"
"    # Creare un nuovo servizio LoadBalancer denominato my-lbs\n"
"    kubectl create service loadbalancer my-lbs --tcp=5678:8080"

#: pkg/kubectl/cmd/create_service.go:53
msgid ""
"\n"
"    # Create a new clusterIP service named my-cs\n"
"    kubectl create service clusterip my-cs --tcp=5678:8080\n"
"\n"
"    # Create a new clusterIP service named my-cs (in headless mode)\n"
"    kubectl create service clusterip my-cs --clusterip=\"None\""
msgstr ""
"\n"
"    # Creare un nuovo servizio clusterIP denominato my-cs\n"
"    kubectl create service clusterip my-cs --tcp=5678:8080\n"
"\n"
"    # Creare un nuovo servizio clusterIP denominato my-cs (in modalità "
"headless)\n"
"    kubectl create service clusterip my-cs --clusterip=\"None\""

#: pkg/kubectl/cmd/create_deployment.go:36
msgid ""
"\n"
"    # Create a new deployment named my-dep that runs the busybox image.\n"
"    kubectl create deployment my-dep --image=busybox"
msgstr ""
"\n"
"    # Crea una nuovo deployment chiamato my-dep che esegue l'immagine "
"busybox.\n"
"    kubectl create deployment my-dep --image=busybox"

#: pkg/kubectl/cmd/create_service.go:116
msgid ""
"\n"
"    # Create a new nodeport service named my-ns\n"
"    kubectl create service nodeport my-ns --tcp=5678:8080"
msgstr ""
"\n"
"    # Creare un nuovo servizio nodeport denominato my-ns\n"
"    kubectl create service nodeport my-ns --tcp=5678:8080"

#: pkg/kubectl/cmd/clusterinfo_dump.go:62
msgid ""
"\n"
"    # Dump current cluster state to stdout\n"
"    kubectl cluster-info dump\n"
"\n"
"    # Dump current cluster state to /path/to/cluster-state\n"
"    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n"
"\n"
"    # Dump all namespaces to stdout\n"
"    kubectl cluster-info dump --all-namespaces\n"
"\n"
"    # Dump a set of namespaces to /path/to/cluster-state\n"
"    kubectl cluster-info dump --namespaces default,kube-system --output-"
"directory=/path/to/cluster-state"
msgstr ""
"\n"
"    # Dump dello stato corrente del cluster verso stdout\n"
"    kubectl cluster-info dump\n"
"\n"
"    # Dump dello stato corrente del cluster verso /path/to/cluster-state\n"
"    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n"
"\n"
"    # Dump di tutti i namespaces verso stdout\n"
"    kubectl cluster-info dump --all-namespaces\n"
"\n"
"    # Dump di un set di namespace verso /path/to/cluster-state\n"
"    kubectl cluster-info dump --namespaces default,kube-system --output-"
"directory=/path/to/cluster-state"

#: pkg/kubectl/cmd/annotate.go:78
msgid ""
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend'.\n"
"    # If the same annotation is set multiple times, only the last value will "
"be applied\n"
"    kubectl annotate pods foo description='my frontend'\n"
"\n"
"    # Update a pod identified by type and name in \"pod.json\"\n"
"    kubectl annotate -f pod.json description='my frontend'\n"
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend running nginx', overwriting any existing value.\n"
"    kubectl annotate --overwrite pods foo description='my frontend running "
"nginx'\n"
"\n"
"    # Update all pods in the namespace\n"
"    kubectl annotate pods --all description='my frontend running nginx'\n"
"\n"
"    # Update pod 'foo' only if the resource is unchanged from version 1.\n"
"    kubectl annotate pods foo description='my frontend running nginx' --"
"resource-version=1\n"
"\n"
"    # Update pod 'foo' by removing an annotation named 'description' if it "
"exists.\n"
"    # Does not require the --overwrite flag.\n"
"    kubectl annotate pods foo description-"
msgstr ""
"\n"
"    # Aggiorna il pod 'foo' con annotazione 'description'e il valore 'my "
"frontend'.\n"
"    # Se la stessa annotazione è impostata più volte, verrà applicato solo "
"l'ultimo valore\n"
"    kubectl annotate pods foo description='my frontend'\n"
"\n"
"    # Aggiorna un pod identificato per tipo e nome in \"pod.json\"\n"
"    kubectl annotate -f pod.json description='my frontend'\n"
"\n"
"    # Aggiorna pod 'foo' con la annotazione 'description' e il valore 'my "
"frontend running nginx', sovrascrivendo qualsiasi valore esistente.\n"
"    kubectl annotate --overwrite pods foo description='my frontend running "
"nginx'\n"
"\n"
"    # Aggiorna tutti i baccelli nel namespace\n"
"    kubectl annotate pods --all description='my frontend running nginx'\n"
"\n"
"    # Aggiorna il pod 'foo' solo se la risorsa è invariata dalla versione 1.\n"
"    kubectl annotate pods foo description='my frontend running nginx' --"
"resource-version=1\n"
"\n"
"    # Aggiorna il pod 'foo' rimuovendo un'annotazione denominata "
"'descrizione' se esiste.\n"
"    # Non richiede flag -overwrite.\n"
"    kubectl annotate pods foo description-"

#: pkg/kubectl/cmd/create_service.go:170
msgid ""
"\n"
"    Create a LoadBalancer service with the specified name."
msgstr ""
"\n"
"    Crea un servizio LoadBalancer con il nome specificato."

#: pkg/kubectl/cmd/create_service.go:50
msgid ""
"\n"
"    Create a clusterIP service with the specified name."
msgstr ""
"\n"
"    Crea un servizio clusterIP con il nome specificato."

#: pkg/kubectl/cmd/create_deployment.go:33
msgid ""
"\n"
"    Create a deployment with the specified name."
msgstr ""
"\n"
"    Creare un deployment con il nome specificato."

#: pkg/kubectl/cmd/create_service.go:113
msgid ""
"\n"
"    Create a nodeport service with the specified name."
msgstr ""
"\n"
"    Creare un servizio nodeport con il nome specificato."

#: pkg/kubectl/cmd/clusterinfo_dump.go:53
msgid ""
"\n"
"    Dumps cluster info out suitable for debugging and diagnosing cluster "
"problems.  By default, dumps everything to\n"
"    stdout. You can optionally specify a directory with --output-directory.  "
"If you specify a directory, kubernetes will\n"
"    build a set of files in that directory.  By default only dumps things in "
"the 'kube-system' namespace, but you can\n"
"    switch to a different namespace with the --namespaces flag, or specify --"
"all-namespaces to dump all namespaces.\n"
"\n"
"    The command also dumps the logs of all of the pods in the cluster, these "
"logs are dumped into different directories\n"
"    based on namespace and pod name."
msgstr ""
"\n"
"    Dump delle informazioni di cluster idonee per il debug e la diagnostica "
"di problemi di cluster. Per impostazione predefinita, tutto\n"
"    verso stdout. È possibile specificare opzionalmente una directory con --"
"output-directory. Se si specifica una directory, kubernetes \n"
"    creearà un insieme di file in quella directory. Per impostazione "
"predefinita, dumps solo i dati del namespace \"kube-system\", ma è\n"
"    possibile passare ad namespace diverso con il flag --namespaces o "
"specificare --all-namespaces per il dump di tutti i namespace.\n"
"\n"
"     Il comando esegue dump anche dei log di tutti i pod del cluster, questi "
"log vengono scaricati in directory differenti\n"
"     basati sul namespace e sul nome del pod."

#: pkg/kubectl/cmd/clusterinfo.go:37
msgid ""
"\n"
"  Display addresses of the master and services with label kubernetes.io/"
"cluster-service=true\n"
"  To further debug and diagnose cluster problems, use 'kubectl cluster-info "
"dump'."
msgstr ""
"\n"
"  Visualizza gli indirizzi del master e dei servizi con label kubernetes.io/"
"cluster-service=true\n"
"  Per ulteriore debug e diagnosticare i problemi di cluster, utilizzare "
"'kubectl cluster-info dump'."

#: pkg/kubectl/cmd/create_quota.go:62
msgid ""
"A comma-delimited set of quota scopes that must all match each object tracked "
"by the quota."
msgstr ""
"Un insieme delimitato-da-virgole di quota scopes che devono corrispondere a "
"ciascun oggetto gestito dalla quota."

#: pkg/kubectl/cmd/create_quota.go:61
msgid ""
"A comma-delimited set of resource=quantity pairs that define a hard limit."
msgstr ""
"Un insieme delimitato-da-virgola di coppie risorsa = quantità che definiscono "
"un hard limit."

#: pkg/kubectl/cmd/create_pdb.go:64
msgid ""
"A label selector to use for this budget. Only equality-based selector "
"requirements are supported."
msgstr ""
"Un label selector da utilizzare per questo budget. Sono supportati solo i "
"selettori equality-based selector."

#: pkg/kubectl/cmd/expose.go:104
msgid ""
"A label selector to use for this service. Only equality-based selector "
"requirements are supported. If empty (the default) infer the selector from "
"the replication controller or replica set.)"
msgstr ""
"Un selettore di label da utilizzare per questo servizio. Sono supportati solo "
"equality-based selector.  Se vuota (default) dedurre il selettore dal "
"replication controller o replica set.)"

#: pkg/kubectl/cmd/run.go:139
msgid "A schedule in the Cron format the job should be run with."
msgstr "Un calendario in formato Cron del lavoro che deve essere eseguito."

#: pkg/kubectl/cmd/expose.go:109
msgid ""
"Additional external IP address (not managed by Kubernetes) to accept for the "
"service. If this IP is routed to a node, the service can be accessed by this "
"IP in addition to its generated service IP."
msgstr ""
"Indirizzo IP esterno aggiuntivo (non gestito da Kubernetes) da accettare per "
"il servizio. Se questo IP viene indirizzato a un nodo, è possibile accedere "
"da questo IP in aggiunta al service IP generato."

#: pkg/kubectl/cmd/expose.go:110 pkg/kubectl/cmd/run.go:122
msgid ""
"An inline JSON override for the generated object. If this is non-empty, it is "
"used to override the generated object. Requires that the object supply a "
"valid apiVersion field."
msgstr ""
"Un override JSON inline per l'oggetto generato. Se questo non è vuoto, viene "
"utilizzato per ignorare l'oggetto generato. Richiede che l'oggetto fornisca "
"un campo valido apiVersion."

#: pkg/kubectl/cmd/run.go:137
msgid ""
"An inline JSON override for the generated service object. If this is non-"
"empty, it is used to override the generated object. Requires that the object "
"supply a valid apiVersion field.  Only used if --expose is true."
msgstr ""
"Un override JSON inline per l'oggetto di servizio generato. Se questo non è "
"vuoto, viene utilizzato per ignorare l'oggetto generato. Richiede che "
"l'oggetto fornisca un campo valido apiVersion. Utilizzato solo se --expose è "
"true."

#: pkg/kubectl/cmd/apply.go:104
msgid "Apply a configuration to a resource by filename or stdin"
msgstr "Applica una configurazione risorsa per nomefile o stdin"

#: pkg/kubectl/cmd/certificates.go:72
msgid "Approve a certificate signing request"
msgstr "Approva una richiesta di firma del certificato"

#: pkg/kubectl/cmd/create_service.go:82
msgid ""
"Assign your own ClusterIP or set to 'None' for a 'headless' service (no "
"loadbalancing)."
msgstr ""
"Assegnare il proprio ClusterIP o impostare su 'None' per un servizio "
"'headless' (nessun bilanciamento del carico)."

#: pkg/kubectl/cmd/attach.go:70
msgid "Attach to a running container"
msgstr "Collega a un container in esecuzione"

#: pkg/kubectl/cmd/autoscale.go:56
msgid "Auto-scale a Deployment, ReplicaSet, or ReplicationController"
msgstr "Auto-scale a Deployment, ReplicaSet, o ReplicationController"

#: pkg/kubectl/cmd/expose.go:113
msgid ""
"ClusterIP to be assigned to the service. Leave empty to auto-allocate, or set "
"to 'None' to create a headless service."
msgstr ""
"ClusterIP da assegnare al servizio. Lasciare vuoto per allocare "
"automaticamente o impostare su 'None' per creare un servizio headless."

#: pkg/kubectl/cmd/create_clusterrolebinding.go:56
msgid "ClusterRole this ClusterRoleBinding should reference"
msgstr "ClusterRole a cui questo ClusterRoleBinding fa riferimento"

#: pkg/kubectl/cmd/create_rolebinding.go:56
msgid "ClusterRole this RoleBinding should reference"
msgstr "ClusterRole a cui questo RoleBinding fa riferimento"

#: pkg/kubectl/cmd/rollingupdate.go:102
msgid ""
"Container name which will have its image upgraded. Only relevant when --image "
"is specified, ignored otherwise. Required when using --image on a multi-"
"container pod"
msgstr ""
"Nome container che avrà la sua immagine aggiornata. Soltanto rilevante quando "
"--image è specificato, altrimenti ignorato. Necessario quando si utilizza --"
"image su un contenitore a più contenitori"

#: pkg/kubectl/cmd/convert.go:68
msgid "Convert config files between different API versions"
msgstr "Convertire i file di configurazione tra diverse versioni APIs"

#: pkg/kubectl/cmd/cp.go:65
msgid "Copy files and directories to and from containers."
msgstr "Copiare file e directory da e verso i container."

#: pkg/kubectl/cmd/create_clusterrolebinding.go:44
msgid "Create a ClusterRoleBinding for a particular ClusterRole"
msgstr "Crea un ClusterRoleBinding per un ClusterRole particolare"

#: pkg/kubectl/cmd/create_service.go:182
msgid "Create a LoadBalancer service."
msgstr "Creare un servizio LoadBalancer."

#: pkg/kubectl/cmd/create_service.go:125
msgid "Create a NodePort service."
msgstr "Crea un servizio NodePort."

#: pkg/kubectl/cmd/create_rolebinding.go:44
msgid "Create a RoleBinding for a particular Role or ClusterRole"
msgstr "Crea un RoleBinding per un particolare Role o ClusterRole"

#: pkg/kubectl/cmd/create_secret.go:214
msgid "Create a TLS secret"
msgstr "Crea un secret TLS"

#: pkg/kubectl/cmd/create_service.go:69
msgid "Create a clusterIP service."
msgstr "Crea un servizio clusterIP."

#: pkg/kubectl/cmd/create_configmap.go:60
msgid "Create a configmap from a local file, directory or literal value"
msgstr ""
"Crea un configmap da un file locale, una directory o un valore letterale"

#: pkg/kubectl/cmd/create_deployment.go:46
msgid "Create a deployment with the specified name."
msgstr "Creare un deployment con il nome specificato."

#: pkg/kubectl/cmd/create_namespace.go:45
msgid "Create a namespace with the specified name"
msgstr "Crea un namespace con il nome specificato"

#: pkg/kubectl/cmd/create_pdb.go:50
msgid "Create a pod disruption budget with the specified name."
msgstr "Crea un pod disruption budget con il nome specificato."

#: pkg/kubectl/cmd/create_quota.go:48
msgid "Create a quota with the specified name."
msgstr "Crea una quota con il nome specificato."

#: pkg/kubectl/cmd/create.go:63
msgid "Create a resource by filename or stdin"
msgstr "Crea una risorsa per nome file o stdin"

#: pkg/kubectl/cmd/create_secret.go:144
msgid "Create a secret for use with a Docker registry"
msgstr "Crea un secret da utilizzare con un registro Docker"

#: pkg/kubectl/cmd/create_secret.go:74
msgid "Create a secret from a local file, directory or literal value"
msgstr "Crea un secret da un file locale, una directory o un valore letterale"

#: pkg/kubectl/cmd/create_secret.go:35
msgid "Create a secret using specified subcommand"
msgstr "Crea un secret utilizzando un subcommand specificato"

#: pkg/kubectl/cmd/create_serviceaccount.go:45
msgid "Create a service account with the specified name"
msgstr "Creare un account di servizio con il nome specificato"

#: pkg/kubectl/cmd/create_service.go:37
msgid "Create a service using specified subcommand."
msgstr "Crea un servizio utilizzando il subcommand specificato."

#: pkg/kubectl/cmd/create_service.go:241
msgid "Create an ExternalName service."
msgstr "Crea un servizio ExternalName."

#: pkg/kubectl/cmd/delete.go:132
msgid ""
"Delete resources by filenames, stdin, resources and names, or by resources "
"and label selector"
msgstr ""
"Elimina risorse selezionate per nomi di file, stdin, risorse e nomi, o per "
"risorsa e selettore di label"

#: pkg/kubectl/cmd/config/delete_cluster.go:39
msgid "Delete the specified cluster from the kubeconfig"
msgstr "Elimina il cluster specificato dal kubeconfig"

#: pkg/kubectl/cmd/config/delete_context.go:39
msgid "Delete the specified context from the kubeconfig"
msgstr "Elimina il context specificato dal kubeconfig"

#: pkg/kubectl/cmd/certificates.go:122
msgid "Deny a certificate signing request"
msgstr "Nega una richiesta di firma del certificato"

#: pkg/kubectl/cmd/stop.go:59
msgid "Deprecated: Gracefully shut down a resource by name or filename"
msgstr "Deprecated: spegne correttamente una risorsa per nome o nome file"

#: pkg/kubectl/cmd/config/get_contexts.go:64
msgid "Describe one or many contexts"
msgstr "Descrive uno o più context"

#: pkg/kubectl/cmd/top_node.go:78
msgid "Display Resource (CPU/Memory) usage of nodes"
msgstr "Visualizza l'utilizzo di risorse (CPU/Memoria) per nodo"

#: pkg/kubectl/cmd/top_pod.go:80
msgid "Display Resource (CPU/Memory) usage of pods"
msgstr "Visualizza l'utilizzo di risorse (CPU/Memoria) per pod."

#: pkg/kubectl/cmd/top.go:44
msgid "Display Resource (CPU/Memory) usage."
msgstr "Visualizza l'utilizzo di risorse (CPU/Memoria)."

#: pkg/kubectl/cmd/clusterinfo.go:51
msgid "Display cluster info"
msgstr "Visualizza informazioni sul cluster"

#: pkg/kubectl/cmd/config/get_clusters.go:41
msgid "Display clusters defined in the kubeconfig"
msgstr "Mostra i cluster definiti nel kubeconfig"

#: pkg/kubectl/cmd/config/view.go:67
msgid "Display merged kubeconfig settings or a specified kubeconfig file"
msgstr ""
"Visualizza le impostazioni merged di kubeconfig o un file kubeconfig "
"specificato"

#: pkg/kubectl/cmd/get.go:111
msgid "Display one or many resources"
msgstr "Visualizza una o più risorse"

#: pkg/kubectl/cmd/config/current_context.go:49
msgid "Displays the current-context"
msgstr "Visualizza il current-context"

#: pkg/kubectl/cmd/explain.go:51
msgid "Documentation of resources"
msgstr "Documentazione delle risorse"

#: pkg/kubectl/cmd/drain.go:178
msgid "Drain node in preparation for maintenance"
msgstr "Drain node in preparazione alla manutenzione"

#: pkg/kubectl/cmd/clusterinfo_dump.go:39
msgid "Dump lots of relevant info for debugging and diagnosis"
msgstr "Dump di un sacco di informazioni pertinenti per il debug e la diagnosi"

#: pkg/kubectl/cmd/edit.go:110
msgid "Edit a resource on the server"
msgstr "Modificare una risorsa sul server"

#: pkg/kubectl/cmd/create_secret.go:160
msgid "Email for Docker registry"
msgstr "Email per il registro Docker"

#: pkg/kubectl/cmd/exec.go:69
msgid "Execute a command in a container"
msgstr "Esegui un comando in un contenitore"

#: pkg/kubectl/cmd/rollingupdate.go:103
msgid ""
"Explicit policy for when to pull container images. Required when --image is "
"same as existing image, ignored otherwise."
msgstr ""
"Politica esplicita per il pull delle immagini container. Richiesto quando --"
"image è uguale all'immagine esistente, altrimenti ignorata."

#: pkg/kubectl/cmd/portforward.go:76
msgid "Forward one or more local ports to a pod"
msgstr "Inoltra una o più porte locali a un pod"

#: pkg/kubectl/cmd/help.go:37
msgid "Help about any command"
msgstr "Aiuto per qualsiasi comando"

#: pkg/kubectl/cmd/expose.go:103
msgid ""
"IP to assign to the Load Balancer. If empty, an ephemeral IP will be created "
"and used (cloud-provider specific)."
msgstr ""
"IP da assegnare al Load Balancer. Se vuota, un IP effimero verrà creato e "
"utilizzato (specifico per provider cloud)."

#: pkg/kubectl/cmd/expose.go:112
msgid ""
"If non-empty, set the session affinity for the service to this; legal values: "
"'None', 'ClientIP'"
msgstr ""
"Se non è vuoto, impostare l'affinità di sessione per il servizio; Valori "
"validi: 'None', 'ClientIP'"

#: pkg/kubectl/cmd/annotate.go:136
msgid ""
"If non-empty, the annotation update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single resource."
msgstr ""
"Se non è vuoto, l'aggiornamento delle annotazioni avrà successo solo se "
"questa è la resource-version corrente per l'oggetto. Valido solo quando si "
"specifica una singola risorsa."

#: pkg/kubectl/cmd/label.go:134
msgid ""
"If non-empty, the labels update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single resource."
msgstr ""
"Se non vuoto, l'aggiornamento delle label avrà successo solo se questa è la "
"resource-version corrente per l'oggetto. Valido solo quando si specifica una "
"singola risorsa."

#: pkg/kubectl/cmd/rollingupdate.go:99
msgid ""
"Image to use for upgrading the replication controller. Must be distinct from "
"the existing image (either new image or new image tag).  Can not be used with "
"--filename/-f"
msgstr ""
"Immagine da utilizzare per aggiornare il replication controller. Deve essere "
"diversa dall'immagine esistente (nuova immagine o nuovo tag immagine). Non "
"può essere utilizzata con --filename/-f"

#: pkg/kubectl/cmd/rollout/rollout.go:47
msgid "Manage a deployment rollout"
msgstr "Gestisci un deployment rollout"

#: pkg/kubectl/cmd/drain.go:128
msgid "Mark node as schedulable"
msgstr "Contrassegnare il nodo come programmabile"

#: pkg/kubectl/cmd/drain.go:103
msgid "Mark node as unschedulable"
msgstr "Contrassegnare il nodo come non programmabile"

#: pkg/kubectl/cmd/rollout/rollout_pause.go:74
msgid "Mark the provided resource as paused"
msgstr "Imposta la risorsa indicata in pausa"

#: pkg/kubectl/cmd/certificates.go:36
msgid "Modify certificate resources."
msgstr "Modificare le risorse del certificato."

#: pkg/kubectl/cmd/config/config.go:40
msgid "Modify kubeconfig files"
msgstr "Modifica i file kubeconfig"

#: pkg/kubectl/cmd/expose.go:108
msgid ""
"Name or number for the port on the container that the service should direct "
"traffic to. Optional."
msgstr ""
"Nome o numero di porta nel container verso il quale il servizio deve dirigere "
"il traffico. Opzionale."

#: pkg/kubectl/cmd/logs.go:113
msgid ""
"Only return logs after a specific date (RFC3339). Defaults to all logs. Only "
"one of since-time / since may be used."
msgstr ""
"Restituisce solo i log dopo una data specificata (RFC3339). Predefinito tutti "
"i log. È possibile utilizzare solo uno tra data-inizio/a-partire-da."

#: pkg/kubectl/cmd/completion.go:104
msgid "Output shell completion code for the specified shell (bash or zsh)"
msgstr ""
"Codice di completamento shell di output per la shell specificata (bash o zsh)"

#: pkg/kubectl/cmd/convert.go:85
msgid ""
"Output the formatted object with the given group version (for ex: 'extensions/"
"v1beta1').)"
msgstr ""
"Output dell'oggetto formattato con la versione del gruppo fornito (per "
"esempio: 'extensions/v1beta1').)"

#: pkg/kubectl/cmd/create_secret.go:158
msgid "Password for Docker registry authentication"
msgstr "Password per l'autenticazione al registro di Docker"

#: pkg/kubectl/cmd/create_secret.go:226
msgid "Path to PEM encoded public key certificate."
msgstr "Percorso certificato di chiave pubblica codificato PEM."

#: pkg/kubectl/cmd/create_secret.go:227
msgid "Path to private key associated with given certificate."
msgstr "Percorso alla chiave privata associata a un certificato specificato."

#: pkg/kubectl/cmd/rollingupdate.go:85
msgid "Perform a rolling update of the given ReplicationController"
msgstr "Eseguire un rolling update del ReplicationController specificato"

#: pkg/kubectl/cmd/scale.go:83
msgid ""
"Precondition for resource version. Requires that the current resource version "
"match this value in order to scale."
msgstr ""
"Prerequisito per la versione delle risorse. Richiede che la versione corrente "
"delle risorse corrisponda a questo valore per scalare."

#: pkg/kubectl/cmd/version.go:40
msgid "Print the client and server version information"
msgstr "Stampa per client e server le informazioni sulla versione"

#: pkg/kubectl/cmd/options.go:38
msgid "Print the list of flags inherited by all commands"
msgstr "Stampa l'elenco flag ereditati da tutti i comandi"

#: pkg/kubectl/cmd/logs.go:93
msgid "Print the logs for a container in a pod"
msgstr "Stampa i log per container in un pod"

#: pkg/kubectl/cmd/replace.go:71
msgid "Replace a resource by filename or stdin"
msgstr "Sostituire una risorsa per nomefile o stdin"

#: pkg/kubectl/cmd/rollout/rollout_resume.go:72
msgid "Resume a paused resource"
msgstr "Riprendere una risorsa in pausa"

#: pkg/kubectl/cmd/create_rolebinding.go:57
msgid "Role this RoleBinding should reference"
msgstr "Ruolo di riferimento per RoleBinding"

#: pkg/kubectl/cmd/run.go:97
msgid "Run a particular image on the cluster"
msgstr "Esegui una particolare immagine nel cluster"

#: pkg/kubectl/cmd/proxy.go:69
msgid "Run a proxy to the Kubernetes API server"
msgstr "Eseguire un proxy al server Kubernetes API"

#: pkg/kubectl/cmd/create_secret.go:161
msgid "Server location for Docker registry"
msgstr "Posizione del server per il Registro Docker"

#: pkg/kubectl/cmd/scale.go:71
msgid ""
"Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job"
msgstr ""
"Imposta una nuova dimensione per Deployment, ReplicaSet, Replication "
"Controller, o Job"

#: pkg/kubectl/cmd/set/set.go:38
msgid "Set specific features on objects"
msgstr "Imposta caratteristiche specifiche sugli oggetti"

#: pkg/kubectl/cmd/apply_set_last_applied.go:83
msgid ""
"Set the last-applied-configuration annotation on a live object to match the "
"contents of a file."
msgstr ""
"Imposta l'annotazione dell'ultima-configurazione-applicata ad un oggetto live "
"per abbinare il contenuto di un file."

#: pkg/kubectl/cmd/set/set_selector.go:82
msgid "Set the selector on a resource"
msgstr "Impostare il selettore di una risorsa"

#: pkg/kubectl/cmd/config/create_cluster.go:68
msgid "Sets a cluster entry in kubeconfig"
msgstr "Imposta una voce cluster in kubeconfig"

#: pkg/kubectl/cmd/config/create_context.go:58
msgid "Sets a context entry in kubeconfig"
msgstr "Imposta una voce context in kubeconfig"

#: pkg/kubectl/cmd/config/create_authinfo.go:104
msgid "Sets a user entry in kubeconfig"
msgstr "Imposta una voce utente in kubeconfig"

#: pkg/kubectl/cmd/config/set.go:60
msgid "Sets an individual value in a kubeconfig file"
msgstr "Imposta un singolo valore in un file kubeconfig"

#: pkg/kubectl/cmd/config/use_context.go:49
msgid "Sets the current-context in a kubeconfig file"
msgstr "Imposta il current-context in un file kubeconfig"

#: pkg/kubectl/cmd/describe.go:86
msgid "Show details of a specific resource or group of resources"
msgstr "Mostra i dettagli di una specifica risorsa o un gruppo di risorse"

#: pkg/kubectl/cmd/rollout/rollout_status.go:58
msgid "Show the status of the rollout"
msgstr "Mostra lo stato del rollout"

#: pkg/kubectl/cmd/expose.go:106
msgid "Synonym for --target-port"
msgstr "Sinonimo di --target-port"

#: pkg/kubectl/cmd/expose.go:88
msgid ""
"Take a replication controller, service, deployment or pod and expose it as a "
"new Kubernetes Service"
msgstr ""
"Prende un replication controller, service, deployment o un pod e lo espone "
"come nuovo servizio Kubernetes"

#: pkg/kubectl/cmd/run.go:117
msgid "The image for the container to run."
msgstr "L'immagine per il container da eseguire."

#: pkg/kubectl/cmd/run.go:119
msgid ""
"The image pull policy for the container. If left empty, this value will not "
"be specified by the client and defaulted by the server"
msgstr ""
"La politica di pull dell'immagine per il container. Se lasciato vuoto, questo "
"valore non verrà specificato dal client e predefinito dal server"

#: pkg/kubectl/cmd/rollingupdate.go:101
msgid ""
"The key to use to differentiate between two different controllers, default "
"'deployment'.  Only relevant when --image is specified, ignored otherwise"
msgstr ""
"La chiave da utilizzare per distinguere tra due controller diversi, "
"predefinito \"deployment\". Rilevante soltanto quando --image è specificato, "
"altrimenti ignorato"

#: pkg/kubectl/cmd/create_pdb.go:63
msgid "The minimum number or percentage of available pods this budget requires."
msgstr ""
"Il numero minimo o la percentuale di pod disponibili che questo budget "
"richiede."

#: pkg/kubectl/cmd/expose.go:111
msgid "The name for the newly created object."
msgstr "Il nome dell'oggetto appena creato."

#: pkg/kubectl/cmd/autoscale.go:72
msgid ""
"The name for the newly created object. If not specified, the name of the "
"input resource will be used."
msgstr ""
"Il nome dell'oggetto appena creato. Se non specificato, verrà utilizzato il "
"nome della risorsa di input."

#: pkg/kubectl/cmd/run.go:116
msgid ""
"The name of the API generator to use, see http://kubernetes.io/docs/user-"
"guide/kubectl-conventions/#generators for a list."
msgstr ""
"Il nome del generatore API da utilizzare, si veda http://kubernetes.io/docs/"
"user-guide/kubectl-conventions/#generators per un elenco."

#: pkg/kubectl/cmd/autoscale.go:67
msgid ""
"The name of the API generator to use. Currently there is only 1 generator."
msgstr ""
"Il nome del generatore API da utilizzare. Attualmente c'è solo 1 generatore."

#: pkg/kubectl/cmd/expose.go:99
msgid ""
"The name of the API generator to use. There are 2 generators: 'service/v1' "
"and 'service/v2'. The only difference between them is that service port in v1 "
"is named 'default', while it is left unnamed in v2. Default is 'service/v2'."
msgstr ""
"Il nome del generatore API da utilizzare. Ci sono 2 generatori: 'service/v1' "
"e 'service/v2'. L'unica differenza tra loro è che la porta di servizio in v1 "
"è denominata \"predefinita\", mentre viene lasciata unnamed in v2. Il valore "
"predefinito è 'service/v2'."

#: pkg/kubectl/cmd/run.go:136
msgid ""
"The name of the generator to use for creating a service.  Only used if --"
"expose is true"
msgstr ""
"Il nome del generatore da utilizzare per la creazione di un servizio. "
"Utilizzato solo se --expose è true"

#: pkg/kubectl/cmd/expose.go:100
msgid "The network protocol for the service to be created. Default is 'TCP'."
msgstr ""
"Il protocollo di rete per il servizio da creare. Il valore predefinito è "
"'TCP'."

#: pkg/kubectl/cmd/expose.go:101
msgid ""
"The port that the service should serve on. Copied from the resource being "
"exposed, if unspecified"
msgstr ""
"La porta che il servizio deve servire. Copiato dalla risorsa esposta, se non "
"specificata"

#: pkg/kubectl/cmd/run.go:124
msgid ""
"The port that this container exposes.  If --expose is true, this is also the "
"port used by the service that is created."
msgstr ""
"La porta che questo contenitore espone. Se --expose è true, questa è anche la "
"porta utilizzata dal servizio creato."

#: pkg/kubectl/cmd/run.go:134
msgid ""
"The resource requirement limits for this container.  For example, 'cpu=200m,"
"memory=512Mi'.  Note that server side components may assign limits depending "
"on the server configuration, such as limit ranges."
msgstr ""
"I limiti delle richieste di risorse per questo contenitore.  Ad esempio, "
"'cpu=200m,memory=512Mi'. Si noti che i componenti lato server possono "
"assegnare i limiti a seconda della configurazione del server, ad esempio "
"intervalli di limiti."

#: pkg/kubectl/cmd/run.go:133
msgid ""
"The resource requirement requests for this container.  For example, 'cpu=100m,"
"memory=256Mi'.  Note that server side components may assign requests "
"depending on the server configuration, such as limit ranges."
msgstr ""
"La risorsa necessita di richieste di requisiti per questo pod. Ad esempio, "
"'cpu = 100m, memoria = 256Mi'. Si noti che i componenti lato server possono "
"assegnare i requisiti a seconda della configurazione del server, ad esempio "
"intervalli di limiti."

#: pkg/kubectl/cmd/run.go:131
msgid ""
"The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  "
"If set to 'Always' a deployment is created, if set to 'OnFailure' a job is "
"created, if set to 'Never', a regular pod is created. For the latter two --"
"replicas must be 1.  Default 'Always', for CronJobs ` + "`" + `Never` + "`" + `."
msgstr ""
"La politica di riavvio per questo Pod. Valori accettati [Always, OnFailure, "
"Never]. Se impostato su 'Always' viene creato un deployment, se impostato su "
"'OnFailure' viene creato un job, se impostato su 'Never', viene creato un "
"pod. Per questi ultimi due le - repliche devono essere 1. Predefinito "
"'Always', per CronJobs ` + "`" + `Never` + "`" + `."

#: pkg/kubectl/cmd/create_secret.go:88
msgid "The type of secret to create"
msgstr "Tipo di segreto da creare"

#: pkg/kubectl/cmd/expose.go:102
msgid ""
"Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is "
"'ClusterIP'."
msgstr ""
"Digitare per questo servizio: ClusterIP, NodePort o LoadBalancer. "
"Ppredefinito è 'ClusterIP'."

#: pkg/kubectl/cmd/rollout/rollout_undo.go:72
msgid "Undo a previous rollout"
msgstr "Annulla un precedente rollout"

#: pkg/kubectl/cmd/config/unset.go:48
msgid "Unsets an individual value in a kubeconfig file"
msgstr "Annulla singolo valore in un file kubeconfig"

#: pkg/kubectl/cmd/patch.go:96
msgid "Update field(s) of a resource using strategic merge patch"
msgstr "Aggiornare campo/i risorsa utilizzando merge patch strategici"

#: pkg/kubectl/cmd/set/set_image.go:95
msgid "Update image of a pod template"
msgstr "Aggiorna immagine di un pod template"

#: pkg/kubectl/cmd/set/set_resources.go:102
msgid "Update resource requests/limits on objects with pod templates"
msgstr "Aggiorna richieste di risorse/limiti sugli oggetti con pod template"

#: pkg/kubectl/cmd/annotate.go:116
msgid "Update the annotations on a resource"
msgstr "Aggiorna